/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_yue_Hans extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "格林威治标准时间",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "艾克标准时间",
               "",
               "艾克夏令时间",
               "",
               "艾克时间",
               "",
            };
        final String[] Apia = new String[] {
               "阿皮亚标准时间",
               "",
               "阿皮亚夏令时间",
               "",
               "阿皮亚时间",
               "",
            };
        final String[] Cook = new String[] {
               "库克群岛标准时间",
               "",
               "库克群岛半夏令时间",
               "",
               "库克群岛时间",
               "",
            };
        final String[] Cuba = new String[] {
               "古巴标准时间",
               "CST",
               "古巴夏令时间",
               "CDT",
               "古巴时间",
               "CT",
            };
        final String[] Fiji = new String[] {
               "斐济标准时间",
               "",
               "斐济夏令时间",
               "",
               "斐济时间",
               "",
            };
        final String[] Gulf = new String[] {
               "波斯湾海域标准时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "科布多标准时间",
               "",
               "科布多夏令时间",
               "",
               "科布多时间",
               "",
            };
        final String[] Iran = new String[] {
               "伊朗标准时间",
               "",
               "伊朗夏令时间",
               "",
               "伊朗时间",
               "",
            };
        final String[] Niue = new String[] {
               "纽埃岛时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "鄂木斯克标准时间",
               "",
               "鄂木斯克夏令时间",
               "",
               "鄂木斯克时间",
               "",
            };
        final String[] Peru = new String[] {
               "秘鲁标准时间",
               "",
               "秘鲁夏令时间",
               "",
               "秘鲁时间",
               "",
            };
        final String[] Truk = new String[] {
               "楚克岛时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "威克岛时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "智利标准时间",
               "",
               "智利夏令时间",
               "",
               "智利时间",
               "",
            };
        final String[] China = new String[] {
               "中国标准时间",
               "CST",
               "中国夏令时间",
               "CDT",
               "中国时间",
               "CT",
            };
        final String[] Cocos = new String[] {
               "科科斯群岛时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "戴维斯时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "印度标准时间",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "日本标准时间",
               "JST",
               "日本夏令时间",
               "JDT",
               "日本时间",
               "JT",
            };
        final String[] Korea = new String[] {
               "韩国标准时间",
               "KST",
               "韩国夏令时间",
               "KST",
               "韩国时间",
               "KST",
            };
        final String[] Nauru = new String[] {
               "诺鲁时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "尼泊尔时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "帛琉时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "萨摩亚标准时间",
               "SST",
               "萨摩亚夏令时间",
               "SST",
               "萨摩亚时间",
               "SST",
            };
        final String[] Syowa = new String[] {
               "昭和基地时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "东加标准时间",
               "",
               "东加夏令时间",
               "",
               "东加时间",
               "",
            };
        final String[] Yukon = new String[] {
               "育空时间",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "阿拉斯加标准时间",
               "AKST",
               "阿拉斯加夏令时间",
               "AKDT",
               "阿拉斯加时间",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "亚马逊标准时间",
               "",
               "亚马逊夏令时间",
               "",
               "亚马逊时间",
               "",
            };
        final String[] Azores = new String[] {
               "亚速尔群岛标准时间",
               "",
               "亚速尔群岛夏令时间",
               "",
               "亚速尔群岛时间",
               "",
            };
        final String[] Bhutan = new String[] {
               "不丹时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "汶莱时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "复活节岛标准时间",
               "",
               "复活节岛夏令时间",
               "",
               "复活节岛时间",
               "",
            };
        final String[] Guyana = new String[] {
               "盖亚那时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "夏威夷-阿留申标准时间",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "以色列标准时间",
               "IST",
               "以色列夏令时间",
               "IDT",
               "以色列时间",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "科斯瑞时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "莫森时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "莫斯科标准时间",
               "MSK",
               "莫斯科夏令时间",
               "MSK",
               "莫斯科时间",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "波纳佩时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "萨马拉标准时间",
               "",
               "萨马拉夏令时间",
               "",
               "萨马拉时间",
               "",
            };
        final String[] Tahiti = new String[] {
               "大溪地时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "台北标准时间",
               "CST",
               "台北夏令时间",
               "CDT",
               "台北时间",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "吐瓦鲁时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "沃斯托克时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "瓦利斯和富图纳群岛时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "阿拉伯标准时间",
               "",
               "阿拉伯夏令时间",
               "",
               "阿拉伯时间",
               "",
            };
        final String[] Armenia = new String[] {
               "亚美尼亚标准时间",
               "",
               "亚美尼亚夏令时间",
               "",
               "亚美尼亚时间",
               "",
            };
        final String[] Bolivia = new String[] {
               "玻利维亚时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "查坦群岛标准时间",
               "",
               "查坦群岛夏令时间",
               "",
               "查坦群岛时间",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "协调世界时间",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "厄瓜多时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "甘比尔群岛时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "乔治亚标准时间",
               "",
               "乔治亚夏令时间",
               "",
               "乔治亚时间",
               "",
            };
        final String[] Irkutsk = new String[] {
               "伊尔库次克标准时间",
               "",
               "伊尔库次克夏令时间",
               "",
               "伊尔库次克时间",
               "",
            };
        final String[] Magadan = new String[] {
               "马加丹标准时间",
               "",
               "马加丹夏令时间",
               "",
               "马加丹时间",
               "",
            };
        final String[] Myanmar = new String[] {
               "缅甸时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "诺福克岛标准时间",
               "",
               "诺福克岛夏令时间",
               "",
               "诺福克岛时间",
               "",
            };
        final String[] Noronha = new String[] {
               "费尔南多 - 迪诺罗尼亚标准时间",
               "",
               "费尔南多 - 迪诺罗尼亚夏令时间",
               "",
               "费尔南多 - 迪诺罗尼亚时间",
               "",
            };
        final String[] Reunion = new String[] {
               "留尼旺时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "罗瑟拉时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "索罗门群岛时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "托克劳群岛时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "乌拉圭标准时间",
               "",
               "乌拉圭夏令时间",
               "",
               "乌拉圭时间",
               "",
            };
        final String[] Vanuatu = new String[] {
               "万那杜标准时间",
               "",
               "万那杜夏令时间",
               "",
               "万那杜时间",
               "",
            };
        final String[] Yakutsk = new String[] {
               "雅库次克标准时间",
               "",
               "雅库次克夏令时间",
               "",
               "雅库次克时间",
               "",
            };
        final String[] Atlantic = new String[] {
               "大西洋标准时间",
               "AST",
               "大西洋夏令时间",
               "AST",
               "大西洋时间",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "巴西利亚标准时间",
               "",
               "巴西利亚夏令时间",
               "",
               "巴西利亚时间",
               "",
            };
        final String[] Chamorro = new String[] {
               "查莫洛时间",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "哥伦比亚标准时间",
               "",
               "哥伦比亚夏令时间",
               "",
               "哥伦比亚时间",
               "",
            };
        final String[] Falkland = new String[] {
               "福克兰群岛标准时间",
               "",
               "福克兰群岛夏令时间",
               "",
               "福克兰群岛时间",
               "",
            };
        final String[] Malaysia = new String[] {
               "马来西亚时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "马尔地夫时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "乌兰巴托标准时间",
               "",
               "乌兰巴托夏令时间",
               "",
               "乌兰巴托时间",
               "",
            };
        final String[] Pakistan = new String[] {
               "巴基斯坦标准时间",
               "PKT",
               "巴基斯坦夏令时间",
               "PKST",
               "巴基斯坦时间",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "巴拉圭标准时间",
               "",
               "巴拉圭夏令时间",
               "",
               "巴拉圭时间",
               "",
            };
        final String[] Pitcairn = new String[] {
               "皮特肯时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "苏利南时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "阿根廷标准时间",
               "",
               "阿根廷夏令时间",
               "",
               "阿根廷时间",
               "",
            };
        final String[] Christmas = new String[] {
               "圣诞岛时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "加拉巴哥群岛时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "香港标准时间",
               "HKT",
               "香港夏令时间",
               "HKST",
               "香港时间",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "印度支那时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "彼得罗巴甫洛夫斯克标准时间",
               "",
               "彼得罗巴甫洛夫斯克日光节约时间",
               "",
               "彼得罗巴甫洛夫斯克时间",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "吉尔吉斯时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "豪勋爵岛标准时间",
               "",
               "豪勋爵岛夏令时间",
               "",
               "豪勋爵岛时间",
               "",
            };
        final String[] Marquesas = new String[] {
               "马可萨斯时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "模里西斯标准时间",
               "",
               "模里西斯夏令时间",
               "",
               "模里西斯时间",
               "",
            };
        final String[] Singapore = new String[] {
               "新加坡标准时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "委内瑞拉时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "亚塞拜然标准时间",
               "",
               "亚塞拜然夏令时间",
               "",
               "亚塞拜然时间",
               "",
            };
        final String[] Bangladesh = new String[] {
               "孟加拉标准时间",
               "",
               "孟加拉夏令时间",
               "",
               "孟加拉时间",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "维德角标准时间",
               "",
               "维德角夏令时间",
               "",
               "维德角时间",
               "",
            };
        final String[] East_Timor = new String[] {
               "东帝汶时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "哈萨克时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "塞席尔时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "塔吉克时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "乌兹别克标准时间",
               "",
               "乌兹别克夏令时间",
               "",
               "乌兹别克时间",
               "",
            };
        final String[] Afghanistan = new String[] {
               "阿富汗时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "克拉斯诺亚尔斯克标准时间",
               "",
               "克拉斯诺亚尔斯克夏令时间",
               "",
               "克拉斯诺亚尔斯克时间",
               "",
            };
        final String[] New_Zealand = new String[] {
               "纽西兰标准时间",
               "NZST",
               "纽西兰夏令时间",
               "NZDT",
               "纽西兰时间",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "菲律宾标准时间",
               "PST",
               "菲律宾夏令时间",
               "PDT",
               "菲律宾时间",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "海参崴标准时间",
               "",
               "海参崴夏令时间",
               "",
               "海参崴时间",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "印度洋时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "莱恩群岛时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "纽芬兰标准时间",
               "NST",
               "纽芬兰夏令时间",
               "NDT",
               "纽芬兰时间",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "土库曼标准时间",
               "",
               "土库曼夏令时间",
               "",
               "土库曼时间",
               "",
            };
        final String[] French_Guiana = new String[] {
               "法属圭亚那时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "新喀里多尼亚标准时间",
               "",
               "新喀里多尼亚群岛夏令时间",
               "",
               "新喀里多尼亚时间",
               "",
            };
        final String[] South_Georgia = new String[] {
               "南乔治亚时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "叶卡捷琳堡标准时间",
               "",
               "叶卡捷琳堡夏令时间",
               "",
               "叶卡捷琳堡时间",
               "",
            };
        final String[] Africa_Central = new String[] {
               "中非时间",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "东非时间",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "西非时间",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "杜蒙杜比尔时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "中欧标准时间",
               "CET",
               "中欧夏令时间",
               "CEST",
               "中欧时间",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "东欧标准时间",
               "EET",
               "东欧夏令时间",
               "EEST",
               "东欧时间",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "西欧标准时间",
               "WET",
               "西欧夏令时间",
               "WEST",
               "西欧时间",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "墨西哥太平洋标准时间",
               "MST",
               "墨西哥太平洋夏令时间",
               "MDT",
               "墨西哥太平洋时间",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "南非标准时间",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "中部标准时间",
               "CST",
               "中部夏令时间",
               "CDT",
               "中部时间",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "东部标准时间",
               "EST",
               "东部夏令时间",
               "EST",
               "东部时间",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "太平洋标准时间",
               "PST",
               "太平洋夏令时间",
               "PDT",
               "太平洋时间",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "法国南方及南极时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "吉尔伯特群岛时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "夏威夷-阿留申标准时间",
               "HST",
               "夏威夷-阿留申夏令时间",
               "HDT",
               "夏威夷-阿留申时间",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "凤凰群岛时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "圣皮埃尔和密克隆群岛标准时间",
               "",
               "圣皮埃尔和密克隆群岛夏令时间",
               "",
               "圣皮埃尔和密克隆群岛时间",
               "",
            };
        final String[] America_Mountain = new String[] {
               "山区标准时间",
               "MST",
               "山区夏令时间",
               "MST",
               "山区时间",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "马绍尔群岛时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "巴布亚纽几内亚时间",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "澳洲中部标准时间",
               "ACST",
               "澳洲中部夏令时间",
               "ACDT",
               "澳洲中部时间",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "澳洲东部标准时间",
               "AEST",
               "澳洲东部夏令时间",
               "AEDT",
               "澳洲东部时间",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "澳洲西部标准时间",
               "AWST",
               "澳洲西部夏令时间",
               "AWDT",
               "澳洲西部时间",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "印尼中部时间",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "印尼东部时间",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "印尼西部时间",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "澳洲中西部标准时间",
               "",
               "澳洲中西部夏令时间",
               "",
               "澳洲中西部时间",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "格林威治标准时间",
                    "GMT",
                    "英国夏令时间",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "协调世界时间",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "格林威治标准时间",
                    "GMT",
                    "爱尔兰标准时间",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "协调世界时间",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "协调世界时间",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "格林威治标准时间",
                    "GMT",
                    "英国夏令时间",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "协调世界时间",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "协调世界时间",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "协调世界时间",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "格林威治标准时间",
                    "GMT",
                    "爱尔兰标准时间",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "格林威治标准时间",
                    "GMT",
                    "英国夏令时间",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "格林威治标准时间",
                    "GMT",
                    "英国夏令时间",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "格林威治标准时间",
                    "GMT",
                    "英国夏令时间",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Saratov", Samara },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "格林威治标准时间",
                    "GMT",
                    "英国夏令时间",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Astrakhan", Samara },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Ulyanovsk", Samara },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "格林威治标准时间",
                    "GMT",
                    "英国夏令时间",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "亚丁" },
            { "timezone.excity.Asia/Baku", "巴库" },
            { "timezone.excity.Asia/Dili", "帝力" },
            { "timezone.excity.Asia/Gaza", "加萨" },
            { "timezone.excity.Asia/Hovd", "科布多" },
            { "timezone.excity.Asia/Omsk", "鄂木斯克" },
            { "timezone.excity.Asia/Oral", "乌拉尔" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "安曼" },
            { "timezone.excity.Asia/Aqtau", "阿克套" },
            { "timezone.excity.Asia/Chita", "赤塔" },
            { "timezone.excity.Asia/Dhaka", "达卡" },
            { "timezone.excity.Asia/Dubai", "杜拜" },
            { "timezone.excity.Asia/Kabul", "喀布尔" },
            { "timezone.excity.Asia/Macau", "中华人民共和国澳门特别行政区" },
            { "timezone.excity.Asia/Qatar", "卡达" },
            { "timezone.excity.Asia/Seoul", "首尔" },
            { "timezone.excity.Asia/Tokyo", "东京" },
            { "timezone.excity.Asia/Tomsk", "托木斯克" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "朱巴" },
            { "timezone.excity.Africa/Lome", "洛美" },
            { "timezone.excity.Asia/Almaty", "阿拉木图" },
            { "timezone.excity.Asia/Anadyr", "阿那底" },
            { "timezone.excity.Asia/Aqtobe", "阿克托比" },
            { "timezone.excity.Asia/Atyrau", "阿特劳" },
            { "timezone.excity.Asia/Beirut", "贝鲁特" },
            { "timezone.excity.Asia/Brunei", "汶莱" },
            { "timezone.excity.Asia/Hebron", "赫布隆" },
            { "timezone.excity.Asia/Kuwait", "科威特" },
            { "timezone.excity.Asia/Manila", "马尼拉" },
            { "timezone.excity.Asia/Muscat", "马斯开特" },
            { "timezone.excity.Asia/Riyadh", "利雅德" },
            { "timezone.excity.Asia/Saigon", "胡志明市" },
            { "timezone.excity.Asia/Taipei", "台北" },
            { "timezone.excity.Asia/Tehran", "德黑兰" },
            { "timezone.excity.Asia/Urumqi", "乌鲁木齐" },
            { "timezone.excity.Etc/Unknown", "未知城市" },
            { "timezone.excity.Europe/Kiev", "基辅" },
            { "timezone.excity.Europe/Oslo", "奥斯陆" },
            { "timezone.excity.Europe/Riga", "里加" },
            { "timezone.excity.Europe/Rome", "罗马" },
            { "timezone.excity.Indian/Mahe", "马埃岛" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "阿克拉" },
            { "timezone.excity.Africa/Cairo", "开罗" },
            { "timezone.excity.Africa/Ceuta", "休达" },
            { "timezone.excity.Africa/Dakar", "达喀尔" },
            { "timezone.excity.Africa/Lagos", "拉哥斯" },
            { "timezone.excity.Africa/Tunis", "突尼斯" },
            { "timezone.excity.America/Adak", "艾达克" },
            { "timezone.excity.America/Lima", "利马" },
            { "timezone.excity.America/Nome", "诺姆" },
            { "timezone.excity.Asia/Baghdad", "巴格达" },
            { "timezone.excity.Asia/Bahrain", "巴林" },
            { "timezone.excity.Asia/Bangkok", "曼谷" },
            { "timezone.excity.Asia/Barnaul", "巴尔瑙尔" },
            { "timezone.excity.Asia/Bishkek", "比什凯克" },
            { "timezone.excity.Asia/Colombo", "可伦坡" },
            { "timezone.excity.Asia/Irkutsk", "伊尔库次克" },
            { "timezone.excity.Asia/Jakarta", "雅加达" },
            { "timezone.excity.Asia/Karachi", "喀拉蚩" },
            { "timezone.excity.Asia/Kuching", "古晋" },
            { "timezone.excity.Asia/Magadan", "马加丹" },
            { "timezone.excity.Asia/Nicosia", "尼古西亚" },
            { "timezone.excity.Asia/Rangoon", "仰光" },
            { "timezone.excity.Asia/Tbilisi", "第比利斯" },
            { "timezone.excity.Asia/Thimphu", "廷布" },
            { "timezone.excity.Asia/Yakutsk", "雅库次克" },
            { "timezone.excity.Asia/Yerevan", "叶里温" },
            { "timezone.excity.Europe/Kirov", "基洛夫" },
            { "timezone.excity.Europe/Malta", "马尔他" },
            { "timezone.excity.Europe/Minsk", "明斯克" },
            { "timezone.excity.Europe/Paris", "巴黎" },
            { "timezone.excity.Europe/Sofia", "索菲亚" },
            { "timezone.excity.Europe/Vaduz", "瓦都兹" },
            { "timezone.excity.Indian/Cocos", "科科斯群岛" },
            { "timezone.excity.Pacific/Apia", "阿皮亚" },
            { "timezone.excity.Pacific/Fiji", "斐济" },
            { "timezone.excity.Pacific/Guam", "关岛" },
            { "timezone.excity.Pacific/Niue", "纽埃岛" },
            { "timezone.excity.Pacific/Truk", "楚克" },
            { "timezone.excity.Pacific/Wake", "威克" },
            { "timezone.excity.Africa/Asmera", "阿斯玛拉" },
            { "timezone.excity.Africa/Bamako", "巴马科" },
            { "timezone.excity.Africa/Bangui", "班吉" },
            { "timezone.excity.Africa/Banjul", "班竹" },
            { "timezone.excity.Africa/Bissau", "比绍" },
            { "timezone.excity.Africa/Douala", "杜阿拉" },
            { "timezone.excity.Africa/Harare", "哈拉雷" },
            { "timezone.excity.Africa/Kigali", "基加利" },
            { "timezone.excity.Africa/Luanda", "罗安达" },
            { "timezone.excity.Africa/Lusaka", "路沙卡" },
            { "timezone.excity.Africa/Malabo", "马拉博" },
            { "timezone.excity.Africa/Maputo", "马普托" },
            { "timezone.excity.Africa/Maseru", "马赛鲁" },
            { "timezone.excity.Africa/Niamey", "尼亚美" },
            { "timezone.excity.America/Aruba", "阿路巴" },
            { "timezone.excity.America/Bahia", "巴伊阿" },
            { "timezone.excity.America/Belem", "贝伦" },
            { "timezone.excity.America/Boise", "波夕" },
            { "timezone.excity.America/Jujuy", "胡胡伊" },
            { "timezone.excity.America/Sitka", "锡特卡" },
            { "timezone.excity.America/Thule", "杜里" },
            { "timezone.excity.Asia/Ashgabat", "阿什哈巴特" },
            { "timezone.excity.Asia/Calcutta", "加尔各答" },
            { "timezone.excity.Asia/Damascus", "大马士革" },
            { "timezone.excity.Asia/Dushanbe", "杜桑贝" },
            { "timezone.excity.Asia/Jayapura", "加亚布拉" },
            { "timezone.excity.Asia/Katmandu", "加德满都" },
            { "timezone.excity.Asia/Khandyga", "堪地加" },
            { "timezone.excity.Asia/Makassar", "马卡沙尔" },
            { "timezone.excity.Asia/Qostanay", "科斯塔奈" },
            { "timezone.excity.Asia/Sakhalin", "库页岛" },
            { "timezone.excity.Asia/Shanghai", "上海" },
            { "timezone.excity.Asia/Tashkent", "塔什干" },
            { "timezone.excity.Asia/Ust-Nera", "乌斯内拉" },
            { "timezone.excity.Europe/Athens", "雅典" },
            { "timezone.excity.Europe/Berlin", "柏林" },
            { "timezone.excity.Europe/Dublin", "都柏林" },
            { "timezone.excity.Europe/Jersey", "泽西岛" },
            { "timezone.excity.Europe/Lisbon", "里斯本" },
            { "timezone.excity.Europe/London", "伦敦" },
            { "timezone.excity.Europe/Madrid", "马德里" },
            { "timezone.excity.Europe/Monaco", "摩纳哥" },
            { "timezone.excity.Europe/Moscow", "莫斯科" },
            { "timezone.excity.Europe/Prague", "布拉格" },
            { "timezone.excity.Europe/Samara", "沙马拉" },
            { "timezone.excity.Europe/Skopje", "史高比耶" },
            { "timezone.excity.Europe/Tirane", "地拉那" },
            { "timezone.excity.Europe/Vienna", "维也纳" },
            { "timezone.excity.Europe/Warsaw", "华沙" },
            { "timezone.excity.Europe/Zagreb", "札格瑞布" },
            { "timezone.excity.Europe/Zurich", "苏黎世" },
            { "timezone.excity.Indian/Chagos", "查戈斯" },
            { "timezone.excity.Indian/Comoro", "科摩罗群岛" },
            { "timezone.excity.Pacific/Efate", "埃法特" },
            { "timezone.excity.Pacific/Nauru", "诺鲁" },
            { "timezone.excity.Pacific/Palau", "帛琉" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "阿比让" },
            { "timezone.excity.Africa/Algiers", "阿尔及尔" },
            { "timezone.excity.Africa/Conakry", "柯那克里" },
            { "timezone.excity.Africa/Kampala", "坎帕拉" },
            { "timezone.excity.Africa/Mbabane", "墨巴本" },
            { "timezone.excity.Africa/Nairobi", "奈洛比" },
            { "timezone.excity.Africa/Tripoli", "的黎波里" },
            { "timezone.excity.America/Belize", "贝里斯" },
            { "timezone.excity.America/Bogota", "波哥大" },
            { "timezone.excity.America/Cancun", "坎昆" },
            { "timezone.excity.America/Cayman", "开曼群岛" },
            { "timezone.excity.America/Cuiaba", "古雅巴" },
            { "timezone.excity.America/Dawson", "道森" },
            { "timezone.excity.America/Denver", "丹佛" },
            { "timezone.excity.America/Guyana", "盖亚那" },
            { "timezone.excity.America/Havana", "哈瓦那" },
            { "timezone.excity.America/Inuvik", "伊奴维克" },
            { "timezone.excity.America/Juneau", "朱诺" },
            { "timezone.excity.America/La_Paz", "拉巴斯" },
            { "timezone.excity.America/Maceio", "马瑟欧" },
            { "timezone.excity.America/Manaus", "玛瑙斯" },
            { "timezone.excity.America/Merida", "梅里达" },
            { "timezone.excity.America/Nassau", "拿索" },
            { "timezone.excity.America/Panama", "巴拿马" },
            { "timezone.excity.America/Recife", "雷西非" },
            { "timezone.excity.America/Regina", "里贾纳" },
            { "timezone.excity.Asia/Famagusta", "法马古斯塔" },
            { "timezone.excity.Asia/Hong_Kong", "中华人民共和国香港特别行政区" },
            { "timezone.excity.Asia/Jerusalem", "耶路撒冷" },
            { "timezone.excity.Asia/Kamchatka", "堪察加" },
            { "timezone.excity.Asia/Pontianak", "坤甸" },
            { "timezone.excity.Asia/Pyongyang", "平壤" },
            { "timezone.excity.Asia/Qyzylorda", "克孜勒奥尔达" },
            { "timezone.excity.Asia/Samarkand", "撒马尔罕" },
            { "timezone.excity.Asia/Singapore", "新加坡" },
            { "timezone.excity.Asia/Vientiane", "永珍" },
            { "timezone.excity.Europe/Andorra", "安道尔" },
            { "timezone.excity.Europe/Saratov", "萨拉托夫" },
            { "timezone.excity.Europe/Tallinn", "塔林" },
            { "timezone.excity.Europe/Vatican", "梵蒂冈" },
            { "timezone.excity.Europe/Vilnius", "维尔纽斯" },
            { "timezone.excity.Indian/Mayotte", "马约特岛" },
            { "timezone.excity.Indian/Reunion", "留尼旺岛" },
            { "timezone.excity.Pacific/Easter", "复活岛" },
            { "timezone.excity.Pacific/Kosrae", "科斯瑞" },
            { "timezone.excity.Pacific/Majuro", "马朱诺" },
            { "timezone.excity.Pacific/Midway", "中途岛" },
            { "timezone.excity.Pacific/Noumea", "诺美亚" },
            { "timezone.excity.Pacific/Ponape", "波纳佩" },
            { "timezone.excity.Pacific/Saipan", "塞班" },
            { "timezone.excity.Pacific/Tahiti", "大溪地" },
            { "timezone.excity.Pacific/Tarawa", "塔拉瓦" },
            { "timezone.excity.Pacific/Wallis", "瓦利斯" },
            { "timezone.excity.Africa/Blantyre", "布兰太尔" },
            { "timezone.excity.Africa/Djibouti", "吉布地" },
            { "timezone.excity.Africa/El_Aaiun", "阿尤恩" },
            { "timezone.excity.Africa/Freetown", "自由城" },
            { "timezone.excity.Africa/Gaborone", "嘉柏隆里" },
            { "timezone.excity.Africa/Khartoum", "喀土穆" },
            { "timezone.excity.Africa/Kinshasa", "金夏沙" },
            { "timezone.excity.Africa/Monrovia", "蒙罗维亚" },
            { "timezone.excity.Africa/Ndjamena", "恩贾梅纳" },
            { "timezone.excity.Africa/Sao_Tome", "圣多美" },
            { "timezone.excity.Africa/Windhoek", "温得和克" },
            { "timezone.excity.America/Antigua", "安地卡" },
            { "timezone.excity.America/Caracas", "卡拉卡斯" },
            { "timezone.excity.America/Cayenne", "开云" },
            { "timezone.excity.America/Chicago", "芝加哥" },
            { "timezone.excity.America/Cordoba", "哥多华" },
            { "timezone.excity.America/Creston", "克雷斯顿" },
            { "timezone.excity.America/Curacao", "库拉索" },
            { "timezone.excity.America/Detroit", "底特律" },
            { "timezone.excity.America/Godthab", "努克" },
            { "timezone.excity.America/Grenada", "格瑞纳达" },
            { "timezone.excity.America/Halifax", "哈里法克斯" },
            { "timezone.excity.America/Iqaluit", "伊魁特" },
            { "timezone.excity.America/Jamaica", "牙买加" },
            { "timezone.excity.America/Managua", "马拿瓜" },
            { "timezone.excity.America/Marigot", "马里戈特" },
            { "timezone.excity.America/Mendoza", "门多萨" },
            { "timezone.excity.America/Moncton", "蒙克顿" },
            { "timezone.excity.America/Noronha", "诺伦哈" },
            { "timezone.excity.America/Ojinaga", "奥希纳加" },
            { "timezone.excity.America/Phoenix", "凤凰城" },
            { "timezone.excity.America/Tijuana", "提华纳" },
            { "timezone.excity.America/Toronto", "多伦多" },
            { "timezone.excity.America/Tortola", "托尔托拉" },
            { "timezone.excity.America/Yakutat", "雅库塔" },
            { "timezone.excity.Asia/Phnom_Penh", "金边" },
            { "timezone.excity.Atlantic/Azores", "亚速尔群岛" },
            { "timezone.excity.Atlantic/Canary", "加纳利" },
            { "timezone.excity.Atlantic/Faeroe", "法罗群岛" },
            { "timezone.excity.Australia/Eucla", "尤克拉" },
            { "timezone.excity.Australia/Perth", "伯斯" },
            { "timezone.excity.Europe/Belgrade", "贝尔格勒" },
            { "timezone.excity.Europe/Brussels", "布鲁塞尔" },
            { "timezone.excity.Europe/Budapest", "布达佩斯" },
            { "timezone.excity.Europe/Busingen", "布辛根" },
            { "timezone.excity.Europe/Chisinau", "奇西瑙" },
            { "timezone.excity.Europe/Guernsey", "根息岛" },
            { "timezone.excity.Europe/Helsinki", "赫尔辛基" },
            { "timezone.excity.Europe/Istanbul", "伊斯坦堡" },
            { "timezone.excity.Europe/Sarajevo", "塞拉耶佛" },
            { "timezone.excity.Indian/Maldives", "马尔地夫" },
            { "timezone.excity.Pacific/Chatham", "查坦" },
            { "timezone.excity.Pacific/Fakaofo", "法考福" },
            { "timezone.excity.Pacific/Gambier", "甘比尔群岛" },
            { "timezone.excity.Pacific/Norfolk", "诺福克" },
            { "timezone.excity.Africa/Bujumbura", "布松布拉" },
            { "timezone.excity.Africa/Mogadishu", "摩加迪休" },
            { "timezone.excity.America/Anguilla", "安吉拉" },
            { "timezone.excity.America/Asuncion", "亚松森" },
            { "timezone.excity.America/Barbados", "巴贝多" },
            { "timezone.excity.America/Dominica", "多明尼加" },
            { "timezone.excity.America/Edmonton", "艾德蒙吞" },
            { "timezone.excity.America/Eirunepe", "艾鲁内佩" },
            { "timezone.excity.America/Mazatlan", "马萨特兰" },
            { "timezone.excity.America/Miquelon", "密启仑" },
            { "timezone.excity.America/New_York", "纽约" },
            { "timezone.excity.America/Resolute", "罗斯鲁特" },
            { "timezone.excity.America/Santarem", "圣塔伦" },
            { "timezone.excity.America/Santiago", "圣地牙哥" },
            { "timezone.excity.America/St_Johns", "圣约翰" },
            { "timezone.excity.America/St_Kitts", "圣基茨" },
            { "timezone.excity.America/St_Lucia", "圣露西亚" },
            { "timezone.excity.America/Winnipeg", "温尼伯" },
            { "timezone.excity.Antarctica/Casey", "凯西" },
            { "timezone.excity.Antarctica/Davis", "戴维斯" },
            { "timezone.excity.Antarctica/Syowa", "昭和基地" },
            { "timezone.excity.Antarctica/Troll", "绰尔" },
            { "timezone.excity.Asia/Krasnoyarsk", "克拉斯诺亚尔斯克" },
            { "timezone.excity.Asia/Novosibirsk", "新西伯利亚" },
            { "timezone.excity.Asia/Ulaanbaatar", "乌兰巴托" },
            { "timezone.excity.Asia/Vladivostok", "海参崴" },
            { "timezone.excity.Atlantic/Bermuda", "百慕达" },
            { "timezone.excity.Atlantic/Madeira", "马得拉群岛" },
            { "timezone.excity.Atlantic/Stanley", "史坦利" },
            { "timezone.excity.Australia/Darwin", "达尔文" },
            { "timezone.excity.Australia/Hobart", "荷巴特" },
            { "timezone.excity.Australia/Sydney", "雪梨" },
            { "timezone.excity.Europe/Amsterdam", "阿姆斯特丹" },
            { "timezone.excity.Europe/Astrakhan", "阿斯特拉罕" },
            { "timezone.excity.Europe/Bucharest", "布加勒斯特" },
            { "timezone.excity.Europe/Gibraltar", "直布罗陀" },
            { "timezone.excity.Europe/Ljubljana", "卢比安纳" },
            { "timezone.excity.Europe/Mariehamn", "玛丽港" },
            { "timezone.excity.Europe/Podgorica", "波多里察" },
            { "timezone.excity.Europe/Stockholm", "斯德哥尔摩" },
            { "timezone.excity.Europe/Ulyanovsk", "乌里扬诺夫斯克" },
            { "timezone.excity.Europe/Volgograd", "伏尔加格勒" },
            { "timezone.excity.Indian/Christmas", "圣诞岛" },
            { "timezone.excity.Indian/Kerguelen", "凯尔盖朗岛" },
            { "timezone.excity.Indian/Mauritius", "模里西斯" },
            { "timezone.excity.Pacific/Auckland", "奥克兰" },
            { "timezone.excity.Pacific/Funafuti", "富那富提" },
            { "timezone.excity.Pacific/Honolulu", "檀香山" },
            { "timezone.excity.Pacific/Pitcairn", "皮特肯群岛" },
            { "timezone.excity.Africa/Casablanca", "卡萨布兰卡" },
            { "timezone.excity.Africa/Libreville", "自由市" },
            { "timezone.excity.Africa/Lubumbashi", "卢本巴希" },
            { "timezone.excity.Africa/Nouakchott", "诺克少" },
            { "timezone.excity.Africa/Porto-Novo", "波多诺佛" },
            { "timezone.excity.America/Anchorage", "安克拉治" },
            { "timezone.excity.America/Araguaina", "阿拉圭那" },
            { "timezone.excity.America/Boa_Vista", "保维斯塔" },
            { "timezone.excity.America/Catamarca", "卡塔马卡" },
            { "timezone.excity.America/Chihuahua", "奇华华" },
            { "timezone.excity.America/Coyhaique", "科伊艾克" },
            { "timezone.excity.America/Fortaleza", "福塔力莎" },
            { "timezone.excity.America/Glace_Bay", "格雷斯贝" },
            { "timezone.excity.America/Goose_Bay", "鹅湾" },
            { "timezone.excity.America/Guatemala", "瓜地马拉" },
            { "timezone.excity.America/Guayaquil", "瓜亚基尔" },
            { "timezone.excity.America/Matamoros", "马塔莫罗斯" },
            { "timezone.excity.America/Menominee", "美诺米尼" },
            { "timezone.excity.America/Monterrey", "蒙特瑞" },
            { "timezone.excity.America/Sao_Paulo", "圣保罗" },
            { "timezone.excity.America/St_Thomas", "圣托马斯" },
            { "timezone.excity.America/Vancouver", "温哥华" },
            { "timezone.excity.Antarctica/Mawson", "莫森" },
            { "timezone.excity.Antarctica/Palmer", "帕麦" },
            { "timezone.excity.Antarctica/Vostok", "沃斯托克" },
            { "timezone.excity.Asia/Kuala_Lumpur", "吉隆坡" },
            { "timezone.excity.Asia/Novokuznetsk", "新库兹涅茨克" },
            { "timezone.excity.Europe/Bratislava", "布拉提斯拉瓦" },
            { "timezone.excity.Europe/Copenhagen", "哥本哈根" },
            { "timezone.excity.Europe/Luxembourg", "卢森堡" },
            { "timezone.excity.Europe/San_Marino", "圣马利诺" },
            { "timezone.excity.Europe/Simferopol", "辛非洛浦" },
            { "timezone.excity.Pacific/Enderbury", "坎顿" },
            { "timezone.excity.Pacific/Galapagos", "加拉巴哥群岛" },
            { "timezone.excity.Pacific/Kwajalein", "瓜加林岛" },
            { "timezone.excity.Pacific/Marquesas", "马可萨斯岛" },
            { "timezone.excity.Pacific/Pago_Pago", "巴哥巴哥" },
            { "timezone.excity.Pacific/Rarotonga", "拉罗汤加" },
            { "timezone.excity.Pacific/Tongatapu", "东加塔布岛" },
            { "timezone.excity.Africa/Addis_Ababa", "阿迪斯阿贝巴" },
            { "timezone.excity.Africa/Brazzaville", "布拉柴维尔" },
            { "timezone.excity.Africa/Ouagadougou", "瓦加杜古" },
            { "timezone.excity.America/Costa_Rica", "哥斯大黎加" },
            { "timezone.excity.America/Grand_Turk", "大特克岛" },
            { "timezone.excity.America/Guadeloupe", "瓜地洛普" },
            { "timezone.excity.America/Hermosillo", "埃莫西约" },
            { "timezone.excity.America/Kralendijk", "克拉伦代克" },
            { "timezone.excity.America/Louisville", "路易斯维尔" },
            { "timezone.excity.America/Martinique", "马丁尼克" },
            { "timezone.excity.America/Metlakatla", "梅特拉卡特拉" },
            { "timezone.excity.America/Montevideo", "蒙特维多" },
            { "timezone.excity.America/Montserrat", "蒙哲腊" },
            { "timezone.excity.America/Paramaribo", "巴拉马利波" },
            { "timezone.excity.America/Rio_Branco", "里约布兰" },
            { "timezone.excity.America/St_Vincent", "圣文森" },
            { "timezone.excity.America/Whitehorse", "怀特霍斯" },
            { "timezone.excity.Antarctica/McMurdo", "麦克默多" },
            { "timezone.excity.Antarctica/Rothera", "罗瑟拉" },
            { "timezone.excity.Asia/Srednekolymsk", "中科雷姆斯克" },
            { "timezone.excity.Asia/Yekaterinburg", "叶卡捷林堡" },
            { "timezone.excity.Atlantic/Reykjavik", "雷克雅维克" },
            { "timezone.excity.Atlantic/St_Helena", "圣赫勒拿岛" },
            { "timezone.excity.Australia/Adelaide", "阿得雷德" },
            { "timezone.excity.Australia/Brisbane", "布利斯班" },
            { "timezone.excity.Australia/Lindeman", "林德曼" },
            { "timezone.excity.Europe/Isle_of_Man", "曼岛" },
            { "timezone.excity.Europe/Kaliningrad", "加里宁格勒" },
            { "timezone.excity.Pacific/Kiritimati", "基里地马地岛" },
            { "timezone.excity.Africa/Johannesburg", "约翰尼斯堡" },
            { "timezone.excity.America/El_Salvador", "萨尔瓦多" },
            { "timezone.excity.America/Fort_Nelson", "纳尔逊堡" },
            { "timezone.excity.America/Los_Angeles", "洛杉矶" },
            { "timezone.excity.America/Mexico_City", "墨西哥市" },
            { "timezone.excity.America/Porto_Velho", "维留港" },
            { "timezone.excity.America/Puerto_Rico", "波多黎各" },
            { "timezone.excity.America/Tegucigalpa", "德古斯加巴" },
            { "timezone.excity.Arctic/Longyearbyen", "隆意耳拜恩" },
            { "timezone.excity.Atlantic/Cape_Verde", "维德角" },
            { "timezone.excity.Australia/Lord_Howe", "豪勋爵岛" },
            { "timezone.excity.Australia/Melbourne", "墨尔本" },
            { "timezone.excity.Indian/Antananarivo", "安塔那那利佛" },
            { "timezone.excity.Pacific/Guadalcanal", "瓜达康纳尔岛" },
            { "timezone.excity.Africa/Dar_es_Salaam", "沙兰港" },
            { "timezone.excity.America/Blanc-Sablon", "白朗萨布隆" },
            { "timezone.excity.America/Buenos_Aires", "布宜诺斯艾利斯" },
            { "timezone.excity.America/Campo_Grande", "格兰场" },
            { "timezone.excity.America/Danmarkshavn", "丹马沙文" },
            { "timezone.excity.America/Dawson_Creek", "道森克里克" },
            { "timezone.excity.America/Indiana/Knox", "印第安那州诺克斯" },
            { "timezone.excity.America/Indianapolis", "印第安那波里斯" },
            { "timezone.excity.America/Punta_Arenas", "蓬塔阿雷纳斯" },
            { "timezone.excity.America/Rankin_Inlet", "兰今湾" },
            { "timezone.excity.America/Scoresbysund", "伊托科尔托米特" },
            { "timezone.excity.Antarctica/Macquarie", "麦觉理" },
            { "timezone.excity.Pacific/Bougainville", "布干维尔" },
            { "timezone.excity.Pacific/Port_Moresby", "莫士比港" },
            { "timezone.excity.America/Cambridge_Bay", "剑桥湾" },
            { "timezone.excity.America/Ciudad_Juarez", "华雷斯城" },
            { "timezone.excity.America/Coral_Harbour", "阿蒂科肯" },
            { "timezone.excity.America/Indiana/Vevay", "印第安那州维威" },
            { "timezone.excity.America/Lower_Princes", "下太子区" },
            { "timezone.excity.America/Port_of_Spain", "西班牙港" },
            { "timezone.excity.America/Santo_Domingo", "圣多明哥" },
            { "timezone.excity.America/St_Barthelemy", "圣巴托洛缪岛" },
            { "timezone.excity.America/Swift_Current", "斯威夫特卡伦特" },
            { "timezone.excity.Australia/Broken_Hill", "布罗肯希尔" },
            { "timezone.excity.America/Bahia_Banderas", "巴伊亚班德拉斯" },
            { "timezone.excity.America/Port-au-Prince", "太子港" },
            { "timezone.excity.Atlantic/South_Georgia", "南乔治亚" },
            { "timezone.excity.America/Argentina/Salta", "萨尔塔" },
            { "timezone.excity.America/Indiana/Marengo", "印第安那州马伦哥" },
            { "timezone.excity.America/Indiana/Winamac", "印第安那州威纳马克" },
            { "timezone.excity.America/Argentina/Tucuman", "吐库曼" },
            { "timezone.excity.America/Argentina/Ushuaia", "乌斯怀亚" },
            { "timezone.excity.America/Indiana/Tell_City", "印第安那州泰尔城" },
            { "timezone.excity.America/Indiana/Vincennes", "印第安那州温森斯" },
            { "timezone.excity.Antarctica/DumontDUrville", "杜蒙杜比尔" },
            { "timezone.excity.America/Argentina/La_Rioja", "拉略哈" },
            { "timezone.excity.America/Argentina/San_Juan", "圣胡安" },
            { "timezone.excity.America/Argentina/San_Luis", "圣路易" },
            { "timezone.excity.America/Indiana/Petersburg", "印第安那州彼得堡" },
            { "timezone.excity.America/Kentucky/Monticello", "肯塔基州蒙地却罗" },
            { "timezone.excity.America/North_Dakota/Beulah", "北达科他州布由拉" },
            { "timezone.excity.America/North_Dakota/Center", "北达科他州中心" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "里奥加耶戈斯" },
            { "timezone.excity.America/North_Dakota/New_Salem", "北达科他州纽沙伦" },
        };
        return data;
    }
}
