enable_language(C)

cmake_policy(GET CMP0184 cmp0184)
if(cmp0184 STREQUAL "NEW")
  if(NOT CMAKE_MSVC_RUNTIME_CHECKS_DEFAULT)
    message(SEND_ERROR "CMAKE_MSVC_RUNTIME_CHECKS_DEFAULT not set under NEW behavior")
  endif()
else()
  if(CMAKE_MSVC_RUNTIME_CHECKS_DEFAULT)
    message(SEND_ERROR "CMAKE_MSVC_RUNTIME_CHECKS_DEFAULT is set under OLD behavior")
  endif()
endif()

if(cmp0184 STREQUAL "NEW")
  if(CMAKE_C_FLAGS_DEBUG MATCHES "[/-](RTC1|GZ)( |$)")
    message(SEND_ERROR "CMAKE_C_FLAGS_DEBUG has -RTC1 flag under NEW behavior:\n ${CMAKE_C_FLAGS_DEBUG}")
  endif()
else()
  if(NOT (CMAKE_C_FLAGS_DEBUG MATCHES "/(RTC1|GZ)( |$)"))
    message(SEND_ERROR "CMAKE_C_FLAGS_DEBUG does not have /RTC1 flag under OLD behavior:\n ${CMAKE_C_FLAGS_DEBUG}")
  endif()
endif()

set(CMAKE_MSVC_RUNTIME_CHECKS BogusValue)
add_library(foo empty.c)
