set(files foo.vcxproj bar.vcxproj baz.vcxproj)

foreach(file ${files})
  set(vsProjectFile ${RunCMake_TEST_BINARY_DIR}/${file})

  if(NOT EXISTS "${vsProjectFile}")
    set(RunCMake_TEST_FAILED "Project file ${vsProjectFile} does not exist.")
    return()
  endif()

  set(waldoFound FALSE)
  set(xyzzyFound FALSE)
  file(STRINGS "${vsProjectFile}" lines)
  foreach(line IN LISTS lines)
    if(line MATCHES "^ *<Import Project=.*/>$")
      if(line MATCHES "^.*waldo.targets.*$")
        set(waldoFound TRUE)
        message(STATUS "${file} is importing waldo.targets")
      elseif(line MATCHES "^.*xyzzy.targets.*$")
        set(xyzzyFound TRUE)
        message(STATUS "${file} is importing xyzzy.targets")
      endif()
    endif()
  endforeach()

  if("${file}" STREQUAL "foo.vcxproj")
    if(NOT xyzzyFound)
      set(RunCMake_TEST_FAILED "xyzzy.targets not imported from ${file}")
      return()
    endif()
    if(waldoFound)
      set(RunCMake_TEST_FAILED "waldo.targets imported from ${file}")
      return()
    endif()
  else()
    if(NOT xyzzyFound)
      set(RunCMake_TEST_FAILED "xyzzy.targets not imported from ${file}")
      return()
    endif()
    if(NOT waldoFound)
      set(RunCMake_TEST_FAILED "waldo.targets not imported from ${file}")
      return()
    endif()
  endif()
endforeach()
