/*
 * Decompiled with CFR 0.152.
 */
package jflex.skeleton;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import jflex.exceptions.GeneratorException;
import jflex.l10n.ErrorMessages;
import jflex.logging.Out;

public class Skeleton {
    private static final String DEFAULT_LOC = "jflex/skeleton.default";
    private static final int size = 21;
    public static String[] line;
    private int pos;
    private final PrintWriter out;

    public Skeleton(PrintWriter out) {
        this.out = out;
    }

    public void emitNext() {
        this.out.print(line[this.pos++]);
    }

    public static void makePrivate() {
        for (int i = 0; i < line.length; ++i) {
            Skeleton.line[i] = Skeleton.replace(" public ", " private ", line[i]);
        }
    }

    public static void readSkelFile(File skeletonFile) {
        if (skeletonFile == null) {
            throw new IllegalArgumentException("Skeleton file must not be null");
        }
        if (!skeletonFile.isFile() || !skeletonFile.canRead()) {
            Out.error(ErrorMessages.CANNOT_READ_SKEL, skeletonFile.toString());
            throw new GeneratorException();
        }
        Out.println(ErrorMessages.READING_SKEL, skeletonFile.toString());
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(skeletonFile.toString(), new String[0]), StandardCharsets.UTF_8);){
            Skeleton.readSkel(reader);
        }
        catch (IOException e) {
            Out.error(ErrorMessages.SKEL_IO_ERROR);
            throw new GeneratorException(e);
        }
    }

    public static void readSkel(BufferedReader reader) throws IOException {
        String ln;
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder section = new StringBuilder();
        while ((ln = reader.readLine()) != null) {
            if (ln.startsWith("---")) {
                lines.add(section.toString());
                section.setLength(0);
                continue;
            }
            section.append(ln);
            section.append(Out.NL);
        }
        if (section.length() > 0) {
            lines.add(section.toString());
        }
        if (lines.size() != 21) {
            Out.error(ErrorMessages.WRONG_SKELETON);
            throw new GeneratorException();
        }
        line = new String[21];
        for (int i = 0; i < 21; ++i) {
            Skeleton.line[i] = (String)lines.get(i);
        }
    }

    public static String replace(String a, String b, String c) {
        StringBuilder result = new StringBuilder(c.length());
        int i = 0;
        int j = c.indexOf(a);
        while (j >= i) {
            result.append(c.substring(i, j));
            result.append(b);
            i = j + a.length();
            j = c.indexOf(a, i);
        }
        result.append(c.substring(i, c.length()));
        return result.toString();
    }

    public static void readDefault() {
        ClassLoader l = Skeleton.class.getClassLoader();
        URL url = l != null ? l.getResource(DEFAULT_LOC) : ClassLoader.getSystemResource(DEFAULT_LOC);
        if (url == null) {
            Out.error(ErrorMessages.SKEL_IO_ERROR_DEFAULT);
            throw new GeneratorException();
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
            Skeleton.readSkel(reader);
        }
        catch (IOException e) {
            Out.error(ErrorMessages.SKEL_IO_ERROR_DEFAULT);
            throw new GeneratorException(e);
        }
    }

    static {
        Skeleton.readDefault();
    }
}

