from pathlib import Path

content = Path("zig-out/lib/core.c").read_text()
print("Size of core.c:", len(content.splitlines()))

valgrind_wrapper = Path("src/helpers/valgrind_wrapper.c").read_text()

STUB = Path("scripts/stub.c").read_text()

TEMPLATE = f"""\
// This file is generated by scripts/release.py
// Do not edit it manually.
#if defined(_WIN32) || defined(__APPLE__)
{STUB}
#else
{content}
#endif
{valgrind_wrapper}
"""

Path("dist/core.c").write_text(TEMPLATE)
