/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_lv extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "ar\u0101bu";
        final String metaValue_arc = "aramie\u0161u";
        final String metaValue_hy = "arm\u0113\u0146u";
        final String metaValue_ban = "balie\u0161u";
        final String metaValue_bn = "beng\u0101\u013cu";
        final String metaValue_ccp = "\u010dakmu";
        final String metaValue_cop = "koptu";
        final String metaValue_ka = "gruz\u012bnu";
        final String metaValue_got = "gotu";
        final String metaValue_el = "grie\u0137u";
        final String metaValue_gu = "gud\u017earatu";
        final String metaValue_pa = "pand\u017eabu";
        final String metaValue_he = "ivrits";
        final String metaValue_jv = "javie\u0161u";
        final String metaValue_ja = "jap\u0101\u0146u";
        final String metaValue_km = "khmeru";
        final String metaValue_kn = "kannadu";
        final String metaValue_ko = "korejie\u0161u";
        final String metaValue_lo = "laosie\u0161u";
        final String metaValue_la = "lat\u012b\u0146u";
        final String metaValue_ml = "malajalu";
        final String metaValue_mn = "mongo\u013cu";
        final String metaValue_my = "birmie\u0161u";
        final String metaValue_nqo = "nko";
        final String metaValue_or = "oriju";
        final String metaValue_phn = "feni\u0137ie\u0161u";
        final String metaValue_si = "sing\u0101\u013cu";
        final String metaValue_su = "zundu";
        final String metaValue_syr = "s\u012brie\u0161u";
        final String metaValue_ta = "tamilu";
        final String metaValue_te = "telugu";
        final String metaValue_tl = "tagalu";
        final String metaValue_th = "taju";
        final String metaValue_bo = "tibetie\u0161u";
        final String metaValue_vai = "vaju";
        final String metaValue_ssy = "saho";
        final Object[][] data = new Object[][] {
            { "001", "pasaule" },
            { "002", "\u0100frika" },
            { "003", "Zieme\u013camerika" },
            { "005", "Dienvidamerika" },
            { "009", "Oke\u0101nija" },
            { "011", "Rietum\u0101frika" },
            { "013", "Centr\u0101lamerika" },
            { "014", "Austrum\u0101frika" },
            { "015", "Zieme\u013c\u0101frika" },
            { "017", "Vidus\u0101frika" },
            { "018", "Dienvid\u0101frika" },
            { "019", "Amerika" },
            { "021", "Amerikas zieme\u013cu da\u013ca" },
            { "029", "Kar\u012bbu j\u016bras re\u0123ions" },
            { "030", "Austrum\u0101zija" },
            { "034", "Dienvid\u0101zija" },
            { "035", "Centr\u0101laustrum\u0101zija" },
            { "039", "Dienvideiropa" },
            { "053", "Austr\u0101l\u0101zija" },
            { "054", "Melan\u0113zija" },
            { "057", "Mikron\u0113zijas re\u0123ions" },
            { "061", "Polin\u0113zija" },
            { "142", "\u0100zija" },
            { "143", "Centr\u0101l\u0101zija" },
            { "145", "Rietum\u0101zija" },
            { "150", "Eiropa" },
            { "151", "Austrumeiropa" },
            { "154", "Zieme\u013ceiropa" },
            { "155", "Rietumeiropa" },
            { "202", "Subsah\u0101ras \u0100frika" },
            { "419", "Lat\u012b\u0146amerika" },
            { "AC", "Debesbrauk\u0161anas sala" },
            { "AD", "Andora" },
            { "AE", "Apvienotie Ar\u0101bu Emir\u0101ti" },
            { "AF", "Afganist\u0101na" },
            { "AG", "Antigva un Barbuda" },
            { "AI", "Angilja" },
            { "AL", "Alb\u0101nija" },
            { "AM", "Arm\u0113nija" },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "AR", "Argent\u012bna" },
            { "AS", "ASV Samoa" },
            { "AT", "Austrija" },
            { "AU", "Austr\u0101lija" },
            { "AW", "Aruba" },
            { "AX", "Olandes salas" },
            { "AZ", "Azerbaid\u017e\u0101na" },
            { "BA", "Bosnija un Hercegovina" },
            { "BB", "Barbadosa" },
            { "BD", "Banglade\u0161a" },
            { "BE", "Be\u013c\u0123ija" },
            { "BF", "Burkinafaso" },
            { "BG", "Bulg\u0101rija" },
            { "BH", "Bahreina" },
            { "BI", "Burundija" },
            { "BJ", "Benina" },
            { "BL", "Senbartelm\u012b" },
            { "BM", "Bermudu salas" },
            { "BN", "Bruneja" },
            { "BO", "Bol\u012bvija" },
            { "BQ", "N\u012bderlandes Kar\u012bbu salas" },
            { "BR", "Braz\u012blija" },
            { "BS", "Bahamu salas" },
            { "BT", "But\u0101na" },
            { "BV", "Buv\u0113 sala" },
            { "BW", "Botsv\u0101na" },
            { "BY", "Baltkrievija" },
            { "BZ", "Beliza" },
            { "CA", "Kan\u0101da" },
            { "CC", "Kokosu (K\u012blinga) salas" },
            { "CD", "Kongo (Kin\u0161asa)" },
            { "CF", "Centr\u0101l\u0101frikas Republika" },
            { "CG", "Kongo (Brazavila)" },
            { "CH", "\u0160veice" },
            { "CI", "Kotdivu\u0101ra" },
            { "CK", "Kuka salas" },
            { "CL", "\u010c\u012ble" },
            { "CM", "Kamer\u016bna" },
            { "CN", "\u0136\u012bna" },
            { "CO", "Kolumbija" },
            { "CP", "Klipertona sala" },
            { "CR", "Kostarika" },
            { "CU", "Kuba" },
            { "CV", "Kaboverde" },
            { "CW", "Kirasao" },
            { "CX", "Ziemsv\u0113tku sala" },
            { "CY", "Kipra" },
            { "CZ", "\u010cehija" },
            { "DE", "V\u0101cija" },
            { "DG", "Djego Garsijas atols" },
            { "DJ", "D\u017eibutija" },
            { "DK", "D\u0101nija" },
            { "DM", "Dominika" },
            { "DO", "Dominik\u0101na" },
            { "DZ", "Al\u017e\u012brija" },
            { "EA", "Se\u016bta un Melilja" },
            { "EC", "Ekvadora" },
            { "EE", "Igaunija" },
            { "EG", "\u0112\u0123ipte" },
            { "EH", "Rietumsah\u0101ra" },
            { "ER", "Eritreja" },
            { "ES", "Sp\u0101nija" },
            { "ET", "Etiopija" },
            { "EU", "Eiropas Savien\u012bba" },
            { "EZ", "Eirozona" },
            { "FI", "Somija" },
            { "FJ", "Fid\u017ei" },
            { "FK", "Folklenda salas" },
            { "FM", "Mikron\u0113zija" },
            { "FO", "F\u0113ru salas" },
            { "FR", "Francija" },
            { "GA", "Gabona" },
            { "GB", "Apvienot\u0101 Karaliste" },
            { "GD", "Gren\u0101da" },
            { "GE", "Gruzija" },
            { "GF", "Francijas Gvi\u0101na" },
            { "GG", "G\u0113rnsija" },
            { "GH", "Gana" },
            { "GI", "Gibralt\u0101rs" },
            { "GL", "Grenlande" },
            { "GM", "Gambija" },
            { "GN", "Gvineja" },
            { "GP", "Gvadelupa" },
            { "GQ", "Ekvatori\u0101l\u0101 Gvineja" },
            { "GR", "Grie\u0137ija" },
            { "GS", "Dienvidd\u017eord\u017eija un Dienvidsendvi\u010du salas" },
            { "GT", "Gvatemala" },
            { "GU", "Guama" },
            { "GW", "Gvineja-Bisava" },
            { "GY", "Gaj\u0101na" },
            { "HK", "\u0136\u012bnas \u012bpa\u0161\u0101s p\u0101rvaldes apgabals Honkonga" },
            { "HM", "H\u0113rda sala un Makdonalda salas" },
            { "HN", "Hondurasa" },
            { "HR", "Horv\u0101tija" },
            { "HT", "Haiti" },
            { "HU", "Ung\u0101rija" },
            { "IC", "Kan\u0101riju salas" },
            { "ID", "Indon\u0113zija" },
            { "IE", "\u012arija" },
            { "IL", "Izra\u0113la" },
            { "IM", "Menas sala" },
            { "IN", "Indija" },
            { "IO", "Indijas oke\u0101na Britu teritorija" },
            { "IQ", "Ir\u0101ka" },
            { "IR", "Ir\u0101na" },
            { "IS", "Islande" },
            { "IT", "It\u0101lija" },
            { "JE", "D\u017e\u0113rsija" },
            { "JM", "Jamaika" },
            { "JO", "Jord\u0101nija" },
            { "JP", "Jap\u0101na" },
            { "KE", "Kenija" },
            { "KG", "Kirgizst\u0101na" },
            { "KH", "Kambod\u017ea" },
            { "KI", "Kiribati" },
            { "KM", "Komoru salas" },
            { "KN", "Sentkitsa un Nevisa" },
            { "KP", "Zieme\u013ckoreja" },
            { "KR", "Dienvidkoreja" },
            { "KW", "Kuveita" },
            { "KY", "Kaimanu salas" },
            { "KZ", "Kazahst\u0101na" },
            { "LA", "Laosa" },
            { "LB", "Lib\u0101na" },
            { "LC", "Sentl\u016bsija" },
            { "LI", "Lihten\u0161teina" },
            { "LK", "\u0160rilanka" },
            { "LR", "Lib\u0113rija" },
            { "LS", "Lesoto" },
            { "LT", "Lietuva" },
            { "LU", "Luksemburga" },
            { "LV", "Latvija" },
            { "LY", "L\u012bbija" },
            { "MA", "Maroka" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Melnkalne" },
            { "MF", "Senmart\u0113na" },
            { "MG", "Madagaskara" },
            { "MH", "M\u0101r\u0161ala salas" },
            { "MK", "Zieme\u013cma\u0137edonija" },
            { "ML", "Mali" },
            { "MM", "Mjanma (Birma)" },
            { "MN", "Mongolija" },
            { "MO", "\u0136TR \u012bpa\u0161ais administrat\u012bvais re\u0123ions Makao" },
            { "MP", "Zieme\u013cu Marianas salas" },
            { "MQ", "Martinika" },
            { "MR", "Maurit\u0101nija" },
            { "MS", "Montserrata" },
            { "MT", "Malta" },
            { "MU", "Maur\u012bcija" },
            { "MV", "Mald\u012bvija" },
            { "MW", "Mal\u0101vija" },
            { "MX", "Meksika" },
            { "MY", "Malaizija" },
            { "MZ", "Mozambika" },
            { "NA", "Nam\u012bbija" },
            { "NC", "Jaunkaledonija" },
            { "NE", "Nig\u0113ra" },
            { "NF", "Norfolkas sala" },
            { "NG", "Nig\u0113rija" },
            { "NI", "Nikaragva" },
            { "NL", "N\u012bderlande" },
            { "NO", "Norv\u0113\u0123ija" },
            { "NP", "Nep\u0101la" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Jaunz\u0113lande" },
            { "OM", "Om\u0101na" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Francijas Polin\u0113zija" },
            { "PG", "Papua-Jaungvineja" },
            { "PH", "Filip\u012bnas" },
            { "PK", "Pakist\u0101na" },
            { "PL", "Polija" },
            { "PM", "Senpj\u0113ra un Mikelona" },
            { "PN", "Pitk\u0113rnas salas" },
            { "PR", "Puertoriko" },
            { "PS", "Palest\u012bnas teritorijas" },
            { "PT", "Portug\u0101le" },
            { "PW", "Palau" },
            { "PY", "Paragvaja" },
            { "QA", "Katara" },
            { "QO", "Oke\u0101nijas att\u0101l\u0101s salas" },
            { "RE", "Reinjona" },
            { "RO", "Rum\u0101nija" },
            { "RS", "Serbija" },
            { "RU", "Krievija" },
            { "RW", "Ruanda" },
            { "SA", "Sa\u016bda Ar\u0101bija" },
            { "SB", "Z\u0101lamana salas" },
            { "SC", "Sei\u0161elu salas" },
            { "SD", "Sud\u0101na" },
            { "SE", "Zviedrija" },
            { "SG", "Singap\u016bra" },
            { "SH", "Sv.Hel\u0113nas sala" },
            { "SI", "Slov\u0113nija" },
            { "SJ", "Svalb\u0101ra un Jana Majena sala" },
            { "SK", "Slov\u0101kija" },
            { "SL", "Sjerraleone" },
            { "SM", "Sanmar\u012bno" },
            { "SN", "Seneg\u0101la" },
            { "SO", "Som\u0101lija" },
            { "SR", "Surinama" },
            { "SS", "Dienvidsud\u0101na" },
            { "ST", "Santome un Prinsipi" },
            { "SV", "Salvadora" },
            { "SX", "Sintm\u0101rtena" },
            { "SY", "S\u012brija" },
            { "SZ", "Svatini" },
            { "TA", "Tristana da Ku\u0146jas salu teritorijas" },
            { "TC", "T\u0113rksas un Kaikosas salas" },
            { "TD", "\u010cada" },
            { "TF", "Francijas Dienvidj\u016bru teritorija" },
            { "TG", "Togo" },
            { "TH", "Taizeme" },
            { "TJ", "Tad\u017eikist\u0101na" },
            { "TK", "Tokelau" },
            { "TL", "Austrumtimora" },
            { "TM", "Turkmenist\u0101na" },
            { "TN", "Tunisija" },
            { "TO", "Tonga" },
            { "TR", "Turcija" },
            { "TT", "Trinid\u0101da un Tob\u0101go" },
            { "TV", "Tuvalu" },
            { "TW", "Taiv\u0101na" },
            { "TZ", "Tanz\u0101nija" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "ASV Maz\u0101s Aizj\u016bras salas" },
            { "UN", "Apvienoto N\u0101ciju Organiz\u0101cija" },
            { "US", "Amerikas Savienot\u0101s Valstis" },
            { "UY", "Urugvaja" },
            { "UZ", "Uzbekist\u0101na" },
            { "VA", "Vatik\u0101ns" },
            { "VC", "Sentvinsenta un Grenad\u012bnas" },
            { "VE", "Venecu\u0113la" },
            { "VG", "Britu Vird\u017e\u012bnas" },
            { "VI", "ASV Vird\u017e\u012bnas" },
            { "VN", "Vjetnama" },
            { "VU", "Vanuatu" },
            { "WF", "Volisa un Futunas salas" },
            { "WS", "Samoa" },
            { "XA", "pseidoakcenti" },
            { "XB", "pseidodivvirzienu" },
            { "XK", "Kosova" },
            { "YE", "Jemena" },
            { "YT", "Majota" },
            { "ZA", "Dienvid\u0101frikas Republika" },
            { "ZM", "Zambija" },
            { "ZW", "Zimbabve" },
            { "ZZ", "nezin\u0101ms re\u0123ions" },
            { "aa", "af\u0101ru" },
            { "ab", "abh\u0101zu" },
            { "ae", "avesta" },
            { "af", "afrikandu" },
            { "ak", "akanu" },
            { "am", "amharu" },
            { "an", "aragonie\u0161u" },
            { "ar", metaValue_ar },
            { "as", "asamie\u0161u" },
            { "av", "av\u0101ru" },
            { "ay", "aimaru" },
            { "az", "azerbaid\u017e\u0101\u0146u" },
            { "ba", "ba\u0161k\u012bru" },
            { "be", "baltkrievu" },
            { "bg", "bulg\u0101ru" },
            { "bi", "bi\u0161lam\u0101" },
            { "bm", "bambaru" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "breto\u0146u" },
            { "bs", "bosnie\u0161u" },
            { "ca", "katal\u0101\u0146u" },
            { "ce", "\u010de\u010denu" },
            { "ch", "\u010damorru" },
            { "co", "korsik\u0101\u0146u" },
            { "cr", "kr\u012b" },
            { "cs", "\u010dehu" },
            { "cu", "bazn\u012bcsl\u0101vu" },
            { "cv", "\u010duva\u0161u" },
            { "cy", "velsie\u0161u" },
            { "da", "d\u0101\u0146u" },
            { "de", "v\u0101cu" },
            { "dv", "mald\u012bvie\u0161u" },
            { "dz", "dzongke" },
            { "ee", "evu" },
            { "el", metaValue_el },
            { "en", "ang\u013cu" },
            { "eo", "esperanto" },
            { "es", "sp\u0101\u0146u" },
            { "et", "igau\u0146u" },
            { "eu", "basku" },
            { "fa", "persie\u0161u" },
            { "ff", "fulu" },
            { "fi", "somu" },
            { "fj", "fid\u017eie\u0161u" },
            { "fo", "f\u0113ru" },
            { "fr", "fran\u010du" },
            { "fy", "rietumfr\u012bzu" },
            { "ga", "\u012bru" },
            { "gd", "skotu g\u0113lu" },
            { "gl", "galisie\u0161u" },
            { "gn", "gvaranu" },
            { "gu", metaValue_gu },
            { "gv", "menie\u0161u" },
            { "ha", "hausu" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hirimotu" },
            { "hr", "horv\u0101tu" },
            { "ht", "haitie\u0161u" },
            { "hu", "ung\u0101ru" },
            { "hy", metaValue_hy },
            { "hz", "hereru" },
            { "ia", "interlingva" },
            { "id", "indon\u0113zie\u0161u" },
            { "ie", "interlingve" },
            { "ig", "igbo" },
            { "ii", "Si\u010dua\u0146as ji" },
            { "ik", "inupiaku" },
            { "io", "ido" },
            { "is", "islandie\u0161u" },
            { "it", "it\u0101\u013cu" },
            { "iu", "inu\u012btu" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "kongu" },
            { "ki", "kikuju" },
            { "kj", "kva\u0146amu" },
            { "kk", "kazahu" },
            { "kl", "grenlandie\u0161u" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuru" },
            { "ks", "ka\u0161mirie\u0161u" },
            { "ku", "kurdu" },
            { "kv", "komie\u0161u" },
            { "kw", "kornie\u0161u" },
            { "ky", "kirg\u012bzu" },
            { "la", metaValue_la },
            { "lb", "luksemburgie\u0161u" },
            { "lg", "gandu" },
            { "li", "limburgie\u0161u" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "lietuvie\u0161u" },
            { "lu", "lubakatanga" },
            { "lv", "latvie\u0161u" },
            { "mg", "malagasu" },
            { "mh", "m\u0101r\u0161alie\u0161u" },
            { "mi", "maoru" },
            { "mk", "ma\u0137edonie\u0161u" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathu" },
            { "ms", "malajie\u0161u" },
            { "mt", "maltie\u0161u" },
            { "my", metaValue_my },
            { "na", "nauruie\u0161u" },
            { "nb", "norv\u0113\u0123u bukmols" },
            { "nd", "zieme\u013cndebelu" },
            { "ne", "nep\u0101lie\u0161u" },
            { "ng", "ndongu" },
            { "nl", "holandie\u0161u" },
            { "nn", "jaunnorv\u0113\u0123u" },
            { "no", "norv\u0113\u0123u" },
            { "nr", "dienvidndebelu" },
            { "nv", "navahu" },
            { "ny", "\u010di\u010deva" },
            { "oc", "oksit\u0101\u0146u" },
            { "oj", "od\u017eibvu" },
            { "om", "oromu" },
            { "or", metaValue_or },
            { "os", "oset\u012bnu" },
            { "pa", metaValue_pa },
            { "pi", "p\u0101li" },
            { "pl", "po\u013cu" },
            { "ps", "pu\u0161tu" },
            { "pt", "portug\u0101\u013cu" },
            { "qu", "ke\u010dvu" },
            { "rm", "retorom\u0101\u0146u" },
            { "rn", "rundu" },
            { "ro", "rum\u0101\u0146u" },
            { "ru", "krievu" },
            { "rw", "ki\u0146aruanda" },
            { "sa", "sanskrits" },
            { "sc", "sard\u012bnie\u0161u" },
            { "sd", "sindhu" },
            { "se", "zieme\u013cs\u0101mu" },
            { "sg", "sango" },
            { "sh", "serbu\u2013horv\u0101tu" },
            { "si", metaValue_si },
            { "sk", "slov\u0101ku" },
            { "sl", "slov\u0113\u0146u" },
            { "sm", "samo\u0101\u0146u" },
            { "sn", "\u0161onu" },
            { "so", "som\u0101\u013cu" },
            { "sq", "alb\u0101\u0146u" },
            { "sr", "serbu" },
            { "ss", "svatu" },
            { "st", "dienvidsotu" },
            { "su", metaValue_su },
            { "sv", "zviedru" },
            { "sw", "svahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tad\u017eiku" },
            { "th", metaValue_th },
            { "ti", "tigrinja" },
            { "tk", "turkm\u0113\u0146u" },
            { "tl", metaValue_tl },
            { "tn", "cvanu" },
            { "to", "tongie\u0161u" },
            { "tr", "turku" },
            { "ts", "congu" },
            { "tt", "tat\u0101ru" },
            { "tw", "tv\u012b" },
            { "ty", "taitie\u0161u" },
            { "ug", "uiguru" },
            { "uk", "ukrai\u0146u" },
            { "ur", "urdu" },
            { "uz", "uzbeku" },
            { "ve", "vendu" },
            { "vi", "vjetnamie\u0161u" },
            { "vo", "volapiks" },
            { "wa", "valo\u0146u" },
            { "wo", "volofu" },
            { "xh", "khosu" },
            { "yi", "jidi\u0161s" },
            { "yo", "jorubu" },
            { "za", "d\u017euanu" },
            { "zh", "\u0137\u012bnie\u0161u" },
            { "zu", "zulu" },
            { "ace", "a\u010dinu" },
            { "ach", "a\u010dolu" },
            { "ada", "adangmu" },
            { "ady", "adigu" },
            { "afh", "afrihili" },
            { "agq", "aghemu" },
            { "ain", "ainu" },
            { "akk", "akadie\u0161u" },
            { "ale", "aleutu" },
            { "alt", "dienvidaltajie\u0161u" },
            { "ang", "senang\u013cu" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", metaValue_arc },
            { "arn", "arauk\u0101\u0146u" },
            { "arp", "arapahu" },
            { "ars", "\u0146ed\u017eu ar\u0101bu" },
            { "arw", "aravaku" },
            { "asa", "asu" },
            { "ast", "ast\u016brie\u0161u" },
            { "atj", "atikameku" },
            { "awa", "avadhu" },
            { "bal", "belud\u017eu" },
            { "ban", metaValue_ban },
            { "bas", "basu" },
            { "bax", "bamumu" },
            { "bbj", "gomalu" },
            { "bej", "bed\u017eu" },
            { "bem", "bembu" },
            { "bez", "bena" },
            { "bfd", "bafutu" },
            { "bgc", "harjanvi" },
            { "bgn", "rietumbelud\u017eu" },
            { "bho", "bhod\u017ep\u016bru" },
            { "bik", "bikolu" },
            { "bin", "binu" },
            { "bkm", "komu" },
            { "bla", "siksiku" },
            { "blo", "an\u012b" },
            { "bra", "brad\u017eie\u0161u" },
            { "brx", "bodo" },
            { "bss", "nkosi" },
            { "bua", "burjatu" },
            { "bug", "bugu" },
            { "bum", "bulu" },
            { "byn", "bilinu" },
            { "byv", "medumbu" },
            { "cad", "kadu" },
            { "car", "kar\u012bbu" },
            { "cay", "kajuga" },
            { "cch", "atsamu" },
            { "ccp", metaValue_ccp },
            { "ceb", "sebu\u0101\u0146u" },
            { "cgg", "kiga" },
            { "chb", "\u010dib\u010du" },
            { "chg", "d\u017eagatajs" },
            { "chk", "\u010d\u016bku" },
            { "chm", "marie\u0161u" },
            { "chn", "\u010dinuku \u017eargons" },
            { "cho", "\u010doktavu" },
            { "chp", "\u010dipevaianu" },
            { "chr", "\u010diroku" },
            { "chy", "\u0161ejenu" },
            { "ckb", "centr\u0101lkurdu" },
            { "clc", "\u010dilkot\u012bnu" },
            { "cop", metaValue_cop },
            { "crg", "mi\u010difu" },
            { "crh", "Krimas tat\u0101ru" },
            { "crj", "dienvidaustrumu kr\u012b" },
            { "crk", "l\u012bdzenumu kr\u012b" },
            { "crl", "zieme\u013caustrumu kr\u012b" },
            { "crm", "m\u016bsu kr\u012b" },
            { "crr", "Karol\u012bnas algonkinu" },
            { "crs", "francisk\u0101 kreolisk\u0101 valoda (Sei\u0161elu salas)" },
            { "csb", "ka\u0161ubu" },
            { "csw", "purvu kr\u012b" },
            { "dak", "dakotu" },
            { "dar", "dargu" },
            { "dav", "taitu" },
            { "del", "delav\u0113ru" },
            { "den", "sleivu" },
            { "dgr", "dogribu" },
            { "din", "dinku" },
            { "dje", "zarmu" },
            { "doi", "dogru" },
            { "dsb", "lejassorbu" },
            { "dua", "dualu" },
            { "dum", "vidusholandie\u0161u" },
            { "dyo", "diola-fonj\u012b" },
            { "dyu", "di\u016blu" },
            { "dzg", "dazu" },
            { "ebu", "kjembu" },
            { "efi", "efiku" },
            { "egy", "\u0113\u0123iptie\u0161u" },
            { "eka", "ekad\u017euku" },
            { "elx", "elamie\u0161u" },
            { "enm", "vidusang\u013cu" },
            { "ewo", "evondu" },
            { "fan", "fangu" },
            { "fat", "fantu" },
            { "fil", "filip\u012bnie\u0161u" },
            { "fon", "fonu" },
            { "frc", "kad\u017e\u016bnu fran\u010du" },
            { "frm", "vidusfran\u010du" },
            { "fro", "senfran\u010du" },
            { "frr", "zieme\u013cfr\u012bzu" },
            { "frs", "austrumfr\u012bzu" },
            { "fur", "fri\u016blu" },
            { "gaa", "ga" },
            { "gag", "gagauzu" },
            { "gay", "gajo" },
            { "gba", "gbaju" },
            { "gez", "g\u0113zu" },
            { "gil", "kiribatie\u0161u" },
            { "gmh", "vidusaug\u0161v\u0101cu" },
            { "goh", "senaug\u0161v\u0101cu" },
            { "gon", "gondu valodas" },
            { "gor", "gorontalu" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "sengrie\u0137u" },
            { "gsw", "\u0160veices v\u0101cu" },
            { "guz", "gusii" },
            { "gwi", "ku\u010dinu" },
            { "hai", "haidu" },
            { "haw", "havajie\u0161u" },
            { "hax", "dienvidhaidu" },
            { "hil", "hiligainonu" },
            { "hit", "hetu" },
            { "hmn", "hmongu" },
            { "hsb", "aug\u0161sorbu" },
            { "hup", "hupu" },
            { "hur", "halkomelenu" },
            { "iba", "ibanu" },
            { "ibb", "ibibio" },
            { "ikt", "Rietumkan\u0101das inu\u012btu" },
            { "ilo", "iloku" },
            { "inh", "ingu\u0161u" },
            { "jbo", "lo\u017ebans" },
            { "jgo", "ngomba" },
            { "jmc", "ma\u010damu" },
            { "jpr", "j\u016bdpersie\u0161u" },
            { "jrb", "j\u016bdar\u0101bu" },
            { "kaa", "karakalpaku" },
            { "kab", "kabilu" },
            { "kac", "ka\u010dinu" },
            { "kaj", "kad\u017ei" },
            { "kam", "kambu" },
            { "kaw", "k\u0101vi" },
            { "kbd", "kabardie\u0161u" },
            { "kbl", "ka\u0146embu" },
            { "kcg", "katabu" },
            { "kde", "makonde" },
            { "kea", "kaboverdie\u0161u" },
            { "kfo", "koru" },
            { "kgp", "kaingangs" },
            { "kha", "khasu" },
            { "kho", "hotanie\u0161u" },
            { "khq", "koira\u010diin\u012b" },
            { "kkj", "kako" },
            { "kln", "kalend\u017e\u012bnu" },
            { "kmb", "kimbundu" },
            { "koi", "komie\u0161u-permie\u0161u" },
            { "kok", "konkanu" },
            { "kos", "kosr\u0101jie\u0161u" },
            { "kpe", "kpellu" },
            { "krc", "kara\u010daju un balk\u0101ru" },
            { "krl", "kar\u0113\u013cu" },
            { "kru", "kuruhu" },
            { "ksb", "\u0161ambalu" },
            { "ksf", "bafiju" },
            { "ksh", "\u0136elnes v\u0101cu" },
            { "kum", "kumiku" },
            { "kut", "kutenaju" },
            { "kwk", "kvakvala" },
            { "kxv", "kuvi" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "landu" },
            { "lam", "lambu" },
            { "lez", "lezg\u012bnu" },
            { "lij", "lig\u016brie\u0161u" },
            { "lil", "lilluetu" },
            { "lkt", "lakotu" },
            { "lmo", "lombardie\u0161u" },
            { "lol", "mongu" },
            { "lou", "Luizi\u0101nas kreolu" },
            { "loz", "lozu" },
            { "lrc", "zieme\u013cluru" },
            { "lsm", "s\u0101mia" },
            { "lua", "lubalulva" },
            { "lui", "luisenu" },
            { "lun", "lundu" },
            { "lus", "lu\u0161eju" },
            { "luy", "luhju" },
            { "mad", "madurie\u0161u" },
            { "maf", "mafu" },
            { "mag", "magahie\u0161u" },
            { "mai", "maithili" },
            { "mak", "makasaru" },
            { "man", "mandingu" },
            { "mas", "masaju" },
            { "mde", "mabu" },
            { "mdf", "mok\u0161u" },
            { "mdr", "mandaru" },
            { "men", "mendu" },
            { "mer", "meru" },
            { "mfe", "Maur\u012bcijas kreolu" },
            { "mga", "vidus\u012bru" },
            { "mgh", "makua-m\u012bto" },
            { "mgo", "metu" },
            { "mic", "mikmaku" },
            { "min", "minangkabavu" },
            { "mnc", "mand\u017e\u016bru" },
            { "mni", "manip\u016bru" },
            { "moe", "motanju" },
            { "moh", "mohauku" },
            { "mos", "mosu" },
            { "mua", "mundangu" },
            { "mul", "vair\u0101kas valodas" },
            { "mus", "kr\u012bku" },
            { "mwl", "mirandie\u0161u" },
            { "mwr", "marvaru" },
            { "mye", "mjenu" },
            { "myv", "erzju" },
            { "mzn", "mazander\u0101\u0146u" },
            { "nap", "neapolie\u0161u" },
            { "naq", "nama" },
            { "nds", "lejasv\u0101cu" },
            { "new", "nevaru" },
            { "nia", "njasu" },
            { "niu", "niu\u0101\u0146u" },
            { "nmg", "kvasio" },
            { "nnh", "ngjemb\u016bnu" },
            { "nog", "nogaju" },
            { "non", "sennorv\u0113\u0123u" },
            { "nqo", metaValue_nqo },
            { "nso", "zieme\u013csotu" },
            { "nus", "nueru" },
            { "nwc", "klasisk\u0101 nevaru" },
            { "nym", "\u0146amvezu" },
            { "nyn", "\u0146ankolu" },
            { "nyo", "\u0146oru" },
            { "nzi", "nzemu" },
            { "ojb", "zieme\u013crietumu od\u017eibvu" },
            { "ojc", "centr\u0101l\u0101 od\u017eibvu" },
            { "ojs", "od\u017ei-kr\u012b" },
            { "ojw", "rietumod\u017eibvu" },
            { "oka", "okanaganu" },
            { "osa", "va\u017e\u0101\u017eu" },
            { "ota", "turku osma\u0146u" },
            { "pag", "pangasinanu" },
            { "pal", "pehlevi" },
            { "pam", "pampanganu" },
            { "pap", "papjamento" },
            { "pau", "palavie\u0161u" },
            { "pcm", "Nig\u0113rijas pid\u017einvaloda" },
            { "peo", "senpersu" },
            { "phn", metaValue_phn },
            { "pis", "pid\u017einvaloda" },
            { "pon", "ponapie\u0161u" },
            { "pqm", "malisetu-pasamakvodi" },
            { "prg", "pr\u016b\u0161u" },
            { "pro", "senprovansie\u0161u" },
            { "quc", "ki\u010de" },
            { "raj", "rad\u017east\u0101\u0146u" },
            { "rap", "rapanuju" },
            { "rar", "rarotongie\u0161u" },
            { "rhg", "rohind\u017eu" },
            { "rof", "rombo" },
            { "rom", "\u010dig\u0101nu" },
            { "rup", "arom\u016bnu" },
            { "rwk", "ruanda" },
            { "sad", "sandavu" },
            { "sah", "jakutu" },
            { "sam", "Sam\u0101rijas aramie\u0161u" },
            { "saq", "samburu" },
            { "sas", "sasaku" },
            { "sat", "santalu" },
            { "sba", "ngambeju" },
            { "sbp", "sangu" },
            { "scn", "sic\u012blie\u0161u" },
            { "sco", "skotu" },
            { "sdh", "dienvidkurdu" },
            { "see", "seneku" },
            { "seh", "senu" },
            { "sel", "selkupu" },
            { "ses", "koiraboro senni" },
            { "sga", "sen\u012bru" },
            { "shi", "\u0161ilhu" },
            { "shn", "\u0161anu" },
            { "shu", "\u010cadas ar\u0101bu" },
            { "sid", "sidamu" },
            { "slh", "dienvidlu\u0161uc\u012bdu" },
            { "sma", "dienvids\u0101mu" },
            { "smj", "Luleo s\u0101mu" },
            { "smn", "Inari s\u0101mu" },
            { "sms", "skolts\u0101mu" },
            { "snk", "soninku" },
            { "sog", "sogdie\u0161u" },
            { "srn", "sranantogo" },
            { "srr", "ser\u0113ru" },
            { "ssy", metaValue_ssy },
            { "str", "\u0161auruma sali\u0161u" },
            { "suk", "sukumu" },
            { "sus", "susu" },
            { "sux", "\u0161umeru" },
            { "swb", "komoru" },
            { "syc", "klasisk\u0101 s\u012brie\u0161u" },
            { "syr", metaValue_syr },
            { "szl", "sil\u0113zie\u0161u" },
            { "tce", "dienvidtut\u010donu" },
            { "tem", "temnu" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tetumu" },
            { "tgx", "tagi\u0161u" },
            { "tht", "tahltanu" },
            { "tig", "tigru" },
            { "tiv", "tivu" },
            { "tkl", "tokelavie\u0161u" },
            { "tlh", "klingo\u0146u" },
            { "tli", "tlinkitu" },
            { "tmh", "tuaregu" },
            { "tog", "Njasas tongu" },
            { "tok", "tokiponu" },
            { "tpi", "tokpisins" },
            { "trv", "taroko" },
            { "tsi", "cim\u0161i\u0101\u0146u" },
            { "ttm", "zieme\u013cu tu\u010donu" },
            { "tum", "tumbuku" },
            { "tvl", "tuvalie\u0161u" },
            { "twq", "tasavaku" },
            { "tyv", "tuvie\u0161u" },
            { "tzm", "Centr\u0101lmarokas tamaz\u012bts" },
            { "udm", "udmurtu" },
            { "uga", "ugaritie\u0161u" },
            { "umb", "umbundu" },
            { "und", "nezin\u0101ma valoda" },
            { "vai", metaValue_vai },
            { "vec", "ven\u0113cie\u0161u" },
            { "vmw", "makua" },
            { "vot", "votu" },
            { "vun", "vund\u017eo" },
            { "wae", "Vallisas v\u0101cu" },
            { "wal", "valamu" },
            { "war", "varaju" },
            { "was", "va\u0161o" },
            { "wbp", "varlpir\u012b" },
            { "wuu", "vu \u0137\u012bnie\u0161u" },
            { "xal", "kalmiku" },
            { "xnr", "kangri" },
            { "xog", "sogu" },
            { "yao", "jao" },
            { "yap", "japie\u0161u" },
            { "yav", "janba\u0146u" },
            { "ybb", "jembu" },
            { "yrl", "njengatu" },
            { "yue", "kantonie\u0161u" },
            { "zap", "sapoteku" },
            { "zbl", "blissimbolika" },
            { "zen", "zenagu" },
            { "zgh", "standarta tamazigtu (Maroka)" },
            { "zun", "zunju" },
            { "zxx", "bez lingvistiska satura" },
            { "zza", "zazaki" },
            { "Adlm", "adlama" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaliku" },
            { "Armi", metaValue_arc },
            { "Armn", metaValue_hy },
            { "Bali", metaValue_ban },
            { "Beng", metaValue_bn },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "Braila raksts" },
            { "Cakm", metaValue_ccp },
            { "Cans", "vienot\u0101 Kan\u0101das aborig\u0113nu zilbju rakst\u012bba" },
            { "Cher", "irok\u0113zu" },
            { "Copt", metaValue_cop },
            { "Cyrl", "kirilica" },
            { "Cyrs", "sensl\u0101vu" },
            { "Deva", "d\u0113van\u0101gari" },
            { "Egyd", "demotiskais raksts" },
            { "Egyh", "hier\u0101tiskais raksts" },
            { "Egyp", "\u0113\u0123iptie\u0161u hieroglifi" },
            { "Ethi", "etiopie\u0161u" },
            { "Geor", metaValue_ka },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", metaValue_pa },
            { "Hanb", "ha\u0146u ar bopomofo" },
            { "Hang", "hangils" },
            { "Hani", "ha\u0146u" },
            { "Hans", "vienk\u0101r\u0161ot\u0101" },
            { "Hant", "tradicion\u0101l\u0101" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hrkt", "jap\u0101\u0146u zilbju alfab\u0113ts" },
            { "Hung", "senung\u0101ru" },
            { "Ital", "vecit\u0101\u013cu" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kana", "katakana" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Lina", "line\u0101r\u0101 A" },
            { "Linb", "line\u0101r\u0101 B" },
            { "Lydi", "l\u012bdie\u0161u" },
            { "Maya", "maiju" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "M\u016bna raksts" },
            { "Mtei", "meitei-majeku" },
            { "Mymr", metaValue_my },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "ogamiskais raksts" },
            { "Olck", "ol\u010diki" },
            { "Orya", metaValue_or },
            { "Osma", "osma\u0146u turku" },
            { "Phnx", metaValue_phn },
            { "Rohg", "hanifi" },
            { "Roro", "rongorongo" },
            { "Runr", "r\u016bnu raksts" },
            { "Samr", "samarie\u0161u" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Syrc", metaValue_syr },
            { "Syrj", "rietums\u012brie\u0161u" },
            { "Syrn", "austrums\u012brie\u0161u" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "tifinagu" },
            { "Tglg", metaValue_tl },
            { "Thaa", "t\u0101na" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Vaii", metaValue_vai },
            { "Xpeo", "senperie\u0161u" },
            { "Xsux", "\u0161umeru-akadie\u0161u \u0137\u012b\u013craksts" },
            { "Yiii", "ji" },
            { "Zinh", "mantot\u0101" },
            { "Zmth", "matem\u0101tiskais pieraksts" },
            { "Zsye", "emocijz\u012bmes" },
            { "Zsym", "simboli" },
            { "Zxxx", "bez rakst\u012bbas" },
            { "Zyyy", "visp\u0101r\u0113j\u0101" },
            { "Zzzz", "nezin\u0101ma rakst\u012bba" },
            { "de_CH", "aug\u0161v\u0101cu (\u0160veice)" },
            { "en_GB", "ang\u013cu (Lielbrit\u0101nija)" },
            { "fa_AF", "dar\u012b" },
            { "nl_BE", "fl\u0101mu" },
            { "ro_MD", "mold\u0101vu" },
            { "sw_CD", "svahili (Kongo)" },
            { "%%1901", "tradicion\u0101l\u0101 v\u0101cu ortogr\u0101fija" },
            { "%%1996", "v\u0101cu ortogr\u0101fija no 1996. gada" },
            { "ar_001", "m\u016bsdienu standarta ar\u0101bu" },
            { "key.ca", "Kalend\u0101rs" },
            { "key.cf", "val\u016btas form\u0101ts" },
            { "key.co", "k\u0101rto\u0161anas sec\u012bba" },
            { "key.cu", "val\u016bta" },
            { "key.hc", "Stundu form\u0101ts (12 vai 24)" },
            { "key.lb", "Rindi\u0146as p\u0101rtraukuma stils" },
            { "key.ms", "m\u0113rvien\u012bbu sist\u0113ma" },
            { "key.nu", "Cipari" },
            { "key.tz", "laika josla" },
            { "key.va", "lokaliz\u0101cijas variants" },
            { "nds_NL", "lejassak\u0161u" },
            { "%%KKCOR", "tradicion\u0101l\u0101 ortogr\u0101fija" },
            { "%%NEDIS", "Natisona dialekts" },
            { "%%POSIX", "datoru" },
            { "%%SAAHO", metaValue_ssy },
            { "%%UCCOR", "vienot\u0101 ortogr\u0101fija" },
            { "az_Arab", "dienvidazerbaid\u017e\u0101\u0146u" },
            { "zh_Hans", "\u0137\u012bnie\u0161u vienk\u0101r\u0161ot\u0101" },
            { "zh_Hant", "\u0137\u012bnie\u0161u tradicion\u0101l\u0101" },
            { "%%FONIPA", "Starptautiskais fon\u0113tiskais alfab\u0113ts" },
            { "%%FONUPA", "UPA fon\u0113tika" },
            { "%%PINYIN", "pi\u0146ji\u0146a romaniz\u0101cija" },
            { "%%TARASK", "Tara\u0161kevi\u010da ortogr\u0101fija" },
            { "%%AREVELA", "austrumarm\u0113\u0146u" },
            { "%%AREVMDA", "rietumarm\u0113\u0146u" },
            { "%%MONOTON", "monotons" },
            { "%%POLYTON", "politons" },
            { "%%1959ACAD", "akad\u0113misk\u0101" },
            { "%%SCOTLAND", "Skotijas ang\u013cu" },
            { "%%VALENCIA", "valensie\u0161u" },
            { "%%WADEGILE", "Veida-D\u017eailza romaniz\u0101cija" },
            { "type.ca.roc", "\u0136\u012bnas Republikas kalend\u0101rs" },
            { "type.co.eor", "Eiropas rakst\u012bbu k\u0101rto\u0161anas sec\u012ba" },
            { "type.hc.h11", "12 stundu sist\u0113ma (0\u201311)" },
            { "type.hc.h12", "12 stundu sist\u0113ma (1\u201312)" },
            { "type.hc.h23", "24 stundu sist\u0113ma (0\u201323)" },
            { "type.hc.h24", "24 stundu sist\u0113ma (1\u201324)" },
            { "type.m0.bgn", "transliter\u0101cijas sist\u0113ma US BGN" },
            { "type.nu.arab", "Ar\u0101bu-indie\u0161u cipari" },
            { "type.nu.armn", "Arm\u0113\u0146u cipari" },
            { "type.nu.beng", "Beng\u0101\u013cu cipari" },
            { "type.nu.cakm", "\u010cakmas cipari" },
            { "type.nu.deva", "Devan\u0101gar\u012b cipari" },
            { "type.nu.ethi", "Etiopie\u0161u cipari" },
            { "type.nu.geor", "Gruz\u012bnu cipari" },
            { "type.nu.grek", "Grie\u0137u cipari" },
            { "type.nu.gujr", "Gud\u017earatu cipari" },
            { "type.nu.guru", "Gurmuki cipari" },
            { "type.nu.hans", "Vienk\u0101r\u0161otie \u0137\u012bnie\u0161u cipari" },
            { "type.nu.hant", "Tradicion\u0101lie \u0137\u012bnie\u0161u cipari" },
            { "type.nu.hebr", "Ivrita cipari" },
            { "type.nu.java", "Javas cipari" },
            { "type.nu.jpan", "Jap\u0101\u0146u cipari" },
            { "type.nu.khmr", "Khmeru cipari" },
            { "type.nu.knda", "Kannadu cipari" },
            { "type.nu.laoo", "Laosie\u0161u cipari" },
            { "type.nu.latn", "Ar\u0101bu cipari" },
            { "type.nu.mlym", "Malajalu cipari" },
            { "type.nu.mong", "Mongo\u013cu cipari" },
            { "type.nu.mtei", "M\u012btei majek cipari" },
            { "type.nu.mymr", "Birmie\u0161u cipari" },
            { "type.nu.olck", "Ol\u010diki cipari" },
            { "type.nu.orya", "Oriju cipari" },
            { "type.nu.taml", "Tamilu tradicion\u0101lie cipari" },
            { "type.nu.telu", "Telugu cipari" },
            { "type.nu.thai", "Tajie\u0161u cipari" },
            { "type.nu.tibt", "Tibetie\u0161u cipari" },
            { "type.nu.vaii", "VAI cipari" },
            { "type.ca.dangi", "dangi kalend\u0101rs" },
            { "type.co.ducet", "noklus\u0113juma unikoda k\u0101rto\u0161anas sec\u012bba" },
            { "type.lb.loose", "Br\u012bvais rindi\u0146as p\u0101rtraukuma stils" },
            { "type.nu.roman", "Romie\u0161u cipari" },
            { "type.ca.coptic", "Koptu kalend\u0101rs" },
            { "type.ca.hebrew", "ebreju kalend\u0101rs" },
            { "type.ca.indian", "Indijas nacion\u0101lais kalend\u0101rs" },
            { "type.co.compat", "sader\u012bg\u0101 k\u0101rto\u0161anas sec\u012bba" },
            { "type.co.pinyin", "pi\u0146ji\u0146a k\u0101rto\u0161anas sec\u012bba" },
            { "type.co.search", "visp\u0101r\u012bga mekl\u0113\u0161ana" },
            { "type.co.stroke", "Stroke k\u0101rto\u0161anas sec\u012bba" },
            { "type.co.unihan", "Radik\u0101l\u0101 k\u0101rto\u0161anas sec\u012bba p\u0113c vilkumu skaita" },
            { "type.d0.fwidth", "Pilna platuma" },
            { "type.d0.hwidth", "Pusplatuma" },
            { "type.lb.normal", "Parastais rindi\u0146as p\u0101rtraukuma stils" },
            { "type.lb.strict", "Stingrais rindi\u0146as p\u0101rtraukuma stils" },
            { "type.m0.ungegn", "transliter\u0101cijas sist\u0113ma UN GEGN" },
            { "type.ms.metric", "metrisk\u0101 sist\u0113ma" },
            { "type.nu.native", "Viet\u0113jie cipari" },
            { "type.ca.chinese", "\u0137\u012bnie\u0161u kalend\u0101rs" },
            { "type.ca.islamic", "Hid\u017er\u012b kalend\u0101rs" },
            { "type.ca.iso8601", "ISO 8601 kalend\u0101rs" },
            { "type.ca.persian", "persie\u0161u kalend\u0101rs" },
            { "type.cf.account", "uzskaites val\u016btas form\u0101ts" },
            { "type.co.big5han", "tradicion\u0101l\u0101s \u0137\u012bnie\u0161u valodas k\u0101rto\u0161anas sec\u012bba - Big5" },
            { "type.d0.npinyin", "Ciparu" },
            { "type.nu.arabext", "Izv\u0113rstie ar\u0101bu-indie\u0161u cipari" },
            { "type.nu.armnlow", "Mazie arm\u0113\u0146u cipari" },
            { "type.nu.finance", "Finan\u0161u cipari" },
            { "type.nu.greklow", "Mazie grie\u0137u cipari" },
            { "type.nu.hanidec", "\u0136\u012bnie\u0161u decim\u0101lda\u013cskait\u013ci" },
            { "type.nu.hansfin", "Vienk\u0101r\u0161otie \u0137\u012bnie\u0161u cipari finan\u0161u dokumentiem" },
            { "type.nu.hantfin", "Tradicion\u0101lie \u0137\u012bnie\u0161u cipari finan\u0161u dokumentiem" },
            { "type.nu.jpanfin", "Jap\u0101\u0146u cipari finan\u0161u dokumentiem" },
            { "type.nu.tamldec", "Tamilu cipari" },
            { "type.ca.buddhist", "budistu kalend\u0101rs" },
            { "type.ca.ethiopic", "etiopie\u0161u kalend\u0101rs" },
            { "type.ca.japanese", "jap\u0101\u0146u kalend\u0101rs" },
            { "type.cf.standard", "standarta val\u016btas form\u0101ts" },
            { "type.co.phonetic", "Fon\u0113tisk\u0101 k\u0101rto\u0161anas sec\u012bba" },
            { "type.co.searchjl", "Mekl\u0113t p\u0113c Hangul s\u0101kuma l\u012bdzska\u0146a" },
            { "type.co.standard", "standarta k\u0101rto\u0161anas sec\u012bba" },
            { "type.ms.uksystem", "britu m\u0113rvien\u012bbu sist\u0113ma" },
            { "type.ms.ussystem", "amerik\u0101\u0146u m\u0113rvien\u012bbu sist\u0113ma" },
            { "type.nu.fullwide", "Pilna platuma cipari" },
            { "type.nu.romanlow", "Mazie romie\u0161u cipari" },
            { "type.ca.gregorian", "Gregora kalend\u0101rs" },
            { "type.co.gb2312han", "vienk\u0101r\u0161ot\u0101s \u0137\u012bnie\u0161u valodas k\u0101rto\u0161anas sec\u012bba - GB2312" },
            { "type.co.phonebook", "t\u0101lru\u0146u gr\u0101matas k\u0101rto\u0161anas sec\u012bba" },
            { "type.co.dictionary", "V\u0101rdn\u012bcas k\u0101rto\u0161anas sec\u012bba" },
            { "type.co.traditional", "tradicion\u0101l\u0101 k\u0101rto\u0161anas sec\u012bba" },
            { "type.nu.traditional", "Tradicion\u0101l\u0101 ciparu sist\u0113ma" },
            { "type.ca.islamic-civil", "Hid\u017er\u012b kalend\u0101rs (pilso\u0146u)" },
            { "type.ca.islamic-umalqura", "Hid\u017er\u012b kalend\u0101rs (Umm al-kura)" },
            { "type.ca.ethiopic-amete-alem", "etiopie\u0161u Amete Alem kalend\u0101rs" },
        };
        return data;
    }
}
