## RabbitMQ 3.7.21

RabbitMQ `3.7.21` is a maintenance release that includes a patch for [CVE-2019-11287](https://pivotal.io/security/cve-2019-11287).
RabbitMQ `3.7.x` series is supported [through March 2020](https://www.rabbitmq.com/versions.html).

### Erlang/OTP Compatibility Notes

Per the new Erlang version support policy in effect starting with January 2019,
this release [**no longer supports Erlang/OTP 20.3**](https://groups.google.com/d/msg/rabbitmq-users/G4UJ9zbIYHs/qCeyjkjyCQAJ).
Make sure a [supported Erlang version](https://www.rabbitmq.com/which-erlang.html) is used before upgrading.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `21.3.x` and `22.x`.

### Compatibility Notes

#### Upgrading to Erlang 21.x or Later Versions

When upgrading to this release **and upgrading Erlang to 21.x or later** at the same time, extra care has to be taken.
Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21 or later,
RabbitMQ **must be upgraded before Erlang**.

#### Upgrade Doc Guides and Change Log

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade
and compatibility notes first if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades
and [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the
[RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes

### Core Server

#### Bug Fixes

 * Avoid pattern expansion when logging connection closure reason.

   This addresses [CVE-2019-11287](https://pivotal.io/security/cve-2019-11287).

   GitHub issue: [rabbitmq/rabbitmq-server#2155](https://github.com/rabbitmq/rabbitmq-server/pull/2155)


### LDAP Plugin

#### Enhancements

 * Errors were not propagated back to the client correctly in case of an LDAP server authentication failure.

   GitHub issue: [rabbitmq/rabbitmq-auth-backend-ldap#116](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/116)


### STOMP Plugin

#### Bug Fixes

 * `stomp.hide_server` is now available in the new style configuration format.

   GitHub issue: [rabbitmq/rabbitmq-stomp#140](https://github.com/rabbitmq/rabbitmq-stomp/issues/140)


### Web STOMP Plugin

#### Bug Fixes

 * The plugin emitted a warning on start.

   GitHub issue: [rabbitmq/rabbitmq-web-stomp#115](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/115)


### Web MQTT Plugin

#### Bug Fixes

 * The plugin emitted a warning on start.

   GitHub issue: [rabbitmq/rabbitmq-web-mqtt#59](https://github.com/rabbitmq/rabbitmq-web-mqtt/issues/59)


### Event Exchange Plugin

#### Bug Fixes

 * `event_exchange.vhost` is now available in the new style configuration format.

   GitHub issue: [rabbitmq/rabbitmq-event-exchange#43](https://github.com/rabbitmq/rabbitmq-event-exchange/issues/43)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-server-3.7.21.tar.xz`.
