## Launch Tayga within a container


# Enable Forwarding
echo "Enabling IPv4 and IPv6 forwarding"
echo 1 > /proc/sys/net/ipv4/conf/all/forwarding
echo 1 > /proc/sys/net/ipv6/conf/all/forwarding
echo 1 > /proc/sys/net/ipv6/conf/all/proxy_ndp

# Default environment variables
TAYGA_PREF64="${TAYGA_PREF64:-64:ff9b::/96}"
TAYGA_WKPF_STRICT="${TAYGA_WKPF_STRICT:-no}"
TAYGA_MTU="${TAYGA_MTU:-65535}"
TAYGA_LOG="${TAYGA_LOG:-drop reject icmp self dyn}"
#Default address for Tayga s in the DS-Lite range for CLAT use
TAYGA_ADDR4="${TAYGA_ADDR:-192.0.0.2}"
#Must specify ADDR6 for clat
WILLEXIT=""
if [ -z "$TAYGA_ADDR6" ]; then echo "TAYGA_ADDR6 must be set"; WILLEXIT="1"; fi
#Must specify MAP4 and MAP6
if [ -z "$TAYGA_MAP4" ]; then echo "TAYGA_MAP4 must be set"; WILLEXIT="1"; fi
if [ -z "$TAYGA_MAP6" ]; then echo "TAYGA_MAP6 must be set"; WILLEXIT="1"; fi

#Exit on validation error
if [ -n "$WILLEXIT" ]; then exit 1; fi

# Delete default v4 route if we have one
ip 4 route del default || true

# Generate tayga.conf file
cat << EOF > /app/tayga.conf.gen
# tayga.conf
# This file is generated by launch-nat64.sh

tun-device nat64
wkpf-strict ${TAYGA_WKPF_STRICT}
ipv4-addr ${TAYGA_ADDR4}
ipv6-addr ${TAYGA_ADDR6}
prefix ${TAYGA_PREF64}
log ${TAYGA_LOG}
map ${TAYGA_MAP4} ${TAYGA_MAP6}
EOF

# Make tunnel adapter
echo "Creating tunnel adapter"
/app/tayga -c /app/tayga.conf -d --mktun || exit 1

# Bring up the interface
echo "Bringing up the interface"
ip link set dev clat up
echo "Setting MTU to ${TAYGA_MTU}"
ip link set clat mtu ${TAYGA_MTU}
echo "Adding default route"
ip -4 route add default dev clat
echo "Adding IPv6 map route"
ip -6 route add ${TAYGA_MAP4} dev clat
if [ -n "$TAYGA_GW4" ]; then
    echo "Adding IPv4 map route"
    ip -4 route add ${TAYGA_MAP4} via ${TAYGA_GW4}
fi

# Start tayga
echo "Starting tayga"
# Use debug mode instead of syslog since containers log to stdout
/app/tayga -c /app/tayga.conf -d

# Delete tunnel adapter on exit
echo "Deleting tunnel adapter on exit"
ip link del clat