/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model.generic;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDialect;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerMetaModel;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.utils.CommonUtils;

public class SQLServerGenericDataSource
extends GenericDataSource {
    private static final Log log = Log.getLog(SQLServerGenericDataSource.class);
    private static final String PROP_ENCRYPT_PASS = "ENCRYPT_PASSWORD";
    private boolean hasMetaDataProcedureView = false;

    public SQLServerGenericDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        this(monitor, container, new SQLServerMetaModel(SQLServerUtils.isDriverSqlServer(container.getDriver())));
    }

    public SQLServerGenericDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, SQLServerMetaModel metaModel) throws DBException {
        super(monitor, container, (GenericMetaModel)metaModel, (SQLDialect)new SQLServerDialect());
    }

    protected Map<String, String> getInternalConnectionProperties(@NotNull DBRProgressMonitor monitor, @NotNull DBPDriver driver, @NotNull JDBCExecutionContext context, @NotNull String purpose, @NotNull DBPConnectionConfiguration connectionInfo) throws DBCException {
        HashMap<String, String> connectionsProps = new HashMap<String, String>();
        if (!this.getContainer().getPreferenceStore().getBoolean("database.meta.client.name.disable")) {
            connectionsProps.put(SQLServerUtils.isDriverJtds(driver) ? "APPNAME" : "applicationName", CommonUtils.truncateString((String)DBUtils.getClientApplicationName((DBPDataSourceContainer)this.getContainer(), (DBCExecutionContext)context, (String)purpose), (int)64));
        }
        if (CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("@dbeaver-encrypt-password@"))) {
            try {
                DBPPropertyDescriptor[] properties;
                DBPPropertyDescriptor[] dBPPropertyDescriptorArray = properties = driver.getDataSourceProvider().getConnectionProperties(monitor, driver, connectionInfo);
                int n = properties.length;
                int n2 = 0;
                while (n2 < n) {
                    DBPPropertyDescriptor descriptor = dBPPropertyDescriptorArray[n2];
                    if (descriptor.getId().equals(PROP_ENCRYPT_PASS) && descriptor instanceof PropertyDescriptor) {
                        connectionInfo.setProperty(PROP_ENCRYPT_PASS, "true");
                        ((JDBCDataSource)context.getDataSource()).getContainer().getConnectionConfiguration().setProperty(PROP_ENCRYPT_PASS, "true");
                        break;
                    }
                    ++n2;
                }
            }
            catch (DBException e) {
                log.error((Object)"Can't read driver properties", (Throwable)e);
            }
        }
        return connectionsProps;
    }

    public Object getDataSourceFeature(String featureId) {
        switch (featureId) {
            case "datasource.limit-affects-dml": {
                return true;
            }
            case "datasource.max-string-type-length": {
                return 8000;
            }
        }
        return super.getDataSourceFeature(featureId);
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int valueType) {
        block14: {
            if (valueType != 12) break block14;
            switch (typeName) {
                case "smalldatetime": 
                case "datetime2": 
                case "datetime": {
                    return DBPDataKind.DATETIME;
                }
                case "datetimeoffset": {
                    return DBPDataKind.DATETIME;
                }
            }
        }
        return super.resolveDataKind(typeName, valueType);
    }

    protected boolean isPopulateClientAppName() {
        return false;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Read server information");){
                JDBCUtils.executeStatement((Connection)session, (String)"SELECT TOP 1 1 FROM SYS.SYSPROCEDURE WHERE 1 <> 1");
                this.hasMetaDataProcedureView = true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            this.hasMetaDataProcedureView = false;
        }
    }

    public boolean hasMetaDataProcedureView() {
        return this.hasMetaDataProcedureView;
    }
}

