/*******************************************************************************************************
 DkSaveDialog.h
 Created on:	03.07.2013

 nomacs is a fast and small image viewer with the capability of synchronizing multiple instances

 Copyright (C) 2011-2013 Markus Diem <markus@nomacs.org>
 Copyright (C) 2011-2013 Stefan Fiel <stefan@nomacs.org>
 Copyright (C) 2011-2013 Florian Kleber <florian@nomacs.org>

 This file is part of nomacs.

 nomacs is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 nomacs is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.

 *******************************************************************************************************/

#pragma once

#include <QDialog>

#include "nmc_config.h"

class QRadioButton;
class QCheckBox;
class QLabel;
class QComboBox;

namespace nmc
{

// nomacs defines
class DkSlider;
class DkColorChooser;
class DkBaseViewPort;

class DllCoreExport DkTifDialog : public QDialog
{
    Q_OBJECT

public:
    explicit DkTifDialog(QWidget *parent = nullptr, Qt::WindowFlags flags = Qt::WindowFlags());

    int getCompression() const;

protected:
    void init();
    QRadioButton *noCompressionButton;
    QRadioButton *compressionButton;
    bool isOk;
};

class DllCoreExport DkCompressDialog : public QDialog
{
    Q_OBJECT

public:
    enum {
        jpg_dialog,
        j2k_dialog,
        webp_dialog,
        web_dialog,
        avif_dialog,
        jxl_dialog,

        dialog_end
    };

    explicit DkCompressDialog(QWidget *parent = nullptr, Qt::WindowFlags flags = Qt::WindowFlags());
    ~DkCompressDialog() override;

    void imageHasAlpha(bool hasAlpha);
    QColor getBackgroundColor() const;
    int getCompression();
    float getResizeFactor();
    void setImage(const QImage &img);
    void setDialogMode(int dialogMode);
    void accept() override;

public slots:
    void setVisible(bool visible) override;

protected slots:
    void newBgCol(const QColor &color);
    void losslessCompression(bool lossless);
    void changeSizeWeb(int);
    void drawPreview();
    void updateFileSizeLabel(float bufferSize = -1, QSize bufferImgSize = QSize(), float factor = -1);

protected:
    void init();
    void createLayout();
    void updateSnippets();
    void saveSettings();
    void loadSettings();
    void resizeEvent(QResizeEvent *ev) override;

    enum {
        best_quality = 0,
        high_quality,
        medium_quality,
        low_quality,
        bad_quality,

        end_quality
    };

    QVector<int> mImgQuality;
    QVector<int> mAvifImgQuality;

    int mDialogMode = jpg_dialog;
    bool mHasAlpha = false;
    QColor mBgCol = QColor(255, 255, 255);

    QCheckBox *mCbLossless = nullptr;
    // DkSlider* mSlider = 0;
    DkColorChooser *mColChooser = nullptr;
    QLabel *mPreviewLabel = nullptr;
    QLabel *mPreviewSizeLabel = nullptr;
    DkBaseViewPort *mOrigView = nullptr;
    QComboBox *mSizeCombo = nullptr;
    QComboBox *mCompressionCombo = nullptr;

    QImage mImg;
    QImage mNewImg;
};

}
