//! @file onedim.h

/**
 * @defgroup onedGroup One-Dimensional Reacting Flows
 *
 * @details These classes comprise %Cantera's ability to solve steady-state
 * one-dimensional reacting flow problems, such as laminar flames, opposed flow
 * diffusion flames, and stagnation flow chemical vapor deposition.
 */

#ifndef CT_INCL_ONEDIM_H
#define CT_INCL_ONEDIM_H

// Cantera core
#include "cantera/core.h"

#include "oneD/Sim1D.h"
#include "oneD/Domain1D.h"
#include "oneD/Boundary1D.h"
#include "oneD/Flow1D.h"
#include "oneD/refine.h"

#endif
