# This file is part of Cantera. See License.txt in the top-level directory or
# at https://cantera.org/license.txt for license and copyright information.

from pathlib import Path
from typing import Any

from ._types import Array, ArrayLike
from .units import Units, UnitStack, UnitSystem, _UnitDict

def add_directory(directory: Path | str) -> None: ...
def add_data_directory(directory: Path | str) -> None: ...
def get_data_directories() -> list[str]: ...

__sundials_version__: str
__version__: str
__git_commit__: str
_USE_SPARSE: bool

def debug_mode_enabled() -> bool: ...
def print_stack_trace_on_segfault() -> None: ...
def appdelete() -> None: ...
def use_sparse(sparse: bool = True) -> None: ...
def suppress_deprecation_warnings() -> None: ...
def make_deprecation_warnings_fatal() -> None: ...
def suppress_thermo_warnings(suppress: bool = True) -> None: ...
def use_legacy_rate_constants(legacy: bool) -> None: ...
def hdf_support() -> set[str]: ...

class CanteraError(RuntimeError):
    @staticmethod
    def set_stack_trace_depth(depth: int) -> None: ...

class AnyMap(dict[str, Any]):
    def default_units(self) -> _UnitDict: ...
    @property
    def units(self) -> UnitSystem: ...
    def convert(self, key: str, dest: str | Units) -> float | Array | list[float]: ...
    def convert_activation_energy(self, key: str, dest: str | Units) -> float: ...
    def convert_rate_coeff(self, key: str, dest: str | Units | UnitStack) -> float: ...
    def set_quantity(self, key: str, value: ArrayLike, src: str | Units) -> None: ...
    def set_activation_energy(
        self, key: str, value: float, src: str | Units
    ) -> None: ...
