// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/connectors/v1/connector_version.proto

package connectors

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum to control which fields should be included in the response.
type ConnectorVersionView int32

const (
	// CONNECTOR_VERSION_VIEW_UNSPECIFIED.
	ConnectorVersionView_CONNECTOR_VERSION_VIEW_UNSPECIFIED ConnectorVersionView = 0
	// Do not include role grant configs.
	ConnectorVersionView_CONNECTOR_VERSION_VIEW_BASIC ConnectorVersionView = 1
	// Include role grant configs.
	ConnectorVersionView_CONNECTOR_VERSION_VIEW_FULL ConnectorVersionView = 2
)

// Enum value maps for ConnectorVersionView.
var (
	ConnectorVersionView_name = map[int32]string{
		0: "CONNECTOR_VERSION_VIEW_UNSPECIFIED",
		1: "CONNECTOR_VERSION_VIEW_BASIC",
		2: "CONNECTOR_VERSION_VIEW_FULL",
	}
	ConnectorVersionView_value = map[string]int32{
		"CONNECTOR_VERSION_VIEW_UNSPECIFIED": 0,
		"CONNECTOR_VERSION_VIEW_BASIC":       1,
		"CONNECTOR_VERSION_VIEW_FULL":        2,
	}
)

func (x ConnectorVersionView) Enum() *ConnectorVersionView {
	p := new(ConnectorVersionView)
	*p = x
	return p
}

func (x ConnectorVersionView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConnectorVersionView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_connectors_v1_connector_version_proto_enumTypes[0].Descriptor()
}

func (ConnectorVersionView) Type() protoreflect.EnumType {
	return &file_google_cloud_connectors_v1_connector_version_proto_enumTypes[0]
}

func (x ConnectorVersionView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConnectorVersionView.Descriptor instead.
func (ConnectorVersionView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connector_version_proto_rawDescGZIP(), []int{0}
}

// Supported Source types for extraction.
type ExtractionRule_SourceType int32

const (
	// Default SOURCE.
	ExtractionRule_SOURCE_TYPE_UNSPECIFIED ExtractionRule_SourceType = 0
	// Config Variable source type.
	ExtractionRule_CONFIG_VARIABLE ExtractionRule_SourceType = 1
)

// Enum value maps for ExtractionRule_SourceType.
var (
	ExtractionRule_SourceType_name = map[int32]string{
		0: "SOURCE_TYPE_UNSPECIFIED",
		1: "CONFIG_VARIABLE",
	}
	ExtractionRule_SourceType_value = map[string]int32{
		"SOURCE_TYPE_UNSPECIFIED": 0,
		"CONFIG_VARIABLE":         1,
	}
)

func (x ExtractionRule_SourceType) Enum() *ExtractionRule_SourceType {
	p := new(ExtractionRule_SourceType)
	*p = x
	return p
}

func (x ExtractionRule_SourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExtractionRule_SourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_connectors_v1_connector_version_proto_enumTypes[1].Descriptor()
}

func (ExtractionRule_SourceType) Type() protoreflect.EnumType {
	return &file_google_cloud_connectors_v1_connector_version_proto_enumTypes[1]
}

func (x ExtractionRule_SourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExtractionRule_SourceType.Descriptor instead.
func (ExtractionRule_SourceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connector_version_proto_rawDescGZIP(), []int{7, 0}
}

// ConnectorVersion indicates a specific version of a connector.
type ConnectorVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of the Version.
	// Format:
	// projects/{project}/locations/{location}/providers/{provider}/connectors/{connector}/versions/{version}
	// Only global location is supported for Connector resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Created time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Updated time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Resource labels to represent user-provided metadata.
	// Refer to cloud documentation on labels for more details.
	// https://cloud.google.com/compute/docs/labeling-resources
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Flag to mark the version indicating the launch stage.
	LaunchStage LaunchStage `protobuf:"varint,6,opt,name=launch_stage,json=launchStage,proto3,enum=google.cloud.connectors.v1.LaunchStage" json:"launch_stage,omitempty"`
	// Output only. ReleaseVersion of the connector, for example: "1.0.1-alpha".
	ReleaseVersion string `protobuf:"bytes,7,opt,name=release_version,json=releaseVersion,proto3" json:"release_version,omitempty"`
	// Output only. List of auth configs supported by the Connector Version.
	AuthConfigTemplates []*AuthConfigTemplate `protobuf:"bytes,8,rep,name=auth_config_templates,json=authConfigTemplates,proto3" json:"auth_config_templates,omitempty"`
	// Output only. List of config variables needed to create a connection.
	ConfigVariableTemplates []*ConfigVariableTemplate `protobuf:"bytes,9,rep,name=config_variable_templates,json=configVariableTemplates,proto3" json:"config_variable_templates,omitempty"`
	// Output only. Information about the runtime features supported by the Connector.
	SupportedRuntimeFeatures *SupportedRuntimeFeatures `protobuf:"bytes,10,opt,name=supported_runtime_features,json=supportedRuntimeFeatures,proto3" json:"supported_runtime_features,omitempty"`
	// Output only. Display name.
	DisplayName string `protobuf:"bytes,11,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Configuration for Egress Control.
	EgressControlConfig *EgressControlConfig `protobuf:"bytes,12,opt,name=egress_control_config,json=egressControlConfig,proto3" json:"egress_control_config,omitempty"`
	// Output only. Role grant configurations for this connector version.
	RoleGrants []*RoleGrant `protobuf:"bytes,14,rep,name=role_grants,json=roleGrants,proto3" json:"role_grants,omitempty"`
	// Output only. Role grant configuration for this config variable. It will be DEPRECATED
	// soon.
	RoleGrant *RoleGrant `protobuf:"bytes,15,opt,name=role_grant,json=roleGrant,proto3" json:"role_grant,omitempty"`
}

func (x *ConnectorVersion) Reset() {
	*x = ConnectorVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connector_version_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectorVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectorVersion) ProtoMessage() {}

func (x *ConnectorVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connector_version_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectorVersion.ProtoReflect.Descriptor instead.
func (*ConnectorVersion) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connector_version_proto_rawDescGZIP(), []int{0}
}

func (x *ConnectorVersion) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConnectorVersion) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ConnectorVersion) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ConnectorVersion) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ConnectorVersion) GetLaunchStage() LaunchStage {
	if x != nil {
		return x.LaunchStage
	}
	return LaunchStage_LAUNCH_STAGE_UNSPECIFIED
}

func (x *ConnectorVersion) GetReleaseVersion() string {
	if x != nil {
		return x.ReleaseVersion
	}
	return ""
}

func (x *ConnectorVersion) GetAuthConfigTemplates() []*AuthConfigTemplate {
	if x != nil {
		return x.AuthConfigTemplates
	}
	return nil
}

func (x *ConnectorVersion) GetConfigVariableTemplates() []*ConfigVariableTemplate {
	if x != nil {
		return x.ConfigVariableTemplates
	}
	return nil
}

func (x *ConnectorVersion) GetSupportedRuntimeFeatures() *SupportedRuntimeFeatures {
	if x != nil {
		return x.SupportedRuntimeFeatures
	}
	return nil
}

func (x *ConnectorVersion) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ConnectorVersion) GetEgressControlConfig() *EgressControlConfig {
	if x != nil {
		return x.EgressControlConfig
	}
	return nil
}

func (x *ConnectorVersion) GetRoleGrants() []*RoleGrant {
	if x != nil {
		return x.RoleGrants
	}
	return nil
}

func (x *ConnectorVersion) GetRoleGrant() *RoleGrant {
	if x != nil {
		return x.RoleGrant
	}
	return nil
}

// Request message for Connectors.GetConnectorVersion.
type GetConnectorVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the form:
	// `projects/*/locations/*/providers/*/connectors/*/versions/*`
	// Only global location is supported for ConnectorVersion resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Specifies which fields of the ConnectorVersion are returned in the
	// response. Defaults to `CUSTOMER` view.
	View ConnectorVersionView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.connectors.v1.ConnectorVersionView" json:"view,omitempty"`
}

func (x *GetConnectorVersionRequest) Reset() {
	*x = GetConnectorVersionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connector_version_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConnectorVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConnectorVersionRequest) ProtoMessage() {}

func (x *GetConnectorVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connector_version_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConnectorVersionRequest.ProtoReflect.Descriptor instead.
func (*GetConnectorVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connector_version_proto_rawDescGZIP(), []int{1}
}

func (x *GetConnectorVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetConnectorVersionRequest) GetView() ConnectorVersionView {
	if x != nil {
		return x.View
	}
	return ConnectorVersionView_CONNECTOR_VERSION_VIEW_UNSPECIFIED
}

// Request message for Connectors.ListConnectorVersions.
type ListConnectorVersionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource of the connectors, of the form:
	// `projects/*/locations/*/providers/*/connectors/*`
	// Only global location is supported for ConnectorVersion resource.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Specifies which fields of the ConnectorVersion are returned in the
	// response. Defaults to `BASIC` view.
	View ConnectorVersionView `protobuf:"varint,4,opt,name=view,proto3,enum=google.cloud.connectors.v1.ConnectorVersionView" json:"view,omitempty"`
}

func (x *ListConnectorVersionsRequest) Reset() {
	*x = ListConnectorVersionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connector_version_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConnectorVersionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConnectorVersionsRequest) ProtoMessage() {}

func (x *ListConnectorVersionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connector_version_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConnectorVersionsRequest.ProtoReflect.Descriptor instead.
func (*ListConnectorVersionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connector_version_proto_rawDescGZIP(), []int{2}
}

func (x *ListConnectorVersionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConnectorVersionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConnectorVersionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListConnectorVersionsRequest) GetView() ConnectorVersionView {
	if x != nil {
		return x.View
	}
	return ConnectorVersionView_CONNECTOR_VERSION_VIEW_UNSPECIFIED
}

// Response message for Connectors.ListConnectorVersions.
type ListConnectorVersionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of connector versions.
	ConnectorVersions []*ConnectorVersion `protobuf:"bytes,1,rep,name=connector_versions,json=connectorVersions,proto3" json:"connector_versions,omitempty"`
	// Next page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListConnectorVersionsResponse) Reset() {
	*x = ListConnectorVersionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connector_version_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConnectorVersionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConnectorVersionsResponse) ProtoMessage() {}

func (x *ListConnectorVersionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connector_version_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConnectorVersionsResponse.ProtoReflect.Descriptor instead.
func (*ListConnectorVersionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connector_version_proto_rawDescGZIP(), []int{3}
}

func (x *ListConnectorVersionsResponse) GetConnectorVersions() []*ConnectorVersion {
	if x != nil {
		return x.ConnectorVersions
	}
	return nil
}

func (x *ListConnectorVersionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListConnectorVersionsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Supported runtime features of a connector version. This is passed to the
// management layer to add a new connector version by the connector developer.
// Details about how this proto is passed to the management layer is covered in
// this doc - go/runtime-manifest.
type SupportedRuntimeFeatures struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies if the connector supports entity apis like 'createEntity'.
	EntityApis bool `protobuf:"varint,1,opt,name=entity_apis,json=entityApis,proto3" json:"entity_apis,omitempty"`
	// Specifies if the connector supports action apis like 'executeAction'.
	ActionApis bool `protobuf:"varint,2,opt,name=action_apis,json=actionApis,proto3" json:"action_apis,omitempty"`
	// Specifies if the connector supports 'ExecuteSqlQuery' operation.
	SqlQuery bool `protobuf:"varint,3,opt,name=sql_query,json=sqlQuery,proto3" json:"sql_query,omitempty"`
}

func (x *SupportedRuntimeFeatures) Reset() {
	*x = SupportedRuntimeFeatures{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connector_version_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SupportedRuntimeFeatures) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupportedRuntimeFeatures) ProtoMessage() {}

func (x *SupportedRuntimeFeatures) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connector_version_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupportedRuntimeFeatures.ProtoReflect.Descriptor instead.
func (*SupportedRuntimeFeatures) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connector_version_proto_rawDescGZIP(), []int{4}
}

func (x *SupportedRuntimeFeatures) GetEntityApis() bool {
	if x != nil {
		return x.EntityApis
	}
	return false
}

func (x *SupportedRuntimeFeatures) GetActionApis() bool {
	if x != nil {
		return x.ActionApis
	}
	return false
}

func (x *SupportedRuntimeFeatures) GetSqlQuery() bool {
	if x != nil {
		return x.SqlQuery
	}
	return false
}

// Egress control config for connector runtime. These configurations define the
// rules to identify which outbound domains/hosts needs to be whitelisted. It
// may be a static information for a particular connector version or it is
// derived from the configurations provided by the customer in Connection
// resource.
type EgressControlConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to OneofBackends:
	//
	//	*EgressControlConfig_Backends
	//	*EgressControlConfig_ExtractionRules
	OneofBackends isEgressControlConfig_OneofBackends `protobuf_oneof:"oneof_backends"`
}

func (x *EgressControlConfig) Reset() {
	*x = EgressControlConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connector_version_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EgressControlConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EgressControlConfig) ProtoMessage() {}

func (x *EgressControlConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connector_version_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EgressControlConfig.ProtoReflect.Descriptor instead.
func (*EgressControlConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connector_version_proto_rawDescGZIP(), []int{5}
}

func (m *EgressControlConfig) GetOneofBackends() isEgressControlConfig_OneofBackends {
	if m != nil {
		return m.OneofBackends
	}
	return nil
}

func (x *EgressControlConfig) GetBackends() string {
	if x, ok := x.GetOneofBackends().(*EgressControlConfig_Backends); ok {
		return x.Backends
	}
	return ""
}

func (x *EgressControlConfig) GetExtractionRules() *ExtractionRules {
	if x, ok := x.GetOneofBackends().(*EgressControlConfig_ExtractionRules); ok {
		return x.ExtractionRules
	}
	return nil
}

type isEgressControlConfig_OneofBackends interface {
	isEgressControlConfig_OneofBackends()
}

type EgressControlConfig_Backends struct {
	// Static Comma separated backends which are common for all Connection
	// resources. Supported formats for each backend are host:port or just
	// host (host can be ip address or domain name).
	Backends string `protobuf:"bytes,1,opt,name=backends,proto3,oneof"`
}

type EgressControlConfig_ExtractionRules struct {
	// Extractions Rules to extract the backends from customer provided
	// configuration.
	ExtractionRules *ExtractionRules `protobuf:"bytes,2,opt,name=extraction_rules,json=extractionRules,proto3,oneof"`
}

func (*EgressControlConfig_Backends) isEgressControlConfig_OneofBackends() {}

func (*EgressControlConfig_ExtractionRules) isEgressControlConfig_OneofBackends() {}

// Extraction Rules to identity the backends from customer provided
// configuration in Connection resource.
type ExtractionRules struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Collection of Extraction Rule.
	ExtractionRule []*ExtractionRule `protobuf:"bytes,1,rep,name=extraction_rule,json=extractionRule,proto3" json:"extraction_rule,omitempty"`
}

func (x *ExtractionRules) Reset() {
	*x = ExtractionRules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connector_version_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExtractionRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtractionRules) ProtoMessage() {}

func (x *ExtractionRules) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connector_version_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtractionRules.ProtoReflect.Descriptor instead.
func (*ExtractionRules) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connector_version_proto_rawDescGZIP(), []int{6}
}

func (x *ExtractionRules) GetExtractionRule() []*ExtractionRule {
	if x != nil {
		return x.ExtractionRule
	}
	return nil
}

// Extraction Rule.
type ExtractionRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source on which the rule is applied.
	Source *ExtractionRule_Source `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// Regex used to extract backend details from source. If empty, whole source
	// value will be used.
	ExtractionRegex string `protobuf:"bytes,2,opt,name=extraction_regex,json=extractionRegex,proto3" json:"extraction_regex,omitempty"`
}

func (x *ExtractionRule) Reset() {
	*x = ExtractionRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connector_version_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExtractionRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtractionRule) ProtoMessage() {}

func (x *ExtractionRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connector_version_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtractionRule.ProtoReflect.Descriptor instead.
func (*ExtractionRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connector_version_proto_rawDescGZIP(), []int{7}
}

func (x *ExtractionRule) GetSource() *ExtractionRule_Source {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *ExtractionRule) GetExtractionRegex() string {
	if x != nil {
		return x.ExtractionRegex
	}
	return ""
}

// Source to extract the backend from.
type ExtractionRule_Source struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the source.
	SourceType ExtractionRule_SourceType `protobuf:"varint,1,opt,name=source_type,json=sourceType,proto3,enum=google.cloud.connectors.v1.ExtractionRule_SourceType" json:"source_type,omitempty"`
	// Field identifier. For example config vaiable name.
	FieldId string `protobuf:"bytes,2,opt,name=field_id,json=fieldId,proto3" json:"field_id,omitempty"`
}

func (x *ExtractionRule_Source) Reset() {
	*x = ExtractionRule_Source{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_connector_version_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExtractionRule_Source) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtractionRule_Source) ProtoMessage() {}

func (x *ExtractionRule_Source) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_connector_version_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtractionRule_Source.ProtoReflect.Descriptor instead.
func (*ExtractionRule_Source) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_connector_version_proto_rawDescGZIP(), []int{7, 0}
}

func (x *ExtractionRule_Source) GetSourceType() ExtractionRule_SourceType {
	if x != nil {
		return x.SourceType
	}
	return ExtractionRule_SOURCE_TYPE_UNSPECIFIED
}

func (x *ExtractionRule_Source) GetFieldId() string {
	if x != nil {
		return x.FieldId
	}
	return ""
}

var File_google_cloud_connectors_v1_connector_version_proto protoreflect.FileDescriptor

var file_google_cloud_connectors_v1_connector_version_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xdc, 0x09, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x55, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x4f, 0x0a, 0x0c,
	0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x5f, 0x73, 0x74, 0x61, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x53, 0x74, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0b, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x53, 0x74, 0x61, 0x67, 0x65, 0x12, 0x2c, 0x0a,
	0x0f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x72, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x0a, 0x15, 0x61,
	0x75, 0x74, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x13, 0x61, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x12, 0x73, 0x0a, 0x19, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x76,
	0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x61, 0x72, 0x69, 0x61,
	0x62, 0x6c, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x17, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x12, 0x77, 0x0a, 0x1a, 0x73, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x65, 0x64, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x18, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x65, 0x64, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x68, 0x0a, 0x15, 0x65, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x13, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x0a, 0x0b, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x67, 0x72, 0x61,
	0x6e, 0x74, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x47, 0x72, 0x61, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x72, 0x6f, 0x6c, 0x65, 0x47, 0x72, 0x61, 0x6e, 0x74,
	0x73, 0x12, 0x49, 0x0a, 0x0a, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x09, 0x72, 0x6f, 0x6c, 0x65, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x1a, 0x39, 0x0a, 0x0b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x98, 0x01, 0xea, 0x41, 0x94, 0x01, 0x0a, 0x2a,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x66, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x7d, 0x2f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x7d, 0x22, 0xaa, 0x01, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x44, 0x0a, 0x04, 0x76, 0x69, 0x65,
	0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22,
	0xe5, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x44, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x69, 0x65,
	0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xc6, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a, 0x12, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20,
	0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0x79, 0x0a, 0x18, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x52, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x61, 0x70, 0x69, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x70, 0x69, 0x73, 0x12, 0x1f, 0x0a,
	0x0b, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x70, 0x69, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0a, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x70, 0x69, 0x73, 0x12, 0x1b,
	0x0a, 0x09, 0x73, 0x71, 0x6c, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x08, 0x73, 0x71, 0x6c, 0x51, 0x75, 0x65, 0x72, 0x79, 0x22, 0x9f, 0x01, 0x0a, 0x13,
	0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x1c, 0x0a, 0x08, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64,
	0x73, 0x12, 0x58, 0x0a, 0x10, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x48, 0x00, 0x52, 0x0f, 0x65, 0x78, 0x74, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x42, 0x10, 0x0a, 0x0e, 0x6f,
	0x6e, 0x65, 0x6f, 0x66, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x73, 0x22, 0x66, 0x0a,
	0x0f, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x73,
	0x12, 0x53, 0x0a, 0x0f, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72,
	0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x0e, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x75, 0x6c, 0x65, 0x22, 0xc3, 0x02, 0x0a, 0x0e, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x49, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x75, 0x6c, 0x65, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x72, 0x65, 0x67, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x65,
	0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x67, 0x65, 0x78, 0x1a, 0x7b,
	0x0a, 0x06, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x56, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x74, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x19, 0x0a, 0x08, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x22, 0x3e, 0x0a, 0x0a, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x4f, 0x55,
	0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47,
	0x5f, 0x56, 0x41, 0x52, 0x49, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x2a, 0x81, 0x01, 0x0a, 0x14,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x56, 0x69, 0x65, 0x77, 0x12, 0x26, 0x0a, 0x22, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x4f,
	0x52, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x20, 0x0a, 0x1c,
	0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f,
	0x4e, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x1f,
	0x0a, 0x1b, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x56, 0x45, 0x52, 0x53,
	0x49, 0x4f, 0x4e, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x42,
	0x7f, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76,
	0x31, 0x42, 0x15, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65,
	0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_connectors_v1_connector_version_proto_rawDescOnce sync.Once
	file_google_cloud_connectors_v1_connector_version_proto_rawDescData = file_google_cloud_connectors_v1_connector_version_proto_rawDesc
)

func file_google_cloud_connectors_v1_connector_version_proto_rawDescGZIP() []byte {
	file_google_cloud_connectors_v1_connector_version_proto_rawDescOnce.Do(func() {
		file_google_cloud_connectors_v1_connector_version_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_connectors_v1_connector_version_proto_rawDescData)
	})
	return file_google_cloud_connectors_v1_connector_version_proto_rawDescData
}

var file_google_cloud_connectors_v1_connector_version_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_connectors_v1_connector_version_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_connectors_v1_connector_version_proto_goTypes = []interface{}{
	(ConnectorVersionView)(0),             // 0: google.cloud.connectors.v1.ConnectorVersionView
	(ExtractionRule_SourceType)(0),        // 1: google.cloud.connectors.v1.ExtractionRule.SourceType
	(*ConnectorVersion)(nil),              // 2: google.cloud.connectors.v1.ConnectorVersion
	(*GetConnectorVersionRequest)(nil),    // 3: google.cloud.connectors.v1.GetConnectorVersionRequest
	(*ListConnectorVersionsRequest)(nil),  // 4: google.cloud.connectors.v1.ListConnectorVersionsRequest
	(*ListConnectorVersionsResponse)(nil), // 5: google.cloud.connectors.v1.ListConnectorVersionsResponse
	(*SupportedRuntimeFeatures)(nil),      // 6: google.cloud.connectors.v1.SupportedRuntimeFeatures
	(*EgressControlConfig)(nil),           // 7: google.cloud.connectors.v1.EgressControlConfig
	(*ExtractionRules)(nil),               // 8: google.cloud.connectors.v1.ExtractionRules
	(*ExtractionRule)(nil),                // 9: google.cloud.connectors.v1.ExtractionRule
	nil,                                   // 10: google.cloud.connectors.v1.ConnectorVersion.LabelsEntry
	(*ExtractionRule_Source)(nil),         // 11: google.cloud.connectors.v1.ExtractionRule.Source
	(*timestamppb.Timestamp)(nil),         // 12: google.protobuf.Timestamp
	(LaunchStage)(0),                      // 13: google.cloud.connectors.v1.LaunchStage
	(*AuthConfigTemplate)(nil),            // 14: google.cloud.connectors.v1.AuthConfigTemplate
	(*ConfigVariableTemplate)(nil),        // 15: google.cloud.connectors.v1.ConfigVariableTemplate
	(*RoleGrant)(nil),                     // 16: google.cloud.connectors.v1.RoleGrant
}
var file_google_cloud_connectors_v1_connector_version_proto_depIdxs = []int32{
	12, // 0: google.cloud.connectors.v1.ConnectorVersion.create_time:type_name -> google.protobuf.Timestamp
	12, // 1: google.cloud.connectors.v1.ConnectorVersion.update_time:type_name -> google.protobuf.Timestamp
	10, // 2: google.cloud.connectors.v1.ConnectorVersion.labels:type_name -> google.cloud.connectors.v1.ConnectorVersion.LabelsEntry
	13, // 3: google.cloud.connectors.v1.ConnectorVersion.launch_stage:type_name -> google.cloud.connectors.v1.LaunchStage
	14, // 4: google.cloud.connectors.v1.ConnectorVersion.auth_config_templates:type_name -> google.cloud.connectors.v1.AuthConfigTemplate
	15, // 5: google.cloud.connectors.v1.ConnectorVersion.config_variable_templates:type_name -> google.cloud.connectors.v1.ConfigVariableTemplate
	6,  // 6: google.cloud.connectors.v1.ConnectorVersion.supported_runtime_features:type_name -> google.cloud.connectors.v1.SupportedRuntimeFeatures
	7,  // 7: google.cloud.connectors.v1.ConnectorVersion.egress_control_config:type_name -> google.cloud.connectors.v1.EgressControlConfig
	16, // 8: google.cloud.connectors.v1.ConnectorVersion.role_grants:type_name -> google.cloud.connectors.v1.RoleGrant
	16, // 9: google.cloud.connectors.v1.ConnectorVersion.role_grant:type_name -> google.cloud.connectors.v1.RoleGrant
	0,  // 10: google.cloud.connectors.v1.GetConnectorVersionRequest.view:type_name -> google.cloud.connectors.v1.ConnectorVersionView
	0,  // 11: google.cloud.connectors.v1.ListConnectorVersionsRequest.view:type_name -> google.cloud.connectors.v1.ConnectorVersionView
	2,  // 12: google.cloud.connectors.v1.ListConnectorVersionsResponse.connector_versions:type_name -> google.cloud.connectors.v1.ConnectorVersion
	8,  // 13: google.cloud.connectors.v1.EgressControlConfig.extraction_rules:type_name -> google.cloud.connectors.v1.ExtractionRules
	9,  // 14: google.cloud.connectors.v1.ExtractionRules.extraction_rule:type_name -> google.cloud.connectors.v1.ExtractionRule
	11, // 15: google.cloud.connectors.v1.ExtractionRule.source:type_name -> google.cloud.connectors.v1.ExtractionRule.Source
	1,  // 16: google.cloud.connectors.v1.ExtractionRule.Source.source_type:type_name -> google.cloud.connectors.v1.ExtractionRule.SourceType
	17, // [17:17] is the sub-list for method output_type
	17, // [17:17] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_google_cloud_connectors_v1_connector_version_proto_init() }
func file_google_cloud_connectors_v1_connector_version_proto_init() {
	if File_google_cloud_connectors_v1_connector_version_proto != nil {
		return
	}
	file_google_cloud_connectors_v1_authconfig_proto_init()
	file_google_cloud_connectors_v1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_connectors_v1_connector_version_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConnectorVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connector_version_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConnectorVersionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connector_version_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConnectorVersionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connector_version_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConnectorVersionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connector_version_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SupportedRuntimeFeatures); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connector_version_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EgressControlConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connector_version_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExtractionRules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connector_version_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExtractionRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_connector_version_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExtractionRule_Source); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_connectors_v1_connector_version_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*EgressControlConfig_Backends)(nil),
		(*EgressControlConfig_ExtractionRules)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_connectors_v1_connector_version_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_connectors_v1_connector_version_proto_goTypes,
		DependencyIndexes: file_google_cloud_connectors_v1_connector_version_proto_depIdxs,
		EnumInfos:         file_google_cloud_connectors_v1_connector_version_proto_enumTypes,
		MessageInfos:      file_google_cloud_connectors_v1_connector_version_proto_msgTypes,
	}.Build()
	File_google_cloud_connectors_v1_connector_version_proto = out.File
	file_google_cloud_connectors_v1_connector_version_proto_rawDesc = nil
	file_google_cloud_connectors_v1_connector_version_proto_goTypes = nil
	file_google_cloud_connectors_v1_connector_version_proto_depIdxs = nil
}
