# docker buildx history inspect attachment

```text
docker buildx history inspect attachment [OPTIONS] [REF [DIGEST]]
```

<!---MARKER_GEN_START-->
Inspect a build record attachment

### Options

| Name                      | Type     | Default | Description                              |
|:--------------------------|:---------|:--------|:-----------------------------------------|
| `--builder`               | `string` |         | Override the configured builder instance |
| `-D`, `--debug`           | `bool`   |         | Enable debug logging                     |
| [`--platform`](#platform) | `string` |         | Platform of attachment                   |
| [`--type`](#type)         | `string` |         | Type of attachment                       |


<!---MARKER_GEN_END-->

## Description

Inspect a specific attachment from a build record, such as a provenance file or
SBOM. Attachments are optional artifacts stored with the build and may be
platform-specific.

## Examples

### <a name="platform"></a> Inspect an attachment by platform (--platform)

```console
$ docker buildx history inspect attachment --platform linux/amd64
{
  "schemaVersion": 2,
  "mediaType": "application/vnd.oci.image.manifest.v1+json",
  "config": {
    "mediaType": "application/vnd.oci.image.config.v1+json",
    "digest": "sha256:814e63f06465bc78123775714e4df1ebdda37e6403e0b4f481df74947c047163",
    "size": 600
  },
  "layers": [
    {
      "mediaType": "application/vnd.oci.image.layer.v1.tar+gzip",
      "digest": "sha256:36537f3920ae948ce3e12b4ae34c21190280e6e7d58eeabde0dff3fdfb43b6b0",
      "size": 21664137
    }
  ]
}
```

### <a name="type"></a> Inspect an attachment by type (--type)

Supported types include:
* `index`
* `manifest`
* `image`
* `provenance`
* `sbom`

#### Index

```console
$ docker buildx history inspect attachment --type index
{
  "schemaVersion": 2,
  "mediaType": "application/vnd.oci.image.index.v1+json",
  "manifests": [
    {
      "mediaType": "application/vnd.oci.image.manifest.v1+json",
      "digest": "sha256:a194e24f47dc6d0e65992c09577b9bc4e7bd0cd5cc4f81e7738918f868aa397b",
      "size": 481,
      "platform": {
        "architecture": "amd64",
        "os": "linux"
      }
    },
    {
      "mediaType": "application/vnd.oci.image.manifest.v1+json",
      "digest": "sha256:49e40223d6a96ea0667a12737fd3dde004cf217eb48cb28c9191288cd44c6ace",
      "size": 839,
      "annotations": {
        "vnd.docker.reference.digest": "sha256:a194e24f47dc6d0e65992c09577b9bc4e7bd0cd5cc4f81e7738918f868aa397b",
        "vnd.docker.reference.type": "attestation-manifest"
      },
      "platform": {
        "architecture": "unknown",
        "os": "unknown"
      }
    }
  ]
}
```

#### Manifest

```console
$ docker buildx history inspect attachment --type manifest
{
  "schemaVersion": 2,
  "mediaType": "application/vnd.oci.image.manifest.v1+json",
  "config": {
    "mediaType": "application/vnd.oci.image.config.v1+json",
    "digest": "sha256:814e63f06465bc78123775714e4df1ebdda37e6403e0b4f481df74947c047163",
    "size": 600
  },
  "layers": [
    {
      "mediaType": "application/vnd.oci.image.layer.v1.tar+gzip",
      "digest": "sha256:36537f3920ae948ce3e12b4ae34c21190280e6e7d58eeabde0dff3fdfb43b6b0",
      "size": 21664137
    }
  ]
}
```

#### Provenance

```console
$ docker buildx history inspect attachment --type provenance
{
  "builder": {
    "id": ""
  },
  "buildType": "https://mobyproject.org/buildkit@v1",
  "materials": [
    {
      "uri": "pkg:docker/docker/dockerfile@1",
      "digest": {
        "sha256": "9ba7531bd80fb0a858632727cf7a112fbfd19b17e94c4e84ced81e24ef1a0dbc"
      }
    },
    {
      "uri": "pkg:docker/golang@1.19.4-alpine?platform=linux%2Farm64",
      "digest": {
        "sha256": "a9b24b67dc83b3383d22a14941c2b2b2ca6a103d805cac6820fd1355943beaf1"
      }
    }
  ],
  "invocation": {
    "configSource": {
      "entryPoint": "Dockerfile"
    },
    "parameters": {
      "frontend": "gateway.v0",
      "args": {
        "cmdline": "docker/dockerfile:1",
        "source": "docker/dockerfile:1",
        "target": "binaries"
      },
      "locals": [
        {
          "name": "context"
        },
        {
          "name": "dockerfile"
        }
      ]
    },
    "environment": {
      "platform": "linux/arm64"
    }
  },
  "metadata": {
    "buildInvocationID": "c4a87v0sxhliuewig10gnsb6v",
    "buildStartedOn": "2022-12-16T08:26:28.651359794Z",
    "buildFinishedOn": "2022-12-16T08:26:29.625483253Z",
    "reproducible": false,
    "completeness": {
      "parameters": true,
      "environment": true,
      "materials": false
    },
    "https://mobyproject.org/buildkit@v1#metadata": {
      "vcs": {
        "revision": "a9ba846486420e07d30db1107411ac3697ecab68",
        "source": "git@github.com:<org>/<repo>.git"
      }
    }
  }
}
```

### Inspect an attachment by digest

You can inspect an attachment directly using its digset, which you can get from
the `inspect` output:

```console
# Using a build ID
docker buildx history inspect attachment qu2gsuo8ejqrwdfii23xkkckt sha256:abcdef123456...

# Or using a relative offset
docker buildx history inspect attachment ^0 sha256:abcdef123456...
```

Use `--type sbom` or `--type provenance` to filter attachments by type. To
inspect a specific attachment by digest, omit the `--type` flag.
