/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.util.Out;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultValuesExtractor
implements DataExtractor {
    protected final ObjectFormatter myConverter;

    public DefaultValuesExtractor(@NotNull ObjectFormatter converter) {
        if (converter == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(0);
        }
        this.myConverter = converter;
    }

    public String getLineSeparator() {
        return "\n";
    }

    @NotNull
    public String getValueLiteral(@NotNull GridRow row, @NotNull GridColumn column, @NotNull ObjectFormatterConfig config) {
        String value;
        if (row == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(1);
        }
        if (column == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(2);
        }
        if (config == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(3);
        }
        String string = (value = this.getValueAsString(row, column, config)) == null ? this.getNullLiteral(row, column) : this.getValueLiteral(value, row, column);
        if (string == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    protected String getValueAsString(@NotNull GridRow row, @NotNull GridColumn column, @NotNull ObjectFormatterConfig config) {
        if (row == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(5);
        }
        if (column == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(6);
        }
        if (config == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(7);
        }
        return this.myConverter.objectToString(this.getValue(row, column), column, config);
    }

    @NotNull
    public String getValueLiteral(@NotNull GridRow row, @NotNull GridColumn column, @NotNull ObjectFormatterMode mode) {
        String value;
        if (row == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(8);
        }
        if (column == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(9);
        }
        if (mode == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(10);
        }
        String string = (value = this.getValueAsString(row, column, mode)) == null ? this.getNullLiteral(row, column) : this.getValueLiteral(value, row, column);
        if (string == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    protected String getValueAsString(@NotNull GridRow row, @NotNull GridColumn column, @NotNull ObjectFormatterMode mode) {
        if (row == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(12);
        }
        if (column == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(13);
        }
        if (mode == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(14);
        }
        return this.myConverter.objectToString(this.getValue(row, column), column, DatabaseObjectFormatterConfig.get(mode));
    }

    @Nullable
    protected Object getValue(@NotNull GridRow row, @NotNull GridColumn column) {
        if (row == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(15);
        }
        if (column == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(16);
        }
        return column.getValue(row);
    }

    public String getValueLiteral(@NotNull String value, @Nullable GridRow row, @Nullable GridColumn column) {
        if (value == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(17);
        }
        return this.isStringLiteral(row, column) ? this.getStringValueLiteral(column, value) : value;
    }

    protected abstract boolean isStringLiteral(@Nullable GridRow var1, @Nullable GridColumn var2);

    @Override
    public abstract DataExtractor.Extraction startExtraction(@NotNull Out var1, @NotNull List<? extends GridColumn> var2, @NotNull String var3, @NotNull ExtractionConfig var4, int ... var5);

    public String getColumnName(GridColumn column) {
        return column.getName();
    }

    @Override
    @NotNull
    public String getFileExtension() {
        return "txt";
    }

    @NotNull
    public String getNullLiteral(GridRow row, GridColumn column) {
        return "NULL";
    }

    @NotNull
    public String getStringValueLiteral(@Nullable GridColumn column, @NotNull String value) {
        if (value == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(18);
        }
        String string = value;
        if (string == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 11, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 4: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/DefaultValuesExtractor";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/DefaultValuesExtractor";
                break;
            }
            case 4: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueLiteral";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValueLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getValueLiteral";
                break;
            }
            case 4: 
            case 11: 
            case 19: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getValueAsString";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getStringValueLiteral";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 11, 19 -> new IllegalStateException(string);
        };
    }

    protected static abstract class DefaultExtraction
    implements DataExtractor.Extraction {
        protected final Out myOut;
        protected List<? extends GridColumn> myAllColumns;
        protected String myQuery;
        protected final int[] mySelectedColumnIndices;
        protected final ExtractionConfig myConfig;
        protected boolean myHeaderAppended;
        protected boolean myFooterAppended;

        public DefaultExtraction(Out out, ExtractionConfig config, List<? extends GridColumn> allColumns, String query, int[] selectedColumnIndices) {
            this.myOut = out;
            this.myConfig = config;
            this.myAllColumns = allColumns;
            this.myQuery = query;
            this.mySelectedColumnIndices = selectedColumnIndices;
        }

        @Override
        public void updateColumns(GridColumn @NotNull [] columns) {
            if (columns == null) {
                DefaultExtraction.$$$reportNull$$$0(0);
            }
            this.myAllColumns = Arrays.asList(columns);
        }

        @Override
        public void addData(List<? extends GridRow> rows) {
            if (!this.myHeaderAppended) {
                this.appendHeader(!rows.isEmpty());
                this.myHeaderAppended = true;
            }
            this.appendData(rows);
        }

        @Override
        public void completeBatch() {
            if (!this.myHeaderAppended) {
                this.appendHeader(false);
                this.myHeaderAppended = true;
            }
            if (!this.myFooterAppended) {
                this.appendFooter();
                this.myFooterAppended = true;
            }
        }

        @Override
        public void complete() {
            this.completeBatch();
        }

        protected void appendHeader(boolean appendNewLine) {
        }

        protected void appendFooter() {
        }

        protected abstract void appendData(List<? extends GridRow> var1);

        @NotNull
        protected GridColumn getRowNumbersColumn() {
            return new DataConsumer.Column(0, "#", 12, "", "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/extractors/DefaultValuesExtractor$DefaultExtraction", "updateColumns"));
        }
    }
}

