# Changelog 0.4.x

## 0.4.0

This release adds first-class support for Python projects that are not designed as Python packages
(e.g., web applications, data science projects, etc.).

In doing so, it includes some breaking changes around uv's handling of projects. Previously, uv
required that all projects could be built into distributable Python packages, and installed them
into the virtual environment. Projects created by `uv init` always included a `[build-system]`
definition and existing projects that did not define a `[build-system]` would use the legacy
setuptools build backend by default.

Most users are not developing libraries that need to be packaged and published to PyPI. Instead,
they're building applications using web frameworks, or running collections of Python scripts in the
project's root directory. In these cases, requiring a `[build-system]` was confusing and
error-prone. In this release, uv changes the default behavior to orient around these common use
cases.

In summary, the major changes are:

- uv no longer attempts to package and install projects that do not define a `[build-system]`.
  - While the project itself will not be installed into the virtual environment, its dependencies
    will still be included.
  - The previous behavior can be recovered by setting `package = true` in the `[tool.uv]` section of
    your `pyproject.toml`.
- `uv init` no longer creates a `src/` directory or defines a `[build-system]` by default.
  - The previous behavior can be recovered with `uv init --lib` or `uv init --app --package`.
- uv allows and recommends including `[project]` definitions in virtual workspace roots.
  - Previously, the uv required the `[project]` section to be omitted.
- uv allows disabling packaging of projects, even if they define a `[build-system]`, by setting
  `package = false` in the `[tool.uv]` section of your `pyproject.toml`.

See the latest documentation on
[build systems in projects](http://docs.astral.sh/uv/concepts/projects/#build-systems) for more
details.

### Enhancements

- Add first-class support for non-packaged projects
  ([#6585](https://github.com/astral-sh/uv/pull/6585))
- Add `--app` and `--lib` options to `uv init` ([#6689](https://github.com/astral-sh/uv/pull/6689))
- Use `virtual` source label in lockfile for non-packaged dependencies
  ([#6728](https://github.com/astral-sh/uv/pull/6728))
- Read hash from URL fragment if `--hashes` are omitted
  ([#6731](https://github.com/astral-sh/uv/pull/6731))
- Support `{package}@{version}` in `uv tool install`
  ([#6762](https://github.com/astral-sh/uv/pull/6762))
- Publish additional Docker tags without patch version
  ([#6734](https://github.com/astral-sh/uv/pull/6734))

### Bug fixes

- Accept either strings or structs for hosts ([#6763](https://github.com/astral-sh/uv/pull/6763))
- Avoid including non-excluded members in parent workspaces
  ([#6735](https://github.com/astral-sh/uv/pull/6735))
- Avoid reading stale `.egg-info` from mutable sources
  ([#6714](https://github.com/astral-sh/uv/pull/6714))
- Avoid writing invalid PEP 723 scripts on `tool.uv.sources`
  ([#6706](https://github.com/astral-sh/uv/pull/6706))
- Compare virtual members when invalidating lockfile
  ([#6754](https://github.com/astral-sh/uv/pull/6754))
- Do not require workspace members to sync with `--frozen`
  ([#6737](https://github.com/astral-sh/uv/pull/6737))
- Implement deserialization for trusted host ([#6716](https://github.com/astral-sh/uv/pull/6716))
- Avoid showing duplicate paths in `uv python list`
  ([#6740](https://github.com/astral-sh/uv/pull/6740))
- Raise an error for unclosed script tags in PEP 723 scripts
  ([#6704](https://github.com/astral-sh/uv/pull/6704))

### Documentation

- Add dependabot and renovate documentation page
  ([#6236](https://github.com/astral-sh/uv/pull/6236))
- Bind to the host to allow connections in FastAPI Docker example
  ([#6753](https://github.com/astral-sh/uv/pull/6753))
- Fix some broken links ([#6705](https://github.com/astral-sh/uv/pull/6705))
- Update FastAPI guide for virtual projects and use `uv init` to create the `pyproject.toml`
  ([#6752](https://github.com/astral-sh/uv/pull/6752))
- Update project documentation for the application / library concepts
  ([#6718](https://github.com/astral-sh/uv/pull/6718))
- Update workspace documentation to remove legacy virtual projects
  ([#6720](https://github.com/astral-sh/uv/pull/6720))

## 0.4.1

### Enhancements

- Add `uv export --format requirements-txt` ([#6778](https://github.com/astral-sh/uv/pull/6778))
- Allow `@` references in `uv tool install --from`
  ([#6842](https://github.com/astral-sh/uv/pull/6842))
- Normalize version specifiers by sorting ([#6333](https://github.com/astral-sh/uv/pull/6333))
- Respect the user's upper-bound in `requires-python`
  ([#6824](https://github.com/astral-sh/uv/pull/6824))
- Use Windows registry to discover Python on Windows directly
  ([#6761](https://github.com/astral-sh/uv/pull/6761))
- Hint at `--no-workspace` in `uv init` failures
  ([#6815](https://github.com/astral-sh/uv/pull/6815))
- Update to last PyPy releases ([#6784](https://github.com/astral-sh/uv/pull/6784))

### Bug fixes

- Avoid deadlocks when multiple uv processes lock resources
  ([#6790](https://github.com/astral-sh/uv/pull/6790))
- Expand tildes when matching against `PATH` ([#6829](https://github.com/astral-sh/uv/pull/6829))
- Fix `uv init --no-project` alias ([#6837](https://github.com/astral-sh/uv/pull/6837))
- Ignore pre-release segments when discovering via `requires-python`
  ([#6813](https://github.com/astral-sh/uv/pull/6813))
- Support inline optional tables in `uv add` and `uv remove`
  ([#6787](https://github.com/astral-sh/uv/pull/6787))
- Update default `hello.py` to pass `ruff format`
  ([#6811](https://github.com/astral-sh/uv/pull/6811))
- Avoid stripping root for user path display ([#6865](https://github.com/astral-sh/uv/pull/6865))
- Error when user-provided environments are disjoint with Python
  ([#6841](https://github.com/astral-sh/uv/pull/6841))
- Retain alphabetical sorting for `pyproject.toml` in `uv add` operations
  ([#6388](https://github.com/astral-sh/uv/pull/6388))))

### Documentation

- Add a link to the multiple index docs in the alternative index guide
  ([#6826](https://github.com/astral-sh/uv/pull/6826))
- Add docs for inline exclude newer in PEP 723 scripts
  ([#6831](https://github.com/astral-sh/uv/pull/6831))
- Enumerate available Docker tags ([#6768](https://github.com/astral-sh/uv/pull/6768))
- Omit `[pip]` section from configuration file docs
  ([#6814](https://github.com/astral-sh/uv/pull/6814))
- Update `project.urls` in `pyproject.toml` ([#6844](https://github.com/astral-sh/uv/pull/6844))
- Add docs for AWS CodeArtifact usage ([#6816](https://github.com/astral-sh/uv/pull/6816))

### Other changes

## 0.4.2

### Enhancements

- Adding support for `.pyc` files in `uv run` ([#6886](https://github.com/astral-sh/uv/pull/6886))
- Treat missing `top_level.txt` as non-fatal ([#6881](https://github.com/astral-sh/uv/pull/6881))

### Bug fixes

- Fix `is_disjoint` check for supported environments
  ([#6902](https://github.com/astral-sh/uv/pull/6902))
- Remove dangling archives in `uv cache clean ${package}`
  ([#6915](https://github.com/astral-sh/uv/pull/6915))
- Error when discovered Python is incompatible with `--isolated` workspace
  ([#6885](https://github.com/astral-sh/uv/pull/6885))
- Warn when discovered Python is incompatible with PEP 723 script
  ([#6884](https://github.com/astral-sh/uv/pull/6884))

## 0.4.3

### Enhancements

- Show build backend output when `--verbose` is provided
  ([#6903](https://github.com/astral-sh/uv/pull/6903))
- Allow `uv sync --frozen --package` without copying member `pyproject.toml`
  ([#6943](https://github.com/astral-sh/uv/pull/6943))

### Bug fixes

- Avoid panic with missing temporary directory ([#6929](https://github.com/astral-sh/uv/pull/6929))
- Avoid updating incorrect dependencies for sorted `uv add`
  ([#6939](https://github.com/astral-sh/uv/pull/6939))
- Use lower-bound semantics for all Python compatibility comparisons
  ([#6882](https://github.com/astral-sh/uv/pull/6882))

## 0.4.4

### Enhancements

- Allow customizing the project environment path with `UV_PROJECT_ENVIRONMENT`
  ([#6834](https://github.com/astral-sh/uv/pull/6834))
- Warn when `VIRTUAL_ENV` is set but will not be respected in project commands
  ([#6864](https://github.com/astral-sh/uv/pull/6864))
- Add `--no-hashes` to `uv export` ([#6954](https://github.com/astral-sh/uv/pull/6954))
- Make HTTP headers title case for backward compatibility
  ([#6887](https://github.com/astral-sh/uv/pull/6887))
- Pin `.python-version` in `uv init` ([#6869](https://github.com/astral-sh/uv/pull/6869))
- Support `file://` URLs for `UV_PYTHON_INSTALL_MIRROR`
  ([#6950](https://github.com/astral-sh/uv/pull/6950))
- Introduce more docker tags for uv ([#6053](https://github.com/astral-sh/uv/pull/6053))

### Bug fixes

- Avoid canonicalizing the cache directory ([#6949](https://github.com/astral-sh/uv/pull/6949))
- Show all PyPy versions in `uv python list --all-versions`
  ([#6917](https://github.com/astral-sh/uv/pull/6917))
- Avoid incorrect `requires-python` marker simplifications
  ([#6268](https://github.com/astral-sh/uv/pull/6268))

### Documentation

- Add documentation for `UV_PROJECT_ENVIRONMENT`
  ([#6987](https://github.com/astral-sh/uv/pull/6987))
- Add optional dependencies section to the lockfile document
  ([#6982](https://github.com/astral-sh/uv/pull/6982))
- Document use of the `file://` scheme in Python installation mirrors
  ([#6984](https://github.com/astral-sh/uv/pull/6984))
- Fix outdated references to the help menu documentation in the first steps page
  ([#6980](https://github.com/astral-sh/uv/pull/6980))
- Show env option in CLI reference documentation
  ([#6863](https://github.com/astral-sh/uv/pull/6863))
- Add bind mount example to `docker.md` ([#6921](https://github.com/astral-sh/uv/pull/6921))

## 0.4.5

### Enhancements

- Implement `uv build` ([#6895](https://github.com/astral-sh/uv/pull/6895))
- Add `--package` support to `uv build` ([#6990](https://github.com/astral-sh/uv/pull/6990))
- Prune unreachable packages from lockfile ([#6959](https://github.com/astral-sh/uv/pull/6959))
- Prune unreachable wheels from lockfile ([#6961](https://github.com/astral-sh/uv/pull/6961))
- Show build output by default in `uv build` ([#6912](https://github.com/astral-sh/uv/pull/6912))
- Support `uv build --wheel` from source distributions
  ([#6898](https://github.com/astral-sh/uv/pull/6898))
- Use the root project name for the project virtual environment prompt
  ([#7021](https://github.com/astral-sh/uv/pull/7021))

### Bug fixes

- Fix handling of inline optional dependencies in `uv add`
  ([#7023](https://github.com/astral-sh/uv/pull/7023))
- Reflect exit code in `uv tool run` and `uv run`
  ([#6994](https://github.com/astral-sh/uv/pull/6994))
- Revert `pyproject.toml` modifications on Ctrl-C
  ([#7024](https://github.com/astral-sh/uv/pull/7024))
- Rollback `pyproject.toml` changes on all errors
  ([#7022](https://github.com/astral-sh/uv/pull/7022))
- Use correct ordering semantics for narrowing upper-bounded Python requirements
  ([#7031](https://github.com/astral-sh/uv/pull/7031))
- Fix segfault in Windows trampolines ([#6955](https://github.com/astral-sh/uv/pull/6955))
- Remove unused `__future__.annotations` import in `_virtualenv.py`
  ([#6996](https://github.com/astral-sh/uv/pull/6996))

### Documentation

- Add documentation for `uv build` ([#6991](https://github.com/astral-sh/uv/pull/6991))
- Add note to `extra` and `all-extras` in `uv sync` help
  ([#7013](https://github.com/astral-sh/uv/pull/7013))
- Add project docs for `project.scripts` ([#7010](https://github.com/astral-sh/uv/pull/7010))
- Fix available Docker image tag rendering and shorten list
  ([#7017](https://github.com/astral-sh/uv/pull/7017))
- Touchup to the project environment config section
  ([#7038](https://github.com/astral-sh/uv/pull/7038))
- Clarify precedence of `uv.toml` ([#6986](https://github.com/astral-sh/uv/pull/6986))
- Fix available Docker tags for `-slim` variants
  ([#7041](https://github.com/astral-sh/uv/pull/7041))

## 0.4.6

### Enhancements

- Accept `--build-constraint` in `uv build` ([#7085](https://github.com/astral-sh/uv/pull/7085))
- Add `--require-hashes` and `--verify-hashes` to `uv build`
  ([#7094](https://github.com/astral-sh/uv/pull/7094))
- Add `--show-version-specifiers` to `uv tool list`
  ([#7050](https://github.com/astral-sh/uv/pull/7050))
- Respect hashes in constraints files ([#7093](https://github.com/astral-sh/uv/pull/7093))
- Upgrade installer scripts ([#7092](https://github.com/astral-sh/uv/pull/7092))
- Allow specifying multiple packages in `uv tool upgrade` and `uninstall`
  ([#7037](https://github.com/astral-sh/uv/pull/7037))
- Sort by implementation in `uv python list` ([#6918](https://github.com/astral-sh/uv/pull/6918))

### Bug fixes

- Invalidate lockfile when member versions change
  ([#7102](https://github.com/astral-sh/uv/pull/7102))
- Strip fragments from direct source URLs in lockfile
  ([#7061](https://github.com/astral-sh/uv/pull/7061))
- Support `--no-build` and `--no-binary` in `uv sync` et al
  ([#7100](https://github.com/astral-sh/uv/pull/7100))
- Use distribution hash over registry hash ([#7060](https://github.com/astral-sh/uv/pull/7060))
- Fix inverted log message ([#7063](https://github.com/astral-sh/uv/pull/7063))
- Adjust Docker `ENTRYPOINT` and `CMD` for inherited images
  ([#7054](https://github.com/astral-sh/uv/pull/7054))

### Documentation

- Add winget to installers ([#7088](https://github.com/astral-sh/uv/pull/7088))
- Document how to disable path modifications during install
  ([#7090](https://github.com/astral-sh/uv/pull/7090))
- Document how to manually update locked package version
  ([#7083](https://github.com/astral-sh/uv/pull/7083))
- Document official `setup-uv` action ([#7056](https://github.com/astral-sh/uv/pull/7056))
- Update docs on `.python-version` file ([#7051](https://github.com/astral-sh/uv/pull/7051))

## 0.4.7

### Enhancements

- Add `--no-emit-project` and friends to `uv export`
  ([#7110](https://github.com/astral-sh/uv/pull/7110))
- Add `--output-file` to `uv export` ([#7109](https://github.com/astral-sh/uv/pull/7109))
- Prune unused source distributions from the cache in `uv cache prune`
  ([#7112](https://github.com/astral-sh/uv/pull/7112))
- Take intersection of constraint and requirements hashes
  ([#7108](https://github.com/astral-sh/uv/pull/7108))

### Performance

- Skip metadata fetch for `--no-deps` and `pip sync`
  ([#7127](https://github.com/astral-sh/uv/pull/7127))

### Bug fixes

- Avoid panicking when encountering an invalid Python version during `uv python list`
  ([#7131](https://github.com/astral-sh/uv/pull/7131))
- Write trailing newline to `.python-version` files
  ([#7140](https://github.com/astral-sh/uv/pull/7140))

## 0.4.8

### Enhancements

- Add support for dynamic cache keys ([#7136](https://github.com/astral-sh/uv/pull/7136))
- Allow `.dist-info` names with dashes for post releases
  ([#7208](https://github.com/astral-sh/uv/pull/7208))
- Use type hints in code from `uv init` ([#7225](https://github.com/astral-sh/uv/pull/7225))
- Treat `.tgz` the same as `.tar.gz` ([#7201](https://github.com/astral-sh/uv/pull/7201))
- Direct users towards `uv venv` to create a virtual environment
  ([#7188](https://github.com/astral-sh/uv/pull/7188))
- Improve error message for uv init already init-ed
  ([#7198](https://github.com/astral-sh/uv/pull/7198))

### Performance

- Avoid batch prefetching for un-optimized registries
  ([#7226](https://github.com/astral-sh/uv/pull/7226))
- Avoid iteration for singleton selections ([#7195](https://github.com/astral-sh/uv/pull/7195))

### Bug fixes

- Avoid extra newlines in debug logging for source builds
  ([#7174](https://github.com/astral-sh/uv/pull/7174))
- Prune unreachable packages from `--universal` output
  ([#7209](https://github.com/astral-sh/uv/pull/7209))
- Respect exclusion when collecting workspace members
  ([#7175](https://github.com/astral-sh/uv/pull/7175))
- Use path file instead of `sitecustomize.py` ([#7161](https://github.com/astral-sh/uv/pull/7161))
- Replace incorrect `--source` and `--binary` flags with correct `--sdist` and `--wheel` flags in
  `uv build` ([#7156](https://github.com/astral-sh/uv/pull/7156))

### Documentation

- Document support for `UV_INSTALL_DIR` ([#7107](https://github.com/astral-sh/uv/pull/7107))
- List all supported sdist formats ([#7168](https://github.com/astral-sh/uv/pull/7168))

## 0.4.9

### Enhancements

- Add support for managed Python 3.13 ([#7263](https://github.com/astral-sh/uv/pull/7263))
- Upgrade managed CPython versions to latest patch releases
  ([#7263](https://github.com/astral-sh/uv/pull/7263))
- Allow setting a target version for `uv self update`
  ([#7252](https://github.com/astral-sh/uv/pull/7252))
- Create `py.typed` files during `uv init --lib`
  ([#7232](https://github.com/astral-sh/uv/pull/7232))
- Add a dedicated error for packages that fail due to `distutils` deprecation
  ([#7239](https://github.com/astral-sh/uv/pull/7239))
- Improve error message when requested Python version is unsupported
  ([#7269](https://github.com/astral-sh/uv/pull/7269))
- Add `uv run --no-sync` ([#7192](<(https://github.com/astral-sh/uv/pull/7192)>)

### Bug fixes

- Avoid updating `pyproject.toml` offsets on non-add edits
  ([#7262](https://github.com/astral-sh/uv/pull/7262))
- Invalidate cache when `--config-settings` change
  ([#7139](https://github.com/astral-sh/uv/pull/7139))
- Remove workspace root for single-member workspace with `uv export`
  ([#7254](https://github.com/astral-sh/uv/pull/7254))

## 0.4.10

### Enhancements

- Allow `uv tool upgrade --all` to continue on individual upgrade failure
  ([#7333](https://github.com/astral-sh/uv/pull/7333))
- Support globs as cache keys in `tool.uv.cache-keys`
  ([#7268](https://github.com/astral-sh/uv/pull/7268))
- Add Python package (`__main__.py`) support to `uv run`
  ([#7281](https://github.com/astral-sh/uv/pull/7281))
- Add zip application support to `uv run` ([#7289](https://github.com/astral-sh/uv/pull/7289))
- Add `--token` option to `self update` command ([#7279](https://github.com/astral-sh/uv/pull/7279))

### Performance

- Use `globwalk` for `cache-keys` matching ([#7337](https://github.com/astral-sh/uv/pull/7337))

### Bug fixes

- Always treat archive-like requirements as local files
  ([#7364](https://github.com/astral-sh/uv/pull/7364))
- Apply `--no-install` options when constructing resolution
  ([#7277](https://github.com/astral-sh/uv/pull/7277))
- Avoid clobbering existing `py.typed` files contents in `uv init`
  ([#7338](https://github.com/astral-sh/uv/pull/7338))
- Avoid enforcing platform compatibility when validating lockfile
  ([#7305](https://github.com/astral-sh/uv/pull/7305))
- Avoid installing transitive dev dependencies ([#7318](https://github.com/astral-sh/uv/pull/7318))
- Avoid selecting prerelease Python installations without opt-in
  ([#7300](https://github.com/astral-sh/uv/pull/7300))
- Fix PPC64 page size in binary builds. ([#7298](https://github.com/astral-sh/uv/pull/7298))
- Include pre-release Python versions in `uv python list`
  ([#7290](https://github.com/astral-sh/uv/pull/7290))
- Make version ID optional for source builds ([#7362](https://github.com/astral-sh/uv/pull/7362))
- Support relative paths in `uv add --script` ([#7301](https://github.com/astral-sh/uv/pull/7301))

### Documentation

- Fix documentation typos for `uv build --build-constraint` flag
  ([#7330](https://github.com/astral-sh/uv/pull/7330))
- Fix grammatical error in CLI docs ([#7353](https://github.com/astral-sh/uv/pull/7353))

### Error messages

- Add dedicated lock errors for wheel-only distributions
  ([#7307](https://github.com/astral-sh/uv/pull/7307))
- Avoid treating `.whl` sources as source distributions
  ([#7303](https://github.com/astral-sh/uv/pull/7303))
- Clarify Python requirement source for script incompatibilities
  ([#7339](https://github.com/astral-sh/uv/pull/7339))

## 0.4.11

### Enhancements

- Add `--no-editable` support to `uv sync` and `uv export`
  ([#7371](https://github.com/astral-sh/uv/pull/7371))
- Add support for `--only-dev` to `uv sync` and `uv export`
  ([#7367](https://github.com/astral-sh/uv/pull/7367))
- Add support for remaining pip-supported file extensions
  ([#7387](https://github.com/astral-sh/uv/pull/7387))
- Generate shell completion for `uvx` ([#7388](https://github.com/astral-sh/uv/pull/7388))
- Include `uv export` command in `requirements.txt` output
  ([#7374](https://github.com/astral-sh/uv/pull/7374))
- Prune unzipped source distributions in `uv cache prune --ci`
  ([#7446](https://github.com/astral-sh/uv/pull/7446))
- Warn when trying to `uv sync` a package without build configuration
  ([#7420](https://github.com/astral-sh/uv/pull/7420))
- Support requests for pre-releases in the `--python` option
  ([#7335](https://github.com/astral-sh/uv/pull/7335))

### Bug fixes

- Avoid erroneous version warning for `.dist-info` directories
  ([#7444](https://github.com/astral-sh/uv/pull/7444))
- Avoid removing seed packages for `uv venv --seed` environments
  ([#7410](https://github.com/astral-sh/uv/pull/7410))
- Avoid unnecessary progress bar initializations
  ([#7412](https://github.com/astral-sh/uv/pull/7412))
- Error when `tool.uv.sources` contains duplicate package names
  ([#7383](https://github.com/astral-sh/uv/pull/7383))
- Include `--branch` et al when resolving unnamed URLs in `uv add`
  ([#7447](https://github.com/astral-sh/uv/pull/7447))
- Include `dev-dependencies` in `--no-sources` invocations
  ([#7408](https://github.com/astral-sh/uv/pull/7408))
- Include the parent interpreter in Python discovery when `--system` is used
  ([#7440](https://github.com/astral-sh/uv/pull/7440))
- Respect `--no-sources` in PEP 723 scripts ([#7409](https://github.com/astral-sh/uv/pull/7409))
- Respect `pyproject.toml` credentials from user-provided requirements
  ([#7474](https://github.com/astral-sh/uv/pull/7474))
- Use consistent PyPI cache bucket ([#7443](https://github.com/astral-sh/uv/pull/7443))
- Use unambiguous relative paths in `uv export` ([#7378](https://github.com/astral-sh/uv/pull/7378))

### Documentation

- Add documentation on platform-specific dependencies
  ([#7411](https://github.com/astral-sh/uv/pull/7411))
- Add documentation for passing installer options on Linux
  ([#6839](https://github.com/astral-sh/uv/pull/6839))
- Separate project data from configuration settings
  ([#7053](https://github.com/astral-sh/uv/pull/7053))

### Error messages

- Hint at missing `project.name` ([#6803](https://github.com/astral-sh/uv/pull/6803))
- Surface dedicated `project.name` error for workspaces
  ([#7399](https://github.com/astral-sh/uv/pull/7399))
- Remove duplicate warning for settings discovery errors
  ([#7384](https://github.com/astral-sh/uv/pull/7384))

## 0.4.12

### Enhancements

- Allow users to provide pre-defined metadata for resolution
  ([#7442](https://github.com/astral-sh/uv/pull/7442))
- Invalidate existing tool environments on Python interpreter mismatch
  ([#7451](https://github.com/astral-sh/uv/pull/7451))

### Bug fixes

- Avoid fatal error when searching for egg-info with missing directory
  ([#7498](https://github.com/astral-sh/uv/pull/7498))

### Documentation

- Add note on cache growth for self-hosted GitHub runners
  ([#5757](https://github.com/astral-sh/uv/pull/5757))

## 0.4.13

### Enhancements

- Add `socks` support ([#7503](https://github.com/astral-sh/uv/pull/7503))
- Avoid warning about bad Python interpreter links for empty project environment directories
  ([#7527](https://github.com/astral-sh/uv/pull/7527))
- Improve invalid environment warning messages ([#7544](https://github.com/astral-sh/uv/pull/7544))
- Use more verbose spelling of "virtualenv" during creation
  ([#7523](https://github.com/astral-sh/uv/pull/7523))
- Do not use a user-facing warning for "Waiting to acquire lock..." message
  ([#7502](https://github.com/astral-sh/uv/pull/7502))

### Performance

- Use a single buffer for hints on resolver errors
  ([#7497](https://github.com/astral-sh/uv/pull/7497))

### Bug fixes

- Allow Python pre-releases to be used if they are first on the `PATH`
  ([#7470](https://github.com/astral-sh/uv/pull/7470))
- Avoid deleting the project environment directory if it is not a virtual environment
  ([#7522](https://github.com/astral-sh/uv/pull/7522))
- Do not error if the `CACHEDIR.TAG` file exists but cannot be written to
  ([#7550](https://github.com/astral-sh/uv/pull/7550))
- Treat invalid platform as more compatible than invalid Python
  ([#7556](https://github.com/astral-sh/uv/pull/7556))
- Use portable paths when serializing sources ([#7504](https://github.com/astral-sh/uv/pull/7504))
- Compute resolver hints using the final reduced derivation tree
  ([#7546](https://github.com/astral-sh/uv/pull/7546))
- Bump the wheel and sdist cache versions ([#7560](https://github.com/astral-sh/uv/pull/7560))
- Heal cache entries with missing source distributions
  ([#7559](https://github.com/astral-sh/uv/pull/7559))

### Rust libraries

- Bump minimum supported Rust version from 1.80 -> 1.81

### Documentation

- Add `UV_LINK_MODE` to Docker caching example ([#7510](https://github.com/astral-sh/uv/pull/7510))
- Clarify behavior of of overrides in CLI reference
  ([#7537](https://github.com/astral-sh/uv/pull/7537))

## 0.4.14

### Breaking

- Move uvx shell completion to `uvx --generate-shell-completion`
  ([#7511](https://github.com/astral-sh/uv/pull/7511))

### Enhancements

- Adjust messaging for frozen hint on resolution failure during `uv add`
  ([#7597](https://github.com/astral-sh/uv/pull/7597))
- Provide resolution hints in case of possible local name conflicts
  ([#7505](https://github.com/astral-sh/uv/pull/7505))
- Improve Docker image release tagging order and display on `ghcr.io`
  ([#7568](https://github.com/astral-sh/uv/pull/7568))
- Improve deserialization error messages ([#7598](https://github.com/astral-sh/uv/pull/7598))

### Bug fixes

- Allow system environments during project environment validity check
  ([#7585](https://github.com/astral-sh/uv/pull/7585))
- Avoid validating workspace members when `--no-sources` is provided
  ([#7599](https://github.com/astral-sh/uv/pull/7599))
- Fix handling of `sys.base_prefix` collision in interpreter identity check during tool installs
  ([#7596](https://github.com/astral-sh/uv/pull/7596))
- Make `uv cache prune` robust to unreadable rkyv entries
  ([#7561](https://github.com/astral-sh/uv/pull/7561))
- Revert "Remove duplicate warning for settings discovery errors (#7384)"
  ([#7594](https://github.com/astral-sh/uv/pull/7594))

### Documentation

- Fix `-` to `_` in packaged applications document
  ([#7571](https://github.com/astral-sh/uv/pull/7571))

## 0.4.15

### Bug fixes

- Revert "Treat invalid platform as more compatible than invalid Python (#7556)"
  ([#7608](https://github.com/astral-sh/uv/pull/7608))

### Documentation

- Add the execution policy to powershell installs for single versions
  ([#7602](https://github.com/astral-sh/uv/pull/7602))

## 0.4.16

### Enhancements

- Add `uv publish` ([#7475](https://github.com/astral-sh/uv/pull/7475))
- Add a `--project` argument to run a command from a project directory
  ([#7603](https://github.com/astral-sh/uv/pull/7603))
- Display Python implementation when creating environments
  ([#7652](https://github.com/astral-sh/uv/pull/7652))
- Implement trusted publishing for `uv publish` ([#7548](https://github.com/astral-sh/uv/pull/7548))
- Respect lockfile preferences for `--with` requirements
  ([#7627](https://github.com/astral-sh/uv/pull/7627))
- Unhide the `--directory` option ([#7653](https://github.com/astral-sh/uv/pull/7653))
- Allow requesting free-threaded Python interpreters
  ([#7431](https://github.com/astral-sh/uv/pull/7431))
- Show a dedicated PubGrub hint for `--unsafe-best-match`
  ([#7645](https://github.com/astral-sh/uv/pull/7645))
- Add resolver error checking for conflicting distributions
  ([#7595](https://github.com/astral-sh/uv/pull/7595))

### Bug fixes

- Avoid adding double-newlines for CRLF ([#7640](https://github.com/astral-sh/uv/pull/7640))
- Avoid retaining forks when `requires-python` range changes
  ([#7624](https://github.com/astral-sh/uv/pull/7624))
- Determine if pre-release Python downloads should be allowed using the version specifiers
  ([#7638](https://github.com/astral-sh/uv/pull/7638))
- Fix `link-mode=clone` for directories on Linux
  ([#7620](https://github.com/astral-sh/uv/pull/7620))
- Improve Python executable name discovery when using alternative implementations
  ([#7649](https://github.com/astral-sh/uv/pull/7649))
- Require opt-in to use alternative Python implementations
  ([#7650](https://github.com/astral-sh/uv/pull/7650))
- Use the first pre-release discovered when only pre-release Python versions are available
  ([#7666](https://github.com/astral-sh/uv/pull/7666))

### Documentation

- Document environment variable that disables printing of virtual environment name in prompt
  ([#7648](https://github.com/astral-sh/uv/pull/7648))
- Remove double whitespaces from the code ([#7623](https://github.com/astral-sh/uv/pull/7623))
- Use anchorlinks rather than permalinks ([#7626](https://github.com/astral-sh/uv/pull/7626))

### Preview features

- Add build backend scaffolding ([#7662](https://github.com/astral-sh/uv/pull/7662))

## 0.4.17

### Enhancements

- Add `uv build --all` to build all packages in a workspace
  ([#7724](https://github.com/astral-sh/uv/pull/7724))
- Add support for `uv init --script` ([#7565](https://github.com/astral-sh/uv/pull/7565))
- Add support for upgrading build environment for installed tools (`uv tool upgrade --python`)
  ([#7605](https://github.com/astral-sh/uv/pull/7605))
- Initialize a Git repository in `uv init` ([#5476](https://github.com/astral-sh/uv/pull/5476))
- Respect `--quiet` flag in `uv build` ([#7674](https://github.com/astral-sh/uv/pull/7674))
- Add context message before listing available tools in `uvx`
  ([#7641](https://github.com/astral-sh/uv/pull/7641))

### Bug fixes

- Don't create Python bytecode files during interpreter discovery
  ([#7707](https://github.com/astral-sh/uv/pull/7707))
- Escape glob patterns in workspace member discovery
  ([#7709](https://github.com/astral-sh/uv/pull/7709))
- Avoid prefetching source distributions with unbounded lower-bound ranges
  ([#7683](https://github.com/astral-sh/uv/pull/7683))

### Documentation

- Add `uv build` and `uv publish` to features overview
  ([#7716](https://github.com/astral-sh/uv/pull/7716))
- Add documentation on cache versioning ([#7693](https://github.com/astral-sh/uv/pull/7693))
- Spell out the names of the Docker images for easier copy-paste
  ([#7706](https://github.com/astral-sh/uv/pull/7706))
- Document uv-with-Jupyter workflows ([#7625](https://github.com/astral-sh/uv/pull/7625))
- Note that `uv lock --upgrade-package` retains locked versions
  ([#7694](https://github.com/astral-sh/uv/pull/7694))

## 0.4.18

### Enhancements

- Allow multiple source entries for each package in `tool.uv.sources`
  ([#7745](https://github.com/astral-sh/uv/pull/7745))
- Add `.gitignore` file to `uv build` output directory
  ([#7835](https://github.com/astral-sh/uv/pull/7835))
- Disable jemalloc on FreeBSD ([#7780](https://github.com/astral-sh/uv/pull/7780))
- Respect `PAGER` env var when paging in `uv help` command
  ([#5511](https://github.com/astral-sh/uv/pull/5511))
- Support `uv run -m foo` to run a module ([#7754](https://github.com/astral-sh/uv/pull/7754))
- Use a top-level output directory for `uv build` in workspaces
  ([#7813](https://github.com/astral-sh/uv/pull/7813))
- Update `uv init --package` command to match project name
  ([#7670](https://github.com/astral-sh/uv/pull/7670))
- Add a custom suggestion for `uv add dotenv` ([#7799](https://github.com/astral-sh/uv/pull/7799))
- Add detailed errors for `tool.uv.sources` deserialization failures
  ([#7823](https://github.com/astral-sh/uv/pull/7823))
- Improve error message copy for failed builds ([#7849](https://github.com/astral-sh/uv/pull/7849))
- Use `serde-untagged` to improve some untagged enum error messages
  ([#7822](https://github.com/astral-sh/uv/pull/7822))
- Use build failure hints for `dotenv` errors, rather than in `uv add`
  ([#7825](https://github.com/astral-sh/uv/pull/7825))

### Configuration

- Add `UV_NO_SYNC` environment variable ([#7752](https://github.com/astral-sh/uv/pull/7752))

### Bug fixes

- Accept `git+` prefix in `tool.uv.sources` ([#7847](https://github.com/astral-sh/uv/pull/7847))
- Allow spaces in path requirements ([#7767](https://github.com/astral-sh/uv/pull/7767))
- Avoid reusing cached downloaded binaries with `--no-binary`
  ([#7772](https://github.com/astral-sh/uv/pull/7772))
- Correctly trims values during wheel WHEEL file parsing
  ([#7770](https://github.com/astral-sh/uv/pull/7770))
- Fix `uv tree --invert` for platform dependencies
  ([#7808](https://github.com/astral-sh/uv/pull/7808))
- Fix encoding mismatch between python child process and uv
  ([#7757](https://github.com/astral-sh/uv/pull/7757))
- Reject self-dependencies in `uv add` ([#7766](https://github.com/astral-sh/uv/pull/7766))
- Respect `tool.uv.environments` for legacy virtual workspace roots
  ([#7824](https://github.com/astral-sh/uv/pull/7824))
- Retain empty extras on workspace members ([#7762](https://github.com/astral-sh/uv/pull/7762))
- Use file stem when parsing cached wheel names ([#7773](https://github.com/astral-sh/uv/pull/7773))

### Rust API

- Make `FlatDistributions` public ([#7833](https://github.com/astral-sh/uv/pull/7833))

### Documentation

- Fix table of contents sizing ([#7751](https://github.com/astral-sh/uv/pull/7751))
- GitLab Integration documentation ([#6857](https://github.com/astral-sh/uv/pull/6857))
- Update documentation to setup-uv@v3 ([#7807](https://github.com/astral-sh/uv/pull/7807))
- Use `uv publish` instead of twine in docs ([#7837](https://github.com/astral-sh/uv/pull/7837))
- Fix typo in `projects.md` ([#7784](https://github.com/astral-sh/uv/pull/7784))

## 0.4.19

### Enhancements

- Add managed downloads for CPython 3.13.0rc3 and 3.12.7
  ([#7880](https://github.com/astral-sh/uv/pull/7880))
- Display the target virtual environment path if non-default
  ([#7850](https://github.com/astral-sh/uv/pull/7850))
- Preserve case-insensitive sorts in `uv add` ([#7864](https://github.com/astral-sh/uv/pull/7864))
- Respect project upper bounds when filtering wheels on `requires-python`
  ([#7904](https://github.com/astral-sh/uv/pull/7904))
- Add `--script` to `uv run` to treat an input as PEP 723 regardless of extension
  ([#7739](https://github.com/astral-sh/uv/pull/7739))
- Improve legibility of build failure errors ([#7854](https://github.com/astral-sh/uv/pull/7854))
- Show interpreter source during Python discovery query errors
  ([#7928](https://github.com/astral-sh/uv/pull/7928))

### Configuration

- Add `UV_FIND_LINKS` environment variable for `--find-links`
  ([#7912](https://github.com/astral-sh/uv/pull/7912))
- Ignore empty string values for `UV_PYTHON` environment variable
  ([#7878](https://github.com/astral-sh/uv/pull/7878))

### Bug fixes

- Allow `py3x-none` tags in newer than Python 3.x
  ([#7867](https://github.com/astral-sh/uv/pull/7867))
- Allow self-dependencies in the `dev` section ([#7943](https://github.com/astral-sh/uv/pull/7943))
- Always ignore `cp2` wheels in resolution ([#7902](https://github.com/astral-sh/uv/pull/7902))
- Clear the publish progress bar on retry ([#7921](https://github.com/astral-sh/uv/pull/7921))
- Fix parsing of `gnueabi` libc variants in Python version requests
  ([#7975](https://github.com/astral-sh/uv/pull/7975))
- Simplify supported environments when comparing to lockfile
  ([#7894](https://github.com/astral-sh/uv/pull/7894))
- Trim commits when reading from Git refs ([#7922](https://github.com/astral-sh/uv/pull/7922))
- Use a higher HTTP read timeout when publishing packages
  ([#7923](https://github.com/astral-sh/uv/pull/7923))
- Remove the first empty line for `uv tree --package foo`
  ([#7885](https://github.com/astral-sh/uv/pull/7885))

### Documentation

- Add 3.13 support to the platform reference ([#7971](https://github.com/astral-sh/uv/pull/7971))
- Clarify project environment creation ([#7941](https://github.com/astral-sh/uv/pull/7941))
- Fix code block title in Gitlab integration docs
  ([#7861](https://github.com/astral-sh/uv/pull/7861))
- Fix project guide section on adding a Git dependency
  ([#7916](https://github.com/astral-sh/uv/pull/7916))
- Fix uninstallation command for Windows ([#7944](https://github.com/astral-sh/uv/pull/7944))
- Clearly specify the minimum supported Windows Server version
  ([#7946](https://github.com/astral-sh/uv/pull/7946))

### Rust API

- Remove unused `Sha256Reader` ([#7929](https://github.com/astral-sh/uv/pull/7929))
- Remove unnecessary `Deserialize` derives on settings
  ([#7856](https://github.com/astral-sh/uv/pull/7856))

## 0.4.20

### Enhancements

- Add managed downloads for CPython 3.13.0 (final)
  ([#8010](https://github.com/astral-sh/uv/pull/8010))
- Python 3.13 is the default version for `uv python install`
  ([#8010](https://github.com/astral-sh/uv/pull/8010))
- Hint at wrong endpoint in `uv publish` failures
  ([#7872](https://github.com/astral-sh/uv/pull/7872))
- List available scripts when a command is not specified for `uv run`
  ([#7687](https://github.com/astral-sh/uv/pull/7687))
- Fill in `authors` field during `uv init` ([#7756](https://github.com/astral-sh/uv/pull/7756))

### Documentation

- Add snapshot testing to contribution guide ([#7882](https://github.com/astral-sh/uv/pull/7882))
- Fix and improve GitLab integration docs ([#8000](https://github.com/astral-sh/uv/pull/8000))

## 0.4.21

### Enhancements

- Add support for managed installations of free-threaded Python
  ([#8100](https://github.com/astral-sh/uv/pull/8100))
- Add note about `uvx` to `uv tool run` short help
  ([#7695](https://github.com/astral-sh/uv/pull/7695))
- Enable HTTP/2 requests ([#8049](https://github.com/astral-sh/uv/pull/8049))
- Support `uv tree --no-dev` ([#8109](https://github.com/astral-sh/uv/pull/8109))
- Support PEP 723 metadata with `uv run -` ([#8111](https://github.com/astral-sh/uv/pull/8111))
- Support `pip install --exact` ([#8044](https://github.com/astral-sh/uv/pull/8044))
- Support `uv export --no-header` ([#8096](https://github.com/astral-sh/uv/pull/8096))
- Add Python 3.13 images to Docker publish ([#8105](https://github.com/astral-sh/uv/pull/8105))
- Support remote (`https://`) scripts in `uv run`
  ([#6375](https://github.com/astral-sh/uv/pull/6375))
- Allow comma value-delimited arguments in `uv run --with`
  ([#7909](https://github.com/astral-sh/uv/pull/7909))

### Configuration

- Support wildcards in `UV_INSECURE_HOST` ([#8052](https://github.com/astral-sh/uv/pull/8052))

### Performance

- Use shared index when fetching metadata in lock satisfaction routine
  ([#8147](https://github.com/astral-sh/uv/pull/8147))

### Bug fixes

- Add prerelease compatibility check to `uv python` CLI
  ([#8020](https://github.com/astral-sh/uv/pull/8020))
- Avoid deleting a project environment directory if we cannot tell if a `pyvenv.cfg` file exists
  ([#8012](https://github.com/astral-sh/uv/pull/8012))
- Avoid excluding valid wheels for exact `requires-python` bounds
  ([#8140](https://github.com/astral-sh/uv/pull/8140))
- Bump `netrc` crate to latest commit ([#8021](https://github.com/astral-sh/uv/pull/8021))
- Fix `uv python pin 3.13t` failure when parsing version for project requires check
  ([#8056](https://github.com/astral-sh/uv/pull/8056))
- Fix handling of != intersections in `requires-python`
  ([#7897](https://github.com/astral-sh/uv/pull/7897))
- Remove the newly created tool environment if sync failed
  ([#8038](https://github.com/astral-sh/uv/pull/8038))
- Respect dynamic extras in `uv lock` and `uv sync`
  ([#8091](https://github.com/astral-sh/uv/pull/8091))
- Treat resolver failures as fatal in lockfile validation
  ([#8083](https://github.com/astral-sh/uv/pull/8083))
- Use `git config --get` for author information for improved backwards compatibility
  ([#8101](https://github.com/astral-sh/uv/pull/8101))
- Use comma-separated values for `UV_FIND_LINKS`
  ([#8061](https://github.com/astral-sh/uv/pull/8061))
- Use shared resolver state between add and lock to avoid double Git update
  ([#8146](https://github.com/astral-sh/uv/pull/8146))
- Make `--relocatable` entrypoints robust to symlinking
  ([#8079](https://github.com/astral-sh/uv/pull/8079))
- Improve compatibility with VSCode PS1 prompt ([#8006](https://github.com/astral-sh/uv/pull/8006))
- Fix "Stream did not contain valid UTF-8" failures in Windows
  ([#8120](https://github.com/astral-sh/uv/pull/8120))
- Use `--with-requirements` in `uvx` error hint ([#8112](https://github.com/astral-sh/uv/pull/8112))

### Documentation

- Include `uvx` installation in Docker examples ([#8179](https://github.com/astral-sh/uv/pull/8179))
- Make the instructions for the Windows standalone installer consistent across README and
  documentation ([#8125](https://github.com/astral-sh/uv/pull/8125))
- Update pip compatibility guide to note transitive URL dependency support
  ([#8081](https://github.com/astral-sh/uv/pull/8081))
- Document `--reinstall` with `--exclude-newer` to ensure downgrades
  ([#6721](https://github.com/astral-sh/uv/pull/6721))

## 0.4.22

### Enhancements

- Respect `[tool.uv.sources]` in build requirements
  ([#7172](https://github.com/astral-sh/uv/pull/7172))

### Preview features

- Add a dedicated `uv publish` error message for missing usernames
  ([#8045](https://github.com/astral-sh/uv/pull/8045))
- Support interactive input in `uv publish` ([#8158](https://github.com/astral-sh/uv/pull/8158))
- Use raw filenames in `uv publish` ([#8204](https://github.com/astral-sh/uv/pull/8204))

### Performance

- Reuse the result of `which git` ([#8224](https://github.com/astral-sh/uv/pull/8224))

### Bug fixes

- Avoid environment check optimization for `uv pip install --exact`
  ([#8219](https://github.com/astral-sh/uv/pull/8219))
- Do not use free-threaded interpreters without a free-threaded request
  ([#8191](https://github.com/astral-sh/uv/pull/8191))
- Don't recommend `--prerelease=allow` during build requirement resolution errors
  ([#8192](https://github.com/astral-sh/uv/pull/8192))
- Prefer optimized builds for free-threaded Python downloads
  ([#8196](https://github.com/astral-sh/uv/pull/8196))
- Retain old `python-build-standalone` releases ([#8216](https://github.com/astral-sh/uv/pull/8216))
- Run `uv build` builds in the source distribution bucket
  ([#8220](https://github.com/astral-sh/uv/pull/8220))

## 0.4.23

This release introduces a revamped system for defining package indexes, as an alternative to the
existing pip-style `--index-url` and `--extra-index-url` configuration options.

You can now define named indexes in your `pyproject.toml` file using the `[[tool.uv.index]]` table:

```toml
[[tool.uv.index]]
name = "pytorch"
url = "https://download.pytorch.org/whl/cpu"
```

Packages can be pinned to a specific index via `tool.uv.sources`, to ensure that a given package is
installed from the correct index. For example, to ensure that `torch` is _always_ installed from the
`pytorch` index:

```toml
[tool.uv.sources]
torch = { index = "pytorch" }

[[tool.uv.index]]
name = "pytorch"
url = "https://download.pytorch.org/whl/cpu"
```

Indexes can also be marked as `explicit = true` to prevent packages from being installed from that
index unless explicitly pinned. For example, to ensure that `torch` is installed from the `pytorch`
index, but all other packages are installed from the default index:

```toml
[tool.uv.sources]
torch = { index = "pytorch" }

[[tool.uv.index]]
name = "pytorch"
url = "https://download.pytorch.org/whl/cpu"
explicit = true
```

To define an additional index outside a `pyproject.toml` file, use the `--index` command-line
argument (or the `UV_INDEX` environment variable); to replace the default index (PyPI), use the
`--default-index` command-line argument (or `UV_DEFAULT_INDEX`).

These changes are entirely backwards-compatible with the deprecated `--index-url` and
`--extra-index-url` options, which continue to work as before.

See the [Index](https://docs.astral.sh/uv/concepts/indexes/) documentation for more.

### Enhancements

- Add index URLs when provided via `uv add --index` or `--default-index`
  ([#7746](https://github.com/astral-sh/uv/pull/7746))
- Add support for named and explicit indexes ([#7481](https://github.com/astral-sh/uv/pull/7481))
- Add templates for popular build backends ([#7857](https://github.com/astral-sh/uv/pull/7857))
- Allow multiple pinned indexes in `tool.uv.sources`
  ([#7769](https://github.com/astral-sh/uv/pull/7769))
- Allow users to incorporate Git tags into dynamic cache keys
  ([#8259](https://github.com/astral-sh/uv/pull/8259))
- Pin named indexes in `uv add` ([#7747](https://github.com/astral-sh/uv/pull/7747))
- Respect named `--index` and `--default-index` values in `tool.uv.sources`
  ([#7910](https://github.com/astral-sh/uv/pull/7910))
- Update to latest PubGrub version ([#8245](https://github.com/astral-sh/uv/pull/8245))
- Enable environment variable authentication for named indexes
  ([#7741](https://github.com/astral-sh/uv/pull/7741))
- Avoid showing lower-bound warning outside of explicit lock and sync
  ([#8234](https://github.com/astral-sh/uv/pull/8234))
- Improve logging during lock errors ([#8258](https://github.com/astral-sh/uv/pull/8258))
- Improve styling of `requires-python` warnings ([#8240](https://github.com/astral-sh/uv/pull/8240))
- Show hint in resolution failure on `Forbidden` (`403`) or `Unauthorized` (`401`)
  ([#8264](https://github.com/astral-sh/uv/pull/8264))
- Update to latest `cargo-dist` version (includes new installer features)
  ([#8270](https://github.com/astral-sh/uv/pull/8270))
- Warn when patch version in `requires-python` is implicitly `0`
  ([#7959](https://github.com/astral-sh/uv/pull/7959))
- Add more context on client errors during range requests
  ([#8285](https://github.com/astral-sh/uv/pull/8285))

### Bug fixes

- Avoid writing duplicate index URLs with `--emit-index-url`
  ([#8226](https://github.com/astral-sh/uv/pull/8226))
- Fix error leading to out-of-bound panic in `uv-pep508`
  ([#8282](https://github.com/astral-sh/uv/pull/8282))
- Fix managed distributions of free-threaded Python on Windows
  ([#8268](https://github.com/astral-sh/uv/pull/8268))
- Fix selection of free-threaded interpreters during default Python discovery
  ([#8239](https://github.com/astral-sh/uv/pull/8239))
- Ignore sources in build requirements for non-source trees
  ([#8235](https://github.com/astral-sh/uv/pull/8235))
- Invalid cache when adding lower bound to lockfile
  ([#8230](https://github.com/astral-sh/uv/pull/8230))
- Respect index priority when storing credentials
  ([#8256](https://github.com/astral-sh/uv/pull/8256))
- Respect relative paths in `uv build` sources ([#8237](https://github.com/astral-sh/uv/pull/8237))
- Narrow what the pip3.<minor> logic drops from entry points.
  ([#8273](https://github.com/astral-sh/uv/pull/8273))

### Documentation

- Add some additional notes to `--index-url` docs
  ([#8267](https://github.com/astral-sh/uv/pull/8267))
- Add upgrade note to README ([#7937](https://github.com/astral-sh/uv/pull/7937))
- Remove note that "only a single source may be defined for each dependency"
  ([#8243](https://github.com/astral-sh/uv/pull/8243))

## 0.4.24

### Bug fixes

- Fix Python executable name in Windows free-threaded Python distributions
  ([#8310](https://github.com/astral-sh/uv/pull/8310))
- Redact index credentials from lockfile sources
  ([#8307](https://github.com/astral-sh/uv/pull/8307))
- Respect `UV_INDEX_` rather than `UV_HTTP_BASIC_` as documented
  ([#8306](https://github.com/astral-sh/uv/pull/8306))
- Improve sources deserialization errors ([#8308](https://github.com/astral-sh/uv/pull/8308))

### Documentation

- Correct pytorch-to-torch reference in docs ([#8291](https://github.com/astral-sh/uv/pull/8291))

## 0.4.25

### Enhancements

- Add support for `uv pip show --files` ([#8369](https://github.com/astral-sh/uv/pull/8369))
- Don't prefetch unreachable packages ([#8246](https://github.com/astral-sh/uv/pull/8246))
- Remove `tool.uv.sources` table if it is empty ([#8365](https://github.com/astral-sh/uv/pull/8365))
- Modify cache versioning to support backwards compatibility
  ([#8386](https://github.com/astral-sh/uv/pull/8386))

### Configuration

- Add support for `UV_FROZEN` and `UV_LOCKED` ([#8340](https://github.com/astral-sh/uv/pull/8340))

### Bug fixes

- Allow dashes and underscores in custom index names
  ([#8339](https://github.com/astral-sh/uv/pull/8339))
- Avoid panic when Git dependencies are included in fork markers
  ([#8388](https://github.com/astral-sh/uv/pull/8388))
- Check existing source by normalized name before `uv add` and `uv remove`
  ([#8359](https://github.com/astral-sh/uv/pull/8359))
- Fix bug where username from authentication cache could be ignored
  ([#8345](https://github.com/astral-sh/uv/pull/8345))
- Fix to respect comments positioning in pyproject.toml on change
  ([#8384](https://github.com/astral-sh/uv/pull/8384))
- Redact index sources in `uv.lock` ([#8333](https://github.com/astral-sh/uv/pull/8333))
- Use correct indentation when project table contains open bracket comment
  ([#8387](https://github.com/astral-sh/uv/pull/8387))
- Only remove a source from `[tool.uv.sources]` if it is no long being referenced
  ([#8366](https://github.com/astral-sh/uv/pull/8366))
- Modify `uv pip list` and `uv tree` to print to stdout regardless of `--quiet` flag
  ([#8392](https://github.com/astral-sh/uv/pull/8392))

### Error messages

- Improve help message for missing `self update` invocations
  ([#8337](https://github.com/astral-sh/uv/pull/8337))
- Log `.netrc` parsing errors ([#8364](https://github.com/astral-sh/uv/pull/8364))
- Remove trailing newlines in error messages ([#8322](https://github.com/astral-sh/uv/pull/8322))
- Use a dedicated message for incompatible Python versions in wheel ABI tags
  ([#8363](https://github.com/astral-sh/uv/pull/8363))
- Remove commands available in the top-level from the suggested subcommand error
  ([#8316](https://github.com/astral-sh/uv/pull/8316))

### Release

- Run release builds for `macos-x86_64` on `macos-14` runners
  ([#8327](https://github.com/astral-sh/uv/pull/8327))

## 0.4.26

### Enhancements

- Allow static dependency metadata entries for direct URL requirements
  ([#7846](https://github.com/astral-sh/uv/pull/7846))
- Use reinstall report formatting for `uv python install --reinstall`
  ([#8487](https://github.com/astral-sh/uv/pull/8487))
- Add support for system-level `uv.toml` configuration
  ([#7851](https://github.com/astral-sh/uv/pull/7851))

### Bug fixes

- Apply `requires-python` narrowing with upper bounds
  ([#8403](https://github.com/astral-sh/uv/pull/8403))
- Avoid rewriting `[[tool.uv.index]]` entries when credentials are provided
  ([#8502](https://github.com/astral-sh/uv/pull/8502))
- Fix `uv add` comment handling for empty arrays
  ([#8504](https://github.com/astral-sh/uv/pull/8504))
- Replace dashes with underscores in index credential variables
  ([#8452](https://github.com/astral-sh/uv/pull/8452))
- Respect `--allow-insecure-host` in `uv publish`
  ([#8440](https://github.com/astral-sh/uv/pull/8440))
- Allow arbitrary `--package` includes in `uv tree`
  ([#8507](https://github.com/astral-sh/uv/pull/8507))
- Remove existing Python install after successful download in `uv python install`
  ([#8485](https://github.com/astral-sh/uv/pull/8485))

### Documentation

- Add docs example for URLs with `[tool.uv.dependency-metadata]`
  ([#8484](https://github.com/astral-sh/uv/pull/8484))
- Add help page for build failures ([#8286](https://github.com/astral-sh/uv/pull/8286))
- Fix `cache-keys` typo in `tags = true` ([#8422](https://github.com/astral-sh/uv/pull/8422))
- Add documentation examples for manual branch, rev, and tag Git dependencies
  ([#8497](https://github.com/astral-sh/uv/pull/8497))

### Error messages

- Improve error message for cache info serialization
  ([#8500](https://github.com/astral-sh/uv/pull/8500))
- Suggest `--from` command when executable is available for `uvx`
  ([#8473](https://github.com/astral-sh/uv/pull/8473))
- Support `--with-editable` in `uv tool install`
  ([#8472](https://github.com/astral-sh/uv/pull/8472))

## 0.4.27

This release includes support for the `[dependency-groups]` table as recently standardized in
[PEP 735](https://peps.python.org/pep-0735/). The table allows for declaration of optional
dependency groups that are not published as part of the package metadata, unlike
`[project.optional-dependencies]`. There are new `--group`, `--only-group`, and `--no-group` options
throughout the uv interface.

Previously, uv used a single `tool.uv.dev-dependencies` list for declaration of development
dependencies. Now, uv supports declaring development dependencies in a standardized format and
allows splitting development dependencies into multiple groups.

For compatibility, and to simplify usage for people that do not need multiple groups, uv
special-cases the group named `dev`. The `dev` group is equivalent to `tool.uv.dev-dependencies`.
The contents of `tool.uv.dev-dependencies` will merged into the `dev` group in uv's resolver. The
`--dev`, `--only-dev`, and `--no-dev` flags remain as aliases for the corresponding `--group`
options. Support for `tool.uv.dev-dependencies` remains in this release, but will display warnings
in a future release.

uv syncs the `dev` group by default — this matches the existing behavior for
`tool.uv.dev-dependencies`. The default groups can be changed with the `tool.uv.default-groups`
setting.

Thank you to Stephen Rosen who authored PEP 735.

### Enhancements

- Support for PEP 735 ([#8272](https://github.com/astral-sh/uv/pull/8272))
- Add support for `--dry-run` mode in `uv lock` ([#7783](https://github.com/astral-sh/uv/pull/7783))
- Don't allow non-string email in authors ([#8520](https://github.com/astral-sh/uv/pull/8520))
- Enforce lockfile schema versions ([#8509](https://github.com/astral-sh/uv/pull/8509))

### Bug fixes

- Always attach URL to network errors ([#8444](https://github.com/astral-sh/uv/pull/8444))
- Fix dangling non-platform dependencies in `uv tree`
  ([#8532](https://github.com/astral-sh/uv/pull/8532))
- Prefer `lto` over `debug` free-threaded managed Python builds
  ([#8515](https://github.com/astral-sh/uv/pull/8515))

### Documentation

- Add `tool.uv.sources` to the "Settings" reference
  ([#8543](https://github.com/astral-sh/uv/pull/8543))
- Add reference to `uv build` and `uv publish` in the landing pages
  ([#8542](https://github.com/astral-sh/uv/pull/8542))
- Avoid duplicate `[tool.uv]` header in TOML examples
  ([#8545](https://github.com/astral-sh/uv/pull/8545))
- Document `.netrc` environment variable and path
  ([#8511](https://github.com/astral-sh/uv/pull/8511))
- Fix `.netrc` typo in authentication docs ([#8521](https://github.com/astral-sh/uv/pull/8521))
- Fix heading level of "Script support" on docs landing page
  ([#8544](https://github.com/astral-sh/uv/pull/8544))
- Move the installation configuration docs to a separate page
  ([#8546](https://github.com/astral-sh/uv/pull/8546))
- Update docs for `--publish-url` to avoid duplication.
  ([#8561](https://github.com/astral-sh/uv/pull/8561))
- Fix typo ([#8554](https://github.com/astral-sh/uv/pull/8554))
- Fix typo in description of `--strict` flag ([#8513](https://github.com/astral-sh/uv/pull/8513))

## 0.4.28

### Enhancements

- Add support for requesting free-threaded builds via `+freethreaded`
  ([#8645](https://github.com/astral-sh/uv/pull/8645))
- Improve trusted publishing error messages ([#8633](https://github.com/astral-sh/uv/pull/8633))
- Remove unneeded `return` from Maturin project template
  ([#8604](https://github.com/astral-sh/uv/pull/8604))
- Skip Python interpreter discovery for `uv export`
  ([#8638](https://github.com/astral-sh/uv/pull/8638))
- Hint about missing trusted publishing permission
  ([#8632](https://github.com/astral-sh/uv/pull/8632))

### Configuration

- Add environment variable to disable progress output
  ([#8600](https://github.com/astral-sh/uv/pull/8600))

### Bug fixes

- Fork when minimum Python version increases ([#8628](https://github.com/astral-sh/uv/pull/8628))
- Ignore empty groups when validating lock ([#8598](https://github.com/astral-sh/uv/pull/8598))
- Remove duplicate word in error message ([#8589](https://github.com/astral-sh/uv/pull/8589))
- Support cyclic dependencies in `uv tree` ([#8564](https://github.com/astral-sh/uv/pull/8564))
- Update `uv init` to imply `--package` when using `--build-backend`
  ([#8593](https://github.com/astral-sh/uv/pull/8593))
- Restore use of `dev-dependencies` and `requires-dev` for lockfile compatibility
  ([#8599](https://github.com/astral-sh/uv/pull/8599))

### Documentation

- Clarify `requires-python` requirement for dependencies
  ([#8619](https://github.com/astral-sh/uv/pull/8619))
- Update CLI documentation for `--cache-dir` ([#8627](https://github.com/astral-sh/uv/pull/8627))

## 0.4.29

### Enhancements

- Sort errors during display in `uv python install`
  ([#8684](https://github.com/astral-sh/uv/pull/8684))
- Update resolver to use disjointness checks instead of marker equality
  ([#8661](https://github.com/astral-sh/uv/pull/8661))
- Add `riscv64` to supported Python platform tags
  ([#8660](https://github.com/astral-sh/uv/pull/8660))

### Bug fixes

- Fix hard and soft float libc detection for managed Python distributions on ARM
  ([#8498](https://github.com/astral-sh/uv/pull/8498))
- Handle cycles in `uv pip tree` ([#8689](https://github.com/astral-sh/uv/pull/8689))
- Respect dependency group markers in `uv export`
  ([#8659](https://github.com/astral-sh/uv/pull/8659))
- Support transitive dependencies in Git workspaces
  ([#8665](https://github.com/astral-sh/uv/pull/8665))
- Use portable paths for subdirectories in lock URLs
  ([#8707](https://github.com/astral-sh/uv/pull/8707))
- Update `uv init --virtual` to imply `--no-package`
  ([#8595](https://github.com/astral-sh/uv/pull/8595))

### Preview

- Install versioned Python executables into the bin directory during `uv python install` (Unix only)
  ([#8458](https://github.com/astral-sh/uv/pull/8458))

### Documentation

- Clarify relationship between specifiers and `requires-python` range
  ([#8688](https://github.com/astral-sh/uv/pull/8688))
- Fix broken link in docs ([#8552](https://github.com/astral-sh/uv/pull/8552))
- Fix outdated documentation on `Requires-Python`
  ([#8679](https://github.com/astral-sh/uv/pull/8679))
- Add Google Artifact Registry index authentication guide
  ([#8579](https://github.com/astral-sh/uv/pull/8579))

## 0.4.30

### Enhancements

- Add support for `.env` and custom env files in `uv run`
  ([#8811](https://github.com/astral-sh/uv/pull/8811))
- Add support for `--all-packages` in `uv run`, `uv sync`, and `uv export`
  ([#8742](https://github.com/astral-sh/uv/pull/8742),
  [#8741](https://github.com/astral-sh/uv/pull/8741),
  [#8739](https://github.com/astral-sh/uv/pull/8739))
- Allow use of `--frozen` with `--all-packages` in `uv sync` and `uv export`
  ([#8760](https://github.com/astral-sh/uv/pull/8760))
- Show full error chain on tool upgrade failures
  ([#8753](https://github.com/astral-sh/uv/pull/8753))
- Add `--check-url` to `uv publish` to check for existing distributions during upload
  ([#8531](https://github.com/astral-sh/uv/pull/8531))
- Suggest using `--check-url` when `--skip-existing` is used
  ([#8803](https://github.com/astral-sh/uv/pull/8803))

### Bug fixes

- Allow incompatible `requires-python` for source distributions with static metadata
  ([#8768](https://github.com/astral-sh/uv/pull/8768))
- Allow managed downloads with `--python-preference system`
  ([#8808](https://github.com/astral-sh/uv/pull/8808))
- Avoid error for `--group` defined in non-root workspace member
  ([#8734](https://github.com/astral-sh/uv/pull/8734))
- Avoid showing dependency group annotations on workspace members in tree
  ([#8730](https://github.com/astral-sh/uv/pull/8730))
- Do not error when the Python bin directory is missing on `uv python uninstall`
  ([#8725](https://github.com/astral-sh/uv/pull/8725))
- Include member groups when locking workspace ([#8736](https://github.com/astral-sh/uv/pull/8736))
- Fix bug where `python_version < '0'` could appear in a final resolution
  ([#8759](https://github.com/astral-sh/uv/pull/8759))
- Sanitize filenames during zip extraction ([#8732](https://github.com/astral-sh/uv/pull/8732))
- Switch to RFC 9110 compatible format for exclude newer requests
  ([#8752](https://github.com/astral-sh/uv/pull/8752))

### Preview features

- Add support for installing versioned Python executables on Windows
  ([#8663](https://github.com/astral-sh/uv/pull/8663))
- Improve interactions with existing Python executables during install
  ([#8733](https://github.com/astral-sh/uv/pull/8733))

### Rust API

- Extend `BaseClient` to accept extra middleware
  ([#8807](https://github.com/astral-sh/uv/pull/8807))
- Add `From` for `FlatDistributions` struct ([#8800](https://github.com/astral-sh/uv/pull/8800))

### Documentation

- Fix environment variable name in providing credentials section
  ([#8740](https://github.com/astral-sh/uv/pull/8740))
- Fix `add httpx` example with real git branch ([#8756](https://github.com/astral-sh/uv/pull/8756))
- Fix indentation in `projects.md` ([#8772](https://github.com/astral-sh/uv/pull/8772))
- Fix link to publish guide in `README` ([#8720](https://github.com/astral-sh/uv/pull/8720))
- Generate environment variables documentation from code
  ([#8493](https://github.com/astral-sh/uv/pull/8493))
- Improve and fix some documents ([#8749](https://github.com/astral-sh/uv/pull/8749))
- Improve environment variables document ([#8777](https://github.com/astral-sh/uv/pull/8777))
