<?php
/**
 * Internationalisation file for extension CategoryTree.
 *
 * @file
 * @ingroup Extensions
 * @author Daniel Kinzler, brightbyte.de
 * @copyright © 2006-2008 Daniel Kinzler
 * @license GPL-2.0-or-later
 */

$magicWords = [];

/** English (English) */
$magicWords['en'] = [
	'categorytree' => [ 0, 'categorytree' ],
];

/** Afrikaans (Afrikaans) */
$magicWords['af'] = [
	'categorytree' => [ 0, 'kategorieboom', 'categorytree' ],
];

/** Arabic (العربية) */
$magicWords['ar'] = [
	'categorytree' => [ 0, 'شجرة_تصنيف' ],
];

/** Egyptian Arabic (مصرى) */
$magicWords['arz'] = [
	'categorytree' => [ 0, 'شجرة_تصنيف' ],
];

/** Bengali (বাংলা) */
$magicWords['bn'] = [
	'categorytree' => [ 0, 'বিষয়শ্রেণী_বৃক্ষ', 'বিষয়শ্রেণীবৃক্ষ', 'categorytree' ],
];

/** Breton (brezhoneg) */
$magicWords['br'] = [
	'categorytree' => [ 0, 'GwezennadurRummad' ],
];

/** Chechen (нохчийн) */
$magicWords['ce'] = [
	'categorytree' => [ 0, 'категоридит', 'деревокатегорий' ],
];

/** German (Deutsch) */
$magicWords['de'] = [
	'categorytree' => [ 0, 'kategorienbaum', 'kategoriebaum' ],
];

/** Zazaki (Zazaki) */
$magicWords['diq'] = [
	'categorytree' => [ 0, 'darakategori' ],
];

/** Esperanto (Esperanto) */
$magicWords['eo'] = [
	'categorytree' => [ 0, 'kategoriarbo' ],
];

/** Spanish (español) */
$magicWords['es'] = [
	'categorytree' => [ 0, 'árboldecategorías', 'arboldecategorias' ],
];

/** Estonian (eesti) */
$magicWords['et'] = [
	'categorytree' => [ 0, 'kategooriapuu' ],
];

/** Persian (فارسی) */
$magicWords['fa'] = [
	'categorytree' => [ 0, 'درخت‌رده', 'درخت_رده' ],
];

/** French (français) */
$magicWords['fr'] = [
	'categorytree' => [ 0, 'arbrecatégories', 'arbrecats' ],
];

/** Western Frisian (Frysk) */
$magicWords['fy'] = [
	'categorytree' => [ 0, 'kategorybeam' ],
];

/** Galician (galego) */
$magicWords['gl'] = [
	'categorytree' => [ 0, 'árboredecategorías' ],
];

/** Hebrew (עברית) */
$magicWords['he'] = [
	'categorytree' => [ 0, 'עץ_קטגוריה' ],
];

/** Hindi (हिन्दी) */
$magicWords['hi'] = [
	'categorytree' => [ 0, 'श्रेणी_वृक्ष' ],
];

/** Igbo (Igbo) */
$magicWords['ig'] = [
	'categorytree' => [ 0, 'óshíshíébéonọr', 'categorytree' ],
];

/** Italian (italiano) */
$magicWords['it'] = [
	'categorytree' => [ 0, 'alberocategorie' ],
];

/** Japanese (日本語) */
$magicWords['ja'] = [
	'categorytree' => [ 0, 'カテゴリツリー' ],
];

/** Georgian (ქართული) */
$magicWords['ka'] = [
	'categorytree' => [ 0, 'კატეგორიის_ხე' ],
];

/** Korean (한국어) */
$magicWords['ko'] = [
	'categorytree' => [ 0, '분류트리' ],
];

/** Kurdish (Latin script) (Kurdî (latînî)) */
$magicWords['ku-latn'] = [
	'categorytree' => [ 0, 'dara_kategoriyan' ],
];

/** Cornish (kernowek) */
$magicWords['kw'] = [
	'categorytree' => [ 0, 'gwedhenglass' ],
];

/** Ladino (Ladino) */
$magicWords['lad'] = [
	'categorytree' => [ 0, 'árvoledekateggorías', 'árboldecategorías', 'arboldecategorias',
		'categorytree' ],
];

/** Malagasy (Malagasy) */
$magicWords['mg'] = [
	'categorytree' => [ 0, 'karazantsokajy', 'categorytree' ],
];

/** Macedonian (македонски) */
$magicWords['mk'] = [
	'categorytree' => [ 0, 'стеблонакатегории' ],
];

/** Malayalam (മലയാളം) */
$magicWords['ml'] = [
	'categorytree' => [ 0, 'വർഗ്ഗവൃക്ഷം' ],
];

/** Marathi (मराठी) */
$magicWords['mr'] = [
	'categorytree' => [ 0, 'वर्गवृक्ष' ],
];

/** Norwegian Bokmål (norsk bokmål) */
$magicWords['nb'] = [
	'categorytree' => [ 0, 'kategoritre' ],
];

/** Low Saxon (Netherlands) (Nedersaksies) */
$magicWords['nds-nl'] = [
	'categorytree' => [ 0, 'kategorieboom', 'categorieboom' ],
];

/** Dutch (Nederlands) */
$magicWords['nl'] = [
	'categorytree' => [ 0, 'categorieboom' ],
];

/** Norwegian Nynorsk (norsk nynorsk) */
$magicWords['nn'] = [
	'categorytree' => [ 0, 'kategoritre' ],
];

/** Polish (polski) */
$magicWords['pl'] = [
	'categorytree' => [ 0, 'drzewokategorii' ],
];

/** Romanian (română) */
$magicWords['ro'] = [
	'categorytree' => [ 0, 'arborecategorie' ],
];

/** Russian (русский) */
$magicWords['ru'] = [
	'categorytree' => [ 0, 'деревокатегорий' ],
];

/** Serbian (Cyrillic script) (српски (ћирилица)) */
$magicWords['sr-ec'] = [
	'categorytree' => [ 0, 'стаблокатегорије', 'стабло_категорије' ],
];

/** Serbian (Latin script) (srpski (latinica)) */
$magicWords['sr-el'] = [
	'categorytree' => [ 0, 'stablokategorije', 'stablo_kategorije' ],
];

/** Swedish (svenska) */
$magicWords['sv'] = [
	'categorytree' => [ 0, 'kategoriträd', 'categorytree' ],
];

/** Turkish (Türkçe) */
$magicWords['tr'] = [
	'categorytree' => [ 0, 'kategorihiyerarşisi', 'kategoriağacı', 'ulamhiyerarşisi', 'ulamağacı' ],
];

/** Tatar (Cyrillic script) (татарча) */
$magicWords['tt-cyrl'] = [
	'categorytree' => [ 0, 'төркемнәр_шәҗәрәсе' ],
];

/** Tuvinian (тыва дыл) */
$magicWords['tyv'] = [
	'categorytree' => [ 0, 'аңгылал_ыяжы' ],
];

/** Ukrainian (українська) */
$magicWords['uk'] = [
	'categorytree' => [ 0, 'деревокатегорій', 'деревокатегорий' ],
];

/** Urdu (اردو) */
$magicWords['ur'] = [
	'categorytree' => [ 0, 'شجرہ_زمرہ', 'شجر_زمرہ' ],
];

/** Uzbek (oʻzbekcha/ўзбекча) */
$magicWords['uz'] = [
	'categorytree' => [ 0, 'turkumiyerarxiyasi', 'turkumdaraxti' ],
];

/** Vietnamese (Tiếng Việt) */
$magicWords['vi'] = [
	'categorytree' => [ 0, 'cây_thể_loại', 'câythểloại' ],
];

/** Yiddish (ייִדיש) */
$magicWords['yi'] = [
	'categorytree' => [ 0, 'קאטעגאריע_בוים' ],
];

/** Simplified Chinese (中文（简体）) */
$magicWords['zh-hans'] = [
	'categorytree' => [ 0, '分类树' ],
];

/** Traditional Chinese (中文（繁體）) */
$magicWords['zh-hant'] = [
	'categorytree' => [ 0, '分類樹' ],
];
