# -*- coding: utf-8 -*-
# File generated from our OpenAPI spec
from stripe._request_options import RequestOptions
from typing import List
from typing_extensions import Literal, NotRequired, TypedDict


class SubscriptionListParams(RequestOptions):
    automatic_tax: NotRequired["SubscriptionListParamsAutomaticTax"]
    """
    Filter subscriptions by their automatic tax settings.
    """
    collection_method: NotRequired[
        Literal["charge_automatically", "send_invoice"]
    ]
    """
    The collection method of the subscriptions to retrieve. Either `charge_automatically` or `send_invoice`.
    """
    created: NotRequired["SubscriptionListParamsCreated|int"]
    """
    Only return subscriptions that were created during the given date interval.
    """
    current_period_end: NotRequired[
        "SubscriptionListParamsCurrentPeriodEnd|int"
    ]
    """
    Only return subscriptions whose minimum item current_period_end falls within the given date interval.
    """
    current_period_start: NotRequired[
        "SubscriptionListParamsCurrentPeriodStart|int"
    ]
    """
    Only return subscriptions whose maximum item current_period_start falls within the given date interval.
    """
    customer: NotRequired[str]
    """
    The ID of the customer whose subscriptions will be retrieved.
    """
    ending_before: NotRequired[str]
    """
    A cursor for use in pagination. `ending_before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, starting with `obj_bar`, your subsequent call can include `ending_before=obj_bar` in order to fetch the previous page of the list.
    """
    expand: NotRequired[List[str]]
    """
    Specifies which fields in the response should be expanded.
    """
    limit: NotRequired[int]
    """
    A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 10.
    """
    plan: NotRequired[str]
    """
    The ID of the plan whose subscriptions will be retrieved.
    """
    price: NotRequired[str]
    """
    Filter for subscriptions that contain this recurring price ID.
    """
    starting_after: NotRequired[str]
    """
    A cursor for use in pagination. `starting_after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with `obj_foo`, your subsequent call can include `starting_after=obj_foo` in order to fetch the next page of the list.
    """
    status: NotRequired[
        Literal[
            "active",
            "all",
            "canceled",
            "ended",
            "incomplete",
            "incomplete_expired",
            "past_due",
            "paused",
            "trialing",
            "unpaid",
        ]
    ]
    """
    The status of the subscriptions to retrieve. Passing in a value of `canceled` will return all canceled subscriptions, including those belonging to deleted customers. Pass `ended` to find subscriptions that are canceled and subscriptions that are expired due to [incomplete payment](https://stripe.com/docs/billing/subscriptions/overview#subscription-statuses). Passing in a value of `all` will return subscriptions of all statuses. If no value is supplied, all subscriptions that have not been canceled are returned.
    """
    test_clock: NotRequired[str]
    """
    Filter for subscriptions that are associated with the specified test clock. The response will not include subscriptions with test clocks if this and the customer parameter is not set.
    """


class SubscriptionListParamsAutomaticTax(TypedDict):
    enabled: bool
    """
    Enabled automatic tax calculation which will automatically compute tax rates on all invoices generated by the subscription.
    """


class SubscriptionListParamsCreated(TypedDict):
    gt: NotRequired[int]
    """
    Minimum value to filter by (exclusive)
    """
    gte: NotRequired[int]
    """
    Minimum value to filter by (inclusive)
    """
    lt: NotRequired[int]
    """
    Maximum value to filter by (exclusive)
    """
    lte: NotRequired[int]
    """
    Maximum value to filter by (inclusive)
    """


class SubscriptionListParamsCurrentPeriodEnd(TypedDict):
    gt: NotRequired[int]
    """
    Minimum value to filter by (exclusive)
    """
    gte: NotRequired[int]
    """
    Minimum value to filter by (inclusive)
    """
    lt: NotRequired[int]
    """
    Maximum value to filter by (exclusive)
    """
    lte: NotRequired[int]
    """
    Maximum value to filter by (inclusive)
    """


class SubscriptionListParamsCurrentPeriodStart(TypedDict):
    gt: NotRequired[int]
    """
    Minimum value to filter by (exclusive)
    """
    gte: NotRequired[int]
    """
    Minimum value to filter by (inclusive)
    """
    lt: NotRequired[int]
    """
    Maximum value to filter by (exclusive)
    """
    lte: NotRequired[int]
    """
    Maximum value to filter by (inclusive)
    """
