package iothub

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessRightsDescription enumerates the values for access rights description.
type AccessRightsDescription string

const (
	// AccessRightsDescriptionDeviceConnect ...
	AccessRightsDescriptionDeviceConnect AccessRightsDescription = "DeviceConnect"
	// AccessRightsDescriptionEnrollmentRead ...
	AccessRightsDescriptionEnrollmentRead AccessRightsDescription = "EnrollmentRead"
	// AccessRightsDescriptionEnrollmentWrite ...
	AccessRightsDescriptionEnrollmentWrite AccessRightsDescription = "EnrollmentWrite"
	// AccessRightsDescriptionRegistrationStatusRead ...
	AccessRightsDescriptionRegistrationStatusRead AccessRightsDescription = "RegistrationStatusRead"
	// AccessRightsDescriptionRegistrationStatusWrite ...
	AccessRightsDescriptionRegistrationStatusWrite AccessRightsDescription = "RegistrationStatusWrite"
	// AccessRightsDescriptionServiceConfig ...
	AccessRightsDescriptionServiceConfig AccessRightsDescription = "ServiceConfig"
)

// PossibleAccessRightsDescriptionValues returns an array of possible values for the AccessRightsDescription const type.
func PossibleAccessRightsDescriptionValues() []AccessRightsDescription {
	return []AccessRightsDescription{AccessRightsDescriptionDeviceConnect, AccessRightsDescriptionEnrollmentRead, AccessRightsDescriptionEnrollmentWrite, AccessRightsDescriptionRegistrationStatusRead, AccessRightsDescriptionRegistrationStatusWrite, AccessRightsDescriptionServiceConfig}
}

// AllocationPolicy enumerates the values for allocation policy.
type AllocationPolicy string

const (
	// AllocationPolicyGeoLatency ...
	AllocationPolicyGeoLatency AllocationPolicy = "GeoLatency"
	// AllocationPolicyHashed ...
	AllocationPolicyHashed AllocationPolicy = "Hashed"
	// AllocationPolicyStatic ...
	AllocationPolicyStatic AllocationPolicy = "Static"
)

// PossibleAllocationPolicyValues returns an array of possible values for the AllocationPolicy const type.
func PossibleAllocationPolicyValues() []AllocationPolicy {
	return []AllocationPolicy{AllocationPolicyGeoLatency, AllocationPolicyHashed, AllocationPolicyStatic}
}

// CertificatePurpose enumerates the values for certificate purpose.
type CertificatePurpose string

const (
	// CertificatePurposeClientAuthentication ...
	CertificatePurposeClientAuthentication CertificatePurpose = "clientAuthentication"
	// CertificatePurposeServerAuthentication ...
	CertificatePurposeServerAuthentication CertificatePurpose = "serverAuthentication"
)

// PossibleCertificatePurposeValues returns an array of possible values for the CertificatePurpose const type.
func PossibleCertificatePurposeValues() []CertificatePurpose {
	return []CertificatePurpose{CertificatePurposeClientAuthentication, CertificatePurposeServerAuthentication}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// IotDpsSku enumerates the values for iot dps sku.
type IotDpsSku string

const (
	// IotDpsSkuS1 ...
	IotDpsSkuS1 IotDpsSku = "S1"
)

// PossibleIotDpsSkuValues returns an array of possible values for the IotDpsSku const type.
func PossibleIotDpsSkuValues() []IotDpsSku {
	return []IotDpsSku{IotDpsSkuS1}
}

// IPFilterActionType enumerates the values for ip filter action type.
type IPFilterActionType string

const (
	// IPFilterActionTypeAccept ...
	IPFilterActionTypeAccept IPFilterActionType = "Accept"
	// IPFilterActionTypeReject ...
	IPFilterActionTypeReject IPFilterActionType = "Reject"
)

// PossibleIPFilterActionTypeValues returns an array of possible values for the IPFilterActionType const type.
func PossibleIPFilterActionTypeValues() []IPFilterActionType {
	return []IPFilterActionType{IPFilterActionTypeAccept, IPFilterActionTypeReject}
}

// IPFilterTargetType enumerates the values for ip filter target type.
type IPFilterTargetType string

const (
	// IPFilterTargetTypeAll ...
	IPFilterTargetTypeAll IPFilterTargetType = "all"
	// IPFilterTargetTypeDeviceAPI ...
	IPFilterTargetTypeDeviceAPI IPFilterTargetType = "deviceApi"
	// IPFilterTargetTypeServiceAPI ...
	IPFilterTargetTypeServiceAPI IPFilterTargetType = "serviceApi"
)

// PossibleIPFilterTargetTypeValues returns an array of possible values for the IPFilterTargetType const type.
func PossibleIPFilterTargetTypeValues() []IPFilterTargetType {
	return []IPFilterTargetType{IPFilterTargetTypeAll, IPFilterTargetTypeDeviceAPI, IPFilterTargetTypeServiceAPI}
}

// NameUnavailabilityReason enumerates the values for name unavailability reason.
type NameUnavailabilityReason string

const (
	// NameUnavailabilityReasonAlreadyExists ...
	NameUnavailabilityReasonAlreadyExists NameUnavailabilityReason = "AlreadyExists"
	// NameUnavailabilityReasonInvalid ...
	NameUnavailabilityReasonInvalid NameUnavailabilityReason = "Invalid"
)

// PossibleNameUnavailabilityReasonValues returns an array of possible values for the NameUnavailabilityReason const type.
func PossibleNameUnavailabilityReasonValues() []NameUnavailabilityReason {
	return []NameUnavailabilityReason{NameUnavailabilityReasonAlreadyExists, NameUnavailabilityReasonInvalid}
}

// PrivateLinkServiceConnectionStatus enumerates the values for private link service connection status.
type PrivateLinkServiceConnectionStatus string

const (
	// PrivateLinkServiceConnectionStatusApproved ...
	PrivateLinkServiceConnectionStatusApproved PrivateLinkServiceConnectionStatus = "Approved"
	// PrivateLinkServiceConnectionStatusDisconnected ...
	PrivateLinkServiceConnectionStatusDisconnected PrivateLinkServiceConnectionStatus = "Disconnected"
	// PrivateLinkServiceConnectionStatusPending ...
	PrivateLinkServiceConnectionStatusPending PrivateLinkServiceConnectionStatus = "Pending"
	// PrivateLinkServiceConnectionStatusRejected ...
	PrivateLinkServiceConnectionStatusRejected PrivateLinkServiceConnectionStatus = "Rejected"
)

// PossiblePrivateLinkServiceConnectionStatusValues returns an array of possible values for the PrivateLinkServiceConnectionStatus const type.
func PossiblePrivateLinkServiceConnectionStatusValues() []PrivateLinkServiceConnectionStatus {
	return []PrivateLinkServiceConnectionStatus{PrivateLinkServiceConnectionStatusApproved, PrivateLinkServiceConnectionStatusDisconnected, PrivateLinkServiceConnectionStatusPending, PrivateLinkServiceConnectionStatusRejected}
}

// PublicNetworkAccess enumerates the values for public network access.
type PublicNetworkAccess string

const (
	// PublicNetworkAccessDisabled ...
	PublicNetworkAccessDisabled PublicNetworkAccess = "Disabled"
	// PublicNetworkAccessEnabled ...
	PublicNetworkAccessEnabled PublicNetworkAccess = "Enabled"
)

// PossiblePublicNetworkAccessValues returns an array of possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{PublicNetworkAccessDisabled, PublicNetworkAccessEnabled}
}

// State enumerates the values for state.
type State string

const (
	// StateActivating ...
	StateActivating State = "Activating"
	// StateActivationFailed ...
	StateActivationFailed State = "ActivationFailed"
	// StateActive ...
	StateActive State = "Active"
	// StateDeleted ...
	StateDeleted State = "Deleted"
	// StateDeleting ...
	StateDeleting State = "Deleting"
	// StateDeletionFailed ...
	StateDeletionFailed State = "DeletionFailed"
	// StateFailingOver ...
	StateFailingOver State = "FailingOver"
	// StateFailoverFailed ...
	StateFailoverFailed State = "FailoverFailed"
	// StateResuming ...
	StateResuming State = "Resuming"
	// StateSuspended ...
	StateSuspended State = "Suspended"
	// StateSuspending ...
	StateSuspending State = "Suspending"
	// StateTransitioning ...
	StateTransitioning State = "Transitioning"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{StateActivating, StateActivationFailed, StateActive, StateDeleted, StateDeleting, StateDeletionFailed, StateFailingOver, StateFailoverFailed, StateResuming, StateSuspended, StateSuspending, StateTransitioning}
}
