// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotfleetwise

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAssociateVehicleFleet = "AssociateVehicleFleet"

// AssociateVehicleFleetRequest generates a "aws/request.Request" representing the
// client's request for the AssociateVehicleFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateVehicleFleet for more information on using the AssociateVehicleFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateVehicleFleetRequest method.
//	req, resp := client.AssociateVehicleFleetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/AssociateVehicleFleet
func (c *IoTFleetWise) AssociateVehicleFleetRequest(input *AssociateVehicleFleetInput) (req *request.Request, output *AssociateVehicleFleetOutput) {
	op := &request.Operation{
		Name:       opAssociateVehicleFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateVehicleFleetInput{}
	}

	output = &AssociateVehicleFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateVehicleFleet API operation for AWS IoT FleetWise.
//
// Adds, or associates, a vehicle with a fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation AssociateVehicleFleet for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - LimitExceededException
//     A service quota was exceeded.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/AssociateVehicleFleet
func (c *IoTFleetWise) AssociateVehicleFleet(input *AssociateVehicleFleetInput) (*AssociateVehicleFleetOutput, error) {
	req, out := c.AssociateVehicleFleetRequest(input)
	return out, req.Send()
}

// AssociateVehicleFleetWithContext is the same as AssociateVehicleFleet with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateVehicleFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) AssociateVehicleFleetWithContext(ctx aws.Context, input *AssociateVehicleFleetInput, opts ...request.Option) (*AssociateVehicleFleetOutput, error) {
	req, out := c.AssociateVehicleFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchCreateVehicle = "BatchCreateVehicle"

// BatchCreateVehicleRequest generates a "aws/request.Request" representing the
// client's request for the BatchCreateVehicle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchCreateVehicle for more information on using the BatchCreateVehicle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchCreateVehicleRequest method.
//	req, resp := client.BatchCreateVehicleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/BatchCreateVehicle
func (c *IoTFleetWise) BatchCreateVehicleRequest(input *BatchCreateVehicleInput) (req *request.Request, output *BatchCreateVehicleOutput) {
	op := &request.Operation{
		Name:       opBatchCreateVehicle,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchCreateVehicleInput{}
	}

	output = &BatchCreateVehicleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchCreateVehicle API operation for AWS IoT FleetWise.
//
// Creates a group, or batch, of vehicles.
//
// You must specify a decoder manifest and a vehicle model (model manifest)
// for each vehicle.
//
// For more information, see Create multiple vehicles (AWS CLI) (https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/create-vehicles-cli.html)
// in the Amazon Web Services IoT FleetWise Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation BatchCreateVehicle for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - LimitExceededException
//     A service quota was exceeded.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/BatchCreateVehicle
func (c *IoTFleetWise) BatchCreateVehicle(input *BatchCreateVehicleInput) (*BatchCreateVehicleOutput, error) {
	req, out := c.BatchCreateVehicleRequest(input)
	return out, req.Send()
}

// BatchCreateVehicleWithContext is the same as BatchCreateVehicle with the addition of
// the ability to pass a context and additional request options.
//
// See BatchCreateVehicle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) BatchCreateVehicleWithContext(ctx aws.Context, input *BatchCreateVehicleInput, opts ...request.Option) (*BatchCreateVehicleOutput, error) {
	req, out := c.BatchCreateVehicleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdateVehicle = "BatchUpdateVehicle"

// BatchUpdateVehicleRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateVehicle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateVehicle for more information on using the BatchUpdateVehicle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchUpdateVehicleRequest method.
//	req, resp := client.BatchUpdateVehicleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/BatchUpdateVehicle
func (c *IoTFleetWise) BatchUpdateVehicleRequest(input *BatchUpdateVehicleInput) (req *request.Request, output *BatchUpdateVehicleOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateVehicle,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchUpdateVehicleInput{}
	}

	output = &BatchUpdateVehicleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdateVehicle API operation for AWS IoT FleetWise.
//
// Updates a group, or batch, of vehicles.
//
// You must specify a decoder manifest and a vehicle model (model manifest)
// for each vehicle.
//
// For more information, see Update multiple vehicles (AWS CLI) (https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/update-vehicles-cli.html)
// in the Amazon Web Services IoT FleetWise Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation BatchUpdateVehicle for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/BatchUpdateVehicle
func (c *IoTFleetWise) BatchUpdateVehicle(input *BatchUpdateVehicleInput) (*BatchUpdateVehicleOutput, error) {
	req, out := c.BatchUpdateVehicleRequest(input)
	return out, req.Send()
}

// BatchUpdateVehicleWithContext is the same as BatchUpdateVehicle with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateVehicle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) BatchUpdateVehicleWithContext(ctx aws.Context, input *BatchUpdateVehicleInput, opts ...request.Option) (*BatchUpdateVehicleOutput, error) {
	req, out := c.BatchUpdateVehicleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCampaign = "CreateCampaign"

// CreateCampaignRequest generates a "aws/request.Request" representing the
// client's request for the CreateCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCampaign for more information on using the CreateCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCampaignRequest method.
//	req, resp := client.CreateCampaignRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateCampaign
func (c *IoTFleetWise) CreateCampaignRequest(input *CreateCampaignInput) (req *request.Request, output *CreateCampaignOutput) {
	op := &request.Operation{
		Name:       opCreateCampaign,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCampaignInput{}
	}

	output = &CreateCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCampaign API operation for AWS IoT FleetWise.
//
// Creates an orchestration of data collection rules. The Amazon Web Services
// IoT FleetWise Edge Agent software running in vehicles uses campaigns to decide
// how to collect and transfer data to the cloud. You create campaigns in the
// cloud. After you or your team approve campaigns, Amazon Web Services IoT
// FleetWise automatically deploys them to vehicles.
//
// For more information, see Collect and transfer data with campaigns (https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/campaigns.html)
// in the Amazon Web Services IoT FleetWise Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation CreateCampaign for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ConflictException
//     The request has conflicting operations. This can occur if you're trying to
//     perform more than one operation on the same resource at the same time.
//
//   - LimitExceededException
//     A service quota was exceeded.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateCampaign
func (c *IoTFleetWise) CreateCampaign(input *CreateCampaignInput) (*CreateCampaignOutput, error) {
	req, out := c.CreateCampaignRequest(input)
	return out, req.Send()
}

// CreateCampaignWithContext is the same as CreateCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) CreateCampaignWithContext(ctx aws.Context, input *CreateCampaignInput, opts ...request.Option) (*CreateCampaignOutput, error) {
	req, out := c.CreateCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDecoderManifest = "CreateDecoderManifest"

// CreateDecoderManifestRequest generates a "aws/request.Request" representing the
// client's request for the CreateDecoderManifest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDecoderManifest for more information on using the CreateDecoderManifest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDecoderManifestRequest method.
//	req, resp := client.CreateDecoderManifestRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateDecoderManifest
func (c *IoTFleetWise) CreateDecoderManifestRequest(input *CreateDecoderManifestInput) (req *request.Request, output *CreateDecoderManifestOutput) {
	op := &request.Operation{
		Name:       opCreateDecoderManifest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDecoderManifestInput{}
	}

	output = &CreateDecoderManifestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDecoderManifest API operation for AWS IoT FleetWise.
//
// Creates the decoder manifest associated with a model manifest. To create
// a decoder manifest, the following must be true:
//
//   - Every signal decoder has a unique name.
//
//   - Each signal decoder is associated with a network interface.
//
//   - Each network interface has a unique ID.
//
//   - The signal decoders are specified in the model manifest.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation CreateDecoderManifest for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ConflictException
//     The request has conflicting operations. This can occur if you're trying to
//     perform more than one operation on the same resource at the same time.
//
//   - LimitExceededException
//     A service quota was exceeded.
//
//   - DecoderManifestValidationException
//     The request couldn't be completed because it contains signal decoders with
//     one or more validation errors.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateDecoderManifest
func (c *IoTFleetWise) CreateDecoderManifest(input *CreateDecoderManifestInput) (*CreateDecoderManifestOutput, error) {
	req, out := c.CreateDecoderManifestRequest(input)
	return out, req.Send()
}

// CreateDecoderManifestWithContext is the same as CreateDecoderManifest with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDecoderManifest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) CreateDecoderManifestWithContext(ctx aws.Context, input *CreateDecoderManifestInput, opts ...request.Option) (*CreateDecoderManifestOutput, error) {
	req, out := c.CreateDecoderManifestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFleet = "CreateFleet"

// CreateFleetRequest generates a "aws/request.Request" representing the
// client's request for the CreateFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFleet for more information on using the CreateFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFleetRequest method.
//	req, resp := client.CreateFleetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateFleet
func (c *IoTFleetWise) CreateFleetRequest(input *CreateFleetInput) (req *request.Request, output *CreateFleetOutput) {
	op := &request.Operation{
		Name:       opCreateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFleetInput{}
	}

	output = &CreateFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFleet API operation for AWS IoT FleetWise.
//
// Creates a fleet that represents a group of vehicles.
//
// You must create both a signal catalog and vehicles before you can create
// a fleet.
//
// For more information, see Fleets (https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleets.html)
// in the Amazon Web Services IoT FleetWise Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation CreateFleet for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ConflictException
//     The request has conflicting operations. This can occur if you're trying to
//     perform more than one operation on the same resource at the same time.
//
//   - LimitExceededException
//     A service quota was exceeded.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateFleet
func (c *IoTFleetWise) CreateFleet(input *CreateFleetInput) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	return out, req.Send()
}

// CreateFleetWithContext is the same as CreateFleet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) CreateFleetWithContext(ctx aws.Context, input *CreateFleetInput, opts ...request.Option) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateModelManifest = "CreateModelManifest"

// CreateModelManifestRequest generates a "aws/request.Request" representing the
// client's request for the CreateModelManifest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateModelManifest for more information on using the CreateModelManifest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateModelManifestRequest method.
//	req, resp := client.CreateModelManifestRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateModelManifest
func (c *IoTFleetWise) CreateModelManifestRequest(input *CreateModelManifestInput) (req *request.Request, output *CreateModelManifestOutput) {
	op := &request.Operation{
		Name:       opCreateModelManifest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateModelManifestInput{}
	}

	output = &CreateModelManifestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateModelManifest API operation for AWS IoT FleetWise.
//
// Creates a vehicle model (model manifest) that specifies signals (attributes,
// branches, sensors, and actuators).
//
// For more information, see Vehicle models (https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/vehicle-models.html)
// in the Amazon Web Services IoT FleetWise Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation CreateModelManifest for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ConflictException
//     The request has conflicting operations. This can occur if you're trying to
//     perform more than one operation on the same resource at the same time.
//
//   - LimitExceededException
//     A service quota was exceeded.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InvalidSignalsException
//     The request couldn't be completed because it contains signals that aren't
//     valid.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateModelManifest
func (c *IoTFleetWise) CreateModelManifest(input *CreateModelManifestInput) (*CreateModelManifestOutput, error) {
	req, out := c.CreateModelManifestRequest(input)
	return out, req.Send()
}

// CreateModelManifestWithContext is the same as CreateModelManifest with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModelManifest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) CreateModelManifestWithContext(ctx aws.Context, input *CreateModelManifestInput, opts ...request.Option) (*CreateModelManifestOutput, error) {
	req, out := c.CreateModelManifestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSignalCatalog = "CreateSignalCatalog"

// CreateSignalCatalogRequest generates a "aws/request.Request" representing the
// client's request for the CreateSignalCatalog operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSignalCatalog for more information on using the CreateSignalCatalog
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSignalCatalogRequest method.
//	req, resp := client.CreateSignalCatalogRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateSignalCatalog
func (c *IoTFleetWise) CreateSignalCatalogRequest(input *CreateSignalCatalogInput) (req *request.Request, output *CreateSignalCatalogOutput) {
	op := &request.Operation{
		Name:       opCreateSignalCatalog,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSignalCatalogInput{}
	}

	output = &CreateSignalCatalogOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSignalCatalog API operation for AWS IoT FleetWise.
//
// Creates a collection of standardized signals that can be reused to create
// vehicle models.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation CreateSignalCatalog for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ConflictException
//     The request has conflicting operations. This can occur if you're trying to
//     perform more than one operation on the same resource at the same time.
//
//   - LimitExceededException
//     A service quota was exceeded.
//
//   - InvalidNodeException
//     The specified node type doesn't match the expected node type for a node.
//     You can specify the node type as branch, sensor, actuator, or attribute.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InvalidSignalsException
//     The request couldn't be completed because it contains signals that aren't
//     valid.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateSignalCatalog
func (c *IoTFleetWise) CreateSignalCatalog(input *CreateSignalCatalogInput) (*CreateSignalCatalogOutput, error) {
	req, out := c.CreateSignalCatalogRequest(input)
	return out, req.Send()
}

// CreateSignalCatalogWithContext is the same as CreateSignalCatalog with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSignalCatalog for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) CreateSignalCatalogWithContext(ctx aws.Context, input *CreateSignalCatalogInput, opts ...request.Option) (*CreateSignalCatalogOutput, error) {
	req, out := c.CreateSignalCatalogRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVehicle = "CreateVehicle"

// CreateVehicleRequest generates a "aws/request.Request" representing the
// client's request for the CreateVehicle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVehicle for more information on using the CreateVehicle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVehicleRequest method.
//	req, resp := client.CreateVehicleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateVehicle
func (c *IoTFleetWise) CreateVehicleRequest(input *CreateVehicleInput) (req *request.Request, output *CreateVehicleOutput) {
	op := &request.Operation{
		Name:       opCreateVehicle,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVehicleInput{}
	}

	output = &CreateVehicleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVehicle API operation for AWS IoT FleetWise.
//
// Creates a vehicle, which is an instance of a vehicle model (model manifest).
// Vehicles created from the same vehicle model consist of the same signals
// inherited from the vehicle model.
//
// If you have an existing Amazon Web Services IoT thing, you can use Amazon
// Web Services IoT FleetWise to create a vehicle and collect data from your
// thing.
//
// For more information, see Create a vehicle (AWS CLI) (https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/create-vehicle-cli.html)
// in the Amazon Web Services IoT FleetWise Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation CreateVehicle for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ConflictException
//     The request has conflicting operations. This can occur if you're trying to
//     perform more than one operation on the same resource at the same time.
//
//   - LimitExceededException
//     A service quota was exceeded.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateVehicle
func (c *IoTFleetWise) CreateVehicle(input *CreateVehicleInput) (*CreateVehicleOutput, error) {
	req, out := c.CreateVehicleRequest(input)
	return out, req.Send()
}

// CreateVehicleWithContext is the same as CreateVehicle with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVehicle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) CreateVehicleWithContext(ctx aws.Context, input *CreateVehicleInput, opts ...request.Option) (*CreateVehicleOutput, error) {
	req, out := c.CreateVehicleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCampaign = "DeleteCampaign"

// DeleteCampaignRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCampaign for more information on using the DeleteCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCampaignRequest method.
//	req, resp := client.DeleteCampaignRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteCampaign
func (c *IoTFleetWise) DeleteCampaignRequest(input *DeleteCampaignInput) (req *request.Request, output *DeleteCampaignOutput) {
	op := &request.Operation{
		Name:       opDeleteCampaign,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCampaignInput{}
	}

	output = &DeleteCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCampaign API operation for AWS IoT FleetWise.
//
// Deletes a data collection campaign. Deleting a campaign suspends all data
// collection and removes it from any vehicles.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation DeleteCampaign for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteCampaign
func (c *IoTFleetWise) DeleteCampaign(input *DeleteCampaignInput) (*DeleteCampaignOutput, error) {
	req, out := c.DeleteCampaignRequest(input)
	return out, req.Send()
}

// DeleteCampaignWithContext is the same as DeleteCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) DeleteCampaignWithContext(ctx aws.Context, input *DeleteCampaignInput, opts ...request.Option) (*DeleteCampaignOutput, error) {
	req, out := c.DeleteCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDecoderManifest = "DeleteDecoderManifest"

// DeleteDecoderManifestRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDecoderManifest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDecoderManifest for more information on using the DeleteDecoderManifest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDecoderManifestRequest method.
//	req, resp := client.DeleteDecoderManifestRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteDecoderManifest
func (c *IoTFleetWise) DeleteDecoderManifestRequest(input *DeleteDecoderManifestInput) (req *request.Request, output *DeleteDecoderManifestOutput) {
	op := &request.Operation{
		Name:       opDeleteDecoderManifest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDecoderManifestInput{}
	}

	output = &DeleteDecoderManifestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDecoderManifest API operation for AWS IoT FleetWise.
//
// Deletes a decoder manifest. You can't delete a decoder manifest if it has
// vehicles associated with it.
//
// If the decoder manifest is successfully deleted, Amazon Web Services IoT
// FleetWise sends back an HTTP 200 response with an empty body.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation DeleteDecoderManifest for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ConflictException
//     The request has conflicting operations. This can occur if you're trying to
//     perform more than one operation on the same resource at the same time.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteDecoderManifest
func (c *IoTFleetWise) DeleteDecoderManifest(input *DeleteDecoderManifestInput) (*DeleteDecoderManifestOutput, error) {
	req, out := c.DeleteDecoderManifestRequest(input)
	return out, req.Send()
}

// DeleteDecoderManifestWithContext is the same as DeleteDecoderManifest with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDecoderManifest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) DeleteDecoderManifestWithContext(ctx aws.Context, input *DeleteDecoderManifestInput, opts ...request.Option) (*DeleteDecoderManifestOutput, error) {
	req, out := c.DeleteDecoderManifestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFleet = "DeleteFleet"

// DeleteFleetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFleet for more information on using the DeleteFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFleetRequest method.
//	req, resp := client.DeleteFleetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteFleet
func (c *IoTFleetWise) DeleteFleetRequest(input *DeleteFleetInput) (req *request.Request, output *DeleteFleetOutput) {
	op := &request.Operation{
		Name:       opDeleteFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFleetInput{}
	}

	output = &DeleteFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFleet API operation for AWS IoT FleetWise.
//
// Deletes a fleet. Before you delete a fleet, all vehicles must be dissociated
// from the fleet. For more information, see Delete a fleet (AWS CLI) (https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/delete-fleet-cli.html)
// in the Amazon Web Services IoT FleetWise Developer Guide.
//
// If the fleet is successfully deleted, Amazon Web Services IoT FleetWise sends
// back an HTTP 200 response with an empty body.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation DeleteFleet for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteFleet
func (c *IoTFleetWise) DeleteFleet(input *DeleteFleetInput) (*DeleteFleetOutput, error) {
	req, out := c.DeleteFleetRequest(input)
	return out, req.Send()
}

// DeleteFleetWithContext is the same as DeleteFleet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) DeleteFleetWithContext(ctx aws.Context, input *DeleteFleetInput, opts ...request.Option) (*DeleteFleetOutput, error) {
	req, out := c.DeleteFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteModelManifest = "DeleteModelManifest"

// DeleteModelManifestRequest generates a "aws/request.Request" representing the
// client's request for the DeleteModelManifest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteModelManifest for more information on using the DeleteModelManifest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteModelManifestRequest method.
//	req, resp := client.DeleteModelManifestRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteModelManifest
func (c *IoTFleetWise) DeleteModelManifestRequest(input *DeleteModelManifestInput) (req *request.Request, output *DeleteModelManifestOutput) {
	op := &request.Operation{
		Name:       opDeleteModelManifest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteModelManifestInput{}
	}

	output = &DeleteModelManifestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteModelManifest API operation for AWS IoT FleetWise.
//
// Deletes a vehicle model (model manifest).
//
// If the vehicle model is successfully deleted, Amazon Web Services IoT FleetWise
// sends back an HTTP 200 response with an empty body.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation DeleteModelManifest for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ConflictException
//     The request has conflicting operations. This can occur if you're trying to
//     perform more than one operation on the same resource at the same time.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteModelManifest
func (c *IoTFleetWise) DeleteModelManifest(input *DeleteModelManifestInput) (*DeleteModelManifestOutput, error) {
	req, out := c.DeleteModelManifestRequest(input)
	return out, req.Send()
}

// DeleteModelManifestWithContext is the same as DeleteModelManifest with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteModelManifest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) DeleteModelManifestWithContext(ctx aws.Context, input *DeleteModelManifestInput, opts ...request.Option) (*DeleteModelManifestOutput, error) {
	req, out := c.DeleteModelManifestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSignalCatalog = "DeleteSignalCatalog"

// DeleteSignalCatalogRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSignalCatalog operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSignalCatalog for more information on using the DeleteSignalCatalog
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSignalCatalogRequest method.
//	req, resp := client.DeleteSignalCatalogRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteSignalCatalog
func (c *IoTFleetWise) DeleteSignalCatalogRequest(input *DeleteSignalCatalogInput) (req *request.Request, output *DeleteSignalCatalogOutput) {
	op := &request.Operation{
		Name:       opDeleteSignalCatalog,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSignalCatalogInput{}
	}

	output = &DeleteSignalCatalogOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSignalCatalog API operation for AWS IoT FleetWise.
//
// Deletes a signal catalog.
//
// If the signal catalog is successfully deleted, Amazon Web Services IoT FleetWise
// sends back an HTTP 200 response with an empty body.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation DeleteSignalCatalog for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ConflictException
//     The request has conflicting operations. This can occur if you're trying to
//     perform more than one operation on the same resource at the same time.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteSignalCatalog
func (c *IoTFleetWise) DeleteSignalCatalog(input *DeleteSignalCatalogInput) (*DeleteSignalCatalogOutput, error) {
	req, out := c.DeleteSignalCatalogRequest(input)
	return out, req.Send()
}

// DeleteSignalCatalogWithContext is the same as DeleteSignalCatalog with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSignalCatalog for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) DeleteSignalCatalogWithContext(ctx aws.Context, input *DeleteSignalCatalogInput, opts ...request.Option) (*DeleteSignalCatalogOutput, error) {
	req, out := c.DeleteSignalCatalogRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVehicle = "DeleteVehicle"

// DeleteVehicleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVehicle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVehicle for more information on using the DeleteVehicle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVehicleRequest method.
//	req, resp := client.DeleteVehicleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteVehicle
func (c *IoTFleetWise) DeleteVehicleRequest(input *DeleteVehicleInput) (req *request.Request, output *DeleteVehicleOutput) {
	op := &request.Operation{
		Name:       opDeleteVehicle,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVehicleInput{}
	}

	output = &DeleteVehicleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVehicle API operation for AWS IoT FleetWise.
//
// Deletes a vehicle and removes it from any campaigns.
//
// If the vehicle is successfully deleted, Amazon Web Services IoT FleetWise
// sends back an HTTP 200 response with an empty body.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation DeleteVehicle for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteVehicle
func (c *IoTFleetWise) DeleteVehicle(input *DeleteVehicleInput) (*DeleteVehicleOutput, error) {
	req, out := c.DeleteVehicleRequest(input)
	return out, req.Send()
}

// DeleteVehicleWithContext is the same as DeleteVehicle with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVehicle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) DeleteVehicleWithContext(ctx aws.Context, input *DeleteVehicleInput, opts ...request.Option) (*DeleteVehicleOutput, error) {
	req, out := c.DeleteVehicleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateVehicleFleet = "DisassociateVehicleFleet"

// DisassociateVehicleFleetRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateVehicleFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateVehicleFleet for more information on using the DisassociateVehicleFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateVehicleFleetRequest method.
//	req, resp := client.DisassociateVehicleFleetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DisassociateVehicleFleet
func (c *IoTFleetWise) DisassociateVehicleFleetRequest(input *DisassociateVehicleFleetInput) (req *request.Request, output *DisassociateVehicleFleetOutput) {
	op := &request.Operation{
		Name:       opDisassociateVehicleFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateVehicleFleetInput{}
	}

	output = &DisassociateVehicleFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateVehicleFleet API operation for AWS IoT FleetWise.
//
// Removes, or disassociates, a vehicle from a fleet. Disassociating a vehicle
// from a fleet doesn't delete the vehicle.
//
// If the vehicle is successfully dissociated from a fleet, Amazon Web Services
// IoT FleetWise sends back an HTTP 200 response with an empty body.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation DisassociateVehicleFleet for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DisassociateVehicleFleet
func (c *IoTFleetWise) DisassociateVehicleFleet(input *DisassociateVehicleFleetInput) (*DisassociateVehicleFleetOutput, error) {
	req, out := c.DisassociateVehicleFleetRequest(input)
	return out, req.Send()
}

// DisassociateVehicleFleetWithContext is the same as DisassociateVehicleFleet with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateVehicleFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) DisassociateVehicleFleetWithContext(ctx aws.Context, input *DisassociateVehicleFleetInput, opts ...request.Option) (*DisassociateVehicleFleetOutput, error) {
	req, out := c.DisassociateVehicleFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCampaign = "GetCampaign"

// GetCampaignRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCampaign for more information on using the GetCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCampaignRequest method.
//	req, resp := client.GetCampaignRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetCampaign
func (c *IoTFleetWise) GetCampaignRequest(input *GetCampaignInput) (req *request.Request, output *GetCampaignOutput) {
	op := &request.Operation{
		Name:       opGetCampaign,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCampaignInput{}
	}

	output = &GetCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaign API operation for AWS IoT FleetWise.
//
// Retrieves information about a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation GetCampaign for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetCampaign
func (c *IoTFleetWise) GetCampaign(input *GetCampaignInput) (*GetCampaignOutput, error) {
	req, out := c.GetCampaignRequest(input)
	return out, req.Send()
}

// GetCampaignWithContext is the same as GetCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See GetCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) GetCampaignWithContext(ctx aws.Context, input *GetCampaignInput, opts ...request.Option) (*GetCampaignOutput, error) {
	req, out := c.GetCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDecoderManifest = "GetDecoderManifest"

// GetDecoderManifestRequest generates a "aws/request.Request" representing the
// client's request for the GetDecoderManifest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDecoderManifest for more information on using the GetDecoderManifest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDecoderManifestRequest method.
//	req, resp := client.GetDecoderManifestRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetDecoderManifest
func (c *IoTFleetWise) GetDecoderManifestRequest(input *GetDecoderManifestInput) (req *request.Request, output *GetDecoderManifestOutput) {
	op := &request.Operation{
		Name:       opGetDecoderManifest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDecoderManifestInput{}
	}

	output = &GetDecoderManifestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDecoderManifest API operation for AWS IoT FleetWise.
//
// Retrieves information about a created decoder manifest.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation GetDecoderManifest for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetDecoderManifest
func (c *IoTFleetWise) GetDecoderManifest(input *GetDecoderManifestInput) (*GetDecoderManifestOutput, error) {
	req, out := c.GetDecoderManifestRequest(input)
	return out, req.Send()
}

// GetDecoderManifestWithContext is the same as GetDecoderManifest with the addition of
// the ability to pass a context and additional request options.
//
// See GetDecoderManifest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) GetDecoderManifestWithContext(ctx aws.Context, input *GetDecoderManifestInput, opts ...request.Option) (*GetDecoderManifestOutput, error) {
	req, out := c.GetDecoderManifestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEncryptionConfiguration = "GetEncryptionConfiguration"

// GetEncryptionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetEncryptionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEncryptionConfiguration for more information on using the GetEncryptionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEncryptionConfigurationRequest method.
//	req, resp := client.GetEncryptionConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetEncryptionConfiguration
func (c *IoTFleetWise) GetEncryptionConfigurationRequest(input *GetEncryptionConfigurationInput) (req *request.Request, output *GetEncryptionConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetEncryptionConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEncryptionConfigurationInput{}
	}

	output = &GetEncryptionConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEncryptionConfiguration API operation for AWS IoT FleetWise.
//
// Retrieves the encryption configuration for resources and data in Amazon Web
// Services IoT FleetWise.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation GetEncryptionConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetEncryptionConfiguration
func (c *IoTFleetWise) GetEncryptionConfiguration(input *GetEncryptionConfigurationInput) (*GetEncryptionConfigurationOutput, error) {
	req, out := c.GetEncryptionConfigurationRequest(input)
	return out, req.Send()
}

// GetEncryptionConfigurationWithContext is the same as GetEncryptionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetEncryptionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) GetEncryptionConfigurationWithContext(ctx aws.Context, input *GetEncryptionConfigurationInput, opts ...request.Option) (*GetEncryptionConfigurationOutput, error) {
	req, out := c.GetEncryptionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFleet = "GetFleet"

// GetFleetRequest generates a "aws/request.Request" representing the
// client's request for the GetFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFleet for more information on using the GetFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetFleetRequest method.
//	req, resp := client.GetFleetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetFleet
func (c *IoTFleetWise) GetFleetRequest(input *GetFleetInput) (req *request.Request, output *GetFleetOutput) {
	op := &request.Operation{
		Name:       opGetFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetFleetInput{}
	}

	output = &GetFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFleet API operation for AWS IoT FleetWise.
//
// Retrieves information about a fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation GetFleet for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetFleet
func (c *IoTFleetWise) GetFleet(input *GetFleetInput) (*GetFleetOutput, error) {
	req, out := c.GetFleetRequest(input)
	return out, req.Send()
}

// GetFleetWithContext is the same as GetFleet with the addition of
// the ability to pass a context and additional request options.
//
// See GetFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) GetFleetWithContext(ctx aws.Context, input *GetFleetInput, opts ...request.Option) (*GetFleetOutput, error) {
	req, out := c.GetFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLoggingOptions = "GetLoggingOptions"

// GetLoggingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the GetLoggingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLoggingOptions for more information on using the GetLoggingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetLoggingOptionsRequest method.
//	req, resp := client.GetLoggingOptionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetLoggingOptions
func (c *IoTFleetWise) GetLoggingOptionsRequest(input *GetLoggingOptionsInput) (req *request.Request, output *GetLoggingOptionsOutput) {
	op := &request.Operation{
		Name:       opGetLoggingOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetLoggingOptionsInput{}
	}

	output = &GetLoggingOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLoggingOptions API operation for AWS IoT FleetWise.
//
// Retrieves the logging options.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation GetLoggingOptions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetLoggingOptions
func (c *IoTFleetWise) GetLoggingOptions(input *GetLoggingOptionsInput) (*GetLoggingOptionsOutput, error) {
	req, out := c.GetLoggingOptionsRequest(input)
	return out, req.Send()
}

// GetLoggingOptionsWithContext is the same as GetLoggingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See GetLoggingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) GetLoggingOptionsWithContext(ctx aws.Context, input *GetLoggingOptionsInput, opts ...request.Option) (*GetLoggingOptionsOutput, error) {
	req, out := c.GetLoggingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetModelManifest = "GetModelManifest"

// GetModelManifestRequest generates a "aws/request.Request" representing the
// client's request for the GetModelManifest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetModelManifest for more information on using the GetModelManifest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetModelManifestRequest method.
//	req, resp := client.GetModelManifestRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetModelManifest
func (c *IoTFleetWise) GetModelManifestRequest(input *GetModelManifestInput) (req *request.Request, output *GetModelManifestOutput) {
	op := &request.Operation{
		Name:       opGetModelManifest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetModelManifestInput{}
	}

	output = &GetModelManifestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetModelManifest API operation for AWS IoT FleetWise.
//
// Retrieves information about a vehicle model (model manifest).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation GetModelManifest for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetModelManifest
func (c *IoTFleetWise) GetModelManifest(input *GetModelManifestInput) (*GetModelManifestOutput, error) {
	req, out := c.GetModelManifestRequest(input)
	return out, req.Send()
}

// GetModelManifestWithContext is the same as GetModelManifest with the addition of
// the ability to pass a context and additional request options.
//
// See GetModelManifest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) GetModelManifestWithContext(ctx aws.Context, input *GetModelManifestInput, opts ...request.Option) (*GetModelManifestOutput, error) {
	req, out := c.GetModelManifestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRegisterAccountStatus = "GetRegisterAccountStatus"

// GetRegisterAccountStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetRegisterAccountStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRegisterAccountStatus for more information on using the GetRegisterAccountStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRegisterAccountStatusRequest method.
//	req, resp := client.GetRegisterAccountStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetRegisterAccountStatus
func (c *IoTFleetWise) GetRegisterAccountStatusRequest(input *GetRegisterAccountStatusInput) (req *request.Request, output *GetRegisterAccountStatusOutput) {
	op := &request.Operation{
		Name:       opGetRegisterAccountStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRegisterAccountStatusInput{}
	}

	output = &GetRegisterAccountStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRegisterAccountStatus API operation for AWS IoT FleetWise.
//
// Retrieves information about the status of registering your Amazon Web Services
// account, IAM, and Amazon Timestream resources so that Amazon Web Services
// IoT FleetWise can transfer your vehicle data to the Amazon Web Services Cloud.
//
// For more information, including step-by-step procedures, see Setting up Amazon
// Web Services IoT FleetWise (https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/setting-up.html).
//
// This API operation doesn't require input parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation GetRegisterAccountStatus for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetRegisterAccountStatus
func (c *IoTFleetWise) GetRegisterAccountStatus(input *GetRegisterAccountStatusInput) (*GetRegisterAccountStatusOutput, error) {
	req, out := c.GetRegisterAccountStatusRequest(input)
	return out, req.Send()
}

// GetRegisterAccountStatusWithContext is the same as GetRegisterAccountStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetRegisterAccountStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) GetRegisterAccountStatusWithContext(ctx aws.Context, input *GetRegisterAccountStatusInput, opts ...request.Option) (*GetRegisterAccountStatusOutput, error) {
	req, out := c.GetRegisterAccountStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSignalCatalog = "GetSignalCatalog"

// GetSignalCatalogRequest generates a "aws/request.Request" representing the
// client's request for the GetSignalCatalog operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSignalCatalog for more information on using the GetSignalCatalog
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSignalCatalogRequest method.
//	req, resp := client.GetSignalCatalogRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetSignalCatalog
func (c *IoTFleetWise) GetSignalCatalogRequest(input *GetSignalCatalogInput) (req *request.Request, output *GetSignalCatalogOutput) {
	op := &request.Operation{
		Name:       opGetSignalCatalog,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSignalCatalogInput{}
	}

	output = &GetSignalCatalogOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSignalCatalog API operation for AWS IoT FleetWise.
//
// Retrieves information about a signal catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation GetSignalCatalog for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetSignalCatalog
func (c *IoTFleetWise) GetSignalCatalog(input *GetSignalCatalogInput) (*GetSignalCatalogOutput, error) {
	req, out := c.GetSignalCatalogRequest(input)
	return out, req.Send()
}

// GetSignalCatalogWithContext is the same as GetSignalCatalog with the addition of
// the ability to pass a context and additional request options.
//
// See GetSignalCatalog for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) GetSignalCatalogWithContext(ctx aws.Context, input *GetSignalCatalogInput, opts ...request.Option) (*GetSignalCatalogOutput, error) {
	req, out := c.GetSignalCatalogRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVehicle = "GetVehicle"

// GetVehicleRequest generates a "aws/request.Request" representing the
// client's request for the GetVehicle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVehicle for more information on using the GetVehicle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVehicleRequest method.
//	req, resp := client.GetVehicleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetVehicle
func (c *IoTFleetWise) GetVehicleRequest(input *GetVehicleInput) (req *request.Request, output *GetVehicleOutput) {
	op := &request.Operation{
		Name:       opGetVehicle,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetVehicleInput{}
	}

	output = &GetVehicleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVehicle API operation for AWS IoT FleetWise.
//
// Retrieves information about a vehicle.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation GetVehicle for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetVehicle
func (c *IoTFleetWise) GetVehicle(input *GetVehicleInput) (*GetVehicleOutput, error) {
	req, out := c.GetVehicleRequest(input)
	return out, req.Send()
}

// GetVehicleWithContext is the same as GetVehicle with the addition of
// the ability to pass a context and additional request options.
//
// See GetVehicle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) GetVehicleWithContext(ctx aws.Context, input *GetVehicleInput, opts ...request.Option) (*GetVehicleOutput, error) {
	req, out := c.GetVehicleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVehicleStatus = "GetVehicleStatus"

// GetVehicleStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetVehicleStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVehicleStatus for more information on using the GetVehicleStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVehicleStatusRequest method.
//	req, resp := client.GetVehicleStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetVehicleStatus
func (c *IoTFleetWise) GetVehicleStatusRequest(input *GetVehicleStatusInput) (req *request.Request, output *GetVehicleStatusOutput) {
	op := &request.Operation{
		Name:       opGetVehicleStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetVehicleStatusInput{}
	}

	output = &GetVehicleStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVehicleStatus API operation for AWS IoT FleetWise.
//
// Retrieves information about the status of a vehicle with any associated campaigns.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation GetVehicleStatus for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetVehicleStatus
func (c *IoTFleetWise) GetVehicleStatus(input *GetVehicleStatusInput) (*GetVehicleStatusOutput, error) {
	req, out := c.GetVehicleStatusRequest(input)
	return out, req.Send()
}

// GetVehicleStatusWithContext is the same as GetVehicleStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetVehicleStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) GetVehicleStatusWithContext(ctx aws.Context, input *GetVehicleStatusInput, opts ...request.Option) (*GetVehicleStatusOutput, error) {
	req, out := c.GetVehicleStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetVehicleStatusPages iterates over the pages of a GetVehicleStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetVehicleStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetVehicleStatus operation.
//	pageNum := 0
//	err := client.GetVehicleStatusPages(params,
//	    func(page *iotfleetwise.GetVehicleStatusOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTFleetWise) GetVehicleStatusPages(input *GetVehicleStatusInput, fn func(*GetVehicleStatusOutput, bool) bool) error {
	return c.GetVehicleStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetVehicleStatusPagesWithContext same as GetVehicleStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) GetVehicleStatusPagesWithContext(ctx aws.Context, input *GetVehicleStatusInput, fn func(*GetVehicleStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetVehicleStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetVehicleStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetVehicleStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opImportDecoderManifest = "ImportDecoderManifest"

// ImportDecoderManifestRequest generates a "aws/request.Request" representing the
// client's request for the ImportDecoderManifest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportDecoderManifest for more information on using the ImportDecoderManifest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ImportDecoderManifestRequest method.
//	req, resp := client.ImportDecoderManifestRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ImportDecoderManifest
func (c *IoTFleetWise) ImportDecoderManifestRequest(input *ImportDecoderManifestInput) (req *request.Request, output *ImportDecoderManifestOutput) {
	op := &request.Operation{
		Name:       opImportDecoderManifest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportDecoderManifestInput{}
	}

	output = &ImportDecoderManifestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportDecoderManifest API operation for AWS IoT FleetWise.
//
// Creates a decoder manifest using your existing CAN DBC file from your local
// device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation ImportDecoderManifest for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ConflictException
//     The request has conflicting operations. This can occur if you're trying to
//     perform more than one operation on the same resource at the same time.
//
//   - DecoderManifestValidationException
//     The request couldn't be completed because it contains signal decoders with
//     one or more validation errors.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InvalidSignalsException
//     The request couldn't be completed because it contains signals that aren't
//     valid.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ImportDecoderManifest
func (c *IoTFleetWise) ImportDecoderManifest(input *ImportDecoderManifestInput) (*ImportDecoderManifestOutput, error) {
	req, out := c.ImportDecoderManifestRequest(input)
	return out, req.Send()
}

// ImportDecoderManifestWithContext is the same as ImportDecoderManifest with the addition of
// the ability to pass a context and additional request options.
//
// See ImportDecoderManifest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ImportDecoderManifestWithContext(ctx aws.Context, input *ImportDecoderManifestInput, opts ...request.Option) (*ImportDecoderManifestOutput, error) {
	req, out := c.ImportDecoderManifestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportSignalCatalog = "ImportSignalCatalog"

// ImportSignalCatalogRequest generates a "aws/request.Request" representing the
// client's request for the ImportSignalCatalog operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportSignalCatalog for more information on using the ImportSignalCatalog
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ImportSignalCatalogRequest method.
//	req, resp := client.ImportSignalCatalogRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ImportSignalCatalog
func (c *IoTFleetWise) ImportSignalCatalogRequest(input *ImportSignalCatalogInput) (req *request.Request, output *ImportSignalCatalogOutput) {
	op := &request.Operation{
		Name:       opImportSignalCatalog,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportSignalCatalogInput{}
	}

	output = &ImportSignalCatalogOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportSignalCatalog API operation for AWS IoT FleetWise.
//
// Creates a signal catalog using your existing VSS formatted content from your
// local device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation ImportSignalCatalog for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ConflictException
//     The request has conflicting operations. This can occur if you're trying to
//     perform more than one operation on the same resource at the same time.
//
//   - LimitExceededException
//     A service quota was exceeded.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InvalidSignalsException
//     The request couldn't be completed because it contains signals that aren't
//     valid.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ImportSignalCatalog
func (c *IoTFleetWise) ImportSignalCatalog(input *ImportSignalCatalogInput) (*ImportSignalCatalogOutput, error) {
	req, out := c.ImportSignalCatalogRequest(input)
	return out, req.Send()
}

// ImportSignalCatalogWithContext is the same as ImportSignalCatalog with the addition of
// the ability to pass a context and additional request options.
//
// See ImportSignalCatalog for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ImportSignalCatalogWithContext(ctx aws.Context, input *ImportSignalCatalogInput, opts ...request.Option) (*ImportSignalCatalogOutput, error) {
	req, out := c.ImportSignalCatalogRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCampaigns = "ListCampaigns"

// ListCampaignsRequest generates a "aws/request.Request" representing the
// client's request for the ListCampaigns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCampaigns for more information on using the ListCampaigns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCampaignsRequest method.
//	req, resp := client.ListCampaignsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListCampaigns
func (c *IoTFleetWise) ListCampaignsRequest(input *ListCampaignsInput) (req *request.Request, output *ListCampaignsOutput) {
	op := &request.Operation{
		Name:       opListCampaigns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCampaignsInput{}
	}

	output = &ListCampaignsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCampaigns API operation for AWS IoT FleetWise.
//
// Lists information about created campaigns.
//
// This API operation uses pagination. Specify the nextToken parameter in the
// request to return more results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation ListCampaigns for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListCampaigns
func (c *IoTFleetWise) ListCampaigns(input *ListCampaignsInput) (*ListCampaignsOutput, error) {
	req, out := c.ListCampaignsRequest(input)
	return out, req.Send()
}

// ListCampaignsWithContext is the same as ListCampaigns with the addition of
// the ability to pass a context and additional request options.
//
// See ListCampaigns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListCampaignsWithContext(ctx aws.Context, input *ListCampaignsInput, opts ...request.Option) (*ListCampaignsOutput, error) {
	req, out := c.ListCampaignsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCampaignsPages iterates over the pages of a ListCampaigns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCampaigns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCampaigns operation.
//	pageNum := 0
//	err := client.ListCampaignsPages(params,
//	    func(page *iotfleetwise.ListCampaignsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTFleetWise) ListCampaignsPages(input *ListCampaignsInput, fn func(*ListCampaignsOutput, bool) bool) error {
	return c.ListCampaignsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCampaignsPagesWithContext same as ListCampaignsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListCampaignsPagesWithContext(ctx aws.Context, input *ListCampaignsInput, fn func(*ListCampaignsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCampaignsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCampaignsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCampaignsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDecoderManifestNetworkInterfaces = "ListDecoderManifestNetworkInterfaces"

// ListDecoderManifestNetworkInterfacesRequest generates a "aws/request.Request" representing the
// client's request for the ListDecoderManifestNetworkInterfaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDecoderManifestNetworkInterfaces for more information on using the ListDecoderManifestNetworkInterfaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDecoderManifestNetworkInterfacesRequest method.
//	req, resp := client.ListDecoderManifestNetworkInterfacesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestNetworkInterfaces
func (c *IoTFleetWise) ListDecoderManifestNetworkInterfacesRequest(input *ListDecoderManifestNetworkInterfacesInput) (req *request.Request, output *ListDecoderManifestNetworkInterfacesOutput) {
	op := &request.Operation{
		Name:       opListDecoderManifestNetworkInterfaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDecoderManifestNetworkInterfacesInput{}
	}

	output = &ListDecoderManifestNetworkInterfacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDecoderManifestNetworkInterfaces API operation for AWS IoT FleetWise.
//
// Lists the network interfaces specified in a decoder manifest.
//
// This API operation uses pagination. Specify the nextToken parameter in the
// request to return more results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation ListDecoderManifestNetworkInterfaces for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestNetworkInterfaces
func (c *IoTFleetWise) ListDecoderManifestNetworkInterfaces(input *ListDecoderManifestNetworkInterfacesInput) (*ListDecoderManifestNetworkInterfacesOutput, error) {
	req, out := c.ListDecoderManifestNetworkInterfacesRequest(input)
	return out, req.Send()
}

// ListDecoderManifestNetworkInterfacesWithContext is the same as ListDecoderManifestNetworkInterfaces with the addition of
// the ability to pass a context and additional request options.
//
// See ListDecoderManifestNetworkInterfaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListDecoderManifestNetworkInterfacesWithContext(ctx aws.Context, input *ListDecoderManifestNetworkInterfacesInput, opts ...request.Option) (*ListDecoderManifestNetworkInterfacesOutput, error) {
	req, out := c.ListDecoderManifestNetworkInterfacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDecoderManifestNetworkInterfacesPages iterates over the pages of a ListDecoderManifestNetworkInterfaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDecoderManifestNetworkInterfaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDecoderManifestNetworkInterfaces operation.
//	pageNum := 0
//	err := client.ListDecoderManifestNetworkInterfacesPages(params,
//	    func(page *iotfleetwise.ListDecoderManifestNetworkInterfacesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTFleetWise) ListDecoderManifestNetworkInterfacesPages(input *ListDecoderManifestNetworkInterfacesInput, fn func(*ListDecoderManifestNetworkInterfacesOutput, bool) bool) error {
	return c.ListDecoderManifestNetworkInterfacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDecoderManifestNetworkInterfacesPagesWithContext same as ListDecoderManifestNetworkInterfacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListDecoderManifestNetworkInterfacesPagesWithContext(ctx aws.Context, input *ListDecoderManifestNetworkInterfacesInput, fn func(*ListDecoderManifestNetworkInterfacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDecoderManifestNetworkInterfacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDecoderManifestNetworkInterfacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDecoderManifestNetworkInterfacesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDecoderManifestSignals = "ListDecoderManifestSignals"

// ListDecoderManifestSignalsRequest generates a "aws/request.Request" representing the
// client's request for the ListDecoderManifestSignals operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDecoderManifestSignals for more information on using the ListDecoderManifestSignals
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDecoderManifestSignalsRequest method.
//	req, resp := client.ListDecoderManifestSignalsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestSignals
func (c *IoTFleetWise) ListDecoderManifestSignalsRequest(input *ListDecoderManifestSignalsInput) (req *request.Request, output *ListDecoderManifestSignalsOutput) {
	op := &request.Operation{
		Name:       opListDecoderManifestSignals,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDecoderManifestSignalsInput{}
	}

	output = &ListDecoderManifestSignalsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDecoderManifestSignals API operation for AWS IoT FleetWise.
//
// A list of information about signal decoders specified in a decoder manifest.
//
// This API operation uses pagination. Specify the nextToken parameter in the
// request to return more results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation ListDecoderManifestSignals for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestSignals
func (c *IoTFleetWise) ListDecoderManifestSignals(input *ListDecoderManifestSignalsInput) (*ListDecoderManifestSignalsOutput, error) {
	req, out := c.ListDecoderManifestSignalsRequest(input)
	return out, req.Send()
}

// ListDecoderManifestSignalsWithContext is the same as ListDecoderManifestSignals with the addition of
// the ability to pass a context and additional request options.
//
// See ListDecoderManifestSignals for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListDecoderManifestSignalsWithContext(ctx aws.Context, input *ListDecoderManifestSignalsInput, opts ...request.Option) (*ListDecoderManifestSignalsOutput, error) {
	req, out := c.ListDecoderManifestSignalsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDecoderManifestSignalsPages iterates over the pages of a ListDecoderManifestSignals operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDecoderManifestSignals method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDecoderManifestSignals operation.
//	pageNum := 0
//	err := client.ListDecoderManifestSignalsPages(params,
//	    func(page *iotfleetwise.ListDecoderManifestSignalsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTFleetWise) ListDecoderManifestSignalsPages(input *ListDecoderManifestSignalsInput, fn func(*ListDecoderManifestSignalsOutput, bool) bool) error {
	return c.ListDecoderManifestSignalsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDecoderManifestSignalsPagesWithContext same as ListDecoderManifestSignalsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListDecoderManifestSignalsPagesWithContext(ctx aws.Context, input *ListDecoderManifestSignalsInput, fn func(*ListDecoderManifestSignalsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDecoderManifestSignalsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDecoderManifestSignalsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDecoderManifestSignalsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDecoderManifests = "ListDecoderManifests"

// ListDecoderManifestsRequest generates a "aws/request.Request" representing the
// client's request for the ListDecoderManifests operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDecoderManifests for more information on using the ListDecoderManifests
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDecoderManifestsRequest method.
//	req, resp := client.ListDecoderManifestsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifests
func (c *IoTFleetWise) ListDecoderManifestsRequest(input *ListDecoderManifestsInput) (req *request.Request, output *ListDecoderManifestsOutput) {
	op := &request.Operation{
		Name:       opListDecoderManifests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDecoderManifestsInput{}
	}

	output = &ListDecoderManifestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDecoderManifests API operation for AWS IoT FleetWise.
//
// Lists decoder manifests.
//
// This API operation uses pagination. Specify the nextToken parameter in the
// request to return more results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation ListDecoderManifests for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifests
func (c *IoTFleetWise) ListDecoderManifests(input *ListDecoderManifestsInput) (*ListDecoderManifestsOutput, error) {
	req, out := c.ListDecoderManifestsRequest(input)
	return out, req.Send()
}

// ListDecoderManifestsWithContext is the same as ListDecoderManifests with the addition of
// the ability to pass a context and additional request options.
//
// See ListDecoderManifests for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListDecoderManifestsWithContext(ctx aws.Context, input *ListDecoderManifestsInput, opts ...request.Option) (*ListDecoderManifestsOutput, error) {
	req, out := c.ListDecoderManifestsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDecoderManifestsPages iterates over the pages of a ListDecoderManifests operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDecoderManifests method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDecoderManifests operation.
//	pageNum := 0
//	err := client.ListDecoderManifestsPages(params,
//	    func(page *iotfleetwise.ListDecoderManifestsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTFleetWise) ListDecoderManifestsPages(input *ListDecoderManifestsInput, fn func(*ListDecoderManifestsOutput, bool) bool) error {
	return c.ListDecoderManifestsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDecoderManifestsPagesWithContext same as ListDecoderManifestsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListDecoderManifestsPagesWithContext(ctx aws.Context, input *ListDecoderManifestsInput, fn func(*ListDecoderManifestsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDecoderManifestsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDecoderManifestsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDecoderManifestsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFleets = "ListFleets"

// ListFleetsRequest generates a "aws/request.Request" representing the
// client's request for the ListFleets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFleets for more information on using the ListFleets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFleetsRequest method.
//	req, resp := client.ListFleetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleets
func (c *IoTFleetWise) ListFleetsRequest(input *ListFleetsInput) (req *request.Request, output *ListFleetsOutput) {
	op := &request.Operation{
		Name:       opListFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFleetsInput{}
	}

	output = &ListFleetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFleets API operation for AWS IoT FleetWise.
//
// Retrieves information for each created fleet in an Amazon Web Services account.
//
// This API operation uses pagination. Specify the nextToken parameter in the
// request to return more results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation ListFleets for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleets
func (c *IoTFleetWise) ListFleets(input *ListFleetsInput) (*ListFleetsOutput, error) {
	req, out := c.ListFleetsRequest(input)
	return out, req.Send()
}

// ListFleetsWithContext is the same as ListFleets with the addition of
// the ability to pass a context and additional request options.
//
// See ListFleets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListFleetsWithContext(ctx aws.Context, input *ListFleetsInput, opts ...request.Option) (*ListFleetsOutput, error) {
	req, out := c.ListFleetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFleetsPages iterates over the pages of a ListFleets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFleets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFleets operation.
//	pageNum := 0
//	err := client.ListFleetsPages(params,
//	    func(page *iotfleetwise.ListFleetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTFleetWise) ListFleetsPages(input *ListFleetsInput, fn func(*ListFleetsOutput, bool) bool) error {
	return c.ListFleetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFleetsPagesWithContext same as ListFleetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListFleetsPagesWithContext(ctx aws.Context, input *ListFleetsInput, fn func(*ListFleetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFleetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFleetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFleetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFleetsForVehicle = "ListFleetsForVehicle"

// ListFleetsForVehicleRequest generates a "aws/request.Request" representing the
// client's request for the ListFleetsForVehicle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFleetsForVehicle for more information on using the ListFleetsForVehicle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFleetsForVehicleRequest method.
//	req, resp := client.ListFleetsForVehicleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleetsForVehicle
func (c *IoTFleetWise) ListFleetsForVehicleRequest(input *ListFleetsForVehicleInput) (req *request.Request, output *ListFleetsForVehicleOutput) {
	op := &request.Operation{
		Name:       opListFleetsForVehicle,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFleetsForVehicleInput{}
	}

	output = &ListFleetsForVehicleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFleetsForVehicle API operation for AWS IoT FleetWise.
//
// Retrieves a list of IDs for all fleets that the vehicle is associated with.
//
// This API operation uses pagination. Specify the nextToken parameter in the
// request to return more results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation ListFleetsForVehicle for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleetsForVehicle
func (c *IoTFleetWise) ListFleetsForVehicle(input *ListFleetsForVehicleInput) (*ListFleetsForVehicleOutput, error) {
	req, out := c.ListFleetsForVehicleRequest(input)
	return out, req.Send()
}

// ListFleetsForVehicleWithContext is the same as ListFleetsForVehicle with the addition of
// the ability to pass a context and additional request options.
//
// See ListFleetsForVehicle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListFleetsForVehicleWithContext(ctx aws.Context, input *ListFleetsForVehicleInput, opts ...request.Option) (*ListFleetsForVehicleOutput, error) {
	req, out := c.ListFleetsForVehicleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFleetsForVehiclePages iterates over the pages of a ListFleetsForVehicle operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFleetsForVehicle method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFleetsForVehicle operation.
//	pageNum := 0
//	err := client.ListFleetsForVehiclePages(params,
//	    func(page *iotfleetwise.ListFleetsForVehicleOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTFleetWise) ListFleetsForVehiclePages(input *ListFleetsForVehicleInput, fn func(*ListFleetsForVehicleOutput, bool) bool) error {
	return c.ListFleetsForVehiclePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFleetsForVehiclePagesWithContext same as ListFleetsForVehiclePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListFleetsForVehiclePagesWithContext(ctx aws.Context, input *ListFleetsForVehicleInput, fn func(*ListFleetsForVehicleOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFleetsForVehicleInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFleetsForVehicleRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFleetsForVehicleOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListModelManifestNodes = "ListModelManifestNodes"

// ListModelManifestNodesRequest generates a "aws/request.Request" representing the
// client's request for the ListModelManifestNodes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListModelManifestNodes for more information on using the ListModelManifestNodes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListModelManifestNodesRequest method.
//	req, resp := client.ListModelManifestNodesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifestNodes
func (c *IoTFleetWise) ListModelManifestNodesRequest(input *ListModelManifestNodesInput) (req *request.Request, output *ListModelManifestNodesOutput) {
	op := &request.Operation{
		Name:       opListModelManifestNodes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListModelManifestNodesInput{}
	}

	output = &ListModelManifestNodesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListModelManifestNodes API operation for AWS IoT FleetWise.
//
// Lists information about nodes specified in a vehicle model (model manifest).
//
// This API operation uses pagination. Specify the nextToken parameter in the
// request to return more results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation ListModelManifestNodes for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - LimitExceededException
//     A service quota was exceeded.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifestNodes
func (c *IoTFleetWise) ListModelManifestNodes(input *ListModelManifestNodesInput) (*ListModelManifestNodesOutput, error) {
	req, out := c.ListModelManifestNodesRequest(input)
	return out, req.Send()
}

// ListModelManifestNodesWithContext is the same as ListModelManifestNodes with the addition of
// the ability to pass a context and additional request options.
//
// See ListModelManifestNodes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListModelManifestNodesWithContext(ctx aws.Context, input *ListModelManifestNodesInput, opts ...request.Option) (*ListModelManifestNodesOutput, error) {
	req, out := c.ListModelManifestNodesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListModelManifestNodesPages iterates over the pages of a ListModelManifestNodes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListModelManifestNodes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListModelManifestNodes operation.
//	pageNum := 0
//	err := client.ListModelManifestNodesPages(params,
//	    func(page *iotfleetwise.ListModelManifestNodesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTFleetWise) ListModelManifestNodesPages(input *ListModelManifestNodesInput, fn func(*ListModelManifestNodesOutput, bool) bool) error {
	return c.ListModelManifestNodesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListModelManifestNodesPagesWithContext same as ListModelManifestNodesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListModelManifestNodesPagesWithContext(ctx aws.Context, input *ListModelManifestNodesInput, fn func(*ListModelManifestNodesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListModelManifestNodesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListModelManifestNodesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListModelManifestNodesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListModelManifests = "ListModelManifests"

// ListModelManifestsRequest generates a "aws/request.Request" representing the
// client's request for the ListModelManifests operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListModelManifests for more information on using the ListModelManifests
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListModelManifestsRequest method.
//	req, resp := client.ListModelManifestsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifests
func (c *IoTFleetWise) ListModelManifestsRequest(input *ListModelManifestsInput) (req *request.Request, output *ListModelManifestsOutput) {
	op := &request.Operation{
		Name:       opListModelManifests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListModelManifestsInput{}
	}

	output = &ListModelManifestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListModelManifests API operation for AWS IoT FleetWise.
//
// Retrieves a list of vehicle models (model manifests).
//
// This API operation uses pagination. Specify the nextToken parameter in the
// request to return more results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation ListModelManifests for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifests
func (c *IoTFleetWise) ListModelManifests(input *ListModelManifestsInput) (*ListModelManifestsOutput, error) {
	req, out := c.ListModelManifestsRequest(input)
	return out, req.Send()
}

// ListModelManifestsWithContext is the same as ListModelManifests with the addition of
// the ability to pass a context and additional request options.
//
// See ListModelManifests for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListModelManifestsWithContext(ctx aws.Context, input *ListModelManifestsInput, opts ...request.Option) (*ListModelManifestsOutput, error) {
	req, out := c.ListModelManifestsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListModelManifestsPages iterates over the pages of a ListModelManifests operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListModelManifests method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListModelManifests operation.
//	pageNum := 0
//	err := client.ListModelManifestsPages(params,
//	    func(page *iotfleetwise.ListModelManifestsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTFleetWise) ListModelManifestsPages(input *ListModelManifestsInput, fn func(*ListModelManifestsOutput, bool) bool) error {
	return c.ListModelManifestsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListModelManifestsPagesWithContext same as ListModelManifestsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListModelManifestsPagesWithContext(ctx aws.Context, input *ListModelManifestsInput, fn func(*ListModelManifestsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListModelManifestsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListModelManifestsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListModelManifestsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSignalCatalogNodes = "ListSignalCatalogNodes"

// ListSignalCatalogNodesRequest generates a "aws/request.Request" representing the
// client's request for the ListSignalCatalogNodes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSignalCatalogNodes for more information on using the ListSignalCatalogNodes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSignalCatalogNodesRequest method.
//	req, resp := client.ListSignalCatalogNodesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogNodes
func (c *IoTFleetWise) ListSignalCatalogNodesRequest(input *ListSignalCatalogNodesInput) (req *request.Request, output *ListSignalCatalogNodesOutput) {
	op := &request.Operation{
		Name:       opListSignalCatalogNodes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSignalCatalogNodesInput{}
	}

	output = &ListSignalCatalogNodesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSignalCatalogNodes API operation for AWS IoT FleetWise.
//
// Lists of information about the signals (nodes) specified in a signal catalog.
//
// This API operation uses pagination. Specify the nextToken parameter in the
// request to return more results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation ListSignalCatalogNodes for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - LimitExceededException
//     A service quota was exceeded.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogNodes
func (c *IoTFleetWise) ListSignalCatalogNodes(input *ListSignalCatalogNodesInput) (*ListSignalCatalogNodesOutput, error) {
	req, out := c.ListSignalCatalogNodesRequest(input)
	return out, req.Send()
}

// ListSignalCatalogNodesWithContext is the same as ListSignalCatalogNodes with the addition of
// the ability to pass a context and additional request options.
//
// See ListSignalCatalogNodes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListSignalCatalogNodesWithContext(ctx aws.Context, input *ListSignalCatalogNodesInput, opts ...request.Option) (*ListSignalCatalogNodesOutput, error) {
	req, out := c.ListSignalCatalogNodesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSignalCatalogNodesPages iterates over the pages of a ListSignalCatalogNodes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSignalCatalogNodes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSignalCatalogNodes operation.
//	pageNum := 0
//	err := client.ListSignalCatalogNodesPages(params,
//	    func(page *iotfleetwise.ListSignalCatalogNodesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTFleetWise) ListSignalCatalogNodesPages(input *ListSignalCatalogNodesInput, fn func(*ListSignalCatalogNodesOutput, bool) bool) error {
	return c.ListSignalCatalogNodesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSignalCatalogNodesPagesWithContext same as ListSignalCatalogNodesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListSignalCatalogNodesPagesWithContext(ctx aws.Context, input *ListSignalCatalogNodesInput, fn func(*ListSignalCatalogNodesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSignalCatalogNodesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSignalCatalogNodesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSignalCatalogNodesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSignalCatalogs = "ListSignalCatalogs"

// ListSignalCatalogsRequest generates a "aws/request.Request" representing the
// client's request for the ListSignalCatalogs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSignalCatalogs for more information on using the ListSignalCatalogs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSignalCatalogsRequest method.
//	req, resp := client.ListSignalCatalogsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogs
func (c *IoTFleetWise) ListSignalCatalogsRequest(input *ListSignalCatalogsInput) (req *request.Request, output *ListSignalCatalogsOutput) {
	op := &request.Operation{
		Name:       opListSignalCatalogs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSignalCatalogsInput{}
	}

	output = &ListSignalCatalogsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSignalCatalogs API operation for AWS IoT FleetWise.
//
// Lists all the created signal catalogs in an Amazon Web Services account.
//
// You can use to list information about each signal (node) specified in a signal
// catalog.
//
// This API operation uses pagination. Specify the nextToken parameter in the
// request to return more results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation ListSignalCatalogs for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogs
func (c *IoTFleetWise) ListSignalCatalogs(input *ListSignalCatalogsInput) (*ListSignalCatalogsOutput, error) {
	req, out := c.ListSignalCatalogsRequest(input)
	return out, req.Send()
}

// ListSignalCatalogsWithContext is the same as ListSignalCatalogs with the addition of
// the ability to pass a context and additional request options.
//
// See ListSignalCatalogs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListSignalCatalogsWithContext(ctx aws.Context, input *ListSignalCatalogsInput, opts ...request.Option) (*ListSignalCatalogsOutput, error) {
	req, out := c.ListSignalCatalogsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSignalCatalogsPages iterates over the pages of a ListSignalCatalogs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSignalCatalogs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSignalCatalogs operation.
//	pageNum := 0
//	err := client.ListSignalCatalogsPages(params,
//	    func(page *iotfleetwise.ListSignalCatalogsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTFleetWise) ListSignalCatalogsPages(input *ListSignalCatalogsInput, fn func(*ListSignalCatalogsOutput, bool) bool) error {
	return c.ListSignalCatalogsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSignalCatalogsPagesWithContext same as ListSignalCatalogsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListSignalCatalogsPagesWithContext(ctx aws.Context, input *ListSignalCatalogsInput, fn func(*ListSignalCatalogsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSignalCatalogsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSignalCatalogsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSignalCatalogsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListTagsForResource
func (c *IoTFleetWise) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS IoT FleetWise.
//
// Lists the tags (metadata) you have assigned to the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListTagsForResource
func (c *IoTFleetWise) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVehicles = "ListVehicles"

// ListVehiclesRequest generates a "aws/request.Request" representing the
// client's request for the ListVehicles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVehicles for more information on using the ListVehicles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVehiclesRequest method.
//	req, resp := client.ListVehiclesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehicles
func (c *IoTFleetWise) ListVehiclesRequest(input *ListVehiclesInput) (req *request.Request, output *ListVehiclesOutput) {
	op := &request.Operation{
		Name:       opListVehicles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVehiclesInput{}
	}

	output = &ListVehiclesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVehicles API operation for AWS IoT FleetWise.
//
// Retrieves a list of summaries of created vehicles.
//
// This API operation uses pagination. Specify the nextToken parameter in the
// request to return more results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation ListVehicles for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehicles
func (c *IoTFleetWise) ListVehicles(input *ListVehiclesInput) (*ListVehiclesOutput, error) {
	req, out := c.ListVehiclesRequest(input)
	return out, req.Send()
}

// ListVehiclesWithContext is the same as ListVehicles with the addition of
// the ability to pass a context and additional request options.
//
// See ListVehicles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListVehiclesWithContext(ctx aws.Context, input *ListVehiclesInput, opts ...request.Option) (*ListVehiclesOutput, error) {
	req, out := c.ListVehiclesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVehiclesPages iterates over the pages of a ListVehicles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVehicles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListVehicles operation.
//	pageNum := 0
//	err := client.ListVehiclesPages(params,
//	    func(page *iotfleetwise.ListVehiclesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTFleetWise) ListVehiclesPages(input *ListVehiclesInput, fn func(*ListVehiclesOutput, bool) bool) error {
	return c.ListVehiclesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVehiclesPagesWithContext same as ListVehiclesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListVehiclesPagesWithContext(ctx aws.Context, input *ListVehiclesInput, fn func(*ListVehiclesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVehiclesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVehiclesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVehiclesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListVehiclesInFleet = "ListVehiclesInFleet"

// ListVehiclesInFleetRequest generates a "aws/request.Request" representing the
// client's request for the ListVehiclesInFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVehiclesInFleet for more information on using the ListVehiclesInFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVehiclesInFleetRequest method.
//	req, resp := client.ListVehiclesInFleetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehiclesInFleet
func (c *IoTFleetWise) ListVehiclesInFleetRequest(input *ListVehiclesInFleetInput) (req *request.Request, output *ListVehiclesInFleetOutput) {
	op := &request.Operation{
		Name:       opListVehiclesInFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVehiclesInFleetInput{}
	}

	output = &ListVehiclesInFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVehiclesInFleet API operation for AWS IoT FleetWise.
//
// Retrieves a list of summaries of all vehicles associated with a fleet.
//
// This API operation uses pagination. Specify the nextToken parameter in the
// request to return more results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation ListVehiclesInFleet for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehiclesInFleet
func (c *IoTFleetWise) ListVehiclesInFleet(input *ListVehiclesInFleetInput) (*ListVehiclesInFleetOutput, error) {
	req, out := c.ListVehiclesInFleetRequest(input)
	return out, req.Send()
}

// ListVehiclesInFleetWithContext is the same as ListVehiclesInFleet with the addition of
// the ability to pass a context and additional request options.
//
// See ListVehiclesInFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListVehiclesInFleetWithContext(ctx aws.Context, input *ListVehiclesInFleetInput, opts ...request.Option) (*ListVehiclesInFleetOutput, error) {
	req, out := c.ListVehiclesInFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVehiclesInFleetPages iterates over the pages of a ListVehiclesInFleet operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVehiclesInFleet method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListVehiclesInFleet operation.
//	pageNum := 0
//	err := client.ListVehiclesInFleetPages(params,
//	    func(page *iotfleetwise.ListVehiclesInFleetOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTFleetWise) ListVehiclesInFleetPages(input *ListVehiclesInFleetInput, fn func(*ListVehiclesInFleetOutput, bool) bool) error {
	return c.ListVehiclesInFleetPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVehiclesInFleetPagesWithContext same as ListVehiclesInFleetPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) ListVehiclesInFleetPagesWithContext(ctx aws.Context, input *ListVehiclesInFleetInput, fn func(*ListVehiclesInFleetOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVehiclesInFleetInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVehiclesInFleetRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVehiclesInFleetOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutEncryptionConfiguration = "PutEncryptionConfiguration"

// PutEncryptionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutEncryptionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEncryptionConfiguration for more information on using the PutEncryptionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutEncryptionConfigurationRequest method.
//	req, resp := client.PutEncryptionConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/PutEncryptionConfiguration
func (c *IoTFleetWise) PutEncryptionConfigurationRequest(input *PutEncryptionConfigurationInput) (req *request.Request, output *PutEncryptionConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutEncryptionConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutEncryptionConfigurationInput{}
	}

	output = &PutEncryptionConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutEncryptionConfiguration API operation for AWS IoT FleetWise.
//
// Creates or updates the encryption configuration. Amazon Web Services IoT
// FleetWise can encrypt your data and resources using an Amazon Web Services
// managed key. Or, you can use a KMS key that you own and manage. For more
// information, see Data encryption (https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/data-encryption.html)
// in the Amazon Web Services IoT FleetWise Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation PutEncryptionConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ConflictException
//     The request has conflicting operations. This can occur if you're trying to
//     perform more than one operation on the same resource at the same time.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/PutEncryptionConfiguration
func (c *IoTFleetWise) PutEncryptionConfiguration(input *PutEncryptionConfigurationInput) (*PutEncryptionConfigurationOutput, error) {
	req, out := c.PutEncryptionConfigurationRequest(input)
	return out, req.Send()
}

// PutEncryptionConfigurationWithContext is the same as PutEncryptionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutEncryptionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) PutEncryptionConfigurationWithContext(ctx aws.Context, input *PutEncryptionConfigurationInput, opts ...request.Option) (*PutEncryptionConfigurationOutput, error) {
	req, out := c.PutEncryptionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutLoggingOptions = "PutLoggingOptions"

// PutLoggingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the PutLoggingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutLoggingOptions for more information on using the PutLoggingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutLoggingOptionsRequest method.
//	req, resp := client.PutLoggingOptionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/PutLoggingOptions
func (c *IoTFleetWise) PutLoggingOptionsRequest(input *PutLoggingOptionsInput) (req *request.Request, output *PutLoggingOptionsOutput) {
	op := &request.Operation{
		Name:       opPutLoggingOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutLoggingOptionsInput{}
	}

	output = &PutLoggingOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutLoggingOptions API operation for AWS IoT FleetWise.
//
// Creates or updates the logging option.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation PutLoggingOptions for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ConflictException
//     The request has conflicting operations. This can occur if you're trying to
//     perform more than one operation on the same resource at the same time.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/PutLoggingOptions
func (c *IoTFleetWise) PutLoggingOptions(input *PutLoggingOptionsInput) (*PutLoggingOptionsOutput, error) {
	req, out := c.PutLoggingOptionsRequest(input)
	return out, req.Send()
}

// PutLoggingOptionsWithContext is the same as PutLoggingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See PutLoggingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) PutLoggingOptionsWithContext(ctx aws.Context, input *PutLoggingOptionsInput, opts ...request.Option) (*PutLoggingOptionsOutput, error) {
	req, out := c.PutLoggingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterAccount = "RegisterAccount"

// RegisterAccountRequest generates a "aws/request.Request" representing the
// client's request for the RegisterAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterAccount for more information on using the RegisterAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterAccountRequest method.
//	req, resp := client.RegisterAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/RegisterAccount
func (c *IoTFleetWise) RegisterAccountRequest(input *RegisterAccountInput) (req *request.Request, output *RegisterAccountOutput) {
	op := &request.Operation{
		Name:       opRegisterAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterAccountInput{}
	}

	output = &RegisterAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterAccount API operation for AWS IoT FleetWise.
//
// This API operation contains deprecated parameters. Register your account
// again without the Timestream resources parameter so that Amazon Web Services
// IoT FleetWise can remove the Timestream metadata stored. You should then
// pass the data destination into the CreateCampaign (https://docs.aws.amazon.com/iot-fleetwise/latest/APIReference/API_CreateCampaign.html)
// API operation.
//
// You must delete any existing campaigns that include an empty data destination
// before you register your account again. For more information, see the DeleteCampaign
// (https://docs.aws.amazon.com/iot-fleetwise/latest/APIReference/API_DeleteCampaign.html)
// API operation.
//
// If you want to delete the Timestream inline policy from the service-linked
// role, such as to mitigate an overly permissive policy, you must first delete
// any existing campaigns. Then delete the service-linked role and register
// your account again to enable CloudWatch metrics. For more information, see
// DeleteServiceLinkedRole (https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServiceLinkedRole.html)
// in the Identity and Access Management API Reference.
//
// Registers your Amazon Web Services account, IAM, and Amazon Timestream resources
// so Amazon Web Services IoT FleetWise can transfer your vehicle data to the
// Amazon Web Services Cloud. For more information, including step-by-step procedures,
// see Setting up Amazon Web Services IoT FleetWise (https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/setting-up.html).
//
// An Amazon Web Services account is not the same thing as a "user." An Amazon
// Web Services user (https://docs.aws.amazon.com/IAM/latest/UserGuide/introduction_identity-management.html#intro-identity-users)
// is an identity that you create using Identity and Access Management (IAM)
// and takes the form of either an IAM user (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html)
// or an IAM role, both with credentials (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html).
// A single Amazon Web Services account can, and typically does, contain many
// users and roles.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation RegisterAccount for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ConflictException
//     The request has conflicting operations. This can occur if you're trying to
//     perform more than one operation on the same resource at the same time.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/RegisterAccount
func (c *IoTFleetWise) RegisterAccount(input *RegisterAccountInput) (*RegisterAccountOutput, error) {
	req, out := c.RegisterAccountRequest(input)
	return out, req.Send()
}

// RegisterAccountWithContext is the same as RegisterAccount with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) RegisterAccountWithContext(ctx aws.Context, input *RegisterAccountInput, opts ...request.Option) (*RegisterAccountOutput, error) {
	req, out := c.RegisterAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/TagResource
func (c *IoTFleetWise) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS IoT FleetWise.
//
// Adds to or modifies the tags of the given resource. Tags are metadata which
// can be used to manage a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/TagResource
func (c *IoTFleetWise) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UntagResource
func (c *IoTFleetWise) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS IoT FleetWise.
//
// Removes the given tags (metadata) from the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UntagResource
func (c *IoTFleetWise) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCampaign = "UpdateCampaign"

// UpdateCampaignRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCampaign for more information on using the UpdateCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCampaignRequest method.
//	req, resp := client.UpdateCampaignRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateCampaign
func (c *IoTFleetWise) UpdateCampaignRequest(input *UpdateCampaignInput) (req *request.Request, output *UpdateCampaignOutput) {
	op := &request.Operation{
		Name:       opUpdateCampaign,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCampaignInput{}
	}

	output = &UpdateCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCampaign API operation for AWS IoT FleetWise.
//
// Updates a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation UpdateCampaign for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ConflictException
//     The request has conflicting operations. This can occur if you're trying to
//     perform more than one operation on the same resource at the same time.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateCampaign
func (c *IoTFleetWise) UpdateCampaign(input *UpdateCampaignInput) (*UpdateCampaignOutput, error) {
	req, out := c.UpdateCampaignRequest(input)
	return out, req.Send()
}

// UpdateCampaignWithContext is the same as UpdateCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) UpdateCampaignWithContext(ctx aws.Context, input *UpdateCampaignInput, opts ...request.Option) (*UpdateCampaignOutput, error) {
	req, out := c.UpdateCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDecoderManifest = "UpdateDecoderManifest"

// UpdateDecoderManifestRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDecoderManifest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDecoderManifest for more information on using the UpdateDecoderManifest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDecoderManifestRequest method.
//	req, resp := client.UpdateDecoderManifestRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateDecoderManifest
func (c *IoTFleetWise) UpdateDecoderManifestRequest(input *UpdateDecoderManifestInput) (req *request.Request, output *UpdateDecoderManifestOutput) {
	op := &request.Operation{
		Name:       opUpdateDecoderManifest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDecoderManifestInput{}
	}

	output = &UpdateDecoderManifestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDecoderManifest API operation for AWS IoT FleetWise.
//
// Updates a decoder manifest.
//
// A decoder manifest can only be updated when the status is DRAFT. Only ACTIVE
// decoder manifests can be associated with vehicles.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation UpdateDecoderManifest for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ConflictException
//     The request has conflicting operations. This can occur if you're trying to
//     perform more than one operation on the same resource at the same time.
//
//   - LimitExceededException
//     A service quota was exceeded.
//
//   - DecoderManifestValidationException
//     The request couldn't be completed because it contains signal decoders with
//     one or more validation errors.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateDecoderManifest
func (c *IoTFleetWise) UpdateDecoderManifest(input *UpdateDecoderManifestInput) (*UpdateDecoderManifestOutput, error) {
	req, out := c.UpdateDecoderManifestRequest(input)
	return out, req.Send()
}

// UpdateDecoderManifestWithContext is the same as UpdateDecoderManifest with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDecoderManifest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) UpdateDecoderManifestWithContext(ctx aws.Context, input *UpdateDecoderManifestInput, opts ...request.Option) (*UpdateDecoderManifestOutput, error) {
	req, out := c.UpdateDecoderManifestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFleet = "UpdateFleet"

// UpdateFleetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFleet for more information on using the UpdateFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFleetRequest method.
//	req, resp := client.UpdateFleetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateFleet
func (c *IoTFleetWise) UpdateFleetRequest(input *UpdateFleetInput) (req *request.Request, output *UpdateFleetOutput) {
	op := &request.Operation{
		Name:       opUpdateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFleetInput{}
	}

	output = &UpdateFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFleet API operation for AWS IoT FleetWise.
//
// Updates the description of an existing fleet.
//
// If the fleet is successfully updated, Amazon Web Services IoT FleetWise sends
// back an HTTP 200 response with an empty HTTP body.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation UpdateFleet for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ConflictException
//     The request has conflicting operations. This can occur if you're trying to
//     perform more than one operation on the same resource at the same time.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateFleet
func (c *IoTFleetWise) UpdateFleet(input *UpdateFleetInput) (*UpdateFleetOutput, error) {
	req, out := c.UpdateFleetRequest(input)
	return out, req.Send()
}

// UpdateFleetWithContext is the same as UpdateFleet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) UpdateFleetWithContext(ctx aws.Context, input *UpdateFleetInput, opts ...request.Option) (*UpdateFleetOutput, error) {
	req, out := c.UpdateFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateModelManifest = "UpdateModelManifest"

// UpdateModelManifestRequest generates a "aws/request.Request" representing the
// client's request for the UpdateModelManifest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateModelManifest for more information on using the UpdateModelManifest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateModelManifestRequest method.
//	req, resp := client.UpdateModelManifestRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateModelManifest
func (c *IoTFleetWise) UpdateModelManifestRequest(input *UpdateModelManifestInput) (req *request.Request, output *UpdateModelManifestOutput) {
	op := &request.Operation{
		Name:       opUpdateModelManifest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateModelManifestInput{}
	}

	output = &UpdateModelManifestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateModelManifest API operation for AWS IoT FleetWise.
//
// Updates a vehicle model (model manifest). If created vehicles are associated
// with a vehicle model, it can't be updated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation UpdateModelManifest for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ConflictException
//     The request has conflicting operations. This can occur if you're trying to
//     perform more than one operation on the same resource at the same time.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InvalidSignalsException
//     The request couldn't be completed because it contains signals that aren't
//     valid.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateModelManifest
func (c *IoTFleetWise) UpdateModelManifest(input *UpdateModelManifestInput) (*UpdateModelManifestOutput, error) {
	req, out := c.UpdateModelManifestRequest(input)
	return out, req.Send()
}

// UpdateModelManifestWithContext is the same as UpdateModelManifest with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateModelManifest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) UpdateModelManifestWithContext(ctx aws.Context, input *UpdateModelManifestInput, opts ...request.Option) (*UpdateModelManifestOutput, error) {
	req, out := c.UpdateModelManifestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSignalCatalog = "UpdateSignalCatalog"

// UpdateSignalCatalogRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSignalCatalog operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSignalCatalog for more information on using the UpdateSignalCatalog
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSignalCatalogRequest method.
//	req, resp := client.UpdateSignalCatalogRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateSignalCatalog
func (c *IoTFleetWise) UpdateSignalCatalogRequest(input *UpdateSignalCatalogInput) (req *request.Request, output *UpdateSignalCatalogOutput) {
	op := &request.Operation{
		Name:       opUpdateSignalCatalog,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSignalCatalogInput{}
	}

	output = &UpdateSignalCatalogOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSignalCatalog API operation for AWS IoT FleetWise.
//
// Updates a signal catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation UpdateSignalCatalog for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ConflictException
//     The request has conflicting operations. This can occur if you're trying to
//     perform more than one operation on the same resource at the same time.
//
//   - LimitExceededException
//     A service quota was exceeded.
//
//   - InvalidNodeException
//     The specified node type doesn't match the expected node type for a node.
//     You can specify the node type as branch, sensor, actuator, or attribute.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InvalidSignalsException
//     The request couldn't be completed because it contains signals that aren't
//     valid.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateSignalCatalog
func (c *IoTFleetWise) UpdateSignalCatalog(input *UpdateSignalCatalogInput) (*UpdateSignalCatalogOutput, error) {
	req, out := c.UpdateSignalCatalogRequest(input)
	return out, req.Send()
}

// UpdateSignalCatalogWithContext is the same as UpdateSignalCatalog with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSignalCatalog for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) UpdateSignalCatalogWithContext(ctx aws.Context, input *UpdateSignalCatalogInput, opts ...request.Option) (*UpdateSignalCatalogOutput, error) {
	req, out := c.UpdateSignalCatalogRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVehicle = "UpdateVehicle"

// UpdateVehicleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVehicle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVehicle for more information on using the UpdateVehicle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateVehicleRequest method.
//	req, resp := client.UpdateVehicleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateVehicle
func (c *IoTFleetWise) UpdateVehicleRequest(input *UpdateVehicleInput) (req *request.Request, output *UpdateVehicleOutput) {
	op := &request.Operation{
		Name:       opUpdateVehicle,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateVehicleInput{}
	}

	output = &UpdateVehicleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVehicle API operation for AWS IoT FleetWise.
//
// Updates a vehicle.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT FleetWise's
// API operation UpdateVehicle for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request couldn't be completed because the server temporarily failed.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ConflictException
//     The request has conflicting operations. This can occur if you're trying to
//     perform more than one operation on the same resource at the same time.
//
//   - ThrottlingException
//     The request couldn't be completed due to throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You don't have sufficient permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateVehicle
func (c *IoTFleetWise) UpdateVehicle(input *UpdateVehicleInput) (*UpdateVehicleOutput, error) {
	req, out := c.UpdateVehicleRequest(input)
	return out, req.Send()
}

// UpdateVehicleWithContext is the same as UpdateVehicle with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVehicle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetWise) UpdateVehicleWithContext(ctx aws.Context, input *UpdateVehicleInput, opts ...request.Option) (*UpdateVehicleOutput, error) {
	req, out := c.UpdateVehicleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have sufficient permission to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A signal that represents a vehicle device such as the engine, heater, and
// door locks. Data from an actuator reports the state of a certain vehicle
// device.
//
// Updating actuator data can change the state of a device. For example, you
// can turn on or off the heater by updating its actuator data.
type Actuator struct {
	_ struct{} `type:"structure"`

	// A list of possible values an actuator can take.
	AllowedValues []*string `locationName:"allowedValues" type:"list"`

	// A specified value for the actuator.
	//
	// Deprecated: assignedValue is no longer in use
	AssignedValue *string `locationName:"assignedValue" deprecated:"true" type:"string"`

	// A comment in addition to the description.
	Comment *string `locationName:"comment" min:"1" type:"string"`

	// The specified data type of the actuator.
	//
	// DataType is a required field
	DataType *string `locationName:"dataType" type:"string" required:"true" enum:"NodeDataType"`

	// The deprecation message for the node or the branch that was moved or deleted.
	DeprecationMessage *string `locationName:"deprecationMessage" min:"1" type:"string"`

	// A brief description of the actuator.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The fully qualified name of the actuator. For example, the fully qualified
	// name of an actuator might be Vehicle.Front.Left.Door.Lock.
	//
	// FullyQualifiedName is a required field
	FullyQualifiedName *string `locationName:"fullyQualifiedName" type:"string" required:"true"`

	// The specified possible maximum value of an actuator.
	Max *float64 `locationName:"max" type:"double"`

	// The specified possible minimum value of an actuator.
	Min *float64 `locationName:"min" type:"double"`

	// The fully qualified name of the struct node for the actuator if the data
	// type of the actuator is Struct or StructArray. For example, the struct fully
	// qualified name of an actuator might be Vehicle.Door.LockStruct.
	StructFullyQualifiedName *string `locationName:"structFullyQualifiedName" min:"1" type:"string"`

	// The scientific unit for the actuator.
	Unit *string `locationName:"unit" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Actuator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Actuator) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Actuator) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Actuator"}
	if s.Comment != nil && len(*s.Comment) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Comment", 1))
	}
	if s.DataType == nil {
		invalidParams.Add(request.NewErrParamRequired("DataType"))
	}
	if s.DeprecationMessage != nil && len(*s.DeprecationMessage) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeprecationMessage", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.FullyQualifiedName == nil {
		invalidParams.Add(request.NewErrParamRequired("FullyQualifiedName"))
	}
	if s.StructFullyQualifiedName != nil && len(*s.StructFullyQualifiedName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StructFullyQualifiedName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *Actuator) SetAllowedValues(v []*string) *Actuator {
	s.AllowedValues = v
	return s
}

// SetAssignedValue sets the AssignedValue field's value.
func (s *Actuator) SetAssignedValue(v string) *Actuator {
	s.AssignedValue = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *Actuator) SetComment(v string) *Actuator {
	s.Comment = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *Actuator) SetDataType(v string) *Actuator {
	s.DataType = &v
	return s
}

// SetDeprecationMessage sets the DeprecationMessage field's value.
func (s *Actuator) SetDeprecationMessage(v string) *Actuator {
	s.DeprecationMessage = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Actuator) SetDescription(v string) *Actuator {
	s.Description = &v
	return s
}

// SetFullyQualifiedName sets the FullyQualifiedName field's value.
func (s *Actuator) SetFullyQualifiedName(v string) *Actuator {
	s.FullyQualifiedName = &v
	return s
}

// SetMax sets the Max field's value.
func (s *Actuator) SetMax(v float64) *Actuator {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *Actuator) SetMin(v float64) *Actuator {
	s.Min = &v
	return s
}

// SetStructFullyQualifiedName sets the StructFullyQualifiedName field's value.
func (s *Actuator) SetStructFullyQualifiedName(v string) *Actuator {
	s.StructFullyQualifiedName = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *Actuator) SetUnit(v string) *Actuator {
	s.Unit = &v
	return s
}

type AssociateVehicleFleetInput struct {
	_ struct{} `type:"structure"`

	// The ID of a fleet.
	//
	// FleetId is a required field
	FleetId *string `locationName:"fleetId" min:"1" type:"string" required:"true"`

	// The unique ID of the vehicle to associate with the fleet.
	//
	// VehicleName is a required field
	VehicleName *string `locationName:"vehicleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateVehicleFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateVehicleFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateVehicleFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateVehicleFleetInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}
	if s.VehicleName == nil {
		invalidParams.Add(request.NewErrParamRequired("VehicleName"))
	}
	if s.VehicleName != nil && len(*s.VehicleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VehicleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *AssociateVehicleFleetInput) SetFleetId(v string) *AssociateVehicleFleetInput {
	s.FleetId = &v
	return s
}

// SetVehicleName sets the VehicleName field's value.
func (s *AssociateVehicleFleetInput) SetVehicleName(v string) *AssociateVehicleFleetInput {
	s.VehicleName = &v
	return s
}

type AssociateVehicleFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateVehicleFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateVehicleFleetOutput) GoString() string {
	return s.String()
}

// A signal that represents static information about the vehicle, such as engine
// type or manufacturing date.
type Attribute struct {
	_ struct{} `type:"structure"`

	// A list of possible values an attribute can be assigned.
	AllowedValues []*string `locationName:"allowedValues" type:"list"`

	// A specified value for the attribute.
	//
	// Deprecated: assignedValue is no longer in use
	AssignedValue *string `locationName:"assignedValue" deprecated:"true" type:"string"`

	// A comment in addition to the description.
	Comment *string `locationName:"comment" min:"1" type:"string"`

	// The specified data type of the attribute.
	//
	// DataType is a required field
	DataType *string `locationName:"dataType" type:"string" required:"true" enum:"NodeDataType"`

	// The default value of the attribute.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// The deprecation message for the node or the branch that was moved or deleted.
	DeprecationMessage *string `locationName:"deprecationMessage" min:"1" type:"string"`

	// A brief description of the attribute.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The fully qualified name of the attribute. For example, the fully qualified
	// name of an attribute might be Vehicle.Body.Engine.Type.
	//
	// FullyQualifiedName is a required field
	FullyQualifiedName *string `locationName:"fullyQualifiedName" type:"string" required:"true"`

	// The specified possible maximum value of the attribute.
	Max *float64 `locationName:"max" type:"double"`

	// The specified possible minimum value of the attribute.
	Min *float64 `locationName:"min" type:"double"`

	// The scientific unit for the attribute.
	Unit *string `locationName:"unit" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Attribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Attribute"}
	if s.Comment != nil && len(*s.Comment) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Comment", 1))
	}
	if s.DataType == nil {
		invalidParams.Add(request.NewErrParamRequired("DataType"))
	}
	if s.DeprecationMessage != nil && len(*s.DeprecationMessage) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeprecationMessage", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.FullyQualifiedName == nil {
		invalidParams.Add(request.NewErrParamRequired("FullyQualifiedName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *Attribute) SetAllowedValues(v []*string) *Attribute {
	s.AllowedValues = v
	return s
}

// SetAssignedValue sets the AssignedValue field's value.
func (s *Attribute) SetAssignedValue(v string) *Attribute {
	s.AssignedValue = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *Attribute) SetComment(v string) *Attribute {
	s.Comment = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *Attribute) SetDataType(v string) *Attribute {
	s.DataType = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *Attribute) SetDefaultValue(v string) *Attribute {
	s.DefaultValue = &v
	return s
}

// SetDeprecationMessage sets the DeprecationMessage field's value.
func (s *Attribute) SetDeprecationMessage(v string) *Attribute {
	s.DeprecationMessage = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Attribute) SetDescription(v string) *Attribute {
	s.Description = &v
	return s
}

// SetFullyQualifiedName sets the FullyQualifiedName field's value.
func (s *Attribute) SetFullyQualifiedName(v string) *Attribute {
	s.FullyQualifiedName = &v
	return s
}

// SetMax sets the Max field's value.
func (s *Attribute) SetMax(v float64) *Attribute {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *Attribute) SetMin(v float64) *Attribute {
	s.Min = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *Attribute) SetUnit(v string) *Attribute {
	s.Unit = &v
	return s
}

type BatchCreateVehicleInput struct {
	_ struct{} `type:"structure"`

	// A list of information about each vehicle to create. For more information,
	// see the API data type.
	//
	// Vehicles is a required field
	Vehicles []*CreateVehicleRequestItem `locationName:"vehicles" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateVehicleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateVehicleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCreateVehicleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchCreateVehicleInput"}
	if s.Vehicles == nil {
		invalidParams.Add(request.NewErrParamRequired("Vehicles"))
	}
	if s.Vehicles != nil && len(s.Vehicles) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Vehicles", 1))
	}
	if s.Vehicles != nil {
		for i, v := range s.Vehicles {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Vehicles", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVehicles sets the Vehicles field's value.
func (s *BatchCreateVehicleInput) SetVehicles(v []*CreateVehicleRequestItem) *BatchCreateVehicleInput {
	s.Vehicles = v
	return s
}

type BatchCreateVehicleOutput struct {
	_ struct{} `type:"structure"`

	// A list of information about creation errors, or an empty list if there aren't
	// any errors.
	Errors []*CreateVehicleError `locationName:"errors" type:"list"`

	// A list of information about a batch of created vehicles. For more information,
	// see the API data type.
	Vehicles []*CreateVehicleResponseItem `locationName:"vehicles" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateVehicleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateVehicleOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchCreateVehicleOutput) SetErrors(v []*CreateVehicleError) *BatchCreateVehicleOutput {
	s.Errors = v
	return s
}

// SetVehicles sets the Vehicles field's value.
func (s *BatchCreateVehicleOutput) SetVehicles(v []*CreateVehicleResponseItem) *BatchCreateVehicleOutput {
	s.Vehicles = v
	return s
}

type BatchUpdateVehicleInput struct {
	_ struct{} `type:"structure"`

	// A list of information about the vehicles to update. For more information,
	// see the API data type.
	//
	// Vehicles is a required field
	Vehicles []*UpdateVehicleRequestItem `locationName:"vehicles" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateVehicleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateVehicleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateVehicleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdateVehicleInput"}
	if s.Vehicles == nil {
		invalidParams.Add(request.NewErrParamRequired("Vehicles"))
	}
	if s.Vehicles != nil && len(s.Vehicles) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Vehicles", 1))
	}
	if s.Vehicles != nil {
		for i, v := range s.Vehicles {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Vehicles", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVehicles sets the Vehicles field's value.
func (s *BatchUpdateVehicleInput) SetVehicles(v []*UpdateVehicleRequestItem) *BatchUpdateVehicleInput {
	s.Vehicles = v
	return s
}

type BatchUpdateVehicleOutput struct {
	_ struct{} `type:"structure"`

	// A list of information about errors returned while updating a batch of vehicles,
	// or, if there aren't any errors, an empty list.
	Errors []*UpdateVehicleError `locationName:"errors" type:"list"`

	// A list of information about the batch of updated vehicles.
	//
	// This list contains only unique IDs for the vehicles that were updated.
	Vehicles []*UpdateVehicleResponseItem `locationName:"vehicles" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateVehicleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateVehicleOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchUpdateVehicleOutput) SetErrors(v []*UpdateVehicleError) *BatchUpdateVehicleOutput {
	s.Errors = v
	return s
}

// SetVehicles sets the Vehicles field's value.
func (s *BatchUpdateVehicleOutput) SetVehicles(v []*UpdateVehicleResponseItem) *BatchUpdateVehicleOutput {
	s.Vehicles = v
	return s
}

// A group of signals that are defined in a hierarchical structure.
type Branch struct {
	_ struct{} `type:"structure"`

	// A comment in addition to the description.
	Comment *string `locationName:"comment" min:"1" type:"string"`

	// The deprecation message for the node or the branch that was moved or deleted.
	DeprecationMessage *string `locationName:"deprecationMessage" min:"1" type:"string"`

	// A brief description of the branch.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The fully qualified name of the branch. For example, the fully qualified
	// name of a branch might be Vehicle.Body.Engine.
	//
	// FullyQualifiedName is a required field
	FullyQualifiedName *string `locationName:"fullyQualifiedName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Branch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Branch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Branch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Branch"}
	if s.Comment != nil && len(*s.Comment) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Comment", 1))
	}
	if s.DeprecationMessage != nil && len(*s.DeprecationMessage) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeprecationMessage", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.FullyQualifiedName == nil {
		invalidParams.Add(request.NewErrParamRequired("FullyQualifiedName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *Branch) SetComment(v string) *Branch {
	s.Comment = &v
	return s
}

// SetDeprecationMessage sets the DeprecationMessage field's value.
func (s *Branch) SetDeprecationMessage(v string) *Branch {
	s.DeprecationMessage = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Branch) SetDescription(v string) *Branch {
	s.Description = &v
	return s
}

// SetFullyQualifiedName sets the FullyQualifiedName field's value.
func (s *Branch) SetFullyQualifiedName(v string) *Branch {
	s.FullyQualifiedName = &v
	return s
}

// Information about a campaign.
//
// You can use the API operation to return this information about multiple created
// campaigns.
type CampaignSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of a campaign.
	Arn *string `locationName:"arn" type:"string"`

	// The time the campaign was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// The description of the campaign.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The last time the campaign was modified.
	//
	// LastModificationTime is a required field
	LastModificationTime *time.Time `locationName:"lastModificationTime" type:"timestamp" required:"true"`

	// The name of a campaign.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The ARN of the signal catalog associated with the campaign.
	SignalCatalogArn *string `locationName:"signalCatalogArn" type:"string"`

	// The state of a campaign. The status can be one of the following:
	//
	//    * CREATING - Amazon Web Services IoT FleetWise is processing your request
	//    to create the campaign.
	//
	//    * WAITING_FOR_APPROVAL - After a campaign is created, it enters the WAITING_FOR_APPROVAL
	//    state. To allow Amazon Web Services IoT FleetWise to deploy the campaign
	//    to the target vehicle or fleet, use the API operation to approve the campaign.
	//
	//    * RUNNING - The campaign is active.
	//
	//    * SUSPENDED - The campaign is suspended. To resume the campaign, use the
	//    API operation.
	Status *string `locationName:"status" type:"string" enum:"CampaignStatus"`

	// The ARN of a vehicle or fleet to which the campaign is deployed.
	TargetArn *string `locationName:"targetArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CampaignSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CampaignSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CampaignSummary) SetArn(v string) *CampaignSummary {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CampaignSummary) SetCreationTime(v time.Time) *CampaignSummary {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CampaignSummary) SetDescription(v string) *CampaignSummary {
	s.Description = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *CampaignSummary) SetLastModificationTime(v time.Time) *CampaignSummary {
	s.LastModificationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *CampaignSummary) SetName(v string) *CampaignSummary {
	s.Name = &v
	return s
}

// SetSignalCatalogArn sets the SignalCatalogArn field's value.
func (s *CampaignSummary) SetSignalCatalogArn(v string) *CampaignSummary {
	s.SignalCatalogArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CampaignSummary) SetStatus(v string) *CampaignSummary {
	s.Status = &v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *CampaignSummary) SetTargetArn(v string) *CampaignSummary {
	s.TargetArn = &v
	return s
}

// Configurations used to create a decoder manifest.
type CanDbcDefinition struct {
	_ struct{} `type:"structure"`

	// A list of DBC files. You can upload only one DBC file for each network interface
	// and specify up to five (inclusive) files in the list. The DBC file can be
	// a maximum size of 200 MB.
	//
	// CanDbcFiles is a required field
	CanDbcFiles [][]byte `locationName:"canDbcFiles" min:"1" type:"list" required:"true"`

	// Contains information about a network interface.
	//
	// NetworkInterface is a required field
	NetworkInterface *string `locationName:"networkInterface" min:"1" type:"string" required:"true"`

	// Pairs every signal specified in your vehicle model with a signal decoder.
	SignalsMap map[string]*string `locationName:"signalsMap" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CanDbcDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CanDbcDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CanDbcDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CanDbcDefinition"}
	if s.CanDbcFiles == nil {
		invalidParams.Add(request.NewErrParamRequired("CanDbcFiles"))
	}
	if s.CanDbcFiles != nil && len(s.CanDbcFiles) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CanDbcFiles", 1))
	}
	if s.NetworkInterface == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkInterface"))
	}
	if s.NetworkInterface != nil && len(*s.NetworkInterface) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkInterface", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCanDbcFiles sets the CanDbcFiles field's value.
func (s *CanDbcDefinition) SetCanDbcFiles(v [][]byte) *CanDbcDefinition {
	s.CanDbcFiles = v
	return s
}

// SetNetworkInterface sets the NetworkInterface field's value.
func (s *CanDbcDefinition) SetNetworkInterface(v string) *CanDbcDefinition {
	s.NetworkInterface = &v
	return s
}

// SetSignalsMap sets the SignalsMap field's value.
func (s *CanDbcDefinition) SetSignalsMap(v map[string]*string) *CanDbcDefinition {
	s.SignalsMap = v
	return s
}

// A single controller area network (CAN) device interface.
type CanInterface struct {
	_ struct{} `type:"structure"`

	// The unique name of the interface.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The name of the communication protocol for the interface.
	ProtocolName *string `locationName:"protocolName" min:"1" type:"string"`

	// The version of the communication protocol for the interface.
	ProtocolVersion *string `locationName:"protocolVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CanInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CanInterface) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CanInterface) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CanInterface"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ProtocolName != nil && len(*s.ProtocolName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProtocolName", 1))
	}
	if s.ProtocolVersion != nil && len(*s.ProtocolVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProtocolVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CanInterface) SetName(v string) *CanInterface {
	s.Name = &v
	return s
}

// SetProtocolName sets the ProtocolName field's value.
func (s *CanInterface) SetProtocolName(v string) *CanInterface {
	s.ProtocolName = &v
	return s
}

// SetProtocolVersion sets the ProtocolVersion field's value.
func (s *CanInterface) SetProtocolVersion(v string) *CanInterface {
	s.ProtocolVersion = &v
	return s
}

// Information about a single controller area network (CAN) signal and the messages
// it receives and transmits.
type CanSignal struct {
	_ struct{} `type:"structure"`

	// A multiplier used to decode the CAN message.
	//
	// Factor is a required field
	Factor *float64 `locationName:"factor" type:"double" required:"true"`

	// Whether the byte ordering of a CAN message is big-endian.
	//
	// IsBigEndian is a required field
	IsBigEndian *bool `locationName:"isBigEndian" type:"boolean" required:"true"`

	// Whether the message data is specified as a signed value.
	//
	// IsSigned is a required field
	IsSigned *bool `locationName:"isSigned" type:"boolean" required:"true"`

	// How many bytes of data are in the message.
	//
	// Length is a required field
	Length *int64 `locationName:"length" type:"integer" required:"true"`

	// The ID of the message.
	//
	// MessageId is a required field
	MessageId *int64 `locationName:"messageId" type:"integer" required:"true"`

	// The name of the signal.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The offset used to calculate the signal value. Combined with factor, the
	// calculation is value = raw_value * factor + offset.
	//
	// Offset is a required field
	Offset *float64 `locationName:"offset" type:"double" required:"true"`

	// Indicates the beginning of the CAN signal. This should always be the least
	// significant bit (LSB).
	//
	// This value might be different from the value in a DBC file. For little endian
	// signals, startBit is the same value as in the DBC file. For big endian signals
	// in a DBC file, the start bit is the most significant bit (MSB). You will
	// have to calculate the LSB instead and pass it as the startBit.
	//
	// StartBit is a required field
	StartBit *int64 `locationName:"startBit" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CanSignal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CanSignal) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CanSignal) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CanSignal"}
	if s.Factor == nil {
		invalidParams.Add(request.NewErrParamRequired("Factor"))
	}
	if s.IsBigEndian == nil {
		invalidParams.Add(request.NewErrParamRequired("IsBigEndian"))
	}
	if s.IsSigned == nil {
		invalidParams.Add(request.NewErrParamRequired("IsSigned"))
	}
	if s.Length == nil {
		invalidParams.Add(request.NewErrParamRequired("Length"))
	}
	if s.MessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageId"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Offset == nil {
		invalidParams.Add(request.NewErrParamRequired("Offset"))
	}
	if s.StartBit == nil {
		invalidParams.Add(request.NewErrParamRequired("StartBit"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFactor sets the Factor field's value.
func (s *CanSignal) SetFactor(v float64) *CanSignal {
	s.Factor = &v
	return s
}

// SetIsBigEndian sets the IsBigEndian field's value.
func (s *CanSignal) SetIsBigEndian(v bool) *CanSignal {
	s.IsBigEndian = &v
	return s
}

// SetIsSigned sets the IsSigned field's value.
func (s *CanSignal) SetIsSigned(v bool) *CanSignal {
	s.IsSigned = &v
	return s
}

// SetLength sets the Length field's value.
func (s *CanSignal) SetLength(v int64) *CanSignal {
	s.Length = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *CanSignal) SetMessageId(v int64) *CanSignal {
	s.MessageId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CanSignal) SetName(v string) *CanSignal {
	s.Name = &v
	return s
}

// SetOffset sets the Offset field's value.
func (s *CanSignal) SetOffset(v float64) *CanSignal {
	s.Offset = &v
	return s
}

// SetStartBit sets the StartBit field's value.
func (s *CanSignal) SetStartBit(v int64) *CanSignal {
	s.StartBit = &v
	return s
}

// The log delivery option to send data to Amazon CloudWatch Logs.
type CloudWatchLogDeliveryOptions struct {
	_ struct{} `type:"structure"`

	// The Amazon CloudWatch Logs group the operation sends data to.
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string"`

	// The type of log to send data to Amazon CloudWatch Logs.
	//
	// LogType is a required field
	LogType *string `locationName:"logType" type:"string" required:"true" enum:"LogType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogDeliveryOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogDeliveryOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchLogDeliveryOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchLogDeliveryOptions"}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogGroupName", 1))
	}
	if s.LogType == nil {
		invalidParams.Add(request.NewErrParamRequired("LogType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *CloudWatchLogDeliveryOptions) SetLogGroupName(v string) *CloudWatchLogDeliveryOptions {
	s.LogGroupName = &v
	return s
}

// SetLogType sets the LogType field's value.
func (s *CloudWatchLogDeliveryOptions) SetLogType(v string) *CloudWatchLogDeliveryOptions {
	s.LogType = &v
	return s
}

// Specifies what data to collect and how often or when to collect it.
type CollectionScheme struct {
	_ struct{} `type:"structure"`

	// Information about a collection scheme that uses a simple logical expression
	// to recognize what data to collect.
	ConditionBasedCollectionScheme *ConditionBasedCollectionScheme `locationName:"conditionBasedCollectionScheme" type:"structure"`

	// Information about a collection scheme that uses a time period to decide how
	// often to collect data.
	TimeBasedCollectionScheme *TimeBasedCollectionScheme `locationName:"timeBasedCollectionScheme" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollectionScheme) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollectionScheme) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CollectionScheme) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CollectionScheme"}
	if s.ConditionBasedCollectionScheme != nil {
		if err := s.ConditionBasedCollectionScheme.Validate(); err != nil {
			invalidParams.AddNested("ConditionBasedCollectionScheme", err.(request.ErrInvalidParams))
		}
	}
	if s.TimeBasedCollectionScheme != nil {
		if err := s.TimeBasedCollectionScheme.Validate(); err != nil {
			invalidParams.AddNested("TimeBasedCollectionScheme", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConditionBasedCollectionScheme sets the ConditionBasedCollectionScheme field's value.
func (s *CollectionScheme) SetConditionBasedCollectionScheme(v *ConditionBasedCollectionScheme) *CollectionScheme {
	s.ConditionBasedCollectionScheme = v
	return s
}

// SetTimeBasedCollectionScheme sets the TimeBasedCollectionScheme field's value.
func (s *CollectionScheme) SetTimeBasedCollectionScheme(v *TimeBasedCollectionScheme) *CollectionScheme {
	s.TimeBasedCollectionScheme = v
	return s
}

// Information about a collection scheme that uses a simple logical expression
// to recognize what data to collect.
type ConditionBasedCollectionScheme struct {
	_ struct{} `type:"structure"`

	// Specifies the version of the conditional expression language.
	ConditionLanguageVersion *int64 `locationName:"conditionLanguageVersion" min:"1" type:"integer"`

	// The logical expression used to recognize what data to collect. For example,
	// $variable.`Vehicle.OutsideAirTemperature` >= 105.0.
	//
	// Expression is a required field
	Expression *string `locationName:"expression" min:"1" type:"string" required:"true"`

	// The minimum duration of time between two triggering events to collect data,
	// in milliseconds.
	//
	// If a signal changes often, you might want to collect data at a slower rate.
	MinimumTriggerIntervalMs *int64 `locationName:"minimumTriggerIntervalMs" type:"long"`

	// Whether to collect data for all triggering events (ALWAYS). Specify (RISING_EDGE),
	// or specify only when the condition first evaluates to false. For example,
	// triggering on "AirbagDeployed"; Users aren't interested on triggering when
	// the airbag is already exploded; they only care about the change from not
	// deployed => deployed.
	TriggerMode *string `locationName:"triggerMode" type:"string" enum:"TriggerMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionBasedCollectionScheme) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionBasedCollectionScheme) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConditionBasedCollectionScheme) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConditionBasedCollectionScheme"}
	if s.ConditionLanguageVersion != nil && *s.ConditionLanguageVersion < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ConditionLanguageVersion", 1))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConditionLanguageVersion sets the ConditionLanguageVersion field's value.
func (s *ConditionBasedCollectionScheme) SetConditionLanguageVersion(v int64) *ConditionBasedCollectionScheme {
	s.ConditionLanguageVersion = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *ConditionBasedCollectionScheme) SetExpression(v string) *ConditionBasedCollectionScheme {
	s.Expression = &v
	return s
}

// SetMinimumTriggerIntervalMs sets the MinimumTriggerIntervalMs field's value.
func (s *ConditionBasedCollectionScheme) SetMinimumTriggerIntervalMs(v int64) *ConditionBasedCollectionScheme {
	s.MinimumTriggerIntervalMs = &v
	return s
}

// SetTriggerMode sets the TriggerMode field's value.
func (s *ConditionBasedCollectionScheme) SetTriggerMode(v string) *ConditionBasedCollectionScheme {
	s.TriggerMode = &v
	return s
}

// The request has conflicting operations. This can occur if you're trying to
// perform more than one operation on the same resource at the same time.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The resource on which there are conflicting operations.
	//
	// Resource is a required field
	Resource *string `locationName:"resource" type:"string" required:"true"`

	// The type of resource on which there are conflicting operations..
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateCampaignInput struct {
	_ struct{} `type:"structure"`

	// The data collection scheme associated with the campaign. You can specify
	// a scheme that collects data based on time or an event.
	//
	// CollectionScheme is a required field
	CollectionScheme *CollectionScheme `locationName:"collectionScheme" type:"structure" required:"true"`

	// (Optional) Whether to compress signals before transmitting data to Amazon
	// Web Services IoT FleetWise. If you don't want to compress the signals, use
	// OFF. If it's not specified, SNAPPY is used.
	//
	// Default: SNAPPY
	Compression *string `locationName:"compression" type:"string" enum:"Compression"`

	// The destination where the campaign sends data. You can choose to send data
	// to be stored in Amazon S3 or Amazon Timestream.
	//
	// Amazon S3 optimizes the cost of data storage and provides additional mechanisms
	// to use vehicle data, such as data lakes, centralized data storage, data processing
	// pipelines, and analytics. Amazon Web Services IoT FleetWise supports at-least-once
	// file delivery to S3. Your vehicle data is stored on multiple Amazon Web Services
	// IoT FleetWise servers for redundancy and high availability.
	//
	// You can use Amazon Timestream to access and analyze time series data, and
	// Timestream to query vehicle data so that you can identify trends and patterns.
	DataDestinationConfigs []*DataDestinationConfig `locationName:"dataDestinationConfigs" min:"1" type:"list"`

	// (Optional) A list of vehicle attributes to associate with a campaign.
	//
	// Enrich the data with specified vehicle attributes. For example, add make
	// and model to the campaign, and Amazon Web Services IoT FleetWise will associate
	// the data with those attributes as dimensions in Amazon Timestream. You can
	// then query the data against make and model.
	//
	// Default: An empty array
	DataExtraDimensions []*string `locationName:"dataExtraDimensions" type:"list"`

	// An optional description of the campaign to help identify its purpose.
	Description *string `locationName:"description" min:"1" type:"string"`

	// (Optional) Option for a vehicle to send diagnostic trouble codes to Amazon
	// Web Services IoT FleetWise. If you want to send diagnostic trouble codes,
	// use SEND_ACTIVE_DTCS. If it's not specified, OFF is used.
	//
	// Default: OFF
	DiagnosticsMode *string `locationName:"diagnosticsMode" type:"string" enum:"DiagnosticsMode"`

	// (Optional) The time the campaign expires, in seconds since epoch (January
	// 1, 1970 at midnight UTC time). Vehicle data isn't collected after the campaign
	// expires.
	//
	// Default: 253402214400 (December 31, 9999, 00:00:00 UTC)
	ExpiryTime *time.Time `locationName:"expiryTime" type:"timestamp"`

	// The name of the campaign to create.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// (Optional) How long (in milliseconds) to collect raw data after a triggering
	// event initiates the collection. If it's not specified, 0 is used.
	//
	// Default: 0
	PostTriggerCollectionDuration *int64 `locationName:"postTriggerCollectionDuration" type:"long"`

	// (Optional) A number indicating the priority of one campaign over another
	// campaign for a certain vehicle or fleet. A campaign with the lowest value
	// is deployed to vehicles before any other campaigns. If it's not specified,
	// 0 is used.
	//
	// Default: 0
	Priority *int64 `locationName:"priority" type:"integer"`

	// (Optional) The Amazon Resource Name (ARN) of the signal catalog to associate
	// with the campaign.
	//
	// SignalCatalogArn is a required field
	SignalCatalogArn *string `locationName:"signalCatalogArn" type:"string" required:"true"`

	// (Optional) A list of information about signals to collect.
	SignalsToCollect []*SignalInformation `locationName:"signalsToCollect" type:"list"`

	// (Optional) Whether to store collected data after a vehicle lost a connection
	// with the cloud. After a connection is re-established, the data is automatically
	// forwarded to Amazon Web Services IoT FleetWise. If you want to store collected
	// data when a vehicle loses connection with the cloud, use TO_DISK. If it's
	// not specified, OFF is used.
	//
	// Default: OFF
	SpoolingMode *string `locationName:"spoolingMode" type:"string" enum:"SpoolingMode"`

	// (Optional) The time, in milliseconds, to deliver a campaign after it was
	// approved. If it's not specified, 0 is used.
	//
	// Default: 0
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// Metadata that can be used to manage the campaign.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The ARN of the vehicle or fleet to deploy a campaign to.
	//
	// TargetArn is a required field
	TargetArn *string `locationName:"targetArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCampaignInput"}
	if s.CollectionScheme == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionScheme"))
	}
	if s.DataDestinationConfigs != nil && len(s.DataDestinationConfigs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataDestinationConfigs", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SignalCatalogArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SignalCatalogArn"))
	}
	if s.TargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetArn"))
	}
	if s.CollectionScheme != nil {
		if err := s.CollectionScheme.Validate(); err != nil {
			invalidParams.AddNested("CollectionScheme", err.(request.ErrInvalidParams))
		}
	}
	if s.DataDestinationConfigs != nil {
		for i, v := range s.DataDestinationConfigs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataDestinationConfigs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SignalsToCollect != nil {
		for i, v := range s.SignalsToCollect {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SignalsToCollect", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionScheme sets the CollectionScheme field's value.
func (s *CreateCampaignInput) SetCollectionScheme(v *CollectionScheme) *CreateCampaignInput {
	s.CollectionScheme = v
	return s
}

// SetCompression sets the Compression field's value.
func (s *CreateCampaignInput) SetCompression(v string) *CreateCampaignInput {
	s.Compression = &v
	return s
}

// SetDataDestinationConfigs sets the DataDestinationConfigs field's value.
func (s *CreateCampaignInput) SetDataDestinationConfigs(v []*DataDestinationConfig) *CreateCampaignInput {
	s.DataDestinationConfigs = v
	return s
}

// SetDataExtraDimensions sets the DataExtraDimensions field's value.
func (s *CreateCampaignInput) SetDataExtraDimensions(v []*string) *CreateCampaignInput {
	s.DataExtraDimensions = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateCampaignInput) SetDescription(v string) *CreateCampaignInput {
	s.Description = &v
	return s
}

// SetDiagnosticsMode sets the DiagnosticsMode field's value.
func (s *CreateCampaignInput) SetDiagnosticsMode(v string) *CreateCampaignInput {
	s.DiagnosticsMode = &v
	return s
}

// SetExpiryTime sets the ExpiryTime field's value.
func (s *CreateCampaignInput) SetExpiryTime(v time.Time) *CreateCampaignInput {
	s.ExpiryTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCampaignInput) SetName(v string) *CreateCampaignInput {
	s.Name = &v
	return s
}

// SetPostTriggerCollectionDuration sets the PostTriggerCollectionDuration field's value.
func (s *CreateCampaignInput) SetPostTriggerCollectionDuration(v int64) *CreateCampaignInput {
	s.PostTriggerCollectionDuration = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *CreateCampaignInput) SetPriority(v int64) *CreateCampaignInput {
	s.Priority = &v
	return s
}

// SetSignalCatalogArn sets the SignalCatalogArn field's value.
func (s *CreateCampaignInput) SetSignalCatalogArn(v string) *CreateCampaignInput {
	s.SignalCatalogArn = &v
	return s
}

// SetSignalsToCollect sets the SignalsToCollect field's value.
func (s *CreateCampaignInput) SetSignalsToCollect(v []*SignalInformation) *CreateCampaignInput {
	s.SignalsToCollect = v
	return s
}

// SetSpoolingMode sets the SpoolingMode field's value.
func (s *CreateCampaignInput) SetSpoolingMode(v string) *CreateCampaignInput {
	s.SpoolingMode = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CreateCampaignInput) SetStartTime(v time.Time) *CreateCampaignInput {
	s.StartTime = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCampaignInput) SetTags(v []*Tag) *CreateCampaignInput {
	s.Tags = v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *CreateCampaignInput) SetTargetArn(v string) *CreateCampaignInput {
	s.TargetArn = &v
	return s
}

type CreateCampaignOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the created campaign.
	Arn *string `locationName:"arn" type:"string"`

	// The name of the created campaign.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCampaignOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateCampaignOutput) SetArn(v string) *CreateCampaignOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCampaignOutput) SetName(v string) *CreateCampaignOutput {
	s.Name = &v
	return s
}

type CreateDecoderManifestInput struct {
	_ struct{} `type:"structure"`

	// A brief description of the decoder manifest.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the vehicle model (model manifest).
	//
	// ModelManifestArn is a required field
	ModelManifestArn *string `locationName:"modelManifestArn" type:"string" required:"true"`

	// The unique name of the decoder manifest to create.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A list of information about available network interfaces.
	NetworkInterfaces []*NetworkInterface `locationName:"networkInterfaces" min:"1" type:"list"`

	// A list of information about signal decoders.
	SignalDecoders []*SignalDecoder `locationName:"signalDecoders" min:"1" type:"list"`

	// Metadata that can be used to manage the decoder manifest.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDecoderManifestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDecoderManifestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDecoderManifestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDecoderManifestInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ModelManifestArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelManifestArn"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NetworkInterfaces != nil && len(s.NetworkInterfaces) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkInterfaces", 1))
	}
	if s.SignalDecoders != nil && len(s.SignalDecoders) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SignalDecoders", 1))
	}
	if s.NetworkInterfaces != nil {
		for i, v := range s.NetworkInterfaces {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NetworkInterfaces", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SignalDecoders != nil {
		for i, v := range s.SignalDecoders {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SignalDecoders", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateDecoderManifestInput) SetDescription(v string) *CreateDecoderManifestInput {
	s.Description = &v
	return s
}

// SetModelManifestArn sets the ModelManifestArn field's value.
func (s *CreateDecoderManifestInput) SetModelManifestArn(v string) *CreateDecoderManifestInput {
	s.ModelManifestArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDecoderManifestInput) SetName(v string) *CreateDecoderManifestInput {
	s.Name = &v
	return s
}

// SetNetworkInterfaces sets the NetworkInterfaces field's value.
func (s *CreateDecoderManifestInput) SetNetworkInterfaces(v []*NetworkInterface) *CreateDecoderManifestInput {
	s.NetworkInterfaces = v
	return s
}

// SetSignalDecoders sets the SignalDecoders field's value.
func (s *CreateDecoderManifestInput) SetSignalDecoders(v []*SignalDecoder) *CreateDecoderManifestInput {
	s.SignalDecoders = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDecoderManifestInput) SetTags(v []*Tag) *CreateDecoderManifestInput {
	s.Tags = v
	return s
}

type CreateDecoderManifestOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the created decoder manifest.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the created decoder manifest.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDecoderManifestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDecoderManifestOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDecoderManifestOutput) SetArn(v string) *CreateDecoderManifestOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDecoderManifestOutput) SetName(v string) *CreateDecoderManifestOutput {
	s.Name = &v
	return s
}

type CreateFleetInput struct {
	_ struct{} `type:"structure"`

	// A brief description of the fleet to create.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique ID of the fleet to create.
	//
	// FleetId is a required field
	FleetId *string `locationName:"fleetId" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of a signal catalog.
	//
	// SignalCatalogArn is a required field
	SignalCatalogArn *string `locationName:"signalCatalogArn" type:"string" required:"true"`

	// Metadata that can be used to manage the fleet.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFleetInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}
	if s.SignalCatalogArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SignalCatalogArn"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateFleetInput) SetDescription(v string) *CreateFleetInput {
	s.Description = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *CreateFleetInput) SetFleetId(v string) *CreateFleetInput {
	s.FleetId = &v
	return s
}

// SetSignalCatalogArn sets the SignalCatalogArn field's value.
func (s *CreateFleetInput) SetSignalCatalogArn(v string) *CreateFleetInput {
	s.SignalCatalogArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFleetInput) SetTags(v []*Tag) *CreateFleetInput {
	s.Tags = v
	return s
}

type CreateFleetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the created fleet.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The ID of the created fleet.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFleetOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateFleetOutput) SetArn(v string) *CreateFleetOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateFleetOutput) SetId(v string) *CreateFleetOutput {
	s.Id = &v
	return s
}

type CreateModelManifestInput struct {
	_ struct{} `type:"structure"`

	// A brief description of the vehicle model.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the vehicle model to create.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A list of nodes, which are a general abstraction of signals.
	//
	// Nodes is a required field
	Nodes []*string `locationName:"nodes" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of a signal catalog.
	//
	// SignalCatalogArn is a required field
	SignalCatalogArn *string `locationName:"signalCatalogArn" type:"string" required:"true"`

	// Metadata that can be used to manage the vehicle model.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelManifestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelManifestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateModelManifestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateModelManifestInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Nodes == nil {
		invalidParams.Add(request.NewErrParamRequired("Nodes"))
	}
	if s.SignalCatalogArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SignalCatalogArn"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateModelManifestInput) SetDescription(v string) *CreateModelManifestInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateModelManifestInput) SetName(v string) *CreateModelManifestInput {
	s.Name = &v
	return s
}

// SetNodes sets the Nodes field's value.
func (s *CreateModelManifestInput) SetNodes(v []*string) *CreateModelManifestInput {
	s.Nodes = v
	return s
}

// SetSignalCatalogArn sets the SignalCatalogArn field's value.
func (s *CreateModelManifestInput) SetSignalCatalogArn(v string) *CreateModelManifestInput {
	s.SignalCatalogArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateModelManifestInput) SetTags(v []*Tag) *CreateModelManifestInput {
	s.Tags = v
	return s
}

type CreateModelManifestOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the created vehicle model.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the created vehicle model.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelManifestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelManifestOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateModelManifestOutput) SetArn(v string) *CreateModelManifestOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateModelManifestOutput) SetName(v string) *CreateModelManifestOutput {
	s.Name = &v
	return s
}

type CreateSignalCatalogInput struct {
	_ struct{} `type:"structure"`

	// A brief description of the signal catalog.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the signal catalog to create.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A list of information about nodes, which are a general abstraction of signals.
	// For more information, see the API data type.
	Nodes []*Node `locationName:"nodes" type:"list"`

	// Metadata that can be used to manage the signal catalog.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSignalCatalogInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSignalCatalogInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSignalCatalogInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSignalCatalogInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Nodes != nil {
		for i, v := range s.Nodes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Nodes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateSignalCatalogInput) SetDescription(v string) *CreateSignalCatalogInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSignalCatalogInput) SetName(v string) *CreateSignalCatalogInput {
	s.Name = &v
	return s
}

// SetNodes sets the Nodes field's value.
func (s *CreateSignalCatalogInput) SetNodes(v []*Node) *CreateSignalCatalogInput {
	s.Nodes = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSignalCatalogInput) SetTags(v []*Tag) *CreateSignalCatalogInput {
	s.Tags = v
	return s
}

type CreateSignalCatalogOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the created signal catalog.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the created signal catalog.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSignalCatalogOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSignalCatalogOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateSignalCatalogOutput) SetArn(v string) *CreateSignalCatalogOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSignalCatalogOutput) SetName(v string) *CreateSignalCatalogOutput {
	s.Name = &v
	return s
}

// An HTTP error resulting from creating a vehicle.
type CreateVehicleError struct {
	_ struct{} `type:"structure"`

	// An HTTP error code.
	Code *string `locationName:"code" type:"string"`

	// A description of the HTTP error.
	Message *string `locationName:"message" type:"string"`

	// The ID of the vehicle with the error.
	VehicleName *string `locationName:"vehicleName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVehicleError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVehicleError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *CreateVehicleError) SetCode(v string) *CreateVehicleError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *CreateVehicleError) SetMessage(v string) *CreateVehicleError {
	s.Message = &v
	return s
}

// SetVehicleName sets the VehicleName field's value.
func (s *CreateVehicleError) SetVehicleName(v string) *CreateVehicleError {
	s.VehicleName = &v
	return s
}

type CreateVehicleInput struct {
	_ struct{} `type:"structure"`

	// An option to create a new Amazon Web Services IoT thing when creating a vehicle,
	// or to validate an existing Amazon Web Services IoT thing as a vehicle.
	//
	// Default:
	AssociationBehavior *string `locationName:"associationBehavior" type:"string" enum:"VehicleAssociationBehavior"`

	// Static information about a vehicle in a key-value pair. For example: "engineType"
	// : "1.3 L R2"
	//
	// A campaign must include the keys (attribute names) in dataExtraDimensions
	// for them to display in Amazon Timestream.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// The ARN of a decoder manifest.
	//
	// DecoderManifestArn is a required field
	DecoderManifestArn *string `locationName:"decoderManifestArn" type:"string" required:"true"`

	// The Amazon Resource Name ARN of a vehicle model.
	//
	// ModelManifestArn is a required field
	ModelManifestArn *string `locationName:"modelManifestArn" type:"string" required:"true"`

	// Metadata that can be used to manage the vehicle.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The unique ID of the vehicle to create.
	//
	// VehicleName is a required field
	VehicleName *string `locationName:"vehicleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVehicleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVehicleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVehicleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVehicleInput"}
	if s.DecoderManifestArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DecoderManifestArn"))
	}
	if s.ModelManifestArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelManifestArn"))
	}
	if s.VehicleName == nil {
		invalidParams.Add(request.NewErrParamRequired("VehicleName"))
	}
	if s.VehicleName != nil && len(*s.VehicleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VehicleName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociationBehavior sets the AssociationBehavior field's value.
func (s *CreateVehicleInput) SetAssociationBehavior(v string) *CreateVehicleInput {
	s.AssociationBehavior = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *CreateVehicleInput) SetAttributes(v map[string]*string) *CreateVehicleInput {
	s.Attributes = v
	return s
}

// SetDecoderManifestArn sets the DecoderManifestArn field's value.
func (s *CreateVehicleInput) SetDecoderManifestArn(v string) *CreateVehicleInput {
	s.DecoderManifestArn = &v
	return s
}

// SetModelManifestArn sets the ModelManifestArn field's value.
func (s *CreateVehicleInput) SetModelManifestArn(v string) *CreateVehicleInput {
	s.ModelManifestArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVehicleInput) SetTags(v []*Tag) *CreateVehicleInput {
	s.Tags = v
	return s
}

// SetVehicleName sets the VehicleName field's value.
func (s *CreateVehicleInput) SetVehicleName(v string) *CreateVehicleInput {
	s.VehicleName = &v
	return s
}

type CreateVehicleOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the created vehicle.
	Arn *string `locationName:"arn" type:"string"`

	// The ARN of a created or validated Amazon Web Services IoT thing.
	ThingArn *string `locationName:"thingArn" type:"string"`

	// The unique ID of the created vehicle.
	VehicleName *string `locationName:"vehicleName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVehicleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVehicleOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateVehicleOutput) SetArn(v string) *CreateVehicleOutput {
	s.Arn = &v
	return s
}

// SetThingArn sets the ThingArn field's value.
func (s *CreateVehicleOutput) SetThingArn(v string) *CreateVehicleOutput {
	s.ThingArn = &v
	return s
}

// SetVehicleName sets the VehicleName field's value.
func (s *CreateVehicleOutput) SetVehicleName(v string) *CreateVehicleOutput {
	s.VehicleName = &v
	return s
}

// Information about the vehicle to create.
type CreateVehicleRequestItem struct {
	_ struct{} `type:"structure"`

	// An option to create a new Amazon Web Services IoT thing when creating a vehicle,
	// or to validate an existing thing as a vehicle.
	AssociationBehavior *string `locationName:"associationBehavior" type:"string" enum:"VehicleAssociationBehavior"`

	// Static information about a vehicle in a key-value pair. For example: "engine
	// Type" : "v6"
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// The Amazon Resource Name (ARN) of a decoder manifest associated with the
	// vehicle to create.
	//
	// DecoderManifestArn is a required field
	DecoderManifestArn *string `locationName:"decoderManifestArn" type:"string" required:"true"`

	// The ARN of the vehicle model (model manifest) to create the vehicle from.
	//
	// ModelManifestArn is a required field
	ModelManifestArn *string `locationName:"modelManifestArn" type:"string" required:"true"`

	// Metadata which can be used to manage the vehicle.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The unique ID of the vehicle to create.
	//
	// VehicleName is a required field
	VehicleName *string `locationName:"vehicleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVehicleRequestItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVehicleRequestItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVehicleRequestItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVehicleRequestItem"}
	if s.DecoderManifestArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DecoderManifestArn"))
	}
	if s.ModelManifestArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelManifestArn"))
	}
	if s.VehicleName == nil {
		invalidParams.Add(request.NewErrParamRequired("VehicleName"))
	}
	if s.VehicleName != nil && len(*s.VehicleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VehicleName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociationBehavior sets the AssociationBehavior field's value.
func (s *CreateVehicleRequestItem) SetAssociationBehavior(v string) *CreateVehicleRequestItem {
	s.AssociationBehavior = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *CreateVehicleRequestItem) SetAttributes(v map[string]*string) *CreateVehicleRequestItem {
	s.Attributes = v
	return s
}

// SetDecoderManifestArn sets the DecoderManifestArn field's value.
func (s *CreateVehicleRequestItem) SetDecoderManifestArn(v string) *CreateVehicleRequestItem {
	s.DecoderManifestArn = &v
	return s
}

// SetModelManifestArn sets the ModelManifestArn field's value.
func (s *CreateVehicleRequestItem) SetModelManifestArn(v string) *CreateVehicleRequestItem {
	s.ModelManifestArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVehicleRequestItem) SetTags(v []*Tag) *CreateVehicleRequestItem {
	s.Tags = v
	return s
}

// SetVehicleName sets the VehicleName field's value.
func (s *CreateVehicleRequestItem) SetVehicleName(v string) *CreateVehicleRequestItem {
	s.VehicleName = &v
	return s
}

// Information about a created vehicle.
type CreateVehicleResponseItem struct {
	_ struct{} `type:"structure"`

	// The ARN of the created vehicle.
	Arn *string `locationName:"arn" type:"string"`

	// The ARN of a created or validated Amazon Web Services IoT thing.
	ThingArn *string `locationName:"thingArn" type:"string"`

	// The unique ID of the vehicle to create.
	VehicleName *string `locationName:"vehicleName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVehicleResponseItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVehicleResponseItem) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateVehicleResponseItem) SetArn(v string) *CreateVehicleResponseItem {
	s.Arn = &v
	return s
}

// SetThingArn sets the ThingArn field's value.
func (s *CreateVehicleResponseItem) SetThingArn(v string) *CreateVehicleResponseItem {
	s.ThingArn = &v
	return s
}

// SetVehicleName sets the VehicleName field's value.
func (s *CreateVehicleResponseItem) SetVehicleName(v string) *CreateVehicleResponseItem {
	s.VehicleName = &v
	return s
}

// Represents a member of the complex data structure. The data type of the property
// can be either primitive or another struct.
type CustomProperty struct {
	_ struct{} `type:"structure"`

	// A comment in addition to the description.
	Comment *string `locationName:"comment" min:"1" type:"string"`

	// Indicates whether the property is binary data.
	DataEncoding *string `locationName:"dataEncoding" type:"string" enum:"NodeDataEncoding"`

	// The data type for the custom property.
	//
	// DataType is a required field
	DataType *string `locationName:"dataType" type:"string" required:"true" enum:"NodeDataType"`

	// The deprecation message for the node or the branch that was moved or deleted.
	DeprecationMessage *string `locationName:"deprecationMessage" min:"1" type:"string"`

	// A brief description of the custom property.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The fully qualified name of the custom property. For example, the fully qualified
	// name of a custom property might be ComplexDataTypes.VehicleDataTypes.SVMCamera.FPS.
	//
	// FullyQualifiedName is a required field
	FullyQualifiedName *string `locationName:"fullyQualifiedName" type:"string" required:"true"`

	// The fully qualified name of the struct node for the custom property if the
	// data type of the custom property is Struct or StructArray.
	StructFullyQualifiedName *string `locationName:"structFullyQualifiedName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomProperty) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomProperty) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomProperty"}
	if s.Comment != nil && len(*s.Comment) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Comment", 1))
	}
	if s.DataType == nil {
		invalidParams.Add(request.NewErrParamRequired("DataType"))
	}
	if s.DeprecationMessage != nil && len(*s.DeprecationMessage) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeprecationMessage", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.FullyQualifiedName == nil {
		invalidParams.Add(request.NewErrParamRequired("FullyQualifiedName"))
	}
	if s.StructFullyQualifiedName != nil && len(*s.StructFullyQualifiedName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StructFullyQualifiedName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *CustomProperty) SetComment(v string) *CustomProperty {
	s.Comment = &v
	return s
}

// SetDataEncoding sets the DataEncoding field's value.
func (s *CustomProperty) SetDataEncoding(v string) *CustomProperty {
	s.DataEncoding = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *CustomProperty) SetDataType(v string) *CustomProperty {
	s.DataType = &v
	return s
}

// SetDeprecationMessage sets the DeprecationMessage field's value.
func (s *CustomProperty) SetDeprecationMessage(v string) *CustomProperty {
	s.DeprecationMessage = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CustomProperty) SetDescription(v string) *CustomProperty {
	s.Description = &v
	return s
}

// SetFullyQualifiedName sets the FullyQualifiedName field's value.
func (s *CustomProperty) SetFullyQualifiedName(v string) *CustomProperty {
	s.FullyQualifiedName = &v
	return s
}

// SetStructFullyQualifiedName sets the StructFullyQualifiedName field's value.
func (s *CustomProperty) SetStructFullyQualifiedName(v string) *CustomProperty {
	s.StructFullyQualifiedName = &v
	return s
}

// The custom structure represents a complex or higher-order data structure.
type CustomStruct struct {
	_ struct{} `type:"structure"`

	// A comment in addition to the description.
	Comment *string `locationName:"comment" min:"1" type:"string"`

	// The deprecation message for the node or the branch that was moved or deleted.
	DeprecationMessage *string `locationName:"deprecationMessage" min:"1" type:"string"`

	// A brief description of the custom structure.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The fully qualified name of the custom structure. For example, the fully
	// qualified name of a custom structure might be ComplexDataTypes.VehicleDataTypes.SVMCamera.
	//
	// FullyQualifiedName is a required field
	FullyQualifiedName *string `locationName:"fullyQualifiedName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomStruct) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomStruct) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomStruct) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomStruct"}
	if s.Comment != nil && len(*s.Comment) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Comment", 1))
	}
	if s.DeprecationMessage != nil && len(*s.DeprecationMessage) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeprecationMessage", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.FullyQualifiedName == nil {
		invalidParams.Add(request.NewErrParamRequired("FullyQualifiedName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *CustomStruct) SetComment(v string) *CustomStruct {
	s.Comment = &v
	return s
}

// SetDeprecationMessage sets the DeprecationMessage field's value.
func (s *CustomStruct) SetDeprecationMessage(v string) *CustomStruct {
	s.DeprecationMessage = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CustomStruct) SetDescription(v string) *CustomStruct {
	s.Description = &v
	return s
}

// SetFullyQualifiedName sets the FullyQualifiedName field's value.
func (s *CustomStruct) SetFullyQualifiedName(v string) *CustomStruct {
	s.FullyQualifiedName = &v
	return s
}

// The destination where the Amazon Web Services IoT FleetWise campaign sends
// data. You can send data to be stored in Amazon S3 or Amazon Timestream.
type DataDestinationConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket where the Amazon Web Services IoT FleetWise campaign
	// sends data.
	S3Config *S3Config `locationName:"s3Config" type:"structure"`

	// The Amazon Timestream table where the campaign sends data.
	TimestreamConfig *TimestreamConfig `locationName:"timestreamConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataDestinationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataDestinationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataDestinationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataDestinationConfig"}
	if s.S3Config != nil {
		if err := s.S3Config.Validate(); err != nil {
			invalidParams.AddNested("S3Config", err.(request.ErrInvalidParams))
		}
	}
	if s.TimestreamConfig != nil {
		if err := s.TimestreamConfig.Validate(); err != nil {
			invalidParams.AddNested("TimestreamConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Config sets the S3Config field's value.
func (s *DataDestinationConfig) SetS3Config(v *S3Config) *DataDestinationConfig {
	s.S3Config = v
	return s
}

// SetTimestreamConfig sets the TimestreamConfig field's value.
func (s *DataDestinationConfig) SetTimestreamConfig(v *TimestreamConfig) *DataDestinationConfig {
	s.TimestreamConfig = v
	return s
}

// Information about a created decoder manifest. You can use the API operation
// to return this information about multiple decoder manifests.
type DecoderManifestSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of a vehicle model (model manifest) associated with the decoder manifest.
	Arn *string `locationName:"arn" type:"string"`

	// The time the decoder manifest was created in seconds since epoch (January
	// 1, 1970 at midnight UTC time).
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// A brief description of the decoder manifest.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The time the decoder manifest was last updated in seconds since epoch (January
	// 1, 1970 at midnight UTC time).
	//
	// LastModificationTime is a required field
	LastModificationTime *time.Time `locationName:"lastModificationTime" type:"timestamp" required:"true"`

	// The detailed message for the decoder manifest. When a decoder manifest is
	// in an INVALID status, the message contains detailed reason and help information.
	Message *string `locationName:"message" min:"1" type:"string"`

	// The ARN of a vehicle model (model manifest) associated with the decoder manifest.
	ModelManifestArn *string `locationName:"modelManifestArn" type:"string"`

	// The name of the decoder manifest.
	Name *string `locationName:"name" type:"string"`

	// The state of the decoder manifest. If the status is ACTIVE, the decoder manifest
	// can't be edited. If the status is marked DRAFT, you can edit the decoder
	// manifest.
	Status *string `locationName:"status" type:"string" enum:"ManifestStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecoderManifestSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecoderManifestSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DecoderManifestSummary) SetArn(v string) *DecoderManifestSummary {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DecoderManifestSummary) SetCreationTime(v time.Time) *DecoderManifestSummary {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DecoderManifestSummary) SetDescription(v string) *DecoderManifestSummary {
	s.Description = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *DecoderManifestSummary) SetLastModificationTime(v time.Time) *DecoderManifestSummary {
	s.LastModificationTime = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DecoderManifestSummary) SetMessage(v string) *DecoderManifestSummary {
	s.Message = &v
	return s
}

// SetModelManifestArn sets the ModelManifestArn field's value.
func (s *DecoderManifestSummary) SetModelManifestArn(v string) *DecoderManifestSummary {
	s.ModelManifestArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *DecoderManifestSummary) SetName(v string) *DecoderManifestSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DecoderManifestSummary) SetStatus(v string) *DecoderManifestSummary {
	s.Status = &v
	return s
}

// The request couldn't be completed because it contains signal decoders with
// one or more validation errors.
type DecoderManifestValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The request couldn't be completed because of invalid network interfaces in
	// the request.
	InvalidNetworkInterfaces []*InvalidNetworkInterface `locationName:"invalidNetworkInterfaces" type:"list"`

	// The request couldn't be completed because of invalid signals in the request.
	InvalidSignals []*InvalidSignalDecoder `locationName:"invalidSignals" type:"list"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecoderManifestValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecoderManifestValidationException) GoString() string {
	return s.String()
}

func newErrorDecoderManifestValidationException(v protocol.ResponseMetadata) error {
	return &DecoderManifestValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DecoderManifestValidationException) Code() string {
	return "DecoderManifestValidationException"
}

// Message returns the exception's message.
func (s *DecoderManifestValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DecoderManifestValidationException) OrigErr() error {
	return nil
}

func (s *DecoderManifestValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DecoderManifestValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DecoderManifestValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DeleteCampaignInput struct {
	_ struct{} `type:"structure"`

	// The name of the campaign to delete.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCampaignInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteCampaignInput) SetName(v string) *DeleteCampaignInput {
	s.Name = &v
	return s
}

type DeleteCampaignOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted campaign.
	//
	// The ARN isn’t returned if a campaign doesn’t exist.
	Arn *string `locationName:"arn" type:"string"`

	// The name of the deleted campaign.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCampaignOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteCampaignOutput) SetArn(v string) *DeleteCampaignOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteCampaignOutput) SetName(v string) *DeleteCampaignOutput {
	s.Name = &v
	return s
}

type DeleteDecoderManifestInput struct {
	_ struct{} `type:"structure"`

	// The name of the decoder manifest to delete.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDecoderManifestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDecoderManifestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDecoderManifestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDecoderManifestInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteDecoderManifestInput) SetName(v string) *DeleteDecoderManifestInput {
	s.Name = &v
	return s
}

type DeleteDecoderManifestOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted decoder manifest.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the deleted decoder manifest.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDecoderManifestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDecoderManifestOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteDecoderManifestOutput) SetArn(v string) *DeleteDecoderManifestOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteDecoderManifestOutput) SetName(v string) *DeleteDecoderManifestOutput {
	s.Name = &v
	return s
}

type DeleteFleetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the fleet to delete.
	//
	// FleetId is a required field
	FleetId *string `locationName:"fleetId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFleetInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DeleteFleetInput) SetFleetId(v string) *DeleteFleetInput {
	s.FleetId = &v
	return s
}

type DeleteFleetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted fleet.
	Arn *string `locationName:"arn" type:"string"`

	// The ID of the deleted fleet.
	Id *string `locationName:"id" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteFleetOutput) SetArn(v string) *DeleteFleetOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteFleetOutput) SetId(v string) *DeleteFleetOutput {
	s.Id = &v
	return s
}

type DeleteModelManifestInput struct {
	_ struct{} `type:"structure"`

	// The name of the model manifest to delete.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelManifestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelManifestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteModelManifestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteModelManifestInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteModelManifestInput) SetName(v string) *DeleteModelManifestInput {
	s.Name = &v
	return s
}

type DeleteModelManifestOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted model manifest.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the deleted model manifest.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelManifestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelManifestOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteModelManifestOutput) SetArn(v string) *DeleteModelManifestOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteModelManifestOutput) SetName(v string) *DeleteModelManifestOutput {
	s.Name = &v
	return s
}

type DeleteSignalCatalogInput struct {
	_ struct{} `type:"structure"`

	// The name of the signal catalog to delete.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSignalCatalogInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSignalCatalogInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSignalCatalogInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSignalCatalogInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteSignalCatalogInput) SetName(v string) *DeleteSignalCatalogInput {
	s.Name = &v
	return s
}

type DeleteSignalCatalogOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted signal catalog.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the deleted signal catalog.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSignalCatalogOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSignalCatalogOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteSignalCatalogOutput) SetArn(v string) *DeleteSignalCatalogOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteSignalCatalogOutput) SetName(v string) *DeleteSignalCatalogOutput {
	s.Name = &v
	return s
}

type DeleteVehicleInput struct {
	_ struct{} `type:"structure"`

	// The ID of the vehicle to delete.
	//
	// VehicleName is a required field
	VehicleName *string `locationName:"vehicleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVehicleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVehicleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVehicleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVehicleInput"}
	if s.VehicleName == nil {
		invalidParams.Add(request.NewErrParamRequired("VehicleName"))
	}
	if s.VehicleName != nil && len(*s.VehicleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VehicleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVehicleName sets the VehicleName field's value.
func (s *DeleteVehicleInput) SetVehicleName(v string) *DeleteVehicleInput {
	s.VehicleName = &v
	return s
}

type DeleteVehicleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted vehicle.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The ID of the deleted vehicle.
	//
	// VehicleName is a required field
	VehicleName *string `locationName:"vehicleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVehicleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVehicleOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteVehicleOutput) SetArn(v string) *DeleteVehicleOutput {
	s.Arn = &v
	return s
}

// SetVehicleName sets the VehicleName field's value.
func (s *DeleteVehicleOutput) SetVehicleName(v string) *DeleteVehicleOutput {
	s.VehicleName = &v
	return s
}

type DisassociateVehicleFleetInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of a fleet.
	//
	// FleetId is a required field
	FleetId *string `locationName:"fleetId" min:"1" type:"string" required:"true"`

	// The unique ID of the vehicle to disassociate from the fleet.
	//
	// VehicleName is a required field
	VehicleName *string `locationName:"vehicleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateVehicleFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateVehicleFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateVehicleFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateVehicleFleetInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}
	if s.VehicleName == nil {
		invalidParams.Add(request.NewErrParamRequired("VehicleName"))
	}
	if s.VehicleName != nil && len(*s.VehicleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VehicleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DisassociateVehicleFleetInput) SetFleetId(v string) *DisassociateVehicleFleetInput {
	s.FleetId = &v
	return s
}

// SetVehicleName sets the VehicleName field's value.
func (s *DisassociateVehicleFleetInput) SetVehicleName(v string) *DisassociateVehicleFleetInput {
	s.VehicleName = &v
	return s
}

type DisassociateVehicleFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateVehicleFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateVehicleFleetOutput) GoString() string {
	return s.String()
}

// Information about a fleet.
//
// You can use the API operation to return this information about multiple fleets.
type FleetSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the fleet.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time the fleet was created, in seconds since epoch (January 1, 1970 at
	// midnight UTC time).
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// A brief description of the fleet.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique ID of the fleet.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The time the fleet was last updated in seconds since epoch (January 1, 1970
	// at midnight UTC time).
	LastModificationTime *time.Time `locationName:"lastModificationTime" type:"timestamp"`

	// The ARN of the signal catalog associated with the fleet.
	//
	// SignalCatalogArn is a required field
	SignalCatalogArn *string `locationName:"signalCatalogArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *FleetSummary) SetArn(v string) *FleetSummary {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *FleetSummary) SetCreationTime(v time.Time) *FleetSummary {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *FleetSummary) SetDescription(v string) *FleetSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *FleetSummary) SetId(v string) *FleetSummary {
	s.Id = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *FleetSummary) SetLastModificationTime(v time.Time) *FleetSummary {
	s.LastModificationTime = &v
	return s
}

// SetSignalCatalogArn sets the SignalCatalogArn field's value.
func (s *FleetSummary) SetSignalCatalogArn(v string) *FleetSummary {
	s.SignalCatalogArn = &v
	return s
}

// Vehicle Signal Specification (VSS) (https://www.w3.org/auto/wg/wiki/Vehicle_Signal_Specification_(VSS)/Vehicle_Data_Spec)
// is a precise language used to describe and model signals in vehicle networks.
// The JSON file collects signal specificiations in a VSS format.
type FormattedVss struct {
	_ struct{} `type:"structure"`

	// Provides the VSS in JSON format.
	VssJson *string `locationName:"vssJson" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FormattedVss) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FormattedVss) GoString() string {
	return s.String()
}

// SetVssJson sets the VssJson field's value.
func (s *FormattedVss) SetVssJson(v string) *FormattedVss {
	s.VssJson = &v
	return s
}

type GetCampaignInput struct {
	_ struct{} `type:"structure"`

	// The name of the campaign to retrieve information about.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetCampaignInput) SetName(v string) *GetCampaignInput {
	s.Name = &v
	return s
}

type GetCampaignOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign.
	Arn *string `locationName:"arn" type:"string"`

	// Information about the data collection scheme associated with the campaign.
	CollectionScheme *CollectionScheme `locationName:"collectionScheme" type:"structure"`

	// Whether to compress signals before transmitting data to Amazon Web Services
	// IoT FleetWise. If OFF is specified, the signals aren't compressed. If it's
	// not specified, SNAPPY is used.
	Compression *string `locationName:"compression" type:"string" enum:"Compression"`

	// The time the campaign was created in seconds since epoch (January 1, 1970
	// at midnight UTC time).
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The destination where the campaign sends data. You can choose to send data
	// to be stored in Amazon S3 or Amazon Timestream.
	//
	// Amazon S3 optimizes the cost of data storage and provides additional mechanisms
	// to use vehicle data, such as data lakes, centralized data storage, data processing
	// pipelines, and analytics.
	//
	// You can use Amazon Timestream to access and analyze time series data, and
	// Timestream to query vehicle data so that you can identify trends and patterns.
	DataDestinationConfigs []*DataDestinationConfig `locationName:"dataDestinationConfigs" min:"1" type:"list"`

	// A list of vehicle attributes associated with the campaign.
	DataExtraDimensions []*string `locationName:"dataExtraDimensions" type:"list"`

	// The description of the campaign.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Option for a vehicle to send diagnostic trouble codes to Amazon Web Services
	// IoT FleetWise.
	DiagnosticsMode *string `locationName:"diagnosticsMode" type:"string" enum:"DiagnosticsMode"`

	// The time the campaign expires, in seconds since epoch (January 1, 1970 at
	// midnight UTC time). Vehicle data won't be collected after the campaign expires.
	ExpiryTime *time.Time `locationName:"expiryTime" type:"timestamp"`

	// The last time the campaign was modified.
	LastModificationTime *time.Time `locationName:"lastModificationTime" type:"timestamp"`

	// The name of the campaign.
	Name *string `locationName:"name" min:"1" type:"string"`

	// How long (in seconds) to collect raw data after a triggering event initiates
	// the collection.
	PostTriggerCollectionDuration *int64 `locationName:"postTriggerCollectionDuration" type:"long"`

	// A number indicating the priority of one campaign over another campaign for
	// a certain vehicle or fleet. A campaign with the lowest value is deployed
	// to vehicles before any other campaigns.
	Priority *int64 `locationName:"priority" type:"integer"`

	// The ARN of a signal catalog.
	SignalCatalogArn *string `locationName:"signalCatalogArn" type:"string"`

	// Information about a list of signals to collect data on.
	SignalsToCollect []*SignalInformation `locationName:"signalsToCollect" type:"list"`

	// Whether to store collected data after a vehicle lost a connection with the
	// cloud. After a connection is re-established, the data is automatically forwarded
	// to Amazon Web Services IoT FleetWise.
	SpoolingMode *string `locationName:"spoolingMode" type:"string" enum:"SpoolingMode"`

	// The time, in milliseconds, to deliver a campaign after it was approved.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The state of the campaign. The status can be one of: CREATING, WAITING_FOR_APPROVAL,
	// RUNNING, and SUSPENDED.
	Status *string `locationName:"status" type:"string" enum:"CampaignStatus"`

	// The ARN of the vehicle or the fleet targeted by the campaign.
	TargetArn *string `locationName:"targetArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCampaignOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetCampaignOutput) SetArn(v string) *GetCampaignOutput {
	s.Arn = &v
	return s
}

// SetCollectionScheme sets the CollectionScheme field's value.
func (s *GetCampaignOutput) SetCollectionScheme(v *CollectionScheme) *GetCampaignOutput {
	s.CollectionScheme = v
	return s
}

// SetCompression sets the Compression field's value.
func (s *GetCampaignOutput) SetCompression(v string) *GetCampaignOutput {
	s.Compression = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetCampaignOutput) SetCreationTime(v time.Time) *GetCampaignOutput {
	s.CreationTime = &v
	return s
}

// SetDataDestinationConfigs sets the DataDestinationConfigs field's value.
func (s *GetCampaignOutput) SetDataDestinationConfigs(v []*DataDestinationConfig) *GetCampaignOutput {
	s.DataDestinationConfigs = v
	return s
}

// SetDataExtraDimensions sets the DataExtraDimensions field's value.
func (s *GetCampaignOutput) SetDataExtraDimensions(v []*string) *GetCampaignOutput {
	s.DataExtraDimensions = v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetCampaignOutput) SetDescription(v string) *GetCampaignOutput {
	s.Description = &v
	return s
}

// SetDiagnosticsMode sets the DiagnosticsMode field's value.
func (s *GetCampaignOutput) SetDiagnosticsMode(v string) *GetCampaignOutput {
	s.DiagnosticsMode = &v
	return s
}

// SetExpiryTime sets the ExpiryTime field's value.
func (s *GetCampaignOutput) SetExpiryTime(v time.Time) *GetCampaignOutput {
	s.ExpiryTime = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *GetCampaignOutput) SetLastModificationTime(v time.Time) *GetCampaignOutput {
	s.LastModificationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetCampaignOutput) SetName(v string) *GetCampaignOutput {
	s.Name = &v
	return s
}

// SetPostTriggerCollectionDuration sets the PostTriggerCollectionDuration field's value.
func (s *GetCampaignOutput) SetPostTriggerCollectionDuration(v int64) *GetCampaignOutput {
	s.PostTriggerCollectionDuration = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *GetCampaignOutput) SetPriority(v int64) *GetCampaignOutput {
	s.Priority = &v
	return s
}

// SetSignalCatalogArn sets the SignalCatalogArn field's value.
func (s *GetCampaignOutput) SetSignalCatalogArn(v string) *GetCampaignOutput {
	s.SignalCatalogArn = &v
	return s
}

// SetSignalsToCollect sets the SignalsToCollect field's value.
func (s *GetCampaignOutput) SetSignalsToCollect(v []*SignalInformation) *GetCampaignOutput {
	s.SignalsToCollect = v
	return s
}

// SetSpoolingMode sets the SpoolingMode field's value.
func (s *GetCampaignOutput) SetSpoolingMode(v string) *GetCampaignOutput {
	s.SpoolingMode = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetCampaignOutput) SetStartTime(v time.Time) *GetCampaignOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetCampaignOutput) SetStatus(v string) *GetCampaignOutput {
	s.Status = &v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *GetCampaignOutput) SetTargetArn(v string) *GetCampaignOutput {
	s.TargetArn = &v
	return s
}

type GetDecoderManifestInput struct {
	_ struct{} `type:"structure"`

	// The name of the decoder manifest to retrieve information about.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDecoderManifestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDecoderManifestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDecoderManifestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDecoderManifestInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetDecoderManifestInput) SetName(v string) *GetDecoderManifestInput {
	s.Name = &v
	return s
}

type GetDecoderManifestOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the decoder manifest.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time the decoder manifest was created in seconds since epoch (January
	// 1, 1970 at midnight UTC time).
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// A brief description of the decoder manifest.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The time the decoder manifest was last updated in seconds since epoch (January
	// 1, 1970 at midnight UTC time).
	//
	// LastModificationTime is a required field
	LastModificationTime *time.Time `locationName:"lastModificationTime" type:"timestamp" required:"true"`

	// The detailed message for the decoder manifest. When a decoder manifest is
	// in an INVALID status, the message contains detailed reason and help information.
	Message *string `locationName:"message" min:"1" type:"string"`

	// The ARN of a vehicle model (model manifest) associated with the decoder manifest.
	ModelManifestArn *string `locationName:"modelManifestArn" type:"string"`

	// The name of the decoder manifest.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The state of the decoder manifest. If the status is ACTIVE, the decoder manifest
	// can't be edited. If the status is marked DRAFT, you can edit the decoder
	// manifest.
	Status *string `locationName:"status" type:"string" enum:"ManifestStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDecoderManifestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDecoderManifestOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetDecoderManifestOutput) SetArn(v string) *GetDecoderManifestOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetDecoderManifestOutput) SetCreationTime(v time.Time) *GetDecoderManifestOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetDecoderManifestOutput) SetDescription(v string) *GetDecoderManifestOutput {
	s.Description = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *GetDecoderManifestOutput) SetLastModificationTime(v time.Time) *GetDecoderManifestOutput {
	s.LastModificationTime = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *GetDecoderManifestOutput) SetMessage(v string) *GetDecoderManifestOutput {
	s.Message = &v
	return s
}

// SetModelManifestArn sets the ModelManifestArn field's value.
func (s *GetDecoderManifestOutput) SetModelManifestArn(v string) *GetDecoderManifestOutput {
	s.ModelManifestArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetDecoderManifestOutput) SetName(v string) *GetDecoderManifestOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetDecoderManifestOutput) SetStatus(v string) *GetDecoderManifestOutput {
	s.Status = &v
	return s
}

type GetEncryptionConfigurationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEncryptionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEncryptionConfigurationInput) GoString() string {
	return s.String()
}

type GetEncryptionConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The time when encryption was configured in seconds since epoch (January 1,
	// 1970 at midnight UTC time).
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The encryption status.
	//
	// EncryptionStatus is a required field
	EncryptionStatus *string `locationName:"encryptionStatus" type:"string" required:"true" enum:"EncryptionStatus"`

	// The type of encryption. Set to KMS_BASED_ENCRYPTION to use a KMS key that
	// you own and manage. Set to FLEETWISE_DEFAULT_ENCRYPTION to use an Amazon
	// Web Services managed key that is owned by the Amazon Web Services IoT FleetWise
	// service account.
	//
	// EncryptionType is a required field
	EncryptionType *string `locationName:"encryptionType" type:"string" required:"true" enum:"EncryptionType"`

	// The error message that describes why encryption settings couldn't be configured,
	// if applicable.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The ID of the KMS key that is used for encryption.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The time when encryption was last updated in seconds since epoch (January
	// 1, 1970 at midnight UTC time).
	LastModificationTime *time.Time `locationName:"lastModificationTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEncryptionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEncryptionConfigurationOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetEncryptionConfigurationOutput) SetCreationTime(v time.Time) *GetEncryptionConfigurationOutput {
	s.CreationTime = &v
	return s
}

// SetEncryptionStatus sets the EncryptionStatus field's value.
func (s *GetEncryptionConfigurationOutput) SetEncryptionStatus(v string) *GetEncryptionConfigurationOutput {
	s.EncryptionStatus = &v
	return s
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *GetEncryptionConfigurationOutput) SetEncryptionType(v string) *GetEncryptionConfigurationOutput {
	s.EncryptionType = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *GetEncryptionConfigurationOutput) SetErrorMessage(v string) *GetEncryptionConfigurationOutput {
	s.ErrorMessage = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *GetEncryptionConfigurationOutput) SetKmsKeyId(v string) *GetEncryptionConfigurationOutput {
	s.KmsKeyId = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *GetEncryptionConfigurationOutput) SetLastModificationTime(v time.Time) *GetEncryptionConfigurationOutput {
	s.LastModificationTime = &v
	return s
}

type GetFleetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the fleet to retrieve information about.
	//
	// FleetId is a required field
	FleetId *string `locationName:"fleetId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFleetInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *GetFleetInput) SetFleetId(v string) *GetFleetInput {
	s.FleetId = &v
	return s
}

type GetFleetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the fleet.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time the fleet was created in seconds since epoch (January 1, 1970 at
	// midnight UTC time).
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// A brief description of the fleet.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The ID of the fleet.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The time the fleet was last updated, in seconds since epoch (January 1, 1970
	// at midnight UTC time).
	//
	// LastModificationTime is a required field
	LastModificationTime *time.Time `locationName:"lastModificationTime" type:"timestamp" required:"true"`

	// The ARN of a signal catalog associated with the fleet.
	//
	// SignalCatalogArn is a required field
	SignalCatalogArn *string `locationName:"signalCatalogArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFleetOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetFleetOutput) SetArn(v string) *GetFleetOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetFleetOutput) SetCreationTime(v time.Time) *GetFleetOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetFleetOutput) SetDescription(v string) *GetFleetOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetFleetOutput) SetId(v string) *GetFleetOutput {
	s.Id = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *GetFleetOutput) SetLastModificationTime(v time.Time) *GetFleetOutput {
	s.LastModificationTime = &v
	return s
}

// SetSignalCatalogArn sets the SignalCatalogArn field's value.
func (s *GetFleetOutput) SetSignalCatalogArn(v string) *GetFleetOutput {
	s.SignalCatalogArn = &v
	return s
}

type GetLoggingOptionsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLoggingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLoggingOptionsInput) GoString() string {
	return s.String()
}

type GetLoggingOptionsOutput struct {
	_ struct{} `type:"structure"`

	// Returns information about log delivery to Amazon CloudWatch Logs.
	//
	// CloudWatchLogDelivery is a required field
	CloudWatchLogDelivery *CloudWatchLogDeliveryOptions `locationName:"cloudWatchLogDelivery" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLoggingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLoggingOptionsOutput) GoString() string {
	return s.String()
}

// SetCloudWatchLogDelivery sets the CloudWatchLogDelivery field's value.
func (s *GetLoggingOptionsOutput) SetCloudWatchLogDelivery(v *CloudWatchLogDeliveryOptions) *GetLoggingOptionsOutput {
	s.CloudWatchLogDelivery = v
	return s
}

type GetModelManifestInput struct {
	_ struct{} `type:"structure"`

	// The name of the vehicle model to retrieve information about.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelManifestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelManifestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetModelManifestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetModelManifestInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetModelManifestInput) SetName(v string) *GetModelManifestInput {
	s.Name = &v
	return s
}

type GetModelManifestOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the vehicle model.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time the vehicle model was created, in seconds since epoch (January 1,
	// 1970 at midnight UTC time).
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// A brief description of the vehicle model.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The last time the vehicle model was modified.
	//
	// LastModificationTime is a required field
	LastModificationTime *time.Time `locationName:"lastModificationTime" type:"timestamp" required:"true"`

	// The name of the vehicle model.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The ARN of the signal catalog associated with the vehicle model.
	SignalCatalogArn *string `locationName:"signalCatalogArn" type:"string"`

	// The state of the vehicle model. If the status is ACTIVE, the vehicle model
	// can't be edited. You can edit the vehicle model if the status is marked DRAFT.
	Status *string `locationName:"status" type:"string" enum:"ManifestStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelManifestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelManifestOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetModelManifestOutput) SetArn(v string) *GetModelManifestOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetModelManifestOutput) SetCreationTime(v time.Time) *GetModelManifestOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetModelManifestOutput) SetDescription(v string) *GetModelManifestOutput {
	s.Description = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *GetModelManifestOutput) SetLastModificationTime(v time.Time) *GetModelManifestOutput {
	s.LastModificationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetModelManifestOutput) SetName(v string) *GetModelManifestOutput {
	s.Name = &v
	return s
}

// SetSignalCatalogArn sets the SignalCatalogArn field's value.
func (s *GetModelManifestOutput) SetSignalCatalogArn(v string) *GetModelManifestOutput {
	s.SignalCatalogArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetModelManifestOutput) SetStatus(v string) *GetModelManifestOutput {
	s.Status = &v
	return s
}

type GetRegisterAccountStatusInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRegisterAccountStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRegisterAccountStatusInput) GoString() string {
	return s.String()
}

type GetRegisterAccountStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status of registering your account and resources. The status can be one
	// of:
	//
	//    * REGISTRATION_SUCCESS - The Amazon Web Services resource is successfully
	//    registered.
	//
	//    * REGISTRATION_PENDING - Amazon Web Services IoT FleetWise is processing
	//    the registration request. This process takes approximately five minutes
	//    to complete.
	//
	//    * REGISTRATION_FAILURE - Amazon Web Services IoT FleetWise can't register
	//    the AWS resource. Try again later.
	//
	// AccountStatus is a required field
	AccountStatus *string `locationName:"accountStatus" type:"string" required:"true" enum:"RegistrationStatus"`

	// The time the account was registered, in seconds since epoch (January 1, 1970
	// at midnight UTC time).
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// The unique ID of the Amazon Web Services account, provided at account creation.
	//
	// CustomerAccountId is a required field
	CustomerAccountId *string `locationName:"customerAccountId" type:"string" required:"true"`

	// Information about the registered IAM resources or errors, if any.
	//
	// IamRegistrationResponse is a required field
	IamRegistrationResponse *IamRegistrationResponse `locationName:"iamRegistrationResponse" type:"structure" required:"true"`

	// The time this registration was last updated, in seconds since epoch (January
	// 1, 1970 at midnight UTC time).
	//
	// LastModificationTime is a required field
	LastModificationTime *time.Time `locationName:"lastModificationTime" type:"timestamp" required:"true"`

	// Information about the registered Amazon Timestream resources or errors, if
	// any.
	TimestreamRegistrationResponse *TimestreamRegistrationResponse `locationName:"timestreamRegistrationResponse" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRegisterAccountStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRegisterAccountStatusOutput) GoString() string {
	return s.String()
}

// SetAccountStatus sets the AccountStatus field's value.
func (s *GetRegisterAccountStatusOutput) SetAccountStatus(v string) *GetRegisterAccountStatusOutput {
	s.AccountStatus = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetRegisterAccountStatusOutput) SetCreationTime(v time.Time) *GetRegisterAccountStatusOutput {
	s.CreationTime = &v
	return s
}

// SetCustomerAccountId sets the CustomerAccountId field's value.
func (s *GetRegisterAccountStatusOutput) SetCustomerAccountId(v string) *GetRegisterAccountStatusOutput {
	s.CustomerAccountId = &v
	return s
}

// SetIamRegistrationResponse sets the IamRegistrationResponse field's value.
func (s *GetRegisterAccountStatusOutput) SetIamRegistrationResponse(v *IamRegistrationResponse) *GetRegisterAccountStatusOutput {
	s.IamRegistrationResponse = v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *GetRegisterAccountStatusOutput) SetLastModificationTime(v time.Time) *GetRegisterAccountStatusOutput {
	s.LastModificationTime = &v
	return s
}

// SetTimestreamRegistrationResponse sets the TimestreamRegistrationResponse field's value.
func (s *GetRegisterAccountStatusOutput) SetTimestreamRegistrationResponse(v *TimestreamRegistrationResponse) *GetRegisterAccountStatusOutput {
	s.TimestreamRegistrationResponse = v
	return s
}

type GetSignalCatalogInput struct {
	_ struct{} `type:"structure"`

	// The name of the signal catalog to retrieve information about.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSignalCatalogInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSignalCatalogInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSignalCatalogInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSignalCatalogInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetSignalCatalogInput) SetName(v string) *GetSignalCatalogInput {
	s.Name = &v
	return s
}

type GetSignalCatalogOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the signal catalog.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time the signal catalog was created in seconds since epoch (January 1,
	// 1970 at midnight UTC time).
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// A brief description of the signal catalog.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The last time the signal catalog was modified.
	//
	// LastModificationTime is a required field
	LastModificationTime *time.Time `locationName:"lastModificationTime" type:"timestamp" required:"true"`

	// The name of the signal catalog.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The total number of network nodes specified in a signal catalog.
	NodeCounts *NodeCounts `locationName:"nodeCounts" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSignalCatalogOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSignalCatalogOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetSignalCatalogOutput) SetArn(v string) *GetSignalCatalogOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetSignalCatalogOutput) SetCreationTime(v time.Time) *GetSignalCatalogOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetSignalCatalogOutput) SetDescription(v string) *GetSignalCatalogOutput {
	s.Description = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *GetSignalCatalogOutput) SetLastModificationTime(v time.Time) *GetSignalCatalogOutput {
	s.LastModificationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetSignalCatalogOutput) SetName(v string) *GetSignalCatalogOutput {
	s.Name = &v
	return s
}

// SetNodeCounts sets the NodeCounts field's value.
func (s *GetSignalCatalogOutput) SetNodeCounts(v *NodeCounts) *GetSignalCatalogOutput {
	s.NodeCounts = v
	return s
}

type GetVehicleInput struct {
	_ struct{} `type:"structure"`

	// The ID of the vehicle to retrieve information about.
	//
	// VehicleName is a required field
	VehicleName *string `locationName:"vehicleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVehicleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVehicleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVehicleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVehicleInput"}
	if s.VehicleName == nil {
		invalidParams.Add(request.NewErrParamRequired("VehicleName"))
	}
	if s.VehicleName != nil && len(*s.VehicleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VehicleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVehicleName sets the VehicleName field's value.
func (s *GetVehicleInput) SetVehicleName(v string) *GetVehicleInput {
	s.VehicleName = &v
	return s
}

type GetVehicleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the vehicle to retrieve information about.
	Arn *string `locationName:"arn" type:"string"`

	// Static information about a vehicle in a key-value pair. For example:
	//
	// "engineType" : "1.3 L R2"
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// The time the vehicle was created in seconds since epoch (January 1, 1970
	// at midnight UTC time).
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The ARN of a decoder manifest associated with the vehicle.
	DecoderManifestArn *string `locationName:"decoderManifestArn" type:"string"`

	// The time the vehicle was last updated in seconds since epoch (January 1,
	// 1970 at midnight UTC time).
	LastModificationTime *time.Time `locationName:"lastModificationTime" type:"timestamp"`

	// The ARN of a vehicle model (model manifest) associated with the vehicle.
	ModelManifestArn *string `locationName:"modelManifestArn" type:"string"`

	// The ID of the vehicle.
	VehicleName *string `locationName:"vehicleName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVehicleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVehicleOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetVehicleOutput) SetArn(v string) *GetVehicleOutput {
	s.Arn = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *GetVehicleOutput) SetAttributes(v map[string]*string) *GetVehicleOutput {
	s.Attributes = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetVehicleOutput) SetCreationTime(v time.Time) *GetVehicleOutput {
	s.CreationTime = &v
	return s
}

// SetDecoderManifestArn sets the DecoderManifestArn field's value.
func (s *GetVehicleOutput) SetDecoderManifestArn(v string) *GetVehicleOutput {
	s.DecoderManifestArn = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *GetVehicleOutput) SetLastModificationTime(v time.Time) *GetVehicleOutput {
	s.LastModificationTime = &v
	return s
}

// SetModelManifestArn sets the ModelManifestArn field's value.
func (s *GetVehicleOutput) SetModelManifestArn(v string) *GetVehicleOutput {
	s.ModelManifestArn = &v
	return s
}

// SetVehicleName sets the VehicleName field's value.
func (s *GetVehicleOutput) SetVehicleName(v string) *GetVehicleOutput {
	s.VehicleName = &v
	return s
}

type GetVehicleStatusInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return, between 1 and 100, inclusive.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token for the next set of results.
	//
	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next set of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The ID of the vehicle to retrieve information about.
	//
	// VehicleName is a required field
	VehicleName *string `locationName:"vehicleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVehicleStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVehicleStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVehicleStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVehicleStatusInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.VehicleName == nil {
		invalidParams.Add(request.NewErrParamRequired("VehicleName"))
	}
	if s.VehicleName != nil && len(*s.VehicleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VehicleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetVehicleStatusInput) SetMaxResults(v int64) *GetVehicleStatusInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetVehicleStatusInput) SetNextToken(v string) *GetVehicleStatusInput {
	s.NextToken = &v
	return s
}

// SetVehicleName sets the VehicleName field's value.
func (s *GetVehicleStatusInput) SetVehicleName(v string) *GetVehicleStatusInput {
	s.VehicleName = &v
	return s
}

type GetVehicleStatusOutput struct {
	_ struct{} `type:"structure"`

	// Lists information about the state of the vehicle with deployed campaigns.
	Campaigns []*VehicleStatus `locationName:"campaigns" type:"list"`

	// The token to retrieve the next set of results, or null if there are no more
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVehicleStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVehicleStatusOutput) GoString() string {
	return s.String()
}

// SetCampaigns sets the Campaigns field's value.
func (s *GetVehicleStatusOutput) SetCampaigns(v []*VehicleStatus) *GetVehicleStatusOutput {
	s.Campaigns = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetVehicleStatusOutput) SetNextToken(v string) *GetVehicleStatusOutput {
	s.NextToken = &v
	return s
}

// Information about registering an Identity and Access Management (IAM) resource
// so Amazon Web Services IoT FleetWise edge agent software can transfer your
// vehicle data to Amazon Timestream.
type IamRegistrationResponse struct {
	_ struct{} `type:"structure"`

	// A message associated with a registration error.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The status of registering your IAM resource. The status can be one of REGISTRATION_SUCCESS,
	// REGISTRATION_PENDING, REGISTRATION_FAILURE.
	//
	// RegistrationStatus is a required field
	RegistrationStatus *string `locationName:"registrationStatus" type:"string" required:"true" enum:"RegistrationStatus"`

	// The Amazon Resource Name (ARN) of the IAM role to register.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IamRegistrationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IamRegistrationResponse) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *IamRegistrationResponse) SetErrorMessage(v string) *IamRegistrationResponse {
	s.ErrorMessage = &v
	return s
}

// SetRegistrationStatus sets the RegistrationStatus field's value.
func (s *IamRegistrationResponse) SetRegistrationStatus(v string) *IamRegistrationResponse {
	s.RegistrationStatus = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *IamRegistrationResponse) SetRoleArn(v string) *IamRegistrationResponse {
	s.RoleArn = &v
	return s
}

// The IAM resource that enables Amazon Web Services IoT FleetWise edge agent
// software to send data to Amazon Timestream.
//
// For more information, see IAM roles (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html)
// in the Identity and Access Management User Guide.
type IamResources struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM resource that allows Amazon Web
	// Services IoT FleetWise to send data to Amazon Timestream. For example, arn:aws:iam::123456789012:role/SERVICE-ROLE-ARN.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IamResources) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IamResources) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IamResources) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IamResources"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *IamResources) SetRoleArn(v string) *IamResources {
	s.RoleArn = &v
	return s
}

type ImportDecoderManifestInput struct {
	_ struct{} `type:"structure"`

	// The name of the decoder manifest to import.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The file to load into an Amazon Web Services account.
	//
	// NetworkFileDefinitions is a required field
	NetworkFileDefinitions []*NetworkFileDefinition `locationName:"networkFileDefinitions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportDecoderManifestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportDecoderManifestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportDecoderManifestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportDecoderManifestInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NetworkFileDefinitions == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkFileDefinitions"))
	}
	if s.NetworkFileDefinitions != nil {
		for i, v := range s.NetworkFileDefinitions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NetworkFileDefinitions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ImportDecoderManifestInput) SetName(v string) *ImportDecoderManifestInput {
	s.Name = &v
	return s
}

// SetNetworkFileDefinitions sets the NetworkFileDefinitions field's value.
func (s *ImportDecoderManifestInput) SetNetworkFileDefinitions(v []*NetworkFileDefinition) *ImportDecoderManifestInput {
	s.NetworkFileDefinitions = v
	return s
}

type ImportDecoderManifestOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the decoder manifest that was imported.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the imported decoder manifest.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportDecoderManifestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportDecoderManifestOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ImportDecoderManifestOutput) SetArn(v string) *ImportDecoderManifestOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *ImportDecoderManifestOutput) SetName(v string) *ImportDecoderManifestOutput {
	s.Name = &v
	return s
}

type ImportSignalCatalogInput struct {
	_ struct{} `type:"structure"`

	// A brief description of the signal catalog.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the signal catalog to import.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Metadata that can be used to manage the signal catalog.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The contents of the Vehicle Signal Specification (VSS) configuration. VSS
	// is a precise language used to describe and model signals in vehicle networks.
	Vss *FormattedVss `locationName:"vss" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportSignalCatalogInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportSignalCatalogInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportSignalCatalogInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportSignalCatalogInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *ImportSignalCatalogInput) SetDescription(v string) *ImportSignalCatalogInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *ImportSignalCatalogInput) SetName(v string) *ImportSignalCatalogInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImportSignalCatalogInput) SetTags(v []*Tag) *ImportSignalCatalogInput {
	s.Tags = v
	return s
}

// SetVss sets the Vss field's value.
func (s *ImportSignalCatalogInput) SetVss(v *FormattedVss) *ImportSignalCatalogInput {
	s.Vss = v
	return s
}

type ImportSignalCatalogOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the imported signal catalog.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the imported signal catalog.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportSignalCatalogOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportSignalCatalogOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ImportSignalCatalogOutput) SetArn(v string) *ImportSignalCatalogOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *ImportSignalCatalogOutput) SetName(v string) *ImportSignalCatalogOutput {
	s.Name = &v
	return s
}

// The request couldn't be completed because the server temporarily failed.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The number of seconds to wait before retrying the command.
	RetryAfterSeconds *int64 `locationName:"retryAfterSeconds" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A reason a vehicle network interface isn't valid.
type InvalidNetworkInterface struct {
	_ struct{} `type:"structure"`

	// The ID of the interface that isn't valid.
	InterfaceId *string `locationName:"interfaceId" min:"1" type:"string"`

	// A message about why the interface isn't valid.
	Reason *string `locationName:"reason" type:"string" enum:"NetworkInterfaceFailureReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNetworkInterface) GoString() string {
	return s.String()
}

// SetInterfaceId sets the InterfaceId field's value.
func (s *InvalidNetworkInterface) SetInterfaceId(v string) *InvalidNetworkInterface {
	s.InterfaceId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *InvalidNetworkInterface) SetReason(v string) *InvalidNetworkInterface {
	s.Reason = &v
	return s
}

// The specified node type doesn't match the expected node type for a node.
// You can specify the node type as branch, sensor, actuator, or attribute.
type InvalidNodeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The specified node type isn't valid.
	InvalidNodes []*Node `locationName:"invalidNodes" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// The reason the node validation failed.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNodeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNodeException) GoString() string {
	return s.String()
}

func newErrorInvalidNodeException(v protocol.ResponseMetadata) error {
	return &InvalidNodeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNodeException) Code() string {
	return "InvalidNodeException"
}

// Message returns the exception's message.
func (s *InvalidNodeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNodeException) OrigErr() error {
	return nil
}

func (s *InvalidNodeException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNodeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNodeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A reason that a signal isn't valid.
type InvalidSignal struct {
	_ struct{} `type:"structure"`

	// The name of the signal that isn't valid.
	Name *string `locationName:"name" min:"1" type:"string"`

	// A message about why the signal isn't valid.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSignal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSignal) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *InvalidSignal) SetName(v string) *InvalidSignal {
	s.Name = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *InvalidSignal) SetReason(v string) *InvalidSignal {
	s.Reason = &v
	return s
}

// A reason that a signal decoder isn't valid.
type InvalidSignalDecoder struct {
	_ struct{} `type:"structure"`

	// The possible cause for the invalid signal decoder.
	Hint *string `locationName:"hint" min:"1" type:"string"`

	// The name of a signal decoder that isn't valid.
	Name *string `locationName:"name" min:"1" type:"string"`

	// A message about why the signal decoder isn't valid.
	Reason *string `locationName:"reason" type:"string" enum:"SignalDecoderFailureReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSignalDecoder) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSignalDecoder) GoString() string {
	return s.String()
}

// SetHint sets the Hint field's value.
func (s *InvalidSignalDecoder) SetHint(v string) *InvalidSignalDecoder {
	s.Hint = &v
	return s
}

// SetName sets the Name field's value.
func (s *InvalidSignalDecoder) SetName(v string) *InvalidSignalDecoder {
	s.Name = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *InvalidSignalDecoder) SetReason(v string) *InvalidSignalDecoder {
	s.Reason = &v
	return s
}

// The request couldn't be completed because it contains signals that aren't
// valid.
type InvalidSignalsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The signals which caused the exception.
	InvalidSignals []*InvalidSignal `locationName:"invalidSignals" type:"list"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSignalsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSignalsException) GoString() string {
	return s.String()
}

func newErrorInvalidSignalsException(v protocol.ResponseMetadata) error {
	return &InvalidSignalsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidSignalsException) Code() string {
	return "InvalidSignalsException"
}

// Message returns the exception's message.
func (s *InvalidSignalsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidSignalsException) OrigErr() error {
	return nil
}

func (s *InvalidSignalsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidSignalsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidSignalsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A service quota was exceeded.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The identifier of the resource that was exceeded.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of resource that was exceeded.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListCampaignsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return, between 1 and 100, inclusive.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token for the next set of results.
	//
	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next set of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Optional parameter to filter the results by the status of each created campaign
	// in your account. The status can be one of: CREATING, WAITING_FOR_APPROVAL,
	// RUNNING, or SUSPENDED.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCampaignsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCampaignsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCampaignsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCampaignsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCampaignsInput) SetMaxResults(v int64) *ListCampaignsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCampaignsInput) SetNextToken(v string) *ListCampaignsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListCampaignsInput) SetStatus(v string) *ListCampaignsInput {
	s.Status = &v
	return s
}

type ListCampaignsOutput struct {
	_ struct{} `type:"structure"`

	// A summary of information about each campaign.
	CampaignSummaries []*CampaignSummary `locationName:"campaignSummaries" type:"list"`

	// The token to retrieve the next set of results, or null if there are no more
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCampaignsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCampaignsOutput) GoString() string {
	return s.String()
}

// SetCampaignSummaries sets the CampaignSummaries field's value.
func (s *ListCampaignsOutput) SetCampaignSummaries(v []*CampaignSummary) *ListCampaignsOutput {
	s.CampaignSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCampaignsOutput) SetNextToken(v string) *ListCampaignsOutput {
	s.NextToken = &v
	return s
}

type ListDecoderManifestNetworkInterfacesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return, between 1 and 100, inclusive.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The name of the decoder manifest to list information about.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A pagination token for the next set of results.
	//
	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next set of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDecoderManifestNetworkInterfacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDecoderManifestNetworkInterfacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDecoderManifestNetworkInterfacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDecoderManifestNetworkInterfacesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDecoderManifestNetworkInterfacesInput) SetMaxResults(v int64) *ListDecoderManifestNetworkInterfacesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListDecoderManifestNetworkInterfacesInput) SetName(v string) *ListDecoderManifestNetworkInterfacesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDecoderManifestNetworkInterfacesInput) SetNextToken(v string) *ListDecoderManifestNetworkInterfacesInput {
	s.NextToken = &v
	return s
}

type ListDecoderManifestNetworkInterfacesOutput struct {
	_ struct{} `type:"structure"`

	// A list of information about network interfaces.
	NetworkInterfaces []*NetworkInterface `locationName:"networkInterfaces" min:"1" type:"list"`

	// The token to retrieve the next set of results, or null if there are no more
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDecoderManifestNetworkInterfacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDecoderManifestNetworkInterfacesOutput) GoString() string {
	return s.String()
}

// SetNetworkInterfaces sets the NetworkInterfaces field's value.
func (s *ListDecoderManifestNetworkInterfacesOutput) SetNetworkInterfaces(v []*NetworkInterface) *ListDecoderManifestNetworkInterfacesOutput {
	s.NetworkInterfaces = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDecoderManifestNetworkInterfacesOutput) SetNextToken(v string) *ListDecoderManifestNetworkInterfacesOutput {
	s.NextToken = &v
	return s
}

type ListDecoderManifestSignalsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return, between 1 and 100, inclusive.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The name of the decoder manifest to list information about.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A pagination token for the next set of results.
	//
	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next set of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDecoderManifestSignalsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDecoderManifestSignalsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDecoderManifestSignalsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDecoderManifestSignalsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDecoderManifestSignalsInput) SetMaxResults(v int64) *ListDecoderManifestSignalsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListDecoderManifestSignalsInput) SetName(v string) *ListDecoderManifestSignalsInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDecoderManifestSignalsInput) SetNextToken(v string) *ListDecoderManifestSignalsInput {
	s.NextToken = &v
	return s
}

type ListDecoderManifestSignalsOutput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results, or null if there are no more
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Information about a list of signals to decode.
	SignalDecoders []*SignalDecoder `locationName:"signalDecoders" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDecoderManifestSignalsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDecoderManifestSignalsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListDecoderManifestSignalsOutput) SetNextToken(v string) *ListDecoderManifestSignalsOutput {
	s.NextToken = &v
	return s
}

// SetSignalDecoders sets the SignalDecoders field's value.
func (s *ListDecoderManifestSignalsOutput) SetSignalDecoders(v []*SignalDecoder) *ListDecoderManifestSignalsOutput {
	s.SignalDecoders = v
	return s
}

type ListDecoderManifestsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return, between 1 and 100, inclusive.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of a vehicle model (model manifest) associated
	// with the decoder manifest.
	ModelManifestArn *string `locationName:"modelManifestArn" type:"string"`

	// A pagination token for the next set of results.
	//
	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next set of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDecoderManifestsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDecoderManifestsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDecoderManifestsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDecoderManifestsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDecoderManifestsInput) SetMaxResults(v int64) *ListDecoderManifestsInput {
	s.MaxResults = &v
	return s
}

// SetModelManifestArn sets the ModelManifestArn field's value.
func (s *ListDecoderManifestsInput) SetModelManifestArn(v string) *ListDecoderManifestsInput {
	s.ModelManifestArn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDecoderManifestsInput) SetNextToken(v string) *ListDecoderManifestsInput {
	s.NextToken = &v
	return s
}

type ListDecoderManifestsOutput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results, or null if there are no more
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of information about each decoder manifest.
	Summaries []*DecoderManifestSummary `locationName:"summaries" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDecoderManifestsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDecoderManifestsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListDecoderManifestsOutput) SetNextToken(v string) *ListDecoderManifestsOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *ListDecoderManifestsOutput) SetSummaries(v []*DecoderManifestSummary) *ListDecoderManifestsOutput {
	s.Summaries = v
	return s
}

type ListFleetsForVehicleInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return, between 1 and 100, inclusive.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token for the next set of results.
	//
	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next set of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The ID of the vehicle to retrieve information about.
	//
	// VehicleName is a required field
	VehicleName *string `locationName:"vehicleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFleetsForVehicleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFleetsForVehicleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFleetsForVehicleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFleetsForVehicleInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.VehicleName == nil {
		invalidParams.Add(request.NewErrParamRequired("VehicleName"))
	}
	if s.VehicleName != nil && len(*s.VehicleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VehicleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFleetsForVehicleInput) SetMaxResults(v int64) *ListFleetsForVehicleInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFleetsForVehicleInput) SetNextToken(v string) *ListFleetsForVehicleInput {
	s.NextToken = &v
	return s
}

// SetVehicleName sets the VehicleName field's value.
func (s *ListFleetsForVehicleInput) SetVehicleName(v string) *ListFleetsForVehicleInput {
	s.VehicleName = &v
	return s
}

type ListFleetsForVehicleOutput struct {
	_ struct{} `type:"structure"`

	// A list of fleet IDs that the vehicle is associated with.
	Fleets []*string `locationName:"fleets" type:"list"`

	// The token to retrieve the next set of results, or null if there are no more
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFleetsForVehicleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFleetsForVehicleOutput) GoString() string {
	return s.String()
}

// SetFleets sets the Fleets field's value.
func (s *ListFleetsForVehicleOutput) SetFleets(v []*string) *ListFleetsForVehicleOutput {
	s.Fleets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFleetsForVehicleOutput) SetNextToken(v string) *ListFleetsForVehicleOutput {
	s.NextToken = &v
	return s
}

type ListFleetsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return, between 1 and 100, inclusive.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token for the next set of results.
	//
	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next set of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFleetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFleetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFleetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFleetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFleetsInput) SetMaxResults(v int64) *ListFleetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFleetsInput) SetNextToken(v string) *ListFleetsInput {
	s.NextToken = &v
	return s
}

type ListFleetsOutput struct {
	_ struct{} `type:"structure"`

	// A list of information for each fleet.
	FleetSummaries []*FleetSummary `locationName:"fleetSummaries" type:"list"`

	// The token to retrieve the next set of results, or null if there are no more
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFleetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFleetsOutput) GoString() string {
	return s.String()
}

// SetFleetSummaries sets the FleetSummaries field's value.
func (s *ListFleetsOutput) SetFleetSummaries(v []*FleetSummary) *ListFleetsOutput {
	s.FleetSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFleetsOutput) SetNextToken(v string) *ListFleetsOutput {
	s.NextToken = &v
	return s
}

type ListModelManifestNodesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return, between 1 and 100, inclusive.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The name of the vehicle model to list information about.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A pagination token for the next set of results.
	//
	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next set of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelManifestNodesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelManifestNodesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListModelManifestNodesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListModelManifestNodesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListModelManifestNodesInput) SetMaxResults(v int64) *ListModelManifestNodesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListModelManifestNodesInput) SetName(v string) *ListModelManifestNodesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListModelManifestNodesInput) SetNextToken(v string) *ListModelManifestNodesInput {
	s.NextToken = &v
	return s
}

type ListModelManifestNodesOutput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results, or null if there are no more
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of information about nodes.
	Nodes []*Node `locationName:"nodes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelManifestNodesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelManifestNodesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListModelManifestNodesOutput) SetNextToken(v string) *ListModelManifestNodesOutput {
	s.NextToken = &v
	return s
}

// SetNodes sets the Nodes field's value.
func (s *ListModelManifestNodesOutput) SetNodes(v []*Node) *ListModelManifestNodesOutput {
	s.Nodes = v
	return s
}

type ListModelManifestsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return, between 1 and 100, inclusive.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token for the next set of results.
	//
	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next set of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The ARN of a signal catalog. If you specify a signal catalog, only the vehicle
	// models associated with it are returned.
	SignalCatalogArn *string `locationName:"signalCatalogArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelManifestsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelManifestsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListModelManifestsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListModelManifestsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListModelManifestsInput) SetMaxResults(v int64) *ListModelManifestsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListModelManifestsInput) SetNextToken(v string) *ListModelManifestsInput {
	s.NextToken = &v
	return s
}

// SetSignalCatalogArn sets the SignalCatalogArn field's value.
func (s *ListModelManifestsInput) SetSignalCatalogArn(v string) *ListModelManifestsInput {
	s.SignalCatalogArn = &v
	return s
}

type ListModelManifestsOutput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results, or null if there are no more
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of information about vehicle models.
	Summaries []*ModelManifestSummary `locationName:"summaries" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelManifestsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelManifestsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListModelManifestsOutput) SetNextToken(v string) *ListModelManifestsOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *ListModelManifestsOutput) SetSummaries(v []*ModelManifestSummary) *ListModelManifestsOutput {
	s.Summaries = v
	return s
}

type ListSignalCatalogNodesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return, between 1 and 100, inclusive.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The name of the signal catalog to list information about.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A pagination token for the next set of results.
	//
	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next set of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The type of node in the signal catalog.
	SignalNodeType *string `locationName:"signalNodeType" type:"string" enum:"SignalNodeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSignalCatalogNodesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSignalCatalogNodesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSignalCatalogNodesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSignalCatalogNodesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSignalCatalogNodesInput) SetMaxResults(v int64) *ListSignalCatalogNodesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListSignalCatalogNodesInput) SetName(v string) *ListSignalCatalogNodesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSignalCatalogNodesInput) SetNextToken(v string) *ListSignalCatalogNodesInput {
	s.NextToken = &v
	return s
}

// SetSignalNodeType sets the SignalNodeType field's value.
func (s *ListSignalCatalogNodesInput) SetSignalNodeType(v string) *ListSignalCatalogNodesInput {
	s.SignalNodeType = &v
	return s
}

type ListSignalCatalogNodesOutput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results, or null if there are no more
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of information about nodes.
	Nodes []*Node `locationName:"nodes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSignalCatalogNodesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSignalCatalogNodesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSignalCatalogNodesOutput) SetNextToken(v string) *ListSignalCatalogNodesOutput {
	s.NextToken = &v
	return s
}

// SetNodes sets the Nodes field's value.
func (s *ListSignalCatalogNodesOutput) SetNodes(v []*Node) *ListSignalCatalogNodesOutput {
	s.Nodes = v
	return s
}

type ListSignalCatalogsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return, between 1 and 100, inclusive.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token for the next set of results.
	//
	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next set of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSignalCatalogsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSignalCatalogsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSignalCatalogsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSignalCatalogsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSignalCatalogsInput) SetMaxResults(v int64) *ListSignalCatalogsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSignalCatalogsInput) SetNextToken(v string) *ListSignalCatalogsInput {
	s.NextToken = &v
	return s
}

type ListSignalCatalogsOutput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results, or null if there are no more
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of information about each signal catalog.
	Summaries []*SignalCatalogSummary `locationName:"summaries" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSignalCatalogsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSignalCatalogsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSignalCatalogsOutput) SetNextToken(v string) *ListSignalCatalogsOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *ListSignalCatalogsOutput) SetSummaries(v []*SignalCatalogSummary) *ListSignalCatalogsOutput {
	s.Summaries = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags assigned to the resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListVehiclesInFleetInput struct {
	_ struct{} `type:"structure"`

	// The ID of a fleet.
	//
	// FleetId is a required field
	FleetId *string `locationName:"fleetId" min:"1" type:"string" required:"true"`

	// The maximum number of items to return, between 1 and 100, inclusive.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token for the next set of results.
	//
	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next set of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVehiclesInFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVehiclesInFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVehiclesInFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVehiclesInFleetInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *ListVehiclesInFleetInput) SetFleetId(v string) *ListVehiclesInFleetInput {
	s.FleetId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVehiclesInFleetInput) SetMaxResults(v int64) *ListVehiclesInFleetInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVehiclesInFleetInput) SetNextToken(v string) *ListVehiclesInFleetInput {
	s.NextToken = &v
	return s
}

type ListVehiclesInFleetOutput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results, or null if there are no more
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of vehicles associated with the fleet.
	Vehicles []*string `locationName:"vehicles" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVehiclesInFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVehiclesInFleetOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVehiclesInFleetOutput) SetNextToken(v string) *ListVehiclesInFleetOutput {
	s.NextToken = &v
	return s
}

// SetVehicles sets the Vehicles field's value.
func (s *ListVehiclesInFleetOutput) SetVehicles(v []*string) *ListVehiclesInFleetOutput {
	s.Vehicles = v
	return s
}

type ListVehiclesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return, between 1 and 100, inclusive.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of a vehicle model (model manifest). You can
	// use this optional parameter to list only the vehicles created from a certain
	// vehicle model.
	ModelManifestArn *string `locationName:"modelManifestArn" type:"string"`

	// A pagination token for the next set of results.
	//
	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next set of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVehiclesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVehiclesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVehiclesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVehiclesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVehiclesInput) SetMaxResults(v int64) *ListVehiclesInput {
	s.MaxResults = &v
	return s
}

// SetModelManifestArn sets the ModelManifestArn field's value.
func (s *ListVehiclesInput) SetModelManifestArn(v string) *ListVehiclesInput {
	s.ModelManifestArn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVehiclesInput) SetNextToken(v string) *ListVehiclesInput {
	s.NextToken = &v
	return s
}

type ListVehiclesOutput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results, or null if there are no more
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of vehicles and information about them.
	VehicleSummaries []*VehicleSummary `locationName:"vehicleSummaries" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVehiclesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVehiclesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVehiclesOutput) SetNextToken(v string) *ListVehiclesOutput {
	s.NextToken = &v
	return s
}

// SetVehicleSummaries sets the VehicleSummaries field's value.
func (s *ListVehiclesOutput) SetVehicleSummaries(v []*VehicleSummary) *ListVehiclesOutput {
	s.VehicleSummaries = v
	return s
}

// The decoding information for a specific message which support higher order
// data types.
type MessageSignal struct {
	_ struct{} `type:"structure"`

	// The structured message for the message signal. It can be defined with either
	// a primitiveMessageDefinition, structuredMessageListDefinition, or structuredMessageDefinition
	// recursively.
	//
	// StructuredMessage is a required field
	StructuredMessage *StructuredMessage `locationName:"structuredMessage" type:"structure" required:"true"`

	// The topic name for the message signal. It corresponds to topics in ROS 2.
	//
	// TopicName is a required field
	TopicName *string `locationName:"topicName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessageSignal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessageSignal) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageSignal) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MessageSignal"}
	if s.StructuredMessage == nil {
		invalidParams.Add(request.NewErrParamRequired("StructuredMessage"))
	}
	if s.TopicName == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicName"))
	}
	if s.TopicName != nil && len(*s.TopicName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TopicName", 1))
	}
	if s.StructuredMessage != nil {
		if err := s.StructuredMessage.Validate(); err != nil {
			invalidParams.AddNested("StructuredMessage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStructuredMessage sets the StructuredMessage field's value.
func (s *MessageSignal) SetStructuredMessage(v *StructuredMessage) *MessageSignal {
	s.StructuredMessage = v
	return s
}

// SetTopicName sets the TopicName field's value.
func (s *MessageSignal) SetTopicName(v string) *MessageSignal {
	s.TopicName = &v
	return s
}

// Information about a vehicle model (model manifest). You can use the API operation
// to return this information about multiple vehicle models.
type ModelManifestSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the vehicle model.
	Arn *string `locationName:"arn" type:"string"`

	// The time the vehicle model was created, in seconds since epoch (January 1,
	// 1970 at midnight UTC time).
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// A brief description of the vehicle model.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The time the vehicle model was last updated, in seconds since epoch (January
	// 1, 1970 at midnight UTC time).
	//
	// LastModificationTime is a required field
	LastModificationTime *time.Time `locationName:"lastModificationTime" type:"timestamp" required:"true"`

	// The name of the vehicle model.
	Name *string `locationName:"name" type:"string"`

	// The ARN of the signal catalog associated with the vehicle model.
	SignalCatalogArn *string `locationName:"signalCatalogArn" type:"string"`

	// The state of the vehicle model. If the status is ACTIVE, the vehicle model
	// can't be edited. If the status is DRAFT, you can edit the vehicle model.
	Status *string `locationName:"status" type:"string" enum:"ManifestStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelManifestSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelManifestSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ModelManifestSummary) SetArn(v string) *ModelManifestSummary {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ModelManifestSummary) SetCreationTime(v time.Time) *ModelManifestSummary {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ModelManifestSummary) SetDescription(v string) *ModelManifestSummary {
	s.Description = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *ModelManifestSummary) SetLastModificationTime(v time.Time) *ModelManifestSummary {
	s.LastModificationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ModelManifestSummary) SetName(v string) *ModelManifestSummary {
	s.Name = &v
	return s
}

// SetSignalCatalogArn sets the SignalCatalogArn field's value.
func (s *ModelManifestSummary) SetSignalCatalogArn(v string) *ModelManifestSummary {
	s.SignalCatalogArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ModelManifestSummary) SetStatus(v string) *ModelManifestSummary {
	s.Status = &v
	return s
}

// Specifications for defining a vehicle network.
type NetworkFileDefinition struct {
	_ struct{} `type:"structure"`

	// Information, including CAN DBC files, about the configurations used to create
	// a decoder manifest.
	CanDbc *CanDbcDefinition `locationName:"canDbc" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFileDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkFileDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NetworkFileDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NetworkFileDefinition"}
	if s.CanDbc != nil {
		if err := s.CanDbc.Validate(); err != nil {
			invalidParams.AddNested("CanDbc", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCanDbc sets the CanDbc field's value.
func (s *NetworkFileDefinition) SetCanDbc(v *CanDbcDefinition) *NetworkFileDefinition {
	s.CanDbc = v
	return s
}

// Represents a node and its specifications in an in-vehicle communication network.
// All signal decoders must be associated with a network node.
//
// To return this information about all the network interfaces specified in
// a decoder manifest, use the API operation.
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// Information about a network interface specified by the Controller Area Network
	// (CAN) protocol.
	CanInterface *CanInterface `locationName:"canInterface" type:"structure"`

	// The ID of the network interface.
	//
	// InterfaceId is a required field
	InterfaceId *string `locationName:"interfaceId" min:"1" type:"string" required:"true"`

	// Information about a network interface specified by the On-board diagnostic
	// (OBD) II protocol.
	ObdInterface *ObdInterface `locationName:"obdInterface" type:"structure"`

	// The network protocol for the vehicle. For example, CAN_SIGNAL specifies a
	// protocol that defines how data is communicated between electronic control
	// units (ECUs). OBD_SIGNAL specifies a protocol that defines how self-diagnostic
	// data is communicated between ECUs.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"NetworkInterfaceType"`

	// The vehicle middleware defined as a type of network interface. Examples of
	// vehicle middleware include ROS2 and SOME/IP.
	VehicleMiddleware *VehicleMiddleware `locationName:"vehicleMiddleware" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkInterface) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NetworkInterface) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NetworkInterface"}
	if s.InterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InterfaceId"))
	}
	if s.InterfaceId != nil && len(*s.InterfaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InterfaceId", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.CanInterface != nil {
		if err := s.CanInterface.Validate(); err != nil {
			invalidParams.AddNested("CanInterface", err.(request.ErrInvalidParams))
		}
	}
	if s.ObdInterface != nil {
		if err := s.ObdInterface.Validate(); err != nil {
			invalidParams.AddNested("ObdInterface", err.(request.ErrInvalidParams))
		}
	}
	if s.VehicleMiddleware != nil {
		if err := s.VehicleMiddleware.Validate(); err != nil {
			invalidParams.AddNested("VehicleMiddleware", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCanInterface sets the CanInterface field's value.
func (s *NetworkInterface) SetCanInterface(v *CanInterface) *NetworkInterface {
	s.CanInterface = v
	return s
}

// SetInterfaceId sets the InterfaceId field's value.
func (s *NetworkInterface) SetInterfaceId(v string) *NetworkInterface {
	s.InterfaceId = &v
	return s
}

// SetObdInterface sets the ObdInterface field's value.
func (s *NetworkInterface) SetObdInterface(v *ObdInterface) *NetworkInterface {
	s.ObdInterface = v
	return s
}

// SetType sets the Type field's value.
func (s *NetworkInterface) SetType(v string) *NetworkInterface {
	s.Type = &v
	return s
}

// SetVehicleMiddleware sets the VehicleMiddleware field's value.
func (s *NetworkInterface) SetVehicleMiddleware(v *VehicleMiddleware) *NetworkInterface {
	s.VehicleMiddleware = v
	return s
}

// A general abstraction of a signal. A node can be specified as an actuator,
// attribute, branch, or sensor.
type Node struct {
	_ struct{} `type:"structure"`

	// Information about a node specified as an actuator.
	//
	// An actuator is a digital representation of a vehicle device.
	Actuator *Actuator `locationName:"actuator" type:"structure"`

	// Information about a node specified as an attribute.
	//
	// An attribute represents static information about a vehicle.
	Attribute *Attribute `locationName:"attribute" type:"structure"`

	// Information about a node specified as a branch.
	//
	// A group of signals that are defined in a hierarchical structure.
	Branch *Branch `locationName:"branch" type:"structure"`

	// Represents a member of the complex data structure. The datatype of the property
	// can be either primitive or another struct.
	Property *CustomProperty `locationName:"property" type:"structure"`

	// An input component that reports the environmental condition of a vehicle.
	//
	// You can collect data about fluid levels, temperatures, vibrations, or battery
	// voltage from sensors.
	Sensor *Sensor `locationName:"sensor" type:"structure"`

	// Represents a complex or higher-order data structure.
	Struct *CustomStruct `locationName:"struct" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Node) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Node) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Node) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Node"}
	if s.Actuator != nil {
		if err := s.Actuator.Validate(); err != nil {
			invalidParams.AddNested("Actuator", err.(request.ErrInvalidParams))
		}
	}
	if s.Attribute != nil {
		if err := s.Attribute.Validate(); err != nil {
			invalidParams.AddNested("Attribute", err.(request.ErrInvalidParams))
		}
	}
	if s.Branch != nil {
		if err := s.Branch.Validate(); err != nil {
			invalidParams.AddNested("Branch", err.(request.ErrInvalidParams))
		}
	}
	if s.Property != nil {
		if err := s.Property.Validate(); err != nil {
			invalidParams.AddNested("Property", err.(request.ErrInvalidParams))
		}
	}
	if s.Sensor != nil {
		if err := s.Sensor.Validate(); err != nil {
			invalidParams.AddNested("Sensor", err.(request.ErrInvalidParams))
		}
	}
	if s.Struct != nil {
		if err := s.Struct.Validate(); err != nil {
			invalidParams.AddNested("Struct", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActuator sets the Actuator field's value.
func (s *Node) SetActuator(v *Actuator) *Node {
	s.Actuator = v
	return s
}

// SetAttribute sets the Attribute field's value.
func (s *Node) SetAttribute(v *Attribute) *Node {
	s.Attribute = v
	return s
}

// SetBranch sets the Branch field's value.
func (s *Node) SetBranch(v *Branch) *Node {
	s.Branch = v
	return s
}

// SetProperty sets the Property field's value.
func (s *Node) SetProperty(v *CustomProperty) *Node {
	s.Property = v
	return s
}

// SetSensor sets the Sensor field's value.
func (s *Node) SetSensor(v *Sensor) *Node {
	s.Sensor = v
	return s
}

// SetStruct sets the Struct field's value.
func (s *Node) SetStruct(v *CustomStruct) *Node {
	s.Struct = v
	return s
}

// Information about the number of nodes and node types in a vehicle network.
type NodeCounts struct {
	_ struct{} `type:"structure"`

	// The total number of nodes in a vehicle network that represent actuators.
	TotalActuators *int64 `locationName:"totalActuators" type:"integer"`

	// The total number of nodes in a vehicle network that represent attributes.
	TotalAttributes *int64 `locationName:"totalAttributes" type:"integer"`

	// The total number of nodes in a vehicle network that represent branches.
	TotalBranches *int64 `locationName:"totalBranches" type:"integer"`

	// The total number of nodes in a vehicle network.
	TotalNodes *int64 `locationName:"totalNodes" type:"integer"`

	// The total properties for the node.
	TotalProperties *int64 `locationName:"totalProperties" type:"integer"`

	// The total number of nodes in a vehicle network that represent sensors.
	TotalSensors *int64 `locationName:"totalSensors" type:"integer"`

	// The total structure for the node.
	TotalStructs *int64 `locationName:"totalStructs" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeCounts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeCounts) GoString() string {
	return s.String()
}

// SetTotalActuators sets the TotalActuators field's value.
func (s *NodeCounts) SetTotalActuators(v int64) *NodeCounts {
	s.TotalActuators = &v
	return s
}

// SetTotalAttributes sets the TotalAttributes field's value.
func (s *NodeCounts) SetTotalAttributes(v int64) *NodeCounts {
	s.TotalAttributes = &v
	return s
}

// SetTotalBranches sets the TotalBranches field's value.
func (s *NodeCounts) SetTotalBranches(v int64) *NodeCounts {
	s.TotalBranches = &v
	return s
}

// SetTotalNodes sets the TotalNodes field's value.
func (s *NodeCounts) SetTotalNodes(v int64) *NodeCounts {
	s.TotalNodes = &v
	return s
}

// SetTotalProperties sets the TotalProperties field's value.
func (s *NodeCounts) SetTotalProperties(v int64) *NodeCounts {
	s.TotalProperties = &v
	return s
}

// SetTotalSensors sets the TotalSensors field's value.
func (s *NodeCounts) SetTotalSensors(v int64) *NodeCounts {
	s.TotalSensors = &v
	return s
}

// SetTotalStructs sets the TotalStructs field's value.
func (s *NodeCounts) SetTotalStructs(v int64) *NodeCounts {
	s.TotalStructs = &v
	return s
}

// A network interface that specifies the On-board diagnostic (OBD) II network
// protocol.
type ObdInterface struct {
	_ struct{} `type:"structure"`

	// The maximum number message requests per diagnostic trouble code per second.
	DtcRequestIntervalSeconds *int64 `locationName:"dtcRequestIntervalSeconds" type:"integer"`

	// Whether the vehicle has a transmission control module (TCM).
	HasTransmissionEcu *bool `locationName:"hasTransmissionEcu" type:"boolean"`

	// The name of the interface.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The standard OBD II PID.
	ObdStandard *string `locationName:"obdStandard" min:"1" type:"string"`

	// The maximum number message requests per second.
	PidRequestIntervalSeconds *int64 `locationName:"pidRequestIntervalSeconds" type:"integer"`

	// The ID of the message requesting vehicle data.
	//
	// RequestMessageId is a required field
	RequestMessageId *int64 `locationName:"requestMessageId" type:"integer" required:"true"`

	// Whether to use extended IDs in the message.
	UseExtendedIds *bool `locationName:"useExtendedIds" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObdInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObdInterface) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ObdInterface) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ObdInterface"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ObdStandard != nil && len(*s.ObdStandard) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObdStandard", 1))
	}
	if s.RequestMessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestMessageId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDtcRequestIntervalSeconds sets the DtcRequestIntervalSeconds field's value.
func (s *ObdInterface) SetDtcRequestIntervalSeconds(v int64) *ObdInterface {
	s.DtcRequestIntervalSeconds = &v
	return s
}

// SetHasTransmissionEcu sets the HasTransmissionEcu field's value.
func (s *ObdInterface) SetHasTransmissionEcu(v bool) *ObdInterface {
	s.HasTransmissionEcu = &v
	return s
}

// SetName sets the Name field's value.
func (s *ObdInterface) SetName(v string) *ObdInterface {
	s.Name = &v
	return s
}

// SetObdStandard sets the ObdStandard field's value.
func (s *ObdInterface) SetObdStandard(v string) *ObdInterface {
	s.ObdStandard = &v
	return s
}

// SetPidRequestIntervalSeconds sets the PidRequestIntervalSeconds field's value.
func (s *ObdInterface) SetPidRequestIntervalSeconds(v int64) *ObdInterface {
	s.PidRequestIntervalSeconds = &v
	return s
}

// SetRequestMessageId sets the RequestMessageId field's value.
func (s *ObdInterface) SetRequestMessageId(v int64) *ObdInterface {
	s.RequestMessageId = &v
	return s
}

// SetUseExtendedIds sets the UseExtendedIds field's value.
func (s *ObdInterface) SetUseExtendedIds(v bool) *ObdInterface {
	s.UseExtendedIds = &v
	return s
}

// Information about signal messages using the on-board diagnostics (OBD) II
// protocol in a vehicle.
type ObdSignal struct {
	_ struct{} `type:"structure"`

	// The number of bits to mask in a message.
	BitMaskLength *int64 `locationName:"bitMaskLength" min:"1" type:"integer"`

	// The number of positions to shift bits in the message.
	BitRightShift *int64 `locationName:"bitRightShift" type:"integer"`

	// The length of a message.
	//
	// ByteLength is a required field
	ByteLength *int64 `locationName:"byteLength" min:"1" type:"integer" required:"true"`

	// The offset used to calculate the signal value. Combined with scaling, the
	// calculation is value = raw_value * scaling + offset.
	//
	// Offset is a required field
	Offset *float64 `locationName:"offset" type:"double" required:"true"`

	// The diagnostic code used to request data from a vehicle for this signal.
	//
	// Pid is a required field
	Pid *int64 `locationName:"pid" type:"integer" required:"true"`

	// The length of the requested data.
	//
	// PidResponseLength is a required field
	PidResponseLength *int64 `locationName:"pidResponseLength" min:"1" type:"integer" required:"true"`

	// A multiplier used to decode the message.
	//
	// Scaling is a required field
	Scaling *float64 `locationName:"scaling" type:"double" required:"true"`

	// The mode of operation (diagnostic service) in a message.
	//
	// ServiceMode is a required field
	ServiceMode *int64 `locationName:"serviceMode" type:"integer" required:"true"`

	// Indicates the beginning of the message.
	//
	// StartByte is a required field
	StartByte *int64 `locationName:"startByte" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObdSignal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObdSignal) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ObdSignal) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ObdSignal"}
	if s.BitMaskLength != nil && *s.BitMaskLength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BitMaskLength", 1))
	}
	if s.ByteLength == nil {
		invalidParams.Add(request.NewErrParamRequired("ByteLength"))
	}
	if s.ByteLength != nil && *s.ByteLength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ByteLength", 1))
	}
	if s.Offset == nil {
		invalidParams.Add(request.NewErrParamRequired("Offset"))
	}
	if s.Pid == nil {
		invalidParams.Add(request.NewErrParamRequired("Pid"))
	}
	if s.PidResponseLength == nil {
		invalidParams.Add(request.NewErrParamRequired("PidResponseLength"))
	}
	if s.PidResponseLength != nil && *s.PidResponseLength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PidResponseLength", 1))
	}
	if s.Scaling == nil {
		invalidParams.Add(request.NewErrParamRequired("Scaling"))
	}
	if s.ServiceMode == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceMode"))
	}
	if s.StartByte == nil {
		invalidParams.Add(request.NewErrParamRequired("StartByte"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBitMaskLength sets the BitMaskLength field's value.
func (s *ObdSignal) SetBitMaskLength(v int64) *ObdSignal {
	s.BitMaskLength = &v
	return s
}

// SetBitRightShift sets the BitRightShift field's value.
func (s *ObdSignal) SetBitRightShift(v int64) *ObdSignal {
	s.BitRightShift = &v
	return s
}

// SetByteLength sets the ByteLength field's value.
func (s *ObdSignal) SetByteLength(v int64) *ObdSignal {
	s.ByteLength = &v
	return s
}

// SetOffset sets the Offset field's value.
func (s *ObdSignal) SetOffset(v float64) *ObdSignal {
	s.Offset = &v
	return s
}

// SetPid sets the Pid field's value.
func (s *ObdSignal) SetPid(v int64) *ObdSignal {
	s.Pid = &v
	return s
}

// SetPidResponseLength sets the PidResponseLength field's value.
func (s *ObdSignal) SetPidResponseLength(v int64) *ObdSignal {
	s.PidResponseLength = &v
	return s
}

// SetScaling sets the Scaling field's value.
func (s *ObdSignal) SetScaling(v float64) *ObdSignal {
	s.Scaling = &v
	return s
}

// SetServiceMode sets the ServiceMode field's value.
func (s *ObdSignal) SetServiceMode(v int64) *ObdSignal {
	s.ServiceMode = &v
	return s
}

// SetStartByte sets the StartByte field's value.
func (s *ObdSignal) SetStartByte(v int64) *ObdSignal {
	s.StartByte = &v
	return s
}

// Represents a primitive type node of the complex data structure.
type PrimitiveMessageDefinition struct {
	_ struct{} `type:"structure"`

	// Information about a PrimitiveMessage using a ROS 2 compliant primitive type
	// message of the complex data structure.
	Ros2PrimitiveMessageDefinition *ROS2PrimitiveMessageDefinition `locationName:"ros2PrimitiveMessageDefinition" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrimitiveMessageDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrimitiveMessageDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrimitiveMessageDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrimitiveMessageDefinition"}
	if s.Ros2PrimitiveMessageDefinition != nil {
		if err := s.Ros2PrimitiveMessageDefinition.Validate(); err != nil {
			invalidParams.AddNested("Ros2PrimitiveMessageDefinition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRos2PrimitiveMessageDefinition sets the Ros2PrimitiveMessageDefinition field's value.
func (s *PrimitiveMessageDefinition) SetRos2PrimitiveMessageDefinition(v *ROS2PrimitiveMessageDefinition) *PrimitiveMessageDefinition {
	s.Ros2PrimitiveMessageDefinition = v
	return s
}

type PutEncryptionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The type of encryption. Choose KMS_BASED_ENCRYPTION to use a KMS key or FLEETWISE_DEFAULT_ENCRYPTION
	// to use an Amazon Web Services managed key.
	//
	// EncryptionType is a required field
	EncryptionType *string `locationName:"encryptionType" type:"string" required:"true" enum:"EncryptionType"`

	// The ID of the KMS key that is used for encryption.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEncryptionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEncryptionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEncryptionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEncryptionConfigurationInput"}
	if s.EncryptionType == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *PutEncryptionConfigurationInput) SetEncryptionType(v string) *PutEncryptionConfigurationInput {
	s.EncryptionType = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *PutEncryptionConfigurationInput) SetKmsKeyId(v string) *PutEncryptionConfigurationInput {
	s.KmsKeyId = &v
	return s
}

type PutEncryptionConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The encryption status.
	//
	// EncryptionStatus is a required field
	EncryptionStatus *string `locationName:"encryptionStatus" type:"string" required:"true" enum:"EncryptionStatus"`

	// The type of encryption. Set to KMS_BASED_ENCRYPTION to use an KMS key that
	// you own and manage. Set to FLEETWISE_DEFAULT_ENCRYPTION to use an Amazon
	// Web Services managed key that is owned by the Amazon Web Services IoT FleetWise
	// service account.
	//
	// EncryptionType is a required field
	EncryptionType *string `locationName:"encryptionType" type:"string" required:"true" enum:"EncryptionType"`

	// The ID of the KMS key that is used for encryption.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEncryptionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEncryptionConfigurationOutput) GoString() string {
	return s.String()
}

// SetEncryptionStatus sets the EncryptionStatus field's value.
func (s *PutEncryptionConfigurationOutput) SetEncryptionStatus(v string) *PutEncryptionConfigurationOutput {
	s.EncryptionStatus = &v
	return s
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *PutEncryptionConfigurationOutput) SetEncryptionType(v string) *PutEncryptionConfigurationOutput {
	s.EncryptionType = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *PutEncryptionConfigurationOutput) SetKmsKeyId(v string) *PutEncryptionConfigurationOutput {
	s.KmsKeyId = &v
	return s
}

type PutLoggingOptionsInput struct {
	_ struct{} `type:"structure"`

	// Creates or updates the log delivery option to Amazon CloudWatch Logs.
	//
	// CloudWatchLogDelivery is a required field
	CloudWatchLogDelivery *CloudWatchLogDeliveryOptions `locationName:"cloudWatchLogDelivery" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLoggingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLoggingOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutLoggingOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutLoggingOptionsInput"}
	if s.CloudWatchLogDelivery == nil {
		invalidParams.Add(request.NewErrParamRequired("CloudWatchLogDelivery"))
	}
	if s.CloudWatchLogDelivery != nil {
		if err := s.CloudWatchLogDelivery.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchLogDelivery", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogDelivery sets the CloudWatchLogDelivery field's value.
func (s *PutLoggingOptionsInput) SetCloudWatchLogDelivery(v *CloudWatchLogDeliveryOptions) *PutLoggingOptionsInput {
	s.CloudWatchLogDelivery = v
	return s
}

type PutLoggingOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLoggingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLoggingOptionsOutput) GoString() string {
	return s.String()
}

// Represents a ROS 2 compliant primitive type message of the complex data structure.
type ROS2PrimitiveMessageDefinition struct {
	_ struct{} `type:"structure"`

	// The offset used to calculate the signal value. Combined with scaling, the
	// calculation is value = raw_value * scaling + offset.
	Offset *float64 `locationName:"offset" type:"double"`

	// The primitive type (integer, floating point, boolean, etc.) for the ROS 2
	// primitive message definition.
	//
	// PrimitiveType is a required field
	PrimitiveType *string `locationName:"primitiveType" type:"string" required:"true" enum:"ROS2PrimitiveType"`

	// A multiplier used to decode the message.
	Scaling *float64 `locationName:"scaling" type:"double"`

	// An optional attribute specifying the upper bound for STRING and WSTRING.
	UpperBound *int64 `locationName:"upperBound" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ROS2PrimitiveMessageDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ROS2PrimitiveMessageDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ROS2PrimitiveMessageDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ROS2PrimitiveMessageDefinition"}
	if s.PrimitiveType == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimitiveType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOffset sets the Offset field's value.
func (s *ROS2PrimitiveMessageDefinition) SetOffset(v float64) *ROS2PrimitiveMessageDefinition {
	s.Offset = &v
	return s
}

// SetPrimitiveType sets the PrimitiveType field's value.
func (s *ROS2PrimitiveMessageDefinition) SetPrimitiveType(v string) *ROS2PrimitiveMessageDefinition {
	s.PrimitiveType = &v
	return s
}

// SetScaling sets the Scaling field's value.
func (s *ROS2PrimitiveMessageDefinition) SetScaling(v float64) *ROS2PrimitiveMessageDefinition {
	s.Scaling = &v
	return s
}

// SetUpperBound sets the UpperBound field's value.
func (s *ROS2PrimitiveMessageDefinition) SetUpperBound(v int64) *ROS2PrimitiveMessageDefinition {
	s.UpperBound = &v
	return s
}

type RegisterAccountInput struct {
	_ struct{} `type:"structure"`

	// The IAM resource that allows Amazon Web Services IoT FleetWise to send data
	// to Amazon Timestream.
	//
	// Deprecated: iamResources is no longer used or needed as input
	IamResources *IamResources `locationName:"iamResources" deprecated:"true" type:"structure"`

	// The registered Amazon Timestream resources that Amazon Web Services IoT FleetWise
	// edge agent software can transfer your vehicle data to.
	//
	// Deprecated: Amazon Timestream metadata is now passed in the CreateCampaign API.
	TimestreamResources *TimestreamResources `locationName:"timestreamResources" deprecated:"true" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterAccountInput"}
	if s.IamResources != nil {
		if err := s.IamResources.Validate(); err != nil {
			invalidParams.AddNested("IamResources", err.(request.ErrInvalidParams))
		}
	}
	if s.TimestreamResources != nil {
		if err := s.TimestreamResources.Validate(); err != nil {
			invalidParams.AddNested("TimestreamResources", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIamResources sets the IamResources field's value.
func (s *RegisterAccountInput) SetIamResources(v *IamResources) *RegisterAccountInput {
	s.IamResources = v
	return s
}

// SetTimestreamResources sets the TimestreamResources field's value.
func (s *RegisterAccountInput) SetTimestreamResources(v *TimestreamResources) *RegisterAccountInput {
	s.TimestreamResources = v
	return s
}

type RegisterAccountOutput struct {
	_ struct{} `type:"structure"`

	// The time the account was registered, in seconds since epoch (January 1, 1970
	// at midnight UTC time).
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// The registered IAM resource that allows Amazon Web Services IoT FleetWise
	// to send data to Amazon Timestream.
	//
	// IamResources is a required field
	IamResources *IamResources `locationName:"iamResources" type:"structure" required:"true"`

	// The time this registration was last updated, in seconds since epoch (January
	// 1, 1970 at midnight UTC time).
	//
	// LastModificationTime is a required field
	LastModificationTime *time.Time `locationName:"lastModificationTime" type:"timestamp" required:"true"`

	// The status of registering your Amazon Web Services account, IAM role, and
	// Timestream resources.
	//
	// RegisterAccountStatus is a required field
	RegisterAccountStatus *string `locationName:"registerAccountStatus" type:"string" required:"true" enum:"RegistrationStatus"`

	// The registered Amazon Timestream resources that Amazon Web Services IoT FleetWise
	// edge agent software can transfer your vehicle data to.
	TimestreamResources *TimestreamResources `locationName:"timestreamResources" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterAccountOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *RegisterAccountOutput) SetCreationTime(v time.Time) *RegisterAccountOutput {
	s.CreationTime = &v
	return s
}

// SetIamResources sets the IamResources field's value.
func (s *RegisterAccountOutput) SetIamResources(v *IamResources) *RegisterAccountOutput {
	s.IamResources = v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *RegisterAccountOutput) SetLastModificationTime(v time.Time) *RegisterAccountOutput {
	s.LastModificationTime = &v
	return s
}

// SetRegisterAccountStatus sets the RegisterAccountStatus field's value.
func (s *RegisterAccountOutput) SetRegisterAccountStatus(v string) *RegisterAccountOutput {
	s.RegisterAccountStatus = &v
	return s
}

// SetTimestreamResources sets the TimestreamResources field's value.
func (s *RegisterAccountOutput) SetTimestreamResources(v *TimestreamResources) *RegisterAccountOutput {
	s.TimestreamResources = v
	return s
}

// The resource wasn't found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The identifier of the resource that wasn't found.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of resource that wasn't found.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The Amazon S3 bucket where the Amazon Web Services IoT FleetWise campaign
// sends data. Amazon S3 is an object storage service that stores data as objects
// within buckets. For more information, see Creating, configuring, and working
// with Amazon S3 buckets (https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html)
// in the Amazon Simple Storage Service User Guide.
type S3Config struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon S3 bucket.
	//
	// BucketArn is a required field
	BucketArn *string `locationName:"bucketArn" min:"16" type:"string" required:"true"`

	// Specify the format that files are saved in the Amazon S3 bucket. You can
	// save files in an Apache Parquet or JSON format.
	//
	//    * Parquet - Store data in a columnar storage file format. Parquet is optimal
	//    for fast data retrieval and can reduce costs. This option is selected
	//    by default.
	//
	//    * JSON - Store data in a standard text-based JSON file format.
	DataFormat *string `locationName:"dataFormat" type:"string" enum:"DataFormat"`

	// (Optional) Enter an S3 bucket prefix. The prefix is the string of characters
	// after the bucket name and before the object name. You can use the prefix
	// to organize data stored in Amazon S3 buckets. For more information, see Organizing
	// objects using prefixes (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html)
	// in the Amazon Simple Storage Service User Guide.
	//
	// By default, Amazon Web Services IoT FleetWise sets the prefix processed-data/year=YY/month=MM/date=DD/hour=HH/
	// (in UTC) to data it delivers to Amazon S3. You can enter a prefix to append
	// it to this default prefix. For example, if you enter the prefix vehicles,
	// the prefix will be vehicles/processed-data/year=YY/month=MM/date=DD/hour=HH/.
	Prefix *string `locationName:"prefix" min:"1" type:"string"`

	// By default, stored data is compressed as a .gzip file. Compressed files have
	// a reduced file size, which can optimize the cost of data storage.
	StorageCompressionFormat *string `locationName:"storageCompressionFormat" type:"string" enum:"StorageCompressionFormat"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Config) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Config) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Config) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Config"}
	if s.BucketArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketArn"))
	}
	if s.BucketArn != nil && len(*s.BucketArn) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("BucketArn", 16))
	}
	if s.Prefix != nil && len(*s.Prefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Prefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketArn sets the BucketArn field's value.
func (s *S3Config) SetBucketArn(v string) *S3Config {
	s.BucketArn = &v
	return s
}

// SetDataFormat sets the DataFormat field's value.
func (s *S3Config) SetDataFormat(v string) *S3Config {
	s.DataFormat = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3Config) SetPrefix(v string) *S3Config {
	s.Prefix = &v
	return s
}

// SetStorageCompressionFormat sets the StorageCompressionFormat field's value.
func (s *S3Config) SetStorageCompressionFormat(v string) *S3Config {
	s.StorageCompressionFormat = &v
	return s
}

// An input component that reports the environmental condition of a vehicle.
//
// You can collect data about fluid levels, temperatures, vibrations, or battery
// voltage from sensors.
type Sensor struct {
	_ struct{} `type:"structure"`

	// A list of possible values a sensor can take.
	AllowedValues []*string `locationName:"allowedValues" type:"list"`

	// A comment in addition to the description.
	Comment *string `locationName:"comment" min:"1" type:"string"`

	// The specified data type of the sensor.
	//
	// DataType is a required field
	DataType *string `locationName:"dataType" type:"string" required:"true" enum:"NodeDataType"`

	// The deprecation message for the node or the branch that was moved or deleted.
	DeprecationMessage *string `locationName:"deprecationMessage" min:"1" type:"string"`

	// A brief description of a sensor.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The fully qualified name of the sensor. For example, the fully qualified
	// name of a sensor might be Vehicle.Body.Engine.Battery.
	//
	// FullyQualifiedName is a required field
	FullyQualifiedName *string `locationName:"fullyQualifiedName" type:"string" required:"true"`

	// The specified possible maximum value of the sensor.
	Max *float64 `locationName:"max" type:"double"`

	// The specified possible minimum value of the sensor.
	Min *float64 `locationName:"min" type:"double"`

	// The fully qualified name of the struct node for a sensor if the data type
	// of the actuator is Struct or StructArray. For example, the struct fully qualified
	// name of a sensor might be Vehicle.ADAS.CameraStruct.
	StructFullyQualifiedName *string `locationName:"structFullyQualifiedName" min:"1" type:"string"`

	// The scientific unit of measurement for data collected by the sensor.
	Unit *string `locationName:"unit" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Sensor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Sensor) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Sensor) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Sensor"}
	if s.Comment != nil && len(*s.Comment) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Comment", 1))
	}
	if s.DataType == nil {
		invalidParams.Add(request.NewErrParamRequired("DataType"))
	}
	if s.DeprecationMessage != nil && len(*s.DeprecationMessage) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeprecationMessage", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.FullyQualifiedName == nil {
		invalidParams.Add(request.NewErrParamRequired("FullyQualifiedName"))
	}
	if s.StructFullyQualifiedName != nil && len(*s.StructFullyQualifiedName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StructFullyQualifiedName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *Sensor) SetAllowedValues(v []*string) *Sensor {
	s.AllowedValues = v
	return s
}

// SetComment sets the Comment field's value.
func (s *Sensor) SetComment(v string) *Sensor {
	s.Comment = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *Sensor) SetDataType(v string) *Sensor {
	s.DataType = &v
	return s
}

// SetDeprecationMessage sets the DeprecationMessage field's value.
func (s *Sensor) SetDeprecationMessage(v string) *Sensor {
	s.DeprecationMessage = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Sensor) SetDescription(v string) *Sensor {
	s.Description = &v
	return s
}

// SetFullyQualifiedName sets the FullyQualifiedName field's value.
func (s *Sensor) SetFullyQualifiedName(v string) *Sensor {
	s.FullyQualifiedName = &v
	return s
}

// SetMax sets the Max field's value.
func (s *Sensor) SetMax(v float64) *Sensor {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *Sensor) SetMin(v float64) *Sensor {
	s.Min = &v
	return s
}

// SetStructFullyQualifiedName sets the StructFullyQualifiedName field's value.
func (s *Sensor) SetStructFullyQualifiedName(v string) *Sensor {
	s.StructFullyQualifiedName = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *Sensor) SetUnit(v string) *Sensor {
	s.Unit = &v
	return s
}

// Information about a collection of standardized signals, which can be attributes,
// branches, sensors, or actuators.
type SignalCatalogSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the signal catalog.
	Arn *string `locationName:"arn" type:"string"`

	// The time the signal catalog was created in seconds since epoch (January 1,
	// 1970 at midnight UTC time).
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The time the signal catalog was last updated in seconds since epoch (January
	// 1, 1970 at midnight UTC time).
	LastModificationTime *time.Time `locationName:"lastModificationTime" type:"timestamp"`

	// The name of the signal catalog.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SignalCatalogSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SignalCatalogSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SignalCatalogSummary) SetArn(v string) *SignalCatalogSummary {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *SignalCatalogSummary) SetCreationTime(v time.Time) *SignalCatalogSummary {
	s.CreationTime = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *SignalCatalogSummary) SetLastModificationTime(v time.Time) *SignalCatalogSummary {
	s.LastModificationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *SignalCatalogSummary) SetName(v string) *SignalCatalogSummary {
	s.Name = &v
	return s
}

// Information about a signal decoder.
type SignalDecoder struct {
	_ struct{} `type:"structure"`

	// Information about signal decoder using the Controller Area Network (CAN)
	// protocol.
	CanSignal *CanSignal `locationName:"canSignal" type:"structure"`

	// The fully qualified name of a signal decoder as defined in a vehicle model.
	//
	// FullyQualifiedName is a required field
	FullyQualifiedName *string `locationName:"fullyQualifiedName" min:"1" type:"string" required:"true"`

	// The ID of a network interface that specifies what network protocol a vehicle
	// follows.
	//
	// InterfaceId is a required field
	InterfaceId *string `locationName:"interfaceId" min:"1" type:"string" required:"true"`

	// The decoding information for a specific message which supports higher order
	// data types.
	MessageSignal *MessageSignal `locationName:"messageSignal" type:"structure"`

	// Information about signal decoder using the On-board diagnostic (OBD) II protocol.
	ObdSignal *ObdSignal `locationName:"obdSignal" type:"structure"`

	// The network protocol for the vehicle. For example, CAN_SIGNAL specifies a
	// protocol that defines how data is communicated between electronic control
	// units (ECUs). OBD_SIGNAL specifies a protocol that defines how self-diagnostic
	// data is communicated between ECUs.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"SignalDecoderType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SignalDecoder) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SignalDecoder) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SignalDecoder) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SignalDecoder"}
	if s.FullyQualifiedName == nil {
		invalidParams.Add(request.NewErrParamRequired("FullyQualifiedName"))
	}
	if s.FullyQualifiedName != nil && len(*s.FullyQualifiedName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FullyQualifiedName", 1))
	}
	if s.InterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InterfaceId"))
	}
	if s.InterfaceId != nil && len(*s.InterfaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InterfaceId", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.CanSignal != nil {
		if err := s.CanSignal.Validate(); err != nil {
			invalidParams.AddNested("CanSignal", err.(request.ErrInvalidParams))
		}
	}
	if s.MessageSignal != nil {
		if err := s.MessageSignal.Validate(); err != nil {
			invalidParams.AddNested("MessageSignal", err.(request.ErrInvalidParams))
		}
	}
	if s.ObdSignal != nil {
		if err := s.ObdSignal.Validate(); err != nil {
			invalidParams.AddNested("ObdSignal", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCanSignal sets the CanSignal field's value.
func (s *SignalDecoder) SetCanSignal(v *CanSignal) *SignalDecoder {
	s.CanSignal = v
	return s
}

// SetFullyQualifiedName sets the FullyQualifiedName field's value.
func (s *SignalDecoder) SetFullyQualifiedName(v string) *SignalDecoder {
	s.FullyQualifiedName = &v
	return s
}

// SetInterfaceId sets the InterfaceId field's value.
func (s *SignalDecoder) SetInterfaceId(v string) *SignalDecoder {
	s.InterfaceId = &v
	return s
}

// SetMessageSignal sets the MessageSignal field's value.
func (s *SignalDecoder) SetMessageSignal(v *MessageSignal) *SignalDecoder {
	s.MessageSignal = v
	return s
}

// SetObdSignal sets the ObdSignal field's value.
func (s *SignalDecoder) SetObdSignal(v *ObdSignal) *SignalDecoder {
	s.ObdSignal = v
	return s
}

// SetType sets the Type field's value.
func (s *SignalDecoder) SetType(v string) *SignalDecoder {
	s.Type = &v
	return s
}

// Information about a signal.
type SignalInformation struct {
	_ struct{} `type:"structure"`

	// The maximum number of samples to collect.
	MaxSampleCount *int64 `locationName:"maxSampleCount" min:"1" type:"long"`

	// The minimum duration of time (in milliseconds) between two triggering events
	// to collect data.
	//
	// If a signal changes often, you might want to collect data at a slower rate.
	MinimumSamplingIntervalMs *int64 `locationName:"minimumSamplingIntervalMs" type:"long"`

	// The name of the signal.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SignalInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SignalInformation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SignalInformation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SignalInformation"}
	if s.MaxSampleCount != nil && *s.MaxSampleCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxSampleCount", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxSampleCount sets the MaxSampleCount field's value.
func (s *SignalInformation) SetMaxSampleCount(v int64) *SignalInformation {
	s.MaxSampleCount = &v
	return s
}

// SetMinimumSamplingIntervalMs sets the MinimumSamplingIntervalMs field's value.
func (s *SignalInformation) SetMinimumSamplingIntervalMs(v int64) *SignalInformation {
	s.MinimumSamplingIntervalMs = &v
	return s
}

// SetName sets the Name field's value.
func (s *SignalInformation) SetName(v string) *SignalInformation {
	s.Name = &v
	return s
}

// The structured message for the message signal. It can be defined with either
// a primitiveMessageDefinition, structuredMessageListDefinition, or structuredMessageDefinition
// recursively.
type StructuredMessage struct {
	_ struct{} `type:"structure"`

	// Represents a primitive type node of the complex data structure.
	PrimitiveMessageDefinition *PrimitiveMessageDefinition `locationName:"primitiveMessageDefinition" type:"structure"`

	// Represents a struct type node of the complex data structure.
	StructuredMessageDefinition []*StructuredMessageFieldNameAndDataTypePair `locationName:"structuredMessageDefinition" min:"1" type:"list"`

	// Represents a list type node of the complex data structure.
	StructuredMessageListDefinition *StructuredMessageListDefinition `locationName:"structuredMessageListDefinition" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StructuredMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StructuredMessage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StructuredMessage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StructuredMessage"}
	if s.StructuredMessageDefinition != nil && len(s.StructuredMessageDefinition) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StructuredMessageDefinition", 1))
	}
	if s.PrimitiveMessageDefinition != nil {
		if err := s.PrimitiveMessageDefinition.Validate(); err != nil {
			invalidParams.AddNested("PrimitiveMessageDefinition", err.(request.ErrInvalidParams))
		}
	}
	if s.StructuredMessageDefinition != nil {
		for i, v := range s.StructuredMessageDefinition {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StructuredMessageDefinition", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.StructuredMessageListDefinition != nil {
		if err := s.StructuredMessageListDefinition.Validate(); err != nil {
			invalidParams.AddNested("StructuredMessageListDefinition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrimitiveMessageDefinition sets the PrimitiveMessageDefinition field's value.
func (s *StructuredMessage) SetPrimitiveMessageDefinition(v *PrimitiveMessageDefinition) *StructuredMessage {
	s.PrimitiveMessageDefinition = v
	return s
}

// SetStructuredMessageDefinition sets the StructuredMessageDefinition field's value.
func (s *StructuredMessage) SetStructuredMessageDefinition(v []*StructuredMessageFieldNameAndDataTypePair) *StructuredMessage {
	s.StructuredMessageDefinition = v
	return s
}

// SetStructuredMessageListDefinition sets the StructuredMessageListDefinition field's value.
func (s *StructuredMessage) SetStructuredMessageListDefinition(v *StructuredMessageListDefinition) *StructuredMessage {
	s.StructuredMessageListDefinition = v
	return s
}

// Represents a StructureMessageName to DataType map element.
type StructuredMessageFieldNameAndDataTypePair struct {
	_ struct{} `type:"structure"`

	// The data type.
	//
	// DataType is a required field
	DataType *StructuredMessage `locationName:"dataType" type:"structure" required:"true"`

	// The field name of the structured message. It determines how a data value
	// is referenced in the target language.
	//
	// FieldName is a required field
	FieldName *string `locationName:"fieldName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StructuredMessageFieldNameAndDataTypePair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StructuredMessageFieldNameAndDataTypePair) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StructuredMessageFieldNameAndDataTypePair) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StructuredMessageFieldNameAndDataTypePair"}
	if s.DataType == nil {
		invalidParams.Add(request.NewErrParamRequired("DataType"))
	}
	if s.FieldName == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldName"))
	}
	if s.FieldName != nil && len(*s.FieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldName", 1))
	}
	if s.DataType != nil {
		if err := s.DataType.Validate(); err != nil {
			invalidParams.AddNested("DataType", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataType sets the DataType field's value.
func (s *StructuredMessageFieldNameAndDataTypePair) SetDataType(v *StructuredMessage) *StructuredMessageFieldNameAndDataTypePair {
	s.DataType = v
	return s
}

// SetFieldName sets the FieldName field's value.
func (s *StructuredMessageFieldNameAndDataTypePair) SetFieldName(v string) *StructuredMessageFieldNameAndDataTypePair {
	s.FieldName = &v
	return s
}

// Represents a list type node of the complex data structure.
type StructuredMessageListDefinition struct {
	_ struct{} `type:"structure"`

	// The capacity of the structured message list definition when the list type
	// is FIXED_CAPACITY or DYNAMIC_BOUNDED_CAPACITY.
	Capacity *int64 `locationName:"capacity" type:"integer"`

	// The type of list of the structured message list definition.
	//
	// ListType is a required field
	ListType *string `locationName:"listType" type:"string" required:"true" enum:"StructuredMessageListType"`

	// The member type of the structured message list definition.
	//
	// MemberType is a required field
	MemberType *StructuredMessage `locationName:"memberType" type:"structure" required:"true"`

	// The name of the structured message list definition.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StructuredMessageListDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StructuredMessageListDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StructuredMessageListDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StructuredMessageListDefinition"}
	if s.ListType == nil {
		invalidParams.Add(request.NewErrParamRequired("ListType"))
	}
	if s.MemberType == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.MemberType != nil {
		if err := s.MemberType.Validate(); err != nil {
			invalidParams.AddNested("MemberType", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacity sets the Capacity field's value.
func (s *StructuredMessageListDefinition) SetCapacity(v int64) *StructuredMessageListDefinition {
	s.Capacity = &v
	return s
}

// SetListType sets the ListType field's value.
func (s *StructuredMessageListDefinition) SetListType(v string) *StructuredMessageListDefinition {
	s.ListType = &v
	return s
}

// SetMemberType sets the MemberType field's value.
func (s *StructuredMessageListDefinition) SetMemberType(v *StructuredMessage) *StructuredMessageListDefinition {
	s.MemberType = v
	return s
}

// SetName sets the Name field's value.
func (s *StructuredMessageListDefinition) SetName(v string) *StructuredMessageListDefinition {
	s.Name = &v
	return s
}

// A set of key/value pairs that are used to manage the resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag's key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The tag's value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The new or modified tags for the resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request couldn't be completed due to throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The quota identifier of the applied throttling rules for this request.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// The number of seconds to wait before retrying the command.
	RetryAfterSeconds *int64 `locationName:"retryAfterSeconds" type:"integer"`

	// The code for the service that couldn't be completed due to throttling.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a collection scheme that uses a time period to decide how
// often to collect data.
type TimeBasedCollectionScheme struct {
	_ struct{} `type:"structure"`

	// The time period (in milliseconds) to decide how often to collect data. For
	// example, if the time period is 60000, the Edge Agent software collects data
	// once every minute.
	//
	// PeriodMs is a required field
	PeriodMs *int64 `locationName:"periodMs" min:"10000" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeBasedCollectionScheme) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeBasedCollectionScheme) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimeBasedCollectionScheme) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimeBasedCollectionScheme"}
	if s.PeriodMs == nil {
		invalidParams.Add(request.NewErrParamRequired("PeriodMs"))
	}
	if s.PeriodMs != nil && *s.PeriodMs < 10000 {
		invalidParams.Add(request.NewErrParamMinValue("PeriodMs", 10000))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPeriodMs sets the PeriodMs field's value.
func (s *TimeBasedCollectionScheme) SetPeriodMs(v int64) *TimeBasedCollectionScheme {
	s.PeriodMs = &v
	return s
}

// The Amazon Timestream table where the Amazon Web Services IoT FleetWise campaign
// sends data. Timestream stores and organizes data to optimize query processing
// time and to reduce storage costs. For more information, see Data modeling
// (https://docs.aws.amazon.com/timestream/latest/developerguide/data-modeling.html)
// in the Amazon Timestream Developer Guide.
type TimestreamConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the task execution role that grants Amazon
	// Web Services IoT FleetWise permission to deliver data to the Amazon Timestream
	// table.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `locationName:"executionRoleArn" min:"20" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Timestream table.
	//
	// TimestreamTableArn is a required field
	TimestreamTableArn *string `locationName:"timestreamTableArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimestreamConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimestreamConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimestreamConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimestreamConfig"}
	if s.ExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionRoleArn"))
	}
	if s.ExecutionRoleArn != nil && len(*s.ExecutionRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionRoleArn", 20))
	}
	if s.TimestreamTableArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TimestreamTableArn"))
	}
	if s.TimestreamTableArn != nil && len(*s.TimestreamTableArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("TimestreamTableArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *TimestreamConfig) SetExecutionRoleArn(v string) *TimestreamConfig {
	s.ExecutionRoleArn = &v
	return s
}

// SetTimestreamTableArn sets the TimestreamTableArn field's value.
func (s *TimestreamConfig) SetTimestreamTableArn(v string) *TimestreamConfig {
	s.TimestreamTableArn = &v
	return s
}

// Information about the registered Amazon Timestream resources or errors, if
// any.
type TimestreamRegistrationResponse struct {
	_ struct{} `type:"structure"`

	// A message associated with a registration error.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The status of registering your Amazon Timestream resources. The status can
	// be one of REGISTRATION_SUCCESS, REGISTRATION_PENDING, REGISTRATION_FAILURE.
	//
	// RegistrationStatus is a required field
	RegistrationStatus *string `locationName:"registrationStatus" type:"string" required:"true" enum:"RegistrationStatus"`

	// The Amazon Resource Name (ARN) of the Timestream database.
	TimestreamDatabaseArn *string `locationName:"timestreamDatabaseArn" type:"string"`

	// The name of the Timestream database.
	//
	// TimestreamDatabaseName is a required field
	TimestreamDatabaseName *string `locationName:"timestreamDatabaseName" min:"3" type:"string" required:"true"`

	// The ARN of the Timestream database table.
	TimestreamTableArn *string `locationName:"timestreamTableArn" type:"string"`

	// The name of the Timestream database table.
	//
	// TimestreamTableName is a required field
	TimestreamTableName *string `locationName:"timestreamTableName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimestreamRegistrationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimestreamRegistrationResponse) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *TimestreamRegistrationResponse) SetErrorMessage(v string) *TimestreamRegistrationResponse {
	s.ErrorMessage = &v
	return s
}

// SetRegistrationStatus sets the RegistrationStatus field's value.
func (s *TimestreamRegistrationResponse) SetRegistrationStatus(v string) *TimestreamRegistrationResponse {
	s.RegistrationStatus = &v
	return s
}

// SetTimestreamDatabaseArn sets the TimestreamDatabaseArn field's value.
func (s *TimestreamRegistrationResponse) SetTimestreamDatabaseArn(v string) *TimestreamRegistrationResponse {
	s.TimestreamDatabaseArn = &v
	return s
}

// SetTimestreamDatabaseName sets the TimestreamDatabaseName field's value.
func (s *TimestreamRegistrationResponse) SetTimestreamDatabaseName(v string) *TimestreamRegistrationResponse {
	s.TimestreamDatabaseName = &v
	return s
}

// SetTimestreamTableArn sets the TimestreamTableArn field's value.
func (s *TimestreamRegistrationResponse) SetTimestreamTableArn(v string) *TimestreamRegistrationResponse {
	s.TimestreamTableArn = &v
	return s
}

// SetTimestreamTableName sets the TimestreamTableName field's value.
func (s *TimestreamRegistrationResponse) SetTimestreamTableName(v string) *TimestreamRegistrationResponse {
	s.TimestreamTableName = &v
	return s
}

// The registered Amazon Timestream resources that Amazon Web Services IoT FleetWise
// edge agent software can transfer your vehicle data to.
type TimestreamResources struct {
	_ struct{} `type:"structure"`

	// The name of the registered Amazon Timestream database.
	//
	// TimestreamDatabaseName is a required field
	TimestreamDatabaseName *string `locationName:"timestreamDatabaseName" min:"3" type:"string" required:"true"`

	// The name of the registered Amazon Timestream database table.
	//
	// TimestreamTableName is a required field
	TimestreamTableName *string `locationName:"timestreamTableName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimestreamResources) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimestreamResources) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimestreamResources) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimestreamResources"}
	if s.TimestreamDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("TimestreamDatabaseName"))
	}
	if s.TimestreamDatabaseName != nil && len(*s.TimestreamDatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TimestreamDatabaseName", 3))
	}
	if s.TimestreamTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TimestreamTableName"))
	}
	if s.TimestreamTableName != nil && len(*s.TimestreamTableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TimestreamTableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTimestreamDatabaseName sets the TimestreamDatabaseName field's value.
func (s *TimestreamResources) SetTimestreamDatabaseName(v string) *TimestreamResources {
	s.TimestreamDatabaseName = &v
	return s
}

// SetTimestreamTableName sets the TimestreamTableName field's value.
func (s *TimestreamResources) SetTimestreamTableName(v string) *TimestreamResources {
	s.TimestreamTableName = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// A list of the keys of the tags to be removed from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateCampaignInput struct {
	_ struct{} `type:"structure"`

	// Specifies how to update a campaign. The action can be one of the following:
	//
	//    * APPROVE - To approve delivering a data collection scheme to vehicles.
	//
	//    * SUSPEND - To suspend collecting signal data. The campaign is deleted
	//    from vehicles and all vehicles in the suspended campaign will stop sending
	//    data.
	//
	//    * RESUME - To reactivate the SUSPEND campaign. The campaign is redeployed
	//    to all vehicles and the vehicles will resume sending data.
	//
	//    * UPDATE - To update a campaign.
	//
	// Action is a required field
	Action *string `locationName:"action" type:"string" required:"true" enum:"UpdateCampaignAction"`

	// A list of vehicle attributes to associate with a signal.
	//
	// Default: An empty array
	DataExtraDimensions []*string `locationName:"dataExtraDimensions" type:"list"`

	// The description of the campaign.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the campaign to update.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCampaignInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *UpdateCampaignInput) SetAction(v string) *UpdateCampaignInput {
	s.Action = &v
	return s
}

// SetDataExtraDimensions sets the DataExtraDimensions field's value.
func (s *UpdateCampaignInput) SetDataExtraDimensions(v []*string) *UpdateCampaignInput {
	s.DataExtraDimensions = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateCampaignInput) SetDescription(v string) *UpdateCampaignInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateCampaignInput) SetName(v string) *UpdateCampaignInput {
	s.Name = &v
	return s
}

type UpdateCampaignOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign.
	Arn *string `locationName:"arn" type:"string"`

	// The name of the updated campaign.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The state of a campaign. The status can be one of:
	//
	//    * CREATING - Amazon Web Services IoT FleetWise is processing your request
	//    to create the campaign.
	//
	//    * WAITING_FOR_APPROVAL - After a campaign is created, it enters the WAITING_FOR_APPROVAL
	//    state. To allow Amazon Web Services IoT FleetWise to deploy the campaign
	//    to the target vehicle or fleet, use the API operation to approve the campaign.
	//
	//    * RUNNING - The campaign is active.
	//
	//    * SUSPENDED - The campaign is suspended. To resume the campaign, use the
	//    API operation.
	Status *string `locationName:"status" type:"string" enum:"CampaignStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCampaignOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateCampaignOutput) SetArn(v string) *UpdateCampaignOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateCampaignOutput) SetName(v string) *UpdateCampaignOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateCampaignOutput) SetStatus(v string) *UpdateCampaignOutput {
	s.Status = &v
	return s
}

type UpdateDecoderManifestInput struct {
	_ struct{} `type:"structure"`

	// A brief description of the decoder manifest to update.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the decoder manifest to update.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A list of information about the network interfaces to add to the decoder
	// manifest.
	NetworkInterfacesToAdd []*NetworkInterface `locationName:"networkInterfacesToAdd" min:"1" type:"list"`

	// A list of network interfaces to remove from the decoder manifest.
	NetworkInterfacesToRemove []*string `locationName:"networkInterfacesToRemove" min:"1" type:"list"`

	// A list of information about the network interfaces to update in the decoder
	// manifest.
	NetworkInterfacesToUpdate []*NetworkInterface `locationName:"networkInterfacesToUpdate" min:"1" type:"list"`

	// A list of information about decoding additional signals to add to the decoder
	// manifest.
	SignalDecodersToAdd []*SignalDecoder `locationName:"signalDecodersToAdd" min:"1" type:"list"`

	// A list of signal decoders to remove from the decoder manifest.
	SignalDecodersToRemove []*string `locationName:"signalDecodersToRemove" min:"1" type:"list"`

	// A list of updated information about decoding signals to update in the decoder
	// manifest.
	SignalDecodersToUpdate []*SignalDecoder `locationName:"signalDecodersToUpdate" min:"1" type:"list"`

	// The state of the decoder manifest. If the status is ACTIVE, the decoder manifest
	// can't be edited. If the status is DRAFT, you can edit the decoder manifest.
	Status *string `locationName:"status" type:"string" enum:"ManifestStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDecoderManifestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDecoderManifestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDecoderManifestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDecoderManifestInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NetworkInterfacesToAdd != nil && len(s.NetworkInterfacesToAdd) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkInterfacesToAdd", 1))
	}
	if s.NetworkInterfacesToRemove != nil && len(s.NetworkInterfacesToRemove) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkInterfacesToRemove", 1))
	}
	if s.NetworkInterfacesToUpdate != nil && len(s.NetworkInterfacesToUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkInterfacesToUpdate", 1))
	}
	if s.SignalDecodersToAdd != nil && len(s.SignalDecodersToAdd) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SignalDecodersToAdd", 1))
	}
	if s.SignalDecodersToRemove != nil && len(s.SignalDecodersToRemove) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SignalDecodersToRemove", 1))
	}
	if s.SignalDecodersToUpdate != nil && len(s.SignalDecodersToUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SignalDecodersToUpdate", 1))
	}
	if s.NetworkInterfacesToAdd != nil {
		for i, v := range s.NetworkInterfacesToAdd {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NetworkInterfacesToAdd", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.NetworkInterfacesToUpdate != nil {
		for i, v := range s.NetworkInterfacesToUpdate {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NetworkInterfacesToUpdate", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SignalDecodersToAdd != nil {
		for i, v := range s.SignalDecodersToAdd {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SignalDecodersToAdd", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SignalDecodersToUpdate != nil {
		for i, v := range s.SignalDecodersToUpdate {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SignalDecodersToUpdate", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateDecoderManifestInput) SetDescription(v string) *UpdateDecoderManifestInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDecoderManifestInput) SetName(v string) *UpdateDecoderManifestInput {
	s.Name = &v
	return s
}

// SetNetworkInterfacesToAdd sets the NetworkInterfacesToAdd field's value.
func (s *UpdateDecoderManifestInput) SetNetworkInterfacesToAdd(v []*NetworkInterface) *UpdateDecoderManifestInput {
	s.NetworkInterfacesToAdd = v
	return s
}

// SetNetworkInterfacesToRemove sets the NetworkInterfacesToRemove field's value.
func (s *UpdateDecoderManifestInput) SetNetworkInterfacesToRemove(v []*string) *UpdateDecoderManifestInput {
	s.NetworkInterfacesToRemove = v
	return s
}

// SetNetworkInterfacesToUpdate sets the NetworkInterfacesToUpdate field's value.
func (s *UpdateDecoderManifestInput) SetNetworkInterfacesToUpdate(v []*NetworkInterface) *UpdateDecoderManifestInput {
	s.NetworkInterfacesToUpdate = v
	return s
}

// SetSignalDecodersToAdd sets the SignalDecodersToAdd field's value.
func (s *UpdateDecoderManifestInput) SetSignalDecodersToAdd(v []*SignalDecoder) *UpdateDecoderManifestInput {
	s.SignalDecodersToAdd = v
	return s
}

// SetSignalDecodersToRemove sets the SignalDecodersToRemove field's value.
func (s *UpdateDecoderManifestInput) SetSignalDecodersToRemove(v []*string) *UpdateDecoderManifestInput {
	s.SignalDecodersToRemove = v
	return s
}

// SetSignalDecodersToUpdate sets the SignalDecodersToUpdate field's value.
func (s *UpdateDecoderManifestInput) SetSignalDecodersToUpdate(v []*SignalDecoder) *UpdateDecoderManifestInput {
	s.SignalDecodersToUpdate = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateDecoderManifestInput) SetStatus(v string) *UpdateDecoderManifestInput {
	s.Status = &v
	return s
}

type UpdateDecoderManifestOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the updated decoder manifest.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the updated decoder manifest.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDecoderManifestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDecoderManifestOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateDecoderManifestOutput) SetArn(v string) *UpdateDecoderManifestOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDecoderManifestOutput) SetName(v string) *UpdateDecoderManifestOutput {
	s.Name = &v
	return s
}

type UpdateFleetInput struct {
	_ struct{} `type:"structure"`

	// An updated description of the fleet.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The ID of the fleet to update.
	//
	// FleetId is a required field
	FleetId *string `locationName:"fleetId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFleetInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateFleetInput) SetDescription(v string) *UpdateFleetInput {
	s.Description = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *UpdateFleetInput) SetFleetId(v string) *UpdateFleetInput {
	s.FleetId = &v
	return s
}

type UpdateFleetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the updated fleet.
	Arn *string `locationName:"arn" type:"string"`

	// The ID of the updated fleet.
	Id *string `locationName:"id" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFleetOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateFleetOutput) SetArn(v string) *UpdateFleetOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateFleetOutput) SetId(v string) *UpdateFleetOutput {
	s.Id = &v
	return s
}

type UpdateModelManifestInput struct {
	_ struct{} `type:"structure"`

	// A brief description of the vehicle model.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the vehicle model to update.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A list of fullyQualifiedName of nodes, which are a general abstraction of
	// signals, to add to the vehicle model.
	NodesToAdd []*string `locationName:"nodesToAdd" min:"1" type:"list"`

	// A list of fullyQualifiedName of nodes, which are a general abstraction of
	// signals, to remove from the vehicle model.
	NodesToRemove []*string `locationName:"nodesToRemove" min:"1" type:"list"`

	// The state of the vehicle model. If the status is ACTIVE, the vehicle model
	// can't be edited. If the status is DRAFT, you can edit the vehicle model.
	Status *string `locationName:"status" type:"string" enum:"ManifestStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateModelManifestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateModelManifestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateModelManifestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateModelManifestInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NodesToAdd != nil && len(s.NodesToAdd) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodesToAdd", 1))
	}
	if s.NodesToRemove != nil && len(s.NodesToRemove) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodesToRemove", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateModelManifestInput) SetDescription(v string) *UpdateModelManifestInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateModelManifestInput) SetName(v string) *UpdateModelManifestInput {
	s.Name = &v
	return s
}

// SetNodesToAdd sets the NodesToAdd field's value.
func (s *UpdateModelManifestInput) SetNodesToAdd(v []*string) *UpdateModelManifestInput {
	s.NodesToAdd = v
	return s
}

// SetNodesToRemove sets the NodesToRemove field's value.
func (s *UpdateModelManifestInput) SetNodesToRemove(v []*string) *UpdateModelManifestInput {
	s.NodesToRemove = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateModelManifestInput) SetStatus(v string) *UpdateModelManifestInput {
	s.Status = &v
	return s
}

type UpdateModelManifestOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the updated vehicle model.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the updated vehicle model.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateModelManifestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateModelManifestOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateModelManifestOutput) SetArn(v string) *UpdateModelManifestOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateModelManifestOutput) SetName(v string) *UpdateModelManifestOutput {
	s.Name = &v
	return s
}

type UpdateSignalCatalogInput struct {
	_ struct{} `type:"structure"`

	// A brief description of the signal catalog to update.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the signal catalog to update.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A list of information about nodes to add to the signal catalog.
	NodesToAdd []*Node `locationName:"nodesToAdd" type:"list"`

	// A list of fullyQualifiedName of nodes to remove from the signal catalog.
	NodesToRemove []*string `locationName:"nodesToRemove" min:"1" type:"list"`

	// A list of information about nodes to update in the signal catalog.
	NodesToUpdate []*Node `locationName:"nodesToUpdate" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSignalCatalogInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSignalCatalogInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSignalCatalogInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSignalCatalogInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NodesToRemove != nil && len(s.NodesToRemove) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodesToRemove", 1))
	}
	if s.NodesToAdd != nil {
		for i, v := range s.NodesToAdd {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NodesToAdd", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.NodesToUpdate != nil {
		for i, v := range s.NodesToUpdate {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NodesToUpdate", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateSignalCatalogInput) SetDescription(v string) *UpdateSignalCatalogInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateSignalCatalogInput) SetName(v string) *UpdateSignalCatalogInput {
	s.Name = &v
	return s
}

// SetNodesToAdd sets the NodesToAdd field's value.
func (s *UpdateSignalCatalogInput) SetNodesToAdd(v []*Node) *UpdateSignalCatalogInput {
	s.NodesToAdd = v
	return s
}

// SetNodesToRemove sets the NodesToRemove field's value.
func (s *UpdateSignalCatalogInput) SetNodesToRemove(v []*string) *UpdateSignalCatalogInput {
	s.NodesToRemove = v
	return s
}

// SetNodesToUpdate sets the NodesToUpdate field's value.
func (s *UpdateSignalCatalogInput) SetNodesToUpdate(v []*Node) *UpdateSignalCatalogInput {
	s.NodesToUpdate = v
	return s
}

type UpdateSignalCatalogOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the updated signal catalog.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the updated signal catalog.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSignalCatalogOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSignalCatalogOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateSignalCatalogOutput) SetArn(v string) *UpdateSignalCatalogOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateSignalCatalogOutput) SetName(v string) *UpdateSignalCatalogOutput {
	s.Name = &v
	return s
}

// An HTTP error resulting from updating the description for a vehicle.
type UpdateVehicleError struct {
	_ struct{} `type:"structure"`

	// The relevant HTTP error code (400+).
	Code *int64 `locationName:"code" type:"integer"`

	// A message associated with the error.
	Message *string `locationName:"message" type:"string"`

	// The ID of the vehicle with the error.
	VehicleName *string `locationName:"vehicleName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVehicleError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVehicleError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *UpdateVehicleError) SetCode(v int64) *UpdateVehicleError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *UpdateVehicleError) SetMessage(v string) *UpdateVehicleError {
	s.Message = &v
	return s
}

// SetVehicleName sets the VehicleName field's value.
func (s *UpdateVehicleError) SetVehicleName(v string) *UpdateVehicleError {
	s.VehicleName = &v
	return s
}

type UpdateVehicleInput struct {
	_ struct{} `type:"structure"`

	// The method the specified attributes will update the existing attributes on
	// the vehicle. UseOverwite to replace the vehicle attributes with the specified
	// attributes. Or use Merge to combine all attributes.
	//
	// This is required if attributes are present in the input.
	AttributeUpdateMode *string `locationName:"attributeUpdateMode" type:"string" enum:"UpdateMode"`

	// Static information about a vehicle in a key-value pair. For example:
	//
	// "engineType" : "1.3 L R2"
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// The ARN of the decoder manifest associated with this vehicle.
	DecoderManifestArn *string `locationName:"decoderManifestArn" type:"string"`

	// The ARN of a vehicle model (model manifest) associated with the vehicle.
	ModelManifestArn *string `locationName:"modelManifestArn" type:"string"`

	// The unique ID of the vehicle to update.
	//
	// VehicleName is a required field
	VehicleName *string `locationName:"vehicleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVehicleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVehicleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVehicleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVehicleInput"}
	if s.VehicleName == nil {
		invalidParams.Add(request.NewErrParamRequired("VehicleName"))
	}
	if s.VehicleName != nil && len(*s.VehicleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VehicleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeUpdateMode sets the AttributeUpdateMode field's value.
func (s *UpdateVehicleInput) SetAttributeUpdateMode(v string) *UpdateVehicleInput {
	s.AttributeUpdateMode = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *UpdateVehicleInput) SetAttributes(v map[string]*string) *UpdateVehicleInput {
	s.Attributes = v
	return s
}

// SetDecoderManifestArn sets the DecoderManifestArn field's value.
func (s *UpdateVehicleInput) SetDecoderManifestArn(v string) *UpdateVehicleInput {
	s.DecoderManifestArn = &v
	return s
}

// SetModelManifestArn sets the ModelManifestArn field's value.
func (s *UpdateVehicleInput) SetModelManifestArn(v string) *UpdateVehicleInput {
	s.ModelManifestArn = &v
	return s
}

// SetVehicleName sets the VehicleName field's value.
func (s *UpdateVehicleInput) SetVehicleName(v string) *UpdateVehicleInput {
	s.VehicleName = &v
	return s
}

type UpdateVehicleOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the updated vehicle.
	Arn *string `locationName:"arn" type:"string"`

	// The ID of the updated vehicle.
	VehicleName *string `locationName:"vehicleName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVehicleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVehicleOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateVehicleOutput) SetArn(v string) *UpdateVehicleOutput {
	s.Arn = &v
	return s
}

// SetVehicleName sets the VehicleName field's value.
func (s *UpdateVehicleOutput) SetVehicleName(v string) *UpdateVehicleOutput {
	s.VehicleName = &v
	return s
}

// Information about the vehicle to update.
type UpdateVehicleRequestItem struct {
	_ struct{} `type:"structure"`

	// The method the specified attributes will update the existing attributes on
	// the vehicle. UseOverwite to replace the vehicle attributes with the specified
	// attributes. Or use Merge to combine all attributes.
	//
	// This is required if attributes are present in the input.
	AttributeUpdateMode *string `locationName:"attributeUpdateMode" type:"string" enum:"UpdateMode"`

	// Static information about a vehicle in a key-value pair. For example:
	//
	// "engineType" : "1.3 L R2"
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// The ARN of the signal decoder manifest associated with the vehicle to update.
	DecoderManifestArn *string `locationName:"decoderManifestArn" type:"string"`

	// The ARN of the vehicle model (model manifest) associated with the vehicle
	// to update.
	ModelManifestArn *string `locationName:"modelManifestArn" type:"string"`

	// The unique ID of the vehicle to update.
	//
	// VehicleName is a required field
	VehicleName *string `locationName:"vehicleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVehicleRequestItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVehicleRequestItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVehicleRequestItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVehicleRequestItem"}
	if s.VehicleName == nil {
		invalidParams.Add(request.NewErrParamRequired("VehicleName"))
	}
	if s.VehicleName != nil && len(*s.VehicleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VehicleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeUpdateMode sets the AttributeUpdateMode field's value.
func (s *UpdateVehicleRequestItem) SetAttributeUpdateMode(v string) *UpdateVehicleRequestItem {
	s.AttributeUpdateMode = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *UpdateVehicleRequestItem) SetAttributes(v map[string]*string) *UpdateVehicleRequestItem {
	s.Attributes = v
	return s
}

// SetDecoderManifestArn sets the DecoderManifestArn field's value.
func (s *UpdateVehicleRequestItem) SetDecoderManifestArn(v string) *UpdateVehicleRequestItem {
	s.DecoderManifestArn = &v
	return s
}

// SetModelManifestArn sets the ModelManifestArn field's value.
func (s *UpdateVehicleRequestItem) SetModelManifestArn(v string) *UpdateVehicleRequestItem {
	s.ModelManifestArn = &v
	return s
}

// SetVehicleName sets the VehicleName field's value.
func (s *UpdateVehicleRequestItem) SetVehicleName(v string) *UpdateVehicleRequestItem {
	s.VehicleName = &v
	return s
}

// Information about the updated vehicle.
type UpdateVehicleResponseItem struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the updated vehicle.
	Arn *string `locationName:"arn" type:"string"`

	// The unique ID of the updated vehicle.
	VehicleName *string `locationName:"vehicleName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVehicleResponseItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVehicleResponseItem) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateVehicleResponseItem) SetArn(v string) *UpdateVehicleResponseItem {
	s.Arn = &v
	return s
}

// SetVehicleName sets the VehicleName field's value.
func (s *UpdateVehicleResponseItem) SetVehicleName(v string) *UpdateVehicleResponseItem {
	s.VehicleName = &v
	return s
}

// The input fails to satisfy the constraints specified by an Amazon Web Services
// service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The list of fields that fail to satisfy the constraints specified by an Amazon
	// Web Services service.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// The reason the input failed to satisfy the constraints specified by an Amazon
	// Web Services service.
	Reason *string `locationName:"reason" type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A validation error due to mismatch between the expected data type, length,
// or pattern of the parameter and the input.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// A message about the validation error.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name of the parameter field with the validation error.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

// The vehicle middleware defined as a type of network interface. Examples of
// vehicle middleware include ROS2 and SOME/IP.
type VehicleMiddleware struct {
	_ struct{} `type:"structure"`

	// The name of the vehicle middleware.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The protocol name of the vehicle middleware.
	//
	// ProtocolName is a required field
	ProtocolName *string `locationName:"protocolName" type:"string" required:"true" enum:"VehicleMiddlewareProtocol"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VehicleMiddleware) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VehicleMiddleware) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VehicleMiddleware) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VehicleMiddleware"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ProtocolName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProtocolName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *VehicleMiddleware) SetName(v string) *VehicleMiddleware {
	s.Name = &v
	return s
}

// SetProtocolName sets the ProtocolName field's value.
func (s *VehicleMiddleware) SetProtocolName(v string) *VehicleMiddleware {
	s.ProtocolName = &v
	return s
}

// Information about the state of a vehicle and how it relates to the status
// of a campaign.
type VehicleStatus struct {
	_ struct{} `type:"structure"`

	// The name of a campaign.
	CampaignName *string `locationName:"campaignName" type:"string"`

	// The state of a vehicle, which can be one of the following:
	//
	//    * CREATED - Amazon Web Services IoT FleetWise sucessfully created the
	//    vehicle.
	//
	//    * READY - The vehicle is ready to receive a campaign deployment.
	//
	//    * HEALTHY - A campaign deployment was delivered to the vehicle.
	//
	//    * SUSPENDED - A campaign associated with the vehicle was suspended and
	//    data collection was paused.
	//
	//    * DELETING - Amazon Web Services IoT FleetWise is removing a campaign
	//    from the vehicle.
	Status *string `locationName:"status" type:"string" enum:"VehicleState"`

	// The unique ID of the vehicle.
	VehicleName *string `locationName:"vehicleName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VehicleStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VehicleStatus) GoString() string {
	return s.String()
}

// SetCampaignName sets the CampaignName field's value.
func (s *VehicleStatus) SetCampaignName(v string) *VehicleStatus {
	s.CampaignName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *VehicleStatus) SetStatus(v string) *VehicleStatus {
	s.Status = &v
	return s
}

// SetVehicleName sets the VehicleName field's value.
func (s *VehicleStatus) SetVehicleName(v string) *VehicleStatus {
	s.VehicleName = &v
	return s
}

// Information about a vehicle.
//
// To return this information about vehicles in your account, you can use the
// API operation.
type VehicleSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the vehicle.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// Static information about a vehicle in a key-value pair. For example:
	//
	// "engineType" : "1.3 L R2"
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// The time the vehicle was created in seconds since epoch (January 1, 1970
	// at midnight UTC time).
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// The ARN of a decoder manifest associated with the vehicle.
	//
	// DecoderManifestArn is a required field
	DecoderManifestArn *string `locationName:"decoderManifestArn" type:"string" required:"true"`

	// The time the vehicle was last updated in seconds since epoch (January 1,
	// 1970 at midnight UTC time).
	//
	// LastModificationTime is a required field
	LastModificationTime *time.Time `locationName:"lastModificationTime" type:"timestamp" required:"true"`

	// The ARN of a vehicle model (model manifest) associated with the vehicle.
	//
	// ModelManifestArn is a required field
	ModelManifestArn *string `locationName:"modelManifestArn" type:"string" required:"true"`

	// The unique ID of the vehicle.
	//
	// VehicleName is a required field
	VehicleName *string `locationName:"vehicleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VehicleSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VehicleSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *VehicleSummary) SetArn(v string) *VehicleSummary {
	s.Arn = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *VehicleSummary) SetAttributes(v map[string]*string) *VehicleSummary {
	s.Attributes = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *VehicleSummary) SetCreationTime(v time.Time) *VehicleSummary {
	s.CreationTime = &v
	return s
}

// SetDecoderManifestArn sets the DecoderManifestArn field's value.
func (s *VehicleSummary) SetDecoderManifestArn(v string) *VehicleSummary {
	s.DecoderManifestArn = &v
	return s
}

// SetLastModificationTime sets the LastModificationTime field's value.
func (s *VehicleSummary) SetLastModificationTime(v time.Time) *VehicleSummary {
	s.LastModificationTime = &v
	return s
}

// SetModelManifestArn sets the ModelManifestArn field's value.
func (s *VehicleSummary) SetModelManifestArn(v string) *VehicleSummary {
	s.ModelManifestArn = &v
	return s
}

// SetVehicleName sets the VehicleName field's value.
func (s *VehicleSummary) SetVehicleName(v string) *VehicleSummary {
	s.VehicleName = &v
	return s
}

const (
	// CampaignStatusCreating is a CampaignStatus enum value
	CampaignStatusCreating = "CREATING"

	// CampaignStatusWaitingForApproval is a CampaignStatus enum value
	CampaignStatusWaitingForApproval = "WAITING_FOR_APPROVAL"

	// CampaignStatusRunning is a CampaignStatus enum value
	CampaignStatusRunning = "RUNNING"

	// CampaignStatusSuspended is a CampaignStatus enum value
	CampaignStatusSuspended = "SUSPENDED"
)

// CampaignStatus_Values returns all elements of the CampaignStatus enum
func CampaignStatus_Values() []string {
	return []string{
		CampaignStatusCreating,
		CampaignStatusWaitingForApproval,
		CampaignStatusRunning,
		CampaignStatusSuspended,
	}
}

const (
	// CompressionOff is a Compression enum value
	CompressionOff = "OFF"

	// CompressionSnappy is a Compression enum value
	CompressionSnappy = "SNAPPY"
)

// Compression_Values returns all elements of the Compression enum
func Compression_Values() []string {
	return []string{
		CompressionOff,
		CompressionSnappy,
	}
}

const (
	// DataFormatJson is a DataFormat enum value
	DataFormatJson = "JSON"

	// DataFormatParquet is a DataFormat enum value
	DataFormatParquet = "PARQUET"
)

// DataFormat_Values returns all elements of the DataFormat enum
func DataFormat_Values() []string {
	return []string{
		DataFormatJson,
		DataFormatParquet,
	}
}

const (
	// DiagnosticsModeOff is a DiagnosticsMode enum value
	DiagnosticsModeOff = "OFF"

	// DiagnosticsModeSendActiveDtcs is a DiagnosticsMode enum value
	DiagnosticsModeSendActiveDtcs = "SEND_ACTIVE_DTCS"
)

// DiagnosticsMode_Values returns all elements of the DiagnosticsMode enum
func DiagnosticsMode_Values() []string {
	return []string{
		DiagnosticsModeOff,
		DiagnosticsModeSendActiveDtcs,
	}
}

const (
	// EncryptionStatusPending is a EncryptionStatus enum value
	EncryptionStatusPending = "PENDING"

	// EncryptionStatusSuccess is a EncryptionStatus enum value
	EncryptionStatusSuccess = "SUCCESS"

	// EncryptionStatusFailure is a EncryptionStatus enum value
	EncryptionStatusFailure = "FAILURE"
)

// EncryptionStatus_Values returns all elements of the EncryptionStatus enum
func EncryptionStatus_Values() []string {
	return []string{
		EncryptionStatusPending,
		EncryptionStatusSuccess,
		EncryptionStatusFailure,
	}
}

const (
	// EncryptionTypeKmsBasedEncryption is a EncryptionType enum value
	EncryptionTypeKmsBasedEncryption = "KMS_BASED_ENCRYPTION"

	// EncryptionTypeFleetwiseDefaultEncryption is a EncryptionType enum value
	EncryptionTypeFleetwiseDefaultEncryption = "FLEETWISE_DEFAULT_ENCRYPTION"
)

// EncryptionType_Values returns all elements of the EncryptionType enum
func EncryptionType_Values() []string {
	return []string{
		EncryptionTypeKmsBasedEncryption,
		EncryptionTypeFleetwiseDefaultEncryption,
	}
}

const (
	// LogTypeOff is a LogType enum value
	LogTypeOff = "OFF"

	// LogTypeError is a LogType enum value
	LogTypeError = "ERROR"
)

// LogType_Values returns all elements of the LogType enum
func LogType_Values() []string {
	return []string{
		LogTypeOff,
		LogTypeError,
	}
}

const (
	// ManifestStatusActive is a ManifestStatus enum value
	ManifestStatusActive = "ACTIVE"

	// ManifestStatusDraft is a ManifestStatus enum value
	ManifestStatusDraft = "DRAFT"

	// ManifestStatusInvalid is a ManifestStatus enum value
	ManifestStatusInvalid = "INVALID"

	// ManifestStatusValidating is a ManifestStatus enum value
	ManifestStatusValidating = "VALIDATING"
)

// ManifestStatus_Values returns all elements of the ManifestStatus enum
func ManifestStatus_Values() []string {
	return []string{
		ManifestStatusActive,
		ManifestStatusDraft,
		ManifestStatusInvalid,
		ManifestStatusValidating,
	}
}

const (
	// NetworkInterfaceFailureReasonDuplicateNetworkInterface is a NetworkInterfaceFailureReason enum value
	NetworkInterfaceFailureReasonDuplicateNetworkInterface = "DUPLICATE_NETWORK_INTERFACE"

	// NetworkInterfaceFailureReasonConflictingNetworkInterface is a NetworkInterfaceFailureReason enum value
	NetworkInterfaceFailureReasonConflictingNetworkInterface = "CONFLICTING_NETWORK_INTERFACE"

	// NetworkInterfaceFailureReasonNetworkInterfaceToAddAlreadyExists is a NetworkInterfaceFailureReason enum value
	NetworkInterfaceFailureReasonNetworkInterfaceToAddAlreadyExists = "NETWORK_INTERFACE_TO_ADD_ALREADY_EXISTS"

	// NetworkInterfaceFailureReasonCanNetworkInterfaceInfoIsNull is a NetworkInterfaceFailureReason enum value
	NetworkInterfaceFailureReasonCanNetworkInterfaceInfoIsNull = "CAN_NETWORK_INTERFACE_INFO_IS_NULL"

	// NetworkInterfaceFailureReasonObdNetworkInterfaceInfoIsNull is a NetworkInterfaceFailureReason enum value
	NetworkInterfaceFailureReasonObdNetworkInterfaceInfoIsNull = "OBD_NETWORK_INTERFACE_INFO_IS_NULL"

	// NetworkInterfaceFailureReasonNetworkInterfaceToRemoveAssociatedWithSignals is a NetworkInterfaceFailureReason enum value
	NetworkInterfaceFailureReasonNetworkInterfaceToRemoveAssociatedWithSignals = "NETWORK_INTERFACE_TO_REMOVE_ASSOCIATED_WITH_SIGNALS"

	// NetworkInterfaceFailureReasonVehicleMiddlewareNetworkInterfaceInfoIsNull is a NetworkInterfaceFailureReason enum value
	NetworkInterfaceFailureReasonVehicleMiddlewareNetworkInterfaceInfoIsNull = "VEHICLE_MIDDLEWARE_NETWORK_INTERFACE_INFO_IS_NULL"
)

// NetworkInterfaceFailureReason_Values returns all elements of the NetworkInterfaceFailureReason enum
func NetworkInterfaceFailureReason_Values() []string {
	return []string{
		NetworkInterfaceFailureReasonDuplicateNetworkInterface,
		NetworkInterfaceFailureReasonConflictingNetworkInterface,
		NetworkInterfaceFailureReasonNetworkInterfaceToAddAlreadyExists,
		NetworkInterfaceFailureReasonCanNetworkInterfaceInfoIsNull,
		NetworkInterfaceFailureReasonObdNetworkInterfaceInfoIsNull,
		NetworkInterfaceFailureReasonNetworkInterfaceToRemoveAssociatedWithSignals,
		NetworkInterfaceFailureReasonVehicleMiddlewareNetworkInterfaceInfoIsNull,
	}
}

const (
	// NetworkInterfaceTypeCanInterface is a NetworkInterfaceType enum value
	NetworkInterfaceTypeCanInterface = "CAN_INTERFACE"

	// NetworkInterfaceTypeObdInterface is a NetworkInterfaceType enum value
	NetworkInterfaceTypeObdInterface = "OBD_INTERFACE"

	// NetworkInterfaceTypeVehicleMiddleware is a NetworkInterfaceType enum value
	NetworkInterfaceTypeVehicleMiddleware = "VEHICLE_MIDDLEWARE"
)

// NetworkInterfaceType_Values returns all elements of the NetworkInterfaceType enum
func NetworkInterfaceType_Values() []string {
	return []string{
		NetworkInterfaceTypeCanInterface,
		NetworkInterfaceTypeObdInterface,
		NetworkInterfaceTypeVehicleMiddleware,
	}
}

const (
	// NodeDataEncodingBinary is a NodeDataEncoding enum value
	NodeDataEncodingBinary = "BINARY"

	// NodeDataEncodingTyped is a NodeDataEncoding enum value
	NodeDataEncodingTyped = "TYPED"
)

// NodeDataEncoding_Values returns all elements of the NodeDataEncoding enum
func NodeDataEncoding_Values() []string {
	return []string{
		NodeDataEncodingBinary,
		NodeDataEncodingTyped,
	}
}

const (
	// NodeDataTypeInt8 is a NodeDataType enum value
	NodeDataTypeInt8 = "INT8"

	// NodeDataTypeUint8 is a NodeDataType enum value
	NodeDataTypeUint8 = "UINT8"

	// NodeDataTypeInt16 is a NodeDataType enum value
	NodeDataTypeInt16 = "INT16"

	// NodeDataTypeUint16 is a NodeDataType enum value
	NodeDataTypeUint16 = "UINT16"

	// NodeDataTypeInt32 is a NodeDataType enum value
	NodeDataTypeInt32 = "INT32"

	// NodeDataTypeUint32 is a NodeDataType enum value
	NodeDataTypeUint32 = "UINT32"

	// NodeDataTypeInt64 is a NodeDataType enum value
	NodeDataTypeInt64 = "INT64"

	// NodeDataTypeUint64 is a NodeDataType enum value
	NodeDataTypeUint64 = "UINT64"

	// NodeDataTypeBoolean is a NodeDataType enum value
	NodeDataTypeBoolean = "BOOLEAN"

	// NodeDataTypeFloat is a NodeDataType enum value
	NodeDataTypeFloat = "FLOAT"

	// NodeDataTypeDouble is a NodeDataType enum value
	NodeDataTypeDouble = "DOUBLE"

	// NodeDataTypeString is a NodeDataType enum value
	NodeDataTypeString = "STRING"

	// NodeDataTypeUnixTimestamp is a NodeDataType enum value
	NodeDataTypeUnixTimestamp = "UNIX_TIMESTAMP"

	// NodeDataTypeInt8Array is a NodeDataType enum value
	NodeDataTypeInt8Array = "INT8_ARRAY"

	// NodeDataTypeUint8Array is a NodeDataType enum value
	NodeDataTypeUint8Array = "UINT8_ARRAY"

	// NodeDataTypeInt16Array is a NodeDataType enum value
	NodeDataTypeInt16Array = "INT16_ARRAY"

	// NodeDataTypeUint16Array is a NodeDataType enum value
	NodeDataTypeUint16Array = "UINT16_ARRAY"

	// NodeDataTypeInt32Array is a NodeDataType enum value
	NodeDataTypeInt32Array = "INT32_ARRAY"

	// NodeDataTypeUint32Array is a NodeDataType enum value
	NodeDataTypeUint32Array = "UINT32_ARRAY"

	// NodeDataTypeInt64Array is a NodeDataType enum value
	NodeDataTypeInt64Array = "INT64_ARRAY"

	// NodeDataTypeUint64Array is a NodeDataType enum value
	NodeDataTypeUint64Array = "UINT64_ARRAY"

	// NodeDataTypeBooleanArray is a NodeDataType enum value
	NodeDataTypeBooleanArray = "BOOLEAN_ARRAY"

	// NodeDataTypeFloatArray is a NodeDataType enum value
	NodeDataTypeFloatArray = "FLOAT_ARRAY"

	// NodeDataTypeDoubleArray is a NodeDataType enum value
	NodeDataTypeDoubleArray = "DOUBLE_ARRAY"

	// NodeDataTypeStringArray is a NodeDataType enum value
	NodeDataTypeStringArray = "STRING_ARRAY"

	// NodeDataTypeUnixTimestampArray is a NodeDataType enum value
	NodeDataTypeUnixTimestampArray = "UNIX_TIMESTAMP_ARRAY"

	// NodeDataTypeUnknown is a NodeDataType enum value
	NodeDataTypeUnknown = "UNKNOWN"

	// NodeDataTypeStruct is a NodeDataType enum value
	NodeDataTypeStruct = "STRUCT"

	// NodeDataTypeStructArray is a NodeDataType enum value
	NodeDataTypeStructArray = "STRUCT_ARRAY"
)

// NodeDataType_Values returns all elements of the NodeDataType enum
func NodeDataType_Values() []string {
	return []string{
		NodeDataTypeInt8,
		NodeDataTypeUint8,
		NodeDataTypeInt16,
		NodeDataTypeUint16,
		NodeDataTypeInt32,
		NodeDataTypeUint32,
		NodeDataTypeInt64,
		NodeDataTypeUint64,
		NodeDataTypeBoolean,
		NodeDataTypeFloat,
		NodeDataTypeDouble,
		NodeDataTypeString,
		NodeDataTypeUnixTimestamp,
		NodeDataTypeInt8Array,
		NodeDataTypeUint8Array,
		NodeDataTypeInt16Array,
		NodeDataTypeUint16Array,
		NodeDataTypeInt32Array,
		NodeDataTypeUint32Array,
		NodeDataTypeInt64Array,
		NodeDataTypeUint64Array,
		NodeDataTypeBooleanArray,
		NodeDataTypeFloatArray,
		NodeDataTypeDoubleArray,
		NodeDataTypeStringArray,
		NodeDataTypeUnixTimestampArray,
		NodeDataTypeUnknown,
		NodeDataTypeStruct,
		NodeDataTypeStructArray,
	}
}

const (
	// ROS2PrimitiveTypeBool is a ROS2PrimitiveType enum value
	ROS2PrimitiveTypeBool = "BOOL"

	// ROS2PrimitiveTypeByte is a ROS2PrimitiveType enum value
	ROS2PrimitiveTypeByte = "BYTE"

	// ROS2PrimitiveTypeChar is a ROS2PrimitiveType enum value
	ROS2PrimitiveTypeChar = "CHAR"

	// ROS2PrimitiveTypeFloat32 is a ROS2PrimitiveType enum value
	ROS2PrimitiveTypeFloat32 = "FLOAT32"

	// ROS2PrimitiveTypeFloat64 is a ROS2PrimitiveType enum value
	ROS2PrimitiveTypeFloat64 = "FLOAT64"

	// ROS2PrimitiveTypeInt8 is a ROS2PrimitiveType enum value
	ROS2PrimitiveTypeInt8 = "INT8"

	// ROS2PrimitiveTypeUint8 is a ROS2PrimitiveType enum value
	ROS2PrimitiveTypeUint8 = "UINT8"

	// ROS2PrimitiveTypeInt16 is a ROS2PrimitiveType enum value
	ROS2PrimitiveTypeInt16 = "INT16"

	// ROS2PrimitiveTypeUint16 is a ROS2PrimitiveType enum value
	ROS2PrimitiveTypeUint16 = "UINT16"

	// ROS2PrimitiveTypeInt32 is a ROS2PrimitiveType enum value
	ROS2PrimitiveTypeInt32 = "INT32"

	// ROS2PrimitiveTypeUint32 is a ROS2PrimitiveType enum value
	ROS2PrimitiveTypeUint32 = "UINT32"

	// ROS2PrimitiveTypeInt64 is a ROS2PrimitiveType enum value
	ROS2PrimitiveTypeInt64 = "INT64"

	// ROS2PrimitiveTypeUint64 is a ROS2PrimitiveType enum value
	ROS2PrimitiveTypeUint64 = "UINT64"

	// ROS2PrimitiveTypeString is a ROS2PrimitiveType enum value
	ROS2PrimitiveTypeString = "STRING"

	// ROS2PrimitiveTypeWstring is a ROS2PrimitiveType enum value
	ROS2PrimitiveTypeWstring = "WSTRING"
)

// ROS2PrimitiveType_Values returns all elements of the ROS2PrimitiveType enum
func ROS2PrimitiveType_Values() []string {
	return []string{
		ROS2PrimitiveTypeBool,
		ROS2PrimitiveTypeByte,
		ROS2PrimitiveTypeChar,
		ROS2PrimitiveTypeFloat32,
		ROS2PrimitiveTypeFloat64,
		ROS2PrimitiveTypeInt8,
		ROS2PrimitiveTypeUint8,
		ROS2PrimitiveTypeInt16,
		ROS2PrimitiveTypeUint16,
		ROS2PrimitiveTypeInt32,
		ROS2PrimitiveTypeUint32,
		ROS2PrimitiveTypeInt64,
		ROS2PrimitiveTypeUint64,
		ROS2PrimitiveTypeString,
		ROS2PrimitiveTypeWstring,
	}
}

const (
	// RegistrationStatusRegistrationPending is a RegistrationStatus enum value
	RegistrationStatusRegistrationPending = "REGISTRATION_PENDING"

	// RegistrationStatusRegistrationSuccess is a RegistrationStatus enum value
	RegistrationStatusRegistrationSuccess = "REGISTRATION_SUCCESS"

	// RegistrationStatusRegistrationFailure is a RegistrationStatus enum value
	RegistrationStatusRegistrationFailure = "REGISTRATION_FAILURE"
)

// RegistrationStatus_Values returns all elements of the RegistrationStatus enum
func RegistrationStatus_Values() []string {
	return []string{
		RegistrationStatusRegistrationPending,
		RegistrationStatusRegistrationSuccess,
		RegistrationStatusRegistrationFailure,
	}
}

const (
	// SignalDecoderFailureReasonDuplicateSignal is a SignalDecoderFailureReason enum value
	SignalDecoderFailureReasonDuplicateSignal = "DUPLICATE_SIGNAL"

	// SignalDecoderFailureReasonConflictingSignal is a SignalDecoderFailureReason enum value
	SignalDecoderFailureReasonConflictingSignal = "CONFLICTING_SIGNAL"

	// SignalDecoderFailureReasonSignalToAddAlreadyExists is a SignalDecoderFailureReason enum value
	SignalDecoderFailureReasonSignalToAddAlreadyExists = "SIGNAL_TO_ADD_ALREADY_EXISTS"

	// SignalDecoderFailureReasonSignalNotAssociatedWithNetworkInterface is a SignalDecoderFailureReason enum value
	SignalDecoderFailureReasonSignalNotAssociatedWithNetworkInterface = "SIGNAL_NOT_ASSOCIATED_WITH_NETWORK_INTERFACE"

	// SignalDecoderFailureReasonNetworkInterfaceTypeIncompatibleWithSignalDecoderType is a SignalDecoderFailureReason enum value
	SignalDecoderFailureReasonNetworkInterfaceTypeIncompatibleWithSignalDecoderType = "NETWORK_INTERFACE_TYPE_INCOMPATIBLE_WITH_SIGNAL_DECODER_TYPE"

	// SignalDecoderFailureReasonSignalNotInModel is a SignalDecoderFailureReason enum value
	SignalDecoderFailureReasonSignalNotInModel = "SIGNAL_NOT_IN_MODEL"

	// SignalDecoderFailureReasonCanSignalInfoIsNull is a SignalDecoderFailureReason enum value
	SignalDecoderFailureReasonCanSignalInfoIsNull = "CAN_SIGNAL_INFO_IS_NULL"

	// SignalDecoderFailureReasonObdSignalInfoIsNull is a SignalDecoderFailureReason enum value
	SignalDecoderFailureReasonObdSignalInfoIsNull = "OBD_SIGNAL_INFO_IS_NULL"

	// SignalDecoderFailureReasonNoDecoderInfoForSignalInModel is a SignalDecoderFailureReason enum value
	SignalDecoderFailureReasonNoDecoderInfoForSignalInModel = "NO_DECODER_INFO_FOR_SIGNAL_IN_MODEL"

	// SignalDecoderFailureReasonMessageSignalInfoIsNull is a SignalDecoderFailureReason enum value
	SignalDecoderFailureReasonMessageSignalInfoIsNull = "MESSAGE_SIGNAL_INFO_IS_NULL"

	// SignalDecoderFailureReasonSignalDecoderTypeIncompatibleWithMessageSignalType is a SignalDecoderFailureReason enum value
	SignalDecoderFailureReasonSignalDecoderTypeIncompatibleWithMessageSignalType = "SIGNAL_DECODER_TYPE_INCOMPATIBLE_WITH_MESSAGE_SIGNAL_TYPE"

	// SignalDecoderFailureReasonStructSizeMismatch is a SignalDecoderFailureReason enum value
	SignalDecoderFailureReasonStructSizeMismatch = "STRUCT_SIZE_MISMATCH"

	// SignalDecoderFailureReasonNoSignalInCatalogForDecoderSignal is a SignalDecoderFailureReason enum value
	SignalDecoderFailureReasonNoSignalInCatalogForDecoderSignal = "NO_SIGNAL_IN_CATALOG_FOR_DECODER_SIGNAL"

	// SignalDecoderFailureReasonSignalDecoderIncompatibleWithSignalCatalog is a SignalDecoderFailureReason enum value
	SignalDecoderFailureReasonSignalDecoderIncompatibleWithSignalCatalog = "SIGNAL_DECODER_INCOMPATIBLE_WITH_SIGNAL_CATALOG"

	// SignalDecoderFailureReasonEmptyMessageSignal is a SignalDecoderFailureReason enum value
	SignalDecoderFailureReasonEmptyMessageSignal = "EMPTY_MESSAGE_SIGNAL"
)

// SignalDecoderFailureReason_Values returns all elements of the SignalDecoderFailureReason enum
func SignalDecoderFailureReason_Values() []string {
	return []string{
		SignalDecoderFailureReasonDuplicateSignal,
		SignalDecoderFailureReasonConflictingSignal,
		SignalDecoderFailureReasonSignalToAddAlreadyExists,
		SignalDecoderFailureReasonSignalNotAssociatedWithNetworkInterface,
		SignalDecoderFailureReasonNetworkInterfaceTypeIncompatibleWithSignalDecoderType,
		SignalDecoderFailureReasonSignalNotInModel,
		SignalDecoderFailureReasonCanSignalInfoIsNull,
		SignalDecoderFailureReasonObdSignalInfoIsNull,
		SignalDecoderFailureReasonNoDecoderInfoForSignalInModel,
		SignalDecoderFailureReasonMessageSignalInfoIsNull,
		SignalDecoderFailureReasonSignalDecoderTypeIncompatibleWithMessageSignalType,
		SignalDecoderFailureReasonStructSizeMismatch,
		SignalDecoderFailureReasonNoSignalInCatalogForDecoderSignal,
		SignalDecoderFailureReasonSignalDecoderIncompatibleWithSignalCatalog,
		SignalDecoderFailureReasonEmptyMessageSignal,
	}
}

const (
	// SignalDecoderTypeCanSignal is a SignalDecoderType enum value
	SignalDecoderTypeCanSignal = "CAN_SIGNAL"

	// SignalDecoderTypeObdSignal is a SignalDecoderType enum value
	SignalDecoderTypeObdSignal = "OBD_SIGNAL"

	// SignalDecoderTypeMessageSignal is a SignalDecoderType enum value
	SignalDecoderTypeMessageSignal = "MESSAGE_SIGNAL"
)

// SignalDecoderType_Values returns all elements of the SignalDecoderType enum
func SignalDecoderType_Values() []string {
	return []string{
		SignalDecoderTypeCanSignal,
		SignalDecoderTypeObdSignal,
		SignalDecoderTypeMessageSignal,
	}
}

const (
	// SignalNodeTypeSensor is a SignalNodeType enum value
	SignalNodeTypeSensor = "SENSOR"

	// SignalNodeTypeActuator is a SignalNodeType enum value
	SignalNodeTypeActuator = "ACTUATOR"

	// SignalNodeTypeAttribute is a SignalNodeType enum value
	SignalNodeTypeAttribute = "ATTRIBUTE"

	// SignalNodeTypeBranch is a SignalNodeType enum value
	SignalNodeTypeBranch = "BRANCH"

	// SignalNodeTypeCustomStruct is a SignalNodeType enum value
	SignalNodeTypeCustomStruct = "CUSTOM_STRUCT"

	// SignalNodeTypeCustomProperty is a SignalNodeType enum value
	SignalNodeTypeCustomProperty = "CUSTOM_PROPERTY"
)

// SignalNodeType_Values returns all elements of the SignalNodeType enum
func SignalNodeType_Values() []string {
	return []string{
		SignalNodeTypeSensor,
		SignalNodeTypeActuator,
		SignalNodeTypeAttribute,
		SignalNodeTypeBranch,
		SignalNodeTypeCustomStruct,
		SignalNodeTypeCustomProperty,
	}
}

const (
	// SpoolingModeOff is a SpoolingMode enum value
	SpoolingModeOff = "OFF"

	// SpoolingModeToDisk is a SpoolingMode enum value
	SpoolingModeToDisk = "TO_DISK"
)

// SpoolingMode_Values returns all elements of the SpoolingMode enum
func SpoolingMode_Values() []string {
	return []string{
		SpoolingModeOff,
		SpoolingModeToDisk,
	}
}

const (
	// StorageCompressionFormatNone is a StorageCompressionFormat enum value
	StorageCompressionFormatNone = "NONE"

	// StorageCompressionFormatGzip is a StorageCompressionFormat enum value
	StorageCompressionFormatGzip = "GZIP"
)

// StorageCompressionFormat_Values returns all elements of the StorageCompressionFormat enum
func StorageCompressionFormat_Values() []string {
	return []string{
		StorageCompressionFormatNone,
		StorageCompressionFormatGzip,
	}
}

const (
	// StructuredMessageListTypeFixedCapacity is a StructuredMessageListType enum value
	StructuredMessageListTypeFixedCapacity = "FIXED_CAPACITY"

	// StructuredMessageListTypeDynamicUnboundedCapacity is a StructuredMessageListType enum value
	StructuredMessageListTypeDynamicUnboundedCapacity = "DYNAMIC_UNBOUNDED_CAPACITY"

	// StructuredMessageListTypeDynamicBoundedCapacity is a StructuredMessageListType enum value
	StructuredMessageListTypeDynamicBoundedCapacity = "DYNAMIC_BOUNDED_CAPACITY"
)

// StructuredMessageListType_Values returns all elements of the StructuredMessageListType enum
func StructuredMessageListType_Values() []string {
	return []string{
		StructuredMessageListTypeFixedCapacity,
		StructuredMessageListTypeDynamicUnboundedCapacity,
		StructuredMessageListTypeDynamicBoundedCapacity,
	}
}

const (
	// TriggerModeAlways is a TriggerMode enum value
	TriggerModeAlways = "ALWAYS"

	// TriggerModeRisingEdge is a TriggerMode enum value
	TriggerModeRisingEdge = "RISING_EDGE"
)

// TriggerMode_Values returns all elements of the TriggerMode enum
func TriggerMode_Values() []string {
	return []string{
		TriggerModeAlways,
		TriggerModeRisingEdge,
	}
}

const (
	// UpdateCampaignActionApprove is a UpdateCampaignAction enum value
	UpdateCampaignActionApprove = "APPROVE"

	// UpdateCampaignActionSuspend is a UpdateCampaignAction enum value
	UpdateCampaignActionSuspend = "SUSPEND"

	// UpdateCampaignActionResume is a UpdateCampaignAction enum value
	UpdateCampaignActionResume = "RESUME"

	// UpdateCampaignActionUpdate is a UpdateCampaignAction enum value
	UpdateCampaignActionUpdate = "UPDATE"
)

// UpdateCampaignAction_Values returns all elements of the UpdateCampaignAction enum
func UpdateCampaignAction_Values() []string {
	return []string{
		UpdateCampaignActionApprove,
		UpdateCampaignActionSuspend,
		UpdateCampaignActionResume,
		UpdateCampaignActionUpdate,
	}
}

const (
	// UpdateModeOverwrite is a UpdateMode enum value
	UpdateModeOverwrite = "Overwrite"

	// UpdateModeMerge is a UpdateMode enum value
	UpdateModeMerge = "Merge"
)

// UpdateMode_Values returns all elements of the UpdateMode enum
func UpdateMode_Values() []string {
	return []string{
		UpdateModeOverwrite,
		UpdateModeMerge,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "unknownOperation"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "cannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "fieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}

const (
	// VehicleAssociationBehaviorCreateIotThing is a VehicleAssociationBehavior enum value
	VehicleAssociationBehaviorCreateIotThing = "CreateIotThing"

	// VehicleAssociationBehaviorValidateIotThingExists is a VehicleAssociationBehavior enum value
	VehicleAssociationBehaviorValidateIotThingExists = "ValidateIotThingExists"
)

// VehicleAssociationBehavior_Values returns all elements of the VehicleAssociationBehavior enum
func VehicleAssociationBehavior_Values() []string {
	return []string{
		VehicleAssociationBehaviorCreateIotThing,
		VehicleAssociationBehaviorValidateIotThingExists,
	}
}

const (
	// VehicleMiddlewareProtocolRos2 is a VehicleMiddlewareProtocol enum value
	VehicleMiddlewareProtocolRos2 = "ROS_2"
)

// VehicleMiddlewareProtocol_Values returns all elements of the VehicleMiddlewareProtocol enum
func VehicleMiddlewareProtocol_Values() []string {
	return []string{
		VehicleMiddlewareProtocolRos2,
	}
}

const (
	// VehicleStateCreated is a VehicleState enum value
	VehicleStateCreated = "CREATED"

	// VehicleStateReady is a VehicleState enum value
	VehicleStateReady = "READY"

	// VehicleStateHealthy is a VehicleState enum value
	VehicleStateHealthy = "HEALTHY"

	// VehicleStateSuspended is a VehicleState enum value
	VehicleStateSuspended = "SUSPENDED"

	// VehicleStateDeleting is a VehicleState enum value
	VehicleStateDeleting = "DELETING"
)

// VehicleState_Values returns all elements of the VehicleState enum
func VehicleState_Values() []string {
	return []string{
		VehicleStateCreated,
		VehicleStateReady,
		VehicleStateHealthy,
		VehicleStateSuspended,
		VehicleStateDeleting,
	}
}
