/*
Copyright 2024 The KEDA Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"

	v1alpha1 "github.com/kedacore/keda/v2/apis/keda/v1alpha1"
	scheme "github.com/kedacore/keda/v2/pkg/generated/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// ScaledJobsGetter has a method to return a ScaledJobInterface.
// A group's client should implement this interface.
type ScaledJobsGetter interface {
	ScaledJobs(namespace string) ScaledJobInterface
}

// ScaledJobInterface has methods to work with ScaledJob resources.
type ScaledJobInterface interface {
	Create(ctx context.Context, scaledJob *v1alpha1.ScaledJob, opts v1.CreateOptions) (*v1alpha1.ScaledJob, error)
	Update(ctx context.Context, scaledJob *v1alpha1.ScaledJob, opts v1.UpdateOptions) (*v1alpha1.ScaledJob, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, scaledJob *v1alpha1.ScaledJob, opts v1.UpdateOptions) (*v1alpha1.ScaledJob, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.ScaledJob, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.ScaledJobList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ScaledJob, err error)
	ScaledJobExpansion
}

// scaledJobs implements ScaledJobInterface
type scaledJobs struct {
	*gentype.ClientWithList[*v1alpha1.ScaledJob, *v1alpha1.ScaledJobList]
}

// newScaledJobs returns a ScaledJobs
func newScaledJobs(c *KedaV1alpha1Client, namespace string) *scaledJobs {
	return &scaledJobs{
		gentype.NewClientWithList[*v1alpha1.ScaledJob, *v1alpha1.ScaledJobList](
			"scaledjobs",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *v1alpha1.ScaledJob { return &v1alpha1.ScaledJob{} },
			func() *v1alpha1.ScaledJobList { return &v1alpha1.ScaledJobList{} }),
	}
}
