/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	metav1 "k8s.io/client-go/applyconfigurations/meta/v1"

	v1 "sigs.k8s.io/gateway-api/apis/v1"
)

// ListenerStatusApplyConfiguration represents an declarative configuration of the ListenerStatus type for use
// with apply.
type ListenerStatusApplyConfiguration struct {
	Name           *v1.SectionName                      `json:"name,omitempty"`
	SupportedKinds []RouteGroupKindApplyConfiguration   `json:"supportedKinds,omitempty"`
	AttachedRoutes *int32                               `json:"attachedRoutes,omitempty"`
	Conditions     []metav1.ConditionApplyConfiguration `json:"conditions,omitempty"`
}

// ListenerStatusApplyConfiguration constructs an declarative configuration of the ListenerStatus type for use with
// apply.
func ListenerStatus() *ListenerStatusApplyConfiguration {
	return &ListenerStatusApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *ListenerStatusApplyConfiguration) WithName(value v1.SectionName) *ListenerStatusApplyConfiguration {
	b.Name = &value
	return b
}

// WithSupportedKinds adds the given value to the SupportedKinds field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the SupportedKinds field.
func (b *ListenerStatusApplyConfiguration) WithSupportedKinds(values ...*RouteGroupKindApplyConfiguration) *ListenerStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithSupportedKinds")
		}
		b.SupportedKinds = append(b.SupportedKinds, *values[i])
	}
	return b
}

// WithAttachedRoutes sets the AttachedRoutes field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AttachedRoutes field is set to the value of the last call.
func (b *ListenerStatusApplyConfiguration) WithAttachedRoutes(value int32) *ListenerStatusApplyConfiguration {
	b.AttachedRoutes = &value
	return b
}

// WithConditions adds the given value to the Conditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Conditions field.
func (b *ListenerStatusApplyConfiguration) WithConditions(values ...*metav1.ConditionApplyConfiguration) *ListenerStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConditions")
		}
		b.Conditions = append(b.Conditions, *values[i])
	}
	return b
}
