/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.chat_markers.filter;

import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smackx.chatstates.ChatState;

public final class EligibleForChatMarkerFilter
extends StanzaExtensionFilter {
    public static final EligibleForChatMarkerFilter INSTANCE = new EligibleForChatMarkerFilter("http://jabber.org/protocol/chatstates");

    private EligibleForChatMarkerFilter(String namespace) {
        super(namespace);
    }

    @Override
    public boolean accept(Stanza message) {
        if (!message.hasStanzaIdSet()) {
            return false;
        }
        if (super.accept(message)) {
            XmlElement extension = message.getExtension("http://jabber.org/protocol/chatstates");
            String chatStateElementName = extension.getElementName();
            try {
                ChatState state = ChatState.valueOf(chatStateElementName);
                return state == ChatState.active;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }
}

