/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.commands.AbstractAdHocCommand;
import org.jivesoftware.smackx.commands.packet.AdHocCommandData;
import org.jivesoftware.smackx.commands.packet.AdHocCommandDataBuilder;
import org.jivesoftware.smackx.xdata.form.SubmitForm;
import org.jxmpp.jid.Jid;

public abstract class AdHocCommandHandler
extends AbstractAdHocCommand {
    private final long creationDate;
    private int currentStage;

    public AdHocCommandHandler(String node, String name, String sessionId) {
        super(node, name);
        this.setSessionId(sessionId);
        this.creationDate = System.currentTimeMillis();
    }

    protected abstract AdHocCommandData execute(AdHocCommandDataBuilder var1) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, IllegalStateException;

    protected abstract AdHocCommandData next(AdHocCommandDataBuilder var1, SubmitForm var2) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, IllegalStateException;

    protected abstract AdHocCommandData complete(AdHocCommandDataBuilder var1, SubmitForm var2) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, IllegalStateException;

    protected abstract AdHocCommandData prev(AdHocCommandDataBuilder var1) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, IllegalStateException;

    public long getCreationDate() {
        return this.creationDate;
    }

    public boolean hasPermission(Jid jid) {
        return true;
    }

    public final int getCurrentStage() {
        return this.currentStage;
    }

    final void incrementStage() {
        ++this.currentStage;
    }

    final void decrementStage() {
        --this.currentStage;
    }

    protected static XMPPException.XMPPErrorException newXmppErrorException(StanzaError.Condition condition) {
        return AdHocCommandHandler.newXmppErrorException(condition, null);
    }

    protected static XMPPException.XMPPErrorException newXmppErrorException(StanzaError.Condition condition, String descriptiveText) {
        StanzaError stanzaError = StanzaError.from(condition, descriptiveText).build();
        return new XMPPException.XMPPErrorException(null, stanzaError);
    }

    protected static XMPPException.XMPPErrorException newBadRequestException(String descriptiveTest) {
        return AdHocCommandHandler.newXmppErrorException(StanzaError.Condition.bad_request, descriptiveTest);
    }

    public static abstract class SingleStage
    extends AdHocCommandHandler {
        public SingleStage(String node, String name, String sessionId) {
            super(node, name, sessionId);
        }

        protected abstract AdHocCommandData executeSingleStage(AdHocCommandDataBuilder var1) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException;

        @Override
        protected final AdHocCommandData execute(AdHocCommandDataBuilder response) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
            response.setStatusCompleted();
            return this.executeSingleStage(response);
        }

        @Override
        public final AdHocCommandData next(AdHocCommandDataBuilder response, SubmitForm submittedForm) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
            throw SingleStage.newXmppErrorException(StanzaError.Condition.bad_request);
        }

        @Override
        public final AdHocCommandData complete(AdHocCommandDataBuilder response, SubmitForm submittedForm) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
            throw SingleStage.newXmppErrorException(StanzaError.Condition.bad_request);
        }

        @Override
        public final AdHocCommandData prev(AdHocCommandDataBuilder response) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
            throw SingleStage.newXmppErrorException(StanzaError.Condition.bad_request);
        }

        @Override
        public final void cancel() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
            throw SingleStage.newXmppErrorException(StanzaError.Condition.bad_request);
        }
    }
}

