/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands;

import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.commands.packet.AdHocCommandData;
import org.jivesoftware.smackx.xdata.form.FillableForm;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public abstract class AdHocCommandResult {
    private final AdHocCommandData response;
    private final boolean completed;

    private AdHocCommandResult(AdHocCommandData response, boolean completed) {
        this.response = response;
        this.completed = completed;
    }

    public final AdHocCommandData getResponse() {
        return this.response;
    }

    public final boolean isCompleted() {
        return this.completed;
    }

    public StatusExecuting asExecutingOrThrow() {
        if (this instanceof StatusExecuting) {
            return (StatusExecuting)this;
        }
        throw new IllegalStateException();
    }

    public StatusCompleted asCompletedOrThrow() {
        if (this instanceof StatusCompleted) {
            return (StatusCompleted)this;
        }
        throw new IllegalStateException();
    }

    public static AdHocCommandResult from(AdHocCommandData response) {
        IQ.Type iqType = response.getType();
        if (iqType == IQ.Type.error) {
            return new Error(response);
        }
        assert (iqType == IQ.Type.result);
        switch (response.getStatus()) {
            case executing: {
                return new StatusExecuting(response);
            }
            case completed: {
                return new StatusCompleted(response);
            }
        }
        throw new IllegalArgumentException();
    }

    public static final class StatusExecuting
    extends AdHocCommandResult {
        private StatusExecuting(AdHocCommandData response) {
            super(response, false);
            assert (response.getStatus() == AdHocCommandData.Status.executing);
        }

        public FillableForm getFillableForm() {
            DataForm form = this.getResponse().getForm();
            return new FillableForm(form);
        }
    }

    public static final class StatusCompleted
    extends AdHocCommandResult {
        private StatusCompleted(AdHocCommandData response) {
            super(response, true);
            assert (response.getStatus() == AdHocCommandData.Status.completed);
        }
    }

    static final class Error
    extends AdHocCommandResult {
        private Error(AdHocCommandData response) {
            super(response, false);
        }
    }
}

