/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.rule.jvmmodel;

import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.NamedThreadFactory;
import org.openhab.core.common.registry.RegistryChangeListener;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.ItemRegistryChangeListener;
import org.openhab.core.model.core.ModelRepository;
import org.openhab.core.model.script.engine.action.ActionService;
import org.openhab.core.service.ReadyMarker;
import org.openhab.core.service.ReadyMarkerFilter;
import org.openhab.core.service.ReadyService;
import org.openhab.core.thing.Thing;
import org.openhab.core.thing.ThingRegistry;
import org.openhab.core.thing.ThingRegistryChangeListener;
import org.openhab.core.thing.binding.ThingActions;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={})
@NonNullByDefault
public class RulesRefresher
implements ReadyService.ReadyTracker {
    private static final long REFRESH_DELAY = 30L;
    public static final String RULES_REFRESH_MARKER_TYPE = "rules";
    public static final String RULES_REFRESH = "refresh";
    private final Logger logger = LoggerFactory.getLogger(RulesRefresher.class);
    private @Nullable ScheduledFuture<?> job;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("rulesRefresher"));
    private boolean started;
    private final ReadyMarker marker = new ReadyMarker("rules", "refresh");
    private final ModelRepository modelRepository;
    private final ItemRegistry itemRegistry;
    private final ThingRegistry thingRegistry;
    private final ReadyService readyService;
    private final ItemRegistryChangeListener itemRegistryChangeListener = new ItemRegistryChangeListener(){

        public void added(Item element) {
            RulesRefresher.this.logger.debug("Item \"{}\" added => rules are going to be refreshed", (Object)element.getName());
            RulesRefresher.this.scheduleRuleRefresh(30L);
        }

        public void removed(Item element) {
            RulesRefresher.this.logger.debug("Item \"{}\" removed => rules are going to be refreshed", (Object)element.getName());
            RulesRefresher.this.scheduleRuleRefresh(30L);
        }

        public void updated(Item oldElement, Item element) {
        }

        public void allItemsChanged(Collection<String> oldItemNames) {
            RulesRefresher.this.logger.debug("All items changed => rules are going to be refreshed");
            RulesRefresher.this.scheduleRuleRefresh(30L);
        }
    };
    private final ThingRegistryChangeListener thingRegistryChangeListener = new ThingRegistryChangeListener(){

        public void added(Thing element) {
            RulesRefresher.this.logger.debug("Thing \"{}\" added => rules are going to be refreshed", (Object)element.getUID().getAsString());
            RulesRefresher.this.scheduleRuleRefresh(30L);
        }

        public void removed(Thing element) {
            RulesRefresher.this.logger.debug("Thing \"{}\" removed => rules are going to be refreshed", (Object)element.getUID().getAsString());
            RulesRefresher.this.scheduleRuleRefresh(30L);
        }

        public void updated(Thing oldElement, Thing element) {
        }
    };

    @Activate
    public RulesRefresher(@Reference ModelRepository modelRepository, @Reference ItemRegistry itemRegistry, @Reference ThingRegistry thingRegistry, @Reference ReadyService readyService) {
        this.modelRepository = modelRepository;
        this.itemRegistry = itemRegistry;
        this.thingRegistry = thingRegistry;
        this.readyService = readyService;
    }

    @Activate
    protected void activate() {
        this.readyService.registerTracker((ReadyService.ReadyTracker)this, new ReadyMarkerFilter().withType("startlevel").withIdentifier(Integer.toString(20)));
    }

    @Deactivate
    protected void deactivate() {
        this.readyService.unregisterTracker((ReadyService.ReadyTracker)this);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addActionService(ActionService actionService) {
        if (this.started) {
            this.logger.debug("Script action added => rules are going to be refreshed");
            this.scheduleRuleRefresh(30L);
        }
    }

    protected void removeActionService(ActionService actionService) {
        if (this.started) {
            this.logger.debug("Script action removed => rules are going to be refreshed");
            this.scheduleRuleRefresh(30L);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addThingActions(ThingActions thingActions) {
        if (this.started) {
            this.logger.debug("Thing automation action added => rules are going to be refreshed");
            this.scheduleRuleRefresh(30L);
        }
    }

    protected void removeThingActions(ThingActions thingActions) {
        if (this.started) {
            this.logger.debug("Thing automation action removed => rules are going to be refreshed");
            this.scheduleRuleRefresh(30L);
        }
    }

    protected synchronized void scheduleRuleRefresh(long delay) {
        ScheduledFuture<?> localJob = this.job;
        if (localJob != null && !localJob.isDone()) {
            localJob.cancel(false);
        }
        this.job = this.scheduler.schedule(() -> {
            try {
                this.modelRepository.reloadAllModelsOfType(RULES_REFRESH_MARKER_TYPE);
            }
            catch (Exception e) {
                this.logger.debug("Exception occurred during execution: {}", (Object)e.getMessage(), (Object)e);
            }
            if (!this.started) {
                this.started = true;
                this.readyService.markReady(this.marker);
            }
        }, delay, TimeUnit.SECONDS);
    }

    public void onReadyMarkerAdded(ReadyMarker readyMarker) {
        this.scheduleRuleRefresh(0L);
        this.itemRegistry.addRegistryChangeListener((RegistryChangeListener)this.itemRegistryChangeListener);
        this.thingRegistry.addRegistryChangeListener((RegistryChangeListener)this.thingRegistryChangeListener);
    }

    public void onReadyMarkerRemoved(ReadyMarker readyMarker) {
        this.itemRegistry.removeRegistryChangeListener((RegistryChangeListener)this.itemRegistryChangeListener);
        this.thingRegistry.removeRegistryChangeListener((RegistryChangeListener)this.thingRegistryChangeListener);
    }
}

