﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agent-runtime/BedrockAgentRuntime_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws {
namespace BedrockAgentRuntime {
namespace Model {
enum class KnowledgeBaseQueryType { NOT_SET, TEXT, IMAGE };

namespace KnowledgeBaseQueryTypeMapper {
AWS_BEDROCKAGENTRUNTIME_API KnowledgeBaseQueryType GetKnowledgeBaseQueryTypeForName(const Aws::String& name);

AWS_BEDROCKAGENTRUNTIME_API Aws::String GetNameForKnowledgeBaseQueryType(KnowledgeBaseQueryType value);
}  // namespace KnowledgeBaseQueryTypeMapper
}  // namespace Model
}  // namespace BedrockAgentRuntime
}  // namespace Aws
