/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.langchain4j.data.message.AudioContent;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.GsonContentAdapter;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.PdfFileContent;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.message.VideoContent;
import java.lang.reflect.Type;

class GsonChatMessageAdapter
implements JsonDeserializer<ChatMessage>,
JsonSerializer<ChatMessage> {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)Content.class), new GsonContentAdapter()).registerTypeAdapter((Type)((Object)TextContent.class), new GsonContentAdapter()).registerTypeAdapter((Type)((Object)ImageContent.class), new GsonContentAdapter()).registerTypeAdapter((Type)((Object)AudioContent.class), new GsonContentAdapter()).registerTypeAdapter((Type)((Object)VideoContent.class), new GsonContentAdapter()).registerTypeAdapter((Type)((Object)PdfFileContent.class), new GsonContentAdapter()).create();
    private static final String CHAT_MESSAGE_TYPE = "type";

    GsonChatMessageAdapter() {
    }

    @Override
    public JsonElement serialize(ChatMessage chatMessage, Type ignored, JsonSerializationContext context) {
        JsonObject messageJsonObject = GSON.toJsonTree(chatMessage).getAsJsonObject();
        messageJsonObject.addProperty(CHAT_MESSAGE_TYPE, chatMessage.type().toString());
        return messageJsonObject;
    }

    @Override
    public ChatMessage deserialize(JsonElement messageJsonElement, Type ignored, JsonDeserializationContext context) {
        UserMessage message;
        String chatMessageTypeString = messageJsonElement.getAsJsonObject().get(CHAT_MESSAGE_TYPE).getAsString();
        ChatMessageType chatMessageType = ChatMessageType.valueOf(chatMessageTypeString);
        ChatMessage chatMessage = GSON.fromJson(messageJsonElement, chatMessageType.messageClass());
        if (chatMessage instanceof UserMessage && (message = (UserMessage)chatMessage).contents() == null) {
            chatMessage = UserMessage.from(messageJsonElement.getAsJsonObject().get("text").getAsString());
        }
        return chatMessage;
    }
}

