/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.lang.reflect.Method;

public final class ReflectionHelper {
    public static Object tryInvokeMethod(Object o, String methodName, Class[] types, Object[] args) {
        return ReflectionHelper.tryInvokeMethod(o, o.getClass(), methodName, types, args);
    }

    public static Object tryInvokeMethod(Object o, Class<?> clazz, String methodName, Class[] types, Object[] args) {
        try {
            Method method = clazz.getMethod(methodName, types);
            method.setAccessible(true);
            return method.invoke(o, args);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object tryInvokeStaticMethod(ClassLoader loader, String className, String methodName, Class[] types, Object[] args) {
        try {
            Method method = ReflectionHelper.classForName(className, loader).getMethod(methodName, types);
            method.setAccessible(true);
            return method.invoke(null, args);
        }
        catch (Exception e) {
            JdbcNativeUtil.logWarn("Cannot invoke static method", e);
            return null;
        }
    }

    public static Class<?> classForName(String className, ClassLoader loader) throws ClassNotFoundException {
        return Class.forName(className, true, loader);
    }
}

