/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.types;

public enum DasTypeCategory {
    INTEGER,
    REAL,
    STRING,
    BOOLEAN,
    DATE_TIME,
    DATE,
    TIME,
    TIMESTAMP,
    INTERVAL,
    BYTES,
    ENUM,
    REFERENCE,
    RECORD,
    UNKNOWN;


    public boolean isNumber() {
        return this == INTEGER || this == REAL;
    }

    public static DasTypeCategory findByJdbcType(int jdbcType) {
        return switch (jdbcType) {
            case -7, -6, -5, 1, 4, 5 -> INTEGER;
            case 2, 3, 6, 7, 8 -> REAL;
            case -1, 12, 2005, 2011 -> STRING;
            case 91 -> DATE;
            case 92 -> TIME;
            case 93 -> TIMESTAMP;
            case -4, -3, -2, 2000, 2004 -> BYTES;
            case 16 -> BOOLEAN;
            default -> UNKNOWN;
        };
    }
}

