/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jettison.mapped;

import org.codehaus.jettison.mapped.TypeConverter;

public class DefaultConverter
implements TypeConverter {
    private static final String ENFORCE_32BIT_INTEGER_KEY = "jettison.mapped.typeconverter.enforce_32bit_integer";
    public static final boolean ENFORCE_32BIT_INTEGER = Boolean.getBoolean("jettison.mapped.typeconverter.enforce_32bit_integer");
    private boolean enforce32BitInt = ENFORCE_32BIT_INTEGER;
    private static final int MAX_LENGTH_LONG = String.valueOf(Long.MAX_VALUE).length();
    private static final int MAX_LENGTH_LONG_NEGATIVE = String.valueOf(Long.MAX_VALUE).length() + 1;
    private static final int MAX_LENGTH_INTEGER = String.valueOf(Integer.MAX_VALUE).length();
    private static final int MAX_LENGTH_INTEGER_NEGATIVE = String.valueOf(Integer.MAX_VALUE).length() + 1;

    public void setEnforce32BitInt(boolean enforce32BitInt) {
        this.enforce32BitInt = enforce32BitInt;
    }

    @Override
    public Object convertToJSONPrimitive(String text2) {
        Double dbl;
        char first2;
        if (text2 == null) {
            return text2;
        }
        if (text2.length() >= 1 && ((first2 = text2.charAt(0)) < '0' || first2 > '9') && first2 != '-') {
            if (first2 == 't') {
                if (text2.equals("true")) {
                    return Boolean.TRUE;
                }
            } else if (first2 == 'f' && text2.equals("false")) {
                return Boolean.FALSE;
            }
            return text2;
        }
        Object primitive = null;
        primitive = this.enforce32BitInt ? (Number)DefaultConverter.getInteger(text2) : (Number)DefaultConverter.getLong(text2);
        if (primitive == null && (dbl = DefaultConverter.getDouble(text2)) != null) {
            primitive = dbl.isInfinite() || dbl.isNaN() ? text2 : dbl;
        }
        if (primitive == null || !primitive.toString().equals(text2)) {
            primitive = text2;
        }
        return primitive;
    }

    private static Long getLong(String text2) {
        if (text2.isEmpty()) {
            return null;
        }
        if (text2.charAt(0) == '-' ? text2.length() > MAX_LENGTH_LONG_NEGATIVE : text2.length() > MAX_LENGTH_LONG) {
            return null;
        }
        int i2 = 0;
        if (text2.charAt(0) == '-') {
            if (text2.length() > 1) {
                ++i2;
            } else {
                return null;
            }
        }
        while (i2 < text2.length()) {
            if (!Character.isDigit(text2.charAt(i2))) {
                return null;
            }
            ++i2;
        }
        try {
            return Long.parseLong(text2);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Integer getInteger(String text2) {
        if (text2.isEmpty()) {
            return null;
        }
        if (text2.charAt(0) == '-' ? text2.length() > MAX_LENGTH_INTEGER_NEGATIVE : text2.length() > MAX_LENGTH_INTEGER) {
            return null;
        }
        int i2 = 0;
        if (text2.charAt(0) == '-') {
            if (text2.length() > 1) {
                ++i2;
            } else {
                return null;
            }
        }
        while (i2 < text2.length()) {
            if (!Character.isDigit(text2.charAt(i2))) {
                return null;
            }
            ++i2;
        }
        try {
            return Integer.parseInt(text2);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Double getDouble(String text2) {
        boolean foundDP = false;
        boolean foundExp = false;
        if (text2.isEmpty()) {
            return null;
        }
        int i2 = 0;
        if (text2.charAt(0) == '-') {
            if (text2.length() > 1) {
                ++i2;
            } else {
                return null;
            }
        }
        while (i2 < text2.length()) {
            char next = text2.charAt(i2);
            if (!Character.isDigit(next)) {
                if (next == '.') {
                    if (foundDP) {
                        return null;
                    }
                    foundDP = true;
                } else if (next == 'E' || next == 'e') {
                    if (foundExp) {
                        return null;
                    }
                    foundExp = true;
                } else {
                    return null;
                }
            }
            ++i2;
        }
        try {
            return Double.parseDouble(text2);
        }
        catch (Exception e) {
            return null;
        }
    }
}

