/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;

public final class CssImportantInsertHandler
implements InsertHandler<LookupElement> {
    public static final InsertHandler<LookupElement> INSTANCE = new CssImportantInsertHandler();

    private CssImportantInsertHandler() {
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Project project;
        if (context == null) {
            CssImportantInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            CssImportantInsertHandler.$$$reportNull$$$0(1);
        }
        Editor editor = context.getEditor();
        String declarationTerminator = CssPsiUtil.getDeclarationsTerminatorFromContext(context.getFile().findElementAt(context.getStartOffset()));
        if (StringUtil.isEmpty((String)declarationTerminator)) {
            return;
        }
        if (declarationTerminator.length() == 1 && context.getCompletionChar() == declarationTerminator.charAt(0)) {
            context.setAddCompletionChar(false);
        }
        if ((project = editor.getProject()) != null) {
            if (!CssImportantInsertHandler.isStringAtCaret(editor, declarationTerminator)) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)declarationTerminator);
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            } else {
                editor.getCaretModel().moveToOffset(editor.getCaretModel().getOffset() + declarationTerminator.length());
            }
        }
    }

    private static boolean isStringAtCaret(Editor editor, String s) {
        int startOffset = editor.getCaretModel().getOffset();
        int endOffset = startOffset + s.length();
        Document document = editor.getDocument();
        return document.getTextLength() > endOffset && s.equals(document.getCharsSequence().subSequence(startOffset, endOffset).toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "item";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/css/impl/util/completion/CssImportantInsertHandler";
        objectArray[2] = "handleInsert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

