/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.columns;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.columns.ColumnKind;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.columns.ColumnResolutionContext;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.columns.DataColumnInternal;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u0000H\u00a6\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH&J\u000f\u0010\t\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H&J\u0016\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\bH\u00a6\u0002\u00a2\u0006\u0002\u0010\u000eJ#\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u000f\u001a\u00020\b2\n\u0010\u0010\u001a\u00020\u0011\"\u00020\bH\u0096\u0002J\u0019\u0010\f\u001a\n\u0012\u0002\b\u00030\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u00a6\u0002J\u001d\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0017H\u00a6\u0002J\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0018\u001a\u00020\u0019H\u00a6\u0002J\u001e\u0010\f\u001a\u00028\u00002\u000e\u0010\u001a\u001a\n\u0012\u0002\b\u00030\u001bj\u0002`\u001cH\u0096\u0002\u00a2\u0006\u0002\u0010\u001dJ%\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\u0010\u001f\u001a\u0004\u0018\u00010 2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0096\u0002J\b\u0010#\u001a\u00020$H&J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010&\u001a\u00020\u0015H&J\b\u0010'\u001a\u00020\bH&J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000+H&J\b\u0010,\u001a\u00020-H&J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H&\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlinx/dataframe/columns/BaseColumn;", "T", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;", "contains", "", "value", "(Ljava/lang/Object;)Z", "countDistinct", "", "defaultValue", "()Ljava/lang/Object;", "distinct", "get", "index", "(I)Ljava/lang/Object;", "firstIndex", "otherIndices", "", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyCol;", "columnName", "", "indices", "", "range", "Lkotlin/ranges/IntRange;", "row", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "Lorg/jetbrains/kotlinx/dataframe/AnyRow;", "(Lorg/jetbrains/kotlinx/dataframe/DataRow;)Ljava/lang/Object;", "getValue", "thisRef", "", "property", "Lkotlin/reflect/KProperty;", "kind", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnKind;", "rename", "newName", "size", "toList", "", "toSet", "", "type", "Lkotlin/reflect/KType;", "values", "core"})
public interface BaseColumn<T>
extends ColumnReference<T> {
    public int size();

    @NotNull
    public ColumnKind kind();

    @NotNull
    public KType type();

    @Nullable
    public T defaultValue();

    public T get(int var1);

    @NotNull
    public BaseColumn<T> get(int var1, int ... var2);

    public T get(@NotNull DataRow<?> var1);

    @NotNull
    public BaseColumn<T> get(@NotNull IntRange var1);

    @NotNull
    public BaseColumn<T> get(@NotNull Iterable<Integer> var1);

    @NotNull
    public DataColumn<?> get(@NotNull String var1);

    @NotNull
    public Iterable<T> values();

    @NotNull
    public List<T> toList();

    @NotNull
    public Set<T> toSet();

    @NotNull
    public BaseColumn<T> distinct();

    public int countDistinct();

    public boolean contains(T var1);

    @Override
    @NotNull
    public BaseColumn<T> rename(@NotNull String var1);

    @Override
    @NotNull
    public BaseColumn<T> getValue(@Nullable Object var1, @NotNull KProperty<?> var2);

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nBaseColumn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseColumn.kt\norg/jetbrains/kotlinx/dataframe/columns/BaseColumn$DefaultImpls\n+ 2 Utils.kt\norg/jetbrains/kotlinx/dataframe/impl/UtilsKt\n*L\n1#1,100:1\n293#2:101\n*S KotlinDebug\n*F\n+ 1 BaseColumn.kt\norg/jetbrains/kotlinx/dataframe/columns/BaseColumn$DefaultImpls\n*L\n51#1:101\n*E\n"})
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public static <T> BaseColumn<T> get(@NotNull BaseColumn<? extends T> $this, int firstIndex, int ... otherIndices) {
            void cols$iv;
            void head$iv;
            Intrinsics.checkNotNullParameter((Object)otherIndices, (String)"otherIndices");
            Integer n = firstIndex;
            Iterable iterable = ArraysKt.asIterable((int[])otherIndices);
            boolean $i$f$headPlusIterable = false;
            return $this.get(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)head$iv), (Iterable)cols$iv));
        }

        public static <T> T get(@NotNull BaseColumn<? extends T> $this, @NotNull DataRow<?> row) {
            Intrinsics.checkNotNullParameter(row, (String)"row");
            return $this.get(row.index());
        }

        @NotNull
        public static <T> List<T> toList(@NotNull BaseColumn<? extends T> $this) {
            return UtilsKt.asList($this.values());
        }

        @NotNull
        public static <T> BaseColumn<T> getValue(@NotNull BaseColumn<? extends T> $this, @Nullable Object thisRef, @NotNull KProperty<?> property) {
            Intrinsics.checkNotNullParameter(property, (String)"property");
            Intrinsics.checkNotNull($this, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dataframe.impl.columns.DataColumnInternal<*>");
            DataColumn dataColumn = ((DataColumnInternal)$this).rename(UtilsKt.getColumnName(property)).forceResolve();
            Intrinsics.checkNotNull(dataColumn, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dataframe.columns.BaseColumn<T of org.jetbrains.kotlinx.dataframe.columns.BaseColumn>");
            return dataColumn;
        }

        public static <T> T getValue(@NotNull BaseColumn<? extends T> $this, @NotNull DataRow<?> row) {
            Intrinsics.checkNotNullParameter(row, (String)"row");
            return (T)ColumnReference.DefaultImpls.getValue((ColumnReference)$this, row);
        }

        @NotNull
        public static <T> ColumnPath path(@NotNull BaseColumn<? extends T> $this) {
            return ColumnReference.DefaultImpls.path((ColumnReference)$this);
        }

        @Nullable
        public static <T> T getValueOrNull(@NotNull BaseColumn<? extends T> $this, @NotNull DataRow<?> row) {
            Intrinsics.checkNotNullParameter(row, (String)"row");
            return (T)ColumnReference.DefaultImpls.getValueOrNull((ColumnReference)$this, row);
        }

        @Nullable
        public static <T> ColumnWithPath<T> resolveSingle(@NotNull BaseColumn<? extends T> $this, @NotNull ColumnResolutionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return ColumnReference.DefaultImpls.resolveSingle((ColumnReference)$this, context);
        }

        @NotNull
        public static <T> List<ColumnWithPath<T>> resolve(@NotNull BaseColumn<? extends T> $this, @NotNull ColumnResolutionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return ColumnReference.DefaultImpls.resolve((ColumnReference)$this, context);
        }
    }
}

