/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.navigation;

import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JsTestSelector;
import com.intellij.javascript.testing.JsTestFileByTestNamesIndexKt;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetector;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetectors;
import com.intellij.javascript.testing.navigation.JsTestNavigationItem;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a \u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"tryToFindTestStructureElementForNavigation", "Lcom/intellij/psi/PsiElement;", "testNames", "", "", "jsFile", "Lcom/intellij/lang/javascript/psi/JSFile;", "tryToCreateTestNavigationItem", "Lcom/intellij/javascript/testing/navigation/JsTestNavigationItem;", "indexKey", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJsTestNavigationItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsTestNavigationItem.kt\ncom/intellij/javascript/testing/navigation/JsTestNavigationItemKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1869#2,2:130\n*S KotlinDebug\n*F\n+ 1 JsTestNavigationItem.kt\ncom/intellij/javascript/testing/navigation/JsTestNavigationItemKt\n*L\n82#1:130,2\n*E\n"})
public final class JsTestNavigationItemKt {
    private static final PsiElement tryToFindTestStructureElementForNavigation(List<String> testNames, JSFile jsFile) {
        JsTestSelector suiteSelector = new JsTestSelector(testNames, true);
        JsTestSelector testSelector = new JsTestSelector(testNames, false);
        Iterable $this$forEach$iv = JsTestFrameworkDetectors.Companion.getDetectorsSortedByDetectionPriority();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsTestFrameworkDetector it = (JsTestFrameworkDetector)element$iv;
            boolean bl = false;
            AbstractTestFileStructure testFileStructure = it.findTestsStructure(jsFile);
            if (testFileStructure == null || testFileStructure.isEmpty()) continue;
            PsiElement testPsiElement = testFileStructure.findPsiElement(testSelector);
            if (testPsiElement != null && testPsiElement.isValid()) {
                return testPsiElement;
            }
            PsiElement suitePsiElement = testFileStructure.findPsiElement(suiteSelector);
            if (suitePsiElement != null && suitePsiElement.isValid()) {
                return suitePsiElement;
            }
            if (!testFileStructure.isBasedOnFrameworkImportChecking()) continue;
            return null;
        }
        return null;
    }

    @Nullable
    public static final JsTestNavigationItem tryToCreateTestNavigationItem(@NotNull String indexKey, @NotNull Project project, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)indexKey, (String)"indexKey");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        List<String> testNames = JsTestFileByTestNamesIndexKt.extractTestNamesFromIndexKey(indexKey);
        if (testNames == null) {
            return null;
        }
        List<VirtualFile> files = JsTestFileByTestNamesIndexKt.findTestFilesByIndexKey(indexKey, scope2);
        VirtualFile file = (VirtualFile)CollectionsKt.firstOrNull(files);
        if (file == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (!(psiFile instanceof JSFile)) {
            return null;
        }
        Icon icon = ((JSFile)psiFile).getIcon(0);
        JSFile jSFile = (JSFile)psiFile;
        Intrinsics.checkNotNull((Object)icon);
        return new JsTestNavigationItem(testNames, jSFile, icon);
    }

    public static final /* synthetic */ PsiElement access$tryToFindTestStructureElementForNavigation(List testNames, JSFile jsFile) {
        return JsTestNavigationItemKt.tryToFindTestStructureElementForNavigation(testNames, jsFile);
    }
}

