/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.jmx;

import java.util.Properties;
import javax.naming.InitialContext;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.jmx.HibernateServiceMBean;
import net.sf.hibernate.jmx.SessionFactoryStub;
import net.sf.hibernate.util.NamingHelper;
import net.sf.hibernate.util.PropertiesHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HibernateService
implements HibernateServiceMBean {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$jmx$HibernateServiceMBean == null ? (class$net$sf$hibernate$jmx$HibernateServiceMBean = HibernateService.class$("net.sf.hibernate.jmx.HibernateServiceMBean")) : class$net$sf$hibernate$jmx$HibernateServiceMBean));
    private String mapResources;
    private String boundName;
    private Properties properties = new Properties();
    static /* synthetic */ Class class$net$sf$hibernate$jmx$HibernateServiceMBean;

    public String getName() {
        return this.getProperty("hibernate.session_factory_name");
    }

    public String getMapResources() {
        return this.mapResources;
    }

    public void setMapResources(String mapResources) {
        this.mapResources = mapResources == null ? null : mapResources.trim();
    }

    public void addMapResource(String mapResource) {
        this.mapResources = this.mapResources == null || this.mapResources.length() == 0 ? mapResource.trim() : this.mapResources + ", " + mapResource.trim();
    }

    public String getDatasource() {
        return this.getProperty("hibernate.connection.datasource");
    }

    public void setDatasource(String datasource) {
        this.setProperty("hibernate.connection.datasource", datasource);
    }

    public String getDialect() {
        return this.getProperty("hibernate.dialect");
    }

    public void setDialect(String dialect) {
        this.setProperty("hibernate.dialect", dialect);
    }

    public String getJndiName() {
        return this.getProperty("hibernate.session_factory_name");
    }

    public void setJndiName(String jndiName) {
        this.setProperty("hibernate.session_factory_name", jndiName);
    }

    public boolean getUseOuterJoin() {
        String prop = this.getProperty("hibernate.use_outer_join");
        return Boolean.valueOf(prop);
    }

    public void setUseOuterJoin(boolean uoj) {
        this.setProperty("hibernate.use_outer_join", uoj ? "true" : "false");
    }

    public boolean getShowSql() {
        String prop = this.getProperty("hibernate.show_sql");
        return Boolean.valueOf(prop);
    }

    public void setShowSql(boolean showSql) {
        this.setProperty("hibernate.show_sql", showSql ? "true" : "false");
    }

    public String getUserName() {
        return this.getProperty("hibernate.connection.username");
    }

    public void setUserName(String userName) {
        this.setProperty("hibernate.connection.username", userName);
    }

    public String getPassword() {
        return this.getProperty("hibernate.connection.password");
    }

    public void setPassword(String password) {
        this.setProperty("hibernate.connection.password", password);
    }

    private String[] parseResourceList(String resourceList) {
        return PropertiesHelper.toStringArray(resourceList, " ,\n\t\r\f");
    }

    public void start() throws HibernateException {
        this.boundName = this.getJndiName();
        try {
            this.buildSessionFactory();
        }
        catch (HibernateException he) {
            log.info((Object)("Could not build SessionFactory using the MBean classpath - will try again using client classpath: " + he.getMessage()));
            log.debug((Object)"Error was", (Throwable)((Object)he));
            new SessionFactoryStub(this);
        }
    }

    public void stop() {
        log.info((Object)"stopping service");
        try {
            InitialContext context = NamingHelper.getInitialContext(this.getProperties());
            ((SessionFactory)context.lookup(this.boundName)).close();
        }
        catch (Exception e) {
            log.warn((Object)"exception while stopping service", (Throwable)e);
        }
    }

    SessionFactory buildSessionFactory() throws HibernateException {
        log.info((Object)("starting service at JNDI name: " + this.boundName));
        log.info((Object)("service properties: " + this.properties));
        Configuration cfg = new Configuration().addProperties(this.getProperties());
        String[] mappingFiles = this.parseResourceList(this.getMapResources());
        int i = 0;
        while (i < mappingFiles.length) {
            cfg.addResource(mappingFiles[i], Thread.currentThread().getContextClassLoader());
            ++i;
        }
        return cfg.buildSessionFactory();
    }

    public String getTransactionStrategy() {
        return this.getProperty("hibernate.transaction.factory_class");
    }

    public String getUserTransactionName() {
        return this.getProperty("jta.UserTransaction");
    }

    public void setTransactionStrategy(String txnStrategy) {
        this.setProperty("hibernate.transaction.factory_class", txnStrategy);
    }

    public void setUserTransactionName(String utName) {
        this.setProperty("jta.UserTransaction", utName);
    }

    public String getTransactionManagerLookupStrategy() {
        return this.getProperty("hibernate.transaction.manager_lookup_class");
    }

    public void setTransactionManagerLookupStrategy(String lkpStrategy) {
        this.setProperty("hibernate.transaction.manager_lookup_class", lkpStrategy);
    }

    public String getPropertyList() {
        return this.getProperties().toString();
    }

    public String getProperty(String property) {
        return this.properties.getProperty(property);
    }

    public void setProperty(String property, String value) {
        this.properties.setProperty(property, value);
    }

    protected Properties getProperties() {
        return this.properties;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

