// Copyright 2014 Google Inc. All Rights Reserved.
//
// Created by postproc-cld2 4.0 on 2014-01-31 09:59:13
// From command line:
//  --nearby_probs=3.4 --extra_entries=be-Cyrl bh-Deva bs-Latn hr-Latn
//  sr-Latn gl-Latn es-Latn id-Latn ms-Latn sv-Latn  --cld2 --cc
//  --just_read_raw --quad --standard --minchars=2 --mincount=2
//  --max_items_per_langscript=6000 --flatmap --rr_alloc --freq_alloc
//  --boostcloseweakerpercent=00 --indirectbits=16 --thresh=224 --v25
//  --kentries=160 --tablename=QuadChrome0122_16 --remap=xxx-Latn=>ut-Latn
//  tw-Latn=>ak-Latn nd-Latn=>nr-Latn blu-Latn=>hmn-Latn nn-Latn=>no-Latn
//  --include=af-Latn ar-Arab be-Cyrl bg-Cyrl bs-Latn ca-Latn cs-Latn
//  cy-Latn    da-Latn de-Latn el-Grek en-Latn es-Latn et-Latn fa-Arab
//  fi-Latn fr-Latn    ga-Latn gd-Latn hi-Deva hr-Latn hu-Latn id-Latn
//  is-Latn it-Latn iw-Hebr    ja-Hani ko-Hani lg-Latn lt-Latn lv-Latn
//  mk-Cyrl ms-Latn nl-Latn no-Latn    pl-Latn pt-Latn ro-Latn ro-Cyrl
//  ru-Cyrl rw-Latn sh-Cyrl sh-Latn sk-Latn sl-Latn sr-Cyrl    sv-Latn
//  sw-Latn th-Thai tl-Latn tr-Latn uk-Cyrl vi-Latn yi-Hebr    zh-Hani zh-TW
//  zhT-Hani    sq-Latn az-Latn eu-Latn bn-Beng gl-Latn ht-Latn mt-Latn
//  sr-Latn ur-Arab    bh-Deva mr-Deva ne-Deva lg-Latn rw-Latn gd-Latn
//  ut-Latn ut-Deva    ceb-Latn blu-Latn hmn-Latn jw-Latn    so-Latn ig-Latn
//  ha-Latn yo-Latn zu-Latn --ko_english --force_to_lang_soft --nosoft_cram2
//  --nomsidlevel --shapeflatprob --langpriorpercent=10 --skipnuc
//  --noshapeforcetop --noshapeeventop --noshapesteep2 --langcounts
//  --writebin --list_items=120 --max_langs_per_item=3
//  /hdb1/cld2/probs/p90_raw_quadgrams_2014.utf8
//
// CLD2_pslangs
//
// See compact_lang_det.cc for usage
//
#include "cld2tablesummary.h"
namespace CLD2 {

// For this build date, looking up 'qpdbmrmxyzptlkuuddlrlrbas' gives AZERBAIJANI
static const uint32 kQuadChrome0122_16BuildDate = 20140131;    // yyyymmdd


// Of 390154 offered items into 163840 table entries:
// 163724 filled (41%), 558 merged (0%), 225872 dropped (57%)

// Nil-grams: 19 languages
//     GREEK MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA PUNJABI
//     GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI CHEROKEE
//     SYRIAC LIMBU ORIYA INUKTITUT

// Uni-grams: 4 languages
//     Japanese Korean Chinese ChineseT

// Words/Quads: 67 languages in range ENGLISH..HMONG:
//     ENGLISH DANISH DUTCH FINNISH FRENCH GERMAN HEBREW ITALIAN
//     NORWEGIAN POLISH PORTUGUESE RUSSIAN SPANISH SWEDISH CZECH
//     ICELANDIC LATVIAN LITHUANIAN ROMANIAN HUNGARIAN ESTONIAN
//     BULGARIAN CROATIAN SERBIAN IRISH GALICIAN TAGALOG TURKISH
//     UKRAINIAN HINDI MACEDONIAN BENGALI INDONESIAN MALAY WELSH
//     NEPALI ALBANIAN BELARUSIAN JAVANESE URDU BIHARI ARABIC CATALAN
//     BASQUE SCOTS_GAELIC SWAHILI SLOVENIAN MARATHI MALTESE
//     VIETNAMESE SLOVAK AZERBAIJANI PERSIAN BOSNIAN ZULU YIDDISH
//     SOMALI MONGOLIAN AFRIKAANS YORUBA HAUSA HAITIAN_CREOLE
//     KINYARWANDA GANDA IGBO CEBUANO HMONG

// TopLanguage  TokenCount
//  ENGLISH 2200
//  DANISH 2244
//  DUTCH 2218
//  FINNISH 2205
//  FRENCH 2207
//  GERMAN 2182
//  HEBREW 2225
//  ITALIAN 2152
//  NORWEGIAN 2233
//  POLISH 2213
//  PORTUGUESE 2226
//  RUSSIAN 2139
//  SPANISH 3167
//  SWEDISH 3274
//  CZECH 4498
//  ICELANDIC 2205
//  LATVIAN 2201
//  LITHUANIAN 2202
//  ROMANIAN 4306
//  HUNGARIAN 2209
//  ESTONIAN 2212
//  BULGARIAN 2149
//  CROATIAN 3414
//  SERBIAN 5250
//  IRISH 2247
//  GALICIAN 3148
//  TAGALOG 2091
//  TURKISH 2231
//  UKRAINIAN 2167
//  HINDI 4330
//  MACEDONIAN 2156
//  BENGALI 2231
//  INDONESIAN 4024
//  MALAY 2752
//  WELSH 2214
//  NEPALI 2183
//  ALBANIAN 2210
//  BELARUSIAN 3189
//  JAVANESE 2218
//  URDU 2212
//  BIHARI 3621
//  ARABIC 2184
//  CATALAN 2236
//  BASQUE 2241
//  SCOTS_GAELIC 2255
//  SWAHILI 2232
//  SLOVENIAN 2223
//  MARATHI 2141
//  MALTESE 2245
//  VIETNAMESE 2200
//  SLOVAK 2227
//  AZERBAIJANI 2232
//  PERSIAN 2204
//  BOSNIAN 2783
//  ZULU 2208
//  YIDDISH 2154
//  SOMALI 2233
//  MONGOLIAN 15
//  AFRIKAANS 2208
//  YORUBA 2212
//  HAUSA 2238
//  HAITIAN_CREOLE 2225
//  KINYARWANDA 2199
//  GANDA 2273
//  IGBO 2175
//  CEBUANO 2006
//  HMONG 1978



// Recognized language-script combinations [69]:
static const char* const kQuadChrome0122_16RecognizedLangScripts =
  "af-Latn ar-Arab az-Latn be-Cyrl bg-Cyrl bh-Deva bn-Beng bs-Latn "
  "ca-Latn ceb-Latn cs-Latn cy-Latn da-Latn de-Latn en-Latn es-Latn "
  "et-Latn eu-Latn fa-Arab fi-Latn fr-Latn ga-Latn gd-Latn gl-Latn "
  "ha-Latn hi-Deva hmn-Latn hr-Latn ht-Latn hu-Latn id-Latn ig-Latn "
  "is-Latn it-Latn iw-Hebr jw-Latn lg-Latn lt-Latn lv-Latn mk-Cyrl "
  "mn-Latn mr-Deva ms-Latn mt-Latn ne-Deva nl-Latn no-Latn pl-Latn "
  "pt-Latn ro-Cyrl ro-Latn ru-Cyrl rw-Latn sk-Latn sl-Latn so-Latn "
  "sq-Latn sr-Cyrl sr-Latn sv-Latn sw-Latn tl-Latn tr-Latn uk-Cyrl "
  "ur-Arab vi-Latn yi-Hebr yo-Latn zu-Latn ";

static const uint32 kQuadChrome0122_16Size = 32768;    // Bucket count
static const uint32 kQuadChrome0122_16KeyMask = 0xffff8000;    // Mask hash key

static const IndirectProbBucket4 kQuadChrome0122_16[kQuadChrome0122_16Size] = {
  // hash_indirect[4], tokens[4] in UTF-8
   {{0xe9da0002,0xe2970003,0x7c2e0004,0x20078005}},	// [000] вка_, аат_, ssbr, _huni_,
   {{0x20078006,0x64438007,0xbddb0008,0x23bf0009}},	//   _kuni_, kuni, stèr, täjä_,
   {{0xddc4000a,0x6563800b,0x52e2800c,0x02e2800d}},	//   _križ, denh, _पर्स, _पर्न,
   {{0x6443800e,0x4916000f,0x63bb8010,0x20078011}},	//   duni, _प्रो_, jiun, _muni_,
   {{0x20078012,0x3ea08013,0x27ed8014,0x63a98015}},	//   _luni_, áit_, _dhen_, dhen,
   {{0x65638016,0x64438017,0x6fdd0018,0xef1f0019}},	//   genh, funi, léct, tjük_,
   {{0x6443801a,0x3ea0801b,0x2451801c,0x2007801d}},	//   guni, šit_, _cơm_, _nuni_,
   {{0x63bb801e,0xef1f0019,0x63a9801f,0x6fdd0020}},	//   giun, rjük_, ghen, néct,
   {{0x36678021,0x65638022,0xa3ab0023,0x2fc68024}},	//   _като_, benh, कोट_, mnog_,
   {{0x2fc68025,0x64438026,0x645e0009,0x20078027}},	//   lnog_, buni, _oppi, _buni_,
   {{0x2b9c0028,0x75288029,0x63bb802a,0x6aad002b}},	//   _tích_, _iedz, biun, zzaf,
   {{0x63a9802c,0x4ea7002d,0x63bb802e,0x2252002f}},	//   chen, арга, ciun, ktyk_,
   {{0x69dc0030,0x645e0031,0xadc38032,0x6b828033}},	//   _okre, _appi, _atẹn, _inog,
   {{0x6e240034,0x75288035,0x2b988036,0x20078037}},	//   _dwib, _jedz, _vécu_, _funi_,
   {{0x75288038,0x89378039,0xddc40024,0x212c8014}},	//   _medz, _כרגע_, _friž, madh_,
   {{0x2fc6803a,0x248d003b,0x212c803c,0xf699003d}},	//   jnog_, ćem_, ladh_, _منبع_,
   {{0x6b82803b,0x2fc68025,0x7afd803e,0xafb8003f}},	// [010] _mnog, dnog_, žstv, _خطوط_,
   {{0x212c803c,0x63bb802e,0x64438040,0x20078041}},	//   nadh_, ziun, yuni, _yuni_,
   {{0x6b828042,0x69d70043,0x65638044,0x27ed8045}},	//   _onog, roxe, venh, _phen_,
   {{0x212c8046,0x69dc0047,0xa8040048,0xc7c48049}},	//   hadh_, _ekre, ізіл, осчи,
   {{0x44310019,0x75288035,0x63a9804a,0x672b804b}},	//   lsz_, _bedz, vhen, ragj,
   {{0x27ed804c,0x6443804d,0x9474004e,0x26df804f}},	//   _when_, tuni, _ادیا, _vyuo_,
   {{0x63bb8012,0x65638050,0x2fc68024,0x27ed8051}},	//   tiun, renh, bnog_, _then_,
   {{0x2fc68052,0x65638053,0xa3ab0054,0x20078055}},	//   cnog_, senh, कोच_, _runi_,
   {{0xe9d98056,0x63a98057,0x64438058,0x29188059}},	//   лки_, rhen, suni, ıran_,
   {{0x212c803c,0x63bb805a,0x63a9805b,0x2007805c}},	//   gadh_, siun, shen, _puni_,
   {{0x63a9805d,0xa3d7005e,0x6616005f,0x8d748060}},	//   phen, ाका_, _styk, _باقا,
   {{0x44310061,0x66018062,0x6fdd002a,0xd5438032}},	//   dsz_, _hilk, xéct, _fẹ̀f,
   {{0x66018063,0xeab38064,0x7e6d0065,0x67298066}},	//   _kilk, _بعض_, _csap, _meej,
   {{0x2fc68067,0x212c8068,0x67298069,0xb21b006a}},	//   znog_, cadh_, _leej, _kræf,
   {{0x1015806b,0x64a3006c,0xfce6006d,0x7e6d006e}},	//   _ابتد, пара, сово, _esap,
   {{0x69dc006f,0xee3f003e,0x260a8006,0x67298070}},	//   _skre, brý_, ादमी_, _neej,
   {{0x2fc6803a,0x0aea0071,0x3a3f802a,0x28a58072}},	// [020] vnog_, удай_, nrup_, खनवि,
   {{0xa5bb0073,0x46db8074,0x31710037,0xda0a8075}},	//   ssór, _बड़ह, _cazz_, _हंसत_,
   {{0x2fc6803a,0xaad80076,0x75288029,0x7e7b8077}},	//   tnog_, _भुरक, _redz, _arup,
   {{0xbb860013,0x43860013,0xfdb0800f,0xa3e7800f}},	//   _الحي, _الحق, जफ्फ, _मील_,
   {{0x2fc68025,0x66018078,0x65948009,0x291e8079}},	//   rnog_, _bilk, жалу, ybta_,
   {{0x69dc007a,0x3a3f806a,0xdb16007b,0x8e57007c}},	//   _ukre, drup_, ábær, מינג_,
   {{0x2fc6805c,0x3860807d,0x66018079,0xe644807e}},	//   pnog_, _ćiro_, _dilk, ğlığ,
   {{0x5214807f,0xe6448059,0x79838080,0x53988081}},	//   одит, şlığ, _annw, рвия_,
   {{0x22400082,0x212c8083,0xa92a8084,0x6fc80085}},	//   nrik_, tadh_, ліне_, rıcl,
   {{0x388e8086,0xf96a8087,0x20098088,0x44310035}},	//   ləri_, урий_, _čair_, ysz_,
   {{0x212c803c,0x22400089,0x6729808a,0xdb0d008b}},	//   radh_, hrik_, _yeej, knað,
   {{0x212c808c,0x6601808d,0x212a008e,0x96f9008f}},	//   sadh_, _zilk, _lebh_, иент_,
   {{0x4ad80076,0x212c8090,0x9f588091,0x44310092}},	//   _भुलव, padh_, _burú_, wsz_,
   {{0x44310019,0x22400093,0x66018079,0x6d4a8094}},	//   tsz_, drik_, _xilk, ngfa,
   {{0x69da8095,0x79950063,0xe8d98028,0x69c88096}},	//   mote, _rozw, _đủ_, mnde,
   {{0x7ae28097,0x67d40098,0x22400099,0xdb0d007b}},	//   _kyot, _нощу, frik_, gnað,
   {{0x7995009a,0x44310019,0xddc2809b,0x7e6d009c}},	// [030] _pozw, ssz_, dvož, _usap,
   {{0x69da809d,0x672f0063,0x69c8809e,0x6441009f}},	//   note, lacj, nnde, àlis,
   {{0xe71980a0,0x439500a1,0x388e8085,0x644100a2}},	//   ليات_, _данс, fəri_, álid,
   {{0x644700a3,0x200a00a4,0xe00b80a5,0x672f0035}},	//   muji, _dubi_, _संसद_, nacj,
   {{0x69da80a6,0x660180a7,0x63ad00a8,0x7e7b8085}},	//   kote, _pilk, mhan, _qrup,
   {{0x63ad00a9,0x69da80aa,0xcfcf00ab,0xd6580039}},	//   lhan, jote, রতিন, ציות_,
   {{0x660180ac,0x645500ad,0x672f0063,0x200a0052}},	//   _vilk, ntzi, kacj, _gubi_,
   {{0x36d580ae,0xeb9980af,0x69c880b0,0x7e7b80b1}},	//   _добр, рии_, ende, _trup,
   {{0x660180b2,0xbfa880b3,0x7e7b80b4,0x69da80b5}},	//   _tilk, _утре_, _urup, fote,
   {{0x499980b6,0xfeb880b7,0x644700b8,0x3b1f80b9}},	//   ртия_, _طاقت_, kuji, sbuq_,
   {{0xa3e900ba,0xe2a88077,0x63ad00bb,0xfbd900bc}},	//   यता_, لاین_, khan, भकाम,
   {{0x69c880bd,0x9986809a,0x14d680be,0xaa5980bf}},	//   ande, _ktoś_, _וועל_, _виду_,
   {{0x63ad00c0,0x69da80c1,0xc8e600c2,0xddc400c3}},	//   dhan, bote, _कर्म_, _asiš,
   {{0x98a580c4,0xa0a580c5,0x7bc980c6,0x63ad00c7}},	//   _миле, _малд, lneu, ehan,
   {{0x09c400c8,0x63ad00c9,0x8b9600ca,0x3b9600a9}},	//   ্তমা, fhan, орач, ојат,
   {{0x63ad00cb,0x7bc980cc,0x2fcd80cd,0x7c3a00ce}},	//   ghan, nneu, _njeg_, štro,
   {{0xa3bb00cf,0x27e000d0,0x200a00d1,0x7c2900d2}},	// [040] _अगर_, _ikin_, _subi_, ćera,
   {{0x224000d3,0x0f2280d4,0x2b4f808e,0x2b58003d}},	//   rrik_, मर्स_, _lcgc_, _گیرد_,
   {{0xc8ca00d5,0x106a00d6,0x13a800d7,0x7bc980d8}},	//   جوان_, рией_, _هندی_, kneu,
   {{0x68e380d9,0x63ad00da,0xa3ae001b,0x69da80db}},	//   _mynd, chan, _कति_, zote,
   {{0xa3d700dc,0x27e000dd,0x69da80de,0x69c68061}},	//   ाकर_, _mkin_, yote, ékek,
   {{0x672f0063,0x200a00df,0x63a400e0,0x644100e1}},	//   zacj, _tubi_, lkin, šlie,
   {{0x07a680e2,0x6d4a80e3,0x7ae280e4,0x201800e5}},	//   _давн, rgfa, _syot, _utri_,
   {{0x63a400e6,0x7bc980e7,0x81e780ab,0xd32680e8}},	//   nkin, gneu, _মূল_, цьки,
   {{0x298a80e9,0x63a400ea,0xdcfe00eb,0xb21b00ec}},	//   асно_, ikin, _kopē, _græd,
   {{0x69c880ed,0x7ae2804f,0x2a6200ee,0x27e680ef}},	//   unde, _vyot, _mpkb_, llon_,
   {{0x200480f0,0x201880f1,0xdb060019,0x672f009a}},	//   _kimi_, ëri_, _elké, tacj,
   {{0x290780f2,0x63a400f3,0x69da80f4,0x27e680f5}},	//   _egna_, jkin, sote, nlon_,
   {{0x200480f6,0x672f0063,0xd25080f7,0x69da80f8}},	//   _mimi_, racj, _أنت_, pote,
   {{0x7bc080f9,0x200480fa,0x27e680fb,0x63ad00fc}},	//   limu, _limi_, hlon_, whan,
   {{0x63ad00fd,0x27e6803b,0x63a400fe,0x261080ff}},	//   than, klon_, fkin, _lào_,
   {{0x20048100,0x2a620101,0x64550102,0x52150103}},	//   _nimi_, _bpkb_, rtzi, здат,
   {{0x26108104,0xe8108105,0xdb0b8106,0x1dbc8107}},	// [050] _nào_, _ठंडा_, _umgå, ्चात,
   {{0x63ad0108,0x7bc08109,0xddc2809a,0x6447010a}},	//   shan, himu, rtoś, puji,
   {{0x672d010b,0x660d010c,0x63a4010d,0x7bc0810e}},	//   _keaj, _huak, bkin, kimu,
   {{0x63a40039,0xf093810f,0x261080ff,0x7bc08110}},	//   ckin, ונע_, _bào_, jimu,
   {{0xa3e40105,0x7bc08111,0xa77c00be,0x660500b9}},	//   _पीट_, dimu, יראפ, _kihk,
   {{0x98a5802e,0x5a340112,0x99640113,0x7bc98114}},	//   nală_, _інст, _отсл, wneu,
   {{0xdd8e80f7,0x22490102,0x20048115,0x27e68116}},	//   اوى_, luak_, _fimi_, blon_,
   {{0xd90e0117,0xdb028118,0x7bc08119,0xb21b006a}},	//   _لیے_, _eloí, gimu, _træd,
   {{0x76428036,0xdce3811a,0x2249011b,0x68e6811c}},	//   croy, menč, nuak_, əkdi,
   {{0x661b811d,0x63a4011e,0x2004811f,0xae44803d}},	//   _ituk, zkin, _zimi_, _آپلو,
   {{0x63a40120,0x7bc08121,0x660d0122,0x7bc98123}},	//   ykin, bimu, _auak, pneu,
   {{0xf7720124,0x6d410125,0x2249011b,0x6e298126}},	//   راج_, ólan, kuak_, _kweb,
   {{0xa3ca8127,0xa3c10128,0x290780ee,0x26108129}},	//   ोवर_, ्चन_, _tgna_, _xào_,
   {{0xdd920077,0x427a812a,0x67228024,0x7c29012b}},	//   روز_, _לאנג, zboj, ćern,
   {{0x63a4012c,0x27e6812d,0x69c1812e,0x9479012f}},	//   tkin, ylon_, mile, осту_,
   {{0x69c18130,0x6f098131,0xdce38132,0xfd4c8133}},	//   lile, _ngec, jenč, _belụ,
   {{0xc64a0013,0xeb970134,0x69c18083,0x6e298135}},	// [060] _اجعل_, чит_, oile, _nweb,
   {{0x20048136,0x63a40137,0xb6bb0051,0x867b012a}},	//   _simi_, skin, _לצפי, _פריו,
   {{0x63a40138,0x036a0139,0xfce6013a,0x661b813b}},	//   pkin, _линк_, _хоно, _atuk,
   {{0xb21b013c,0x69c1813d,0x2249013e,0x2d9a0039}},	//   _dræb, hile, buak_, _hope_,
   {{0x69c1813f,0x672280eb,0x7bc08110,0xddc98140}},	//   kile, rboj, vimu, _drež,
   {{0x6d4e0141,0x26108142,0x6d5c0143,0x76428144}},	//   ngba, _vào_, nfra, rroy,
   {{0x69c18145,0x6e298146,0x27e68147,0x20048148}},	//   dile, _eweb, plon_, _timi_,
   {{0x69de0149,0x7e6400d2,0x65ab0085,0x7642814a}},	//   lope, _opip, _müha, proy,
   {{0xadc38028,0x7bc0814b,0xe944803d,0x9d46814c}},	//   _quản, rimu, وردی, _неад,
   {{0x7bc0814d,0x69c1814e,0x6d4e00f3,0x69de014f}},	//   simu, gile, jgba, nope,
   {{0x7bc08150,0x672d0151,0x290a0135,0xe8df00ff}},	//   pimu, _peaj, _mgba_, _trục_,
   {{0x37ab0152,0xeb978153,0xd36f8154,0x660d00ee}},	//   стон_, _них_, _مهم_, _puak,
   {{0x69c18155,0x6d5c0156,0x69de0157,0xe3b38158}},	//   bile, ffra, kope, _אױף_,
   {{0x72eb8159,0x69c1815a,0xe9448077,0xf9c4815b}},	//   _פֿאַ, cile, _آرشی, _تحصی,
   {{0xd5c88104,0x98a58087,0x7c29012b,0xe7e8015c}},	//   yền_, rală_, ćero, _टीका_,
   {{0x2249011e,0x660d015d,0x290a015e,0x6d4e015f}},	//   tuak_, _tuak, _agba_, agba,
   {{0xb9990160,0xdce38161,0x98a58162,0x644a0163}},	// [070] овах_, venč, pală_, _åfin,
   {{0x5c070098,0x644a8164,0x22490102,0xc1788110}},	//   _няма, kufi, ruak_, ndė_,
   {{0x3ea60029,0xddc98165,0x661b8166,0x2249011b}},	//   _ļoti_, _prež, _stuk, suak_,
   {{0x69c18167,0x6443807a,0x65770168,0x290a0032}},	//   zile, vrni, _haxh, _egba_,
   {{0x69c18169,0x7bdf016a,0xee3880e8,0xddc98088}},	//   yile, moqu, зні_, _vrež,
   {{0x7bdf00a2,0x050100ab,0xddd6016b,0xfce5816c}},	//   loqu, ্রীর_, _kryš, моло,
   {{0x6458816d,0x200e8041,0x65770168,0x6443816e}},	//   gtvi, _nufi_, _maxh, urni,
   {{0x09b7816f,0x7bcd0170,0x22158171,0x64c50115}},	//   ेच्य, nnau, мфор, _ičić,
   {{0x69c18172,0x6d5c0114,0x661b8173,0xd24e8174}},	//   tile, yfra, _utuk, لني_,
   {{0x7bcd0175,0x23c38176,0x6d410177,0x10a58178}},	//   hnau, _bèjè_, ólal, дион,
   {{0x69c18179,0x5455817a,0xe3c2017b,0xf746017c}},	//   rile, _цвет, lmış_, мено,
   {{0x69c1817d,0xd24e817e,0x7c3a017f,0xe2918180}},	//   sile, دنی_, štrk, _لذت_,
   {{0x65b00181,0xe3c20182,0x6d5c0183,0x69c18184}},	//   _lähe, nmış_, tfra, pile,
   {{0x90c58185,0x7ae60186,0x65ab0074,0x69de0187}},	//   _обле, _rykt, _püha, xope,
   {{0xfce30188,0x6d5c0189,0x7bdf018a,0xa507018b}},	//   воро, rfra, foqu, дера_,
   {{0x8ffa003d,0x320f808e,0x764b818c,0x6441018d}},	//   _برتر_, _kugy_, kugy, ália,
   {{0xd5b20019,0x2fc0018e,0x7c248115,0x3207818f}},	// [080] _لفظ_, _imig_, ćiri, _kiny_,
   {{0xb1430190,0xa0a60191,0x320f810c,0x65ab0192}},	//   кнул, мазд, _mugy_, _hühn,
   {{0xeb9a0193,0x69de0194,0xb21b006a,0x8b260195}},	//   _дин_, rope, _præc, _одне,
   {{0xfaa60196,0x46ea80b3,0x201c00eb,0xddc98197}},	//   _жамо, оден_, īvi_, _ereż,
   {{0x65b00198,0xfe6f8199,0x05d20035,0x69de019a}},	//   _tähd, لدو_, _सदाब, pope,
   {{0x6458819b,0x443a019c,0x290a019d,0x644a819e}},	//   ttvi, _kvp_, _ugba_, tufi,
   {{0xd90d019f,0x910301a0,0x443a00c3,0x443801a1}},	//   _ایم_, _апре, _jvp_, nsr_,
   {{0xda088104,0x28bd01a2,0x645881a3,0x02a681a4}},	//   _hỏi_, ्परि, rtvi, дром,
   {{0x200e81a5,0x961880ab,0x6f09016b,0x6aa401a6}},	//   _sufi_, _ডটকম_, žeck, nyif,
   {{0x6e2281a7,0xb5aa81a8,0x443800b9,0x67d201a9}},	//   mpob, _بارك_, ksr_, vāja,
   {{0x26ee81aa,0xda0880ff,0xa3ae01ab,0x65ab0192}},	//   _जरुर_, _mỏi_, कसा_, _bühn,
   {{0xdce501ac,0x67d200eb,0x733681ad,0x338381ae}},	//   _pohľ, tāja, _آرائ, _аушв,
   {{0xa3e781af,0x799c01b0,0x7bdf01b1,0x200e80b9}},	//   _मीट_, _oorw, voqu, _wufi_,
   {{0x58d481b2,0x29070110,0xdb0b81b3,0x660881b4}},	//   _полт, žnai_, _algè, _jidk,
   {{0x7bdf00a9,0x66088079,0x9f588144,0xd13981b5}},	//   toqu, _midk, _juró_, _ххі_,
   {{0x26ee81b6,0x628281b7,0x67d200eb,0x53de816f}},	//   _जरूर_, _kroo, pāja, मविश,
   {{0x7bcd01b8,0x050100ab,0xddc981b9,0x799c01ba}},	// [090] rnau, ্রের_, _preż, _borw,
   {{0x51f801bb,0xaca301bc,0x2a6680ee,0xd13101bd}},	//   дную_, _arụg, _mpob_, اما_,
   {{0x753501be,0x200901bf,0x9f9c808b,0x443a01c0}},	//   mazz, _kiai_, tíð_, _gvp_,
   {{0x753501c1,0x65b001c2,0x6e2d01c3,0xa635804a}},	//   lazz, _vähe, _kwab, енді,
   {{0x59de81c4,0x628281c5,0x6e2d008e,0x799c01c6}},	//   नकार, _nroo, _jwab, _forw,
   {{0x753501b9,0x65b00006,0x9f588144,0xba430084}},	//   nazz, _tähe, _buró_, žįst,
   {{0x76598114,0x628281c7,0x3ea981c8,0x64c50088}},	//   stwy, _aroo, šat_, _učić,
   {{0x6f0d01c9,0x9f5881ca,0x6aca81cb,0xe3c201cc}},	//   _ngac, _duró_, ापूर, pmış_,
   {{0x753501cd,0xb4bc01ce,0x020581cf,0x67f601d0}},	//   kazz, _अध्_, нзин, náje,
   {{0xf9918013,0x628280c9,0x6b9d01d1,0x7c3a017f}},	//   ابة_, _droo, _losg, štri,
   {{0xa3c101d2,0xfc3080f7,0x2011004f,0x39588014}},	//   ्चा_, _نحن_, _juzi_, òrsa_,
   {{0x6e2d01d3,0x201101d4,0x69c501d5,0x248601d6}},	//   _bwab, _muzi_, hihe, _čom_,
   {{0xee3701d7,0x628281d8,0xa68301d9,0x6b8b81da}},	//   ння_, _groo, гляд, _ingg,
   {{0xceb281db,0x753501dc,0x7c2201dd,0x236d81de}},	//   נים_, gazz, _čorb, leej_,
   {{0x77a601df,0xdb0b80e7,0x69c501e0,0x6b9d01e1}},	//   _lóxi, _algé, dihe, _bosg,
   {{0xddcd01e2,0x63a981e3,0x2009001c,0x6b9d01e4}},	//   _graž, nken, _giai_, _cosg,
   {{0x6b6301e5,0xe8df801c,0x799c01e6,0x6b8b80dd}},	// [0a0] ыкта, _khỏi_, _porw, _mngg,
   {{0x61e181e7,0x753501e8,0x236d81e9,0x63a981ea}},	//   noll, cazz, heej_, hken,
   {{0x63a981eb,0x799c01ec,0x6b9d01e4,0x03a60087}},	//   kken, _vorw, _fosg, _зино,
   {{0x201100d2,0x63a981ed,0x644e01ee,0x61e181ef}},	//   _duzi_, jken, mubi, holl,
   {{0x61e181f0,0x63a9813c,0x99800110,0xdfcf81a8}},	//   koll, dken, usių_, حين_,
   {{0x6b8b81f1,0xdd9080f7,0x63a981f2,0xda088129}},	//   _angg, شوب_, eken, _tỏi_,
   {{0x186701f3,0x316c81ac,0x201101f4,0x61e181f5}},	//   _пари_, vedz_, _guzi_, doll,
   {{0x2a66808e,0x67d201a9,0x7c38800b,0x656e01f6}},	//   _ppob_, dājo, rsvr, hebh,
   {{0x645c01f7,0x644e01f8,0xdd8f81f9,0x6d4101fa}},	//   htri, hubi, _گول_, ólak,
   {{0x6b8b81fb,0x644e01fc,0xbddb01fd,0x6e2d00b4}},	//   _engg, kubi, trèm, _rwab,
   {{0xa3d001fe,0x753501ff,0x2d8c8200,0xd8f880e8}},	//   वचा_, vazz, _inde_, ьної_,
   {{0x645a8201,0x63a98202,0xe7cf00ab,0x657a8203}},	//   _iqti, cken, রত্য, _hath,
   {{0x657a8204,0x2d9e8205,0x61e18206,0xb5fb0207}},	//   _kath, _kote_, boll, ntág,
   {{0x61e18208,0xd12f8077,0xb21b013c,0x2d9e8168}},	//   coll, _همه_, _bræn, _jote_,
   {{0xddcd0209,0x753501cd,0x6b9d020a,0xa4d400e8}},	//   _traž, razz, _posg, горі,
   {{0x657a820b,0x6e2d020c,0x3ea6820d,0x25dc820e}},	//   _lath, _twab, kyot_, मकुण,
   {{0x245a820f,0x2d8c8210,0x75350211,0x21310176}},	// [0b0] hëm_, _onde_, pazz, _pezh_,
   {{0x657a8212,0xdb0d00f7,0x2d9e8213,0x3eb30214}},	//   _nath, mhaí, _note_, ıntı_,
   {{0xb21b0215,0x644e0216,0x69c50217,0x645c0218}},	//   _græn, cubi, rihe, ctri,
   {{0x44210219,0x201c021a,0x61fe021b,0x69c5021c}},	//   _ith_, ívia_, ampl, sihe,
   {{0x2d9e821d,0xe618821e,0x3ea6821f,0x8b9a0039}},	//   _bote_, еді_, gyot_, _חברת,
   {{0x7bc28220,0xbea28221,0x2d9e8222,0x644800eb}},	//   _amou, рашк, _cote_, šdie,
   {{0x61e18223,0x657a8224,0xeb998225,0xabd58226}},	//   voll, _dath, дий_, кциј,
   {{0x2d8c8227,0x77a60228,0xc1788110,0x657a8229}},	//   _ende_, _tóxi, klės_, _eath,
   {{0x61e1822a,0x853c8084,0xddcd022b,0x98ac81a9}},	//   toll, _plėt, _braż, vadā_,
   {{0x926480f7,0x236d822c,0xb5fb0118,0x777b811b}},	//   اديم, seej_, ntád, _haux,
   {{0xb604000d,0x645c022d,0xe80b8105,0x6b8b80dd}},	//   ntář, xtri, _सूखा_, _tngg,
   {{0x2d9e822e,0x6b8b822f,0x22490230,0x61e18231}},	//   _zote_, _ungg, krak_, soll,
   {{0x2d9e822e,0x61e18232,0x44210233,0x657a8234}},	//   _yote_, poll, _ath_, _yath,
   {{0x645c0235,0xa5bb0236,0x61458237,0x644e0238}},	//   ttri, spón, _река, tubi,
   {{0xb0248104,0x44210239,0xfce6006d,0x22490102}},	//   _trườ, _cth_, тово, erak_,
   {{0x1e86023a,0xf41380ab,0x764f023b,0x2c7c81d0}},	//   _алим, _সবার_, bucy, ládá_,
   {{0xc332804c,0x6d41803a,0x2619023c,0x644e023d}},	// [0c0] יון_, _odla, _यूपी_, subi,
   {{0xb21b0022,0x3f8d823e,0xa92480e1,0xe9d7023f}},	//   _træn, _aneu_, peľň, вку_,
   {{0x657a8240,0x2d9e8241,0x7e698242,0x7aeb8243}},	//   _rath, _rote_, _apep, _lygt,
   {{0x6d418244,0xdce88038,0x2d9e8245,0x22490246}},	//   _adla, _podľ, _sote_, brak_,
   {{0x2d9e8247,0xa3c10054,0x69c38248,0xeb970249}},	//   _pote_, ्चर_, _omne, _рия_,
   {{0x245a820f,0x2fc68110,0x44210101,0x7c3a024a}},	//   tëm_, siog_, _yth_, štru,
   {{0x6da3824b,0x6aca824c,0x629d8106,0x2d9e824d}},	//   рија, ाप्र, äson, _vote_,
   {{0x2d9e822e,0x6286024e,0x657a805d,0x8fa3824f}},	//   _wote_, _krko, _wath, _касе,
   {{0xe73781a1,0xa6658250,0xcb678251,0x2d9e8252}},	//   _шет_, _مطلو, тање_, _tote_,
   {{0x2d8c8012,0x657a80f7,0x601e80eb,0x62860253}},	//   _unde_, _uath, _līme, _mrko,
   {{0x31370039,0x7f590254,0x22490255,0x1cba8061}},	//   כנים_, нанс_, zrak_, _غائب_,
   {{0x97a70256,0x69c38257,0xdb0d00f7,0x1fa70258}},	//   трол, _emne, thaí, трог,
   {{0xecdb000f,0xdddb8259,0xa2c2025a,0x629601c0}},	//   _मुजफ, _hruš, _रेल्, jxyo,
   {{0xdddb825b,0x765d025c,0xdbd1808b,0x764f018e}},	//   _kruš, rtsy, lýðs, rucy,
   {{0xd5b8025d,0xb4ad025e,0xa3d680c2,0x81d800ab}},	//   тся_, कने_, _सदा_, াতা_,
   {{0x6286012b,0x644a81a8,0x7d080061,0x9cd7825f}},	//   _brko, irfi, _sérü, דולה_,
   {{0x27e90260,0x62848084,0x443c8088,0x777b8261}},	// [0d0] _ikan_, _šioj, hsv_, _raux,
   {{0x224900ad,0x69c88262,0x645a009f,0x23b180e1}},	//   rrak_, nide, àtic, _mája_,
   {{0x290700f2,0x62860263,0x981401a8,0x4cc10264}},	//   äna_, _erko, لبنا, _শুরু,
   {{0x63b60265,0x69c88266,0x75220267,0x22490268}},	//   chyn, hide, _đozi, prak_,
   {{0x69c88269,0x2509026a,0x3f8181d0,0xadc4026b}},	//   kide, _ترکی_, ěhu_, _arẹw,
   {{0x24858101,0x2b59026c,0x6d55026d,0xf483803d}},	//   _prlm_, _hcsc_, ngza, لاعی,
   {{0x27e9026e,0x61e5026f,0x69c88270,0x25a101d0}},	//   _okan_, mohl, dide, _mohl_,
   {{0x63ad0271,0xb5fb0272,0xdb098073,0xaca3019d}},	//   nkan, ntáb, nheç, _abịd,
   {{0x443e8273,0x1a65826a,0x7e69804f,0xb5fb0118}},	//   _evt_, ایتی_, _upep, itáb,
   {{0x27e90274,0x69c88275,0x63ad0057,0x6d418276}},	//   _akan_, gide, hkan, _udla,
   {{0xcea90158,0xcb558277,0x8fa60278,0x64410279}},	//   _צי_, _مناظ, гане, šlij,
   {{0x63ad027a,0x61e5027b,0x69c8827c,0x2619827d}},	//   jkan, hohl, aide, _kèo_,
   {{0x69c880ad,0xe1ee827e,0x200d8098,0xdddb827f}},	//   bide, _гг_, _miei_, _zruš,
   {{0x27e90280,0x63ad0281,0x237d8282,0x7bc98283}},	//   _ekan_, ekan, _hawj_, lieu,
   {{0x98ac8162,0xbb460284,0x225f8285,0x63b60286}},	//   radă_, левк, ltuk_, thyn,
   {{0x7bc98287,0xc0528051,0x63ad0288,0x62860289}},	//   nieu, _הזה_, gkan, _prko,
   {{0x225f828a,0xe1fa028b,0x63b6028c,0x6abb81ec}},	// [0e0] ntuk_, ега_, rhyn, nzuf,
   {{0x63ad028d,0x237d822c,0x6e240214,0x7c3e0115}},	//   akan, _lawj_, _itib, _tvpr,
   {{0x11d70013,0xdca6028e,0x9c7c828f,0x70560290}},	//   دولة_, _сани, _tyči, انصا,
   {{0x69c88291,0x63ad0292,0xee3a8293,0x237d8282}},	//   zide, ckan, енд_, _nawj_,
   {{0xdddb8067,0x443e816d,0x56948162,0x6da68294}},	//   _sruš, _svt_, ралт, лида,
   {{0x443e8295,0xdddb8296,0x2816003d,0x644a8088}},	//   _pvt_, _pruš, _موسس, trfi,
   {{0x657e0297,0xb5fb0298,0x66160299,0xdd32029a}},	//   _maph, ltác, _luyk, zəşt,
   {{0x657e029b,0x7bc9829c,0x7f440168,0x69c8829d}},	//   _laph, gieu, _ndiq, wide,
   {{0x69c8829e,0xb5fb029f,0x237d81c0,0x6e2402a0}},	//   tide, ntác, _dawj_, _ntib,
   {{0xd6cf8277,0x657e0234,0x27e682a1,0xb33b02a2}},	//   _عقل_, _naph, loon_, _moça,
   {{0x63ad02a3,0x0c2682a4,0xdddb82a5,0x6b9b82a6}},	//   ykan, _смен, _uruš, bjug,
   {{0x27e682a7,0x7bc980e7,0x7a868019,0x644101a9}},	//   noon_, cieu, _مشتم, šlik,
   {{0xb8eb82a8,0x199482a9,0x78ba8019,0x657e0234}},	//   _रे_, _валя, sztv, _baph,
   {{0x27e682aa,0x2d9c80f1,0x63a28074,0x2a79018e}},	//   hoon_, njve_, _hoon, _rssb_,
   {{0x63a282ab,0xf36702ac,0x63ad02ad,0x27e682ae}},	//   _koon, лтан, tkan, koon_,
   {{0x764b8286,0x25a102af,0x63a282b0,0x67f600e1}},	//   yrgy, _wohl_, _joon, pája,
   {{0x6d5a82b1,0x65ab0074,0x27e681b4,0x38c90019}},	// [0f0] _octa, _lühi, doon_, ھائی_,
   {{0x63ad02b2,0x63a282b3,0x26188105,0x2bc602b4}},	//   skan, _loon, _पढ़ी_, रोबा,
   {{0x44ce8086,0x27e682b5,0x63ad02b6,0xb5fb02b7}},	//   _nə_, foon_, pkan, ptáb,
   {{0x63a282b8,0xbddb00e7,0x27e682b9,0x61fc01ec}},	//   _noon, ssèd, goon_, _ehrl,
   {{0xd9f68076,0xb5fb02ba,0x6b9b826c,0x657e0234}},	//   ुगात_, ctác, vjug, _yaph,
   {{0xdcfa82bb,0xdca582bc,0x9f42016b,0x3a2900ee}},	//   _altı, иали, roké_, mpap_,
   {{0x63a282bd,0x290502be,0x9f42026f,0x27e681b4}},	//   _boon, _àla_, soké_, boon_,
   {{0x44ce82bf,0xc24582c0,0x225f8061,0x2619827d}},	//   _də_, аник, ttuk_, _tèo_,
   {{0x63a282c1,0x7bc982c2,0x6d4502c3,0x7e6d02c4}},	//   _doon, rieu, _odha, _npap,
   {{0xb5fd803b,0x7bc982be,0x7e7b82c5,0xaca3026b}},	//   _opši, sieu, _isup, _abọd,
   {{0x7e6d02c6,0xe8f682c7,0x63a282c8,0x225f82c9}},	//   _apap, иль_, _foon, stuk_,
   {{0x6d4502ca,0x8e8602cb,0x657e02cc,0x63a281b4}},	//   _adha, агме, _saph, _goon,
   {{0x7c2502cd,0x69c702ce,0x44258088,0x2bb880f7}},	//   _athr, _omje, _htl_, _حالة_,
   {{0x63a282cf,0x44ce811c,0x291f02d0,0x27e682d1}},	//   _zoon, _yə_, _şuan_, zoon_,
   {{0x63a282d2,0x4174803d,0xab5d81b9,0x88838019}},	//   _yoon, _دانس, viżj, _ایجن,
   {{0x032602d3,0x65b001ec,0x657e0234,0x7e7b82d4}},	//   рдан, _zähl, _waph, _osup,
   {{0x3f9202d5,0x6a830087,0x98b102d6,0x442582d7}},	// [100] _inyu_, олта, _dezč_, _ltl_,
   {{0x27e682d8,0x2a6002d9,0xd94602da,0x628402db}},	//   woon_, rtib_, режи, rvio,
   {{0x7e7b802e,0xe73a82dc,0x27e682dd,0x67f601ac}},	//   _asup, вее_, toon_, nájo,
   {{0xd62a82de,0x753c0035,0xc6a682df,0xb6cb8019}},	//   воде_, larz, ирли, ھانے_,
   {{0x27e682e0,0x63a282e1,0x644182e2,0xfe7282e3}},	//   roon_, _roon, _avli, تدا_,
   {{0xbebb020f,0x27e682e4,0x224002e5,0x798181c0}},	//   mbët, soon_, msik_, jdlw,
   {{0x442582e6,0x63a282e7,0x224002e8,0x7e7b82e9}},	//   _ctl_, _poon, lsik_, _esup,
   {{0x44ce82ea,0xafe382eb,0x7bd602ec,0x67f880e1}},	//   _və_, _досл, nnyu, bíja,
   {{0x753c009a,0x6441807e,0x201802ed,0xe57a82ee}},	//   karz, _evli, _huri_, _иза_,
   {{0x1daa82ef,0x201802f0,0x63a282d8,0x65ab02f1}},	//   _कवित, _kuri_, _woon, _tühi,
   {{0x201802f2,0x63a282f3,0x753c009a,0xdcfa8176}},	//   _juri_, _toon, darz, _katč,
   {{0x201802f4,0xc4778051,0x224002f5,0x65b002af}},	//   _muri_, _כתבו_, ksik_, _wähl,
   {{0x95cb00b3,0x539b82f6,0x6d4502f7,0x442580e5}},	//   вува_, _שידו, _pdha, _ztl_,
   {{0x6d5882f8,0xdb0d0187,0x6703016f,0x753c02f9}},	//   ngva, lhaç, रेषक_, garz,
   {{0x201802fa,0xb21b013c,0x8bc702fb,0x442502fc}},	//   _nuri_, _træk, асад, ël_,
   {{0x69c702fd,0xf77f0187,0x7e6282fe,0x473502ff}},	//   _smje, moço_, ktop, _унис,
   {{0x7e628042,0x20180300,0x2fc90229,0x7c2d8301}},	// [110] jtop, _auri_, _imag_, ćari,
   {{0xdce181e2,0x201802a0,0x673d0302,0x6d450303}},	//   _galė, _buri_, lasj, _udha,
   {{0x20180304,0x4dda01c6,0x67030305,0x7e7b8306}},	//   _curi_, _תחתו, रेरक_, _ssup,
   {{0x9f058307,0x44258308,0x64550309,0x61e8803e}},	//   موضو, _rtl_, muzi, hodl,
   {{0x6455030a,0x7bcd0110,0xd244002e,0x2d810074}},	//   luzi, miau, _мэри, _kahe_,
   {{0x69c7030b,0x2d83030c,0x7bcd01e2,0x5187030d}},	//   _umje, ndje_, liau, _тума,
   {{0x2018030e,0xf773830f,0x673d0310,0x64550311}},	//   _guri_, _وار_, kasj, nuzi,
   {{0x224d8312,0x7e7b809c,0x7bcd0110,0x3219016b}},	//   trek_, _tsup, niau, _kusy_,
   {{0x20180313,0xa3af0006,0x6aad0314,0x27ed8315}},	//   _zuri_, _कवन_, nyaf, _iken_,
   {{0x224d811e,0x64550316,0x3f800317,0x2d8300f3}},	//   rrek_, kuzi, _saiu_, jdje_,
   {{0xe73a0318,0x600a0319,0x480a031a,0x7bcd031b}},	//   лен_, лном_, леон_, kiau,
   {{0x6455031c,0x25a5831d,0x753c009a,0x224d831e}},	//   duzi, _holl_, warz, prek_,
   {{0xa969831f,0x21698320,0x25a5816d,0x4ac70321}},	//   _била_, _били_, _koll_, _रेलव,
   {{0x2d8302fd,0x63bb8322,0x2fc90162,0x41268323}},	//   gdje_, lhun, _emag_, _лошо_,
   {{0x27ff8324,0x27ed8325,0xa34a0098,0x2d810326}},	//   _ohun_, _oken_, лзва_, _dahe_,
   {{0xb4e80327,0x7bcd0110,0x3f920101,0x20180314}},	//   _बडी_, giau, _unyu_, _ruri_,
   {{0xe2970328,0x17570039,0xb1460329,0x2018032a}},	// [120] бат_, _הספר_, йнал, _suri_,
   {{0x645c832b,0x2018032c,0x6455032d,0x2240032e}},	//   _årig, _puri_, buzi, rsik_,
   {{0x6c860013,0x27ff832f,0x64550330,0x63bb805d}},	//   _الجم, _bhun_, cuzi, khun,
   {{0x44440331,0x27ff8332,0xb5fb0333,0x7bcd0334}},	//   _iv_, _chun_, ntán, ciau,
   {{0x63bb8335,0x44440336,0x20180337,0xb5fb0118}},	//   dhun, _hv_, _wuri_, itán,
   {{0x6b840338,0x20180339,0x27ed833a,0x3f80833b}},	//   ldig, _turi_, _eken_, žiu_,
   {{0x7e62833c,0x31cd80c8,0x628b833d,0x44440077}},	//   stop, রকাশ, _argo, _jv_,
   {{0x63bb833e,0xd544826b,0x3a26833f,0x2d830340}},	//   ghun, _bẹ̀w, _ptop_, zdje_,
   {{0x44440341,0x67d20341,0xa5bb00f7,0xd13080f7}},	//   _lv_, nāju, spói, ومة_,
   {{0x44440342,0x361b8039,0x2fc90343,0x67240344}},	//   _ov_, _עובד, _smag_, _afij,
   {{0xd90d803d,0x673d00e8,0x2d83026c,0x63bb8345}},	//   نیه_, tasj, vdje_, bhun,
   {{0x63bb8346,0x753a80f3,0xf8b30039,0x61e88347}},	//   chun, _hetz, פשר_, sodl,
   {{0x44440348,0x673d00e8,0x6b840349,0x2d81008e}},	//   _av_, rasj, ddig, _pahe_,
   {{0x753a834a,0x6455034b,0xb21b013c,0x4444034c}},	//   _jetz, tuzi, _kræv, _bv_,
   {{0x7bcd034d,0x63a6034e,0x2d83034f,0x32190350}},	//   tiau, _bokn, rdje_, _susy_,
   {{0x44440351,0x753a8352,0x64550098,0xddc40353}},	//   _dv_, _letz, ruzi, _vpiš,
   {{0x6d488354,0x7bcd01e2,0x6e360355,0x67d201a9}},	// [130] _odda, riau, _gwyb, gāju,
   {{0x753a82af,0x213e8229,0x6b828356,0x44440357}},	//   _netz, nath_, _laog, _fv_,
   {{0xddc4003a,0x63bb8358,0x6aad0359,0x27ff80ff}},	//   _upiš, yhun, syaf, _phun_,
   {{0x25a58352,0x64c3835a,0x6d48835b,0x6b82835c}},	//   _soll_, _वेगळ, _adda, _naog,
   {{0xb5fd835d,0x25a5835e,0x9599835f,0x2c618035}},	//   _opšt, _poll_, итку_, wód_,
   {{0x4444011e,0x7afd0360,0x2bb18361,0x6b828362}},	//   _yv_, _izst, जस्थ, _aaog,
   {{0x44440363,0x65b00364,0x63bb805d,0x25a581ec}},	//   _xv_, _sähk, thun, _voll_,
   {{0x2c61809a,0x6d488365,0x27ed804a,0x628b81f4}},	//   ród_, _edda, _uken_, _prgo,
   {{0x60250110,0xb21b0366,0x25a58367,0x7d000032}},	//   _dėme, _usæd, _toll_, _kárí,
   {{0x63bb8368,0x628b8369,0x776d036a,0x3eb2804a}},	//   shun, _vrgo, _abax, øyte_,
   {{0xc952036b,0x6b84036c,0xa3e9036d,0x673b836e}},	//   ומי_, ydig, मका_, _keuj,
   {{0x628b836f,0xe3b381bd,0x661b8364,0x64438370}},	//   _trgo, _عرض_, _kuuk, msni,
   {{0x61458371,0x63a60372,0x69cf8373,0xd9458374}},	//   _дела, _rokn, éces, _дели,
   {{0x67d200eb,0xb5fb0375,0x6d410376,0x63a60377}},	//   vāju, stán, ólap, _sokn,
   {{0x8fa60003,0xd5e4019d,0xdb1d016d,0x64438378}},	//   _маке, _arị, _omsä, nsni,
   {{0x44440379,0x67d20029,0x6b84037a,0x333f80e7}},	//   _vv_, tāju, udig, naux_,
   {{0x9f5f8028,0x65b0037b,0x7983837c,0xdce381d0}},	// [140] _thuê_, _lähi, _kanw, teně,
   {{0xb5fb037d,0x4444037e,0x6b84037f,0xa7fd0380}},	//   ntál, _tv_, sdig, ntın,
   {{0xef1a8381,0xdce18029,0x79838382,0xdb060168}},	//   аме_, _dalī, _manw, _kokë,
   {{0xf1bf0065,0x6d5c0383,0x753a8384,0xbddb0385}},	//   _után_, lgra, _setz, nsèn,
   {{0x25e68076,0x3e640386,0x2b400387,0x644100e1}},	//   टवली_, nöt_, maic_, šlit,
   {{0x27388028,0x67228388,0x6b828014,0xc7b98061}},	//   ẩn_, scoj, _saog, _elő_,
   {{0xe73a8389,0x2636809a,0x68300032,0x6e29838a}},	//   _веб_, sło_, _dòdò, _eteb,
   {{0x66e6838b,0xdee6838c,0x0b8a838d,0x7983838e}},	//   _доба, _доби, рски_, _aanw,
   {{0x7983838f,0x386d0390,0xed5a8391,0xdfcf8174}},	//   _banw, _ćeri_, _воз_, _شيك_,
   {{0x6d48813c,0x6d5c0392,0x3f84804f,0x23b88036}},	//   _udda, jgra, _hamu_, _déja_,
   {{0x3f848393,0x213e8394,0x6d5c0395,0xd7fb0396}},	//   _kamu_, rath_, dgra, иум_,
   {{0xa2cb835a,0x3f848397,0x333f80e7,0x442e8398}},	//   _तेव्, _jamu_, caux_, mpf_,
   {{0xdefb0196,0x64588399,0x22948081,0x79838286}},	//   рын_, luvi, _хиля, _fanw,
   {{0x69ca839a,0x6d5c039b,0x2918039c,0xe2a98180}},	//   _umfe, ggra, _ngra_, _دامن_,
   {{0x5ba7039d,0xe0d480be,0x602181a9,0x3b280133}},	//   ораз, _מײַ_, _tēma, _ọyị_,
   {{0x6d5c0013,0x3f84839e,0xdce180eb,0xdb0f0333}},	//   agra, _namu_, _salī, _alcá,
   {{0x1ddb81fe,0xdce18029,0x2bbc0076,0x201c82f1}},	// [150] _बदलत, _palī, _ईतरा, _huvi_,
   {{0x69da839f,0x64438370,0x645883a0,0x7afd808b}},	//   nnte, ysni, kuvi, ýsti,
   {{0x65ab02af,0x6e2983a1,0xb5fb03a2,0x3f8483a3}},	//   _führ, _steb, ntám, _bamu_,
   {{0xd47a0158,0xa3af03a4,0xb5fb0019,0x2cac0106}},	//   _פארל, _कवि_, ztál, ädde_,
   {{0x333f82be,0x7afd00eb,0x3f8483a5,0x539a0039}},	//   vaux_, _uzst, _damu_, _הירו,
   {{0x644383a6,0x201c83a7,0xdb0403a8,0xa7fd0085}},	//   tsni, _ouvi_, chiñ, xtın,
   {{0x201c8358,0x333f80e7,0x21ef01ec,0x9f3583a9}},	//   _nuvi_, taux_, bühr_, _неві,
   {{0x69da83aa,0x644383ab,0x79838091,0x3a3903ac}},	//   ente, rsni, _sanw, _kwsp_,
   {{0x644380f2,0x6d5c03ad,0x798382f7,0x333f80e7}},	//   ssni, ygra, _panw, raux_,
   {{0x644381e2,0x3f8483ae,0x65b00074,0x69da83af}},	//   psni, _zamu_, _tähi, gnte,
   {{0xb5fb03b0,0x7c2d83b1,0x6d5c0289,0x798383b2}},	//   rtál, ćars, vgra, _vanw,
   {{0xb5fb03b3,0x2d8583b4,0xbebb0168,0x201c802a}},	//   stál, _hale_, rcën, _duvi_,
   {{0x2d8583b5,0xa2cb03b6,0xcaea03b7,0x19958081}},	//   _kale_, _सेल्, _झुंड_, _надя,
   {{0x2d8583b8,0xda1f0105,0x6d5c03b9,0x2d8783ba}},	//   _jale_, _बढ़त_, ugra, ndne_,
   {{0x9f9203bb,0x64a603bc,0xdb060168,0x224682d4}},	//   lší_, чава, _tokë, _zvok_,
   {{0x422603bd,0x225203be,0xa7fd03bf,0x65618122}},	//   здав, tryk_, ntıl, _lclh,
   {{0x27e003c0,0x6e4600f7,0x9f9203c1,0x6d5c03c2}},	// [160] _ijin_, _عندم, nší_, pgra,
   {{0x3f8483c3,0x2b4003c4,0xb46603c5,0x2d8581f6}},	//   _samu_, saic_, _екол, _nale_,
   {{0xe1ff00a9,0x764603c6,0x9d1b00be,0x628f01e8}},	//   _após_, lsky, _לויט, _erco,
   {{0x205503c7,0xdc9b03c8,0x3f8683c9,0x6ecd83ca}},	//   ьтур, _היטל, udou_, _देहु,
   {{0x9f9203cb,0x764603cc,0x3f8683cd,0xa3e900d4}},	//   jší_, nsky, rdou_, मकर_,
   {{0x645883ce,0x63b603cf,0xa6db007b,0x2d8583d0}},	//   tuvi, lkyn, naða, _cale_,
   {{0x80d080c8,0x69ce03d1,0x3f8483d2,0xddc98162}},	//   _সুন্, _imbe, _tamu_, _speţ,
   {{0x69dd83d3,0x63a403d4,0x645883d5,0xb21b0366}},	//   ésen, njin, ruvi, _græs,
   {{0x2d8583d6,0x201c83d7,0x7d028032,0x6b8603d8}},	//   _fale_, _suvi_, _bírí, _makg,
   {{0x764603d9,0x69da83da,0x27e00300,0x7d070036}},	//   dsky, unte, _ajin_, néré,
   {{0x69ce00dd,0x261583db,0x69da83dc,0xf99301c6}},	//   _mmbe, _फूटी_, rnte, גרת_,
   {{0x09b903dd,0x6028801b,0x78fb03de,0x2d8583df}},	//   _इत्य, _něme, מפיו, _zale_,
   {{0x69ce03e0,0x443a03e1,0x9f4b0216,0x764603e2}},	//   _ombe, _awp_, nocé_, gsky,
   {{0x7afd83e3,0x9f42016b,0x7d02826b,0x442c83e4}},	//   üste, roká_, _gírí, _ktd_,
   {{0x9f42026f,0x6b8603e5,0x7d0703e6,0x628f00c3}},	//   soká_, _bakg, déré, _srco,
   {{0x27e003e7,0x63a400f1,0xa3bc03e8,0x087783de}},	//   _gjin_, gjin, _अतः_, _זעהט_,
   {{0x3edf0135,0xdcf200eb,0x6b8603e9,0x442c81c6}},	// [170] _kpọọ_, īgāk, _dakg, _ltd_,
   {{0x6e2d03ea,0xceb200be,0xaca301bc,0xbba983eb}},	//   _itab, _סיי_, _asụg, _छक्क,
   {{0xb21b013c,0x2d8583ec,0x673f03ed,0xa3be8035}},	//   _præs, _rale_, _keqj, ीफा_,
   {{0x69ce03ee,0x64550289,0x2d8583ef,0x256f807e}},	//   _embe, mrzi, _sale_, zılı_,
   {{0xd2468065,0x644883f0,0x442c83f1,0x256f8214}},	//   _جن_, _avdi, _atd_, yılı_,
   {{0xcb120051,0x645501ed,0x9f9203f2,0x68f500e1}},	//   _שלך_, orzi, vší_, _tyzd,
   {{0x2d8583f3,0xac09827e,0x628283f4,0x2d8783f5}},	//   _vale_, онка_, _asoo, rdne_,
   {{0x2d8583f6,0x9f92001b,0x6e2d03f7,0x395e80eb}},	//   _wale_, tší_, _otab, egts_,
   {{0xfe7083f8,0x2d8583f9,0x2a6903fa,0x6e2d02a0}},	//   _مدل_, _tale_, ntab_, _ntab,
   {{0x9f9203fb,0x3ce8809a,0x27f203fc,0xab5b0192}},	//   rší_, _चुके_, _skyn_, _flüg,
   {{0x6d4383fd,0xd37180f7,0xdddb805c,0x6e2d03fe}},	//   mana, _لها_, _kruž, _atab,
   {{0x65b003ff,0x9f920400,0x2a690401,0x7bc08402}},	//   _läht, pší_, ktab_, chmu,
   {{0xb8f48403,0xa6db008b,0x443a0404,0xdcfa8162}},	//   _से_, taða, _swp_, _tată,
   {{0x79870063,0x76460405,0x65b00406,0x273c0028}},	//   _najw, rsky, _näht, ận_,
   {{0xdddb8025,0x6e2d0407,0x76460408,0x69c18409}},	//   _oruž, _etab, ssky, mhle,
   {{0x6d43840a,0x6b89840b,0x6f1b840c,0xeb97040d}},	//   hana, ndeg, _nguc, мис_,
   {{0x59e1824c,0xdb0b840e,0x63ab840f,0x63a680f2}},	// [180] _पदार, _algú, _mogn, ökni,
   {{0x6d438410,0x69c18234,0x63b60411,0x63a40412}},	//   jana, nhle, skyn, sjin,
   {{0x6d438413,0x657c0414,0x628b0106,0x7bc78084}},	//   dana, merh, ågor, _įjun,
   {{0x645c0415,0xdd8f8416,0x657c0417,0x3fbe80ab}},	//   muri, یون_, lerh, েক্ষ,
   {{0x6d438418,0xdddb8419,0x4cd300ab,0x7988831d}},	//   fana, _druž, _দুপু, yddw,
   {{0x69ce041a,0x657c02af,0x442c83ac,0x63ab8362}},	//   _umbe, nerh, _ptd_, _aogn,
   {{0x645c041b,0x442c841c,0x69c1841d,0x644d81a9}},	//   nuri, _qtd_, dhle, ņain,
   {{0x63ab841e,0xdddb841f,0x6d438420,0x6b898421}},	//   _cogn, _gruž, aana, gdeg,
   {{0x657c0422,0x645c0423,0xe7bd8424,0x52148425}},	//   kerh, huri, ्फरप, ндит,
   {{0x645c0426,0x442c808e,0x69c18427,0x657c0144}},	//   kuri, _ttd_, ghle, jerh,
   {{0x39570051,0x6e20820f,0x79888428,0x63ab8429}},	//   ושים_, _humb, rddw, _fogn,
   {{0x6e20842a,0x628281c5,0xe29a81e2,0x26c681c0}},	//   _kumb, _tsoo, _мае_, ozoo_,
   {{0xdce881e2,0xdde2042b,0x6e20842c,0x26c68144}},	//   _padė, _šušk, _jumb, nzoo_,
   {{0xceb38158,0xe0cf8416,0x645c042d,0x69c1842e}},	//   דיש_, ازی_, furi, chle,
   {{0x67d5042f,0x6e208430,0xb5fb00f7,0xdb060019}},	//   _поку, _lumb, ntái, _elkü,
   {{0x6d438431,0x2a690432,0x2cac0106,0x7c220088}},	//   zana, ttab_, ädda_, _čort,
   {{0x657c0433,0x6e208434,0x6e2d0435,0x65950436}},	// [190] berh, _numb, _utab, _запу,
   {{0x645c0437,0x6d438438,0x765d0439,0x4905801b}},	//   buri, xana, musy, हेको_,
   {{0xdddb812b,0x2a690006,0x6d43843a,0x765d043b}},	//   _pruž, stab_, vana, lusy,
   {{0x6d43843c,0x2a690242,0x93c90019,0xef1982a6}},	//   wana, ptab_, _راجہ_, _każi_,
   {{0xcb360051,0x65b0043d,0x6e20843e,0x6d43843f}},	//   _ראשי_, _täht, _cumb, tana,
   {{0x63ab8440,0xa2bf0441,0x9f4d8229,0x44210442}},	//   _sogn, लैण्, _cheò_, _kuh_,
   {{0x6d438443,0x442101d6,0x22490444,0x67298197}},	//   rana, _juh_, lsak_, _tfej,
   {{0x6d438445,0x65b002af,0x765d0446,0x26c6822c}},	//   sana, _jähr, kusy, bzoo_,
   {{0x6d438447,0x645c8448,0x6b898449,0x6e20844a}},	//   pana, _årin, rdeg, _gumb,
   {{0x645c044b,0x6d43844c,0x9f4d8362,0x6b89844d}},	//   yuri, qana, _gheò_, sdeg,
   {{0x657c044e,0xe8f9844f,0x6d4180eb,0x67248450}},	//   verh, яло_, _iela, žije,
   {{0xf0920451,0x6d418452,0x22490453,0x657c0454}},	//   אנט_, _hela, ksak_, werh,
   {{0x6d418455,0x657c0456,0x3e6980e1,0xe3c20457}},	//   _kela, terh, nút_, nlış_,
   {{0x6d418458,0x92c18459,0x9aa4845a,0xdd92045b}},	//   _jela, ığın, _جمهو, دوس_,
   {{0x6d41845c,0xfce3045d,0xddcd0087,0x6603045e}},	//   _mela, горо, _spaţ, упра,
   {{0x6d41845f,0xa2d48076,0x645c0460,0x765d0461}},	//   _lela, _बेड्, ruri, busy,
   {{0xf41280be,0x22490462,0x02060463,0xdb060242}},	// [1a0] רפן_, gsak_, езан, _alkò,
   {{0x6d418464,0x645c0465,0xe889801c,0x442100ee}},	//   _nela, puri, _kẻ_, _fuh_,
   {{0x6e208397,0x65b001ec,0xdddb8035,0x21f40192}},	//   _sumb, _fähr, _druż, fähr_,
   {{0xa2cb0466,0xfaa60467,0xfe468468,0xe6668469}},	//   _सेक्, _замо, ендо, етко,
   {{0xe889801c,0x394580eb,0x98ac0085,0x91b48035}},	//   _lẻ_, kals_, ğlıq_, ेसमै,
   {{0xe5a3846a,0x6d4182ad,0x7bd6046b,0x98ac0085}},	//   личи, _cela, liyu, şlıq_,
   {{0x6d41846c,0x8d1a8065,0xdbe3046d,0x26c681c0}},	//   _dela, _ہزار_, _béèn, szoo_,
   {{0xb5fb00f7,0x6d4182f1,0x51200054,0x8aa6846e}},	//   rtái, _eela, _बलुआ_, ерод,
   {{0xb5fb0013,0x6d41846f,0x66e38470,0x6aa40118}},	//   stái, _fela, _бота, nxif,
   {{0x64a68471,0xb5ca8065,0x39458472,0x7afd8085}},	//   _паза, _عوام_, gals_, üsta,
   {{0x815700be,0x3f890473,0xdb12007b,0x7c218474}},	//   עסטע_, _paau_, _ágæt, _gulr,
   {{0xfa888142,0x6d418102,0x765d0475,0xb5fb0476}},	//   _từ_, _zela, tusy, ntáv,
   {{0x42db00ab,0x7d278106,0x44210477,0x6d418478}},	//   _দর্শ, _årså, _suh_, _yela,
   {{0x39458479,0x661a847a,0x9f4b001b,0x4421047b}},	//   cals_, _jitk, mocí_, _puh_,
   {{0x317e80cd,0x6286047c,0xb3a4847d,0x7bd6008e}},	//   metz_, _asko, _खचाख, fiyu,
   {{0x7bc4047e,0x7bdf047f,0x22490480,0xdcf88088}},	//   ghiu, unqu, tsak_, jevč,
   {{0x66d38065,0x9f4b0388,0x443e82f7,0xd2510481}},	// [1b0] _műkö, nocí_, _lwt_, شنا_,
   {{0x661a8482,0x44210483,0xd8e70484,0x65b002af}},	//   _nitk, _tuh_, нцеп, _währ,
   {{0x62860485,0x6d470486,0x20090028,0x22490487}},	//   _esko, maja, _khai_, ssak_,
   {{0x6d41845c,0x6d470393,0x200901c0,0x7bc40488}},	//   _sela, laja, _jhai_, chiu,
   {{0x661a8489,0x6b9d048a,0xdb0b80f1,0x69dd8019}},	//   _bitk, _insg, _vogë, ések,
   {{0x6d47048b,0xb90700c8,0xdce88029,0x443e848c}},	//   naja, _পর_, _gadī, _bwt_,
   {{0x63af02a5,0xab5b02af,0x80d080ab,0x644a848d}},	//   _kocn, _glüc, _সুস্, gsfi,
   {{0xe8898028,0x69d701df,0x6d470353,0x6d41848e}},	//   _rẻ_, lixe, haja, _wela,
   {{0x6d41848f,0x39458490,0xe8898028,0x63af0491}},	//   _tela, tals_, _sẻ_, _mocn,
   {{0x6d470492,0x27fd8428,0x798a8428,0x93bc8493}},	//   jaja, llwn_, _cafw, _stăt,
   {{0x39458494,0x6d470495,0x2fc001e9,0xf9920496}},	//   rals_, daja, _plig_, ברי_,
   {{0x39458497,0xe8898028,0x20090498,0x6b8d01ed}},	//   sals_, _vẻ_, _chai_, jdag,
   {{0x63a9830b,0x6b8d03a6,0x93b68051,0xddcd0499}},	//   mjen, ddag, _שלנו_, _spaš,
   {{0xceb2804c,0x6d47049a,0x7bd600b4,0x65638129}},	//   סים_, gaja, wiyu, ngnh,
   {{0xdce880eb,0xddc280eb,0x6b8b849b,0x443e049c}},	//   _radī, ntoš, _kagg, èt_,
   {{0x63a9849d,0x63bb849e,0x6b8d049f,0x087680be}},	//   njen, nkun, gdag, _יעצט_,
   {{0x6b8b84a0,0x6d4704a1,0x3951026c,0x4b2300e8}},	// [1c0] _magg, baja, _bdzs_, рмув,
   {{0x6d470025,0x63a984a2,0xb65b007c,0x00da04a3}},	//   caja, hjen, _קדיש, وبات_,
   {{0x63bb84a4,0xdce88029,0x63a984a5,0x661a84a6}},	//   kkun, _vadī, kjen, _ritk,
   {{0x6b8b84a7,0x70530077,0x6e24004f,0x7bd600dd}},	//   _nagg, شنها, _kuib, qiyu,
   {{0x63a984a8,0x628604a9,0x661a8364,0x443e84aa}},	//   djen, _usko, _pitk, _swt_,
   {{0xb5fb04ab,0x69c504ac,0xd49a84ad,0x8d6384ae}},	//   stáv, chhe, дри_, авље,
   {{0x6b8b84af,0xb5fb001b,0xcbe684b0,0x2cb80362}},	//   _bagg, ptáv, кции, nyrd_,
   {{0x63a984b1,0x63bb84b2,0x09da8072,0x61fe04b3}},	//   gjen, gkun, यच्य, llpl,
   {{0xd00f8013,0xfbd30051,0x2009031d,0x6b8b84b4}},	//   _ذلك_, יתה_, _rhai_, _dagg,
   {{0xa3f5800d,0x661a837a,0xb4d2016f,0x200900fc}},	//   ější_, _uitk, _वधू_, _shai_,
   {{0x2d9e84b5,0x6d4704b6,0x63a984b7,0xd1388110}},	//   _inte_, vaja, bjen, rbą_,
   {{0x2d8c84b8,0x317e81ec,0x6b8b84b9,0x63bb82af}},	//   _hade_, setz_, _gagg, ckun,
   {{0x6d4704ba,0x2d8c84bb,0x6e2404bc,0xc9aa84bd}},	//   taja, _kade_, _cuib, _овде_,
   {{0x2d8c84be,0xea778039,0xa4d500e8,0x63af01f4}},	//   _jade_, _סגור_, гогі, _socn,
   {{0x6d4704bf,0x63af0052,0x80a384c0,0x6b8d03b2}},	//   raja, _pocn, _نمون, tdag,
   {{0x5f7704c1,0x2d8c84c2,0x6b8b8079,0x2009004f}},	//   _شاعر, _lade_, _xagg, _uhai_,
   {{0x2d9e84c3,0x6d4704c4,0x63af025b,0xf8e284c5}},	// [1d0] _onte_, paja, _vocn, _पशुप,
   {{0x6b8d03a6,0x63bb80ad,0x68fc04c6,0x80be0264}},	//   sdag, zkun, _byrd, ্পন্,
   {{0x44270193,0x3eb904c7,0xc953810f,0x69d704c8}},	//   _în_, lyst_, שמע_, rixe,
   {{0x2d9e84c9,0x44330183,0xb4c1009a,0x7659831d}},	//   _ante_, _itx_, ्छी_, trwy,
   {{0x6d4504ca,0x6b8b84cb,0x4ea78081,0x6b8084cc}},	//   _keha, _ragg, ържа, demg,
   {{0x6d4504cd,0xf2d20051,0x7bc284ce,0xa93404cf}},	//   _jeha, _פעם_, _alou, _верш,
   {{0x63a984d0,0x7afd04d1,0x6b8b84d2,0x7bc284d3}},	//   tjen, _hyst, _pagg, _blou,
   {{0x2d9e84d4,0xddc284d5,0x7afd04d6,0x7bc284d7}},	//   _ente_, rtoš, _kyst, _clou,
   {{0x3f9f82c1,0x63a984d8,0x7bc2800d,0xee8484d9}},	//   _inuu_, rjen, _dlou, _выхо,
   {{0x63bb84da,0xdcbb8021,0x2d8c8247,0x5fb9835a}},	//   skun, _още_, _gade_, _आवडल,
   {{0x2dd880f7,0xf74604db,0x7afd04dc,0x046784dd}},	//   _شبكة_, лено, _lyst, _штам,
   {{0xdb0f0073,0xc43a84de,0x7ae48289,0x44258087}},	//   _você, _נתני, _žite, _iul_,
   {{0x442584df,0x6d4504e0,0x7afd04e1,0x69d504e2}},	//   _hul_, _beha, _nyst, _omze,
   {{0x88c584e3,0x442584e4,0x2bcf84e5,0x7bc28067}},	//   _متعل, _kul_, तोरा, _zlou,
   {{0x224d84e6,0x7981805d,0x442584e7,0x987980be}},	//   lsek_, melw, _jul_, _טאַט,
   {{0x7afd04e8,0x2d8c04e9,0x44258006,0x7981805d}},	//   _byst, žde_, _mul_, lelw,
   {{0x7afd0114,0xdcfc026f,0x442584ea,0x6d450144}},	// [1e0] _cyst, merč, _lul_, _feha,
   {{0x6d4504eb,0x7afd04ec,0x3f8204ed,0x798184ee}},	//   _geha, _dyst, leku_, nelw,
   {{0xdb06003e,0x2d8c84ef,0xdce38110,0xb5fb04f0}},	//   _doká, _rade_, menė, rtát,
   {{0xb5fb04f1,0x2d8c84f2,0x6d45011e,0x224d8214}},	//   gráf, _sade_, _zeha, ksek_,
   {{0x2d8c84f3,0x7981805d,0x7f3b00be,0x7afd0114}},	//   _pade_, kelw, גענו, _gyst,
   {{0x7bc2801b,0x442584f4,0xd5b1801c,0x7e7b808e}},	//   _slou, _bul_, _có_, _dpup,
   {{0x442584f5,0x5b2684f6,0x2d8c8214,0x7bc284f7}},	//   _cul_, льпа, _vade_, _plou,
   {{0xb5fb04f8,0x442584f9,0x3f820499,0x539884fa}},	//   ntár, _dul_, jeku_, твия_,
   {{0x2d8c84fb,0xbebb0168,0x224d82c4,0xdb060061}},	//   _tade_, ncët, gsek_, _elkö,
   {{0xc05a8221,0x602180eb,0x442584fc,0x79818114}},	//   нім_, _lēmu, _ful_, gelw,
   {{0x291884fd,0x98be8087,0x442584fe,0x798e04ff}},	//   ära_, dată_, _gul_, _mabw,
   {{0x6d450500,0x6d4a8501,0x644e0502,0xa6db007b}},	//   _seha, lafa, dsbi, laði,
   {{0x6d450503,0x44258504,0x645c011b,0x79818505}},	//   _peha, _zul_, erri, belw,
   {{0x44258506,0xbb1b02be,0x6d4a8507,0xa6db008b}},	//   _yul_, _maît, nafa, naði,
   {{0x6d450508,0x44258509,0xb4c1050a,0x3ebf050b}},	//   _veha, _xul_, ्छे_, šut_,
   {{0xc4c4850c,0x7afd0009,0xa3cf050d,0x246e8085}},	//   _ہے_, _pyst, वों_, _cəmi_,
   {{0x6d4a850e,0x6d450074,0x645c02f9,0x5b7b80be}},	// [1f0] kafa, _teha, arri, ערמא,
   {{0x7afd050f,0x645a0510,0x98be802e,0xb5fb0061}},	//   _vyst, átic, cată_, rtás,
   {{0x7afd0063,0x2d8302a0,0xb5fb0511,0xd7c880d7}},	//   _wyst, meje_, tráf, گونه_,
   {{0x31e18512,0x645a011f,0x2d830513,0x7afd0514}},	//   _पद्ध, štic, leje_, _tyst,
   {{0x44258515,0x6d4a8516,0xa2d4800c,0x98aa01a9}},	//   _sul_, fafa, _बेल्, ējām_,
   {{0x44258085,0x2d830517,0xf483804e,0x6d4a8518}},	//   _pul_, neje_, ماعی, gafa,
   {{0x63ad0110,0xa7fd007e,0xa2d90519,0x7981851a}},	//   ojan, ntıs, _नेत्, velw,
   {{0x63ad051b,0x4425838e,0x98be8087,0xddc4051c}},	//   njan, _vul_, zată_, _spiż,
   {{0x69da851d,0x6b8f051e,0x6d4a851f,0x2b468176}},	//   fite, _macg, bafa, _deoc_,
   {{0x2d830520,0x44258521,0x27e90522,0x69c8808c}},	//   jeje_, _tul_, _ajan_, ghde,
   {{0xe73a0523,0x2d830524,0x63ad0525,0x66ca8019}},	//   кен_, deje_, kjan, _töké,
   {{0xc6000526,0x7981805d,0xb5fb0527,0x63ad0528}},	//   ोग्य_, selw, hrád, jjan,
   {{0x63ad0529,0x98be8087,0x2bc9052a,0xb5fb052b}},	//   djan, tată_, रसना, vtár,
   {{0x3f82052c,0x69c8852d,0x644e052e,0x7bc980e7}},	//   seku_, chde, tsbi, lheu,
   {{0x98be802e,0x645c052f,0xdd0e02d0,0x8c460530}},	//   rată_, urri, _dışa, ребе,
   {{0xc0528039,0x7bc980e7,0xdb0b8531,0x63ad0532}},	//   _וזה_, nheu, _logí, gjan,
   {{0x6d4a8533,0x661e0534,0x644e0535,0xeab70536}},	// [200] yafa, _tipk, ssbi, айт_,
   {{0x394782fe,0xb5fb0537,0xf0a98032,0xdebb0538}},	//   _jens_, stár, _gbàà_, _סמיל,
   {{0xa3af00d4,0x64a60539,0x63ad053a,0xdca6053b}},	//   _कवच_, _тана, bjan, _тани,
   {{0x69da853c,0x6d4a8010,0x764400b4,0x6e93053d}},	//   zite, wafa, _kwiy, _الیا,
   {{0xb8fd053e,0xe8e2853f,0x23a98540,0x6d4a8541}},	//   _ते_, _पश्च, कानद, tafa,
   {{0x44440542,0x3947809f,0xb8660019,0x6b840543}},	//   _kw_, _nens_, _پاسو, leig,
   {{0x92e280c8,0x292700e1,0xa6db008b,0x03c68544}},	//   _ধরে_, ávať_, raði, исим,
   {{0x44440545,0x69da8546,0x6d4a8547,0x0fc100ab}},	//   _mw_, wite, safa, _উদ্ধ,
   {{0x444402ec,0x27e68420,0x39478548,0x2d830549}},	//   _lw_, mnon_, _bens_, yeje_,
   {{0x444402ec,0x6b84054a,0x63ad054b,0x4973854c}},	//   _ow_, heig, zjan, ольс,
   {{0x628b854d,0x7644054e,0x3947854f,0x58d880e8}},	//   _esgo, _awiy, _dens_, удня_,
   {{0x69da8550,0x394782d8,0x27e68551,0x6d488102}},	//   site, _eens_, nnon_, _heda,
   {{0x44440552,0x63a28553,0x6d4884bf,0xd6d80554}},	//   _aw_, _inon, _keda, атр_,
   {{0x6d488025,0x44440555,0x7bc60556,0x39478557}},	//   _jeda, _bw_, _alku, _gens_,
   {{0x6d488558,0x2d830559,0xf77f055a,0x63ad055b}},	//   _meda, reje_, ança_, tjan,
   {{0x7c288025,0x6d48855c,0x4444055d,0x628b8355}},	//   _mudr, _leda, _dw_, _ysgo,
   {{0x7c28855e,0x2905055f,0xadf683eb,0x717900e5}},	// [210] _ludr, _šla_, इवान_, лбар_,
   {{0x6f098063,0x39470560,0x3947802a,0x394c8561}},	//   _rzec, úns_, _xens_, nads_,
   {{0x44440562,0x63ad0563,0x63a28564,0x6b8401a9}},	//   _gw_, pjan, _onon, beig,
   {{0x27e68565,0x2014009f,0xdc9a03de,0x63a283f7}},	//   gnon_, _èxit_, _עירל, _nnon,
   {{0x7c288566,0x69d881eb,0x44440567,0xed598568}},	//   _audr, _omve, _zw_, гол_,
   {{0x63a28569,0x44440355,0x27e6856a,0x5f0a056b}},	//   _anon, _yw_, anon_, _सरस्_,
   {{0x4444056c,0x6d48856d,0xa6db0125,0x0574803d}},	//   _xw_, _deda, maðu, تاند,
   {{0x3947856e,0x69c7056f,0x23690570,0x1dd98571}},	//   _sens_, _hlje, ngaj_, _भगवत,
   {{0xe1f98572,0x248c8573,0xdd2c0110,0xe7308019}},	//   лги_, _esdm_, vėži, _آصف_,
   {{0x6b840352,0x6d488574,0xa6db007b,0x63a28575}},	//   zeig, _geda, naðu, _enon,
   {{0xa3e80576,0x69c702ce,0x7c288577,0x7dc200e1}},	//   _बदल_, _mlje, _gudr, _dôsl,
   {{0x44440578,0x3947837a,0x7dc201ac,0x6d570579}},	//   _rw_, _wens_, _pôso, _adxa,
   {{0x34b2057a,0x7f49857b,0x69c7057c,0xa7fd02d0}},	//   ीन्द, _meeq, _olje, ttır,
   {{0x4444057d,0x6e298264,0x6e21857e,0x28b980f7}},	//   _pw_, _mueb, _jilb, _مطبخ_,
   {{0x44440282,0x6b84057f,0xdb0b8187,0xdb1d0580}},	//   _qw_, teig, _fogã, _alsà,
   {{0xf1bf001c,0x69c1800b,0x44440581,0xfd6901bc}},	//   _quán_, lkle, _vw_, _kepụ,
   {{0x69c70582,0xa7fd0214,0x6e2982d5,0xfaa30530}},	// [220] _blje, ptır, _nueb, пато,
   {{0x44440583,0x01d70013,0x69c18584,0x6b840585}},	//   _tw_, موقع_, nkle, seig,
   {{0x44440586,0x3f920587,0x6d4e0588,0x291c0589}},	//   _uw_, _kayu_, maba, äva_,
   {{0x6d4e058a,0x7bc6058b,0x78a30338,0x68fc8192}},	//   laba, _ulku, ånva, ürdi,
   {{0x6e21811e,0xa3ab858c,0x2b40058d,0x3f920041}},	//   _bilb, खान_, mbic_, _mayu_,
   {{0x6d4e058e,0x225f858f,0x3f920590,0xe1e78591}},	//   naba, druk_, _layu_, _رس_,
   {{0x2bbf0592,0x6d488593,0xb5fb026f,0x394c80eb}},	//   _एकमा, _veda, duál, vads_,
   {{0x69de0594,0x6d4e0595,0x9b6a8596,0x6d488597}},	//   lipe, haba, ушка_, _weda,
   {{0x6d4e0598,0x6d488599,0x7dcb0059,0x394c859a}},	//   kaba, _teda, _hüse, tads_,
   {{0x69de059b,0x6d4e059c,0x8c0000ab,0xfd6901bc}},	//   nipe, jaba, ্দিন_, _depụ,
   {{0x672d80ce,0x64a3859d,0x3f92059e,0x9f42016b}},	//   žaje, _нафа, _bayu_, soký_,
   {{0x4422059f,0xaad98105,0x69de0087,0x225f85a0}},	//   _nik_, _बेवक, hipe, bruk_,
   {{0x69de05a1,0x645a0091,0x394a05a2,0x3f9202f7}},	//   kipe, átin, _oebs_, _dayu_,
   {{0x6d4e05a3,0xf1bf05a4,0x4422016d,0x30a685a5}},	//   gaba, _cuál_, _aik_, _грив,
   {{0x645a05a6,0x61fa8580,0x69de05a7,0xc05a85a8}},	//   štin, motl, dipe, _сіл_,
   {{0x69c702fd,0x442205a9,0x61fa85aa,0xeda585ab}},	//   _slje, _cik_, lotl, _गच्छ,
   {{0x6d4e05ac,0x442205ad,0x69c70052,0x7c2285ae}},	// [230] baba, _dik_, _plje, _mior,
   {{0x6d4e005d,0x7c228118,0x6f0d05af,0x61fa85b0}},	//   caba, _lior, _izac, notl,
   {{0x44220022,0x2fc905b1,0x660384e8,0x6d4105b2}},	//   _fik_, _klag_, vlnk, ılad,
   {{0x1da705b3,0x6e2985b4,0xdb0b8013,0x4422013c}},	//   खावत, _pueb, _logá, _gik_,
   {{0x7bdf05b5,0x7bcd05b6,0x61fa85b7,0x6e218176}},	//   miqu, mhau, kotl, _pilb,
   {{0x7bdf05b8,0x628f0197,0xb5fb05b9,0x69de05ba}},	//   liqu, _isco, xuál, cipe,
   {{0xddcc01e2,0x224680ee,0x442200ee,0x7c2285bb}},	//   _žiūr, _awok_, _yik_, _bior,
   {{0x23c905b3,0x7bdf05bc,0x6d4e05bd,0xa91c8038}},	//   रसिद, niqu, zaba, teľn,
   {{0x6e2185be,0xb5fb05bf,0x7c2285c0,0x3e72802e}},	//   _tilb, tuál, _dior, cât_,
   {{0x80be00c8,0x8d778416,0x3f9205c1,0xe9d985c2}},	//   ্পর্, _دارا, _sayu_, рко_,
   {{0x7c228098,0x2fc905c3,0x15fa009a,0x6f0d05c4}},	//   _fior, _blag_, ृतसर_, _azac,
   {{0x7c228021,0xdd0e85c5,0x6d4e05c6,0x2d8785c7}},	//   _gior, lışm, waba, lene_,
   {{0x6d4e05c8,0x7bdf05c9,0xf8a6016f,0x7bcd05ca}},	//   taba, diqu, _गप्प, dhau,
   {{0x442205cb,0x2d8785cc,0xdb0f002a,0xdd0e83bf}},	//   _sik_, nene_, _cocí, nışm,
   {{0x6d4e05cd,0x7bdf05ce,0x628f0098,0x629d05cf}},	//   raba, fiqu, _asco, _arso,
   {{0x7bdf0557,0xb5fb05d0,0x2d8785d1,0x3f868118}},	//   giqu, trác, hene_, xeou_,
   {{0x2d8785d2,0xe9da05d3,0x6d4e05d4,0xb5fb00e1}},	// [240] kene_, ака_, paba, urác,
   {{0x27ff85d5,0x27ed80b9,0xe16600f7,0x6d4e05d6}},	//   _akun_, _ajen_, تدري, qaba,
   {{0x442205d7,0x2d87835f,0x628f05d8,0x69de05d9}},	//   _tik_, dene_, _esco, ripe,
   {{0xeb9a05da,0x7bdf05db,0xb5fb026f,0x394a05dc}},	//   _тим_, ciqu, prác, _webs_,
   {{0x7c2285dd,0xfe6f85de,0x2d8785df,0x61fa85e0}},	//   _rior, ندو_, fene_, yotl,
   {{0x69de020f,0x2d8785e1,0x443a05e2,0x7c228014}},	//   qipe, gene_, _ktp_, _sior,
   {{0x69dc00f7,0x7c2285e3,0x6fc60118,0x50b5002e}},	//   _imre, _pior, _nóco, _есту,
   {{0x78a105e4,0xa3ba80f7,0x27ed8168,0xe3bf0144}},	//   _álva, شاعر_, _gjen_, _tiñe_,
   {{0x2d8785e5,0xa91c8038,0xf41302f6,0x69dc02f7}},	//   bene_, teľo, ופה_, _kmre,
   {{0x2fc905e6,0x61e881ec,0x20068168,0x7bdf05e7}},	//   _slag_, undl, lloi_, ziqu,
   {{0x09b78307,0xeb0705e8,0x2fc9056c,0x28f885e9}},	//   تطيع_, _शर्त_, _plag_, сень_,
   {{0x93258077,0x32058039,0xea0100ff,0x7bdf05ea}},	//   _فرهن, ally_, _đập_, xiqu,
   {{0x645a005c,0x442c84fe,0x69dc05eb,0xf98f80d5}},	//   štil, _hud_, _omre, ربی_,
   {{0x63a605ec,0x72e980be,0x443a05ed,0x200005ee}},	//   _ankn, _פֿײַ, _btp_, _ekii_,
   {{0x7bdf05ef,0x69ca808e,0x442c8162,0x7bcd05f0}},	//   tiqu, _ilfe, _jud_, thau,
   {{0x5a3505f1,0x798885f2,0x3a3905f3,0x69dc05f4}},	//   знат, ledw, _ptsp_, _amre,
   {{0x7bdf03d3,0x442c85f5,0x7bcd05f6,0x2d9305f7}},	// [250] riqu, _lud_, rhau, _taxe_,
   {{0x7bdf0557,0x442c85f8,0x7bcd05f9,0xaca301bc}},	//   siqu, _oud_, shau, _apụg,
   {{0x2d8785fa,0x6e2d022c,0xf8ca85fb,0x20ca85fc}},	//   vene_, _huab, ानिय, ानिध,
   {{0x6d5a85fd,0x7e6281e0,0x2d8780d7,0x6e2d05fe}},	//   _adta, frop, wene_, _kuab,
   {{0xf77085ff,0x27ed80f1,0x2d87835f,0x7c3a8600}},	//   ضان_, _vjen_, tene_, _attr,
   {{0x442c8601,0xb2ba01c6,0x6e2d0602,0xa2ba01c6}},	//   _bud_, _המשר, _muab, _המשט,
   {{0x2d878603,0xd8380048,0x27ff81cd,0x7d1c808b}},	//   rene_, _мэт_, _tkun_, _úrsl,
   {{0x5ba98604,0x442c8197,0x2d878605,0x69ca8606}},	//   ским_, _dud_, sene_, _alfe,
   {{0xe9d98607,0x2d878608,0x64488609,0x79950234}},	//   йки_, pene_, _ewdi, _kazw,
   {{0x442c80f7,0x6ca7860a,0x69c5060b,0x2ba981cb}},	//   _fud_, _мреж, nkhe, काहा,
   {{0x6d43860c,0x442c8082,0x2a6901c5,0x6e2d0362}},	//   mbna, _gud_, huab_, _auab,
   {{0x69ca860d,0xe29f007b,0x7649860e,0x628d060f}},	//   _elfe, _orð_, _kwey, kwao,
   {{0xb9028610,0xfaa58611,0x7bcb8612,0x629800eb}},	//   _ने_, _хало, _ilgu, āvok,
   {{0xceb2804c,0x69c50613,0x79950063,0x645a005c}},	//   עים_, jkhe, _nazw, štim,
   {{0x61e18614,0xdca30615,0x64a30616,0x764983f7}},	//   mill, нари, нара, _lwey,
   {{0x61e18617,0x67298618,0x3cde8006,0x69dc0619}},	//   lill, _ngej, _कइसे_, _smre,
   {{0x61e1861a,0x443a008e,0x2737001c,0x37e180ab}},	// [260] oill, _wtp_, _ủng_, যকার,
   {{0x3ea0061b,0x443a0359,0x6d41061c,0xa96a01a8}},	//   _irit_, _ttp_, ılac, إمام_,
   {{0x7e628372,0x6e3b861d,0x55bb01c6,0x2ec4861e}},	//   wrop, _atub, _המיו, वन्त,
   {{0x442c861f,0x2d980620,0x2d8a0621,0x7e628622}},	//   _rud_, ldre_, lebe_, trop,
   {{0x61e18623,0xdfcf8624,0xc61580c8,0x2a690282}},	//   kill, دين_, াদনা_, cuab_,
   {{0x7bcb8531,0x2d980625,0xb5fb0626,0x61e18627}},	//   _algu, ndre_, hrán, jill,
   {{0xf7468628,0x200683d3,0x62828629,0xb4c6800d}},	//   _нево, ploi_, _spoo, उने_,
   {{0x7dcb062a,0x2d8a062b,0x9f5900e7,0x61e1862c}},	//   _müsa, hebe_, posé_, eill,
   {{0x63b9862d,0x61e1862e,0x60338087,0xdcfa80eb}},	//   _down, fill, _răma, _patē,
   {{0xe3bf062f,0x442c8630,0x61e18631,0x6d5a806a}},	//   _miña_, _tud_, gill, _udta,
   {{0xe3bf062f,0xb5fb0632,0x2d8a0633,0x442c8634}},	//   _liña_, frán, debe_, _uud_,
   {{0x61fe0047,0x61e18635,0x79888636,0x22400637}},	//   hopl, aill, sedw, kpik_,
   {{0x71a68638,0x61fe0639,0xe3bf0264,0x2ba9863a}},	//   _надз, kopl, _niña_, कारा,
   {{0x61e1863b,0x64550065,0x4426863c,0x2d8a063d}},	//   cill, tszi, _hio_, gebe_,
   {{0x4426863e,0x3ea00176,0x48dc016f,0xb5fb03c1}},	//   _kio_, _erit_, _गेलो_, brán,
   {{0xcf2700f7,0x3ea0006a,0x2d98063f,0x6e2d0640}},	//   _عربي, _frit_, adre_, _tuab,
   {{0x44268641,0x61eb8019,0x7c260642,0x2d8a0643}},	// [270] _mio_, _állí, _dikr, bebe_,
   {{0x2d8a0644,0x61fe00fe,0x44268645,0xeb9f0646}},	//   cebe_, gopl, _lio_, _skød_,
   {{0x7c260647,0x69c50648,0x25d800be,0x2a690069}},	//   _fikr, rkhe, _מוזן_, suab_,
   {{0x61e18649,0xb8d5064a,0x4426864b,0xe29f008b}},	//   zill, _जप_, _nio_, _eyða_,
   {{0x6ff5809a,0xcb9a0039,0x63b9864c,0xf8a9864d}},	//   jące, _וסרט, _rown, _छप्प,
   {{0xd1268013,0x06f4803d,0x6b89864e,0xbea2864f}},	//   _لم_, رسنج, weeg, ташк,
   {{0x44268025,0x6b898650,0x2ba98651,0xdb0603ec}},	//   _bio_, teeg, काला, _ankè,
   {{0x2fc68052,0x5f948652,0x44268653,0x3f8b0654}},	//   ckog_, _пист, _cio_, jecu_,
   {{0x6b898079,0x44268655,0x8d878656,0x60188009}},	//   reeg, _dio_, _нужд, _хотя_,
   {{0x61e180e7,0x26c20084,0x63b982f7,0x5555803d}},	//   uill, vyko_, _wown, _آپار,
   {{0x61e18657,0x7dd00009,0x442683a7,0xb5fb0658}},	//   rill, _jäse, _fio_, trán,
   {{0x61e18659,0x4426865a,0xdee6065b,0x66e6065c}},	//   sill, _gio_, доми, дома,
   {{0x7dd0016d,0xb5fb05e4,0xab0b803d,0x6fc6002a}},	//   _läse, rrán, _اتاق_, _hóck,
   {{0xb21b065d,0x26110105,0x7c26065e,0x61e1865f}},	//   _spæn, _दीदी_, _sikr, qill,
   {{0x2d9801b3,0x3e76006a,0x2d8a00b4,0x3b960073}},	//   rdre_, sæt_, rebe_, мјат,
   {{0x6ff60307,0x3ea00660,0xea01001c,0xe3bf0661}},	//   _تستط, _trit_, _đạp_, _piña_,
   {{0x61fe0662,0x2bbf0663,0x3b070098,0x7c260664}},	// [280] topl, _एकरा, дето_, _vikr,
   {{0x3cde8665,0xe3bf05e4,0xc98601a8,0x2fcd8162}},	//   _कइले_, _viña_, بشري, _aleg_,
   {{0x7c260666,0x61fe0667,0x8cb503eb,0x2fc68668}},	//   _tikr, ropl, _उपयो, tkog_,
   {{0xe3bf062f,0x672d8669,0x2fcd810c,0x4f0a866a}},	//   _tiña_, žajn, _cleg_, онен_,
   {{0x442680a9,0xa91c80e1,0xa248003d,0xdb0f016a}},	//   _rio_, teľk, _ریال_, _tocá,
   {{0x2fc68289,0x44268010,0x3f8b017f,0x7d1c808b}},	//   skog_, _sio_, zecu_, _úrsk,
   {{0xd49781bb,0x52b8866b,0x6da3866c,0x69ce066d}},	//   дры_, ेन्स, тија, _ilbe,
   {{0x27e000e4,0xcfaa866e,0xc1788196,0x2918066f}},	//   _nmin_, _باسم_, ynės_, ągać_,
   {{0x8cb50670,0x44268671,0x29078672,0xb5fb016a}},	//   _उपभो, _vio_, _ayna_, rtáz,
   {{0x27e00673,0x7c3e003a,0x76428674,0x290781b0}},	//   _amin_, _otpr, mpoy, _byna_,
   {{0x44268675,0xf1bf001c,0x3f8b026c,0xf99301c6}},	//   _tio_, _quái_, tecu_, דרת_,
   {{0x443e8065,0x72c68676,0x62860677,0x29078114}},	//   _itt_, _обез, _opko, _dyna_,
   {{0x441b8158,0x69ce0358,0xa3ab8105,0x3f8b017f}},	//   _וואס, _olbe, खार_, recu_,
   {{0x34950678,0x443e8679,0x27e0067a,0x7dcf8366}},	//   нагр, _ktt_, _emin_, _tøse,
   {{0xe4e400e8,0x628600eb,0xc1788084,0x7d088366}},	//   вітн, _apko, snės_, _jyds,
   {{0x69ce067b,0xcbcd00ab,0xddc9801b,0x7dd0039c}},	//   _albe, রচ্ছ, _dveř, _räse,
   {{0x6feb0063,0x5215067c,0xbbbf036d,0x6b82867d}},	// [290] jęci, едат, _एकीक, _mbog,
   {{0x443e867e,0x2fcd867f,0x64588680,0x26000072}},	//   _ott_, _sleg_, ksvi, ळवणी_,
   {{0x3cde835a,0x443e8681,0x6d470682,0x764d0683}},	//   _केले_, _ntt_, mbja, _hway,
   {{0x764d0684,0x69ce0685,0x64588686,0x7dd00106}},	//   _kway, _elbe, dsvi, _väse,
   {{0x443e8687,0xb906058c,0x6fc600f7,0x733a00be}},	//   _att_, _बे_, _dóch, _מערס,
   {{0x6b828688,0x6d550689,0x63bd068a,0x764d0247}},	//   _abog, naza, _hosn, _mway,
   {{0x26c9803a,0x6458868b,0x6aa2808e,0x63bd007b}},	//   šao_, gsvi, _arof, _kosn,
   {{0x6d55068c,0x672d068d,0xe3bf04c3,0x61e5068e}},	//   haza, _ngaj, _miño_, lihl,
   {{0x443e868f,0xb5fb0019,0x29078690,0x6aa28691}},	//   _ett_, trál, _syna_, _crof,
   {{0xf1b180f7,0x672d04b9,0x6e288197,0x63bd0692}},	//   اءة_, _agaj, _gidb, _losn,
   {{0xe3bf0693,0x764d0694,0x6aa2826b,0x6d550695}},	//   _niño_, _away, _erof, daza,
   {{0x649a8051,0x6b828324,0x63bd0696,0x64438502}},	//   _מסעד, _gbog, _nosn, mpni,
   {{0x0aeb8077,0xe1ee8098,0x6d55005d,0x34c80697}},	//   _براي_, _бг_, faza, रन्द,
   {{0x7bcf0698,0x200b0699,0x6d55069a,0x6b82812b}},	//   _alcu, alci_, gaza, _zbog,
   {{0xafe6069b,0xb042801c,0xdb86069c,0x63bd069d}},	//   _покл, _trưở, нгви, _bosn,
   {{0x6b9b869e,0x7ae4869f,0x63bd0090,0x27e0008e}},	//   ndug, _žiti, _cosn, _umin_,
   {{0x6d5506a0,0xada606a1,0x7bc98198,0x200206a2}},	// [2a0] baza, _запл, ikeu, moki_,
   {{0xdb0d0125,0x200206a3,0x7bcf0144,0x673b85ee}},	//   rkað, loki_, _elcu, _afuj,
   {{0x7dcb0457,0xb5fb016b,0x717300f7,0x7bc98198}},	//   _müsl, kráj, اهما, kkeu,
   {{0x2d9a06a4,0x48c300ab,0x601606a5,0x2ca5006a}},	//   _hape_, ্পূর, lámb, ælde_,
   {{0x2d9a06a6,0x490686a7,0x7bc986a8,0xfeb7803d}},	//   _kape_, _सुनो_, dkeu, فاوت_,
   {{0x63ab86a9,0x645886aa,0xab5b01ec,0x200206ab}},	//   _angn, tsvi, _flüs, hoki_,
   {{0x200206ac,0x2d9a06ad,0xa3ab86ae,0xb0de86af}},	//   koki_, _mape_, खां_, _फेंग,
   {{0x645883a6,0x6b9b84a7,0x8cb182f1,0x9f5901ca}},	//   rsvi, gdug, _अपरो, tosí_,
   {{0x6d5506b0,0x60e00110,0x645886b1,0x200206b2}},	//   yaza, žymė, ssvi, doki_,
   {{0x27e686b3,0x7d08867f,0x2d9a06b4,0x6b8d011b}},	//   lion_, _tyds, _nape_, zeag,
   {{0xc05786b5,0x764d06b6,0x5fc486b7,0xdddb80ce}},	//   нія_, _sway, _वकाल, _upuš,
   {{0x6d5506b8,0x6b8286b9,0x27e686ba,0x6b998326}},	//   waza, _ubog, nion_, _gawg,
   {{0xcf938158,0x26c686bb,0x6d5506bc,0x63bd06bd}},	//   נטש_, nyoo_, taza, _rosn,
   {{0x7d0306be,0xbbc902ef,0x2bc906bf,0x764d06c0}},	//   _ønsk, रस्क, रस्थ, _vway,
   {{0x6d5506c1,0x26ec8665,0x63bd06c2,0x5ff50098}},	//   raza, जपुर_, _posn, _изку,
   {{0xe3bf04c3,0x6d5a06c3,0x27e686c4,0x60160118}},	//   _viño_, ótar, jion_, táme,
   {{0x27e686c5,0x6b8d06c6,0x6d5506c7,0x497506c8}},	// [2b0] dion_, reag, paza, клас,
   {{0x601606c9,0x8cb1809a,0x63bd008e,0x6b8d06ca}},	//   ráme, _अपलो, _wosn, seag,
   {{0xc95380be,0x6fc60187,0x6f0986cb,0x61e506cc}},	//   רמע_, _sóci, _syec, rihl,
   {{0x27e686cd,0x61e5005d,0x60c50009,0x76598428}},	//   gion_, sihl, ryhm, tswy,
   {{0xa3b486ce,0xee3886cf,0x7e7d06d0,0xd35604de}},	//   ञान_, ені_, ntsp, _שישי_,
   {{0xfce581cf,0x442b06d1,0x7bc981ed,0xd5bb86d2}},	//   коло, _hic_, wkeu, ясе_,
   {{0x645a06d3,0x27e68114,0x02c986d4,0x6b9b86d5}},	//   štiv, bion_, िन्न, tdug,
   {{0x27e686d6,0x25ac802a,0x644386d7,0x443306d8}},	//   cion_, _endl_, rpni, _mux_,
   {{0x7dd000f2,0x7bc986d9,0x443306da,0x2a690066}},	//   _läsa, rkeu, _lux_, nrab_,
   {{0x644386db,0x3f8f807b,0xddc28110,0x7bc986dc}},	//   ppni, legu_, puoš, skeu,
   {{0x660386dd,0xa3c306de,0x442b06df,0x200206e0}},	//   monk, ्सा_, _oic_, toki_,
   {{0x442b06e1,0xb4bf8076,0xf77206e2,0x66038234}},	//   _nic_, ुनी_, جاد_, lonk,
   {{0x443306e3,0x200206e4,0x3f9b0609,0x7e7d06e5}},	//   _aux_, roki_, _daqu_, gtsp,
   {{0x008586e6,0x442b06e7,0x7d048214,0x27e686e8}},	//   _алко, _aic_, şise, zion_,
   {{0xdce18214,0xa50706e9,0x601886ea,0xd62706eb}},	//   _kalı, вера_, líme, торе_,
   {{0x27e682be,0x3f8f86ec,0x442b06ed,0x660386ee}},	//   xion_, jegu_, _cic_, honk,
   {{0x442b06ef,0x443302be,0x3ae80077,0x2ebd86f0}},	// [2c0] _dic_, _eux_, ربری_, ्नोत,
   {{0xb14306f1,0x261683db,0xdcfc00eb,0x7c2b86f2}},	//   инул, _पीढी_, ndrī, _ligr,
   {{0x27e686f3,0xe0d200f7,0xd6a9026a,0x27f7015b}},	//   tion_, جزء_, _قدیم_, _سفید_,
   {{0x7c2b86f4,0x2d858039,0xa3a9064a,0x442b06f5}},	//   _nigr, _able_, _गोप_, _gic_,
   {{0x27e686f6,0xa3ab823c,0x644186f7,0xc32000ab}},	//   rion_, खाई_, _atli, _ফ্রি_,
   {{0x27e686f8,0xd94306f9,0x442b0087,0x614306fa}},	//   sion_, _вери, _zic_, _вера,
   {{0xdce183bf,0x27e686fb,0x2d8e86fc,0x09e306fd}},	//   _balı, pion_, refe_, _торн,
   {{0x442006fe,0x7bd606ff,0xb5fb0700,0xd9ca8701}},	//   nmi_, nhyu, nuár, िस्ट,
   {{0x64418702,0x877b80be,0x60188661,0x3cde8074}},	//   _etli, _קאמי, gíme, _कइके_,
   {{0x79a68703,0x66038704,0xf1a68705,0x2fc00706}},	//   трие, conk, трин, _aoig_,
   {{0x799c0707,0x7bd60708,0x44200709,0x4ce080ab}},	//   _marw, khyu, kmi_, _পুরু,
   {{0x6d58870a,0x7e7d070b,0x4420070c,0x9f4b0020}},	//   lava, ttsp, jmi_, vocó_,
   {{0xb5fb0065,0x2902809a,0x4420070d,0xf40800ab}},	//   nság, łka_, dmi_, লগার_,
   {{0x6d58870e,0x442b00f1,0xdd11026f,0x4420070f}},	//   nava, _sic_, _výži, emi_,
   {{0x61e88710,0x2fd20711,0xf41480be,0x645c0106}},	//   midl, _flyg_, ָפּ_, gsri,
   {{0x6d588712,0xdce18713,0xa3dd009a,0xef670098}},	//   hava, _xalı, थों_, _ръко,
   {{0x799c0714,0x6d588715,0x2009010c,0x2b4900fe}},	// [2d0] _barw, kava, _ikai_, rbac_,
   {{0x6d588025,0x44200716,0x799c0717,0xb5fb0718}},	//   java, ami_, _carw, dság,
   {{0x2d9100b4,0x48c300ab,0x3c388019,0xd246853d}},	//   meze_, ্প্র, _név_, _گن_,
   {{0x2d910719,0x6603871a,0x4420071b,0x926b0087}},	//   leze_, wonk, cmi_, _орга_,
   {{0x645a003a,0x35a8023c,0xd2468065,0x799c0428}},	//   štit, _छोड़, _دن_, _farw,
   {{0xa3c3035a,0x6d58871c,0x3e7b82be,0x6575071d}},	//   ्सव_, gava, rêt_, ngzh,
   {{0x6603871e,0xfd500135,0xdb0b80e7,0x6b9d0122}},	//   ronk, _aghụ, _ingé, _kasg,
   {{0x7c3e803e,0x6603871f,0x7bcd0720,0x1fa48721}},	//   ípra, sonk, nkau, _круг,
   {{0x6603807a,0x2fc00722,0x6b9d0723,0x2d910724}},	//   ponk, _roig_, _masg, keze_,
   {{0x44200725,0x20090041,0x3c3880e7,0x61e88726}},	//   zmi_, _akai_, _fév_, gidl,
   {{0x7c2b8727,0x44200728,0x7bcd0364,0x80ad8540}},	//   _tigr, ymi_, kkau, टमें,
   {{0x366a0729,0xeb9f006a,0x5275872a,0x7bcd01c0}},	//   намо_, _skøn_, _буку, jkau,
   {{0x6f0d00b4,0x4420072b,0x765d072c,0x61e8872d}},	//   _cyac, vmi_, gssy, bidl,
   {{0x63bb872e,0x4095872f,0x2d9102a0,0x645c0730}},	//   ljun, _брит, geze_, tsri,
   {{0x07a60048,0x44200731,0x6b9d0732,0x6f0d0733}},	//   _байн, tmi_, _basg, _eyac,
   {{0x63bb8734,0x7bcd0735,0x44200736,0x6b9d0114}},	//   njun, gkau, umi_, _casg,
   {{0xc332836b,0xdcfa80eb,0x6d588737,0x60160511}},	// [2e0] מון_, _patī, yava, cáma,
   {{0xd05a0558,0x64410207,0xddd481ac,0x7bd602a0}},	//   ерді_, ílic, _ťažk, shyu,
   {{0x6d588738,0x63bb808b,0x2a7f82f1,0x6b9d0739}},	//   vava, kjun, htub_, _fasg,
   {{0x4444073a,0x61e8873b,0xb4c2073c,0x799c073d}},	//   _it_, zidl, ्नी_, _warw,
   {{0x6d58873e,0x4444073f,0xa3c30740,0x799c0741}},	//   tava, _ht_, ्सर_, _tarw,
   {{0x270300ff,0xb5fb0742,0x7dd001d6,0x98be8196}},	//   ổng_, trái, _mäso, lbtą_,
   {{0x6d588743,0x44440744,0x61e8827f,0x395a01e0}},	//   rava, _jt_, vidl, maps_,
   {{0x7dc68125,0x2d910745,0xb5fb01a8,0x6f090035}},	//   _aðst, zeze_, rrái, żeci,
   {{0x44440746,0x6d5e84c3,0xb4c2000d,0x0aea80f7}},	//   _lt_, ópas, ्नु_, عربي_,
   {{0x44440747,0xc27b03de,0x765d0163,0x776402f9}},	//   _ot_, עריי, vssy, _adix,
   {{0x20090748,0x28f88749,0x63bb874a,0x26e200ab}},	//   _pkai_, тень_, bjun, _গুলো_,
   {{0x09c1016f,0x2d91074b,0x2006874c,0x765d074d}},	//   _शक्य, weze_, nooi_, tssy,
   {{0x4444004c,0x61e8874e,0xa91c81ac,0x2d91074f}},	//   _at_, pidl, teľs, teze_,
   {{0x7dcb0006,0xb5fb003e,0x0cb680c8,0x23278750}},	//   _küsi, hráv, জনীত, _сочи_,
   {{0x2d910751,0x6b840752,0x6b9d0753,0xd13f809a}},	//   reze_, ffig, _pasg, łącz_,
   {{0x672d8754,0x44440755,0x2d910756,0x261a06a7}},	//   žaji, _dt_, seze_, _मीठी_,
   {{0x44440757,0x99550758,0x7bcd0759,0xf96b075a}},	// [2f0] _et_, икац, rkau, ерей_,
   {{0x2d9e875b,0x7bcd075c,0x444401c6,0x6b9d075d}},	//   _nate_, skau, _ft_, _wasg,
   {{0x6b9d0014,0x3ea904e8,0x92b50264,0x63bb875e}},	//   _tasg, _hrat_, জনে_, yjun,
   {{0xb4d100a5,0x3ea9075f,0x66070088,0x64450760}},	//   वनी_, _krat_, lojk, _ithi,
   {{0x2d9e8761,0x248c80ee,0x29180762,0xd2440087}},	//   _bate_, _apdm_, _ezra_, _гэси,
   {{0xd6580051,0x22490763,0x6da58764,0x2d9e802e}},	//   ניות_, mpak_, рика, _cate_,
   {{0xeb998765,0x2d9e8766,0x23d58767,0xa3b90768}},	//   вий_, _date_, ицир, चाप_,
   {{0xea010104,0xb5fb01df,0x3ff980be,0x2d9e838a}},	//   _đẹp_, nsáb, _ספּע, _eate_,
   {{0x22490769,0x59a686a7,0xe3b6876a,0xd7f88084}},	//   npak_, _कोहर, рбы_, _сур_,
   {{0x3a2e83a8,0x7c2f076b,0x6ff201a9,0x64450234}},	//   _cifp_, _licr, māci, _othi,
   {{0x7dd000f2,0x7c9586e2,0xf9920039,0x6607076c}},	//   _säso, _خلاص, חרי_, dojk,
   {{0x2249076d,0xf1d98651,0x7c2f0706,0x2d218072}},	//   kpak_, योजन, _nicr, मधील_,
   {{0x6445076e,0xa3b90321,0x2d9e876f,0x6ff200eb}},	//   _athi, चान_, _yate_, nāci,
   {{0x3ea9008e,0x7bc281c0,0x9fb881d0,0xe4da00d7}},	//   _drat_, _zoou, včí_, پورت_,
   {{0xb4c20770,0x3ea9010b,0xd5e4019d,0x69c38771}},	//   ्ने_, _erat_, _apị, _ione,
   {{0x6ff200eb,0xa3a90105,0x2d9e027f,0xb5fb04f0}},	//   kāci, _गोद_, žte_, dráu,
   {{0x442f8772,0x44440773,0x64450774,0x60188775}},	// [300] _mig_, _wt_, _ethi, jíma,
   {{0x44440776,0x442f8777,0xbbd28778,0xe9d70779}},	//   _tt_, _lig_, _तत्क, аку_,
   {{0x4444077a,0x673b077b,0x69c3877c,0xd91000d5}},	//   _ut_, žuje, _mone, سیر_,
   {{0xc60e83b7,0xddc28029,0x6d41877d,0x53ca0424}},	//   ित्य_, droš, _afla, _रविश,
   {{0x7c24077e,0x9f82077f,0x7ae90669,0xeb970081}},	//   mmir, _yóò_, _žetv, _тия_,
   {{0x2b4d8780,0x6d5c0781,0x69c380b4,0x442f8782}},	//   ebec_, nara, _none, _aig_,
   {{0x442f8783,0x601d02be,0xb5fb026f,0x2bdd016f}},	//   _big_, léme, práv, नोका,
   {{0xa3b905b3,0x442f8784,0x0b8a8139,0x938a8785}},	//   चाय_, _cig_, тски_, тска_,
   {{0x442f8786,0x2a6d8787,0x6d5c0788,0x3c3c0789}},	//   _dig_, greb_, kara, _lív_,
   {{0x6d5c078a,0x4e7b8051,0x64430036,0x442f878b}},	//   jara, _באמצ, _énig, _eig_,
   {{0x6607003b,0x69c3878c,0xb4c203bb,0x3137078d}},	//   vojk, _done, ्नो_, ינים_,
   {{0x6d57078e,0x41a68076,0x3ea9078f,0x0aea8790}},	//   _sexa, _कोरस, _prat_, _идей_,
   {{0xdefb0791,0x6d5c0792,0x69c38793,0x7c240669}},	//   тын_, fara, _fone, dmir,
   {{0x6d5c0794,0x442f8795,0x7c2f031d,0x3ea90796}},	//   gara, _zig_, _sicr, _vrat_,
   {{0x442f8069,0xe4a40256,0x6d570797,0x6ff20029}},	//   _yig_, орто, _vexa, zāci,
   {{0x7c240798,0x3ea90799,0x83350081,0x69c3879a}},	//   gmir, _trat_, снах, _zone,
   {{0x6d5c079b,0x8d8701a1,0x69d5001b,0xba5501a8}},	// [310] bara, _кунд, _plze, صناع,
   {{0xe29f8125,0xc1788110,0x6ff201a9,0x3958079c}},	//   æði_, ngė_, vāci, _cers_,
   {{0xd1380698,0x224902f7,0x6445079d,0x4395079e}},	//   рху_, spak_, _uthi, _ланс,
   {{0x3958079f,0x224687a0,0x6ff200eb,0x6018807b}},	//   _eers_, _otok_, tāci, tíma,
   {{0x6d4181ec,0x9f42016b,0x60160019,0xbea587a1}},	//   _pfla, niká_, zámo, салк,
   {{0x442f87a2,0xb5fb07a3,0x6ff20029,0x629d07a4}},	//   _sig_, crát, rāci, _isso,
   {{0x27e907a5,0xe3b180f7,0x22468748,0x69c387a6}},	//   _oman_, كرة_, _atok_, _rone,
   {{0x69c387a7,0x442f822c,0x27e907a8,0x2a6d87a9}},	//   _sone, _qig_, _nman_, treb_,
   {{0x69c387aa,0xdcfe01a9,0x36d4804a,0x2b4d87ab}},	//   _pone, _papī, _дотр, rbec_,
   {{0xdef887ac,0x27e90590,0x25a107ad,0x69da8039}},	//   _тыс_, _aman_, _nahl_, ghte,
   {{0x2ed00076,0x442f87ae,0x1bf905e8,0x69c387af}},	//   हन्त, _tig_, ्काल_, _vone,
   {{0x6d5c07b0,0xcdc90051,0x601607b1,0x69c380f3}},	//   wara, _אך_, rámo, _wone,
   {{0x6d5c07b2,0x69c387b3,0x539a8039,0x7bdb8079}},	//   tara, _tone, _תינו, mhuu,
   {{0x69da87b4,0x27e9011e,0x32b881a8,0x601603a8}},	//   chte, _eman_, _خدمة_, pámo,
   {{0x629d07b5,0x04460226,0xb5fb016b,0x25a104dc}},	//   _asso, себн, vrát, _dahl_,
   {{0xe29a07b6,0x9f82007b,0x2b5907b7,0x7dd007b8}},	//   лаб_, _góð_, _cesc_, _käsk,
   {{0x2b400390,0xaaa786ae,0x09360742,0xb5fb07b9}},	// [320] rcic_, कटिक, مراج, trát,
   {{0x6d5c07ba,0x2a6007bb,0x2d87826c,0x601d07bc}},	//   qara, rsib_, jfne_, réme,
   {{0xfbd207bd,0x395807be,0x629d07bf,0x6f1b85e4}},	//   _فتح_, _vers_, _esso, _azuc,
   {{0xc88507c0,0x25a107c1,0x201f87c2,0x939607c3}},	//   daşı_, _zahl_, _chui_, _اجدا,
   {{0xe5c687c4,0x248c01b9,0x69da87c5,0x201f8362}},	//   йско, ħdmu_, yhte, _dhui_,
   {{0x443a07c6,0x62840106,0x6b96057b,0xe196002e}},	//   _kup_, mtio, leyg, _урмэ,
   {{0x7bc6029b,0x224687c7,0x62840009,0x29c9802a}},	//   _koku, _stok_, ltio, _lúas_,
   {{0xd00a87c8,0x443a0067,0x6b9607c9,0xb33b0315}},	//   _себе_, _mup_, neyg, _kaça,
   {{0x7ae907ca,0x63a407cb,0x628407cc,0x7bc607cd}},	//   _þett, idin, ntio, _moku,
   {{0x7bc607ce,0x27e907cf,0x984a8098,0xb33b07d0}},	//   _loku, _sman_, ляма_, _maça,
   {{0x7dcb07d1,0xe45287d2,0xb5fb07d3,0x8b66803d}},	//   _xüsu, _رضا_, krár, _هاشم,
   {{0x628407d4,0x69da820f,0x7bc6029b,0x6d5a816d}},	//   ktio, shte, _noku, _heta,
   {{0x6d5a87d5,0x63a407d6,0x7f5d002a,0xb4d107d7}},	//   _keta, ddin, rasq, वन्_,
   {{0x27078104,0x29c9862f,0x7c3a87d8,0xd6d800e8}},	//   ống_, _dúas_, _kutr, стю_,
   {{0xdce887d9,0x6d5a87da,0x395e87db,0x69d884a2}},	//   _kadı, _meta, mats_, _ilve,
   {{0x395e87dc,0x6d5a87dd,0x27e907de,0x7c3a811b}},	//   lats_, _leta, _uman_, _mutr,
   {{0x63a2822e,0x7c3a82a5,0x200b07df,0xb33b07e0}},	// [330] _maon, _lutr, moci_, _caça,
   {{0x7c3a87e1,0x2ba905b3,0x395e87e2,0x63a407e3}},	//   _outr, _चोरा, nats_, adin,
   {{0xceeb8077,0x5335079e,0x443a07e4,0x628407e5}},	//   گران_, _мент, _gup_, atio,
   {{0x61c587e6,0xb33b07e7,0xdea1803d,0x395e87e8}},	//   _लक्ष, _faça, ویزی, hats_,
   {{0x628407e9,0x7c3a86e3,0x6d5a87ea,0x25ed835a}},	//   ctio, _autr, _beta, _अगदी_,
   {{0x313507eb,0x6d5a87ec,0x7bc6029b,0xdcf88110}},	//   _февр, _ceta, _zoku, nevė,
   {{0x7bc6029b,0x628282a3,0x395e87ed,0x7c3a8087}},	//   _yoku, _aqoo, dats_, _cutr,
   {{0x69d887ee,0x69c707ef,0x7c3a87f0,0x6d5a87f1}},	//   _alve, _hoje, _dutr, _eeta,
   {{0x69c7003a,0xe9d987f2,0x64488201,0x200b0052}},	//   _koje, ики_, _etdi, doci_,
   {{0x7dcb0352,0x29c984c3,0x395e87f3,0x7dd0016d}},	//   _müss, _rúas_, gats_, _väsk,
   {{0x29c987f4,0x69c707f5,0x63a407f6,0x645e80e1}},	//   _súas_, _moje, ydin, špir,
   {{0x6d4507f7,0x69d887f8,0x6d5a87f9,0x200b0722}},	//   _afha, _elve, _zeta, goci_,
   {{0x395e87fa,0x6d5a87fb,0xa2948112,0xd9fb016f}},	//   bats_, _yeta, _наці, ्वात_,
   {{0x7dd003ff,0x395e87fc,0x7bc6029b,0x63a40295}},	//   _käsi, cats_, _soku, wdin,
   {{0x7bc607fd,0x63a287fe,0x64a307ff,0x7dcb0800}},	//   _poku, _yaon, мара, _rüst,
   {{0xb06880d5,0x63a40801,0x29c984c3,0x7dcb0074}},	//   _اصول_, udin, _túas_, _süst,
   {{0x63a40802,0x98a583bf,0x7dcb02f1,0x224d8088}},	// [340] rdin, malı_, _püst, npek_,
   {{0x7bc6029b,0x63a40803,0x3ea006c0,0x69c70804}},	//   _woku, sdin, _isit_, _coje,
   {{0x69c70805,0x62840806,0x7bc60807,0xdbd18214}},	//   _doje, stio, _toku, _güçl,
   {{0x2d980808,0x62840809,0x510c8158,0x98a5880a}},	//   lere_, ptio, נהאַ, nalı_,
   {{0xd5ba8009,0x4e96880b,0x63a2880c,0x601d080d}},	//   иск_, تشار, _raon, néma,
   {{0x2d98080e,0x7c3a81f1,0x3ead809f,0x7e6280b9}},	//   nere_, _putr, _dret_, rsop,
   {{0x395e880f,0xaff58065,0x98a5861c,0xb4d4853f}},	//   vats_, _کہنا_, kalı_, हने_,
   {{0x2d980810,0xdce88201,0x32668811,0x9faf001b}},	//   here_, _qadı, отов, tří_,
   {{0x6d5a8812,0x395e8813,0x2d980814,0xdb1d0019}},	//   _teta, tats_, kere_, _kosá,
   {{0x2d980815,0x670e0816,0xddc2809a,0x63a2804f}},	//   jere_, _सड़क_, społ, _waon,
   {{0x2d980817,0x395e8818,0x63a282b8,0xeb9a8819}},	//   dere_, rats_, _taon, _вие_,
   {{0x395e881a,0xf8ad881b,0xb09b01c6,0x2d98038a}},	//   sats_, اکو_, ביטר, eere_,
   {{0x2d98081c,0x200b081d,0x395e881e,0xa3b9081f}},	//   fere_, roci_, pats_, चास_,
   {{0x2d980820,0xddcf0162,0x61ea8162,0x69d88821}},	//   gere_, ducţ, _umfl, _ulve,
   {{0xfbd30013,0xa1778051,0x69c70822,0xc05a821e}},	//   وتر_, _ועוד_, _roje, _тіл_,
   {{0x44220823,0x69c70824,0xb5fb0825,0x98a58826}},	//   _chk_, _soje, rráq, calı_,
   {{0x2d980827,0x69c70828,0xe1f30829,0x7c22882a}},	// [350] bere_, _poje, وسط_, _mhor,
   {{0x2d98082b,0x44220006,0xdddb882c,0x3f99082d}},	//   cere_, _ehk_, _spuž, lesu_,
   {{0xe7f78076,0x2d81082e,0x69c7026f,0x7649882f}},	//   ंचला_, _iche_, _voje, _stey,
   {{0x3ead8830,0x320c8831,0x69c7009a,0x4c9a04de}},	//   _pret_, hody_, _woje, _פברו,
   {{0xb3ba0039,0x320c866f,0x00000000,0x00000000}},	//   _המרכ, kody_, --, --,
   {{0x7c228832,0x270a0104,0x27ef8833,0x246580eb}},	//   _ahor, ờng_, sign_, tēm_,
   {{0x98a58059,0xc5f4007c,0x7c228834,0x6b898122}},	//   yalı_, ודס_, _bhor, tfeg,
   {{0x3cfc012a,0x44290835,0x2d9800b4,0x3f99005d}},	//   ילונ, nma_, zere_, jesu_,
   {{0x6aa48836,0x7c228837,0x27ed8838,0xe7af009a}},	//   _šifr, _dhor, _imen_, _जोधप,
   {{0xe9d98139,0xaca38135,0x2d810135,0xba228071}},	//   ско_, _ahụm, _nche_, ндык,
   {{0x2d980839,0x4429083a,0x7c228013,0x224d883b}},	//   vere_, kma_, _fhor, spek_,
   {{0x2d98082e,0x7c22883c,0x4429083d,0x2fc9002a}},	//   were_, _ghor, jma_, _coag_,
   {{0x2d98083e,0x4429083f,0x98a583bf,0x25a58840}},	//   tere_, dma_, ralı_, _kall_,
   {{0x44290841,0x7c22816b,0x7dd00338,0x7ddd810c}},	//   ema_, _zhor, _läsv, _hèsb,
   {{0x2d980842,0x7c298843,0x44220573,0x27ed8844}},	//   rere_, omer, _phk_, _omen_,
   {{0x2d980845,0x44290846,0x4a460847,0x7c298848}},	//   sere_, gma_, знав, nmer,
   {{0x2d980849,0x6d41084a,0xe9da084b,0x236000dd}},	// [360] pere_, ılar, бка_, raij_,
   {{0x4429084c,0xb33b02be,0x7c29884d,0xdb04084e}},	//   ama_, _faço, hmer, ndié,
   {{0x6d5e00eb,0x7c29884f,0x6d3b01c6,0x63768850}},	//   _iepa, kmer, _לתינ, nünü,
   {{0xb4b800c2,0x7c298851,0xf1ba8129,0x291d0326}},	//   चमी_, jmer, _nhơn_, ƙwan_,
   {{0x6d5e0852,0xa3b90853,0xb4e486a7,0xa7fd02d0}},	//   _kepa, चार_, _पेड़_, ksın,
   {{0x6d5e0854,0x63a60855,0x7c228039,0x25a58856}},	//   _jepa, _hakn, _shor, _call_,
   {{0x25a58698,0x7c228857,0x63a60858,0x320c83fb}},	//   _dall_, _phor, _kakn, vody_,
   {{0x6d5e0859,0x7bd6085a,0x7c29885b,0xdcf881a9}},	//   _lepa, nkyu, gmer, levī,
   {{0x63a6085c,0x320c885d,0x25a5885e,0xdb040036}},	//   _makn, tody_, _fall_, udiè,
   {{0x64a6885f,0x20030025,0x672082fd,0xdca68860}},	//   _наза, čkim_, _izmj, _нази,
   {{0x44290861,0xa3190740,0x7c298862,0x660e0079}},	//   yma_, _दर्ज_, bmer, dobk,
   {{0x7c228863,0x44290864,0x2d810865,0x443e8866}},	//   _uhor, xma_, _sche_, _iut_,
   {{0x6d5e05f8,0xe80d80ba,0xb80d86b7,0x7c3e00e7}},	//   _bepa, िकता_, िकतम_, _aupr,
   {{0x6d5e0867,0x443e8868,0x1a9b80be,0x224b80e1}},	//   _cepa, _kut_, _לידע, ícke_,
   {{0x44290869,0x7c3e002e,0xdcf881a9,0xa3b9086a}},	//   tma_, _cupr, devī, चाल_,
   {{0x4429086b,0x443e886c,0x7dcf80e8,0x63a600b9}},	//   uma_, _mut_, _høst, _cakn,
   {{0x5a3500b3,0x443e886d,0x601d086e,0x69dc0362}},	// [370] днат, _lut_, lémo, _blre,
   {{0x443e804c,0x6d5e04eb,0x7c29886f,0x2d810870}},	//   _out_, _gepa, zmer, _uche_,
   {{0x7c298428,0xf8dc86ae,0x442902d0,0x9f4f8036}},	//   ymer, मनिय, pma_, ligé_,
   {{0xc10400a0,0x6d488871,0xa7fd02d0,0x60160118}},	//   روني, _afda, zsın, támi,
   {{0xf7708872,0x443e8873,0x6da586f1,0x81bc80eb}},	//   طان_, _aut_, дила, rmēj,
   {{0x443e804c,0x60160874,0xf6508875,0x6b828876}},	//   _but_, rámi, ائن_, _acog,
   {{0x63a60877,0x25a58722,0xdca28098,0x70940878}},	//   _yakn, _vall_, ващи, _парф,
   {{0x7dd00879,0x443e811e,0x601d087a,0x25a5887b}},	//   _häst, _dut_, démo, _wall_,
   {{0x200f887c,0x6449887d,0x91e5887e,0x443e8036}},	//   mogi_, _žlič, допе, _eut_,
   {{0x7c29887f,0x443e8880,0x39e9835f,0x69ca8881}},	//   smer, _fut_, ідно_, _cofe,
   {{0x65638882,0x7bdd02bb,0xdd1c826f,0x764d0883}},	//   manh, _olsu, _záži, _atay,
   {{0x7dd00884,0x637683bf,0x5ec600ab,0x65638885}},	//   _läst, rünü, _লেগে, lanh,
   {{0x6d5e0886,0x7bcb8887,0x7c3e0888,0x799a8889}},	//   _pepa, _iogu, _supr, betw,
   {{0x7dd004b8,0x63a9888a,0x51878791,0x63a6088b}},	//   _näst, lden, _худа, _sakn,
   {{0xa3b90076,0x660e0831,0x7bcb888c,0x764d038a}},	//   चां_, robk, _kogu, _etay,
   {{0x7ae4011b,0x673b888d,0x6d5e088e,0x6563888f}},	//   tzit, _nguj, _wepa, hanh,
   {{0x7bcb803a,0x7dd004b8,0x6d5e0890,0x62898891}},	// [380] _mogu, _bäst, _tepa, nteo,
   {{0x673b81ca,0x7bcb8892,0x6b9b80f3,0x63a98198}},	//   _aguj, _logu, heug, hden,
   {{0xdb0f023e,0xd91000d7,0x765b8893,0x59c40894}},	//   _encà, ایز_, _awuy, लॉगर,
   {{0xef1a8895,0x63a98896,0x443e8897,0x200f8898}},	//   оме_, jden, _rut_, gogi_,
   {{0x443e831d,0x7dd0016d,0xd765803d,0x60188899}},	//   _sut_, _fäst, رنوی, ními,
   {{0x7dd0089a,0x63a9889b,0x443e869d,0x6b8281e8}},	//   _gäst, eden, _put_, _scog,
   {{0x7dd0089c,0x78450110,0xb4bc052a,0x601d002a}},	//   _häss, _tėva, _आपो_, xémo,
   {{0x69ca889d,0xd7648019,0x7dcf889e,0x7bcb889f}},	//   _sofe, _سنئی, _søst, _cogu,
   {{0x291808a0,0x7bcb88a1,0xa80283bf,0x1eaa803d}},	//   _hyra_, _dogu, ğıda, _بازي_,
   {{0x443e88a2,0x7abb0039,0x7dd008a3,0x601d08a4}},	//   _tut_, קציו, _mäss, témo,
   {{0x2d9c820f,0x7dd002af,0xc0578221,0x443e8074}},	//   meve_, _läss, мія_, _uut_,
   {{0x2d9c88a5,0x6aa28041,0x601d08a6,0x764088a7}},	//   leve_, _tsof, rémo, _kumy,
   {{0x442688a8,0x628988a9,0x7dd008aa,0xa2fd066f}},	//   _iho_, cteo, _näss, _एशेज_,
   {{0x2d9c80f1,0x7dd4809f,0x764088ab,0x7bcb83ed}},	//   neve_, _bàsi, _mumy, _zogu,
   {{0x442688ac,0x200f88ad,0x2bbb01a8,0x16340198}},	//   _kho_, yogi_, يارة_, теря,
   {{0x7bcb81df,0x6aad88ae,0x2ba908af,0x439408b0}},	//   _xogu, _šafi, _चोखा, касс,
   {{0xa3d68424,0x6563833e,0x4e0e8035,0x764d08b1}},	// [390] _हवन_, yanh, ाकाई_, _utay,
   {{0x2d9c88b2,0x442688b3,0x6b9b82af,0xdbd68074}},	//   jeve_, _lho_, zeug, _hääl,
   {{0x7dd000f2,0xdb0b80f2,0x2d9c88b4,0x63a988b5}},	//   _väst, _ingå, deve_, yden,
   {{0xdb0f03a8,0x442688b6,0xddcd016b,0x656380b9}},	//   _encá, _nho_, _staň, wanh,
   {{0x20030025,0x7c2d0687,0x656388b7,0x7dd00364}},	//   čkih_, mmar, tanh, _täst,
   {{0x442688b8,0x44390051,0x291800f2,0x0ea880e8}},	//   _aho_, _his_, _fyra_, ькій_,
   {{0x443908b9,0x7bcb88ba,0x44268046,0x656388bb}},	//   _kis_, _pogu, _bho_, ranh,
   {{0x442688bc,0x7c2d08bd,0x443908be,0x7e7d08bf}},	//   _cho_, nmar, _jis_, kusp,
   {{0x443908c0,0x66f38894,0x656388c1,0x2a6908c2}},	//   _mis_, _अधिक_, panh, nsab_,
   {{0x443908c3,0x3f9d88c4,0x600808c5,0x628988c6}},	//   _lis_, lewu_, zımd, rteo,
   {{0x628988c7,0x7c2d08c8,0x7bcb88c9,0xdb060168}},	//   steo, kmar, _togu, _pakë,
   {{0xf77208ca,0x44390046,0x64418012,0x656181a3}},	//   داد_, _nis_, _iuli, _helh,
   {{0x442d88cb,0x81d588cc,0x644188cd,0x213c80ee}},	//   mme_, _подх, _huli, _fgvh_,
   {{0x644188ce,0x7c2608cf,0x4439061f,0x3f8401b9}},	//   _kuli, _shkr, _ais_, żmu_,
   {{0x65618003,0x443908d0,0xb8f480c8,0xa3b48054}},	//   _melh, _bis_, _সে_, _छोड_,
   {{0x442d8179,0x644188d1,0x7c2d08d2,0xf0628081}},	//   nme_, _muli, gmar, _скъп,
   {{0x291e0025,0x443908d3,0x160f88d4,0x422608d5}},	// [3a0] _šta_, _dis_, िवार_, едав,
   {{0x442d88d6,0x443908d7,0x7c2d08d8,0xdb06001b}},	//   hme_, _eis_, amar, _jaké,
   {{0x443908d9,0x644188da,0x442d88db,0x61fe08dc}},	//   _fis_, _nuli, kme_, rnpl,
   {{0x442d88dd,0x7dd00364,0x3f8208de,0xe853003d}},	//   jme_, _täss, ngku_, انند,
   {{0x2d9c820f,0x442688df,0x442d88e0,0x245e001b}},	//   teve_, _rho_, dme_, lům_,
   {{0x443908e1,0x644188e2,0x442d88e3,0x27f2008e}},	//   _zis_, _buli, eme_, _lmyn_,
   {{0x644188e4,0x2d9c80f1,0xd49784d9,0x27e008e5}},	//   _culi, reve_, еры_, _olin_,
   {{0x644188e6,0x442681e9,0x44390069,0x69ce011e}},	//   _duli, _qho_, _xis_, _hobe,
   {{0x65618065,0x69ce08e7,0x7c39831d,0x2d9c8168}},	//   _felh, _kobe, _diwr, peve_,
   {{0x44268051,0x27e008e8,0xef1f08e9,0x442d88ea}},	//   _who_, _alin_, ngüe_, ame_,
   {{0x644188eb,0xdbd68364,0x33d6835f,0x27e008ec}},	//   _guli, _pääl, _підт, _blin_,
   {{0x7e7d04a2,0xa2e688ed,0x7c2d0079,0x442d88ee}},	//   tusp, _поед, xmar, cme_,
   {{0x443908ef,0x0cc906ce,0x644188f0,0xa3d58006}},	//   _ris_, रह्म, _zuli, _सकत_,
   {{0x443901e9,0x7afd88f1,0x644188f2,0x27e008f3}},	//   _sis_, úste, _yuli, _elin_,
   {{0x443908f4,0x7e7d08f5,0xdbd68009,0x644188f6}},	//   _pis_, susp, _tääl, _xuli,
   {{0x44390069,0xa4010264,0x75d8007e,0x69c88106}},	//   _qis_, ্ষ্য_, _ağzı, ljde,
   {{0x443908f7,0x98ac83bf,0x1b0e80ab,0x7f490216}},	// [3b0] _vis_, madı_, াইকে_, ñequ,
   {{0x443903f8,0x69da88f8,0x98ac861c,0x9f590174}},	//   _wis_, nkte, ladı_, insí_,
   {{0xd36688f9,0x69ce08fa,0xaca30133,0x27e00198}},	//   _په_, _dobe, _kpọg, _ylin_,
   {{0x443908fb,0x7e6d08fc,0x6e3a8362,0x2d83021e}},	//   _uis_, _kvap, _aitb, lgje_,
   {{0xe7e288fd,0x2fcd80c9,0x6e3a88fe,0x2fdf874c}},	//   _खतरा_, _voeg_, _bitb, _vlug_,
   {{0x69ce08ff,0x64418900,0x20048088,0x7d1a8901}},	//   _gobe, _puli, _ejmi_, _byts,
   {{0x442d8902,0x65618903,0x301b80f7,0x6441811c}},	//   tme_, _velh, _فترة_, _quli,
   {{0x7bcf0012,0x64418904,0x2242008e,0x69da8905}},	//   _jocu, _vuli, _yukk_, ekte,
   {{0x628d0906,0x1309835f,0x9f4200f1,0x65618907}},	//   ntao, ьний_, shkë_, _telh,
   {{0x7bcf0012,0x64418908,0xb63587c3,0x63ad0909}},	//   _locu, _tuli, _شفاع, hdan,
   {{0xf8e1090a,0x63ad090b,0x442d890c,0xdb1d00f7}},	//   पनिय, kdan, pme_, _cosú,
   {{0x13a7803d,0x79818114,0x6e3a890d,0x78bc8338}},	//   _سنتی_, sglw, _zitb, årva,
   {{0x63ad090e,0x69c4090f,0x21e401ec,0x3f8c009a}},	//   ddan, रामी, _höhe_, ędu_,
   {{0x7ae98065,0x7e6d012b,0x69da8910,0x827680be}},	//   mzet, _dvap, ckte, _יענע_,
   {{0xa8060098,0x69ce0911,0xc5630912,0x2bc58913}},	//   _изкл, _robe, ркск, वापा,
   {{0x63ad0914,0x7bc98915,0x63ab8916,0x6f16809a}},	//   gdan, njeu, _jagn, życi,
   {{0x69ce0917,0x7bcf0918,0xe7f780d4,0x7ae98919}},	// [3c0] _pobe, _docu, ूचना_, nzet,
   {{0xdb0d008b,0x63ab891a,0x867b01c6,0x63ad091b}},	//   rjað, _lagn, _קריו, adan,
   {{0xa50a091c,0x3d16835a,0x8fa6891d,0x1d0a091e}},	//   _цена_, _पुढे_, каже, _цени_,
   {{0x4444091f,0x69ce0920,0x63ab8921,0x78b5026c}},	//   _iu_, _wobe, _nagn, _drzv,
   {{0x44440922,0xe7f3809a,0x776403a8,0xe7378923}},	//   _hu_, _आगरा_, _meix, вец_,
   {{0x44440924,0x77640118,0x249a00b9,0x7ae98925}},	//   _ku_, _leix, _kppm_, dzet,
   {{0x44440926,0x63ab8098,0x6f098927,0x629986c0}},	//   _ju_, _bagn, _exec, _apwo,
   {{0x44440928,0x3d16835a,0xb5fb00f7,0x63ab8929}},	//   _mu_, _पुणे_, rsái, _cagn,
   {{0x4444092a,0x249a008e,0xdb028118,0x7ae98061}},	//   _lu_, _lppm_, _taoí, gzet,
   {{0x4444092b,0xbda587bd,0xdb1d0331,0x6e3a837a}},	//   _ou_, _محمو, _posú, _uitb,
   {{0x4444092c,0x601d092d,0x717b010f,0x69da892e}},	//   _nu_, lémi, וניס, rkte,
   {{0x63ab892f,0xb4c08076,0x7ec900f1,0xb5fb0073}},	//   _gagn, ुही_, _nëpë, nsáv,
   {{0x44440930,0x77640931,0x63ad05f5,0xd25080f7}},	//   _au_, _deix, vdan, _انت_,
   {{0x44440932,0x63ab8933,0x76440326,0xceb381c6}},	//   _bu_, _zagn, _duiy, ביש_,
   {{0x44440934,0xa3d68935,0x77640936,0x657a00f7}},	//   _cu_, _हवा_, _feix, ótha,
   {{0x249a00b9,0x600802d0,0x6b840937,0x63a0821e}},	//   _dppm_, rımc, ggig, nemn,
   {{0x44440938,0x63ad0939,0x27e6893a,0x628081e0}},	// [3d0] _eu_, rdan, dhon_, numo,
   {{0x4444093b,0xa2940160,0x601d093c,0x628d00e5}},	//   _fu_, рафі, démi, rtao,
   {{0x44440782,0xf1ba8104,0x6280893d,0x94d5093e}},	//   _gu_, _chơi_, humo, _сонц,
   {{0xf093893f,0x65650940,0x62808941,0x63a08942}},	//   ינע_, _hehh, kumo, jemn,
   {{0x44440943,0x63ab8944,0x628080eb,0x6008080a}},	//   _zu_, _ragn, jumo, nıma,
   {{0xee38835f,0x7ae98945,0x8d548098,0x63ab8946}},	//   вні_, vzet, атъч, _sagn,
   {{0x44440947,0x63ab8948,0x64450074,0x20020035}},	//   _xu_, _pagn, _juhi, ynki_,
   {{0x64450949,0x27e6894a,0x7ae9894b,0x3f89022c}},	//   _muhi, chon_, tzet, _ncau_,
   {{0x7ae9803b,0x63ab894c,0x23c580d4,0x7764094d}},	//   uzet, _vagn, वाबद, _reix,
   {{0x798502f7,0x7ae9894e,0x7764094f,0x7bdb8950}},	//   nghw, rzet, _seix, skuu,
   {{0x54558951,0x63ab8952,0x6d418953,0x7ae98019}},	//   _свет, _tagn, _igla, szet,
   {{0x44440954,0xdce38955,0x63a0808e,0x92b58250}},	//   _ru_, nanč, cemn, _محتا,
   {{0x644502f1,0xe7370956,0x3ea90957,0x62c78174}},	//   _auhi, лею_, _csat_, _جزاك,
   {{0x44440958,0x64450959,0x2002026c,0x7c3d0362}},	//   _pu_, _buhi, snki_, _aisr,
   {{0x444406e3,0xfce3095a,0x7764095b,0x6565008e}},	//   _qu_, боро, _teix, _dehh,
   {{0x4444095c,0xdce38110,0xfaa6095d,0x81bc81a9}},	//   _vu_, janč, лабо, smēt,
   {{0x6d41895e,0x4444095f,0xfe7200d5,0x032602fb}},	// [3e0] _ogla, _wu_, _ادب_, удан,
   {{0x44440960,0x6d41845a,0x63a08961,0xf1ba8129}},	//   _tu_, _ngla, zemn, _phơi_,
   {{0x44440962,0x81bc8029,0x27e68963,0x644502a0}},	//   _uu_, slēg, thon_, _guhi,
   {{0x2a6d8964,0x6d418965,0x4b550081,0xbe8a8966}},	//   kseb_, _agla, _върт, еске_,
   {{0x44200967,0x6d5c0968,0xcc3b00be,0x44320969}},	//   mli_, obra, _רעכט, mmy_,
   {{0x4432096a,0x6143096b,0xe9df00f7,0xc6930039}},	//   lmy_, _гера, _dtús_, צאו_,
   {{0xe0c7896c,0x4420096d,0xdb1d03ec,0x63a0896e}},	//   _از_, oli_, _ansè, temn,
   {{0x4420017b,0x02a6896f,0x44320970,0x6e3e0971}},	//   nli_, гром, nmy_, _lipb,
   {{0x060a8972,0xaf068973,0xe20b009a,0x248e81e0}},	//   _знак_, _спал, łóż_, stfm_,
   {{0x44200255,0x2a978013,0x63a08974,0x62808975}},	//   hli_, ائية_, semn, rumo,
   {{0x438680d5,0x683e8110,0x62808976,0x02170039}},	//   _ملاق, _būda, sumo, רחים_,
   {{0x273a8182,0x3f8686c0,0x64450977,0x9f590168}},	//   _günü_, ngou_, _ruhi, misë_,
   {{0xeab284e3,0x64450978,0x9f590168,0x98b8022b}},	//   _دعا_, _suhi, lisë_, _ferħ_,
   {{0x44200979,0x2fc0097a,0x44320035,0x6445097b}},	//   eli_, _enig_, emy_, _puhi,
   {{0x4420097c,0x9f5900f1,0xfaff00f1,0xa2ac897d}},	//   fli_, nisë_, _ndër_, जिक्,
   {{0x4420097e,0x61fa897f,0x81bc80eb,0xdb0f0118}},	//   gli_, litl, slēd, _incú,
   {{0x6d5c0098,0xdce381f4,0x3ea90980,0xe51b83b7}},	// [3f0] bbra, vanč, _usat_, _पुनि_,
   {{0x44200981,0x6d5c0362,0x61fa8982,0x9f590168}},	//   ali_, cbra, nitl, kisë_,
   {{0x44200983,0xa3d58006,0xdce38984,0xdb04016a}},	//   bli_, _सकल_, tanč, rdiá,
   {{0xb4c3035a,0x44200985,0x673b011f,0x9f5903ed}},	//   ्ही_, cli_, žuju, disë_,
   {{0xd90f0986,0x8d658987,0xdce38988,0xea0080ff}},	//   _کیا_, авле, ranč, _giầy_,
   {{0x3f758104,0x7dd48722,0x443d8989,0xaaa80081}},	//   ều_, _bàsq, _siw_, _съюз_,
   {{0x5ed380c8,0x463c098a,0x7aed047f,0x244a898b}},	//   _দেশে, געגע, lzat, _cùm_,
   {{0x7bcd098c,0x0b45898d,0x22468122,0x6d5c098e}},	//   njau, шнин, _buok_, zbra,
   {{0x7aed098f,0x63af0990,0x11e58991,0x4a458992}},	//   nzat, _macn, ижим, јнов,
   {{0x6d41803a,0x43758077,0xe9d98993,0x44200994}},	//   _ugla, _چهار, тко_, zli_,
   {{0xf1b20451,0x44200995,0x23c58996,0x53c580d4}},	//   קסט_, yli_, वादद, वादश,
   {{0x22958997,0x629d074c,0x6d5c0998,0xb4b18999}},	//   _видя, _opso, wbra, टटी_,
   {{0x228f0019,0x6d5c099a,0x61fa899b,0x4420099c}},	//   jük_, tbra, bitl, vli_,
   {{0x2d87899d,0x4420099e,0x200900b9,0xeaf8853d}},	//   ngne_, wli_, _ejai_, _حرمت_,
   {{0x4420099f,0x64a609a0,0x629d003a,0x6d5c09a1}},	//   tli_, шава, _apso, rbra,
   {{0x35c7800f,0xdb0400a9,0x864604ad,0x2fc0031d}},	//   लाड़, ndiç, _книж, _unig_,

   {{0x442009a2,0xade589a3,0x443209a4,0x896609a5}},	// [400] rli_, कसान_, rmy_, икаж,
   {{0x442009a6,0xd5a409a7,0x63af00f7,0x68e481d0}},	//   sli_, _الدی, _eacn, _řidi,
   {{0x18a609a8,0x161f09a9,0xb5fb09aa,0x68e489ab}},	//   раем, _मीटर_, rsát, _ƙidi,
   {{0x442009ac,0x7bdf09ad,0x244a8014,0x7e6409ae}},	//   qli_, ckqu, _rùm_, _kwip,
   {{0x63a409af,0xe5c689b0,0x614609b1,0x3f8689b2}},	//   mein, иско, _вега, rgou_,
   {{0xd49a8381,0x5d7a0158,0x672981a9,0x63af09b3}},	//   ври_, דאַק, _dzej, _zacn,
   {{0x53e689b4,0xcbe689b5,0x672989b6,0x00000000}},	//   ициа, иции, _ezej, --,
   {{0x9f5908cf,0xdb008065,0x63a409b7,0x7afb0289}},	//   risë_, lemé, nein, _žuti,
   {{0x9f5900f1,0x75e201ac,0xee3a89b8,0x6fb38290}},	//   sisë_, _rôzn, _ана_, _بمقا,
   {{0x63a40352,0xe61f00e7,0x9f5909b9,0x3e328019}},	//   hein, ntôt_, pisë_, _بہتر,
   {{0x7aed09ba,0x9f5909bb,0x3167819d,0x61fa89bc}},	//   zzat, lisé_, _denz_, ritl,
   {{0x228f084a,0x61fa89bd,0x656889be,0x6618816b}},	//   yük_, sitl, _hedh, lovk,
   {{0x61fa89bf,0x644889c0,0xf1c909c1,0x34df09c2}},	//   pitl, _hudi, रामन, नन्द,
   {{0x644889c3,0x656889c4,0x249e89c5,0x752d801b}},	//   _kudi, _jedh, _kptm_, řaze,
   {{0x63a409c6,0x403509c7,0x31578039,0xb4c309c8}},	//   fein, _лекс, _דיון_, ्हे_,
   {{0x81e880c8,0x644889c9,0x2cba09ca,0x7aed09cb}},	//   _যদি_, _mudi, _drpd_, tzat,
   {{0x6e950307,0x7bcd0364,0x4df88105,0x5e9500f7}},	// [410] _الخا, rjau, ्चाई_, _الخط,
   {{0x201909cc,0x7bcd09cd,0x228f09ce,0xa80281cc}},	//   losi_, sjau, rük_, şıla,
   {{0x63af09cf,0xea008028,0x6618826f,0x6d4509d0}},	//   _tacn, _giấy_, dovk, _igha,
   {{0x64570102,0x63a400e7,0xdce709d1,0x5f7480f7}},	//   _itxi, cein, najč, قاهر,
   {{0xef1f080a,0x2bc5816f,0xa3bc06a7,0x656880d7}},	//   zgün_, वासा, _आफत_, _bedh,
   {{0x75eb0059,0x201909d2,0xa1840150,0x7bc289d3}},	//   _düzg, hosi_, _мысл, _anou,
   {{0x201909d4,0x2d8789d5,0xddc98087,0x6d4509d6}},	//   kosi_, rgne_, _aveţ, _mgha,
   {{0xd77489d7,0x6e45803d,0x3ff980be,0x316781e8}},	//   _واقع, _هنرم, _עפּע, _senz_,
   {{0x6568822e,0x69d509d8,0x201909d9,0x316c89da}},	//   _fedh, _koze, dosi_, fadz_,
   {{0x6d4509db,0x3ead83a7,0x65688077,0x69d509dc}},	//   _ngha, _iset_, _gedh, _joze,
   {{0x27338104,0x645701e9,0x7e6409dd,0x2019047f}},	//   _ảnh_, _ntxi, _swip, fosi_,
   {{0x6d4509de,0xdb0609df,0x0cb3864a,0xfaff067f}},	//   _agha, _laká, ंटीम, _reën_,
   {{0xe9ce89e0,0x64570102,0x6d450609,0x05c30035}},	//   _ек_, _atxi, _bgha, शांब,
   {{0xc5f28158,0x9f590009,0x63a40114,0x644889e1}},	//   ִדן_, ensä_, wein, _yudi,
   {{0x764189e2,0xdcf70201,0x644889e3,0x201909e4}},	//   _mily, _baxı, _xudi, bosi_,
   {{0x6b8989e5,0x6618826f,0x776989e6,0x7ddd88f9}},	//   ngeg, zovk, _neex, _dèsi,
   {{0x63a409e7,0xb5fb03a7,0x69d509e8,0xdb008061}},	// [420] rein, rsár, _boze, temé,
   {{0xb5fb09e9,0x05aa04d9,0x458609ea,0x3ea002d5}},	//   ssár, _свой_, _угов, _ipit_,
   {{0x656889eb,0x3ead89ec,0x442f89ed,0x6008080a}},	//   _redh, _aset_, _ohg_, yıml,
   {{0x644889ee,0x656e09ef,0x76498144,0x6b89890d}},	//   _rudi, labh, _buey, jgeg,
   {{0x6448803b,0x6b8989f0,0x69c38009,0x764189f1}},	//   _sudi, dgeg, _onne, _bily,
   {{0x2d9187d9,0x644888a4,0x20190135,0x9f5902be}},	//   _özel_, _pudi, zosi_, risé_,
   {{0x270409f2,0xdcf70201,0x645c09f3,0x442f89f4}},	//   रपुर_, _yaxı, npri, _bhg_,
   {{0x69c389f5,0xdb06003e,0x656e09f6,0x65688077}},	//   _anne, _zaká, habh, _wedh,
   {{0x6ff58063,0x75eb0214,0x316c8890,0x600801cc}},	//   jący, _yüzd, tadz_, rıml,
   {{0xc05a89f7,0x64488573,0x76418114,0x69c38144}},	//   лім_, _tudi, _gily, _cnne,
   {{0x644889f8,0x645c0639,0x201909f9,0x656e0706}},	//   _uudi, jpri, tosi_, dabh,
   {{0x69c389fa,0xa3cc0740,0x61fe0214,0x442f82c4}},	//   _enne, लाफ_, hipl, _ghg_,
   {{0x201909fb,0x2d9809fc,0x442480b9,0xdce181a9}},	//   rosi_, ffre_, mlm_, _ielā,
   {{0x6d480024,0xddcd009a,0x10f98019,0x15eb00e8}},	//   ždan, _stał, ابیں_, уємо_,
   {{0xd12f896b,0x69d509fd,0x7c240609,0x645c09fe}},	//   _хх_, _roze, flir, gpri,
   {{0x68e10074,0xdb0f0216,0x61fe09ff,0x98a78196}},	//   _üldi, _hacé, eipl, _agnė_,
   {{0x69d50a00,0x27e90a01,0xdd9100f7,0x645c0a02}},	// [430] _poze, _ilan_, _قوة_, apri,
   {{0x44248106,0x672d0a03,0xdb098118,0x776981b4}},	//   hlm_, _izaj, ndeá, _seex,
   {{0x463c0158,0x7c240a04,0x69d50a05,0xdb1d0a06}},	//   _געזע, blir, _voze, _insí,
   {{0x75eb07d9,0x76418a07,0xdb0981a8,0x2b4680ff}},	//   _düze, _sily, hdeá, _ngoc_,
   {{0x442480dd,0x62350a08,0xdb2300d7,0xdb060a09}},	//   dlm_, _мему, _روسی, _taká,
   {{0x27180028,0x442f8573,0x27fd8114,0x321a0a0a}},	//   ọng_, _shg_, siwn_, copy_,
   {{0x27e90a0b,0x75eb0179,0x64428a0c,0x2bc58a0d}},	//   _olan_, _güze, _bioi, वाला,
   {{0xa9f385b3,0x8c428a0e,0xa3cc016f,0x5f948193}},	//   ेच्छ_, меще, लाय_, _нист,
   {{0xdd3a8012,0x22430a0f,0x6b898a10,0x6442802a}},	//   tăţi, _kijk_, rgeg, _dioi,
   {{0x6b898a11,0x645c0a12,0x75eb02d0,0xfaff067f}},	//   sgeg, ypri, _yüze, _reël_,
   {{0x27e906c0,0x600a0a13,0xe5c48a14,0x3ea00a15}},	//   _blan_, ином_, _эсто, _spit_,
   {{0xd9a60a16,0x64428081,0x7a30016d,0xdb1d016a}},	//   _ऑस्ट, _gioi, mäte, _ansí,
   {{0xdb0f0a17,0x8db6004a,0x11d58a18,0x51f58a19}},	//   _facé, осві, _мікр, _وستر,
   {{0x645c0a1a,0xcb368039,0x27e90a1b,0x672d069f}},	//   tpri, _ואני_, _elan_, _dzaj,
   {{0x656e0834,0x236001ed,0xdb0b816a,0x2ea681d0}},	//   rabh, tbij_, _magí, _गन्त,
   {{0x27e90a1c,0x656e0a1d,0x645c0a1e,0xf34e8870}},	//   _glan_, sabh, rpri, _hụrụ_,
   {{0xe1fa0a1f,0x23600613,0x3ea00a20,0x53368158}},	// [440] ага_, rbij_, _upit_, ַנען_,
   {{0x244e0a21,0xf6530039,0x645c0a22,0xf77f0214}},	//   _tým_, _קצת_, ppri, rkçe_,
   {{0x321a0873,0x7c240a23,0x224301ed,0xf34e8135}},	//   ropy_, plir, _dijk_, _mụrụ_,
   {{0xf34e8133,0xdb040174,0x7a300198,0xb09a83de}},	//   _lụrụ_, idiú, däte, ייער,
   {{0x7bc60a24,0xddc98a25,0x2d588a26,0xdce701a9}},	//   _inku, _sveš, биль_, majā,
   {{0xddc9801b,0x624901a1,0x8cb88a27,0x78af0198}},	//   _kteř, _džod, ्मलो, äivä,
   {{0xc0c900a9,0x9cca8a28,0x37e680e8,0x3ea981b9}},	//   _луѓе_, рыла_, _довг, ħata_,
   {{0xd00a8a29,0x68e30257,0x39478a2a,0x7dd00198}},	//   _тебе_, ønde, _agns_, _väsy,
   {{0x77628a2b,0xf34e8a2c,0x661c0a2d,0xc1a68a2e}},	//   mbox, _bụrụ_, kork, ојни,
   {{0x661c0a2f,0x64a68a30,0x68e901d0,0x776288dc}},	//   jork, _маза, _ředi, lbox,
   {{0x27e90220,0xf2df001c,0x7bc60a31,0xc9530039}},	//   _plan_, _ngân_, _onku, ומת_,
   {{0x645a8a32,0x68318a33,0x77628a34,0x6724018e}},	//   _itti, rådg, nbox, _byij,
   {{0xf7738039,0x661c0a35,0x99d381f9,0x63b60428}},	//   וקר_, fork, ستیا, ddyn,
   {{0xdcfa8214,0x2d9e8267,0x661c0a36,0xf34e8133}},	//   _hatı, _jbte_, gork, _gụrụ_,
   {{0xdcfa87d9,0x224b0a37,0x224300f3,0xdb6b02dc}},	//   _katı, _suck_, _rijk_, ирал_,
   {{0x69d88a38,0x27e90a39,0x3eb00009,0xf34e8133}},	//   _hove, _ulan_, ältä_, _zụrụ_,
   {{0x161a8a3a,0x672d0a3b,0x69d88a3c,0x2aab0a3d}},	// [450] धवार_, _uzaj, _kove, штво_,
   {{0x69d88a3e,0x645a8a3f,0x661c00dd,0x7bc60a40}},	//   _jove, _otti, cork, _enku,
   {{0x69d88039,0xef58819d,0xb4b50a41,0x90990a42}},	//   _move, _ịfụn, _эйнш, свет_,
   {{0x2bb68a43,0x6d488a44,0x224300f3,0x59c9001b}},	//   _अफगा, _agda, _wijk_, राहर,
   {{0x645a8a45,0xf1bc8076,0x68e3006a,0x9e6480e8}},	//   _atti, ्ञान, øndb, двід,
   {{0x76450101,0x7a3001ec,0xb5fb002a,0x764d02d0}},	//   _jihy, täte, lpáb, _muay,
   {{0x69c70a46,0x459c0158,0x5ed380ab,0xdcfa807e}},	//   _inje, יסגע, _দেখে, _batı,
   {{0xf7738a47,0x6e958009,0x7a300a48,0xf1c906ab}},	//   _زار_, _нибу, räte, रावन,
   {{0x81ae0a49,0x69d88613,0x645a8a4a,0xa3cc0935}},	//   কার_, _bove, _etti, लात_,
   {{0x69d88a4b,0x7e698135,0x99158a4c,0x2484819d}},	//   _cove, _iwep, зьмі, _ịmee_,
   {{0x69d88a4d,0x6d55009a,0x6c4980f7,0x661c0a4e}},	//   _dove, dcza, _الصف_, vork,
   {{0x764d0a4f,0x201d8035,0x3ebf8a50,0x69ce8a51}},	//   _buay, nowi_, _krut_, öber,
   {{0x63a98a52,0xdce881d0,0xa3b48074,0xf34e8135}},	//   meen, _oddě, _छोट_, _tụrụ_,
   {{0x63a98a53,0x7e698a54,0x225f859e,0x69d88a55}},	//   leen, _mwep, mpuk_, _gove,
   {{0xdcfa8457,0x8af00085,0xdce701a9,0xdb0f0144}},	//   _yatı, hbət, tajā, _oncó,
   {{0x24518a56,0x69c70a57,0x69d88a58,0x661c0088}},	//   _mám_, _anje, _zove, sork,
   {{0x661c0057,0x764d0a59,0x765b8a5a,0x7e698133}},	// [460] pork, _guay, _ntuy, _nwep,
   {{0x69d8862f,0x14bd885d,0x63a98a5b,0x42230073}},	//   _xove, ्माण, heen, едув,
   {{0x24518a5c,0x81ae00c8,0x63a98a5d,0x62960a5e}},	//   _nám_, কাল_, keen, styo,
   {{0x20020a5f,0x7bc6029b,0x26c00503,0x63a98a60}},	//   niki_, _unku, _krio_, jeen,
   {{0x1dc78a61,0x63a98a62,0xdb060106,0x64460a63}},	//   लांत, deen, _bakå, _iiki,
   {{0xdcfa82bb,0x68e18a64,0xf1d0801c,0xdb0f03a8}},	//   _satı, kyld, _mạch_, _encó,
   {{0x2451801c,0x645800e7,0x24778087,0x7e698870}},	//   _cám_, _évid, găm_, _ewep,
   {{0x63a98079,0x75eb0201,0x24518a65,0xa6d380ab}},	//   geen, _müza, _dám_, _দেওয়,
   {{0x644607ca,0x20020a66,0x36678a67,0x5a348a68}},	//   _miki, diki_, _нато_, мнит,
   {{0x68318370,0x64460a69,0x68e1813c,0x62840084}},	//   råde, _liki, fyld, irio,
   {{0x20020a6a,0x80df80c8,0x9b46803d,0x63a98a6b}},	//   fiki_, _ফেব্, _فناو, been,
   {{0x64460a6c,0x683f0110,0xf1d0801c,0x7bd985ee}},	//   _niki, _kūdi, _bạch_, _gowu,
   {{0x9f4d816d,0x7c228a6d,0x27e68a6e,0x69d88a6f}},	//   _umeå_, _ikor, ikon_, _tove,
   {{0x644603c3,0x4a7b812a,0x62840a70,0x5558002e}},	//   _aiki, _פרוב, drio, заря_,
   {{0x64460a71,0x2c5580eb,0x20020a72,0x6d550035}},	//   _biki, _kāda_, biki_, rcza,
   {{0x64460a73,0x683f0029,0x671e000f,0x69c702ce}},	//   _ciki, _līdz, _युवक_, _snje,
   {{0x4422013c,0xe802009a,0xf1d080ff,0x5edc8264}},	// [470] _dkk_, _लगता_, _gạch_, _মেসে,
   {{0xda0c8a74,0x2fc9022c,0x8af00085,0x20b08a75}},	//   िचित_, _hnag_, vbət, _जनाध,
   {{0x6284040e,0x64460a76,0xdb0b8065,0x7c228a77}},	//   ario, _fiki, _magá, _okor,
   {{0xdb0f05a4,0x64460a78,0x3ebf8a79,0x321e8a7a}},	//   _hací, _giki, _prut_, hoty_,
   {{0x44290a7b,0x2451826f,0x4ea781e2,0x9f4b0216}},	//   mla_, _sám_, яржа, licó_,
   {{0x44290a7c,0x20020a7d,0x7c228a7e,0x63a98079}},	//   lla_, ziki_, _akor, ween,
   {{0x58840a7f,0x44290a80,0x63a98a81,0xd5fb819d}},	//   _пыта, ola_, teen, _apụ,
   {{0x24518775,0x69dc8884,0x44290a82,0x7a300a83}},	//   _vám_, ören, nla_, mäta,
   {{0x44290695,0x3ebf845f,0x27ff8a84,0x63a98a85}},	//   ila_, _urut_, _imun_, reen,
   {{0x44290a86,0x13068364,0x81bc80eb,0x7c228a87}},	//   hla_, ьный_, blēm, _ekor,
   {{0x20020a88,0x66038a89,0xf1d0801c,0x2fc90a2a}},	//   tiki_, mink, _sạch_, _bnag_,
   {{0xad1a893f,0x3f8f859c,0x44290a8a,0x9f4b06a5}},	//   _ווער, nggu_, jla_, dicó_,
   {{0x44290a8b,0x7c298179,0x20020a8c,0x62898a8d}},	//   dla_, mler, riki_, queo,
   {{0x66038a8e,0x64460a8f,0x64a60a90,0x20020a91}},	//   nink, _siki, мага, siki_,
   {{0x27ed8a92,0x64460a93,0x80160a94,0xe6430a95}},	//   _olen_, _piki, _офиц, терп,
   {{0x7c2987d9,0xdb008a96,0x26c00a97,0x2d840214}},	//   nler, lemá, _trio_, şme_,
   {{0x41c901fe,0xec098104,0x66038a98,0xdb0f04c3}},	// [480] रांस, yến_, kink, _fací,
   {{0x64460a99,0xceb40086,0x66038a9a,0x27ed8669}},	//   _wiki, _isə_, jink, _alen_,
   {{0x44290a9b,0x64460a9c,0x7c298a9d,0x66038a9e}},	//   bla_, _tiki, kler, dink,
   {{0x62840a9f,0x44290aa0,0xe8d680be,0xbf9b0129}},	//   prio, cla_, ווער_, hiên,
   {{0x27e68aa1,0x7c298aa2,0x22478aa3,0x66038aa4}},	//   rkon_, dler, _oink_, fink,
   {{0x27e68aa5,0xa3cc009a,0x44200aa6,0x7bdd81ec}},	//   skon_, लाव_, loi_, ösun,
   {{0x7c298aa7,0xdcfe0214,0xbf9b03a7,0x27ed8aa8}},	//   fler, _kapı, diên, _flen_,
   {{0xfbdf0104,0x69dc0aa9,0x7c298aaa,0x44200aab}},	//   _liên_, _hore, gler, noi_,
   {{0xc9868aac,0x34ab0aad,0xdb0b8aae,0x6aa880d4}},	//   муни, _चन्द, _pagá, कबेर,
   {{0x44290aaf,0x645e0289,0x7c298ab0,0xfbdf001c}},	//   zla_, _otpi, aler, _niên_,
   {{0x69dc0ab1,0x442902bb,0x7c298620,0x2247879f}},	//   _more, yla_, bler, _dink_,
   {{0xe3638ab2,0xca488104,0x69dc0ab3,0x7c228ab4}},	//   _акци, _lời_, _lore, _ukor,
   {{0x8c438ab5,0x44290ab6,0xe81f800c,0x3f85017b}},	//   _реце, vla_, यकता_, ğlu_,
   {{0xbf9b03a7,0x69dc021e,0x9f4b0216,0x06e180ab}},	//   ciên, _nore, ticó_, _মেডি,
   {{0x62868ab7,0x44290ab8,0xdb0f05a4,0x76488ab9}},	//   škod, tla_, _vací, _midy,
   {{0x66038aba,0x44200abb,0x44290365,0xdb0d03a7}},	//   zink, goi_, ula_, ndaç,
   {{0x66038abc,0x63a28abd,0xdce7009a,0x5a350abe}},	// [490] yink, _mbon, dają, енат,
   {{0x69dc0abf,0x44290ac0,0x7c2987d9,0xddc40668}},	//   _core, sla_, zler, _zviž,
   {{0x66038ac1,0x69dc0ac2,0x44200ac3,0x27ed86c0}},	//   vink, _dore, boi_, _plen_,
   {{0x6d5a8ac4,0xdd0d009a,0x66038ac5,0x44290085}},	//   _afta, półp, wink, qla_,
   {{0x69dc0ac6,0x660381e2,0x63ad0ac7,0x36698ac8}},	//   _fore, tink, mean, чало_,
   {{0x63ad0ac9,0x69dc816d,0xed598aca,0x65750168}},	//   lean, örel, чок_, nazh,
   {{0xdcfe0179,0x7c298179,0xa3e38074,0x7bdd0acb}},	//   _yapı, tler, _नकद_, _kosu,
   {{0x66038acc,0x63ad0acd,0x7f85803f,0x7f4d0ace}},	//   sink, nean, _سلطن, _ngaq,
   {{0x69c403b7,0x7c298179,0x3d0605b3,0xdb008acf}},	//   राची, rler, _हेने_, temá,
   {{0x63ad0ad0,0x7c298ad1,0xdb1d016d,0xe1ff009a}},	//   hean, sler, _insä, _swój_,
   {{0x7c298214,0xbf9b0073,0x31710ad2,0xbc6880f7}},	//   pler, riên, _mezz_, _يمكن_,
   {{0x44200ad3,0x6e250ad4,0x60dc8106,0x34bd8ad5}},	//   xoi_, _akhb, ärma, ्मीद,
   {{0x7bcb8ad6,0x63ad0ad7,0x63bb8ad8,0x6d478019}},	//   _ingu, dean, mdun, _újab,
   {{0x63bb8ad9,0xf1d0801c,0x40958ada,0x65750168}},	//   ldun, _hạnh_, _зрит, gazh,
   {{0xdca30adb,0xfbdf0104,0x44200adc,0x32058add}},	//   лари, _viên_, toi_, mily_,
   {{0x63bb8ade,0xc4d28158,0x7bdd0087,0xca4880ff}},	//   ndun, נגן_, _cosu, _rời_,
   {{0x69dc003b,0x629b8a7f,0xfbdf0028,0x44200adf}},	// [4a0] _pore, ntuo, _tiên_, roi_,
   {{0xf1d08028,0x81e180ab,0x44200ae0,0x171b0039}},	//   _lạnh_, নোর_, soi_, _מופע,
   {{0x69dc0ae1,0x63ad0ae2,0x4420002e,0xdcfe08c5}},	//   _vore, bean, poi_, _tapı,
   {{0x63ad0ae3,0xca4880ff,0x76488122,0x629b8084}},	//   cean, _vời_, _sidy, ktuo,
   {{0x69dc0ae4,0x3f9a809a,0xdce70035,0xfbd3801b}},	//   _tore, ępu_, rają, थानम,
   {{0x7bcb8ae5,0xb90600c8,0x7e628ae6,0x629b8122}},	//   _angu, _বই_, rpop, dtuo,
   {{0x3f6a8ae7,0x987e801b,0x7bdd0ae8,0x7bcb808e}},	//   _ниво_, _péče_, _yosu, _bngu,
   {{0xa2c403b7,0xf1d0801c,0x76488ae9,0x63bb8420}},	//   रिप्, _cạnh_, _widy, gdun,
   {{0xa3e805e8,0x63b98aea,0x7c2084dc,0x3205816b}},	//   _भवन_, _dawn, romr, fily_,
   {{0x7bcb8aeb,0x7c208082,0xa2b18aec,0x2006811b}},	//   _engu, somr, _अनर्, lioi_,
   {{0x6815809a,0x2bb88aed,0xdb1d0106,0x63b98aee}},	//   ląda, _आसपा, _inså, _fawn,
   {{0xc02e8104,0x63a28aef,0x9cd78039,0x20d58196}},	//   _điều_, _ubon, _רואה_, džią_,
   {{0x91e68af0,0x44268af1,0x2d8507a3,0x09e68af2}},	//   _поде, _iko_, óleo_, _подн,
   {{0xa2c40af3,0x92f283bf,0x69ca8af4,0x7bdd0af5}},	//   रिन्, ığım, _unfe, _sosu,
   {{0x63ad0af6,0xe57180be,0xa25b0187,0xb4cb0af7}},	//   tean, יַן_, _crôn, लमे_,
   {{0x657500f1,0x6836002a,0xdb008366,0x44268af8}},	//   sazh, táde, remæ, _jko_,
   {{0x63ad0af9,0x62490a2f,0x75eb007e,0xa7fd02d0}},	// [4b0] rean, _džon, _yüzl, ksız,
   {{0x63ad0afa,0x99990084,0xafdb0366,0x22b202d6}},	//   sean, _rusų_, smød, _dņk_,
   {{0x63ad0afb,0x78ba01ac,0xa7758afc,0xddc982d0}},	//   pean, _štvr, влеч, _ateş,
   {{0x66070586,0x44268afd,0xe50001a2,0xdb1d0106}},	//   lijk, _nko_, ोपरि_, _anså,
   {{0x7c2d0afe,0x44390aff,0x23690087,0x212b80ff}},	//   mlar, _ihs_, mbaj_, ́ch_,
   {{0x44268b00,0x6da58b01,0xada58b02,0x7c2d0b03}},	//   _ako_, тика, такл, llar,
   {{0x1fa786b5,0x34bd8b04,0x270d009a,0x32058b05}},	//   _праг, ्मेद, सपुर_, vily_,
   {{0x7c2d0b06,0xdb008009,0x629b8b07,0xd6d880ab}},	//   nlar, kemä, ttuo, _দেওয,
   {{0x66070a0f,0x63bb8b08,0x44268b09,0x7c2d011b}},	//   kijk, rdun, _dko_, ilar,
   {{0x3d1a0063,0x7c2d080a,0x44268b0a,0x7d798077}},	//   _मुझे_, hlar, _eko_, _آمار_,
   {{0x7c2d0b0b,0x629b8b0c,0x23e780e8,0xc95204de}},	//   klar, stuo, _підв, ימי_,
   {{0x7bcb8b0d,0x6e238b0e,0x7c2d0457,0x2d81010c}},	//   _ungu, lonb, jlar, _adhe_,
   {{0x443f8b0f,0x7c2d0b10,0x442d8b11,0x26c4001b}},	//   mmu_, dlar, mle_, ímo_,
   {{0x644b8b12,0xb5fb016a,0x2fdf8118,0x3ea90b13}},	//   _higi, spán, _loug_, _dpat_,
   {{0x442d8b14,0x644b8b15,0x7c2d0b16,0x44390b17}},	//   ole_, _kigi, flar, _bhs_,
   {{0x2d810b18,0x442d8b19,0x7c2d0b1a,0x443f8b1b}},	//   _edhe_, nle_, glar, nmu_,
   {{0x442d8219,0x443f8b1c,0xdb0f00f7,0x6e238b1d}},	// [4c0] ile_, imu_, _pacá, konb,
   {{0x644b8b1e,0xf1aa0077,0x442d8b1f,0x443f8b20}},	//   _ligi, باره_, hle_, hmu_,
   {{0x7c2d0b21,0x443f8886,0x27e00b22,0x442d8b23}},	//   blar, kmu_, _koin_, kle_,
   {{0x443f8b24,0x27e00b25,0x4f0a8b26,0x442d8b27}},	//   jmu_, _join_, мнен_, jle_,
   {{0x442d8b28,0x443f8b29,0x6e238b2a,0x96968098}},	//   dle_, dmu_, fonb, треш,
   {{0x442d8b2b,0x442680b2,0x7c240b2c,0x443f8b2d}},	//   ele_, _sko_, loir, emu_,
   {{0x69ce0b2e,0x644b80b4,0x443902f7,0xeb9f00e8}},	//   _inbe, _bigi, _yhs_, _kjøp_,
   {{0x68e30b2f,0x27e00364,0xeb978b30,0x644b8b31}},	//   ände, _noin_, вић_, _cigi,
   {{0x644b8b32,0xea00801c,0x2d968b33,0x78ad8140}},	//   _digi, _nhảy_, _арес, _ćava,
   {{0x442d8b34,0x7c2d017b,0x644b8b35,0xdb0401df}},	//   ale_, zlar, _eigi, ndiñ,
   {{0x442d8b36,0x44268b37,0x7c2d0b38,0xf9930039}},	//   ble_, _tko_, ylar, ברת_,
   {{0x44268578,0x442d8b39,0x644b8b3a,0x660700f3}},	//   _uko_, cle_, _gigi, wijk,
   {{0xa3cc0b3b,0x7c24062f,0x69ce0b3c,0x4ab6800c}},	//   लाई_, doir, _onbe, _अनिव,
   {{0x44248b3d,0x82778158,0x644b8b3e,0x44390b3f}},	//   lom_, _יעדע_, _zigi, _shs_,
   {{0x7c2d084a,0x66070a0f,0x644b8314,0x2bc4097d}},	//   tlar, rijk, _yigi, _लोहा,
   {{0x69ce0b40,0xe7870b41,0xe41400e8,0xfbdf00ff}},	//   _anbe, _руко, адсь, _tiêm_,
   {{0x7c2d0b42,0x6b828010,0x3b540087,0x64408198}},	// [4d0] rlar, _mdog, ркур, immi,
   {{0x44248b43,0x2fcd8b44,0x7c2d0b45,0x442d8b46}},	//   hom_, _sneg_, slar, zle_,
   {{0x442d8b47,0x7c2d03bf,0x21a4035f,0x6836027f}},	//   yle_, plar, риєм, láda,
   {{0x7c2d0086,0x44248b48,0xb8db0b49,0x6b828b4a}},	//   qlar, jom_, _अन_, _ndog,
   {{0x442d83a6,0x6e238b4b,0x628b0b4c,0xdd0180d2}},	//   vle_, tonb, ágod, _čuđe,
   {{0x68388b4d,0x6b828b4e,0x68e88106,0x69d80019}},	//   víde, _adog, kydd, övet,
   {{0x442d8b4f,0x443f8b50,0x18b80009,0x644b8b51}},	//   tle_, tmu_, _игры_, _pigi,
   {{0x4424803a,0x442d8b52,0x5f458b53,0x62898b54}},	//   gom_, ule_, _منزل, treo,
   {{0x442d8b55,0x63bd0b56,0x644b8b57,0x11d980f7}},	//   rle_, _masn, _vigi, فوظة_,
   {{0x442d8b58,0x443f8b59,0x62898b5a,0xe0d98b5b}},	//   sle_, smu_, rreo, ево_,
   {{0x442d8b5c,0x77940077,0x27e00072,0x443f859e}},	//   ple_, لیغا, _poin_, pmu_,
   {{0x44248b5d,0xf649010f,0x69da8282,0x672d0b5e}},	//   com_, _זצ_, ajte, _byaj,
   {{0xa9a58b5f,0x7c2400e7,0x27e00198,0x7e7d0b60}},	//   _билд, voir, _voin_, gssp,
   {{0x68e88114,0x7bcf0b61,0x645c841c,0xdb040b62}},	//   bydd, _ancu, _éric, leiç,
   {{0x7c2402be,0x0c7901bb,0x7ae98b63,0xdb008b64}},	//   toir, ксты_, lyet, remå,
   {{0x63bd0b65,0x6d5c0b66,0x62490b67,0xf09281c6}},	//   _casn, scra, _džom, _הנה_,
   {{0x7ae98b68,0x43750b69,0xdb1989c4,0x7c240b6a}},	// [4e0] nyet, руст, _bawé, roir,
   {{0x7bcf0b6b,0x3c3a8168,0x764b0036,0x7c240b6c}},	//   _encu, mëve_, _égyp, soir,
   {{0x98a68b6d,0x2fd70077,0xdb040b6e,0x3c3a80f1}},	//   čiće_, _شوید_, rdiñ, lëve_,
   {{0x7880003e,0x27e08125,0x61e08b6f,0x63bd0b70}},	//   _návš, ðin_, _पक्ष, _gasn,
   {{0x4a750b71,0x44248b72,0x3c3a80f1,0x7e2a8b73}},	//   _выст, vom_, nëve_, ніка_,
   {{0x63a40b74,0x69ce02af,0xa3cc0b75,0x4424833e}},	//   lfin, _unbe, लाक_, wom_,
   {{0xa1160b76,0x98be83bf,0xdb040187,0xa3cf8a27}},	//   _صورت, yatı_, feiç, शां_,
   {{0xd90d0077,0x6440826c,0x20048b77,0x3c3a80f1}},	//   _تیم_, ummi, _ummi_, këve_,
   {{0x68e88355,0x81bc8029,0x3c3a8168,0x64408b78}},	//   wydd, klēt, jëve_, rmmi,
   {{0x49748b79,0x683881d0,0x3c3a8168,0x24588b7a}},	//   шлос, bídc, dëve_, _tém_,
   {{0x7e640b7b,0x44248b7c,0xea008028,0x48150b7d}},	//   _atip, pom_, _chạy_, имос,
   {{0x44248b7e,0x68e88b7f,0x59d2801b,0x63a400fe}},	//   qom_, rydd, ताहर, jfin,
   {{0x6b7b810f,0x63bd011f,0x5eb880ab,0x62490b80}},	//   _טראנ, _rasn, _আপডে, _džoj,
   {{0xdb070019,0x63bd00eb,0x7e7d0b81,0x6836016b}},	//   ámít, _sasn, rssp, ráda,
   {{0x63bd0b82,0x81da0264,0x683604e8,0x40350b83}},	//   _pasn, ়সা_, mádn, _кекс,
   {{0x59d28b84,0xa3cc0b85,0x75eb0214,0x683603b0}},	//   तावर, लाग_, _müzi, ládn,
   {{0x2ba68b86,0x200b0b87,0x49750b88,0xdb0600e1}},	// [4f0] क्या, mici_, илас, _taký,
   {{0xdd9103f8,0xddc98b89,0x63a40b8a,0xd91b0198}},	//   _بود_, _svež, afin, нье_,
   {{0x7afb80e5,0xfaf98084,0x155a01c6,0x273b046d}},	//   zzut, lbūt_, _בכתב, _fàní_,
   {{0x200b02a5,0xa29505e9,0x69d80b8b,0x26c90503}},	//   nici_, _камі, över, _krao_,
   {{0x442b026c,0xf8c9826b,0x7c3a0036,0xb5fd8084}},	//   _ikc_, _asẹ́_, ître, _atša,
   {{0x7bc78029,0x644f05a4,0x48770b8c,0x7ae98b8d}},	//   ējum, _hici, _مدرس, vyet,
   {{0x200b0b8e,0xdb1d006a,0x644f0b8f,0x2c5581a9}},	//   kici_, _ansø, _kici, _kādi_,
   {{0x7afb8b90,0x26c9025b,0x73e58ada,0x99908503}},	//   tzut, _orao_, роиз, _čaši_,
   {{0x200b0b91,0x645702f7,0x22158b92,0x5fab80d4}},	//   dici_, _luxi, ифор, _टॉयल,
   {{0x644f0b93,0xe1258615,0x7ae98b94,0x9f5900e5}},	//   _lici, импи, ryet, misù_,
   {{0x7ae98b95,0x200b0b96,0x387e8077,0x63a40b97}},	//   syet, fici_, gstr_, yfin,
   {{0x644f0b98,0x3c3a80f1,0x76438b99,0x200b0b9a}},	//   _nici, tëve_, lmny, gici_,
   {{0xaa678b9b,0x32638019,0xdb0603ec,0x32678237}},	//   _стек, _انتہ, _lakò, _стев,
   {{0x3c3a820f,0xd9458b9c,0x644f0029,0x442b01e0}},	//   rëve_, _кели, _aici, _akc_,
   {{0x442b0267,0x443d8069,0x7643808e,0x61e38b9d}},	//   _bkc_, _khw_, imny, _ionl,
   {{0x3ead803a,0x200b0b9e,0x4aa98b9f,0x61e38019}},	//   _opet_, cici_, _कहाव, _honl,
   {{0x63a40ba0,0x26c904c3,0x02060ba1,0x395600a9}},	// [500] rfin, _grao_, азан, ањет,
   {{0x69c18ba2,0x61e3810c,0x64570ba3,0x667b00be}},	//   ndle, _jonl, _fuxi, _שטיק,
   {{0x61e38ba4,0x03a60ba5,0x657c0ba6,0x60268ba7}},	//   _monl, _кино, marh, аджа,
   {{0xb8ce023c,0xe6668b02,0x443d831d,0xb8fe0054}},	//   _कह_, атко, _nhw_, _तप_,
   {{0x2fc007e2,0xddd6026f,0xfe468ba8,0xb8660061}},	//   _maig_, _zvyš, андо, _چارو,
   {{0x44320ba9,0x2d980baa,0x200b001b,0x2fc00bab}},	//   lly_, ngre_, zici_, _laig_,
   {{0x443d80dd,0xeb0e81a2,0xa2c40035,0x200b01cc}},	//   _bhw_, ाप्त_, रिव्, yici_,
   {{0x8aa68bac,0x25a9812b,0xe8d70039,0x317801ec}},	//   арод, đala_, _דולר_, _herz_,
   {{0x44320bad,0x78af011f,0x9f490315,0x61e380c3}},	//   ily_, čivš, _ilaç_, _bonl,
   {{0x2c0b89d7,0x44320bae,0x61e38baf,0xc05a81e2}},	//   _یعنی_, hly_, _conl, кім_,
   {{0x245c026f,0x61e38bb0,0x3a370039,0x65770168}},	//   _ním_, _donl, שרים_, _rexh,
   {{0x2fc001c0,0x2a7f8bb1,0xdb1d0176,0x683604e8}},	//   _caig_, bsub_, _fasè, sádn,
   {{0x200b0bb2,0x67010bb3,0x2fc00bb4,0x645701df}},	//   rici_, _लेखक_, _daig_, _suxi,
   {{0x644f0bb5,0xfaf98bb6,0x2b928065,0x442b0bb7}},	//   _sici, rbūt_, _ایکس, _skc_,
   {{0x6ab6890a,0x52b68bb8,0x644f0bb9,0xe7870bba}},	//   _अनुर, _अनुस, _pici, _купо,
   {{0x628d0bbb,0x3b55096b,0x26c9001c,0xd0f781c6}},	//   trao, скар, _trao_, _כמות_,
   {{0xa3a88bbc,0x657c0bbd,0xd2510bbe,0xa2c405ab}},	// [510] ख्य_, barh, سنا_, रिष्,
   {{0xf9930bbe,0x2ba6800c,0x6838801b,0x644f0114}},	//   تبر_, क्ता, vída, _wici,
   {{0x3ead8353,0x44320bbf,0x644f0bc0,0x2fc0022c}},	//   _spet_, bly_, _tici, _yaig_,
   {{0x442b0bc1,0xa2c40bc2,0x1ab686a7,0x628d0140}},	//   _ukc_, रिश्, _अनूठ, prao,
   {{0x44290bc3,0x683d02be,0x6fd8016f,0x7a3d80e7}},	//   moa_, céde, यातू, lète,
   {{0x44290bc4,0x7aed05ee,0x764389da,0xc5f400fc}},	//   loa_, myat, umny, _tuɓe_,
   {{0x22590bc5,0xfc3f0028,0xa3cc016f,0x764382f7}},	//   _husk_, _khí_, लाच_, rmny,
   {{0x44290bc6,0x5f948bc7,0x24898bc8,0x2a7f8bc9}},	//   noa_, _мист, čam_, tsub_,
   {{0x8d878bca,0xfc3f00f7,0x62808bcb,0x645c8019}},	//   _نشان, _mhí_, gsmo, _érin,
   {{0x44290bcc,0x20190bcd,0x20090bce,0x673b8bcf}},	//   hoa_, érin_, _amai_, _izuj,
   {{0x44290bd0,0x7aed008e,0x69c18bd1,0x62808a53}},	//   koa_, hyat, rdle, asmo,
   {{0xc5e9007c,0xfc3f00ff,0x44290bd2,0xfbdf0129}},	//   _אד_, _nhí_, joa_, _kiêu_,
   {{0x2fc0009f,0xdb098bd3,0x44290bd4,0xf3ff00ab}},	//   _vaig_, rdeó, doa_, ্কার_,
   {{0x61fa8bd5,0xfc3f0693,0x7aed0bd6,0x69dc8bd7}},	//   chtl, _ahí_, dyat, öret,
   {{0x40958307,0xfc3f0307,0x2fc0022c,0x44290bd8}},	//   _العر, _bhí_, _taig_, foa_,
   {{0x4429011e,0x3ce500f2,0xfc3f0028,0x7ff6026a}},	//   goa_, älva_, _chí_, _دستا,
   {{0x44320051,0x9ad381bc,0x68e305ec,0x77640609}},	// [520] rly_, _aịzi, ändn, _ifix,
   {{0xc3328051,0x245c000d,0x44320bd9,0x51560bda}},	//   לון_, _tím_, sly_, стау,
   {{0x44320bdb,0xef6582bb,0x2c5580eb,0x44290bdc}},	//   ply_, ğını_, _kādu_, boa_,
   {{0xef658059,0xea00801c,0x7c298123,0x22590bdd}},	//   şını_, _thầy_, joer, _fusk_,
   {{0x317802a6,0x673b8035,0x7aed018f,0x661a808e}},	//   _terz_, _czuj, cyat, _pjtk,
   {{0x99d60277,0x21f600f7,0x63b60bde,0x62960bdf}},	//   _اتحا, _اكسس, leyn, muyo,
   {{0xec098028,0x320c82d6,0x62960be0,0x44c780ff}},	//   yết_, vidy_, luyo, _cđ_,
   {{0x8fa38be1,0xc7a38be2,0x62808be3,0x62868be4}},	//   _насе, _ниск, tsmo, škom,
   {{0x6aa40be5,0x62960214,0x200900ee,0x6d43016b}},	//   ntif, nuyo, _rmai_, _únav,
   {{0x660e0be6,0x44290102,0x60ca82f7,0x200900b9}},	//   jibk, zoa_, _prfm, _smai_,
   {{0x7c298be7,0x201903a7,0xe1ff0118,0x44290122}},	//   boer, ério_, _otón_, yoa_,
   {{0x7aed0be8,0x6aa40590,0xf5378039,0x313704de}},	//   yyat, ktif, _פנאי_, מנים_,
   {{0x7336803d,0x657a80d7,0xf1c800d4,0x63b60be9}},	//   _ارائ, _keth, रयान, deyn,
   {{0x329b8bea,0xe1ff0118,0x77640118,0xe7cf8beb}},	//   _עבוד, _atón_, _efix, _सोनप,
   {{0x44290bec,0xf1a98077,0xfc3f0028,0x657a8bed}},	//   toa_, _خانه_, _phí_, _meth,
   {{0x645a8bee,0x657a8bef,0x317e81ec,0x200900b9}},	//   _muti, _leth, latz_, _umai_,
   {{0x44290bf0,0x645a8bf1,0x62960bf2,0x8af78085}},	// [530] roa_, _luti, guyo, _çəti,
   {{0x645a82be,0x44290bf3,0x7aed0bf4,0xa3a883eb}},	//   _outi, soa_, ryat, ख्त_,
   {{0xe8e00142,0x2bc40bf5,0xfbdf0129,0x3178809a}},	//   ười_, _लोका, _siêu_, órzy_,
   {{0x2d9e8bf6,0x317e8bf7,0x657a8286,0x473583a7}},	//   _acte_, hatz_, _aeth, онес,
   {{0x539a0051,0x657a8bf8,0x7c29838e,0x6aa40bf9}},	//   _דירו, _beth, voer, ctif,
   {{0x645a8bfa,0x25a9812b,0x63ab80b9,0xdc3c81a9}},	//   _buti, đalo_, _sbgn, kšēj,
   {{0x69d50bfb,0x645a802e,0x8ccc0b9f,0x7c29800b}},	//   _inze, _cuti, हियो, toer,
   {{0xfbdf0028,0x69c50bfc,0x7bc28036,0x657a8bfd}},	//   _tiêu_, ldhe, _caou, _eeth,
   {{0x7bc28bfe,0x6fdd016f,0x657a8bff,0x0ae68009}},	//   _daou, यानं, _feth, ждый_,
   {{0x69c50c00,0x200f8c01,0x88858758,0x657a8c02}},	//   ndhe, ligi_, олож, _geth,
   {{0xf9920bea,0x69c50046,0x645a8c03,0x7a300009}},	//   ורי_, idhe, _guti, mätt,
   {{0x7a300c04,0x200f8c05,0x777b80e7,0x26cd8c06}},	//   lätt, nigi_, _jeux, _kreo_,
   {{0xe9d98c07,0x3f890114,0x9f448168,0x69d50c08}},	//   _вкл_, _ddau_, _romë_, _onze,
   {{0x20190c09,0x317e83e4,0xdce8801b,0x63b60079}},	//   ansi_, catz_, _nedě, weyn,
   {{0x2c5580eb,0x7bc28c0a,0x69c50c0b,0x68e30192}},	//   _tādu_, _yaou, ddhe, ändl,
   {{0x69c38c0c,0x69d50352,0x7bc40358,0x62960c0d}},	//   _hane, _anze, udiu, tuyo,
   {{0xb4b683bb,0xe29a0c0e,0x69c38c0f,0x2c5580eb}},	// [540] _छन्_, раз_, _kane, _kāds_,
   {{0x69c38c10,0xea008104,0x69c50c11,0x62960c12}},	//   _jane, _thấy_, gdhe, ruyo,
   {{0x02b68aed,0xd91009a7,0x657a8c13,0x69c385d8}},	//   _अन्न, ریر_, _reth, _mane,
   {{0x69c3811e,0xd7dd016f,0x657a8c14,0x26cd8118}},	//   _lane, यायच, _seth, _breo_,
   {{0x26cd8c15,0x645a8c16,0x777b80e7,0x7bc28c17}},	//   _creo_, _suti, _deux, _raou,
   {{0x62860c18,0x7c36008b,0x63a98c19,0x7bc28c1a}},	//   _ivko, llyr, efen, _saou,
   {{0x63a98c1b,0x5fca0c1c,0xb5fb0c1d,0xf77f02d0}},	//   ffen, ियाल, mpát, yaç_,
   {{0x7a34809f,0x657a8c1e,0x69c38c1f,0x26cd802a}},	//   màti, _weth, _aane, _freo_,
   {{0x62840c20,0x69c38c21,0x2fc6849c,0x38698c22}},	//   nsio, _bane, mdog_, _čara_,
   {{0x094a8abe,0x645a8c23,0x914a8c24,0x3ebb84de}},	//   ични_, _tuti, ична_, _דצמב,
   {{0x69c38c25,0x645a8364,0x61e302af,0x4254803d}},	//   _dane, _uuti, önli, _کنتر,
   {{0x62840c26,0x2fc68c27,0x317e81ec,0x2ba68c28}},	//   ksio, ndog_, satz_, क्शा,
   {{0x3ea68c29,0x0aba8c2a,0x7a2f8aa2,0xead48791}},	//   ntot_, _خطاب_, tøtt, _холь,
   {{0x81f88c2b,0x62840c2c,0x2ba68c2d,0x200f8c2e}},	//   _دفتر_, dsio, क्रा, zigi_,
   {{0xd37b0c2f,0x64428c30,0x271c8028,0x09ac80ab}},	//   ича_, _khoi, ỉnh_, _কোথা,
   {{0x248d0c31,0x683f00eb,0x6b80804f,0xdb198144}},	//   čem_, _lūdz, namg, _hawá,
   {{0x2bbd8c32,0x34b78c33,0x27e90c34,0x4abc80d4}},	// [550] ्यता, _आन्द, _ioan_, ्टिव,
   {{0x69c3862f,0x78a50125,0x27e900ff,0xdb00841c}},	//   _xane, tthv, _hoan_, lemó,
   {{0x69c50c35,0x26cd82a5,0x7fd58084,0x7e698c36}},	//   rdhe, _sreo_, зілі, _step,
   {{0x764183ed,0x69c503ed,0x27e90c37,0xdb0b8176}},	//   _shly, sdhe, _joan_, _magò,
   {{0x2bc40076,0x200f8c38,0x7c2d0c39,0x7bda0039}},	//   _लोटा, rigi_, moar, _הקרו,
   {{0x7c2d0c3a,0x26cd8087,0xdd918c3b,0x1dcb0512}},	//   loar, _vreo_, روع_, ायित,
   {{0x7a300c3c,0x6442832f,0x69c38c3d,0x6ab90085}},	//   rätt, _bhoi, _rane, şafı,
   {{0x7a300c3c,0x69c3803d,0x57b48c3e,0x64428c3f}},	//   sätt, _sane, _обст, _choi,
   {{0xd5bb8c40,0x64428c41,0x63a98c42,0x3ebf8573}},	//   _все_, _dhoi, rfen, _usut_,
   {{0xdb0d0c43,0x63a98c44,0x7c2d0c45,0x1306862c}},	//   ndañ, sfen, hoar, яный_,
   {{0xf992093f,0x69c38074,0x6442861f,0x7c2d011e}},	//   ערט_, _vane, _fhoi, koar,
   {{0xb4d78c46,0x69c38c47,0xa3bb8c48,0x64428c49}},	//   ामी_, _wane, _خاطر_, _ghoi,
   {{0x7c2d0c4a,0x27e90c4b,0x64498c4c,0x24980c4d}},	//   doar, _doan_, mmei, wurm_,
   {{0x64498c4e,0x2c5580eb,0x57470a41,0x63af0163}},	//   lmei, _tāds_, язям_, _abcn,
   {{0x2eb88424,0x7981838a,0x33f60c4f,0x8cce8035}},	//   _इन्त, malw, пчас, थियो,
   {{0x62840665,0x644981e4,0x7c2d0c50,0x1e860c51}},	//   tsio, nmei, goar, _елим,
   {{0x2bad835a,0x9f448c52,0x62840110,0x26c00c53}},	// [560] झ्या, _tomé_, usio, _usio_,
   {{0x3f820500,0x79818c54,0x2bb8825e,0x200d8187}},	//   laku_, nalw, _आस्थ, _amei_,
   {{0x62840c55,0x23bd83dd,0xfbbd824c,0x201c83a7}},	//   ssio, ्याद, ्याम, évio_,
   {{0x3f820c56,0x61fe0c57,0x657e01e0,0x7a3001ec}},	//   naku_, shpl, _heph, täts,
   {{0x5fdd016f,0x78828019,0xb5fb0c58,0x442d8c59}},	//   यातल, _kívá, mpár, doe_,
   {{0x645e0c5a,0x7bc60c5b,0x64428c41,0xe5348c5c}},	//   _kupi, _haku, _shoi, мель,
   {{0x7bc60c5d,0x64428c5e,0x3ea68c5f,0xa2c40aed}},	//   _kaku, _phoi, stot_, रिक्,
   {{0x293700be,0x7bc60558,0x657e0c60,0xdb00802a}},	//   _זאלן_, _jaku, _leph, xemó,
   {{0x7bc60c61,0x3f820c62,0xdb0d008b,0x64a080c3}},	//   _maku, daku_, ndað, dšiš,
   {{0x7bc60590,0x657e0c63,0xeaaf880b,0x39588aa2}},	//   _laku, _neph, اعي_, ørs_,
   {{0x64428c64,0x3f820c65,0x6d5a8bb1,0x5f950c66}},	//   _thoi, faku_, _igta, минт,
   {{0x1ae68c67,0x3f820c68,0x04db8039,0x7c2d0102}},	//   _ноем, gaku_, _לקבל, xoar,
   {{0xa3c00c69,0x7c2d0087,0x79818c6a,0x63a28c6b}},	//   ंजन_, voar, balw, _icon,
   {{0x91e38c6c,0x09e38c6d,0x611484bd,0x7bc602d5}},	//   _поче, _почн, _одлу, _aaku,
   {{0x7c2d0c6e,0x7bc60c6f,0x69c8831d,0x69a18beb}},	//   toar, _baku, mdde, _खाती,
   {{0x645e0c70,0x7bc60c71,0x2c0d016f,0x69c88c72}},	//   _dupi, _caku, _सगळं_, ldde,
   {{0x4a550c73,0x7c2d0102,0x7bc60c74,0x32550c75}},	// [570] дкас, roar, _daku, двар,
   {{0x7c2d0c76,0x6838800d,0x69c88c77,0xa2bf8c78}},	//   soar, bídk, ndde, _वनस्,
   {{0x7bc60c79,0x2d830c7a,0x7c2d0c7b,0x61ea8144}},	//   _faku, maje_, poar, _mofl,
   {{0x2d9c04b8,0x27e987ca,0x2d830c7c,0x68360187}},	//   _över_, ðan_, laje_, tádi,
   {{0x6fa50c7d,0x63ad0c7e,0x69d880c9,0x62490c7f}},	//   _कानू, mfan, _onve, _džor,
   {{0x2d830c80,0x7bc60c81,0x63ad0c82,0x68360c83}},	//   naje_, _zaku, lfan, rádi,
   {{0x7bc60c84,0xb4d78054,0x645800e7,0x442d8c85}},	//   _yaku, ामे_, _évit, toe_,
   {{0xeb9980af,0x69d88c86,0x2bda8c87,0x63ad0c88}},	//   ции_, _anve, भाषा, nfan,
   {{0x442d8baf,0x69c70c89,0x64498c8a,0x79818c8b}},	//   roe_, _kaje, rmei, talw,
   {{0x63a28c8c,0x64498c8d,0x78a10106,0x442d852a}},	//   _econ, smei, _älvs, soe_,
   {{0x39458c8e,0x3f820c8f,0x02ba03e8,0x61ea8c06}},	//   ьног, taku_, _उन्न, _dofl,
   {{0x645e0c90,0xe73a0c91,0x657e0c92,0x69c70077}},	//   _rupi, жем_, _seph, _laje,
   {{0x7bd981bc,0x63bb8c93,0x63ad0c94,0x7c2d8c95}},	//   _inwu, meun, dfan, čard,
   {{0x2bbd87e6,0x69c70c96,0x2d830c97,0x3f820c98}},	//   ्यवा, _naje, gaje_, saku_,
   {{0x64a30c99,0x7bc60c9a,0xed570c9b,0x6286816b}},	//   кара, _paku, дор_, ákov,
   {{0x7bc98c9c,0xaac900d4,0x04430c9d,0x672401c0}},	//   ndeu, रिंक, весн, _txij,
   {{0x69c70c9e,0x6aa98c9f,0xc1ea0ca0,0x7bc60ca1}},	// [580] _baje, ntef, одаж_, _vaku,
   {{0x7c290025,0x7bc60ca2,0x69c70ca3,0x26d200b4}},	//   čera, _waku, _caje, _iryo_,
   {{0x106a0ca4,0xb4d7852a,0x7640001b,0x7bd98133}},	//   цией_, ामो_, ůmys, _onwu,
   {{0x63bb8ca5,0x680b066f,0x00000000,0x00000000}},	//   jeun, wędz, --, --,
   {{0xa3e1873c,0x69c88ca6,0x6d418748,0x6b840ca7}},	//   दान_, ydde, _azla, maig,
   {{0x6b840c5e,0x69c70ca8,0x7bd981bc,0x63a28ca9}},	//   laig, _gaje, _anwu, _scon,
   {{0xdb0b8125,0xd839012b,0x7e7b8caa,0x7bc98cab}},	//   _sagð, luče_, _ewup, fdeu,
   {{0x69c70025,0x6b840cac,0x2d830cad,0xd9430cae}},	//   _zaje, naig, zaje_, _реси,
   {{0x7e7b81bc,0x27e6810c,0x83fc8bcf,0x752d861c}},	//   _gwup, mjon_, _nuđe, ğaza,
   {{0x27e68caf,0x6b840cb0,0x765f0359,0x24f68cb1}},	//   ljon_, haig, _ruqy, _очер,
   {{0xdb1d026f,0x2d830cb2,0x69c88114,0x4422008e}},	//   _masá, vaje_, rdde, _ojk_,
   {{0x7e608cb3,0x68e30cb4,0xb8e6809a,0x63bb8118}},	//   _kump, ändi, _उन_, ceun,
   {{0x6b840cb5,0x19948cb6,0xd8390968,0x7c228cb7}},	//   daig, _заля, juče_, _ijor,
   {{0xc1c803bb,0x7c2d807d,0x69d88cb8,0x7e608cb9}},	//   रयोग, čare, _unve, _mump,
   {{0x2d830cba,0x7e608cbb,0x69c70cbc,0x63ad007b}},	//   raje_, _lump, _raje, tfan,
   {{0x2d830cbd,0xeac88028,0x25a98289,0x69c70cbe}},	//   saje_, _kỹ_, đali_, _saje,
   {{0x63ad0cbf,0x7e608cc0,0x79a70cc1,0x4caa80ab}},	// [590] rfan, _nump, дрее, কিটু,
   {{0xeac88028,0x2fc90cc2,0x7c228cc3,0x63ad0cc4}},	//   _mỹ_, _haag_, _ljor, sfan,
   {{0x6b840110,0x61e7816d,0x69c70cc5,0x63ad0cc6}},	//   baig, öjli, _vaje, pfan,
   {{0x69c703c3,0x66150cc7,0xd839026c,0x6b840cc8}},	//   _waje, lizk, buče_, caig,
   {{0x7e608cc9,0xb4d78cca,0xdb1d0ccb,0x644d0ccc}},	//   _cump, ाम्_, _ansö, mmai,
   {{0x7c228ccd,0x2fc903b2,0x7a2b02af,0xa5948081}},	//   _ajor, _laag_, hütz, връщ,
   {{0x271b0cce,0x63bb85f8,0x97a7846e,0xdce380eb}},	//   नपुर_, teun, _орал, manī,
   {{0x6aa981a3,0xee3f00e1,0x2d810ccf,0x75fd82d6}},	//   ttef, dtým_, _lehe_, _dèza,
   {{0xc6a48cd0,0x7bc98cd1,0x4ea48b02,0x7c228cd2}},	//   _архи, rdeu, _арха, _djor,
   {{0xddc4003b,0xb5fd8cd3,0xdb040cd4,0x63bb8cd5}},	//   _otiš, _buše, nfiá, seun,
   {{0x83fc803b,0x07a60112,0xf1b200be,0x6d418cd6}},	//   _suđe, нанн, נסט_, _uzla,
   {{0x7c228cd7,0x2fc90cd8,0xb5fd8cd9,0x60da0061}},	//   _gjor, _caag_, _duše, _átme,
   {{0x79850748,0x2fc90cda,0x2d810cdb,0xdce18084}},	//   kahw, _daag_, _behe_, _pelė,
   {{0x6a178065,0xd8390024,0x3ea2816d,0x27ff8114}},	//   _تبصر, vuče_, _åkte_, _llun_,
   {{0x62868cdc,0xb5fd811f,0x6b840cdd,0x7c29042b}},	//   škot, _guše, taig, čern,
   {{0x27ed8cde,0x83fc80d2,0x8b950cdf,0x7c3b820d}},	//   _noen_, _tuđe, круч, nlur,
   {{0xdb1d0ce0,0x64598ce1,0x22580084,0x49960162}},	// [5a0] _pasá, _miwi, _pirk_, ешет,
   {{0xe7ac01c4,0x6b84008c,0x644d0ce2,0x27ff8ce3}},	//   ट्रप, saig, amai, _alun_,
   {{0x644d0ce4,0x7d7b0039,0xdb1d0019,0x6d5e033e}},	//   bmai, _מניו, _vasá, _igpa,
   {{0x4ea68ce5,0x644d09c4,0xc6a68ce6,0x64598ce7}},	//   ерка, cmai, ерки, _niwi,
   {{0x44200ce8,0x27ed81d8,0x44320ce9,0x61f30aa2}},	//   mni_, _doen_, moy_, ådlø,
   {{0x27e68cde,0x443202b8,0xf2df00ff,0xf48700d7}},	//   sjon_, loy_, _ngây_, _تایی,
   {{0x44200cea,0x69dc0ceb,0xd9430cec,0x61430110}},	//   oni_, _inre, _бери, _бера,
   {{0x44200ced,0x2bba8013,0x44320cee,0x7e608cef}},	//   nni_, ساعة_, noy_, _tump,
   {{0x7ae404c3,0xe7e40cf0,0x64598cf1,0x61ee0cf2}},	//   nxit, गाना_, _diwi, _kobl,
   {{0xb5fd8503,0xfce68cf3,0x44320cf4,0x44200cf5}},	//   _puše, _позо, hoy_, hni_,
   {{0x44200cf6,0x7a2b02af,0x4432009c,0x61ee094d}},	//   kni_, tütz, koy_, _mobl,
   {{0x2d8101ec,0x6d5e02c4,0x44320cf7,0x7c3b8cf8}},	//   _sehe_, _agpa, joy_, clur,
   {{0xd6d80cf9,0x2d81026b,0x69dc0cfa,0x44320cfb}},	//   нтр_, _pehe_, _onre, doy_,
   {{0x44200cfc,0x2ee10cfd,0x6b82876d,0x84e4864a}},	//   eni_, _पपीत, _heog, _कपाट_,
   {{0x44200125,0xa4d80cfe,0x765a8cff,0x66150d00}},	//   fni_, ндру_, _mity, rizk,
   {{0x69dc0d01,0x44200d02,0x493b8039,0x44320d03}},	//   _anre, gni_, _מגוו, goy_,
   {{0x61ee0b7f,0x5a3500b3,0x23690d04,0x27ed8d05}},	// [5b0] _bobl, внат, rcaj_, _roen_,
   {{0x44200d06,0x27ed8d07,0x6b828d08,0x61ee0d09}},	//   ani_, _soen_, _leog, _cobl,
   {{0x44200d0a,0x44320d0b,0x61ee0d0c,0x69ca81bc}},	//   bni_, boy_, _dobl, _mafe,
   {{0x44200042,0x69dc0557,0x69ca8d0d,0x87e48d0e}},	//   cni_, _enre, _lafe, люче,
   {{0x539a0bea,0x6abc8996,0xf770845b,0xe5a58d0f}},	//   _קישו, ्टोर, صان_, вили,
   {{0x0c740077,0x44d101e2,0xdce88029,0x69ca8d10}},	//   _جدید, _ką_, _nedē, _nafe,
   {{0x6b828d11,0xdb04007b,0x27ed8a0f,0x44d10d12}},	//   _beog, leið, _toen_, _ją_,
   {{0xa1580d13,0xbbbd8d14,0x19580d15,0xc4478019}},	//   _часу_, ्येक, _часы_, ریشن_,
   {{0x24808025,0x7c3a00e7,0x7c3b8106,0x64598c53}},	//   ćima_, îtri, rlur, _viwi,
   {{0x44200d16,0x62898d17,0x64598077,0x33f183a8}},	//   zni_, rseo, _wiwi, _páxs_,
   {{0xd7dd053e,0x7bdd0d18,0x34948791,0x7c3b8d19}},	//   यांच, _onsu, _бахр, plur,
   {{0x5b1587eb,0x6b828d1a,0x2d8785d1,0xdb04008b}},	//   _имет, _geog, lane_, keið,
   {{0x6d450d1b,0x76488009,0x25de0d1c,0x2d878162}},	//   _azha, _yhdy, खाली_, oane_,
   {{0x44200d1d,0xa7fd0201,0x7bcb8d1e,0x69ca8135}},	//   wni_, qqın, _hagu, _gafe,
   {{0x6e3c0713,0x443200ab,0x59a68076,0x7bcb8d1f}},	//   rlrb, toy_, _खातर, _kagu,
   {{0x2d878c89,0x6b8284c3,0x44200d20,0x3e660d21}},	//   hane_, _xeog, uni_, _tôt_,
   {{0x61ee0d22,0x2d878d23,0x6b848074,0xdfd20065}},	// [5c0] _pobl, kane_, _õige, _ميں_,
   {{0x7bcb8d24,0xfe9b04de,0x6d5e0122,0x7ae68106}},	//   _lagu, _קיימ, _ugpa, äkti,
   {{0x2d878d25,0x7e640009,0x4432033e,0x83fc8d26}},	//   dane_, _huip, poy_, _luđa,
   {{0xdb0401fa,0x7bcb8d27,0x59e0000d,0x7e640d28}},	//   beið, _nagu, नाहर, _kuip,
   {{0xa2c1000f,0x779180d5,0x765a8d29,0xe7aa0321}},	//   रौद्, صیلا, _pity, _कानप,
   {{0x63a40d2a,0x2d878d2b,0x61ee00d2,0x68388187}},	//   lgin, gane_, _uobl, vídu,
   {{0x7bcb8d2c,0x6abc82ef,0x69ca8d2d,0xc0e30254}},	//   _bagu, ्ट्र, _rafe, _корк,
   {{0x63a40d2e,0x25ad0d2f,0x83fc8b80,0x69ca8d30}},	//   ngin, đeli_, _buđa, _safe,
   {{0x5a348d31,0xf4130bea,0x67ff00f1,0x7bcb8d32}},	//   лнит, יפה_, _bëjn, _dagu,
   {{0x2d878d33,0x683d0d34,0xbd8a80d7,0x320581c6}},	//   cane_, médi, _آنان_, ghly_,
   {{0x68388187,0xa99b00be,0xbb1b0162,0x61fa8d35}},	//   sídu, וביר, _neîn, rktl,
   {{0x3f848d36,0x7bcb8d37,0x63a401ed,0xc05801e2}},	//   _jemu_, _gagu, jgin, кія_,
   {{0x44d10d38,0x44268d39,0x69ca837a,0x8a0684fa}},	//   _są_, _ijo_, _tafe, _изде,
   {{0x7bc08006,0x27318028,0xb5fd842b,0xdb04008b}},	//   lemu, ỡng_, _kuša, veið,
   {{0x442688cf,0x6d5c81ac,0x20068d3a,0x7bcb8d3b}},	//   _kjo_, _úrad, khoi_, _yagu,
   {{0x2d878d3c,0x7bc08763,0x6aad0d3d,0x2ba689c8}},	//   zane_, nemu, ttaf, क्चा,
   {{0x20190d3e,0x2d878d3f,0x36d50d40,0xab840746}},	// [5d0] misi_, yane_, _сопр, руск,
   {{0x20190d41,0x44d10d42,0x26c9007d,0xdb04007b}},	//   lisi_, _tą_, _isao_, reið,
   {{0x44268d43,0x7bc08d44,0x21640d45,0x99640d46}},	//   _ojo_, kemu, ртуг, ртул,
   {{0x2d878d47,0xf8b3893f,0x20190d48,0x3f8485f5}},	//   wane_, ישע_, nisi_, _cemu_,
   {{0x4b7a0bea,0x539a0051,0x2d878d49,0x6aa084a8}},	//   _ראשו, _אירו, tane_, jumf,
   {{0xd1268d4a,0x44268d4b,0xa2b880bc,0x20190d4c}},	//   _هم_, _ajo_, ्बन्, hisi_,
   {{0x2d878d4d,0x20190d4e,0x645d0d4f,0x2baa06d4}},	//   rane_, kisi_, _kisi, ङ्का,
   {{0x7bc08d50,0x645d0d51,0x2bda816f,0x3f848d52}},	//   gemu, _jisi, भागा, _gemu_,
   {{0x20190d53,0x2d878d54,0x442682d6,0xe3b68d55}},	//   disi_, pane_, _djo_, убы_,
   {{0x44390d56,0xf99180f7,0x44268d57,0x6e350503}},	//   _lks_, حبة_, _ejo_, jozb,
   {{0x7bcb8d58,0x201906c0,0x63a40d59,0x7a3d823e}},	//   _tagu, fisi_, ygin, nèti,
   {{0x645d0d5a,0x2d858d5b,0xc50c83de,0xbb1b0162}},	//   _nisi, _hele_, _קלאָ, _reîn,
   {{0x443f8d5c,0xd24e803d,0xa3e70d5d,0x63a40850}},	//   mlu_, تنی_, पान_, vgin,
   {{0x443f8d5e,0x64a60d5f,0x2d858d60,0xdca60523}},	//   llu_, лага, _jele_, лаги,
   {{0x69c18d61,0x443f8d62,0x2d858d63,0x5e5680be}},	//   mele, olu_, _mele_, טישע_,
   {{0x69c18d64,0x2d858d65,0x66188503,0xeb9f0aa2}},	//   lele, _lele_, zivk, _smør_,
   {{0x645d0d66,0xe2970d67,0x443f8d68,0x9e5a0d69}},	// [5e0] _disi, лат_, ilu_, _проф_,
   {{0x69c18d6a,0x645d0d6b,0x44390d6c,0x3f848d6d}},	//   nele, _eisi, _eks_, _semu_,
   {{0x645d0d6e,0x443f8d6f,0x34aa0d70,0x27e00669}},	//   _fisi, klu_, _явно_, _knin_,
   {{0x69c18d71,0x2bab0d72,0x2d8a02ec,0x645d0d73}},	//   hele, _छाया, labe_, _gisi,
   {{0x69c18d74,0xa3d783b7,0x443f8d75,0x60060d76}},	//   kele, ायन_, dlu_, _góme,
   {{0x2d858c6e,0x69c18d77,0xb5fd812b,0x7c240087}},	//   _cele_, jele, _puša, lnir,
   {{0x3f848d78,0x69c18d79,0x7bc08d7a,0x2d858d7b}},	//   _temu_, dele, temu, _dele_,
   {{0x69ce0d7c,0x683d0d7d,0x2d8a0d7e,0x68e30a33}},	//   _habe, pédi, habe_, ånde,
   {{0x69ce0d7f,0x20048d80,0x6b8601a1,0x69c18d81}},	//   _kabe, _ilmi_, _mekg, fele,
   {{0x69c187b3,0x7bc08d82,0x27e00d83,0x69ce0102}},	//   gele, semu, _anin_, _jabe,
   {{0x69ce0d84,0x443f8d85,0x03148d86,0x7bc080dd}},	//   _mabe, blu_, _तेरह_, pemu,
   {{0x31570451,0x2d858052,0x44268d87,0x7c240024}},	//   טיין_, _zele_, _ujo_, jnir,
   {{0xa3e187e6,0xcaf68154,0x26c682f7,0x645d0d88}},	//   दार_, _حساب, nwoo_, _risi,
   {{0x20190d89,0x2d8a0d8a,0x645d0d8b,0x69ce0d8c}},	//   sisi_, gabe_, _sisi, _nabe,
   {{0x44390d8d,0xab5d84b7,0xe4e40d8e,0x02178039}},	//   _pks_, reże, бітн, _תחום_,
   {{0xfbdf0104,0x69a70006,0x33750d8f,0x6b8600b9}},	//   _thêm_, _चाही, ргар, _cekg,
   {{0x52150d90,0x65950d91,0x3f8b0d92,0x2d8a0d93}},	// [5f0] адат, _капу, macu_, babe_,
   {{0x69ce0510,0x9475026a,0x3b540d94,0x443f8d95}},	//   _cabe, _نگرا, скур, zlu_,
   {{0x69ce0d96,0x2d858205,0x443f8d97,0x44390d98}},	//   _dabe, _rele_, ylu_, _tks_,
   {{0x69c18d99,0x2d858d9a,0x8d74003d,0x3f8b0d9b}},	//   zele, _sele_, _پایا, nacu_,
   {{0x2d858d9c,0x66e58d9d,0xdee58d9e,0x69c18d9f}},	//   _pele_, рола, роли, yele,
   {{0x2bda8da0,0x69c18da1,0x69ce0da2,0x20048085}},	//   _मोबा, xele, _gabe, _elmi_,
   {{0x2d858da3,0x628282a3,0x7e718da4,0x7bcf0da5}},	//   _vele_, _awoo, _žepč, _kacu,
   {{0x69ce0da6,0xd6f70076,0x629b8da7,0x3f8b0da8}},	//   _zabe, ुनाथ_, truo, jacu_,
   {{0x69c18da9,0x2d858daa,0x443f8dab,0x4919016f}},	//   tele, _tele_, rlu_, _येतो_,
   {{0x7c878dac,0x443f81fa,0x2ba7835a,0xd24e80a0}},	//   _буде, slu_, _गावा, وني_,
   {{0x443f8dad,0xd9458d5f,0x61458dae,0x69c18daf}},	//   plu_, рени, рена, rele,
   {{0x20040db0,0xdcfe01a9,0x7bcf0db1,0x78a18db2}},	//   ómi_, _nepā, _nacu, rulv,
   {{0x91e58db3,0x248600e1,0x09e58db4,0xf38c83de}},	//   _воле, _ňom_, _волн, _טראָ,
   {{0x44d58db5,0x7a3002af,0xee370db6,0x216681a1}},	//   _kā_, sätz, иня_, _киши_,
   {{0x2d8a0db7,0x7bcf0db8,0x44d580eb,0x69ce0db9}},	//   rabe_, _bacu, _jā_, _rabe,
   {{0x3ced8d38,0x44d58dba,0x2d8a0dbb,0x31c58dbc}},	//   _अपने_, _mā_, sabe_, _वसुध,
   {{0xfaa60dbd,0x69ce0dbe,0xcb00009a,0x25db82f1}},	// [600] разо, _pabe, लैंड_, _गोभी_,
   {{0xb21b0bc5,0x69ce04b7,0xe1ff0dbf,0x2d960dc0}},	//   _svær, _qabe, _stór_, _трис,
   {{0x44d58dc1,0x61fe0dc2,0x44c78019,0x661c0dc3}},	//   _nā_, rkpl, _nő_, mirk,
   {{0x69ce0dc4,0x7bcf0dc5,0xb5fd811f,0x661c0dc6}},	//   _wabe, _gacu, _bušo, lirk,
   {{0xdfcf80f7,0x683d00e7,0x7bc40162,0x41a6864a}},	//   بين_, cédu, meiu, _खालस,
   {{0xa61380e8,0x2888004e,0x27350129,0xd0b3011c}},	//   оміч, _مصری_, ụng_, hşət,
   {{0x291e00f2,0x6da38dc7,0xb21b006a,0x7bcf018f}},	//   _äta_, ција, _tvær, _yacu,
   {{0x661c0057,0x3edf01bc,0x6d4884e8,0x07a38191}},	//   hirk, _stọọ_, _vzda, _масн,
   {{0x15f8085d,0xe5a68dc8,0x6da68dc9,0xb5fd826c}},	//   ुसार_, _визи, _виза, _kušl,
   {{0x44c78019,0x38600362,0x7cdc8162,0x99668dca}},	//   _fő_, _aiir_, _pără, штил,
   {{0x7e760dcb,0x6aa401ed,0xddc98dcc,0x88590087}},	//   _atyp, huif, _uteš, лиос_,
   {{0xa3d78054,0xb8868032,0xb5fc8372,0xeb978dcd}},	//   ायण_, _atíò, _diġe, _виц_,
   {{0xc7b38051,0x69a701b6,0x661c0359,0x3f8b0b80}},	//   חבר_, _चाली, firk, racu_,
   {{0x2723801c,0x661c0dce,0x7bcf0dcf,0x2bda8006}},	//   ằng_, girk, _sacu, _मोता,
   {{0x40948dd0,0xedf48996,0xe65400e8,0x7bcf0dd1}},	//   _البر, _अवैध_, івсь, _pacu,
   {{0x3ced0024,0x539800e8,0x41a68dd2,0x672d01c0}},	//   ćev_, ився_, _खाँस, _txaj,
   {{0x99670dd3,0x7bcf0dd4,0x79870101,0x24580009}},	// [610] ател, _vacu, _pejw, рать_,
   {{0x661c0dd5,0x3d178074,0x2aaf011c,0x7bcf0dd6}},	//   cirk, _भइले_, rüb_, _wacu,
   {{0x7bcf0dd7,0x35f8003d,0x92e700ab,0x61f80106}},	//   _tacu, _خريد_, বনে_, övla,
   {{0x44d58dc1,0x9ad3819d,0x7bc40162,0x4e9581a8}},	//   _rā_, _dịji, ceiu, مشتر,
   {{0xa3ea8dbc,0xd6d9809a,0x6b8d0dd8,0x645a0dd9}},	//   मान_, _była_, maag, ïtie,
   {{0xee38835f,0x44d58dc1,0x6b8d0dda,0x80af80ab}},	//   ані_, _pā_, laag, য়িত্,
   {{0x69c50ddb,0x93fb016f,0x70940ddc,0xcd9801c6}},	//   mehe, _एकाच_, _марф, בדות_,
   {{0x6b8d0ddd,0x69c50dde,0x53c98319,0x44d58dba}},	//   naag, lehe, угим_, _vā_,
   {{0xb5fb0118,0x60060333,0x7d06811c,0x65958162}},	//   bpáx, _nóma, _əksi, _газу,
   {{0x44d58341,0xa2058ddf,0x7ae984c3,0x26cd80e5}},	//   _tā_, спод, rxet, _iseo_,
   {{0x3f890de0,0x661c0de1,0x6b8d0de2,0x629d816b}},	//   _beau_, virk, kaag, ásob,
   {{0x69c50de3,0x661c0de4,0x76438de5,0x7e69804f}},	//   hehe, wirk, llny, _kuep,
   {{0x69c50de6,0x7e618009,0x661c0de7,0xaac60105}},	//   kehe, _kilp, tirk, _रैंक,
   {{0x63a98de8,0x998580f7,0x6006008b,0x3f9e0214}},	//   lgen, _الثو, _dóma, ştu_,
   {{0x61e38de9,0xeb9a0dea,0x63a98deb,0x61fc8dec}},	//   _innl, лив_, ogen, örle,
   {{0x63a98ded,0x644f0dee,0x78a504a8,0x6b8d0def}},	//   ngen, _chci, duhv, gaag,
   {{0x38b18df0,0x661c0df1,0x63b6031d,0x63a98df2}},	// [620] lár_, pirk, rfyn, igen,
   {{0xe3b203f8,0x69c50df3,0xb5fd826c,0x443d8192}},	//   _کرد_, gehe, _bušm, _lkw_,
   {{0xa3d78df4,0x395c016d,0x6d418df5,0x26cd8020}},	//   ाया_, ävs_, _nyla, _aseo_,
   {{0x6b8d0df6,0x20020009,0xddc281b9,0x7e618362}},	//   caag, nkki_, spoż, _ailp,
   {{0xadec0cce,0xa3e1823c,0x69c50df7,0x248d00eb}},	//   ञापन_, दाई_, behe, ņemt_,
   {{0x44d803bb,0x443d8133,0x64440df8,0x6d418df9}},	//   _kč_, _akw_, llii, _byla,
   {{0x38b18dfa,0x63a98dfb,0xdd99804a,0x7c29016b}},	//   jár_, fgen, рші_, červ,
   {{0x68158063,0x6d41831d,0x63a98dfc,0x83fc805c}},	//   ządz, _dyla, ggen, _tuđm,
   {{0x44d806c0,0xa3e0064a,0xaf068dfd,0x645c80e5}},	//   _lč_, _दफन_, _упал, _èrim,
   {{0x60060dfe,0xd9cf00ab,0xddcd01a1,0x98b88073}},	//   _róma, রাথম, _otaš, алот_,
   {{0x3f8900e7,0xeb9a8dff,0x2cbe82f7,0x26c0016a}},	//   _peau_, _бие_, _uptd_, _apio_,
   {{0xfaa681e2,0x3a3a0711,0x82a68705,0x394281a9}},	//   _гадо, hopp_, _гадж, āks_,
   {{0xab5d809a,0xa3e70e00,0x3ea68e01,0x3f890866}},	//   leżn, पास_, nuot_, _veau_,
   {{0x86270e02,0xddcd009a,0x6b8d0e03,0x9f44826b}},	//   сьме, _uważ, waag, _bomú_,
   {{0x61f50e04,0x6b8d0e05,0x9f448722,0x69c50e06}},	//   _rozl, taag, _comú_, vehe,
   {{0x321e8e07,0x69c5010c,0x27e482c4,0x93790162}},	//   lity_, wehe, _nnmn_, рбат_,
   {{0x7a3d8e08,0x69c502af,0x6b8d0e09,0xfaff0168}},	// [630] mètr, tehe, raag, _afër_,
   {{0x321e8e0a,0x44d80247,0xddab0e0b,0x32070e0c}},	//   nity_, _fč_, _стил_, óny_,
   {{0x094b03bd,0x201d8e0d,0x6b8d0e0e,0x69c50e0f}},	//   учаи_, tiwi_, paag, rehe,
   {{0x69c50352,0xb8f10e10,0x7e618e11,0xad1a0039}},	//   sehe, _वन_, _silp, _כותר,
   {{0x8d658e12,0x44290e13,0x38b18e14,0x7e698e15}},	//   овле, mna_, zár_, _quep,
   {{0x443b0e16,0xdc998e17,0x20090114,0x201d804f}},	//   loq_, атиш_, _llai_, siwi_,
   {{0xd7aa0e18,0xcc8684fa,0x63a98e19,0xb5fd80d2}},	//   _कालच, обще_, tgen, _hušk,
   {{0x5fd90e1a,0xdb0d0e1b,0x66838065,0x6b808122}},	//   _बोलल, leañ, _فیصل, gbmg,
   {{0xab2989e0,0x7e618e1c,0x23298e1d,0x3ebf8088}},	//   ропа_, _tilp, ропи_, _uput_,
   {{0xb5fd803b,0x44290e1e,0x63a9844e,0x38b18e1f}},	//   _mušk, hna_, sgen, tár_,
   {{0x29038298,0x44290e20,0x443d8573,0x3207816b}},	//   ája_, kna_, _tkw_, _vlny_,
   {{0xa3ea86d4,0x3ea08805,0xb4d58128,0x2ca78e21}},	//   माण_, šite_, िटी_, mund_,
   {{0x7c3b8e22,0x2ca78e23,0x20020009,0x38b18e24}},	//   mour, lund_, rkki_, sár_,
   {{0x27388028,0x321e8e25,0x44d80e26,0x386a81a8}},	//   ứng_, city_, _pč_, úirí_,
   {{0xed5a0dd3,0x44290e27,0x7c298e28,0xdbc7007b}},	//   ров_, fna_, oner, töðu,
   {{0x44290e29,0x683601ac,0xb5fd88ae,0xf1ac0cf0}},	//   gna_, hádz, _bušk, _चाहन,
   {{0xa3ea816f,0xdb118036,0x2ca784dc,0x6b8b8e2a}},	// [640] मात_, éfèr, hund_, _megg,
   {{0x44290e2b,0x6b8b8e2c,0xb5fd8390,0x44d80e2d}},	//   ana_, _legg, _dušk, _tč_,
   {{0x44290e2e,0xd6d98063,0x63af0364,0x7c3b86c0}},	//   bna_, _było_, ännö, kour,
   {{0x7c3b83d3,0x8c46002e,0x321e84e8,0x2d8e8e2f}},	//   jour, _феме, zity_, wafe_,
   {{0x44200e30,0xa3e7025e,0x7c3b8e31,0x628681d0}},	//   mii_, पार_, dour, škoz,
   {{0xd49a8abe,0x44200e32,0x2ba80e33,0xa6e3007b}},	//   ари_, lii_, गलवा, æðis,
   {{0x6b8b8e34,0x25a087d9,0x1db20740,0x798a8e35}},	//   _begg, ğil_, _जानत, _refw,
   {{0x44200e36,0x25a082d0,0x7c3b8e37,0x2d8e8e38}},	//   nii_, şil_, gour, safe_,
   {{0x24898a20,0x9c8780e1,0x6b8b81b4,0x6ab60035}},	//   ćama_, _počú, _degg, ntyf,
   {{0x44200e39,0x44290e3a,0xdb198247,0x2ca78e3b}},	//   hii_, zna_, _pawò, bund_,
   {{0x44290e3c,0xa3b58076,0x44200079,0x600605e4}},	//   yna_, _चॉक_, kii_, _cómo,
   {{0x44200e3d,0x44290e3e,0xf1ae852a,0x7c29826c}},	//   jii_, xna_, ज्जन, cner,
   {{0x44200962,0x44290e3f,0x77640698,0x6e3c0e40}},	//   dii_, vna_, държ, forb,
   {{0x6b8b8a0f,0x2d8c8e41,0x44290e42,0x60060118}},	//   _zegg, _jede_, wna_, _fómo,
   {{0xa3e7005e,0x69c88e43,0x48c500c8,0x44200e44}},	//   पाल_, mede, _এপ্র, fii_,
   {{0x44200e45,0x69c88e46,0x44290e47,0x7aed0e48}},	//   gii_, lede, una_, txat,
   {{0x4429088b,0x443b022b,0xd839011a,0xf96b0e49}},	// [650] rna_, roq_, juči_, арей_,
   {{0x7c2d80d2,0x69c88e4a,0xdb1182be,0x527b8158}},	//   čari, nede, éfér, ינמא,
   {{0x44200e4b,0x44290e4c,0x2d910e4d,0x683601ac}},	//   bii_, pna_, maze_, vádz,
   {{0x2d91012b,0x44200e4e,0x69c88e4f,0x98b38052}},	//   laze_, cii_, hede, žeći_,
   {{0x6b8b8e50,0x63ad0e51,0x2d8c8e52,0x3f8f8e53}},	//   _regg, mgan, _bede_, ragu_,
   {{0x69c88e54,0x63ad0e55,0x2ca78e56,0xe61880e8}},	//   jede, lgan, tund_, оді_,
   {{0xa3d784e5,0x7c3b8e57,0x69c88e58,0x2d8c8e59}},	//   ायल_, tour, dede, _dede_,
   {{0x63ad0e5a,0xb5fd8754,0x25db8e5b,0x2ca78e5c}},	//   ngan, _muši, _गोरी_, rund_,
   {{0x2ca78e5d,0x2d910e5e,0x2d8c8e5f,0x6b8b8357}},	//   sund_, kaze_, _fede_, _vegg,
   {{0x44200012,0xddc4003b,0x2d8c8e60,0x6b8b8e61}},	//   zii_, _stiž, _gede_, _wegg,
   {{0x6d450e62,0x442004be,0xb5fd8e63,0x9f448242}},	//   _nyha, yii_, _nuši, _anmè_,
   {{0x442002a3,0x69d50e64,0xdd8f8019,0x6e3c0192}},	//   xii_, _laze, _سوچ_, worb,
   {{0x63bb8710,0x44200e65,0x63ad0e66,0xdb1d016a}},	//   mfun, vii_, dgan, _masó,
   {{0x9c828db7,0x2d8c0e67,0x63bb80e3,0x44200079}},	//   ščen, úde_, lfun, wii_,
   {{0x44200e68,0xe1668077,0xa5070e69,0x63ad0e6a}},	//   tii_, _عضوی, пера_, fgan,
   {{0xc4d2893f,0xbc630e6b,0x6e3c0e6c,0x61e70e6d}},	//   עגן_, евск, sorb, _anjl,
   {{0x44200e6e,0x7e6d0e6f,0x2fc002b8,0xaabd81a2}},	// [660] rii_, _guap, _ibig_, ्बिक,
   {{0xa3e28e70,0x44200e71,0x2d910e72,0x25db8bb8}},	//   _फोन_, sii_, caze_, _गोली_,
   {{0x44200e73,0x38b50e23,0x2d8c8e74,0x7e7b8e75}},	//   pii_, går_, _rede_, _atup,
   {{0xdb1d0e76,0x83fc82a5,0xde6d001c,0x35b203db}},	//   _obsè, _tuđi, _hươn, _जाड़,
   {{0x69d50003,0xf8a88bb8,0x66fe0540,0x2d8c8e77}},	//   _faze, _कम्प, ॉनिक_, _pede_,
   {{0xd8390e78,0x69d50e79,0x6b840e7a,0x7c3b0da8}},	//   ruči_, _gaze, lbig, čure,
   {{0x2d8c8e7b,0xdb0f02be,0xe81d06a7,0x63bb8e7c}},	//   _vede_, _accè, _पगला_, ffun,
   {{0x8aa68adb,0xde6d001c,0x69c88e7d,0x32058366}},	//   прод, _lươn, wede, ekly_,
   {{0x62960e7e,0x69c88e7f,0x2d8c8e80,0xa3e18e81}},	//   nsyo, tede, _tede_, दाज_,
   {{0xdb0d03a7,0xde6d00ff,0x8afb0e82,0x6faa0305}},	//   sfaç, _nươn, צהיי, _काउं,
   {{0x6aa40e83,0x7e6d0ad4,0x63ad0e84,0xb4c80035}},	//   hrif, _suap, ygan, ोटो_,
   {{0x6aa40e85,0xe45a8e86,0x62960e87,0x4c16826a}},	//   krif, _уже_, ksyo, _عباس,
   {{0xf2068021,0x78a8806a,0x7e6d0299,0xeb9f0646}},	//   _няко, sudv, _quap, _fløj_,
   {{0xa2db0e88,0x7afd8e89,0x6aa4035f,0xde6d00ff}},	//   निस्, äste, drif, _cươn,
   {{0x63ad0e8a,0xde6d0028,0x69d50e8b,0x19bb8039}},	//   tgan, _dươn, _raze, _המוב,
   {{0x6aa4031d,0x6b84009c,0x9c7c812b,0x2d910e8c}},	//   frif, gbig, _grče, saze_,
   {{0x6aa40e8d,0x95cb0e8e,0x2ee00e8f,0xb03803c8}},	// [670] grif, _луна_, _grif_, _מנהג_,
   {{0x38b50bfa,0xde6d001c,0x20c80e90,0xb0c8052a}},	//   tår_, _gươn, रबंध, रबंग,
   {{0x7e7b8b24,0x6b840e91,0x29070e92,0x7e7c807a}},	//   _stup, bbig, ána_, _črpa,
   {{0x2c718e93,0x290704b7,0x6aa40e94,0x69d50e95}},	//   _rád_, ġna_, brif, _waze,
   {{0xdb1d0b2c,0x38b50bbd,0x7c2d0e96,0x603201a9}},	//   _obsé, sår_, mnar, nāma,
   {{0x6da58e97,0xde6d001c,0x2c71816b,0x38b50106}},	//   фика, _xươn, _pád_, pår_,
   {{0x2489805c,0x442f80dd,0x27e902d6,0xed568073}},	//   ćamo_, _pjg_, _onan_, мош_,
   {{0x7c2d0e98,0xdb0f0e99,0x1b1e80ab,0x67d4806d}},	//   nnar, _accé, _পড়ে_, _посу,
   {{0x63bb8e9a,0x7c2d0e9b,0x7bc98e9c,0xa7fd011c}},	//   rfun, inar, reeu, yqır,
   {{0x27e90e9d,0x3eab0e9e,0x6442811b,0xb5fd8e9f}},	//   _anan_, duct_, _ekoi, _aušv,
   {{0x63bb8ea0,0x07a601d9,0x7c2d007b,0x200d800b}},	//   pfun, манн, knar, _klei_,
   {{0x2ee0031d,0x81b580ab,0xe3b081a8,0xde6d00ff}},	//   _prif_, _চোখ_, _مره_, _sươn,
   {{0xa3ea88d4,0x7c2d0353,0x443f8ea1,0xe28e8ea2}},	//   मार_, dnar, mou_, _ша_,
   {{0x64498ea3,0x200d809f,0x7c2d0ea4,0x27e902d6}},	//   llei, _llei_, enar, _enan_,
   {{0x442d8021,0xe1f08ea5,0x3eb90613,0x9d430ea6}},	//   one_, _حسن_, atst_, верд,
   {{0x443f8ea7,0x7c2d0ea8,0x64498e5d,0x9c7c8ea9}},	//   nou_, gnar, nlei, _urče,
   {{0x442d8eaa,0xe1fa0eab,0xde6d0028,0x64498229}},	// [680] ine_, ога_, _tươn, ilei,
   {{0x6aa40eac,0x443f8ead,0x2b8c0028,0x6b8402a3}},	//   rrif, hou_, ếc_, sbig,
   {{0x443f8eae,0x442d8558,0x851c8105,0x64498eaf}},	//   kou_, kne_, _भेंट_, klei,
   {{0x442d8eb0,0xa2db05e8,0x798e00c9,0x443f8eb1}},	//   jne_, निश्, _webw, jou_,
   {{0x442d81d6,0x443f8eb2,0xee3a8eb3,0x20068168}},	//   dne_, dou_, онд_, rkoi_,
   {{0xa2db0eb4,0x6449844e,0x6e238129,0xb8140264}},	//   निर्, elei, ginb, াচিত_,
   {{0x443f8eb5,0xa3ea84c5,0x3e740106,0x1dc00eb6}},	//   fou_, माल_, _lät_, श्यत,
   {{0x442d8eb7,0x443f8e67,0x68e3013c,0x64498eb8}},	//   gne_, gou_, ænde, glei,
   {{0x61fc0eb9,0x3e740106,0x3f868eba,0x9ad301bc}},	//   _korl, _nät_, mbou_, tịim,
   {{0x442d8ebb,0x7c240ebc,0x4efb81c6,0x6449862c}},	//   ane_, hiir, _והמו, alei,
   {{0x443f8ebd,0x850684c0,0x442d8ebe,0x25eb8ebf}},	//   bou_, _توان, bne_, चारी_,
   {{0x443f8ec0,0x3f868ec1,0x62808ec2,0x60320ec3}},	//   cou_, nbou_, ppmo, tāma,
   {{0x64408ec4,0x61fc00c9,0x2bdf00d4,0x5bbc8ec5}},	//   momi, _oorl, _पोषा, ्जीव,
   {{0x64408ec6,0x61fc0ec7,0x8a038081,0x603201a9}},	//   lomi, _norl, _изче, rāma,
   {{0x92bb0a49,0x443f001c,0x7c240ec8,0x623381a1}},	//   _আছে_, _ưu_, fiir, _шешу,
   {{0x27e90ec9,0xfc300eca,0x69da8ecb,0x69d88cf7}},	//   _unan_, لحق_, ldte, _have,
   {{0xa3b685e8,0x69d88ecc,0x61fc0ecd,0x776d0118}},	// [690] _जान_, _kave, _borl, _igax,
   {{0x443f8ece,0x442d8ecf,0x69da8ed0,0x64408ed1}},	//   zou_, zne_, ndte, homi,
   {{0x442d8ed2,0x644081f6,0x69d88ed3,0x7c240ed4}},	//   yne_, komi, _mave, biir,
   {{0x44248025,0x27e98ed5,0x69d88257,0x443f8548}},	//   jim_, ñan_, _lave, xou_,
   {{0x442d8ed6,0x443f8ed7,0x9f4087ca,0x61fc0ed8}},	//   vne_, vou_, ðið_, _forl,
   {{0x7bc2804c,0x442d8063,0x61fc0ed9,0x7cd38085}},	//   _abou, wne_, _gorl, _hərə,
   {{0x443f8eda,0x442d8ed6,0x60060013,0x44248edb}},	//   tou_, tne_, _fómh, fim_,
   {{0x442d8012,0x200d8087,0x61ea8edc,0x61fc03bf}},	//   une_, _ulei_, _anfl, _zorl,
   {{0x442d8edd,0x64498357,0x63a68ede,0x69d88edf}},	//   rne_, rlei, ókna, _bave,
   {{0x443f83a8,0x442d8ee0,0xe1f18013,0x9c828ee1}},	//   sou_, sne_, اسة_, ščan,
   {{0xd8260ab5,0x602607eb,0x38690ee2,0x69d88ee3}},	//   едни, една, _biar_, _dave,
   {{0x64408ee4,0x7ae28ee5,0xa3b68ee6,0x61ea8ee7}},	//   comi, _frot, _जाय_, _enfl,
   {{0x7ae28ee8,0x7bcd0ee9,0x7c240eea,0x69d88eeb}},	//   _grot, deau, viir, _fave,
   {{0x69d88eec,0xa3d78eed,0xb5fd8582,0x2d9e0036}},	//   _gave, ायक_, _gušt, ûte_,
   {{0x7bd98eee,0x1b1d00ab,0xd00a0eef,0xa3b68ef0}},	//   _kawu, _ভুলে_, _неке_, _जाम_,
   {{0x69d88ef1,0xe73a0009,0x7bcd010c,0xb60201d0}},	//   _zave, _ней_, geau, _žádo,
   {{0x7c240ef2,0xf41280be,0x60060ef3,0x7cd38085}},	// [6a0] riir, אפן_, _nómi, _dərə,
   {{0x44248ef4,0xe9d70ef5,0x7c2402a3,0x7c3b0279}},	//   zim_, нку_, siir, čura,
   {{0xa3ea0381,0x7c240ef6,0x44248ef7,0x61fc01ec}},	//   _една_, piir, yim_, _vorl,
   {{0x44248ef8,0x61fc0051,0xfbae8670,0x7bd98ef9}},	//   xim_, _worl, _टाइम, _nawu,
   {{0xa3b685b3,0x600605e4,0x64408791,0x6d488efa}},	//   _जाब_, _cómi, vomi, _syda,
   {{0x44248efb,0xf2d3007c,0x7ae28168,0x7cd3811c}},	//   wim_, _געש_, _rrot, _zərə,
   {{0x8fa681e2,0x04668adb,0x7c2f00f7,0x9c7c8754}},	//   _паве, нтим, _áirí, _brča,
   {{0x6d488efc,0xb5fd8efd,0x961d0eed,0xccf304de}},	//   _vyda, _sušt, _नष्ट_, רכה_,
   {{0x44248efe,0xb5fd803a,0x64408eff,0x69d88f00}},	//   rim_, _pušt, romi, _pave,
   {{0x38690ad0,0x64408329,0x38b88f01,0x7afd8f02}},	//   _siar_, somi, tér_, ästa,
   {{0x0b8a825d,0x9f448f03,0x290a8019,0x64a38f04}},	//   _если_, _tomó_, ába_, _баха,
   {{0x7ae28f05,0x2c750f06,0x68e38858,0x929d8035}},	//   _trot, _råd_, _drnd, syła,
   {{0x7bcd0f07,0x7ae28f08,0x38b88f09,0x3869008e}},	//   veau, _urot, sér_, _viar_,
   {{0x61ea8176,0x8cd78f0a,0x44220f0b,0x64460c2e}},	//   _unfl, _मनमो, _amk_, _akki,
   {{0x248d003b,0x7bcd0f0c,0x7bd98f0d,0xf8a48f0e}},	//   ćemo_, teau, _yawu, _खटिय,
   {{0x59c600d4,0x60c7008e,0x210301d6,0x6b9601b4}},	//   _रॉबर, _rpjm, nčiť_, gayg,
   {{0x6b848006,0x2bc2816f,0xfbc28f0f,0x7bcd0f10}},	// [6b0] _õigu, व्या, व्यम, reau,
   {{0x7bcd0f11,0xa2a70f12,0x2bcf0035,0x210301d6}},	//   seau, _चिठ्, हजहा, hčiť_,
   {{0x7cd38086,0x5f958f13,0x7c228f14,0x6b9601b4}},	//   _tərə, виет, _omor, bayg,
   {{0xfbab0009,0x629d8061,0x9f49010c,0x200b01d0}},	//   _этой_, ások, _anaé_, nkci_,
   {{0x62830025,0x644d0f15,0x6aad00e5,0x79a70a2e}},	//   ćnos, mlai, quaf, _прве,
   {{0x62350f16,0x9c7c8024,0x2ab98247,0x62500074}},	//   _регу, _srča, vèb_, näol,
   {{0xda3401bb,0xdce1809a,0x644d0f17,0x7bd98f18}},	//   _серы, _oglą, olai, _pawu,
   {{0x644d0f19,0x8ca286b7,0x69c3808e,0x26c90390}},	//   nlai, _गिरो, _sbne, _opao_,
   {{0x7bdb8f1a,0x69c10f1b,0x68e38bcf,0x961d8ec3}},	//   rduu, र्थी, _srnd, _atņe,
   {{0xaca38870,0x644d0c5e,0x2fcf80e8,0x7c228f1c}},	//   _amụm, hlai, legg_, _emor,
   {{0x9c7c805c,0x76438f1d,0x644d0f1e,0x7bd98f1f}},	//   _trča, mony, klai, _tawu,
   {{0x9c7c8f20,0x645a0084,0x27ff8176,0x69c10f21}},	//   _krčn, įtik, _joun_, र्ती,
   {{0xa3b68f22,0x27ff8f23,0x9aa48f24,0xe9ce8f25}},	//   _जात_, _moun_, _ممنو, _кк_,
   {{0x44220f26,0xed5a0f27,0x7c228f28,0xc5d50a4c}},	//   _smk_, дог_, _zmor, лісь,
   {{0x799702c1,0x44220f29,0xdcfc00eb,0x27ed8f2a}},	//   daxw, _pmk_, varē, _onen_,
   {{0x644d0f2b,0x7ae9005c,0x69c18f2c,0x6b898f2d}},	//   glai, _šeta, lfle, nbeg,
   {{0xe2970f2e,0xee3a0f2f,0xab270320,0x76438f30}},	// [6c0] кат_, _они_, вота_, kony,
   {{0x644d0f31,0x69c18f32,0x6b89826c,0x175701c6}},	//   alai, nfle, hbeg, _בספר_,
   {{0x76438f33,0x644d0f34,0x27ff8176,0x62840f35}},	//   dony, blai, _boun_, spio,
   {{0x2d980f36,0x644d0f37,0x629b8084,0x6aa9804a}},	//   lare_, clai, ksuo, kref,
   {{0x76438f38,0x44320f39,0x37dc0264,0x2a6a011c}},	//   fony, mny_, ধাপর, _tibb_,
   {{0xa2a70f3a,0x4432096a,0x2d980f3b,0x76438f3c}},	//   _चित्, lny_, nare_, gony,
   {{0x61ee0106,0x44320f3d,0x69dc0f3e,0xb5fc81b9}},	//   _inbl, ony_, _iare, _jiġi,
   {{0x44320f3f,0x64598f40,0x2d980f41,0x69dc0f42}},	//   nny_, _chwi, hare_, _hare,
   {{0x69dc0f43,0x2d980f44,0x51868071,0x76438f45}},	//   _kare, kare_, куна, bony,
   {{0x69dc0f46,0x2d980f47,0x44320f48,0x2bae816f}},	//   _jare, jare_, hny_, _टाका,
   {{0x69dc0f49,0x25db8076,0x2d98088b,0x27ff8247}},	//   _mare, _गोटी_, dare_, _youn_,
   {{0x27ed07f4,0x44320f4a,0x2d930f4b,0x3ea986c2}},	//   ñen_, jny_, _sexe_, šate_,
   {{0x44320f4c,0x34cb0996,0x2d9800e5,0x63a28f4d}},	//   dny_, ाब्द, fare_, _idon,
   {{0x69dc0f4e,0xb8828f4f,0x2d980687,0x62828f50}},	//   _nare, üíst, gare_, _itoo,
   {{0x6d400b16,0x20d38c3b,0x65940f51,0xdd940f52}},	//   şman, _نتيج, расу, расы,
   {{0x76438f53,0x44320f54,0xec340f55,0x644d0f56}},	//   zony, gny_, ансь, ulai,
   {{0x2d980f57,0x644d0f58,0x81d580c8,0x76438f59}},	// [6d0] bare_, rlai, হার_, yony,
   {{0x2d980f5a,0x44320063,0xaca30135,0x69dc0f5b}},	//   care_, any_, _atụg, _care,
   {{0x69dc0f5c,0x26080063,0x24810748,0x9c7c807a}},	//   _dare, _सकती_, _uthm_, _srčn,
   {{0x63a28f5d,0x3f990f5e,0xa283003d,0xac1900e8}},	//   _ndon, nasu_, _نیرو, _чому_,
   {{0x44290f5f,0x501c0f60,0xf7708bbe,0x1dc000d4}},	//   mia_, וואו, زان_, श्वत,
   {{0x69dc0f61,0x63a28f62,0x6272809a,0x7bdd0f63}},	//   _gare, _adon, _młod, _hasu,
   {{0x7bdd0f64,0x6b898754,0x27ff826b,0x25a983bf}},	//   _kasu, tbeg, _toun_, ğal_,
   {{0x44290f65,0x2d980012,0x69dc0f66,0x6aa98f67}},	//   nia_, zare_, _zare, tref,
   {{0x7bdd0f68,0x69dc0f69,0x76438f6a,0x6113811c}},	//   _masu, _yare, pony, mələ,
   {{0x44290f6b,0x386d8f6c,0x6aa98f6d,0x61138201}},	//   hia_, _hier_, rref, lələ,
   {{0x44290f6e,0x2d980f6f,0x44320063,0x69c18f70}},	//   kia_, vare_, yny_, rfle,
   {{0x7bdd0f71,0x44290f72,0x98160154,0x6aa98f73}},	//   _nasu, jia_, ابدا, pref,
   {{0x66018f74,0x4432003e,0x7ae9005c,0xfaa58f75}},	//   _kolk, vny_, _šetn, _сало,
   {{0x4432009a,0x3e798247,0x61138085,0x98e580f7}},	//   wny_, _mèt_, hələ, _مكتو,
   {{0x2d980f3b,0x61138201,0x3f990f76,0x69dc0f77}},	//   rare_, kələ, basu_, _rare,
   {{0x44290f78,0x69dc0f79,0x2d980f7a,0x44e387d9}},	//   gia_, _sare, sare_, _mı_,
   {{0x79950f7b,0x2d980f7c,0x4432096a,0x3e7986c0}},	// [6e0] _bezw, pare_, rny_, _nèt_,
   {{0x7c298f7d,0x44290f7e,0x44320f7f,0x613a0f80}},	//   hier, aia_, sny_, нчер_,
   {{0x69dc0f81,0x386d8f82,0x61138085,0x7c298f83}},	//   _vare, _bier_, fələ, kier,
   {{0xe73a8364,0x765a80f1,0xb8dc03a4,0x3e798247}},	//   нее_, _shty, _आम_, _bèt_,
   {{0x69dc0f84,0xadf08f85,0x539b0039,0x386d8f86}},	//   _tare, चालन_, _איכו, _dier_,
   {{0x38bc0f87,0x61460f88,0x3f990f89,0x386d8f8a}},	//   pír_, _бега, zasu_, _eier_,
   {{0x7c298f8b,0x386d8f8c,0xa3bb0f8d,0x7bdd0f8e}},	//   fier, _fier_, _घाम_, _yasu,
   {{0x7c298f8f,0x3e798205,0x79950f90,0x61138201}},	//   gier, _fèt_, _zezw, cələ,
   {{0x66018f91,0x7ae40d7b,0x52148cc1,0xe7378037}},	//   _folk, nvit, идит, _бет_,
   {{0x44290f92,0xddcd0f93,0xa3b68006,0x66018f94}},	//   zia_, _staž, _जाव_, _golk,
   {{0x7c298f95,0x7c260f96,0x41c60670,0x59c60f97}},	//   bier, _omkr, र्यस, र्यर,
   {{0x7c298f98,0xaae68f99,0x386d0106,0x660180b9}},	//   cier, _مستو, öer_, _zolk,
   {{0x44268f9a,0x7bdd0f9b,0x6d4003bf,0x95cb0f9c}},	//   _imo_, _rasu, şmal, нува_,
   {{0x44290f9d,0x442681c5,0x7bdd0f9e,0x2731801c}},	//   wia_, _hmo_, _sasu, ạng_,
   {{0x44290f9f,0x7bdd0fa0,0x3f990fa1,0x317b810f}},	//   tia_, _pasu, pasu_, _ארומ,
   {{0xb4c50006,0x799a8fa2,0x44290fa3,0x6006008b}},	//   _एही_, latw, uia_, _dóms,
   {{0x59c603eb,0xafdb03ba,0x7bdf0fa4,0x7bdd0fa5}},	// [6f0] र्भर, sløs, rdqu, _vasu,
   {{0x44290fa6,0x7c298fa7,0x386d835f,0x7bdd0fa8}},	//   sia_, zier, _sier_, _wasu,
   {{0x4426877f,0x7bdd0006,0xc7958071,0x44290fa9}},	//   _omo_, _tasu, арлы, pia_,
   {{0xb4fa078d,0x20da807d,0x79950f90,0x2ee903ac}},	//   _ספרי, mšić_, _wezw, _kraf_,
   {{0x6b8d0faa,0x386d84eb,0x7c298fab,0x539a0039}},	//   mbag, _vier_, vier, _בירו,
   {{0x6b8d0fac,0x7c298063,0x61138201,0x69c7056f}},	//   lbag, wier, sələ, _ubje,
   {{0x6601844e,0x7c298fad,0x44390fae,0xb60584be}},	//   _volk, tier, _kjs_, _aláì,
   {{0x3e798205,0x66018faf,0x61138085,0x22458fb0}},	//   _tèt_, _wolk, qələ, wolk_,
   {{0x7c298fb1,0x2bc7016f,0xa3b68fb2,0x799a80b4}},	//   rier, ऱ्या, _जार_, fatw,
   {{0x7c298fb3,0x20da812b,0x5ec880ab,0xb4c50074}},	//   sier, kšić_, লিশে, _एहू_,
   {{0x63b60196,0x2bc2816f,0x3ea00fb4,0xdb09816a}},	//   ygyn, व्हा, _svit_, rfeñ,
   {{0x44268fb5,0xa4fa80be,0x6aad0fb6,0x2ee90428}},	//   _gmo_, _בלעט, kraf, _braf_,
   {{0x636b83bf,0x1f5601bb,0x799a8fb7,0x41c60fb8}},	//   _dönü, ртнё, batw, र्डस,
   {{0x91fc8341,0x81ab00c8,0x6aad0fb9,0x62898fba}},	//   rmāc, ক্ত_, draf, mpeo,
   {{0x3b960fbb,0xe946819f,0x2ee90fbc,0x4439041c}},	//   ијат, _پروی, _eraf_, _bjs_,
   {{0x3ea0812b,0xf8140077,0x6b8d0fbd,0xafdb0aa2}},	//   šiti_, _دستگ, gbag, slør,
   {{0xd4670fbe,0xb22601b5,0xada60fbf,0xa3d686b7}},	// [700] рите_, амал, _капл, ाजत_,
   {{0x7ae40fc0,0x27e00fc1,0x26060187,0xa3e601a2}},	//   rvit, _hain_, _vôos_, _योर_,
   {{0x27e00590,0x6b9b8fc2,0xdb0d016b,0x2fdf8fc3}},	//   _kain_, kaug, čkác, _baug_,
   {{0x7c260fc4,0x2fdf8069,0xbc7b0039,0xe3b20fc5}},	//   _umkr, _caug_, _שנכת, _برد_,
   {{0x2fdf81e2,0x27e00fc6,0xa3bb0075,0x2bdf0072}},	//   _daug_, _main_, _घात_, _पोटा,
   {{0x27e00fc7,0x7ae480f7,0x7aeb006a,0x44d802d6}},	//   _lain_, _áiti, ægte, _kō_,
   {{0xd49781e2,0x10a30fc8,0x18a30fc9,0x44268fca}},	//   ары_, _мирн, _марм, _pmo_,
   {{0xa6868fcb,0xeca78fcc,0x27e00fcd,0xa3c90fce}},	//   _влад, _गिरफ, _nain_, ल्प_,
   {{0x9c7c85f3,0xf1c60aed,0x41c60af3,0x7cca811c}},	//   _krčk, र्थन, र्थस, _qərb,
   {{0x1db2016f,0x2fdf81c5,0x38780168,0xdb0982d0}},	//   _जागत, _zaug_, _kurr_, zgeç,
   {{0x27e00fcf,0x44d802d6,0x2d9c80f1,0x20048fd0}},	//   _bain_, _nō_, mave_, _komi_,
   {{0xf1c6000d,0x2d9c8fd1,0x7c3b0c18,0x6286012b}},	//   र्तन, lave_, čurk, _otko,
   {{0x27e00fd2,0x799a8c53,0xeafa81f9,0x2c0b8fd3}},	//   _dain_, patw, _جرات_, _جعلی_,
   {{0x2d9c8fd4,0xa3b68fd5,0xa3c9001b,0x6aad00e5}},	//   nave_, _जाँ_, ल्न_, vraf,
   {{0x69ca81c0,0x44390fd6,0xf8da80c2,0x61fc8338}},	//   _ibfe, _pjs_, _बनिय, örlu,
   {{0x20048fd7,0x6aad0fd8,0x25ad0fd9,0xa3b68816}},	//   _nomi_, traf, şel_, जलि_,
   {{0x6b8d01f1,0x9c7c8fda,0x81e000c8,0x2fdf81e9}},	// [710] rbag, _brčk, থান_, _raug_,
   {{0xd9990f99,0x6aad0fdb,0x98da8770,0xf8da809a}},	//   انات_, rraf, _बनाए, _बनाय,
   {{0x20048915,0x2fdf8282,0x29070162,0x2d9c8fdc}},	//   _bomi_, _paug_, âna_, dave_,
   {{0x6aad002e,0x2ef58fdd,0x628981e0,0x2fdf8069}},	//   praf, йзер, ypeo, _qaug_,
   {{0x20048fde,0x7c2d0fdf,0x6d5a8fe0,0xadc40032}},	//   _domi_, miar, _azta, _atẹw,
   {{0x9c7c803b,0x929d809a,0x2d9c8fe1,0x41c600c2}},	//   _grčk, syłk, gave_, र्दस,
   {{0x2fdf81c5,0x20048fe2,0x6b9b8fe3,0x610a829a}},	//   _taug_, _fomi_, taug, nəld,
   {{0xf77f817b,0x2d828019,0xf5380039,0x3c3a81a9}},	//   _üç_, _őket_, ינוי_, tīva_,
   {{0xa3c90fe4,0x6d5a8102,0x6b9b8fe5,0x3f158fe6}},	//   ल्य_, _ezta, raug, _удас,
   {{0x6b9b81e2,0xe1f98fe7,0x7528009a,0x27e00fe8}},	//   saug, уго_, ździ, _sain_,
   {{0x7c2d0102,0xd24e803d,0x7c360fe9,0x799883ec}},	//   kiar, رچه_, ynyr, _devw,
   {{0xa3c90fea,0x60060feb,0x9f0601a8,0xa3e60035}},	//   ल्म_, _cómp, موجو, _यों_,
   {{0x27e00364,0x91e58381,0x7c2d0fec,0x201e01e2}},	//   _vain_, _голе, diar, ėti_,
   {{0x442d8fed,0xdce38182,0x26c20fee,0x44d80176}},	//   lie_, lanı, rtko_, _pō_,
   {{0x26c20063,0x27e00fef,0x94790ff0,0x60c10106}},	//   stko_, _tain_, исту_, _älmh,
   {{0x442d8ff1,0x2d9c8ff2,0x7c2d0ff3,0xdce383bf}},	//   nie_, zave_, giar, nanı,
   {{0x38a38459,0x63a68ff4,0x7c360084,0xb3440085}},	// [720] lır_, ókni, rnyr, _keçə,
   {{0x442d882e,0x81ab00c8,0x9c828353,0x20048ff5}},	//   hie_, ক্স_, ščin, _somi_,
   {{0x442d8ff6,0x999a893f,0x8c460ff7,0x38a38182}},	//   kie_, רבעט, _гене, nır_,
   {{0x442d8ff8,0x2d9a0ff9,0x68fc8106,0x6e2e0ffa}},	//   jie_, _hepe_, ärdi, libb,
   {{0x442d8ffb,0x2d9c8ffc,0x3ea20ffd,0x9c7c80cd}},	//   die_, tave_, nskt_, _trčk,
   {{0x6b828081,0x6e2e04b7,0x38a382d0,0x27e08ffe}},	//   _sfog, nibb, kır_, žin_,
   {{0x2d9c8fff,0xdcfc00eb,0x557700be,0x6ce68196}},	//   rave_, darī, זעצן_, сіле,
   {{0x442d9000,0x38a38b06,0x2d9c9001,0x6d5a801b}},	//   gie_, dır_, save_, _vzta,
   {{0xa3bb01b6,0x3866816d,0x34d40054,0x2d9c9002}},	//   _घास_, mmor_, दबुद, pave_,
   {{0x7c2d1003,0x442d9004,0x3860009f,0x38a382d0}},	//   ziar, aie_, _ahir_, fır_,
   {{0x442d9005,0x19589006,0x660509f8,0x2bca835f}},	//   bie_, раны_, _rohk, _було_,
   {{0x442d9007,0x28a99008,0x38601009,0x39570039}},	//   cie_, _किरि, _chir_, משים_,
   {{0x7c2d100a,0x291e900b,0x799e100c,0x6e2e0037}},	//   viar, szta_, kapw, fibb,
   {{0xdb0d03a7,0x6e2e038a,0xe84c01d0,0x38a38380}},	//   lgaç, gibb, ětší, bır_,
   {{0x7c2d100d,0x2d9a02f7,0xe65400e8,0x38600c41}},	//   tiar, _depe_, ївсь, _fhir_,
   {{0x388101e2,0x69c88a53,0x2d9a026b,0x38600362}},	//   _nėra_, lfde, _eepe_, _ghir_,
   {{0x7c2d011e,0xa3b68665,0x99990aac,0x24580009}},	// [730] riar, _जाई_, икат_, сать_,
   {{0x442d900e,0x6fb50416,0x7c2d100f,0xa3bb0e5b}},	//   zie_, _امکا, siar, _घाव_,
   {{0xdce39010,0xa25b0038,0x9f520242,0x3c590087}},	//   yanı, _spôs, _anyè_, _винэ_,
   {{0x9f558468,0x9c7c9011,0x28ba03b7,0x64498118}},	//   овеч, _grči, _उमरि, xoei,
   {{0x442d9012,0x38a38059,0xdce388c5,0x81ab00ab}},	//   vie_, zır_, vanı, ক্ষ_,
   {{0x442d9013,0x7aed805c,0xd9fd05e8,0x38a39014}},	//   wie_, _šato, _उचित_, yır_,
   {{0x442d9015,0xdce387c0,0xed599016,0x69d7002a}},	//   tie_, tanı, шок_, mexe,
   {{0x7cca8201,0x52a99017,0x3ea2039c,0xe0d200be}},	//   _qəra, авим_, yskt_, _קײן_,
   {{0x28e10076,0x2d83009a,0xdce38059,0x442b1018}},	//   फिकि, kcje_, ranı, _mmc_,
   {{0x442d9019,0x38a385c5,0x88c98009,0x38600079}},	//   sie_, tır_, алов_, _shir_,
   {{0x442d901a,0xdce38380,0x61e50014,0x999e81d0}},	//   pie_, panı, idhl, nitř_,
   {{0xa3b6901b,0xb901901c,0xa2b2835a,0x38a38059}},	//   _जाए_, _नई_, _आमच्, rır_,
   {{0xf77207bd,0x38a38214,0xe29981a1,0xb7da81c6}},	//   باد_, sır_, _тал_, בקרי,
   {{0x63bb901d,0x5fdc101e,0x7ae9901f,0x3ea21020}},	//   lgun, _बसवल, mvet, rskt_,
   {{0xc5f28039,0xfce31021,0xf3870133,0x7c3a1022}},	//   ודם_, моро, _ụtọa, étro,
   {{0x63bb9023,0x3ead1024,0x26df81a1,0x69de9025}},	//   ngun, šeta_, _osuo_, _óper,
   {{0x61e39026,0x9c7c817f,0xa2061027,0x81dc80ab}},	// [740] _kanl, _isče, опад, ডার_,
   {{0xe1f71028,0x63bb8458,0xe24601a8,0x915f1029}},	//   огу_, hgun, آخري, _sắp_,
   {{0x6026902a,0x9c7c8968,0x7ae9902b,0x7c2b821e}},	//   оджа, _trči, hvet, _omgr,
   {{0xb8f20d38,0x9c7c803e,0x61e3902c,0x2eed902d}},	//   _वह_, _urči, _lanl, _bref_,
   {{0x38668bbd,0xaad8805e,0x4e0e102e,0x6d418106}},	//   rmor_, _बैंक, _हवाई_, _axla,
   {{0x6ce589a3,0xb0a98540,0x7ae9816d,0x0caa8318}},	//   किंग_, _किंग, dvet, атии_,
   {{0x90c3102f,0xa3d686a7,0x7bc99030,0x69ce1031}},	//   _обре, ाजल_, ffeu, _ibbe,
   {{0x61e380c9,0x2fc001c5,0x63bb9032,0x8aa69033}},	//   _aanl, _ncig_, ggun, ород,
   {{0x8af78201,0xada68187,0x61e39034,0x7ae98061}},	//   _şərh, _маал, _banl, gvet,
   {{0x61e39035,0x32188063,0x7ae48267,0x799c0326}},	//   _canl, óry_, _šits, _jerw,
   {{0x61e39036,0x63bb8102,0x2ee01037,0x3207808e}},	//   _danl, bgun, _asif_, _dony_,
   {{0x68e3013c,0x27e69038,0x69ca1039,0x61ed8300}},	//   ændi, ndon_, स्ती, _ɗali,
   {{0x91e68a94,0xb90183bb,0x26c6903a,0x09e68293}},	//   _моде, _नै_, ntoo_, _модн,
   {{0xd3448077,0x63a0903b,0x32078118,0x61e38114}},	//   _ویژه_, lamn, _gony_, _ganl,
   {{0x81c200c8,0x70c90074,0x80c90035,0x27e68122}},	//   ্যা_, _रहेल, _रहें, kdon_,
   {{0x27e48687,0xe3ac80ab,0xb8670fd3,0x3cdd86ae}},	//   _namn_, ক্রব, _باتو, _कईसे_,
   {{0xd7630bca,0x799c103c,0xa3cc8aed,0x69d701df}},	// [750] _تنظی, _berw, श्य_, texe,
   {{0x3eb9103d,0xaaac103e,0x63a0903f,0x63bb9040}},	//   must_, _चिरक, hamn, zgun,
   {{0x21270142,0x69d71041,0x3eb90074,0x7ae98019}},	//   ành_, rexe, lust_, zvet,
   {{0x69d71042,0x69ce1043,0x60c50428,0x6b8400e5}},	//   sexe, _ebbe, rthm, ccig,
   {{0xd6db823a,0x799c1044,0x69d71045,0xfd4c80ff}},	//   рте_, _ferw, pexe, _triề,
   {{0xc27a0039,0x66088079,0x62728035,0x7ae982d0}},	//   _לרשי, _codk, _słon, vvet,
   {{0x1c0f09f2,0x32078176,0x91fc80eb,0x27e49046}},	//   _सवाल_, _rony_, rmāl, _famn_,
   {{0xd7c9803d,0x61e39047,0x3eb90074,0xa80601df}},	//   _دوره_, _sanl, kust_, _mañá,
   {{0x63bb9048,0x61e39049,0xeab181a8,0x7ae98162}},	//   rgun, _panl, رعة_, uvet,
   {{0x2ea806b7,0x6608904a,0x3eb9103d,0xa925904b}},	//   _कटौत, _godk, dust_, здол,
   {{0x7ae9904c,0x61e3904d,0xf1b200be,0xa3bb853d}},	//   svet, _vanl, עסט_, _ناشر_,
   {{0xb4e78540,0x63a0904e,0x22808247,0x5437853d}},	//   यटी_, camn, _fòk_, _برطر,
   {{0xa3e6104f,0x61e39050,0xe8039051,0xe7371052}},	//   _योग_, _tanl, _रचना_, зея_,
   {{0xa3c91053,0x321e9054,0x3e6086c0,0x59c29055}},	//   ल्स_, chty_, pòte_, _शायर,
   {{0xed5a1056,0x27e69057,0x1828003d,0xdbd9007b}},	//   сов_, ydon_, _وقتی_, tæðu,
   {{0x799c0d38,0x7c3b9058,0xaca3819d,0x6b9d1059}},	//   _serw, nnur, _anịm, _cesg,
   {{0x3cdd8063,0x799c105a,0xc86500f7,0xdbd9007b}},	// [760] _कैसे_, _perw, _تطوي, ræðu,
   {{0x6aa40057,0x6b84105b,0x09e3105c,0xe4760012}},	//   rsif, scig, ноун, _нумэ,
   {{0x799c105d,0x6b9d002a,0xa8060118,0x1b0400ab}},	//   _verw, _fesg, _gañá, _রেখে_,
   {{0x6281105e,0xdcf5009a,0x7985105f,0x799c1060}},	//   _člov, jczę, achw, _werw,
   {{0x44321061,0x799c1062,0x66088f66,0x27e69063}},	//   miy_, _terw, _podk, rdon_,
   {{0x26c68009,0xd49a8abe,0x98a61064,0x27e485ee}},	//   rtoo_, бри_, _ниге, _wamn_,
   {{0x39a68013,0x26c68079,0x628b8428,0xa3c9064a}},	//   hísí_, stoo_, _atgo, ल्व_,
   {{0xafe39065,0x44201066,0xb60380eb,0x320a008e}},	//   _посл, nhi_, īšan, _hoby_,
   {{0x27f7800d,0x44201067,0x2bce016f,0xa0678a4c}},	//   šení_, ihi_, ह्या, _хата_,
   {{0x59cf016f,0xe8e000ff,0x3eb90074,0x7de580f7}},	//   स्पर, _nhịp_, vust_, _يسلم,
   {{0x69bd8eed,0x44201068,0x69c10f1b,0x3eb900f3}},	//   _शारी, khi_, र्टी, wust_,
   {{0x44201069,0x3eb90006,0x29028289,0x443202ed}},	//   jhi_, tust_, ćka_, jiy_,
   {{0x4420106a,0x2d9e906b,0x6b9d106c,0x79850428}},	//   dhi_, _kete_, _resg, ychw,
   {{0x99ce00c8,0x2d9e906d,0x2b09801b,0x6b9d016a}},	//   রযুক, _jete_, िहरु_, _sesg,
   {{0x2d9e8205,0x61f8837a,0x3eb90074,0x248c8037}},	//   _mete_, _invl, sust_, _jtdm_,
   {{0x4420106e,0x69da906f,0x3eb91070,0x5c741071}},	//   ghi_, lete, pust_, елст,
   {{0x3eb91072,0x3a751073,0x78ba9074,0x320a1075}},	// [770] qust_, длар, lutv, _boby_,
   {{0x44200079,0xdce70214,0xa3cc8105,0xdcf50035}},	//   ahi_, sajı, श्त_, zczę,
   {{0x02d983bb,0x77610201,0x79851076,0x320a03c1}},	//   _भन्न, əlxa, rchw, _doby_,
   {{0x44201077,0x69da9078,0x798502af,0x98c582a5}},	//   chi_, hete, schw, žući_,
   {{0xa2a700cf,0x69da9079,0x7ae2907a,0x2d9e8102}},	//   _चिट्, kete, _nsot, _bete_,
   {{0x2d9e8052,0x69da907b,0x7bcd0bda,0x8afa01c6}},	//   _cete_, jete, lfau, _והשי,
   {{0x2d9e8eef,0xd0d40698,0x20f08904,0xe81e06a7}},	//   _dete_, _поръ, nđić_, _पतला_,
   {{0x3ea9025d,0xfcaa093f,0x61e70061,0xdb1b907c}},	//   _ovat_, קיפּ, _hajl, lgué,
   {{0x2d9e907d,0x61e70088,0x7aed107e,0x81e000ab}},	//   _fete_, _kajl, nvat, থার_,
   {{0xb33b07d9,0xdb1b907f,0x69da9080,0x44201081}},	//   _geçe, ngué, gete, zhi_,
   {{0x7aed02a5,0x7ae29082,0x61e71083,0x44201084}},	//   hvat, _esot, _majl, yhi_,
   {{0x44201085,0x7aed00d2,0x61e701c0,0xead2077f}},	//   xhi_, kvat, _lajl, fẹ́_,
   {{0x44321086,0x44201087,0x764e1088,0x7aed0bcf}},	//   viy_, vhi_, toby, jvat,
   {{0x61e71089,0x7a200019,0x59cf04c5,0xf1cf108a}},	//   _najl, _köte, स्मर, स्मन,
   {{0x4420108b,0x443202d6,0x442f8079,0x320a00e5}},	//   thi_, tiy_, _kmg_, _roby_,
   {{0x7a20016d,0x68fc908c,0xc1728039,0x4420010b}},	//   _möte, årde, _בחו_, uhi_,
   {{0xfaa3108d,0x4420108e,0x442f908f,0x2eff0192}},	// [780] като, rhi_, _mmg_, äuft_,
   {{0x44201090,0xe9d71091,0x601f0168,0x7cca829a}},	//   shi_, мку_, _vëme, _sərm,
   {{0xb4661092,0x2d9e9093,0x4420029b,0x25e71094}},	//   _окол, _rete_, phi_, _छोटी_,
   {{0x69da9095,0x9f401096,0x6d40017b,0xb33b0214}},	//   zete, _unió_, şmas, _seçe,
   {{0x61e71097,0xa3c8809a,0x63a41098,0xc7a384bd}},	//   _fajl, _लॉग_, main, тичк,
   {{0x3f9f9099,0x3f86907c,0x7a200106,0xd04c8085}},	//   _eeuu_, scou_, _böte, _əhəm,
   {{0x2d9e80f1,0x69da909a,0x28dd909b,0xf8d20075}},	//   _vete_, vete, _फैलि, _सहिय,
   {{0x2284109c,0x69da909d,0x2d9e909e,0x6b9600e8}},	//   _kök_, wete, _wete_, nbyg,
   {{0x2d9e909f,0x69c38580,0x427490a0,0xe45701c6}},	//   _tete_, _bcne, нгис, ויקט_,
   {{0x61e88713,0xf8d210a1,0x63a410a2,0xdb150036}},	//   uddl, _सहाय, hain, ébéc,
   {{0xd1308307,0x63a410a3,0x291890a4,0x69da90a5}},	//   امج_, kain, ára_, rete,
   {{0xe8df0028,0x7aed026f,0x63a410a6,0x7ae290a7}},	//   _cuộc_, yvat, jain, _tsot,
   {{0x63a410a8,0xd6d9809a,0x6b9610a9,0x78ba90aa}},	//   dain, _były_, dbyg, sutv,
   {{0xead210ab,0x7aed10ac,0x69da90ad,0x2ef20a53}},	//   rẹ́_, vvat, qete, _dryf_,
   {{0x61e70267,0x1bd50098,0xdb008511,0x2edb90a1}},	//   _rajl, новя, damé, _यन्त,
   {{0x63a40219,0x69ca8b6f,0x61e7025b,0x20f08088}},	//   gain, त्री, _sajl, rđić_,
   {{0xeabc80ab,0x61e70282,0x2bd08072,0x2ef210ae}},	// [790] _অনুম, _pajl, थ्या, _gryf_,
   {{0x6d4510af,0x27e910b0,0xdb0090b1,0x228410b2}},	//   _txha, _haan_, ramè, _dök_,
   {{0x63a410b3,0x7aed037b,0x588401bb,0xd13100f7}},	//   bain, svat, выча, دما_,
   {{0x201910b4,0x3cf48743,0x27e910b5,0x63a410b6}},	//   nksi_, ्मने_, _jaan_, cain,
   {{0x61e710b7,0x0f35804e,0x27e902a1,0x20190198}},	//   _tajl, رکرد, _maan_, iksi_,
   {{0x780c016f,0x27e910b8,0x68e3006a,0x64428198}},	//   _हक्क_, _laan_, ænds, _ajoi,
   {{0xf41f0106,0x25a110b9,0xafdb0163,0x00000000}},	//   _klä_, _mehl_, sløy, --,
   {{0x7cca8085,0x3eb28084,0x27e910ba,0x2d878174}},	//   _mərh, šyta_, _naan_, scne_,
   {{0x7c3a0073,0x9f9d007b,0x316300c3,0xf6b58019}},	//   étri, væði_, _hzjz_, _سماج,
   {{0x63a410bb,0xfdf38424,0x20190009,0x569490bc}},	//   zain, _आफिस_, eksi_, _рафт,
   {{0x6e350052,0x27e910bd,0x09e18264,0x200d8a53}},	//   dizb, _baan_, বালা, _koei_,
   {{0xcdc90051,0x80a0809a,0x59cf10be,0x2b408968}},	//   _לך_, _खबरे, स्तर, _žice_,
   {{0xef1710bf,0x63a410c0,0x27e910c1,0xcc3a80be}},	//   емя_, vain, _daan_, _צענט,
   {{0x63a410c2,0xfce60a13,0x645b90c3,0xc69283de}},	//   wain, ного, llui, ראם_,
   {{0x443f90c4,0x228404b8,0xa3cc90c5,0xa50a0d5f}},	//   onu_, _sök_, श्व_, чева_,
   {{0x443f90c6,0x27e910c7,0x6b898057,0x7dd38457}},	//   nnu_, _gaan_, nceg, lısı,
   {{0x34dc90c8,0x6b9610c9,0x7ae9016b,0x41b610ca}},	// [7a0] _मन्द, rbyg, _šetr, есет,
   {{0x69c190cb,0x6b9610cc,0x80c900ab,0x8e9701c6}},	//   ngle, sbyg, রবন্, _רדיו_,
   {{0x2d9810cd,0x63a410ce,0xf1c290cf,0x69c80214}},	//   mbre_, pain, _शासन, _ödem,
   {{0xa2b210d0,0x443f883d,0x7afb0bcf,0xcfb20264}},	//   ेंद्, jnu_, _šute, ট্রন,
   {{0x443f90d1,0xc87981cc,0x7cca8085,0xe8df819d}},	//   dnu_, _diş_, _tərk, diọm_,
   {{0x443f90d2,0x69c190d3,0x6aa990d4,0xa3c8864a}},	//   enu_, jgle, dsef, _लॉज_,
   {{0x69c18503,0x443f90d5,0x32430171,0x5fc6016f}},	//   dgle, fnu_, _серг, _वाढल,
   {{0x59c2886a,0x66e690d6,0x6b7b00be,0x25fe816f}},	//   _शाहर, _поба, ּרינ, लाही_,
   {{0xdcea90d7,0xe7d583bf,0x3edf0133,0x27e902d5}},	//   rafı, lığı, _kwụọ_, _raan_,
   {{0x27e910d8,0x69c190d9,0x443f90da,0x9fd000ab}},	//   _saan_, ggle, anu_, িযোগ,
   {{0x7c2410db,0x443f883d,0x27e910dc,0x39588366}},	//   khir, bnu_, _paan_, ærs_,
   {{0x645b90dd,0x69de10de,0x351b8039,0x2d980144}},	//   clui, hepe, _מובנ, ebre_,
   {{0x27e90364,0x69de10df,0x7cca8085,0x81ab0264}},	//   _vaan_, kepe, _sərh, ক্ট_,
   {{0xa3cc83b7,0x27e902a3,0x4992804e,0x63a290e0}},	//   श्र_, _waan_, _حیدر, _heon,
   {{0x644102be,0x63a290e1,0x69de10e2,0x6282810c}},	//   élio, _keon, depe, _huoo,
   {{0xe7d582bb,0x7c2410e3,0x63a290e4,0x61ea90e5}},	//   dığı, ghir, _jeon, _hafl,
   {{0xf1a48b85,0x63a2808e,0x7cca8085,0x61ea8ff4}},	// [7b0] _खजान, _meon, _dəri, _kafl,
   {{0x63a290e6,0xbbdd90e7,0x443f90e8,0x69de10e9}},	//   _leon, _मस्क, znu_, gepe,
   {{0x443f90ea,0x7c2410eb,0x47bc8264,0xb21b0163}},	//   ynu_, bhir, োজনী, _stæs,
   {{0x7c2410ec,0x61ea90ed,0x443f02f9,0x6e9590ee}},	//   chir, _lafl, _ñu_, виду,
   {{0x443f803a,0xdee590ef,0x44248013,0xb4e10054}},	//   vnu_, толи, dhm_, _धनु_,
   {{0x27e9803b,0xe6188163,0x69de10f0,0xed5987b6}},	//   žan_, нді_, cepe, мол_,
   {{0x443f812b,0x6d5a8035,0x7e7a810c,0x645b90f1}},	//   tnu_, _cyta, _ditp, tlui,
   {{0x2ef587eb,0x201f802e,0x7bdf041c,0x386901b9}},	//   _избр, _ului_, nequ, _nhar_,
   {{0x6b89807d,0x63a290f2,0x645b90f3,0x045680f7}},	//   rceg, _deon, rlui, خلية_,
   {{0x443f82a5,0x645b90f4,0x6aa990f5,0xd24e80a0}},	//   snu_, slui, rsef, يني_,
   {{0x69c190f6,0xd945828b,0xf1c6086a,0x25fe90f7}},	//   rgle, тени, र्टन, लारी_,
   {{0xe73a10f8,0x68fc8106,0x69c190f9,0xdb1b8333}},	//   дем_, årda, sgle, lguí,
   {{0x69c702fd,0x26160074,0x7dd3807e,0x69de10fa}},	//   _ocje, _नकदी_, pısı, yepe,
   {{0xdb1b8228,0xdd92003f,0x628003c9,0x61ea90fb}},	//   nguí, شور_, _émoi, _gafl,
   {{0xed570785,0xada310fc,0x7c2410fd,0x63a290fe}},	//   вор_, расл, thir, _yeon,
   {{0x1c4310ff,0x63a283a8,0x38691100,0x60d69101}},	//   ансм, _xeon, _ghar_, _יוצא_,
   {{0xb33b0073,0xeab10065,0x7c240c0b,0x248601d6}},	// [7c0] _peça, یعے_, rhir, _čomu_,
   {{0x7c241102,0xb21b1103,0xceb9000d,0x68f5026f}},	//   shir, _stær, áře_, _brzd,
   {{0x291c0ed7,0x69de1104,0xb33b00f1,0x7bdf1105}},	//   áva_, repe, _veça, bequ,
   {{0x6e219106,0x7bc6026c,0xf1c61107,0x7ae602c4}},	//   _allb, _ucku, र्जन, _tskt,
   {{0x44220459,0x63a2826c,0xdfcf80f7,0x3ead9108}},	//   _ilk_, _reon, تين_, _cvet_,
   {{0x6d5a8063,0x93f60201,0xaa461109,0x4a750009}},	//   _pyta, _şəhə, _регл, _быст,
   {{0x63a2910a,0xa3c9000c,0x3ead8214,0x98a3110b}},	//   _peon, ल्क_, _evet_, _висе,
   {{0x61ea831d,0x7bc4110c,0xa78580f7,0x6d5a910d}},	//   _safl, ngiu, _مشكو, _vyta,
   {{0x7c23002e,0x59cf000c,0xdee3910e,0x7ae40197}},	//   _înre, स्वर, _коти, nwit,
   {{0xaca401bc,0x610a8085,0x7e7a910f,0x63a28144}},	//   _ahọt, səlm, _uitp, _weon,
   {{0x859b82f6,0x9f4e026f,0x3ea01110,0x850688ca}},	//   _חשבו, čným_, _awit_, _جوان,
   {{0xc9530051,0x28c48540,0xaca40135,0x7ae41111}},	//   ימת_, लंबि, _chọt, kwit,
   {{0xd5c98074,0x05c98a74,0x7c229112,0x61ea9113}},	//   _रामज, _रामब, _ilor, _tafl,
   {{0xb8f480f7,0x6e940009,0x44221114,0x70d206a7}},	//   _مكتب, риру, _alk_, _सहूल,
   {{0x62728063,0x3869008c,0x7bdf1115,0x1dd206bf}},	//   _słow, _thar_, tequ, द्धत,
   {{0xd10f83b7,0x7bc40098,0xaca40135,0x41c6052a}},	//   ाहरण_, ggiu, _ghọt, र्घस,
   {{0x24580364,0xdb1d06c4,0x0cbf83b7,0x41cf8743}},	// [7d0] тать_, _absò, _एम्म, त्वस,
   {{0x7c229116,0x200b0503,0x4422038e,0xf7f48077}},	//   _llor, ljci_, _elk_, یسند,
   {{0x3ead9117,0x0cbd80c8,0x7c2290ab,0xe01e8105}},	//   _svet_, _আন্ত, _olor, पसंद_,
   {{0xa2c30540,0x76551118,0x787a801b,0x7ae41119}},	//   िंद्, lozy, _důvo, bwit,
   {{0xa3cc00d4,0x539a0039,0x3c3a80eb,0x03d61101}},	//   _शॉट_, _רישו, hīvs_, _גורם_,
   {{0x7c22911a,0x69c7111b,0x5187111c,0x6b8d111d}},	//   _alor, _ucje, _шума, lcag,
   {{0x6aad111e,0xb4b1009a,0x7c22911f,0x81cc0264}},	//   lsaf, _ऑटो_, _blor, _শোক_,
   {{0x20f30a20,0x30da00be,0x2fc901c0,0x69c51120}},	//   _ići_, _אַמע, _ncag_, lghe,
   {{0x2bd51121,0x32111122,0x2d8101bc,0x0a398190}},	//   ड्या, _kozy_, _oghe_, ечны_,
   {{0x2d810028,0x20f31123,0x7c229124,0xb33b0036}},	//   _nghe_, _kći_, _elor, _leço,
   {{0xe4cb9125,0x07a6035f,0x69c50083,0x1acf00ab}},	//   _زبان_, ланн, ighe, রিয়া,
   {{0x30da00be,0x27ed9126,0x7643808e,0xf3f081a8}},	//   ײַטע, _jaen_, lnny, _وأن_,
   {{0x25a59127,0x27ed9128,0x63a99129,0x9f8a8074}},	//   _kell_, _maen_, maen, _tööd_,
   {{0x27ed912a,0x2aba8039,0x7c22912b,0x63a9912c}},	//   _laen_, _נמצא, _zlor, laen,
   {{0x27ff9010,0x03e680c8,0xdcee080a,0x7643912d}},	//   _onun_, কারী_, tabı, inny,
   {{0x6b8d112e,0x61e1912f,0xf1cf9130,0x63a99131}},	//   gcag, lell, त्रन, naen,
   {{0xab661132,0xe1fa1133,0x764380dd,0x6826016a}},	// [7e0] увал, нга_, knny, _códe,
   {{0x55e61134,0x25a58698,0xdcee080a,0x787a801b}},	//   _сооб, _nell_, sabı, _půvo,
   {{0x7ae41135,0x61e18081,0x610a8085,0x20120041}},	//   swit, iell, vəlk, _koyi_,
   {{0x61e19136,0x6b8d1137,0xe29a1138,0x27ed9139}},	//   hell, ccag, _пам_, _caen_,
   {{0x61e1913a,0xdd92826a,0x6456113b,0x7e7e113c}},	//   kell, موش_, moyi, _kipp,
   {{0x69d3913d,0x7e7e04b7,0xc1e7019f,0x61e1913e}},	//   _बॉली, _jipp, _مکمل_, jell,
   {{0x61e1913f,0x25a59140,0x62861141,0x63a61142}},	//   dell, _dell_, _huko, _kekn,
   {{0x61ee1143,0x62861144,0xe4f70996,0x76438867}},	//   _habl, _kuko, ुमति_, anny,
   {{0x61ee1145,0x61e19146,0x7c2280f1,0xa3c9000c}},	//   _kabl, fell, _vlor, ल्ट_,
   {{0x628601d3,0x61e19147,0x61ee07df,0xddc89148}},	//   _muko, gell, _jabl, _hidž,
   {{0x5bc68bbe,0x61ee1149,0x64440009,0x63a9820d}},	//   _مقال, _mabl, knii, baen,
   {{0x6456114a,0x0eeb0009,0x61ee114b,0x26c2114c}},	//   joyi, ньги_, _labl, fuko_,
   {{0xcc57810f,0xb33b0036,0xddc88b80,0xe2968073}},	//   _גבאי_, _reço, _midž, _среќ,
   {{0x27ed114d,0x61e1914e,0x7e7e00e5,0xa2c3114f}},	//   žen_, cell, _cipp, िंस्,
   {{0xf9938039,0x69ca8144,0x62861150,0x63a61151}},	//   _פרק_, _icfe, _auko, _bekn,
   {{0x682607f4,0x62861152,0x60df8065,0x3756082e}},	//   _póde, _buko, őzmé, ọdụ_,
   {{0x5a350e17,0x92590003,0x765a8085,0x76439153}},	// [7f0] анат, ваат_, _okty, ynny,
   {{0x61ee1154,0x27ed81df,0x321e809a,0x6b8d1155}},	//   _cabl, _saen_, nkty_, scag,
   {{0xa3d51156,0xa3e58105,0x69c51157,0x6aad1158}},	//   _конч, _फसल_, rghe, ssaf,
   {{0x61e19159,0x765a915a,0x63a6115b,0x6272809a}},	//   zell, _akty, _gekn, _złot,
   {{0x69d8915c,0x61ee115d,0xddc881e2,0x62860578}},	//   _obve, _fabl, _didž, _guko,
   {{0x4429115e,0xf770915f,0x64599160,0x61e18bf9}},	//   lha_, سان_, _skwi, xell,
   {{0x62861161,0x6b9b8609,0x20f3005c,0x61e19162}},	//   _zuko, tbug, _ući_, vell,
   {{0x442907e1,0x62861163,0x25a58051,0x61e19164}},	//   nha_, _yuko, _well_, well,
   {{0x61e19165,0x62800036,0xcb1200be,0x25a58039}},	//   tell, _émot, ַלט_, _tell_,
   {{0x63a98573,0x60c1861c,0x6abb9166,0x26c21167}},	//   saen, tulm, rruf, vuko_,
   {{0x5d849168,0x645600a4,0xc5fa80be,0x44291169}},	//   _المل, yoyi, _שפעט, kha_,
   {{0x61e1916a,0x4375916b,0x26c200ad,0x60c1817b}},	//   sell, _култ, tuko_, rulm,
   {{0x4429116c,0x60c1916d,0x8c1a8039,0xe7d7916e}},	//   dha_, sulm, _שוני, ण्यप,
   {{0x7c29916f,0x51879170,0x26c21171,0xc9878389}},	//   lher, _суда, ruko_, _суди,
   {{0xed5a1172,0x64a60912,0xe8168076,0x26c21173}},	//   тов_, раба, _थकला_, suko_,
   {{0x44291174,0x1e86013a,0x20000974,0x6286005c}},	//   gha_, _клим, _unii_, _puko,

   {{0x7e7e1175,0x64561176,0x6272809a,0x6d5e009a}},	// [800] _tipp, royi, _głos, _wypa,
   {{0x6286003a,0xb33b0214,0x6d4100f7,0xc6930039}},	//   _vuko, _geçm, úlac, _ואז_,
   {{0x44291177,0x55bb0039,0x61ee007a,0x7c299178}},	//   bha_, _במיו, _vabl, kher,
   {{0x44291179,0x386d82be,0x6286117a,0xfa8880ff}},	//   cha_, _cher_, _tuko, _lừa_,
   {{0x4420117b,0x66f4917c,0x628600e4,0x386d917d}},	//   mki_, сплу, _uuko, _dher_,
   {{0x61ee0362,0x40960785,0x386d82af,0x9c7c8140}},	//   _uabl, _врат, _eher_, _isči,
   {{0xac26917e,0xdb008789,0x29070106,0xd943117f}},	//   ифик, damá, änat_, _дери,
   {{0x20e80059,0x7c299180,0x6aa28247,0x7c3b9181}},	//   _işi_, gher, _pwof, giur,
   {{0x787f00eb,0xf5ea9182,0x5a348081,0xdb0d008b}},	//   _būvn, _имал_, йнит, ngað,
   {{0x44201183,0x7a248362,0x387f8cdb,0x24780176}},	//   hki_, _bòta, _ziur_, _dōmi_,
   {{0x44201184,0x6e3c1185,0x7c298234,0xfa8880ff}},	//   kki_, dirb, bher, _dừa_,
   {{0x7c299186,0xb33b080a,0x44291187,0x44201188}},	//   cher, _seçm, xha_, jki_,
   {{0x22949189,0x4426918a,0x09e180c8,0x4420118b}},	//   _التس, _ilo_, বাজা, dki_,
   {{0x4420118c,0x4429022b,0x44268069,0xaadb83c8}},	//   eki_, wha_, _hlo_, _סחור,
   {{0x4429118d,0x4426918e,0xda05000f,0x6272809a}},	//   tha_, _klo_, रासत_, _włos,
   {{0xe97b8039,0xf21c8105,0x5bb80009,0x717b8039}},	//   _בנוש, _पकड़_, ился_, _בנוס,
   {{0x4429118f,0xb06602f1,0xf7731190,0x32d08129}},	// [810] rha_, svää, _باغ_, này_,
   {{0x44291191,0x44201192,0x44269193,0x69c8904a}},	//   sha_, aki_, _llo_, ngde,
   {{0xda781194,0x4f58026a,0x44201195,0x6f1d0176}},	//   рят_, _مجید_, bki_, lysc,
   {{0xa3ce023c,0xe8df0104,0xd1268117,0x44268091}},	//   _राय_, _quốc_, _ہم_, _nlo_,
   {{0x63ad1196,0xd9f8815c,0x161b016f,0x44390581}},	//   maan, ्ञात_, _नकार_, _ims_,
   {{0x63ad1197,0x6da28073,0x7c2981c6,0xe5a29198}},	//   laan, пиша, wher, пиши,
   {{0xa3ce1199,0x4426807a,0x7c29919a,0x2907119b}},	//   _राम_, _blo_, ther, ånad_,
   {{0x63ad119c,0x4369919d,0x4426919e,0x1be988ed}},	//   naan, лайн_, _clo_, удии_,
   {{0x7c3b919f,0x7c2991a0,0x44268247,0x44390558}},	//   riur, rher, _dlo_, _mms_,
   {{0x442691a1,0x442011a2,0x7c2991a3,0x63ad11a4}},	//   _elo_, zki_, sher, haan,
   {{0x63ad11a5,0x442691a6,0xfa888028,0x60c500dd}},	//   kaan, _flo_, _vừa_, nuhm,
   {{0x442691a7,0x5c7591a8,0xdb0091a9,0x7bd98314}},	//   _glo_, _улет, samá, _ubwu,
   {{0x44200805,0x63ad11aa,0xceb283de,0x28c9064a}},	//   vki_, daan, ּיל_, ांडि,
   {{0x44200063,0xe29c80be,0x7d1c03ed,0x519581a8}},	//   wki_, _ישׂר, tyrs, _الغذ,
   {{0x442011ab,0x823491ac,0x1d19035f,0x63ad11ad}},	//   tki_, _برنا, ають_, faan,
   {{0x63ad11ae,0x61b7816f,0x3eb28110,0x7bc991af}},	//   gaan, _आयुष, šyti_, ngeu,
   {{0x442011b0,0xe9da11b1,0x7ae991b2,0xd46711b3}},	// [820] rki_, лка_, nwet, сите_,
   {{0x645d11b4,0x7afd8198,0x27f201b4,0xdb0d01fa}},	//   _eksi, ästy, _hayn_, rgað,
   {{0xf77f03a7,0x63ad11b5,0x5a3a80be,0x442011b6}},	//   meça_, baan, נגעה, pki_,
   {{0x7ae991b7,0x63ad11b8,0xa967047f,0xf77f02df}},	//   kwet, caan, щиха_, leça_,
   {{0x2907016d,0x628f91b9,0x9ad38870,0x61e511ba}},	//   änar_, ícol, _dịkw, behl,
   {{0x442691bb,0x60c50359,0xd0420085,0x7cca8085}},	//   _slo_, buhm, rtlə, _bərp,
   {{0x645d0364,0x261991bc,0xd0420085,0xd4978110}},	//   _yksi, _बकरी_, stlə, бры_,
   {{0x290500ce,0x1e86845e,0x786a91bd,0x9c7c80c3}},	//   _šlag_, _глам, býva, _opče,
   {{0x59cf11be,0x09ac80ab,0x6a700106,0x69c811bf}},	//   स्कर, _খাবা, räff, _ödes,
   {{0x98a787d9,0xb33b0201,0x6d4003bf,0x23ad0084}},	//   _aynı_, _seçk, şmay, mųjų_,
   {{0x69dc11c0,0x63ad11c1,0x4426812b,0x69ce0176}},	//   _mbre, yaan, _tlo_, _mcbe,
   {{0x63ad02c1,0x442691c2,0x438680f7,0xbb8680f7}},	//   xaan, _ulo_, _الإق, _الإي,
   {{0x69dc11c3,0xf1a810a1,0x23ad0084,0x291886ae}},	//   _obre, गरान, nųjų_, ärab_,
   {{0x63ad11c4,0x7afd806a,0x44f880ff,0x41c70f3d}},	//   waan, æste, _kĩ_, _लाइस,
   {{0x43960a2c,0x786a83f2,0x2d910035,0xb425866f}},	//   _ọrụ_, zýva, rcze_, łżeń,
   {{0x682604c3,0x25bf11c5,0xa3cc91c6,0x53990198}},	//   _tóda, şul_, श्च_, рвая_,
   {{0x7b6711c7,0xb33b0086,0x63ad11c8,0xf77f0073}},	// [830] стве, _keçi, raan, beça_,
   {{0x63ad11c9,0x9c7c80fe,0x9ad3819d,0x69dc0362}},	//   saan, _isču, _sịkw, _cbre,
   {{0x63ad11ca,0x6826026f,0xf96b0196,0x44390198}},	//   paan, _módn, урай_, _tms_,
   {{0x69dc11cb,0x7c6711cc,0x63ad0079,0x160700d4}},	//   _ebre, _داخل, qaan, शावर_,
   {{0x7c2d11cd,0xa3ce0740,0x60c50a84,0x287c00be}},	//   mhar, _रात_, suhm, אנאמ,
   {{0xae038aed,0x7c2d11ce,0x69d80e88,0x313511cf}},	//   लाइन_, lhar, न्दी, _дегр,
   {{0xac0991d0,0x24098171,0xafdb006a,0x661702f9}},	//   инка_, инки_, rnøj, _moxk,
   {{0x7afd025b,0x7c2d11d1,0x601f020f,0xa4b80039}},	//   _krst, nhar, _fëmi, צלחה_,
   {{0xc7b98019,0x7bc980e7,0x20f78162,0x7afb05f3}},	//   _idő_, rgeu, _săi_, _šutj,
   {{0x394591d2,0x1ddb097d,0xaca311d3,0x7ae991d4}},	//   жног, म्मत, _atọg, rwet,
   {{0xa96991d5,0x7c2d11d6,0x216991d7,0x7bcf11d8}},	//   рина_, khar, рини_, _occu,
   {{0xe8df8028,0x3dc989ab,0xe8e0027d,0x20d191d9}},	//   hiệm_, ɗawa_, _chộp_, rái_,
   {{0x7c2d06df,0x442d8068,0x6d4111da,0xc7d681c6}},	//   dhar, mhe_, úlan, חורי_,
   {{0x443f91db,0xb33b07d9,0x442d8073,0x628b91dc}},	//   liu_, _geçi, lhe_, _iugo,
   {{0xf77f11dd,0x27e686ff,0x7afd11de,0x628391df}},	//   reça_, yeon_, _arst, _iino,
   {{0x443f91e0,0x7c2d11e1,0x644991e2,0x442d8073}},	//   niu_, ghar, nnei, nhe_,
   {{0xda0509a3,0x63ab8019,0x644991e3,0x987b03de}},	// [840] रांत_, _megn, inei, _דאקט,
   {{0x63ab91e4,0x442d8940,0x644991e5,0x628b820c}},	//   _legn, hhe_, hnei, _mugo,
   {{0x7afd11e6,0x7c2d11e7,0x442d91e8,0x443f8110}},	//   _erst, bhar, khe_, kiu_,
   {{0x81e70a49,0x307691e9,0x628391ea,0x68260019}},	//   ভাগ_, цузс, _lino, _módo,
   {{0x442d91eb,0x443f91ec,0x44f88028,0x087700be}},	//   dhe_, diu_, _sĩ_, קענט_,
   {{0x8c1f00c8,0xdcba8098,0x7c240074,0xa0a611ed}},	//   নোদন_, ащи_, lkir, _магд,
   {{0x25ba11ee,0x7a2001ec,0x291c02f1,0x443f91ef}},	//   _mdpl_, _nöti, ävad_, fiu_,
   {{0x09b48a49,0x442d91f0,0xb33b1010,0x443f91f1}},	//   জ্ঞা, ghe_, _seçi, giu_,
   {{0x63ab91f2,0x2d9691f3,0x628b80c3,0x63b90035}},	//   _degn, _дрес, _cugo, ówni,
   {{0x386691f4,0x628b803a,0x291e8110,0xfce691f5}},	//   llor_, _dugo, tyta_, _мозо,
   {{0xf9930051,0x443f91f6,0x69fb010f,0x7c240c56}},	//   ורת_, biu_, בליק, kkir,
   {{0x443f91f7,0x63ab91f8,0x291e91f9,0x628b91fa}},	//   ciu_, _gegn, ryta_, _fugo,
   {{0xe1ef91fb,0xc7b38051,0x38668087,0x628391fc}},	//   رسی_, ובר_, ilor_, _fino,
   {{0x765c11fd,0x7c2d11fe,0x628391ff,0x64409200}},	//   gory, whar, _gino, limi,
   {{0x7c2d1201,0x61e88bbd,0x7c2402a6,0xfe6e0180}},	//   thar, medl, fkir, دگي_,
   {{0x69da8a34,0x62839202,0xdb0080e1,0x38668b67}},	//   lfte, _zino, pamä, jlor_,
   {{0x7c2d1203,0xdceb03bf,0xf77f03a7,0x628b8118}},	// [850] rhar, ınız, meço_, _xugo,
   {{0x7c2d1204,0x61e8831d,0x64409205,0x443f9206}},	//   shar, nedl, himi, ziu_,
   {{0x64409207,0x7c2d1208,0xf8b1004e,0x442480b9}},	//   kimi, phar, عکس_, kkm_,
   {{0xdce50028,0x443f9209,0x6440920a,0x25ac802a}},	//   _nghĩ, xiu_, jimi, _aedl_,
   {{0x63ab920b,0x6605920c,0x443f920d,0x63a206a5}},	//   _regn, зпла, viu_, ñone,
   {{0x63ab8698,0x61e8920e,0x628b920f,0x7aed1210}},	//   _segn, jedl, _rugo, mwat,
   {{0x442d9211,0x443f9212,0x64409213,0x628b9214}},	//   the_, tiu_, fimi, _sugo,
   {{0x61f51215,0x64409216,0x3f891217,0xa2c2001b}},	//   _hazl, gimi, _ngau_, _लिम्,
   {{0x443f9218,0x63ab8125,0x62839219,0x442d84a9}},	//   riu_, _vegn, _pino, rhe_,
   {{0x442d921a,0x443f921b,0x7c24059f,0x61f50748}},	//   she_, siu_, zkir, _jazl,
   {{0x442d921c,0x63ab921d,0x61f5121e,0x6440921f}},	//   phe_, _tegn, _mazl, bimi,
   {{0x64409220,0x7aed0c56,0xe8df082e,0x628b9221}},	//   cimi, kwat, _ahịa_, _tugo,
   {{0x765c1222,0x62839223,0x249a03ac,0xd5d2852a}},	//   tory, _tino, _stpm_, _सामज,
   {{0x682604c3,0xa3ce000f,0x7aed1224,0xe8df01bc}},	//   _tódo, _राह_, dwat, _chịa_,
   {{0x32078035,0x7afb9225,0x7c241226,0x00000000}},	//   _inny_, lvut, tkir, --,
   {{0x5fc6035a,0x765c1227,0xc4830abe,0x7bcd0041}},	//   _वाटल, sory, елск, ggau,
   {{0x7c241228,0x6e461229,0x6fa20670,0x7aed122a}},	// [860] rkir, _неиз, _क्यू, gwat,
   {{0x7c240b0c,0x17570051,0x6440922b,0x2fdf8122}},	//   skir, _מספר_, zimi, _abug_,
   {{0x6440922c,0x2eff8359,0xae1b00be,0x7aed008e}},	//   yimi, _aruf_, _הויכ, awat,
   {{0x442b122d,0x4424001c,0x7aed0c2e,0x61e8922e}},	//   _glc_, _ôm_, bwat, zedl,
   {{0x61f507d9,0x6440922f,0x38669230,0xa2bd83dd}},	//   _fazl, vimi, rlor_, _शिष्,
   {{0xe29701a1,0x63a41231,0x442480ee,0x160386a7}},	//   _хар_, lbin, wkm_, लागर_,
   {{0xf8e00076,0x8fa69232,0x443d9233,0x61e89234}},	//   _नहिय, _наве, _bmw_, vedl,
   {{0x7afb01dd,0x60c89235,0x61e89236,0x329883a7}},	//   _šuti, vudm, wedl, овиќ_,
   {{0x63a41237,0x61f51238,0x6ab61239,0x06e40264}},	//   ibin, _yazl, nsyf, মিডি,
   {{0x27e003c3,0x80c0923a,0x3f808110,0xa2bd90be}},	//   _abin_, _विदे, žius_, _शिर्,
   {{0xdca3835f,0x64a38a1f,0x6608813c,0x859b8039}},	//   _захи, _заха, _indk, _השבו,
   {{0x7aed0063,0x35d28105,0x61e8923b,0x3207923c}},	//   ywat, _साड़, sedl, _enny_,
   {{0x7ae2803b,0xf77f0073,0x82fa853d,0x442b09c4}},	//   _upot, reço_, _دراز_, _rlc_,
   {{0x661a8364,0x4b7b81c6,0xa7fb123d,0xe3b08fd3}},	//   _jotk, _האדו, doñe, _سرچ_,
   {{0x7a2d840e,0x601f00f1,0x1c208105,0x61db82f6}},	//   _fútb, _sëmu, _बवाल_, _הקוד,
   {{0x63a4123e,0x7aed123f,0xd2510019,0x442b00e5}},	//   gbin, twat, ھنا_, _qlc_,
   {{0x3b541240,0xa3de8aed,0x7bcd1241,0x35d281ce}},	// [870] ектр, द्य_, rgau, _साढ़,
   {{0x24868013,0x91fc8029,0x661a807b,0x7c870012}},	//   _liom_, klām, _notk, _нуме,
   {{0x4fd59242,0x21270028,0xb33b0036,0x26cb1243}},	//   джет, ánh_, _reçu, luco_,
   {{0xa2bd9244,0x2eff80b9,0x35d303b7,0xa3de852a}},	//   _शिल्, _pruf_, _ताड़, द्म_,
   {{0xa7fb07f4,0xd6db9245,0x236681c0,0x26cb016a}},	//   coñe, сте_, _nyoj_, nuco_,
   {{0x2f238029,0x443d808e,0x992b1246,0x644d1247}},	//   _rīgā_, _smw_, _люба_, lnai,
   {{0x644d1248,0x3cf78035,0x80db8327,0xb33b03ed}},	//   onai, ंटें_, _बहें, _veçu,
   {{0x62870693,0x13b100ab,0xaca3819d,0x9f448037}},	//   _hijo, _ছাড়, _haịm, _lamù_,
   {{0x661a9249,0xb33b0214,0x2eff80b9,0x644d124a}},	//   _fotk, _geçt, _uruf_, inai,
   {{0x644d0083,0x7afb8074,0x26cb124b,0x2009124c}},	//   hnai, rvut, duco_, _anai_,
   {{0x7643924d,0xdb0b8019,0xd90f803d,0x63a4124e}},	//   miny, _megé, ایع_, ybin,
   {{0xa3ae8a3a,0x7643924f,0x59dd1250,0xeb0d1251}},	//   करण_, liny, न्तर, _सपूत_,
   {{0x629d01c5,0x7a201252,0xd0928201,0x09ac80ab}},	//   _ntso, _kött, _müəy, _খারা,
   {{0xfce600e8,0xdb2680d7,0x62871253,0x3e640061}},	//   мого, _توهی, _nijo, jött_,
   {{0x2101005c,0x91fc80eb,0x63a41254,0x7a201255}},	//   nčić_, klāj, tbin, _mött,
   {{0x27e002f7,0x628f1256,0x644d1257,0x601f0168}},	//   _ubin_, _buco, gnai, _dëms,
   {{0x76439258,0x4b7a8158,0x62871259,0xcb67125a}},	// [880] kiny, ַטעג, _bijo, дате_,
   {{0x644d125b,0x7643925c,0x62870b80,0x21010267}},	//   anai, jiny, _cijo, kčić_,
   {{0x7643925d,0x628707fc,0x2101011f,0x644d125e}},	//   diny, _dijo, jčić_, bnai,
   {{0xa7fb04c3,0x28c5925f,0x320984b9,0x3b0a0fdd}},	//   poñe, _विनि, _ɗaya_, _демо_,
   {{0x62870216,0x76438234,0x987b03de,0x628f018f}},	//   _fijo, finy, קאנט, _guco,
   {{0xd49a9260,0x59dd1261,0x62871262,0x9d450019}},	//   ори_, न्दर, _gijo, _آئین,
   {{0xf9831263,0x7a200338,0xa9670198,0x21671264}},	//   _агро, _dött, _жира_, _жири_,
   {{0xa8038098,0xb7fb801b,0x628702f9,0x00000000}},	//   _изсл, _एफएम_, _zijo, --,
   {{0x984600eb,0x7a20016d,0x76439265,0x998c8088}},	//   _dēļ_, _fött, biny, ridž_,
   {{0x7a201266,0x76439267,0x210100c3,0x20091268}},	//   _gött, ciny, bčić_, _snai_,
   {{0xa3c00576,0xa3ce016f,0x24868706,0x2d8c81a1}},	//   ीला_, रला_, _tiom_, _igde_,
   {{0x3e640065,0x699e800d,0x53468ada,0x2b40811f}},	//   zött_, _ख्री, _охла, _žicu_,
   {{0xa7741269,0x2ba480bc,0x63af0bda,0x4432126a}},	//   ключ, _ग्या, _recn, dhy_,
   {{0x68fc926b,0x26d90102,0xb8f480ab,0x764e126c}},	//   årds, rtso_, _হন_, gnby,
   {{0x236d026c,0x63af0669,0x628f126d,0x644d126e}},	//   _šej_, _pecn, _suco, tnai,
   {{0x7643926f,0x62871270,0x61f89271,0x20091272}},	//   ziny, _sijo, _havl, _unai_,
   {{0xf4841273,0x76439274,0x61f89275,0x0c840048}},	// [890] турн, yiny, _kavl, тырм,
   {{0x61f88025,0x644d1276,0x9c13819d,0x61fa9277}},	//   _javl, snai, _kọch, ndtl,
   {{0xa3ae8006,0x64dd9278,0x76438234,0x62871279}},	//   करा_, _महेश, viny, _vijo,
   {{0x4432127a,0x2c27035f,0x210102a5,0x628f01a1}},	//   chy_, _цьог, včić_, _tuco,
   {{0x4429127b,0x28c58bb8,0x7643927c,0xceeb803d}},	//   mka_, _विभि, tiny, تران_,
   {{0x4429127d,0xf7708416,0x321c816b,0x7876041c}},	//   lka_, جام_, _novy_, máve,
   {{0x764389ca,0x4429127e,0x7876127f,0x7a24823e}},	//   riny, oka_, láve, _gòti,
   {{0x44291280,0xa3d70d86,0x76439281,0x21010668}},	//   nka_, _साफ_, siny, rčić_,
   {{0x44291282,0xa3de8744,0x76439283,0x61f89284}},	//   ika_, द्ध_, piny, _bavl,
   {{0x80c08b6f,0xe9d99285,0x3eb9004a,0xa2c2064a}},	//   _विशे, чко_, dsst_, _लिस्,
   {{0x61f89286,0x68461287,0x44291288,0x186a1289}},	//   _davl, енна, kka_, зани_,
   {{0x44f18a8e,0xdb0601ac,0xb4fa81c6,0x7876128a}},	//   _iš_, _leká, _מפעי, káve,
   {{0xc2c88277,0x442f83a8,0xbbbd816f,0x93278f24}},	//   _قبول_, _ilg_, ोलीक, _تران,
   {{0x4429128b,0x7876128c,0x2d8c128d,0xf65200f7}},	//   eka_, dáve, øde_, ائح_,
   {{0xdb04128e,0x442902a3,0x7c29928f,0x1d071290}},	//   mbié, fka_, oker, нери_,
   {{0x44291291,0x1ddf816f,0x44f1816b,0x3c2e01d6}},	//   gka_, प्तत, _mš_, _býva_,
   {{0x7c29838e,0x28c5809a,0x290301b9,0x44f18bda}},	// [8a0] iker, _विडि, _arja_, _lš_,
   {{0x44291292,0xe1f70638,0x4a431293,0x7a2486c4}},	//   aka_, нгу_, гнув, _dòtw,
   {{0x442902c1,0x7c298d5b,0x4c861294,0x3ead9295}},	//   bka_, kker, _плов, _awet_,
   {{0x44291296,0x7c299297,0x6f041298,0x768b0035}},	//   cka_, jker, _kric, _użyc,
   {{0x68260510,0xdcfc0201,0x5fd18076,0xc8ec9299}},	//   _códi, marı, _हारल, _जन्म_,
   {{0xdcfc0b06,0x80db00ab,0xceb303c8,0x63b60079}},	//   ları, ণিজ্, ריג_, layn,
   {{0x3da5835f,0xa3d704e5,0x442f929a,0xdb1d0176}},	//   тріб, _साम_, _blg_, _adsè,
   {{0x6f040012,0x61f8929b,0x63b60079,0x7c29929c}},	//   _oric, _savl, nayn, gker,
   {{0x44f18267,0x53348087,0xa3ce01d0,0x661e129d}},	//   _eš_, тепт, _राई_, _oopk,
   {{0x4429129e,0x2d8c03f2,0x63b601b4,0xdb0f0580}},	//   zka_, ždej_, hayn, _decè,
   {{0x44290063,0xdcfc0214,0x6f04129f,0x403512a0}},	//   yka_, karı, _aric, венс,
   {{0x2fc080f7,0x7c2992a1,0x442912a2,0x63b601b4}},	//   óigh_, cker, xka_, jayn,
   {{0x61f892a3,0x6d480511,0x63b60079,0x44f1816b}},	//   _tavl, údan, dayn, _zš_,
   {{0x4429009a,0x6f04016d,0x787612a4,0xbe880198}},	//   wka_, _dric, váve, ессе_,
   {{0xf1b38051,0xcfb00264,0x2d8512a5,0xd12f804a}},	//   _עסק_, _কারন, äle_, _сх_,
   {{0x442912a6,0x6f0412a7,0xd6db1294,0x3ea004b7}},	//   uka_, _fric, _ето_, _ftit_,
   {{0x442912a8,0x78ba92a9,0xa3d7058c,0x06e880ab}},	// [8b0] rka_, lstv, _साठ_, পিডি,
   {{0x787612aa,0x51f80150,0x2296006a,0x7c298102}},	//   ráve, нную_, _dæk_, zker,
   {{0x78ba86d4,0xe8028076,0x7fd5902a,0x63b601b4}},	//   nstv, _रोहा_, вілі, bayn,
   {{0x644812ab,0x3ead809c,0x69d5009a,0x764706c0}},	//   édit, _pwet_, _wcze, lijy,
   {{0x141a098a,0xe8df001c,0xdb0b806a,0x799c0114}},	//   _חורב, _thỏa_, _udgø, _ffrw,
   {{0xf77400be,0xb5c285e9,0x628a92ac,0x442f802a}},	//   נקס_, айшл, _nifo, _slg_,
   {{0x7c2992ad,0xf402002e,0x442f92ae,0x9165003d}},	//   tker, _faţă_, _plg_, _شهره,
   {{0x130991d2,0x5fd891bc,0xd138809a,0x628a8915}},	//   дний_, _डायल, dzą_, _aifo,
   {{0x628a816d,0x56958081,0x3ed981a8,0x95d983a7}},	//   _bifo, _разт, _زواج_, _одат_,
   {{0x7c2992af,0xdcfc0059,0x32d986c0,0x6442811b}},	//   sker, zarı, rèy_, _emoi,
   {{0xa2bd885d,0x07a60554,0x442f92b0,0x2dd880f7}},	//   _शिक्, канн, _tlg_, _سبلة_,
   {{0x6f0412b1,0x63b602a3,0xdcfc0085,0x23c7826b}},	//   _pric, xayn, xarı, _dìjà_,
   {{0xe1ee92b2,0xfc46826f,0x539a82f6,0x628a8032}},	//   _кг_, ších_, _חינו, _fifo,
   {{0xceb2873a,0x63a992b3,0x2c4c801b,0x248b0144}},	//   שים_, lben, vědi_, _aicm_,
   {{0xdcfc1014,0xd1388035,0x78ba8dcc,0xa7fb016a}},	//   tarı, czą_, cstv, soña,
   {{0x2ae585e8,0x51848160,0x21888158,0x63a992b4}},	//   _कहाँ_, _суча, _אָפּ, nben,
   {{0xd4670572,0x787880a9,0x63b612b5,0x3b860048}},	// [8c0] тите_, níve, rayn, тлаг,
   {{0xa3d70d38,0x2296013c,0xdcfc0214,0x7d0892b6}},	//   _साथ_, _væk_, sarı, _jérô,
   {{0x63a992b7,0xd7fa92b8,0x28c904e5,0x64a612b9}},	//   kben, дул_, ांगि, _шана,
   {{0x63a9911b,0x26cf804f,0x63b60079,0xc95281c6}},	//   jben, fugo_, qayn, סמא_,
   {{0x63a98805,0x78ba826f,0x6378026b,0xfaa6111c}},	//   dben, zstv, _dúní, _јаго,
   {{0x71a30162,0x63a992ba,0x787881d0,0xaca40135}},	//   _варз, eben, díve, _nkịt,
   {{0x628a92bb,0xd94612bc,0xdb0f12bd,0x61fc12be}},	//   _rifo, _реви, _recé, _iarl,
   {{0x61fc12bf,0xdfd280f7,0x7a2d8019,0xab8692c0}},	//   _harl, _خير_, _búto, купк,
   {{0x61fc12c1,0xa3e4001b,0x26dd809a,0x97ea8085}},	//   _karl, प्य_, ctwo_, ışdı,
   {{0x682607a3,0x78ba90e8,0x61fe12c2,0x61fc12c3}},	//   _módu, tstv, ndpl, _jarl,
   {{0x3ea692c4,0xc4c592c5,0x1be212c6,0x02de02f1}},	//   lpot_, _متنو, खभाल_, नझुन,
   {{0xa3ce12c7,0x23ba92c8,0xa3d70fd5,0x6d5a8216}},	//   _राग_, _آداب_, _साध_, _ixta,
   {{0x6f0292c9,0xd138809a,0x682612ca,0x628a92cb}},	//   nvoc, szą_, _nódu, _tifo,
   {{0x78ba89cf,0x6f0292cc,0xa4d50d8e,0x67200338}},	//   pstv, ivoc, логі, ämja,
   {{0xfa778051,0xa3ce12cd,0x97320061,0x69c81238}},	//   _שעות_, _राख_, لکیا, _ödey,
   {{0x7876026f,0x3c31816b,0x54540425,0xc61f92ce}},	//   rávc, _káva_, авст, _भव्य_,
   {{0x2d9e8e1c,0x61fc12cf,0x337500c4,0x06d78264}},	// [8d0] _ofte_, _barl, угар, _দৈনি,
   {{0x35f5098d,0x61fc12d0,0x63a99123,0x394b003d}},	//   _спор, _carl, zben, وشاپ_,
   {{0x61fc12d1,0xdb0b80ab,0x787603b0,0x27ef83ba}},	//   _darl, _regí, láva, tegn_,
   {{0xdb0b8065,0xdb0612d2,0x61fc0039,0x28c586ae}},	//   _segí, _bekä, _earl, _विसि,
   {{0x6d5a8201,0x787612d3,0x7c2d12d4,0x78788187}},	//   _axta, náva, mkar, xíve,
   {{0xd77480f7,0x26cf92d5,0x78788187,0x7bc292d6}},	//   جامع, rugo_, víve, _adou,
   {{0xeb9992d7,0xd46992d8,0x7e6392d9,0x26dd8035}},	//   ний_, нике_, ronp, stwo_,
   {{0x200d8012,0x7876037d,0x787892da,0xdb0b8187}},	//   _unei_, káva, tíve, _negã,
   {{0xc7b28039,0x7c2d12db,0x05d3025a,0x9d238264}},	//   _לבן_, ikar, _तांब, বছেন_,
   {{0x78760a56,0x96f892dc,0x63a992dd,0x386912de}},	//   dáva, _جعفر_, sben, _akar_,
   {{0x7c2d12df,0x2ba492e0,0x78788187,0x9f4e001b}},	//   kkar, _ग्वा, síve, čním_,
   {{0x1ddf836d,0xddd5001b,0x2c098035,0xdb0a016b}},	//   प्रत, mozř, वाओं_, šnéh,
   {{0x91e592e1,0x28c58bbc,0x09e58abe,0x442d92e2}},	//   _боле, _विवि, _болн, mke_,
   {{0x442d92e3,0xdd920f99,0x386912e4,0xaf7683de}},	//   lke_, صور_, _ekar_, טערס_,
   {{0x442d92e5,0x7c3612e6,0x6e218668,0x09b200ab}},	//   oke_, thyr, _molb, _চালা,
   {{0x442d92e7,0x7c2d12e8,0x044312e9,0x8c4312ea}},	//   nke_, gkar, бесн, бесе,
   {{0x442d92eb,0x9b9300f7,0x248012ec,0x7c3612ed}},	// [8e0] ike_, إلكت, rmim_, rhyr,
   {{0xf1a903f8,0xe9d70003,0x05d292ee,0x3b8312ef}},	//   نامه_, лку_, _साइब, слуг,
   {{0x442d92f0,0x3ebf8012,0x61fe12f1,0x19b680be}},	//   kke_, _avut_, rdpl, רפער_,
   {{0x442d92f2,0x7c2d12f3,0x6aad81cd,0x61fc12f4}},	//   jke_, ckar, _ħafn, _warl,
   {{0x6e2192f5,0x61fc12f6,0xc7d70039,0x442d92f7}},	//   _bolb, _tarl, רוני_, dke_,
   {{0x442d8b3c,0x6e2192f8,0xccfa84ae,0x442212f9}},	//   eke_, _colb, ећи_, _hok_,
   {{0x6aa292fa,0x442212fb,0xf8c5825e,0x442d84b9}},	//   _stof, _kok_, _विषय, fke_,
   {{0x442212fc,0x25f0809a,0x7bd612fd,0x442d92fe}},	//   _jok_, _इसकी_, ngyu, gke_,
   {{0xa6ca89d7,0x628e12ff,0x5a349300,0xa3d70592}},	//   _سوال_, _kibo, инит, _सास_,
   {{0xa3e40e70,0xa2d501fe,0x2ba480d4,0xd6cf8f99}},	//   प्त_, यंत्, _ग्रा, _رقم_,
   {{0x8d939301,0x44221302,0x2907803b,0xf5938013}},	//   _المش, _ook_, _crna_, _المج,
   {{0x628e1303,0x764a9304,0x4422005f,0x557780be}},	//   _libo, lify, _nok_, _געבן_,
   {{0xa3ce09a3,0x09cc00c8,0x80c09305,0xe80b8beb}},	//   _राज_, র্যা, _विके, _सोफा_,
   {{0xe80b800f,0x7c229306,0x78761307,0x386681b0}},	//   _सोना_, _hoor, ráva, hoor_,
   {{0x16d19308,0x44221309,0x7c2d130a,0x7876130b}},	//   _सम्ब, _bok_, tkar, sáva,
   {{0x09cc00c8,0x44220214,0x26de0087,0x628e130c}},	//   র্মা, _cok_, ător_, _aibo,
   {{0x44220025,0x7c22930d,0x628e130e,0x5b15130f}},	// [8f0] _dok_, _moor, _bibo, шмат,
   {{0x7c2d00ad,0x442d9310,0x628e1311,0x7c229312}},	//   skar, zke_, _cibo, _loor,
   {{0x645a1313,0x44221314,0x764a9315,0x442d8be7}},	//   étic, _fok_, dify, yke_,
   {{0x7c229316,0xe8d784de,0x6e218f06,0x72d51317}},	//   _noor, רואר_, _solb, _комф,
   {{0x6e219318,0x44c101e2,0x64499319,0x27e9131a}},	//   _polb, lė_, viei, _mban_,
   {{0x09cc0a49,0x80aa8a49,0x7d0882a5,0xa1940071}},	//   র্বা, _কিন্, _brds, _гарч,
   {{0x44c101e2,0x442d931b,0x4422131c,0xa3dc131d}},	//   nė_, tke_, _yok_, _ठाम_,
   {{0x0c258aac,0x63ad131e,0x442d931f,0x6a6b0192}},	//   рмин, nban, uke_, rüfu,
   {{0x2907812b,0x78a49320,0x63ad1321,0x7c229322}},	//   _srna_, _čiva, iban, _door,
   {{0x442d9323,0x44c101e2,0x4a459324,0x27e91325}},	//   ske_, kė_, рнов, _aban_,
   {{0x69dd090a,0x7c2289f8,0xc32380c8,0x8e848013}},	//   _पानी, _foor, _বেশি_, _الله,
   {{0x7bc78110,0xdb0f03a7,0xd71c80ab,0x44c10110}},	//   ėjus, _mecâ, _দেয়া_, dė_,
   {{0x92b78013,0xf77208ca,0x290780dd,0x93948a47}},	//   _إحصا, تاد_, _wrna_, _اجما,
   {{0x44221326,0x63bb9327,0xbb3a8496,0x63ad1328}},	//   _sok_, laun, _בעני, eban,
   {{0x628e1329,0x6142932a,0xdb0f05e4,0x89da8039}},	//   _ribo, _меша, _decí, _יחסי,
   {{0x63ad132b,0x63bb932c,0x6f09932d,0x628e132e}},	//   gban, naun, _orec, _sibo,
   {{0xe9da0a08,0x386680f3,0x6d41046d,0xeb97002e}},	// [900] кка_, voor_, úlar, риу_,
   {{0x63ad132f,0x63bb8bb1,0x7af60114,0x787881d0}},	//   aban, haun, rwyt, díva,
   {{0xe0da1330,0xf1dd83eb,0x41dd8eb4,0xeaf28592}},	//   тве_, _मानन, _मानस, _अन्त_,
   {{0x35dc0665,0x6f099331,0xa3e7800d,0xdb0f002e}},	//   _बाड़, _brec, म्म_, _decâ,
   {{0x6f09840e,0x27ff8590,0xe7e8035a,0x764a9332}},	//   _crec, _daun_, ट्या_, tify,
   {{0x69dd0076,0x7c229333,0x6f099334,0x7d008019}},	//   _पायी, _soor, _drec, járá,
   {{0x01bb8a49,0x764a9335,0x7c229336,0x38669337}},	//   ংলাদ, rify, _poor, poor_,
   {{0x64561338,0x6f099339,0x27ff8763,0x69d8816f}},	//   nnyi, _frec, _gaun_, _माही,
   {{0x7c22933a,0xd37780d6,0x27e902f7,0xadba81a8}},	//   _voor, ичь_, _rban_, _لهذا_,
   {{0x7c2290f4,0x20120870,0x27e6933b,0x5a34933c}},	//   _woor, _anyi_, lfon_, снот,
   {{0xa3d703a4,0x78760a56,0x63ad133d,0xdca38088}},	//   _साल_, rávn, yban, _дахи,
   {{0x44c10110,0x3e7b8036,0x78a10061,0x63ad133e}},	//   vė_, rête_, _élve, xban,
   {{0x63a2933f,0xdb0f0118,0x200501d0,0xdb060032}},	//   _ifon, _pecí, ěli_, _eekú,
   {{0x20050063,0x20121340,0x44c101e2,0xa3e41053}},	//   śli_, _enyi_, tė_, प्स_,
   {{0x9c470791,0x3a7b83de,0x00000000,0x00000000}},	//   ахал, _שטוד, --, --,
   {{0x8f471317,0x27e91341,0x7055003d,0x1dd30105}},	//   _вход, _uban_, _دنبا, _ताकत,
   {{0x290a01e2,0x63ad1342,0xaa7b00e1,0xfb870e49}},	// [910] _arba_, rban, _opýt, рывн,
   {{0xe7e80063,0x39a71343,0x44c10110,0x63bb84b9}},	//   ट्ठा_, ршав, pė_, zaun,
   {{0x26141344,0x6f09803b,0x27ff8abf,0x63ad1345}},	//   दारी_, _srec, _paun_, pban,
   {{0xdd1c01d0,0x765a8168,0xe3b81346,0x785201a9}},	//   _nářa, _ajty, _ключ_, tāvi,
   {{0xe5a5917e,0x290a1347,0xd6db82dc,0x8c1a0039}},	//   били, _erba_, тте_, _עושי,
   {{0x644d1348,0x63a29349,0x14b8019f,0x6f0980e1}},	//   liai, _afon, _حدیث_, _vrec,
   {{0x27ff83f8,0x6f098114,0x44f88028,0x63bb934a}},	//   _taun_, _wrec, _cũ_, taun,
   {{0x6f098012,0x644d134b,0xed580039,0x62850706}},	//   _trec, niai, יבור_, lmho,
   {{0x869887eb,0x63bb934c,0x386d934d,0x6f098087}},	//   _вкус_, raun, _iker_, _urec,
   {{0x6ce7835f,0x629b82be,0xe4e7835f,0xe8f9934e}},	//   _віде, rquo, _відн, гло_,
   {{0xa3d71344,0x92d780c8,0x261989f2,0x9f5e000d}},	//   सला_, াবে_, पाठी_, ětí_,
   {{0x6601934f,0x44e19350,0x9b9580f7,0xaac704c5}},	//   _halk, mó_, _الإت, _लिंक,
   {{0x69c71351,0xbb858013,0x64561352,0x44e19353}},	//   _odje, _الشي, vnyi, ló_,
   {{0x69c7020f,0x6da31354,0x66018009,0x7bdd0118}},	//   _ndje, зира, _jalk, _acsu,
   {{0x44e19355,0x64a602df,0x2d8c0106,0x2ba6801b}},	//   nó_, саба, äde_, síců_,
   {{0x7c3b9356,0x69dc1357,0x644d1358,0x62999359}},	//   nhur, _scre, giai, _kuwo,
   {{0x290a003b,0xa3df8105,0x63b98114,0xd3b90a8e}},	// [920] _srba_, _तान_, _mewn, русі_,
   {{0xbf9b0073,0x26c2135a,0xa3e786ab,0xdb0f0980}},	//   ndên, msko_, म्त_, _decà,
   {{0x44e1935b,0x31ba8158,0x93f9816f,0x787d0019}},	//   jó_, רזענ, ्याच_, séve,
   {{0x387f8af9,0x44e1935c,0xe73a8364,0x644d135d}},	//   _chur_, dó_, лее_, ciai,
   {{0x26c20ed6,0x4432003e,0x7c3b935e,0x2f18935f}},	//   nsko_, mky_, dhur, роль_,
   {{0x443203cb,0x63a29360,0x40961361,0xceb303c8}},	//   lky_, _sfon, _грат, ליד_,
   {{0x660182c1,0x44e19362,0x1619000f,0xdc1180ab}},	//   _dalk, gó_, दातर_, িউনস_,
   {{0x44321363,0x44f88028,0x62999364,0x69c71365}},	//   nky_, _vũ_, _buwo, _zdje,
   {{0x8c1b004c,0x26c2135a,0x66019366,0x32669367}},	//   רופי, jsko_, _falk, йтов,
   {{0x41dd835a,0x8afb00be,0x660181b4,0x11d880f7}},	//   _माणस, נהיי, _galk, جودة_,
   {{0x04968013,0x44e185a4,0xdb0f02ba,0xdfd11368}},	//   _الصح, có_, _mecá, ويد_,
   {{0x4432026f,0xdb0b816d,0x44201369,0x6e250214}},	//   jky_, _begä, jji_, _sohb,
   {{0x44320a56,0x4420136a,0x447b8158,0x7c6580f7}},	//   dky_, dji_, _ענדע, _بالل,
   {{0x7ae4136b,0x4420136c,0x63b9809a,0x66018df6}},	//   dtit, eji_, _zewn, _xalk,
   {{0x90a6936d,0x644d136e,0x4432136f,0x59dd9370}},	//   _احتم, tiai, fky_, _मातर,
   {{0x442000f1,0xb4e90770,0x7c2606cb,0x44269371}},	//   gji_, _यही_, _cokr, _joo_,
   {{0x644d1372,0x2fc9108c,0x442681c5,0x44e18065}},	// [930] riai, _idag_, _moo_, zó_,
   {{0x442682c1,0x442000f6,0x386d832b,0x644d1373}},	//   _loo_, aji_, _sker_, siai,
   {{0x4432003e,0xda781374,0x6f0d026f,0x7d081375}},	//   bky_, сят_, _hrac, ådst,
   {{0x44200d38,0x44321376,0x6f0d1377,0x44e19378}},	//   cji_, cky_, _krac, vó_,
   {{0x443903d3,0x660188e5,0x9f0580f7,0xe610804e}},	//   _ils_, _palk, توشو, کشن_,
   {{0x44e18117,0xd1268154,0x4ac28072,0x2ba501d0}},	//   tó_, _قم_, _शिजव, गुरा,
   {{0x63b98063,0xe3b18013,0xfe708077,0x66019379}},	//   _pewn, ورة_, رده_, _valk,
   {{0x44e1937a,0x5ac9937b,0x386d80e8,0x6601937c}},	//   ró_, алим_, _uker_, _walk,
   {{0x44e1937d,0xe816816f,0xb4d601ce,0x27ed89bf}},	//   só_, णारा_, _सम्_, _iben_,
   {{0x7c3b937e,0x4432003e,0x4420137f,0x2fc91380}},	//   shur, zky_, zji_, _adag_,
   {{0x3ea9002e,0x9d559381,0x6f0d1382,0x261d015c}},	//   _atat_, _بنات, _arac, मानी_,
   {{0x186a1383,0xa4140264,0x44c581a9,0x69da9384}},	//   рами_, _সত্য_, mē_, agte,
   {{0x44321385,0x28c5825e,0x44c580eb,0x44201386}},	//   vky_, _विकि, lē_, vji_,
   {{0x44391387,0x7ae41388,0x5bb206a7,0x64a380c3}},	//   _als_, vtit, जर्व, _gđic,
   {{0x44321389,0x4426877f,0x27ed8352,0x8c0100c8}},	//   tky_, _yoo_, _oben_, _একজন_,
   {{0xd5dc023c,0x6a7002af,0x5baa07a1,0x7bdb938a}},	//   _बावज, häft, ркам_, nguu,
   {{0x4420138b,0x4432003e,0x4226138c,0x3b0700b3}},	// [940] rji_, rky_, одав, оето_,
   {{0x4439138d,0x44320a56,0x4420009a,0x6aa480f7}},	//   _els_, sky_, sji_, _éife,
   {{0x7ae4138e,0x10a6138f,0x4432003e,0x644b8370}},	//   stit, циен, pky_, _omgi,
   {{0xa2a2000f,0x7876026f,0x23e10935,0x7ae41390}},	//   _कंप्, dávk, _फायद, ptit,
   {{0x69da806a,0xa25b00e1,0xdb0f0144,0xaac7001b}},	//   ygte, _kvôl, _tecá, _लिएक,
   {{0x2d4e011b,0x44268962,0xa3e79391,0x27ed9392}},	//   _eнee_, _soo_, म्स_, _eben_,
   {{0xd4979006,0x44269393,0x672f009a,0xd5b98a4c}},	//   оры_, _poo_, zycj, ссі_,
   {{0x3cfe8267,0x7a2d9394,0x442682f7,0x68e3023e}},	//   _vstv_, _mútu, _qoo_, ànde,
   {{0x63a41395,0x44269396,0x69da1238,0x6a748580}},	//   icin, _voo_, _ötes, làfi,
   {{0x81d280c8,0x27e000fc,0x2004865f,0x26c08196}},	//   হ্ন_, _acin_, _hami_, šios_,
   {{0x20049397,0x63a41398,0x4a7b0158,0xc27b00be}},	//   _kami_, kcin, שריב, שריי,
   {{0x6f0d1399,0x200480a4,0x63a400d2,0x6e28826c}},	//   _prac, _jami_, jcin, _hodb,
   {{0x61ee139a,0x7bc0939b,0x78ad939c,0xa3e3864a}},	//   _obbl, mamu, _čave, _पॉट_,
   {{0x63a400eb,0x2004939d,0xdef801e2,0xddda8061}},	//   ecin, _lami_, цыю_, _kitű,
   {{0xdd940196,0x63a4026c,0x6594139e,0x6f0d139f}},	//   дары, fcin, дару, _wrac,
   {{0x320d017b,0x6f0d13a0,0x200493a1,0x7bc093a2}},	//   _şey_, _trac, _nami_, namu,
   {{0x6f0d13a3,0x44c581a9,0x97ea81cc,0x2aa08242}},	// [950] _urac, zē_, ışlı, _jòb_,
   {{0x7bc093a4,0x20048091,0x290e81a1,0xdb198176}},	//   hamu, _aami_, _krfa_, _dewè,
   {{0x31c40987,0x7bc093a5,0x26d913a6,0x200493a7}},	//   ьств, kamu, luso_, _bami_,
   {{0xdb1f0168,0xae190035,0x7bc093a8,0x200493a9}},	//   naqë, दावन_, jamu, _cami_,
   {{0xdefb8364,0x7bc093aa,0x81e700c8,0x63bd0029}},	//   рые_, damu, _মোঃ_, _iesn,
   {{0x46d30076,0xafdb00e8,0x386681a1,0xdcef8b80}},	//   _तिनह, rnøy, čora_, šečl,
   {{0x660513ab,0x20048970,0x19580190,0x6a7013ac}},	//   _mahk, _fami_, _дары_, räft,
   {{0x660513ad,0x629d13ae,0x443993af,0x69ca93b0}},	//   _lahk, _kuso, ós_, _adfe,
   {{0xf7498013,0x768b0063,0x6e28813c,0x629d13b1}},	//   _الذي_, _używ, _fodb, _juso,
   {{0x2bab8eed,0x629d13b2,0x36378077,0x63bd13b3}},	//   _ट्रा, _muso, _بررس, _lesn,
   {{0x216993b4,0x629d13b5,0x60c50168,0x7bc093b6}},	//   сини_, _luso, nshm, bamu,
   {{0xa3d71278,0x2489026c,0x26d90568,0x7bc093b7}},	//   _साग_, jmam_, fuso_, camu,
   {{0x660513b8,0x20040038,0xdb0b8019,0x7876016b}},	//   _bahk, ľmi_, _legú, návi,
   {{0x443f84b9,0x8b058063,0x629513b9,0x3d0813ba}},	//   lhu_, _częś, _nizo, हिले_,
   {{0x69c193bb,0xe3bf0e1b,0x60c500f1,0xc6928039}},	//   male, _coño_, jshm, תאם_,
   {{0x69c1805d,0x629d13bc,0xaac7009a,0x4ac70d86}},	//   lale, _buso, _लिखक, _लिखव,
   {{0x63a413bd,0xe36313be,0x6b6313bf,0x62950019}},	// [960] rcin, екти, екта, _bizo,
   {{0x69c193c0,0x629504b9,0x7bc080b4,0x63a413c1}},	//   nale, _cizo, zamu, scin,
   {{0x6d438024,0x443f829b,0x200486c0,0x7bcb80d2}},	//   jzna, khu_, _pami_, _odgu,
   {{0x38a18013,0xfc3200f7,0xdb0400f3,0x7bc08079}},	//   _mór_, _أحد_, ncië, xamu,
   {{0xfbd30051,0x69c193c2,0x7bc08006,0x629d02a0}},	//   _אתר_, kale, vamu, _guso,
   {{0xe8df0028,0x69c193c3,0x20048234,0x629513c4}},	//   _giữa_, jale, _wami_, _gizo,
   {{0x69c193c5,0x7bc093c6,0x2ee693c7,0xb5098072}},	//   dale, tamu, stof_, विषय_,
   {{0x7c2413c8,0x629d03ac,0xb0d1016f,0xf8c5824c}},	//   njir, _yuso, _हितग, _विजय,
   {{0x7bc093c9,0x69c193ca,0xdb060061,0x2a6c8163}},	//   ramu, fale, _nekü, todb_,
   {{0x69c193cb,0x7bc093cc,0x7f3b8039,0x62838219}},	//   gale, samu, _העמו, _chno,
   {{0x7bc08ce9,0x443f81f6,0x649581a1,0xf1dd8ad5}},	//   pamu, bhu_, _išin, _मारन,
   {{0xc48693cd,0x3157098a,0x660513ce,0x7d7b80be}},	//   _элек, ליין_, _sahk, _פראג,
   {{0x63bd13cf,0xe3bf01df,0xee870198,0x47340c6e}},	//   _resn, _soño_, зыво, еняс,
   {{0x69c193d0,0x38a18125,0xe3bf002a,0xd2508fd3}},	//   cale, _fór_, _poño_, _جنت_,
   {{0x776401df,0xa15793d1,0x26d913d2,0x7876026f}},	//   _exix, _нашу_, suso_, závi,
   {{0x26d913d3,0x31c6801b,0x629d13d4,0xab5d809a}},	//   puso_, bízí_, _puso, saże,
   {{0xdb0b8c15,0xdb0400e7,0x248913d5,0x60da80dd}},	// [970] _segú, nciè, rmam_, lutm,
   {{0x60c500f1,0x4ad493ba,0x61fa93d6,0xddc381ac}},	//   tshm, _दिनव, netl, konš,
   {{0x6ca413d7,0x63bd024a,0x787d0036,0x7c380333}},	//   _пряж, _tesn, névo, ñará,
   {{0x69c193d8,0x60c500f1,0x629d0365,0xf770803d}},	//   zale, rshm, _tuso, گام_,
   {{0x261993d9,0x61fa93da,0xe80e10c8,0x69c193db}},	//   पाली_, ketl, ियता_, yale,
   {{0xf7708bbe,0x61fa82fd,0x442b13dc,0x7876016b}},	//   دام_, jetl, _hoc_, rávi,
   {{0x443f93dd,0xc2120039,0x26c681b4,0x60c513de}},	//   thu_, _בהם_, asoo_, qshm,
   {{0xc9520051,0x442b13df,0x7bdf13e0,0xdb1d0168}},	//   _סמן_, _joc_, ngqu, _nesë,
   {{0xe82101fe,0x69c193e1,0x442b13e2,0xa3e505fc}},	//   याना_, tale, _moc_, _नान_,
   {{0x442b0012,0x443f93e3,0x38a193e4,0xa3df93e5}},	//   _loc_, shu_, _pór_, _ताव_,
   {{0x443f93e6,0xa2cf8c2d,0xda1f8072,0x3de30264}},	//   phu_, _दिव्, बाबत_, য়াল,
   {{0x69c193e7,0xcdc90051,0x442b1122,0x64408920}},	//   sale, _כך_, _noc_, chmi,
   {{0xa3d70e5b,0xdb060247,0xdb0401ed,0x09d500ab}},	//   _साज_, _lekò, rcië, স্যা,
   {{0x69c18234,0xf1ba00ff,0x7ae993e8,0x291113e9}},	//   qale, ươi_, mtet, _orza_,
   {{0x6a7d809f,0x443d815d,0x1d070c24,0x442b13ea}},	//   lèfo, _klw_, мери_, _boc_,
   {{0x998381e2,0x26c40019,0x6e21008b,0xdb1d13eb}},	//   ųjų_, ámos_, ölbr, _kesè,
   {{0x7ae993ec,0x7c2b8122,0x290313ed,0xfaff00eb}},	// [980] ntet, _mogr, _asja_, šīnu_,
   {{0x7c2b840e,0x291113ee,0x7ae993ef,0x6f040234}},	//   _logr, _brza_, itet, _isic,
   {{0x361b0158,0x442b13f0,0xeb9a13f1,0x26c90052}},	//   _וויד, _foc_, _мин_, _zvao_,
   {{0xdfcf8013,0x3ea013f2,0x61fa93f3,0x9f5906c0}},	//   ليم_, _kuit_, zetl, fesè_,
   {{0x61fa93f4,0xbefa826a,0x7ae98019,0x41dd83dd}},	//   yetl, تراض_, jtet, _मांस,
   {{0x768b0d38,0x28db03eb,0x2d9a80e8,0x6f04004f}},	//   _użyt, मूहि, øpe_, _msic,
   {{0xa3e513f5,0x61fa93f6,0x5e570158,0xe821000d}},	//   _नाम_, vetl, ויסע_, यामा_,
   {{0x7bc41149,0x09c6816f,0x442b023e,0xdb1d010c}},	//   naiu, लण्य, _xoc_, _besè,
   {{0xae1e83dd,0xa3df8999,0x68e100f2,0x3ea002be}},	//   पादन_, _तार_, _äldr, _nuit_,
   {{0x64408168,0xa68393f7,0x2fc00580,0xdb1d13f8}},	//   shmi, _алуд, _aeig_, _desè,
   {{0x61fa93f9,0xae220d86,0x6f0413fa,0x443d82df}},	//   retl, मानन_, _asic, _flw_,
   {{0x68e100f2,0x61fa93fb,0xf9930039,0x3ea013fc}},	//   _ålde, setl, כרת_, _buit_,
   {{0x5b36845b,0x69ce01ac,0x320790e4,0x27e480b9}},	//   _تعار, _odbe, _fany_, _mcmn_,
   {{0x3ea013fd,0x6b8293fe,0x32078176,0x683a8580}},	//   _duit_, _izog, _gany_, _oïdo,
   {{0xd3088104,0x2bd00006,0x442b009f,0x24868282}},	//   _hệ_, तृभा, _poc_, _khom_,
   {{0x7a3f80e7,0x3ea013ff,0x69ce1400,0xdb0606c0}},	//   _vête, _fuit_, _adbe, _rekò,
   {{0x52151401,0x661a8cfa,0x7d1c81fa,0x62989402}},	// [990] ндат, _ontk, _ársf, _kivo,
   {{0x7a3f8036,0x20090cda,0x24868609,0xdb060176}},	//   _tête, _haai_, _lhom_, _pekò,
   {{0x7ae99403,0xd308801c,0xa3df8f97,0xdb1d0061}},	//   ztet, _lệ_, _ताल_, _mesé,
   {{0xa2cf9404,0x7ae99405,0xec350158,0x6448009f}},	//   _दिल्, ytet, _נאָר_, èdit,
   {{0x66089406,0x2ee900b9,0x6b828a03,0x20091407}},	//   _badk, _jqaf_, _nzog, _maai_,
   {{0x62989408,0xa3cd064a,0x7c2b9409,0x2009067f}},	//   _nivo, रणव_, _sogr, _laai_,
   {{0x660882c1,0x6d4704b7,0xdfd58009,0x69c5140a}},	//   _dadk, nzja, _повы, mahe,
   {{0x9b05940b,0xcd980bea,0x2486940c,0x58878e11}},	//   езид, ודות_, _chom_, _цыга,
   {{0xed5881ac,0xfe0f140d,0x6298940e,0x443d8187}},	//   _veľa_, ायास_, _bivo, _vlw_,
   {{0x7ae9940f,0x66089410,0x69c51411,0x3ea01412}},	//   rtet, _gadk, nahe, _ruit_,
   {{0x7ae99413,0x09d500c8,0x61e10125,0x29119414}},	//   stet, স্থা, _öllu, íza_,
   {{0x7a320125,0x7878826f,0x2360816b,0x764380dd}},	//   _hætt, tívi, _žije_, lhny,
   {{0x69c513fa,0x200901b0,0x76551415,0x64859416}},	//   kahe, _daai_, fizy, róid,
   {{0xceb29417,0x09d50a49,0xfc3f062f,0x63a99418}},	//   רים_, স্তা, _alí_, lcen,
   {{0x75f38059,0xa8060457,0x7a32007b,0x69c51419}},	//   mızı, _alış, _mætt, dahe,
   {{0x3ea00998,0x98a701d0,0x2af382f1,0x52aa0081}},	//   _tuit_, šně_, _अहाँ_, звам_,
   {{0x9696141a,0x1e96018b,0xfd658028,0xfc3f00f7}},	// [9a0] _прош, _прор, _chuẩ, _dlí_,
   {{0x75f38457,0xa3dc141b,0xd94611f3,0x69c5141c}},	//   nızı, _ठाक_, нези, gahe,
   {{0xa3df941d,0x78ab802e,0x261d00c2,0xba3b023e}},	//   तला_, _învă, मारी_, _suïc,
   {{0xe29a141e,0x41e2016f,0x63a9941f,0xa0679420}},	//   _нам_, _पावस, jcen, наха_,
   {{0xe7379421,0x64561422,0x69c51423,0x2ca1026c}},	//   нец_, miyi, bahe, _zuhd_,
   {{0x64561424,0x69c5008e,0x20e0016f,0x63a99425}},	//   liyi, cahe, खंदळ_, ecen,
   {{0x62989426,0x24868069,0xdb1d1427,0x649581f4}},	//   _rivo, _phom_, _resé, _išij,
   {{0xdb0f0118,0x7643836e,0x64561428,0x04638a41}},	//   _recú, ahny, niyi, лтым,
   {{0xeaaf803d,0x81e700ab,0xa01b007b,0x6d4701b9}},	//   یعی_, _মোট_, llög, zzja,
   {{0xd3088028,0xc3330039,0x63a99429,0x20091384}},	//   _vệ_, טוח_, acen, _saai_,
   {{0xa3e881b6,0x7655142a,0xab5d809a,0x63a9942b}},	//   _बाप_, vizy, raża, bcen,
   {{0x236690af,0xfaa6942c,0x80d3142d,0x9cd782f6}},	//   _txoj_, _задо, _डिसे, _טובה_,
   {{0x644402a3,0x64560201,0xe667142e,0x61fe004a}},	//   dhii, diyi, етво, kepl,
   {{0x61fe142f,0x320a01b0,0x614680e7,0x2009067f}},	//   jepl, _naby_, _célé, _waai_,
   {{0xe821101b,0x5fd0816f,0x69c50006,0x61fe1430}},	//   यादा_, हणाल, vahe, depl,
   {{0x60de09ca,0x9f520e1b,0x765506c0,0x64440162}},	//   dupm, _cayó_, sizy, ghii,
   {{0xc2991431,0x69c50a74,0x3a7507b6,0x2fc68bb1}},	// [9b0] дках_, tahe, влар, daog_,
   {{0xddc71432,0x6467026f,0xbbeb003d,0x61fe1433}},	//   bojš, _špič, _کردم_, gepl,
   {{0x7a321434,0xe61f801c,0x659504bd,0x64561435}},	//   _rætt, _đô_, _јану, biyi,
   {{0x7a32065d,0x44cc800d,0x69c51436,0xd75984a3}},	//   _sætt, dě_, sahe, ولات_,
   {{0xd90f0117,0x320a1437,0x764380dd,0x61fe1438}},	//   _گیا_, _faby_, thny, bepl,
   {{0xee389439,0x7aed0019,0x20098110,0x657a943a}},	//   нні_, mtat, žai_, _byth,
   {{0x25e909f2,0xd90f0117,0x44290110,0x78ad8115}},	//   _जानी_, _دیا_, oja_, _čavo,
   {{0xeb99943b,0x764382f7,0x7aed00e5,0x6d58143c}},	//   мий_, shny, otat, _žvak,
   {{0xc864943d,0xe7db143e,0x248d943f,0x7a320366}},	//   _стри, _भाजप, rmem_, _tætt,
   {{0x44291440,0x63a99441,0x7aed1442,0x6aa281e0}},	//   hja_, scen, itat, _duof,
   {{0x44291443,0xa06a1444,0x7aed0168,0x186a1445}},	//   kja_, дана_, htat, дани_,
   {{0x44291446,0x2d8587d9,0x7c2f09c4,0x7bc29447}},	//   jja_, _izle_, _nocr, _geou,
   {{0xe28e9448,0x44291449,0x7c29944a,0xf092893f}},	//   _ва_, dja_, mjer, ינט_,
   {{0xc0a883f8,0xda110076,0x7c2984fe,0x7c3b944b}},	//   بایل_, _डोलत_, ljer, lkur,
   {{0x442f8bda,0x1fb6144c,0x7aed144d,0x4429144e}},	//   _kog_, _испр, etat, fja_,
   {{0x4429144f,0x442f9450,0x69c39451,0xe8df00ff}},	//   gja_, _jog_, _hene, _nhựa_,
   {{0x614683d3,0x442f822c,0x7aed02b8,0xe29a02df}},	// [9c0] _télé, _mog_, gtat, даа_,
   {{0x69c39452,0x644402a3,0x44291453,0x4a431454}},	//   _jene, shii, aja_, анув,
   {{0x44291455,0x7c3b9456,0x442f837a,0x2dd900be}},	//   bja_, kkur, _oog_, _אַרב,
   {{0x44290d38,0x44cc800d,0x442f9457,0xdefa8048}},	//   cja_, vě_, _nog_, дык_,
   {{0x7aed1458,0xb8659459,0xab5d809a,0x3aeb804a}},	//   ctat, دالو, ważn, jøp_,
   {{0x09cc00c8,0x649580d2,0x44cc801b,0x98a70087}},	//   র্জা, _ušij, tě_, ână_,
   {{0x77698118,0xe976003d,0xa2bf8035,0x4096945a}},	//   _exex, _شهرد, लीस्, _арат,
   {{0x442f81c5,0xdb0b8073,0x629c145b,0x7c29945c}},	//   _cog_, _negó, _hiro, gjer,
   {{0x629c145d,0xbea68098,0x657a831d,0x3f848289}},	//   _kiro, _разк, _wyth, _uzmu_,
   {{0x69c3945e,0x629c145f,0x44291460,0x656902d0}},	//   _cene, _jiro, zja_, şehi,
   {{0x69c39461,0x7aed1462,0x44291463,0x442f9464}},	//   _dene, ztat, yja_, _fog_,
   {{0x320a8775,0x76588010,0xc1730039,0xe53780be}},	//   žby_, livy, יחת_, _שטאט_,
   {{0x44291465,0x69c39466,0xada2807b,0x2fc480b9}},	//   vja_, _fene, _þúsu, _memg_,
   {{0x442f81e9,0x7c2f1467,0x629c1468,0x6f161469}},	//   _zog_, _socr, _niro, _dryc,
   {{0x442f946a,0x69c8946b,0xd49b146c,0x16df8bb8}},	//   _yog_, made, дра_, _नम्ब,
   {{0x030e146d,0x7aed146e,0x3d08035a,0x629c146f}},	//   सिंह_, ttat, हिजे_, _airo,
   {{0x629c1470,0x7aed1471,0x5b150791,0x34940254}},	// [9d0] _biro, utat, ымат, ратр,
   {{0x44291472,0x7aed1473,0x69c8888b,0xa3e5035a}},	//   sja_, rtat, nade, _नाव_,
   {{0x7aed1474,0x44291475,0xdb0b809f,0x629c1476}},	//   stat, pja_, _segü, _diro,
   {{0x4429020f,0x629c0029,0x7aed1477,0x69c89478}},	//   qja_, _eiro, ptat, hade,
   {{0x442f9479,0x7c29830b,0x4421801c,0x63ad147a}},	//   _rog_, vjer, _đh_, mcan,
   {{0x629c147b,0x64428364,0x6d580110,0x3ea48bbd}},	//   _giro, _aloi, _žvai, _dumt_,
   {{0x69c89313,0x7c29911b,0x442f947c,0x6442947d}},	//   dade, tjer, _pog_, _bloi,
   {{0x63ad147e,0x69c3947f,0x442f8282,0x13099480}},	//   ncan, _sene, _qog_, ений_,
   {{0x69c39481,0x7c299482,0x628a8013,0x442f9483}},	//   _pene, rjer, _bhfo, _vog_,
   {{0x69c89484,0x42259485,0x64429486,0x6f099487}},	//   gade, удов, _eloi, _isec,
   {{0xa2cf873c,0x569482df,0xe4e4804a,0x6a7d8980}},	//   _दिक्, _тафт, _вічн, nèfi,
   {{0x69c39488,0x64429489,0xb8cb9370,0x5fab81d0}},	//   _wene, _gloi, _कं_, _छलफल,
   {{0x63bb8397,0xa3e880cf,0x69c3948a,0x69c8948b}},	//   mbun, _बात_, _tene, bade,
   {{0xa2d88305,0xf1e2000d,0x63bb948c,0xfce6148d}},	//   _मित्, _पाइन, lbun, лого,
   {{0x629c148e,0xa3e503b6,0xdb1d01d0,0x290780fe}},	//   _riro, _नाश_, _desí, _usna_,
   {{0x7bc9948f,0x6f161490,0x6f0981dd,0x6e3c1491}},	//   naeu, _tryc, _osec, skrb,
   {{0x63bb82af,0x629c1492,0xa3e50327,0xc05301c6}},	// [9e0] ibun, _piro, _नार_, _לזה_,
   {{0x20020c14,0x629c0609,0x63ad1493,0x09d580ab}},	//   leki_, _qiro, acan, ত্রা,
   {{0x25e91370,0x291e0b67,0xa494003d,0x645a0036}},	//   _जाती_, _štab_, _نیست, étis,
   {{0x63ad0098,0x69c89494,0x61e5032f,0x629c1495}},	//   ccan, zade, aghl, _wiro,
   {{0x68e19496,0x69c89497,0x2ca58362,0xa2cf8c2d}},	//   huld, yade, _auld_, _दिग्,
   {{0x2480020f,0xd252015b,0x69c89498,0x64428635}},	//   llim_, _طنز_, xade, _sloi,
   {{0xa3e89499,0x69c8949a,0x7bc6059c,0x6f09949b}},	//   _बाद_, vade, _keku, _esec,
   {{0x2002061b,0x63bb949c,0x68e1949d,0x7658949e}},	//   jeki_, gbun, duld, sivy,
   {{0x38558698,0x6edb925f,0x38a880e7,0x20020214}},	//   _търс, _नियु, _sûr_, deki_,
   {{0x7bc6149f,0x2ca5813c,0xdd8f94a0,0x27e694a1}},	//   _leku, _fuld_, _کوم_, lgon_,
   {{0x63ad0086,0xe821053e,0x2ca594a2,0x6e9380f7}},	//   ycan, याला_, _guld_, _اللا,
   {{0x27e69341,0x69c894a3,0x7bc614a4,0x64858742}},	//   ngon_, sade, _neku, lóin,
   {{0xd90e8077,0x63ad02a5,0xb8cb86ae,0xa85781c6}},	//   زیک_, vcan, _कू_, ריכה_,
   {{0xdd20800d,0x539b812a,0x291801e4,0x25e8940d}},	//   _může, _ניגו, _orra_, च्ची_,
   {{0x68e183a7,0xdb1d002a,0x7bc614a5,0x63ad14a6}},	//   culd, _vesí, _beku, tcan,
   {{0x20020214,0x63ad0144,0xf1e2001b,0x93b5105c}},	//   ceki_, ucan, _पाउन, рбац,
   {{0x29180019,0x28da800d,0x63a2804f,0x32550f04}},	// [9f0] _arra_, _भिडि, _mgon, авар,
   {{0x200d80ee,0x61e501c0,0x63bb8162,0x6fc794a7}},	//   _saei_, ughl, zbun, ारभू,
   {{0x78ad817f,0xdfd181a8,0x648594a8,0x63ad14a9}},	//   _čavk, قيا_, dóin, pcan,
   {{0x63a294aa,0x7bc614ab,0xf8c9026b,0x64b181a9}},	//   _ngon, _geku, _aréè_, _jāie,
   {{0x260a016f,0x291814ac,0x61f882d4,0x65c582df}},	//   ायची_, _erra_, _obvl, абла,
   {{0x63a294ad,0xe61890ac,0x200214ae,0xed5994af}},	//   _agon, лді_, zeki_, кол_,
   {{0xce380039,0x7bc60085,0x2905047f,0x51840084}},	//   ראות_, _yeku, _èla_, _гута,
   {{0x201f8012,0x68e194b0,0x7afd0122,0x3dc594b1}},	//   _unui_, vuld, _kpst, _welw_,
   {{0x63bb89af,0x28c282f1,0xa3b483b7,0xc24594b2}},	//   rbun, वीसि, झड़_, иник,
   {{0x69c714b3,0x386914b4,0xdb0414b5,0x63a28102}},	//   _jeje, _ajar_, nciá, _egon,
   {{0x69c714b6,0xa96994b7,0x216994b8,0x7c2d14b9}},	//   _meje, тина_, тини_, kjar,
   {{0x7afd14ba,0x69c714bb,0xe73a14bc,0x20560cc1}},	//   _opst, _leje, вем_, ртор,
   {{0x387e86e3,0x81dd00c8,0x7c2d14bd,0x200214be}},	//   _être_, থ্য_, djar, reki_,
   {{0x7bc614bf,0x443f94c0,0x644994c1,0x69c7001b}},	//   _seku, lku_, lhei, _neje,
   {{0x7afd0029,0x776d0118,0x442d8110,0x7c2d007b}},	//   _apst, _exax, oje_, fjar,
   {{0x644994c2,0x660394c3,0x44f1801c,0xef1a066a}},	//   nhei, henk, _mơ_, _ами_,
   {{0x69c70065,0x645a02be,0x207b00be,0x68fc012b}},	// [a00] _beje, étiq, _באקא, _sprd,
   {{0xba2314c4,0x601b0364,0x442d94c5,0x7bc614c6}},	//   одук, _tämä, hje_, _weku,
   {{0x443f94c7,0x442d821e,0x69c714c8,0x6449879f}},	//   kku_, kje_, _deje, khei,
   {{0x1ae6025d,0x443f803b,0x644980f3,0x442d94c9}},	//   _комм, jku_, jhei, jje_,
   {{0x27e694ca,0x442d94cb,0x644994cc,0x644614cd}},	//   rgon_, dje_, dhei, _ilki,
   {{0x443f8029,0x69c71024,0x442214ce,0x660394cf}},	//   eku_, _geje, _hnk_, genk,
   {{0x44f18104,0x7ae414d0,0xb4e40540,0x644980f7}},	//   _cơ_, luit, _नमो_, fhei,
   {{0x644994d1,0x442d94d2,0x628194d3,0x443f80ee}},	//   ghei, gje_, ello, gku_,
   {{0x660394d4,0xd5c614d5,0x326694d6,0x765c14d7}},	//   benk, वराज, итов, kiry,
   {{0x442d94d8,0x443f94d9,0x7c2d14da,0x442214db}},	//   aje_, aku_, zjar, _lnk_,
   {{0x850684c0,0x443f94dc,0x442d8353,0x6449851e}},	//   _خوان, bku_, bje_, bhei,
   {{0x644994dd,0x442d8d38,0x386694de,0x443f87df}},	//   chei, cje_, nnor_, cku_,
   {{0x7c22811b,0xfe2214df,0x7c2d14e0,0x95cb0f9c}},	//   _inor, मांस_, vjar, кува_,
   {{0x7ae414e1,0xdbf880c8,0x644614e2,0x30a68ff7}},	//   duit, _অফিস_, _alki, _крив,
   {{0x69c714e3,0x0ed30072,0x44f18129,0xfda70a27}},	//   _reje, _तिकड, _xơ_, _खलीफ,
   {{0xe51785e8,0x69c714e4,0x386914e5,0x660394e6}},	//   थिति_, _seje, _ujar_, zenk,
   {{0x7ae414e7,0x7c2d14e8,0xdb1982af,0x499282e3}},	// [a10] guit, rjar, _gewä, _دیگر,
   {{0x443f827f,0xdb1d0207,0xe4e700e8,0x442d94e9}},	//   zku_, _cesá, _кімн, zje_,
   {{0x442d94ea,0x69c714eb,0x644981b0,0x3ea900ee}},	//   yje_, _veje, yhei, _huat_,
   {{0x3ea914ec,0x7ae414ed,0x386681e8,0x660394ee}},	//   _kuat_, buit, gnor_, wenk,
   {{0x660394ef,0x443f94f0,0x44f18028,0x442d94f1}},	//   tenk, vku_, _sơ_, vje_,
   {{0xc3320158,0x3ea90812,0x9f568061,0x2fc914f2}},	//   _צום_, _muat_, ágát_, _leag_,
   {{0x442d94f3,0x3ea914f4,0x644994f5,0x58d414f6}},	//   tje_, _luat_, thei, _морт,
   {{0xa2d881ab,0x442d81e2,0x660394f7,0x443f94f8}},	//   _मिश्, uje_, senk, uku_,
   {{0x644994f9,0xa3e8901c,0xa3e50054,0x66038a9e}},	//   rhei, _बार_, _नाई_, penk,
   {{0x442d94fa,0x644994fb,0xa2d894fc,0xaca38135}},	//   sje_, shei, _मिर्, _anụm,
   {{0x2fc90ad0,0x442d94fd,0x6f0d14fe,0x84678098}},	//   _beag_, pje_, _asac, _къде,
   {{0x3ea914ff,0x64409500,0x442d8168,0x66fa8ec3}},	//   _buat_, ckmi, qje_, bākā,
   {{0x44d3009a,0x683f00f1,0xac7480f7,0x02a78cdf}},	//   eć_, _mëdh, _بالش, _трем,
   {{0xed5a1501,0x6d4e0192,0xa3e501a2,0x7c229502}},	//   гог_, tzba, _नाउ_, _znor,
   {{0x50b590f8,0x25e9123a,0xf1ca026f,0x38669503}},	//   _услу, _जारी_, ntáž_, ynor_,
   {{0x7ae41504,0xb603827f,0x47c61505,0x68e50122}},	//   tuit, _hráč, _убив, duhd,
   {{0xab271506,0x23271507,0xe1fa1508,0x44d30035}},	// [a20] бота_, боти_, лга_, ać_,
   {{0x78a908ae,0x3ea101f4,0x15461509,0x78a0950a}},	//   _čevr, _giht_, _геом, _simv,
   {{0x0ce2950b,0xa3e88128,0x7ae4150c,0x20120300}},	//   _মন্ত, _बाल_, suit, _kayi_,
   {{0xa2d8800c,0xdd2c8110,0x32058061,0xd6cf01f9}},	//   _मिल्, _nėšt, hely_, _تقی_,
   {{0x3866950d,0xa2a20540,0x78bb10d3,0x6ecb150e}},	//   rnor_, _कंट्, _čuve, तीपु,
   {{0x6f1b82af,0x20120041,0xdb1d0366,0x6459950f}},	//   _druc, _layi_, _besæ, _amwi,
   {{0xd132045b,0x6f1b819d,0x48e31510,0xa3cc00d4}},	//   _عمر_, _eruc, _норв, _रजा_,
   {{0xf0639511,0x6f1b9512,0xe8e0001c,0xa2b48993}},	//   _експ, _fruc, _chụp_, обич,
   {{0x25e91513,0x6440807b,0x66118198,0x2fc90037}},	//   _जाली_, rkmi, ökkä, _reag_,
   {{0xd90e84c0,0x64408074,0x683f03ed,0x66fa81a9}},	//   فیت_, skmi, _zëdh, rākā,
   {{0x20121514,0x5d868013,0x5316815b,0x28f8804a}},	//   _bayi_, _الال, _گذار, шень_,
   {{0x96eb0084,0x9f991515,0x6f0d1516,0x673d062c}},	//   льга_, ивну_, _psac, tysj,
   {{0x21270129,0x3c388036,0x32059517,0x6c7b83de}},	//   ̣nh_, _févr_, bely_, _גראד,
   {{0x6d1401fe,0x1bf89518,0xe6671519,0x25a51277}},	//   डिंग_, ्जवल_, стмо, øll_,
   {{0x3211009a,0x4035151a,0x64a3817f,0x20120db1}},	//   _razy_, _мекс, _uđit, _fayi_,
   {{0x0ca8151b,0x20120326,0x6b828c2e,0x6495936f}},	//   стри_, _gayi_, _kyog, _ušit,
   {{0x5a35151c,0xe7cc8035,0x6f0d113b,0x69ca951d}},	// [a30] онат, ारनप, _usac, _kefe,
   {{0xa3e5146d,0x6b82951e,0x27ed951f,0x69ca9520}},	//   _नाक_, _myog, _scen_, _jefe,
   {{0x201200a4,0x69ca826b,0x66070088,0xa3e89521}},	//   _yayi_, _mefe, mejk, बला_,
   {{0xac190765,0x69ca9522,0x753a0192,0x06ed064a}},	//   _тому_, _lefe, ätze, _जमाव_,
   {{0x644d1523,0x69ca80c9,0xd6db8aac,0x171c00be}},	//   mhai, _oefe, уте_, ָווע,
   {{0xf7708c48,0x644d1524,0x5bb38beb,0x30a71525}},	//   ران_, lhai, ीर्व, _грав,
   {{0xb0660009,0x32059526,0x91fc80eb,0x6b828c56}},	//   ntää, vely_, rnāl, _ayog,
   {{0x69d89527,0x628504b7,0x6b829528,0x69ca85ee}},	//   _adve, llho, _byog, _aefe,
   {{0x52a691e9,0x32058e25,0x69ca9529,0x290e8118}},	//   овым_, tely_, _befe, _asfa_,
   {{0xe8f9952a,0x2012152b,0x6b8282c4,0x5f1d152c}},	//   ало_, _sayi_, _dyog, मिन्_,
   {{0x386d8db7,0x69d80073,0x644d152d,0x69ca952e}},	//   _kjer_, óvei, khai, _defe,
   {{0xdb1d0364,0x76438aa2,0x645980b4,0xa3e50107}},	//   _kesä, lkny, _umwi, _नाग_,
   {{0x644d152f,0x7bcb80eb,0x3205816b,0x7643808e}},	//   dhai, _iegu, pely_, okny,
   {{0x76439530,0x69ca9531,0xe7e607e6,0xceb283de}},	//   nkny, _gefe, _काका_, ויך_,
   {{0x69c19532,0x2d8c0370,0x7bcb8812,0x6da30ae7}},	//   mble, åde_, _kegu, дира,
   {{0x644d1523,0xe3ba067c,0x62851533,0x76a0077f}},	//   ghai, рба_, elho, _báyì,
   {{0xe7ff8b04,0x764380dd,0xd0420085,0x764b0084}},	// [a40] ोजना_, kkny, xslə, _įgyv,
   {{0x7bcb9534,0xa7fb04c3,0x69c19535,0x25fb8bb8}},	//   _legu, riñe, nble, ल्मी_,
   {{0x644d1523,0x60c70282,0x03a60e97,0x6aa381b9}},	//   bhai, _cwjm, _мино, _minf,
   {{0x644d1536,0xef1a9537,0x6edb83eb,0xa7fb002a}},	//   chai, име_, _निशु, piñe,
   {{0x7c261538,0x2f189539,0x63b40035,0x386d89c4}},	//   _inkr, соль_, ągną, _djer_,
   {{0x644402a3,0x386d813c,0x6aa3953a,0x78a407b8}},	//   lkii, _ejer_, _ninf, _liiv,
   {{0x69ca953b,0x3af4039c,0xdd9381e5,0x69c182c4}},	//   _refe, läp_, машы, dble,
   {{0x6444153c,0xdee6953d,0x69ca953e,0x69c1953f}},	//   nkii, _моби, _sefe, eble,
   {{0x7e7c1540,0x16668098,0x9e669541,0x213e8114}},	//   korp, _двам, _двад, wyth_,
   {{0x7af601e2,0x76439542,0x645f05e7,0x7bcb8091}},	//   ityt, ckny, ziqi, _eegu,
   {{0x7c261543,0x6e371544,0x3a3800b9,0x644d1545}},	//   _onkr, _roxb, _morp_, yhai,
   {{0x69ba83eb,0x6aa39546,0x644d01c5,0x7bcb9547}},	//   _श्री, _einf, xhai, _gegu,
   {{0xdefb0196,0x09d500ab,0x44269548,0x64440079}},	//   шын_, স্টা, _ino_, dkii,
   {{0x44269549,0x3f850029,0x7c26154a,0x46dc154b}},	//   _hno_, ālu_, _ankr, _बिरह,
   {{0x644d154c,0x6607154d,0x7bcb954e,0x3495154f}},	//   thai, rejk, _yegu, завр,
   {{0xe019853e,0x68e89550,0x4426808e,0x8cdc12c6}},	//   _नोंद_, mudd, _jno_, _फिरो,
   {{0xa3e89551,0x68e89552,0x644d1553,0xb0660009}},	// [a50] _बाई_, ludd, rhai, stää,
   {{0x7c260353,0x09e300ab,0x65950139,0x387f9554}},	//   _enkr, ন্না, _напу, _skur_,
   {{0xdb098013,0x3a38037a,0x68e89555,0xceb981d0}},	//   iceá, _dorp_, nudd, _stř_,
   {{0x26c90010,0x44268365,0x670081bc,0x645f1556}},	//   _kwao_, _nno_, _ịkag, qiqi,
   {{0x7bcb9557,0x645d1558,0x68e89559,0x870780d7}},	//   _regu, _imsi, hudd, تبال,
   {{0x4426955a,0x4439120b,0x68e8955b,0x2cac955c}},	//   _ano_, _hos_, kudd, _budd_,
   {{0x4439155d,0x7bcb955e,0x7643955f,0x6aa38d02}},	//   _kos_, _pegu, rkny, _rinf,
   {{0x44391560,0x387f885c,0x7643808e,0x44268706}},	//   _jos_, _ukur_, skny, _cno_,
   {{0x44391561,0x9f4f8e1b,0xab659562,0x27ff8122}},	//   _mos_, regó_, явил, _ibun_,
   {{0x44391563,0x44269564,0x7e55803f,0x68e88c2e}},	//   _los_, _eno_, _عناص, fudd,
   {{0x2cac9565,0x7bcb9566,0x3ead9567,0x69c19568}},	//   _gudd_, _tegu, _huet_, rble,
   {{0x44d7802e,0xe8df001c,0xbbaa1370,0x69c18192}},	//   mă_, _chứa_, _कलेक, sble,
   {{0x7d1e09cf,0x644b9569,0x44d7802e,0x2fcd81c0}},	//   _srps, _ilgi, lă_, _meeg_,
   {{0x2fcd956a,0x4439156b,0x68e8956c,0x629d801b}},	//   _leeg_, _aos_, budd, ůsob,
   {{0x44d78012,0x7ae9956d,0x44268114,0x78a4156e}},	//   nă_, luet, _yno_, _tiiv,
   {{0x4426040e,0x2fcd90af,0x4439156f,0x5baa1570}},	//   ño_, _neeg_, _cos_, скам_,
   {{0x44391571,0x78bb003b,0xe9da11b1,0x64440079}},	// [a60] _dos_, _čuva, йка_, rkii,
   {{0xa7fb04c3,0x64441572,0x7c399106,0x27ff8041}},	//   miña, skii, _lowr, _abun_,
   {{0xe821035a,0xe8fa12e1,0x7af61573,0xa3e50f12}},	//   याचा_, сле_, styt, _नाच_,
   {{0xa3ea800c,0x1bea809a,0x44391574,0xafdb0257}},	//   _टाइप_, _टाइल_, _gos_, lhør,
   {{0x9cf880ab,0x7bc41575,0x2fcd9576,0xdfcf80a0}},	//   _আছেন_, mbiu, _deeg_, ايه_,
   {{0x443901c5,0x644b8084,0x44268b81,0x412a1577}},	//   _zos_, _algi, _sno_, _лого_,
   {{0xe7ed035a,0x44390282,0x44d78087,0x69dc00e8}},	//   _झाला_, _yos_, gă_, _idre,
   {{0xb6038029,0x44391578,0x68e302ba,0x69ce1579}},	//   ēšan, _xos_, ánde, _hebe,
   {{0x69ce0393,0x7ae9957a,0x7ae41434,0x66e3957b}},	//   _kebe, guet, nrit, _пота,
   {{0x64aa800d,0x69ce06ec,0x78ad957c,0x25fb80d4}},	//   _přid, _jebe, _čavr, ल्दी_,
   {{0x69ce157d,0x44d78012,0x6e28813c,0x7ae402af}},	//   _mebe, că_, _indb, hrit,
   {{0x4426957e,0x69ce157f,0x68e89580,0x5f1383ca}},	//   _uno_, _lebe, rudd, _धनम्_,
   {{0x69dc0025,0x44391581,0x68e89582,0x7ae98661}},	//   _odre, _ros_, sudd, cuet,
   {{0x8cb109a3,0x69ce1583,0xc6a41584,0x6266845a}},	//   _आंदो, _nebe, ерси, _عاشق,
   {{0x92e900c8,0x44391585,0x7ae40074,0x6fcc816f}},	//   _মনে_, _pos_, erit, ारां,
   {{0x69dc1586,0x7ae41587,0x765e1588,0x69ce011b}},	//   _adre, frit, _empy, _aebe,
   {{0x44391589,0x69ce158a,0x44d78012,0xe3b007bd}},	// [a70] _vos_, _bebe, ză_, ارف_,
   {{0x19ab03a7,0x4439158b,0x6d5909ab,0x200b158c}},	//   стап_, _wos_, _ƙwad, leci_,
   {{0x69ce158d,0x4439158e,0x3947158f,0x7ae400e5}},	//   _debe, _tos_, áns_, arit,
   {{0x44d78087,0x645d01f6,0x4add8d86,0x2fcd822c}},	//   vă_, _umsi, _मिलव, _qeeg_,
   {{0x3ea58074,0x24891217,0x2fc08333,0x66171590}},	//   _pilt_, mlam_, ñiga_, _kaxk,
   {{0x69ce1591,0x44d78012,0x1dbf0f97,0x6e3a8362}},	//   _gebe, tă_, ्रित, _cotb,
   {{0x7bcf059c,0x78a2826f,0x661702a3,0x7c39809a}},	//   _kecu, ňova, _maxk, _powr,
   {{0x44d78012,0x3ea58613,0x200b120e,0xa01b016d}},	//   ră_, _wilt_, jeci_, slöj,
   {{0x44d7802e,0x4add816f,0x1dbf016f,0x7bcf1592}},	//   să_, _मिळव, ्रात, _mecu,
   {{0xe0d99593,0x39459594,0x2d85809a,0x44d78087}},	//   ово_, дног, _tyle_, pă_,
   {{0x24891595,0x69c501e4,0x7ae401ac,0x7ae98cdb}},	//   klam_, ibhe, zrit, suet,
   {{0xb9220870,0x25c601cb,0x7bcf0087,0xa7fb002a}},	//   _akpọ_, वर्ण, _necu, tiña,
   {{0x6d439596,0xba558081,0x99830196,0x00000000}},	//   lyna, _откъ, _kojų_, --,
   {{0xc87902bb,0xa7fb04c3,0x09e300ab,0xdb218216}},	//   duğu_, riña, ন্তা, _ñuño,
   {{0xbea31597,0x7bcf1598,0x9872016b,0xa7fb03a8}},	//   тарк, _becu, láč_, siña,
   {{0x69ce1599,0xd9f0159a,0xd7ff002e,0x7e63826c}},	//   _sebe, _चाहत_, şări_, hinp,
   {{0x78ae159b,0x64bc0024,0x78bc026c,0x7bcf159c}},	// [a80] _subv, _očig, _strv, _decu,
   {{0x7ae4159d,0x2489159e,0x1cba003f,0xe8df001c}},	//   rrit, alam_, _واجب_, _chữa_,
   {{0xdb1d01df,0xfbc6159f,0x7bcf15a0,0x2d9615a1}},	//   _xesú, _обно, _fecu, _юрис,
   {{0xab2a153d,0x31368158,0x248915a2,0x7d1c808b}},	//   _дома_, ונעם_, clam_, _ársi,
   {{0x69ce15a3,0x09e300ab,0x394601a9,0xe73795a4}},	//   _tebe, ন্ধা, ņos_, мец_,
   {{0x69dc15a5,0x65948162,0xdcba95a6,0x69ce0192}},	//   _udre, налу, ощи_, _uebe,
   {{0x0ee0835a,0x2df980d7,0x6935128a,0xdb060646}},	//   _निवड, سبوک_, _přeš, _afkø,
   {{0x3218008e,0x25de0d14,0xdb1d0511,0x64aa801b}},	//   _hary_, कृती_, _resú, _přib,
   {{0x41e68d13,0xa3c10074,0xc5e600ab,0x25fb95a7}},	//   міна, ुरत_, খ্যা_, ल्ही_,
   {{0xd25095a8,0xd62695a9,0x6d4395aa,0x2fc680e4}},	//   اند_, _تعري, byna, lbog_,
   {{0x6d4395ab,0xc87f0192,0xa01b0198,0x321801c6}},	//   cyna, toß_, llöi, _mary_,
   {{0xa3e8800d,0xc32a80f7,0xb9068af3,0xd5b1827d}},	//   _बाट_, _وكان_, _पि_, _tác_,
   {{0xa2d88105,0xdca395ac,0xd78b00f7,0x7bcf15ad}},	//   _मिट्, _раци, تخدم_, _recu,
   {{0x200b0025,0x386015ae,0x3eb985a4,0x7bcf079a}},	//   seci_, _emir_, _éste_, _secu,
   {{0x38b701cd,0x248915af,0x6d550037,0x320c95b0}},	//   _oħra_, tlam_, uzza, medy_,
   {{0xa7fb04c3,0xd49815b1,0xfc150071,0x28d815b2}},	//   miño, дру_, эмбэ, _डिजि,
   {{0x7bcf00eb,0x6d43809a,0x2fc6806a,0x32180a7a}},	// [a90] _vecu, zyna, dbog_, _bary_,
   {{0x321815b3,0x248915b4,0xae0082f1,0xa2b00a27}},	//   _cary_, slam_, ल्मन_, _अंर्,
   {{0xa3c38b6f,0x1bd515b5,0x24890214,0x69c5125b}},	//   ्रम_, _поня, plam_, rbhe,
   {{0x3f8904b9,0x61fe1384,0x2fc695b6,0x64bc0362}},	//   _kyau_, afpl, gbog_, _dčid,
   {{0xe4560159,0xdb028028,0xa3e88fb2,0x320c81ac}},	//   _נישט_, _ngoà, _बाज_, kedy_,
   {{0x2451827f,0x7aed03ac,0x46e082f1,0x645a01a9}},	//   _máme_, muat, _निरह, ītie,
   {{0x7aed0be5,0x82b881bc,0xc98415b7,0x7e6395b8}},	//   luat, _rịịl_, _аути, rinp,
   {{0xe7f9800d,0xdb1d0b40,0xa19415b9,0xa3c10697}},	//   _एउटा_, _besø, _расч, ुरि_,
   {{0x442b06cb,0x7e6395ba,0x2ef48098,0x25a9803d}},	//   _mnc_, pinp, _изтр, _فضای_,
   {{0x442b0122,0x291e0084,0x850f001b,0x4ae2052a}},	//   _lnc_, _štai_, ाबाट_, _पिसव,
   {{0x7aed15bb,0xa3c115bc,0xf8660a13,0x3f8909ab}},	//   huat, ुरा_, евно, _ayau_,
   {{0x7aed15bd,0x66e615be,0x9ac48372,0xdee615bf}},	//   kuat, нома, _boċċ, номи,
   {{0xe801835a,0x7aed15c0,0x7c2b95c1,0x64498192}},	//   ळ्या_, juat, _ingr, mkei,
   {{0x443d8051,0x78a995c2,0x95860088,0x442b15c3}},	//   _how_, _liev, елге, _anc_,
   {{0xa7fb062f,0x628195c4,0xda020a0d,0x26d915c5}},	//   ciño, molo, र्फत_, asso_,
   {{0x7aed022e,0x628195c6,0x78a995c7,0x7c3d00b9}},	//   fuat, lolo, _niev, _cosr,
   {{0x3b070698,0xae008e5b,0xfe720065,0x2c01809a}},	// [aa0] нето_, ल्डन_, _مدد_, व्यू_,
   {{0x9b9300f7,0x443d8039,0x98d38ad5,0xb77b01c6}},	//   الكت, _low_, _दबाए, _מאפש,
   {{0x26c0120e,0x644995c8,0x61fe016d,0x7c2b95c9}},	//   _htio_, kkei, rfpl, _ongr,
   {{0x672415ca,0x443d8051,0xdfcf8013,0x7aed09ca}},	//   _krij, _now_, ميم_, buat,
   {{0x78a995cb,0x91fc80eb,0x7bd615cc,0x7aed15cd}},	//   _diev, onāt, mayu, cuat,
   {{0x25fb901b,0x7c2b95ce,0x628195cf,0x7bd615d0}},	//   ल्ली_, _angr, jolo, layu,
   {{0xa3e40740,0xafe695d1,0x291e01fa,0x7c3d0748}},	//   _नया_, _повл, _éta_, _yosr,
   {{0x64498352,0x98a395d2,0x78a995d3,0x7bd615d4}},	//   gkei, _бисе, _giev, nayu,
   {{0x0edc01ce,0x7afb90c1,0xdb1981ec,0x68e10106}},	//   _बिगड, gtut, _gewü, _åldr,
   {{0x628195d5,0x27e015d6,0x7bd615d7,0xef178110}},	//   golo, _adin_, hayu, _яму_,
   {{0x694680fe,0xa3b3801b,0x7afb8cdb,0x320c95d8}},	//   _očeš, जुङ_, atut, redy_,
   {{0x44fa88cf,0x672415d9,0x661a826c,0xa7fb05e4}},	//   më_, _brij, _hatk, riño,
   {{0x62818042,0xff0415da,0x44fa80f1,0x672415db}},	//   bolo, лярн, lë_, _crij,
   {{0x661a8364,0x672403e9,0x27e015dc,0x442b047f}},	//   _jatk, _drij, _edin_, _snc_,
   {{0x44fa88cf,0x661a95dd,0x25a500f2,0x7c3d0805}},	//   në_, _matk, äll_, _posr,
   {{0x6d588353,0x27e0017f,0x672415de,0x7aed15df}},	//   izva, _gdin_, _frij, tuat,
   {{0xc6a715e0,0x672415e1,0x44fa80f1,0x6aaa95e2}},	// [ab0] _прои, _grij, hë_, _kiff,
   {{0x78a98029,0xda7815e3,0x44fa80f1,0x6aaa81b9}},	//   _siev, нях_, kë_, _jiff,
   {{0xdd9115e4,0x78a98029,0x7aed0867,0x44fa820f}},	//   _خود_, _piev, suat, jë_,
   {{0x644f15e5,0x648580f7,0x7aed15e6,0x44fa83ed}},	//   _ulci, hóir, puat, dë_,
   {{0x628195e7,0x661a8267,0xdb070009,0x44fa81b0}},	//   yolo, _batk, ämäs, eë_,
   {{0x443d95e8,0x628195e9,0x99d40154,0x9f4f8077}},	//   _sow_, xolo, _متفا, nggé_,
   {{0x628195ea,0x92a60063,0x648580f7,0xdd918065}},	//   volo, _dołą, dóir, گوں_,
   {{0x628195eb,0x7afb8098,0x38668087,0xed6404e8}},	//   wolo, ttut, cior_, loží_,
   {{0x644995ec,0xdd918065,0x661a8168,0x200f95ed}},	//   rkei, دوں_, _fatk, megi_,
   {{0x7afb95ee,0x644995ef,0x69d704c3,0x200f95f0}},	//   rtut, skei, naxe, legi_,
   {{0x7afb95f1,0x6aaa8806,0x672402fd,0xa3c380c2}},	//   stut, _diff, _srij, ्रद_,
   {{0x672415f2,0x20040a56,0xa3d284c5,0xd5648638}},	//   _prij, ými_, वरण_, _ступ,
   {{0x628195f3,0x6aaa95f4,0x6e3e01a1,0xddd8807a}},	//   polo, _fiff, _popb, lovš,
   {{0x672415f5,0x248d95f6,0x63bb8098,0xfce615f7}},	//   _vrij, llem_, lcun, кого,
   {{0x6b8b95f8,0x7ae995f9,0x7bd615fa,0xe81d15fb}},	//   _hygg, lret, tayu, _बोका_,
   {{0xc9528051,0x27e0015d,0x15ee0035,0x7bc98d35}},	//   _כמו_, _udin_, _जाकर_, nbeu,
   {{0xdca315fc,0x64a30110,0xcb6715fd,0x0b4315fe}},	// [ac0] рати, рата, вате_, антн,
   {{0x7bd604a7,0x7ae9802a,0x6b8b92f1,0xbea615ff}},	//   sayu, iret, _mygg, _шапк,
   {{0x661a8009,0xfe370039,0xa3c3873c,0x249f9600}},	//   _ratk, _סרטי_, ्रा_, kmum_,
   {{0x69469601,0x628700b9,0xddd8824a,0x44fa8168}},	//   _učeš, _ekjo, dovš, vë_,
   {{0x248d9602,0x92a6009a,0x69ca008b,0x38669603}},	//   dlem_, _połą, ðfes, rior_,
   {{0x44fa88cf,0x7ae98620,0x68e88114,0x629d9412}},	//   të_, dret, yrdd, ïsol,
   {{0x81d780ab,0x38668106,0x7ae99604,0x200f9605}},	//   িলা_, pior_, eret, begi_,
   {{0x44fa88cf,0x6aaa9606,0x43948b69,0x291800a4}},	//   rë_, _siff, лайс, _isra_,
   {{0x44fa88cf,0x661a8359,0x6d47009a,0x648580f7}},	//   së_, _tatk, zyja, tóir,
   {{0x91fc8029,0x5ea68b76,0x3eb985a4,0x60c49607}},	//   ciāl, _شمال, _ésta_, _čimb,
   {{0x67229608,0x248d9609,0x648580f7,0xb6a38162}},	//   lvoj, blem_, róir, _тифл,
   {{0xdb04160a,0x7ae9960b,0x4bda819f,0x648581a8}},	//   nció, bret, _آباد_, sóir,
   {{0x7336845b,0xf09f023e,0x7ae9960c,0xdb040333}},	//   _جرائ, rmà_, cret, ició,
   {{0x52d78039,0x201b00dd,0xceb383c8,0x200f960d}},	//   _יודע_, _waqi_, ייש_, zegi_,
   {{0x4fc70652,0x984f009a,0x3eac8aa2,0x201b0187}},	//   _испа, jęć_, _midt_, _taqi_,
   {{0x3eac8022,0x62870370,0x57f5160e,0x3dd88264}},	//   _lidt_, _skjo, _спит, _সাফল,
   {{0xb275160f,0x3a750162,0x2d8c9610,0x667200d7}},	// [ad0] глаш, глар, _lyde_, شگیر,
   {{0x6722803a,0x68e302ba,0x7aef809f,0x78ad01c0}},	//   dvoj, ándo, àcti, _hiav,
   {{0x200f9611,0xa3d28076,0xf1a71612,0x2d8c8366}},	//   tegi_, वरा_, тран, _nyde_,
   {{0x25ff05fc,0x69d71613,0x69ca007b,0xa01b1614}},	//   श्री_, saxe, ðfer, mlös,
   {{0x7c2f1615,0x200f9616,0x64aa801b,0xd6db9617}},	//   _incr, regi_, _přin, фте_,
   {{0xe29a8104,0xdb04040e,0x6b8b8bfa,0x644d0364}},	//   _như_, ació, _rygg, lkai,
   {{0x91fc8029,0x62851618,0x58d41619,0x30a7961a}},	//   riāl, moho, _вост, _арав,
   {{0xdb04161b,0x69d5161c,0x6285161d,0xc1720039}},	//   cció, _heze, loho, _החל_,
   {{0x69d50065,0x248d961e,0x6f098754,0xac9680f7}},	//   _keze, rlem_, _upec, دنيا_,
   {{0x7ae9961f,0x3f7a8158,0x69d51620,0x63bb9621}},	//   rret, _אָבע, _jeze, scun,
   {{0x10a600c4,0x644d0009,0x69d51622,0x2ba483db}},	//   лион, kkai, _meze, खेबा,
   {{0xcea9093f,0x69d51623,0x7ae98558,0xf99204de}},	//   _זי_, _leze, pret, מרי_,
   {{0x442f896c,0xe28e9624,0x78ad1625,0x643a81c6}},	//   _ing_, _га_, _diav, _רעננ,
   {{0x69d51626,0xa01b01ec,0x7c2f1627,0x644d0196}},	//   _neze, flös, _ancr, ekai,
   {{0xa5070fbf,0x2d8c013c,0xed5a1628,0xdb0b806a}},	//   лера_, æde_, хов_, _afgø,
   {{0x7c3b8886,0x644d1629,0x442f962a,0x78ad162b}},	//   njur, gkai, _jng_, _giav,
   {{0x69d5162c,0x28d78f97,0x33d5021e,0x2ca002f1}},	// [ae0] _beze, _भौति, ріст, rmid_,
   {{0x64560578,0x442f820d,0x62851486,0x2ca0162d}},	//   shyi, _lng_, goho, smid_,
   {{0x442f962e,0x69d5162f,0x4fea9630,0x00e61631}},	//   _ong_, _deze, емен_, ужен,
   {{0x6493029a,0x442f85ee,0xf3f98493,0x644d0196}},	//   nçil, _nng_, biţi_, ckai,
   {{0xdb040c15,0x44201632,0x62851633,0xbe8a9634}},	//   rció, mdi_, boho, нске_,
   {{0x442f9635,0x69d51636,0x20d18390,0x67229637}},	//   _ang_, _geze, kši_, rvoj,
   {{0xdb04040e,0x442f862f,0x20d18db7,0x78b502a5}},	//   pció, _bng_, jši_, _guzv,
   {{0x33269638,0x661e0110,0x26c69639,0x44de81b9}},	//   _prox_, _lapk, ppoo_, rċ_,
   {{0x76418065,0x4420163a,0x442f963b,0x78ad047f}},	//   _foly, idi_, _dng_, _riav,
   {{0x7641831d,0x78a2963c,0x644d011e,0x4420163d}},	//   _goly, lmov, zkai, hdi_,
   {{0xd48f963e,0x1994963f,0x2d8c009a,0x7413803d}},	//   _гр_, раня, żdej_, _گونا,
   {{0x4d7b8f60,0x44201640,0x78a28333,0xd0e5800c}},	//   _ארבע, jdi_, nmov, _किरण_,
   {{0xa2b005e8,0xead49641,0x44201642,0xe29a8028}},	//   _अंग्, _толь, ddi_, _thư_,
   {{0x44201643,0x98bc001b,0x2bd2940d,0x64429151}},	//   edi_, ávě_, सरवा, _hooi,
   {{0x69da9644,0x442f8355,0x644d0364,0x78a28353}},	//   mate, _yng_, tkai, kmov,
   {{0x69da9645,0x78a280ce,0x44201646,0xa01b1647}},	//   late, jmov, gdi_, rlös,
   {{0x644d0483,0x644282d8,0x90980c48,0xa01b12d2}},	// [af0] rkai, _mooi, _حضور_, slös,
   {{0x644d1648,0x629c0c3f,0x44201649,0x7d1a964a}},	//   skai, _chro, adi_, _osts,
   {{0x21270104,0x69d5164b,0x442002a3,0x3915164c}},	//   ính_, _veze, bdi_, рмер,
   {{0x644290f4,0x69d5164d,0x69da964e,0x628500b4}},	//   _nooi, _weze, hate, soho,
   {{0x7bda0496,0xfe7f023e,0x2d9c01d6,0xf6e7964f}},	//   _בקרו, buït_, _úver_, уцен,
   {{0x20d71650,0x7aed1651,0xf6259652,0x4e00864a}},	//   _مترج, mrat, рдко, ल्लई_,
   {{0xe3b18307,0x69da9653,0xa3b91094,0x76419654}},	//   يرة_, date, _चला_, _voly,
   {{0x20d1803b,0x6ee780d5,0x1309835f,0x7bcd1655}},	//   vši_, _مسئل, вний_, nbau,
   {{0x7c3b9656,0x92020054,0x69da8428,0x64429657}},	//   rjur, र्वज_, fate, _dooi,
   {{0x2480803b,0x7aed1658,0x212789da,0xf41f016d}},	//   čima_, irat, _prnh_, _skäl_,
   {{0x44201659,0x6493080a,0xdddc025b,0x27e0808b}},	//   ydi_, tçil, jorš, ðing_,
   {{0x442f965a,0x186a0153,0x20d193cf,0x6729965b}},	//   _ung_, тами_, rši_, _krej,
   {{0x69da965c,0x442001b9,0x7aed026c,0x6c8481a8}},	//   bate, vdi_, jrat, _النم,
   {{0x69da8039,0xfed780ab,0x8cb10035,0x78a284e8}},	//   cate, _সমাধ, _आंखो, zmov,
   {{0xada6165d,0xdb1207ca,0x4420011c,0x6da614b8}},	//   равл, _ágús, tdi_, рива,
   {{0x4420165e,0x3b00022b,0x6729965f,0x2b099660}},	//   udi_, ttiq_, _orej, _वहाँ_,
   {{0x44201661,0x5baa06d2,0xfe7f0722,0x62661662}},	// [b00] rdi_, ткам_, tuït_, аваа,
   {{0x2bb80076,0x09e61663,0x2243026c,0x91e600bf}},	//   _अलवा, рожн, _cojk_, роже,
   {{0x2cf49664,0x290100f7,0x44201665,0x78a29666}},	//   _इमेल_, gtha_, pdi_, tmov,
   {{0x67299667,0x69da9668,0x44201669,0x64aa928a}},	//   _brej, zate, qdi_, _přim,
   {{0x2bd301fe,0x629c0051,0x78a2826f,0x69da966a}},	//   तररा, _thro, rmov, yate,
   {{0x672988cf,0xa11600d7,0x69da966b,0x2901166c}},	//   _drej, _پورت, xate, btha_,
   {{0x69da966d,0x2508819f,0xafdb0aa2,0x320a0118}},	//   vate, ارتی_, ljøe, _ibby_,
   {{0x69da966e,0x67299554,0x6d4a966f,0x249d9670}},	//   wate, _frej, ryfa, _chwm_,
   {{0x67299671,0x69da9672,0xa2b38198,0xd1ca9673}},	//   _grej, tate, обыч, кунд_,
   {{0x38ba9674,0x6f029675,0x16639676,0x32549677}},	//   _për_, mtoc, _двум, свор,
   {{0xa3d60816,0x6f0d1678,0x672980e1,0x91a980ff}},	//   हरा_, _spac, _zrej, _đã_,
   {{0x69da9679,0x64bc0088,0xa3c38eb6,0x7aed0071}},	//   sate, _pčin, ्रः_, yrat,
   {{0x69da967a,0x98be8196,0xfe7f0980,0x00000000}},	//   pate, dytą_, duïr_, --,
   {{0x7aed07aa,0x9f4002af,0x2d840214,0x69d8007b}},	//   vrat, _weiß_, ğmen_, ðvel,
   {{0x0467167b,0x25fb9513,0x7aed0372,0x24920114}},	//   атам, ल्टी_, wrat, flym_,
   {{0x7aed167c,0x200900b9,0x6f02967d,0x69d8967e}},	//   trat, _ubai_, ktoc, _heve,
   {{0x7bcd167f,0x6f0d0397,0x64aa801b,0x69d89680}},	// [b10] rbau, _upac, _přij, _keve,
   {{0x62888114,0xe9ab07d2,0x35f50a13,0x290100b9}},	//   nodo, ندان_, _упор, ttha_,
   {{0xdfd180f7,0x69d88722,0x38690506,0x66151681}},	//   كيا_, _meve, _kmar_, mezk,
   {{0x69d89682,0x67299683,0x62889684,0x7aed1685}},	//   _leve, _prej, hodo, prat,
   {{0x53350158,0x29011686,0xdefb8198,0x48dd8074}},	//   _האָב_, stha_, тые_, _कौनो_,
   {{0x9e648cde,0xb6079687,0x69d89688,0xddc3802e}},	//   овід, рядк, _neve, dinţ,
   {{0x7ae280eb,0x62889689,0xd469968a,0x48ab81e5}},	//   _avot, dodo, лике_, _атам_,
   {{0xeb99968b,0x6729968c,0xfd5501bc,0xdd2801a9}},	//   лий_, _trej, _slaị, nēša,
   {{0x69d8968d,0x67298353,0x9f44080a,0x62888114}},	//   _beve, _urej, ümü_, fodo,
   {{0x38690727,0x2fdd822c,0x69d8968e,0x00000000}},	//   _amar_, lawg_, _ceve, --,
   {{0x69d8968f,0xf5958013,0x8d958013,0x6615011e}},	//   _deve, _الاج, _الاش, dezk,
   {{0x20560a14,0xa856038c,0x3d01809a,0x6e219690}},	//   стор, стој, mów_, _halb,
   {{0x6e219691,0x62889692,0x41a7016f,0x443f9693}},	//   _kalb, bodo, केतस, mju_,
   {{0x69d882d8,0x6615011b,0xb6cc8380,0x645b9694}},	//   _geve, gezk, _şükü, lhui,
   {{0x3d018063,0x7bd983ac,0xc69283c8,0x443f8084}},	//   nów_, _kewu, פאל_, oju_,
   {{0x645b9695,0x69d89696,0x78a38cfa,0xd5b18129}},	//   nhui, _zeve, ïnvl, _cái_,
   {{0x7bd98057,0x04431697,0x3aba80be,0x03a30d91}},	// [b20] _mewu, четн, ָמענ, зито,
   {{0x3d018d38,0x64bc0fda,0x443f8074,0x3f920300}},	//   ków_, _učio, hju_, _iyyu_,
   {{0x24891698,0x499a0a14,0x3d018035,0x645b9699}},	//   boam_, утая_, jów_, khui,
   {{0x7bd989b6,0x3d01809a,0x6e21813c,0x6f02969a}},	//   _newu, dów_, _aalb, ttoc,
   {{0x443f969b,0xf3ff80ab,0x645b969c,0x8bff80ab}},	//   dju_, ্যার_, dhui, ্যান_,
   {{0x4422059e,0x7c24169d,0x443f969e,0x6446169f}},	//   _hak_, ldir, eju_, _hoki,
   {{0x6f0296a0,0x44220988,0x644601e2,0x7bd996a1}},	//   stoc, _kak_, _koki, _bewu,
   {{0x44221308,0x7c24158a,0x644616a2,0xa3a980bc}},	//   _jak_, ndir, _joki, _गृह_,
   {{0x442216a3,0x35fa845b,0x6e2181e4,0x64460110}},	//   _mak_, _مراد_, _falb, _moki,
   {{0xc333004c,0x69d8820f,0x6e2196a4,0x6e9696a5}},	//   פות_, _qeve, _galb, _الطا,
   {{0x443f96a6,0x3d01809a,0x78b88713,0xa3b90006}},	//   bju_, ców_, _quvv, _चलल_,
   {{0x442216a7,0x443f8699,0x645b96a8,0x69de16a9}},	//   _nak_, cju_, chui, hape,
   {{0x7645003e,0x628896aa,0x69d896ab,0x69de16ac}},	//   _pohy, podo, _teve, kape,
   {{0x3dd900c8,0x7aef86a5,0x7c22810c,0xdce500e1}},	//   _তাহল, ácte, _haor, _vzhľ,
   {{0x69de16ad,0x64aa800d,0xe57300f7,0x66150102}},	//   dape, _přih, سطس_, rezk,
   {{0x386916ae,0x7c2416af,0x60c781d0,0x2fdd822c}},	//   _umar_, gdir, íjme, xawg_,
   {{0x7c2296b0,0x644616b1,0x27e903c3,0x442216b2}},	// [b30] _maor, _doki, _idan_, _dak_,
   {{0x443f84b7,0x7b7400f7,0xb9210870,0x765c16b3}},	//   zju_, أطفا, _gasị_, chry,
   {{0x7c2416b4,0xbebd96b5,0x672d03c1,0xf6520039}},	//   bdir, _trūk, _hraj, _חצי_,
   {{0x442216b6,0x7c228052,0x64bc005c,0x6e2196b7}},	//   _gak_, _naor, _očij, _salb,
   {{0x443f96b8,0x69de16b9,0xe73996ba,0x3d018035}},	//   vju_, bape, рел_, wów_,
   {{0xdb1d04b8,0x3d018063,0x6e2196bb,0xc332010f}},	//   _besö, tów_, _qalb, _קום_,
   {{0x443f96bc,0x442216bd,0xed5996be,0xf53280a9}},	//   tju_, _yak_, рой_, дејќ,
   {{0x3d018063,0x6e2182a3,0x7bdf16bf,0x7c2296c0}},	//   rów_, _walb, naqu, _caor,
   {{0x443f96c1,0x3d018063,0x6e2196c2,0x645b83b2}},	//   rju_, sów_, _talb, rhui,
   {{0xe9d985f1,0x27e916c3,0xda6580e8,0x443f96c4}},	//   шко_, _adan_, івни, sju_,
   {{0x69c196c5,0x26c9008e,0x443f96c6,0xd94596c7}},	//   rcle, _atao_, pju_, цени,
   {{0x672d16c8,0x60cd8267,0x69de16c9,0x1faa05f1}},	//   _braj, _čamd, zape, икни_,
   {{0x442216ca,0x7bdf16cb,0xb69b16cc,0x644616cd}},	//   _rak_, daqu, rtân, _roki,
   {{0x442216ce,0x8aa796cf,0x672d16d0,0xb69b16cc}},	//   _sak_, _уред, _draj, stân,
   {{0x442216d1,0xa3bd835a,0x644601ac,0x69de16d2}},	//   _pak_, _आला_, _poki, vape,
   {{0x69de16d3,0x7c228118,0xdb1d041c,0x7c240037}},	//   wape, _xaor, _lesõ, udir,
   {{0xe9da16d4,0x7c2416d5,0x20050201,0xf41282f6}},	// [b40] ика_, rdir, əli_, ופן_,
   {{0x442216d6,0x22478a53,0x7c2416d7,0x4996066c}},	//   _wak_, _jonk_, sdir, ошет,
   {{0x69de16d8,0x6da616d9,0x644616da,0x8c4616db}},	//   rape, _фина, _toki, _дене,
   {{0xdd0f0214,0x7c24011c,0x9f4800ff,0x7bdf16dc}},	//   lışt, qdir, _điêu_, caqu,
   {{0x9eaa8ba1,0xcfbc00ab,0x245c0061,0x4ea696dd}},	//   авда_, _অজান, _címe_, орка,
   {{0xe29716de,0x7c22808c,0x412a16df,0x7ae401a8}},	//   _мая_, _saor, _кого_, msit,
   {{0x910315e0,0xf9878f24,0xd90d019f,0x7ae400f7}},	//   _опре, _آب_, _میل_, lsit,
   {{0x7bc416e0,0xfd530091,0x6ee381bc,0x7ae416e1}},	//   nciu, _aifọ, _ọber, osit,
   {{0x69dc01f9,0x6fd08105,0x7ae416e2,0x224796e3}},	//   _kere, _ड्यू, nsit, _bonk_,
   {{0x245181a8,0x20000362,0x442482f7,0x7ae416e4}},	//   _lámh_, _acii_, sdm_, isit,
   {{0x69dc045c,0x224796e5,0x26c902a5,0x7bdf16e6}},	//   _mere, _donk_, _stao_, yaqu,
   {{0x69dc16e7,0x672d16e8,0x7ae416e9,0xe0cf87d2}},	//   _lere, _praj, ksit, کزی_,
   {{0x7648808e,0xfd530032,0x674701e2,0x2005066f}},	//   _kody, _fifọ, цэнз, ęli_,
   {{0x248980e1,0x7bc616ea,0x76488242,0x672d16eb}},	//   čame_, _afku, _jody, _vraj,
   {{0x7bdf00e7,0xa3c80135,0x2bc80133,0x764896ec}},	//   taqu, _ọbịa_, _ọjị_, _mody,
   {{0x672d16ed,0xd6db0364,0x69dc0081,0x67209351}},	//   _traj, _кто_, _aere, _osmj,
   {{0x69dc16ee,0x201916ef,0x7ae400e4,0x7bdf16f0}},	// [b50] _bere, mesi_, gsit, raqu,
   {{0x201916f1,0x661896f2,0x69dc079a,0x7bc401e8}},	//   lesi_, jevk, _cere, aciu,
   {{0x69dc005f,0x7bdf16f3,0xc0158009,0x7d0d8035}},	//   _dere, paqu, змещ, łasz,
   {{0x765a96f4,0x201916f5,0x78bc16f6,0x7ae416f7}},	//   _alty, nesi_, _durv, bsit,
   {{0x2ca916f8,0x27e0807b,0x69dc16f9,0x7bdd02f9}},	//   mmad_, ðina_, _fere, _iesu,
   {{0x69dc16fa,0x7bdd16fb,0x518716fc,0x2ca916fd}},	//   _gere, _hesu, _дуба, lmad_,
   {{0xdfd596fe,0x7bdd0859,0x69c516ff,0xdb1b81df}},	//   _новы, _kesu, mche, rcuí,
   {{0x69c51700,0x7bdd1701,0x0b458081,0x7d7c00be}},	//   lche, _jesu, знин, ינוו,
   {{0x2bdc0076,0x7bdd1702,0x69dc1703,0x76d580f7}},	//   बरता, _mesu, _yere, _رياض,
   {{0x69dc1704,0x7bdd1705,0x69c51706,0x09af00ab}},	//   _xere, _lesu, nche, _চ্যা,
   {{0x69c51707,0x20191708,0x2c0c0054,0xdcef8084}},	//   iche, fesi_, ड्डू_, _įdėt,
   {{0x2458837d,0x7bdd01e2,0x315600be,0x20191709}},	//   _téma_, _nesu, פירן_, gesi_,
   {{0x2451970a,0x64aa81d0,0x2905970b,0x69cc970c}},	//   _námi_, _přiv, stla_, _द्वी,
   {{0xfe79801b,0x6e25170d,0x69c5170e,0x68e7082c}},	//   _svůj_, _cahb, jche, _ovjd,
   {{0x61e18364,0x2019026e,0x386d970f,0x7bdd1710}},	//   mall, besi_, _omer_, _besu,
   {{0x7ae41711,0x20191712,0x61e19713,0x248d81b0}},	//   tsit, cesi_, lall, noem_,
   {{0x69dc1714,0x7bdd006a,0x7bc40019,0x2d9e026f}},	// [b60] _pere, _desu, rciu, ťte_,
   {{0x7bc40098,0xba231715,0x27e200dd,0x78bc0612}},	//   sciu, ндук, lakn_, _purv,
   {{0x7ae41716,0x76488110,0xda0204c5,0x7bc41717}},	//   ssit, _rody, र्गत_, pciu,
   {{0x69dc1718,0x61e19719,0x7bdd171a,0x7ae4171b}},	//   _were, hall, _gesu, psit,
   {{0x61e1971c,0x387f816d,0xddcf801b,0x69c5171d}},	//   kall, _djur_, _řeše, bche,
   {{0x69c50098,0x78bc037b,0x61e1971e,0x7bdd09b6}},	//   cche, _turv, jall, _zesu,
   {{0x2019171f,0x20c18104,0x7bdd1720,0x7c261721}},	//   yesi_, _nói_, _yesu, _kakr,
   {{0x321a009a,0x9e66826a,0x7bdd03a8,0xadc30032}},	//   lepy_, _کارن, _xesu, _diẹd,
   {{0x66188038,0x61e19722,0x6720920e,0x20191723}},	//   pevk, fall, _usmj, vesi_,
   {{0x20191724,0x61e19725,0x7aef9726,0xe3bf1727}},	//   wesi_, gall, ácta, _maña_,
   {{0x20191728,0x60cd82a5,0x6e251729,0x69c3007a}},	//   tesi_, _čamc, _rahb, žneg,
   {{0x78a4172a,0x7c26172b,0x7ac6841c,0xe3a78019}},	//   _chiv, _nakr, _еске, _کشمی,
   {{0x2bd29513,0x61e1972c,0x2019172d,0xaa7b01d0}},	//   _ध्या, ball, resi_, _svým,
   {{0x7bdd0393,0x4426972e,0x61e1972f,0x80d200ab}},	//   _sesu, _hao_, call, _হিন্,
   {{0x4426803a,0x20c1801c,0x7bdd08e5,0x20191730}},	//   _kao_, _gói_, _pesu, pesi_,
   {{0x7c260cc0,0x9584009a,0xbebd96b5,0x6e2500b9}},	//   _cakr, _łącz, _krūt, _wahb,
   {{0xd6d78a49,0x4426951e,0x69c51731,0xe3bf06a5}},	// [b70] _সম্প, _mao_, tche, _caña_,
   {{0x44269732,0x27e08125,0x69c51733,0x386d9734}},	//   _lao_, ðinn_, uche, _smer_,
   {{0x69c506f8,0x7bdd1735,0x291906e2,0xfaa801a8}},	//   rche, _tesu, تقاد_, أهلي_,
   {{0x69c51736,0x44269737,0xd75980f7,0x61e19738}},	//   sche, _nao_, يلات_, zall,
   {{0x44291739,0x4439173a,0x69c5173b,0x61e1973c}},	//   mda_, _ins_, pche, yall,
   {{0x4439173d,0x7c260491,0x5fce8327,0x61e1973e}},	//   _hns_, _zakr, हुबल, xall,
   {{0x442902a3,0x44268028,0xc10515a9,0x7c3a0174}},	//   oda_, _bao_, _توزي, _úcrá,
   {{0x4429173f,0x44268104,0x61e19740,0xf53800be}},	//   nda_, _cao_, wall, לטור_,
   {{0x61e1855b,0x27ed9741,0xdb0982d0,0x20c18129}},	//   tall, _iden_, _önüm, _sói_,
   {{0x44291742,0x81bc81a9,0x25a0928a,0x7ea01743}},	//   hda_, ldēj, řila_, köpa,
   {{0x44391744,0x44291745,0x26cd82ee,0x61e19746}},	//   _ons_, kda_, _hteo_, rall,
   {{0x61e19747,0x44291748,0xd36e8077,0x2fdf867f}},	//   sall, jda_, اهی_, _jeug_,
   {{0x442912a8,0x61e19749,0xe28e974a,0xbebd80eb}},	//   dda_, pall, _аа_, _grūt,
   {{0x4439174b,0x4429174c,0x4426822e,0x6da609b8}},	//   _ans_, eda_, _zao_, дига,
   {{0x4426822e,0x7afb84a2,0x7c260110,0x27e200dd}},	//   _yao_, luut, _pakr, pakn_,
   {{0x4429174d,0x26cd825b,0x5ed380ab,0x442680ff}},	//   gda_, _oteo_, _সিনে, _xao_,
   {{0x1e860615,0x644b974e,0xeb97174f,0x7c299750}},	// [b80] _олим, _mogi, дит_, ider,
   {{0x44391751,0x44261752,0x645d1753,0x7c26004f}},	//   _ens_, žo_, _elsi, _wakr,
   {{0x44291754,0x661c1755,0x27e00352,0x7c261756}},	//   bda_, merk, _kein_, _takr,
   {{0x7c299757,0x7afb9758,0x442902a3,0x3ebf9759}},	//   jder, kuut, cda_, _buut_,
   {{0x27e00352,0x44268028,0x2fdf81e4,0xdd8f00d7}},	//   _mein_, _rao_, _deug_, _موی_,
   {{0x4426975a,0x27ed975b,0x7c29975c,0x27e0031d}},	//   _sao_, _eden_, eder, _lein_,
   {{0xda0e80ff,0x2ee680b9,0xa3aa01d0,0xa3cb175d}},	//   _bỏng_, ssof_, गेर_, रुव_,
   {{0xe9a3175e,0x6724175f,0x644b9760,0x27e010f6}},	//   _расп, _osij, _cogi, _nein_,
   {{0x1dcf863a,0x60cd8289,0x7afb9761,0x44269762}},	//   _स्वत, _čama, guut, _vao_,
   {{0x4426822e,0x2489805c,0xdb22809a,0x64aa801b}},	//   _wao_, čama_, _źród, _přis,
   {{0x44269763,0x09f70051,0x44291764,0xd48f8012}},	//   _tao_, ומים_, yda_, _ар_,
   {{0x442902a3,0xdbd604a2,0x7afb9765,0x26c0047f}},	//   xda_, _jääd, buut, _buio_,
   {{0x27e002af,0xfe730154,0x26c00118,0x6e2880b9}},	//   _dein_, ندس_, _cuio_, _kadb,
   {{0x44390eef,0x661c1766,0x44291767,0x63a29768}},	//   _sns_, gerk, wda_, _izon,
   {{0x44290085,0x27e01769,0x44390b99,0x6fde8006}},	//   tda_, _fein_, _pns_, मरां,
   {{0xd5b8176a,0xaa7b026f,0x7af60168,0x4429176b}},	//   ься_, _zvýh, fryt, uda_,
   {{0x6e3a83b2,0xa3aa016f,0xf0940039,0xfc3f0216}},	// [b90] _ontb, गेल_, _בנק_, _chía_,
   {{0x4429176c,0x6e28976d,0x27e0011e,0x7674176e}},	//   sda_, _nadb, _zein_, _альф,
   {{0x7c29976f,0x80e080ab,0x66051770,0xdb0d016a}},	//   yder, পূর্, _ichk, rcañ,
   {{0x44291771,0x44391772,0x245c0125,0x7af61773}},	//   qda_, _uns_, _tíma_, bryt,
   {{0x6e288079,0x22940106,0x6d550061,0xa3c29774}},	//   _badb, täkt_, lyza, ंशन_,
   {{0xe5a58e8e,0xceb8809a,0x603e8087,0x6da59775}},	//   нили, _cię_, _pămâ, нила,
   {{0x63a28065,0x61e51776,0xdc3a82d0,0x2ca68706}},	//   _azon, mahl, _açıs, _bhod_,
   {{0x03259777,0x27ed8022,0x69ca9778,0x61e51779}},	//   един, _uden_, _affe, lahl,
   {{0x7c29977a,0x27e0177b,0xe61082e3,0x661c177c}},	//   rder, _rein_, _چشم_, yerk,
   {{0x27e0177d,0x7c299045,0x63a2977e,0x3945977f}},	//   _sein_, sder, _dzon, еног,
   {{0x661c088b,0x7afb9780,0x9f4200d7,0x644b838a}},	//   verk, suut, maké_, _togi,
   {{0xed56893f,0x661c1781,0xe7308065,0x6e288035}},	//   _אבער_, werk, _حصہ_, _zadb,
   {{0x661c1782,0x443e001c,0x3a2786c0,0x61e50234}},	//   terk, _đt_, _tanp_, kahl,
   {{0xe3bf1783,0x64bc1784,0x2cad9785,0x7ae99786}},	//   _baño_, _očit, lmed_, mset,
   {{0x40960676,0x61e5010b,0xa97980be,0x7ae99787}},	//   _прит, dahl, _מאַכ, lset,
   {{0x46ea0698,0xe3bf06a5,0xfc3f001c,0x7bc99788}},	//   _един_, _daño_, _phía_, nceu,
   {{0x7ae99789,0x9f4203f8,0x27450168,0x3860178a}},	// [ba0] nset, kaké_, _vënë_, _ilir_,
   {{0x7ae9978b,0x2cad978c,0x9f42026f,0x99858019}},	//   iset, hmed_, jaké_, lelő_,
   {{0x7ae99266,0xf77f041c,0x50ba0060,0x6e28978d}},	//   hset, maça_, سداد_, _radb,
   {{0xceb88610,0x27e0978e,0x2002178f,0xe3a7845b}},	//   _się_, úin_, ngki_, _مر_,
   {{0xe8050c28,0x2cad8074,0x61e51790,0x7ae99791}},	//   ष्टा_, dmed_, bahl, jset,
   {{0x7ae99792,0xf77f023e,0x9c7c80c3,0xae040072}},	//   dset, naça_, _ivči, श्चन_,
   {{0xf653010f,0x6e28807a,0x7ae99793,0xa9a301a1}},	//   רצו_, _vadb, eset, _бирд,
   {{0x7ae99794,0x25a081d0,0x2bd3001b,0x69a51795}},	//   fset, řilo_, धुपा, _करती,
   {{0x6e2883ac,0x087780be,0x3f8188c5,0x7ae99796}},	//   _tadb, _נעמט_, şhur_, gset,
   {{0x27e69797,0xdb2381a8,0x38601798,0x3eba1799}},	//   laon_, órái, _alir_, _nipt_,
   {{0x3860179a,0xd5a484e5,0x88bc801b,0x67d500e8}},	//   _blir_, _ओरिज, jvět, кону,
   {{0x248000ce,0x27e6979b,0x61e5179c,0xa3b103dd}},	//   jnim_, naon_, zahl, टेड_,
   {{0x24800025,0x64bc179d,0xe784179e,0x3ce30072}},	//   dnim_, _očis, гуро, टीने_,
   {{0xbb3b8451,0x09e380ab,0xfc3f00ff,0xe3bf0388}},	//   _מעדי, _মাথা, _chín_, _paño_,
   {{0xceb380be,0x321e9122,0x27e68bb1,0x89338481}},	//   טיש_, mety_, kaon_, _معيا,
   {{0xd49814d6,0x6d55009a,0x321e89a4,0x61e5179f}},	//   еру_, ryza, lety_, wahl,
   {{0x200c0201,0x29180037,0x09e38264,0xf77f02df}},	// [bb0] ədi_, _apra_, _মাতা, baça_,
   {{0x7afd809f,0x248017a0,0x9e6701a8,0xa15917a1}},	//   àsti, anim_, _ساخن, мазу_,
   {{0xa3e08fd5,0xdfd180f7,0x61e517a2,0xf7730019}},	//   थरा_, ليا_, rahl, _جاں_,
   {{0x24800052,0x1b1780ab,0x2918008e,0xddc88bcf}},	//   cnim_, তিতে_, _dpra_, _ćoša,
   {{0xd9ad97a3,0x321e826f,0x7c2d17a4,0x58b881a8}},	//   _घण्ट, kety_, mdar, رامج_,
   {{0x7c2d17a5,0x7ae997a6,0x442b17a7,0x644f17a8}},	//   ldar, vset, _hac_, _hoci,
   {{0x644f17a9,0x64aa800d,0x64bc17aa,0xfc3180f7}},	//   _koci, _přip, _učit, لحة_,
   {{0x2489881d,0x7ae997ab,0x63a217ac,0xf3ff02df}},	//   čamo_, tset, żone, _imãs_,
   {{0x644f17ad,0x1c4297ae,0x9f42003d,0x2cad97af}},	//   _moci, рным, paké_, rmed_,
   {{0xa77480e9,0x7ae997b0,0x248000ce,0x7c2d17b1}},	//   _случ, rset, znim_, hdar,
   {{0x320b809a,0x442b0980,0x7c2d17b2,0x09e38264}},	//   ęcy_, _oac_, kdar, _মাদা,
   {{0x442b0114,0x7c2d17b3,0x7ae997b4,0x26df8135}},	//   _nac_, jdar, pset, _kwuo_,
   {{0x7c2d17b5,0x442d8b0b,0xf8b28158,0xe813816f}},	//   ddar, mde_, ישט_, ण्या_,
   {{0xf1b1053f,0x23690035,0xa3d40072,0x99858061}},	//   जधान, dzaj_, सुन_, selő_,
   {{0x1d070dae,0xfc3f0118,0x442b17b6,0x7c2b97b7}},	//   кери_, _chío_, _bac_, _kagr,
   {{0x644f040e,0x7c2d020d,0x442b17b8,0xc48310ca}},	//   _coci, gdar, _cac_, алск,
   {{0x7c2b97b9,0xa3e317ba,0xc0530039,0x628186cb}},	// [bc0] _magr, _नजर_, _כזה_, onlo,
   {{0x248002a5,0x442d8364,0x7c2b97bb,0x60c397bc}},	//   snim_, hde_, _lagr, _kunm,
   {{0x442b0012,0x27e69049,0x442d97bd,0x7c2d17be}},	//   _fac_, taon_, kde_, bdar,
   {{0x442d97bf,0x38608013,0xd00f8eca,0x7e6197c0}},	//   jde_, óir_, قلم_, _allp,
   {{0x442d97c1,0xe1e784c0,0x442017c2,0x27e697c3}},	//   dde_, _پس_, mei_, raon_,
   {{0x442017c4,0x442d97c5,0x290c8085,0x765c17c6}},	//   lei_, ede_, ytda_, nkry,
   {{0x442d90f4,0x614317c7,0x3cfd801b,0xa8068256}},	//   fde_, _кера, रूले_, _извл,
   {{0x6abb0118,0x409597c8,0x78bb97c9,0x442b027d}},	//   _éufr, _брут, _giuv, _xac_,
   {{0x68e1013c,0x26df819d,0xd7078087,0x799c0114}},	//   _ældr, _gwuo_, _инте_, _hyrw,
   {{0x386680a9,0x7c2b97ca,0x442017cb,0x7c2d17cc}},	//   lhor_, _eagr, hei_, zdar,
   {{0x442017cd,0x26c497ce,0xdd1f81ac,0x5ec780ab}},	//   kei_, _humo_, píšt, রীদে,
   {{0xf9930051,0x386683a7,0x68e31735,0x7c2b80d7}},	//   ירת_, nhor_, ândi, _gagr,
   {{0x442017cf,0x6d588110,0x260980d4,0x321e89a4}},	//   dei_, lyva, _सामी_, pety_,
   {{0x7c2b97d0,0xdce50038,0x27e4802e,0x61e397d1}},	//   _zagr, _vyhľ, _lemn_, _genl,
   {{0x644f0a7a,0x241901bb,0x61e897d2,0x40350a08}},	//   _poci, новы_, madl, _бейс,
   {{0xfbd304c0,0x69ce0a0f,0x7c2d14e4,0x442017d3}},	//   شتر_, _afbe, udar, gei_,
   {{0x521517d4,0x386697d5,0x644f17d6,0x6d4a0706}},	// [bd0] лдат, dhor_, _voci, _àfan,
   {{0x442d97d7,0xf09f009f,0xa2c381a2,0x78bb8084}},	//   zde_, llà_, रदत्, _siuv,
   {{0xf770096c,0x442017d8,0x21270104,0x6d5d8201}},	//   _های_, bei_, ình_, _əsas,
   {{0x61e897d9,0xcfde80c8,0x24868a20,0x442017da}},	//   hadl, _ডাউন, _njom_, cei_,
   {{0x442d97db,0xd9e386a7,0x61e897dc,0xdbd102f1}},	//   vde_, _ग़लत_, kadl, _müüd,
   {{0x442d97dd,0x6abc0609,0x26c482ed,0x6a6001fa}},	//   wde_, _girf, _dumo_, _höfn,
   {{0x7c2b97de,0x2609816f,0x61e897df,0x442d97e0}},	//   _pagr, _साठी_, dadl, tde_,
   {{0x6281862d,0x61e397e1,0x290117e2,0x26c497e3}},	//   wnlo, _senl, muha_, _fumo_,
   {{0x442d97e4,0x60c397e5,0x7aed11e6,0x78660693}},	//   rde_, _sunm, nsat, _jóve,
   {{0x442d9313,0xb7bd802e,0x78660073,0x672997e6}},	//   sde_, _naţi, _móve, _isej,
   {{0x61e397e7,0x7c2b97e8,0x26c497e9,0x290117ea}},	//   _venl, _tagr, _zumo_, nuha_,
   {{0x44e181e2,0xbf9b0073,0x442017eb,0x6f1b8133}},	//   mų_, rgên, xei_, _kpuc,
   {{0x442017ec,0x7866007b,0x44e18110,0x7bdb97ed}},	//   vei_, _nóve, lų_, mbuu,
   {{0x249f97ee,0x290117ef,0x442017f0,0x38ca8077}},	//   llum_, kuha_, wei_, بایی_,
   {{0x44e181e2,0x765c17f1,0x7cd180eb,0x7afb84dc}},	//   nų_, rkry, _dārg, lrut,
   {{0x765c079f,0x78660e15,0xa3e68105,0x290117f2}},	//   skry, _bóve, _बड़ा_, duha_,
   {{0xfc3f003e,0x7aed17f3,0xcb6717f4,0x64a3076a}},	// [be0] _dní_, gsat, гате_, сата,
   {{0x442017f5,0x44e181e2,0xfeba0277,0x6b9d031d}},	//   sei_, kų_, _ثابت_, _dysg,
   {{0x44e181e2,0x629e17f6,0x442017f7,0x249f97f8}},	//   jų_, rlpo, pei_, klum_,
   {{0x8c4617f9,0x7afb97fa,0x44e18110,0x6abc17fb}},	//   _семе, krut, dų_, _wirf,
   {{0x09e800ab,0x7aed1380,0x7e788b67,0xe3b2015b}},	//   _পাঠা, csat, tivp, _درد_,
   {{0x2ca017fc,0x290117fd,0x6d588084,0xb5e20264}},	//   llid_, buha_, tyva, _বাঁচ,
   {{0x386697fe,0x2cc981ac,0x61e897ff,0x44e18110}},	//   phor_, _ľudí_, vadl, gų_,
   {{0x7afb9800,0x260981c4,0x7bdb9801,0x26c49802}},	//   frut, _साथी_, gbuu, _tumo_,
   {{0x68f5803e,0x3075831f,0x61e89803,0x41e68221}},	//   ázdn, _турс, tadl, ліна,
   {{0x471b80be,0x39148329,0xdbd10074,0xfd5d8870}},	//   _אומג, амор, _süüd, _jizọ,
   {{0x3de2150b,0x26098e18,0x69da9175,0x2ca00074}},	//   _বাংল, _साती_, rbte, klid_,
   {{0x7aed02a3,0xfc3f001c,0x7afb9804,0x3ebe9805}},	//   ysat, _phím_, brut, _hitt_,
   {{0x543b8158,0x7afb9806,0x61e89807,0xf77f03a7}},	//   _רעדא, crut, padl, raço_,
   {{0x26e5000f,0xcf9381c6,0x6d498035,0x6a60008b}},	//   _कबीर_, מטר_, ślał, _söfn,
   {{0x3ebe9808,0xf77f0073,0x6d4a07b6,0xf09f0980}},	//   _mitt_, paço_, _àfal, plà_,
   {{0x3ebe8cde,0x248d1809,0x7aed180a,0x2ca002f1}},	//   _litt_, čemo_, tsat, glid_,
   {{0x3a75180b,0x78ad180c,0xb27501a1,0x998c0b80}},	// [bf0] алар, _ihav, алаш, _ćoše_,
   {{0x7aef840e,0x7ed40013,0x5ed380c8,0x7bcd180d}},	//   ácti, _ازيا, _সিলে, scau,
   {{0x7aed180e,0x66758077,0xf1a7180f,0xc9841810}},	//   ssat, یدتر, уран, буци,
   {{0x29011811,0x2c27035f,0x7aed1812,0x2ca01813}},	//   ruha_, _сьог, psat, clid_,
   {{0xb8170768,0xe81701b6,0xf7459814,0x26009815}},	//   ध्यम_, ध्या_, рело, _राखी_,
   {{0x62830259,0x44e181e2,0x09df00ab,0x7bc28176}},	//   čnos, tų_, _ঢাকা, _agou,
   {{0x3ebe9816,0xd6580051,0x58d4153d,0x7ae29817}},	//   _ditt_, ריות_, _гост, _awot,
   {{0xeb999687,0x99840013,0x7afb9818,0x44e18110}},	//   кий_, _الفو, trut, rų_,
   {{0x6f1b8024,0x09e800ab,0xc8649819,0x6729981a}},	//   _upuc, _পাতা, _утри, _usej,
   {{0x6285181b,0x7cd18029,0x7afb981c,0x7c2f117e}},	//   nnho, _pārd, rrut, _lacr,
   {{0xa06a181d,0x61e7181e,0x888608cc,0x186a181f}},	//   вана_, _mejl, илож, вани_,
   {{0xb4c19094,0xfa2580c8,0x7cd18029,0x78ad1820}},	//   ंदी_, বাইল_, _vārd, _chav,
   {{0xe9ce9821,0x2ca01822,0x7ae29823,0x7d039824}},	//   _мк_, vlid_, _gwot, luns,
   {{0x442f9825,0x61e7000d,0x3ebe09df,0x6e239826}},	//   _hag_, _nejl, ött_, nenb,
   {{0x442f9827,0xc62800ab,0xfd5d81bc,0x7d039828}},	//   _kag_, মালা_, _rizọ, nuns,
   {{0x442f84b5,0xbc630ab5,0xa3ac8935,0x26c41829}},	//   _jag_, овск, _गरम_, ímos_,

   {{0xa3b1016f,0x62970118,0x91fc80eb,0x6e23982a}},	// [c00] टेल_, foxo, bkād, kenb,
   {{0xe9d700bf,0x442f982b,0x7ea0016d,0xd0e68fd3}},	//   ику_, _lag_, köpi, _حکیم_,
   {{0x3f9f982c,0x61e7013c,0x7d038669,0xa926182d}},	//   _ayuu_, _dejl, juns, рдел,
   {{0x442f982e,0x3ebe888b,0x7d03982f,0x60c7082c}},	//   _nag_, _sitt_, duns, _dujm,
   {{0x7c2407e1,0x61e71830,0x6e239831,0x2d9e9832}},	//   meir, _fejl, fenb, _syte_,
   {{0x7c241833,0xb4c19834,0x6e239835,0x7c2f012b}},	//   leir, ंदू_, genb, _zacr,
   {{0x394700f2,0x3ebe9836,0xddc8809a,0xafe68110}},	//   änst_, _vitt_, _podł, _вобл,
   {{0x7c24156b,0x442f9837,0x7ae28247,0x44321838}},	//   neir, _cag_, _pwot, ndy_,
   {{0x15e6000f,0x27e0807b,0x6e239839,0xd5b180ff}},	//   करार_, ðinu_, benb, _máy_,
   {{0x80ca8935,0x7d1e035f,0xf1aa0035,0x2d96983a}},	//   _संदे, _opps, _करान, _крес,
   {{0x3a370051,0x4432003e,0x442f983b,0xd57580e8}},	//   ברים_, kdy_, _fag_, _луць,
   {{0x442f983c,0x7c240ba3,0x69c3983d,0x1b1d0264}},	//   _gag_, jeir, _egne, নিতে_,
   {{0x7c24183e,0x4424983f,0x7ad486e2,0x629c1840}},	//   deir, mem_, _اقتص, _okro,
   {{0xa2c386a7,0x442f9841,0x78a2816b,0x443200e1}},	//   रदर्, _zag_, hlov, edy_,
   {{0x7c24031d,0x58871842,0x78a2816b,0xa4d5004a}},	//   feir, _выпа, klov, собі,
   {{0x44249843,0x61300117,0x78a28d11,0x7c241844}},	//   nem_, zólá, jlov, geir,
   {{0x78a29845,0x44249846,0x644d1847,0xa3b10035}},	// [c10] dlov, iem_, rjai, टें_,
   {{0x44249848,0x62851849,0xa3cb184a,0x6e23984b}},	//   hem_, unho, रुज_, xenb,
   {{0x4424984c,0x61e7013c,0x7c24184d,0x6285184e}},	//   kem_, _vejl, beir, rnho,
   {{0x7c24184f,0x60c084b9,0x27e91850,0x9ef581a8}},	//   ceir, _cimm, _jean_, مستش,
   {{0x44249851,0x6e239852,0x442f9853,0x2b470071}},	//   dem_, tenb, _rag_, _тэнг,
   {{0x64428307,0x442f9854,0x7d039855,0x672d004f}},	//   _anoi, _sag_, tuns, _msaj,
   {{0x442f9856,0x78a28b67,0x60c0807b,0x40358098}},	//   _pag_, blov, _fimm, _левс,
   {{0x44249857,0x7d039858,0x7cd180eb,0x213e00f7}},	//   gem_, runs, _pārb, _átha_,
   {{0x442f9859,0x6e23985a,0x7d03985b,0x753a8102}},	//   _vag_, penb, suns, _ertz,
   {{0x4432185c,0x442f985d,0x60c082af,0x7d038077}},	//   zdy_, _wag_, _zimm, puns,
   {{0x236d8063,0x442f8252,0x4424985e,0x2913011b}},	//   szej_, _tag_, bem_, ntxa_,
   {{0x4424985f,0x7c24184f,0x442f81c0,0x245c008b}},	//   cem_, xeir, _uag_, _tími_,
   {{0x7c240548,0x43749860,0x6d410502,0x6d5c0428}},	//   veir, _мушт, ålan, wyra,
   {{0xda0305b3,0x6d5c1861,0xa3bd1862,0x69c39863}},	//   _लागत_, tyra, ेखन_, _ugne,
   {{0x7c241864,0x78a29865,0x98a7928a,0x27e91866}},	//   teir, ylov, íně_, _fean_,
   {{0x27e91867,0x29059868,0x3fe609a5,0xe8171869}},	//   _gean_, mula_, _ужив, ध्दा_,
   {{0x2905986a,0x7c24186b,0x387d8114,0x64aa81d0}},	// [c20] lula_, reir, diwr_, _přiz,
   {{0x7c24186c,0x09e800ab,0x0f3701c6,0x200d8493}},	//   seir, _পাহা, _פריט_, _acei_,
   {{0x7d1e186d,0xed5a07ff,0xe8fa186e,0x27e900b9}},	//   _upps, _сон_, уле_, _yean_,
   {{0x4424986f,0x673b8ca3,0x3a259870,0x16058006}},	//   xem_, _bruj, help_, _राउर_,
   {{0x44249871,0x78a29872,0x29059873,0x7bc60122}},	//   vem_, rlov, hula_, _igku,
   {{0x78a29874,0x412a0cde,0x29059875,0xa3d40075}},	//   slov, _його_, kula_, सुर_,
   {{0x60c09876,0x26098701,0x7bc60122,0x9ac301b9}},	//   _timm, _सारी_, _kgku, ċċes,
   {{0x29059877,0xbf4d81d0,0x6d5900fc,0xafdb1277}},	//   dula_, _šířk, _ƙwaz, hjør,
   {{0xe7378364,0x53349878,0x673b9879,0x66e3987a}},	//   _лет_, цепт, _gruj, _нота,
   {{0x4424987b,0x3d190d38,0x6f060ebf,0x2905987c}},	//   sem_, _पहले_, dukc, fula_,
   {{0x2905987d,0x6e93987e,0x44248873,0x3a370039}},	//   gula_, _علما, pem_, זרים_,
   {{0x6ca6826a,0xc867187f,0x5edd0264,0xc95301c6}},	//   _اصطل, стои, _বিবে, למת_,
   {{0xa3bc9880,0x27e91881,0x26c1033e,0xb8ef86ae}},	//   _आणि_, _vean_, _piho_, _वू_,
   {{0x29058a40,0x63a29882,0xafdb00e8,0x161b8c28}},	//   bula_, _iyon, gjør, प्पर_,
   {{0x29059883,0x865b898a,0x63a2808e,0x280401d0}},	//   cula_, נדלי, _hyon, ásné_,
   {{0xd49b0912,0xd5d901ce,0x81c000ab,0x213f026c}},	//   ург_, _ब्रज, ীরা_, _čuh_,
   {{0x32550a13,0x672d004f,0x62889884,0x26099885}},	// [c30] овар, _usaj, ondo, _साली_,
   {{0x62889886,0x80db80ab,0x98bf0084,0xf8c9827d}},	//   nndo, _ভিত্, tytė_, _mẩn_,
   {{0x38691887,0x63a29888,0x62889447,0x09e80264}},	//   _klar_, _lyon, indo, _পাশা,
   {{0x629a9889,0xf77080d5,0x6e27188a,0x27e9988b}},	//   hoto, کام_, lejb, úan_,
   {{0xddc5835f,0x290594e6,0x2489188c,0x61f8988d}},	//   обли, zula_, mnam_, _odvl,
   {{0xe61890ac,0xdce8817b,0x38690722,0x673b81a1}},	//   йді_, _aydı, _llar_, _vruj,
   {{0xe80a00cf,0x38690201,0x69c7035f,0x2489188e}},	//   _वाला_, _olar_, _igje, onam_,
   {{0x06d880ab,0x63a28c56,0xe459988f,0x29058234}},	//   _সিরি, _byon, ржи_, vula_,
   {{0x24891890,0x29059891,0xf8c980ff,0x60ca81ec}},	//   inam_, wula_, _cẩn_, _aufm,
   {{0x29059892,0x629a9893,0x63a286c4,0x38691894}},	//   tula_, goto, _dyon, _alar_,
   {{0x6026076a,0xd8261895,0x63a29896,0x38691897}},	//   одна, одни, _eyon, _blar_,
   {{0x29059898,0x38691899,0xe73a07c4,0x27ef80dd}},	//   rula_, _clar_, аем_, nagn_,
   {{0x2905989a,0x63a28365,0x6235957b,0xde888133}},	//   sula_, _gyon, _меду, lịa_,
   {{0x2905989b,0x61ea989c,0x629a989d,0x2489189e}},	//   pula_, _gefl, coto, enam_,
   {{0xdd920a47,0x8c7a0081,0x2c6706ae,0x66010789}},	//   ذور_, ащат_, _sõda_, ólka,
   {{0x60c91482,0x69c700f1,0x69d501ed,0x2489189f}},	//   _čemp, _agje, _afze, gnam_,
   {{0xd46718a0,0x161b00d4,0xc88916a5,0x03a30729}},	// [c40] ците_, _पॉवर_, _دخول_, дито,
   {{0xae0e8aed,0xafdb054f,0x78a618a1,0x25ad06d4}},	//   _साधन_, ljøp, llkv, řela_,
   {{0x4fc698a2,0x38cb00d5,0x7cf081a8,0xc7c698a3}},	//   осла, لانی_, _mórá, осли,
   {{0xdca60e97,0x69da18a4,0x629a804f,0x09aa0072}},	//   _фами, _प्री, zoto, _करीय,
   {{0x41c9800c,0x644618a5,0x3ced0024,0x629a8010}},	//   रशास, _inki, ćeve_, yoto,
   {{0x72c30364,0x4733835f,0x6b849024,0xa3dc8072}},	//   _обяз, ьніс, _žigo, तुन_,
   {{0x629a98a6,0x26120074,0x78660118,0x68ed8035}},	//   voto, _तानी_, _nóvo, _ładn,
   {{0x69c7020f,0x7c3618a7,0x629a98a8,0x6ab298a9}},	//   _zgje, ndyr, woto, ँग्र,
   {{0x3ce9803b,0x629a82b8,0x38690362,0x3e6b8163}},	//   ćava_, toto, _rlar_, _søte_,
   {{0x2489105e,0xd25a80c4,0x24800079,0x7afd98aa}},	//   znam_, рци_, hiim_, ásta,
   {{0xaca401bc,0x2bac8424,0x628884fe,0x64460198}},	//   _alọt, _चरवा, rndo, _onki,
   {{0x0b4698ab,0x7ea00106,0x63a298ac,0x6f0298ad}},	//   _мнен, köps, _tyon, oroc,
   {{0x629a8c93,0x60c418ae,0x628f8866,0x06cc8264}},	//   poto, _diim, écoc, রীরি,
   {{0x5edd00ab,0x628e026c,0x22580102,0x644618af}},	//   _বিদে, _njbo, _nork_, _anki,
   {{0xd7fb18b0,0x64c518b1,0x60c418b2,0x6b60826b}},	//   _куп_, वदेश, _fiim, _fágú,
   {{0x38690458,0xd14b004e,0x60c418b3,0x6f0298b4}},	//   _ular_, یشان_, _giim, kroc,
   {{0x248918b5,0x3f8c0085,0x27ef98b6,0x22580d05}},	// [c50] rnam_, şdur_, vagn_, _bork_,
   {{0xe80d85b3,0x644618b7,0x9388102a,0xe817064a}},	//   _हाहा_, _enki, іста_, ध्रा_,
   {{0xf7d88133,0x47d881bc,0xb11301bc,0x7ea4823e}},	//   _ịrụp, _ịzụk, pụmk, còpi,
   {{0xb8f318b8,0xc95380be,0x6f028037,0x2ee900fc}},	//   _हं_, ומע_, froc, _kwaf_,
   {{0x442918b9,0xe73998ba,0x6f0298bb,0x872781a8}},	//   mea_, сел_, groc, تعام,
   {{0x442918bc,0x27ef9277,0xb9010264,0x9605914f}},	//   lea_, sagn_, _দি_, रलेट_,
   {{0x308588ca,0x224998bd,0x3b0900b9,0x2fc902c4}},	//   _فلسف, _đak_, luaq_, _ogag_,
   {{0x442918be,0x6f0298bf,0x2fc90420,0x68ed8035}},	//   nea_, broc, _ngag_, _łado,
   {{0x4ea7838c,0xa3bd001b,0xeda8001b,0x225818c0}},	//   _држа, ेखि_, _गर्छ, _york_,
   {{0x28cf81b6,0x442918c1,0x27ed83b2,0xcb120496}},	//   _संदि, hea_, _heen_, עלי_,
   {{0x44290bec,0xd945919d,0x60c418c2,0x98a60087}},	//   kea_, чени, _piim, зине,
   {{0x26c5822e,0xc4d28039,0x442918c3,0x60c40079}},	//   _hilo_, _נגד_, jea_, _qiim,
   {{0x442918c4,0x60c418c5,0xeb8e98c6,0x27ed98c7}},	//   dea_, _viim, _чи_, _meen_,
   {{0xc4c60013,0xd35684de,0x27ed98c8,0xbb3a82f6}},	//   كترو, _מיני_, _leen_, _לעני,
   {{0xceb28051,0xc1aa009a,0x442918c9,0x44f701b9}},	//   גים_, _करेग, fea_, għ_,
   {{0x7c2998ca,0x26c584be,0x442918cb,0x6f0298cc}},	//   neer, _lilo_, gea_, yroc,
   {{0x2ee900fc,0x20120a03,0x2d850866,0x26c58f3e}},	// [c60] _gwaf_, _icyi_, ûler_, _oilo_,
   {{0x628198cd,0x26c590ab,0x7c2998ce,0x69de8074}},	//   nilo, _nilo_, heer, _õpet,
   {{0x2366003b,0x27ed98cf,0x7c2998d0,0x35a618d1}},	//   šoj_, _been_, keer, _ханг,
   {{0x69c388fd,0x225818d2,0x442918d3,0xc18c80be}},	//   _रणनी, _work_, cea_, סטאָ,
   {{0x628198d4,0xbea68160,0x225818d5,0x7c2998d6}},	//   kilo, падк, _tork_, deer,
   {{0x6b8907ca,0x98ac880a,0x26c580c3,0xa3b10054}},	//   _þega, ılır_, _cilo_, _ओरत_,
   {{0x7c2998d7,0x628198d8,0x26c598d9,0x645998da}},	//   feer, dilo, _dilo_, _bowi,
   {{0x27ed98db,0x7c2998dc,0x629e18dd,0x67240267}},	//   _geen_, geer, lopo, _opij,
   {{0x6459809a,0x26c598de,0x61ee18df,0xd00f98e0}},	//   _dowi, _filo_, _kebl, _حلق_,
   {{0x442918e1,0x628198e2,0x25a58b64,0x26c589c4}},	//   zea_, gilo, _fyll_, _gilo_,
   {{0x7c298c56,0x764898e3,0x442918e4,0x61ee009a}},	//   beer, _indy, yea_, _mebl,
   {{0xa3e6800f,0x629e18e5,0x7c298a0f,0x27ed01df}},	//   _बजट_, hopo, ceer, úen_,
   {{0xb8d398e6,0x6a600125,0x629e18e7,0x765a98e8}},	//   _जी_, _höfu, kopo, _koty,
   {{0xcad78051,0x628198e9,0x61ee0084,0x20f8026c}},	//   _צוות_, cilo, _nebl, kči_,
   {{0x442918ea,0x765a98eb,0x20f8050b,0x629e0cd9}},	//   tea_, _moty, jči_, dopo,
   {{0xa3d4000d,0x81e900ab,0x4fc70fe6,0xea0000ff}},	//   सँग_, _যাই_, _эска, _đạn_,
   {{0x442918ec,0xe7e30d38,0x261a035a,0x245818ed}},	// [c70] rea_, _क्या_, म्ही_, чать_,
   {{0x32d2801c,0x765a98ee,0x61fc0122,0x7d0a88ae}},	//   _mây_, _noty, _cdrl, kufs,
   {{0x442918ef,0x80a404c0,0x30158009,0x26c58122}},	//   pea_, _زمین, ддер, _rilo_,
   {{0x2c090077,0x7c2998f0,0x5ee18264,0x9f4b18f1}},	//   _بعدی_, xeer, _নিবে, hací_,
   {{0x7c2998f2,0x61ee18f3,0x2ca918f4,0x67f80019}},	//   veer, _febl, mlad_, lújí,
   {{0x2ca918f5,0xe5a598f6,0x645998f7,0x7c2998f8}},	//   llad_, мили, _sowi, weer,
   {{0x64598d38,0x765a98f9,0x7c2998fa,0x27ed98fb}},	//   _powi, _doty, teer, _teen_,
   {{0x386680f2,0x61e48eef,0x32d2801c,0xccf8801b}},	//   ckor_, _đila, _bây_, _dvě_,
   {{0x7c2998fc,0x06e200c8,0x628198fd,0x32d28028}},	//   reer, _বিভি, tilo, _cây_,
   {{0x7c2998fe,0xe8f998ff,0x32d2801c,0x2ca91900}},	//   seer, оло_, _dây_, hlad_,
   {{0x62818c6e,0x2ca91901,0xa6dd00c8,0x7c299902}},	//   rilo, klad_, _বিষয়, peer,
   {{0x6d419903,0x200f9904,0x06e200ab,0x1de61905}},	//   _irla, nggi_, _বিবি, कर्ष_,
   {{0x28cf80bc,0x32d28028,0x2ca91906,0x6279816b}},	//   _संवि, _gây_, dlad_, dňov,
   {{0x5edd00c8,0x248d9907,0x7cd50110,0x753c01d0}},	//   _বিশে, lnem_, _sąra, tvrz,
   {{0x64a61908,0xddd8811f,0x248d9909,0x6da30fe7}},	//   дава, nivš, onem_, вира,
   {{0x248d990a,0x161f0bb8,0x629e190b,0x4e1f03a4}},	//   nnem_, म्बर_, wopo, म्बई_,
   {{0xa5a485e8,0x64a31444,0x3ced0067,0xf1fa190c}},	// [c80] _चुनौ, тата, ćeva_, قعات_,
   {{0x9f44803e,0x7cd180eb,0x1e83012f,0x386d8580}},	//   _nemá_, _pārl, _альм, _aler_,
   {{0x629e190d,0x85bb0065,0x2ca9190e,0x20f8190f}},	//   ropo, _واپس_, blad_, uči_,
   {{0x20d38028,0x61ee1910,0x7bcb803d,0x248d9911}},	//   _mãi_, _webl, _nggu, jnem_,
   {{0x248d9640,0x6d419912,0x629e1913,0x38669914}},	//   dnem_, _arla, popo, rkor_,
   {{0x38669915,0x2ca01916,0xa3bd0540,0x7bcb9917}},	//   skor_, loid_, ेखर_, _aggu,
   {{0x386d9918,0x9f4b03cb,0xceb30158,0xa06a9071}},	//   _fler_, vací_, דיג_, _дава_,
   {{0x38b58e23,0x7d0a81ec,0x60cd826c,0xe0438dca}},	//   gård_, rufs, _čamp, _инси,
   {{0x6d419919,0x27e6991a,0xc5f400ab,0xd62680f7}},	//   _erla, mbon_, _জানা_, _يعطي,
   {{0x20d380ff,0x78a4191b,0x27e6811b,0xd90e815b}},	//   _bãi_, _akiv, lbon_, لیت_,
   {{0x248d991c,0xddd88699,0x9f4b03c1,0x20d380ff}},	//   bnem_, civš, rací_, _cãi_,
   {{0x32d28028,0x27e68bfe,0xfe0e8424,0x20d3827d}},	//   _tây_, nbon_, _साँस_, _dãi_,
   {{0x7c22991d,0x80ca87e6,0x2ca9191e,0x2905991f}},	//   _ibor, _संके, vlad_, arla_,
   {{0x2ca91920,0x2005061c,0x6456022c,0x7ea4823e}},	//   wlad_, şli_, ejyi, còpt,
   {{0xda659921,0x6279816b,0x44220cdb,0x200f808b}},	//   _ثاني, tňov, _bbk_, yggi_,
   {{0x8af00086,0x6e3702a3,0x290c9922,0x2ca002c4}},	//   yyət, _waxb, muda_, goid_,
   {{0xfe0e8fd5,0x290c9923,0x7b180198,0x291801b9}},	// [c90] _सांस_, luda_, мотр_, _aqra_,
   {{0xd5a48117,0x248d9924,0xe3b001a8,0x627984e8}},	//   _نہ_, znem_, شرق_, sňov,
   {{0x7c229925,0x6279826f,0x38b21926,0x7cd181a9}},	//   _obor, pňov, lára_, _pārm,
   {{0xddd8812b,0x5f959927,0x5f008074,0x4422008e}},	//   vivš, ниет, _रिश्_, _gbk_,
   {{0xf6259928,0x248d8353,0x7c2d1929,0x38b5816d}},	//   едло, vnem_, mear, vård_,
   {{0x4439192a,0xddd8812b,0x7c2d192b,0x645d038a}},	//   _has_, tivš, lear, _hosi,
   {{0x44390f29,0x248d8353,0xe5a280e8,0x79a4018b}},	//   _kas_, tnem_, лиши, _арте,
   {{0x645d192c,0x7c2d192d,0x6285192e,0x387f8397}},	//   _josi, near, liho, _umur_,
   {{0x4439022c,0x248d992f,0x9985801b,0x6d4301a1}},	//   _mas_, rnem_, telů_, _šnal,
   {{0x44391930,0x7c2d008c,0x78a40e23,0x38b21931}},	//   _las_, hear, _skiv, dára_,
   {{0x290c9932,0x6d419933,0x60c99934,0x443908dc}},	//   guda_, _urla, _kiem, _oas_,
   {{0x60c98110,0x7aeb81c0,0x6a6d80e1,0x20d38129}},	//   _jiem, _twgt, _dúfa, _vãi_,
   {{0xe28e9935,0x60c985b4,0x442d9936,0x7c2d1937}},	//   _ба_, _miem, mee_, dear,
   {{0x442d9938,0x786605b4,0x60c99939,0x4422193a}},	//   lee_, _móvi, _liem, _sbk_,
   {{0x4439193b,0x6fa0146d,0x645d0114,0x27ff90ab}},	//   _bas_, _गुरू, _bosi, _odun_,
   {{0x4439193c,0x442d993d,0x60c9993e,0x7c2d193f}},	//   _cas_, nee_, _niem, gear,
   {{0x44391940,0x645d1941,0x7c39831d,0x644b80dd}},	// [ca0] _das_, _dosi, _mawr, _mngi,
   {{0x442d9942,0x27ff85a3,0x6aa1831d,0xae0e809a}},	//   hee_, _adun_, nolf, _साइन_,
   {{0x442d9943,0x26d2022e,0x44391944,0x7c2d1945}},	//   kee_, _huyo_, _fas_, bear,
   {{0x645d0870,0x60c99946,0x7c2d1947,0x78660118}},	//   _gosi, _ciem, cear, _bóvi,
   {{0x765e1948,0x442d9949,0xe818000f,0x3a380110}},	//   _kopy, dee_, _थाना_, _tarp_,
   {{0x4420194a,0x644b994b,0x27ff994c,0x27e6994d}},	//   lfi_, _angi, _edun_, sbon_,
   {{0x442d8135,0x4439194e,0x7ae4194f,0x69ce10ab}},	//   fee_, _yas_, lpit, _igbe,
   {{0x8fa69950,0x442d9951,0x44390069,0x7c3b820d}},	//   _забе, gee_, _xas_, gdur,
   {{0x7ae41952,0x7c399953,0xddcf81d0,0x44200286}},	//   npit, _dawr, řešn, ifi_,
   {{0x60c99954,0x290c9955,0x442009ca,0x644b9956}},	//   _ziem, tuda_, hfi_, _engi,
   {{0xd48f94b7,0x69ce0133,0x06d88264,0xa1949957}},	//   _бр_, _mgbe, _সিটি, танч,
   {{0x290c9958,0x7ae41959,0x7c22995a,0x442d995b}},	//   ruda_, kpit, _ubor, cee_,
   {{0x69dc040e,0x645d195c,0x26d205a4,0xc6f80221}},	//   _ofre, _rosi, _cuyo_, ннях_,
   {{0x62850144,0x2b400824,0x6e2e0061,0xb9068264}},	//   xiho, dvic_, gebb, _পি_,
   {{0x4439195d,0xa8a71264,0x4420195e,0x7c2d195f}},	//   _pas_, _прик, ffi_, tear,
   {{0x44391960,0x69dc1961,0x69ce10ab,0xa01b0106}},	//   _qas_, _afre, _agbe, rnös,
   {{0xe4ed023c,0x7c2d1962,0x60c99963,0x7cd180eb}},	// [cb0] _जबकि_, rear, _riem, _pārk,
   {{0x44391964,0x60c99965,0x7c2d1966,0x442d9967}},	//   _was_, _siem, sear, zee_,
   {{0x44391968,0x60c99969,0x442d996a,0x645d0364}},	//   _tas_, _piem, yee_, _tosi,
   {{0x443910af,0x6285196b,0x69ce0091,0xdddc0110}},	//   _uas_, siho, _egbe, mirš,
   {{0xd366996c,0x6f1d196d,0xb8d80105,0xab87196e}},	//   _ئه_, ntsc, _घी_, _чунк,
   {{0x442d996f,0x6d4a00f7,0x6f1d0192,0x60c99970}},	//   wee_, _áfac, itsc, _wiem,
   {{0x60c99971,0x442d9972,0x6e3a831d,0x78a2826c}},	//   _tiem, tee_, _datb, boov,
   {{0xdd8e8013,0x20d7007e,0x6e3a82c4,0xa8a49973}},	//   توى_, _içi_, _eatb, _брук,
   {{0x2ba705e8,0x36d5835f,0x442d8051,0x2612154b}},	//   _कुमा, _розр, ree_, _ताली_,
   {{0x6f0f1974,0x39459594,0x442d9975,0xcb1400be}},	//   ducc, вног, see_, אלץ_,
   {{0x442d9976,0x26d21977,0x44201978,0x35558277}},	//   pee_, _suyo_, yfi_, _جناز,
   {{0xcc148077,0x644b9979,0x6e2e03f7,0x60dc802a}},	//   _مذهب, _ungi, webb, írma,
   {{0xa3a8816f,0x6e2e197a,0x69c390a1,0x547a81c6}},	//   _खुप_, tebb, _रणवी, _קטנו,
   {{0x27f202a3,0x2cad8051,0x6d4500dd,0xdee3197b}},	//   _weyn_, lled_, _brha, рори,
   {{0xe5a61401,0x7afd197c,0x6e2e0698,0x6da6018b}},	//   тиви, _avst, rebb, тива,
   {{0x64be0778,0xb4ac016f,0x26d2197d,0x7f44197e}},	//   ्देश, गते_, _tuyo_, _triq,
   {{0x4420197f,0xe3631980,0x7d0e1981,0x6d4502af}},	// [cc0] rfi_, акти, subs, _erha,
   {{0x2cbf9982,0x2cad801b,0x63ab82c4,0x7ae41983}},	//   hmud_, hled_, _mygn, rpit,
   {{0x2ba70076,0x6e3c9984,0xa3ea02c7,0x7ae41985}},	//   _कुठा, _órbi, _одна_, spit,
   {{0xdee68ba1,0x66e69986,0x248202f7,0x7afb9987}},	//   води, вода, _umkm_, ksut,
   {{0x44fe01e2,0x2cad8428,0x628381d6,0x6e3a89c4}},	//   lį_, dled_, _omno, _patb,
   {{0x24921988,0x2cad822b,0xb7d280ab,0x20ee81d0}},	//   lnym_, eled_, ারেট, yři_,
   {{0x44fe01e2,0xda188076,0x660101fa,0x6e3a9989}},	//   nį_, _दाबत_, ólki, _vatb,
   {{0x2492198a,0x386002be,0x63ab8bc5,0x39470366}},	//   nnym_, _noir_, _bygn, ænse_,
   {{0x63ab8358,0x7afb998b,0xaec68196,0xa7a7998c}},	//   _cygn, gsut, _абал, _акта_,
   {{0x63ab816d,0x44fe0084,0x3860198d,0xf8ca027d}},	//   _dygn, kį_, _aoir_, _mẩu_,
   {{0xd6e200c8,0x2617998e,0x2cad8039,0x38600706}},	//   _বিষয, _नाती_, bled_, _boir_,
   {{0x2cad998f,0x38600635,0xb4ac016f,0x6f0f01e8}},	//   cled_, _coir_, गतो_, tucc,
   {{0x44269990,0xf8bf02be,0x24920dee,0x38600706}},	//   _ibo_, rmé_, dnym_, _doir_,
   {{0x6f1d1991,0x6f0f05dc,0x2c75013c,0xb7e3085d}},	//   rtsc, rucc, _måde_, _क्रम_,
   {{0x26cc9992,0x7cd180eb,0x2bc51993,0x6f1d1994}},	//   _mido_, _pāri, लेना, stsc,
   {{0x48150139,0x91f282f1,0x588701e5,0x38601995}},	//   _смис, _आजुओ_, _шыла, _goir_,
   {{0x201e0086,0x44269996,0x09bd1107,0x9cc801e5}},	// [cd0] əti_, _mbo_, ्ख्य, тыра_,
   {{0x62889997,0x7afd8510,0x7ae28010,0x99671777}},	//   nido, ásti, _mtot, ктел,
   {{0xdfd18013,0x44269998,0x60cd1999,0x6729999a}},	//   ميا_, _obo_, _kiam, _spej,
   {{0x2c750f06,0x245881ac,0x4426999b,0x60cd199c}},	//   _både_, _témy_, _nbo_, _jiam,
   {{0x60cd199d,0xb8fa199e,0x26cc8135,0x160e816f}},	//   _miam, _डू_, _bido_, _साखर_,
   {{0x4426999f,0x7c3d19a0,0xa3e58beb,0x98b3817b}},	//   _abo_, _hasr, बुन_, ıdır_,
   {{0x62888510,0x261b0665,0xc2120039,0x6ed506b7}},	//   dido, _बानी_, _להם_, _यूसु,
   {{0x394999a1,0x60cd19a2,0x248919a3,0x26cc81df}},	//   _čas_, _niam, niam_, _eido_,
   {{0x408499a4,0x291e99a5,0x89f585a8,0x7c3181a1}},	//   _турб, etta_, лянц, _čerč,
   {{0x628899a6,0x386019a7,0x442699a8,0x7afb99a9}},	//   gido, _soir_, _ebo_, rsut,
   {{0x7afb99aa,0xe73c07d9,0x78bb81c0,0x60cd0176}},	//   ssut, _küçü, _khuv, _biam,
   {{0x60cd01e4,0x05a70105,0x442690ab,0x7c8499ab}},	//   _ciam, _गड़ब, _gbo_, _куче,
   {{0x386006e3,0x7e6199ac,0x60cd19ad,0x248919ae}},	//   _voir_, _kolp, _diam, diam_,
   {{0x62889313,0x443f99af,0x443d99b0,0x26cc8118}},	//   cido, ldu_, _haw_, _xido_,
   {{0x443d99b1,0x443f99b2,0xff1400ab,0x60cd19b3}},	//   _kaw_, odu_, িবেশ_, _fiam,
   {{0x60cd19b4,0x38b90019,0x44fe0110,0x7c3d01b4}},	//   _giam, tére_, rį_, _casr,
   {{0x4bd9176a,0x443d8114,0x422619b5,0x3b071182}},	// [ce0] ться_, _maw_, лдав, лето_,
   {{0xe74719b6,0x78a619b7,0x443d8039,0x44fe0084}},	//   ções_, lokv, _law_, pį_,
   {{0x090619b8,0x9f520205,0x38b90019,0x26cc99b9}},	//   упен, _seyè_, sére_, _rido_,
   {{0x26cc99ba,0x38608125,0x78bb8548,0x443f816b}},	//   _sido_, ðir_, _chuv, jdu_,
   {{0x443f99bb,0x26cc99bc,0x443219bd,0x7e6199be}},	//   ddu_, _pido_, mey_, _bolp,
   {{0x0f370051,0x628883a8,0x7e6199bf,0x443f99c0}},	//   טרנט_, xido, _colp, edu_,
   {{0xe29707b6,0x60d50661,0xad268c2a,0x443d99c1}},	//   _сар_, _guzm, ارتو, _baw_,
   {{0xdd0401e2,0x443d8069,0x443219c2,0x7c2419c3}},	//   ūrėt, _caw_, ney_, nfir,
   {{0x62889313,0x443d99c4,0x26cc99c5,0xf743932a}},	//   tido, _daw_, _tido_, _лето,
   {{0x60cd19c6,0x59b804e5,0x7e6190dd,0xc3330051}},	//   _siam, _अरार, _golp, צות_,
   {{0x7c2419c7,0xc27b00be,0x291e8009,0x443f82a6}},	//   kfir, גריי, utta_, bdu_,
   {{0xf5378051,0x7cd18029,0x60cd0748,0x628899c8}},	//   _תנאי_, _pārv, _qiam, sido,
   {{0x443202a3,0x7c3d19c9,0x248919ca,0x442480b9}},	//   dey_, _rasr, viam_, mfm_,
   {{0xbb3b8158,0x2489009a,0x7ead80e1,0x35a986a7}},	//   _רעגי, wiam_, túpi, _चुड़,
   {{0x248919cb,0x60cd0069,0x61fa8201,0x7c2419cc}},	//   tiam_, _tiam, matl, ffir,
   {{0x61fa99cd,0x6d4899ce,0x44320079,0x644099cf}},	//   latl, _mrda, gey_, ndmi,
   {{0x248919d0,0x99900289,0x50b8006b,0xf77302e3}},	// [cf0] riam_, _čaša_, _حدود_, _داغ_,
   {{0x7cd18029,0x61fa99d1,0xbbd186b7,0x443f99d2}},	//   _kārt, natl, _हल्क, zdu_,
   {{0x394719d3,0x443f99d4,0x7c3d19d5,0x7e61867f}},	//   íns_, ydu_, _tasr, _rolp,
   {{0x26179880,0x61fa85b2,0x443219d6,0x644f19d7}},	//   _नाही_, hatl, cey_, _unci,
   {{0x6d4899d8,0xe73999d9,0x443f99da,0x61fa99db}},	//   _arda, тел_, vdu_, katl,
   {{0xa5098fe6,0x8d6580af,0x26dc00be,0x61fa99dc}},	//   века_, ивле, עקומ, jatl,
   {{0xed5999dd,0x443d8e35,0x61fa99de,0x7e6199df}},	//   той_, _paw_, datl, _volp,
   {{0x443f99e0,0x3e7419e1,0xc60680ab,0xf0bb8fd3}},	//   udu_, _mäta_, ল্লা_, _سازش_,
   {{0xa3a8823c,0x443f99e2,0xfc3f07ca,0x290c85a4}},	//   _खुद_, rdu_, _maí_, erda_,
   {{0xc6a799e3,0x61fa99e4,0xea2490ab,0x2bd185fc}},	//   _срби, gatl, ẹ́rẹ, _हलका,
   {{0x443202c1,0x3ea799e5,0x443d99e6,0xf99180f7}},	//   yey_, mont_, _taw_, تبة_,
   {{0x18a60364,0x44320079,0x443f99e7,0x92a60035}},	//   рамм, xey_, qdu_, _załą,
   {{0x61fa899b,0xa3d919e8,0x290c99e9,0xbca499ea}},	//   batl, ाशन_, arda_, _امني,
   {{0x4b7a8158,0x443219eb,0x7ae999ec,0x200c0085}},	//   _באנו, wey_, mpet, şdi_,
   {{0x44320079,0x44f38087,0x8d630615,0xa3dc98a9}},	//   tey_, nţ_, овре, तुक_,
   {{0xb05b19ed,0x673b8bcf,0xd91a8e82,0x261219ee}},	//   lmän, _osuj, _סופל, _ताकी_,
   {{0x443219ef,0x7c2419f0,0x7ae999f1,0x3ea799f2}},	// [d00] rey_, rfir, npet, kont_,
   {{0x14b8016f,0xab2719f3,0x7bdf01e8,0xf2df00ff}},	//   _आठवण, рофа_, acqu, _trân_,
   {{0xd00f19f4,0x7f498388,0x33200372,0x261b0074}},	//   _علی_, _areq, stix_, _बाती_,
   {{0x03a600e8,0x8c4610ca,0x044619f5,0x09d2801b}},	//   _вимо, _теме, _темн, _सल्य,
   {{0x27e985b4,0x61fa83bf,0x6d48812b,0xbb4300e8}},	//   ñana_, yatl, _srda, _деяк,
   {{0x2913002a,0xa01b0198,0xa3e206ae,0x290c9388}},	//   buxa_, riöi, नुर_, yrda_,
   {{0x61fa99f6,0x442499f7,0xd49a99f8,0x261795bc}},	//   vatl, tfm_, кри_, _नारी_,
   {{0x61fa80dd,0x290c8140,0xa0678dc0,0x7f4999f9}},	//   watl, vrda_, _каса_, _freq,
   {{0x7f4980f1,0xc1788110,0xa06799fa,0x3ced192c}},	//   _greq, ybės_, _тата_, ćevi_,
   {{0xaa668d91,0x7cd180eb,0x09ca00ab,0x672299fb}},	//   ртик, _pārt, _ল্যা, mtoj,
   {{0x61fa99fc,0xfce38c3e,0xd2578e11,0x6d4899fd}},	//   ratl, _дохо, рцы_, _urda,
   {{0x67228110,0x7cd181a9,0x2c78826b,0x61fa99fc}},	//   otoj, _vārt, _béde_, satl,
   {{0x67229608,0x628001e2,0xb7141194,0xab838eef}},	//   ntoj, _įmon, одящ, _мушк,
   {{0xea000104,0x61fa811c,0xfc3f041c,0x67228a14}},	//   _đến_, qatl, _saí_, itoj,
   {{0xb2bb8051,0xa5f819fe,0x28d01862,0xbd680012}},	//   _שמור, ресу_, _संचि, арте_,
   {{0x2c7500f2,0x672299ff,0xdb0f016a,0xb8670019}},	//   _båda_, ktoj, _azcá, _خاتو,
   {{0x4aba8074,0x3a750088,0xaaba8105,0x67228168}},	// [d10] _उठाव, блар, _उठाक, jtoj,
   {{0x29130118,0x6d4300fe,0x3e740338,0xe7e300ba}},	//   tuxa_, _šnau, _täta_, कुरा_,
   {{0x2ba7000d,0xc5f20039,0xdd911a00,0x61f89a01}},	//   _कुरा, _מדי_, _روح_, _mevl,
   {{0x20190455,0x31578158,0x272086c0,0x67228168}},	//   ngsi_, ייבן_, fòn_, ftoj,
   {{0xf7459a02,0xb4b300d4,0xc8d0016f,0x27209a03}},	//   село, टती_, _संघट, gòn_,
   {{0x2ca9062d,0x78a2803e,0xbb3a00be,0x14b5016f}},	//   load_, čova, _געשי, ंतवण,
   {{0xfbdb0076,0x3ea782be,0x442b1a04,0x28f802c7}},	//   _भलाम, ront_, _kbc_, _весь_,
   {{0x1ee7826a,0x7ae980ce,0x2901004f,0x4adb1a05}},	//   _نوری_, tpet, msha_, _बढाव,
   {{0x7cd18029,0x3ea78019,0x4aa9891d,0x7ae99a06}},	//   _pārs, pont_, лкин_, upet,
   {{0xfc3f800d,0x38bc9a07,0x78ad1a08,0x7aed8085}},	//   ží_, ríre_, _akav, _çatm,
   {{0x61f89a09,0x7ae99a0a,0x186a1324,0xa06a1a0b}},	//   _devl, spet, гани_, гана_,
   {{0xf9920039,0xb1138133,0x764181b4,0x29011a0c}},	//   לרי_, _kụzu, _haly, isha_,
   {{0x248d8341,0x3b098d69,0x76419a0d,0x7205803d}},	//   miem_, _село_, _kaly, _هوشم,
   {{0x78ad00d2,0x248d80eb,0x61f8874c,0xb05b0198}},	//   _ekav, liem_, _gevl, lmäl,
   {{0x442b1a0e,0xceb29a0f,0xd5b21a10,0xd9c580ab}},	//   _bbc_, פיל_, سفر_, _শ্রম,
   {{0x248d9a11,0x672281e2,0xb05b016d,0x6d4a0118}},	//   niem_, ytoj, nmäl, _áfam,
   {{0xe29a041c,0xe3ba1a12,0x045700f7,0xf1bf81d0}},	// [d20] гаа_, уба_, حلقة_, řád_,
   {{0x6f040e78,0x6f0483f2,0x248d9a13,0x76419a14}},	//   _ivic, šick, hiem_, _naly,
   {{0xfe370051,0x248d9a15,0x2b4b0326,0x64a60084}},	//   _פרטי_, kiem_, _ercc_, _гана,
   {{0x248d8341,0x91fc80eb,0x17fa80f7,0x6f041a16}},	//   jiem_, nkār, اراة_, _kvic,
   {{0x248d8029,0x501b0bea,0x76419a17,0xb4c4009a}},	//   diem_, רונו, _baly, एगी_,
   {{0x67229a18,0x1ae31a19,0xbea39a1a,0xa2e31a1b}},	//   rtoj, _хорм, пачк, _хорд,
   {{0x67228828,0x764181e2,0x261b1a1c,0x394a0580}},	//   stoj, _daly, _बासी_, _urbs_,
   {{0x248d9a1d,0x64440c56,0x7c361a1e,0x67228168}},	//   giem_, ndii, neyr, ptoj,
   {{0xa3a897ba,0x7cd181a9,0x3e799a1f,0x9e658061}},	//   _खुश_, _pārr, _sète_, _ڈالن,
   {{0x9e658013,0xc3330039,0x0665803d,0x78ad1a20}},	//   _والن, לוח_, _والپ, _skav,
   {{0xd0110199,0x6f029a21,0xa3a8852a,0x248d8ec3}},	//   ولد_, lsoc, _खुर_, biem_,
   {{0xc19b0158,0x248d9a22,0x764185ee,0x13b00264}},	//   רשטי, ciem_, _zaly, চেয়,
   {{0x61fe1a23,0x6f029a24,0x64441a25,0x5f940081}},	//   kapl, nsoc, ddii, зият,
   {{0x6f040267,0x64429a26,0x442b0df6,0x29010df6}},	//   _dvic, _haoi, _sbc_, ysha_,
   {{0x90e69a27,0x7c36008b,0xe5c40081,0x61fe1a28}},	//   _استن, feyr, зсто, dapl,
   {{0x38b902be,0xb4b3016f,0x644402d5,0x629c03ed}},	//   méro_, टते_, gdii, _ajro,
   {{0x64429a29,0x5eb800ab,0x290101b4,0xd9f901ae}},	// [d30] _maoi, _ইংরে, wsha_, инац_,
   {{0x61fe1a2a,0x7f4d1a2b,0x60c09a2c,0x2901005d}},	//   gapl, _iraq, _ahmm, tsha_,
   {{0x6f040168,0x200900b9,0x442b1a2d,0xb05b0198}},	//   _zvic, _kdai_, _tbc_, ymäl,
   {{0x6d400029,0xdd00800d,0xdb0f00e7,0x442b1a2e}},	//   āmat, štěn, _lycé, _ubc_,
   {{0x3ced02a5,0x248d9a2f,0xa3a88105,0x76418110}},	//   ćevu_, viem_, _खुल_, _paly,
   {{0xf1c88bb8,0x999e8065,0x60c0808e,0x248d8035}},	//   रधान, hető_, _ehmm, wiem_,
   {{0x248d8029,0x9f40007b,0x76419a30,0x76439a31}},	//   tiem_, _leið_, _valy, rdny,
   {{0x130982da,0x44291a32,0x6442832f,0x26d30ba3}},	//   аний_, nfa_, _caoi, _lixo_,
   {{0x6442803c,0x290a8065,0x248d9a2f,0x7aed1a33}},	//   _daoi, ában_, riem_, npat,
   {{0x248d8029,0x090580e8,0x2009004f,0x38bc84e8}},	//   siem_, опон, _adai_, míra_,
   {{0xdd9b8153,0x64428068,0x644402a3,0x6f04190f}},	//   _сша_, _faoi, ydii, _svic,
   {{0xc5e90bea,0x43759a34,0x290b9a35,0x64428c49}},	//   _יד_, _мулт, čca_, _gaoi,
   {{0x99980289,0x4429031d,0xdd1e81ac,0xe28e9a36}},	//   _marš_, dfa_, _víťa, _жа_,
   {{0x7c298e5d,0x3e708706,0xa3e586ae,0x7aed066b}},	//   lfer, _càth_, बुर_, dpat,
   {{0x26d304c3,0x7aed0858,0x61fe0214,0xa3c18540}},	//   _dixo_, epat, vapl, ंधक_,
   {{0x13ea0196,0x74161a37,0x26d30ba3,0x6f0480e1}},	//   рмай_, تورا, _eixo_, šici,
   {{0xe1fa0d69,0x26d31a38,0x7aed1066,0x7c36007b}},	// [d40] ига_, _fixo_, gpat, reyr,
   {{0x44291a39,0xf22186a7,0x63b6804a,0x41b61821}},	//   afa_, _माफ़_, _øyne, осет,
   {{0xda218e18,0x27241a3a,0x649780eb,0x05a99a3b}},	//   _मानत_, lön_, rģij, _चुलब,
   {{0x5ee180c8,0x7c2980f3,0x61fe02d0,0x4429018e}},	//   _নিজে, jfer, sapl, cfa_,
   {{0xee3a8012,0xaf369a3c,0xd00f8199,0x7c299670}},	//   инд_, ترات, ئله_, dfer,
   {{0x6442808c,0x999e8019,0x6f029a3d,0x7c298192}},	//   _saoi, zető_, rsoc, efer,
   {{0x7c299a3e,0x27241a3f,0x7cd180eb,0x61fc1384}},	//   ffer, hön_, _pārp, _ierl,
   {{0x61fc1a40,0x2c78803d,0x61e90bda,0x60c082d5}},	//   _herl, _béda_, _đeli, _uhmm,
   {{0x60dc1a41,0x7a3f8110,0x27241a42,0x61fc1a43}},	//   _hurm, kštė, jön_, _kerl,
   {{0x60dc1a44,0x61fc09a6,0x026a80e8,0x5ee18264}},	//   _kurm, _jerl, рший_, _নিচে,
   {{0x44291a45,0x3a370496,0x64428834,0x8cd61a46}},	//   yfa_, חרים_, _taoi, _मंगो,
   {{0xab2a9a47,0x26dc00ce,0x7c298118,0x6724022b}},	//   _вода_, _čvor_, cfer, _bqij,
   {{0xd90e89d7,0xa09b80be,0xe29a84ae,0x7d1c92f1}},	//   ریک_, שיכט, _кад_, _årsb,
   {{0x29070019,0x628a8234,0x25e601d0,0x63a282f9}},	//   ának_, _umfo, जुली_, _ixon,
   {{0x7e689a48,0x44291a49,0x45d41a4a,0x60dc1a4b}},	//   _modp, tfa_, дорс, _nurm,
   {{0xa01b1a4c,0xd5b80e02,0xe57180be,0x44291a4d}},	//   riös, юся_, ײַל_, ufa_,
   {{0x61fc1a4e,0x44291a4f,0x6d5a1a50,0x3a750088}},	// [d50] _berl, rfa_, ätar, плар,
   {{0x44291a51,0x4eac80ab,0x656e0061,0x68e301df}},	//   sfa_, গগুল, ínhá, índo,
   {{0x05a98540,0x60dc1a52,0x38690573,0x442900b4}},	//   _चुंब, _curm, _koar_, pfa_,
   {{0x7aed1a53,0x61fc037a,0x60dc1a54,0x63a2808e}},	//   ppat, _eerl, _durm, _oxon,
   {{0x66c01836,0x61fc1a55,0x76451a56,0xdb07861c}},	//   söke, _ferl, _kahy, ümüz,
   {{0x61fc1a57,0x60dc01b4,0x0e648558,0x3e798176}},	//   _gerl, _furm, мкін, _bèta_,
   {{0xc6940158,0x7c2982af,0x60dc1a58,0xf3ff03a7}},	//   ואס_, tfer, _gurm, _joão_,
   {{0x629a9a59,0x320102ed,0x61e50428,0xab6582ac}},	//   ento, lahy_, lchl, звил,
   {{0x7c299a5a,0x61fc084a,0x5f94835f,0xa3ce0107}},	//   rfer, _yerl, _житт, षेप_,
   {{0x61e50635,0x60dc008e,0x320110ba,0x62800196}},	//   nchl, _yurm, nahy_, _įmok,
   {{0x27e084c4,0x850580d5,0x91fc80eb,0xa92281e5}},	//   žine_, _روشن, rkāp, ндэл,
   {{0x7e688efc,0x201d81b9,0x27240009,0x629a99b0}},	//   _zodp, ngwi_, tön_, anto,
   {{0x38690012,0xacaa8117,0xc31980c8,0x31b80526}},	//   _doar_, _اپنے_, _তৈরি_, _अर्ध,
   {{0x27241a5b,0x2b4f826c,0x7645111f,0x9f5d8077}},	//   rön_, _irgc_, _cahy, gawé_,
   {{0x491283bb,0xbea3014c,0xdd921a5c,0x61e51a5d}},	//   _थियो_, харк, رور_, dchl,
   {{0x442f807d,0x61fc1a5e,0x6d4180dd,0x3869010c}},	//   _jbg_, _serl, _msla, _goar_,
   {{0x61fc0455,0x20021a5f,0xd46711b3,0x60dc1a60}},	// [d60] _perl, maki_, чите_, _surm,
   {{0x20021a61,0x6d4194f0,0x60dc1a62,0x2c71826b}},	//   laki_, _osla, _purm, _dádi_,
   {{0xceb31a63,0x61fc04eb,0x29059a64,0xd5b00065}},	//   _איז_, _verl, nsla_, _شہر_,
   {{0x20021a65,0x38cb8416,0xc6048540,0x64a61a66}},	//   naki_, مانی_, रण्य_, _хама,
   {{0x61fc1a67,0xe81f0006,0x6d419a68,0x60dc1a69}},	//   _terl, _भासा_, _asla, _wurm,
   {{0x442f810b,0x20021a6a,0x2907817f,0x7bd9819d}},	//   _abg_, haki_, _ovna_, _agwu,
   {{0xdb078a56,0x628e1a6b,0x20020041,0xe9a31663}},	//   _člán, _imbo, kaki_, _зарп,
   {{0x64461a6c,0x20020f28,0x2cad83b2,0x399b0039}},	//   _jaki, jaki_, goed_, _הילד,
   {{0x200207d9,0x6d41957a,0x6b841a6d,0x64461a6e}},	//   daki_, _esla, nzig, _maki,
   {{0x64461a6f,0x2a6a1a70,0xb05b0364,0x27e69a71}},	//   _laki, _jobb_, mmäi, lcon_,
   {{0x2bb9053f,0xa6e98028,0x24978077,0xbbb9146d}},	//   _आर्थ, _chươ, _کنند_, _आर्क,
   {{0x64461a72,0x76451a73,0x442f8338,0x63a20035}},	//   _naki, _sahy, _gbg_, żony,
   {{0x60c41a74,0x6b840a0f,0x628e0b81,0x24800168}},	//   _dhim, jzig, _ombo, dhim_,
   {{0x291a1a75,0x2c7181d0,0x64461a76,0x442208dc}},	//   kupa_, _rádi_, _aaki, _ack_,
   {{0x64461a77,0x20021a78,0x7647006a,0xa2c00b04}},	//   _baki, baki_, rdjy, वतन्,
   {{0x628e1313,0x76450397,0x64461a79,0x30a401e2}},	//   _ambo, _wahy, _caki, _прыв,
   {{0x64461a7a,0x3f9e0214,0x4e1c801b,0x76451a7b}},	// [d70] _daki, ştur_, नलाई_, _tahy,
   {{0x291a0c53,0x6d41008b,0x78af1a7c,0x60c40326}},	//   fupa_, ælas, locv, _zhim,
   {{0x7c229a7d,0x2907001b,0x2509003d,0x4422006a}},	//   _ocor, éna_, _برخی_, _fck_,
   {{0x628e1a7e,0x61e50352,0x386987ca,0xdfd180f7}},	//   _embo, schl, ðar_, نيا_,
   {{0x7c2d1a7f,0x64978162,0x2cad9384,0x36699a80}},	//   mfar, nţie, voed_, жало_,
   {{0x442f9a81,0x443b00b9,0x20021a82,0xed599a83}},	//   _sbg_, leq_, zaki_, жок_,
   {{0xa9341a84,0x20021a85,0x291a1a86,0xdd918019}},	//   _перш, yaki_, cupa_, کوں_,
   {{0xe81f1a87,0x7c2d1a88,0x14bf0c78,0x443b1a89}},	//   _भाषा_, nfar, ्षिण, neq_,
   {{0x200d9a8a,0x20021a8b,0xaca38133,0xddd48088}},	//   _idei_, vaki_, _nkụj, čaši,
   {{0x60c41a8c,0xa6e98028,0x2002054e,0xddc18493}},	//   _shim, _phươ, waki_, _colţ,
   {{0x20021a8d,0x66039a8e,0x19c59a8f,0xa0a601a1}},	//   taki_, mank, ьбом, данд,
   {{0x1620023c,0x60d60201,0x27ff9a90,0x7d1c8257}},	//   _बाहर_, _qiym, _jeun_, _årsa,
   {{0xeaae8012,0x20021a91,0xb9048a74,0x6449831d}},	//   _ай_, raki_, _भू_, mdei,
   {{0x64461a92,0x442d8352,0xa6e98104,0x7c3b9a93}},	//   _saki, lfe_, _thươ, leur,
   {{0xceb281db,0x20021a94,0x6d58017f,0x2a6a1a95}},	//   דים_, paki_, _švab, _robb_,
   {{0x64499a96,0x6b840b90,0x442d9a97,0x7c2d1a98}},	//   ndei, tzig, nfe_, gfar,
   {{0x66039a99,0x64461a9a,0xfc3f026b,0x64978087}},	// [d80] kank, _vaki, _akís_, cţie,
   {{0x64461a9b,0x7c3b9a9c,0x248000f1,0x6281805d}},	//   _waki, heur, shim_, nhlo,
   {{0x66039a9d,0x64461a9e,0x7c3b83b2,0x6f098216}},	//   dank, _taki, keur, _avec,
   {{0x291a1a9f,0x7d1c1aa0,0x22479aa1,0x7c3b8036}},	//   rupa_, murs, _lank_, jeur,
   {{0x9c7c8499,0x073a9381,0x6f099aa2,0x98a7012b}},	//   _juče, تساب_, _cvec, žića_,
   {{0x44201aa3,0x628e1aa4,0x26c59aa5,0x66039aa6}},	//   lgi_, _umbo, _chlo_, gank,
   {{0x442d9aa7,0x69dc0548,0x7c3b9aa8,0xe81f06ae}},	//   ffe_, _igre, feur, _भाला_,
   {{0x3ae400f2,0x6e3c1aa9,0x27ff9aaa,0x7c3b9aab}},	//   _köp_, herb, _geun_, geur,
   {{0x44201aac,0x22479aad,0x7ae20174,0xcf469aae}},	//   igi_, _bank_, íoth, _юнай,
   {{0x66039aaf,0x64499396,0x22478db1,0x38668338}},	//   cank, adei, _cank_, ljor_,
   {{0x7c3b85f8,0x22479ab0,0x765a9ab1,0x021704de}},	//   beur, _dank_, _inty, וחים_,
   {{0x7d1c1ab2,0xb4d80697,0x1c1d0ebf,0x38669ab3}},	//   durs, ादो_, _फाइल_, njor_,
   {{0x69dc1ab4,0x3f869ab5,0x6e3c1ab6,0x76489ab7}},	//   _ogre, nzou_, ferb, _kady,
   {{0xf98f99f4,0x62819ab8,0x64830006,0xddda800d}},	//   ابی_, chlo, _kõig, _potř,
   {{0xf1aa803d,0x76489ab9,0x7d1c1aba,0xc34880ff}},	//   _باشه_, _mady, gurs, _hổ_,
   {{0x44201abb,0x261b1551,0x66039abc,0x69dc1abd}},	//   ggi_, _बाकी_, zank, _agre,
   {{0x3ec71abe,0x66c000f2,0x443b1abf,0x439404bd}},	// [d90] _особ, söka, req_, ватс,
   {{0x27ff81b0,0x7648923c,0x68fc0114,0xc34880ff}},	//   _seun_, _nady, _bwrd, _mổ_,
   {{0x6f1d002a,0x332901b9,0x30159ac0,0x48159ac1}},	//   lusc, stax_, едер, емес,
   {{0x6d450108,0x66039ac2,0x765a9ac3,0x8c3d8087}},	//   _isha, wank, _anty, noşt,
   {{0xa3b608fd,0xb4bd009a,0x76489ac4,0xc34880ff}},	//   _चुप_, ेगी_, _bady, _nổ_,
   {{0x68fc0428,0x171c03de,0x64598362,0x764890ba}},	//   _fwrd, קווע, _snwi, _cady,
   {{0x7ce787d9,0x7bc29ac5,0x7c3b90b6,0x3f868118}},	//   _bıra, _azou, teur, azou_,
   {{0x934591c7,0x0b459537,0xc348801c,0x61ea9ac6}},	//   ение, енин, _bổ_, _affl,
   {{0x442d9ac7,0xc3488028,0x6f09825b,0x7c3b9ac8}},	//   rfe_, _cổ_, _uvec, reur,
   {{0x272982ba,0x764883ec,0xaa459ac9,0x66038079}},	//   mún_, _gady, хеол, qank,
   {{0xa3b601ce,0x02db09c8,0x9c7c9123,0x6d451aca}},	//   _चुन_, बदुन, _suče, _nsha,
   {{0x386d8216,0x6e3c02af,0xf09f0580,0x6f1d0037}},	//   _joer_, werb, gnà_, fusc,
   {{0x66019acb,0x6d451acc,0x44200059,0xda0f016f}},	//   _kelk, _asha, vgi_, ाणात_,
   {{0x7d1c1434,0x9c7c992c,0x386d867f,0xb4d81acd}},	//   turs, _vuče, _loer_, ाद्_,
   {{0x387f82bb,0x66019ace,0x7afd1acf,0xed571ad0}},	//   _olur_, _melk, _awst, нор_,
   {{0x69c3803b,0x249f8125,0x6e3c1ad1,0x04431ad2}},	//   _izne, nnum_, serb, лесн,
   {{0x6d451ad3,0xc34880ff,0x249f808b,0xb09b1101}},	// [da0] _esha, _xổ_, inum_, _מיקר,
   {{0x6d4500f1,0x387f9ad4,0x44201ad5,0xc7d701c6}},	//   _fsha, _alur_, sgi_, _אופי_,
   {{0x387f8358,0x76489ad6,0x386d9ad7,0x7cd180eb}},	//   _blur_, _rady, _boer_, _dārz,
   {{0xd7068767,0x7648820d,0x5f069ad8,0xfbc78277}},	//   езди, _sady, езда, _مت_,
   {{0x27299ad9,0x08e68a49,0x61368065,0x66019ada}},	//   gún_, _কিছু_, _külö, _belk,
   {{0x66018a56,0x7ce782bb,0x3f86802a,0xdd949adb}},	//   _celk, _sıra, rzou_, калы,
   {{0xc348801c,0x44fe001b,0x2ca01adc,0x249f807b}},	//   _sổ_, nů_, onid_, fnum_,
   {{0x249f807b,0x54548991,0x26da1add,0xf8ca00ff}},	//   gnum_, твит, _lipo_, _tẩy_,
   {{0xb05b016d,0x66019ade,0xc7a38139,0x764880e4}},	//   lläg, _felk, _битк, _tady,
   {{0xdee39adf,0xd90e8bca,0x2c7c0511,0x44fe01d0}},	//   _софи, میت_, _oído_, ků_,
   {{0x2d878d38,0xb05b00f2,0x44fe001b,0x2b9100e1}},	//   czne_, nläg, jů_, môcť_,
   {{0xc3488028,0x44fe001b,0x6fd6880a,0xbebb0168}},	//   _tổ_, dů_, _gücü, ntëv,
   {{0x44269ae0,0xb05b01ec,0xfebb01a8,0x98741ae1}},	//   _ico_, hläg, كاست_, уляц,
   {{0x66c0016d,0x6f1d1ae2,0xa01b0192,0x7aef802a}},	//   sökn, rusc, chön, ícte,
   {{0xb606026c,0x5558002e,0x26da0091,0x7ae29ae3}},	//   dušč, наря_, _dipo_, _huot,
   {{0xdcb80698,0x6f1d159c,0xb05b0338,0x6d450299}},	//   ещу_, pusc, dläg, _vsha,
   {{0x291e80df,0x64978087,0x61fb026c,0x386d800b}},	// [db0] luta_, nţia, _đulb, _roer_,
   {{0x979c004c,0x6d4510af,0x64830006,0x7ae28009}},	//   _משחק, _tsha, _sõid, _muot,
   {{0x291e81dd,0x3b0902a6,0x6d451ae4,0xf1a7153d}},	//   nuta_, ssaq_, _usha, хран,
   {{0x442681e9,0x6f0d017f,0x66018009,0x26da004f}},	//   _nco_, _kvac, _selk, _zipo_,
   {{0x54541ae5,0x7ae281e2,0xf7459ae6,0x66018009}},	//   _свят, _nuot, тело, _pelk,
   {{0x291e9ae7,0x66071ae8,0x27299ae9,0x644d1aea}},	//   kuta_, najk, rún_, ldai,
   {{0x66019aeb,0xd65802f6,0x32059aec,0x291e9aed}},	//   _velk, תיות_, valy_, juta_,
   {{0x66019aee,0x6f0d0503,0x291e9aef,0x3e740799}},	//   _welk, _ovac, duta_, _hätt_,
   {{0x7ae280ab,0x249f807b,0x32059af0,0x5ba99af1}},	//   _cuot, rnum_, taly_, ьким_,
   {{0x291e9af2,0x644d0014,0xc3320039,0x7ae28084}},	//   futa_, hdai, סוי_, _duot,
   {{0x60c98748,0xb05b1af3,0x645d1af4,0x60db804f}},	//   _khem, kläd, _onsi, _kium,
   {{0x3e7400f2,0x32059af5,0x66e61af6,0x26da1af7}},	//   _lätt_, saly_, кома, _sipo_,
   {{0x26da1af8,0x443f9af9,0x6ec58b04,0x80cb80ab}},	//   _pipo_, meu_, ितपु, িদপ্,
   {{0x6da61afa,0x443f9afb,0x291e80a4,0x644b9afc}},	//   вига, leu_, buta_, _hagi,
   {{0xceb28f60,0x291e802e,0x644b9afd,0x6f0d1afe}},	//   ייך_, cuta_, _kagi, _evac,
   {{0x443f809f,0x44fe001b,0x7f8600f7,0x224a00ee}},	//   neu_, rů_, _للبن, _sabk_,
   {{0x644b9aff,0x44fe001b,0x6b899b00,0x443f9b01}},	// [dc0] _magi, sů_, nzeg, ieu_,
   {{0x645d1b02,0x644b9b03,0x644d1a29,0xaa7b008b}},	//   _ensi, _lagi, adai, _stýr,
   {{0xaca40135,0x44e700ff,0x9c7c8b80,0x68e382df}},	//   _amụt, _gõ_, _luča, _jund,
   {{0x644b9b04,0x60db9b05,0x63a4807b,0xb05b1b06}},	//   _nagi, _cium, _þing, rläg,
   {{0x443f9b07,0x68e39b08,0x16160b86,0x60db9b09}},	//   deu_, _lund, _तयार_, _dium,
   {{0x7bc60db7,0x7ae284fa,0x7c240110,0x291e9b0a}},	//   _izku, _ruot, lgir, yuta_,
   {{0x644b9b0b,0x92de80c8,0xc5d580c8,0x60db8081}},	//   _bagi, _তবে_, _স্বপ, _fium,
   {{0x7c24199f,0x38c884c0,0x291e9b0c,0x443f809f}},	//   ngir, _سازی_, vuta_, geu_,
   {{0x7ae29b0d,0x44269b0e,0xb05b1b0f,0x394781a1}},	//   _quot, _vco_, kmär, _asns_,
   {{0x7ae29b10,0x291e80ad,0x3a279b11,0x68e39b12}},	//   _vuot, tuta_, _ccnp_, _bund,
   {{0x2004820f,0x443f9b13,0x68e39b14,0x38b90019}},	//   _kemi_, beu_, _cund, kért_,
   {{0x7ae2825d,0x291e9b15,0x443f9b16,0x200480f1}},	//   _tuot, ruta_, ceu_, _jemi_,
   {{0x6b898063,0xda3491e9,0x291e9b17,0x644082d0}},	//   czeg, _белы, suta_, memi,
   {{0x64409b18,0x27e000ad,0x291e8870,0xd9548277}},	//   lemi, _egin_, puta_, _منتخ,
   {{0x3e7404b8,0x660700d2,0x644b9b19,0x7bc60cdb}},	//   _rätt_, rajk, _yagi, _azku,
   {{0x64409b1a,0x3e7404b8,0x200480a4,0x7c241b1b}},	//   nemi, _sätt_, _nemi_, ggir,
   {{0x4ea71b1c,0xe3740196,0x644d1b1d,0x5a351354}},	// [dd0] _арна, алты, rdai, лнат,
   {{0x60c99b1e,0x443f9b1f,0xf8bf1b20,0x64409b21}},	//   _shem, zeu_, llé_, hemi,
   {{0x60db9b22,0x60c981c0,0x39151b23,0x7bc6011b}},	//   _pium, _phem, умер, _ezku,
   {{0x2bae12ee,0x443f823e,0x33200722,0x645d1b24}},	//   _झुका, xeu_, buix_, _unsi,
   {{0x644b9b25,0x443f9b26,0x20049b27,0x60db804f}},	//   _ragi, veu_, _demi_, _vium,
   {{0x644b9b28,0x9c7c805c,0xe5a595b1,0x2004826b}},	//   _sagi, _ruča, лили, _eemi_,
   {{0x644b9b29,0x443f9b2a,0x60c99b2b,0x78a29b2c}},	//   _pagi, teu_, _them, bnov,
   {{0x64409b2d,0x68e38558,0x69c7135a,0x332d84b7}},	//   gemi, _rund, _izje, ttex_,
   {{0x443f9b2e,0x2cb9008e,0x91e59b2f,0xbebb0168}},	//   reu_, _mksd_, лопе, ntës,
   {{0x443f9b30,0x68e39b31,0x644b9b32,0x20049b33}},	//   seu_, _pund, _wagi, _zemi_,
   {{0x644b9b34,0xab5b0065,0xe4e7835f,0x6b899b35}},	//   _tagi, _szül, _різн, szeg,
   {{0x9b458277,0xa35592dc,0x68e38982,0x672d0372}},	//   _منصو, _مختص, _vund, _bqaj,
   {{0x9cd68039,0xbebb00f1,0x68e39b36,0x6d571b37}},	//   _עונה_, jtës, _wund, _arxa,
   {{0x68e39b38,0x78a29b39,0x539a83c8,0x6d5c81a8}},	//   _tund, znov, _אינו, _árac,
   {{0x9c7c811f,0x78a297ff,0x64978087,0xf8bf1b3a}},	//   _mučn, ynov, nţio, blé_,
   {{0xb05b0074,0x2121008e,0xdd8f01a8,0x672d0197}},	//   smär, duhh_, سوق_, _fqaj,
   {{0x74130077,0x20048301,0xb05b016d,0x78a29b3b}},	// [de0] صولا, _remi_, pmär, vnov,
   {{0xddb615a9,0x64409b3c,0x7c241b3d,0xe3b7146c}},	//   _محجب, zemi, sgir, убу_,
   {{0x64409b3e,0x7a7a80be,0x7c240980,0xdce801a9}},	//   yemi, ערעס, pgir, ēlēt,
   {{0xe3a78077,0xdee6997b,0x644082f9,0xd70a9b3f}},	//   _هر_, годи, xemi, енде_,
   {{0xb8eb058c,0x78a29b40,0x2bba00f7,0x9c7c811a}},	//   _री_, rnov, _ساحة_, _bučn,
   {{0x91e3091c,0x09e30652,0x7d1c9b41,0x69dc8ec3}},	//   _горе, _горн, _årsk, žrei,
   {{0x644087d9,0xafdb0aa2,0x20f3026c,0x3a2a0267}},	//   temi, ndør, _aćif_, _icbp_,
   {{0x64978087,0x78a2816b,0x3ae98129,0x115b03de}},	//   sţin, čovs, _búp_, _אדלע,
   {{0x6d580da8,0xb5fc8609,0x3ae98129,0x543b03de}},	//   _šval, _anġe, _cúp_, געפא,
   {{0x7ae61b42,0x86c681a8,0x67228084,0x64409b43}},	//   _mukt, _صيان, muoj, semi,
   {{0x27e98353,0x64409b44,0x3cf800e1,0x64978087}},	//   žane_, pemi, jprv_, cţio,
   {{0xf99304de,0x64978087,0x81d600ab,0x1fdf064a}},	//   מרת_, nţil, _সভা_, नखेड,
   {{0x44ea9b45,0x67228110,0xf4878065,0x26de9b46}},	//   _hù_, nuoj, _حالی, _kito_,
   {{0xc7b382f6,0x81d49b47,0xe45f0106,0xb05b1b48}},	//   מבר_, _колх, _snö_, fläc,
   {{0x629a9b49,0x7ae61b4a,0x44ea877f,0x6ca71b4b}},	//   mito, _aukt, _jù_, граж,
   {{0x44ea9b4c,0x7ae6085c,0x26de9b4d,0x1f750a0e}},	//   _mù_, _bukt, _lito_, _влия,
   {{0x44ea8091,0x3a3807cf,0x26de8548,0x3a2a0088}},	// [df0] _lù_, _bbrp_, _oito_, _bcbp_,
   {{0x44ea83d3,0x26de9882,0x195911e9,0x7ae61b4e}},	//   _où_, _nito_, казы_, _dukt,
   {{0x60cd1b4f,0x9c7c9b50,0x81b680ab,0x2121008e}},	//   _kham, _ručn, চের_, uuhh_,
   {{0xb4fa0158,0x26de9b51,0x89340013,0xa565803d}},	//   _שפרי, _aito_, إعلا, یگان,
   {{0x629a9b52,0xde059b53,0x2489198d,0xe758804a}},	//   kito, апли, mham_, лиці_,
   {{0x44ea9b4c,0x644f1b54,0x629a9b55,0x24891b56}},	//   _bù_, _haci, jito, lham_,
   {{0x26de82b8,0x200b1b57,0x44ea9b58,0x6f1d01ec}},	//   _dito_, kaci_, _cù_, hrsc,
   {{0x644f1b59,0xaf349125,0x24891b5a,0x44ea9b5b}},	//   _jaci, _گرفت, nham_, _dù_,
   {{0x200b003b,0x26de80a4,0x9c7c9b5c,0x6b8d1b5d}},	//   daci_, _fito_, _tučn, nzag,
   {{0x644f1b5e,0x68e700f1,0x60cd0518,0x659592b8}},	//   _laci, _kujd, _aham, _казу,
   {{0x76439b5f,0xf8661594,0x44391b60,0x644f0118}},	//   meny, авно, _obs_, _oaci,
   {{0x44391b61,0x60cd1b62,0x442b1b63,0x23608267}},	//   _nbs_, _cham, _ncc_, _šije_,
   {{0x60cd1b64,0x24891916,0x6b8d017f,0xdee61631}},	//   _dham, dham_, jzag, роги,
   {{0x44391b65,0x78a98582,0x76438365,0x96200035}},	//   _abs_, _ljev, neny, बलेट_,
   {{0x442b1b66,0x7c961b67,0x75239b68,0xf4961b69}},	//   _bcc_, арац, nunz, араю,
   {{0x3d0880cf,0x44391b6a,0x644f1b6b,0x24891b6c}},	//   _सबसे_, _cbs_, _caci, gham_,
   {{0x4439011b,0x644f1b6d,0x76439b6e,0x0206028b}},	// [e00] _dbs_, _daci, keny, изан,
   {{0x442b0098,0xe1f700bf,0x75238ab4,0x61e380ee}},	//   _ecc_, игу_, kunz, _jgnl,
   {{0x2bb80105,0x26de809c,0x644f1162,0xfe3700be}},	//   _आडवा, _rito_, _faci, _דריי_,
   {{0x26de8698,0x60cd1b6f,0x6288820f,0x629a9b70}},	//   _sito_, _xham, zhdo, zito,
   {{0x78a982fd,0x26de9b71,0x44ea9b72,0x629a9b73}},	//   _djev, _pito_, _sù_, yito,
   {{0x75239b74,0x629a8118,0x76439b75,0x67228110}},	//   funz, xito, geny, ruoj,
   {{0x6d581b76,0x629a9b77,0x3218809a,0xe9671b2f}},	//   _švaj, vito, órym_, _карл_,
   {{0xc0e31421,0x7c360789,0x26de804f,0x644f03a8}},	//   _фотк, nfyr, _wito_, _xaci,
   {{0x8aa69b78,0x629a9b79,0x76439b7a,0x26de9b7b}},	//   ирод, tito, beny, _tito_,
   {{0x32078f4c,0x60cd1b7c,0xab5b0065,0xc3330bea}},	//   _ceny_, _sham, _szük, קות_,
   {{0xa3d80076,0x2d968d91,0x60cd005d,0x68e08059}},	//   ाधड_, _трас, _pham, _kimd,
   {{0x629a9b7d,0x66088041,0x859b81c6,0x5faa8072}},	//   sito, _hedk, _בשבו, _कशाल,
   {{0xc7c7117f,0x2bd29b7e,0x3eb81706,0x4fc70071}},	//   рсни, देशा, fort_, рсна,
   {{0x644f1b7f,0x6f1d1b80,0x6d5a8f28,0x60c281f6}},	//   _saci, rrsc, _krta, hlom,
   {{0xa3ea853e,0x241901bb,0x60cd1b81,0x200b1b82}},	//   _मला_, ловы_, _tham, paci_,
   {{0x6d5a805c,0x60cd1b83,0x320c8831,0x3d180fd5}},	//   _mrta, _uham, lady_, _फिरे_,
   {{0x644f1b84,0x2284016d,0x24868282,0xa3ca816f}},	// [e10] _vaci, _söka_, _mlom_, ळेच_,
   {{0x6d5a82bb,0x78a9920e,0x78bb939c,0x62868168}},	//   _orta, _sjev, _skuv, ëkoh,
   {{0x78a98499,0xbebb00f1,0x27e482f7,0x644f1b85}},	//   _pjev, rrëd, _bgmn_, _taci,
   {{0x76439b86,0x320c84e8,0x60c29b87,0x442b1b88}},	//   weny, hady_, glom, _ucc_,
   {{0x44291b89,0x6d5a8b0b,0xfd4c80ff,0x78a985f3}},	//   mga_, _arta, _thiể, _vjev,
   {{0x75238b15,0x528500f7,0x6d5a80dd,0x7bda0039}},	//   tunz, _السك, _brta, _תקשו,
   {{0x6d5a805c,0x76439b8a,0x44291b8b,0x24869b8c}},	//   _crta, reny, oga_, _blom_,
   {{0x44291b8d,0x76439b8e,0x68e08110,0x78bb9b8f}},	//   nga_, seny, _gimd, _ukuv,
   {{0x291e85a4,0x6d5a9b90,0x75239b91,0x6d5c9b92}},	//   erta_, _erta, sunz, _áran,
   {{0xf67480f7,0x6d5a826c,0x752380b4,0x25478061}},	//   _والخ, _frta, punz, _től_,
   {{0xd9459b93,0xb4e60321,0x3eb81b94,0xd00a1b95}},	//   щени, _पढे_, vort_, лене_,
   {{0x3eb802af,0xb7bd802e,0x20090162,0xb5fc8372}},	//   wort_, _acţi, _ceai_, _inġa,
   {{0xd12e84c0,0x44291a21,0x42d580e8,0x291e9b96}},	//   ومی_, dga_, _ліку, arta_,
   {{0x201e1b97,0x44291b98,0x20090362,0x24869b99}},	//   şti_, ega_, _eeai_, _zlom_,
   {{0xe8f59b9a,0x291e8289,0x22459b9b,0x2d7e042b}},	//   _استخ, crta_, melk_, _oćeš_,
   {{0x44291b9c,0x27e08796,0xb05b1b9d,0xdb23807b}},	//   gga_, žini_, llän, _þróu,
   {{0xf8b31b9e,0x3eb81b9f,0x7afb9ba0,0x24801ba1}},	// [e20] _משה_, port_, nput, rkim_,
   {{0x34d3809a,0xb05b1614,0xa96a1ba2,0x3d0882f1}},	//   दगुद, nlän, лиза_, _सबले_,
   {{0x7c299ba3,0x6608807a,0xc6930039,0x7afb89da}},	//   kger, _redk, _מאז_, hput,
   {{0x660e01b4,0x53a6161a,0x7c2981ed,0x0aea01a8}},	//   labk, _гамб, jger, _مرسي_,
   {{0x60c2815d,0x68fb1ba4,0xb05b0338,0x8c468085}},	//   rlom, _čude, klän, qişə,
   {{0x44ee0104,0xfd650028,0x6d5a808e,0xacf89ba5}},	//   _ký_, _nguồ, _prta, анку_,
   {{0x99860307,0x27e9803a,0xb05b016d,0x5d7a00be}},	//   _الأو, žana_, dlän, טאַק,
   {{0x7c299ba6,0x629e1ba7,0x6d5a9ba8,0x66089ba9}},	//   gger, lipo, _vrta, _wedk,
   {{0x44ee0104,0xeaf78077,0xc445803d,0x320a01ac}},	//   _lý_, یریت_, زیون_, _keby_,
   {{0xaa669baa,0x27328087,0x33770039,0x39149bab}},	//   стик, mân_, צעים_, омор,
   {{0x44291bac,0x27329bad,0x6d5a8102,0x44ee007b}},	//   yga_, lân_, _urta, _ný_,
   {{0x320c9bae,0x4429002a,0x9c7c8115,0x629d8036}},	//   sady_, xga_, _mučk, ésor,
   {{0x629e1baf,0x320c8690,0x9c7c8805,0xeb33804e}},	//   kipo, pady_, _lučk, _فروخ,
   {{0x442902a3,0x62819bb0,0x249900b9,0xacf91bb1}},	//   wga_, cklo, _smsm_, ингу_,
   {{0x40351056,0x787f00f1,0x629e1bb2,0x7a538591}},	//   _дейс, _lëvi, dipo, _رضوا,
   {{0x44291bb3,0xce330077,0xcd02809a,0xa0a400a9}},	//   uga_, _کودک, mość_, _најд,
   {{0x4429078a,0x660e1bb4,0x320a1bb5,0x3a7515b7}},	// [e30] rga_, babk, _beby_, олар,
   {{0x9e071bb6,0x660e02a3,0x2eb40074,0x5b7b80be}},	//   _учил, cabk, ंकृत, ארמא,
   {{0xcd02809a,0x320a1bb7,0x9c7c811f,0x7c298be7}},	//   ność_, _deby_, _vučj, yger,
   {{0x50c90107,0xf8c90bb8,0x657a148c,0xdbd982df}},	//   रतिष, रतिय, äthe, nção,
   {{0x7aed0609,0x2ca91bb8,0x320a008e,0x62819bb9}},	//   qqat, mnad_, _feby_, yklo,
   {{0x45199bba,0xcd02809a,0xee3880e8,0x9c7c80c3}},	//   ация_, kość_, йні_, _fučk,
   {{0x20c9016f,0x7bc29bbb,0x648306ae,0x22458ec3}},	//   रताध, _ayou, _lõim, velk_,
   {{0xa2b90a0d,0x2ca91bbc,0x23608267,0x7c29823e}},	//   ्तव्, nnad_, _šija_, uger,
   {{0x2d8c157a,0xb05b148c,0xf09f023e,0x200f9bbd}},	//   údez_, tlän, dià_, magi_,
   {{0x200f9bbe,0x7afb9bbf,0x7c29996d,0x78ad07b8}},	//   lagi_, rput, sger, _ajav,
   {{0x684616de,0xb05b1bc0,0xe0461bc1,0x62819bc2}},	//   онна, rlän, онни, rklo,
   {{0x660e010b,0x6d419bc3,0x200f8074,0x61fc880a}},	//   wabk, _ipla, nagi_, ırla,
   {{0x61c6024c,0x3f841bc4,0xc1c6024c,0x3b09944c}},	//   _वर्ष, ámu_, _वर्ग, _тело_,
   {{0x200f9882,0x7c2f1bc5,0x96ba069b,0x3f8c0035}},	//   hagi_, _accr, руму_, ądu_,
   {{0xa50a0ae7,0x649a1bc6,0x7ae39bc7,0x200f9bc8}},	//   реба_, атар_, _iint, kagi_,
   {{0x90c31056,0x9c7c811f,0x660e1bc9,0x248d9bca}},	//   _обще, _ručk, sabk, nhem_,
   {{0x200f8006,0x7ae39bcb,0x8c3d8201,0xab2a1bcc}},	// [e40] dagi_, _kint, mişd, роза_,
   {{0x7ae39bcd,0x6d419bce,0x9c7c9bcf,0x66c01bd0}},	//   _jint, _opla, _pučk, töku,
   {{0x629e1bd1,0x6d418069,0xdb060106,0x443d82ec}},	//   ripo, _npla, _nykö, _obw_,
   {{0x7ae391d6,0x629e1bd2,0x69c3831d,0x442f83a8}},	//   _lint, sipo, _myne, _ncg_,
   {{0xa2cb06bf,0x7ae39bd3,0x052680ab,0x249f9bd4}},	//   _तीव्, _oint, _মনের_, dium_,
   {{0x7ae39bd5,0x0576845b,0x63a481e2,0xddc18353}},	//   _nint, قاعد, _žino, _dolž,
   {{0xa2b900bc,0x200f9bd6,0x443d9bd7,0x442f838a}},	//   ्तर्, bagi_, _bbw_, _bcg_,
   {{0x69ce1bd8,0x6d5c9bd9,0x68e41bda,0x7aeb9bdb}},	//   _izbe, _áram, _niid, _bugt,
   {{0x0a6a80c4,0xcd02809a,0x926a9bdc,0xc4d30039}},	//   арни_, wość_, арна_, וגה_,
   {{0x7ae38859,0x539b0bea,0x34a708fd,0xd90e87d2}},	//   _cint, ייפו, _गद्द, نیت_,
   {{0x7ae39bdd,0x9c7c842b,0x68e41bde,0x2b4200b9}},	//   _dint, _luči, _biid, _lpkc_,
   {{0x68e402c1,0x8c468628,0x7ae39bdf,0x248d9be0}},	//   _ciid, _феде, _eint, chem_,
   {{0x98b3811f,0x68e41be1,0x629c1be2,0xf09f0722}},	//   žeća_, _diid, _omro, rià_,
   {{0x64830665,0x7d1c9be3,0x7ae39be4,0x6d5e008e}},	//   _võim, _årss, _gint, _brpa,
   {{0xd49b1be5,0x2d85027f,0x66cd81ac,0x29119be6}},	//   ара_, ále_, núka, ázat_,
   {{0xd7fb0698,0x7ae39be7,0xbca501a8,0x7aeb8c27}},	//   _тук_, _zint, أمري, _yugt,
   {{0x2d850289,0x7de705a8,0x5334047f,0x6d5e02d5}},	// [e50] šle_, _мінд, метт, _erpa,
   {{0xe7f90076,0x64830006,0x249f9be8,0xa3e70d86}},	//   ंडवा_, _kõik, zium_, _पलक_,
   {{0x7583004e,0xdcef01a9,0x37f881bc,0x2ca91be9}},	//   _غیرم, ēdēt, _ịkụz, pnad_,
   {{0x92ab00c8,0x27e900dd,0xa2cb0aed,0x66c00106}},	//   খতে_, _jgan_, _तीर्, sökt,
   {{0x200f9bea,0x69ce1beb,0x64830074,0xae1f123a}},	//   ragi_, _ezbe, _lõik, _बयान_,
   {{0xe7e3146d,0x442f9bec,0x7bda0039,0x200f9bed}},	//   _गणना_, _scg_, _לקרו, sagi_,
   {{0x7ae39bee,0x442f8118,0x200f8c2e,0x8c3d9bef}},	//   _rint, _pcg_, pagi_, yişd,
   {{0x67228025,0x27e91bf0,0x69c38035,0x8c3d82d0}},	//   broj, _ngan_, _ryne, kişe,
   {{0x69c386be,0x68e418c2,0x248d91bf,0xdd918019}},	//   _syne, _riid, rhem_, بوں_,
   {{0x27e9035a,0x248d80f1,0x7c2d0114,0x68e41bf1}},	//   _agan_, shem_, hgar, _siid,
   {{0x63ad9bf2,0x648e8362,0x7c2d0299,0x8c3d829a}},	//   _žand, _bùid, kgar, tişd,
   {{0x2eb60d72,0x628a8019,0xdb0f01b3,0x7aeb9bf3}},	//   ृत्त, _elfo, _excé, _tugt,
   {{0xe28e8abe,0x44f180a9,0x6d5e173d,0x68e40406}},	//   _за_, _há_, _srpa, _viid,
   {{0x442d854f,0x27e91bf4,0x44f190ab,0x7c3b9bf5}},	//   lge_, _egan_, _ká_, lfur,
   {{0x44f19bf6,0x2ca002f9,0xf4840180,0x68e41bf7}},	//   _já_, tiid_, واری, _tiid,
   {{0x7c2d1bf8,0x7c3b9bf9,0x768f804a,0xb5fc822b}},	//   ggar, nfur, _høyd, _anġl,
   {{0x44f19bfa,0x442d9bfb,0x20d200f7,0x2ca01bfc}},	// [e60] _lá_, ige_, ráid_, riid_,
   {{0x9c7c8eef,0x7c2d01e4,0x394302f7,0x20d201a8}},	//   _vuči, agar, _bpjs_, sáid_,
   {{0x44f19bfd,0xd7fa8530,0x66c0016d,0x867b0039}},	//   _ná_, бул_, söks, _הריו,
   {{0x67229bfe,0x9c7c826c,0xc8799bff,0x6aa181ec}},	//   troj, _tuči, _coş_, hilf,
   {{0xd00f9b9a,0x27e08009,0x442d8039,0x44f19c00}},	//   اله_, äin_, dge_, _aá_,
   {{0x44f18324,0x628504b8,0x629c1c01,0x67229c02}},	//   _bá_, ckho, _umro, rroj,
   {{0xd94312bc,0x44f19c03,0x7c3b9c04,0x61430a8e}},	//   _пери, _cá_, ffur, _пера,
   {{0x44f19c05,0x442d9c06,0xd00f866e,0x61fb0b80}},	//   _dá_, gge_, _ملف_, _đuli,
   {{0x3d088b9f,0x76900198,0x6aa18789,0x7ce79238}},	//   _सबके_, _käyd, filf, _sırt,
   {{0xaabe1c07,0x44f19c08,0x442d9c09,0x7c2d1c0a}},	//   ्तिक, _fá_, age_, zgar,
   {{0x44f19c0b,0xe8e0001c,0x7c2d1c0c,0x6f0981ec}},	//   _gá_, _ngồi_, ygar, _zwec,
   {{0xab2a96fe,0xd90e803d,0x64830074,0x7c3b8122}},	//   _года_, پیک_, _võik, cfur,
   {{0x2bdb800f,0xaabe14a7,0x7ce78214,0x4df083eb}},	//   मेदा, ्ताक, _fırs, _चलाई_,
   {{0x68fc00eb,0x1df80a14,0x2ee50192,0xddc5128a}},	//   _otrd, зеры_, ölf_, _zahř,
   {{0x291c0065,0xd23b8039,0xdb1d01d0,0x7e6880ee}},	//   ával_, _הגול, _vysí, _mndp,
   {{0x7c2d1c0d,0x5d541c0e,0xd1388196,0xb4fb8e82}},	//   ugar, экст, mtą_, מפלי,
   {{0x7c2d1c0f,0x64978162,0x768f80e8,0x386901a8}},	// [e70] rgar, cţiu, _høye, _inar_,
   {{0x09e080c8,0x7c2d1c10,0xedf88c1c,0x6ce700e8}},	//   _ম্যা, sgar, ुरोध_, _німе,
   {{0x349502cb,0xc5fb1094,0xd1388110,0x62851c11}},	//   _жанр, ्रीय_, ntą_, rkho,
   {{0x44f19c12,0x9c7c88ae,0x78a280e5,0xdbf181d0}},	//   _rá_, _kuču, giov, třík,
   {{0x291804ae,0x2d8301e2,0xb8f406a7,0x44f19c13}},	//   _evra_, lyje_, _सी_, _sá_,
   {{0x44f19c14,0xd1388110,0x61ea810c,0xb05b1c15}},	//   _pá_, ktą_, _ngfl, fläk,
   {{0x442d8813,0x2d830110,0x38690f3e,0xe61099ea}},	//   tge_, nyje_, _onar_, اشه_,
   {{0x44f19c16,0xdbf1801b,0x442d9c17,0x78a29c18}},	//   _vá_, přík, uge_, ciov,
   {{0x44f1877f,0x6aa19c19,0x7c3b9c1a,0x26c7816b}},	//   _wá_, tilf, rfur, plno_,
   {{0x44f19301,0x6d451c1b,0x66020d11,0x38691c1c}},	//   _tá_, _opha, _đoko, _anar_,
   {{0x6fd9816f,0x386900dd,0x6d450282,0xbebb03ed}},	//   बेरं, _bnar_, _npha, trën,
   {{0xc689093f,0xbe2500ab,0x6724817f,0x768b0214}},	//   _דא_, ম্মদ_, šije, _rüya,
   {{0x6d4501f6,0x2cad9c1d,0x38b904e8,0x3ea31799}},	//   _apha, mned_, néry_, fijt_,
   {{0x2cbf9c1e,0xdce38084,0xcb1281c6,0xdd920180}},	//   loud_, tynė, _ילד_, پور_,
   {{0xdee30aac,0x7afd1c1f,0x66e31c20,0xe810800d}},	//   тори, _atst, тора, ारमा_,
   {{0x69da0073,0x68ee0326,0x2cad9c21,0x78a2802a}},	//   _útei, _rubd, nned_, xiov,
   {{0x60c41c22,0x7ae71c23,0xaca3819d,0x6d450234}},	// [e80] _ikim, _bijt, _nfọm, _epha,
   {{0x2cbf85f8,0x7bc61c24,0xab5b0019,0x68ee1c25}},	//   houd_, _vyku, _gyüm, _pubd,
   {{0xceb30158,0xbebb0168,0x63a9007b,0x994a04a3}},	//   _ביז_, ytëz, _þenn, تلال_,
   {{0x2a698326,0x7aef0493,0x672b9c26,0xb4b781d0}},	//   _ɗaba_, _fuct, fugj, चको_,
   {{0x7e7a803a,0x78a29c27,0x76900009,0x3b04026b}},	//   _potp, riov, _täyd, _dépò_,
   {{0xd1389c28,0xa9261c29,0x6b840db1,0x6eeb0197}},	//   ytą_, _одгл, myig, _użbe,
   {{0x98a68e17,0x25078061,0x68fc0824,0x60c403f7}},	//   _живе, ورٹی_, _utrd, _okim,
   {{0x2cad9c2a,0x22581c2b,0x628e00e1,0x3d1103b7}},	//   gned_, _hark_, _hlbo, _तबसे_,
   {{0x6b840f18,0xb05b0338,0x628e1c2c,0x752a8326}},	//   nyig, släk, _klbo, sufz,
   {{0x6f0285a4,0x60c41c2d,0x38691c2e,0x32549138}},	//   mpoc, _akim, _snar_, хвор,
   {{0x29189c2f,0xaca4019d,0x22580039,0x6f028118}},	//   éra_, _anọt, _mark_, lpoc,
   {{0xd1389c30,0x60d6031d,0x2d830196,0x3af29c31}},	//   rtą_, _chym, vyje_, _tâp_,
   {{0xd1388d42,0x27ed1874,0x649798ad,0x00000000}},	//   stą_, ženo_, rţit, --,
   {{0x60c41c32,0x2bd5015c,0x2d830110,0x9c7c8da8}},	//   _ekim, _दरबा, tyje_, _vuču,
   {{0x7aef81ac,0x7aef1c33,0x68fb135a,0x6d581c34}},	//   íctv, _suct, _čudo, _švar,
   {{0x628e1c35,0x76570079,0x961480ab,0x2d830110}},	//   _albo, _waxy, সলিম_, ryje_,
   {{0x3f4f04b7,0x628e016b,0x7ebf01d0,0x3ea3090d}},	// [e90] _użu_, _blbo, tápě, pijt_,
   {{0xdddc00d2,0x2d830084,0x6f0d00b4,0x2fc902c4}},	//   skrš, pyje_, _iwac, _iyag_,
   {{0x6d450234,0x22581c36,0x66151c37,0x6b841a14}},	//   _upha, _dark_, mazk, ayig,
   {{0x3869840e,0xc87982bb,0x8c3d8201,0x6f0d1c38}},	//   ñar_, _kişi_, kişa, _kwac,
   {{0x59d40e18,0x7afd068f,0x24891c39,0xfc3f0061}},	//   _थरथर, _utst, mkam_, _amíg_,
   {{0x8d558425,0x644283c9,0xed599c3a,0xaa450009}},	//   етич, _aboi, зок_, ävää_,
   {{0xa2c282f1,0xaabe1c3b,0x20e8807e,0x3f898084}},	//   रकन्, ्तरक, _işin_, šau_,
   {{0x44f51c3c,0xa3ba8b9f,0x24891c3d,0xa2b90ec5}},	//   _må_, _आँख_, nkam_, ्तक्,
   {{0x27ed9c3e,0x44f50aa2,0x2cbf9c3f,0x2cad8039}},	//   _igen_, _lå_, roud_, rned_,
   {{0x2cbf9c40,0x644d1c41,0x17fa1c42,0x00000000}},	//   soud_, heai, ूर्व_, --,
   {{0x44f50cde,0x68e98063,0xa969813a,0xaca38870}},	//   _nå_, _kied, чина_, _ajụj,
   {{0xf1b203c8,0x228082d6,0x6f0d0314,0x2bb88a74}},	//   רסט_, _bòks_, _bwac, _उँचा,
   {{0xeb8e891e,0x68e99c43,0x66150748,0x6f0d05ee}},	//   _си_, _mied, fazk, _cwac,
   {{0x52398158,0x443f9c44,0x68e99c45,0x6615011e}},	//   _זײַנ, lfu_, _lied, gazk,
   {{0x49bb83f8,0xfaff020f,0x04460468,0x64599c46}},	//   _باشد_, _atë_, невн, _kawi,
   {{0x44f51c47,0x68e99c48,0x63a48110,0x60c40010}},	//   _då_, _nied, _žini, _ukim,
   {{0x6d4107d9,0x64598010,0x22581c49,0xfc3f0032}},	// [ea0] çlar, _mawi, _park_, _ajís_,
   {{0x44f50082,0x78a61c4a,0x27ed8590,0x77641c4b}},	//   _få_, likv, _agen_, _irix,
   {{0x44f50082,0x68e99c4c,0xe5a6028b,0x35c486a7}},	//   _gå_, _bied, _чини, _लुढ़,
   {{0x7e7e0502,0x6459809a,0x78a61c4d,0xb5fc822b}},	//   _hopp, _nawi, nikv, _inġi,
   {{0x7e7e0422,0xde5885e9,0x17548198,0x225806ae}},	//   _kopp, далі_, твля, _tark_,
   {{0x20120032,0x27ed8f06,0x443f874b,0x7e7e1c4e}},	//   _leyi_, _egen_, efu_, _jopp,
   {{0x80d100c8,0x52be1c4f,0x64830074,0x7e7e052e}},	//   _সংস্, ्तीस, _võiv, _mopp,
   {{0x7764062f,0x7e7e1c50,0xd4978ca4,0x44321c51}},	//   _orix, _lopp, ерь_, ngy_,
   {{0x64599c52,0x82a68d55,0x61f303ed,0x764e1c53}},	//   _dawi, ешне, _çelë, keby,
   {{0x2d96867c,0x68e980eb,0x60c28074,0x2012026b}},	//   _прес, _zied, loom, _aeyi_,
   {{0xddc88754,0x6f1b8024,0x39478b99,0x78a61c54}},	//   _hodž, _zvuc, _cpns_, fikv,
   {{0x645982b8,0x765a80b9,0xddc8817f,0x27ed04d6}},	//   _gawi, _haty, _kodž, øen_,
   {{0x44f50bfa,0x765a9c55,0x66150102,0x77641c56}},	//   _så_, _katy, tazk, _crix,
   {{0x44f50082,0x36d515d1,0x64598063,0xa6e780ff}},	//   _på_, тогр, _zawi, _nhữ,
   {{0xd5b81c57,0xb81081fe,0x66150cc7,0x7e7e1c58}},	//   ест_, ाराम_, razk, _dopp,
   {{0x77641041,0x39138098,0x3f868176,0x765a9c59}},	//   _frix, _смър, kyou_, _laty,
   {{0x68e99c5a,0x60c282a3,0x439417c8,0x77640118}},	// [eb0] _ried, doom, гатс, _grix,
   {{0x6d488022,0x765a9c5b,0x68e99c5c,0x66d2007b}},	//   _opda, _naty, _sied, lækn,
   {{0x68e99c5d,0x673d1388,0x7aea81b9,0x39470722}},	//   _pied, ltsj, _mift, ïns_,
   {{0x20d20307,0x26c5826f,0xe0df1c5e,0x7e7e00e5}},	//   háin_, _sklo_, nmò_, _zopp,
   {{0x64599c5f,0x23d50f12,0x68e99c60,0x765a9c61}},	//   _rawi, _दरिद, _vied, _baty,
   {{0x68e99c62,0x64599c63,0x945d809a,0x7aea9c64}},	//   _wied, _sawi, końc, _nift,
   {{0x68e98364,0x64599c65,0xd6580039,0x443f9c66}},	//   _tied, _pawi, גיות_, tfu_,
   {{0x2d51800d,0x67249c67,0x27ed806a,0x0b459c68}},	//   _vše_, šija, _ugen_, внин,
   {{0x645b9c69,0xe2998e9f,0x443f9c6a,0x6f1b8699}},	//   rdui, дап_, rfu_, _uvuc,
   {{0x64598010,0x09e500ab,0x765a9c6b,0x443f9c6c}},	//   _wawi, _প্যা, _gaty, sfu_,
   {{0x81c98a49,0x20120f23,0xe9d98987,0x3ea78019}},	//   লেন_, _peyi_, ько_, mint_,
   {{0x387f83d3,0x7e0a0076,0x3ea79c6d,0x64830006}},	//   _jour_, वर्ग_, lint_, _mõis,
   {{0xa4d4835f,0x80d100ab,0x087680be,0x2d879c6e}},	//   _соці, _সংশ্, דערט_, lyne_,
   {{0x9f9e0073,0x3ea79c6f,0x60c29c70,0x78a61c71}},	//   _ação_, nint_, zoom, sikv,
   {{0x69ca8355,0x2d8c1c72,0x764e1c73,0x765c1c74}},	//   _gyfe, áde_, reby, rdry,
   {{0x29059c75,0x09b000ab,0x764e1c76,0x765c1c77}},	//   mpla_, _করলা, seby, sdry,
   {{0x7e7e12f1,0xf4128158,0x753c0063,0xfce3137b}},	// [ec0] _topp, יפן_, strz, рото,
   {{0x64830074,0xddc89c78,0x386d83ba,0xdee61c79}},	//   _sõit, _rodž, _aner_, _шопи,
   {{0xfbc78077,0x386d9142,0x3ea79c7a,0xa2b31c7b}},	//   _چت_, _bner_, dint_, _आदर्,
   {{0xfbc7880b,0x2eca8bb3,0x387f80e7,0x765a9c7c}},	//   _نت_, ित्त, _cour_, _saty,
   {{0x765a8110,0x64830006,0x69d50019,0x387f9c7d}},	//   _paty, _võit, _ezze, _dour_,
   {{0x3ea79c7e,0x6f0207d9,0x649580f7,0x60c29c7f}},	//   gint_, _çocu, _láid, soom,
   {{0x82a30071,0x64b38087,0xfaa31b2f,0xc60b80ab}},	//   _тарж, răin, _таро, _রাখা_,
   {{0x44221c80,0xb4cc816f,0x69ca8428,0x70569c81}},	//   _jdk_, ळते_, _ryfe, _جنرا,
   {{0xee3a9c82,0x44221c83,0x8c3d880a,0x20d201a8}},	//   _она_, _mdk_, mişl, táin_,
   {{0x63a90110,0x3ea79c84,0x7c2900eb,0x44221c85}},	//   _ženk, cint_, _ķerm, _ldk_,
   {{0x387f873a,0x6d488add,0x63ad8125,0xe1348196}},	//   _your_, _upda, _þann, ынны,
   {{0x387f1c86,0x20d20013,0x63a481e2,0x386d04c3}},	//   ður_, sáin_, _žinu, ñer_,
   {{0x26c31c87,0x7aea84b7,0x7c229c88,0x66d2006a}},	//   tojo_, _tift, _idor, rækn,
   {{0x44f890ab,0x39580267,0x6d5c81a8,0x6fe901a9}},	//   _ké_, _osrs_, _áras, _rīcī,
   {{0x44f8877f,0x44220359,0x3958026c,0x673d006f}},	//   _jé_, _bdk_, _nsrs_, stsj,
   {{0x44f89c89,0x273b8104,0x65650267,0x80d10264}},	//   _mé_, yên_, _vrhh, _সূর্,
   {{0x44f88324,0x20191c8a,0x1af41c8b,0x26c31c8c}},	// [ed0] _lé_, masi_, иптя, pojo_,
   {{0x20d20013,0x7e5500e8,0x68ed0362,0x44f881a8}},	//   háil_, _своє, _hiad, _oé_,
   {{0x387f9c8d,0x6618826f,0x68ed0019,0x3ea79c8e}},	//   _pour_, davk, _kiad, vint_,
   {{0x64830074,0x66020da8,0xdb1d0198,0x22840106}},	//   _võis, _đoki, _pysä, _sökt_,
   {{0xfeb80288,0x9cd60f60,0x20d200f7,0x3ea79c8f}},	//   _سایت_, _תורה_, dáil_, tint_,
   {{0x44f89c90,0x645d1c91,0x0ccb8eed,0x2ca9031d}},	//   _bé_, _hasi, ात्म, liad_,
   {{0x20191c92,0x44f88013,0x88838077,0x3ea79c93}},	//   kasi_, _cé_, _پیشن, rint_,
   {{0x2366803b,0x44f89c94,0x20d20013,0x2ca9031d}},	//   _broj_, _dé_, gáil_, niad_,
   {{0x645d1c95,0x661890d3,0x44391c96,0x69da01d0}},	//   _masi, bavk, _mcs_, _úter,
   {{0x44f8877f,0x2019002e,0x4439038a,0x7c228f3e}},	//   _fé_, easi_, _lcs_, _edor,
   {{0x2019022e,0x44f8877f,0xa29f8006,0x68ed01e4}},	//   fasi_, _gé_, गोष्, _biad,
   {{0x645d1c97,0x20191c98,0x68f51c99,0x20d200f7}},	//   _nasi, gasi_, _muzd, cáil_,
   {{0x7bcb87d9,0x32458767,0x68ed1c9a,0x2ca90355}},	//   _uygu, _белг, _diad, diad_,
   {{0xed5a0b30,0xb4be1c9b,0x248d801b,0x29059c9c}},	//   ног_, ेत्_, lkem_, ppla_,
   {{0x68ed1c9d,0x2ca9031d,0x68f500d2,0x20191c9e}},	//   _fiad, fiad_, _nuzd, basi_,
   {{0x6abe0f1b,0x68ed1c9f,0x2ca9031d,0x64a31ca0}},	//   ्त्र, _giad, giad_, баса,
   {{0x6b899ca1,0xab6607ac,0x645d1ca2,0x2fcd822c}},	// [ee0] nyeg, ывал, _dasi, _nyeg_,
   {{0x248d8006,0x68ed1ca3,0x60c98deb,0x60db9ca4}},	//   hkem_, _ziad, _akem, _ahum,
   {{0x645d1ca5,0x44221ca6,0x60db9ca7,0xb05b01ec}},	//   _fasi, _tdk_, _bhum, plät,
   {{0x60db9ca8,0x44f89ca9,0x645d1caa,0xb05b1cab}},	//   _chum, _ré_, _gasi, llär,
   {{0x44f89cac,0x43751cad,0x60db8077,0x8c3d861c}},	//   _sé_, _курт, _dhum, rişl,
   {{0x44f88324,0x4ab8000c,0x645d1cae,0x248d81ed}},	//   _pé_, _आदिव, _zasi, ekem_,
   {{0x20191014,0x645d0309,0x20d20013,0x765e004f}},	//   yasi_, _yasi, táil_, _mapy,
   {{0x6f04007d,0x44f8801c,0x60db80b9,0x765e02d5}},	//   _otic, _vé_, _ghum, _lapy,
   {{0x36368277,0x2019059e,0xe80a835a,0x20d20013}},	//   _مراس, vasi_, _ह्या_, ráil_,
   {{0x44f89caf,0x20191cb0,0xfaff0168,0x20d200f7}},	//   _té_, wasi_, _orën_, sáil_,
   {{0x6f041cb1,0x68ed1cb2,0xe3af89a7,0x32638084}},	//   _atic, _piad, قری_, стыв,
   {{0x6d5a9cb3,0x68e29cb4,0x60db9cb5,0x6f1d1cb6}},	//   _ista, nmod, _xhum, tssc,
   {{0xb4c0823c,0xb4c2835a,0x2ca6813c,0x68ed1cb7}},	//   ंकी_, ृती_, _imod_, _viad,
   {{0x20191cb8,0x68ed1cb9,0x256387d9,0x645d1cba}},	//   sasi_, _wiad, _yıl_, _sasi,
   {{0x645d1cbb,0x68ed1cbc,0x6f040b87,0x201910e1}},	//   _pasi, _tiad, _etic, pasi_,
   {{0x69d89cbd,0x245802c7,0x752801ac,0x645d1cbe}},	//   _izve, лась_, ádza, _qasi,
   {{0x645d1cbf,0x2ca91cc0,0x68f51cc1,0x291e9cc2}},	// [ef0] _vasi, riad_, _suzd, lsta_,
   {{0x60db8b18,0x645d1cc3,0x60c99cc4,0x291e9276}},	//   _shum, _wasi, _skem, osta_,
   {{0x645d1cc5,0x6d5a9cc6,0x41551cc7,0x81e68264}},	//   _tasi, _nsta, рвес, যুর_,
   {{0x291e913f,0x765e009a,0x3cfb8035,0x69ce0366}},	//   ista_, _zapy, _लंबे_, _dybe,
   {{0x8335093f,0x65689cc8,0x6d5a9cc9,0x2b401cca}},	//   _דאָס_, _ardh, _asta, ctic_,
   {{0x291e9ccb,0x7aee01ec,0x83fd8019,0x68f51ccc}},	//   ksta_, _gibt, zdőd, _tuzd,
   {{0x248d8419,0xd61881a8,0x291c01d0,0x2ca68197}},	//   tkem_, اتها_, ávat_, _bmod_,
   {{0x03258abe,0x291e8106,0x9f05803d,0xac858037}},	//   адин, dsta_, _نورو, ргил,
   {{0x291e9ccd,0x6d5a8c8c,0x656880f1,0xeb998530}},	//   esta_, _esta, _erdh, тип_,
   {{0xea899cce,0x78ab8aa2,0x7aa599f8,0x64878388}},	//   тбол_, ligv, риоз, _añit,
   {{0xe807053e,0xd9459ccf,0xe0da1cd0,0x26c79cd1}},	//   _व्हा_, шени, кво_, mono_,
   {{0xaca301bc,0x6e250014,0x26c79cd2,0x290381a9}},	//   _brọd, _adhb, lono_, īja_,
   {{0xe28e8abe,0x291e9cd3,0xb8fc9cd4,0x765e06c0}},	//   _да_, asta_, _ती_, _papy,
   {{0x91e59cd5,0x6d5a8114,0x26c78365,0x539a8039}},	//   _коле, _ysta, nono_, _בינו,
   {{0xb05b08dc,0x26c7847f,0x5fd80072,0x68e29bad}},	//   rlär, iono_, _ठरवल, ymod,
   {{0xdd8f0eca,0x77860098,0x62839cd6,0x765e004f}},	//   ذوق_, _влиз, _hono, _wapy,
   {{0x6f041601,0xd3870d70,0x26c79cd7,0x23e00424}},	// [f00] _utic, айте_, kono_, पेंद,
   {{0x26c78110,0x2b401cd8,0xa01b1cd9,0x64440162}},	//   jono_, rtic_, sköt, sfii,
   {{0x2b401cda,0x628380e5,0xd83a81e5,0xf67b0158}},	//   stic_, _mono, вэл_, _סאטמ,
   {{0x2b401cdb,0x69ce003e,0x504685fa,0x650201bc}},	//   ptic_, _vybe, редб, _ọkwụ,
   {{0x26c79cdc,0xdfcf8013,0xbebb00f1,0x44fc1cdd}},	//   fono_, ويم_, rrëv, _hí_,
   {{0x44fc0324,0x62839cde,0x661c1cdf,0x68e284fe}},	//   _kí_, _nono, nark, smod,
   {{0x44fc1ce0,0xb87b000d,0xa01b0106,0xa3e3864a}},	//   _jí_, dmín, ljöe, फेस_,
   {{0x44fc1ce1,0x661c011e,0x3218008e,0x38601ce2}},	//   _mí_, hark, _hery_, _nair_,
   {{0xf749803d,0xa2c2816f,0xb7fd0424,0x321800b9}},	//   _مجله_, रकल्, _एलबम_, _kery_,
   {{0x62839ce3,0x26c79ce4,0x661c1ce5,0x7f3b825f}},	//   _cono, cono_, jark, _בעמו,
   {{0x44fc1ce6,0x6d5a9ce7,0x62839ce8,0x7c261ce9}},	//   _ní_, _usta, _dono, _odkr,
   {{0x291e9cea,0x38601ceb,0xdcee0110,0x66171cec}},	//   rsta_, _cair_, mybė, _sexk,
   {{0x44269ced,0x661c1cee,0x44fc1cef,0x38601cf0}},	//   _ido_, fark, _aí_, _dair_,
   {{0x44fc1cf1,0x661c1cf2,0x3f4280ff,0x27fe01d0}},	//   _bí_, gark, _mưu_, ětna_,
   {{0x3f428028,0x44269cf3,0x88d600ab,0xdcee0084}},	//   _lưu_, _kdo_, _সংরক, nybė,
   {{0x44fc1cf4,0x316d1cf5,0x30150187,0xd4981cf6}},	//   _dí_, _čez_, _удир, ару_,
   {{0x26c7861b,0x60cd1cf7,0x69ca8a74,0x24581cf8}},	// [f10] yono_, _ikam, _सुती, шать_,
   {{0x996713f1,0x661c1cf9,0xdcee0084,0x3b09011c}},	//   ител, cark, kybė, rpaq_,
   {{0xd3668288,0x44269cfa,0x161a8063,0x26c78098}},	//   _که_, _odo_, _नज़र_, vono_,
   {{0x776984c3,0xa3cc81a2,0x44269cfb,0x40359cfc}},	//   _prex, _शुभ_, _ndo_, седс,
   {{0x26c79cfd,0x753501b9,0x32181cfe,0x60cd0c53}},	//   tono_, luzz, _fery_, _mkam,
   {{0xc9871a02,0x51871cff,0xee3880e8,0x76551d00}},	//   _куби, _куба, ині_, nezy,
   {{0x09e50a49,0x31e500c8,0x99850013,0x01e500c8}},	//   _প্রা, _প্রশ, _الزو, _প্রদ,
   {{0x69ca9d01,0xa8a48160,0x442680f1,0xe5709a37}},	//   _सुधी, _друк, _cdo_, بطه_,
   {{0x6b8d1d02,0x26c79d03,0x661c1d04,0x201d95d7}},	//   nyag, pono_, yark, mawi_,
   {{0x60cd0b15,0x44269d05,0x81c280c8,0x38601d06}},	//   _akam, _edo_, ্ধন_, _sair_,
   {{0xb87b026f,0x69ca8441,0xec15803d,0x661c1d07}},	//   rmín, _सुदी, _هواد, vark,
   {{0x656e8307,0x44fc077f,0x201d83f8,0x62839d08}},	//   _ábha, _rí_, nawi_, _wono,
   {{0x44fc1d09,0x2d8a834a,0x6d439d0a,0xafdb013c}},	//   _sí_, _über_, ltna, lføj,
   {{0x629a9d0b,0xb05b0106,0x201d9d0c,0x7e63808e}},	//   chto, släp, hawi_, ndnp,
   {{0x7e619d0d,0x661c02a3,0x201d9d0e,0x7c9602a9}},	//   _malp, rark, kawi_, брац,
   {{0x661c1d0f,0x3860003c,0x201d9d10,0x44fc1d11}},	//   sark, _uair_, jawi_, _ví_,
   {{0xd4671194,0xc9f600f7,0x201d80ee,0xb2260e02}},	// [f20] щите_, مساع, dawi_, ймал,
   {{0x44fc1d12,0xe8108526,0x753501b9,0x2bac0072}},	//   _tí_, ार्थ_, buzz, _घेणा,
   {{0x81c98a49,0x32180051,0x3f42801c,0x75351d13}},	//   লের_, _very_, _sưu_, cuzz,
   {{0xa01b016d,0x443d9d14,0x26ca0234,0x7f4280e5}},	//   nköp, _ncw_, lobo_, ttoq,
   {{0x20020bda,0x645601cc,0x6d4380ff,0x649c8174}},	//   icki_, meyi, etna, _héig,
   {{0xa01b0364,0x2480005c,0x7e619d15,0xdcee0110}},	//   hköp, ljim_, _calp, tybė,
   {{0x201d82e7,0x7f4281b9,0x2cad9d16,0x25e39d17}},	//   bawi_, stoq, fied_, टेली_,
   {{0x69dc1d18,0x64561d19,0x44269d1a,0xdcee0084}},	//   _izre, neyi, _qdo_, rybė,
   {{0x6d698029,0x4426856c,0x57fb810f,0x26ca1d1b}},	//   _īpaš, _vdo_, _תלמו, kobo_,
   {{0x60cd1d1c,0x6d5e1d1d,0x321881ac,0xe810801b}},	//   _skam, _ospa, úry_, ारका_,
   {{0x2cad8b3c,0x44269d1e,0x67240da8,0x20f3026c}},	//   bied_, _tdo_, _avij, _ućit_,
   {{0x55778158,0x44269d1f,0x661a837b,0x629a80f1}},	//   _לעבן_, _udo_, _hetk, shto,
   {{0x6724003a,0x6d5181dd,0x29079d20,0x24800503}},	//   _cvij, čkaš, _etna_, djim_,
   {{0x672402fd,0x69dc017f,0x24868282,0x753504b7}},	//   _dvij, _ozre, _hoom_, tuzz,
   {{0x248681e9,0x59cf8aed,0x321e9d21,0xdd940048}},	//   _koom_, _सुपर, maty_, пары,
   {{0x753512bb,0x8c3d87d9,0x60cd1d22,0x6b8d1d23}},	//   ruzz, tişi, _ukam, tyag,
   {{0x6d5e1d24,0x26ca1d25,0xfbd30154,0x69dc00ee}},	// [f30] _espa, bobo_, ستر_, _azre,
   {{0x63a9095e,0x661a9d26,0x201d9d27,0xbebb0168}},	//   _žens, _netk, wawi_, rrës,
   {{0x6724120e,0x2bd50d86,0x201d9d28,0x6f160035}},	//   _zvij, _दरका, tawi_, _zwyc,
   {{0x2ec186bf,0x24868282,0x6e289d29,0x4fd58171}},	//   शक्त, _noom_, _addb, ожет,
   {{0xf1cf8105,0x643a00be,0x201b008e,0xddda81a1}},	//   _सुनन, _דערנ, _meqi_, _rotš,
   {{0x3eae8e23,0x661a80d2,0x6d439d2a,0x443d8079}},	//   gift_, _cetk, ttna, _scw_,
   {{0x7e619d2b,0x78bb8711,0x7d0201d6,0x201d876d}},	//   _valp, _tjuv, _čosk, pawi_,
   {{0x62988aa2,0xcc898bda,0x6d439d2c,0x672281c0}},	//   _alvo, рбие_, rtna, bsoj,
   {{0x6287003a,0x6d439d2d,0x7e619d2e,0x254e811c}},	//   _kojo, stna, _talp, _cəlb_,
   {{0xa9259d2f,0x24800bda,0x6f099086,0x4ea78a2e}},	//   одол, zjim_, _itec, _урба,
   {{0x6724030b,0x3f8f8355,0x2d678024,0x24868069}},	//   _svij, lygu_, _uđe_, _foom_,
   {{0x649c8174,0xa91100d4,0x6287046d,0x7de00032}},	//   _réig, डीएफ_, _lojo, _lásí,
   {{0x661a8457,0x321e9d30,0x776d00e5,0x2d851d31}},	//   _yetk, baty_, _crax, älen_,
   {{0x21699d32,0x64499d33,0xa9699d34,0xfc3f023e}},	//   _вики_, lfei, _вика_, _ací_,
   {{0x649c8307,0x26ca1d35,0xa2ba03dd,0x249902f7}},	//   _féid, robo_, ्वस्, _blsm_,
   {{0x7c3b9d36,0x24869d37,0x26ca1d38,0x2fc0022c}},	//   ngur, _xoom_, sobo_, _txig_,
   {{0x6724030b,0x62871d39,0x776d1d3a,0x52aa0471}},	// [f40] _uvij, _bojo, _grax, авам_,
   {{0x62871d3b,0x649c80f7,0x64561d3c,0x1ae31d3d}},	//   _cojo, _téig, seyi, доум,
   {{0x661a9d3e,0x6f0980e5,0xa01b0106,0x62871d3f}},	//   _retk, _atec, ljöa, _dojo,
   {{0x50ca009a,0x661a9d40,0x20ca001b,0x67228198}},	//   रविष, _setk, रविध, tsoj,
   {{0x44201d41,0x661a84c4,0x24868039,0xe8e08129}},	//   mai_, _petk, _room_, hiệt_,
   {{0x2a630267,0x24869d42,0x6b8b0106,0x6d5c02ed}},	//   _gajb_, _soom_, ägge, owra,
   {{0xd49a80c4,0x24869d43,0x661a9d44,0x69dc01a9}},	//   ири_, _poom_, _vetk, _uzre,
   {{0x44201d45,0xb19880ff,0x734a8087,0x672d9d46}},	//   nai_, _ngưỡ, ачов_, šaja,
   {{0x68fc1d47,0x61ef8085,0x649c81a8,0x1fd180ab}},	//   _hurd, əklə, _réid, ়েবস,
   {{0x68fc1d48,0x38669d49,0x7c3b9d4a,0x20e89238}},	//   _kurd, ldor_, agur, _eşit_,
   {{0x44201d4b,0x69ca946d,0xe45a835f,0x24868282}},	//   kai_, _सुशी, _вже_, _toom_,
   {{0x44201d4c,0x68fc1d4d,0x776d1d4e,0x290a0267}},	//   jai_, _murd, _prax, _mtba_,
   {{0x44201d4f,0x69ca864d,0x610180eb,0xe6671229}},	//   dai_, _सुरी, _vēla, отво,
   {{0x81c980ab,0x2455001c,0x7658804f,0x809f0035}},	//   লেই_, _ấm_, nevy, खोजे,
   {{0x44201d50,0xbd681d51,0x62870388,0x00950162}},	//   fai_, орте_, _rojo, _никэ,
   {{0x44201d52,0x776d062f,0x628700a4,0x7c209d53}},	//   gai_, _trax, _sojo, namr,
   {{0x62871d08,0x8c3d8214,0x1eab00f7,0x7bc10035}},	// [f50] _pojo, mişt, _نادي_, _ślub,
   {{0x8c3d9d54,0x7afd9d55,0x1b040264,0x68fc1d56}},	//   lişt, ísti, _লিখে_, _burd,
   {{0x44201d57,0x6f099d58,0x7c209d59,0xad27003d}},	//   bai_, _stec, kamr, _برخو,
   {{0xe8f806b5,0x649580f7,0x8c3d8087,0x68fc1d5a}},	//   ілі_, _cáil, nişt, _durd,
   {{0xb9020076,0xb4d7016f,0xcb4400a9,0x62871d5b}},	//   _नी_, िती_, _охри, _tojo,
   {{0x81cd00c8,0x7afd1d5c,0x8afa01c6,0x24678129}},	//   শেষ_, _iust, _להשי, _ốm_,
   {{0xceb40158,0x6d471d5d,0x855780d5,0x649580f7}},	//   ויס_, ntja, تیار_, _fáil,
   {{0x7af50102,0x81c28264,0x442b1d5e,0x00000000}},	//   _hizt, ্ধা_, _jdc_, --,
   {{0xbf1592dc,0x64499d5f,0x7c3b9d60,0xe3b180f7}},	//   _رواب, rfei, rgur, عرب_,
   {{0x78ad1d61,0x64499d62,0x7c3b9d63,0x44201d64}},	//   _amav, sfei, sgur, zai_,
   {{0x81cd00c8,0x44201d65,0x68fc04c3,0x644f1d66}},	//   শের_, yai_, _xurd, _obci,
   {{0xa3ac0665,0x7c2081a1,0x44201d67,0x29e1841c}},	//   _कइल_, camr, xai_, _açaí_,
   {{0x442006f7,0x7afd01e2,0xb4c9816f,0xf77201a8}},	//   vai_, _nust, ोती_, راح_,
   {{0x44201d68,0x59cf86a7,0x91fc81a9,0x200d811c}},	//   wai_, _सुथर, ndāl, əmiş_,
   {{0x44201d69,0x7c960160,0x649580f7,0x442b00e5}},	//   tai_, прац, _láim, _bdc_,
   {{0x2be292ee,0x249f80a9,0x7afd1d6a,0xa3e28074}},	//   _परमा, nhum_, _bust, _धरम_,
   {{0x7af51d6b,0x44201d6c,0x59cf8076,0x7afd1d6d}},	// [f60] _bizt, rai_, _सुतर, _cust,
   {{0x44201d6e,0x7c2080ee,0x2bce954b,0x7afd1d6f}},	//   sai_, zamr, _हँसा, _dust,
   {{0x68e40ad4,0x442b03f7,0xa3ac11bc,0x2be29d70}},	//   _khid, _fdc_, _केर_, _परभा,
   {{0x7afd1d71,0x20d21d72,0x68fc054f,0x69d51d73}},	//   _fust, máis_, _vurd, _dyze,
   {{0x7afd1d74,0x68fc034a,0x6726035f,0x672d812b}},	//   _gust, _wurd, nskj, šajn,
   {{0x425503bd,0x68fc1d75,0x63a41d76,0x543600d7}},	//   _отст, _turd, mzin, _برگر,
   {{0x7afd1d77,0x63a41d78,0x649581a8,0x321c82fe}},	//   _zust, lzin, _táil, _revy_,
   {{0x2ca0076d,0x7de70019,0xf7469b3f,0xc5f301c6}},	//   nhid_, lésé, _небо, עדה_,
   {{0x7afd062f,0x8fa39d79,0xe45703de,0x7de2826b}},	//   _xust, _зате, ליקט_, _bísí,
   {{0x63a41d7a,0x3a749d7b,0xcb1301c6,0x8f9b825f}},	//   izin, флор, עלת_, _הימי,
   {{0xa3cc8076,0x4035072a,0xade89d7c,0xfbc400ab}},	//   _शुर_, менс, टेशन_, ্ধিত,
   {{0x290a8341,0x68e41d7d,0x7bc30162,0x20d21d7e}},	//   ība_, _chid, şnui, dáis_,
   {{0x68e41d7f,0x442b1d80,0x63a400f3,0x8c3d9d81}},	//   _dhid, _rdc_, jzin, rişt,
   {{0x63a41d82,0x7afd1d83,0x442b0267,0x6d471d84}},	//   dzin, _rust, _sdc_, ttja,
   {{0xe5c4079e,0xd49b1d85,0x71f78154,0x78ad026f}},	//   есто, бра_, _عروس_, _tmav,
   {{0xb4d70e18,0xe45f0125,0x6d471d86,0x68e41d87}},	//   िते_, _mjög_, rtja, _ghid,
   {{0x6d4704a4,0x628a9d88,0xc62280ab,0xa3e71d89}},	// [f70] stja, _kofo, _নানা_, यें_,
   {{0x6f0d1d8a,0xbd020144,0x8f9c01c6,0x628a8e06}},	//   _itac, ñéca, _ליחי, _jofo,
   {{0xb5fc84b7,0x78bd1d8b,0x442b006a,0x20d21d8c}},	//   _paġn, onsv, _tdc_, cáis_,
   {{0x442b1d8d,0xddde1601,0x69d501ac,0x2ca01d8e}},	//   _udc_, _uopš, _vyze, chid_,
   {{0x644d00b9,0xf7459d8f,0x5f94804a,0x7afd03ca}},	//   mfai, фело, ницт, _uust,
   {{0x628a81a9,0x20d200f7,0x6442802a,0x644d1d90}},	//   _nofo, náir_, _acoi, lfai,
   {{0x236d0858,0x249f9670,0x7d1a9670,0x24e99d91}},	//   _šejh_, thum_, _cwts, омки_,
   {{0x644d1d92,0x649580f7,0x9f6500e1,0xfd5e801c}},	//   nfai, _táim, _štýl_, _huyề,
   {{0x7690025d,0x6f0d1d93,0x80c900ab,0x32059d94}},	//   _käyt, _ntac, রগঞ্, tcly_,
   {{0x09059baa,0x68e41d95,0xd0480085,0x20d20216}},	//   мпон, _shid, əməy, yáis_,
   {{0x63a40098,0x661e1d96,0x6e239d97,0xdd9b8087}},	//   zzin, _repk, manb, _уша_,
   {{0x644280f7,0x7de70019,0x6f1b81bc,0xf485853d}},	//   _gcoi, zésé, _kwuc, _تائی,
   {{0x644d00f7,0xe3ae89a8,0x628a9d98,0x10a31d99}},	//   dfai, _рб_, _fofo, тиян,
   {{0x76900364,0x7afd9d9a,0x12fa8039,0xddc38019}},	//   _näyt, ístu, _והסב, lenő,
   {{0x2ca00014,0x644d1d9b,0x768f804a,0x2c0b0135}},	//   thid_, ffai, _høys, _ụjọ_,
   {{0x443f9d9c,0x63a41d9d,0x672981ca,0x20d200f7}},	//   ngu_, tzin, _ovej, ráis_,
   {{0xc61d00c8,0x6e239d9e,0x7de70019,0x236d806a}},	// [f80] _তারা_, kanb, tésé, nvej_,
   {{0x248b00b9,0x2ca01d9f,0xe45f0106,0x6b8b0106}},	//   _eocm_, shid_, _sköt_, ägga,
   {{0x64a6014c,0x443f8ad4,0x81d600ab,0xc5fa02f1}},	//   _жана, kgu_, াইভ_, ंशीय_,
   {{0x765c1da0,0x753c1da1,0x38ab0035,0x644d01a8}},	//   lery, murz, _górę_, cfai,
   {{0x7c240f2b,0x201f808e,0x2b490aae,0x672981a1}},	//   mair, _deui_, ctac_, _cvej,
   {{0x7c241da2,0x64428013,0x443f9da3,0x2458801c}},	//   lair, _scoi, egu_, _ẩm_,
   {{0x26ce9da4,0xa01b007b,0x3d12016f,0xaca401bc}},	//   rofo_, fjöl, धीचे_, _naịt,
   {{0x7c241da5,0x628a82af,0x7764002a,0x2be28fb2}},	//   nair, _sofo, _osix, _परदा,
   {{0x9ce88117,0x6e239da6,0xd00f8bbe,0x648e8229}},	//   _ہوئے_, banb, _خلق_, _bùir,
   {{0x7c241da7,0x765c1da8,0x648e851e,0xee379da9}},	//   hair, jery, _cùir, _ону_,
   {{0x3a37078d,0x7c241daa,0x60cf0087,0xe873003d}},	//   ורים_, kair, tocm, نندگ,
   {{0x78a29dab,0x6f00804f,0x645b9dac,0x2baf8b99}},	//   nhov, _kumc, ceui, _जेवा,
   {{0x7c241dad,0xb90582ef,0x23e295a7,0x628a8915}},	//   dair, _बी_, _परिद, _tofo,
   {{0x44249dae,0xb4d70054,0x768f835f,0x59cf8f21}},	//   lam_, ित्_, _høyr, _सुवर,
   {{0x77641daf,0xa2cb86b7,0x20c70be2,0x3ce68069}},	//   _esix, सकर्, _осиг, _khov_,
   {{0x44249db0,0x64409db1,0x7c240c5e,0xa3e29344}},	//   nam_, ngmi, gair, _धरा_,
   {{0xf8bf0efc,0x644d1db2,0x69d880f3,0x765c02ec}},	// [f90] mné_, rfai, _hyve, bery,
   {{0x44249db3,0x386901d8,0xf8bf03cb,0xfd5e8028}},	//   ham_, _haar_, lné_, _quyề,
   {{0x44249db4,0x6729811f,0x443f9db5,0x59d482f1}},	//   kam_, _svej, ygu_, _ठुमर,
   {{0xf8bf1db6,0x3869133a,0x7c241db7,0x656500b9}},	//   nné_, _jaar_, cair, _ishh,
   {{0x38691db8,0x6e239db9,0x76900364,0xe0d880e8}},	//   _maar_, tanb, _täyt, єві_,
   {{0x81c980ab,0x451989b5,0xa01b0061,0x6d4a9dba}},	//   লেট_, пция_, gköz, ftfa,
   {{0xf8bf1dbb,0x44249dbc,0xddde0035,0x645b9dbd}},	//   kné_, fam_, _zapł, teui,
   {{0x38691dbe,0x78a28775,0x6ac79516,0xf8bf027f}},	//   _naar_, chov, रक्र, jné_,
   {{0xf8bf0a56,0x610180eb,0x254e8085,0xaca40870}},	//   dné_, _vēlm, _həll_, _saịt,
   {{0x443f831d,0x961e001b,0x236d806a,0xf1bf81d6}},	//   sgu_, _बजेट_, rvej_, ášok_,
   {{0xe9d98098,0xae748065,0x236d806a,0xf99181a8}},	//   яко_, _جھنڈ, svej_, ابخ_,
   {{0x6e21811e,0x3ce681c0,0xf8bf00e7,0x7cc180eb}},	//   _helb, _ghov_, gné_, mēro,
   {{0x386901d8,0x442f9dbf,0x9f4c080a,0x7c2400eb}},	//   _daar_, _idg_, _ölüm_, vair,
   {{0x78a2826f,0x2cbf8074,0xade406ae,0x7ce58144}},	//   zhov, lnud_, _गरदन_, sórd,
   {{0x7c241dc0,0x69d88a8e,0xf8bf1dc1,0xc692810f}},	//   tair, _gyve, bné_, נאל_,
   {{0x386902a3,0xf8bf026f,0x23ce800d,0x765c1dc2}},	//   _gaar_, cné_, _हुँद, sery,
   {{0x7c241dc3,0x765c1dc4,0xfa3607c3,0x26d11dc5}},	// [fa0] rair, pery, فراد, bozo_,
   {{0x7c241dc6,0x2be29344,0x0566046a,0x4a431dc7}},	//   sair, _परसा, _звон, лнув,
   {{0x44249dc8,0x442f979d,0x6f009dc9,0xf29683de}},	//   yam_, _odg_, _sumc, עכער_,
   {{0xafdb0bc5,0x76900009,0x38a201ac,0x44249dca}},	//   mfør, _täys, _fóre_, xam_,
   {{0xa01b0019,0x2cbf8074,0x78a29dcb,0x76450114}},	//   tköz, dnud_, rhov, _ychy,
   {{0x7d0182a3,0xf8bf03fb,0x44221dcc,0x60c401a1}},	//   _buls, zné_, _hek_, _ljim,
   {{0xb7bd802e,0xa0a680e8,0x78a2816d,0x6e218bbd}},	//   _reţe, _завд, phov, _delb,
   {{0x6d4a8e23,0x3ce6946a,0x442f85db,0xb4ca858c}},	//   rtfa, _qhov_, _cdg_, लके_,
   {{0xf8bf0ed7,0x64408006,0xe7378785,0x628e1dcd}},	//   vné_, rgmi, _пет_, _kobo,
   {{0xc3331dce,0x44248304,0x628e1dcf,0x6e219dd0}},	//   נות_, sam_, _jobo, _gelb,
   {{0xf8bf0a56,0x386914f9,0x7afd826f,0x3ce681e9}},	//   tné_, _paar_, ístr, _thov_,
   {{0x26f909a3,0x44221dd1,0xdd8f817e,0x386902a3}},	//   ंद्र_, _nek_, _دوم_, _qaar_,
   {{0xf8bf1dd2,0x6108801b,0x7af89dd3,0x60c41dd4}},	//   rné_, _děla, _tivt, _djim,
   {{0x386901d8,0xf8bf003e,0x7c2280f7,0x65650267}},	//   _waar_, sné_, _heor, _pshh,
   {{0xf8bf003e,0xf1d00128,0x7c22808e,0xafdb1dd5}},	//   pné_, _तुलन, _keor, gfør,
   {{0x11db8051,0x44221dd6,0x629a9dd7,0x7c22808e}},	//   _מחוב, _cek_, lkto, _jeor,
   {{0x628e1dd8,0x213e9a2e,0x2a7c890d,0x7c2f92ca}},	// [fb0] _bobo, luth_, _knvb_, ócri,
   {{0xd0198935,0x44221dd9,0x629a9dda,0x628e1ddb}},	//   दर्भ_, _eek_, nkto, _cobo,
   {{0x628e1ddc,0x649c8036,0xb8128264,0x2bd1052a}},	//   _dobo, _réin, _হয়ত_, _थुरा,
   {{0x6e218352,0xb4ca83bb,0x7cc180eb,0x89341ddd}},	//   _selb, लको_, vēro, اعلا,
   {{0x6e219cbc,0x7d019dde,0x4f0890ac,0x36699ddf}},	//   _pelb, _suls, енін_, дало_,
   {{0x628e02c1,0xed599016,0x44221de0,0x442f9de1}},	//   _gobo, док_, _zek_, _sdg_,
   {{0x6abf0770,0x2cbf8074,0xa158054c,0x6e219de2}},	//   ्वीर, tnud_, _пару_, _velb,
   {{0x24891de3,0x628e1de4,0x629a9de5,0x6e219de6}},	//   njam_, _zobo, ekto, _welb,
   {{0x6e219de7,0x7c229de8,0x2ef59016,0xd0498326}},	//   _telb, _deor, _азар, _sheɗ,
   {{0x3da79285,0x29030010,0xb87b01d0,0x60d60338}},	//   _преб, _kuja_, hlíd, _skym,
   {{0x10a600e8,0x98a61593,0x7c228706,0x290313de}},	//   винн, вине, _feor, _juja_,
   {{0x92c380c8,0x61fa1de9,0x2efa026c,0x7c229dea}},	//   ্ষে_, _útle, _sipf_, _geor,
   {{0xeb8e964f,0x672d026c,0xc62600ab,0xda658088}},	//   _ти_, _cvaj, _বাবা_, _авли,
   {{0x76438393,0x44221deb,0xa7fb04c3,0x66e61dec}},	//   ngny, _sek_, xeñe, тога,
   {{0xceb29a0f,0x2a6a07c7,0x44220214,0x27ff90ab}},	//   בים_, _rabb_, _pek_, _ogun_,
   {{0xafdb0257,0x7c2283a8,0x6fb601a8,0x3958018e}},	//   rfør, _xeor, _لمعا, _rprs_,
   {{0x63a99ded,0xb87b1dee,0xe8d71def,0x44221df0}},	// [fc0] nzen, rmít, _בוקר_, _vek_,
   {{0x68e99df1,0x63a981ed,0xafdb004a,0x27ff810c}},	//   _ahed, izen, pfør, _agun_,
   {{0x44221df2,0x68e98362,0x29030187,0x68fb8084}},	//   _tek_, _bhed, _cuja_, _biud,
   {{0x68fb9df3,0x7794803d,0xb87b03a8,0x649c81a8}},	//   _ciud, هیزا, lmír, _céil,
   {{0xdfd280f7,0x63a981ed,0x649c81a8,0x2d980061}},	//   جيش_, jzen, _déil, lyre_,
   {{0x63a99df4,0x7c2294ff,0x27ff80ad,0x6e9481a8}},	//   dzen, _seor, _egun_, طلبا,
   {{0xd9e605b3,0x68469d32,0x649c80f7,0x7c229df5}},	//   _करित_, _инва, _féil, _peor,
   {{0x61e307d9,0x68fb8098,0x68e98c9f,0x7afc1df6}},	//   ünle, _giud, _ghed, _hirt,
   {{0x69dc016d,0x69ca8fd5,0x7afc1df7,0x3dd28035}},	//   _hyre, _सुजी, _kirt, ływ_,
   {{0xbbe283eb,0x7afc02a3,0x60c29df8,0x5be29008}},	//   _परीक, _jirt, lnom, _परीव,
   {{0xe6be1513,0x672d0110,0x5d869df9,0x2d9803ed}},	//   ोवैज, _svaj, _جلال, jyre_,
   {{0x6f0400f7,0x60c29dfa,0x213e9dfb,0x6d5a8214}},	//   _buic, nnom, ruth_, _ipta,
   {{0x63a98d38,0x7afc0c41,0xb4be9a1c,0x59b2801b}},	//   czen, _oirt, ँची_, ुपहर,
   {{0x6f041dfc,0x7ce59dfd,0x71749ab3,0x3f8682df}},	//   _duic, móra, _مهتا, ixou_,
   {{0xddda801b,0x5c071dfe,0x69dc006f,0xb5fc81b9}},	//   _patř, вяза, _nyre, _baġi,
   {{0x7afc0013,0x3eb80083,0x672d80eb,0x2fc901c0}},	//   _airt, airt_, šaji, _txag_,
   {{0x649c80f7,0x24891dff,0xb87b1e00,0x56951246}},	// [fd0] _réil, rjam_, smís, _бапт,
   {{0x22470065,0x6d5a9e01,0x68e99e02,0x29031e03}},	//   ünk_, _opta, _shed, _puja_,
   {{0xa3e70076,0xa2ba0f21,0x2d8c03ba,0xddc89e04}},	//   येज_, ्वज्, ødet_, _andž,
   {{0x69dc1e05,0xf8d180c8,0x60c29e06,0x7afc1e07}},	//   _dyre, িষ্ঠ, gnom, _eirt,
   {{0x44291e08,0xc43a0051,0x6d5a8df1,0x68fb9e09}},	//   maa_, _אתרי, _apta, _viud,
   {{0xf7708c2a,0x44291e0a,0x64958013,0x4aa71e0b}},	//   غان_, laa_, _láit, _गतिव,
   {{0x68e99e0c,0x20d91e0d,0x200981df,0xb87b0187}},	//   _thed, néis_, ñais_, ilíb,
   {{0x44291e0e,0x63a99e0f,0x2005009a,0x7d051e10}},	//   naa_, tzen, ślij_, _muhs,
   {{0xddc183bb,0x7b758199,0xaca38133,0xe8949e11}},	//   _dalš, اطبا, _ntụl, _тать,
   {{0x63a99e12,0x44291e0e,0x45459e13,0xd90c8065}},	//   rzen, haa_, _منطق, ڈیو_,
   {{0x44291e14,0x63a99e15,0x26c30353,0xaca38135}},	//   kaa_, szen, dnjo_, _atụl,
   {{0xe73a09a8,0x44291e16,0x20d91e17,0x3da49e18}},	//   нем_, jaa_, déis_, _труб,
   {{0x442902a3,0xb8cc1e19,0x7c299e1a,0x6f040039}},	//   daa_, _गत_, maer, _quic,
   {{0x2d9800f1,0x25ef035a,0x66e3816f,0x386d867f}},	//   tyre_, _आणखी_, गतिक_, _laer_,
   {{0x09be00c8,0xada307b6,0x44291e1b,0x6da315e0}},	//   _অর্থ, барл, faa_, бира,
   {{0x38a21e1c,0x442902a3,0x7afc1e1d,0xb87b1e1e}},	//   _fóra_, gaa_, _sirt, smír,
   {{0x2d9e15d8,0x09be1664,0x38a2009a,0x7afc1e1f}},	// [fe0] šte_, ्थ्य, _góra_, _pirt,
   {{0x7c298114,0x649c80f7,0x0e661e20,0x20d91e21}},	//   haer, _réim, _скон, béis_,
   {{0x386d8358,0x44291e22,0x20d90e1b,0x7c298102}},	//   _baer_, baa_, céis_, kaer,
   {{0x7afc1e23,0x386d9e24,0x00da8eca,0x4fa69e25}},	//   _wirt, _caer_, ربات_, лиев,
   {{0xbbe2801b,0x386d9e26,0x7c299e27,0x7afc1e28}},	//   _परेक, _daer_, daer, _tirt,
   {{0x7afc01a8,0x20d901a8,0x3fcb9e29,0x78a40580}},	//   _uirt, néir_, ردنی_, _lliv,
   {{0xf9879e2a,0x2aa40065,0x64958013,0x7c2606cb}},	//   _اب_, _több_, _náis, _kekr,
   {{0xa01b1e2b,0x386d8286,0x7c299e2c,0xb4de8072}},	//   ljöv, _gaer_, gaer, णते_,
   {{0x40938064,0x649580f7,0x7c261e2d,0x26da01bc}},	//   _القر, _ráit, _mekr, _okpo_,
   {{0x415498a2,0x78a41e2e,0x59b8102e,0x629e1e2f}},	//   авос, _aliv, _आधार, nkpo,
   {{0x78a41e30,0x442902c1,0x7c2982c4,0x6e250214}},	//   _bliv, yaa_, baer, _rehb,
   {{0x44290962,0x7c26003a,0x26da0133,0xe3bf0511}},	//   xaa_, _nekr, _akpo_, _leña_,
   {{0x44291e31,0xe29a81e2,0xe0df00e5,0x91fc81a9}},	//   vaa_, _пад_, rlò_, edāt,
   {{0x44291e32,0x20d91e33,0x386d1e34,0x442680ff}},	//   waa_, téis_, žer_, _heo_,
   {{0x44291e35,0x44269e36,0x78a40609,0x254e811c}},	//   taa_, _keo_, _fliv, _bəli_,
   {{0x442682a5,0x649580f7,0x26da01bc,0x20d91e37}},	//   _jeo_, _háir, _ekpo_, réis_,
   {{0x44291e38,0x7c261e39,0x20d91e3a,0xbbe281a2}},	// [ff0] raa_, _dekr, séis_, _परोक,
   {{0x44291e3b,0x44269e3c,0x27e900ad,0x7ce58125}},	//   saa_, _leo_, _izan_, jórn,
   {{0x44291e3d,0x68ed1e3e,0x649581a8,0x64ac0162}},	//   paa_, _khad, _máir, rşir,
   {{0x44268046,0x7c2600c9,0x0467133c,0xb4c0800d}},	//   _neo_, _gekr, _стом, ूको_,
   {{0xd366896c,0xddd70201,0x68ed1e3f,0x2ca900f7}},	//   _به_, _yaxş, _mhad, mhad_,
   {{0x1eea80d5,0xca49003d,0x63ad036a,0x9a870a4c}},	//   نونی_, _جلسه_, mzan, _сумл,
   {{0x44269e40,0x63ad1e41,0x1ddb00d4,0x41e4102a}},	//   _beo_, lzan, _मुमत, _гіта,
   {{0x61fa01fa,0x68ed1e42,0x27e91e43,0x44269e44}},	//   _útla, _nhad, _ozan_, _ceo_,
   {{0x63ad1e45,0x44269e46,0xbf1587bd,0x7c2982ec}},	//   nzan, _deo_, _ضواب, raer,
   {{0xdfd88698,0x60c98a38,0xa7fb01df,0x68ed004f}},	//   _със_, _hjem, xeña, _ahad,
   {{0x008609a0,0x78a40a20,0x27e91e47,0x442681ca}},	//   ално, _pliv, _azan_, _feo_,
   {{0x7e639e48,0x672d8042,0xac198638,0x44269e49}},	//   lenp, šaju, _роду_, _geo_,
   {{0x6d439e4a,0x81bd80c8,0x63ad0669,0x249f81e0}},	//   luna, _আরও_, jzan, mkum_,
   {{0xe296806d,0x63ad1988,0xbb3a8039,0x8f9a83de}},	//   _ваш_, dzan, _יעני, דישי,
   {{0x6d439e4b,0x60db9e4c,0x68ed008c,0x20d900f7}},	//   nuna, _okum, _fhad, réir_,
   {{0x60c99351,0xa7fb040e,0x68ed1e4d,0x44269e4e}},	//   _njem, seña, _ghad, _xeo_,

   {{0xd4670572,0x3b071927,0x6d439341,0xe3bf1e4f}},	// [1000] шите_, ието_, huna, _peña_,
   {{0x29079e50,0x3ce01e51,0x60c9846d,0x248d83ba}},	//   _kuna_, sliv_, _ajem, hjem_,
   {{0x6d439e52,0x29079e53,0x249f808b,0x64599e54}},	//   juna, _juna_, kkum_, _obwi,
   {{0x3ea59e55,0x29079e56,0x26d81e57,0x315680be}},	//   _allt_, _muna_, loro_, ייען_,
   {{0x29079e58,0xe3bf04c3,0x63ad009a,0x60c98168}},	//   _luna_, _teña_, czan, _djem,
   {{0x44269e59,0x8d768416,0x60c985b4,0x64599e5a}},	//   _seo_, لاعا, _ejem, _abwi,
   {{0x6d43859c,0x290783c3,0x7d78803d,0x6e2a9e5b}},	//   guna, _nuna_, امبر_, rafb,
   {{0x26d81e5c,0xd7668065,0x60c99e5d,0x2ca01e5e}},	//   horo_, _پارٹ, _gjem, nkid_,
   {{0x44269e5f,0x64958013,0x29079e60,0xb5fc81b9}},	//   _veo_, _páir, _auna_, _raġu,
   {{0x29079e61,0x781f0e00,0x6d5e1e62,0x3a278118}},	//   _buna_, पर्क_, _oppa, _cenp_,
   {{0x26d81e63,0x44269e64,0x63ad1e65,0x27e004b9}},	//   doro_, _teo_, zzan, _ayin_,
   {{0xd83f83c1,0x7ae19e66,0x644b8122,0x6b9b9e67}},	//   _účtu_, allt, _gcgi, byug,
   {{0x6d5e1e68,0x64958013,0x61050110,0x27e0008e}},	//   _appa, _táir, _vėli, _cyin_,
   {{0x26d81e69,0x7d089e6a,0xd0650085,0x291a008e}},	//   goro_, _kuds, _əsər, kppa_,
   {{0x29078057,0x6e289e6b,0x68ed1e6c,0x3cf3016f}},	//   _guna_, _medb, _thad, ंगले_,
   {{0x1b1980c8,0x63ad1e6d,0x7d089b6c,0x7cc180eb}},	//   _দিতে_, tzan, _muds, tēri,
   {{0x26d81e6e,0x6d439e6f,0x2ca91e70,0x78bd1e71}},	// [1010] boro_, zuna, rhad_, misv,
   {{0x26d81e72,0x60c995db,0x29079e73,0x6d4397e2}},	//   coro_, _sjem, _yuna_, yuna,
   {{0xceb20159,0x2f0b8022,0x83fd8019,0x249f9e74}},	//   _זיי_, _søg_, ndőr, ykum_,
   {{0x6d438365,0x78bd1e75,0x68e29e76,0xa49b07f1}},	//   vuna, nisv, glod, _diòc,
   {{0x95e90065,0x7c2d1e77,0x7e639e78,0x7ae19e79}},	//   _جبکہ_, maar, tenp, yllt,
   {{0x7c2d1e7a,0x6d439e7b,0x7d089e7c,0x22950174}},	//   laar, tuna, _buds, _الآس,
   {{0x365c0039,0x2ca681a3,0x60c9942f,0x248d807a}},	//   דכונ, _blod_, _tjem, tjem_,
   {{0x58d49e7d,0x7c2d1e7e,0x60db9e7f,0x26d801bc}},	//   _дост, naar, _ukum, zoro_,
   {{0x290783c3,0x6d439e80,0xf77384c0,0x248d9e81}},	//   _suna_, suna, _باز_, rjem_,
   {{0x6d439e82,0x249f9e83,0x7c2d1e84,0x29000074}},	//   puna, skum_, haar, _siia_,
   {{0xf769004c,0x26d80698,0x6f0986a5,0x6f161e85}},	//   _רק_, voro_, _huec, _styc,
   {{0x26d81e86,0x7c2d1e87,0x645982a0,0x290780fe}},	//   woro_, jaar, _ubwi, _vuna_,
   {{0x442d9e88,0x6f0981ca,0x7c2d1e89,0x290002f1}},	//   mae_, _juec, daar, _viia_,
   {{0x442d9e8a,0x64499e8b,0x6f098144,0xc7d6807c}},	//   lae_, lgei, _muec, מורי_,
   {{0x26d81e8c,0x776d03a8,0xf1cf8651,0x62839e8d}},	//   roro_, _esax, _सुचन, _inno,
   {{0x7c2d1e8e,0x26d81e8f,0x64499e90,0xdd8f1e91}},	//   gaar, soro_, ngei, روق_,
   {{0x09b500c8,0x2ca000ee,0x442d8118,0xbebb00f1}},	// [1020] _জুলা, rkid_, iae_, rsër,
   {{0x442d9e92,0xe3a78065,0x2ca01e93,0xe7db8327}},	//   hae_, _ہر_, skid_, _बड़प,
   {{0x7c2d1e94,0x9e7b00be,0xed4594a0,0x04ca00f7}},	//   baar, _ענטפ, _تھ_, _مودي_,
   {{0x6c861e95,0x6e2e1e96,0x777b9e97,0x7c2d0079}},	//   _الحم, labb, _brux, caar,
   {{0x44201e98,0x3ebc8bfa,0x7d08803a,0x442d9e99}},	//   mbi_, tivt_, _suds, dae_,
   {{0xcd2909d7,0x6e2e1e9a,0x6f099e9b,0x62951e9c}},	//   _حسین_, nabb, _duec, _gozo,
   {{0x7d088359,0x61431e9d,0x649581a8,0x2b401e9e}},	//   _quds, _нера, _páip, lric_,
   {{0x62839e9f,0x5b148d91,0x6e2e1ea0,0x44201ea1}},	//   _anno, омит, habb, nbi_,
   {{0xdc9b0158,0x213e831d,0x78a2816b,0x657a8114}},	//   טיקל, wrth_, mkov, _wrth,
   {{0x290a1ea2,0x78a29ea3,0xd91a9ea4,0x6e2e1ea5}},	//   _kuba_, lkov, льм_, jabb,
   {{0xd48f9ea6,0x7c2d02a3,0x290a1ea7,0x442d82b8}},	//   _ер_, yaar, _juba_, bae_,
   {{0x442000fe,0x7d1c016b,0x62838c2e,0x2ca68122}},	//   jbi_, dprs, _enno, _ulod_,
   {{0x7c2d1ea8,0x44200805,0x2bd811bc,0xa7fb165f}},	//   vaar, dbi_, _भुला, reño,
   {{0x442d1234,0x29181ea9,0x7c2d02b5,0xae1405fc}},	//   _že_, _otra_, waar, तुलन_,
   {{0x3abb804c,0x7c2d1eaa,0x8af00201,0x6ca702eb}},	//   _תמונ, taar, ktəb, браж,
   {{0x44201eab,0x941913f1,0xfbe98326,0xd4981eac}},	//   gbi_, ржат_, _øªù_, бру_,
   {{0x7c2d1ead,0x61150201,0x78a2826f,0x6e2e1eae}},	// [1030] raar, _işlə, dkov, babb,
   {{0x7c2d1eaf,0x7d028068,0xf8bf0036,0xff5001a8}},	//   saar, _lios, lié_, _أخي_,
   {{0x290a1083,0xe3bf04c3,0x6f09957a,0x44201eb0}},	//   _cuba_, _teño_, _suec, bbi_,
   {{0x290a00a4,0x6d471eb1,0xec6b0a0e,0xfc3f128a}},	//   _duba_, muja, _срок_, _zlín_,
   {{0x7c208713,0x6d4704be,0x6d5500ad,0x44391eb2}},	//   dbmr, luja, ltza, _ids_,
   {{0x442d9eb3,0x442b1eb4,0x29071571,0x44391eb5}},	//   wae_, _hec_, ínas_, _hds_,
   {{0x6d5500ad,0x442b0101,0x290a1eb6,0x6d47007a}},	//   ntza, _kec_, _guba_, nuja,
   {{0x6e2e1eb7,0xdfd58790,0x78a287df,0x6d550102}},	//   zabb, _добы, ckov, itza,
   {{0x442d9eb8,0x290a1eb9,0x7d029eba,0x442b1ebb}},	//   rae_, _zuba_, _dios, _mec_,
   {{0xadf9000f,0x442b01a9,0x6d471ebc,0x27ed8102}},	//   ंधान_, _lec_, kuja, _izen_,
   {{0xf8bf02be,0xa88a1ebd,0x44391ebe,0x7d028046}},	//   fié_, айна_, _ods_, _fios,
   {{0x25d6893f,0x44391ebf,0x442b1ec0,0x6d4701ac}},	//   _ווען_, _nds_, _nec_, duja,
   {{0x2cad813c,0x78a99ec1,0x6e2e1ec2,0x60cd1ec3}},	//   mhed_, _mlev, tabb, _djam,
   {{0x78a99ec4,0x05db0105,0x78a2826f,0x9c130135}},	//   _llev, _मुहब, zkov, _kọwa,
   {{0x6e2e1ec5,0x78a983ff,0xde03035f,0xfc3f0118}},	//   rabb, _olev, дпри, _clío_,
   {{0x03260698,0x44201ec6,0x2cad806a,0x290a1ec7}},	//   ждан, ubi_, nhed_, _ruba_,
   {{0x78a29ec8,0x290a1ec9,0x7c2b9eca,0x3eba09ca}},	// [1040] vkov, _suba_, _megr, _tmpt_,
   {{0x44201ecb,0x645d0609,0x644f047f,0xa01b0106}},	//   sbi_, _ebsi, _ecci, ljöp,
   {{0x78a294f0,0x78a98022,0x38669ecc,0x2d780289}},	//   tkov, _blev, teor_, _uče_,
   {{0xddc89807,0x290a00b4,0x7a400091,0x803703de}},	//   _nadš, _vuba_, _bátà, ַנצע_,
   {{0x78a294f0,0xf8b30051,0x7d0281a8,0x61e38366}},	//   rkov, ושא_, _rios, _lynl,
   {{0x7d029ecd,0x290a1ece,0x877b010f,0x7b09129b}},	//   _sios, _tuba_, יאני, _džud,
   {{0x7c2b9ecf,0x78a285b7,0x27ed9ed0,0x98a69ed1}},	//   _begr, pkov, _ezen_, _диве,
   {{0x61ee012b,0x442b1ed2,0x2cad9ed3,0x78a987f1}},	//   _izbl, _xec_, ghed_, _glev,
   {{0x7cc18029,0xccf302f6,0x320d080a,0xf8bf1ed4}},	//   vērt, וכה_, _şeyi_, vié_,
   {{0x23620748,0x7d029ed5,0x290483e4,0x60cd1ed6}},	//   _mpkj_, _wios, _hima_, _sjam,
   {{0x61e38355,0xc27b010f,0x29049ed7,0x291880f1}},	//   _cynl, בריי, _kima_, ëra_,
   {{0x7c2b96a1,0xb87b00f7,0x29049ed8,0xbb8695a9}},	//   _gegr, rlío, _jima_, _ولاي,
   {{0x24869ed9,0x29189482,0x29049d96,0x81d600ab}},	//   _inom_, ūra_, _mima_, াইট_,
   {{0x26dc8289,0x6d471eda,0x442b1edb,0x6f1d0bfd}},	//   novo_, tuja, _sec_, rpsc,
   {{0xdcbb1edc,0x442b1edd,0xf8bf1ede,0x61e38114}},	//   аща_, _pec_, pié_, _gynl,
   {{0x29048353,0x62988efc,0x5b151edf,0x6d55011e}},	//   _nima_, _hovo, змат, rtza,
   {{0x442b0c79,0x62989c24,0x2486805c,0x63a09ee0}},	// [1050] _vec_, _kovo, _mnom_, nymn,
   {{0x78a9800d,0x2904826b,0x291e808e,0x78bb8088}},	//   _slev, _aima_, opta_, _smuv,
   {{0x24868052,0x29049ee1,0x89d900f7,0x26dc9ee2}},	//   _onom_, _bima_, حوار_, dovo_,
   {{0xf7718307,0x29049092,0x44391ee3,0x644f0081}},	//   فات_, _cima_, _uds_, _ucci,
   {{0x8e859ee4,0x7c2205e4,0xddc883f2,0x7c2b9ee5}},	//   згле, ñore, _radš, _regr,
   {{0xa1370077,0x7ce59ee6,0xd6db9ee7,0x31351715}},	//   _ورزش, móri, ште_, _негр,
   {{0x62871ee8,0x6f0d008c,0x78a9826c,0x2cad9ee9}},	//   _injo, _luac, _tlev, thed_,
   {{0x644d1eea,0x7cc180eb,0x78bb80b4,0x29049eeb}},	//   ngai, vērs, _umuv, _gima_,
   {{0x6f0d0013,0x2cad813c,0x649c80f7,0x61e38370}},	//   _nuac, rhed_, _réit, _synl,
   {{0xd2a98009,0x2cad8051,0x649c9eec,0x62989eed}},	//   ское_, shed_, _béis, _covo,
   {{0x62989eee,0xa9699eef,0x21699ef0,0x2b490144}},	//   _dovo, щина_, щини_, huac_,
   {{0x2009002a,0x6f0d0834,0x92cb80ab,0x67299ef1}},	//   _cgai_, _buac, লতে_, _kwej,
   {{0x61fe803e,0x291e8087,0x7ea200e7,0x2d8512f1}},	//   _úpln, apta_, _hôpi, ålen_,
   {{0x6d439ef2,0x6f0d03ac,0xe3b0826a,0x59bd047d}},	//   orna, _duac, _جرم_, ्पार,
   {{0xb7bd8087,0xf3f98087,0xa5d606a7,0x10a61ef3}},	//   _deţi, deţi_, _मुखौ, _никн,
   {{0x649c80f7,0x62871ef4,0x6ab406a7,0x5f761ef5}},	//   _héir, _anjo, ंफ्र, _فاخر,
   {{0x7ce59ef6,0x6b6309c7,0x7cd38162,0x69c3002a}},	// [1060] góri, нкта, căre, únen,
   {{0x6d410013,0x644d008c,0xe2970162,0x6d438bcf}},	//   álac, agai, пау_, krna,
   {{0xfe9b00be,0x386001b9,0xd24f1ef7,0x80669ef8}},	//   _היימ, _kbir_, انم_, звеж,
   {{0x649c8013,0x62871ef9,0xe7f3001b,0x2f10823e}},	//   _léir, _enjo, _घरमा_, _pàg_,
   {{0x44321efa,0x7c241efb,0x66e69efc,0x6d439efd}},	//   may_, mbir, пода, erna,
   {{0x7f429efe,0x44321eff,0x332001e0,0xb603816b}},	//   rroq, lay_, mpix_, _otáč,
   {{0x29048503,0x6298817f,0xacf881e2,0x490b801b}},	//   _tima_, _rovo, онку_, _ठूलो_,
   {{0x44321efa,0x26dc825b,0x7c241f00,0x649c9995}},	//   nay_, sovo_, nbir, _réis,
   {{0x62989f01,0x7d061f02,0x33200e23,0x6d438427}},	//   _povo, _miks, npix_, arna,
   {{0x44321f03,0x2cfa05fc,0x7d061f04,0x60c29f05}},	//   hay_, ्दुल_, _liks, liom,
   {{0x05db0576,0xcc128133,0x80b083eb,0xb7bd8087}},	//   _मुंब, _bọtị, ंसपे, _reţi,
   {{0x48ab19fe,0x7d061f06,0x24868bb1,0x75d381a8}},	//   стом_, _niks, _unom_, _ثيما,
   {{0x7c241f07,0x44321f08,0x6298807a,0x765c0428}},	//   dbir, day_, _tovo, ffry,
   {{0xd24f80a0,0x7c241f09,0x9c13019d,0x291e9f0a}},	//   _منه_, ebir, _lọta, ppta_,
   {{0x443201b4,0xda5b8496,0x6d4a9f0b,0xc9869f0c}},	//   fay_, _הכול, nufa, _хули,
   {{0x44321f0d,0x7ce580a9,0xb4d7023c,0x7c241f0e}},	//   gay_, tóri, ाके_, gbir,
   {{0x2d8c1f0f,0x7d061f10,0xf3f9802e,0xddde011c}},	// [1070] äder_, _diks, teţi_, _tapş,
   {{0x78ad0a56,0x290e9f11,0x6d4a9f12,0x644d1f13}},	//   _hlav, _kufa_, kufa, sgai,
   {{0x44321f14,0x7c241f15,0xa9070591,0x7ce58187}},	//   bay_, bbir, سبان, sóri,
   {{0x443202c1,0x26c31f16,0xd138102a,0x6d4a9f17}},	//   cay_, lijo_, яху_, dufa,
   {{0x3b640021,0x7eaf80e8,0x9c1301bc,0xb4e90ec5}},	//   _първ, _løpe, _dọta, यती_,
   {{0x78ad1f18,0x6d4382a5,0x26c30353,0x628704b7}},	//   _llav, trna, nijo_, _unjo,
   {{0x60c29f19,0x672480eb,0x2d571f1a,0x290e89ab}},	//   biom, ģija, nçe_, _nufa_,
   {{0xc9520039,0x60c28706,0xdb009a1f,0x6729838a}},	//   _שמן_, ciom, lymè, _twej,
   {{0x1ee7819f,0x2d570214,0x81df00ab,0x8f55803d}},	//   _فوری_, hçe_, দেশ_, _زناش,
   {{0x44321f1b,0xb4e91f1c,0x2d5702d0,0x26c31f1d}},	//   zay_, यतु_, kçe_, jijo_,
   {{0x81df150b,0x443202c1,0x26c31f1e,0x78ad1f1f}},	//   দের_, yay_, dijo_, _blav,
   {{0xcea91a63,0x443202c1,0xb4d703bb,0x78ad0018}},	//   _די_, xay_, ाको_, _clav,
   {{0x610c07d9,0x44320205,0x7d061f20,0x26c3007a}},	//   _işle, vay_, _riks, fijo_,
   {{0x44321f21,0x60c2809a,0x78ad1f22,0x7d061f23}},	//   way_, ziom, _elav, _siks,
   {{0x44321f24,0x998583f8,0xfce61f25,0x7d060077}},	//   tay_, _آلبو, дово, _piks,
   {{0x442f9f26,0x1ad580ab,0x3ce91f27,0x61fa008b}},	//   _jeg_, _হওয়া, glav_, _útli,
   {{0x442f9f28,0xa8570051,0x7c241f29,0x44321f2a}},	// [1080] _meg_, _חיפה_, rbir, ray_,
   {{0x44321f2b,0x26c30db7,0x7c241503,0x7d060242}},	//   say_, cijo_, sbir, _wiks,
   {{0x44321f2c,0xa96a045b,0x7d061f2d,0xd91000d7}},	//   pay_, تمام_, _tiks, ایر_,
   {{0x442f86c0,0x44320079,0x53ad83eb,0x7c2f1f2e}},	//   _neg_, qay_, टनाश, _gecr,
   {{0x3eac82c4,0x69d51f2f,0x7ae8805f,0x7ae385ee}},	//   _pldt_, _exze, yldt, _oknt,
   {{0xd25212dc,0x442f8006,0x6d589f30,0x60c29f31}},	//   _جنس_, _aeg_, ttva, siom,
   {{0x442f9f32,0xafdb0edd,0x20569a1b,0x443d8609}},	//   _beg_, ngør, _отар, _bdw_,
   {{0x63a402a3,0x442f8069,0x290e9f33,0x26c3007a}},	//   oyin, _ceg_, _rufa_, zijo_,
   {{0x63a41f34,0x442f9f35,0x629c1f36,0x9c13019d}},	//   nyin, _deg_, _koro, _kọra,
   {{0x68e41f37,0x629c1f38,0x395801c0,0x3b0780e7}},	//   _akid, _joro, _kqrs_, _cinq_,
   {{0x67228029,0x6da6845a,0x629c1f39,0x26c30353}},	//   lpoj, _تمام, _moro, vijo_,
   {{0x629c0397,0xa9c380e8,0x3f861f3a,0x3cfa0035}},	//   _loro, тськ, _šoua_, ्दों_,
   {{0xceeb1c12,0x26c3007a,0xe81e0035,0x7c2f1f3b}},	//   قرآن_, tijo_, पड़ा_, _recr,
   {{0x629c1f3c,0x442f80f3,0xb4d709c1,0x290e9f3d}},	//   _noro, _zeg_, ाक्_, _tufa_,
   {{0xd49b1f3e,0x26c30353,0x6f08951e,0x26ce9f3f}},	//   ора_, rijo_, _midc, info_,
   {{0xb4e91885,0x6b829f40,0x9f5500e8,0x26c3007a}},	//   यते_, _krog, _звич, sijo_,
   {{0x629c1f41,0x7ce580f7,0x7c220511,0x26c3007a}},	// [1090] _boro, mórt, ñora, pijo_,
   {{0x27e91f42,0xddc38162,0x672d04be,0x68fd1f43}},	//   _iyan_, nenţ, _iwaj, lmsd,
   {{0x610c080a,0x629c1f44,0x7c2f0214,0x2a781f45}},	//   _oğlu, _doro, _tecr, _darb_,
   {{0x6b829f46,0x2cb2031d,0x27e900a4,0x38a21f47}},	//   _orog, chyd_, _kyan_, _fóru_,
   {{0x442f9f48,0x63b60063,0x629c1f49,0xb8d78105}},	//   _reg_, czyn, _foro, _छत_,
   {{0x442f8cde,0xd3560051,0x629c1f4a,0x9c13019d}},	//   _seg_, _אישי_, _goro, _tọsa,
   {{0x26c981dd,0xddc3802e,0x201281a8,0x672d1f4b}},	//   đao_, denţ, íniú_, _lwaj,
   {{0x628a9f4c,0xf1b200be,0xeb999508,0x394c82c4}},	//   _anfo, _עסן_, зии_, duds_,
   {{0x27e9076d,0x68f60114,0x6b829f4d,0x442f9f4e}},	//   _nyan_, _rhyd, _crog, _veg_,
   {{0x442f8574,0xddc38087,0x291101d4,0x2ef49ac0}},	//   _weg_, genţ, _kuza_, _азур,
   {{0x442f9f4f,0x6b829f50,0xa6db007b,0x2a6300b9}},	//   _teg_, _erog, nuðu, _mbjb_,
   {{0x6b829f51,0x2d98809f,0x8cc10327,0xb4e9103e}},	//   _frog, _àrea_, रोमो, यतो_,
   {{0xc00000c8,0x1b1980c8,0xd85001bc,0x7ba780f7}},	//   ূর্ণ_, _দিকে_, _fọnt_, _تصام,
   {{0x539a8451,0x2f1400f2,0x27e9020d,0xafdb0366}},	//   _מינו, _väg_, _dyan_, tgør,
   {{0x629c049c,0x98a781d0,0xcc128133,0x672d0032}},	//   _roro, éně_, _kọpị, _ewaj,
   {{0x68e40067,0x629c1f52,0x63a41f53,0xfce301a1}},	//   _ukid, _soro, tyin, госо,
   {{0xca860071,0x27e91f54,0x672d0041,0xd8d700be}},	// [10a0] нгай, _gyan_, _gwaj, _רופט_,
   {{0x63b6009a,0x29111f55,0xddc18609,0x996e811c}},	//   rzyn, _buza_, _balż, nəş_,
   {{0xc8798086,0xdca61612,0x065700be,0xc8669289}},	//   _baş_, _зани, _אייך_, етли,
   {{0x60c60867,0x2ca9016d,0x7ae19f56,0x6d4e1f57}},	//   nikm, ckad_, holt, muba,
   {{0x7ae19f58,0x629c1f59,0x6d4e1f5a,0xb05b1f5b}},	//   kolt, _toro, luba, onär,
   {{0x26ce9f5c,0x7cd38087,0x7e7c0267,0x1fdf80ab}},	//   unfo_, văra, ndrp, _বৃহস,
   {{0x23668669,0x2911011f,0xddc38087,0x7ae19f5d}},	//   _spoj_, _guza_, venţ, dolt,
   {{0x91e31f5e,0x6d5c1f5f,0x67228198,0x39470118}},	//   _сосе, itra, ppoj, ánse_,
   {{0x290901e0,0x6d4e1f60,0xddc38087,0x68e29f61}},	//   _riaa_, huba, tenţ, mood,
   {{0x6d4e1f62,0x8af00085,0x394c8722,0x3f99841c}},	//   kuba, xtəl, tuds_, _àsua_,
   {{0xe3af84c0,0x6d5c0503,0x0c2685e9,0xc87983bf}},	//   لری_, jtra, _змен, _yaş_,
   {{0xeb9a81f3,0x01370039,0xe61f8028,0x6d4e1f63}},	//   _ние_, ערכת_, _đôi_, duba,
   {{0x7ae18ede,0xb4be9f64,0x28c006b7,0xdefb0009}},	//   bolt, ुची_, शोधि, зыв_,
   {{0x7ae19f65,0x68e28079,0x6d5c1f66,0x38a200f7}},	//   colt, hood, ftra, _sórt_,
   {{0x6d5c1f67,0x68e28ebc,0x45d41a0b,0x6e350968}},	//   gtra, kood, горс, razb,
   {{0xdef804b7,0x8af00085,0x7e7a808e,0x29111f68}},	//   ċċa_, stəl, _latp, _ruza_,
   {{0x68e282a3,0x2911005c,0x6d5c1f69,0x2ca91f6a}},	// [10b0] dood, _suza_, atra, rkad_,
   {{0x7e7a805c,0x644800eb,0x6d4e1f6b,0x2ca91f6c}},	//   _natp, _ēdie, buba, skad_,
   {{0x7c361f6d,0xc9841f6e,0x3f849f6f,0x6720810c}},	//   bayr, луци, _armu_, _atmj,
   {{0xc5f2078d,0x68e28079,0x90e780d7,0x7ae18061}},	//   _כדי_, good, رسان, zolt,
   {{0x44291f70,0x4c9a04de,0xef18804a,0x643603de}},	//   mba_, _חברו, емі_, _בארא_,
   {{0x44291f71,0x07a282a9,0x7bdc8457,0x8fa29f72}},	//   lba_, рашн, ğrul, раше,
   {{0x691780eb,0x44291f73,0xc87982d0,0x68e29f74}},	//   _aģen, oba_, _taş_, bood,
   {{0xfebb8077,0x44291f75,0x4c859631,0xc48581a1}},	//   _کارت_, nba_, тлив, тлик,
   {{0xe803000d,0x44291f76,0xa3de8105,0x6d4e1f77}},	//   रेमा_, iba_, _दुआ_, zuba,
   {{0x6d4e1f78,0x44291f79,0x6d5c1f7a,0x2b4d87f1}},	//   yuba, hba_, ytra, ruec_,
   {{0x26c79f7b,0x61ea8355,0x60c61f7c,0x44290019}},	//   mino_, _cyfl, tikm, kba_,
   {{0x44291f7d,0x7ae19f7e,0xf4858065,0x6d5c1f7f}},	//   jba_, solt, _جائی, vtra,
   {{0x7fd610ac,0x2d858699,0x98bf1f80,0x3f84001b}},	//   тіні, _hrle_, nutę_, ímu_,
   {{0xaa458002,0x6d5c1f81,0x44291f82,0x26c79f83}},	//   _рекл, ttra, eba_, nino_,
   {{0xed571f84,0x61ea831d,0x68e28079,0x7d0b8122}},	//   кор_, _gyfl, yood, _kigs,
   {{0x44291f85,0x6d4e1f86,0x7d0b9f87,0x26c79f88}},	//   gba_, ruba, _jigs, hino_,
   {{0x26c79f89,0x6d4e1f8a,0x7c299f8b,0x387d8428}},	// [10c0] kino_, suba, iber, ddwr_,
   {{0xb2231baa,0x44291f8c,0x68e29f8d,0x7c299f8e}},	//   имул, aba_, wood, hber,
   {{0x44291f8f,0xf8c617a3,0xa3de800d,0x644b1f90}},	//   bba_, _लगाय, _दुई_, ógic,
   {{0x64a61f91,0x7e7a9d08,0x44291f92,0x251e0135}},	//   _рама, _satp, cba_, _ọnwụ_,
   {{0xdfcf8307,0x68e29f93,0x7c299f94,0xddc39f95}},	//   ييم_, rood, dber, venš,
   {{0x26c79f96,0x656880b9,0xb87b0061,0x3ce6806a}},	//   gino_, _ppdh, llít, _skov_,
   {{0xceb30051,0x3cde98b8,0x628e1f97,0x127b00be}},	//   שיו_, खवले_, _inbo, _קאלע,
   {{0x7c299f98,0x98a38ae7,0x7d0b8267,0xb4be93e5}},	//   gber, _кисе, _cigs, ुचे_,
   {{0x26c79f99,0x2d859f9a,0x6ef20366,0xaf068196}},	//   bino_, _erle_, væbn, _апал,
   {{0x26c79f9b,0xc3330039,0x44291f9c,0x7c299f9d}},	//   cino_, סות_, zba_, aber,
   {{0x7c299f9e,0x44291f9f,0x2d85817f,0x40351fa0}},	//   bber, yba_, _grle_, ленс,
   {{0x30a71fa1,0x44290079,0x93469fa2,0x6abf03eb}},	//   тров, xba_, _анде, _एग्र,
   {{0x2d8c0e23,0x58d41194,0x44291fa3,0x64429fa4}},	//   åden_, роят, vba_, _idoi,
   {{0x41dd9094,0xddda8110,0x60c40c2e,0x442910ba}},	//   _नुकस, _natū, _emim, wba_,
   {{0x55581fa5,0x7b091fa6,0x26cd00ce,0xd3088129}},	//   каря_, _džul, đeo_, _dệt_,
   {{0x629a825b,0x628e1fa7,0x44291fa8,0xa7750012}},	//   ljto, _anbo, uba_, _блич,
   {{0x09bd06bf,0x1be30327,0x93f51fa9,0x6d4a81ec}},	// [10d0] ्प्य, _कुशल_, упац, hrfa,
   {{0x44291faa,0xf1a71fab,0xdd03007e,0x6d481fac}},	//   sba_, крен, ırıc, ádac,
   {{0x26c79fad,0xd011936d,0x81e480ab,0x7c299fae}},	//   vino_, ملا_, পের_, yber,
   {{0x673b0fda,0xf1c30110,0x26c79faf,0x7fd58196}},	//   šuju, _rašė_, wino_, лілі,
   {{0x78a089d1,0x3ea10074,0xb4c10701,0x7d0b8366}},	//   _domv, _koht_, ्ची_, _rigs,
   {{0x644284c3,0x7d0b8123,0x4df59980,0x7c299fb0}},	//   _adoi, _sigs, ляйт, wber,
   {{0x26c79fb1,0x7d0b9400,0x3ced9fb2,0xfc3f1b88}},	//   rino_, _pigs, tlev_, _flít_,
   {{0x7eb487f1,0xf7738e06,0xb87b0174,0x0cd18264}},	//   _ràpe, _پار_, ilís, াত্ত,
   {{0x26c79fb3,0x68e9846d,0x81e800ab,0x13099fb4}},	//   pino_, _iked, মেদ_, нний_,
   {{0xd7f89b67,0x3cff81c0,0x3ced9fb5,0x6b6701a9}},	//   _рус_, smuv_, slev_, mīgā,
   {{0x2455806b,0xb87b0c52,0x27fa809a,0xa0a61adb}},	//   _مناس, roín, ępne_, ганд,
   {{0xc32400ab,0x5fc502f1,0xd308827d,0x00000000}},	//   _পিসি_, _लेहल, _sệt_, --,
   {{0x7ae5043d,0x4c9a8e82,0x2a7c87f1,0x27ed8176}},	//   koht, _רבנו, _favb_, _jyen_,
   {{0x1bb888ca,0x99858061,0x7ae50198,0x63bb9fb6}},	//   _جامع_, _ملتو, joht, mzun,
   {{0x27ed8205,0x270f80bc,0xc8798214,0x8af00085}},	//   _lyen_, ादुर_, _ekşi_, stək,
   {{0x7b090858,0x60c41fb7,0x27ed8144,0x2cad9fb8}},	//   _džum, _umim, _oyen_, nked_,
   {{0x63a99fb9,0x63bb9fba,0x2f1986c0,0x27ed8db1}},	// [10e0] nyen, nzun, _nèg_, _nyen_,
   {{0xfeba0077,0xb87b016b,0x290d8300,0x68e99fbb}},	//   _ساخت_, slít, _aiea_, _aked,
   {{0xe5a61a02,0x35a60071,0x673b007a,0x6da61ac9}},	//   _сини, _санг, šujt, _сина,
   {{0x270f8076,0xd7fa9fbc,0x25a51b9d,0x68fb9fbd}},	//   ादूर_, нул_, älle_, _chud,
   {{0xe3b21fbe,0x7e7e1fbf,0xbea6854c,0x6e3884e8}},	//   _طرح_, _kapp, ладк, tavb,
   {{0x7e7e04b7,0xddc71807,0xf12400d5,0x68e981bc}},	//   _japp, lejš, _نظری, _eked,
   {{0x7e7e1fc0,0x7b09173d,0xccf8801b,0x21751fc1}},	//   _mapp, _ožuj, _opět_, _кутр,
   {{0xddc71fc2,0x24801fc3,0x26ca1fc4,0x645600fc}},	//   nejš, ndim_, hibo_, ngyi,
   {{0xa3de85e8,0x63a99fc5,0x26ca1fc6,0x1bd4802e}},	//   _दुख_, gyen, kibo_, ропя,
   {{0x7e7e1fc7,0x5a3482dc,0x9e65853d,0xf1269fc8}},	//   _napp, шнот, _نامن, льмо,
   {{0xddc88fda,0x67240091,0x23ba846d,0xd9178198}},	//   _hadž, _atij, _bàjé_, лья_,
   {{0x657a810c,0x7e7e1fc9,0x2cad8039,0x63a99fca}},	//   _isth, _aapp, cked_, byen,
   {{0xa3e401a2,0x0a948c5c,0x7e7e02f7,0x248002a6}},	//   _पुल_, _валю, _bapp, ddim_,
   {{0x4b7b80be,0x7e7e1fcb,0xddc881c8,0x29021fcc}},	//   _נאוו, _capp, _madž, amka_,
   {{0x7e7e1fcd,0xccfb04ae,0x61ee0338,0x291c04e8}},	//   _dapp, ећа_, _nybl, íval_,
   {{0xb4c10361,0x64561fce,0x38c90065,0x61f59fcf}},	//   ्चे_, ggyi, _جاتی_, üzle,
   {{0x36d50364,0x5a351fd0,0xddc880d2,0x26ca02ec}},	// [10f0] _вопр, инат, _nadž, bibo_,
   {{0x26ca1fd1,0x2f198247,0xccf8801b,0x68fb89ab}},	//   cibo_, _règ_, _zpět_, _shud,
   {{0x657a822c,0x386901b9,0x65951246,0x7ae51fd2}},	//   _nsth, _kbar_, _тану, roht,
   {{0xf77185ff,0x7e7e1fd3,0xddc71fd4,0x6b670ec3}},	//   قات_, _zapp, cejš, tīgā,
   {{0x7c2d1fd5,0x443b0086,0x69dc1fd6,0x2ab60646}},	//   mbar, maq_, _exre, _sæbe_,
   {{0x443b1fd7,0x3a29826c,0x6b6700eb,0x171c00be}},	//   laq_, _đapo_, rīgā, עווע,
   {{0x7d0f0065,0x5e5800be,0x40358530,0x68fb9fd8}},	//   _kics, טיגע_, _вебс, _thud,
   {{0x0b4585c2,0x63bb9fd9,0x443b0085,0x68fb826c}},	//   анин, tzun, naq_, _uhud,
   {{0x3f8901c0,0x2cad9fda,0x60cb9fdb,0x7c2d1fdc}},	//   _nrau_, rked_, migm, ibar,
   {{0x4e7887bd,0x2cad9fdd,0x52a99fde,0x63a99fdf}},	//   _محمد_, sked_, твом_, ryen,
   {{0x63a99fe0,0x67241fe1,0x7c2d1fe2,0x7e7e1fe3}},	//   syen, _stij, kbar, _rapp,
   {{0x254101e2,0xa3b510c5,0x7e7e1fe4,0x7645008e}},	//   dėl_, जना_, _sapp, _adhy,
   {{0x442d9fe5,0x7e7e1fe6,0xddc71fe7,0x26ca1fe8}},	//   mbe_, _papp, vejš, tibo_,
   {{0x7c3b97ec,0x442d9fe9,0x7b0901a1,0x6b8401e8}},	//   laur, lbe_, _džuk, vvig,
   {{0xceb28bea,0x3f89002e,0x3cfd81c5,0x3c420019}},	//   חים_, _erau_, _khwv_, _lévő_,
   {{0x0c261fea,0x7c2d1feb,0x442d9fec,0x3f890384}},	//   рман, gbar, nbe_, _frau_,
   {{0x442d9fed,0x3f891fee,0x24801fef,0x032308cc}},	// [1100] ibe_, _grau_, rdim_, ждун,
   {{0x236000f3,0x7c3b8010,0x6b841ff0,0x62819ff1}},	//   rtij_, haur, rvig, ndlo,
   {{0x6e3c0370,0x6aa39e72,0x7c2d1ff2,0x7c3b9ff3}},	//   marb, _monf, bbar, kaur,
   {{0x443b0086,0x442d9ff4,0x24800085,0x6e3c1ff5}},	//   caq_, jbe_, qdim_, larb,
   {{0x7d041ff6,0x442d8ee1,0x6fd680f7,0x7ccd80eb}},	//   mmis, dbe_, جزائ, _mērķ,
   {{0x44201ff7,0x7d041ff8,0x6b8b013c,0xddc89ff9}},	//   lci_, lmis, ægge, _vadž,
   {{0x40969285,0x61430972,0x38568081,0xd943151b}},	//   _крат, _мера, _възс, _мери,
   {{0x44201ffa,0x442d877f,0x387f811e,0x8fa68056}},	//   nci_, gbe_, _gaur_, _кабе,
   {{0x7d041ffb,0x44250085,0x3d16809a,0x29181ffc}},	//   imis, _əl_, _पूरे_, _hura_,
   {{0x29181ffd,0xf1eb0424,0x2ee78362,0x6d411d46}},	//   _kura_, _जुड़_, conf_, šlai,
   {{0x6e3c1ffe,0x442d9fff,0x81e800c8,0x44202000}},	//   darb, bbe_, মের_, kci_,
   {{0x3866a001,0x29182002,0x7c2d0079,0xd5778039}},	//   nfor_, _mura_, xbar, _כתבה_,
   {{0x29182003,0x7c22a004,0x7d040074,0x4ea72005}},	//   _lura_, _ifor, dmis, арва,
   {{0x44200063,0xa15886d2,0x6e3c2006,0x7d042007}},	//   eci_, _баку_, garb, emis,
   {{0x29182008,0x7c22a009,0x7d0f200a,0x78b6005f}},	//   _nura_, _kfor, _pics, _flyv,
   {{0x7d04200b,0x44220144,0x7c2d200c,0xb0350251}},	//   gmis, _cfk_, ubar, _униш,
   {{0x7c2d200d,0x443b200e,0x68ed200f,0x8afd800d}},	// [1110] rbar, raq_, _ikad, stře,
   {{0x7c2d2010,0x442da011,0x7d040009,0x29182012}},	//   sbar, zbe_, amis, _bura_,
   {{0x29182013,0xa2d81344,0x7c228503,0x44202014}},	//   _cura_, _मदर्, _ofor, bci_,
   {{0x44202015,0x38698789,0x7c9500f7,0x6d552016}},	//   cci_, ýar_, _الحص, muza,
   {{0x3cf405b3,0x29181351,0x44392017,0x6d418668}},	//   ंतरे_, _eura_, _ies_, _svla,
   {{0x7c22a018,0x44392019,0x2918201a,0x7cd3802e}},	//   _afor, _hes_, _fura_, mări,
   {{0x4439201b,0x20d20038,0x63ad201c,0x2918201d}},	//   _kes_, lšie_, lyan, _gura_,
   {{0xec798dea,0x442d81ec,0x3cfd8282,0x9c5986d2}},	//   упи_, ube_, _qhwv_, ушку_,
   {{0x7c220511,0x6d55201e,0x60db804f,0x69ce80e1}},	//   ñori, huza, _ijum, úben,
   {{0x4439201f,0x7c3ba020,0x442da021,0x2b4d809f}},	//   _les_, saur, sbe_, rrec_,
   {{0x7c22831d,0x4439031d,0x63ad2022,0x6281a023}},	//   _ffor, _oes_, hyan, rdlo,
   {{0x44392024,0x63ad2025,0x3ea5a026,0x9c14019d}},	//   _nes_, kyan, _holt_, _pọmp,
   {{0xef198063,0x20d20038,0x442006d4,0x6e3c2027}},	//   _już_, jšie_, vci_, tarb,
   {{0xed5a2028,0x63ad10c1,0x249fa029,0x6d55202a}},	//   лог_, dyan, ljum_, fuza,
   {{0x3ea58813,0x7d040006,0x78a40364,0x6e3c0456}},	//   _molt_, tmis, _toiv, rarb,
   {{0x4439202b,0x25a500f2,0x4420202c,0xfd56819d}},	//   _ces_, älla_, uci_, _albọ,
   {{0x4439202d,0x4420202e,0x7e750f4c,0x64a302a9}},	// [1120] _des_, rci_, bezp, чата,
   {{0x4420202f,0x3f8f0073,0x44392030,0x29122031}},	//   sci_, _água_, _ees_, _hiya_,
   {{0xc6930051,0x44392032,0x290001c0,0x8fc5003d}},	//   _זאת_, _fes_, _khia_, _هزین,
   {{0x92d800c8,0x44392033,0x7c3987d8,0xa14b0065}},	//   াতে_, _ges_, _newr, اسلے_,
   {{0x38668a38,0x63ad2034,0x80ca80ab,0x7cd38087}},	//   rfor_, cyan, িকল্, cări,
   {{0x7c22a035,0x60c9a036,0x291800a4,0x29120077}},	//   _sfor, _emem, _tura_, _liya_,
   {{0x05868087,0x11da00f7,0x29121142,0x237d80ee}},	//   сулм, _صورة_, _oiya_, _aswj_,
   {{0x0cb880c8,0x291204d2,0x3ce0812b,0x44390069}},	//   ুক্ত, _niya_, čivo_, _xes_,
   {{0xdfcf8013,0x99858084,0xe4fb114f,0x6d552037}},	//   _كيف_, kalų_, ्षति_, zuza,
   {{0x25618065,0x68ed08f8,0x9e66803d,0x29000870}},	//   ból_, _skad, _دارن, _ahia_,
   {{0xf09f009f,0x29122038,0x7648831d,0x7cd38087}},	//   tjà_, _biya_, _iddy, zări,
   {{0x29000028,0x63ad03c3,0x7c228aa2,0x9c14019d}},	//   _chia_, yyan, _ufor, _dọkp,
   {{0x29002039,0x7d1a8102,0x33f6936d,0x29121dd4}},	//   _dhia_, _huts, _اساس, _diya_,
   {{0x4439203a,0x7d1aa03b,0x20d201ac,0x6d55203c}},	//   _ses_, _kuts, všie_, tuza,
   {{0x443901c0,0x3b110609,0x2912203d,0x7cfe8168}},	//   _pes_, _rizq_, _fiya_, përd,
   {{0x4439203e,0x63ad203f,0x7d1aa040,0x6d551c88}},	//   _qes_, tyan, _muts, ruza,
   {{0x44392041,0xab870098,0x76489d30,0x7b141612}},	// [1130] _ves_, щувк, _oddy, здух,
   {{0x2d8ca042,0x63ad2043,0x44392044,0x20d200e1}},	//   _orde_, ryan, _wes_, ršie_,
   {{0x44392045,0x63ad2046,0x7d1aa047,0x97d8015b}},	//   _tes_, syan, _nuts, _نظیر_,
   {{0x7648831d,0x20d201ac,0x515b83c8,0x43950098}},	//   _addy, pšie_, רכאו, _дамс,
   {{0x291e0118,0xf7458087,0x63ad00b9,0x2d8c9339}},	//   _étan_, цело, qyan, _arde_,
   {{0x25618065,0x6b8d911b,0x7d1a8db1,0xa3d60a75}},	//   tól_, _šago, _buts, िपर_,
   {{0x3ea58117,0x62952048,0x2ca6a049,0x045981a8}},	//   _volt_, _inzo, _bood_, للغة_,
   {{0xc325a04a,0x25618065,0x60dba04b,0x0325a04c}},	//   омик, ról_, _ujum, один,
   {{0x2ca6a04d,0x7b09026c,0x249f807b,0x290001c0}},	//   _dood_, _džuv, rjum_, _rhia_,
   {{0x6285204e,0x291204d2,0x02c5835f,0x2900204f}},	//   ndho, _siya_, ійно, _shia_,
   {{0xe0da0b9c,0x7d1aa050,0xd4e7835f,0x2bd00ebf}},	//   иво_, _guts, _люди, _सेना,
   {{0x2ca68051,0x290010af,0x3f8d8168,0x237d81c5}},	//   _good_, _qhia_, _kreu_, _tswj_,
   {{0x443fa051,0x03a58a13,0x2bd08074,0x6d439345}},	//   mau_, _фило, _तइया, lsna,
   {{0x443fa052,0x645ba053,0x6729a054,0x6b89a055}},	//   lau_, lgui, _mtej, mveg,
   {{0x29002056,0x2d8c2057,0x62850197,0x386da058}},	//   _thia_, íde_, ddho, _ober_,
   {{0x443fa059,0x62851175,0x3f8601a1,0x645ba05a}},	//   nau_, edho, _šouu_, ngui,
   {{0x42ca0d45,0x5aca01bb,0x6b89a05b,0x6283a05c}},	// [1140] аган_, алам_, nveg, _kano,
   {{0x386d834a,0x443fa05d,0x2ca00859,0x7cd38087}},	//   _aber_, hau_, sjid_, măru,
   {{0x443fa05e,0xdca6205f,0x64a604ae,0x6729a060}},	//   kau_, _дани, _дана, _atej,
   {{0x186aa061,0x443fa062,0xa06aa063,0x7d1aa064}},	//   ради_, jau_, рада_, _ruts,
   {{0x443fa065,0x27e0a066,0x61402067,0x3f8da068}},	//   dau_, çin_, _bálá, _creu_,
   {{0x44322069,0x29068102,0x9f610019,0x27e081b9}},	//   lby_, smoa_, ését_, ħin_,
   {{0x68eb9148,0x4432206a,0x443f8114,0x672981bc}},	//   bogd, oby_, fau_, _etej,
   {{0xa3ae07e6,0x7c24206b,0x443f831d,0x5c988098}},	//   _कथा_, ncir, gau_, ския_,
   {{0x3f8da06c,0xae7a8364,0x6283a06d,0x7d1a80fc}},	//   _greu_, _всех_, _bano, _wuts,
   {{0x62839670,0x78a285a2,0x7d1aa06e,0x645b906c}},	//   _cano, ljov, _tuts, agui,
   {{0x443fa06f,0xe29a8104,0x69c12070,0x60cf0079}},	//   bau_, _chưa_, _žlez, ticm,
   {{0x78a281a1,0x6d58a071,0x44322072,0x00000000}},	//   njov, muva, jby_, --,
   {{0x44268870,0x6440a073,0x44322074,0x6d588406}},	//   _ifo_, mami, dby_, luva,
   {{0x6283a075,0x3ce98088,0x2bd08054,0xdea88041}},	//   _gano, čave_, _तेया, _ƙoƙa,
   {{0xa3d02076,0xeca709a5,0x9c8301d0,0x64408c53}},	//   _वेब_, ојан, íčov, oami,
   {{0x44322077,0xd4982078,0x6aaa01ec,0x19bb8039}},	//   gby_, ору_, öffn, _כמוב,
   {{0x628394be,0x7cd38162,0xdfd101bd,0x6d58a079}},	// [1150] _yano, căru, _سيد_, huva,
   {{0x291ca07a,0x6440a07b,0x6d58a07c,0x4424801c}},	//   _kuva_, hami, kuva, hcm_,
   {{0xceb2093f,0x6440805b,0x6729800d,0xe2a68125}},	//   _ניט_, kami, _stej, _áður_,
   {{0x5d7a00be,0x3f8d809f,0x26d1207d,0x6d589adc}},	//   _פארק, _preu_, lizo_, duva,
   {{0x6440a07e,0x443f8110,0x291ca07f,0x7b6419a5}},	//   dami, vau_, _luva_, _отре,
   {{0x8af00201,0x4426a080,0x6d43a081,0x443fa082}},	//   stər, _afo_, tsna, wau_,
   {{0x443fa083,0x60cd2084,0x645ba085,0x7d02a086}},	//   tau_, _omam, tgui, _bhos,
   {{0x6440a087,0x62838364,0x6d43a088,0x3f8da089}},	//   gami, _sano, rsna, _treu_,
   {{0x443f8355,0x6d43a08a,0x7c3d208b,0x38a2009a}},	//   rau_, ssna, _mesr, _góry_,
   {{0x60cd208c,0x443fa08d,0x78a985f8,0x6283a08e}},	//   _amam, sau_, _hoev, _qano,
   {{0x4432208f,0x6283a090,0x443fa091,0x7d028083}},	//   yby_, _vano, pau_, _fhos,
   {{0x6283a092,0x291c8b80,0x44248c53,0x7d02a093}},	//   _wano, _duva_, ccm_, _ghos,
   {{0x7d09a094,0x69c18065,0x628382b8,0x4432003e}},	//   mmes, szle, _tano, vby_,
   {{0x7d09a095,0x78bb85a4,0x26d12096,0xe29a80ff}},	//   lmes, _lluv, gizo_, _thưa_,
   {{0x4432026f,0xde032097,0x6da62098,0x443d83ec}},	//   tby_, епри, чива, _kew_,
   {{0xdca31e25,0x7d098214,0x03260009,0x61fc8214}},	//   наси, nmes, здан, ürle,
   {{0x44322099,0x26d11ea2,0xeb97209a,0x6d4101fa}},	// [1160] rby_, bizo_, пит_, álar,
   {{0x4432209b,0x09e60ae7,0xb87b209c,0x7c24209d}},	//   sby_, позн, gníf, scir,
   {{0x7d09a09e,0x6440999f,0x78a28144,0x7cfe83ed}},	//   kmes, yami, tjov, hëra,
   {{0x443d804c,0xd12f07bd,0x6440a09f,0x60cd00b9}},	//   _new_, امن_, xami, _xmam,
   {{0x6440a0a0,0x8af00085,0x2cbf80e4,0x7d09a0a1}},	//   vami, stəq, dhud_, dmes,
   {{0x6d58a0a2,0xab270698,0xd94620a3,0x33fb01c6}},	//   tuva, _хора_, _неги, _להכנ,
   {{0x7d02a0a4,0xda788038,0x6440a0a5,0x205699fa}},	//   _phos, veď_, tami, _нтар,
   {{0x6d58a0a6,0x443d808e,0x78bba0a7,0x89db01c6}},	//   ruva, _cew_, _gluv, _החלי,
   {{0x6440a0a8,0xe7378364,0x6d58a0a9,0x291c9adc}},	//   rami, _нет_, suva, _suva_,
   {{0xc333004c,0x6440a0aa,0xbebb03ed,0x6d58a079}},	//   עות_, sami, hpër, puva,
   {{0x7d02a0ab,0x2eeea0ac,0x443d8039,0x705519ea}},	//   _thos, moff_, _few_, وندا,
   {{0x443da0ad,0xf8bf01d0,0x38bb03ed,0x644085e7}},	//   _gew_, uhé_, _bëra_, qami,
   {{0x26d1022e,0xb8e503ca,0x2d8c0366,0xdcb10129}},	//   tizo_, _एत_, æden_, ểm_,
   {{0xba178013,0x2eeea0ae,0x7bc41c28,0x6b82a0af}},	//   _فيها_, noff_, dziu, _isog,
   {{0xdd940084,0x26d120b0,0x443da0b1,0x35e400e8}},	//   нары, rizo_, _yew_, ецтв,
   {{0x6aaaa0b2,0x26d120b3,0x60cd20b4,0x20d201d6}},	//   _hoff, sizo_, _umam, pšia_,
   {{0x6aaaa0b5,0x2bc70c78,0xe803064a,0xa3d009a9}},	// [1170] _koff, _रेखा, रेखा_, _वेद_,
   {{0x7b09025b,0x672d20b6,0x6aaaa0b7,0x6d488253}},	//   _ažur, _itaj, _joff, _ovda,
   {{0x2d8c0082,0x6aaaa0b8,0x7d09a0b9,0x2d8120ba}},	//   ådet_, _moff, ymes, _ushe_,
   {{0x92bf00ab,0x6d55192c,0xcfd20091,0x98a60162}},	//   ুকে_, mrza, _apẹẹ, mplă_,
   {{0x2489009c,0x7b09026c,0x629883b2,0x7feba0bb}},	//   mdam_, _džur, _onvo, حراف_,
   {{0x443d81b9,0x6b8d0314,0x248920bc,0x672d0c53}},	//   _sew_, mvag, ldam_, _mtaj,
   {{0xa3b50063,0x78a9838e,0x58d5835f,0x236920bd}},	//   जनक_, _toev, _жовт, ltaj_,
   {{0x645f01f6,0x672d20be,0xb87b0118,0xe3b9a0bf}},	//   ngqi, _otaj, alíz, жби_,
   {{0xa3e7890a,0x236920c0,0xf770803f,0x7d09a0c1}},	//   _मुख_, ntaj_, _مال_, rmes,
   {{0x88bd000d,0xeab180f7,0x25e88321,0x7d09a0c2}},	//   zpět, ئعة_, _चुकी_, smes,
   {{0x7643a0c3,0x6b82a0c4,0x41b4896b,0x672d20c5}},	//   many, _esog, есят, _ataj,
   {{0x6298a0c6,0x6d550042,0x628720c7,0x7643a0c8}},	//   _envo, drza, _lajo, lany,
   {{0xa49b0104,0x7d1e0024,0x6d55066f,0x9b94862c}},	//   _phòn, _sups, erza, _пицц,
   {{0x7643a0c9,0x62870b48,0x6aaaa0ca,0x24890dba}},	//   nany, _najo, _goff, edam_,
   {{0x672d20cb,0x9fa00cab,0x24890901,0x236918ad}},	//   _etaj, _méér_, fdam_, etaj_,
   {{0x7643a0cc,0xc10600f7,0x38bb03ed,0x7bc402f9}},	//   hany, _توبي, _tëra_, tziu,
   {{0x7643a0cd,0x52aa176e,0xcb670dc0,0x248601ac}},	// [1180] kany, овам_, мате_, ľom_,
   {{0x628720ce,0x7643a0cf,0x0f5701c6,0x63ab1d31}},	//   _cajo, jany, _קיים_, ägna,
   {{0x7643a0d0,0x7e7c20d1,0x673ba0d2,0x5e9b01c6}},	//   dany, merp, _awuj, _וביק,
   {{0x6d5c20d3,0x6aaa9c7b,0x628705ee,0x673b818e}},	//   mura, _चक्र, _eajo, _bwuj,
   {{0x7643a0d4,0x6d5c0886,0x62888355,0xb906a0d5}},	//   fany, lura, yddo, _पद_,
   {{0x395a20d6,0x7643a0d7,0x3ced0503,0x670020d8}},	//   pups_, gany, čeve_, ोगिक_,
   {{0x6d5c20d9,0xf98320da,0x6aaaa0db,0x99878196}},	//   nura, _игро, _roff, _menų_,
   {{0x2ebb0894,0x6aaaa0dc,0x2eee8748,0x7e7c20dd}},	//   _उत्त, _soff, soff_, herp,
   {{0x7643a08c,0x7eb48580,0x60c29a1f,0xda7a847f}},	//   bany, _làpi, mhom, оян_,
   {{0x3ce9803b,0xd2508077,0x764382a0,0x60c2a0de}},	//   čava_, دند_, cany, lhom,
   {{0x28f905e9,0x6288831d,0x644420df,0x7e7c20e0}},	//   зень_, rddo, kaii, derp,
   {{0x6d5c20e1,0x2369009a,0x6720a0e2,0x049381a8}},	//   dura, ytaj_, _kumj, _للمح,
   {{0x6aaaa0e3,0x6f17008e,0xfc3f0144,0x60dd20e4}},	//   _toff, _pixc, _reí_, rnsm,
   {{0x6d5c0010,0x7e7c20e5,0x62988192,0x68ef0df6}},	//   fura, gerp, _unvo, socd,
   {{0x628720e6,0x60c2805d,0x7eb487f1,0xa49b0706}},	//   _rajo, khom, _càpi, _fhòl,
   {{0x7643a0e7,0x6d4720e8,0xb4fb20e9,0x3f8481a1}},	//   zany, rsja, ्षेप_, _osmu_,
   {{0x248920ea,0x7643a0eb,0x2d9e02af,0x2d8c0aa2}},	// [1190] rdam_, yany, äter_, åder_,
   {{0x6d5c20eb,0x236920ec,0x9af500f7,0xb87b0144}},	//   bura, rtaj_, ركات, coír,
   {{0x236920ed,0x7643a0ee,0x6d5c20ef,0x6b8d20f0}},	//   staj_, vany, cura, svag,
   {{0x7643a0f1,0x2bd020f2,0xe80c20f3,0xe0df01e8}},	//   wany, _सेवा, सेवा_, nnò_,
   {{0x7643a0f4,0x7d0d20f5,0xf388801c,0x628720f6}},	//   tany, mmas, _nợ_, _tajo,
   {{0x7d0d20f7,0x442920f8,0xddde20f9,0x69c586ae}},	//   lmas, lca_, _hapš, _üheg,
   {{0x7643a0fa,0x3f8480eb,0x442907b6,0x00000000}},	//   rany, _esmu_, oca_, --,
   {{0x7d0d20fb,0x7643a0fc,0x60c2a0fd,0xb385824f}},	//   nmas, sany, chom, елил,
   {{0x7643a0fe,0x7cfe80f1,0x7d0d20ff,0x375580d7}},	//   pany, përn, imas, _سپاس,
   {{0x3eac805f,0x13068364,0x6d5c2100,0xde97806b}},	//   _godt_, нный_, yura, _تجرب,
   {{0xd12e817e,0xe4a7802e,0x98bf0110,0x644f1660}},	//   یمی_, _ордо, nutė_, _odci,
   {{0x76418117,0xf9920158,0xb4e9000d,0x7eb4809f}},	//   _hely, ארט_, मको_, _ràpi,
   {{0x44292101,0xe8df8870,0x42cd80ab,0x6d5c2102}},	//   dca_, _abịa_, রকৌশ, wura,
   {{0x91e591c7,0x09e5a103,0x6d5c2104,0xa3d0081f}},	//   _поле, _полн, tura, _वेष_,
   {{0x7641a105,0x44292106,0xa3d3864a,0x998581a8}},	//   _mely, fca_, _हेत_, _ألبو,
   {{0x44290af8,0x442b2107,0x7d0d2108,0x78ad0176}},	//   gca_, _cfc_, gmas, _goav,
   {{0x68e40133,0x245a82d0,0x42562109,0x6b8900fe}},	// [11a0] _ijid, lümü_, етет, _šegr,
   {{0x6d5c210a,0x4429210b,0x160f897d,0xb05b1b48}},	//   pura, aca_, ाधार_, nhän,
   {{0x60c2805d,0x2726001c,0x442b0140,0x8c460703}},	//   thom, _hôn_, _ffc_, _пене,
   {{0x4429210c,0x70f680f7,0x7eb00074,0x03a6210d}},	//   cca_, رسائ, _täps, _зимо,
   {{0xb87b001b,0x20d2007a,0xa2b4801b,0x74160061}},	//   lníc, jšim_, ेसम्, _سوسا,
   {{0x7cfe80f1,0x60c2966a,0x2726210e,0x7c2ba10f}},	//   tëro, shom, _môn_, _afgr,
   {{0x91e60abe,0xf388801c,0x629c2110,0x27262111}},	//   _чове, _sợ_, _inro, _lôn_,
   {{0x7ae381a1,0x75218661,0x68e401bc,0x7c29823e}},	//   _ajnt, _dulz, _njid, gcer,
   {{0xdcfa8087,0x63a42112,0x2245a113,0x69080118}},	//   _astă, nxin, falk_, iñed,
   {{0x44292114,0xf3888028,0x7641a115,0x68e4026b}},	//   zca_, _vợ_, _gely, _ajid,
   {{0x7cfe80f1,0x6d1f0424,0x1dcf0105,0x44292116}},	//   qëro, _मूंग_, _हेंत, yca_,
   {{0xb87b003e,0x8d5595e3,0x7c29a117,0x254c81d0}},	//   dníc, _штуч, ccer, měl_,
   {{0xe29aa118,0xe80c05b3,0xb05b01ec,0x68e40b80}},	//   _над_, सेला_, bhän, _djid,
   {{0x68e40133,0x4429009a,0x6f1d8037,0x6da189ab}},	//   _ejid, wca_, _èsce, mɓar,
   {{0x6f1aa119,0x7d0d211a,0x4429211b,0x212d01d0}},	//   _mitc, tmas, tca_, _čeho_,
   {{0x4429211c,0xdc88002e,0xccf80eef,0x629c211d}},	//   uca_, нсул_, ећу_, _anro,
   {{0x4429211e,0x7d0d0859,0x98bf002e,0x628aa11f}},	// [11b0] rca_, rmas, astă_, _kafo,
   {{0xa3d0035a,0xb87b03fb,0x68fd2120,0x6d4a8b81}},	//   _वेळ_, bníc, llsd, ksfa,
   {{0x395e809f,0x7641a121,0x442b2122,0xd99900f7}},	//   nuts_, _rely, _tfc_, بنات_,
   {{0x7641a123,0x5fd28074,0x64429995,0x628aa124}},	//   _sely, _देहल, _neoi, _lafo,
   {{0x81bc81a9,0x27260129,0x2bd08072,0x7eb02125}},	//   ucēj, _xôn_, _तेला, _käpp,
   {{0x7521a126,0x20d20503,0x69d5016f,0xf6538065}},	//   _pulz, všim_, _येथी, ائش_,
   {{0xada58098,0x644280f7,0x6d4aa127,0x395e8106}},	//   тайл, _beoi, gsfa, juts_,
   {{0xe7d2a128,0xeb9993f1,0x644281a8,0x3ce98796}},	//   _देवप, дии_, _ceoi, čavo_,
   {{0xb87b026f,0x26c103a7,0xe3b180f7,0x248b00b9}},	//   zníc, _olho_, شرة_, _macm_,
   {{0x290902c1,0x68f62129,0x628a8114,0x7eb0156e}},	//   _ahaa_, _skyd, _cafo, _näpp,
   {{0x395e8722,0x628aa12a,0x27260428,0xbbeb8019}},	//   guts_, _dafo, _sôn_, _کرام_,
   {{0x2d988510,0xb87b027f,0x6442a12b,0x290901bc}},	//   _área_, vníc, _geoi, _chaa_,
   {{0xb05b00f2,0x6a859630,0xb90a0424,0x773a0b79}},	//   mhäl, _алла, _मद_, ьянс_,
   {{0xb87b003e,0x395e87fa,0x7982009a,0x628a8114}},	//   tníc, buts_, łowi, _gafo,
   {{0xe643212c,0x26c100e1,0x200400e1,0xbea309a5}},	//   респ, _dlho_, ťmi_, шарк,
   {{0x248da12d,0xb87b026f,0x2726001c,0x29090133}},	//   ndem_, rníc, _tôn_, _ghaa_,
   {{0x46ea0b88,0xb87b016b,0x2c070a27,0x236d8069}},	// [11c0] _один_, sníc, _शरणं_, ntej_,
   {{0x63a40509,0x3ce001c0,0x63a68106,0x6d4803a2}},	//   rxin, sniv_, äkni, ádas,
   {{0x26d80365,0x67240198,0xae5701c6,0xc96606d2}},	//   miro_, _huij, _בסיס_, твей,
   {{0x7995009a,0x26d802ec,0x38cb9190,0x6d4a84fe}},	//   _drzw, liro_, وانی_, vsfa,
   {{0x6d5a0110,0xf093007c,0xe7d28072,0x23d08035}},	//   štad, ינא_, _देशप, _तेंद,
   {{0x26d802a0,0x248d81b9,0x6d4a848d,0x6d58816b}},	//   niro_, edem_, tsfa, trva,
   {{0xe9a3212e,0x628a808b,0x71a301a1,0x7cfe83ed}},	//   _карп, _rafo, _карз, sërm,
   {{0x7cfe80f1,0x26d800b4,0xb866826a,0x628a831d}},	//   përm, hiro_, _جاسو, _safo,
   {{0x2c6d0019,0x2004805c,0xc4d30039,0x26d8020c}},	//   lódó_, _uzmi_, יגה_, kiro_,
   {{0xbe858bbe,0x395ea12f,0x248005e1,0x69c882af}},	//   _مجمو, tuts_, heim_, tzde,
   {{0x9f4f007b,0x6442a130,0x24802131,0xc8b682f1}},	//   _ágú_, _teoi, keim_, _अकाट,
   {{0x26d82132,0x9f352133,0xe3baa134,0x68e28428}},	//   eiro_, лемі, _обе_, nnod,
   {{0x35a8800f,0x26d8106c,0x26c1022c,0x68e28118}},	//   _कपड़, firo_, _plho_, inod,
   {{0x26d82135,0xbc1b8039,0x6b842136,0x7a4801a9}},	//   giro_, _חודש, dwig, nūtē,
   {{0x1df817ae,0x2ca902f1,0x20d20bcf,0x51f380d7}},	//   веры_, tjad_, kših_, _پسور,
   {{0x20d20353,0x851b082e,0x2d1b01bc,0xa3d683ca}},	//   jših_, _ụgbọ_, _ụgbụ_, _सधा_,
   {{0x68e2803e,0xc2990e02,0x26d82137,0x3a752138}},	// [11d0] dnod, нках_, biro_, ллар,
   {{0x26d802a0,0x3f89026c,0x5a342139,0x78bd213a}},	//   ciro_, _isau_, инут, lksv,
   {{0x68e382ba,0x68e2831d,0xceb204de,0x7bc98338}},	//   éndo, fnod, _היי_, zzeu,
   {{0x61fc213b,0x78bd0bfd,0x68e28286,0x6b84018f}},	//   _dyrl, nksv, gnod, bwig,
   {{0xb9ff81b6,0x78bd0a0f,0xe9ff00ff,0x8afd81d0}},	//   _उर्फ_, iksv, _trắc_, stři,
   {{0x7d1d1010,0x7c2d17d6,0x62340992,0x7e6381c0}},	//   _hiss, lcar, _веру, ugnp,
   {{0x68e2a13c,0xc984213d,0x4519a13e,0xb05b01ec}},	//   bnod, _кути, нция_, thäl,
   {{0x7c2d213f,0x7d1d01b9,0xdb1e016b,0xa49b051e}},	//   ncar, _jiss, _švéd, _bhòi,
   {{0x7d1d2140,0x248da141,0xb05b1b48,0x26d82142}},	//   _miss, rdem_, rhäl, yiro_,
   {{0x248d8573,0x7bc981ec,0x236da143,0x27e081a8}},	//   sdem_, rzeu, rtej_, úine_,
   {{0x291e02be,0xdd918e06,0x50460071,0x186a151a}},	//   _état_, _دوا_, ленб, нани_,
   {{0x7c2d2144,0xd5ba80be,0x26d82145,0x25f700c2}},	//   jcar, _אזעל, wiro_, _एड़ी_,
   {{0xe28e8934,0x1cb88077,0x26d82146,0x7c2d2147}},	//   _ла_, _جالب_, tiro_, dcar,
   {{0x442da148,0x7c3ba149,0x7d1d214a,0x35d886a7}},	//   lce_, lbur, _aiss, _भेड़,
   {{0x649a00ae,0x6281a14b,0x26d81b19,0x7d1d1531}},	//   нтар_, melo, riro_, _biss,
   {{0x442da14c,0x7786214d,0x6281a14e,0x7d1d214f}},	//   nce_, _близ, lelo, _ciss,
   {{0x68e2811f,0x7c3ba150,0x60c42151,0xe29a0073}},	// [11e0] vnod, ibur, _ilim, наа_,
   {{0xc3328051,0x6281a152,0x7bc00201,0x21a61ddf}},	//   צוב_, nelo, _ümum, лизм,
   {{0x442d800d,0x2d9619e3,0x7d1d2153,0x25a50004}},	//   kce_, _српс, _fiss, ällt_,
   {{0x64a62154,0xdca62155,0x7c2d2156,0x7d1d2157}},	//   _сама, _сами, ccar, _giss,
   {{0x442da158,0x6281a159,0x7c3ba15a,0x6d4e215b}},	//   dce_, kelo, dbur, lsba,
   {{0x5694a15c,0x6281a15d,0x7cfe83ed,0x6d5c215e}},	//   ракт, jelo, mëri, orra,
   {{0x6281a15f,0x64462160,0x442202f7,0x628e02c4}},	//   delo, _keki, _kgk_, _iabo,
   {{0x7c3b8135,0x442fa161,0x64462162,0x628e2163}},	//   gbur, _cfg_, _jeki, _habo,
   {{0x28a80b75,0x628e2164,0xb4e4873c,0x6281a165}},	//   गानि, _kabo, _नदी_, felo,
   {{0x49749663,0x6281a166,0x442da167,0x26c7801b}},	//   алос, gelo, ace_, chno_,
   {{0x60c42168,0x442d801b,0x628e2169,0x6d41831d}},	//   _blim, bce_, _mabo, _gwla,
   {{0x442da16a,0x3866a16b,0x7cfe80f1,0x4422216c}},	//   cce_, ngor_, këri, _ngk_,
   {{0xb4c08592,0xb9098870,0x7c22a16d,0x78bd216e}},	//   ँसी_, _achọ_, _igor, rksv,
   {{0x442d0d38,0x7d1d0006,0x628e1c73,0x4422216f}},	//   _że_, _siss, _nabo, _agk_,
   {{0x64460586,0x60c404b7,0x7c2d2170,0x40350470}},	//   _beki, _flim, tcar, _кейс,
   {{0x60c42171,0x64462172,0x4422008e,0x3f890282}},	//   _glim, _ceki, _cgk_, _tsau_,
   {{0x7d1d2173,0x6d5c2174,0x628e2175,0x6d4e2176}},	// [11f0] _viss, arra, _babo, asba,
   {{0x7d1d1ab0,0x442da177,0x628e106c,0xf8bf001b}},	//   _wiss, zce_, _cabo, lké_,
   {{0x7d1d2178,0xb87b00f7,0x628e2179,0x442da17a}},	//   _tiss, nnío, _dabo, yce_,
   {{0xf8bf217b,0x7c22a17c,0x6281a17d,0x38bb0168}},	//   nké_, _ngor, zelo, _bëri_,
   {{0x442d9249,0x07a5981f,0x8fa5a17e,0x36698db3}},	//   vce_, ралн, рале, вало_,
   {{0x7c22983e,0x8d5584db,0x628e217f,0x3869a180}},	//   _agor, атич, _gabo, żar_,
   {{0x62818218,0x442d909b,0x56b800be,0x49932181}},	//   velo, tce_, רפון_, _دیار,
   {{0x628e012b,0xed64026f,0x47359ef0,0x442da182}},	//   _zabo, leží_, _внас, uce_,
   {{0x62818162,0x442da183,0xe7308f24,0x6449a184}},	//   telo, rce_, _فصل_, raei,
   {{0x442da185,0x7c3ba186,0x60c42187,0x7c22a188}},	//   sce_, sbur, _slim, _egor,
   {{0x6281a189,0xceb8809a,0x442d90d1,0xaca38133}},	//   relo, _więc_, pce_, _agụm,
   {{0x62818049,0x65638187,0x272b806a,0x8af0011c}},	//   selo, munh, _køn_, stəx,
   {{0x7bcd218a,0x6446218b,0xfaa5a18c,0x68e98168}},	//   jzau, _reki, _вало, _mjed,
   {{0x6446218d,0x41b511bc,0x98ab0029,0x7c228353}},	//   _seki, ंहास, ībā_, _zgor,
   {{0x68fba18e,0x628e218f,0xb8cc00ab,0x63bba190}},	//   _okud, _rabo, _গত_, lyun,
   {{0xf8bf2191,0x628e03c3,0xdcfc0025,0x27ffa192}},	//   cké_, _sabo, tvrđ, _oyun_,
   {{0x63bba193,0x63a9a194,0x26c581df,0x628e2195}},	// [1200] nyun, nxen, _ollo_, _pabo,
   {{0xc8798201,0x644607fb,0x68e98388,0xed4602c7}},	//   _abş_, _weki, _ajed, _кноп,
   {{0x64462196,0x44220ad4,0x63bb8573,0x27ffa197}},	//   _teki, _tgk_, hyun, _ayun_,
   {{0x7cfe820f,0x290d81df,0x26c58098,0x628e2198}},	//   përi, _chea_, _allo_, _wabo,
   {{0x628e2199,0x7cfe80f1,0x68e982ce,0x16348098}},	//   _tabo, qëri, _djed, беля,
   {{0x68e9a19a,0xf8bf01d0,0x7c22a19b,0x629801d6}},	//   _ejed, zké_, _sgor, ôvod,
   {{0x6563862f,0x91e3179e,0x09e307b6,0x20d201d6}},	//   gunh, _доре, _дорн, lšiu_,
   {{0x26c585b4,0x5fa6016f,0xb4c09513,0x320a219c}},	//   _ello_, खमाल, ँसे_, _izby_,
   {{0xef1a98a0,0x041800ab,0x63bb8019,0x63a98234}},	//   _ама_, ধুরী_, gyun, gxen,
   {{0x291f802e,0xb27381bb,0x657e00e8,0x2902219d}},	//   _ziua_, ольш, _opph, elka_,
   {{0xd90f03f8,0x2247a19e,0x26dca19f,0xadf20768}},	//   ویت_, _denk_, mivo_, _आँगन_,
   {{0x64a3a1a0,0x26dc8f20,0xddc501d0,0x5fdb8a27}},	//   _маха, livo_, _schů, _मेडल,
   {{0xdb028352,0x69c58074,0x27ed0214,0x752880dd}},	//   _groß, _ühen, çen_, _hudz,
   {{0xf8bf03cb,0x7648809a,0x2247a1a1,0x29020079}},	//   ské_, _jedy, _genk_, alka_,
   {{0xe3e88a49,0xd5b814b7,0x7528a1a2,0x2000026b}},	//   _পরিব, аст_, _judz, _eyii_,
   {{0x75288267,0xc05b035f,0x7bcd21a3,0x25de8074}},	//   _mudz, _рік_, tzau, _कइनी_,
   {{0x75288063,0x2bba0035,0x5399062c,0x2d9a0299}},	// [1210] _ludz, jącą_, ывая_, _erpe_,
   {{0x68e9a1a4,0x68fba1a5,0x69c102f1,0xd7fc01c6}},	//   _sjed, _skud, _ülek, _בהחל,
   {{0x272b8aa2,0x248481b9,0xc8ab8098,0x63a4802a}},	//   _søn_, kemm_, къде_, _áinf,
   {{0xf7719301,0x9c13019d,0xa49b0a2a,0xe0d081a8}},	//   كات_, _jọka, _chòt, وزن_,
   {{0x2bde13d9,0x644d04a2,0x2d8c83a8,0x752880eb}},	//   _नेपा, maai, _asde_, _audz,
   {{0x6563a1a6,0x644d21a7,0xb87b01d0,0x20d201a1}},	//   tunh, laai, dním, lšit_,
   {{0x68e982fd,0xa8a7a1a8,0x785782e3,0x7528a1a9}},	//   _tjed, _крак, _نیاز_, _cudz,
   {{0x68e98025,0x6563a1aa,0x224786c0,0x60dd21ab}},	//   _ujed, runh, _senk_, jism,
   {{0x1c4281bb,0xfd488133,0x7b06808b,0x6f1d8037}},	//   чным, _kemị, rðun, _èsco,
   {{0x63a984c3,0x2cad82ce,0x6563a1ac,0x628521ad}},	//   rxen, sjed_, punh, neho,
   {{0x63bb96fb,0x386d8140,0x66c201d6,0x95c8a1ae}},	//   syun, _kcer_, _dôkl, _куца_,
   {{0xe73a0ab5,0x297a012a,0x6721a1af,0x397a0039}},	//   лем_, נטרא, _hilj, נטרנ,
   {{0xeaae9156,0x443fa1b0,0x8ca4809a,0x6d450122}},	//   _ей_, mbu_, कारो, _awha,
   {{0x443fa1b1,0x6285029b,0x6b89a1b2,0x6d4502c4}},	//   lbu_, jeho, mweg, _bwha,
   {{0x80b880c8,0xdca60dd3,0x2d950ff7,0x6285013c}},	//   _আগস্, бави, ортс, deho,
   {{0x70b6800f,0x443fa1b3,0x6721a1b4,0x0c26030d}},	//   _अकेल, nbu_, _lilj, сман,
   {{0x03a30e97,0x6b89a1b5,0x78a406c0,0x443fa1b6}},	// [1220] пито, nweg, _iniv, ibu_,
   {{0x443f8609,0x62851854,0x2d9a0042,0xa49b06c4}},	//   hbu_, geho, _trpe_, _akòd,
   {{0x657e21b7,0x78a40e23,0x499a17ae,0x764895ab}},	//   _upph, _kniv, ытая_, _redy,
   {{0x764e0365,0x443f822b,0x7648a1b8,0x7528a1b9}},	//   laby, jbu_, _sedy, _rudz,
   {{0x7d0421ba,0x7528a1bb,0x5fd28074,0x4b550081}},	//   mlis, _sudz, _देखल, _мърт,
   {{0x7d0421bc,0x66fa0a74,0xf1ca800d,0xdfa580f7}},	//   llis, ृतिक_, ानमन, تحمي,
   {{0x171b0158,0x26dca1bd,0x6721a1be,0x2d9821bf}},	//   נוצע, rivo_, _dilj, nvre_,
   {{0x6cd487bd,0x7d0421c0,0x44320051,0x60dd21c1}},	//   تقبا, nlis, ncy_, xism,
   {{0xe81a1c4f,0x60c2a1b4,0x26dca1c2,0x47c680a9}},	//   नेमा_, mkom, pivo_, _убав,
   {{0x60c292f1,0x7d0421c3,0x6601835f,0x39ae8085}},	//   lkom, hlis, _fylk, ləsi_,
   {{0x443fa1c4,0x8afb00be,0x69c582f1,0x63a4a1c5}},	//   bbu_, רהיי, _ühel, _šind,
   {{0x236021c6,0x7d0421c7,0x66cb0214,0x26da21c8}},	//   krij_, jlis, _müke, _ampo_,
   {{0x4426a1c9,0xe6c48125,0xb87b026f,0x7d0401ac}},	//   _igo_, _þjóð, lník, dlis,
   {{0x7d1600e1,0xf1a69ad0,0x60dd0558,0x39ae8085}},	//   emys, _грин, sism, həsi_,
   {{0x6d5a003b,0x60c2a1ca,0xb87b00e1,0x7afaa1cb}},	//   štan, kkom, nník, mott,
   {{0xd9049fbe,0x60c2a1cc,0xf98f80f7,0x7d0421cd}},	//   _سی_, jkom, _أبو_, glis,
   {{0x2d8c013c,0x60c28370,0x764e21ce,0x644d21cf}},	// [1230] æder_, dkom, baby, raai,
   {{0x7d0421d0,0x443fa1d1,0x7afa84fa,0x325521d2}},	//   alis, zbu_, nott, івер,
   {{0x7d0421d3,0x4426a1d4,0x443fa1d5,0x6ab500ff}},	//   blis, _ogo_, ybu_, _vozf,
   {{0x4426a1d6,0x60c282b8,0x212a0083,0xb87b026f}},	//   _ngo_, gkom, _dubh_, dník,
   {{0xd366a1d7,0x672985a4,0x443f826f,0x7afaa1d8}},	//   _ته_, _quej, vbu_, kott,
   {{0x24ab00ab,0x60c2a1d9,0xa3be8dd2,0x3ce90162}},	//   _ঐতিহ, akom, ीनन_, lnav_,
   {{0x7afaa1da,0x6721a1db,0x68ed21dc,0x442682c4}},	//   dott, _vilj, _ojad, _bgo_,
   {{0x6b89a1dd,0x39ae811c,0x60c2a1de,0xa0c5a1df}},	//   tweg, cəsi_, ckom, _بيرو,
   {{0x443fa1e0,0x7b1001ec,0x44268144,0x6b89890d}},	//   rbu_, bäud, _dgo_, uweg,
   {{0x44268a2c,0x66018d38,0x443fa1e1,0xb87b05b9}},	//   _ego_, _tylk, sbu_, bník,
   {{0x00860cec,0x7d0421e2,0x6b8981ec,0xb87b04e8}},	//   олно, ylis, sweg, cník,
   {{0x2eb421e3,0xc952007c,0x9c1301bc,0x7d0402ed}},	//   ुस्त, ומט_, _tọha, xlis,
   {{0xfc4601ac,0x764e21e4,0x68ed21e5,0xbebb0168}},	//   šíka_, taby, _djad, jqës,
   {{0x4432009a,0x7afaa1e6,0x6145814f,0x7d0421e7}},	//   wcy_, cott, _дека, wlis,
   {{0x60c9a1e8,0x644ba1e9,0x7d040b81,0x764e21ea}},	//   _olem, _kegi, tlis, raby,
   {{0x78a421eb,0x764e1b19,0x0ce800ab,0xb05b1a50}},	//   _univ, saby, পত্ত, lkän,
   {{0x272f084a,0x7d0421ec,0xb87b003e,0xeb970009}},	// [1240] _gün_, rlis, zník, оит_,
   {{0xda6600f7,0x4432009a,0xdc3c9e1e,0x60dba1ed}},	//   تاري, scy_, váčk, _amum,
   {{0x7d0421ee,0x6459809a,0x60c29151,0x1d0a0703}},	//   plis, _odwi, tkom, _вени_,
   {{0xb87b003e,0x7afa8019,0x6fdb80d4,0x53a6161a}},	//   vník, zott, _मेहं, _дамб,
   {{0x39ae8085,0x2bd9a1ef,0x888d00be,0x60c9810c}},	//   rəsi_, _बेला, טראַ, _dlem,
   {{0x8f9b1b9e,0xb87b026f,0x60c2a1f0,0x66cb21f1}},	//   ייני, tník, skom, _tüke,
   {{0x2bde00ba,0xb05b016d,0x7afaa1f2,0x60c9a1f3}},	//   _नेता, dkän, vott, _flem,
   {{0x412721f4,0x60c98bc5,0xb87b1c18,0x644ba1f5}},	//   _фото_, _glem, rník, _cegi,
   {{0x7afa8065,0x2aaa9285,0x8e76a1f6,0x644ba1f7}},	//   tott, атно_, _мужч, _degi,
   {{0x7cfe80f1,0x6459a1f8,0x3ce00074,0x8af00085}},	//   tërs, _edwi, hiiv_, qsəd,
   {{0x2730a1f9,0x7afaa1fa,0xe8950087,0x644ba1fb}},	//   _hàn_, rott, пань, _fegi,
   {{0x6ab70a74,0x4426a1fc,0x2d9ea1fd,0xbebb0168}},	//   _आक्र, _ugo_, _irte_, yqës,
   {{0x6d5a0b48,0x69c10074,0x3ce902d4,0xdb2482f1}},	//   štal, _ülev, vnav_, öpäe,
   {{0x20050029,0x27308028,0xdefb0d15,0x2bd5001b}},	//   āli_, _màn_, рым_, _ठेगा,
   {{0x2730a1fe,0x6288a1ff,0xc8bc9a3b,0x2ebc80ab}},	//   _làn_, medo, ्घाट, _অগাষ,
   {{0x6288a200,0x70b98074,0x63ad2201,0x68ed2202}},	//   ledo, _आवेल, txan, _ujad,
   {{0x60c02203,0xb87b001b,0x68fd0168,0x27308129}},	// [1250] ömme, vníh, mosd, _nàn_,
   {{0x6288a204,0x63ad2205,0x21248706,0x2d9e8192}},	//   nedo, rxan, _aimh_, _orte_,
   {{0xdc3f026f,0x672d0168,0xb87b01d0,0x59ca98b1}},	//   líčk, _huaj, tníh, ानिर,
   {{0xd04f0201,0x2730a206,0x628881bc,0x26f5a207}},	//   ticə, _bàn_, hedo, ेत्र_,
   {{0x2d9ea208,0x6d488079,0xf745a209,0x23d98127}},	//   _arte_, _awda, чело, _बेंद,
   {{0x2730a20a,0x644ba20b,0x62889351,0x672d00f1}},	//   _dàn_, _segi, jedo, _muaj,
   {{0x6288a20c,0x6b8d0a0f,0x672d0168,0x2d9e812b}},	//   dedo, lwag, _luaj, _crte_,
   {{0x60dba20d,0x60c9a20e,0x6295018e,0x29190088}},	//   _umum, _ulem, _hazo, jmsa_,
   {{0x6295220f,0x6b8d2210,0x644b808b,0x7cfe8168}},	//   _kazo, nwag, _vegi, tërr,
   {{0xdd959006,0x3ed580f7,0x62952211,0x6288a212}},	//   _назы, _عقار, _jazo, gedo,
   {{0x644ba213,0x62952214,0xb05b1a50,0x236901c5}},	//   _tegi, _mazo, rkän, huaj_,
   {{0x6b8d1b86,0x62952215,0xb05b0338,0x68fd2216}},	//   kwag, _lazo, skän, gosd,
   {{0x24892217,0xe299a218,0xa3d3816f,0x6288a219}},	//   deam_, _гал_, _हेच_, bedo,
   {{0x6d5a0904,0x2cb90706,0x62889ee5,0x672d03ed}},	//   štam, _aosd_, cedo, _duaj,
   {{0x2d9e003e,0x6da31a19,0xada30071,0x764380dd}},	//   íte_, нира, нарл, ibny,
   {{0x01c300c8,0x5fbd8651,0xd7bd8072,0x2cb90706}},	//   ্পাদ, ्नाल, ्नाच, _cosd_,
   {{0x6295221a,0x672d0fe2,0x673b8282,0xe45f0106}},	// [1260] _bazo, _guaj, _ntuj, _glöm_,
   {{0x479b0051,0x0e660009,0x3f92221b,0x6295016a}},	//   _פייס, _экон, _isyu_, _cazo,
   {{0x2730a21c,0x69c1a21d,0x98b08289,0x3ebb0039}},	//   _sàn_, nyle, šači_, _הציב,
   {{0x7762a21e,0xa06aa21f,0x7ae1a220,0x6b8d2221}},	//   trox, сада_, hilt, bwag,
   {{0x7ae1a222,0xfc3f1727,0x64442223,0x65638192}},	//   kilt, _unía_, mbii, ernh,
   {{0x628897ad,0x996401d0,0x62952224,0x2b4014a9}},	//   xedo, může_, _gazo, mpic_,
   {{0x28af06b7,0x6b82a225,0x515519d9,0xb0cc1c7b}},	//   टामि, _spog, _отту, ासाग,
   {{0x2d9e8042,0x2124a226,0x6288831d,0x2730a227}},	//   _vrte_, _uimh_, wedo, _tàn_,
   {{0xfc3f82ba,0x62952228,0x66cb06ae,0xbbb88c28}},	//   ñía_, _yazo, _lüka, ेनेक,
   {{0x7ae1a229,0xb6c88065,0x7afe222a,0x7f3b8039}},	//   gilt, _بارے_, nopt, _לעמו,
   {{0x6d5a003b,0x2d9e811e,0x68fd222b,0x6b8d222c}},	//   štaj, _urte_, tosd, zwag,
   {{0xeafa0670,0x68e2a22d,0x2ca6a22e,0xab5d8035}},	//   ्तुत_, niod, _unod_, wyże,
   {{0x7ae1a22f,0xfaa68391,0x672d00f1,0x6288a230}},	//   bilt, _надо, _quaj, pedo,
   {{0x628880f1,0x0ebe8b9f,0x672d0168,0x6d552231}},	//   qedo, ्सिड, _vuaj, tsza,
   {{0x24892232,0x672504a2,0xf2978496,0x3ebe18b6}},	//   team_, _vihj, _זכור_, ötta_,
   {{0x6d552233,0x23692234,0x6b8d2235,0xfbde016f}},	//   rsza, tuaj_, twag, _नेहम,
   {{0x6d550065,0x62952236,0x68e2a237,0xa3be852a}},	// [1270] ssza, _pazo, diod, ीनि_,
   {{0x6b8d2238,0x60cd2239,0x88bd8035,0x92940162}},	//   rwag, _hlam, _ciśn, науц,
   {{0xc1788110,0x673b80dd,0x64440365,0x7d028061}},	//   ntė_, _stuj, bbii, _okos,
   {{0xa3be823c,0xc5f2004c,0x2ec5a23a,0xc1788110}},	//   ीना_, _ידי_, वस्त, itė_,
   {{0x629501e0,0x635e0162,0x644f01a9,0x041b0264}},	//   _tazo, tănţ, _ieci, _ফ্রী_,
   {{0x60cd223b,0x7d02a23c,0x25de800d,0x7afe223d}},	//   _llam, _akos, _केही_, copt,
   {{0x644f1a67,0xf6508154,0x68e2826b,0x60cd02d0}},	//   _keci, ائه_, biod, _olam,
   {{0x68e2802e,0x2ee301ed,0x387f81bf,0xe8948110}},	//   ciod, hijf_, _ubur_, _пась,
   {{0x644f223e,0x7ae1a23f,0xeb99a240,0x645d0144}},	//   _meci, tilt, цип_, _mdsi,
   {{0x78bba241,0x69c10074,0x66cf80e8,0xb05b1743}},	//   _houv, _üles, _bøke, skäl,
   {{0x78bba242,0x7ae1a243,0x44390174,0xa88a2244}},	//   _kouv, rilt, _ofs_, ойна_,
   {{0xafe6035f,0xa3ad001b,0x7ae1a245,0x15e3850a}},	//   домл, कमा_, silt, _केयर_,
   {{0x78bba246,0xb8e61c7b,0x66d0016d,0x7d09a247}},	//   _mouv, _एव_, _läke, mles,
   {{0x78bba248,0x60cd2249,0x7d09938e,0x644f224a}},	//   _louv, _elam, lles, _aeci,
   {{0xcb128051,0x644f003d,0x66d00009,0x999801a1}},	//   _שלו_, _beci, _näke, _serž_,
   {{0x78bba24b,0x7afe02d6,0x68e2802a,0xb05b224c}},	//   _nouv, wopt, xiod, shär,
   {{0x7d09a24d,0x073a00f7,0xb05b01ec,0x443902ed}},	// [1280] iles, _بسبب_, phär, _dfs_,
   {{0x244c001c,0x7d09a24e,0x273b8162,0x05000264}},	//   ếm_, hles, _mână_, ্দের_,
   {{0x27340364,0x2d9c0019,0x63a904b7,0x644f224f}},	//   _hän_, _éve_, _ġene, _feci,
   {{0x588381bb,0x78bb82be,0x7d098019,0x60cd00b9}},	//   выша, _couv, jles, _xlam,
   {{0x78bb83ec,0x2d8582d6,0xd5af80d7,0x711b03de}},	//   _douv, _aple_, یفه_, קונפ,
   {{0x273400f2,0x68e2a250,0xbea38652,0x44390299}},	//   _män_, siod, качк, _zfs_,
   {{0x2734016d,0x7d09a251,0x3d0a8072,0x26198075}},	//   _län_, fles, ातले_, येली_,
   {{0x78bba252,0x1ee88117,0x6abc007b,0x9972801b}},	//   _gouv, _کوئی_, _horf, těže_,
   {{0x66cf80e8,0x69c106ae,0x2d85a253,0x60cd0229}},	//   _søke, _üler, _eple_, _rlam,
   {{0x60cd2254,0xf743a255,0x7d1ba256,0xf7d7807c}},	//   _slam, _рефо, amus, _חומש_,
   {{0x7c398428,0xa50a8087,0xb05b1d31,0xa2d4a257}},	//   _ffwr, _дежа_, skäm, योग्,
   {{0x7d09a258,0x2bd981b6,0x22498904,0xc1788110}},	//   cles, _बेका, _đake_, rtė_,
   {{0xad1b8158,0xe81a101e,0x644f2259,0x6d588e51}},	//   _וואר, नेला_, _reci, lsva,
   {{0x644f225a,0x32078114,0x4439225b,0x63a2a25c}},	//   _seci, _fyny_, _sfs_, _iron,
   {{0x63a2a25d,0x6728a25e,0x6d58a25f,0x27fa809a}},	//   _hron, _midj, nsva, ępny_,
   {{0x60cd0812,0x629aa260,0x6ee900ce,0xc983802e}},	//   _ulam, ldto, džbe, _руши,
   {{0x66d004b8,0xbf0ea261,0x5b152262,0x63a28077}},	// [1290] _säke, िताभ_, емат, _jron,
   {{0xd251045b,0x67160996,0x78bba263,0x6abc0114}},	//   انا_, _दीपक_, _souv, _corf,
   {{0x78bba264,0x25de835a,0x7d00a265,0x44390358}},	//   _pouv, _केली_, koms, _tfs_,
   {{0x62988021,0x63a2a266,0x90158221,0x7d0904b7}},	//   _lavo, _oron, нфлі, ċess,
   {{0x6abc2267,0x8e8590ca,0xe8d803c8,0x6d5aa1ad}},	//   _forf, егле, וואר_, _avta,
   {{0x6abc031d,0x2bd986a7,0x7a318061,0x7f4d02a6}},	//   _gorf, _बेगा, _műté, _mwaq,
   {{0xdce88182,0x63a2a268,0xd5b192c8,0x7d09a269}},	//   _ardı, _aron, افع_, tles,
   {{0x273b802e,0x9f518019,0x212900b9,0x6aaa8428}},	//   _până_, ából_, _niah_, _anff,
   {{0x7d09a26a,0x65938085,0x200921e5,0x03259af6}},	//   rles, _məhə, _nyai_, ндин,
   {{0xeab18013,0x39458987,0xaad9809a,0x7dee0019}},	//   اعة_, нног, योंक, nősé,
   {{0x6298a26b,0x212900b9,0x69c5226c,0x7d1ba26d}},	//   _davo, _biah_, nyhe, pmus,
   {{0x0ef80540,0xf9da00be,0x629aa26e,0x6d438372}},	//   ंक्स_, פֿיל, adto, mpna,
   {{0x63a2a26f,0x21290359,0xbbeb9c81,0x6d43a270}},	//   _gron, _diah_, _برام_, lpna,
   {{0x248d856c,0x2734016d,0xe3b080d5,0x290b017f}},	//   leem_, _vän_, _خرم_, alca_,
   {{0x57bd83bb,0xdd92187e,0x2cbda271,0x24990493}},	//   ्नुह, دوز_, _kowd_, _basm_,
   {{0x248d879f,0x050000ab,0x91fc81a9,0x94260087}},	//   neem_, ্দ্র_, rgāt, ембе,
   {{0x38600068,0x29022272,0x6abc2273,0xc4d280be}},	// [12a0] _idir_, moka_, _porf, אגן_,
   {{0x248d8069,0x29022274,0x68e62275,0xe2972276}},	//   heem_, loka_, likd, нау_,
   {{0xa3bc04e5,0x67288699,0xa84a81a8,0x6abc2277}},	//   _अथक_, _ridj, كلام_, _vorf,
   {{0x25a5006a,0x26150816,0x26ca00b9,0x6d58a09b}},	//   ælle_, _धरती_, lkbo_, vsva,
   {{0x66e69383,0x656e2278,0x1c1c2279,0x6abc227a}},	//   нода, lubh, पेशल_, _torf,
   {{0x6456227b,0x6d58a27c,0x290200b4,0x6d41227d}},	//   layi, tsva, hoka_, ílag,
   {{0x6728a27e,0x29020365,0xe9f980ff,0x248d81c0}},	//   _vidj, koka_, _đế_, feem_,
   {{0x6298a27f,0x6d58a280,0x64562281,0x6728a282}},	//   _savo, rsva, nayi, _widj,
   {{0x29022283,0x6298a284,0x1e86a285,0x7d00a286}},	//   doka_, _pavo, _плам, roms,
   {{0x6456005d,0x656e0234,0xdce380eb,0x2fc681c0}},	//   hayi, kubh, runā, myog_,
   {{0xfbcf82e3,0x200900dd,0x29022287,0x212900b9}},	//   لتی_, _syai_, foka_, _piah_,
   {{0x63a28142,0x38600362,0x29022288,0x3cfa0035}},	//   _tron, _cdir_, goka_, ंवों_,
   {{0x09dd0b6f,0xbfa81fbc,0x6298a289,0x249900b9}},	//   _मध्य, нтре_, _tavo, _rasm_,
   {{0x38600086,0x63ad8390,0x61eb8019,0x3ebea28a}},	//   _edir_, _šang, állá, _jott_,
   {{0x2902228b,0x3a3780be,0xe29b80be,0x3eac808e}},	//   boka_, _ארום_, _זשור, _mndt_,
   {{0x3ebea28c,0x6456228d,0xade38074,0xb05b0198}},	//   _lott_, gayi, _कइसन_, kkäi,
   {{0x3a75228e,0x7dee0065,0xe7e081ce,0x66cb0059}},	// [12b0] клар, tősé, _खेला_, _yükl,
   {{0x6911a28f,0x63bd8aa2,0x3ebe81a1,0x257a83ed}},	//   gåen, øsni, _nott_, kël_,
   {{0x64562290,0xa5f92134,0x1df90009,0x7ae52291}},	//   bayi, _цену_, _цены_, riht,
   {{0xf7718124,0xa90784c1,0x248d822c,0x69c50a53}},	//   لات_, ربان, xeem_, ryhe,
   {{0x7d0d2292,0x3ebea293,0x57bd81d0,0x23c72294}},	//   mlas, _bott_, ्नेह, _díjú_,
   {{0x29022295,0x66d00338,0xdb029407,0xaca78061}},	//   zoka_, _käka, _droë, کھئے_,
   {{0x6d5a0025,0x257a80f1,0x1af42296,0x3ebe847f}},	//   štav, gël_, _спря, _dott_,
   {{0x7d0d2297,0x2fc68420,0x6b848162,0x3eac9277}},	//   nlas, byog_, _ţiga, _endt_,
   {{0x66d000f2,0x3f8901c5,0x98a80087,0x07359bc1}},	//   _läka, _npau_, _lună_, _резю,
   {{0x7d0d073b,0x3ebea298,0x78ad2299,0x248da29a}},	//   hlas, _gott_, _anav, seem_,
   {{0x2902229b,0xa06a229c,0x3de100c8,0x7d0d043c}},	//   toka_, мана_, _মুসল, klas,
   {{0x48e60381,0x6f03a29d,0xa2a1a29e,0x23690304}},	//   томв, lonc, _कोर्, kraj_,
   {{0x29020ee1,0xe28ea29f,0x2bd98105,0x6449a2a0}},	//   roka_, _ка_, _बेचा, mbei,
   {{0x6f03a2a1,0x8a059a19,0x98a80087,0x6449a2a2}},	//   nonc, _изле, _bună_, lbei,
   {{0x645622a3,0x290222a4,0xfc3f01d6,0xceb28e82}},	//   tayi, poka_, _kníh_, סיל_,
   {{0x320a0690,0x6449a2a5,0x443d808e,0x7c3b8888}},	//   _ryby_, nbei, _jfw_, ncur,
   {{0x6f039122,0x645622a6,0xa50722a7,0x6911a2a8}},	// [12c0] konc, rayi, тета_, tåen,
   {{0x6281822b,0x645622a9,0x4a431819,0x69c582f1}},	//   nflo, sayi, инув, _ühes,
   {{0x6d4182a6,0x645622aa,0x3ebea2ab,0x00000000}},	//   _ntla, payi, _rott_, --,
   {{0xf7468256,0x3ebea2ac,0x00e68081,0x2d3e0870}},	//   ведо, _sott_, ъжен, _ọgwụ_,
   {{0xd7ef8013,0x6f0380e7,0x7d0422ad,0x3ebea2ae}},	//   يكم_, fonc, mois, _pott_,
   {{0x7d0422af,0xa2a1a2b0,0x6d5a01ac,0x442f8752}},	//   lois, _कोल्, štau, _agg_,
   {{0x180f035a,0x6d5c048d,0x68e422b1,0x1ae319a5}},	//   _सर्व_, nsra, _omid, _торм,
   {{0x629c1a7b,0x7d0422b2,0x22498904,0x6d5c22b3}},	//   _haro, nois, _đaka_, isra,
   {{0x629c22b4,0xcb678fbb,0x4f268196,0x613e80eb}},	//   _karo, вање_, _адаб, _mīle,
   {{0x60c0a2b5,0x629c185c,0x629e22b6,0x02a6a2b7}},	//   _homm, _jaro, ndpo, трим,
   {{0x629c202e,0xf4848077,0x7d040364,0xd48f8ba8}},	//   _maro, _ماشی, kois, _кр_,
   {{0x629c009c,0xcfa98019,0x7793003d,0x6d5c22b8}},	//   _laro, _تاہم_, لیبا, dsra,
   {{0x248680fc,0x7d0422b9,0xb4c09130,0x98a80493}},	//   _ibom_, dois, ुसी_, _sună_,
   {{0x752b802a,0x76588010,0x60c0a2ba,0x68e422bb}},	//   _zigz, navy, _lomm, _emid,
   {{0x2fcd003b,0xd6d8035f,0xe5c411a8,0x7d0d22bc}},	//   šeg_, ття_, асто, tlas,
   {{0x60c0a2bd,0x78ad0c93,0x236922be,0x4aa6864a}},	//   _nomm, _unav, traj_, _कोतव,
   {{0x629c22bf,0x7b32809a,0x7d0d22c0,0x69c8a2c1}},	// [12d0] _baro, _dług, rlas, lyde,
   {{0x7d0d22c2,0xade38074,0xfde38074,0x629c22c3}},	//   slas, _कइलन_, _कइलस_, _caro,
   {{0x7d0d22c4,0x7d041009,0x6f0380c3,0x6f0200f7}},	//   plas, bois, vonc, _íoca,
   {{0x60c0a2c5,0xf09f22c6,0x7d0d208e,0x48e180ab}},	//   _comm, ndà_, qlas, যক্র,
   {{0x6f0385b4,0x973580d5,0x60c0a2c7,0x26c1016b}},	//   tonc, اکرا, _domm, _koho_,
   {{0x629c22c8,0x60c08b99,0x26c103e4,0x69c88646}},	//   _garo, _eomm, _joho_, kyde,
   {{0xceb40451,0x26c11ab3,0xf0758019,0x60c08372}},	//   ייס_, _moho_, _میاں_, _fomm,
   {{0x60c0a2c9,0x290901bc,0x394601a1,0x7c3b82df}},	//   _gomm, _nkaa_, ćost_, ucur,
   {{0x6449a2ca,0x7c3b8012,0x57f5a2cb,0x27e080f7}},	//   rbei, rcur, _спат, úint_,
   {{0x3ce901e9,0x68e422cc,0xa3bb0006,0x290922cd}},	//   hiav_, _smid, _अपन_, _akaa_,
   {{0x6281a2ce,0xaad98770,0x59ca90be,0x6d41a2cf}},	//   rflo, योगक, ानगर, _utla,
   {{0x6281808b,0xf7460293,0x20c201a8,0x6fa78697}},	//   sflo, лемо, _cóip_, चिपू,
   {{0x6b65a2d0,0x2d0f835a,0x7b06807b,0x4b7980be}},	//   _скла, ातील_, rður, _נאַו,
   {{0x249fa2d1,0xe2968226,0x249d81c5,0x7ae381f6}},	//   ldum_, _баш_, _hawm_, _umnt,
   {{0xa0a622d2,0x7d040009,0x249d81e9,0x69118370}},	//   _байд, tois, _kawm_, tåel,
   {{0x249f8125,0x68e422d3,0x97c61e91,0x212d8359}},	//   ndum_, _umid, _مقبو, _nieh_,
   {{0xcb67023a,0x60c0a2d4,0x237fa2d5,0xdd038084}},	// [12e0] лате_, _romm, ntuj_, ūrėj,
   {{0xda650013,0x249d90af,0x6d5a04c3,0x8f9b0039}},	//   لامي, _lawm_, átas, _טיפי,
   {{0x629c22d6,0x60c0a2d7,0x2cafa2d8,0x7d0422d9}},	//   _varo, _pomm, _ongd_, pois,
   {{0x249d81c0,0xa09a81a8,0x629c22da,0x237f9d21}},	//   _nawm_, عضاء_, _waro, ktuj_,
   {{0x629c00a4,0x44240014,0x69c88035,0x69da8216}},	//   _taro, _àm_, zyde, zzte,
   {{0xb8cba2db,0x2ca00074,0x3b0a0009,0x4e7a00be}},	//   _को_, ldid_, _чего_, גאַצ,
   {{0x60c0a2dc,0x57d001d0,0x2ca006ae,0xf8bf1a1f}},	//   _tomm, हनुह, odid_, lmée_,
   {{0x7ae8a2dd,0xbd878624,0x2ca022de,0x249d8069}},	//   widt, انين_, ndid_, _cawm_,
   {{0xc6768060,0xe646a2df,0x63a422e0,0x66d000f2}},	//   _مطاب, _безп, nvin, _räkn,
   {{0x69c88bfa,0x69da8352,0x63ad826f,0xe45f0009}},	//   tyde, tzte, _šanc, _ylös_,
   {{0x249d81c0,0x26c122e1,0xd2b70039,0x7c8689a0}},	//   _fawm_, _roho_, אלית_, _буле,
   {{0xa3e50665,0x8dfb8039,0x249d81c0,0x69c8a2e2}},	//   _भइल_, _אהבת, _gawm_, ryde,
   {{0x69da8065,0x63a40a0f,0x81bc00c8,0xf09f009f}},	//   szte, jvin, েছি_, rdà_,
   {{0x11d6803f,0x3ce68282,0x99d68277,0x539b84de}},	//   _متعد, _hmov_, _متعا, _ניוו,
   {{0x7f441883,0x58d50009,0x249d8069,0x1df8076a}},	//   _etiq, _войт, _yawm_, геры_,
   {{0x290f01a8,0x20f88084,0x2bd18b99,0x290903e4}},	//   _óga_, yčia_, दैवा, _ukaa_,
   {{0x26c10a56,0x395e8341,0x63a422e3,0x4a5520bf}},	// [12f0] _toho_, lsts_, gvin, икас,
   {{0xb05b01ec,0x66d00106,0x3ce901c0,0x2739a2e4}},	//   rkäu, _jäkl, siav_, _rèn_,
   {{0x46150077,0x66d0016d,0x6d5a22e5,0xb035a209}},	//   _خودر, _mäkl, štar, анеш,
   {{0x6d4522e6,0x237f8035,0x395ea2e7,0x5c07047f}},	//   _itha, ytuj_, ists_, _бяга,
   {{0x644d22e8,0x249d822c,0xb4c30bbc,0xb05b0198}},	//   mbai, _rawm_, ्सी_, lkäs,
   {{0x395e8029,0x644d22e9,0xddc5a2ea,0x249d8282}},	//   ksts_, lbai, ибли, _sawm_,
   {{0xa56480f7,0xfc3180f7,0xb05b0198,0x249f811c}},	//   مدين, يحة_, nkäs, tdum_,
   {{0xff1580c8,0x644d0102,0x386080f7,0xdb06010c}},	//   াদেশ_, nbai, óirt_, _arkè,
   {{0x395e87e2,0x249f8457,0x6d450122,0x7d1d010c}},	//   ests_, rdum_, _ltha, _mhss,
   {{0x752f0063,0x644d03ac,0x237f809a,0x6d4522eb}},	//   _licz, hbai, rtuj_, _otha,
   {{0x249d81e9,0x6d45022c,0x2a760039,0x25b98199}},	//   _tawm_, _ntha, בעתך_, _جهاد_,
   {{0x68eb8cfa,0x63a403c7,0x752f0035,0x25de81d0}},	//   nigd, yvin, _nicz, _केटी_,
   {{0x6d4522ec,0xb8ee000f,0xa3e50074,0x26d822ed}},	//   _atha, _शक_, _भेल_, thro_,
   {{0x443fa2ee,0x63a40197,0x7d1d0706,0x68eb8420}},	//   lcu_, vvin, _ahss, higd,
   {{0x2d53802e,0xa01b0019,0x50460037,0xddc322ef}},	//   nţe_, lföl, _кейб, обри,
   {{0x1c4622f0,0x8a14803d,0x6d450706,0x47c6004a}},	//   рнам, _اظها, _dtha, _вбив,
   {{0x6d4522f1,0x6f07017f,0x68eba2f2,0x2ca00074}},	// [1300] _etha, bojc, digd, rdid_,
   {{0x55e622f3,0xf8bf0036,0x0ea49370,0x3ce981d6}},	//   _вооб, rmée_, _गोंड, čavy_,
   {{0x765c22f4,0x2d9a095e,0x644d22f5,0xf0aa046d}},	//   mary, _uspe_, bbai, _gbàá_,
   {{0x270e8c78,0x64a622f6,0x39a58029,0x4fc68bba}},	//   ित्र_, _тама, _mēs_, исла,
   {{0x443fa2f7,0x02b580c2,0x98a622f8,0x3f82136f}},	//   dcu_, _अचंभ, nslı_, ntku_,
   {{0x765c22f9,0x5d66a2fa,0x658a8201,0x236da2fb}},	//   nary, атиз, _rəhb, drej_,
   {{0xdce18214,0x69c7806a,0x6d450706,0x290683e4}},	//   _aslı, øjel, _xtha, pooa_,
   {{0x399b012a,0x0ca78009,0x656e0c5e,0x765c22fc}},	//   _בילד, атьи_, irbh, hary,
   {{0xf743a2fd,0x765c22fe,0x225800c9,0xdb0609c4}},	//   _мето, kary, _kerk_, _arké,
   {{0x78a2a2ff,0x79a6a300,0x0f7b83c8,0xb4d203ca}},	//   ldov, арме, _באמב, वसु_,
   {{0x3a370051,0x765c01e2,0x22582301,0x6f070024}},	//   ירים_, dary, _merk_, vojc,
   {{0x60c40c64,0x1bea9508,0x395ea302,0x69de011b}},	//   _coim, _идеи_, rsts_, izpe,
   {{0x77f4a303,0x3949a304,0x60c42305,0xd7fb0530}},	//   _अशोक_, _čase_, _doim, тун_,
   {{0x0eeb2306,0x28dd82f1,0xb05b062c,0x7e78a307}},	//   тьми_, _मतभि, tkäs, ngvp,
   {{0x3f822308,0x7afda309,0xeda400e8,0xd2f88019}},	//   atku_, éste, ошто, _لکھا_,
   {{0x04c900f7,0x78a2a30a,0xdce7009a,0x60d6230b}},	//   دوري_, jdov, kują, _glym,
   {{0x644d230c,0x656e0c41,0x765c230d,0x78a281e8}},	// [1310] rbai, arbh, bary, ddov,
   {{0x6e950013,0xf1a71980,0x644d0014,0xf699230e}},	//   _الدا, ирен, sbai, _свој_,
   {{0x6d45005d,0x20f8811f,0x28cc109b,0x3ce781ab}},	//   _utha, rčin_, ासचि, _जगले_,
   {{0xa3c7a30f,0x628501a8,0x271f847d,0x273d04be}},	//   _उथल_, sfho, यग्र_, _kìn_,
   {{0x443f8289,0xa3bb152c,0x2d8300f3,0x60c02310}},	//   vcu_, _अपि_, ltje_, ömmi,
   {{0x4aa68076,0xaaa6a311,0x6b9d002a,0x236d8b80}},	//   _कोलव, _कोलक, _issg, vrej_,
   {{0x2d832312,0xad5897ae,0x443fa313,0x645b888b}},	//   ntje_, арых_, tcu_, taui,
   {{0xfdf80039,0x66cf813c,0x84f900d4,0x20f8826f}},	//   ימוש_, _køkk, ्किट_, nčil_,
   {{0x60c40068,0x68e9a314,0x443fa315,0xe3e9803d}},	//   _roim, _imed, rcu_, دکان_,
   {{0x443f8012,0x236da316,0xa01b2317,0x9f958074}},	//   scu_, rrej_, rföl, _müüa_,
   {{0x66cf813c,0x98a62318,0x60d62319,0x39e9a31a}},	//   _løkk, бине, _plym, удно_,
   {{0x236d8353,0xa01b0106,0xfd1f0129,0x693a8197}},	//   prej_, pföl, _nhì_, _kċej,
   {{0x60c40009,0xfaa581e2,0x6f1e0118,0x66cf80e8}},	//   _voim, _гало, _phpc, _nøkk,
   {{0x3f82231b,0x78a28f20,0x291f81c0,0xe7371ac9}},	//   rtku_, zdov, _lhua_, сер_,
   {{0x60c40181,0x645990e1,0x68e98106,0x3f820696}},	//   _toim, _kewi, _omed, stku_,
   {{0xeb9a10ac,0x26c5a31c,0xb05b0b8b,0xb4d20075}},	//   либ_, _lolo_, skär, वसे_,
   {{0x63bb862f,0x765c010c,0x2d8300f3,0x2258231d}},	// [1320] nxun, pary, atje_, _perk_,
   {{0x68fba31e,0x6459a31f,0xf4128451,0x78a0a320}},	//   _ajud, _lewi, לפן_, _samv,
   {{0x68fb816d,0x2722801c,0xdb042321,0x63a48118}},	//   _bjud, _hưng_, nvié, _áinv,
   {{0x225801d8,0x291fa322,0x6459831d,0x2cbfa323}},	//   _werk_, _chua_, _newi, jjud_,
   {{0x0eea835f,0x26c58038,0x7d09a324,0x96eaa325}},	//   льки_, _bolo_, does, лька_,
   {{0x527519b5,0xdb028187,0xdce70035,0x20f880c3}},	//   _мусу, _proí, rują, mčim_,
   {{0x2b46a326,0x6443009a,0x6b842327,0x64599781}},	//   _stoc_, śnie, ltig, _bewi,
   {{0x63ab82f7,0xdce70035,0xa7fb0118,0xd497a328}},	//   _brgn, pują, lañe, брь_,
   {{0x68e380f1,0xd2508013,0x6459831d,0x940d0326}},	//   ënde, ونة_, _dewi, ɓoɓi_,
   {{0x63ab006a,0x63a92329,0x6b84232a,0x6d4a8711}},	//   ågni, _šenk, itig, ppfa,
   {{0x2d98a32b,0x20120326,0x6b84232c,0x7d09a32d}},	//   _ère_, _ayyi_, htig, boes,
   {{0x2d9e8042,0x6459a32e,0x6b84232f,0x2ed10beb}},	//   _iste_, _gewi, ktig, हस्त,
   {{0xdfd80098,0x61e00085,0x765a8168,0x272280ff}},	//   бър_, _əmla, _kety, _cưng_,
   {{0x81de00c8,0xd9fa01cb,0xf40000ab,0xeaf58c33}},	//   _তখন_, ्थात_, ্ধার_, ीकृत_,
   {{0x2d9e800d,0x765aa330,0x6b8406a8,0x691881ca}},	//   _jste_, _mety, etig, víen,
   {{0x2d830a0f,0x2eeea331,0x62889de6,0x753a8db1}},	//   rtje_, hiff_, lfdo, _mutz,
   {{0x6b842332,0x2d832333,0x38690041,0x3ea12334}},	// [1330] gtig, stje_, _idar_, _taht_,
   {{0x68e9a335,0x8c1b8bea,0x290b2336,0x765aa337}},	//   _smed, רומי, loca_, _nety,
   {{0xfd1f0104,0x399aa338,0x753a8352,0x6b842339}},	//   _thì_, _jūs_, _nutz, atig,
   {{0x26c5a33a,0x7e688216,0x291f8069,0x399a81a9}},	//   _solo_, _addp, _qhua_, _mūs_,
   {{0x66048182,0x765a904a,0x4918010f,0x2d9e8102}},	//   şikl, _bety, זקאל_, _aste_,
   {{0x26c581b4,0x35c98284,0x321c9075,0x6459a33b}},	//   _qolo_, игло_, _ozvy_, _sewi,
   {{0x765a820f,0x26c5a33c,0x291fa33d,0xd05d0085}},	//   _dety, _volo_, _thua_, sisə,
   {{0x6297233e,0x9345a33f,0x645f0085,0xf9921101}},	//   lexo, оние, naqi, _קרן_,
   {{0x2d9ea340,0x8c6480f7,0xdcfc00eb,0x03a5a341}},	//   _este_, سطين, ntrā, ципо,
   {{0x05ba2342,0x399a8029,0xdddc0019,0x38692343}},	//   _उपलब, _būs_, zerű, _adar_,
   {{0xe8fa2344,0x290319b7,0x7d09a345,0x63bb8118}},	//   ило_, čkan_, poes, sxun,
   {{0x160400d4,0x297a00be,0x79850114,0x63ab8669}},	//   _शुगर_, סטרא, ithw, _trgn,
   {{0xa3bb815b,0x68fd0216,0x940580d7,0x63ab8037}},	//   _حاضر_, érda, _بوشه, _urgn,
   {{0x673b8079,0x38692346,0x63a9a347,0xa8030118}},	//   _muuj, _edar_, mven, úñas,
   {{0x63a9a348,0x62971075,0x845a2349,0x6da31ba2}},	//   lven, dexo, ират_, мира,
   {{0x63a9a34a,0x9e3c9c18,0x6aa38114,0x161e80c2}},	//   oven, _maďa, _hanf, येटर_,
   {{0xb6a60ff7,0x0aea1b69,0xab6600e8,0x6aa38300}},	// [1340] _дипл, адай_, ювал, _kanf,
   {{0x6b84234b,0x78a40282,0x63a9a34c,0x386904e8}},	//   rtig, _haiv, iven, _zdar_,
   {{0x6aa38590,0x28af000d,0x78a40198,0x9e3c80e1}},	//   _manf, _जोडि, _kaiv, _naďa,
   {{0x765aa34d,0x6aa3a34e,0xac760019,0x78a40144}},	//   _sety, _lanf, _بادش, _jaiv,
   {{0x78a40282,0x765aa34f,0x63a980f3,0x6b840079}},	//   _maiv, _pety, jven, qtig,
   {{0x63a9a350,0x78a42351,0x645d807b,0x356a9593}},	//   dven, _laiv, ðsin, арин_,
   {{0x20d7a352,0xd54780a9,0xa9672353,0xe6da8105}},	//   _için_, опје_, _мира_, _भतीज,
   {{0x66cb0459,0x6aa3826b,0xdb0b841c,0x2fcf804a}},	//   _yüks, _aanf, _urgê, bygg_,
   {{0x3949a354,0xaca401bc,0xfb868110,0xdb040580}},	//   _časa_, _ndọt, цыйн, nviï,
   {{0xcb1a80a9,0x63a4a355,0x386900b9,0x6aa38114}},	//   јќи_, _šins, _sdar_, _canf,
   {{0x09f88013,0x7afd85e4,0xaca40133,0x3f868548}},	//   صفحة_, ésta, _adọt, ltou_,
   {{0x63a9959b,0x7aef82ba,0x29030289,0x78a40037}},	//   bven, éctr, čkao_, _caiv,
   {{0x3f86a356,0x4ea72357,0x63a9802e,0x60358085}},	//   ntou_, орва, cven, _həmç,
   {{0xa3ae0df4,0x387f2358,0x3f86a359,0x66d9046d}},	//   किन_, żur_, itou_, _bìka,
   {{0x78178a74,0x290b1fea,0x7b1001ec,0x58d5091e}},	//   _तर्क_, poca_, häus, _нокт,
   {{0x628e235a,0xd5a48986,0x38690024,0x6aa3a35b}},	//   _abbo, _یہ_, _udar_, _zanf,
   {{0x28ab9a3b,0x3d0b8076,0x645f00f1,0xb87b0118}},	// [1350] _घोषि, ावते_, raqi, rhíd,
   {{0x7e990019,0x238e00eb,0x2489026c,0xb87b0118}},	//   _اندر_, dējā_, sfam_, eníx,
   {{0xdcfc0029,0x6297002a,0x39580114,0x0e9a01c6}},	//   strā, rexo, _cwrs_, _השתל,
   {{0x23668025,0x7985235c,0x6ee9235d,0x6297235e}},	//   _ovoj_, rthw, džbi, sexo,
   {{0x7d0d002e,0x68ed0a2c,0x645d235f,0xba7700f7}},	//   moas, _mmad, _iesi, _واست,
   {{0x645d2360,0x6da59ba2,0x7d0d08b0,0x60dd0168}},	//   _hesi, зика, loas, ërmj,
   {{0xb14603f8,0x645d2361,0x6aa383ec,0x68ed02f1}},	//   _فیلم_, _kesi, _ranf, _omad,
   {{0x7d0d0ca4,0xdd8e80f7,0x2ec819e8,0x66d00198}},	//   noas, اوي_, _रक्त, _väki,
   {{0x645d2362,0x3f86a363,0x6aa3a364,0x63a980e7}},	//   _mesi, ctou_, _panf, uven,
   {{0x68ed2365,0x645d2366,0x44392367,0x6721a368}},	//   _amad, _lesi, _lgs_, _uhlj,
   {{0x60db84dc,0x4efa80be,0xaf0881a8,0x3ea58366}},	//   _klum, _פלעג, _بقلم_, _ialt_,
   {{0x21060c78,0x645d2369,0x44390420,0x7522a36a}},	//   रवेश_, _nesi, _ngs_, _ghoz,
   {{0x087680be,0x78a4236b,0xe45680be,0x3ea5a36c}},	//   הערט_, _vaiv, _זינט_, _kalt_,
   {{0x4439236d,0x7529a36e,0x60dba36f,0x68ed2370}},	//   _ags_, lmez, _llum, _emad,
   {{0x60dba371,0x2cf91344,0x645d2372,0x78a42373}},	//   _olum, ्कूल_, _besi, _taiv,
   {{0x645d0baf,0x0b4604db,0x60c9a374,0x201e0201}},	//   _cesi, знан, _noem, ətin_,
   {{0x7d1604fe,0x2d8782f1,0x64442375,0xdb0b87b6}},	// [1360] rlys, htne_, rcii, _argé,
   {{0x60db88e9,0x2d87a376,0x645d1312,0x691d0866}},	//   _alum, ktne_, _eesi, néen,
   {{0x7d16006f,0x60dba377,0x2d930118,0x60c9a378}},	//   plys, _blum, _gpxe_, _boem,
   {{0xe04396d9,0x645d2379,0x7d0d237a,0xa7fb0118}},	//   енци, _gesi, coas, laña,
   {{0xdc370158,0x765e237b,0x3f86802a,0x6d45a37c}},	//   _מאכט_, _kepy, utou_, íhan,
   {{0x645d237d,0xa3e50d14,0xdee3a37e,0x2d878390}},	//   _zesi, _भेट_, ночи, ftne_,
   {{0x23668ee0,0x3f86a37f,0x645d005d,0x3ea5a380}},	//   _svoj_, stou_, _yesi, _dalt_,
   {{0x60db803a,0x2900022e,0x3f86a381,0x18a38254}},	//   _glum, _njia_, ptou_, _пасм,
   {{0x613a001b,0x3ea5804a,0x6f0e0326,0x66dd89c4}},	//   _důle, _falt_, kobc, _sèke,
   {{0x3ea5a382,0xfc3f0118,0x68ed2383,0x6da68ab2}},	//   _galt_, _maía_, _smad, _низа,
   {{0xa7fb0216,0xdd8f866e,0x1ea9a384,0x7416a385}},	//   daña, _مول_, _باقي_, _کوشا,
   {{0x69370499,0xfce3a386,0x236697aa,0x09f701c6}},	//   _kćer, _похо, _tvoj_, למים_,
   {{0x645d2387,0xa3cd8701,0x44390196,0xbff80470}},	//   _resi, रहण_, _rgs_, зеях_,
   {{0x645d2388,0x63a2a389,0xa7fb238a,0x29120365}},	//   _sesi, _ison, gaña, _ekya_,
   {{0xa3e5000f,0x56780009,0x7d0d238b,0x765e0176}},	//   _भेज_, ября_, toas, _depy,
   {{0x5fbea38c,0x68ed0079,0x7aee01ed,0xc8ab86a7}},	//   ्हाल, _umad, _ambt, _घोंट,
   {{0xd90f09d7,0x645d238d,0x7d0d002e,0xa7fb15c7}},	// [1370] _لیگ_, _vesi, roas, baña,
   {{0x60dba38e,0x7f4d238f,0x63a28c53,0x645d005d}},	//   _slum, _itaq, _mson, _wesi,
   {{0x645d2390,0x63a282f7,0x68fd2391,0x60db8e79}},	//   _tesi, _lson, onsd, _plum,
   {{0x3ce02392,0x63a2a393,0x629aa394,0x68fd2395}},	//   chiv_, _oson, heto, nnsd,
   {{0x6d4a00f1,0xdcfc0087,0x63a2a396,0x6d5a85ee}},	//   _çfar, stră, _nson, _awta,
   {{0x629aa397,0x658a8201,0x2ca92398,0x63ad2399}},	//   jeto, _təhl, ldad_, mvan,
   {{0x3ea5a39a,0xa1941182,0x63a2a39b,0x60db9d40}},	//   _valt_, _парч, _ason, _tlum,
   {{0x2d87a39c,0x60db80ee,0x63ad239d,0x66d00106}},	//   rtne_, _ulum, ovan, _häkt,
   {{0x290f8867,0x752984b7,0x63ad239e,0x2d87a39f}},	//   moga_, rmez, nvan, stne_,
   {{0xa3ae146d,0x39459fc8,0x2bdf001b,0xe3ca8144}},	//   कित_, мног, पैया, _soñó_,
   {{0x7f4d0510,0x66d00106,0x6dd5804e,0x63a2a3a0}},	//   _ataq, _mäkt, _تقاض, _eson,
   {{0x290fa3a1,0x63ad1434,0x3940811a,0x2ca682c4}},	//   noga_, kvan, _čist_, _gaod_,
   {{0x2ca923a2,0x691d00e7,0x272401ec,0xe79c02d0}},	//   ddad_, péen, höne_, _düğü,
   {{0x63ad23a3,0x2ca90144,0x6b89a3a4,0x629aa3a5}},	//   dvan, edad_, mteg, ceto,
   {{0x386d834a,0x290f812b,0x6f0e003e,0x6b89811e}},	//   _oder_, koga_, robc, lteg,
   {{0xf8e2141b,0x386d8168,0x2eda84c5,0xa7fb0144}},	//   _पतिय, _nder_, _भत्त, saña,
   {{0xfa8e801c,0x6aa701a1,0x59cb8127,0xccf28039}},	// [1380] _mừng_, _bajf, ाहवर, דכן_,
   {{0x386d80ee,0xe297002e,0xb05b1cab,0x63a6a3a6}},	//   _ader_, мау_, hjäl, ækni,
   {{0xe8208076,0xd62a01bb,0x88868a13,0xa87a00be}},	//   _बरहा_, _фоне_, длеж, ַאַר,
   {{0xa3bf86a7,0xa3cda3a7,0x61ee8118,0x657c062c}},	//   ीहा_, रहा_, úbli, murh,
   {{0x3860021e,0x6aa8831d,0x8cdb00d4,0x629aa3a8}},	//   _meir_, yddf, नसरो, yeto,
   {{0x386da3a9,0x473380e8,0x386023aa,0x629a8118}},	//   _eder_, вніс, _leir_, xeto,
   {{0xc6930051,0xe8208076,0x290fa3ab,0x657c00b9}},	//   דאו_, _बरवा_, boga_, nurh,
   {{0x248023ac,0x3eba00b9,0xdc13807e,0x629a9588}},	//   ngim_, _lnpt_, _ağır, weto,
   {{0xd90d8288,0x629aa3ad,0xa6868293,0xfa8e80ff}},	//   _این_, teto, _олад, _dừng_,
   {{0xb6cb8117,0x7b32809a,0x38600174,0x68e2936f}},	//   _والے_, _tłum, _aeir_, lhod,
   {{0x629aa3ae,0x658a8201,0x6b89a3af,0x66d018c2}},	//   reto, _məhk, ateg, _läks,
   {{0xa3de0fcc,0x63ad03bf,0x75498019,0x38600114}},	//   तना_, yvan, őszö, _ceir_,
   {{0x27e684b9,0x63a2a3b0,0x386000f7,0x9f59077f}},	//   nzon_, _uson, _deir_, ìyàn_,
   {{0xe1ef95e4,0x7ce30006,0x3eba0118,0x63ad23b1}},	//   اسی_, _kõrg, _cnpt_, vvan,
   {{0x9f34035f,0xdc3a07d9,0xc32780f7,0x290fa3b2}},	//   тері, _açık, _تكون_, yoga_,
   {{0x63ad23b3,0xadf18665,0x26cc846d,0x442223b4}},	//   tvan, _अइसन_, _lodo_, _bzk_,
   {{0x2ca91726,0x68e284c4,0x290f86ec,0xa7fb0511}},	// [1390] rdad_, dhod, voga_, maño,
   {{0x26cca3b5,0xcf2715a9,0x63ad1457,0xa7fb0216}},	//   _nodo_, _تربي, rvan, laño,
   {{0x63ad23b6,0x6b898102,0x290fa3b7,0x7e63a3b8}},	//   svan, zteg, toga_, vanp,
   {{0x63ad01ed,0xf86981a8,0x2fe402d0,0x7e6381e0}},	//   pvan, سمتي_, _örgü_, wanp,
   {{0x26cc8db7,0x6aa7069f,0xfa8e801c,0x752d23b9}},	//   _bodo_, _tajf, _rừng_, mmaz,
   {{0x752d0065,0x26cc8333,0x290fa3ba,0xaaad86a7}},	//   lmaz, _codo_, soga_, _झोंक,
   {{0x26cca3bb,0x0445a3bc,0x68e281f6,0x3d0ba3bd}},	//   _dodo_, нейн, bhod, ावले_,
   {{0x68e28f4c,0x27e682d0,0x752d22f8,0x2f16008b}},	//   chod, bzon_, nmaz, lægt_,
   {{0x7e63a3be,0x248d8669,0xe3b18c3b,0x386023bf}},	//   panp, rfem_, ارب_, _reir_,
   {{0x7c22a3c0,0x5fbe950e,0x386023c1,0x1eea8061}},	//   _dzor, ्हरल, _seir_, _فوقی_,
   {{0x6b89a3c2,0xfa8e8028,0xaca38870,0x7c22a3c3}},	//   steg, _từng_, _azụm, _ezor,
   {{0xc689073a,0x26c7803a,0x98b880eb,0x7e61a3c4}},	//   _לא_, ljno_, _kurā_, _help,
   {{0xbd2c893f,0x95228117,0x6d41a3c5,0x752d0904}},	//   _וואָ, _حکوم, _hula, dmaz,
   {{0x68e28a56,0x7d1ba3c6,0x78a9a3c7,0xd36ea3c8}},	//   zhod, llus, _laev, _اهو_,
   {{0x6d41a3c9,0x386023ca,0x7d0902a5,0x442223cb}},	//   _jula, _teir_, česn, _szk_,
   {{0x6d41a3cc,0x64a323cd,0xdca30af0,0x7693861c}},	//   _mula, ласа, ласи, lıyı,
   {{0xac070056,0x68e29dc1,0x24070c24,0xeb97023a}},	// [13a0] ента_, vhod, енти_, нит_,
   {{0xe9ff8104,0x6281a3ce,0x7d1ba3cf,0x7e6181bf}},	//   _giải_, nglo, hlus, _nelp,
   {{0x7d1ba3d0,0xae5b0051,0xd9108065,0x6d41a1b8}},	//   klus, _מכיר, لیس_, _nula,
   {{0xa01b00f2,0x38608013,0x26cca3d1,0x443da3d2}},	//   mför, úir_, _sodo_, _ngw_,
   {{0x6d41a3d3,0xa01b016d,0x26cca3d4,0x7d1b82f1}},	//   _aula, lför, _podo_, dlus,
   {{0x6d41a3d5,0x27e6a3d6,0x6e94a3d7,0x644b806a}},	//   _bula, rzon_, тику, _afgi,
   {{0x68e28efd,0x40969d85,0xa01b23d8,0x26cc8353}},	//   phod, _прат, nför, _vodo_,
   {{0x629e23d9,0x6d41a3da,0xf8bf0019,0x7ce302f1}},	//   lepo, _dula, rmék_, _võrg,
   {{0x26cc90dd,0xa2c40e70,0x6d41a3db,0x2904a3dc}},	//   _todo_, राप्, _eula, _ijma_,
   {{0x7c229234,0x6d41a3dd,0x60cd1613,0xa01b016d}},	//   _vzor, _fula, _soam, kför,
   {{0x6d41a3de,0x7c228035,0x5cd6804a,0x7d1ba3df}},	//   _gula, _wzor, _підх, blus,
   {{0x73e6a3e0,0x660907d9,0xa01b016d,0x7d1ba3e1}},	//   _поез, şekk, dför, clus,
   {{0x7c228a20,0x6d5e026b,0x6d41a3e2,0xddcc01d0}},	//   _uzor, _awpa, _zula, _čišt,
   {{0x629e23e3,0x66d0016d,0x661aa3e4,0x673a8372}},	//   jepo, _säkr, _kytk, _jitj,
   {{0xdd940048,0xa7fb128e,0x659423e5,0xa2c423e6}},	//   лары, paño, лару, रान्,
   {{0x752d0118,0x57b523e7,0x6aaa86b1,0x5183a3e8}},	//   umaz, _абит, _haff, _суша,
   {{0x752d23e9,0x6aaaa3ea,0x2f160366,0xd3711ef7}},	// [13b0] rmaz, _kaff, tægt_, شها_,
   {{0x6aaaa3eb,0x629e23ec,0xff5001a8,0x78a9852a}},	//   _jaff, gepo, _اخي_, _saev,
   {{0x073601c6,0x7d1b8428,0x317ea3ed,0x661a862c}},	//   _שאתם_, ylus, nutz_, _nytk,
   {{0x6ee200e1,0x6d41a3ee,0x98bd02d6,0x00000000}},	//   _vôbe, _rula, _ouvč_, --,
   {{0x6d41a3ef,0x07a58fe7,0x317e81ec,0x7ce30074}},	//   _sula, талн, hutz_, _võrd,
   {{0x6d419397,0xa3ae0665,0xcf9400be,0x7e6705f3}},	//   _pula, किर_, רטס_, najp,
   {{0xf2d20159,0xdcfa884a,0x6b8d0601,0x7d1b8006}},	//   _דעם_, _artı, ltag, tlus,
   {{0xdb060884,0x6281a3f0,0x24868706,0x673a890d}},	//   _erkä, wglo, _ccom_, _eitj,
   {{0x7d1ba3f1,0x7e61a3f2,0x6aaa8365,0x6b8d1162}},	//   rlus, _telp, _baff, ntag,
   {{0x6d41a3f3,0x6aaaa3f4,0x7d1ba3f5,0x9e678065}},	//   _tula, _caff, slus, _سائن,
   {{0x7d1ba3f6,0x0574a3f7,0x6d41876d,0xc0e60a41}},	//   plus, _ماند, _uula, вонк,
   {{0x63ad88ae,0xa01b0106,0x6b8d23f8,0x62819670}},	//   _šanu, vför, ktag, sglo,
   {{0xa8568039,0x66048457,0x629523f9,0x9cd681c6}},	//   כירה_, şikt, _obzo, _שונה_,
   {{0xe1f183f8,0x6b8d23fa,0x658a8201,0x6aaaa3fb}},	//   _پست_, dtag, _səhi, _gaff,
   {{0xe73723fc,0x213b23fd,0x8d6304ae,0x925881a8}},	//   тер_, _fiqh_, ивре, _أشهر_,
   {{0xa3ae023c,0xa01b23fe,0x6aaaa3ff,0x2cada400}},	//   किल_, rför, _zaff, nded_,
   {{0x93432401,0xa01b00f2,0x6b8d10c1,0xcb672402}},	// [13c0] инте, sför, gtag, кате_,
   {{0xf1fa2403,0x249fa404,0xa01b0106,0xd0f20032}},	//   وعات_, heum_, pför, _faṣẹ,
   {{0x629e2405,0xfaa31cce,0xcb1283c8,0xa2c41513}},	//   repo, рахо, סלב_, राब्,
   {{0xb91a0032,0x673aa406,0x080a80d7,0xdcfa82a6}},	//   _aifẹ_, _sitj, وزشي_, _istħ,
   {{0x2cada407,0x673aa408,0x2ca00074,0xdb0b823e}},	//   dded_, _pitj, meid_, _orgà,
   {{0xc7d70051,0x2ca02409,0xf4130039,0x63a41e8f}},	//   כוני_, leid_, _כפר_, mwin,
   {{0x6aaaa40a,0x63a4005d,0x5fa9000f,0x888482e3}},	//   _raff, lwin, _चैनल, _میان,
   {{0x4420801c,0x2ca002f1,0xfd0f81a8,0xef1f0061}},	//   _ơi_, neid_, يجي_, ttük_,
   {{0xccf30051,0x2b4600f7,0xf746a40b,0x63a4240c}},	//   יכה_, íoch_, _резо, nwin,
   {{0x2ca0240d,0x2129240e,0x2d9a0aa2,0x63ab006a}},	//   heid_, _shah_, _oppe_, ægni,
   {{0x60f9240f,0xc486a410,0x63a42411,0xfbcf8bca}},	//   ення_, _алек, hwin, متی_,
   {{0x6aaaa412,0x63a42413,0x6b8d2414,0xcd368481}},	//   _waff, kwin, ytag, _شراب,
   {{0x6aaa82a6,0x442080ff,0x2ca002f1,0x64430035}},	//   _taff, _ái_, deid_, śnik,
   {{0x29022415,0x442682a0,0x2d472416,0x6b8d2417}},	//   anka_, _izo_, _põe_, vtag,
   {{0x63a42418,0x69dca419,0x6b8085ee,0x00000000}},	//   ewin, øred, lumg, --,
   {{0x6b8d241a,0x200901c0,0x2ca0052a,0xba3781c6}},	//   ttag, _txai_, geid_, _בטוח_,
   {{0xbab902cb,0x3949807a,0x63a4241b,0x613a928a}},	// [13d0] нгах_, _časi_, gwin, _půln,
   {{0x6b8d241c,0x24730028,0x7a40026f,0xbb1900f7}},	//   rtag, ệm_, vští, رياض_,
   {{0x6b8d241d,0x2ca0241e,0x7afda41f,0x249f808e}},	//   stag, beid_, ésti, yeum_,
   {{0xf7719a00,0x44268870,0xf2df002e,0x2ca00362}},	//   مات_, _ozo_, _atât_, ceid_,
   {{0x747a0039,0x78ad02f1,0x6d452420,0x7f198110}},	//   _אנרג, _maav, _huha, ніку_,
   {{0x6d452421,0x753d2422,0x6f152423,0x3ebea424}},	//   _kuha, _hisz, nozc, _cntt_,
   {{0x4426a425,0x6d450406,0x753d0019,0x29880dc7}},	//   _azo_, _juha, _kisz, _исто_,
   {{0x644d2426,0xf3f98087,0x60dd090d,0xd9288162}},	//   ncai, laţi_, jksm, _ацул_,
   {{0xe796853d,0x2cada427,0xf4959e29,0x644d2428}},	//   _مالک, rded_, نشکد, icai,
   {{0x63ad803b,0xdb0400a9,0x62852429,0x2fd9031d}},	//   _šans, rviç, ngho, dysg_,
   {{0x63a4242a,0x5dd58875,0x4426a42b,0xa2c403dd}},	//   zwin, _حقائ, _ezo_, रात्,
   {{0xcea90bea,0x78ad002a,0x29020079,0x63a40123}},	//   _מי_, _caav, unka_, ywin,
   {{0x645ba42c,0x7f44157a,0x776081c0,0xe2a880d7}},	//   mbui, _quiq, _xwmx, راین_,
   {{0x6d45242d,0x201e00eb,0x99d581ad,0xf3f98162}},	//   _buha, āti_, _متبا, jaţi_,
   {{0xfce6242e,0x2ca00074,0x63a4242f,0xe2968098}},	//   гово, teid_, wwin, _сащ_,
   {{0x30ae80ab,0x6d452430,0x03a613f7,0x78ad1a14}},	//   _কক্স, _duha, либо, _gaav,
   {{0x68e42431,0x2ca02432,0x6d452433,0x0c262434}},	// [13e0] _ilid, reid_, _euha, уман,
   {{0xa2c42435,0x2ca00006,0x63a4044e,0x6aa1808e}},	//   राध्, seid_, rwin, nelf,
   {{0x3f822436,0x394f802e,0x6d4502a0,0x2d9a016d}},	//   luku_, _însă_, _guha, _uppe_,
   {{0x7d7b012a,0x74550698,0xa3e3809a,0x600a8110}},	//   _אנטו, _върх, नना_, ннем_,
   {{0x7d042437,0xa2c40697,0x6d452438,0x3f822439}},	//   mnis, राद्, _zuha, nuku_,
   {{0xf3f9802e,0x765c243a,0xe16601a8,0x716601a8}},	//   caţi_, nbry, _مدري, _مارك,
   {{0x91e60134,0x7d0d9234,0x3f82243b,0x68e4243c}},	//   _сове, časn, huku_, _olid,
   {{0x33749630,0x7d04138e,0x44268140,0x7981a43d}},	//   агир, nnis, _pzo_, dulw,
   {{0x7d04243e,0xd70a81f3,0x3f82126a,0x1616243f}},	//   inis, _знае_, juku_, _दुसर_,
   {{0xbda68077,0x78ad01c2,0x7d042440,0x68e42441}},	//   _محصو, _saav, hnis, _alid,
   {{0x7d040e51,0x527b00be,0x765c2280,0x6f1504e8}},	//   knis, ענטא, dbry, vozc,
   {{0x27e62442,0x33869c79,0x6d452443,0x2ba510d0}},	//   _żona_, _букв, _ruha, _ऑनला,
   {{0x44268870,0x6d450239,0x3f822444,0x60dd2445}},	//   _uzo_, _suha, guku_, rksm,
   {{0x6d452446,0x68e401f6,0x7d042447,0x02a3847f}},	//   _puha, _elid, enis, _гръм,
   {{0x59a40063,0x753d2448,0x78ad14c7,0x7afaa449}},	//   _गैलर, _pisz, _taav, mitt,
   {{0x7afaa44a,0x3f820904,0x5455244b,0x6d45244c}},	//   litt, buku_, рват, _vuha,
   {{0x753d0065,0x644d244d,0xf3f98087,0xe0208105}},	// [13f0] _visz, rcai, taţi_, _बरगद_,
   {{0x644d244e,0x7afaa44f,0x320b0d8f,0x657a0174}},	//   scai, nitt, нхен_, áthc,
   {{0x753d0065,0x7d0402af,0x658a8085,0xad27004e}},	//   _tisz, bnis, _məhs, _مرحو,
   {{0x7afaa450,0x6aa18a0f,0xe82082f1,0x3ea32126}},	//   hitt, zelf, _बरखा_, lejt_,
   {{0x62989807,0x2d910102,0xd5b88dc1,0x938b2451}},	//   _obvo, ltze_, _arā_, _ясна_,
   {{0xd9f68075,0x4b7a03de,0x60c082d6,0x261a0075}},	//   ुपात_, _באשו, _enmm, _मुडी_,
   {{0x2d8309a4,0x7afaa452,0x249900b9,0x2d91011b}},	//   nuje_, ditt, _kbsm_, ntze_,
   {{0x09e10770,0x2909004f,0x67d58a42,0x7d0d94f0}},	//   पनीय, _njaa_, _кобу, časo,
   {{0x2d830bfb,0xb4d58b9f,0xe787a453,0x645ba454}},	//   huje_, _सकी_, _љубо, rbui,
   {{0x3ae400f2,0x6442a455,0x7afaa456,0x3f820289}},	//   _köpa_, _egoi, gitt, vuku_,
   {{0x41062457,0xdeba83c8,0x7d042458,0x8a388198}},	//   изов, _שמעל, ynis, ляют_,
   {{0x3c478013,0x3f822459,0x6aa1879f,0xab9580e8}},	//   _إضاف, tuku_, self, _виді,
   {{0x3949a19f,0x7d04007d,0x7d04a45a,0xf746245b}},	//   _času_, vnis, čist, рего,
   {{0x3f82003a,0x69daa45c,0x26d30118,0x7afa847f}},	//   ruku_, byte, _coxo_, citt,
   {{0x7d04245d,0x3f82245e,0x6da602c7,0x765c245f}},	//   tnis, suku_, шива, rbry,
   {{0x3f822460,0x81bd00ab,0x26f28697,0x7ce302f1}},	//   puku_, েনা_, _अग्र_, _põra,

   {{0x26d303a8,0x7d041162,0x234800d7,0x39478580}},	// [1400] _foxo_, rnis, اسری_, _huns_,
   {{0x2d832461,0x42560dc0,0x3947867f,0x658a811c}},	//   buje_, ртат, _kuns_, _məhr,
   {{0x50669ac9,0x867b00be,0x7e7b0039,0xc6930039}},	//   атла, _בריו, _באיז, _ואת_,
   {{0xd7faa462,0xe7b30bca,0xa2c40aed,0x7afaa463}},	//   кул_, _امید, राह्, zitt,
   {{0x27e08307,0x3947862f,0x44242464,0x212d81b4}},	//   áin_, _luns_, _ám_, _dheh_,
   {{0x78a2a465,0x64428046,0xa2e60009,0xdd9aa466}},	//   seov, _sgoi, _тогд, вши_,
   {{0x35678048,0x3947a467,0x7afa95c8,0xf8bf00e7}},	//   арын_, _nuns_, vitt, llée_,
   {{0x3d10a468,0xd9432469,0x63b99670,0x658a811c}},	//   ावें_, _фети, _brwn, _bəhr,
   {{0x66768077,0x7afaa46a,0xb4d6816f,0x2b4680ff}},	//   _ندار, titt, _हवी_, _quoc_,
   {{0xf2d300be,0xf2df00ff,0x69daa46b,0x4ac90f3a}},	//   ַער_, _luân_, tyte, रायव,
   {{0x7afaa46c,0x394783a8,0x26d3241f,0x6f18a46d}},	//   ritt, _cuns_, _roxo_, movc,
   {{0x7afaa46e,0x2d83003e,0x3949811f,0x394784c3}},	//   sitt, vuje_, _čast_, _duns_,
   {{0xcb548277,0x658a8201,0x893780be,0x61ff8085}},	//   _انتظ, _təhs, ירטע_, _əylə,
   {{0x6f18a46f,0x6d48a470,0xdefb01e2,0x3ce681c0}},	//   novc, _kuda, тым_, _hlov_,
   {{0x998480f7,0x69da8168,0x272981a8,0x3ea30168}},	//   _العو, qyte, núna_, rejt_,
   {{0x6d48a471,0x3ea32472,0x657a00f7,0xf8bf2473}},	//   _muda, sejt_, átha, rmés_,
   {{0xc2991b69,0x3ea300f1,0x26d3002a,0x213f8359}},	// [1410] лках_, pejt_, _toxo_, _riuh_,
   {{0xa2c40778,0x29192474,0x68fd2475,0xddc38087}},	//   राष्, losa_, lisd, nanţ,
   {{0xf9f901a8,0x6f18936f,0x80cb81a2,0x80c38072}},	//   دفاع_, dovc, _सचदे, ळाले,
   {{0x68fd2476,0xb4d5a0d5,0x6d57011b,0x112880e8}},	//   nisd, _सके_, _itxa, аючи_,
   {{0x38691de8,0x2d9ea477,0x395a02c4,0x6d48016b}},	//   _mear_, _apte_, apps_, ídav,
   {{0x6d48a478,0xef188a8e,0x386901a8,0x9a840251}},	//   _buda, амі_, _lear_, _мусл,
   {{0x29192479,0x6d48a47a,0xa2c40c46,0x7ae700b9}},	//   kosa_, _cuda, रार्, _iljt,
   {{0x6d48a47b,0x2489247c,0xf2df001c,0xe91980e8}},	//   _duda, ngam_, _xuân_, _собі_,
   {{0xdd0205f3,0x6d48a47d,0x3940247e,0x658a811c}},	//   šuću, _euda, _riis_, _qəhr,
   {{0x3940247f,0x7645031d,0xf3ff0187,0xcac98d15}},	//   _siis_, _nghy, _leão_, угое_,
   {{0x6d48a480,0xa06a2481,0x6d5701c5,0x186a2482}},	//   _guda, лана_, _ntxa, лани_,
   {{0xcd968039,0x38692483,0x29192484,0x62889de6}},	//   _לדעת_, _cear_, gosa_, agdo,
   {{0xe8f72485,0x39400074,0x6d570cdb,0xe2999c68}},	//   сля_, _viis_, _atxa, _бал_,
   {{0x7c2b8025,0x63a9a486,0x6d48a168,0xddc38087}},	//   _izgr, mwen, _yuda, canţ,
   {{0x63a9805d,0x39402487,0x38692488,0x8db5004a}},	//   lwen, _tiis_, _fear_, ості,
   {{0x3991a489,0xf2df0028,0x6b84248a,0xb4d5954b}},	//   más_, _quân_, tuig, _सको_,
   {{0x39918117,0x60c4248b,0xe29a02df,0x63a9a48c}},	// [1420] lás_, _inim, лаа_, nwen,
   {{0x16aa00af,0xfd690133,0x20ef0326,0x7b1d823e}},	//   _свои_, _jupụ, nƙin_, cèut,
   {{0xe29702cb,0x38690051,0x63a9a48d,0xbed700be}},	//   сах_, _year_, hwen, _הויז_,
   {{0xb4d68e1a,0x6d5c0cd4,0x63a9a48e,0x6d48a48f}},	//   _हवे_, mpra, kwen, _ruda,
   {{0x6d48a490,0x351b0051,0xdefa8a41,0x64460122}},	//   _suda, _תוכנ, лык_, _igki,
   {{0x3ce6826f,0x3991a491,0x75242492,0x6ffc00eb}},	//   _slov_, kás_, lliz, mācī,
   {{0x6d5c0247,0xfe6f8060,0x29192493,0x6f18a494}},	//   npra, ردو_, yosa_, rovc,
   {{0x39918065,0x4422079f,0x3b548652,0xdbdd00e1}},	//   dás_, _kyk_, окир, zšír,
   {{0xddc3802e,0x9696813a,0x64460359,0xfd69019d}},	//   tanţ, _греш, _mgki, _bupụ,
   {{0x6d48a495,0x4974a45b,0x38690229,0x2ca4a496}},	//   _tuda, олос, _sear_, semd_,
   {{0x629c020f,0x4422079f,0xddc38087,0xba9b03de}},	//   _mbro, _lyk_, ranţ, נסטי,
   {{0x23c802f1,0x7aef8722,0x3ce6a497,0x6d5c2498}},	//   रमाद, èctr, _ulov_, dpra,
   {{0x7afe0125,0x75242499,0x6c36a3f7,0x5f94249a}},	//   kipt, dliz, _افشا, пият,
   {{0xb5fc84b7,0x39918019,0x60c4249b,0xddc3826c}},	//   _reġj, bás_, _enim, lanš,
   {{0x2919249c,0x1dbd881f,0x6d5c200b,0xf3ff02df}},	//   posa_, ्मयत, gpra, _peão_,
   {{0x99860063,0x4422249d,0xddc380eb,0x657c854f}},	//   łoś_, _byk_, nanš, _århu,
   {{0x8b5801a8,0x629c0362,0x2489249e,0x2d7301a1}},	// [1430] مجلس_, _bbro, rgam_, sće_,
   {{0x7524249f,0x2d7324a0,0x3f868118,0x442224a1}},	//   aliz, pće_, duou_, _dyk_,
   {{0x752424a2,0x66d00009,0x7f3c00be,0x1a9b80be}},	//   bliz, _näky, _געזו, ריבע,
   {{0xad270416,0x38698125,0x9bc7027e,0xfc3f01df}},	//   _درخو, úar_, _лёгк, _saíu_,
   {{0x39918065,0x7c229eb3,0x7f49a4a3,0x39580580}},	//   zás_, _nyor, _queq, _etrs_,
   {{0x7afe059c,0xab5b02af,0x8d558056,0xe739a4a4}},	//   cipt, _prüf, отич, шел_,
   {{0x6d42a4a5,0xc05b8558,0xed598150,0x63bd008e}},	//   _bioa, _біз_, шой_, _hrsn,
   {{0x6d42a4a6,0x7cfe9482,0x68e2a4a7,0x63bd025b}},	//   _cioa, tūra, ckod, _krsn,
   {{0x69dc8bc5,0x68e9a4a8,0x63a98a0f,0x63bb00fe}},	//   øren, _iled, uwen, _šunj,
   {{0x60c4003b,0x3991a4a9,0x81d480c8,0x68e9800d}},	//   _snim, tás_, _সেই_, _hled,
   {{0x3ea785ef,0x68e9a4aa,0x63a9805d,0x54558323}},	//   ment_, _kled, swen, _двет,
   {{0x2d87a4ab,0x3ea08067,0x6d5c007a,0x3ea7a4ac}},	//   mune_, đite_, vpra, lent_,
   {{0x7c228065,0x7d248009,0x7c2ba4ad,0xb05b016d}},	//   _gyor, _эффе, _uzgr, tjär,
   {{0x4422067f,0x6d5c24ae,0x68e2a4af,0x7d1ba4b0}},	//   _ryk_, tpra, zkod, lous,
   {{0x3ea782be,0x8237826a,0x7d09a4b1,0x290d802a}},	//   ient_, _ارشا, ones, _ojea_,
   {{0x395824b2,0xe45a0323,0x3ea7a4b3,0x2a6a00ee}},	//   _rtrs_, ржа_, hent_, _sebb_,
   {{0x3ea7a4b4,0xa11300f7,0x752424b5,0x2a78008e}},	// [1440] kent_, _تويت, rliz, _pdrb_,
   {{0x6d5c24b6,0x3ea7a4b7,0x63bd1b3b,0x68e9816a}},	//   ppra, jent_, _drsn, _aled,
   {{0x7afe24b8,0x3ea7a1eb,0x8c46054c,0x2d87a4b9}},	//   ript, dent_, _мене, june_,
   {{0x4fc681bb,0x3f868ece,0xa99a80be,0x2d87a4ba}},	//   жска, tuou_, יבער, dune_,
   {{0x7d1b81df,0x7d090669,0xddc38088,0xbba8886a}},	//   dous, čest, vanš, _कनेक,
   {{0x7afe08cf,0x3ea78bf9,0x68e2a4bb,0x68e9a4bc}},	//   qipt, gent_, skod, _eled,
   {{0xbb4311d2,0xc448819f,0xf9878277,0xa2cda4bd}},	//   _церк, میان_, _تب_, तान्,
   {{0xd4978012,0x7d1ba4be,0x151780f7,0xd25080d7}},	//   орь_, gous, يزية_, کند_,
   {{0x3ea7a4bf,0x39448101,0xe7a90035,0xcb0a81a4}},	//   bent_, _iims_, _चैंप, иход_,
   {{0x21268b50,0x3ea7a4c0,0xb5fc81b9,0x7d0981e8}},	//   lloh_, cent_, _leġi, anes,
   {{0x2d87a4c1,0x3958a4c2,0x6e93803d,0x7d1ba4c3}},	//   cune_, ërs_, _آلما, bous,
   {{0x7d1ba4c4,0xeb9a8a94,0x6d5aa4c5,0x6ec283ca}},	//   cous, _вид_, _itta, लाकु,
   {{0x7762011c,0x6f1c24c6,0x5ead8264,0x7c228db1}},	//   _çoxl, forc, চারে, _uyor,
   {{0x3f508028,0x6f1c0024,0x61318370,0x63a2826b}},	//   _màu_, gorc, måle, _ipon,
   {{0xd5b80abe,0x3eb30085,0xfc3f801b,0x2b4b01e8}},	//   ост_, _vaxt_, žít_, _succ_,
   {{0x3ea7a4c7,0x7d00880a,0x1fa724c8,0x63bd1b99}},	//   zent_, nims, _дрог, _prsn,
   {{0x964701e5,0x200c0201,0x3ea7a4c9,0x43940251}},	// [1450] _мэнд, şdir_, yent_, матс,
   {{0x7d09a4ca,0x6d5a919d,0x68fba4cb,0x63bd0042}},	//   znes, _otta, _smud, _vrsn,
   {{0xaca301bc,0x3ea7a4cc,0x7d00a4cd,0xdcf50035}},	//   _ahụb, vent_, kims, erzą,
   {{0x3ea7a4ce,0x63a287c6,0x76550035,0x39448980}},	//   went_, _opon, lczy, _cims_,
   {{0x6d5aa4cf,0x7d098aa2,0x98c60289,0x995401d0}},	//   _atta, vnes, šući_, _výše_,
   {{0x63ad0555,0x643a0158,0x2d87a4d0,0x2ca924d1}},	//   mwan, _לערנ, tune_, lead_,
   {{0x7d1ba4d2,0x3ea78218,0x63ad24d3,0x63a2a4d4}},	//   tous, rent_, lwan, _apon,
   {{0x3ea7a4d5,0x68fba4d6,0x2ca924d7,0x2d87a4d8}},	//   sent_, _umud, nead_, rune_,
   {{0xff538b53,0x7d1ba4d9,0x291da4da,0x6d5a82ec}},	//   _آخر_, rous, mowa_, _etta,
   {{0x2ca924db,0x63a000f2,0xdd008029,0x7d09a4dc}},	//   head_, _ämne, ētāj, snes,
   {{0x63ad24dd,0x386da4de,0x7d1ba4df,0x63a2a4e0}},	//   hwan, _keer_, pous, _epon,
   {{0x63ad24e1,0x0d848048,0x386d8079,0x23759459}},	//   kwan, _ілін, _jeer_, _فاتح,
   {{0x386d9302,0xb5fc84b7,0x63ad24e2,0x7cee8362}},	//   _meer_, _reġi, jwan, _dùrd,
   {{0x386da4e3,0x63ad24e4,0x27328087,0x248d9dff}},	//   _leer_, dwan, când_, lgem_,
   {{0x1dbd88af,0xa928826f,0x291da4e5,0x09e581e5}},	//   ्मित, ližš, kowa_, _хойн,
   {{0x2ca90706,0x7afc06d4,0x6f1c016a,0x386d837a}},	//   gead_, _smrt, sorc, _neer_,
   {{0xfc3f04c3,0x291da4e6,0x63ad24e7,0x2d8324e8}},	// [1460] _saír_, dowa_, gwan, arje_,
   {{0x290224e9,0xe81f8740,0x78b60214,0x6b96016d}},	//   lika_, _बड़ा_, _hayv, rtyg,
   {{0xb87b0876,0x5ba880d4,0x399504e1,0x6edb01c6}},	//   chís, _कन्व, gås_, _החיפ,
   {{0x29020288,0x63ad24ea,0x2fc001a3,0x3eaa0192}},	//   nika_, bwan, _krig_, lebt_,
   {{0x4cbb0051,0xdcfc0029,0x2d9824eb,0x6b898264}},	//   _הזכו, strē, ltre_, jueg,
   {{0x290224ec,0x6d4624ed,0xb4b48105,0x6b8424ee}},	//   hika_, _hika, _छोड़_, mrig,
   {{0x290224ef,0x2d9824f0,0x6d4624f1,0x291da4f2}},	//   kika_, ntre_, _kika, bowa_,
   {{0xe05591fb,0x94aa8bac,0x6eeb0201,0x6d4616f8}},	//   _قیمت_, стка_, _müba, _jika,
   {{0x290224f3,0x6d4624f4,0x6b8424f5,0x7f4a826a}},	//   dika_, _mika, nrig, _طلاق_,
   {{0x6d4624f6,0x386d8a0f,0x61e1a4f7,0x248d83a7}},	//   _lika, _zeer_, fyll, agem_,
   {{0x290224f8,0x63ad24f9,0x6b8402af,0x6d5a8b64}},	//   fika_, zwan, hrig, _utta,
   {{0xc0580a4c,0x63ad0063,0x2fc0031d,0x6b840bbd}},	//   зір_, ywan, _brig_, krig,
   {{0x613f0029,0x3869808b,0xb4db0722,0x27328087}},	//   _jūli, ðari_, _diàl, pând_,
   {{0x4426a4fa,0x6d4624fb,0xa3c209a3,0xa3c00540}},	//   _iyo_, _aika, ्मन_, ंटन_,
   {{0x26da0698,0xcb138158,0x6d4624fc,0x2902028d}},	//   _dopo_, _אלס_, _bika, bika_,
   {{0x6d4624fd,0x44268365,0xe81e123a,0x2d8300f1}},	//   _cika, _kyo_, _युवा_, rrje_,
   {{0x2d9c1918,0x6d46059c,0xa87c0051,0x386d82a3}},	// [1470] _även_, _dika, _האחר, _reer_,
   {{0x63ad0578,0x6eef8022,0x7cea003e,0x291da4fe}},	//   rwan, _købe, _výra, wowa_,
   {{0x68ed07df,0x63ad24ff,0x6d462500,0x291da501}},	//   _klad, swan, _fika, towa_,
   {{0xf1c00104,0xf77185ff,0x399500f2,0xddde001b}},	//   ương_, نات_, rås_, _nepř,
   {{0x68ed15d8,0x6eef813c,0x4426a502,0x611200eb}},	//   _mlad, _løbe, _nyo_, nāla,
   {{0x386d81d8,0x6da5a503,0x291da504,0x6d462198}},	//   _weer_, дика, sowa_, _zika,
   {{0xfe708d4a,0x68ed046d,0x4426a505,0xc9842410}},	//   اده_, _olad, _ayo_, _пути,
   {{0x7d0d2506,0x44268e4d,0x29022507,0x61120ec3}},	//   nnas, _byo_, xika_, kāla,
   {{0x248da508,0x442682a0,0xdb1d2509,0x61e18114}},	//   rgem_, _cyo_, _arsé, wyll,
   {{0x6721803b,0x68ed250a,0x7cf1250b,0x7d0d031d}},	//   _uklj, _alad, _hård, hnas,
   {{0x2902250c,0x68ed0cda,0x60db8247,0x6f038098}},	//   tika_, _blad, _koum, minc,
   {{0x68ed250d,0x61e1a50e,0x7d0d026c,0xe45f0106}},	//   _clad, ryll, jnas, _snön_,
   {{0x2902250f,0x61e18355,0x6d462510,0xdb0f2511}},	//   rika_, syll, _rika, _escé,
   {{0x2d982512,0x68ed2513,0x29022514,0x7529a515}},	//   ttre_, _elad, sika_, llez,
   {{0xceb2878d,0xf7432516,0x29022517,0x31160a0e}},	//   כים_, теро, pika_, _офис,
   {{0xd1320b76,0x2d982518,0x7d0d007b,0x60dba519}},	//   _جمع_, rtre_, gnas, _noum,
   {{0x26da251a,0xeb97251b,0xddc7251c,0x442681c0}},	// [1480] _topo_, мит_, rajš, _xyo_,
   {{0x6d46009c,0xa01b251d,0x7c26016b,0x7d0d0706}},	//   _wika, rgöt, _vykr, anas,
   {{0x6d460341,0x6f03a51e,0x644b81e8,0x810206a7}},	//   _tika, dinc, _oggi, _लगाओ_,
   {{0x6b84251f,0x61e30edd,0x236000f3,0xa3bf801b}},	//   prig, ønla, ppij_, ुमा_,
   {{0x4f579e91,0x60db8bfe,0x6f03a520,0x75298da8}},	//   وجود_, _doum, finc, dlez,
   {{0x644b8698,0x7d042521,0x75228353,0x75298010}},	//   _aggi, liis, _skoz, elez,
   {{0x1ea980f7,0x7ae30009,0xa01b2522,0x4096a523}},	//   ثاني_, önte, ngör, _орат,
   {{0x7529a524,0x2902816d,0x44268683,0x629e2525}},	//   glez, _öka_, _pyo_, lfpo,
   {{0x3866a526,0x6f0385a3,0xdb04002a,0xd00781a1}},	//   mbor_, binc, lviñ, _жете_,
   {{0x68ed077b,0x6d5e003a,0x2b47809f,0x7d040079}},	//   _slad, _otpa, _cinc_, hiis,
   {{0x6d5ea527,0x68ed0022,0x7d042528,0x7cf1104a}},	//   ípad, _plad, kiis, _håre,
   {{0x80e080c8,0x4426a529,0x7cf1006f,0x63a61384}},	//   পোর্, _tyo_, _kåre, _opkn,
   {{0x68ed0289,0x7d0402a3,0x6d5e252a,0x59b0805e}},	//   _vlad, diis, _atpa, _जनवर,
   {{0xe8df801c,0x68ed252b,0x3f99252c,0x69c101a1}},	//   _miền_, _wlad, rtsu_, _šlem,
   {{0x442d252d,0xc3488028,0xe8df801c,0x7d0d252e}},	//   _še_, _nổi_, _liền_, tnas,
   {{0x3998a52f,0x6f03a530,0x7d042531,0x30a704bd}},	//   més_, zinc, giis, _цркв,
   {{0xe667017a,0x3998a532,0x6e2883ba,0x60dba533}},	// [1490] _отно, lés_, _lydb, _roum,
   {{0x7d0d2534,0x4ac9000f,0x3f8687b1,0x35b52535}},	//   snas, राइव, drou_, _збор,
   {{0x6f03a536,0x7d042537,0x3998a538,0xa2c42539}},	//   vinc, biis, nés_, राज्,
   {{0x7d0401b4,0xa8158162,0x4f958087,0x61360144}},	//   ciis, ндеш, ерку, rálg,
   {{0x3f868ece,0x7cf100f2,0x3949253a,0x399880e7}},	//   grou_, _vård, _mias_, hés_,
   {{0x39490282,0x8ca1809a,0x6d580036,0x6b8d0c53}},	//   _lias_, क्नो, _évac, muag,
   {{0x6f03a53b,0x7bc2a53c,0x60dba53d,0xada5a53e}},	//   rinc, _arou, _toum, хайл,
   {{0x6234253f,0x60c9a540,0x39490069,0x3998a541}},	//   _ресу, _unem, _nias_, dés_,
   {{0xa2c4016f,0x7bc2a542,0x6136016b,0x7529890d}},	//   राच्, _crou, nále, rlez,
   {{0xa3c20c78,0x7529928a,0x394906ae,0xaad20b84}},	//   ्मत_, slez, _aias_, सायक,
   {{0x39492543,0x3998a544,0x2b47874a,0x290f8db1}},	//   _bias_, gés_, _vinc_, onga_,
   {{0x290f81e0,0x7bc284cc,0xf8bf003e,0x39492545}},	//   nnga_, _frou, blém_, _cias_,
   {{0x39492546,0x7bc2a547,0x2b47809f,0x7d0421e8}},	//   _dias_, _grou, _tinc_, viis,
   {{0xfbd08065,0x6136026f,0x2cad8079,0x3998a548}},	//   _ختم_, dále, leed_, bés_,
   {{0x18a615e3,0x64a62549,0x399887e2,0x7d04254a}},	//   _займ, нава, cés_, tiis,
   {{0x7cea0a56,0x2d878c41,0x2900254b,0x2cad81b4}},	//   _výro, irne_, _umia_, need_,
   {{0x7d04254c,0x6136254d,0x6b9ba54e,0xccf280be}},	// [14a0] riis, ráld, ntug, אכן_,
   {{0x7d0418dc,0x2cb90118,0x2cada54f,0x39490282}},	//   siis, _easd_, heed_, _zias_,
   {{0x39490282,0x7cf1120b,0x8886a550,0x7d042551}},	//   _yias_, _såre, ележ, piis,
   {{0xa3c206a7,0x70538077,0x3f86a552,0xdd2f001b}},	//   ्मद_, هنما, trou_, pěšn,
   {{0x39988065,0x2d87a553,0x78a42554,0x3c7701c6}},	//   zés_, erne_, _mbiv, _אתכם_,
   {{0x290fa555,0x399880e7,0x7bc48110,0x7cf10b64}},	//   anga_, yés_, _šiuo, _våre,
   {{0xf9879ddd,0x2cada556,0xc69300be,0x212b0114}},	//   _حب_, feed_, טאג_, ylch_,
   {{0xe8df8104,0x2cad8079,0x61469c8b,0x7cee8362}},	//   _tiền_, geed_, _чеба, _bùra,
   {{0x02e401ce,0xdccf8028,0x39492557,0x69c3a558}},	//   _गवाह_, _tỉnh_, _rias_, _arne,
   {{0x3998a559,0x7bc2a4de,0x93fb03c8,0x78a4255a}},	//   tés_, _vrou, פליי, _abiv,
   {{0x0d868847,0x3949255b,0xb05b0338,0xfaa38048}},	//   _член, _pias_, ndäg, ушын,
   {{0x39989b01,0xa3c21299,0xfc648bca,0x7bc2a55c}},	//   rés_, ्मा_, _شخصی, _trou,
   {{0x3998a532,0x3949255d,0xa30b8117,0xa2e69ccf}},	//   sés_, _vias_, _کرنے_, _подд,
   {{0x3998a55e,0x8c4395d2,0x26de804f,0x9f35004a}},	//   pés_, _сече, _joto_, тегі,
   {{0x394910af,0x3eba255f,0x62830511,0x7e752560}},	//   _tias_, _dapt_, ónom, razp,
   {{0x6b8d2561,0x0ccf00ab,0x81d60264,0x7cf1006f}},	//   tuag, রস্ত, িনা_, _sårb,
   {{0x60cd02a0,0x3eba002e,0x26cca562,0x7d02826c}},	// [14b0] _inam, _fapt_, _ondo_, _mmos,
   {{0x78bd04fe,0x78a415db,0x26dea563,0x6b8d2564}},	//   ldsv, _zbiv, _noto_, ruag,
   {{0x2cad82c1,0xab5b02af,0x290f8bb1,0x7d02a565}},	//   yeed_, _grün, tnga_, _omos,
   {{0x82341301,0x78bd0bcb,0xa95400e8,0xd47900be}},	//   اركا, ndsv, укці, _קאָל,
   {{0x27e68065,0x78bd0fb0,0x60cd004f,0x26dea566}},	//   gyon_, idsv, _mnam, _boto_,
   {{0x7d02a567,0xe8df8028,0x752d2568,0x26de8333}},	//   _amos, _biển_, llaz, _coto_,
   {{0x30a7a569,0xa8a799b8,0x62340ca0,0x387f808e}},	//   _прав, _прак, _беру, _tdur_,
   {{0x6b9ba56a,0x7cf58661,0x09e480ab,0x81c88264}},	//   ttug, _márg, _ফেভা, োনা_,
   {{0x249fa56b,0x2cada56c,0xf69984ae,0x69dca56d}},	//   rfum_, reed_, _овај_, ären,
   {{0x6b9ba56e,0x60cd256f,0x78bba570,0x752d237d}},	//   rtug, _anam, _hauv, hlaz,
   {{0x3f8fa571,0x6723822b,0x6b9ba572,0x60cd0144}},	//   lugu_, monj, stug, _bnam,
   {{0x6723a573,0x60cd0362,0xa3d1001b,0x69c382d4}},	//   lonj, _cnam, वमा_, _vrne,
   {{0x3ae4016d,0x78bb80e7,0xe29983a7,0x442b2574}},	//   _köpt_, _mauv, _жал_, _nyc_,
   {{0x290680ad,0x6d4ba575,0x60cd2576,0x6723a577}},	//   zioa_, _higa, _enam, nonj,
   {{0x3f8f8578,0x6d4ba578,0x27e6942a,0x752d2579}},	//   hugu_, _kiga, zyon_, flaz,
   {{0x6d4b8300,0x3f8fa57a,0xfbe700ff,0x7cfea57b}},	//   _jiga, kugu_, _thể_, tūri,
   {{0x6d4ba57c,0x69c1a57d,0x0326257e,0x442b00ee}},	// [14c0] _miga, lvle, вдан, _cyc_,
   {{0x6d4ba57f,0x394a026f,0x3f8fa580,0x6b89802a}},	//   _liga, _časy_, dugu_, ireg,
   {{0xe2971a8f,0x26dea581,0x6723a582,0x752d2583}},	//   тах_, _roto_, donj, blaz,
   {{0x26dea584,0x6b8980f3,0xe78681e2,0xa9670adb}},	//   _soto_, kreg, вуко, тица_,
   {{0xa2b2835a,0x26dea585,0xa8570039,0x75242586}},	//   _असल्, _poto_, דינה_, moiz,
   {{0x6b898620,0x6723a587,0x57fb0039,0x7bc6022b}},	//   dreg, gonj, ולנו, _irku,
   {{0x27e6a588,0x6d4ba589,0xe297258a,0x7bc081c0}},	//   syon_, _biga, _шар_, wvmu,
   {{0x399c0722,0x6abc258b,0x6b89a58c,0x753982d6}},	//   mís_, _harf, freg, _chwz,
   {{0x26de803e,0x6d4b859e,0x6b89a58d,0x6abc00a4}},	//   _toto_, _diga, greg, _karf,
   {{0x613184b8,0x78bb805c,0x60cd258e,0x78a2a58f}},	//   håll, _zauv, _snam, lfov,
   {{0xa2c30f21,0x399c2590,0x6abc2591,0x68e0a592}},	//   रयत्, nís_, _marf, _komd,
   {{0x6d4b84a7,0x7bc62593,0x7cf581ca,0x92ae00ab}},	//   _giga, _orku, _cárd, কায়_,
   {{0xe9ff8104,0x399c00f7,0x7bd601c0,0x53b6a594}},	//   _phải_, hís_, jxyu, _अनिश,
   {{0x6d4ba595,0x3d952596,0x28a4864a,0x65952597}},	//   _ziga, лигр, _गॉसि, лагу,
   {{0x5e58035f,0x7bc62598,0x2904a599,0x09e384bd}},	//   тися_, _arku, _omma_, _војн,
   {{0x5183a59a,0x60cd259b,0xc9838468,0x399c259c}},	//   _туша, _unam, _туши, dís_,
   {{0x6d408009,0x6abc259d,0xe9ff80ff,0x6d580866}},	// [14d0] imma, _barf, _thải_, _évan,
   {{0x2904a59e,0x78bb82be,0xe8df8028,0x61360125}},	//   _amma_, _sauv, _miễn_, mála,
   {{0x6abc259f,0xce330bca,0x22470884,0xd36680d7}},	//   _darf, _خودک, änk_, _گه_,
   {{0xf8bf25a0,0xfc640698,0x3f8fa5a1,0xfc3f06a5}},	//   ndé_, _върн, tugu_, _maíz_,
   {{0xd3668154,0x70848048,0x6abc25a2,0x6d4ba5a3}},	//   _ده_, ргіз, _farf, _riga,
   {{0x6d4b883a,0x6abc25a4,0x7e7880eb,0x539a04de}},	//   _siga, _garf, gavp, _אישו,
   {{0x613600f7,0x399c25a5,0xdcef81a1,0x6d4ba5a6}},	//   hála, cís_, _žeđa, _piga,
   {{0x6b89a5a7,0x2602816f,0xe3b9a4c8,0x69c7008e}},	//   treg, _वेळी_, еби_, _irje,
   {{0x6d4ba5a8,0x6723a5a9,0x032581cf,0xecc50264}},	//   _viga, ponj, лдин, _একাড,
   {{0x6b89a5aa,0xe8df8104,0x61e8831d,0x645ba5ab}},	//   rreg, _diễn_, fydl, scui,
   {{0x049587bd,0x394d8b3c,0x6d4ba5ac,0x7c2b809a}},	//   _ملاح, _kies_, _tiga, _wygr,
   {{0x6b898e67,0x69c1a5ad,0xa6e28125,0x2d910234}},	//   preg, rvle, _öðru, duze_,
   {{0x7d09a5ae,0x394d9405,0xfaa5a5af,0x7524007d}},	//   mies, _mies_, _бало, voiz,
   {{0x272981df,0x69c725b0,0xe2998320,0x24990122}},	//   múns_, _orje, _чак_, _acsm_,
   {{0x52398158,0xd33681c6,0x26ca8118,0x2d910542}},	//   _אײַנ, _גרסה_, _óboe_, guze_,
   {{0x7d09a5b1,0x399c25b2,0x394d84b7,0xa3c00540}},	//   nies, vís_, _nies_, ंटल_,
   {{0x42ca02df,0x4ab7835a,0x7cf5a5b3,0x2d8a026c}},	// [14e0] нган_, _असाव, _kárb, srbe_,
   {{0x80a005e8,0xe2970087,0xa3d48063,0x2cbd8282}},	//   ग्रे, лау_, हमत_, _lawd_,
   {{0x6abc25b4,0x869b012a,0x8cbf0327,0x7ce30074}},	//   _varf, _אייז, _लोको, _võrr,
   {{0x399c22c6,0x2cbd822c,0x6ae0801b,0x50ba8199}},	//   rís_, _nawd_, _पक्र, عداد_,
   {{0xb8dc9d01,0x394da5b5,0xdee6a5b6,0x7d09a5b7}},	//   _अस_, _dies_, лоди, dies,
   {{0x2d808029,0xd5ba9324,0x3f598580,0x394d821e}},	//   ņiem_, еси_, _dèu_, _eies_,
   {{0x7d09a5b8,0xc693025f,0x69c705f3,0xd13281a8}},	//   fies, צאה_, _grje, _همس_,
   {{0x2904a5b9,0xfc3f05e4,0x7d09a5ba,0x62838114}},	//   _umma_, _raíz_, gies, _adno,
   {{0x4e968307,0x2729862f,0xd2508013,0x12e68071}},	//   _مشار, gúns_, ينة_, гінг,
   {{0x7cf804c3,0x61e8816d,0xe8df801c,0x61360019}},	//   _fírg, tydl, _viễn_, vála,
   {{0x7d09a5bb,0x39152457,0x6eef83ba,0x28f925bc}},	//   bies, имор, _møbl, вень_,
   {{0x2d9102a0,0x8c3d802e,0x3ebe80e8,0x7d09a5bd}},	//   vuze_, teşt, _hatt_, cies,
   {{0x8cbf0063,0xead48678,0x3ebea5be,0xf8bf25bf}},	//   _लोगो, _воль, _katt_, rdé_,
   {{0x8c3d802e,0x43839ddd,0x613600f7,0xef1f07c0}},	//   reşt, _الوق, rála, mrük_,
   {{0x613625c0,0x8c3d802e,0x6d5802be,0x4a5b83c8}},	//   máln, seşt, _éval, _אדוו,
   {{0x69c700f1,0x628a0511,0xdb1981ec,0xa99b81c6}},	//   _rrje, ófon, _erwä, _נבחר,
   {{0xe8df8104,0x3a750087,0x1bd40081,0xa3e48075}},	// [14f0] _hiện_, илар, ботя, नहि_,
   {{0x6136037d,0xe8df8028,0x7d0986d7,0x3ebe8b64}},	//   náln, _kiện_, zies, _natt_,
   {{0x38600125,0xc3338051,0xa2c9016f,0x28c6904f}},	//   _yfir_, צוע_, _होण्, _रोहि,
   {{0x290b04ef,0x7cf58019,0x80d80beb,0x2fc901b0}},	//   nica_, _márc, याये, _krag_,
   {{0x394d837f,0xdb0f05e4,0x7d09a5c1,0x613603b0}},	//   _vies_, _escá, vies, káln,
   {{0x236902ee,0x7d09a5c2,0x2cbd81de,0xb4db0229}},	//   mpaj_, wies, _sawd_, _bhàg,
   {{0x7d09a5c3,0x1dc58697,0x45199bba,0x6d4f10e1}},	//   ties, विधत, кция_, _kica,
   {{0x2bc912ee,0xa2c9016f,0x6d570079,0x7cf81520}},	//   रिपा, _होत्, _muxa, _vírg,
   {{0x6e959ad0,0x3ebe81b9,0x3ced9b3b,0x2fc901c0}},	//   _визу, _fatt_, rkev_, _nrag_,
   {{0x6d4f01c5,0x7d09a5c4,0x7cf5988b,0x4255824b}},	//   _lica, sies, _bárc, штит,
   {{0x290b1f65,0x7cf80065,0x6b8d08b3,0x7cf585e4}},	//   fica_, _híre, hrag, _cárc,
   {{0xe8df8028,0x61fa0006,0x6fdc80ab,0xe0461bc1}},	//   _diện_, _ütle, _মেয়ে, инни,
   {{0xf36792b2,0x08360678,0x61360c83,0x69dc8257}},	//   _стен, рхня, báln, ører,
   {{0xfc3f046d,0x7d0600ee,0x7cf801a8,0x2fc925c5}},	//   _abío_, _smks, _míre, _drag_,
   {{0x7ae38307,0x6d4f1258,0x649a25c6,0x2d9e00e7}},	//   _iont, _bica, ктар_, îte_,
   {{0x6b8d25c7,0xb4e3816f,0xa2cd816f,0x05550012}},	//   frag, _नको_, ताक्, стря,
   {{0x6d4f25c8,0xdbd98187,0x61360019,0x42561dc7}},	// [1500] _dica, _açúc, lálo, атет,
   {{0x8ccc8063,0x68e40406,0x6d57002a,0xff7b00be}},	//   _दोनो, _hoid, _fuxa, _שטימ,
   {{0x6d4f00a9,0x613614b5,0x442f8084,0x3ebea0db}},	//   _fica, nálo, _lyg_, _ratt_,
   {{0x7ae3a5c9,0xdbdc003e,0x3ead0024,0x3ebe83e5}},	//   _lont, lšíc, đete_, _satt_,
   {{0x3ebe822b,0xc7a3964f,0x3869a5ca,0x684a0196}},	//   _patt_, жичк, ñara_, būdž,
   {{0x7ae3a5cb,0x7cf80013,0x290b002e,0xdfcf80f7}},	//   _nont, _díre, zica_, بيه_,
   {{0x442f808e,0x6ef48a2a,0x7cf80174,0x6d4f09ae}},	//   _ayg_, _càba, _tírd, _yica,
   {{0x290b062f,0x7ae3861f,0x3ea0801b,0x628303f2}},	//   xica_, _aont, řit_, ónov,
   {{0x2bc91a46,0x6136003e,0x60c2a5cc,0x3ebe80e8}},	//   रिया, táln, mdom, _tatt_,
   {{0xdbdc026f,0x60c28110,0x395825cd,0x68e40219}},	//   jšíc, ldom, _kurs_, _aoid,
   {{0x60c089ab,0x613625ce,0x7ae3a5cf,0x7e7700b9}},	//   _kamm, ráln, _dont, _rexp,
   {{0xb35689d7,0x03a68767,0x68e404c3,0x60c0a5d0}},	//   _پیدا_, _видо, _coid, _jamm,
   {{0x6d4f1155,0xe8010a43,0x7cf10b40,0x68e40187}},	//   _rica, _लेखा_, _dårl, _doid,
   {{0xe8df8028,0x6d4f25d1,0x6b8d25d2,0x6d57241f}},	//   _tiện_, _sica, vrag, _puxa,
   {{0xe5c40af2,0x5bb68ebf,0x13b699e8,0xab5b25d3}},	//   осто, _अनुव, _अनुभ, _trük,
   {{0x2fc68025,0x60c0a5d4,0x987515d1,0xb4c10074}},	//   kvog_, _namm, _улиц, ंये_,
   {{0x56950323,0xa2cb8072,0x7cf58061,0xdd2f128a}},	// [1510] _лапт, _थोड्, _jára, _těžb,
   {{0x6b8d25d5,0x60c08df6,0xf9c71fb4,0x6d4f25d6}},	//   rrag, _aamm, ищен, _wica,
   {{0x395825d7,0x6d4f25d8,0x60c08c2e,0xb4db25d9}},	//   _curs_, _tica, _bamm, _diàr,
   {{0x6b82803a,0x60c2904a,0x60c0a5da,0x395825db}},	//   _ovog, gdom, _camm, _durs_,
   {{0x7d0d009a,0x7cf58a21,0x23668282,0x60c0888b}},	//   mias, _nára, _ntoj_, _damm,
   {{0xaf0480e8,0x395825dc,0x442fa5dd,0x60c28035}},	//   опіл, _furs_, _ryg_, adom,
   {{0x7ae3a5de,0x6b8281df,0x29090009,0x645a0087}},	//   _ront, _avog, _omaa_, _ştii,
   {{0x7d0d0048,0x61360061,0x201e0087,0xeb998991}},	//   nias, gáll, ştii_, гии_,
   {{0x7ae3a5df,0x69ca831d,0xb4db0706,0x57f583a7}},	//   _pont, _arfe, _ghàe, _упат,
   {{0x81e280c8,0x7d0d25e0,0x61360510,0x6b828289}},	//   _নেই_, hias, tálo, _dvog,
   {{0x68e425e1,0x7e7c007b,0x7ae3a5e2,0x60c0a5e3}},	//   _poid, varp, _vont, _yamm,
   {{0x5f0503bb,0x7ae38288,0x26d301df,0x673e00f1}},	//   होस्_, _wont, _anxo_, _shpj,
   {{0x68e40009,0x7e7c25e4,0x6b65946c,0x69ca874c}},	//   _void, tarp, _укла, _erfe,
   {{0x7afaa5e5,0x60c2a5e6,0x61fb09ab,0x613d25e7}},	//   chtt, zdom, _ƙull, véle,
   {{0xf8bf040e,0x99858624,0xa2db25e8,0x61462118}},	//   glés_, _البو, नान्, _лека,
   {{0x6ab78a74,0x3d08016f,0x2b59002a,0x7e7c039c}},	//   _असुर, _सगळे_, _busc_, sarp,
   {{0x6d4425e9,0x60c08e51,0x7cfc8065,0xdbdc026f}},	// [1520] rmia, _ramm, _férf, pšíc,
   {{0x60c08f06,0x3f820052,0x6d4425ea,0x212d8077}},	//   _samm, msku_, smia, _akeh_,
   {{0x7cf807a3,0x7d0d25eb,0xc879880a,0x394001c0}},	//   _círc, bias, _beş_, _khis_,
   {{0x60c29c33,0x03a61630,0x27328087,0x2bbc82f1}},	//   udom, _лимо, mâni_, ्टमा,
   {{0x3f8225ec,0x44240028,0x81e600ab,0xbbb6824c}},	//   nsku_, _âm_, _বেশ_, _अनेक,
   {{0xb8ef901b,0x63a425ed,0x3ce0011a,0xe3e88019}},	//   _वो_, mtin, ljiv_, یکشن_,
   {{0x7bcba5ee,0xa3c2000c,0x6b82a5ef,0x60c088e5}},	//   _argu, ्मक_, _svog, _tamm,
   {{0xdb1d016d,0x18a38468,0x3ce0011f,0x26c30267}},	//   _ersä, _насм, njiv_, zdjo_,
   {{0x3f820025,0x241881bb,0xda7a9ebd,0xe73a8073}},	//   jsku_, ропы_, лян_, _беа_,
   {{0x3f82005c,0x4ace0327,0x3f5d00ff,0x27f98074}},	//   dsku_, _होमव, _rìu_, _üsna_,
   {{0x63a425f0,0xd2508c48,0x7bcba5f1,0x68fd03ed}},	//   htin, بند_, _ergu, ërdo,
   {{0x3a370051,0x63a425f2,0x6b828042,0x463b80be}},	//   מרים_, ktin, _tvog, _געבע,
   {{0x6d5aa5f3,0x7bcb811f,0x3946a216,0xc1a50778}},	//   _huta, _grgu, imos_, _गङ्ग,
   {{0x6d5aa5f4,0x61360019,0xdb1d0187,0x28cfa539}},	//   _kuta, nálj, _essê, _सोनि,
   {{0xc27b893f,0x6d5a8304,0x3ce6822c,0x2b59026c}},	//   _גרוי, _juta, _koov_, _susc_,
   {{0x6d5aa5f5,0x26c1018e,0xdb060019,0xa4f102d0}},	//   _muta, _waho_, _eskü, _dışı_,
   {{0x28d61a3b,0x63a425f6,0x3ce6a5f7,0x26c125f8}},	// [1530] धारि, gtin, _moov_, _taho_,
   {{0x629aa5f9,0x7d0d25fa,0xda670013,0x39468876}},	//   ngto, sias, صائي, emos_,
   {{0x7cfc8117,0xb9b50872,0x6d5aa5fb,0x9962026f}},	//   _kérd, تماع, _nuta, _píše_,
   {{0x3835a5fc,0x212b25fd,0xd011803f,0xb4db0362}},	//   онер, noch_, ولا_, _dhàc,
   {{0x6d5aa5fe,0x656880f1,0x63a425ff,0x7d1d01ed}},	//   _auta, _atdh, ctin, _ijss,
   {{0x6d5aa600,0x39838214,0x7cf58333,0x212b2601}},	//   _buta, yıs_, _cárn, hoch_,
   {{0x78ad0025,0x6d5a80a4,0x2d832602,0x212b01ac}},	//   _obav, _cuta, nsje_, koch_,
   {{0x3f8201b4,0x6d5a8314,0x2d8301ed,0x212b01d6}},	//   ysku_, _duta, isje_, joch_,
   {{0x212b2603,0xeab99d7b,0x290fa604,0x7529a605}},	//   doch_, айп_, miga_, roez,
   {{0x290f9f6a,0xf6f5817e,0xdb1d016d,0x78ad1ea2}},	//   liga_, _بزرگ, _ursä, _abav,
   {{0xd9462606,0x6d5aa607,0xf7488013,0x7ae70669}},	//   жени, _guta, _اللي_, _mojt,
   {{0x63a42608,0x3f82003a,0x290fa609,0xa4f7803d}},	//   ytin, tsku_, niga_, _دکتر_,
   {{0x3f8403cb,0xe73a0991,0x7cf58019,0xbbeb803f}},	//   ému_, ием_, _háro, _حرام_,
   {{0x7f5b82a3,0x3f82260a,0x290fa60b,0x7cf58019}},	//   _muuq, rsku_, higa_, _káro,
   {{0x3940073a,0xdd920277,0x7bc9a60c,0x290fa60d}},	//   _this_, ظور_, lveu, kiga_,
   {{0x63a4260e,0x3f820067,0x4c6a0b87,0x212b260f}},	//   ttin, psku_, риан_, coch_,
   {{0x290fa610,0x63a42611,0x6ef00074,0x130a0110}},	// [1540] diga_, utin, _läbi, анай_,
   {{0x63a42612,0x2d91009a,0xdcfc00eb,0x78ad2613}},	//   rtin, brze_, turē, _zbav,
   {{0x7cf5803e,0x5bb6800d,0x60c42614,0xfce614d6}},	//   _náro, _अन्व, _kaim, _доно,
   {{0x6d5aa615,0x63bb8870,0x63a42616,0xeb9a0c9d}},	//   _ruta, kwun, ptin, _ким_,
   {{0x3946a617,0x60c42618,0x6d5aa619,0xdb0406a8}},	//   rmos_, _maim, _suta, ntië,
   {{0x39469313,0x6d5aa61a,0x2480261b,0x60c4261c}},	//   smos_, _puta, laim_, _laim,
   {{0x2d98261d,0x290fa61e,0x6b84261f,0x7cfc83a8}},	//   nure_, biga_, lsig, _lére,
   {{0x443d82af,0x3eb801ec,0x6d5ca620,0x290fa621}},	//   _bzw_, hert_, _éram, ciga_,
   {{0x3eb82622,0x6b842623,0xa686838d,0x14a68d72}},	//   kert_, nsig, _млад, क्षण,
   {{0x6d5aa624,0x61360019,0x2d982625,0x212b01ec}},	//   _tuta, lálh, kure_, woch_,
   {{0xa2db1a3b,0xd62a8009,0x7cfca626,0x3eb82627}},	//   नात्, _тоже_, _pérd, dert_,
   {{0x60c4051e,0x613d007b,0x61360019,0x69c88106}},	//   _caim, féla, nálh, rvde,
   {{0xd83b01e5,0x60c42628,0x6b840042,0x7cf585b9}},	//   рэн_, _daim, jsig, _záro,
   {{0x6b842629,0x290f8f8e,0x2d83090d,0x3eb801e3}},	//   dsig, ziga_, tsje_, gert_,
   {{0x290f8ec8,0x6d42801c,0x7ae7262a,0x2d98262b}},	//   yiga_, _khoa, _rojt, gure_,
   {{0x24f80fe6,0x245802c7,0x7aea80eb,0x290fa62c}},	//   онсы_, жать_, žotā, xiga_,
   {{0x20020063,0x7cfc80e7,0x69de262d,0x290fa62e}},	// [1550] czki_, _gére, expe, viga_,
   {{0x3eb807f1,0xdb040036,0x2d980a03,0x28ac06a7}},	//   cert_, ntiè, bure_, ट्ठि,
   {{0x7ae7262f,0x80b000c8,0x6b8418dc,0x6d352630}},	//   _vojt, য়ার্, asig, _неоф,
   {{0x52b7a631,0x02b783ca,0x6b840079,0x7cf8002a}},	//   _अस्स, _अस्न, bsig, _tíra,
   {{0x290fa632,0x3f992633,0x69ce2634,0x6b840079}},	//   riga_, nusu_, _erbe, csig,
   {{0x290fa635,0x6d429fa4,0x7cf5a636,0xed5986c8}},	//   siga_, _ahoa, _páro, бок_,
   {{0x3f9900f6,0x290f822e,0x2bc90f97,0x6d428362}},	//   husu_, piga_, रिवा, _bhoa,
   {{0x7cf58065,0xd5ae80f7,0x6136016b,0x7bcf01a1}},	//   _váro, افي_, rálk, _krcu,
   {{0x2d982637,0x2d98816d,0x3ec48009,0x48fa80be}},	//   zure_, _åren_, östä_, _פּלא,
   {{0x61360ede,0x60c42638,0x7bc980e7,0x613d2639}},	//   máli, _saim, rveu, véla,
   {{0x3eb8263a,0x7c2280ee,0x60c4263b,0x7bc9826c}},	//   vert_, _exor, _paim, sveu,
   {{0x3ea1263c,0x3eb802af,0x7cfc91b9,0x6b84263d}},	//   _acht_, wert_, _pére, ysig,
   {{0x26c5835a,0xe28ea63e,0x68e99989,0x3eb8263f}},	//   _kalo_, _па_, _moed, tert_,
   {{0xb8f305e8,0x2d982640,0x26c58a6e,0x60c42641}},	//   _हो_, ture_, _jalo_, _waim,
   {{0x26c58b5d,0x6281a642,0x60c42643,0x57b8809a}},	//   _malo_, malo, _taim, _इन्ह,
   {{0x3ea12644,0xab66076a,0x7d1ba645,0x3eb8035f}},	//   _echt_, звал, nnus, sert_,
   {{0x7cfc8c52,0x24800c5e,0x2d9822c5,0x6d498c41}},	// [1560] _hérc, raim_, sure_, imea,
   {{0x2d980098,0x6b842646,0x26c5a647,0x6d4981a8}},	//   pure_, rsig, _nalo_, hmea,
   {{0x68fba648,0x68e9831e,0x14bd824c,0xdb040144}},	//   _blud, _boed, ्याण, ntié,
   {{0x7cfc862f,0x7cf58019,0x7e7e2649,0x00e68009}},	//   _mérc, _bárm, _hepp, яжен,
   {{0x7e7e007b,0x26c5a64a,0x68e281b9,0x68e98114}},	//   _kepp, _balo_, rjod, _doed,
   {{0x6d5e264b,0x62818503,0x6daa8201,0xf1db89c2}},	//   _kupa, jalo, _fəal, यमान,
   {{0x4343264c,0x6281a64d,0xbb43264e,0x69da00e1}},	//   _черв, dalo, _черк, _štef,
   {{0x68e9a64f,0x7e7e2650,0x7cf59984,0x7d1ba651}},	//   _goed, _lepp, _fárm, gnus,
   {{0x6d5e2652,0x26c5a653,0x613612ca,0x38668118}},	//   _lupa, _falo_, cáli, mcor_,
   {{0x6281a654,0xe3af8624,0x26c5a655,0x6d42a656}},	//   galo, اري_, _galo_, _whoa,
   {{0xd48fa657,0x386d0876,0x672e0353,0x3f86a363}},	//   _пр_, ñero_, dobj, lsou_,
   {{0x64a68048,0x26c593e0,0x3f992658,0xdca6a659}},	//   _хада, _zalo_, tusu_, _хади,
   {{0x6d5e265a,0xddc8826c,0x7e7e01e8,0x3f86a41f}},	//   _aupa, _jedž, _bepp, nsou_,
   {{0xb4db265b,0xddc881e2,0x628a813c,0x6d5e0e60}},	//   _chàn, _medž, _udfo, _bupa,
   {{0x28dd0663,0xa2a1816f,0x3f99265c,0x7e7e1ff5}},	//   यादि, _खात्, susu_, _depp,
   {{0x2eb9823c,0x645a0087,0x291ca65d,0x5d542255}},	//   _इस्त, _ştir, éval_, екст,
   {{0x68e98355,0x201e07d9,0xddc888ae,0x3f86801b}},	// [1570] _roed, ştir_, _nedž, jsou_,
   {{0x68fb80eb,0x7cf80019,0x79850234,0x7bcd8084}},	//   _slud, _hírl, tshw, _šauk,
   {{0x68fba65e,0xaaae8bc2,0x68e9a65f,0xf1c201a9}},	//   _plud, ज्यक, _poed, jušā_,
   {{0x26c580a4,0xf9900bbe,0x61362660,0x7e7e2661}},	//   _salo_, ابل_, táli, _zepp,
   {{0x2b9319f4,0x68e985f8,0x7e7e04e6,0x37ab938c}},	//   _سیاس, _voed, _yepp, стен_,
   {{0xe8da00a5,0x2bb68105,0xddc88267,0x68e98cfa}},	//   _बच्च, _अनजा, _dedž, _woed,
   {{0x68e9a26f,0x7cf80144,0x7bc28176,0x27328162}},	//   _toed, _oírl, _asou, vânt_,
   {{0xddc8826c,0xed568098,0x69da0088,0x68fb82d0}},	//   _fedž, мощ_, _šteg, _ulud,
   {{0x6d4984bc,0x26c5a662,0xa2a18aed,0xddc8a663}},	//   rmea, _talo_, _खाद्, _gedž,
   {{0xff5380f7,0x38692664,0x3cff8901,0x6d49a12b}},	//   _أخر_, _afar_, shuv_, smea,
   {{0x387f800b,0x7bc2a665,0x7aeaa666,0x7cee851e}},	//   _keur_, _esou, _doft, _cùrs,
   {{0x6281a667,0x6d5e2668,0xc689007c,0xdb040020}},	//   salo, _rupa, _כא_, rtié,
   {{0x6d5e2669,0x387fa66a,0xfaa59612,0x69dc8338}},	//   _supa, _meur_, _жало, ärer,
   {{0x387f83d3,0x3cfd81c0,0x2bbc801b,0x6ef48362}},	//   _leur_, _hlwv_, ्टरा, _càbh,
   {{0x63a9a66b,0x64a6266c,0x7cfca639,0xe7371505}},	//   lten, мава, _héra, фер_,
   {{0x249f8125,0x2056266d,0x7cf8266e,0x6eef8366}},	//   ngum_, _отпр, _víro, _købs,
   {{0xb4db0142,0xe8df8104,0xb4be009a,0x7e7e266f}},	// [1580] _thàn, _chọn_, _इसी_, _tepp,
   {{0x6138a670,0xb0c68aad,0x2d878aa2,0x63a9a671}},	//   míli, _रोजग, ksne_, iten,
   {{0xddd882a5,0x63a9a672,0x80a5103e,0x2d878c18}},	//   kavš, hten, _कामे, jsne_,
   {{0x7cf5801b,0x63a9a673,0x69c381a1,0x0cd88264}},	//   _dárk, kten, _msne, _তত্ত,
   {{0x387fa674,0xddd882a5,0x6ef48722,0x3866a675}},	//   _deur_, davš, _hàbi, rcor_,
   {{0x386687d0,0x6136007b,0xbd6a94ed,0x6b9ba676}},	//   scor_, málu, орие_, duug,
   {{0x63a9802e,0x94188201,0xf9878117,0xceb30039}},	//   eten, ərə_, _جب_, דיו_,
   {{0x7aea96f7,0x387fa677,0x67211809,0x2ca02678}},	//   _soft, _geur_, člji, ngid_,
   {{0x63a9a679,0x7aea8087,0x7cfc8036,0x290201b4}},	//   gten, _poft, _céra, dhka_,
   {{0x7aea80f1,0x78a403a8,0x69c80118,0x7cfc8036}},	//   _qoft, _aciv, _ádes, _déra,
   {{0xb4db0362,0x611c82d4,0x612802d0,0xdee38081}},	//   _bhàl, včlj, kıld, _шофи,
   {{0x61e3016d,0x63a9a67a,0xb4db0362,0x6cd3a0bb}},	//   änli, bten, _chàl, _لقما,
   {{0x628e267b,0x69c3a67c,0x63a9a67d,0x7cfc902d}},	//   _odbo, _esne, cten, _géra,
   {{0xaff980be,0x4426a67e,0xa3d2175d,0x2fd2267f}},	//   פּרי, _ixo_, विन_, _dryg_,
   {{0x6d46008e,0x9e341bcc,0xe93b07c3,0xb4db0362}},	//   _bhka, верч, _وسعت_, _fhàl,
   {{0x3ea98668,0x2b582680,0x628e0114,0x26da06c4}},	//   đati_, _airc_, _adbo, _enpo_,
   {{0x613896dc,0x7cfc8118,0x2b5800c3,0xa87c01c6}},	// [1590] cíli, _xéra, _birc_, _ואחר,
   {{0x2d8506a5,0x7bcd156e,0x28dd1869,0x31670118}},	//   áles_, rvau, यावि, ínzo_,
   {{0x63a99124,0x387f80e7,0x2d9ca681,0x68ed011b}},	//   zten, _peur_, juve_, _koad,
   {{0x78bd2682,0x63a9a445,0xf77180a0,0x09b100ab}},	//   nesv, yten, هات_, ছিলা,
   {{0x6d4d2683,0x2b580118,0x645d0420,0x68ed033e}},	//   mmaa, _firc_, _igsi, _moad,
   {{0xd246a684,0x6d4d2685,0x68ed2686,0x61360019}},	//   _من_, lmaa, _load, lált,
   {{0x62852687,0x6138a688,0xddd8811f,0x442682df}},	//   maho, zíli, tavš, _axo_,
   {{0xd658004c,0x62852689,0x6d4d06d9,0x61360019}},	//   ויות_, laho, nmaa, nált,
   {{0x3834a68a,0x60dba68b,0x7522826c,0x249f9ab2}},	//   _антр, _inum, _djoz, rgum_,
   {{0x6285049f,0xe3c88028,0x7cf5a68c,0x6442826c}},	//   naho, _dự_, _mári, _dzoi,
   {{0x4439268d,0xc332010f,0x442690e4,0x7cf581a8}},	//   _lys_, רוי_, _exo_, _lári,
   {{0xcea9004c,0xb4be101c,0x7cfca68e,0x68ed040d}},	//   _לי_, _इसे_, _hérn, _coad,
   {{0xb8e80063,0x68ed1d3a,0x6285268f,0x6d59820d}},	//   _उस_, _doad, kaho, _iiwa,
   {{0x6d46020f,0x6561a690,0x29022691,0x6d59a692}},	//   _shka, _kulh, shka_, _hiwa,
   {{0x65618073,0x6d59a693,0x6138a694,0x386b00f7}},	//   _julh, _kiwa, síli, éirí_,
   {{0x656180a9,0x6d4d2695,0x6b962696,0x6d598458}},	//   _mulh, gmaa, tryg, _jiwa,
   {{0x44260003,0x7cf5a697,0x6128080a,0xf1c9801c}},	// [15a0] ço_, _cári, rıld, _hạ_,
   {{0x60dba698,0x28ac0023,0x6d599110,0xa8570039}},	//   _anum, ट्रि, _liwa, _איפה_,
   {{0x753b826f,0x29002699,0x5ec880ab,0x61280457}},	//   kluz, _klia_, লামে, pıld,
   {{0x6d59a69a,0x6d4d0079,0x60c9816a,0x6d460198}},	//   _niwa, cmaa, _caem, _uhka,
   {{0xf1c9801c,0xe73a9505,0x6285269b,0x087700be}},	//   _lạ_, пед_, baho, גענט_,
   {{0x8f9b00be,0xe5c6a13d,0x6d5984b9,0xe8020d86}},	//   פיצי, есио, _aiwa, रैया_,
   {{0xe3c88104,0xaa430adb,0x2bd28f12,0x6d5998a8}},	//   _sự_, _берл, तिभा, _biwa,
   {{0x2d9815a0,0x6d59a69c,0x60c9808e,0xed5784ae}},	//   irre_, _ciwa, _gaem, ној_,
   {{0x53c904e5,0xd90d8416,0x6b898073,0xe8b5817b}},	//   रिएश, _بین_, gseg, lışı,
   {{0x68ed002a,0xf1c980ff,0x291203f7,0x23d283ca}},	//   _soad, _bạ_, _amya_, तिबद,
   {{0xf8dd10be,0xe8b588c5,0x7d040234,0x13170039}},	//   यालय, nışı, khis, תחיל_,
   {{0xe3c88104,0x78a2827f,0x7d04269d,0x6b89a69e}},	//   _tự_, ngov, jhis, bseg,
   {{0x66f48076,0x04578013,0x7d04269f,0x628526a0}},	//   _अवाक_, _كلمة_, dhis, yaho,
   {{0x3ea50019,0x44391c59,0x6d599f62,0x1ee7003d}},	//   ült_, _rys_, _ziwa, روزی_,
   {{0x7bc600f1,0x6d4d26a1,0x645d0122,0x29000144}},	//   _asku, tmaa, _pgsi, _flia_,
   {{0x7d0426a2,0xf98f9c12,0x23b79094,0x9a3b8039}},	//   ghis, _ابو_, _अहमद, _מתוק,
   {{0x6d4d26a3,0x61361ddd,0x60c9808e,0x54550323}},	// [15b0] rmaa, rált, _raem, тват,
   {{0x2d8ca6a4,0x6d4d26a5,0x7cf58073,0x60c9a6a6}},	//   _ovde_, smaa, _vári, _saem,
   {{0x7bc600ad,0x3949059c,0x4439079f,0x7d0426a7}},	//   _esku, _khas_, _wys_, bhis,
   {{0x7d0426a8,0x628526a9,0x4439009a,0x38c98019}},	//   chis, saho, _tys_, بائی_,
   {{0x6d5987ba,0x6561a6aa,0x2d8c826c,0x7cfc80e7}},	//   _riwa, _sulh, _avde_, _aéro,
   {{0x63ad04a7,0x6d59a6ab,0xa3c006b7,0x7cfc810c}},	//   mtan, _siwa, ूटर_, _béro,
   {{0x50b111bc,0x60c9a6ac,0x6916016b,0x656180ee}},	//   जभाष, _taem, dšen, _qulh,
   {{0x925826ad,0x7cfca6ae,0x69c726af,0x6b89a6b0}},	//   _част_, _déro, _isje, tseg,
   {{0x6d598010,0x3f8b009a,0x2d8c82d0,0xd46881a8}},	//   _viwa, jscu_, _evde_, رحيم_,
   {{0x466ba6b1,0xdb0081fa,0x6d59a6b2,0xa3d2090f}},	//   _храм_, ttmá, _wiwa, वित_,
   {{0x6b89a6b3,0x290026b4,0x63ad26b5,0x394926b6}},	//   sseg, _plia_, htan, _bhas_,
   {{0x69d51024,0xdb00826f,0x394926b7,0xdddc0088}},	//   _mrze, rtmá, _chas_, jarš,
   {{0x63ad26b8,0xaca301bc,0xc95280be,0x7529017f}},	//   jtan, _chọb, ימט_, čezl,
   {{0x69c7030b,0x78a2803a,0x2cbfa6b9,0x69d50035}},	//   _osje, zgov, leud_, _orze,
   {{0x7d0426a7,0x2d8c26ba,0x386da6bb,0x28aa06ab}},	//   this, éde_, _ofer_, _कापि,
   {{0x2cbf831d,0x6283976f,0x7aee023e,0xbddc0032}},	//   neud_, _heno, _sobt, _aṣòf,
   {{0x63ad26bc,0xa3d2024c,0x628389c4,0x7aee022c}},	// [15c0] gtan, विध_, _keno, _pobt,
   {{0x7d0426bd,0x13032063,0x6283a6be,0x386da6bf}},	//   shis, азум, _jeno, _afer_,
   {{0x62839a59,0x7d0426c0,0x63ad26c1,0x7cf808f1}},	//   _meno, phis, atan, _líri,
   {{0x63ad26c2,0xe8b5817b,0x69d50035,0x6f0190ba}},	//   btan, rışı, _drze, _allc,
   {{0x10a39593,0x7bc626c3,0x98a38a0e,0x69d526c4}},	//   ричн, _usku, риче, _erze,
   {{0x6283a6c5,0xa3d58c87,0x47338221,0x7cfca6c6}},	//   _neno, हिन_, аніс, _péro,
   {{0x91e3249a,0x78b6026f,0xe29700a9,0x27e0802e}},	//   _коре, _obyv, _јас_, ţin_,
   {{0x7cfca538,0x80ca8bb8,0x3f4f0197,0xaae001d0}},	//   _véro, _सोचे, _jżur_, नावक,
   {{0x62838c77,0xfd0f8077,0x9eaa80a9,0xf8bf00e7}},	//   _beno, تجو_, _оваа_, nnée_,
   {{0x80a50006,0x386026c7,0x7cf801a8,0xe6c581a8}},	//   _काहे, _agir_, _díri, _متمي,
   {{0x69240052,0x26dea6c8,0xe8169094,0x63ad0102}},	//   rđen, _into_, _देता_, ztan,
   {{0x63ad127a,0xd90f026a,0x2906a6c9,0x26cca6ca}},	//   ytan, تیب_, nhoa_, _hado_,
   {{0x26cca6cb,0x691626cc,0x7d02a6cd,0xd83801e5}},	//   _kado_, pšen, _ilos, вэр_,
   {{0x6283a6ce,0xd7f8176e,0xb8fa26cf,0x8c438991}},	//   _geno, тую_, _डो_, _тече,
   {{0x6288a6d0,0x26cca6d1,0xdddc026f,0x8233815b}},	//   mado, _mado_, tarš, _پروا,
   {{0x26cc8510,0x692426d2,0xd498237e,0xf8bf0118}},	//   _lado_, nđel, кру_, roés_,
   {{0x291926d3,0x63ad26d4,0x63a089ca,0xf8bf00e7}},	// [15d0] misa_, utan, numn, gnée_,
   {{0x69d50610,0x6288a6d5,0x291926d6,0x63ad26d7}},	//   _prze, nado, lisa_, rtan,
   {{0x7d02a6d8,0xc8aa0076,0x7cf5a6d9,0xf8aa0105}},	//   _olos, _कामट, _záru, _कामय,
   {{0x29190418,0x63ad26da,0x63a0a6db,0x60cd26dc}},	//   nisa_, ptan, kumn, _jaam,
   {{0x60cd26dd,0xb8cb91bc,0x26cc822e,0x7cf596a5}},	//   _maam, _खा_, _bado_, _márt,
   {{0x6288a6de,0x69d50063,0xa3d69a3b,0x248926df}},	//   jado, _trze, ाटन_, laam_,
   {{0x26cc90dd,0x291926e0,0x7cf826e1,0x69c705f3}},	//   _dado_, kisa_, _síri, _usje,
   {{0x23ab813c,0x7d028051,0x2906a6e2,0x248903b2}},	//   tøj_, _clos, choa_, naam_,
   {{0x6b8d0003,0x6283a08d,0x291926e3,0x7cfca6e4}},	//   nsag, _peno, disa_, _kérj,
   {{0x6d5d0665,0x61280059,0x26cca6e5,0xa3ab00c2}},	//   _lisa, dıla, _gado_, _गमन_,
   {{0x60cd26e6,0x628380e1,0x29192486,0x0596804e}},	//   _baam, _veno, fisa_, _مانگ,
   {{0x6d5d0668,0x7cf580f7,0x29190365,0xc19a03de}},	//   _nisa, _cárt, gisa_, עשרי,
   {{0x3ce08076,0x776404c3,0xb4db0046,0xe8f72462}},	//   कारे_, _quix, _ghài, уля_,
   {{0x6288a6e7,0xe5a60d9e,0x6d5d0091,0x7d02805c}},	//   cado, лиги, _aisa, _zlos,
   {{0x6d5d1341,0x291911b7,0x60cd26e8,0x78a980d2}},	//   _bisa, bisa_, _faam, _ocev,
   {{0x29191092,0x6d5d26e9,0x6565010c,0x6f188bcf}},	//   cisa_, _cisa, _duhh, zivc,
   {{0x612805c5,0x03261957,0x6d5d19ad,0x93aa045b}},	// [15e0] cıla, гдан, _disa, عارف_,
   {{0xf8bf02be,0x78a98333,0x656526ea,0x3cda86a7}},	//   rnée_, _acev, _fuhh, _खोने_,
   {{0x6d5d26eb,0x2d950249,0x60cd019e,0xaaa6864a}},	//   _fisa, _кряс, _yaam, _खासक,
   {{0x613d0acf,0x6d5d26ec,0xbfaa8284,0x7cfc8118}},	//   téli, _gisa, етке_, _pérm,
   {{0x6f188052,0x6288a6ed,0xb4c026ee,0x752426ef}},	//   tivc, yado, ंजी_, mniz,
   {{0xa3c101fe,0x6288a6f0,0x29190c6a,0x918607c3}},	//   ंबर_, xado, zisa_, _مجرم,
   {{0xe1e7a6f1,0x612802bb,0x7d03002e,0x6d4b826c}},	//   _اس_, zıla, _însc, _bhga,
   {{0x7cfc9fd1,0x6288a6f2,0x80d408fd,0xb88704c3}},	//   _térm, wado, _बोले, _muíñ,
   {{0x62888510,0x2904883f,0x60cd09f8,0x2919155f}},	//   tado, _ilma_, _raam, visa_,
   {{0x248900f3,0xc87987c0,0x443d8428,0x291926f3}},	//   zaam_, _inşa_, _dyw_, wisa_,
   {{0x63a0811f,0x291926f4,0x69160110,0x2258a6f5}},	//   sumn, tisa_, pšel, ärk_,
   {{0x612803bf,0x6b8d26f6,0x6b9ba6f7,0x60cd057b}},	//   tıla, ysag, brug, _qaam,
   {{0x628883f8,0x291926f8,0x60cd26f9,0x68fd26fa}},	//   pado, risa_, _vaam, rksd,
   {{0x61280182,0x6d5d0744,0x29190234,0x60cd26fb}},	//   rıla, _sisa, sisa_, _waam,
   {{0x60cd26fc,0xbcfb00e7,0xb887002a,0x69da26fd}},	//   _taam, _liée, _cuíñ, _šten,
   {{0x612807d9,0x69ca81b9,0x2fc901c0,0x6b8d26fe}},	//   pıla, _isfe, _tsag_, tsag,
   {{0x6d5d26ff,0x5b152700,0x6d4083ff,0x28aa2701}},	// [15f0] _visa, амат, ilma, _काति,
   {{0x6d5d0854,0xa3d58519,0x2bb78105,0x6b8d2702}},	//   _wisa, हित_, _अहसा, rsag,
   {{0x6b8d114e,0x6d5d2703,0x26c32704,0x06cd80ab}},	//   ssag, _tisa, mejo_, লামি,
   {{0x26c32705,0x60c28358,0xc91380ab,0xe8168c28}},	//   lejo_, geom, িক্ত_, _देहा_,
   {{0xdb042706,0xa2d0016f,0xafe5a707,0x21290299}},	//   stiá, _डोक्, ролл, _mjah_,
   {{0x26c32708,0xa3d206b7,0x26d1026c,0x6b4b02af}},	//   nejo_, विर_, ndzo_, füge,
   {{0x6ead000d,0xba740065,0x5a440a8e,0x6b828242}},	//   _जानु, _چاہت, _гэта, _awog,
   {{0x2d67811f,0x6b9ba709,0x2d9e1f3a,0x62950140}},	//   _uđem_, trug, šteg_, _hdzo,
   {{0x69d8a70a,0xf7708077,0x6287270b,0x28d91c7b}},	//   _arve, _فال_, _kejo, _बोधि,
   {{0x26c30db7,0x6b9ba70c,0x21290b99,0x98148a47}},	//   jejo_, rrug, _ajah_, _طبقا,
   {{0x6287270d,0x69d8803b,0x394d8282,0x26c3270e}},	//   _mejo, _crve, _khes_, dejo_,
   {{0x69d8803b,0x6b9b803a,0x69de81ac,0x6287270f}},	//   _drve, prug, _špec, _lejo,
   {{0x95548bca,0x21290267,0x290c0110,0x3cff81c0}},	//   _اخلا, _djah_, ėda_, mkuv_,
   {{0x7cf58065,0xe2999577,0x3ced9de3,0x6287001b}},	//   _társ, _рак_, ljev_, _nejo,
   {{0x2d988cd7,0x2cb90706,0x2d5182d4,0x21a58037}},	//   _året_, _bbsd_, _ušes_, _тийм,
   {{0x25ed8df4,0x88830081,0x94262710,0x7d09a711}},	//   _अपनी_, _длъж, амбе, nhes,
   {{0xf77207bd,0xed572712,0x26c32713,0x03a62714}},	// [1600] _باب_, рот_, bejo_, ризо,
   {{0x7d1ba715,0x7cf58511,0x752400b9,0x31679500}},	//   hius, _márq, sniz, _kunz_,
   {{0x7d1ba716,0x395f8359,0xa2a700c2,0x41aa0ae7}},	//   kius, _bius_, _चार्, твен_,
   {{0x613d2717,0x53a6217e,0x3cff81c0,0x6f1c0037}},	//   bélu, _камб, jkuv_, lirc,
   {{0x7d09a718,0x3ced85f3,0x395f823e,0x67d49f6e}},	//   dhes, djev_, _dius_, солу,
   {{0x98ab009a,0x62872719,0x63a4271a,0x7cfc8019}},	//   mocą_, _gejo, muin, _térk,
   {{0x63a4271b,0x7d1b8118,0xb23a00f7,0x4420802e}},	//   luin, fius, _شكرا_, _ţi_,
   {{0x6b828247,0x92a6009a,0x7d1b847f,0x395f8037}},	//   _pwog, _wyłą, gius, _gius_,
   {{0x6f1c271c,0x7cf5988b,0xdcef011f,0x6d40808b}},	//   kirc, _párr, žeće, rlma,
   {{0x7cfca71d,0x2d9c81d0,0x6f1c09ab,0x2fc99a1f}},	//   _méri, prve_, jirc, çage_,
   {{0x63a41581,0x7d1ba71e,0x3ced826c,0xf2d900be}},	//   huin, bius, bjev_, אַרל,
   {{0x7d09a71f,0x7d1ba720,0x63a42721,0xb4c503db}},	//   ches, cius, kuin, _एसे_,
   {{0x315780be,0x8c43a30e,0x7cf58144,0x6568a722}},	//   ייטן_, _деце, _tárr, _hudh,
   {{0x63a42723,0x65688303,0x31678037,0x46de2724}},	//   duin, _kudh, _funz_, मागह,
   {{0x26d10063,0x62872725,0x26c32726,0x518693bf}},	//   rdzo_, _rejo, rejo_, _тула,
   {{0x26c32727,0x6568a728,0x3f8f8114,0x7cfc9a90}},	//   sejo_, _mudh, ysgu_, _béri,
   {{0x63a4107f,0x2d5802c7,0x26c32729,0x62870088}},	// [1610] guin, рить_, pejo_, _pejo,
   {{0x883c0039,0x6e2d8214,0x67389351,0x7cfc80e7}},	//   _בתחו, şabi, jovj, _déri,
   {{0x75d50199,0xb4db051e,0x6738a72a,0x656888f9}},	//   _ايجا, _bhàt, dovj, _nudh,
   {{0x7cfca72b,0xa3d6873c,0xb12580ab,0xb4db0362}},	//   _féri, ाटा_, বত্ব_, _chàt,
   {{0x63a40087,0x395f823e,0xb0aa0035,0x3cff822c}},	//   cuin, _vius_, _कासग, vkuv_,
   {{0x6568a72c,0x67388639,0x16a9a349,0xa3d581ab}},	//   _budh, govj, увки_, हिस_,
   {{0x394da72d,0xa194272e,0xdcfb1a3b,0x21390168}},	//   _thes_, _марч, _एकाध_, kosh_,
   {{0x2ca9272f,0x28cf9513,0xd5d82730,0x51840cc1}},	//   ngad_, _सोचि, डितज, _фура,
   {{0x291d80f6,0x3ced8db7,0x7d1ba731,0x7d09a732}},	//   miwa_, rjev_, rius, rhes,
   {{0x291d80f6,0xddde0f20,0xfe708b76,0x7305943d}},	//   liwa_, _lepš, _قدم_, споз,
   {{0xdb0403a7,0x7d09a733,0x657701e9,0x6568a734}},	//   stiç, phes, _ntxh, _gudh,
   {{0x291d804f,0x213912ec,0x05090264,0x14ca9ab3}},	//   niwa_, gosh_, রচুর_, _مهمی_,
   {{0xeb99a306,0xdb0b806a,0xc50c80be,0x9fd60264}},	//   _сил_, _opgø, _בלאָ, সঙ্গ,
   {{0xa3c10935,0x65689d08,0x291da735,0x644ba736}},	//   ंबई_, _yudh, hiwa_, _izgi,
   {{0x7ae3a737,0x291d80f6,0x7cfca738,0x6b5004b8}},	//   _innt, kiwa_, _séri, lägg,
   {{0xb466044f,0x7cfca739,0x2ca9016d,0x291d8010}},	//   скал, _péri, ggad_, jiwa_,
   {{0x09b201fe,0x612805c5,0x68e41dde,0x291d8010}},	// [1620] ीब्य, nılm, _inid, diwa_,
   {{0x63a4125b,0x7cfc82be,0xb4db0229,0x2ca902c4}},	//   ruin, _véri, _bhàs, agad_,
   {{0x63a4273a,0x28dd016f,0x8db600e8,0x291d804f}},	//   suin, याचि, _успі, fiwa_,
   {{0x98a68cdf,0x612802d0,0x291da73b,0xb4db0a2a}},	//   сиде, kılm, giwa_, _dhàs,
   {{0x6568a73c,0x29020009,0x31b18019,0xc7a38992}},	//   _sudh, ikka_, ház_, зичк,
   {{0x61280085,0x6d44273d,0x4dbe80ab,0xa3bd00c2}},	//   dılm, llia, ্মসূ, _आहत_,
   {{0x38698052,0x6d44031d,0x6738a73e,0x291da73f}},	//   žara_, olia, rovj, biwa_,
   {{0x539894ed,0xbb748992,0x69ce01b4,0x7ae3851e}},	//   авия_, огиј, _isbe, _annt,
   {{0x2d8502ba,0x673882ce,0x656890e1,0x442f83a8}},	//   ález_, povj, _wudh, _cxg_,
   {{0x6d442362,0x78ad2740,0x68e42741,0x37be0264}},	//   hlia, _scav, _anid, ইটার,
   {{0xe3af9fbe,0xdd928077,0x6d440110,0x81b600ab}},	//   وری_, _روش_, klia, জিক_,
   {{0xd84304e8,0x00000000,0x00000000,0x00000000}},	//   _ničí_, --, --, --,
   {{0x2d910063,0xb0aa000f,0x28aa097d,0x6d440114}},	//   wsze_, _कारग, _कारि, dlia,
   {{0x291da742,0xa3d5a743,0x69dc2744,0x98be00eb}},	//   ziwa_, हिर_, _orre, ētā_,
   {{0x7af50e04,0x8cda016f,0x291da745,0x2d852746}},	//   _rozt, _पोहो, yiwa_, èle_,
   {{0x6d440698,0x2d912422,0x65628326,0x183a01bc}},	//   glia, rsze_, _jioh, ọmụm,
   {{0x290902a3,0x69dc2747,0x36d52748,0x7af50cc7}},	// [1630] _ilaa_, _arre, _допр, _pozt,
   {{0x32672134,0x2d91009a,0xaa672749,0x6d44274a}},	//   став, psze_, стак, alia,
   {{0x291d8010,0x612803bf,0x7d030162,0xdb098174}},	//   tiwa_, zılm, _înso, nteá,
   {{0xdb0980f7,0x6128080a,0x628a8061,0x6ca7274b}},	//   iteá, yılm, _lefo, _урож,
   {{0x69dc274c,0x629898a6,0x291da74d,0xcf9b84ae}},	//   _erre, _odvo, riwa_, ује_,
   {{0x7d0d0065,0x291da74e,0xab5b0019,0xe81c0074}},	//   lhas, siwa_, _csüt, _पइसा_,
   {{0x24e98698,0xace9a74f,0xceb404de,0x28aa0ebf}},	//   имки_, имка_, פיק_, _कालि,
   {{0x28d90b75,0x61280457,0x2fcd81e9,0x6abc01a1}},	//   _बोलि, tılm, _tseg_, _zbrf,
   {{0x628a9c93,0x68e42750,0xa49b0176,0x130985a5}},	//   _befo, _rnid, _alòk, иний_,
   {{0x61280182,0x69060118,0x4225a42e,0x68f60850}},	//   rılm, _cóen, ждов, _soyd,
   {{0x90c60364,0x7d0d2751,0x60c600eb,0x6d440114}},	//   обне, khas, tekm, ylia,
   {{0xf9920051,0x7bcf2752,0x612813da,0x69da2753}},	//   ורט_, _oscu, pılm, _štek,
   {{0x3c47803f,0x7529802e,0x6b500884,0x7d0d2754}},	//   _اضاف, mnez, läge, dhas,
   {{0x2bcf901c,0x26c78010,0xa3d689f2,0x628a8dfb}},	//   _तैया, neno_, ाटर_, _gefo,
   {{0x6281a755,0x7bcf002e,0x9663120c,0x2ee580b9}},	//   mblo, _ascu, дкре, _mnlf_,
   {{0x68e40510,0xd46715d1,0x7d0d2756,0x6281a757}},	//   _unid, жите_, ghas, lblo,
   {{0x2ee58079,0x8c430e8e,0x24802758,0xdb00804a}},	// [1640] _onlf_, дете, rbim_, ttmø,
   {{0x681c0029,0xc8aa0327,0xb0aa18a9,0xe29a23d7}},	//   rādī, _काँट, _काँग, раж_,
   {{0x673c2759,0x506682df,0x7d0d275a,0x26c78ef1}},	//   morj, отла, bhas, deno_,
   {{0x7d0d0870,0xdb0400f7,0x31ba80be,0x7cfc9ab3}},	//   chas, ntiú, יזענ, _yéru,
   {{0xa3ce09a3,0x765f8201,0x1eca81a1,0x7529a75b}},	//   _शनि_, əyyə, илди_, dnez,
   {{0x7d040009,0x26c780e5,0xdd9a97c8,0xa49b026b}},	//   lkis, geno_, аши_, _alòh,
   {{0xb0aa275c,0x69dc275d,0xd9a8800f,0x4c94a3e7}},	//   _कांग, _urre, _कमेट, пийс,
   {{0x61e10065,0x3ea0a75e,0x7d04275f,0x394001c0}},	//   _álla, şit_, nkis, _nkis_,
   {{0xd0078ae7,0x63b62760,0x2f0b806a,0x3946a761}},	//   _дете_, ntyn, _søge_, mlos_,
   {{0x3946840e,0x26c78828,0x2909004f,0x39400084}},	//   llos_, ceno_, _slaa_, _akis_,
   {{0xd48fa762,0x26d32763,0x7d042764,0xdb040216}},	//   _ор_, _raxo_, kkis, guié,
   {{0x394682af,0x26d32765,0x88b10180,0x657a8061}},	//   nlos_, _saxo_, ریخچ, _itth,
   {{0xc86400e8,0xdb0981a8,0xab2a86f9,0x6281a766}},	//   дтри, steá, _кода_, bblo,
   {{0x3ce681c5,0x6298812b,0x39401400,0x7c2da767}},	//   _hnov_, _udvo, _ekis_, _žarg,
   {{0x7d0d2768,0xf27b8051,0x394681e2,0x7cfc8c52}},	//   thas, _דרוש, klos_, _fért,
   {{0xdb0400f7,0x26c79620,0x394681c0,0x80a52769}},	//   ctiú, zeno_, jlos_, _काटे,
   {{0x7d0d276a,0x6b4f806a,0x394689ed,0xdb0d00f7}},	// [1650] rhas, søge, dlos_, staí,
   {{0x7d0d276b,0x657a8019,0x26c783a8,0x39468020}},	//   shas, _otth, xeno_, elos_,
   {{0xceb20451,0x69240d11,0x69160353,0x7d0401de}},	//   _איי_, rđev, ršev, bkis,
   {{0x6b50016d,0x3946a76c,0x7d04276d,0x55da00be}},	//   väge, glos_, ckis, _פֿינ,
   {{0x657a8748,0x26c7a76e,0x60dc00be,0x66e580ae}},	//   _atth, teno_, יקאנ, зола,
   {{0x6281813c,0x644f01a9,0x39468118,0xf8bf01d0}},	//   xblo, _izci, alos_, dném_,
   {{0x26c7812b,0x80ac035a,0x39468ae5,0x7bc2a76f}},	//   reno_, _झाले, blos_, _apou,
   {{0x39468c52,0x61360065,0x673c007a,0x6b5001ec}},	//   clos_, bály, zorj, räge,
   {{0x76450009,0x6281a770,0x39520428,0x26c7a771}},	//   _lyhy, tblo, _rhys_, peno_,
   {{0x386913b8,0x13098d15,0x753b928a,0x7cfca772}},	//   _agar_, сной_, souz, _sért,
   {{0x753b811f,0x7d040082,0x7bc2a1bf,0x673c007a}},	//   pouz, ykis, _epou, vorj,
   {{0x2fdf805c,0x69d083eb,0x63b60198,0xbcfb0216}},	//   _krug_, धिजी, ytyn, _sién,
   {{0x673c2773,0xb4d7864a,0x4aac0072,0x69da81c0}},	//   torj, ायी_, _चालव, avte,
   {{0x4e1f85e8,0x3f9e026f,0x7bda8039,0x657a8388}},	//   _बधाई_, čtu_, _לקנו, _ytth,
   {{0x386d0301,0x7d042774,0xdb040036,0x649a0071}},	//   žera_, tkis, quié, йтар_,
   {{0x2571807b,0x63b60009,0x673c2775,0x61fc8338}},	//   _mál_, ttyn, sorj, ärle,
   {{0xf42a01ac,0x2fdf8282,0x7d042776,0xfbdf02df}},	// [1660] _opäť_, _nrug_, rkis, _crê_,
   {{0x7d042777,0x27e02778,0xa3dc853f,0x60d62779}},	//   skis, _irin_, डित_, _haym,
   {{0x63b6277a,0x9d4624c8,0x60d6277b,0x2c75019d}},	//   styn, _неод, _kaym, _ụde_,
   {{0x2fdf8022,0x63a9a77c,0x63b6277d,0x7ae70168}},	//   _brug_, kuen, ptyn, _enjt,
   {{0x3946a77e,0xe81683a4,0x09a8800c,0x2efa01ec}},	//   rlos_, _देखा_, _कम्य, _kopf_,
   {{0x69c38fb0,0x26ca277f,0xf67a00be,0x290b00eb}},	//   _opne, nebo_, זאַמ, ībai_,
   {{0x629c2780,0x7bc2a781,0x25718118,0x3946a782}},	//   _idro, _spou, _cál_, plos_,
   {{0x27e0077f,0x399b0039,0x2571801b,0x63a995a0}},	//   _orin_, _לילד, _dál_, fuen,
   {{0x63a42783,0x63a9a784,0x628e0587,0x7cfc8125}},	//   nrin, guen, _kebo, _sérs,
   {{0xa3ab8063,0x63a42785,0x628e2786,0x877b83c8}},	//   गढ़_, irin, _jebo, _לאמי,
   {{0x63a42787,0x6446007b,0x26ca026b,0x27e02788}},	//   hrin, _lyki, debo_, _arin_,
   {{0x63a9a789,0x29068bf0,0x27e0278a,0x60d6278b}},	//   buen, nkoa_, _brin_, _caym,
   {{0xd83b01e5,0x63a9960a,0x5f940098,0x7cfc8207}},	//   сэн_, cuen, ният, _férr,
   {{0x628e14f0,0x27e0278c,0xa3e00327,0xf8bf0036}},	//   _nebo, _drin_, थिन_, diée_,
   {{0x27e0278d,0x2d9e003a,0x29068009,0x16042076}},	//   _erin_, šten_, kkoa_, रनगर_,
   {{0xca478013,0x63a4278e,0x629c031d,0xf8bf00e7}},	//   _عليه_, frin, _adro, fiée_,
   {{0x63a4278f,0xa3d58063,0x24580009,0x628e2790}},	// [1670] grin, हिए_, зать_, _bebo,
   {{0x26ca2791,0x628e1e00,0x629c01e0,0x6d428326}},	//   cebo_, _cebo, _cdro, _lkoa,
   {{0x32072792,0x65662793,0x644600b9,0x163502a9}},	//   ány_, _fikh, _eyki, _ценя,
   {{0x25e0858c,0x6ebf800d,0xf42a01ac,0x5fb103db}},	//   किनी_, ल्नु, _späť_, _जमाल,
   {{0xf8bf0036,0x2571a794,0x61360118,0x32071517}},	//   ciée_, _sál_, rálx, šny_,
   {{0x628e105d,0x290fa795,0x6d42826b,0x670d03eb}},	//   _gebo, shga_, _akoa, हसिक_,
   {{0x69da0db7,0x30a7a796,0x20020035,0x60dd8144}},	//   _štev, _нрав, zyki_, _ósmo,
   {{0x58d49697,0x629c09a4,0x63a98102,0x26d80690}},	//   _пост, _zdro, tuen, zdro_,
   {{0x2be00f97,0x2fdf808e,0x68e9a797,0x19588196}},	//   निया, _urug_, _ined, _хаты_,
   {{0x68fb82d8,0x63a9a798,0x7c26807b,0x68e980e1}},	//   _houd, ruen, úkra, _hned,
   {{0x68fba799,0x80d700ab,0x2bdb820e,0x60d6279a}},	//   _koud, ধান্, बिहा, _paym,
   {{0x27e00c6e,0x26c10267,0x2002009a,0x63a4279b}},	//   _prin_, _abho_, tyki_, yrin,
   {{0x21221083,0x63a9a79c,0x6d5b836e,0xeb8e8934}},	//   rikh_, quen, mmua, _ши_,
   {{0x6d49a79d,0x672394e4,0x2906811e,0x6566005d}},	//   llea, ninj, zkoa_, _sikh,
   {{0xdd1c026f,0x63a4279e,0x644f817f,0xed168019}},	//   _vážn, wrin, škić, _رہیں_,
   {{0x628e279f,0x27e027a0,0x6d4990a2,0x752d27a1}},	//   _sebo, _trin_, nlea, gnaz,
   {{0x6d49a7a2,0xab66096b,0x59d584c5,0xc9530039}},	// [1680] ilea, двал, धिकर, _במה_,
   {{0x290da7a3,0x63a427a4,0x03a301a1,0xf8bf0036}},	//   _alea_, rrin, тифо, riée_,
   {{0x68fba1bf,0x63a427a5,0x68e9822b,0xd46a06a1}},	//   _boud, srin, _bned, _мине_,
   {{0x6d5b822c,0x628e03fb,0xc7c68af2,0x8fa69182}},	//   jmua, _webo, дски, даде,
   {{0x628e27a6,0x68fba7a7,0x29068bf0,0x4c3601e2}},	//   _tebo, _doud, rkoa_, _цэнт,
   {{0xf8bf0019,0x291f80b9,0x2906811b,0x68e9a7a8}},	//   tnék_, _emua_, skoa_, _ened,
   {{0x626327a9,0x68fb8866,0x7afc02f9,0xdd1d136f}},	//   _авра, _foud, _iort, lášs,
   {{0x25a0a7aa,0x7afc27ab,0x68fba7ac,0xe81f84e5}},	//   čil_, _hort, _goud, _मेवा_,
   {{0x6723a7ad,0x6843a7ae,0x644e8035,0xaf2aa7af}},	//   binj, _анта, ębio, _джаз_,
   {{0x67238052,0x68fb8a0f,0xadba80f7,0xe45703de}},	//   cinj, _zoud, _وهذا_, ויפט_,
   {{0x6d49a7b0,0xf2d30039,0x36068199,0xbcfb010c}},	//   blea, דעת_, _تواف, _diéj,
   {{0x7afc011e,0xcb6a8323,0xb4db0032,0xf78702df}},	//   _lort, _даде_, _akàn, íços_,
   {{0xac978077,0x6d4082d6,0x7afc01b0,0x2d9e27b1}},	//   _آنها_, moma, _oort, štel_,
   {{0x6d409619,0x7afc160c,0xdce280c3,0x75e401bc}},	//   loma, _nort, _mioč, _ọzay,
   {{0xa3d689a3,0xdb0081ca,0x7bc601a9,0x6455866f}},	//   ाटक_, cumá, _apku, ęzie,
   {{0x6d40a7b2,0x50670abe,0x6b500106,0x66f802d0}},	//   noma, _отпа, väga, _aşkı,
   {{0x752d27b3,0xdb0d0073,0x7afc0687,0x3b550012}},	// [1690] rnaz, ntaç, _bort, екар,
   {{0x6d40a7b4,0x68fba7b5,0x291f8890,0xdb0d0187}},	//   homa, _soud, _smua_, itaç,
   {{0x6d40a7b6,0x68fba7b7,0x7afc27b8,0xda0e80a5}},	//   koma, _poud, _dort, ानित_,
   {{0x2d8301ed,0xa49b0362,0xe7f3866f,0x3835a7b9}},	//   mpje_, _clòt, _आपदा_, ннер,
   {{0x67238025,0x69da003b,0x68fb80e7,0x2575016d}},	//   tinj, _štet, _voud, _hål_,
   {{0x63ad27ba,0x7afc27bb,0xe7338bbe,0x68fb9412}},	//   muan, _gort, خصص_, _woud,
   {{0x67238db7,0x63ad14ff,0xe81fa7bc,0x6d40a7bd}},	//   rinj, luan, _मेरा_, foma,
   {{0x25750082,0x6723a7be,0xdfd597ae,0x67d5a57e}},	//   _mål_, sinj, _побы, _побу,
   {{0x6d49a7bf,0x6d5ba7c0,0x77688118,0x386da7c1}},	//   rlea, rmua, _fidx, _iger_,
   {{0xa3e0090f,0x6d49a7c2,0xcb1200be,0x7afc16bb}},	//   थित_, slea, ָלט_, _xort,
   {{0x6d498e6f,0x7648a7c3,0x7d0f0019,0x6d40a7c4}},	//   plea, _gydy, _olcs, boma,
   {{0x6d40a7c5,0xdb0980a9,0xe8f7176e,0x75d38201}},	//   coma, nteú, елю_, _nəzə,
   {{0xa3d58076,0x316927c6,0xfaa5a3d7,0x7d098c9a}},	//   हिओ_, _diaz_, _зало, mkes,
   {{0x63ad0057,0x2d9e005c,0x7d099323,0x69c705f3}},	//   duan, štem_, lkes, _opje,
   {{0x63bba7c7,0x2f1400f2,0x2d8c27c8,0xed5a0d0e}},	//   ltun, _lägg_, ède_, зов_,
   {{0x7afc27c9,0xc5f280be,0x69a48072,0x1da78035}},	//   _sort, נדן_, _किती, _गिनत,
   {{0x63bb885c,0x63ad27ca,0xfd648a2c,0x03a327cb}},	// [16a0] ntun, guan, _akwụ, лито,
   {{0x28c10054,0x7afc27cc,0x63bb8759,0x06860110}},	//   ष्ठि, _qort, itun, _ягон,
   {{0x63bba7cd,0x7afc11e6,0x6d40a7ce,0x7d09a7cf}},	//   htun, _vort, yoma, kkes,
   {{0x26da022e,0x7648831d,0x7afc27d0,0x61fca7d1}},	//   _hapo_, _rydy, _wort, ørli,
   {{0xe7e327d2,0x6d4613ed,0x63ad0144,0x7afc27d3}},	//   खिया_, _ikka, cuan, _tort,
   {{0x6b8427d4,0x6d40a7d5,0x386da7d6,0x2d8c80e4}},	//   mpig, woma, _eger_, _pwde_,
   {{0x60c427d7,0x2d9a9be6,0xceb300be,0x63bba7d8}},	//   _obim, épe_, טיג_, etun,
   {{0x63bb90f6,0x75d38085,0xc5f30039,0xd9e386a7}},	//   ftun, _xəzə, רדה_, गिनत_,
   {{0x6d40a7d9,0x63bba7da,0xd4e38009,0xdb040036}},	//   roma, gtun, ующи, triè,
   {{0x2d6e800d,0x6b4f813c,0xdb0d27db,0x26da27dc}},	//   _před_, søgn, rtaç, _napo_,
   {{0x6d4627dd,0xdb0402be,0xdb0d03a7,0x95caa7de}},	//   _okka, rriè, staç, _хлеб_,
   {{0x6d40a7df,0x69b1809a,0xdb0d0187,0xdcdf03db}},	//   qoma, _अमरी, ptaç, _पोंछ,
   {{0xb8d90576,0xa3e4800d,0xa2c106af,0xdb040118}},	//   _चा_, _पछि_, र्ड्, ntió,
   {{0x5453835f,0x6d4627e0,0x26da27e1,0xd04089ab}},	//   _світ, _akka, _capo_, _hamɓ,
   {{0x0dc81506,0x95c8028b,0x394227e2,0x26da026b}},	//   нути_, нута_, boks_, _dapo_,
   {{0x290b0341,0x63ad27e3,0x2b5827e4,0x394200b9}},	//   ības_, tuan, _ahrc_, coks_,
   {{0x8aa70153,0x69c727e5,0xfaa704fa,0x6b84076d}},	// [16b0] еред, _spje, ешен, gpig,
   {{0x60dd0a64,0x2fc902e8,0x6d460365,0x25750106}},	//   ldsm, _ipag_, _ekka, _tål_,
   {{0xf99307bd,0x799aa7e6,0x63bb9124,0x67270267}},	//   ابط_, nstw, ztun, mijj,
   {{0x60dd23ea,0x21268358,0x2fc902d5,0x2d8127e7}},	//   ndsm, gioh_, _kpag_, _ithe_,
   {{0xb8c98b3b,0x63ad27e8,0x69d5009a,0x389c00be}},	//   _गए_, quan, _wsze, ליאנ,
   {{0x6d4d1e38,0x6da5867c,0x443901e0,0x6727026c}},	//   llaa, вика, _ixs_, nijj,
   {{0x53340425,0xa3b3816f,0x68ed27e9,0x7d09956e}},	//   _серт, जून_, _onad, tkes,
   {{0x63bba7ea,0x68ff02a3,0x386d813c,0x60dd006a}},	//   ttun, _noqd, _uger_, jdsm,
   {{0x63bb8009,0x7d09a7eb,0xd9d9801b,0xa2c11869}},	//   utun, rkes, बट्ट, र्थ्,
   {{0x613d0065,0x7d098100,0x63bb8367,0x68ed27ec}},	//   mély, skes, rtun, _anad,
   {{0x63bba7ed,0x6d4d27ee,0x3f80002e,0x2d81022c}},	//   stun, klaa, _stiu_, _nthe_,
   {{0x60db809f,0xdb2689a7,0x26da27ef,0x2d9e27f0}},	//   _jaum, _یونی, _sapo_, štek_,
   {{0x889a8039,0x26da24d4,0x2f14016d,0x60db804f}},	//   וברי, _papo_, _läge_, _maum,
   {{0x4ad78117,0x4ed51b69,0xdb0402be,0xfaa5a7f1}},	//   _ساتھ_, люст, prié, _рако,
   {{0xceb29a0f,0x63a9a7f2,0x656ba7f3,0xcb1281c6}},	//   יים_, lren, _kigh, _דלג_,
   {{0x6d4d27f4,0x26da004f,0x63a9a7f5,0x656b819d}},	//   glaa, _wapo_, oren, _jigh,
   {{0x26da0110,0x656b8039,0xb46601e5,0x2d8127f6}},	// [16c0] _tapo_, _migh, ткал, _ethe_,
   {{0x656ba7f7,0x613d0019,0x68ed05f3,0x6d4d27f8}},	//   _ligh, dély, _znad, alaa,
   {{0x2be00076,0x63a9a7f9,0x644b8110,0x60db9655}},	//   निहा, hren, _lygi, _baum,
   {{0x63a982a5,0xfbab1344,0x656ba7fa,0x290027fb}},	//   kren, _चमचम, _nigh, _joia_,
   {{0x7c2da7fc,0x68438a14,0xb4c00beb,0x087700be}},	//   _žarn, анца, ूजी_, דענט_,
   {{0xa3c1009a,0x3cda8592,0x656b832f,0x7f4381e0}},	//   ूबर_, _खोजे_, _aigh, gonq,
   {{0xdb04040e,0x63a9a7fd,0x28dd92c6,0x2be0170c}},	//   stió, eren, _नोकि, निवा,
   {{0x6d59a7fe,0x290027ff,0x60dba800,0x6d442801}},	//   _chwa, _noia_, _gaum, noia,
   {{0xa7668be1,0x63a9906f,0x656ba802,0x6b9b84a7}},	//   _акад, gren, _digh, gsug,
   {{0x6d5983ac,0x68ed001b,0xbcfb0118,0x29120c2e}},	//   _ehwa, _snad, _viéi, _alya_,
   {{0xdb0404c3,0x7c2d807b,0x63a9a803,0x6727026c}},	//   ntiñ, _þarn, aren, vijj,
   {{0x0c26a804,0xe8e00028,0x799a809a,0x94268009}},	//   _имен, _trời_, rstw, _имее,
   {{0x692b000d,0x6727026c,0x60dd0cd7,0x6d441b1f}},	//   třeb, tijj, rdsm, doia,
   {{0xf8bf06a5,0x656b81bc,0x68ed0326,0x2912038a}},	//   cién_, _zigh, _wnad, _elya_,
   {{0x7e280d13,0xdb00816d,0xf62800e8,0x6d4d2805}},	//   віта_, rumä, віти_, tlaa,
   {{0xe7f3816f,0x6727026c,0x69d8a806,0x68ed01f8}},	//   _आपला_, sijj, _isve, _unad,
   {{0x54552807,0xdc550003,0x6d4d2808,0x60dba809}},	// [16d0] уват, увањ, rlaa, _raum,
   {{0x6d4d0b3c,0xf1b6a769,0xe3b001a8,0x22950481}},	//   slaa, _अमान, ترف_, الاس,
   {{0x6d4d280a,0x26d1280b,0x60dba80c,0x63a99002}},	//   plaa, mezo_, _paum, zren,
   {{0x26d1280d,0xe0df280e,0x3015a80f,0x2600001b}},	//   lezo_, ndò_, лдер, रहरी_,
   {{0xe8d90104,0x656b8051,0xd91c0158,0x251a0039}},	//   _chỉ_, _righ, וואל, _נושא,
   {{0x69d893f6,0xb87b12ca,0x60db804f,0x26d12810}},	//   _osve, ndíb, _waum, nezo_,
   {{0x99678e9f,0x60dba811,0xdb040c52,0xf8bf00e7}},	//   _атал, _taum, quiá, nnés_,
   {{0x7d0d2812,0x26d12813,0x6b9ba814,0x39490282}},	//   nkas, hezo_, tsug, _nkas_,
   {{0x26d12813,0x0b45841c,0x63a9a815,0x69ca81ec}},	//   kezo_, лнин, uren, _apfe,
   {{0xe1f98364,0x63a9a816,0x656ba817,0x25788019}},	//   его_, rren, _wigh, _fél_,
   {{0x7d0d2818,0xa2ca06af,0xaca30032,0x26d10118}},	//   kkas, _सॉफ्, _akọb, dezo_,
   {{0x38698699,0x69a48beb,0x64558085,0x61f80589}},	//   žaru_, _किरी, əzin, ävli,
   {{0x03a58258,0x53a587b6,0x7d0d2819,0x69d88580}},	//   _сило, _салб, dkas, _esve,
   {{0x6295281a,0x26d12169,0x7529a81b,0xfd65027d}},	//   _nezo, gezo_, liez, _truồ,
   {{0xdca60cec,0x64a608d5,0xc0e6281c,0xdd1d01d0}},	//   лави, лава, _бойк, lářs,
   {{0x7d0d043b,0xa3e0281d,0x7e7c0216,0x7529a81e}},	//   gkas, थिल_, scrp, niez,
   {{0x0aea1bcc,0x6295281f,0x6eac009a,0x6d442820}},	// [16e0] ндай_, _bezo, _जयपु, roia,
   {{0x7d0d0009,0xb4631a1a,0xdb00a821,0x6d442822}},	//   akas, скул, stmö, soia,
   {{0x62952823,0xd24f00f7,0x88868098,0x9abc84b7}},	//   _dezo, كنك_, глеж, fiċj,
   {{0xdb0401df,0xc0968290,0x25aa804a,0x31bc0118}},	//   rtiñ, اجات, _åbli_, ríz_,
   {{0xa3d28610,0x316da824,0xdb042825,0x6ac900ab}},	//   _हैं_, _diez_, stiñ, রয়ো,
   {{0x62952826,0x6f01a827,0xaa4602a9,0xa85701c6}},	//   _gezo, _colc, _бегл, ניסה_,
   {{0x645d8125,0x6f018098,0xceb30039,0xe5c69821}},	//   ýsin, _dolc, ציה_, усло,
   {{0xd1328b76,0x386d2828,0x78a4004f,0x75298cdb}},	//   _امر_, žeri_, _ndiv, giez,
   {{0x28dd800f,0x5b14a503,0x6f01a829,0xdb040187}},	//   _नोटि, имит, _folc, guiç,
   {{0x3946a82a,0x78a4282b,0x2578a82c,0x9bbb00be}},	//   loos_, _adiv, _tél_, עציפ,
   {{0xaac623a7,0x80de00c8,0xd2508077,0x7d0d282d}},	//   र्यक, যান্, تند_, ykas,
   {{0xdb0403a7,0x3f84808e,0xaca301bc,0x26de8a03}},	//   buiç, _ktmu_, _kwụd, _hato_,
   {{0xe8d90104,0xa3b3823c,0x26dea82e,0xed579baa}},	//   _giờ_, जूद_, _kato_, _соц_,
   {{0x7d0282a3,0x8c1b8039,0x26de82df,0xaca3019d}},	//   _hoos, _אודי, _jato_, _mwụd,
   {{0x6295282f,0xc27b893f,0x7d0289f8,0x26d12830}},	//   _rezo, _ארוי, _koos, rezo_,
   {{0x99838307,0x629aa831,0xf1a9809a,0x26dea832}},	//   _اليو, lato, _कितन, _lato_,
   {{0x62950216,0x26d10333,0x24180fe6,0x3946a833}},	// [16f0] _pezo, pezo_, готы_, doos_,
   {{0x212b034a,0x27e92834,0x7d0d2835,0x830500ab}},	//   lich_, _iran_, skas, োচ্চ_,
   {{0xe8d900ff,0xa2c12836,0x8027881b,0xc1e8084b}},	//   _nhị_, र्ष्, گرام, льце_,
   {{0x629aa837,0x212b01e4,0x32641132,0x6f01a838}},	//   hato, nich_, стув, _solc,
   {{0x26dea839,0x4ac48651,0xe8d901bc,0x35ab06a7}},	//   _bato_, वभाव, _ahị_, _छिड़,
   {{0x7ceb04b8,0x656f283a,0x66e5a83b,0xaec480e8}},	//   _förä, _hich, рока, йбіл,
   {{0x212b0063,0x26dea83c,0x6f01a09c,0x656f283d}},	//   kich_, _dato_, _volc, _kich,
   {{0x212b0775,0xdb040073,0x63ad283e,0x27e9283f}},	//   jich_, tuiç, oran, _oran_,
   {{0x656f2840,0x212b0229,0x26de83a7,0x9ed98098}},	//   _mich, dich_, _fato_, _имат_,
   {{0x656f2841,0x26de954e,0x13098009,0x03259138}},	//   _lich, _gato_, тной_, рдон,
   {{0x63ad2842,0x7529a843,0x69de826f,0xcb140039}},	//   hran, piez, _šper, מלץ_,
   {{0x656f0943,0x212b2844,0x95678698,0x75ca8201}},	//   _nich, gich_, _създ, _qəze,
   {{0x26de8091,0x63ad0289,0x248d83a7,0x5edf00ab}},	//   _yato_, jran, mbem_, মানে,
   {{0x7d02822c,0x656f2845,0x6b89a846,0x27e901ec}},	//   _zoos, _aich, mpeg, _dran_,
   {{0x63ad2847,0xde032657,0x27e92848,0x656f106c}},	//   eran, опри, _eran_, _bich,
   {{0x63ad2849,0x212b01ac,0x69c1a84a,0x7de08019}},	//   fran, cich_, mtle, lásá,
   {{0x656f284b,0x27e9284c,0x998d23e3,0x0326284d}},	// [1700] _dich, _gran_, _ćeš_, адан,
   {{0x6d5d284e,0x656f1f8b,0xfaa6284f,0x60c9a850}},	//   _ehsa, _eich, ражо, _abem,
   {{0x63ad1897,0xa2bd80bc,0x60c9838a,0xb87b016a}},	//   aran, _शान्, _bbem, ldía,
   {{0x629aa851,0x2ba6901c,0x26dea852,0xfce62853}},	//   zato, _खिला, _sato_, _томо,
   {{0x26dea854,0x7d0298d6,0xb87b05e4,0xdb09816a}},	//   _pato_, _roos, ndía, nteó,
   {{0x656f2855,0x69c1a280,0xadc30032,0x3d118091}},	//   _zich, ktle, _atẹg, _báwo_,
   {{0x656f20ba,0xfaa32856,0xdd978048,0x7de08019}},	//   _yich, _фасо, ашы_, dásá,
   {{0x629a8077,0x26de80a4,0x3d11846d,0x44f4a857}},	//   wato, _wato_, _dáwo_, спис,
   {{0x26de801b,0x2fc0022c,0x629aa858,0x69c18035}},	//   _tato_, _nqig_, tato, etle,
   {{0x68e0a859,0xe8d90104,0x5b148364,0x3178285a}},	//   _hamd, _thị_, смот, _kurz_,
   {{0x2904a85b,0x257c0013,0x13cf00c8,0xbcfb285c}},	//   _koma_, _níl_, রিয়, _miér,
   {{0x68e2a85d,0x27e90205,0x2904a85e,0x644686ae}},	//   ndod, _pran_, _joma_, ükis,
   {{0x212b285f,0x2f1400f2,0x656f2860,0xd83b0048}},	//   rich_, _säga_, _rich, тэн_,
   {{0x656f2861,0x212b01e4,0x69dc007a,0x69ce2862}},	//   _sich, sich_, _osre, _opbe,
   {{0x656f022e,0x2d8505f8,0x35e405a8,0x69c1890d}},	//   _pich, ële_, оцтв, ctle,
   {{0x2f140006,0x2904829b,0x5c750a95,0xfc3f002a}},	//   _väga_, _noma_, слат, _adía_,
   {{0x63ad2863,0x2129036e,0x656f2864,0x68e2831d}},	// [1710] uran, _imah_, _vich, ddod,
   {{0xf1da8063,0x656f02af,0x59da92ee,0x63ad2865}},	//   _बनान, _wich, _बनार, rran,
   {{0x656f0a00,0x63ad16b2,0x644f009a,0xc69202f6}},	//   _tich, sran, _wyci, _מאי_,
   {{0x2904a866,0x63ad2867,0xc8798059,0x68e08114}},	//   _coma_, pran, _başa_, _camd,
   {{0x27e9a868,0x68e0809c,0x752d2869,0x6b5d8866}},	//   ían_, _damd, miaz, lège,
   {{0x6298a86a,0x81cd80c8,0x7bdd0051,0x752d030a}},	//   _nevo, রিত_, _issu, liaz,
   {{0x63a2a86b,0xe7f38063,0x816b8071,0x692b001b}},	//   _avon, _आपका_, _араб_, vřen,
   {{0xce380bea,0x2904a86c,0x752d286d,0x25a9a304}},	//   יאות_, _goma_, niaz, čal_,
   {{0x629894f9,0xe784a86e,0x7de08065,0x3015a481}},	//   _bevo, _духо, tásá, _удар,
   {{0x69c1a86f,0xf7708013,0x6b89a870,0xc2e98065}},	//   ttle, _قال_, rpeg, اعظم_,
   {{0x7c3b0125,0x395f81c0,0x6b89a871,0x6298a872}},	//   _þurf, _khus_, speg, _devo,
   {{0xa3d281ce,0x443d81c0,0x628e807b,0xc8798850}},	//   _हैक_, _txw_, ðbor, _yaşa_,
   {{0xe28e8ae7,0x43858307,0x752d2873,0x7d1ba874}},	//   _на_, _التق, diaz, mhus,
   {{0x6298a4de,0xe7fa816f,0x7d1ba875,0x68e2a876}},	//   _gevo, ्हता_, lhus, zdod,
   {{0xba9a8051,0x63a2883d,0x7bdd19c3,0x1a65853d}},	//   _עסקי, _zvon, _assu, _دیدی_,
   {{0x31a382bb,0x6143120c,0x2bac0a27,0x6281a877}},	//   mız_, _неща, _चिदा, lclo,
   {{0x2904a878,0x68e0a879,0xed5700a9,0xdb098216}},	// [1720] _roma_, _ramd, сот_, lteñ,
   {{0xb87b287a,0x2904a87b,0x6281a87c,0x394d810c}},	//   ndín, _soma_, nclo, _akes_,
   {{0x31a38afe,0x58868084,0x7bdd0c56,0xdb0984c3}},	//   nız_, была, _essu, nteñ,
   {{0x752d287d,0x395fa87e,0x75ca8085,0x61fc85ec}},	//   ciaz, _chus_, _nəza, ärli,
   {{0xe1e789d7,0x68e2a87f,0x7d1ba880,0xc7968190}},	//   _کس_, rdod, dhus, ёрды,
   {{0x2904913b,0x44202881,0xdb04016a,0x99760049}},	//   _woma_, mzi_, briá, _гуаш,
   {{0x63a28125,0x69dc0a20,0x6d410125,0xacf891d2}},	//   _svon, _usre, élag, инку_,
   {{0x629e2882,0x7d1ba883,0x75ca8085,0x186aa884}},	//   lapo, ghus, _cəza, _баби_,
   {{0x44201167,0x7d0601e2,0xa3b383b7,0x77e20a27}},	//   nzi_, _moks, जूल_, गटोक_,
   {{0xbea3a885,0x629e2886,0x752d2887,0x6281a888}},	//   _наук, napo, ziaz, gclo,
   {{0x60f901d7,0x9cca8b71,0x14ca8009,0x8afb007c}},	//   ання_, _была_, _были_, אליז,
   {{0xeb9a87b6,0x629e02e8,0xe8d900ff,0x63a282f7}},	//   _бид_, hapo, _thọ_, _tvon,
   {{0x2571805c,0x629e2889,0x6ebf800f,0x6298a88a}},	//   _ušla_, kapo, ल्कु, _tevo,
   {{0x4420288b,0x657a94aa,0x543b80be,0x1ddc9834}},	//   dzi_, _kuth, _געדא, _मनात,
   {{0x918688ca,0x4420288c,0x50c8864a,0x752d288d}},	//   _اجتم, ezi_, रभाष, tiaz,
   {{0x2129288e,0x7a0a8085,0xa3e50327,0x2f0b821e}},	//   _umah_, rətd, पटल_, _høgt_,
   {{0x2d580153,0x60cd288f,0x752d0f92,0x657aa890}},	// [1730] сить_, _ibam, riaz, _luth,
   {{0x629e2891,0x3f890187,0x394b1e9e,0x249902c4}},	//   gapo, _itau_, locs_, _wesm_,
   {{0xe5c72300,0x395f81c0,0x44202892,0x657a89c4}},	//   _успо, _phus_, azi_, _nuth,
   {{0x63b606d5,0x764482d0,0xe1f001a8,0xfbd00061}},	//   buyn, ğiyl, عسل_, بتہ_,
   {{0x7bc413df,0x2b930bca,0x657a8051,0xb4db026b}},	//   ctiu, _ریاس, _auth, _ajàg,
   {{0x6b8d2893,0x079c0039,0xdb231a50,0x31a3807e}},	//   mpag, נסול, örän, yız_,
   {{0x4519a33f,0x6b8d2894,0xe8d90028,0x7d060214}},	//   иция_, lpag, _nhỏ_, _yoks,
   {{0x69c52895,0x75ca8085,0x394b023e,0xdb1b8118}},	//   mthe, _qəza, jocs_, rtuí,
   {{0xfc318307,0x31d184e5,0x3f8910af,0x7d1b8370}},	//   بحث_, तब्ध, _ntau_, rhus,
   {{0x657a91e8,0x693c9807,0x60cd2896,0x7d1ba897}},	//   _futh, nčen, _abam, shus,
   {{0x44202898,0x3f89048f,0xb87b2899,0x657aa89a}},	//   zzi_, _atau_, rdín, _guth,
   {{0xc6890f60,0xe56e835f,0x69c50cac,0x291d8683}},	//   _יא_, _із_, ithe, nhwa_,
   {{0x31a383bf,0x81c100ab,0xfaa58196,0x2f10851e}},	//   sız_, ্টি_, _дало, _bàgh_,
   {{0x6b8d0f33,0x212f81e4,0xe3b0a89b,0x69c5289c}},	//   dpag, high_, _سره_, kthe,
   {{0x693c816b,0x366a2748,0x78a9a67b,0xdb098661}},	//   dčen, раво_, _odev, nreí,
   {{0x7ae3a89d,0x4420011e,0x2d78017f,0x81c100ab}},	//   _hant, tzi_, _očev_, ্টা_,
   {{0x7ae3861b,0x629e049f,0x66e60003,0x7d060b40}},	// [1740] _kant, tapo, _допа, _voks,
   {{0x78a98012,0x249f81c5,0x7bc4289e,0x44200235}},	//   _adev, haum_, rtiu, rzi_,
   {{0x44200065,0x7bc4289f,0x68e428a0,0xe9da28a1}},	//   szi_, stiu, _kaid, рке_,
   {{0x6b8d28a2,0x26d828a3,0x777b8079,0x29020796}},	//   bpag, lero_, _buux, njka_,
   {{0x2ca028a4,0x657aa8a5,0x795d03f8,0x27ed9c4b}},	//   maid_, _suth, néwa, _cren_,
   {{0x26d828a6,0xfdfe0e18,0xf413004c,0x7ae3a8a7}},	//   nero_, _उपास_, _חפש_, _nant,
   {{0x63a428a8,0x27eda8a9,0x629c0029,0xd5b080f7}},	//   lsin, _eren_, _iero, رفة_,
   {{0x7ae382b5,0x68e40046,0x291da8aa,0xf1c303fb}},	//   _aant, _naid, chwa_, žší_,
   {{0x7ae3a0fc,0xa2ca0023,0x629c28ab,0xdddc01dd}},	//   _bant, स्थ्, _kero, jbrž,
   {{0x26d828ac,0xbcfb00f7,0x3d1880d7,0xdb0d0118}},	//   jero_, _mhéa, _déwa_, traé,
   {{0x7ae3a8ad,0x26d828ae,0x629c28af,0x27e028b0}},	//   _dant, dero_, _mero, _asin_,
   {{0x645c8086,0x2ca00074,0x7c65803d,0x68e428b1}},	//   ərin, jaid_, _کامل, _caid,
   {{0xb4d69344,0x26d828b2,0xc05b0558,0xb4b6a8b3}},	//   ाजी_, fero_, рін_, जली_,
   {{0xa3d785e8,0x629c1bfe,0x26d80e4d,0xf6518065}},	//   ाबर_, _nero, gero_, _آئے_,
   {{0xd49b0ae7,0x6b8d28b4,0x27e004be,0x68e428b5}},	//   ира_, wpag, _esin_, _faid,
   {{0x68e428b6,0x7ae3a8b7,0x25ad1f95,0x63a428b8}},	//   _gaid, _zant, čel_, fsin,
   {{0xbcfb0013,0x63a428b9,0x26d828ba,0x7ae3a8bb}},	// [1750] _chéa, gsin, bero_, _yant,
   {{0x68e400f6,0xbcfb0307,0xa3ac000f,0x6b8d28bc}},	//   _zaid, _dhéa, _गिर_, rpag,
   {{0xa2bd81ab,0x212f80f7,0x26c10133,0x291d805d}},	//   _शास्, tigh_, _icho_, thwa_,
   {{0xa2ca824c,0xbcfb0013,0x2ca028bd,0x69c528be}},	//   त्त्, _fhéa, caid_, rthe,
   {{0x629c28bf,0xf484003d,0x212f8c5e,0x2fc6a8c0}},	//   _fero, _تاپی, righ_, gtog_,
   {{0x291d9ae4,0x629c28c1,0x69c528c2,0x212f81a8}},	//   shwa_, _gero, pthe, sigh_,
   {{0x7ae3a8c3,0x6ecd000c,0x6d44a8c4,0x61ee01a1}},	//   _rant, द्यु, čian, _grbl,
   {{0x7ae3933b,0x27eda8c5,0x628528c6,0xd4d9835f}},	//   _sant, _tren_, lcho, ські_,
   {{0x26c105a4,0x629c0c2e,0x26d828c7,0x27eda8c8}},	//   _ocho_, _yero, yero_, _uren_,
   {{0x628528c9,0x68e428ca,0x26c1022c,0x629c28cb}},	//   ncho, _said, _ncho_, _xero,
   {{0xdb0d02ba,0x26d815a4,0x68e428cc,0x63a428cd}},	//   ntañ, vero_, _paid, zsin,
   {{0x26c128ce,0x7c2d9bcf,0x9f4481df,0x63a428cf}},	//   _acho_, _žaru, _irmá_, ysin,
   {{0x26d828d0,0x2ca00006,0x68e428d1,0x628528d2}},	//   tero_, vaid_, _vaid, kcho,
   {{0x7ae38282,0x628528d3,0x25ac026f,0xbbe9804e}},	//   _uant, jcho, ádlo_, _پرچم_,
   {{0x26d828d4,0x628528d5,0xdb0d00e7,0x68e422af}},	//   rero_, dcho, traî, _taid,
   {{0x63a428d6,0x629c28d7,0x26d828d8,0xb4e606af}},	//   tsin, _sero, sero_, पये_,
   {{0xa5070098,0xd46710ca,0x61ee1f3a,0x1d072300}},	// [1760] чета_, зите_, _srbl, чети_,
   {{0x63a428d9,0x2ca028da,0x6b50016d,0x6aa18b81}},	//   rsin, said_, vägs, nalf,
   {{0x629c28db,0x2ca017f6,0x63a41527,0xc8b50019}},	//   _vero, paid_, ssin, _علیک,
   {{0x63a428dc,0xbcfb00f7,0x629c28dd,0x00000000}},	//   psin, _théa, _wero, --,
   {{0x28c110be,0x629c28de,0x4abda23a,0x6285016b}},	//   ष्टि, _tero, ्भाव, bcho,
   {{0x656280f1,0x657e005d,0x45d4a8df,0x6285051e}},	//   _shoh, _kuph, докс, ccho,
   {{0x3981a8e0,0xc1da800f,0xdb04016d,0x7c240087}},	//   _nós_, _बनेग, rriä, lzir,
   {{0xdce428e1,0x48e38af2,0xb4d693e5,0x7d0428e2}},	//   kmič, _посв, ाजे_, njis,
   {{0xd943838d,0x7c2428e3,0xa2bd9834,0x614389b5}},	//   _чети, nzir, _शाश्, _чета,
   {{0x645c8201,0xdce42648,0xfbcf80a0,0xef178009}},	//   əril, dmič, اتي_, _ему_,
   {{0xa2c10540,0x58d90b79,0x6562a8e4,0x867581e2}},	//   र्ट्, одня_, _thoh, _жыцц,
   {{0xdb1ba8e5,0x2d570214,0x69cd86a7,0x62850690}},	//   rtuá, rçek_, _तहरी, zcho,
   {{0x506404ae,0xdb1b8187,0x75ca8085,0x6aa18c0b}},	//   етра, stuá, _məzm, balf,
   {{0x39818013,0x7c2428e6,0x6aa1823e,0xf53f021e}},	//   _fós_, dzir, calf, _sjå_,
   {{0x78a28a9e,0x6614128a,0x97579101,0x9f44128a}},	//   kaov, _čeká, פילו_, ímá_,
   {{0xd23b804c,0x7d04020f,0xe945026a,0x2a3b81c6}},	//   _לגול, gjis, _ترتی, _לעומ,
   {{0x628528e7,0x2b510267,0x3ce681a1,0x6f010061}},	// [1770] tcho, _pkzc_, _maov_, ölcs,
   {{0x212da8e8,0x501c01c6,0x628513ff,0x4424a8e9}},	//   _smeh_, _לוחו, ucho, izm_,
   {{0xceb2093f,0x628528ea,0xcb138158,0x69c887f1}},	//   _ביי_, rcho, עלע_, ntde,
   {{0x628528eb,0xf8bf28ec,0x7c240bcf,0xb4d68327}},	//   scho, ngé_, bzir, ाजो_,
   {{0xdb0d0ef3,0x31648115,0xf8bf0036,0xc615a8ed}},	//   stañ, _dhmz_, liés_, तन्य_,
   {{0x8ae4035f,0x3ea328ee,0xdb0d0187,0x6440050b}},	//   _післ, najt_, duaç, _žmig,
   {{0x3164826c,0xa3e5000d,0x77770609,0xdb0d01a8}},	//   _fhmz_, पटक_, _mixx, nraí,
   {{0xfdf80039,0x7ae728ef,0x78ad0a03,0x3d18810c}},	//   לצות_, _hajt, _ndav, _déwo_,
   {{0x6aa1a8f0,0x04778065,0x7ae7007a,0x6569a8f1}},	//   talf, _ہلاک_, _kajt, rmeh,
   {{0x394f80eb,0x398183a7,0x6569a8f2,0xc9a98198}},	//   logs_, _pós_, smeh, овое_,
   {{0xd9462606,0x7ae728f3,0x7d1d28f4,0x645c8085}},	//   дени, _majt, _olss, ərim,
   {{0xcea9004c,0x7ae728f5,0xf8bf28f6,0x3981a6f0}},	//   _כי_, _lajt, ggé_, _vós_,
   {{0xd9aa01a2,0xbcfb00e7,0xe7f0881f,0xbbeb80d7}},	//   _चट्ट, _phén, चिया_, _درام_,
   {{0xdb0980f7,0x69d500f3,0xf8bf0036,0xdce428f7}},	//   breá, _opze, fiés_, rmič,
   {{0xbb5284e3,0xdb0d0013,0xc10600f7,0x63bba8f8}},	//   _جنوب, graí, _يوتي, luun,
   {{0x2cbf8074,0x29190168,0x7d0b8061,0x2d5389b2}},	//   ngud_, ërat_, _jogs, mães_,
   {{0x3ce60038,0x7bc9a8f9,0x7d0428fa,0x63bba8fb}},	// [1780] ľov_, nteu, rjis, nuun,
   {{0xe8d90142,0xa3cf1a87,0x44630073,0x3ce600e1}},	//   _thể_, _शहर_, твув, žov_,
   {{0xaacfa3a7,0xa50a18a0,0x3ce9151e,0x7ae728fc}},	//   त्यक, _дена_, bdav_, _dajt,
   {{0xdb0d007b,0x7bc9a8fd,0x3cf90118,0x693c81d6}},	//   stað, kteu, _gnsv_, mček,
   {{0xd12f83f8,0x10a3a8fe,0x98a38991,0x87da9c12}},	//   جمن_, тичн, тиче, تباس_,
   {{0x6d448110,0x63bb8079,0xaacf8107,0x644602f9}},	//   čiam, duun, त्मक, _ixki,
   {{0x7d0ba8ff,0x60c402a5,0x98a9026c,0x69c8a900}},	//   _bogs, _ocim, _smač_, xtde,
   {{0xdb0d0073,0x7ae7251c,0x63bba901,0xfbaa862c}},	//   tuaç, _zajt, fuun, отой_,
   {{0x7d0b81e0,0x7ae701c0,0xaec6a902,0x693c928a}},	//   _dogs, _yajt, _обал, yčej,
   {{0x60c40073,0x764d8182,0x1f63a28e,0x59d205fb}},	//   _acim, şaya, _акум, _सहार,
   {{0xe1352903,0x195901bb,0xdb042904,0x81d68264}},	//   енны, заны_, friú, সিভ_,
   {{0x26dca905,0x7d0b80b9,0x27f22906,0xdb040036}},	//   levo_, _gogs, _bryn_, ssiè,
   {{0x7bc982c2,0x78a09142,0xf8bf00e7,0x69c8a907}},	//   cteu, _memv, rgé_, stde,
   {{0xdef8053b,0xdb0d2908,0x26dc80e5,0xf8bf0866}},	//   мыс_, traí, nevo_, tiés_,
   {{0xcad78051,0x7ae70019,0x3ea32909,0x7d1d02c4}},	//   _חוות_, _rajt, rajt_, _plss,
   {{0x7ae7290a,0xa2ca8d14,0xf8bf00e7,0x3ea3290b}},	//   _sajt, त्र्, riés_, sajt_,
   {{0x29190029,0x24580009,0x7ae7290c,0x60dd0123}},	// [1790] ūras_, дать_, _pajt, mesm,
   {{0x60dd290d,0x26dc9620,0xbcfb00e7,0xc8798087}},	//   lesm, jevo_, _théo, _iaşi_,
   {{0x7ae7290e,0x26dca90f,0x51840110,0x85750009}},	//   _vajt, devo_, вуча, _плох,
   {{0x25f4825e,0x60dd2910,0x2561808b,0x63b62911}},	//   ्मनी_, nesm, kóla_, bryn,
   {{0x24b600be,0x63bb8079,0xf8bf00e7,0x7ae72912}},	//   _אהרן_, xuun, chée_, _tajt,
   {{0x656d1572,0x2b0003eb,0x2f188198,0x62830088}},	//   lmah, राणु_, мочь_, žnob,
   {{0x60dd2913,0x6aa52914,0x62888216,0x9f400362}},	//   kesm, mahf, dcdo, _criù_,
   {{0x7bc9a915,0x656d2916,0x63bba917,0x3ea12918}},	//   tteu, nmah, tuun, _leht_,
   {{0x31348703,0x2fc901c0,0x656d011b,0x6d4280c3}},	//   _ретр, _nqag_, imah, _djoa,
   {{0x291f8282,0x656d2919,0x26dc847f,0x7bc9a91a}},	//   _hlua_, hmah, cevo_, rteu,
   {{0x68e99083,0x656d09ca,0xf2d200be,0x68fba91b}},	//   _kaed, kmah, נעט_, _knud,
   {{0xaacf024c,0x4acf06bf,0x7bc980e7,0x656d026c}},	//   स्तक, स्तव, pteu, jmah,
   {{0x7c3b291c,0x395e00eb,0x653a80be,0x6aa500b9}},	//   _žurn, ēts_, _צענד, kahf,
   {{0x6d5b820f,0x6446008e,0x63a9a91d,0xbcfb09c4}},	//   llua, _rxki, msen, _dhém,
   {{0xceb29a0f,0x63a9a280,0xf8bf026f,0x24f61444}},	//   טים_, lsen, riér_, нчар,
   {{0x2edc800d,0x63b60d12,0xfce30171,0x693c81ac}},	//   _यस्त, tryn, лосо, rček,
   {{0x63a9a91e,0x6d5ba91f,0x6b4b0061,0xab662920}},	// [17a0] nsen, ilua, lügy, евал,
   {{0x3ea10352,0x63a9a921,0x68fba922,0x291f8f3e}},	//   _geht_, isen, _anud, _alua_,
   {{0x64a625af,0xda0f83eb,0x81cd80ab,0x26dca923}},	//   _пана, ाहित_, রিক_, vevo_,
   {{0x92c20a49,0xc7c69b10,0x63a9a924,0x4fc68103}},	//   ্যে_, ески, ksen, еска,
   {{0xb05b0106,0x26dca925,0x98ab0087,0x6d5ba926}},	//   lfär, tevo_, lică_, dlua,
   {{0x63a997db,0x290d8176,0xde588084,0x36d4a927}},	//   dsen, _eoea_, малі_, токр,
   {{0xd91099f4,0xe3570451,0x78a6003a,0x4343014f}},	//   _پیش_, _נשלח_, kakv, _серв,
   {{0xafe69631,0x628a826c,0x26dc8267,0xd90d881b}},	//   _побл, _sffo, sevo_, _ویل_,
   {{0xcf469ae5,0x6459864c,0x26dc847f,0x60c281f6}},	//   _знай, _cywi, pevo_, mgom,
   {{0x21200455,0x9ad281bc,0x7a0a8085,0xef1981b9}},	//   _alih_, _bịag, bətl, _tuża_,
   {{0x2258813c,0x6d5ba928,0x673500f1,0x75d395a9}},	//   ærk_, blua, vizj, _ميلا,
   {{0x60c2a929,0x28c60ebf,0x98ab0087,0x67350035}},	//   ngom, _वाणि, dică_, wizj,
   {{0x60dd292a,0xac9781a8,0x2d81292b,0x64598114}},	//   resm, _أنها_, _suhe_, _gywi,
   {{0x98ab0087,0xb05b05ec,0xb6e4096b,0x60dd292c}},	//   fică_, ffär, люск, sesm,
   {{0x248901e0,0xa01b0019,0x6d408a53,0xaa57a92d}},	//   tcam_, nböz, onma, _пишу_,
   {{0x7aeaa92e,0x6d40a92f,0x81cd80c8,0x92bd00ab}},	//   _haft, nnma, রিখ_, _আসে_,
   {{0x24892930,0x7aeaa931,0x7ff701a8,0x6d40a932}},	// [17b0] rcam_, _kaft, _أسعا, inma,
   {{0xdbc78074,0x656d2933,0x24892934,0xdb098187}},	//   _tööp, smah, scam_, rreç,
   {{0x6b828098,0xc3338039,0x24891286,0xaca30133}},	//   _luog, נוע_, pcam_, _amụb,
   {{0x75242935,0x7aeaa936,0x9f5206c4,0x41d201a2}},	//   chiz, _laft, _aryè_, _सहरस,
   {{0x2571812b,0x5eaa80ab,0x3d0489c8,0x672380f1}},	//   _ušli_, চ্ছে, वाने_, thnj,
   {{0x44290010,0x6d40a937,0x141a01c6,0x63bf0037}},	//   mza_, enma, _חושב, muqn,
   {{0x7d0f0061,0xb89581a8,0x661881d6,0x777a9fa4}},	//   _kocs, _للأع, _čaká, _ditx,
   {{0x63a9a938,0x44292939,0x67238168,0x7a0a8085}},	//   tsen, oza_, shnj, rətl,
   {{0x6d5b8867,0x777a89cb,0x25a0812b,0x98ab0087}},	//   rlua, _fitx, ćila_, zică_,
   {{0x4429293a,0x765a80f1,0x7aea8bfe,0x777a8cdb}},	//   iza_, _fyty, _caft, _gitx,
   {{0x7aea8455,0x3ea7a93b,0x63a9a93c,0x7bcd0198}},	//   _daft, mant_, ssen, htau,
   {{0x3ea79702,0x63a98721,0x61f50ee1,0x27260129}},	//   lant_, psen, _mrzl, _kông_,
   {{0xa3e593d9,0x7d09920e,0x4429293d,0x88e300ab}},	//   _पनि_, mjes, jza_, যাংক,
   {{0x3ea7a93e,0x7d09a93f,0x44292940,0x98ab002e}},	//   nant_, ljes, dza_, tică_,
   {{0x7d0f2941,0x44292942,0x80d28b75,0xed5a24a4}},	//   _bocs, eza_, ण्डे, дов_,
   {{0xed431980,0x98ab0087,0x3d0483db,0x7d09a943}},	//   ансп, rică_, वाये_, njes,
   {{0x75ca8201,0xed570003,0x2726001c,0x7d0f0706}},	// [17c0] _vəzi, тот_, _nông_, _docs,
   {{0x693ca944,0x3ea7a945,0x752400b4,0x81bc80eb}},	//   nčev, jant_, shiz, dzēj,
   {{0x44290012,0x3ea7a946,0x7d1ba947,0x7d09a948}},	//   aza_, dant_, kkus, kjes,
   {{0x6ec4a6ee,0x272600ff,0x44292949,0xb87b294a}},	//   _राहु, _bông_, bza_, rdív,
   {{0x27260142,0x44290063,0xb91d01bc,0x2ba90ad5}},	//   _công_, cza_, _anyụ_, _चौपा,
   {{0x3ea7a94b,0xcf9300be,0xef19809a,0x272600ff}},	//   gant_, סטו_, _dużo_, _dông_,
   {{0x20008c6e,0x644e8085,0x7afe823e,0xdb0401df}},	//   ţii_, əbiy, _òpti, quiñ,
   {{0x7aea84dc,0x7d09a94c,0x7d1b8ec9,0xaacf909b}},	//   _saft, gjes, gkus, त्सक,
   {{0x3ea7a94d,0x6aa3a94e,0x6d408d1a,0xafe397c7}},	//   bant_, _benf, rnma, _котл,
   {{0x3ea7a94f,0x5186a950,0x2d6e801b,0xd764803d}},	//   cant_, кума, _přes_, _صنای,
   {{0xc333004c,0x691387d9,0x44292951,0xaad40c1c}},	//   שות_, _içer, zza_, ठ्यक,
   {{0x78a412f5,0x3f84a952,0x44292953,0x7bcd0084}},	//   _ceiv, _kumu_, yza_, ytau,
   {{0xead49641,0x99640071,0x3f849325,0x7c298035}},	//   _боль, ртэл, _jumu_, czer,
   {{0x7bc0a954,0x07a40048,0x3f8482ec,0x7f942218}},	//   mumu, раён, _mumu_, рарх,
   {{0x5faf0076,0x4b7b80be,0x3f848c2e,0xd37b8e82}},	//   _झटकल, _קאוו, _lumu_, _קרוט,
   {{0x44292955,0x7bcd24fb,0x3ea7a956,0xaac618b1}},	//   tza_, ttau, zant_, र्घक,
   {{0x2d580364,0x44292957,0x3ea7a958,0x8aa70b5b}},	// [17d0] тить_, uza_, yant_, вред,
   {{0xd5a48986,0x27e9026b,0x8c3d82bb,0x7bcd2959}},	//   _وہ_, _isan_, daşl, rtau,
   {{0x3ea7a95a,0x4429295b,0x68ed295c,0x8af78201}},	//   vant_, sza_, _kaad, _şəki,
   {{0x7bc0a95d,0x4429008e,0xb7d5846d,0x213901c6}},	//   kumu, pza_, _aṣaw, nish_,
   {{0x7bc0a95e,0x68ed295f,0x7d09920e,0x2ca92960}},	//   jumu, _maad, vjes, maad_,
   {{0x68ed2961,0x2ca90079,0x39ae8084,0xdce98267}},	//   _laad, laad_, kęs_, rmeč,
   {{0x3ea7a962,0x657d2963,0xed59a964,0x41e40084}},	//   rant_, _kish, нок_, _кіта,
   {{0x7983a965,0x3ea7a966,0x61fa0019,0x272600ff}},	//   _runw, sant_, _átla, _tông_,
   {{0x657d2967,0x7d09a968,0x60c98267,0xbcfb0013}},	//   _mish, rjes, _icem, _chéi,
   {{0x657d2647,0x63ad2969,0x78a4296a,0x645d296b}},	//   _lish, isan, _seiv, _mysi,
   {{0x68ed296c,0x7c298117,0xc6928158,0xa0a61ddf}},	//   _baad, szer, _האב_, ланд,
   {{0x3ea58f06,0x63ad296d,0x8c3d8182,0x657d296e}},	//   _helt_, ksan, laşm, _nish,
   {{0xb8ec131d,0x7bc0a96f,0x6d59a970,0x68ed2971}},	//   _ला_, cumu, _ikwa, _daad,
   {{0x2d85a972,0x63ad2973,0x248da974,0xf53981ac}},	//   _kule_, dsan, lcem_, liť_,
   {{0x27e92975,0x1dc6820e,0x63bb80eb,0x7ae1a976}},	//   _esan_, रूपत, lrun, melt,
   {{0x28d30076,0xaacf86de,0x68ed0ef2,0xf53981ac}},	//   ध्दि, त्रक, _gaad, niť_,
   {{0x69c1a977,0xb7be80c8,0x63ad2978,0x2fcd81c0}},	// [17e0] lule, _ইন্ট, gsan, _nqeg_,
   {{0x7ae1a979,0x29000282,0xb87b0019,0x81d680ab}},	//   nelt, _hnia_, rdít, সির_,
   {{0x2b898104,0x63bb8352,0x69c1a97a,0xe8d90028}},	//   _lúc_, hrun, nule, _nhớ_,
   {{0x645d2280,0x657d297b,0x6d598870,0x29120388}},	//   _fysi, _gish, _nkwa, _joya_,
   {{0x69c18fc4,0xf53981ac,0x7ae1a97c,0x63ad297d}},	//   hule, diť_, kelt, csan,
   {{0x6d441c30,0x6d59a97e,0x69c1a97f,0x6d5602ed}},	//   lnia, _akwa, kule, loya,
   {{0x63bb82af,0x25a082a5,0x657d0ab4,0xb87b2980}},	//   erun, ćilo_, _yish, ndír,
   {{0x69c1a981,0x7bc0a982,0x6d442983,0x39ae8110}},	//   dule, tumu, nnia, vęs_,
   {{0x68ed2984,0x63bb8a64,0xd90d8065,0x6d442985}},	//   _raad, grun, _تین_, inia,
   {{0x68ed2986,0x7bc0a987,0x29002988,0x6d562989}},	//   _saad, rumu, _ania_, hoya,
   {{0x69c19786,0x2912298a,0xdd8f8077,0x7bc0a98b}},	//   gule, _boya_, _فول_, sumu,
   {{0x68ed02c1,0x6d440069,0x2ca902a3,0x63ad298c}},	//   _qaad, jnia, xaad_, ysan,
   {{0x9cd78051,0x657d298d,0x68ed09f8,0x2900009a}},	//   _תודה_, _rish, _vaad, _dnia_,
   {{0x69dc298e,0x69c1a98f,0x2d858010,0x6d448110}},	//   _opre, bule, _yule_, čiau,
   {{0x69c1a990,0x693c8a2f,0x291200ee,0xfa558019}},	//   cule, nčes, _foya_, _پروگ,
   {{0x657d2991,0x6d562992,0x349501e5,0x636b2993}},	//   _qish, goya, раар, zünd,
   {{0x2ca91e94,0x27e91df5,0x2b89801c,0x9f400144}},	// [17f0] raad_, _usan_, _xúc_, _crió_,
   {{0x61f8811f,0xf5398038,0x6b5d8722,0x63a2a994}},	//   _krvl, ziť_, tègi, _mwon,
   {{0x6d442995,0x645d2996,0x7aee01c5,0x69dc2997}},	//   bnia, _wysi, _dabt, _cpre,
   {{0x417480f7,0x57f58568,0x2ba91513,0x645d0035}},	//   مانس, ипет, _चौथा, _tysi,
   {{0x69dc2998,0xf5398038,0x69c1a999,0x2d85a99a}},	//   _epre, viť_, zule, _sule_,
   {{0x7d0d299b,0xc5f980c8,0x2d85a99c,0xbcfb1727}},	//   ljas, _অথবা_, _pule_, _chév,
   {{0xf53981ac,0x28c603eb,0x2ba9000d,0x7c2d299d}},	//   tiť_, _वालि, _चौता, lzar,
   {{0xdb04299e,0x3ea582af,0xa3b90105,0xa3e92279}},	//   brió, _welt_, _घटा_, _मना_,
   {{0x7c2d299f,0xdcfa8029,0x7ae1a9a0,0xf53981ac}},	//   nzar, _attē, telt, riť_,
   {{0x69c1a9a1,0xadf7015c,0x63bba9a2,0x2d85837b}},	//   tule, ुमान_, rrun, _tule_,
   {{0x6d44031d,0x8e848013,0xf53981ac,0xa2ca06ce}},	//   ynia, _المه, piť_, स्ट्,
   {{0x69c1a055,0x63bba9a3,0x61f8817f,0x7ae1a9a4}},	//   rule, prun, _drvl, selt,
   {{0xe28e828b,0x53a582fb,0x6d4429a5,0x6d4481ac}},	//   _ма_, _талб, vnia, čiat,
   {{0x69c1a9a6,0xf7721ddd,0x38690239,0x6d4429a7}},	//   pule, تاج_, _dzar_, wnia,
   {{0xada61a8f,0xe8d90028,0x7aee16bb,0x442da9a8}},	//   рабл, _giữ_, _rabt, lze_,
   {{0x7aee29a9,0x06af80ab,0xef8615e0,0x7d0d1443}},	//   _sabt, চ্চি, _клип, gjas,

   {{0x69dc29aa,0x2d9829ab,0x6d4429ac,0xafe61878}},	// [1800] _spre, spre_, rnia, _топл,
   {{0x7aee02a3,0x6aa7026c,0x2561808b,0x442da9ad}},	//   _qabt, _cejf, fólk_, ize_,
   {{0x09e604fa,0xfc3f01ca,0x6d561149,0x7d0d026c}},	//   роен, _veía_, poya, bjas,
   {{0x316d83d3,0x442d8831,0xdb04188b,0x2900a38a}},	//   _chez_, kze_, trió, ñia_,
   {{0x7aee29ae,0x442da9af,0xe8d9001c,0x3d048075}},	//   _tabt, jze_, _nhờ_, वासे_,
   {{0x6b8480f7,0x442da9b0,0xd83f016b,0xe2970a42}},	//   _éigi, dze_, _účel_, _вар_,
   {{0xe1e78064,0x32070009,0x69dc00e1,0x6136017f}},	//   _بس_, änyt_, _upre, ršlj,
   {{0x7c3b02a5,0x6283a9b1,0x387f017f,0x7529a9b2}},	//   _žuri, _agno, žuri_, ghez,
   {{0x673c01c2,0x394682ba,0xe8d90028,0x6eb681a8}},	//   kirj, mnos_, _chờ_, _نصائ,
   {{0x3d0483b7,0xdb040118,0x7dfc8162,0x661c1235}},	//   वाहे_, oriñ, _păsă, kyrk,
   {{0x7980a9b3,0xdb098020,0x442d838a,0x7c2d0ca9}},	//   _kimw, gueñ, aze_, zzar,
   {{0x7529822e,0x3946a9b4,0x63a29528,0x6d4488fc}},	//   chez, nnos_, _twon, čias,
   {{0x442d8d38,0x7d02a9b5,0x63a2a9b6,0xdce88110}},	//   cze_, _inos, _uwon, _sudė,
   {{0xdced026f,0xa2c2000d,0x7bdb83c8,0xadc3826b}},	//   rmač, _लाग्, _סקוו, _alẹm,
   {{0xdb00a3fa,0xa6978039,0xeca70226,0x28d7a9b7}},	//   gsmå, שכלה_, ијан, ण्डि,
   {{0x7c2d29b8,0xdb0401df,0x80c1016f,0x39468019}},	//   tzar, driñ, _वाटे, jnos_,
   {{0x29e8002e,0x395929b9,0x7bc426f9,0x67da81a9}},	// [1810] _aşa_, moss_, guiu, nājā,
   {{0x7d0d29ba,0x3946a9bb,0xd543026b,0xa91d80c3}},	//   sjas, enos_, _bẹ́n, _miže,
   {{0x442da9bc,0x6ecd8beb,0x7c2d29bd,0x798080b4}},	//   zze_, _साबु, szar, _bimw,
   {{0x3946a9be,0xe45f0198,0xed4680d7,0x645d82f1}},	//   gnos_, _työ_, _رپ_, üsik,
   {{0x6126007b,0xa91d80ce,0x6d5d1400,0x693c81a1}},	//   _jóla, _niže, _iksa, tčer,
   {{0x66e582a9,0x39469f90,0xc69500be,0xdee59033}},	//   сока, anos_, זאַ_, соки,
   {{0x7afa008b,0xa3a9864a,0x2d680799,0x3f8917c9}},	//   _ótta, गीन_, ißen_, _luau_,
   {{0x442da9bf,0x4c698037,0x7ae508e5,0x69c51a08}},	//   tze_, лийн_, leht, muhe,
   {{0x3d080076,0xc9528bea,0x442da9c0,0x60dba9c1}},	//   हाते_, _זמן_, uze_, _ibum,
   {{0x442d8b04,0x7d028353,0x78a9a9c2,0xb87b29c3}},	//   rze_, _enos, _heev, teín,
   {{0x442da95b,0x5d8580f7,0x7529805d,0x673c007a}},	//   sze_, _الصل, phez, virj,
   {{0x612629c4,0x2d6802af,0xf09f077f,0xe8d900ff}},	//   _bóla, eßen_, gbà_, _thờ_,
   {{0xdb0981ca,0xed59807a,0x249f82df,0x3d04873c}},	//   sueñ, mož_, mbum_, वारे_,
   {{0x6d5d29c5,0x539a8051,0x612619ba,0x249fa9c6}},	//   _aksa, _עיצו, _dóla, lbum_,
   {{0xdb098c15,0x637012d2,0xd6270af0,0xe164003d}},	//   queñ, läng, боре_, _وضعی,
   {{0x6ab79094,0x2ba9000f,0x4c861d85,0x8a168039}},	//   _आयुर, _चौहा, слав, _לחצו_,
   {{0xd6c30019,0x798080b4,0x673c007a,0x63620187}},	// [1820] _کمپی, _rimw, pirj, lôni,
   {{0xadf985e8,0x27e00091,0x6ac600f7,0x6d5d17ab}},	//   ्मान_, _ipin_, إقام, _eksa,
   {{0x63700b2f,0x1efb00be,0x27ed86c4,0xed59a9c7}},	//   häng, _עלטע, _asen_, kož_,
   {{0xa2d80540,0xdb0429c8,0x78a98282,0x1d0a29c9}},	//   _नॉर्, rriñ, _ceev, _семи_,
   {{0x3946a82b,0xaab8026a,0x33b50a14,0x7bc429ca}},	//   rnos_, _نگار_, _мёрт, quiu,
   {{0x26ca29cb,0x7d028d11,0x656429cc,0x3946a720}},	//   ngbo_, _snos, llih, snos_,
   {{0x3d04800c,0xe7af009a,0x2d8229cd,0x877b03de}},	//   वाले_, _जौनप, _kike_, נאצי,
   {{0x27e029ce,0x71268277,0xf8b0803d,0x77868009}},	//   _opin_, _ارسل, _آکا_, _глаз,
   {{0x63701f0f,0x7d02807a,0xa3cb073c,0xa2d8001b}},	//   gäng, _vnos, रूप_, न्थ्,
   {{0x2d8229cf,0xaaa8036d,0x636203a7,0x7b39816b}},	//   _like_, गरिक, fôni, lňuj,
   {{0xd5b9835f,0xfbcf826a,0x712700f7,0x23a986a7}},	//   _всі_, وتی_, مرحل, चीबद,
   {{0x59c90e1a,0xa2d80023,0x7d028024,0x63701bc0}},	//   ांतर, न्त्, _unos, länd,
   {{0xa2d381fe,0xdc8e81bc,0x395929d0,0x26d829d1}},	//   _बॉक्, _dịtụ_, ross_, ffro_,
   {{0x43748077,0x4ac700d4,0x2d820300,0xe5c70a08}},	//   _بهتر, _लाइव, _aike_, йсбо,
   {{0xa3cb09c8,0xd0470085,0xe18980ff,0x2d821aad}},	//   रंभ_, _əməl, _hẳn_, _bike_,
   {{0x3eae8352,0x637012d2,0x2d820041,0x6aaaa9d2}},	//   haft_, händ, _cike_, _heff,
   {{0x2d8229d3,0x78a9a9d4,0x06e400ab,0xe50986a7}},	// [1830] _dike_, _reev, মাজি, वाति_,
   {{0x9a8706d2,0xbcfb29d5,0x2d8211ce,0x8c1b81c6}},	//   суал, _chér, _eike_, אומי,
   {{0x3cfe8076,0x78a9822c,0xa3a909f2,0xd91b99b8}},	//   _शोभे_, _peev, _गौर_, льд_,
   {{0x69c529d6,0x69c080d4,0x6aaa8198,0x5c070bac}},	//   ruhe, _विनी, _leff, _ляга,
   {{0xf7719168,0xd009a9d7,0xe8d911d3,0x6362041c}},	//   وات_, реле_, _nkọ_, zôni,
   {{0xa2d80bb8,0xb6a593b4,0x2d959016,0x6aaaa9d8}},	//   न्द्, цикл, орис, _neff,
   {{0x2129059c,0x171c0158,0xe8d919a8,0x78a9a9d9}},	//   _olah_, רווע, _akọ_, _teev,
   {{0x58d48e8e,0x60dba9da,0x6370016d,0xa63c0039}},	//   _ност, _ubum, täng, טגור,
   {{0x98178077,0x798a81ec,0x395f8102,0x6aaaa9db}},	//   _ابزا, _aufw, _ikus_, _beff,
   {{0x63700884,0xdb160009,0x63620187,0xe9d98eef}},	//   räng, styö, tôni, ако_,
   {{0x9f4901ec,0x7a699324,0x6aaaa9dc,0x637029dd}},	//   _spaß_, ринг_, _deff, säng,
   {{0x628300e1,0x637005ec,0x6362041c,0x6f05027d}},	//   ľnoh, mäne, rôni, _anhc,
   {{0x6d49a9de,0x2d8229df,0xbf87801c,0xeaaea9e0}},	//   mnea, _rike_, _điển_, _ой_,
   {{0xe299917c,0x1ddd80d4,0x321ea9e1,0xd5b800eb}},	//   _так_, _महात, byty_, šām_,
   {{0x6b83a9e2,0x395fa9e3,0x6d499b1f,0xad3a004a}},	//   _iing, _okus_, onea, ачає_,
   {{0x6d49954c,0x6b838f68,0x39b580eb,0x6b8ba9e4}},	//   nnea, _hing, mās_, _kugg,
   {{0x65640877,0x6f1729e5,0x6d498068,0x39b58029}},	// [1840] rlih, _foxc, inea, lās_,
   {{0x6b83a9e6,0x6b8ba9e7,0x6d498083,0xf77212c8}},	//   _jing, _mugg, hnea, _تاب_,
   {{0x63701918,0x39b58341,0x6b83a9e8,0xa3a98128}},	//   vänd, nās_, _ming, गीत_,
   {{0x6b83a9e9,0x752d29ea,0x69c1832f,0x80668081}},	//   _ling, chaz, irle, овеж,
   {{0x63700b2f,0x394d826c,0xbcfb0036,0x69c181ec}},	//   tänd, _djes_, _thér, hrle,
   {{0x6b83a9eb,0xd5ba84ad,0x39b58029,0x394da9ec}},	//   _ning, аси_, kās_, _ejes_,
   {{0x39b58341,0x637029ed,0x44200019,0x386d9403}},	//   jās_, ränd, lyi_, _ezer_,
   {{0x6d499581,0x6b83a9ee,0x39b580eb,0x6370016d}},	//   gnea, _aing, dās_, sänd,
   {{0x442029ef,0x6b83a9f0,0x25a9805c,0x73fa80ab}},	//   nyi_, _bing, ćala_, েন্ট_,
   {{0x37d000ab,0x2129111e,0xda7aa3e7,0xa3cb0ad5}},	//   িবার, _slah_, иян_, रंत_,
   {{0x39b580eb,0xaacf047d,0x9258a9f1,0x28f91b53}},	//   gās_, स्टक, сант_, бень_,
   {{0x394d0003,0x6b839546,0xe8d90028,0x6b8ba9f2}},	//   ões_, _eing, _phố_, _fugg,
   {{0xb97b812a,0x442002a0,0x2129026c,0x6b8ba9f3}},	//   ינטי, jyi_, _vlah_, _gugg,
   {{0x7d060110,0x4432009a,0x39b581a9,0xa49b07f1}},	//   _anks, dzy_, bās_, _enòl,
   {{0x2129015d,0x752d005d,0x39b580eb,0x612629f4}},	//   _tlah_, thaz, cās_, _gólo,
   {{0x6d40a9f5,0x6b83a9f6,0x212901bf,0x4add0a27}},	//   nima, _zing, _ulah_, न्नव,
   {{0x2d8c812b,0x6b83a9f7,0x44200019,0x61260118}},	// [1850] _lude_, _ying, gyi_, _móll,
   {{0x6d40a883,0x2d8c8a0f,0x74150019,0x6b83a9f8}},	//   hima, _oude_, _ہوجا, _xing,
   {{0x6d40a9f9,0x69c8a9fa,0x7c20831d,0x752d0234}},	//   kima, nude, hymr, phaz,
   {{0x6d4081e2,0xdb098013,0x7c208aa2,0x442000b4}},	//   jima, iseá, kymr, byi_,
   {{0x44320063,0x6d40a9fb,0x3d08000f,0x2d8ca9fc}},	//   czy_, dima, हारे_, _aude_,
   {{0x2d8ca9fd,0x78ad29fe,0x68fa00eb,0x3eba00ee}},	//   _bude_, _leav, ētdi, _xdpt_,
   {{0x6d408079,0x69c8a9ff,0x6b8b914e,0x6d498cb5}},	//   fima, jude, _sugg, tnea,
   {{0x6b83aa00,0x395f8024,0x39b580eb,0x6126002a}},	//   _sing, _ukus_, vās_, _cóll,
   {{0x6b83aa01,0x3eac806a,0x7f5c0216,0xb4e91d40}},	//   _ping, _fedt_, yorq, _यसै_,
   {{0x39b58029,0x49c994bc,0x27ffaa02,0x6d498c49}},	//   tās_, блон_, _irun_, snea,
   {{0x644d81e2,0x6b83aa03,0xc4cb009a,0x44322a04}},	//   _žaid, _ving, िलाओ, zzy_,
   {{0x69c18915,0x70c6016f,0xdce99487,0x39b580eb}},	//   rrle, वलेल, dmeć, rās_,
   {{0x3f85aa05,0x39b581a9,0x3f8d8980,0x7f5c1d5e}},	//   _kilu_, sās_, _jueu_, torq,
   {{0x2d9611c7,0x7d19aa06,0x69c8aa07,0x6b838010}},	//   зрас, _hows, bude, _uing,
   {{0x80ab0a49,0xe737138f,0x78bb805c,0x69d7022c}},	//   _কার্, чер_, _oduv, jtxe,
   {{0x80da00ab,0x3f85aa08,0x44322a09,0x78ad01ed}},	//   _বোর্, _lilu_, tzy_, _geav,
   {{0x75242a0a,0xc1db80d4,0x3b182a0b,0x7af50102}},	// [1860] rkiz, _बहुग, _porq_, _bazt,
   {{0x44321d21,0x6d40aa0c,0x39422a0d,0x3f85930c}},	//   rzy_, zima, liks_, _nilu_,
   {{0x27308104,0xe9da2a0e,0x44320063,0x68f62a0f}},	//   _hàng_, ске_, szy_, _kayd,
   {{0x3f8d81df,0xd910804e,0x39422a10,0x68f62a11}},	//   _bueu_, خیر_, niks_, _jayd,
   {{0x6d40aa12,0x68f619d4,0xa3cb0424,0x78a2aa13}},	//   vima, _mayd, रूद_, rbov,
   {{0x7af500ad,0x2d8caa14,0x273080ff,0x28d186a7}},	//   _gazt, _pude_, _màng_, _हाथि,
   {{0x91e32a15,0x6d40aa16,0x09e30811,0x7d1981e0}},	//   _поре, tima, _порн, _bows,
   {{0x539889b5,0xdb98a64e,0x69c88687,0x2cb201b4}},	//   овия_, ович_, vude, nayd_,
   {{0x27308028,0x7bc9aa17,0x7ae89b4a,0x63b6006f}},	//   _nàng_, gueu, tedt, nsyn,
   {{0x59d00063,0xaacc2a18,0x6d40aa19,0x798e0a8c}},	//   _हमार, ालिक, sima, _kubw,
   {{0xc4869895,0x6d40aa1a,0x68f60079,0x78ad0074}},	//   _елек, pima, _bayd, _peav,
   {{0x6f1aa817,0x68f601b4,0xa91d80c3,0x27308129}},	//   _hotc, _cayd, _ližn, _bàng_,
   {{0xc05b0196,0xb4e88074,0x27308028,0x69c8aa1b}},	//   сін_, मजी_, _càng_, sude,
   {{0x2730801c,0x7bc40084,0xdb098144,0x69c8aa1c}},	//   _dàng_, driu, breñ, pude,
   {{0x68f603bf,0x78ad1b17,0x7bc40074,0xa4d50b73}},	//   _fayd, _teav, eriu, мові,
   {{0x7bc40037,0x5ec58264,0x68f610ba,0x8d7405de}},	//   friu, ল্পে, _gayd, فاقا,
   {{0x6c5423e0,0xdcfa8029,0xc1580051,0x31ae80ab}},	// [1870] екту, _attī, _משהו_, _কমিশ,
   {{0x798e03f7,0x60dd2a1d,0x6f1a9e44,0x00000000}},	//   _bubw, lfsm, _notc, --,
   {{0xa3b906af,0x79a419a5,0xa2cf8540,0x69c80163}},	//   _घटक_, ерче, _दास्, _ådel,
   {{0x9c13819d,0x3f8584ef,0x81df0264,0x68f62a1e}},	//   _kọti, _silu_, তিল_, _xayd,
   {{0xe0d08f24,0x7bc4009f,0x7d199770,0x6d4d02f1}},	//   ازم_, criu, _rows, mnaa,
   {{0xdb1b8548,0x05b1016f,0xdce181b9,0x82371e29}},	//   truí, _जबाब, _kulħ, _فرزا,
   {{0x25a982a5,0x7d19809a,0x6d4d2a1f,0xc5d58a4c}},	//   ćalo_, _pows, onaa, філь,
   {{0x6d4d2a20,0x27ff826c,0xe8d9001c,0xa3e10072}},	//   nnaa, _trun_, _khổ_, _दहा_,
   {{0x47d58013,0x3f85aa21,0x68eb8bda,0x6ece016f}},	//   _زيار, _tilu_, megd, _तालु,
   {{0x81c200c8,0x29092a22,0x80d9800c,0x273080ff}},	//   ্বর_, _anaa_, फ्रे, _ràng_,
   {{0x68f62a23,0x13e600c8,0x39422a24,0x1dc68424}},	//   _payd, নিয়, tiks_, रूआत,
   {{0xd7d1aa25,0x254580eb,0x68f60085,0xe7d181a2}},	//   _समाच, tēlu_, _qayd, _समाप,
   {{0x636b080a,0x39422a26,0x69c501ec,0x7bc98036}},	//   tünl, riks_, hrhe, queu,
   {{0x27308028,0x68f60079,0x6d4d2a27,0x6569805f}},	//   _vàng_, _wayd, enaa, lleh,
   {{0x212d848f,0x4ac700d4,0xa91d8bcf,0x63700106}},	//   _oleh_, _लाजव, _nižo, jäna,
   {{0x6d4d2a28,0x273080ff,0xadf08074,0x798e018f}},	//   gnaa, _tàng_, _अईसन_, _rubw,
   {{0xd467067c,0x04432118,0x3b8601e8,0x6b8700f3}},	// [1880] дите_, ветн, длаг, _bijg,
   {{0x63b60aa2,0x212d8118,0xdcfd00eb,0xd7760b53}},	//   rsyn, _aleh_, _visā, _تابع,
   {{0x212d83ac,0x2eaa016f,0xfe7201a8,0x63b62a29}},	//   _bleh_, करीत, _جدة_, ssyn,
   {{0xeb9f0aa2,0x7bc413bf,0x2d5701b9,0x53a90072}},	//   _brød_, priu, għed_, _चौकश,
   {{0x69c503b2,0x6f1aaa2a,0x9f4907f1,0xd84f019d}},	//   arhe, _potc, _graó_, lọra_,
   {{0x212d80b9,0xdd9a9577,0x2d868114,0xa91d82d4}},	//   _eleh_, оши_, _sioe_, _fižo,
   {{0x66e00074,0xdce4016b,0x80cf001b,0xa3b0aa2b}},	//   ख्यक_, hlič, _थाले, टीन_,
   {{0x6ba5016d,0xdce4007a,0x9c1381bc,0xe73f041c}},	//   _åtgä, klič, _nọsi, mpõe_,
   {{0xf8639485,0x7c242a2c,0xd8d78158,0xa3a98072}},	//   _авто, nyir, _קומט_, गील_,
   {{0x61260125,0x394002be,0x7f4381e8,0xdce4016b}},	//   _fólk, _amis_, cinq, dlič,
   {{0x8e4a80f7,0x656981e0,0x28f92a2d,0xa2cf8cf0}},	//   _بلاك_, bleh, пень_, _दार्,
   {{0xf3888028,0x212d80ee,0xfd4f81bc,0x0c26802e}},	//   _lợi_, _xleh_, _mejọ, _омен,
   {{0x1bf289a3,0xdce4026f,0x60dd007b,0x28d1a0d5}},	//   _अनिल_, glič, rfsm, _हासि,
   {{0xf53f13c2,0x399383a7,0x4424809a,0x636f8aa2}},	//   _små_, _fãs_, mym_, lønn,
   {{0x1df811e9,0x4424aa2e,0x569402d3,0x6d4d2a2f}},	//   меры_, lym_, таст, tnaa,
   {{0xdce41024,0x7af8aa30,0xa91d8988,0xe8d9001c}},	//   blič, _havt, _rižo, _phổ_,
   {{0x4424aa31,0x4ea7143d,0x6d4d2a32,0x7af881c0}},	// [1890] nym_, _орна, rnaa, _kavt,
   {{0xdb1606c0,0x656081a8,0x2fc6aa33,0x2d9e806a}},	//   nsyè, homh, drog_, _otte_,
   {{0x69da8009,0x212d81f4,0x69cf8035,0x29d88866}},	//   ntte, _pleh_, ąceg, néa_,
   {{0x69da8364,0x3cfe80d4,0x7c2400b4,0xe8d900ff}},	//   itte, _शोले_, byir, _thổ_,
   {{0x7feb87bd,0x93270b76,0x68ebaa34,0x6370089c}},	//   تراف_, _قرآن, regd, männ,
   {{0x4424831d,0x7d1d0019,0x7af8aa35,0x7df38085}},	//   dym_, _hoss, _navt, _həsə,
   {{0x628301ac,0xf388801c,0x212d82d4,0x7f43811c}},	//   ľnos, _gợi_, _tleh_, rinq,
   {{0x6283105e,0x2fc6805c,0x7d1d0364,0x98a01487}},	//   žnos, brog_, _joss, _ilić_,
   {{0x7d1d2a36,0x7df38201,0x2d9e8006,0x3d048540}},	//   _moss, _məsə, _ette_, वाजे_,
   {{0x8c9f80d4,0x3f9f808e,0x7af88115,0x6569aa37}},	//   _ग्रो, _ituu_, _cavt, sleh,
   {{0xa96a18ba,0xcb1204de,0x63701af3,0x38690b8e}},	//   зина_, אלי_, känn, _ayar_,
   {{0x7d1d0003,0xfe6e803d,0xdce4007a,0x4424939f}},	//   _noss, _اگه_, tlič, bym_,
   {{0xb4278c2a,0x4424809a,0xdce40289,0x7d0b80d7}},	//   _تعاو, cym_, ulič, _ings,
   {{0xdb1b8e14,0x75298019,0x798981b0,0x8c1a825f}},	//   bruá, lkez, _liew, _מוני,
   {{0x7bdbaa38,0xdd920277,0x3d04816f,0x6146031a}},	//   ltuu, اور_, वाचे_, _пека,
   {{0x7989809a,0x7d1d2a39,0xdce41320,0x5ec10264}},	//   _niew, _coss, plič, শ্লে,
   {{0x7d1d2a3a,0x98a0190f,0x7bdba3df,0x68e42a3b}},	// [18a0] _doss, _alić_, ntuu, _ibid,
   {{0x7d0b82f7,0x3ced822c,0x425623d7,0x272b8163}},	//   _lngs, heev_, нтет, _sønn_,
   {{0x7d1d1260,0x3cfb0c28,0x3f920010,0xe8d9001c}},	//   _foss, _लोके_, _huyu_, _chỗ_,
   {{0x69c305e4,0x7bdbaa3c,0x2fc68d2f,0x59d206af}},	//   ánea, ktuu, trog_, दंबर,
   {{0x68e40135,0x7f469663,0xd43600f7,0xe73f0187}},	//   _mbid, недж, _أعجب, spõe_,
   {{0x69daaa3d,0xa8478b53,0x442484e8,0x57f38eef}},	//   ytte, علوم_, vym_, упшт,
   {{0x44248063,0x61262a3e,0x68e42a3f,0x63a42a40}},	//   wym_, _eóli, _obid, lpin,
   {{0x612603b0,0x7d1d01df,0x68e42a41,0x98a92a42}},	//   _fóli, _xoss, _nbid, _plač_,
   {{0x3946aa43,0x27340106,0x63a42a44,0x849780f7}},	//   mios_, _känd_, npin, رئيس_,
   {{0x656086be,0x39468196,0x68e42a45,0x3075aa46}},	//   somh, lios_, _abid, _русс,
   {{0xc3331dce,0x19590a14,0x2bc29244,0xfbc2aa47}},	//   רות_, даны_, _शिवा, _शिवम,
   {{0x3946aa48,0x69daaa49,0x98a900e1,0x6374823e}},	//   nios_, rtte, _tlač_, fànc,
   {{0x7d1d2a4a,0x629c00f1,0x7bdb80f3,0x628e04be}},	//   _ross, _ofro, ctuu, _ogbo,
   {{0x68e40146,0x6566008e,0x999e8019,0x254c81d0}},	//   _ebid, _akkh, sztő_, děli_,
   {{0x7d1d2a4b,0x39468110,0x7d0baa4c,0x80a21b7e}},	//   _poss, kios_, _yngs, _क्वे,
   {{0x9d180fe7,0x59c5800c,0xc4cb06b7,0x628e18b2}},	//   ност_, _वितर, िलेख, _agbo,
   {{0x39469984,0xeb93030f,0xf2c704ad,0xdb0d03a7}},	// [18b0] dios_, اظر_, есен, nsaç,
   {{0x69c882d8,0xdb0d2868,0x7989a180,0xd011804e}},	//   orde, trañ, _siew, یلا_,
   {{0xa2d88b6f,0x2004aa4d,0xa7fd8019,0x3946aa4e}},	//   _मान्, _armi_, _gyűj, fios_,
   {{0x68fd2a4f,0x3946aa50,0x69c88635,0x628e0135}},	//   ndsd, gios_, irde, _egbo,
   {{0x79898051,0x2ca91e7a,0x69c8aa51,0x80098019}},	//   _view, mbad_, hrde, براہ_,
   {{0x2d8b0264,0x2ca90bb1,0x3669a09a,0xb87b0144}},	//   _hice_, lbad_, мало_, leís,
   {{0x75298065,0x8d558729,0x7d0b826c,0xed59a45b}},	//   tkez, ктич, _pngs, мок_,
   {{0x394690dd,0x7bdb8198,0x68fd2a52,0x2ca92a53}},	//   cios_, ttuu, jdsd, nbad_,
   {{0x80a22a54,0x7529aa55,0x69c880c9,0x2d932a56}},	//   _क्षे, rkez, erde, _luxe_,
   {{0x2d8b003b,0x7bdbaa57,0x3eb32a58,0x69ca03a7}},	//   _lice_, rtuu, _next_, áfeg,
   {{0x7bdb8f1a,0x81df00c8,0x68fbaa59,0x27e904a7}},	//   stuu, তিক_, _kaud, _apan_,
   {{0x61460b9c,0x2eaa04c5,0xfeac877f,0x63748722}},	//   тема, कर्त, _iṣẹ_, tànc,
   {{0x69c89699,0x656d026f,0x20042a5a,0x68fbaa5b}},	//   arde, dlah, ími_, _maud,
   {{0x2d8b0083,0x27e900dd,0x80a20701,0x3946aa5c}},	//   _aice_, _dpan_, _क्रे, zios_,
   {{0xa3d4035a,0x63bd0186,0x2d8b2a5d,0x1659245b}},	//   सून_, _avsn, _bice_, ерть_,
   {{0x2be5959a,0x291f802e,0x68fbaa5e,0x394684c3}},	//   _कहां_, _noua_, _naud, xios_,
   {{0x3cf4881f,0xb87b07e0,0x63bbaa5f,0x3946a581}},	// [18c0] ्यते_, rfíc, nsun, vios_,
   {{0x63a42a60,0x6f1e02ce,0x5fb70039,0x81e480ab}},	//   rpin, _uopc, _שהיא_, নির_,
   {{0x39468511,0x63a42a61,0x68fb9482,0x2d8b0041}},	//   tios_, spin, _baud, _fice_,
   {{0x63a42a62,0x3eb81be3,0xd5b80029,0xc7c69d79}},	//   ppin, lart_, šās_, вски,
   {{0x3946aa63,0x68fbaa64,0x291f8012,0x2d802a65}},	//   rios_, _daud, _doua_, mmie_,
   {{0x394681e2,0x63bbaa66,0xfaa31957,0x2d8b0087}},	//   sios_, dsun, _варо, _zice_,
   {{0x39469f5c,0x41aa0221,0x68fb80e7,0x7afc0af6}},	//   pios_, _іван_, _faud, _iart,
   {{0x7afc2a67,0x29dc040e,0x68fbaa68,0x3eb80046}},	//   _hart, mía_, _gaud, hart_,
   {{0x29dc2868,0x63bbaa69,0x06b800ab,0x3eb82a6a}},	//   lía_, gsun, _জানি, kart_,
   {{0x68fbaa6b,0x7afc0102,0x77638118,0xc1808135}},	//   _zaud, _jart, conx, _ịghọ,
   {{0x27e901b0,0x29dc040e,0x69c880c9,0x7c3a0201}},	//   _span_, nía_, urde, _ətra,
   {{0xdca6902f,0x7afc020f,0xf8bf0019,0x64a69957}},	//   _ради, _lart, mkék_, _рада,
   {{0xb8eb0076,0xdb04040e,0xb4ae9d7c,0x29dc2a6c}},	//   _लय_, nsió, करी_, hía_,
   {{0x0ccb0b85,0xcf9380be,0x63a282b8,0x3eb82a6d}},	//   िल्म, יטש_, _iton, gart_,
   {{0xd5b80be1,0x80d3800f,0x29dc01ca,0xb8d90264}},	//   кст_, _डाले, jía_, _চা_,
   {{0x29dc02ba,0xa3e6816f,0xdb1b8073,0x7afc2a6e}},	//   día_, _पहा_, truç, _aart,
   {{0x3eb32a6f,0x3eb80502,0x5c750b01,0x656d0057}},	// [18d0] _text_, bart_, улат, rlah,
   {{0x29dc040e,0x7afc2a70,0xe4e281c4,0x69de1c33}},	//   fía_, _cart, क्ति_, ftpe,
   {{0x9a872a71,0x29dc0c15,0x2d8b0025,0xaca301bc}},	//   туал, gía_, _tice_, _alụb,
   {{0x63a2aa72,0x59c59834,0x7afc167c,0x23c2825a}},	//   _oton, _विसर, _eart, _शिंद,
   {{0xb8db8424,0x3f8c81b9,0x69dc2a73,0x63a28542}},	//   _आज_, _bidu_, _eqre, _nton,
   {{0x7afc2a74,0x29dc040e,0x44292a75,0x543a00be}},	//   _gart, bía_, mya_, _טערא,
   {{0x29dc040e,0x63a2aa76,0x74d78035,0x02af2076}},	//   cía_, _aton, _यादृ, टरीन,
   {{0x7afc2a77,0x7bc9aa78,0x16b00105,0x752d01f6}},	//   _zart, treu, _जज्ब, nkaz,
   {{0xa855a796,0x7bc980e7,0x0ed300d4,0xbab581bb}},	//   _скач, ureu, _तांड, лёны,
   {{0x63bbaa79,0x89a9891c,0x386daa7a,0x7bc9aa7b}},	//   rsun, нков_, _iyer_, rreu,
   {{0x63bbaa7c,0x44292a7d,0x3eb82a7e,0x63a2aa7f}},	//   ssun, hya_, vart_, _eton,
   {{0x7fd605e9,0x44292a80,0x7bc9802e,0x798d02f7}},	//   лігі, kya_, preu, _ciaw,
   {{0xa2e587b6,0x59c594a7,0x6721aa81,0x44290578}},	//   _болд, _विवर, _kolj, jya_,
   {{0x3cfd81c0,0x7d1baa82,0x6d49aa83,0xa03a83de}},	//   _hawv_, ljus, liea, געשפ,
   {{0xceb29a0f,0xa2d88913,0x29dc07f4,0x3cfd81c0}},	//   מים_, _मात्, xía_, _kawv_,
   {{0x7afc2a84,0xb4ce2a85,0x29dc040e,0xb4c00c33}},	//   _sart, रले_, vía_, ीले_,
   {{0x7c29aa86,0x7c3baa87,0x44292a88,0x3eb81a1f}},	// [18e0] nyer, nzur, gya_, part_,
   {{0x57fb0051,0x3cfd90af,0x7d1b8006,0x7afc00f1}},	//   _טלפו, _lawv_, hjus, _qart,
   {{0x7afc0b71,0x386d85b4,0xf77200d5,0xdce28743}},	//   _vart, _ayer_, _پاک_, _skoč,
   {{0x29dc161b,0x7afc2a89,0x44292a8a,0x3cfd8069}},	//   ría_, _wart, bya_, _nawv_,
   {{0x7afc2a8b,0x6d460182,0x29dc02ba,0x23658042}},	//   _tart, _imka, sía_, kolj_,
   {{0xa2d88fe4,0xdb04160a,0x29dc2a8c,0x78b60216}},	//   _माध्, rsió, pía_, _leyv,
   {{0xf41f825d,0x7afeaa63,0x672180ce,0x3d8a8198}},	//   ään_, _ópti, _dolj, нщин_,
   {{0xb4ae89a3,0x60c42a8d,0x3cfd8069,0x80d6016f}},	//   करे_, _ndim, _cawv_, _भाषे,
   {{0x7c299fce,0x3cfd81c0,0x6721a909,0x14d5866b}},	//   gyer, _dawv_, _folj, _धारण,
   {{0xa3b585b3,0xef83867c,0x60c42a8e,0x2365911b}},	//   _जबर_, _глуп, _adim, golj_,
   {{0xe6938307,0x6e938013,0x5e938013,0x41551016}},	//   _المد, _الما, _المط, ивос,
   {{0x44292778,0x3cfd81c0,0x7c29a42d,0x67218267}},	//   yya_, _gawv_, byer, _zolj,
   {{0x63a2aa8f,0x752d2a90,0x69c090be,0x386d0366}},	//   _uton, vkaz, _विकी, æer_,
   {{0x88bd809a,0x7bfb8039,0x7dea8085,0x4429004f}},	//   _kośc, _נפוצ, _təsd, vya_,
   {{0x2bc71834,0x4429010c,0xd2b783c8,0x6aba9a20}},	//   _लिहा, wya_, _גלות_, matf,
   {{0x44292a91,0x7982809a,0x06c600ab,0x752d01d6}},	//   tya_, jmow, শ্লি, ukaz,
   {{0x752281c0,0x44290176,0xdb04002a,0x394b2a92}},	// [18f0] _mooz, uya_, esiñ, mics_,
   {{0xd25b0ab2,0x44292a93,0x394b2a94,0x752d0010}},	//   нце_, rya_, lics_, skaz,
   {{0x3207026f,0xeb9f0edd,0xdb580009,0x7c3b81e8}},	//   íny_, _grøn_, уют_, zzur,
   {{0x20092914,0xb4ae83ca,0x394b2a95,0x7c3b8035}},	//   _krai_, करो_, nics_, yzur,
   {{0xe8d90028,0x06b800ab,0xb9658032,0x3cfd8282}},	//   _chứ_, _জাতি, _adìé, _rawv_,
   {{0x3cfd81e9,0x92940048,0x8cad01d0,0x394b1e44}},	//   _sawv_, _гарц, जरको, hics_,
   {{0x23658353,0x3cfd81c0,0x7bcd008b,0x61ed8b80}},	//   volj_, _pawv_, lrau, _ćalo,
   {{0x20090110,0x7c29aa96,0x7c3baa97,0xf8b986ae}},	//   _orai_, tyer, tzur, _उजिय,
   {{0x75ec0065,0xa3cb0540,0x36d5aa98,0x394b2a99}},	//   _közö, रंट_, _возр, dics_,
   {{0xff538013,0xef678098,0x81e800ab,0x7c298d18}},	//   _اخر_, _събо, বির_, ryer,
   {{0x394b2a9a,0x88bd809a,0xb0b983eb,0x7bcd232a}},	//   fics_, _gośc, _उजाग, hrau,
   {{0x637000f2,0x291d9ae4,0x394b0722,0x7bcd2a9b}},	//   tänk, njwa_, gics_, krau,
   {{0xa0760071,0x273989c4,0x23658b80,0xe7b389ab}},	//   рынш, _cèng_, polj_, _ƙaƙƙ,
   {{0xfaa59abe,0x82a58364,0x7bcd2a9c,0x20092a9d}},	//   _тако, _такж, drau, _drai_,
   {{0x29560698,0x63a9aa9e,0x99d700ab,0x28a721e3}},	//   _въпр, lpen, সবুক, _क्वि,
   {{0xf3888104,0x27edaa9f,0x63a9aaa0,0x2d8f82d6}},	//   _hợp_, _open_, open, _jige_,
   {{0x63a9aaa1,0x2912019d,0x7bcd2aa2,0x290012d0}},	// [1900] npen, _inya_, grau, _iaia_,
   {{0x2d8faaa3,0x60dbaaa4,0x29122aa5,0x68e9aaa6}},	//   _lige_, _acum, _hnya_, _abed,
   {{0xa2d880d4,0xe9da0604,0x80a68c2a,0xaadd858c}},	//   _मास्, тке_, لمان, _मानक,
   {{0x7bcd2aa7,0xa3e68bb8,0x3be586a7,0xdb04002a}},	//   brau, _पहल_, _कहूँ_, rsiñ,
   {{0xdefa8364,0x7982809a,0x7600aaa8,0xbcfb0091}},	//   вый_, rmow, kázá, _akéw,
   {{0x2d8f8ad0,0xd00f9a37,0x29002aa9,0xe80703eb}},	//   _aige_, بله_, _laia_, शिता_,
   {{0x636b05c5,0xd5b794ef,0x6d560079,0x2d8faaaa}},	//   rünt, асы_, onya, _bige_,
   {{0xe8d90028,0x6d562aab,0xa3ea0327,0x29002aac}},	//   _thứ_, nnya, _महा_, _naia_,
   {{0x8fa39383,0x61e90024,0x63a9aaad,0x2d8f8326}},	//   _мате, _ćeli, gpen, _dige_,
   {{0x29120a2c,0x8ca680d4,0x29020079,0x320a016b}},	//   _anya_, _ट्रो, edka_, _krby_,
   {{0x2bc29199,0x6d562aae,0x29002aaf,0x7522826c}},	//   _शिका, knya, _baia_, _tooz,
   {{0x38c9026a,0xdd8f806b,0x29002ab0,0x5fba86a7}},	//   دادی_, _قول_, _caia_, _उबाल,
   {{0xc05b0163,0xe53b8051,0x2006aab1,0x2912008e}},	//   тін_, _בתאר, nvoi_, _dnya_,
   {{0x28a70aed,0x29122ab2,0x394b2ab3,0x200902be}},	//   _क्रि, _enya_, sics_, _vrai_,
   {{0x68ff2ab4,0x68930077,0x3cdd864a,0x29002ab5}},	//   _taqd, _ویدئ, क्के_, _faia_,
   {{0x7bcd2ab6,0x20090028,0x29000102,0xc0cb0178}},	//   trau, _trai_, _gaia_, _руке_,
   {{0x39490025,0xe4f9aab7,0x3cde8035,0x44980198}},	// [1910] _imas_, ्यति_, _गाने_, рвую_,
   {{0x27340006,0x6d562ab8,0x60db8087,0xfaa70196}},	//   _täna_, anya, _scum, ршан,
   {{0x81e480ab,0xa3cb11bc,0xa2dd125f,0x63a98102}},	//   নিক_, रूज_, _पाठ्, zpen,
   {{0x2912008e,0x27398036,0x637daab9,0x21248427}},	//   _xnya_, _mène_, mène, _comh_,
   {{0x838711e9,0x2d8faaba,0x98e481a8,0x21248427}},	//   _выве, _rige_, تكنو, _domh_,
   {{0x2d8faabb,0x394901c0,0x7bc0874d,0x2d84862c}},	//   _sige_, _lmas_, dsmu, emme_,
   {{0x80c200c8,0x2cadaabc,0x78bd2abd,0x2d8f806a}},	//   ষ্ট্, tbed_, kasv, _pige_,
   {{0x2608035a,0x28a70a3a,0x68e982ee,0x58d48f27}},	//   हिती_, _क्लि, _ubed, _мост,
   {{0x7c2d2abe,0x40349ccf,0xe29982df,0x2cadaabf}},	//   nyar, _детс, лап_, rbed_,
   {{0x7de7835f,0x39492ac0,0xf5e780e8,0x29002ac1}},	//   _відд, _amas_, _відм, _saia_,
   {{0xa2d8aac2,0xe8d90028,0x291209da,0x7c2d2ac3}},	//   _मार्, _chữ_, _pnya_, hyar,
   {{0x637005ec,0x3cde86a7,0x6d9581d6,0x049581a8}},	//   räni, _गाये_, _všad, _الإح,
   {{0x290001df,0x6c8580f7,0xdced082c,0x7c2d0314}},	//   _vaia_, _الشم, jmađ, jyar,
   {{0x3949059c,0x442daac4,0xdced011c,0x6d50866f}},	//   _emas_, mye_, tmağ, ądał,
   {{0x442daac5,0xe5a60628,0x6f01aac6,0x29120359}},	//   lye_, сиби, _malc, _tnya_,
   {{0x6d4d16d5,0xdced2ac7,0x29122ac8,0xe0da04ae}},	//   giaa, rmağ, _unya_, _сви_,
   {{0x442daac9,0x7c2d0065,0x443faaca,0xec7a16d9}},	// [1920] nye_, gyar, nzu_, упа_,
   {{0xa2dd1f64,0x8a3a0009,0x7c248014,0x5fd18072}},	//   _पाण्, ляет_, _àire, _समजल,
   {{0xb4f981ab,0xd9108077,0xdce400ce,0x442d8168}},	//   ्याय_, ویس_, jlić, hye_,
   {{0x7c2d29b3,0x6d4d0a0f,0x442daacb,0x69c1aacc}},	//   byar, ciaa, kye_, isle,
   {{0xa2d8908a,0x572509a7,0x291283bf,0x442d8c97}},	//   _माल्, _طریق, ıya_, jye_,
   {{0x7d04103d,0x443f80eb,0x442daacd,0x290088fc}},	//   ldis, dzu_, dye_, žia_,
   {{0xe7f48b85,0xa2dd09c2,0xa3d40540,0x9c13819d}},	//   _इनका_, _पात्, सूर_, _gọzi,
   {{0x7d042ace,0xc0e39d51,0x442d8247,0x7bc68110}},	//   ndis, _носк, fye_, škum,
   {{0x442daacf,0x7d042ad0,0x78a2816b,0x6f01aad1}},	//   gye_, idis, mcov, _falc,
   {{0xdced012b,0x7d040009,0x78a2816b,0xd6d28bbe}},	//   vlač, hdis, lcov, _رقص_,
   {{0x69c1a10f,0x9952001b,0x442daad2,0x78bd2ad3}},	//   gsle, lář_, aye_, tasv,
   {{0x78a2803e,0x442da0d7,0xd25786b5,0x753b8010}},	//   ncov, bye_, сць_, chuz,
   {{0x7d042ad4,0x67250364,0xc8671194,0x506711b1}},	//   ddis, _pohj, стни, стна,
   {{0x6d5a2ad5,0x7bd62ad6,0xd6d80a42,0xa85781c6}},	//   étan, duyu, йтс_, מיכה_,
   {{0xdced0289,0x6d4d2ad7,0x80d88f3d,0x9577003d}},	//   slač, tiaa, डलाइ, مدرض,
   {{0x2d9a2ad8,0xdced0353,0x394903a7,0x7d042ad9}},	//   _dupe_, plač, _umas_, gdis,
   {{0xac18210d,0x241813cd,0x6d4d2ada,0xa3d40c28}},	// [1930] боту_, боты_, riaa, सूल_,
   {{0x6d4d2adb,0x70d18105,0x7c2d2adc,0x7d02aadd}},	//   siaa, हल्ल, ryar, _laos,
   {{0x7c2d059c,0x637d809f,0x442d83ec,0x4c9520da}},	//   syar, lènc, zye_, _минс,
   {{0x27308104,0x26de82ba,0x442daade,0x7bd6008e}},	//   _hành_, _acto_, yye_, buyu,
   {{0x68ed2957,0xe8d901bc,0x675402e3,0x81e480ab}},	//   _mbad, _ajị_, _ذخیر, নিট_,
   {{0x7a3f8065,0xe7368e17,0x442daadf,0xf6500065}},	//   _játé, жеш_, vye_, _آئی_,
   {{0xf7708077,0x68ed2ae0,0x6f01aae1,0x78a283f2}},	//   راه_, _obad, _valc, bcov,
   {{0x442d8247,0x443f8102,0xa159a17e,0x273080ff}},	//   tye_, tzu_, _табу_, _lành_,
   {{0x63ad2ae2,0x60c9811f,0x4ad4835a,0xe8d92ae3}},	//   npan, _idem, _दाखव, _ejị_,
   {{0x443faae4,0xa1c58676,0x68ed2ae5,0x442daae6}},	//   rzu_, обод, _abad, rye_,
   {{0x442daae7,0x2d5701cd,0x63ad008e,0x5f1d1a46}},	//   sye_, għek_, hpan, मान्_,
   {{0xa3ea09f2,0x63ad2ae8,0x69c18e1c,0x3eba2ae9}},	//   _महल_, kpan, rsle, _sept_,
   {{0x41c583b7,0x637d8722,0x3cde80d4,0x6d4b8197}},	//   _विकस, gènc, _गाते_, _imga,
   {{0x69c380eb,0x2cbfaaea,0x2a8e8085,0x6d5d01a1}},	//   _tvne, laud_, bəb_, _ajsa,
   {{0x27308028,0x7d041849,0x78bb80e7,0x6da3197b}},	//   _dành_, tdis, _oeuv, диса,
   {{0x78bbaaeb,0x2fcd0353,0x0d9917ae,0x95990a95}},	//   _neuv, šega_, стры_, стру_,
   {{0xccf2836b,0x637d809f,0x63ad1341,0x78a2816b}},	// [1940] וכן_, cènc, gpan, vcov,
   {{0x60c9960a,0x91eda0d8,0x7bd6080a,0x20000870}},	//   _adem, _जहाज_, ruyu, _isii_,
   {{0x6d4baaec,0xe1fa2aed,0x63ad01a8,0x48e10054}},	//   _omga, рге_, apan, _कामो_,
   {{0x7d0402c1,0xa50a1878,0x1d0a2aee,0x200daaef}},	//   qdis, _тема_, _теми_, _brei_,
   {{0x78a2aaf0,0x200d991f,0x60c9aaf1,0x3860811c}},	//   rcov, _crei_, _ddem, çir_,
   {{0x60c9aaf2,0x200d82af,0x7d02aaf3,0x78a2aaf4}},	//   _edem, _drei_, _saos, scov,
   {{0xa3dc825a,0x64490125,0x3f4d026c,0x27ff846d}},	//   तून_, _þeir, džul_, _esun_,
   {{0x200d81ec,0x6374823e,0x7bc40084,0x64408799}},	//   _frei_, màni, osiu, tzmi,
   {{0x81bc0a49,0x7bc42af5,0x741480f7,0x6440812b}},	//   _আমি_, nsiu, سودا, uzmi,
   {{0x290490fe,0x799c02a0,0x637d8722,0x6d4baaf6}},	//   _hama_, _kurw, vènc, _emga,
   {{0x2904aaf7,0x81e800ab,0x13b300ab,0x6abc0197}},	//   _kama_, বিক_, টওয়, _merf,
   {{0x290483c3,0x09cf00c8,0xe8d90028,0x2906aaf8}},	//   _jama_, _রহমা, _thử_, ndoa_,
   {{0x644080b9,0x6abc2af9,0x81b700fc,0x6370062c}},	//   qzmi, _oerf, ɓɓuk, näns,
   {{0x2904a9a9,0x637d87e2,0x6abc2afa,0x26dc8048}},	//   _lama_, rènc, _nerf, ngvo_,
   {{0x56940a7c,0xe8d9001c,0x637d809f,0xdcbb2296}},	//   дарт, _chợ_, sènc, ища_,
   {{0x5c992afb,0xa3ae8b75,0x27e6aafc,0x68ed13e3}},	//   ская_, _ओझा_, kton_, _ubad,
   {{0x6abc103c,0x6370016d,0x63ad2afd,0xdfdb0098}},	// [1950] _berf, jäns, upan, _тъй_,
   {{0xc7b22afe,0xd3711b9a,0x63ad2aff,0xb2ab096b}},	//   _רבי_, رها_, rpan, ртаж_,
   {{0x6abc0a38,0x78bb82be,0x2904ab00,0x63701a50}},	//   _derf, _peuv, _bama_, vänt,
   {{0x7af72b01,0x2904a827,0x61e52b02,0x644004b7}},	//   sext, _cama_, rthl, _żmie,
   {{0x290480a4,0x01e080c8,0xd009802e,0x251a04de}},	//   _dama_, ববিদ, селе_, _הורא,
   {{0x200d802e,0xe3b200be,0x69d703a8,0x27398176}},	//   _vrei_, _אױך_, puxe, _bèna_,
   {{0x27e6825d,0x67288025,0x2904ab03,0x09af80ab}},	//   aton_, _dodj, _fama_, _কিভা,
   {{0x2904ab04,0x200d802e,0x2ee12417,0x6b9d2b05}},	//   _gama_, _trei_, _lchf_, _kusg,
   {{0xdb1b841c,0x27ff83db,0x1c0e01a2,0x4ea78162}},	//   ssuí, _usun_, सियल_, _дреа,
   {{0x290483c3,0x4a45a7cb,0x6b9d2b06,0x466b8878}},	//   _zama_, знов, _musg, _крем_,
   {{0xe8038c78,0xc86900be,0x69c52b07,0x2904ab08}},	//   लिका_, _ען_, nshe, _yama_,
   {{0x6723ab09,0x7dea8085,0x21290144,0x6d4bab0a}},	//   ljnj, _məsl, _coah_, _umga,
   {{0x88bd809a,0x200f1520,0x246483ed,0x69c52b0b}},	//   _rośl, _ágil_, rëmë_, hshe,
   {{0x69c702ce,0x395f816d,0x26080072,0x2904026c}},	//   _ovje, _ljus_, हिली_, žma_,
   {{0x6b9d0352,0x69c52b0c,0x6b402b0d,0x7dea829a}},	//   _ausg, jshe, _högg, _nəsl,
   {{0xe9a89b9a,0x6d5bab0e,0x2bc713ba,0xc4d60072}},	//   _بدون_, nnua, _लिखा, धलेख,
   {{0x2904ab0f,0x42ca01e5,0x2ef82b10,0xf99301c6}},	// [1960] _rama_, йган_, perf_, _ארה_,
   {{0x799c2b11,0x7bc42462,0x63748722,0x1ddb8424}},	//   _purw, rsiu, tàni, _यमंत,
   {{0xa2dd2b12,0x6abc2b13,0x4ae2035a,0x67288067}},	//   _पार्, _verf, _पाठव, _rodj,
   {{0x2367173d,0x69c7111b,0x0edc001b,0x27e6ab14}},	//   čnja_, _dvje, _बाँड, tton_,
   {{0x67288f28,0x2904803a,0x2906ab15,0x6abc208d}},	//   _podj, _vama_, rdoa_, _terf,
   {{0x395f86c4,0x63701743,0x2904ab16,0x7d062b17}},	//   _ejus_, räns, _wama_, _haks,
   {{0x2904ab18,0x7d062b19,0x27e6ab1a,0x6728a76e}},	//   _tama_, _kaks, ston_, _vodj,
   {{0x7d062b1b,0x06c600ab,0x27e6ab1c,0x75242b1d}},	//   _jaks, শ্চি, pton_, njiz,
   {{0x7d062b1e,0x69c72b1f,0x0edc047d,0x64440365}},	//   _maks, _zvje, _बांड, nzii,
   {{0x3cde8e18,0x883b8039,0xbec280eb,0x44200722}},	//   _गावे_, _התמו, šība, ixi_,
   {{0x76438063,0x75240590,0x58d512b2,0x26cc831d}},	//   czny, kjiz, монт, _iddo_,
   {{0xf487819f,0x60c2804f,0x3ebea67f,0x44320198}},	//   _کامی, naom, _hett_, kyy_,
   {{0xfc3f2b20,0xa2dd1664,0xfc2fa0bb,0x798409c4}},	//   _afín_, _पाल्, _محو_, _dhiw,
   {{0x3da704fa,0x7d0600e4,0x2d9e8129,0x44200118}},	//   зраб, _aaks, _kute_, dxi_,
   {{0x7afaab21,0x249900b9,0x2d9eab22,0x3ebeab23}},	//   mett, _pgsm_, _jute_, _mett_,
   {{0x3ebeab24,0x69da9c61,0xb4c9000d,0xb4d7024c}},	//   _lett_, mute, ैले_, सले_,
   {{0x69c7030b,0x60cd2b25,0x69daab26,0x2d8909c4}},	// [1970] _svje, _idam, lute, rmae_,
   {{0x7afaab27,0x69c5029b,0x2bd49094,0x394d822b}},	//   nett, tshe, _दिना, _smes_,
   {{0x26c3007a,0x6d40ab28,0x6aa52b29,0x7afa847f}},	//   majo_, khma, rchf, iett,
   {{0x69c52b2a,0x7afaab2b,0x26c3007a,0xac192b2c}},	//   rshe, hett, lajo_, _дому_,
   {{0x4addab2d,0x7afaa9a4,0x69c52b2e,0xb4db0091}},	//   _मालव, kett, sshe, _alàg,
   {{0x69daab2f,0x2d9eab30,0x26c32b31,0x7afaa452}},	//   kute, _bute_, najo_, jett,
   {{0x69c7030b,0x69daab32,0x41778416,0x7afaab33}},	//   _uvje, jute, _فارس, dett,
   {{0x2d9e80ad,0x69daab34,0x60cd2b35,0xbe3c01c6}},	//   _dute_, dute, _ndam, מעות,
   {{0x7afa81dc,0xb4ad901c,0x387fab36,0x6d5b8102}},	//   fett, _कभी_, _uzur_, rnua,
   {{0x60cd2b37,0x7afaab38,0x6fd2800f,0x26c30db7}},	//   _adam, gett, _सितं, jajo_,
   {{0x2d9e9b36,0x26c30353,0x69daab39,0x7764823e}},	//   _gute_, dajo_, gute, éixe,
   {{0x6d4082af,0x2734016d,0x604301bc,0x7e7eab3a}},	//   chma, _tänk_, _ọmaj, üppe,
   {{0x7d060341,0x442004b7,0x6b40016d,0x7afaab3b}},	//   _raks, xxi_, _höge, bett,
   {{0x7afaab3c,0xdb0b816d,0x6d4f2b3d,0x26c3007a}},	//   cett, _avgö, _amca, gajo_,
   {{0x7d062b3e,0x2d962b3f,0x2d9e02be,0x7d09ab40}},	//   _paks, драс, ête_, odes,
   {{0x44200102,0xe3ba20bf,0x44320198,0x2bd495bc}},	//   txi_, жба_, tyy_, _दिमा,
   {{0x26c31220,0x7dea8201,0x7d06021e,0x73060084}},	// [1980] bajo_, _rəsm, _vaks, мпаз,
   {{0x7d098009,0x5fd306a7,0x753d0061,0x60c2804f}},	//   hdes, _तितल, _elsz, waom,
   {{0x7d062b41,0x00e6835f,0xf1a50558,0x3ebe821e}},	//   _taks, джен, ерін, _rett_,
   {{0x2d9ea36a,0x3ebe8558,0x7d09ab42,0x3cf98035}},	//   _rute_, _sett_, jdes, ्यों_,
   {{0x2d9e8c7b,0x69daab43,0x7afaab44,0x8fa38cf3}},	//   _sute_, zute, yett, ваче,
   {{0x69daab45,0xeb9f0bc5,0x437500e8,0xb86587c3}},	//   yute, _prøv_, _зуст, رانو,
   {{0x7afaab46,0x629c01dd,0x7d09874c,0x8a031285}},	//   vett, _igro, fdes, _изре,
   {{0x7afaab47,0xdc8e81bc,0x7d09ab48,0x490686a7}},	//   wett, _dịnụ_, gdes, _सोचो_,
   {{0x7afaab49,0x671e89a3,0x3ebeab4a,0x63a42b4b}},	//   tett, पादक_, _tett_, nqin,
   {{0x60c0ab4c,0x48e10076,0xf7729ddd,0x6d40ab4d}},	//   _hemm, _काहो_, _شاء_, shma,
   {{0x7afaab4e,0x60c082a6,0x7d09ab4f,0x26c30353}},	//   rett, _kemm, bdes, vajo_,
   {{0x92be80c8,0x69daab50,0x60c0822b,0x914b0d8e}},	//   ইলে_, rute, _jemm, ічна_,
   {{0xb9072b51,0x7afaab52,0x629c2b53,0x60c0ab54}},	//   _पा_, pett, _ogro, _memm,
   {{0x69daab55,0x60c0ab56,0xb8d60beb,0xdce98503}},	//   pute, _lemm, _च्_, tleć,
   {{0xe5c41285,0x26c32b57,0x2d86801c,0xf2068098}},	//   ксто, rajo_, _khoe_, _цяло,
   {{0x60c0ab58,0x9d180081,0xab5d8035,0xd7fb2b59}},	//   _nemm, мост_, duży, _дуо_,
   {{0xdce982a5,0x63adab5a,0x2139008e,0x21268da8}},	// [1990] sleć, _çant, mksh_, djoh_,
   {{0x32110063,0x68fd2b5b,0xdb098187,0x629c0362}},	//   _przy_, lesd, mpeã, _cgro,
   {{0xe8d90104,0xe8070c78,0xd25b0746,0x7d098009}},	//   _chủ_, शिका_, цца_, ydes,
   {{0xa2d8853e,0x6562820f,0x60c0ab5c,0x290b0162}},	//   _माझ्, _njoh, _cemm, ndca_,
   {{0x7ac7013a,0x60c0ab5d,0xdce40214,0x6f08810c}},	//   _осве, _demm, lliğ, _badc,
   {{0x26c10775,0xaadd8996,0xdc1480c8,0x6d9101ac}},	//   _jeho_, _माइक, িহাস_, _sťah,
   {{0x60c0ab5e,0x58d58293,0x3d108105,0x2d992b5f}},	//   _femm, _повт, _दोहे_, _kise_,
   {{0x60c0ab60,0x69c8ab61,0x28db2b62,0x7d098198}},	//   _gemm, dsde, _भागि, udes,
   {{0x2d992b63,0x47d58013,0x7d09ab64,0x6d5a02be}},	//   _mise_, _سيار, rdes, étai,
   {{0x4225838b,0x26c100e1,0x2d992b65,0xdce402d0}},	//   едов, _neho_, _lise_, kliğ,
   {{0x78a4a354,0x4ae21391,0x9f8a8009,0x443980eb}},	//   žive, _पासव, töön_, šs_,
   {{0x2d992b66,0x68fd2b67,0x186a0956,0xa06a02ee}},	//   _nise_, gesd, зами_, зама_,
   {{0x2d8dab68,0x26c102c4,0x98a481a9,0x66052b69}},	//   mmee_, _beho_, _jomā_, _ashk,
   {{0xa3578077,0x613a823e,0x2d992b6a,0xa3d401d0}},	//   _تخصص, _aïll, _aise_, संघ_,
   {{0xe6170554,0xf53f0370,0xa3e2123a,0x2d992b6b}},	//   ндр_, _blå_, नून_, _bise_,
   {{0x6283803a,0x68e42b6c,0x6d95811f,0x2d99117d}},	//   _izno, _ucid, _ošam, _cise_,
   {{0x4ad384e5,0x2d992b6d,0xe7da80c8,0x7bc9ab6e}},	// [19a0] _दयाव, _dise_, _ধন্য, nseu,
   {{0x60c0ab6f,0x394001c5,0xe8d9001c,0xd83f05b9}},	//   _semm, _hlis_, _phủ_, íček_,
   {{0xdebb010f,0x53368158,0xda1f8ebf,0x60c0808e}},	//   _ממיל, ענען_, यमित_, _pemm,
   {{0xe1ff809a,0xeb9a2b70,0x5976803d,0x7bd58035}},	//   łów_, _ним_, رداز, ązuj,
   {{0x6d562b71,0x7bcfab72,0x63a4011c,0xed50803d}},	//   miya, ácul, qqin, یپت_,
   {{0x6d562b73,0x629c003b,0xe8d92b74,0x9e068087}},	//   liya, _ugro, _thủ_, ечил,
   {{0x7bcbab75,0xe3630f2e,0xceb30051,0x60c0ab76}},	//   _avgu, _скри, ניה_, _temm,
   {{0xe2970bac,0x6d562b77,0x60c62b78,0x6d442b79}},	//   _час_, niya, jakm, nhia,
   {{0xe3af84c0,0x60c609da,0x69de2b7a,0xdce402d0}},	//   یری_, dakm, lupe, zliğ,
   {{0x6d562b7b,0xfd1f0028,0x39402b7c,0x3f9a0573}},	//   hiya, _nhìn_, _alis_, _nipu_,
   {{0x6d562b7d,0x6d440590,0x4dd6ab7e,0x68fd2b7f}},	//   kiya, khia, _ستاس, tesd,
   {{0xfc668098,0x6d562b80,0x88bd809a,0x68e2ab81}},	//   _пълн, jiya, _dośw, ngod,
   {{0x6d562b82,0x54338154,0xb4bc801b,0x557780be}},	//   diya, _مرور, अरी_, _װעגן_,
   {{0x2d992b83,0xb9c68013,0xae0d0076,0xa3ea01ce}},	//   _sise_, _كتبه, हिलन_, _महज_,
   {{0x2d990052,0x63a2ab84,0xe8d90a2c,0x6d562b85}},	//   _pise_, _huon, _ahụ_, fiya,
   {{0x63a280f6,0x6d562b86,0x6d4414ed,0xdce40214}},	//   _kuon, giya, ghia, rliğ,
   {{0x2ca901b4,0x63a28198,0x26c12b87,0x656094f2}},	// [19b0] rcad_, _juon, _teho_, inmh,
   {{0xaa671519,0x63a2ab88,0x5f950eef,0x3a2b027d}},	//   нтек, _muon, _шипт, _đểđă,
   {{0x6d562b89,0x63a2ab8a,0xda6700f7,0xcad781c6}},	//   biya, _luon, رائي, תובת_,
   {{0x6d442b8b,0xa2dd0f8d,0x6d561cee,0x637d8247}},	//   chia, _पाक्, ciya, vènm,
   {{0x7c8418f6,0x63a2965a,0xdee5951a,0x7d0d008b}},	//   _буре, _nuon, воли, mdas,
   {{0x98a90267,0xbec280eb,0x7d0d2b8c,0x68e28118}},	//   _mlađ_, šīna, ldas, agod,
   {{0xae14023c,0x7bdf0388,0xc1790110,0x7764802a}},	//   डियन_, luqu, ntės_, éixa,
   {{0x63a2ab8d,0x7d0d2b8e,0x2734016d,0xacbb00e7}},	//   _buon, ndas, _hänt_, _goût,
   {{0x2d8d8b3c,0x27340106,0x6b400106,0x63a280ff}},	//   rmee_, _känt_, _höga, _cuon,
   {{0x6d562b8f,0x7bc9ab90,0x63a2ab91,0x78ad0722}},	//   ziya, rseu, _duon, _afav,
   {{0x216a2061,0xa96a18b0,0xd9460b01,0x7bc9ab92}},	//   дини_, дина_, вени, sseu,
   {{0x26c7ab93,0x7afe1919,0x8fa62b94,0x6d562b95}},	//   lano_, zept, каме, xiya,
   {{0xeb8ea64c,0xf9928158,0x7d0d2b96,0xa3a8835a}},	//   _ви_, ירט_, ddas, _खूप_,
   {{0x26c7ab97,0x7529a3e3,0x41d120f2,0x9a15ab98}},	//   nano_, ljez, _हिंस, _афиш,
   {{0x6d562b99,0x6d44031d,0xb87b0020,0x65c32b9a}},	//   tiya, thia, rgía, ибра,
   {{0xe8d90028,0x26c7ab9b,0x7d0d2b9c,0xb4dc2a85}},	//   _phụ_, hano_, gdas, ठले_,
   {{0x26c78f45,0x7d0b849f,0x7afe002e,0x644982af}},	// [19c0] kano_, _mags, tept, nzei,
   {{0x6d4401c5,0x6d562b9d,0x60c40357,0x7c2680f2}},	//   shia, siya, _heim, äkri,
   {{0xb6d90158,0x60c41203,0x7dea8085,0x3ed900be}},	//   _אַרט, _keim, _təsi, _אַרא,
   {{0xa3e201b6,0x7d0b84d2,0x7afe2b9e,0x7989ab9f}},	//   नंद_, _nags, sept, _chew,
   {{0xb90aaba0,0x26c7aba1,0x79898077,0x87e38198}},	//   _मा_, fano_, _dhew, ающе,
   {{0x6a861b2f,0x4add816f,0x3d16020e,0xdbdb808b}},	//   _алга, _मागव, _पोते_, _ráðg,
   {{0x2d9c0065,0x63a2aba2,0x248080eb,0x7d0b95b6}},	//   _éves_, _suon, _šim_, _bags,
   {{0x3d19852a,0x644981ec,0x6b9c01b4,0x6b448176}},	//   भागे_, fzei, _hirg, _mòge,
   {{0x7d0b92fa,0x07a684a9,0x46ea81a1,0x6b9c2ba3}},	//   _dags, _разн, _одан_, _kirg,
   {{0xdced003b,0x39468073,0x63a2aba4,0x7d0d0019}},	//   plać, lhos_, _vuon, zdas,
   {{0x2bd48f85,0x53d4816f,0x7d0d07c0,0x7d0baba5}},	//   _दिवा, _दिवश, ydas, _fags,
   {{0x394680a9,0xdd968277,0x63a2aba6,0xa9210085}},	//   nhos_, _شجاع, _tuon, _şöbə,
   {{0x93468e97,0x14d7812a,0xf7730c2a,0xdb098013}},	//   _инде, _יואל_, لاس_, speá,
   {{0x69d300d4,0x5333aba7,0x6b9c2ba8,0xf09381c6}},	//   _डिली, _вешт, _nirg, ינר_,
   {{0x752f0063,0xa4d5035f,0x7e86801b,0x2fc02ba9}},	//   _pocz, лові, _úspě, _ewig_,
   {{0xb4cd016f,0x60c42baa,0xe7d280d4,0xd7d2970c}},	//   रणे_, _geim, _सिंप, _सिंच,
   {{0x65940a4c,0x24580364,0x7d0d2bab,0xdd940084}},	// [19d0] рату, вать_, rdas, раты,
   {{0x26c79041,0x7d0d01e0,0x7cde0087,0x79899c80}},	//   xano_, sdas, tărâ, _shew,
   {{0x26c7abac,0x6b9c2bad,0xfaa40f27,0xe659002e}},	//   vano_, _dirg, ршун, _чинч_,
   {{0x69da808c,0x26c7abae,0x06d800ab,0x7d009b77}},	//   irte, wano_, দ্দি, jems,
   {{0x26c7abaf,0x7d0080d2,0x3869abb0,0x69da81ec}},	//   tano_, dems, çar_, hrte,
   {{0x386981cd,0x6b9c2bb1,0xa03c0039,0x7d0babb2}},	//   ħar_, _girg, ועדפ, _sags,
   {{0x78a48025,0x7d0b97ef,0xa3a88b85,0xa2b8801b}},	//   živa, _pags, _खूब_, ोरन्,
   {{0xf3ffabb3,0x3946abb4,0xb4ad835a,0x97c58013}},	//   ção_, chos_, कडे_, _مقرو,
   {{0xeb998db4,0x26c7abb5,0x69daabb6,0x290dabb7}},	//   нии_, pano_, erte, _iaea_,
   {{0x64498352,0x4add8023,0x60c42bb8,0x753b801b}},	//   rzei, _माओव, _seim, skuz,
   {{0x7d0babb9,0x52d000c8,0x2bc486b7,0x6449abba}},	//   _tags, স্কৃ, लीबा, szei,
   {{0xe4cb803d,0x26c59920,0xb87b2bbb,0x2e3a80be}},	//   _آبان_, _helo_, rgín, _אגענ,
   {{0x69daabbc,0xb4df816f,0xdb0f0511,0xfd1f00ff}},	//   arte, तली_, _etcé, _chìm_,
   {{0x25a581cd,0xe8e081d0,0x26c5805c,0x200900ee}},	//   _kull_, _पञ्च, _jelo_, _dsai_,
   {{0x26c5abbd,0x60c42bbe,0x16098aed,0x68e98904}},	//   _melo_, _teim, विटर_, _oced,
   {{0x2d8b09a4,0x2cad8039,0xf8a80105,0x61e1abbf}},	//   _chce_, nced_, _गलिय, mull,
   {{0x61e1898c,0xc9530051,0x7bcd1849,0xac860d45}},	// [19e0] lull, _למה_, gsau, угал,
   {{0x7d00a1d1,0x29022bc0,0x491c000d,0x68e989b2}},	//   zems, leka_, याको_, _aced,
   {{0x61e1abc1,0xe0da94d6,0xaca401bc,0x248600e1}},	//   null, еве_, _alụs, ťom_,
   {{0x29022bc2,0x69ce9d3a,0x9fca8009,0x26ca2bc3}},	//   neka_, ábei, егда_, labo_,
   {{0x6b9c0029,0x26c5abc4,0x7e7e2bc5,0x2d802bc6}},	//   _tirg, _belo_, _hypp, mlie_,
   {{0x61e1820f,0x26c5a354,0x26ca2bc7,0x643b00be}},	//   kull, _celo_, nabo_, _טעכנ,
   {{0x21200025,0x26c5abc8,0x394681e0,0x63a60267}},	//   _onih_, _delo_, phos_, _hukn,
   {{0x9d220a49,0x29020499,0x61e1abc9,0xa534802e}},	//   _নতুন_, jeka_, dull, рнич,
   {{0x7866abca,0x26c5abcb,0x26ca1486,0x7d00abcc}},	//   _сказ, _felo_, kabo_, rems,
   {{0x25a5abcd,0x69da807a,0x3d19816f,0x26c5abce}},	//   _full_, trte, _मोठे_, _gelo_,
   {{0x61e1abcf,0x63a62bd0,0x037701c6,0x26ca2bd1}},	//   gull, _lukn, רתית_, dabo_,
   {{0x26c58db7,0x613f13de,0x7dea8201,0x29020555}},	//   _zelo_, _gëll, _dəst, geka_,
   {{0x3f9eabd2,0x54368bbe,0x63a602c4,0x26c5abd3}},	//   _kitu_, _حرار, _nukn, _yelo_,
   {{0x26ca2bd4,0x3f9e800e,0xa29485e9,0x26c58118}},	//   gabo_, _jitu_, _калі, _xelo_,
   {{0x1df801bb,0x2902005d,0x61e1abd5,0x3f9e8074}},	//   леры_, beka_, cull, _mitu_,
   {{0x2d800b91,0x20090041,0x7bcd2bd6,0x29022bd7}},	//   glie_, _tsai_, tsau, ceka_,
   {{0x20092bd8,0x5c990a14,0x36d5242e,0x3b551b2f}},	// [19f0] _usai_, ткая_, _копр, акар,
   {{0xd4982bd9,0x7bcd2bda,0x3ea10122,0x6d5a0585}},	//   урс_, rsau, _ught_, étar,
   {{0x7bcd2bdb,0x798d2bdc,0x2d800de0,0x7dea8085}},	//   ssau, _khaw, blie_, _xəst,
   {{0x26c58503,0x30158012,0x98c780f7,0x25a5abdd}},	//   _selo_, идер, اغان, _rull_,
   {{0xf7719301,0x26c58003,0x25a58098,0xd0098012}},	//   يات_, _pelo_, _sull_, теле_,
   {{0x290220b3,0x3f9e80eb,0x61e1abde,0xddc88084}},	//   zeka_, _citu_, yull, _dydž,
   {{0x6b400352,0x3f9e80ad,0xed5983fb,0x26c5abdf}},	//   _mögl, _ditu_, tiž_, _velo_,
   {{0xd6580051,0xb4df8b86,0x613f00f1,0x61e1a450}},	//   טיות_, तले_, _qëll, vull,
   {{0xa3e591bc,0xa3dc8076,0x934590ff,0x26c59117}},	//   बंध_, तंग_, иние, _telo_,
   {{0x61e1abe0,0x2902022e,0x3f9e8877,0x44292be1}},	//   tull, weka_, _gitu_, ixa_,
   {{0x29022be2,0x69261b67,0x7c42811f,0x656401b4}},	//   teka_, амна, _čvrš, ynih,
   {{0x273d0104,0x798d01c5,0x5c7591c7,0x60cb97ea}},	//   _hình_, _chaw, _клет, nagm,
   {{0x29022be3,0x798d2be4,0x6d498ad0,0x26ca2be5}},	//   reka_, _dhaw, mhea, tabo_,
   {{0x61e1abe6,0x29021e98,0x63a62be7,0x644d00dd}},	//   pull, seka_, _rukn, dzai,
   {{0x273d0104,0x26ca2be8,0x63a62be9,0x3f8400eb}},	//   _mình_, rabo_, _sukn, ēmu_,
   {{0x20560d31,0x63a62bea,0x26ca0f8e,0x59da86ae}},	//   _втор, _pukn, sabo_, _भितर,
   {{0x6f03ab42,0x7c3b9437,0x78a92944,0x7c298980}},	// [1a00] kenc, nyur, ževc, nxer,
   {{0x6f03abeb,0xdcfb811f,0x973c80fe,0x6d958084}},	//   jenc, dluč, _kiće, _išau,
   {{0x6f03abec,0x6edb0039,0xa3e5a6ee,0x2d801a1f}},	//   denc, _בחיפ, बूत_, plie_,
   {{0xebe6119d,0xaae2035a,0x3f9e835e,0xdb060168}},	//   _комп, _पाकक, _situ_, _kukë,
   {{0x6d498782,0x273d0104,0x7d042bed,0xe81911bc}},	//   dhea, _bình_, meis, दिया_,
   {{0x7d042bee,0x2612abef,0x69c38039,0xed5900e1}},	//   leis, थिली_, _owne, ďže_,
   {{0x3f9e8010,0x6fd280d4,0x645d808b,0xbd6a898d}},	//   _vitu_, _सिकं, úsin, крие_,
   {{0x6d4984bc,0xc0e3a386,0x7d040009,0x2b582bf0}},	//   ghea, _моск, neis, _hmrc_,
   {{0x3f9eabf1,0x6f03abf2,0xdee6abf3,0x798d2bf4}},	//   _titu_, benc, _вози, _rhaw,
   {{0x7d041276,0x798d00a4,0x79828051,0x973c9487}},	//   heis, _shaw, llow, _biće,
   {{0x6d498083,0x7d0407ac,0x6b400106,0x798d1236}},	//   bhea, keis, _rögl, _phaw,
   {{0x6d498782,0x798d022c,0x7bc286c0,0x85568061}},	//   chea, _qhaw, _twou, _خیبر_,
   {{0x58870196,0x7522abf5,0x442904b7,0x3202801b}},	//   рына, _inoz, xxa_, ňky_,
   {{0x6d462bf6,0x6d40abf7,0x973c80c3,0xc05800e8}},	//   _alka, lkma, _fiće, рію_,
   {{0xd378803a,0x798d01e9,0x69c38355,0xdcfbabf8}},	//   moć_, _thaw, _gwne, zluč,
   {{0x929b8051,0x7d042bf9,0x644d00ad,0x44292bfa}},	//   _ביות, geis, tzai, txa_,
   {{0xf8bf2bfb,0xdfd100f7,0xfaa72bfc,0x69d8016b}},	// [1a10] mbé_, _عيد_, ашен, áven,
   {{0x6d462bfd,0xd378825b,0x44292bfe,0x6f0384c3}},	//   _elka, noć_, rxa_, xenc,
   {{0x3f83003b,0x387f9142,0x7d0f2bff,0x98bf8699}},	//   mlju_, _syur_, _tacs, _smuđ_,
   {{0x6d498362,0xae1a0039,0x6d40ac00,0x3e1603de}},	//   xhea, _עורכ, jkma, _פֿיל_,
   {{0xd3788d26,0x6b818114,0x1b0f00ab,0xf807a240}},	//   koć_, yllg, সাবে_, рчен,
   {{0xd246803f,0x38ad8032,0x7522ac01,0x6d409151}},	//   _فن_, _bóró_, _anoz, ekma,
   {{0x6d49954c,0x6f03ac02,0xed59a53f,0x60cb820d}},	//   thea, renc, лок_, pagm,
   {{0x23672bea,0x7c29ac03,0x61e5005d,0x6f03ac04}},	//   čnju_, txer, muhl, senc,
   {{0x273d0104,0x68fb99a8,0x973c8088,0x63ad2c05}},	//   _tình_, _ibud, _siće, nqan,
   {{0x6aa4817b,0x6d49ac06,0x60c998f0,0x973c811f}},	//   _şifr, shea, _heem, _piće,
   {{0x7d042c07,0xdce9ac08,0x60c9ac09,0x6d4980f5}},	//   yeis, sleđ, _keem, phea,
   {{0x7522826c,0x973c81a1,0xa3e201a2,0xfc339c81}},	//   _gnoz, _viće, नूँ_, _وحش_,
   {{0x442983d3,0x8d748872,0x7d042c0a,0x057480f7}},	//   _ça_, _بالا, veis, _بالد,
   {{0x63bb8dab,0x2cbf86be,0x02398b76,0x7d0402af}},	//   mpun, lbud_, _مثبت_, weis,
   {{0x68fbac0b,0x7d042c0c,0x78a90db7,0x19b59e91}},	//   _obud, teis, ževa, _احتج,
   {{0x60c9ac0d,0x90c61dc7,0x68fb8135,0x2b5800c3}},	//   _neem, _убие, _nbud, _smrc_,
   {{0x3f830a20,0x63bbac0e,0x44260073,0xa3e20beb}},	// [1a20] blju_, npun, ão_, नूं_,
   {{0x29122c0f,0x7d040406,0xd24f003d,0xe6462c10}},	//   _haya_, seis, کنم_, _геоп,
   {{0x29122c11,0x60c9ac12,0x993a8221,0x2cbf81bf}},	//   _kaya_, _beem, ляду_, kbud_,
   {{0xc6930051,0x2912059c,0x63bbac13,0x68fb8362}},	//   _מאת_, _jaya_, kpun, _cbud,
   {{0x8ff78013,0xe73a8785,0xdfcf80f7,0xbcfb026b}},	//   مرور_, лед_, فين_, _ajéw,
   {{0x6d59ac14,0x68fba0c4,0x63bbac15,0x29122c16}},	//   _amwa, _ebud, dpun, _laya_,
   {{0x60c981c0,0x200dac17,0xceb303c8,0x8f9b0e82}},	//   _feem, _esei_, ליג_, ניצי,
   {{0x29122c18,0x63bba525,0xfc4684e8,0x60c9ac19}},	//   _naya_, fpun, šími_, _geem,
   {{0x63bb900c,0x6d40ac1a,0x61fb01a1,0x2906aaa0}},	//   gpun, rkma, _ćuli, meoa_,
   {{0xdb042c1b,0x68ed14ed,0x29122c1c,0x6d40ac1d}},	//   mpió, _scad, _aaya_, skma,
   {{0x291200a4,0x3f83003a,0x7c248110,0x8e8680f7}},	//   _baya_, vlju_, _šird, _الاه,
   {{0x291200ee,0x60c981c0,0xddcb01b9,0x73e681e2}},	//   _caya_, _xeem, ġiżl, _годз,
   {{0x291203c3,0x637d823e,0x27e6833e,0x3f830bcf}},	//   _daya_, tènt, nuon_, tlju_,
   {{0xc90580c2,0x83030264,0x2e1806c4,0xf8bf0061}},	//   _रस्म_, _উচ্চ_, _bčf_, sbé_,
   {{0x2c748019,0x29122c1e,0x2bc483eb,0x44b601bc}},	//   _دیکھ_, _faya_, लीरा, _ọsụ_,
   {{0x29122c1f,0x52838013,0x78a4920e,0x27e68420}},	//   _gaya_, _عليك, živj, kuon_,
   {{0xfd4f0028,0x994800a0,0x26ce85ee,0x3f830390}},	// [1a30] _khiế, _دليل_, kafo_, plju_,
   {{0x63ad2c20,0x3949016b,0x60c9ac21,0x27e6ac22}},	//   rqan, _hlas_, _seem, duon_,
   {{0x39492c23,0x56952c24,0x27ff802e,0x29122c25}},	//   _klas_, _фант, _spun_, _yaya_,
   {{0x61e52c26,0x2cbf8338,0x63bbac27,0x399b2c28}},	//   ruhl, xbud_, ypun, _būsi_,
   {{0xb4e501ab,0x63ad2c29,0x6aa90162,0x9f999abe}},	//   नली_, qqan, _şefu, авду_,
   {{0x70b52c2a,0x60c98c2e,0x3949016a,0xfd4f00ff}},	//   ंडुल, _weem, _llas_, _nhiế,
   {{0x60c9ac2b,0x27ff80b9,0x39492c2c,0x2cbfac2d}},	//   _teem, _wpun_, _olas_, tbud_,
   {{0x63bb803a,0x2bd4901c,0x68fbac2e,0x6d4d2c2f}},	//   tpun, _दिखा, _ubud, nhaa,
   {{0x29122c30,0x6fe081fe,0x69da04b8,0x2cbf81a3}},	//   _raya_, _नियं, _åter, rbud_,
   {{0x2912048f,0xfd4f0104,0x6d4d2c31,0x63bbac32}},	//   _saya_, _chiế, hhaa, rpun,
   {{0x63bbac33,0x29120695,0x7cd98019,0x39492c34}},	//   spun, _paya_, _نواز_, _blas_,
   {{0x78a902a5,0x6d598578,0x39492c35,0x7c248a20}},	//   ževn, _umwa, _clas_, _šire,
   {{0x6d4d2c36,0x291215c7,0x224d01d0,0x232984dd}},	//   dhaa, _vaya_, _řekl_, _воли_,
   {{0x39492c37,0x6da62c38,0x6569ac39,0x973c81a1}},	//   _elas_, жива, lneh, _kića,
   {{0x63abac3a,0xa3e58105,0xad5a2c3b,0x29122c3c}},	//   _hugn, बूर_, арах_, _taya_,
   {{0x63a3aabd,0x6569ac3d,0x6d4d2c3e,0x6d430087}},	//   _hinn, nneh, ghaa, _înal,
   {{0x63a3ac3f,0x443fac40,0x442d9daf,0xe5770a18}},	// [1a40] _kinn, nyu_, nxe_, ізу_,
   {{0x6fe081fe,0x63a3ac41,0x261a81ce,0x7c2480f7}},	//   _निबं, _jinn, _मछली_, _áire,
   {{0x64a60eab,0x443f8397,0x63ab816d,0x2d8c2c42}},	//   _мана, hyu_, _lugn, ïdes_,
   {{0x63a3ac43,0x6d4d2c44,0x443fac45,0xdce4017f}},	//   _linn, chaa, kyu_, onič,
   {{0xee02ac46,0xd70a8162,0x63ab82d5,0xc8cc801b}},	//   लब्ध_, инде_, _nugn, ारबट,
   {{0x1754a45b,0xfaa60703,0xd04e0085,0x501b04de}},	//   явля, _фаво, ükəs, יונו,
   {{0x79460063,0xd946879e,0x6146a7cb,0x6283835f}},	//   _równ, _деви, _дева, _nyno,
   {{0x6d4401e2,0x63abac47,0x7d162c48,0xdb040511}},	//   nkia, _bugn, ndys, mpiñ,
   {{0x63a3a4de,0xdce40052,0x443fac49,0xeb0682c7}},	//   _binn, jnič, gyu_, очно,
   {{0x63a3861f,0x6d5f036a,0x63abac4a,0xba548251}},	//   _cinn, ziqa, _dugn, звој,
   {{0x442d84c3,0x39492c4b,0x62838114,0x6d440198}},	//   axe_, _plas_, _cyno, kkia,
   {{0x63a38125,0x62838114,0x80b5064a,0x2ca682c4}},	//   _einn, _dyno, ंडें, _ugod_,
   {{0x63a39808,0xfd4f0104,0xcb6a80a9,0x61e18118}},	//   _finn, _thiế, _каде_, arll,
   {{0x63a3ac4c,0x628e0b80,0xdced0bcf,0xf48781f9}},	//   _ginn, _ozbo, vlađ, _بامی,
   {{0x26ccac4d,0x6d5f2c4e,0x6d4d044e,0x661e0369}},	//   _medo_, tiqa, thaa, _crpk,
   {{0xb4e52c4f,0x39492c50,0x91b780d5,0x63a3ac51}},	//   नले_, _ulas_, _بطور_, _zinn,
   {{0xe8731125,0x6d4d2c52,0x6d5f0748,0x628e2c53}},	// [1a50] _زندگ, rhaa, riqa, _azbo,
   {{0x6d4d2c54,0x26cc8267,0xce950098,0x2bdd909b}},	//   shaa, _nedo_, _напъ, _मिसा,
   {{0x60cd059c,0x6cea9344,0xdced0289,0x2fc900e4}},	//   _keam, _टांग_, slađ, _hwag_,
   {{0xdd868065,0x6d5f00b9,0x26d12c55,0x60c2ac56}},	//   _سو_, qiqa, lazo_, gbom,
   {{0xf48419b8,0x880780d5,0x6d5d2c57,0x2be20075}},	//   _журн, تظام, _imsa, _पिया,
   {{0x26d12c58,0x60cd0635,0x26ccac59,0x61e88234}},	//   nazo_, _leam, _cedo_, kudl,
   {{0x63a3ac5a,0xc33203c8,0x6569ac39,0x63ab8079}},	//   _rinn, _אום_, tneh, _sugn,
   {{0x60cd0af6,0x26d1016a,0x442d89cb,0x63abac5b}},	//   _neam, hazo_, txe_, _pugn,
   {{0x6569ac5c,0xb4bb901c,0x399b0029,0xb4ab9a3b}},	//   rneh, _अभी_, _jūsu_, _खली_,
   {{0x399b0029,0xdce42c5d,0x442d84c3,0x6d932c5e}},	//   _mūsu_, vnič, rxe_, lçad,
   {{0x63a3ac5f,0x6d442c60,0xd9100065,0x98b00668}},	//   _vinn, ykia, ہیں_, šača_,
   {{0xdce4003b,0x6d93055a,0x63abac61,0x60cd01a8}},	//   tnič, nçad, _tugn, _ceam,
   {{0x6d4bac62,0x60cd1581,0x661e0253,0xe81e92ee}},	//   _ilga, _deam, _srpk, पिया_,
   {{0x26cc1cef,0x7d099196,0x6d5d2c63,0x61e8ac64}},	//   údo_, lees, _amsa, budl,
   {{0x614623cd,0x65c60098,0xd9461634,0x60dbac65}},	//   _нека, ябва, _неки, _odum,
   {{0x60cd2c66,0x7d09ac67,0x2a3a8039,0xdce41607}},	//   _geam, nees, _לעצמ, pnič,
   {{0x26d12c68,0x6d442c69,0x2900019d,0x2fc90428}},	// [1a60] bazo_, rkia, _ibia_, _gwag_,
   {{0xe8190540,0x7d098009,0x78a9847f,0x8afc809a}},	//   दिरा_, hees, _agev, mięc,
   {{0x6d4bac6a,0x2366011f,0x7d09ac6b,0x7ae32c6c}},	//   _olga, đoj_, kees, ónta,
   {{0xdb042509,0xfaf88ec3,0x39b797c9,0x26ccac6d}},	//   rpiñ, lnīt_, _găse_, _sedo_,
   {{0x2d821f26,0x98a70a20,0x8afc809a,0x26cc97e9}},	//   _ikke_, šića_, nięc, _pedo_,
   {{0x6d93041c,0x60dbac6e,0x6d4ba0a5,0xa2bb0c9a}},	//   açad, _edum, _alga, शुद्,
   {{0x78ad803a,0x26ccac6f,0x6440a1f5,0x7d09ac70}},	//   žava, _vedo_, wymi, fees,
   {{0x7d09ac71,0x3f878289,0x6440ac72,0x5bb882ff}},	//   gees, alnu_, tymi, олия_,
   {{0x6fb685ff,0x7bd62c73,0x60cd2c74,0x26d12bd7}},	//   _رمضا, nsyu, _ream, yazo_,
   {{0x290010ec,0x60cd2c75,0xff24803d,0x656082a6}},	//   _abia_, _seam, _تبری, simh,
   {{0x628781cd,0xc3330039,0x60cd0074,0x7bd600dd}},	//   żjon, תות_, _peam, hsyu,
   {{0x39468110,0xf8cc850d,0x26d10010,0x7bd6076d}},	//   nkos_, ारिय, wazo_, ksyu,
   {{0x61e8ac76,0x315783c8,0x60cd2c77,0x26d12c78}},	//   sudl, ליטן_, _veam, tazo_,
   {{0xd7f81b69,0x973c8b80,0x2d8205ee,0xe8d904be}},	//   чую_, _mićo, _akke_, _imọ_,
   {{0x50ccac79,0x8afb8051,0x26d12c7a,0xf8cc8a74}},	//   ाराष, _להגי, razo_, ाराय,
   {{0x2d5801a0,0x6b40007b,0xe8d900ff,0x2fc902c4}},	//   пись_, _mögu, _thự_, _twag_,
   {{0x26d1062f,0x6728911b,0xb0c3097d,0x6b40007b}},	// [1a70] pazo_, _ondj, _व्यग, _lögu,
   {{0x29190267,0xe1ab83db,0x399203a8,0xe9ff8129}},	//   ldsa_, _घूँघ, ráse_, _hoại_,
   {{0x7f3c0039,0xdb0b8687,0x62868035,0x22470061}},	//   _לעזו, _utgå, ękow, ánk_,
   {{0x67288088,0xbcfb0693,0x3946861b,0x6d5d2c7b}},	//   _andj, _ejér, gkos_, _umsa,
   {{0xdb1b85b4,0x24869352,0x29d88028,0x6d932c7c}},	//   spué, _nyom_, hĩa_, rçad,
   {{0xe9ff8104,0x7d09ac7d,0xdb0286a5,0x69d88081}},	//   _loại_, wees, _otoñ, _ovve,
   {{0x7d09ac7e,0xed5981bb,0x290b2c7f,0x673a85f3}},	//   tees, жой_, keca_, _dotj,
   {{0x656d2c80,0x63af007d,0x25de8697,0xe3b9ac81}},	//   nnah, _kucn, _गिरी_, оби_,
   {{0x69d8a35a,0x2bdd835a,0x394dac82,0x290b2c83}},	//   _avve, _मिळा, _iles_, deca_,
   {{0x990608fd,0xe9d98256,0x7d09ac84,0x4a459383}},	//   षज्ञ_, око_, sees, днов,
   {{0x7d09ac85,0x63a700f3,0x779082e3,0xdb0381d0}},	//   pees, _mijn, _حیوا, _jiné,
   {{0x69d803a7,0xe6c601a2,0x6b40016d,0x2ec60c2d}},	//   ávei, वर्ज, _högt, वर्त,
   {{0x7d5680be,0xdb038866,0x69d8ac86,0x656d0df6}},	//   _קינד_, _liné, _evve, dnah,
   {{0x394dac87,0x6265997b,0x7763ac88,0x63a72c89}},	//   _lles_, _овла, ninx, _nijn,
   {{0x8fa31814,0x8afc809a,0x394d808e,0x656d232a}},	//   таре, sięc, _oles_, fnah,
   {{0x19870098,0x63af0bcf,0xa1870081,0x8afc8035}},	//   _общи_, _bucn, _обща_, pięc,
   {{0x7984022e,0x63a70a0f,0x2486822c,0x63af00c3}},	// [1a80] _ikiw, _bijn, _xyom_, _cucn,
   {{0x394d802e,0x7bd60057,0xdb098876,0x395fac8a}},	//   _ales_, rsyu, mpeó, _amus_,
   {{0xdb03ac8b,0x69c1ac8c,0x6b52013c,0x656d0079}},	//   _ciné, nple, _lægg, bnah,
   {{0x39468110,0x395f802a,0x2004ac8d,0x656d01b4}},	//   ukos_, _cmus_, _ppmi_, cnah,
   {{0x3946ac8e,0x63a700f3,0x6b40007b,0x77638118}},	//   rkos_, _fijn, _sögu, finx,
   {{0x394d8e67,0xd5ba83bc,0x39468612,0xdb03ac8f}},	//   _eles_, оси_, skos_, _finé,
   {{0x44222c90,0x53a700d4,0x394d9699,0x09d800ab}},	//   _hrk_, _कूटश, _fles_, _সহকা,
   {{0xb4e883eb,0x69c19c11,0x63a701ed,0x2d800037}},	//   बले_, dple, _zijn, noie_,
   {{0xd90d8bca,0xa2a203dd,0x64440365,0x25a69139}},	//   _دین_, _कृत्, nyii, _viol_,
   {{0x79842c91,0x5a349071,0x25f68035,0x628f8035}},	//   _akiw, енот, _एमपी_, ęcon,
   {{0x6b4000f2,0x290b2c92,0x656d02a3,0x212900dd}},	//   _högs, teca_, ynah, _pnah_,
   {{0x1c468544,0x78a4936f,0x79960286,0x2d4707b6}},	//   _онем, živu, _chyw, _põem_,
   {{0xb8d705fb,0x6d43002e,0x290b2c93,0x59ce016f}},	//   _जल_, _înai, reca_, हीतर,
   {{0x290b02a5,0x2bb501fe,0x63af011f,0x5ee080ab}},	//   seca_, _अंबा, _rucn, প্রে,
   {{0xd9f281b6,0x27e6ac94,0x290b2c95,0x3da701e2}},	//   _अमित_, hron_, peca_, драб,
   {{0xa3e58076,0x994402bb,0x63af10d3,0x656d2c96}},	//   बूक_, mış_, _pucn, unah,
   {{0x63a71696,0xdb039c81,0x994407c0,0x6f170144}},	// [1a90] _pijn, _siné, lış_, _taxc,
   {{0x656d2c97,0x442214fb,0xdb038144,0xa3e68128}},	//   snah, _drk_, _piné, _बटन_,
   {{0x27e685a4,0x39920019,0x21f888f9,0x994408c5}},	//   eron_, lása_, néh_, nış_,
   {{0x63a700f3,0x26de833e,0x7c22ac98,0x6b448176}},	//   _wijn, _adto_, _oror, _dògi,
   {{0x7d0d2c99,0x80278013,0x78ad82a5,0x5ed380ab}},	//   meas, برام, žavo, _সাবে,
   {{0xf77381bd,0xae03016f,0x7d02ac9a,0x7d0d2c9b}},	//   خاص_, _लहान_, _abos, leas,
   {{0x753d2233,0x27e6ac9c,0x776388e9,0xc17788ca}},	//   _kosz, aron_, rinx, _قدرت,
   {{0x7643ac9d,0x7d0d2c9e,0x92942c9f,0x7c22aca0}},	//   ryny, neas, _расц, _bror,
   {{0x7996031d,0x76438198,0x99858061,0xf8b28e82}},	//   _rhyw, syny, _élő_, _תשמ_,
   {{0x7d0d2ca1,0x6b4000f2,0x39920019,0x69c1aca2}},	//   heas, _högr, dása_, tple,
   {{0x26c78353,0x7d0d0009,0x7c22a7a3,0xe1f6802e}},	//   mbno_, keas, _eror, нгэ_,
   {{0x361a8039,0x69c1aca3,0xaca38135,0x7c22802a}},	//   _מועד, rple, _arụm, _fror,
   {{0x2d802ca4,0x69c1aca5,0x291e001b,0xdb060c83}},	//   voie_, sple, ěta_, _luká,
   {{0x6d4f11b9,0xcc3a893f,0x7d1b8006,0x6b40007b}},	//   _alca, _מענט, ldus, _lögr,
   {{0x236580f2,0xd0408201,0x7d0d1995,0xd5b21a00}},	//   milj_, _demə, feas, افر_,
   {{0x7d1b8665,0xdb0985e4,0x7984004f,0x7d198326}},	//   ndus, mpeñ, _ukiw, _jaws,
   {{0x03260d9e,0x6b52013c,0xec770012,0x490000c2}},	// [1aa0] ндан, _læge, епт_, ष्णो_,
   {{0xaca4019d,0xb4db0362,0x44220d55,0x27e69532}},	//   _nzụt, _blàs, _vrk_, vron_,
   {{0x00e694b8,0xb4db023e,0x2d73025b,0x7d0d2ca6}},	//   ежен, _clàs, mćen_, beas,
   {{0x27e6aca7,0x61e30065,0xaca40133,0xe0d29459}},	//   tron_, ánla, _azụt, ازا_,
   {{0x14d70051,0x673e2ca8,0x7d1baca9,0x27e6acaa}},	//   _אוכל_, _kopj, ddus, uron_,
   {{0x7bc42cab,0xf0930158,0x7c24a771,0x27e6acac}},	//   mpiu, אנד_, _širo, rron_,
   {{0x99440201,0x39920019,0x38728087,0x6b6680e7}},	//   xış_, zása_, _ţară_, _légè,
   {{0x78a90024,0xe9a38e63,0xdd9781e5,0x69dc27f5}},	//   ževi, _басп, ншы_, _ivre,
   {{0x3076938f,0x7d19acad,0x6b818352,0x4420009f}},	//   _чувс, _daws, folg, nvi_,
   {{0x994403bf,0x44202cae,0xf063acaf,0x973c81a1}},	//   tış_, ivi_, _скуп, _mićk,
   {{0x44202cb0,0xdb072cb1,0x2fc01670,0x7d1982ed}},	//   hvi_, _dijè, _atig_, _faws,
   {{0x4420003a,0x39920065,0x99441014,0x613f00f1}},	//   kvi_, tása_, rış_, _pëlq,
   {{0x53b5016f,0xa49b06c0,0x656282c4,0x23658b80}},	//   _अंधश, _abòn, _imoh, bilj_,
   {{0x7d19809a,0x44200088,0x7c2d8904,0xadf489c1}},	//   _zaws, dvi_, _šarg, _इमान_,
   {{0x6f1aacb2,0x753d1b35,0x3ea52cb3,0x7d0d2cb4}},	//   _matc, _posz, ält_, teas,
   {{0x69daacb5,0xdb06026f,0x2bb51d7c,0x3ceb00c2}},	//   mste, _ruká, _अंदा, टलें_,
   {{0x97a7028b,0x69dc1fcb,0xb4db0a2a,0x442001fa}},	// [1ab0] _прол, _avre, _blàr, gvi_,
   {{0x6f1aacb6,0x7d1b8b80,0x69daa6a1,0x2009008e}},	//   _natc, zdus, oste, _ipai_,
   {{0x64410201,0x69daa7d0,0x44202cb7,0x7d0d2cb8}},	//   _əliy, nste, avi_, peas,
   {{0x69daacb9,0x3f832cba,0xf99f06c0,0x6b818061}},	//   iste, loju_, nmè_, zolg,
   {{0xb90992c7,0x7d19acbb,0x69dc2cbc,0x41748290}},	//   _मय_, _raws, _evre, دالس,
   {{0x65628122,0x2d8686cb,0xdcfb86d3,0xdce9826c}},	//   _amoh, _akoe_, rouč, rneč,
   {{0x6b81acbd,0xc8f58698,0xda0512ee,0x69daacbe}},	//   volg, _извъ, _रहित_, jste,
   {{0x26d300f1,0xab640380,0x387e0035,0x7c2000c3}},	//   _lexo_, rmüş, ętrz_, _šmri,
   {{0x69daacbf,0x81c300ab,0x6d498bc6,0x290facc0}},	//   este, _এটি_, rkea, mega_,
   {{0x26d30207,0x69daacc1,0x290facc2,0x656295d7}},	//   _nexo_, fste, lega_, _emoh,
   {{0x2bd18740,0x2fc023ea,0x28c3016f,0x291b19e7}},	//   _दौरा, _stig_, _व्हि, _baqa_,
   {{0x290f8db7,0x291dacc3,0x81c300c8,0x186a245b}},	//   nega_, ndwa_, _এটা_, дами_,
   {{0x3959020f,0x3de380ab,0x2d8d8748,0x61e8acc4}},	//   ërsa_, _মহিল, mlee_, ardl,
   {{0x290facc5,0xdf15035f,0x2d8dacc6,0x3f8306ec}},	//   hega_, льсь, llee_, goju_,
   {{0x290f8db7,0x5ed400c8,0x26d30118,0x628a8428}},	//   kega_, _তাদে, _dexo_, _gyfo,
   {{0x290facc7,0x44202cc8,0xa2a21299,0x25ab0037}},	//   jega_, tvi_, _कृष्, _cicl_,
   {{0xd4671a19,0xc4d28158,0x290f8006,0x6da30012}},	// [1ac0] вите_, יגן_, dega_, рита,
   {{0x212d81f1,0x7bdb8009,0x39400362,0x7bc40048}},	//   _aneh_, isuu, _hois_, rpiu,
   {{0x26d800b4,0xab5b02af,0x2d8dacc9,0xe8fa81e2}},	//   maro_, _stüc, klee_, дле_,
   {{0x290facca,0x26d8009c,0x6f1a8aff,0xd7e6902a}},	//   gega_, laro_, _satc, віко,
   {{0xa41c80c8,0x394003d3,0x3166a75d,0x212d807a}},	//   _তথ্য_, _mois_, rioz_, _dneh_,
   {{0x6d932ccb,0x69da92cf,0xbcfb000d,0x26d81aae}},	//   nçan, yste, _jmén, naro_,
   {{0x670423e6,0x6f0307d9,0x69dc0067,0x52750087}},	//   श्यक_, _önce, _uvre, _буту,
   {{0x290f82a5,0x6f1a8039,0xe297186e,0x38c889a7}},	//   cega_, _watc, _рас_, _ساری_,
   {{0xa8878071,0xd175876a,0x98a39d32,0x69daaccc}},	//   _айта_, _сыры, _вите, wste,
   {{0x69da8574,0x39400068,0x5fdc0321,0x26d82ccd}},	//   tste, _aois_, _बिजल, jaro_,
   {{0x394002be,0xe7378f2e,0x69daacce,0x26d82ccf}},	//   _bois_, _шеф_, uste, daro_,
   {{0x69da8faf,0x26d303aa,0x7c2d8668,0xbcfb00e7}},	//   rste, _sexo_, _šare, _amén,
   {{0x39402cd0,0x69da8456,0xc0ab0875,0x50642cd1}},	//   _dois_, sste, بادل_, атра,
   {{0x26d82cd2,0x4426acd3,0x973c8669,0x628aacd4}},	//   garo_, _iro_, _bići, _tyfo,
   {{0x394003d3,0x3f832cd5,0xe8d90870,0x26d301df}},	//   _fois_, roju_, _akụ_, _vexo_,
   {{0x2d84acd6,0x4426acd7,0x63ad81e8,0x6e2505f3}},	//   nome_, _kro_, _èanc, _vrhb,
   {{0x290facd8,0x26d82cd9,0x27e096f2,0x26d3002a}},	// [1ad0] vega_, baro_, šinj_, _texo_,
   {{0x9952003e,0x26d80314,0x61e30019,0x2d8d80b9}},	//   máš_, caro_, ánlo, zlee_,
   {{0x6d5c81e2,0x290facda,0x02a719b8,0x2d84acdb}},	//   _įran, tega_, трам, kome_,
   {{0x4426acdc,0xe5350009,0x2d848084,0xa6cf8264}},	//   _oro_, _семь, jome_, _রাইট,
   {{0xb4c12cdd,0x4426acde,0x290facdf,0xdee58790}},	//   ुरी_, _nro_, rega_, голи,
   {{0x290f8665,0x6d4d02c1,0x20d18104,0x77848112}},	//   sega_, lkaa, ại_, аліз,
   {{0x7bc2ace0,0x2d84ace1,0x80d280ab,0xfd1181a8}},	//   _atou, fome_, _হার্, مجة_,
   {{0xdb0d160a,0x6d4d1e0a,0x7d1d2ce2,0x2d84ace3}},	//   mpañ, nkaa, _jass, gome_,
   {{0x7d1d291e,0x4426ace4,0x39402ce5,0x98a008ae}},	//   _mass, _cro_, _rois_, _inić_,
   {{0x7d1d2ce6,0x7bdbace7,0x96ca8540,0xdced0024}},	//   _lass, rsuu, _स्पॉ, dnač,
   {{0x4426ace8,0x39402ce9,0x6d4d2cea,0xd9460468}},	//   _ero_, _pois_, kkaa, гени,
   {{0x7d1d2ceb,0x44268428,0x2d848039,0x6d4d2cec}},	//   _nass, _fro_, come_, jkaa,
   {{0xeb8eaced,0x4426acee,0x26d82cef,0x39402cf0}},	//   _ги_, _gro_, taro_, _vois_,
   {{0x973c80fe,0x06e580ab,0x6569acf1,0x59d0801b}},	//   _pići, প্রি, lieh, थीहर,
   {{0x7d1d2cf2,0xfce6210d,0x26d82cf3,0xa50a1ed1}},	//   _bass, лово, raro_, нева_,
   {{0x7d1d2cf4,0x291e0029,0x39990065,0x6d4d2cf5}},	//   _cass, ētas_, tése_, gkaa,
   {{0x2e178201,0x5f76003d,0x25a02cf6,0x69c380c3}},	// [1ae0] _dəfə_, _مادر, rmil_, _htne,
   {{0x6d5602a0,0x46f604fa,0xdcf49487,0x7c24acf7}},	//   shya, _счит, _čačk, _širk,
   {{0x7d1d2cf8,0x29d18796,0x6d4d01b4,0xdb0a849c}},	//   _fass, nša_, bkaa, _difè,
   {{0x3940808b,0x631400ab,0x79862cf9,0x6d932cfa}},	//   ðis_, সাইট_, nokw, nçal,
   {{0x6f1e0117,0xe3b207d2,0x61fe2cfb,0x799b8077}},	//   _kapc, _درج_, stpl, _dhuw,
   {{0x779180d5,0x7c240842,0x9c12819d,0x798981bc}},	//   قیقا, mvir, _dọlf, _ekew,
   {{0xe297028b,0x5fe0823c,0x29d1a354,0xdced07df}},	//   _бар_, _निकल, jša_, znač,
   {{0x442693d9,0x69de2cfc,0x74149a37,0x68e40135}},	//   _pro_, mspe, لوبا, _ndid,
   {{0x7c242cfd,0x69de2cfe,0x136a9182,0x7f41acff}},	//   nvir, lspe, ешни_, _folq,
   {{0xa3e5901c,0x93fb012a,0xbcfb02be,0xe3bf81df}},	//   _फिर_, עליי, _amél, íña_,
   {{0x19590a7f,0xe1350364,0xaa94a6b1,0x69de2d00}},	//   ваны_, анны, ринч, nspe,
   {{0x25f38076,0x4426ad01,0x69de00f7,0x63ae02d6}},	//   ्झरी_, _tro_, ispe, _libn,
   {{0x44268353,0x68e40114,0x644682f1,0x27e00176}},	//   _uro_, _ddid, äkid, _cvin_,
   {{0x7d1d2d02,0x2b8f02af,0x69de2d03,0x7c290bda}},	//   _sass, rück_, kspe, _šero,
   {{0x7d042d04,0xd9048065,0x6d4d0a81,0xe5c40081}},	//   ffis, _ٹی_, tkaa, йсто,
   {{0x6298803b,0xb4c12d05,0x69de0e23,0x7d1d022b}},	//   _izvo, ुरे_, dspe, _qass,
   {{0x6d4d02c1,0x81b680c8,0x7afd9f3a,0x69c89fcd}},	// [1af0] rkaa, _ছবি_, đstv, lpde,
   {{0x7d1d2d06,0x6d4d2d07,0x656982af,0x6e288370}},	//   _wass, skaa, zieh, _ordb,
   {{0x7d1d2d08,0x5ed380ab,0x69de2d09,0x63ae01b4}},	//   _tass, _সালে, gspe, _dibn,
   {{0xf8bf02be,0xa3e585fc,0x973c8390,0x7ff59459}},	//   ncé_, _फिल_, _miću, لستا,
   {{0x6d93055a,0x6e289995,0x69de0162,0xdb0d0333}},	//   nçam, _ardb, aspe, spañ,
   {{0x6d5801e2,0xb8ec80d4,0x99d712c8,0x79860234}},	//   _įvai, _श्_, _مترا, zokw,
   {{0xb8db80c8,0x8d558a13,0x6569ad0a,0xf8c980e7}},	//   _আজ_, итич, tieh, _créé_,
   {{0xf1a48554,0x754595ac,0x29d1811f,0xdce40289}},	//   _грун, рниз, vša_, rnić,
   {{0x1c4297ae,0xdb0f11b9,0x656984dc,0x6e288192}},	//   жным, _lucí, rieh, _erdb,
   {{0x7bdf0187,0xe787ad0b,0x60d62d0c,0x6569ad0d}},	//   isqu, _субо, _seym, sieh,
   {{0x4a758048,0x29d1ad0e,0x5efe809a,0x291f82f1}},	//   рыпт, uša_, _शॉट्_, _kaua_,
   {{0xb4e401fe,0xdb0385e4,0xfe708591,0x60260a41}},	//   _नये_, _diná, _عدل_, адма,
   {{0xb4c3885d,0x291f804f,0x6d93061c,0x2f248061}},	//   ्री_, _maua_, rçal, ségű_,
   {{0xfaa59597,0x2d8b001b,0xdb038e93,0x2909019d}},	//   _кало, _akce_, _finá, _ebaa_,
   {{0x7d042d0f,0x597604d9,0xbea61229,0x6d930722}},	//   tfis, _выпу, равк, pçal,
   {{0x7c2401e2,0x2c09809a,0x27e08805,0x29092d10}},	//   tvir, _वहां_, šini_, _gbaa_,
   {{0xdee62657,0xab662bd9,0x7d04007b,0x5ee080c8}},	// [1b00] _копи, авал, rfis, প্টে,
   {{0x68fbad11,0x69de2a33,0x212000b9,0xb4c384c5}},	//   _acud, tspe, _haih_, ्रु_,
   {{0xbd8a003f,0x399c80f7,0xa3b60999,0xf8ba00d4}},	//   _لندن_, híse_, _चूर_, _इलाय,
   {{0xb4db0028,0x4fc6ab3f,0x6d430087,0x628e016b}},	//   _hoàn, аска, _înap, _vybo,
   {{0x628e2d12,0x63ae2d13,0x779482e3,0x27e08834}},	//   _wybo, _tibn, میرا, éin_,
   {{0x7c2480f7,0x69de2d14,0x2d922d15,0x7bc6062c}},	//   _áiri, pspe, llye_, _itku,
   {{0x91e302a4,0x25af81a1,0xdb0e0168,0xcb67002e}},	//   _море, _bigl_, _libë, _таре_,
   {{0x27e98341,0x7c2d8052,0x399c81a8,0xa534aba7}},	//   šana_, _šara, físe_, снич,
   {{0xef1a8abe,0x60cdad16,0x973c80d2,0xf8bf00e7}},	//   _има_, ñame, _siću, ndée_,
   {{0x3b5491b3,0x3944ad17,0xd00f80f7,0x316b0035}},	//   скор, _homs_, _تلك_, wicz_,
   {{0xe81e825e,0x44e880ab,0x7c2901b9,0x291f8c53}},	//   पिका_, ক্ষক_, _ġerm, _yaua_,
   {{0x7bc6003a,0x26dcad18,0x2b0606f0,0xbc6789a7}},	//   _otku, lavo_, स्तु_, امین_,
   {{0xb4d2ad19,0x7afc00d2,0xf8bf2d1a,0x1b1d0264}},	//   वरी_, _ocrt, rcé_, নাতে_,
   {{0xe78727f1,0x200501b9,0x26dc8611,0xdb0e13de}},	//   румо, ċli_, navo_, _dibë,
   {{0xd5b81e25,0x139b84de,0x539b8039,0x629880d2}},	//   ист_, _שבוע, _שיוו, _uzvo,
   {{0x394487fa,0x3a2d2d1b,0x48670081,0x00000000}},	//   _noms_, _čep_, _въоб, --,
   {{0x9fe180ab,0x798d2d1c,0xe7ee0105,0x3f87880a}},	// [1b10] _মঙ্গ, _ikaw, _जिया_, yonu_,
   {{0xf2c7096b,0x7bdf02be,0x26dcad1d,0x68fb847f}},	//   рсан, rsqu, javo_, _scud,
   {{0xd1b80065,0x26dc8110,0x6f150216,0x79a786fd}},	//   لانا_, davo_, mezc, арде,
   {{0x3944ad1e,0x8c48017b,0xc10580f7,0xdb0e06c0}},	//   _coms_, _bağı, صوتي, _libè,
   {{0xdc350159,0x656d010c,0x2cbf811c,0x80c68327}},	//   _האָט_, miah, vcud_, ाड़े,
   {{0x8c480182,0x656d2d1f,0x6f152d20,0x6dbc007a}},	//   _dağı, liah, nezc, _očal,
   {{0xb87b17ad,0x6b52006a,0x291fad21,0xb345841c}},	//   laíd, _mægl, _taua_, _loçã,
   {{0x798d01c5,0xb4c38f21,0xe3bf81df,0x656d2d22}},	//   _nkaw, ्रे_, íño_, niah,
   {{0x69c7120e,0x21200590,0x26dc807a,0x442b0197}},	//   _htje, _raih_, bavo_, _jrc_,
   {{0xda0e0540,0x798d2d23,0x26dc81e8,0x442b2d24}},	//   _सहमत_, _akaw, cavo_, _mrc_,
   {{0xe69580f7,0x39920019,0x442b026c,0x6f150e1b}},	//   _الاد, lási_, _lrc_, dezc,
   {{0x6721ad25,0xf65282f6,0x8c48080a,0x7bc9ad26}},	//   _halj, _מצב_, _yağı, ppeu,
   {{0x656d2d27,0x4ca580ab,0x6721ad28,0xe81b03a4}},	//   diah, _গ্রু, _kalj, _पैदा_,
   {{0x20022d29,0x69c702ce,0x6721808e,0x6d5bad2a}},	//   rtki_, _otje, _jalj, lhua,
   {{0xceb281db,0xed5a1628,0xa6e3007b,0x20022d2b}},	//   לים_, гов_, íðar, stki_,
   {{0x6d5b80fc,0x26dc8517,0x7afc0267,0xc21281c6}},	//   nhua, zavo_, _scrt, _זהה_,
   {{0x64a30084,0x657603a6,0x7c3bad2c,0xdcfb8380}},	// [1b20] зата, rnyh, nxur, zluğ,
   {{0x39448b3c,0x7c2bad2d,0xb05b016d,0x6721ad2e}},	//   _soms_, _mrgr, rbät, _nalj,
   {{0x260184c3,0x442b009f,0x6d5b8748,0x26dc8084}},	//   jóo_, _erc_, khua, vavo_,
   {{0x00da803f,0x3f8a0136,0xd91080d5,0x6d5b8282}},	//   ابات_, lobu_, بیر_, jhua,
   {{0xdcfb82a5,0x7d160079,0xdb0e00e7,0x5ec980ab}},	//   jluđ, meys, _libé, _রয়ে,
   {{0xa09b0158,0x06d880c8,0x6d4606cb,0x7d162d2f}},	//   ניסט, _সাহি, _hoka, leys,
   {{0x6d462d30,0x7c2b8114,0x60c415a0,0x3944ad31}},	//   _koka, _argr, _ofim, _toms_,
   {{0x2fda83f8,0x75242d32,0x6d462d33,0x6fb68077}},	//   _مورد_, ndiz, _joka, _همرا,
   {{0x7524004f,0x6d462d34,0x3eaa8388,0x67218168}},	//   idiz, _moka, _ºbto_, _falj,
   {{0x6d462d35,0x69c103d3,0xd00f8eca,0x8c1b0039}},	//   _loka, _élec, _سلم_, נויי,
   {{0xd9151006,0x60c904c3,0x61150fe6,0x60dd0102}},	//   одны, ñemo, одну, tasm,
   {{0x27e0805c,0xf53f016d,0x6d5bad36,0xd7fb0198}},	//   šinu_, _ihåg_, chua, луг_,
   {{0xbfb68104,0x588701e5,0x60dd2d37,0xc05803a9}},	//   _điểm_, сына, rasm, бір_,
   {{0x3f8a2d38,0x26da0144,0xac9784a3,0x3c778e82}},	//   gobu_, _cepo_, _انها_, _פתגם_,
   {{0x26da2d39,0x6f1505a4,0x656d00e1,0x39920019}},	//   _depo_, rezc, tiah, zási_,
   {{0x22ae8086,0x6d408247,0x7d160079,0x6a4a8085}},	//   mək_, njma, geys, rəfd,
   {{0x6d9303d3,0x69c71277,0xb4b9000f,0x656d2d3a}},	// [1b30] nçai, _stje, _चली_, riah,
   {{0x656d01ac,0xb87b25a7,0x6b4d8144,0x6d5bad3b}},	//   siah, raíd, _púgi, zhua,
   {{0xfbda88fd,0x644d0239,0x821500f7,0x7d1601b4}},	//   _मौसम, syai, تواص, beys,
   {{0x39920065,0x6d5ba928,0x6dbc005c,0x752281ac}},	//   tási_, xhua, _očaj, _naoz,
   {{0x672198c5,0x261b8076,0x6d4080d2,0xf8078087}},	//   _palj, _मनही_, djma, счен,
   {{0x7c2d811f,0x44292d3c,0xf41f0198,0x2fc90122}},	//   _šaro, mva_, _isä_, _mtag_,
   {{0x6721803a,0x69c7120e,0xe81b175d,0x67238052}},	//   _valj, _utje, _पैसा_, rdnj,
   {{0x60c2ad3d,0xdd9180f7,0x44292d3e,0xd65804de}},	//   ccom, بوع_, ova_, מיות_,
   {{0xe3b693cd,0x7bcd2d3f,0x6721ad40,0x27e080f7}},	//   обы_, npau, _talj, áint_,
   {{0x44292d41,0x6d5bad42,0x98ad80e1,0x60dbad43}},	//   iva_, shua, _hneď_, _heum,
   {{0xe2999289,0x44278416,0x44290406,0x60db80dd}},	//   ран_, _گراف, hva_, _keum,
   {{0x4429003a,0xfd5681bc,0x6d5b81c0,0x7d1601b4}},	//   kva_, _mgbọ, qhua, xeys,
   {{0x6d462d44,0x2bb50d14,0xdce9ad45,0x26da0c53}},	//   _roka, _अंगा, nieč, _pepo_,
   {{0x6d462d46,0x7c29ad47,0xbf9b0073,0x83fd8019}},	//   _soka, mver, stên, rződ,
   {{0x22ae8086,0x3f8a026f,0x614617f4,0x7d162d48}},	//   cək_, robu_, _мека, teys,
   {{0xdce98110,0x7c29a7d1,0x9f468118,0xb05b0338}},	//   kieč, over, iroá_, rbär,
   {{0x06d900c8,0x7d162d49,0xfd5699a8,0x7bcd13d2}},	// [1b40] _তারি, reys, _agbọ, gpau,
   {{0x68e9ad4a,0x75241b68,0x1b1780ab,0x7c29ad4b}},	//   _aded, sdiz, তাকে_, iver,
   {{0x7c299103,0x44292d4c,0xe8220ebf,0x8afc809a}},	//   hver, ava_, मिका_, mięt,
   {{0x60c29c33,0x7c29ad4d,0x629c1f95,0xf1a9803d}},	//   ucom, kver, _vzro, مانه_,
   {{0xb4d62d4e,0x7c29ad4f,0x88169a37,0x68e9ad50}},	//   हरी_, jver, تباط, _dded,
   {{0x05ea9d2f,0x60c2ad51,0xe3a78591,0x8afc809a}},	//   афии_, scom, _زر_, nięt,
   {{0xd6d98cde,0xda0e090a,0x629c003a,0xd5b78364}},	//   сті_, _सहित_, _uzro, осы_,
   {{0x7c290042,0x29002d52,0x7c29ad53,0x60db8706}},	//   _šeri, _ncia_, fver, _geum,
   {{0x7c29ad54,0x8d5b03de,0xb054819d,0x8b6681a8}},	//   gver, יכקי, ọọrụ_, قادم,
   {{0xb4d613d9,0x3f76809a,0xa3dc2207,0xeb4a9cad}},	//   हरु_, dług_, णीय_, рчик_,
   {{0x2b4783d3,0x06d900ab,0x79952d55,0x2c0600ab}},	//   _donc_, _তালি, зинф, রিয়ে_,
   {{0x81bc8341,0xb4b9023c,0x22ae8201,0x212682f7}},	//   lvēk, _चले_, rək_, ndoh_,
   {{0x2006ad56,0x22ae829a,0x32058833,0x69c807b6}},	//   ntoi_, sək_, atly_, _édef,
   {{0x6d9326e1,0xdefb0110,0x21248229,0x7c3b0580}},	//   nçav, шым_, _lamh_, _àuri,
   {{0xb4d60b6f,0xd25080f7,0xc4db04ae,0x3205ad57}},	//   हरू_, _سنة_, иђа_, ctly_,
   {{0xb87b0187,0x395d81c0,0x6ecb170c,0x200683ed}},	//   raíb, xhws_, _त्रु, ktoi_,
   {{0x29192d58,0x4c940198,0x0cab2d59,0x94ab14c4}},	// [1b50] mesa_, дитс, ртви_, ртва_,
   {{0x29192d5a,0x60dbad5b,0x6f188904,0x7bcd00c6}},	//   lesa_, _seum, jevc, rpau,
   {{0x3915885f,0x44292d5c,0x7bcd0110,0x9268108d}},	//   змер, sva_, spau, орца_,
   {{0x68fd1887,0xdb0b8106,0xdb1bad5d,0x28f88749}},	//   ngsd, _utgö, rqué, жець_,
   {{0x25a90ecb,0x67250074,0x39490118,0xdb1b85c9}},	//   mmal_, _kahj, _moas_, squé,
   {{0x7c29ad5e,0x9a87143d,0x3949056c,0x25a92d5f}},	//   vver, _дубл, _loas_, lmal_,
   {{0xd90f8065,0x2006ad60,0x7c29890d,0x316f8118}},	//   _لیا_, atoi_, wver, pigz_,
   {{0x25a902af,0x29192d61,0x67252d62,0xea0000ff}},	//   nmal_, jesa_, _lahj, _hiếp_,
   {{0x29192d63,0xc10480f7,0x7c2980e7,0x657e80e7}},	//   desa_, _توقي, uver, épha,
   {{0x63bd2d64,0x25a901ec,0x67252d65,0x7d09888b}},	//   _musn, hmal_, _nahj, sfes,
   {{0x29192d66,0x39490548,0x25a92d67,0x29000144}},	//   fesa_, _boas_, kmal_, _pcia_,
   {{0x3949062f,0x29192d68,0x7c29ad69,0x9f42001b}},	//   _coas_, gesa_, pver, mské_,
   {{0xdb03ad6a,0x9f4203fb,0x63bb01df,0x44298548}},	//   _minú, lské_, _éunh, _éa_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x9f4203cb,0x6da62d6b,0x2bb5000f,0x442f82f7}},	//   nské_, зива, _अंजा, _hrg_,
   {{0xf9920077,0x7ae1ad6c,0x63bd031d,0xb4d617ba}},	//   _ثبت_, lalt, _busn, हरे_,
   {{0x29c18028,0x27e9ad6d,0xaaba0a47,0xf48400d7}},	// [1b60] _hóa_, šanj_, مدار_, ذاری,
   {{0xdb0b8118,0x8b230d55,0x442f8362,0xed160035}},	//   _augú, ндуе, _mrg_, _łódź_,
   {{0x63b50da8,0x9f42016b,0xb6bb01c6,0xdb1989c4}},	//   _dizn, jské_, _לציי, _cuwé,
   {{0x7ae1ad6e,0x2d8081ac,0xa6d880ab,0x63bd2d6f}},	//   halt, čiek_, _সাইট, _fusn,
   {{0x18188077,0x7ae1a2d2,0x98a68162,0x29c1ad70}},	//   تراک_, kalt, чиде, _lóa_,
   {{0xbb4a0013,0x7bcb2d11,0x291902ec,0x2006ad71}},	//   _الآن_, ígue, zesa_, rtoi_,
   {{0x7ae18fe0,0x442f848d,0x6f188da8,0x29192d72}},	//   dalt, _arg_, revc, yesa_,
   {{0x6d4408de,0xd90d826a,0x7cf6880a,0x442f89ca}},	//   njia, _نیم_, dürü, _brg_,
   {{0x9f5900f2,0x29192d73,0x06e200ab,0x63bd0df6}},	//   ltså_, vesa_, _বানি, _xusn,
   {{0x27e6ad74,0x442f8573,0x44222d75,0x7ae1ad76}},	//   mson_, _drg_, _msk_, galt,
   {{0x442f82d8,0xc333036b,0x29192d77,0x6d5604b9}},	//   _erg_, גות_, tesa_, kkya,
   {{0x463b80be,0x26de876d,0x7ae194c7,0x68e28c53}},	//   _לעבע, _heto_, aalt, naod,
   {{0x7ae1ad78,0x26de80f1,0x24aa80ab,0x63602d79}},	//   balt, _keto_, _গ্রহ, _göng,
   {{0x27e683d3,0x7c22ad7a,0xd3708077,0x7ae1ad7b}},	//   ison_, _isor, _جهت_, calt,
   {{0x29192d7c,0x39920019,0x63b50289,0x2cb9008e}},	//   pesa_, tást_, _rizn, _pgsd_,
   {{0x26dead7d,0x9cfa8264,0x5d9901e2,0x3f8e9fb6}},	//   _leto_, _আসুন_, ікаў_, hofu_,
   {{0x68ed2d7e,0x68e2ad7f,0xa49b0032,0x27e68b80}},	// [1b70] _idad, daod, _abòr, json_,
   {{0x8aa705c2,0x02a70adb,0x25a901ec,0x6d562d80}},	//   пред, прем, smal_, akya,
   {{0x2b0e8023,0x60cda511,0x98bf8087,0xfe1b8424}},	//   त्यु_, ñamo, _nouă_, _भैंस_,
   {{0x1a6804c0,0x63bd2d81,0x9f42026f,0x7c22ad82}},	//   سیقی_, _tusn, vské_, _osor,
   {{0xea000104,0x26dead83,0xbcfb002a,0x7d0d2d84}},	//   _tiếp_, _beto_, _alég, mfas,
   {{0x9f42003e,0x7c2d2d85,0xaae10cfd,0x26de8041}},	//   tské_, mvar, _फ़िक, _ceto_,
   {{0x7ae1ad86,0x26de80b9,0xa3df873c,0x68ed0d6a}},	//   valt, _deto_, धीन_, _odad,
   {{0x7d0d1fba,0x98bf802e,0x27e90292,0x9f42027f}},	//   nfas, _două_, _ovan_, rské_,
   {{0xb4bd835a,0x7ae1ad87,0xbcfb2491,0xdc0b00ab}},	//   _आली_, talt, _elég, রিকস_,
   {{0x63600459,0x68ed2d88,0x04ff80ab,0x7cf68059}},	//   _gönd, _adad, ্যের_, türü,
   {{0x27e906c0,0x7c22ad89,0x6d5d061c,0x987000e1}},	//   _avan_, _esor, _olsa, rúča_,
   {{0x7ae1a6e1,0x442f8796,0x29e78c18,0xdb06002a}},	//   salt, _trg_, rđa_, _yukó,
   {{0x442f80b9,0x7ae1ad8a,0xeb8e8087,0x7d1bad8b}},	//   _urg_, palt, _аи_, meus,
   {{0xdfcf0013,0x6d4bad8c,0x442d920f,0x61faad8d}},	//   شيف_, _hoga, mve_, butl,
   {{0xab28845b,0xdb1b97ad,0x7d0d2d8e,0x7c2d0084}},	//   _رسول_, nquí, ffas, evar,
   {{0x7529ad8f,0x6d4bad90,0x78bb822e,0xe5a304fa}},	//   ndez, _joga, _nguv, виси,
   {{0x9f5fad11,0x6360016d,0x7c2d2d91,0x2fcd822c}},	// [1b80] _aquí_, _löne, gvar, _nteg_,
   {{0x6d4bad92,0xdcdaa769,0xa3df83eb,0xeb9f00e8}},	//   _loga, _यज्ञ, धीय_, _spør_,
   {{0x26deaa63,0x75262d93,0xc87f02af,0x7d1bad94}},	//   _reto_, _takz, raße_, keus,
   {{0x442d803a,0x63602d95,0x26dead96,0xaca38032}},	//   kve_, _sönd, _seto_, _afọj,
   {{0xd0108277,0x44222d97,0xa3f880ab,0x442d80f1}},	//   الت_, _usk_, _অন্য_, jve_,
   {{0x27e68782,0x60c9ad98,0x44200010,0x7d029429}},	//   rson_, _efem, mwi_, _scos,
   {{0xe1e78117,0x442dad99,0x656f031d,0x27e6ad9a}},	//   _جس_, eve_, _ymch, sson_,
   {{0x6f1c2d9b,0x636007d9,0x6d4b9a29,0x7d1bad9c}},	//   herc, _döne, _coga, geus,
   {{0xe3bf01df,0x26de928c,0xea0000ff,0x44200114}},	//   _xuñ_, _teto_, _khắp_, nwi_,
   {{0x6d9307e0,0x291202d6,0x68e0ad9d,0x61faad9e}},	//   nçar, _abya_, _hemd, tutl,
   {{0x6d4bad9f,0x7d2780f2,0x442dada0,0x7d1b8118}},	//   _foga, örsä, ave_, beus,
   {{0x7d1b8373,0x7c2284b9,0x442dada1,0x68e0826c}},	//   ceus, _tsor, bve_, _jemd,
   {{0xab2a91b3,0xf7730829,0x7c22882e,0x442000b4}},	//   _мода_, ناس_, _usor, jwi_,
   {{0x636007d9,0x6f1c2da2,0x44202da3,0x61faada4}},	//   _yöne, gerc, dwi_, putl,
   {{0x672880f1,0xb87b282b,0x7d0d242f,0x7dc782d0}},	//   _madj, caín, tfas, _kısa,
   {{0xbcfb2da5,0x6d4b862f,0x06e200ab,0x68ed2da6}},	//   _amér, _xoga, _বাণি, _udad,
   {{0xdd940196,0x7d0d10f6,0x6f1c2da7,0xb87b00f7}},	// [1b90] таты, rfas, berc, maío,
   {{0x6f1c2da8,0x672889cf,0xb87b0013,0x38668805}},	//   cerc, _nadj, laío, dzor_,
   {{0x442dada9,0x2fcdadaa,0x3f912dab,0x2bdf06f0}},	//   zve_, _steg_, mozu_, _पौरा,
   {{0xb4bd835a,0x63b8942f,0xb87b00f7,0x8aa40dd3}},	//   _आले_, _livn, naío, труд,
   {{0xe739a66c,0xdd910065,0x442d0091,0x6d4badac}},	//   зел_, _لوگ_, _ée_, _roga,
   {{0x25a68019,0x6d4badad,0x442dadae,0xb87b01a8}},	//   _ahol_, _soga, vve_, haío,
   {{0xf7708bbe,0x995c803e,0x7ae52daf,0xe8d911d3}},	//   جان_, síš_, maht, _alọ_,
   {{0x442dadb0,0x6f1c003e,0x94259fd0,0xdb1b85e4}},	//   tve_, zerc, емие, rquí,
   {{0x6d4badb1,0x442dadb2,0x291da5f3,0x7d1badb3}},	//   _voga, uve_, mewa_, reus,
   {{0x291d822e,0x4a45867c,0x1b1d00c8,0x629881b0}},	//   lewa_, енов, নাকে_, _byvo,
   {{0x44202db4,0x63b88503,0x442dadb5,0x6d4b8014}},	//   zwi_, _divn, sve_, _toga,
   {{0x2fc00722,0x9952026f,0x291dadb6,0x25b90f3e}},	//   _puig_, sáž_, newa_, _nisl_,
   {{0x25adadb7,0x394d879f,0xdbd70406,0xf1b9a944}},	//   mmel_, _moes_, _jäät, _miš_,
   {{0x7ae5178f,0x442006c4,0x291dadb8,0x63b8a085}},	//   jaht, vwi_, hewa_, _givn,
   {{0x69962344,0x59b98076,0x291dadb9,0xba5280f7}},	//   _прих, _ईंटर, kewa_, _منوع,
   {{0xa0a60048,0xb87b0013,0xa2cd08fd,0xf1b98024}},	//   _пайд, caío, दुस्, _niš_,
   {{0x248604c3,0xac861663,0x291dadba,0x2bdb001b}},	// [1ba0] çom_, хгал, dewa_, मीला,
   {{0x395fadbb,0xe6258028,0x44201044,0x6b520366}},	//   _alus_, _đông_, rwi_, _nægt,
   {{0x26d82dbc,0xa2a5053e,0x44202dbd,0x6728adbe}},	//   mbro_, _करण्, swi_, _radj,
   {{0x29022dbf,0x8c461593,0x39990019,0x67288353}},	//   ngka_, _земе, tési_, _sadj,
   {{0x394dadc0,0xea000129,0x2d802dc1,0x6728832a}},	//   _does_, _thắp_, mnie_, _padj,
   {{0x2d800063,0x69dc041c,0x6720052a,0x395fadc2}},	//   lnie_, _twre, मजिक_, _elus_,
   {{0xfaa31b2f,0x5693adc3,0x63830098,0x395f81b9}},	//   _баро, лашт, _сгра, _flus_,
   {{0x291dadc4,0x248681df,0xa53480c4,0xd00a9052}},	//   cewa_, _pxom_, тнич, _небе_,
   {{0x9f868221,0x63b89a7c,0xfbcf815b,0x2d802dc5}},	//   _згад, _pivn, یتی_, inie_,
   {{0x5a348e17,0x7c3b12ca,0x2d802dc6,0xdbdb846d}},	//   внот, _áure, hnie_, _dààt,
   {{0x7d0604b8,0x28f92dc7,0xb87b00f7,0x3f9110d1}},	//   _ocks, мень_, taío, vozu_,
   {{0x25d983f8,0xea000104,0x7c262dc8,0xa3c0000d}},	//   _آهنگ_, _nhập_, _oskr, ँदा_,
   {{0x2d800063,0xdd8f8154,0xb87b00f7,0xd83822f0}},	//   dnie_, _اون_, raío, нэр_,
   {{0x4426adc9,0x61fe003a,0x2d80009a,0xb87b00f7}},	//   _iso_, kupl, enie_, saío,
   {{0xbe880ca4,0x249f0088,0xdb03801b,0x59b09516}},	//   есте_, _šum_, _jiný, जगार,
   {{0x2d802dca,0x6564009c,0xba9b8039,0x4426adcb}},	//   gnie_, ghih, _מסוי, _kso_,
   {{0x44268088,0x26d800e5,0x7ae518c2,0x3ebe80c3}},	// [1bb0] _jso_, bbro_, taht, _ogtt_,
   {{0x6d5a08cf,0xd6db0009,0x2d800035,0x63ad8037}},	//   ëtar, _эти_, anie_, _èant,
   {{0xf7718bca,0x395fa4cc,0xa4d9245b,0x2d9202a0}},	//   یات_, _plus_, _одну_, boye_,
   {{0xdbd70364,0x4426811e,0x60b59e91,0x2d80009a}},	//   _päät, _oso_, نمائ, cnie_,
   {{0x4426815e,0xb8e98076,0xbcfb02ba,0x7ae50364}},	//   _nso_, _ईल_, _eléc, paht,
   {{0x394d81b0,0x6d4f0214,0x21298824,0xbcfb0866}},	//   _woes_, _hoca, žah_, _fléc,
   {{0x4426adcc,0x291d8010,0x6d4f2dcd,0x6b52006a}},	//   _aso_, pewa_, _koca, _vægt,
   {{0x752d2dce,0x69c78efc,0x7415845b,0x8477826b}},	//   ndaz, íjem, نوعا, _aáwẹ,
   {{0x51849fa0,0xdb1882d6,0x5f09866f,0xe4c895a9}},	//   _сура, _kivè, _साप्_, ربين_,
   {{0x2d802448,0x799d01ec,0x6b52008b,0xdd0201a1}},	//   znie_, elsw, _hægr, _čučk,
   {{0x4426adcf,0x96ca8540,0x36d48009,0x68e602e8}},	//   _eso_, _स्टॉ, _сохр, takd,
   {{0x27e98341,0x2902816d,0x4ad18701,0x6dbc131b}},	//   šanu_, _ökat_, _द्रव, _očar,
   {{0xf1b28f60,0xd24e80d5,0x8b25add0,0x3ebe8326}},	//   יסט_, منی_, _адле, _ygtt_,
   {{0x06e200ab,0x7bc00187,0x3ebe004a,0x6d5b8bf0}},	//   _বাহি, _émui, øtt_, lkua,
   {{0x6d4f2dd1,0x2d800063,0xfce60171,0x4426add2}},	//   _boca, tnie_, ково, _zso_,
   {{0x7ae38de1,0x2bc30fb8,0x6d5badd3,0x26d82dd4}},	//   _hent, _वंशा, nkua, sbro_,
   {{0xc9530051,0x78a40503,0x69c3add5,0x2d802dd6}},	// [1bc0] _כמה_, _uziv, _hune, rnie_,
   {{0x7ae3add7,0x69c39e98,0x27e02227,0x65642dd8}},	//   _jent, _kune, _iwin_, shih,
   {{0x6d4f0013,0x6dbc0353,0xdb1886c0,0xea0000ff}},	//   _foca, _včas, _divè, _thập_,
   {{0x7ae3add9,0x69c3adda,0x61fe2ddb,0x3f85826c}},	//   _lent, _mune, rupl, _ajlu_,
   {{0x69c3addc,0xf7468003,0xdb0baddd,0x7c26005c}},	//   _lune, кедо, _bugü, _uskr,
   {{0x7bd62dde,0x68e405d1,0x7d042ddf,0x7ae3ade0}},	//   mpyu, _leid, lgis, _nent,
   {{0x69c3ade1,0x91e30e02,0x27ed8051,0x752b81a1}},	//   _nune, _восе, _even_, _bagz,
   {{0x7d042de2,0x68e40114,0x39990f87,0x6d4f2de3}},	//   ngis, _neid, nést_, _xoca,
   {{0x7ae38763,0x63bc26a6,0x7c240192,0x27ed81f4}},	//   _bent, _kirn, nwir, _gven_,
   {{0x69c3ade4,0x3a27808e,0x4426807a,0xdb188061}},	//   _bune, _bsnp_, _vso_, _kivé,
   {{0x68e42de5,0x69c3ade6,0x7ae39ee5,0x6ed88f1b}},	//   _beid, _cune, _dent, _न्यु,
   {{0x442681e9,0x7c2400b4,0x7ae3ade7,0x629c2127}},	//   _tso_, kwir, _eent, _myro,
   {{0x7ae3ade8,0x5887014c,0x68e401e4,0x60cd8020}},	//   _fent, тына, _deid, ñami,
   {{0x7ae3ade9,0x63bc01a1,0x629c02c4,0x52e10035}},	//   _gent, _nirn, _oyro, _फ़ेस,
   {{0xe5c42dea,0xd378811f,0x68e40013,0x31668019}},	//   исто, mić_, _feid, khoz_,
   {{0x7ae3adeb,0x7982809a,0x7d042dec,0x9f59026f}},	//   _zent, jnow, ggis, musí_,
   {{0x63bc03c3,0x6c542ded,0x752d2dee,0x629c0420}},	// [1bd0] _birn, акту, rdaz, _ayro,
   {{0x7ae3862f,0x629c2def,0x7d042df0,0x68e40bfd}},	//   _xent, _byro, agis, _zeid,
   {{0x3f83011f,0xdb050013,0x6562adf1,0x27edadf2}},	//   mnju_, gmhá, _oloh, _sven_,
   {{0xd37885f5,0x6d4f026c,0x7c2402a0,0x9f4203c1}},	//   hić_, _uoca, bwir, mská_,
   {{0xd3788025,0x7ae8adf3,0x629c0bb1,0x9f4205b9}},	//   kić_, kadt, _eyro, lská_,
   {{0x65628091,0xd378803b,0x6360007b,0x490886a7}},	//   _aloh, jić_, _hönn, _हाथो_,
   {{0x63602df4,0x9f42003e,0xd378803b,0x2d55013c}},	//   _könn, nská_, dić_, _fået_,
   {{0xdb1d0a56,0x2d55013c,0x661a8748,0x4424822c}},	//   _musí, _gået_, _dptk, fwm_,
   {{0x7ae38193,0x6d5badf5,0x69c3adf6,0x3f831351}},	//   _pent, rkua, _sune, knju_,
   {{0xd37885f5,0xe9d99016,0x69c3adf7,0x2902816d}},	//   gić_, нко_, _pune, _ökar_,
   {{0x3f83003b,0xc3320158,0xdb0385e4,0x68e42df8}},	//   dnju_, זוי_, _sinó, _peid,
   {{0x69c380fe,0x290911b9,0x7412803d,0x9f42016b}},	//   _vune, _ccaa_, جویا, dská_,
   {{0x68e42a24,0xd3788d78,0xe9e980e1,0xa3dfab12}},	//   _veid, bić_, dnúť_, धीश_,
   {{0x44322df9,0x68e40faf,0xd378809a,0x2d992dfa}},	//   vvy_, _weid, cić_, _akse_,
   {{0x68e42dfb,0x39990019,0x2bdf81fe,0x31790035}},	//   _teid, tést_, पीरा, bisz_,
   {{0x96d411bc,0x63bc2dfc,0x7c242dfd,0x2d960a14}},	//   _ब्रॉ, _sirn, twir, ургс,
   {{0x6da30087,0x09cc016f,0x3f832bea,0x629c0690}},	// [1be0] сита, ाऱ्य, bnju_, _syro,
   {{0x7c242dfe,0x44322dff,0xfbcd00ab,0x87260009}},	//   rwir, rvy_, _লিখত, _смож,
   {{0xe8faa9d7,0x20022e00,0x7c242e01,0x644001a1}},	//   еле_, luki_, swir, _šmid,
   {{0x629c027f,0xd3788d78,0x786a8019,0x88e68198}},	//   _vyro, zić_, _növé, ужде,
   {{0x63bc2e02,0x20022e03,0xe3c880ff,0x629c0035}},	//   _tirn, nuki_, _mực_, _wyro,
   {{0xdb1c00f1,0xe3c88028,0x31668019,0x96a8001b}},	//   _mirë, _lực_, shoz_, _गराउ,
   {{0xd378803b,0x6b631594,0x7bc60300,0xd6d9804a}},	//   vić_, _укра, _huku, тті_,
   {{0x7bc62e04,0x3f83007d,0x1db4035a,0xd378809a}},	//   _kuku, znju_, ंगित, wić_,
   {{0xd378803a,0x12e68a4c,0x7bc62e05,0xe64483bf}},	//   tić_, лінг, _juku, ılığ,
   {{0x96d42e06,0x20022e07,0x7bc620d7,0x39402e08}},	//   _ब्लॉ, duki_, _muku, _anis_,
   {{0xd378803a,0x7bc62e09,0xdb0380f7,0x3f832e0a}},	//   rić_, _luku, _ghní, vnju_,
   {{0x2ee58613,0xe3c88028,0x9f42026f,0xf1ab0077}},	//   _zelf_, _cực_, vská_, عاده_,
   {{0x8d938013,0x3f830024,0x7bc62e0b,0x69c100e7}},	//   _النش, tnju_, _nuku, _élev,
   {{0x9f42026f,0x3179009a,0x28e30128,0x636001fa}},	//   tská_, sisz_, परहि, _sönn,
   {{0x58d50698,0x31790063,0xe8d90135,0x3f83012b}},	//   _койт, pisz_, _ajụ_, rnju_,
   {{0x7bc62e0c,0x3f8302a5,0x9f42026f,0x20022e0d}},	//   _buku, snju_, rská_, buki_,
   {{0x7bc60763,0x3f83173d,0x337513bf,0x80cd8264}},	// [1bf0] _cuku, pnju_, агар, ারম্,
   {{0x7bc62e0e,0x9f42128a,0x332e8372,0xa3e6885d}},	//   _duku, pská_, _jafx_, यीय_,
   {{0xfaa7174a,0x02a726b1,0xb4db0362,0xe9e981d6}},	//   ушан, урам, _cnàc, pnúť_,
   {{0xdc34026f,0x27ed012b,0x2ee58039,0x3835802e}},	//   _zúča, šenu_, _self_, инер,
   {{0x7bc61b19,0x3b0a0580,0x5045847f,0x6360029a}},	//   _guku, _fcbq_, релб, _könl,
   {{0x6d4d2e0f,0xb0d580d4,0x29068102,0x2b140ebf}},	//   ljaa, _ड्रग, agoa_, न्दु_,
   {{0xf1a785c2,0x7bc601ec,0xd0560085,0xf1c980ff}},	//   _бран, _zuku, _deyə, _mạc_,
   {{0x442b2e10,0x6d4d2e11,0xf1c98028,0x528400f7}},	//   _ksc_, njaa, _lạc_, _الفك,
   {{0x7bc602a3,0xab6595ac,0x2ee5ae12,0x69ceae13}},	//   _xuku, ивил, _telf_, íben,
   {{0xce6b9a19,0x69c72e14,0xd7a4000f,0x68eb84dc}},	//   _пред_, _kuje, _खींच, lagd,
   {{0x216a22df,0x6723895e,0xa96a013a,0xfaa5ae15}},	//   вини_, menj, вина_, рано,
   {{0x69c704a1,0x67238353,0xdc3401ac,0x442b00ee}},	//   _muje, lenj, _súča, _osc_,
   {{0x6603ae16,0xe3c88028,0x25e30540,0xf1c9801c}},	//   lunk, _vực_, टीसी_, _bạc_,
   {{0x7bc62e17,0x66e301e5,0x20022e18,0x6723ae19}},	//   _ruku, жора, ruki_, nenj,
   {{0x13da80c8,0x7bc62e1a,0x20020590,0x799b8c56}},	//   _দিয়, _suku, suki_, _okuw,
   {{0x7bc613b8,0x6723ae1b,0x6446816d,0x39402e1c}},	//   _puku, henj, åkig, _unis_,

   {{0x6723ae1d,0x644984c3,0x69d5011e,0x68eb96fb}},	// [1c00] kenj, nxei, _atze, dagd,
   {{0x44392e1e,0xaaba026a,0x6603ae1f,0x25a0141f}},	//   _drs_, ندار_, kunk, slil_,
   {{0x44392e20,0x7ae72e21,0x69c70052,0x67238805}},	//   _ers_, _dejt, _cuje, denj,
   {{0x7bc62e22,0xe3c8801c,0xdb0f0825,0x44392e23}},	//   _tuku, _lựa_, _bucó, _frs_,
   {{0x6a4a8201,0x2906ae24,0x33d52e25,0x3860978e}},	//   rəfi, rgoa_, _гіст, áir_,
   {{0x752f009a,0x6723ae26,0x25e30105,0x78a9826c}},	//   _zacz, genj, टीवी_, _dzev,
   {{0x69c18526,0x25fd8f85,0x7c2d8e9f,0x9f590036}},	//   _रंगी, रंगी_, _šarp, ursé_,
   {{0x3f98001b,0xdb1c21bf,0xa6e9801c,0x7ae72e27}},	//   horu_, _sirè, _ngươ, _zejt,
   {{0x69c0ae28,0x442b0118,0x6723ae29,0xdb072e2a}},	//   _iime, _xsc_, benj, _gijó,
   {{0x4aaa2e2b,0x6723803b,0x69c0ae2c,0x7c398122}},	//   _कराव, cenj, _hime, _drwr,
   {{0x69c10065,0x195917ae,0x69c0ae2d,0xe3c880ff}},	//   _élet, ганы_, _kime, _dựa_,
   {{0x50672e2e,0xf1c980ff,0x2c5e00eb,0x69c0ae2f}},	//   атга, _sạc_, _kādā_, _jime,
   {{0xb8cf0403,0x938a8098,0x8ca20d86,0x68f6031d}},	//   _कर_, _иска_, _खरगो, _ddyd,
   {{0x69c0ae30,0x3f9802a5,0x09d700ab,0x65662e31}},	//   _lime, goru_, _হিসা, _alkh,
   {{0x7ae72e32,0x752f0035,0xdef801e2,0xa1870d15}},	//   _rejt, _pacz, шыя_, _выпл,
   {{0x81c40a49,0x69c0ae33,0x672380d2,0x442b009f}},	//   _এবং_, _nime, zenj, _psc_,
   {{0x69c72e34,0x6d4d2e35,0x61fe110f,0xf2c701cf}},	// [1c10] _suje, rjaa, erpl, асен,
   {{0x34a7023c,0x69c0ae36,0x44392e37,0xdb0a80f7}},	//   _खरीद, _aime, _vrs_, _bhfé,
   {{0x6723ae38,0x5f00800f,0x69c0ae39,0x6d428162}},	//   venj, _राज्_, _bime, _onoa,
   {{0xdd8683f8,0x98a9811f,0x44392e3a,0xdb0f0144}},	//   _رو_, žač_, _trs_, _pucó,
   {{0xe8f8902a,0x7ae70038,0x44392e3b,0x6723a76e}},	//   рлі_, _tejt, _urs_, tenj,
   {{0x44292578,0x2fc901e9,0x6d4282c4,0x6603a9bd}},	//   mwa_, _muag_, _anoa, tunk,
   {{0x672382a5,0x442926e0,0x2fc901e9,0xdb1881df}},	//   renj, lwa_, _luag_, _civí,
   {{0x6723825b,0x6603ae3c,0x99858013,0xf8bf2e3d}},	//   senj, runk, _الرو, ndés_,
   {{0x44292e3e,0x1c4297ae,0x681a80eb,0x6723acc7}},	//   nwa_, зным, gādā, penj,
   {{0x69c08010,0x6569ae3f,0x44292e40,0xb4e68035}},	//   _zime, sheh, iwa_, _बड़ी_,
   {{0x44292e41,0xb6358277,0xed358162,0x68e9ae42}},	//   hwa_, _دفاع, _гэлэ, _keed,
   {{0x44292e43,0x68e982a3,0xce689878,0x3f982e44}},	//   kwa_, _jeed, _труд_, woru_,
   {{0x3438819f,0xa2e800c8,0x68e9ae45,0x2fc901c5}},	//   _پسند_, _পাসও, _meed, _cuag_,
   {{0x59cf8a16,0x4429029b,0x50d80eed,0x68e9ae46}},	//   _संपर, dwa_, _भ्रष, _leed,
   {{0x44292e47,0x7c29844e,0xdb0380f7,0xc8798087}},	//   ewa_, lwer, _ghná, _deşi_,
   {{0xbf9b03a7,0x68e98039,0x44292e48,0x3f982e49}},	//   quên, _need, fwa_, soru_,
   {{0x44292e4a,0x7c29ae4b,0x69c0ae4c,0x75242a6b}},	// [1c20] gwa_, nwer, _rime, reiz,
   {{0x69c0ae4d,0x06e200ab,0x290d8087,0x7d098192}},	//   _sime, _বাকি, _acea_, hges,
   {{0xcf57004c,0xe1fa168a,0xe80a8076,0x44291f11}},	//   _הבית_, уге_, हूना_, awa_,
   {{0x44291d1b,0xb4e6923a,0x7c29ae4e,0x2638026f}},	//   bwa_, _बजे_, kwer, _ičo_,
   {{0x7bcfa6f0,0x69c0ae4f,0x7d09949d,0x6360016d}},	//   ícul, _vime, dges, _jönk,
   {{0x69da9766,0xaa462e50,0x7c29ae51,0x2d9d8326}},	//   ypte, _легл, dwer, _akwe_,
   {{0x69c0ae52,0xf38a877f,0x68e9ae53,0x6b630d15}},	//   _time, nṣe_, _feed, _экра,
   {{0x68e98079,0x7c29ae54,0xea00001c,0xdb1885e4}},	//   _geed, fwer, _chấp_, _viví,
   {{0x7866a804,0x80668f75,0x7c29ae55,0xa6c000ab}},	//   _указ, _уваж, gwer, ্রিয়,
   {{0x681a8029,0x6e3ca868,0x2619009a,0x7d09ae56}},	//   rādā, _árbo, _पहली_, ages,
   {{0x44292e57,0x6b9b00be,0x68e981b4,0xcb9b1101}},	//   zwa_, רשיד, _yeed, רסיט,
   {{0xd90f15e4,0x44292e58,0x7c2983f4,0x2fc901c5}},	//   ریخ_, ywa_, bwer, _puag_,
   {{0x34a7016f,0x2fc901c0,0xf8ba970c,0x91ca80bc}},	//   _खरेद, _quag_, ेशिय, _संवै,
   {{0x44290205,0x2fc90069,0xd7f80198,0x69daae59}},	//   vwa_, _vuag_, щую_, ppte,
   {{0xf1c98028,0x7aea802e,0x442904b7,0x4b7b8e82}},	//   _hạn_, _ieft, wwa_, _תאוו,
   {{0x44292e5a,0x2fc92e5b,0x46d9064a,0x6b9a87f1}},	//   twa_, _tuag_, _ब्रह, lotg,
   {{0x68e9ae5c,0xd05d0201,0xf8bf2e5d,0x44292e5e}},	// [1c30] _reed, yasə, rdés_, uwa_,
   {{0x44292e5f,0x7aea803a,0x69caae60,0xf1c980ff}},	//   rwa_, _jeft, _kufe, _mạn_,
   {{0x44292e61,0x201f8087,0x7d09867f,0x9d190087}},	//   swa_, _spui_, yges, _конт_,
   {{0xe705026a,0x44292e62,0x69ca8e72,0x3f9eae63}},	//   _اسکی, pwa_, _mufe, _aktu_,
   {{0x44292e64,0x260681ce,0xf1c9801c,0xbae800ab}},	//   qwa_, सूसी_, _nạn_, _পারছ,
   {{0x7c2f0698,0xe739ae65,0x7aea8085,0x45d58293}},	//   _iscr, рек_, _neft, оцит,
   {{0x7d098e61,0x636d8c52,0x7c299699,0x9c1381bc}},	//   tges, _húng, wwer, _tọkw,
   {{0xf1c98142,0xf77391fb,0x7c29ae66,0xed5993f1}},	//   _bạn_, _کار_, twer, рои_,
   {{0x7d09ae67,0x69d8ac62,0x7c2981ed,0x25fd8fd5}},	//   rges, _atve, uwer, रूजी_,
   {{0x7c29910f,0x7d09ae68,0x6d932e69,0x3205816b}},	//   rwer, sges, lħad, tuly_,
   {{0xdce2803a,0xea00001c,0x2d8910e4,0xdd9983f2}},	//   _zloč, _thấp_, knae_, poň_,
   {{0x26138073,0x24198009,0x7c29ae6a,0xdb0180e7}},	//   mão_, _воды_, pwer, illé,
   {{0x26138073,0x656d2e6b,0xb87b0207,0x6b9aae6c}},	//   lão_, dhah, daís, botg,
   {{0x88ba8039,0x78ad0b80,0xdb0a87f1,0x7bd98db1}},	//   יזרי, _dzav, _difó, _itwu,
   {{0x3ebe2e6d,0x443dae6e,0x7bcbae6f,0x26138187}},	//   ätt_, _hrw_, _hugu, não_,
   {{0x7bc39341,0x7bcb8f45,0x656d02b8,0x2d8902f7}},	//   _hinu, _kugu, ghah, gnae_,
   {{0x7bcbae70,0x7bc3ae71,0xfd648135,0x64a32e72}},	// [1c40] _jugu, _kinu, _anwụ, дата,
   {{0xaac986bf,0xdb188019,0x443d8333,0x636001ec}},	//   रशिक, _kivá, _mrw_, _köni,
   {{0x442f82f7,0x26138187,0x7bcbae73,0x2d9e0036}},	//   _lsg_, jão_, _lugu, îtes_,
   {{0xdce280ce,0x26138073,0x8c4609e0,0x02aa12c6}},	//   _ploč, dão_, _деме, _करीन,
   {{0x274a80ae,0x2eeeae74,0x6d462e75,0x443dae76}},	//   ичко_, taff_, _inka, _nrw_,
   {{0x442209da,0x7bc3ae77,0x29d70372,0x2613841c}},	//   _ipk_, _ninu, _bħad_, fão_,
   {{0x7bcb9e44,0x2eeeae78,0x261383a7,0xf1c9801c}},	//   _augu, raff_, gão_, _sạn_,
   {{0x54549bc1,0x7bc38006,0x7bcbae79,0x44220b99}},	//   звит, _ainu, _bugu, _kpk_,
   {{0x68e2ae7a,0xa067ae7b,0xa2be063a,0x7bc3a68b}},	//   mbod, _дата_, _वृत्, _binu,
   {{0x7bcb8102,0xb4db009f,0x2d680214,0x7bc3808e}},	//   _dugu, _anàl, rşey_, _cinu,
   {{0x6d462e7c,0x78ad0019,0x7bc3ae7d,0x261383a7}},	//   _onka, _szav, _dinu, cão_,
   {{0x7bc3807b,0xdb1d02af,0xdb18826f,0x3f9c80fa}},	//   _einu, _zusä, _divá, lovu_,
   {{0x6440011f,0x6727022b,0x69caae7e,0x60c901a1}},	//   _šmin, tejj, _wufe, žemo,
   {{0x3f9c8025,0x6d460835,0x7c228136,0x7bc3ae7f}},	//   novu_, _anka, _ipor, _ginu,
   {{0x69d8ae80,0x44222e81,0xdb1c0118,0x656d00d7}},	//   _utve, _apk_, _cirí, thah,
   {{0x3f9c8042,0x31690052,0x44222e82,0x656d2e83}},	//   hovu_, _ulaz_, _bpk_, uhah,
   {{0xb87b2a63,0x261383a7,0x78ad03fb,0x636d802a}},	// [1c50] raís, zão_, _uzav, _fúnd,
   {{0x656d2e84,0x27e92e85,0xfaa71383,0x6d462e86}},	//   shah, _iwan_, ошен, _enka,
   {{0x68ed0867,0xa2be0af3,0x26138073,0x27e90683}},	//   _kead, _वृद्, xão_, _hwan_,
   {{0x68e28091,0x27e92bb7,0xa2daa769,0x61e701c0}},	//   gbod, _kwan_, पुत्, _vwjl,
   {{0xd6bd00c8,0xf7458f13,0x442200b9,0xb8d3864a}},	//   _অভিয, зело, _gpk_, _ऑर_,
   {{0x26138003,0xdfce8013,0x7d0d2e87,0x7c2d2668}},	//   tão_, ديو_, lgas, mwar,
   {{0x7c22ae88,0x59c69344,0x7bc3ae89,0xf9938277}},	//   _apor, _रंगर, _rinu, _قبر_,
   {{0x261380a9,0x7d0d2e8a,0x7bcb809f,0x442fae8b}},	//   rão_, ngas, _pugu, _psg_,
   {{0x261380a9,0xa3e68076,0x7bc3ae8c,0x7c2d2e8d}},	//   são_, यील_, _pinu, nwar,
   {{0x59cf8935,0x261383a7,0x31b6066b,0x6d9304b7}},	//   _संदर, pão_, ृद्ध, nħab,
   {{0xe299839d,0x7c2d2e8e,0x27e92e8f,0x7bc3ae90}},	//   сан_, hwar, _awan_, _vinu,
   {{0x7c2d082e,0xbea8803d,0xfc3f077f,0x68ed0cb5}},	//   kwar, _بهمن_, _orí_, _cead,
   {{0x7bc3ae91,0xf1c98104,0x8d748077,0xdb1c0118}},	//   _tinu, _tạo_, _تالا, _sirí,
   {{0x81e10a49,0x442d82f4,0x7c2d2e92,0x657d2e93}},	//   _দিন_, mwe_, dwar, _amsh,
   {{0x6d5980a4,0x442dae94,0x68ed0ad0,0xdcfb807d}},	//   _kowa, lwe_, _fead, gnuć,
   {{0x60c9ae95,0x7d0d0fc3,0xdb1c03a2,0x3f9cae96}},	//   _ngem, ggas, _virí, zovu_,
   {{0x442dae97,0x7c2d2e98,0x2b581458,0x6d598c2e}},	// [1c60] nwe_, gwar, _porc_, _mowa,
   {{0x083b0051,0x291f81bc,0x7d0d2e99,0x44222e9a}},	//   _פעיל, _abua_, agas, _vpk_,
   {{0xa9268991,0xb6a300e7,0x442dae9b,0xa75b01c6}},	//   здел, éâtr, hwe_, _הדיר,
   {{0x442da08c,0x6d59ae9c,0xfc3f01fa,0x68ed03a8}},	//   kwe_, _nowa, _frí_, _xead,
   {{0x07a69285,0x442d8578,0x684681e5,0x68e2ae9d}},	//   падн, jwe_, янда, rbod,
   {{0xe3a78b76,0x501b0039,0x21200359,0x1b0300ab}},	//   _سر_, מונו, _lbih_, র্বে_,
   {{0x7d1bae9e,0x2cc18201,0x442d81b0,0x6d59838a}},	//   ffus, ərdə_, ewe_, _bowa,
   {{0x3f9c825b,0x6b818013,0x69ce0087,0x7d7880f7}},	//   sovu_, eilg, _iube, تمبر_,
   {{0x442dae9f,0x69ce2ea0,0x68ed0051,0x6d59aea1}},	//   gwe_, _hube, _read, _dowa,
   {{0x69ce0f45,0x68ed2ea2,0xb4ac800d,0x27f7800d}},	//   _kube, _sead, _गरी_, ření_,
   {{0x52138071,0xcfc400ab,0x442daea3,0x7c2d2ea4}},	//   ндэт, ্ঠান, awe_, zwar,
   {{0x442daea5,0x7c22973d,0x7982809a,0x69ce1bcb}},	//   bwe_, _tpor, niow, _mube,
   {{0x7c22aea6,0x69ce2ea7,0x43468ba5,0x6b819c0a}},	//   _upor, _lube, _недв, bilg,
   {{0xc7c40009,0x6d59aea8,0xb9042261,0x69dc2ea9}},	//   есси, _zowa, _प्_, _otre,
   {{0xd7888104,0x68ed0006,0x21200fda,0x69ce05e4}},	//   yển_, _tead, _fbih_, _nube,
   {{0xbcfb2eaa,0x7c2d262b,0x7aee0f3e,0x7d0d0789}},	//   _llév, twar, _aebt, ugas,
   {{0x94ab2eab,0x7d0d2eac,0x69dc209c,0x2d5802c7}},	// [1c70] ства_, rgas, _atre, чить_,
   {{0x212b2ead,0x69ce2eae,0x3dc680b9,0x7c2d2eaf}},	//   lech_, _bube, _liow_, rwar,
   {{0x69ce2eb0,0x442daeb1,0x200b00d2,0x35b52eb2}},	//   _cube, zwe_, luci_, _обор,
   {{0xfc3f2eb3,0x6b81aeb4,0x212b2eb5,0x69ce2eb6}},	//   _trí_, zilg, nech_, _dube,
   {{0xf77084c0,0x6d59aeb7,0x20192eb8,0x200b0503}},	//   گان_, _rowa, ntsi_, nuci_,
   {{0x6d59aeb9,0x7bdd2eba,0xf09400be,0x25a92ebb}},	//   _sowa, _itsu, ענס_, llal_,
   {{0xf770806b,0xa3c29a1c,0x69ce2ebc,0x442d867f}},	//   دان_, ्दन_, _gube, wwe_,
   {{0x442da0d7,0x61fa007b,0x7982809a,0x7bc70144}},	//   twe_, _ætla, ciow, _hiju,
   {{0x442d8586,0x6b81aebd,0x200b0042,0x212b001b}},	//   uwe_, tilg, juci_, dech_,
   {{0xe1f99bc1,0x442daebe,0xdb1c0019,0x7bcf261d}},	//   ого_, rwe_, _kirá, _mucu,
   {{0x7bcf2ebf,0x3f832ec0,0x442da6bd,0xf1c9801c}},	//   _lucu, diju_, swe_, _tạm_,
   {{0x290f859c,0x7bdd0006,0xdb1c0333,0x37e20264}},	//   ngga_, _otsu, _mirá, _বিবর,
   {{0x02aa1344,0x59cf858c,0x7bdd01e9,0x200b00d2}},	//   _कर्न, _संवर, _ntsu, guci_,
   {{0x3f830025,0x6b8182a6,0xdb1c0144,0x1b030264}},	//   giju_, qilg, _oirá, র্তে_,
   {{0x7bcf03d3,0x6372006a,0xe5a62ec1,0xddd401d6}},	//   _aucu, _hæng, диви, ňažn,
   {{0x7bcf0012,0xdb188364,0x200b2ec2,0x2d8daec3}},	//   _bucu, _eivä, buci_, nnee_,
   {{0xe73a15fe,0x3f831487,0x7bc72ec4,0x6721a7b1}},	// [1c80] _деп_, biju_, _biju, _oblj,
   {{0x39490025,0x09e61bc1,0x6372006a,0x316d86c4}},	//   _znas_, дожн, _mæng, _alez_,
   {{0x7bc701f1,0x63720022,0x39990e06,0x6b9e2ec5}},	//   _diju, _læng, vész_, ropg,
   {{0x6e3ca6d5,0x7aee2ec6,0xdb1c0333,0xfc4a9434}},	//   _árbi, _webt, _dirá, ntíð_,
   {{0xb4ac800d,0xdfcf8c3b,0x7bc7017f,0x629500b9}},	//   _गरे_, لين_, _fiju, _exzo,
   {{0x212b085d,0x26d82ec7,0x3dc680b9,0x6d5d8106}},	//   zech_, ncro_, _siow_, ösan,
   {{0x69dc239a,0x63600019,0x200b2ec8,0xdb1c002a}},	//   _utre, _dönt, zuci_, _girá,
   {{0x2d8daec9,0xd8268a2e,0x63648580,0x6d56018f}},	//   gnee_, _одби, _iòni, njya,
   {{0xf8b28105,0xae0282f1,0x212b2eca,0x657a1a1f}},	//   _जरिय, रूजन_, vech_, éthy,
   {{0xd370845a,0x200b02a5,0x6eb6866e,0xdb0a8174}},	//   اهد_, vuci_, _قصائ, _bhfá,
   {{0xc3331a0f,0x3f83005c,0x212b001b,0x25a02ecb}},	//   דות_, viju_, tech_, koil_,
   {{0x80fb23e6,0x6372006a,0x63600106,0xe7f58035}},	//   ्लेख_, _fæng, _köns, ुंचा_,
   {{0x3f83025b,0x212b2ecc,0x63602ecd,0xd8380087}},	//   tiju_, rech_, _yönt, мэр_,
   {{0x4426aece,0x2d84aecf,0x6360016d,0xa2948a8e}},	//   _ipo_, lime_, _möns, _палі,
   {{0x290f8186,0x212b1e1e,0x200b09c4,0x63600106}},	//   ygga_, pech_, suci_, _löns,
   {{0x394905b4,0x26170073,0x2d84aed0,0x7bcf2ed1}},	//   _unas_, rço_, nime_, _pucu,
   {{0x36d516df,0x60cd26bd,0x9f4205b9,0xc3130032}},	// [1c90] _попр, _igam, lský_, _ajíṣ,
   {{0x25a91807,0x4426aed2,0x316d81a1,0x2006aed3}},	//   slal_, _mpo_, _slez_, droi_,
   {{0x9f42027f,0x2d84aed4,0x7bc72ed5,0x636487f1}},	//   nský_, kime_, _viju, _còni,
   {{0x4adf0913,0x3949840e,0x4426aed6,0xdb1c0019}},	//   _प्रव, ñas_, _opo_, _virá,
   {{0x44268282,0x752d002e,0x636d80f7,0x60cd2ed7}},	//   _npo_, meaz, _lúna, _mgam,
   {{0x752d002e,0xbcfb2ed8,0x2d848118,0x798083f7}},	//   leaz, _elét, eime_, _emmw,
   {{0x442688cf,0x69ca8128,0x6da5aed9,0x38698916}},	//   _apo_, _संगी, ника, šar_,
   {{0x636000f2,0x60cd2eda,0x752d002e,0x2d84aedb}},	//   _föns, _ngam, neaz, gime_,
   {{0x6d5d2edc,0x6442aedd,0xa2d606bf,0x4426808e}},	//   _mosa, _croi, मुक्, _cpo_,
   {{0x644294e1,0x60cd20fc,0x4426aede,0xf1c9801c}},	//   _droi, _agam, _dpo_, _hại_,
   {{0x442684be,0x80c200d4,0x636d81a8,0x2d84aedf}},	//   _epo_, रेने, _cúna, bime_,
   {{0x6442aee0,0x6d5d2ee1,0x5c758256,0x752d0087}},	//   _froi, _nosa, _плет, jeaz,
   {{0x6d4baee2,0xeb8e96cf,0xf1c98028,0xec6e8dc0}},	//   _inga, _би_, _mại_, _сп_,
   {{0xf1c98104,0x27ed8f23,0xa3c08540,0x443fad3c}},	//   _lại_, _mwen_, ंगण_, mvu_,
   {{0x6d5d056f,0x69ce8e15,0x60cd002a,0x443faee3}},	//   _bosa, íbet, _fgam, lvu_,
   {{0x6d5d2ee4,0x753baee5,0xed5715d1,0xf65280be}},	//   _cosa, nduz, нос_, נצן_,
   {{0x6d5d2ee6,0x443f82ec,0x2fdf8069,0xf1ac1251}},	// [1ca0] _dosa, nvu_, _ntug_, _टीएन,
   {{0x60dbaee7,0x25a02ee8,0x27e00110,0x79862ee9}},	//   _afum, soil_, _itin_, likw,
   {{0x6d4baeea,0x6d5d1d8c,0x090695bf,0x443faeeb}},	//   _onga, _fosa, епен, hvu_,
   {{0x2d84aeec,0x443f803a,0x7e6100f2,0x79862eed}},	//   xime_, kvu_, älpe, nikw,
   {{0x40349071,0x69c9aeee,0x63a1aeef,0x2d84aef0}},	//   телс, _diee, koln, vime_,
   {{0x6d4baef1,0xf1ca0129,0x4426aef2,0x60dbaef3}},	//   _anga, _dại_, _rpo_, _efum,
   {{0xe297111c,0xe5c68ada,0x443f9693,0x27ed8706}},	//   _зар_, нсио, evu_, _ewen_,
   {{0x9f42003e,0xd5b781bb,0xdb1c0214,0x29000135}},	//   vský_, нсы_, _birç, _ndia_,
   {{0x6d4b8359,0x6372006a,0x70af123a,0x79862ef4}},	//   _dnga, _tænd, _घरेल, dikw,
   {{0x8883a86e,0x2d84aef5,0x5c739663,0x752d002e}},	//   _служ, sime_, ульт, zeaz,
   {{0x27e0009c,0x7e9a8a47,0xa294902a,0x2a6a8061}},	//   _atin_, _عنصر_, тані, ább_,
   {{0x32029385,0x6442aef6,0x9f421c18,0x67d526b1}},	//   čky_, _troi, rský_, кому,
   {{0x38668722,0x752d0087,0x4426aef7,0x63a1aef8}},	//   nyor_, veaz, _upo_, boln,
   {{0x6d5d00a4,0x4432031d,0x66010019,0x69ce802a}},	//   _sosa, dwy_, álko, íbes,
   {{0xf1a72657,0x79a718ff,0x752d2ef9,0x644780eb}},	//   _прин, _прие, teaz, ājie,
   {{0x60cd2efa,0xbcfb25a7,0x29d70372,0xe534076a}},	//   _ugam, _alér, _bħan_, лесь,
   {{0x752d0012,0x7bcaaefb,0xfbd3006b,0x6d5d2efc}},	// [1cb0] reaz, _kifu, اتر_, _vosa,
   {{0x673aa4a0,0x752d002e,0x60dbaefd,0x7bca804f}},	//   _natj, seaz, _sfum, _jifu,
   {{0x6d5d0013,0x752d0870,0x69c98029,0x61faaefe}},	//   _tosa, peaz, _piee, nstl,
   {{0x7ff5819f,0xbcfb0065,0x27ed86c0,0xb4db0980}},	//   نستا, _elér, _pwen_, _anàv,
   {{0xa3c283bb,0xe7399878,0xa3c0aeff,0x29d704b7}},	//   ्दा_, дел_, ंगा_, _għan_,
   {{0x25a6af00,0x6d4b80dd,0xdb0501a8,0x79862f01}},	//   _akol_, _snga, rmhó, zikw,
   {{0x6d4b80dd,0xed59af02,0x63a183c1,0x61ee0428}},	//   _pnga, дой_, voln, _gwbl,
   {{0xf1ca0104,0x92e900c8,0x63a1809a,0xf1a4af03}},	//   _tại_, _যায়_, woln, _брун,
   {{0x02c98aed,0x210401e2,0xe3b98703,0x656982af}},	//   रश्न, nčių_, мби_, rkeh,
   {{0x4a458e12,0x443faf04,0x200faf05,0x6569af06}},	//   внов, rvu_, mugi_, skeh,
   {{0x3f87af07,0x200faf08,0x6aaa831d,0x779087d2}},	//   minu_, lugi_, _cyff, _دیوا,
   {{0x3f87af09,0x6d4ba890,0x212f826c,0x69dc8174}},	//   linu_, _unga, negh_, írea,
   {{0x63a18db7,0x8d74af0a,0x79862f0b,0xb0a51774}},	//   poln, _حالا, rikw, _गुदग,
   {{0x25adaf0c,0x79862970,0xa283803d,0x25bf8087}},	//   llel_, sikw, _میخو, lmul_,
   {{0xbea60056,0x7af70079,0x6aaa8114,0xe3c880ff}},	//   тавк, daxt, _gyff, _cựu_,
   {{0x395faf0d,0x1614000f,0x7bcaaf0e,0x44320035}},	//   _nous_, तंबर_, _zifu, twy_,
   {{0xccf2812a,0xf773003d,0x3f87af0f,0x61fc0390}},	// [1cc0] יכן_, _چاپ_, kinu_, _svrl,
   {{0x4432064c,0x200f8074,0xc88701ec,0x31caaac2}},	//   rwy_, dugi_, ößer_, िद्ध,
   {{0x3f878289,0xc33284de,0xf506028b,0x7ae58074}},	//   dinu_, שוב_, _изно, _õhtu,
   {{0xcfe680c8,0xb8162701,0x4a5a8039,0x200faf10}},	//   _নিবন, _तमाम_, ודעו, fugi_,
   {{0x395faf11,0x394d8775,0x261486b7,0x2d922f12}},	//   _dous_, _dnes_, नूनी_, mnye_,
   {{0x394daf13,0x3f87807b,0xbf9b00e7,0x2d9200dd}},	//   _enes_, ginu_, quêt, lnye_,
   {{0x6e288713,0x7bca9360,0x6aa301ec,0x2bd8143e}},	//   _qpdb, _rifu, ünft, _भंडा,
   {{0x2d922f14,0x7bcaaf15,0x3160011b,0xfbe78129}},	//   nnye_, _sifu, _noiz_, _thế_,
   {{0x3f878024,0x2d9200b9,0xd0e30c2d,0x47c68110}},	//   binu_, inye_, _क्षण_, _абав,
   {{0x3f8780d2,0x64460088,0x2d9200ee,0x3d148075}},	//   cinu_, _mrki, hnye_, _धावे_,
   {{0x27e68cc0,0xcb130039,0xc224826a,0x2d92036e}},	//   lpon_, בלת_, اکتو, knye_,
   {{0xfce6a1ae,0x64462f16,0x25a6820d,0x7984008e}},	//   _родо, _orki, _ukol_, _cmiw,
   {{0x7d02af17,0x2d9200b9,0x27e6af18,0xf1bf2ab5}},	//   _idos, dnye_, npon_, rmá_,
   {{0x29d704b7,0x257503ba,0x27e680e4,0x798403f7}},	//   _bħal_, _måle_, ipon_, _emiw,
   {{0x64462f19,0x636d81a8,0xfbb781c6,0xc333825f}},	//   _arki, _múnl, _שפות_, _כוס_,
   {{0x6446017f,0x39150391,0x81e100ab,0x69cb0107}},	//   _brki, _смир, _দিল_, _सूची,
   {{0x95c80bac,0x0dc82f1a,0x644488ae,0x5bb90fe6}},	// [1cd0] тура_, тури_, _šiij, елая_,
   {{0x395faf1b,0xdb01af1c,0x2571af1d,0x64460140}},	//   _sous_, golè, _mála_, _drki,
   {{0x3f87803b,0x29d72f1e,0x64462f1f,0x7d0281ac}},	//   vinu_, _għal_, _erki, _odos,
   {{0x7d0280f1,0x6446026c,0x69c88037,0x200faf20}},	//   _ndos, _frki, _èdel, tugi_,
   {{0x395f9c8d,0x3f87af21,0x2575016d,0x6d4f0888}},	//   _vous_, tinu_, _våld_, _inca,
   {{0x753d0117,0xa2be00d4,0xa3b28105,0xf1ca001c}},	//   _hasz, _वृक्, _झील_, _hạt_,
   {{0x395f86e3,0x44392f22,0x753d29bd,0x200faf23}},	//   _tous_, _hss_, _kasz, sugi_,
   {{0x2249803a,0x394d809f,0x3f87af09,0xdb01af24}},	//   _čak_, _unes_, sinu_, molé,
   {{0xc9849506,0x5184830d,0x69d52f25,0xcfab8065}},	//   _тури, _тура, _huze, _قائم_,
   {{0x25bf802e,0x25ad816b,0x44392f26,0x69d52f27}},	//   smul_, slel_, _mss_, _kuze,
   {{0x75158307,0x443912b7,0x198a0ae7,0xa18a00c4}},	//   _مواض, _lss_, ебни_, ебна_,
   {{0x753d0d38,0x44390687,0x69d52f28,0x78ad228b}},	//   _nasz, _oss_, _muze, _byav,
   {{0x69d52f29,0xaac3000d,0x2d8909c4,0x63a509da}},	//   _luze, वेतक, diae_, kohn,
   {{0x6d4f2f2a,0x77ad8118,0xdce28140,0xe2998791}},	//   _anca, fúxi, _ploć, _пал_,
   {{0xa3c2800f,0x63a52f2b,0x656d0359,0x44392f2c}},	//   ्दर_, dohn, fkah, _ass_,
   {{0x6d5b8867,0x656d2575,0x2614816f,0x442b2f2d}},	//   njua, gkah, नंती_, _bpc_,
   {{0x44392f2e,0x03260162,0xe3ba2f2f,0xa4460071}},	// [1ce0] _css_, лдан, еба_, ынад,
   {{0x6d4f2f30,0x68f60085,0x442b2f31,0x63768087}},	//   _enca, _heyd, _dpc_, _gând,
   {{0x6146af32,0xd9469fcb,0x471b00be,0x2d9200b9}},	//   лежа, лежи, _אויג, pnye_,
   {{0x44392f33,0x2d89002a,0x673e2f34,0xdb01a1bf}},	//   _fss_, ciae_, _hapj, solè,
   {{0x68f61d5a,0x776188f1,0x6d5b9abf,0x64460bf0}},	//   _meyd, _bolx, djua, _urki,
   {{0x27f2031d,0x8fa3adc3,0xfaa62154,0x753d066f}},	//   _mwyn_, баче, _баго, _zasz,
   {{0x27e6af35,0x09cf80a5,0xe1e78019,0x7c2b80eb}},	//   spon_, _संगठ, _دس_, _apgr,
   {{0x44202f36,0x7bce0587,0x44390683,0x6d5b8168}},	//   oti_, _hibu, _yss_, gjua,
   {{0x44202f37,0xa3c2835a,0x7bce0555,0x69d500ad}},	//   nti_, ्दल_, _kibu, _zuze,
   {{0x44202f38,0x3f8a022e,0x673e0019,0x69d519d5}},	//   iti_, jibu_, _napj, _yuze,
   {{0x44200a92,0xdd8f8bca,0x6b7b098a,0x63768087}},	//   hti_, _کون_, גרינ, _rând,
   {{0x84468b76,0x7bce2f39,0x7d02809a,0xddb68019}},	//   _مختل, _libu, _udos, _صحاب,
   {{0x44202f3a,0x68f62f3b,0x69c2808e,0x20000362}},	//   jti_, _deyd, imoe, _cvii_,
   {{0x44392f3c,0x447b893f,0x7bce0ab4,0x78ad018e}},	//   _rss_, _אנדע, _nibu, _vyav,
   {{0x44202f3d,0x7afa8364,0xd5bb15a4,0x2904805c}},	//   eti_, matt, еса_, _odma_,
   {{0x44202f3e,0x7bce2f3f,0x61fe2280,0x63a501ec}},	//   fti_, _aibu, dspl, wohn,
   {{0x656d2f40,0x442b01df,0x44200dc3,0x7bce1c61}},	// [1cf0] rkah, _qpc_, gti_, _bibu,
   {{0x443902a5,0x59d901b6,0x7bce2f41,0x34d195a7}},	//   _vss_, _बंदर, _cibu, _हल्द,
   {{0x5a352f42,0x44202f43,0x7afa80e5,0x44390299}},	//   рнет, ati_, iatt, _wss_,
   {{0x7afaaf44,0x673e0654,0x44202f45,0xe9ab9e29}},	//   hatt, _zapj, bti_, ردان_,
   {{0x68f98063,0x44202f46,0xda010076,0xb97c0158}},	//   rawd, cti_, _लटकत_, ענדי,
   {{0x6d478029,0xa0669bf2,0xf74584db,0x7bce04a7}},	//   ējam, раша_, реко, _gibu,
   {{0x7afaaf47,0x7f3c00be,0xff048ea6,0xb87b0118}},	//   datt, געוו, сячн, ncíb,
   {{0xdb150118,0x656280c3,0x3f8a02ec,0x7bce06a0}},	//   _tizó, _cooh, zibu_, _zibu,
   {{0x6d5b94ec,0x236301c0,0x7bce0cb7,0x28c701a2}},	//   rjua, _kojj_, _yibu, रेमि,
   {{0x7afaaf48,0x25a08ee1,0x21290239,0x42259fab}},	//   gatt, čila_, _abah_, адов,
   {{0xe299af49,0x44202f4a,0x491a02f1,0x45d5af4b}},	//   тан_, zti_, _भादो_, _тоес,
   {{0x44202f4c,0x213f8867,0x68f60086,0x69d80073}},	//   yti_, _jauh_, _qeyd, ívei,
   {{0x7afaa280,0x3f8a022e,0x671c80a5,0x290c07c0}},	//   batt, tibu_, _नामक_, ğda_,
   {{0xcb6684dd,0xb4c19094,0x68f602a3,0x7afa8081}},	//   _ваше_, ंधी_, _weyd, catt,
   {{0x3f8a022e,0x7bce178f,0x0fc300e8,0x24f616cf}},	//   ribu_, _ribu, ійсн, ичар,
   {{0x442021da,0x7bce2f4d,0x3f8a2f4e,0x257185b9}},	//   tti_, _sibu, sibu_, _málo_,
   {{0x3b860110,0x44201aea,0x6386041c,0x31bc801b}},	// [1d00] алаг, uti_, агаа, níze_,
   {{0x44200743,0xfbdf0142,0x394010af,0x61fe1d31}},	//   rti_, _trên_, _hais_, tspl,
   {{0x201faf4f,0x4aab8076,0x39402f50,0x69c280c9}},	//   _aqui_, _घुमव, _kais_, tmoe,
   {{0xc8ca8154,0x61fe2f51,0x636d816a,0x39402f52}},	//   نوان_, rspl, _búnk, _jais_,
   {{0x394019c3,0x7bce04a7,0x69c2a023,0x61fe2f53}},	//   _mais_, _tibu, rmoe, sspl,
   {{0x39402f54,0x63768087,0x69c2af55,0x9e069bb1}},	//   _lais_, _mânc, smoe, ачил,
   {{0x9c87026f,0xbcfb010c,0x798baf56,0xd6d98163}},	//   počí, _moén, bigw, уті_,
   {{0x5d5498a0,0x39402f57,0x6443009a,0xe29701a1}},	//   скит, _nais_, łnie, _тас_,
   {{0x7afaaf58,0x6d40ad03,0x68ed83a8,0xf1d00a27}},	//   tatt, rdma, ñade, _संजन,
   {{0x39520813,0xf36695b5,0x6562808e,0x7b668f13}},	//   _anys_, ртин, _wooh, ртие,
   {{0x7afaaf59,0x1b0300c8,0x0bb70039,0x39402f5a}},	//   ratt, র্কে_, שלים_, _bais_,
   {{0x644901e2,0x7afa920b,0x39402f5b,0x672d80ce}},	//   _šeim, satt, _cais_, đaje,
   {{0x39402f5c,0x7afaaf5d,0xc8642f5e,0x63768187}},	//   _dais_, patt, отри, _cânc,
   {{0x93fb8051,0x7afa8372,0x3ea98162,0xd7f80d15}},	//   _ילדי, qatt, şate_, шую_,
   {{0x394002be,0xe8d90135,0x63a8af5f,0xf1bf81d6}},	//   _fais_, _amụ_, modn, žšia_,
   {{0xda5b8051,0x69d88fee,0x2129010b,0x2baf0d86}},	//   _יכול, _iuve, _ubah_, _जीजा,
   {{0x54b901bb,0x68fd2f60,0x7af881c0,0x69d888dc}},	// [1d10] угая_, masd, _kevt, _huve,
   {{0x8ae7035f,0x3b541242,0x69d8af61,0x28c7009a}},	//   ріал, окур, _kuve, रेणि,
   {{0xcfe200c8,0x213f8748,0x69da0019,0x39520114}},	//   _বিএন, _pauh_, _étel, _ynys_,
   {{0x29190397,0x63a8af62,0x69d8997a,0x68fd2f63}},	//   ngsa_, hodn, _muve, nasd,
   {{0x8d5a0051,0xdee581cf,0x69d8af64,0x504583a7}},	//   _עכשי, боли, _luve, селб,
   {{0x69d882be,0xcc3a0158,0xdc3a0158,0x543a00be}},	//   _ouve, _געשט, _געשר, _געשא,
   {{0x798b8010,0x69d88c16,0x81e10264,0x92580436}},	//   pigw, _nuve, _দিক_, _карт_,
   {{0x7bc52f65,0xf1ca00ff,0x069801c6,0xddd50e06}},	//   lmhu, _nạp_, ידום_, nyző,
   {{0x394000f6,0x7989804f,0x69d88036,0x201f8118}},	//   _rais_, _imew, _auve, _uqui_,
   {{0xf77395e4,0x63a8af66,0x4ea792bc,0x39402f67}},	//   _بار_, godn, _креа, _sais_,
   {{0x39402f68,0x636d8019,0xa96a1c79,0xd946116b}},	//   _pais_, _júni, гина_, бени,
   {{0x394000dd,0xdb050106,0x249d81c5,0x636d957a}},	//   _qais_, llhä, _txwm_, _múni,
   {{0x63a8883d,0x39402f69,0xab298bda,0xb900109b}},	//   bodn, _vais_, _бола_, _तल_,
   {{0x2bdb023c,0x53348ada,0x442f80ee,0x7777002a}},	//   _बढ़ा, _мечт, _ipg_, _clxx,
   {{0x394001e9,0x69d8af6a,0xa50a07a1,0x261801fe}},	//   _tais_, _guve, лева_, बंधी_,
   {{0xf1d01299,0x1c030006,0x442f80ee,0xa19309a5}},	//   _सूचन, _लिखल_, _kpg_, _најч,
   {{0xb87b2f6b,0x69d881ec,0x7bd98326,0xdb018144}},	// [1d20] rcíc, _zuve, _juwu, holí,
   {{0xf3f98a49,0x26180540,0x46f6159f,0x7989804f}},	//   _আমার_, बंदी_, _учит, _amew,
   {{0x6e4603f8,0x2002127a,0x69d8862f,0x2571808b}},	//   _انجم, lski_, _xuve, _páll_,
   {{0x9f4907ca,0x442f8115,0xdb01a0ce,0xf8fa81a8}},	//   _hvað_, _opg_, dolí, اءات_,
   {{0x7f41af6c,0x7bd9803d,0x68e40c53,0xbf9b0866}},	//   _balq, _nuwu, _mfid, prêt,
   {{0x7f41862f,0x6d44011e,0xb87b0511,0x798991d3}},	//   _calq, ldia, ncía, _emew,
   {{0x644baf6d,0x41b6803d,0x65be8168,0x8afb04de}},	//   _argi, _همسر, hëhe, _תהלי,
   {{0x25a0a52d,0x63a8809a,0xb99680f7,0x657b96fb}},	//   čilo_, wodn, _الرب, ghuh,
   {{0x7c242f6e,0x69d8af6f,0x69c08009,0x656600ee}},	//   ntir, _suve, _ihme, _mokh,
   {{0x20020289,0x4f658013,0x6566029b,0x68e42f70}},	//   dski_, _والف, _lokh, _afid,
   {{0x9f5d0324,0x442f8695,0xe13521f6,0x68e92509}},	//   _ìwé_, _epg_, онны, ñedo,
   {{0x3f8e8010,0x5a9b00be,0x442f8118,0x7afe1ab3}},	//   lifu_, רשטא, _fpg_, hapt,
   {{0x6d440355,0x63a8803b,0x7afe2f71,0x68fd2f72}},	//   ddia, podn, kapt, rasd,
   {{0x7f418201,0x60d60019,0x3f8e8010,0x6d442f73}},	//   _xalq, _egym, nifu_, edia,
   {{0x41e68bbe,0xf1ca001c,0x65662f74,0xdb1c01a8}},	//   _استف, _tạp_, _bokh, _ghré,
   {{0x1619835a,0x6615011e,0xd0110b8c,0x56942f75}},	//   नंतर_, ruzk, _قلب_, част,
   {{0xdd1c816b,0x7c2400e4,0x9817136d,0xe5208105}},	// [1d30] kážk, gtir, _ابعا, _यानि_,
   {{0x63600065,0x6615011e,0x27e910ab,0x25a90748}},	//   _köny, puzk, _itan_, soal_,
   {{0x6d440b50,0x7c242f76,0xd25101a8,0x7a3501a8}},	//   bdia, atir, بنا_, تفاص,
   {{0xac191480,0x68e2af77,0x7c242b6c,0x798f0db1}},	//   _кому_, gcod, btir, nicw,
   {{0x7afe2f78,0x27e90101,0x442480b9,0xe8f89138}},	//   bapt, _jtan_, jtm_, слі_,
   {{0x7afe2f79,0x2d9a8019,0xdb01af7a,0xd7c8af7b}},	//   capt, épen_, tolí, مونه_,
   {{0xdb18826f,0x442f82f7,0x7bd980d7,0x6d42af7c}},	//   _chví, _spg_, _suwu, _baoa,
   {{0x2409af7d,0xdb01af7e,0x68e2af7f,0x442f9670}},	//   ании_, rolí, ccod, _ppg_,
   {{0x75ca809a,0x1c4297ae,0x7f4180ee,0x0b59876a}},	//   _języ, дным, _talq, арны_,
   {{0x68e42f80,0x657b8010,0x645b8118,0x644b80c3}},	//   _sfid, shuh, rxui, _vrgi,
   {{0xcb120bea,0x2002009a,0xeab180f7,0x68fb80dd}},	//   ולי_, wski_, بعة_, _keud,
   {{0x2002003a,0x68fb82be,0x443d8069,0xa4f780d5}},	//   tski_, _jeud, _tsw_, _اکثر_,
   {{0x442f802a,0x443d81ec,0xbee5016f,0x68fb851e}},	//   _upg_, _usw_, कडून_, _meud,
   {{0x7d1b8074,0x94748875,0x68fb81e4,0x257c01a8}},	//   lgus, _عدنا, _leud, _míle_,
   {{0xfc3f160a,0xdce40279,0x27e92f81,0x212daf82}},	//   _así_, nkić, _etan_, _obeh_,
   {{0x20021487,0x7c242f83,0x75298081,0x291f8069}},	//   pski_, ttir, nfez, _ncua_,
   {{0xf7462f84,0xab662f85,0x61e902d4,0x3366102a}},	// [1d40] _депо, овал, _čela, оваг,
   {{0x6d44002a,0x2575016d,0xb7d7004e,0x3cff8282}},	//   sdia, _håll_, _گویا_, hauv_,
   {{0xe0daaf86,0xdce40754,0x68e28bfd,0xfc3f0091}},	//   аве_, jkić, tcod, _esí_,
   {{0x64430035,0x671c82f1,0x27e90106,0x68fb851e}},	//   łnia, _नाहक_, _ytan_, _ceud,
   {{0x68fbaf87,0x68ed85e4,0x3f8eaf88,0x183680a0}},	//   _deud, ñada, tifu_, تراح,
   {{0x68e28f67,0x7d1baf89,0x69d82f8a,0x7c3b8123}},	//   scod, egus, íves, dwur,
   {{0xe2972f8b,0xdd1c816b,0x3f8eaf8c,0x7afc0162}},	//   _дар_, rážk, rifu_, _iert,
   {{0x3f8eaf8d,0x7d1baf8e,0x7ae901a1,0x717680d7}},	//   sifu_, ggus, _đeti, _بهرا,
   {{0x7afc2f8f,0x660381c0,0xe81603b7,0x7c3b8133}},	//   _kert, asnk, _तमगा_, gwur,
   {{0x69dc2f90,0xe4570158,0x442480ee,0x3946af91}},	//   _kure, קייט_, rtm_, ldos_,
   {{0xc4e6af92,0x798f2f93,0xbcfb04be,0x3946af94}},	//   _джей, ticw, _eléy, odos_,
   {{0x69dc2f95,0x3946af96,0x7afc2c98,0x21200176}},	//   _mure, ndos_, _lert, _ccih_,
   {{0x81ba00ab,0x3946af97,0x7dd58110,0x84968019}},	//   _অংশ_, idos_, _išsa, _بجائ,
   {{0x69dc062f,0x25a996f2,0x6738911b,0x7d00af98}},	//   _oure, čale_, nevj, lams,
   {{0xb7bb041c,0xccfb0eef,0x5559047f,0x645d862c}},	//   stão, ића_, бавя_, äsiv,
   {{0xdb1c0118,0x394481a9,0x7d00af99,0x7afc2f9a}},	//   _oiró, _nams_, nams, _aert,
   {{0x7afc100d,0x69dc2f9b,0x27e92f9c,0x0bd500f7}},	// [1d50] _bert, _aure, _utan_, سياح,
   {{0x69dc2f9d,0x7afc10b6,0x20192f9e,0x6738af9f}},	//   _bure, _cert, musi_, jevj,
   {{0x20191ad4,0x7afc00d8,0xea00001c,0x28c71516}},	//   lusi_, _dert, _đảo_, रेरि,
   {{0x69dc2fa0,0x3f910052,0xf55900f7,0x7d008bcf}},	//   _dure, lizu_, _الحب_, jams,
   {{0x69dc2fa1,0x66e591b1,0x20192fa2,0xa3ca816f}},	//   _eure, пола, nusi_, लगा_,
   {{0x7afc2fa3,0x39468510,0x213900f1,0x69dc2fa4}},	//   _gert, ados_, hesh_, _fure,
   {{0x7c390214,0x7bdd2fa5,0xf77092c8,0x69dc2fa6}},	//   şarı, _husu, خان_, _gure,
   {{0x7bdd2fa7,0x20192fa8,0x7afc2fa9,0x7c3bafaa}},	//   _kusu, kusi_, _zert, twur,
   {{0x20192fab,0x7bdd2fac,0x7d1bafad,0x69dc2fa9}},	//   jusi_, _jusu, rgus, _zure,
   {{0x7bdd2fae,0x6449afaf,0x20192fb0,0x2571807b}},	//   _musu, rvei, dusi_, _máli_,
   {{0xcb12093f,0x2b1c85b3,0x6449afb1,0x7ae50014}},	//   עלט_, _मारु_, svei, icht,
   {{0x291dafb2,0xac198b71,0xaca38133,0xdb0a80f7}},	//   ngwa_, _году_, _ahụk, _bhfó,
   {{0x20192fb3,0x7bdd2fb4,0xdce28088,0x5ed080ab}},	//   gusi_, _nusu, _glođ, _স্পে,
   {{0xdb1c0706,0xc3110264,0x636d8174,0x7bd503df}},	//   _chrì, স্তি_, _cúnt, _nizu,
   {{0xe29690fc,0xed5a0847,0xdb01afb5,0x272f83bf}},	//   _наш_, бов_, colá, mını_,
   {{0x7afc14ff,0x20192fb6,0x6372013c,0x7bdd2fb7}},	//   _sert, busi_, _tænk, _busu,
   {{0x7afc2fb8,0x29022fb9,0x69dc2fba,0x7bdd02a3}},	// [1d60] _pert, maka_, _sure, _cusu,
   {{0x29022fbb,0xef860c5c,0x272f861c,0x04fc00ab}},	//   laka_, _хлоп, nını_, ইলের_,
   {{0x7afc2fbc,0x7dc58511,0x7bdd002a,0x19ba82c7}},	//   _vert, mósf, _eusu, будь_,
   {{0x7ae50307,0x7afc206f,0xe5a60ada,0x69d60708}},	//   acht, _wert, _хими, _jiye,
   {{0x7afc0393,0x2d922fbd,0x672d80d2,0x25ad837a}},	//   _tert, miye_, đajn, doel_,
   {{0x69dc2fbe,0x6d462fbf,0x29022fc0,0x2d922fc1}},	//   _ture, _haka, haka_, liye_,
   {{0x6d462fc2,0x29022fc3,0x272f8059,0xfaa32fc4}},	//   _kaka, kaka_, dını_, _заро,
   {{0x6d462fc5,0x290209a6,0x2d922fc6,0x7ec70019}},	//   _jaka, jaka_, niye_, lépé,
   {{0x6d460846,0x7bdd2fc7,0x6618816b,0xb4c880d4}},	//   _maka, _xusu, suvk, ोखे_,
   {{0x6d462588,0x6843a87d,0xfc2f9a3c,0x20192fc8}},	//   _laka, _януа, احي_, vusi_,
   {{0x29022fc9,0x2d922fca,0x213900f1,0x69d62fcb}},	//   faka_, kiye_, tesh_, _biye,
   {{0x6d462fcc,0x20192fcd,0x644a00eb,0x69c41e68}},	//   _naka, tusi_, āfij, _chie,
   {{0x69d62fce,0x2d922fcf,0x69c4008e,0x21390168}},	//   _diye, diye_, _dhie, resh_,
   {{0x20192fd0,0x6d46076d,0x321a1d21,0x1be306a7}},	//   rusi_, _aaka, kupy_, _कंबल_,
   {{0x29022fd1,0xc6a41109,0x7bdd2fd2,0x644f017f}},	//   baka_, ерти, _susu, _srci,
   {{0x2d802fd3,0x6d461083,0x20192fd4,0x2d9202a0}},	//   ghie_, _caka, pusi_, giye_,
   {{0x071c9d01,0x6d462fd5,0xea000028,0x5c99027e}},	// [1d70] _नांव_, _daka, _đạo_, цкая_,
   {{0xe3b8884a,0xa87c0039,0x7ae501ec,0xad272385}},	//   nlı_, _לאחר, ucht, _کردو,
   {{0x7bd52fd6,0x32070065,0x6d462fd7,0x68ed82ba}},	//   _vizu, ény_, _faka, ñado,
   {{0x2d802fd8,0x4426802a,0x637307d9,0x7ae501ec}},	//   chie_, _oqo_, _sını, scht,
   {{0x25ad80c9,0xb4d909c8,0xe3b88214,0x4426afd9}},	//   voel_, ाशी_, klı_, _nqo_,
   {{0x44292fda,0xaca3019d,0xe80e83b7,0x644d2fdb}},	//   mta_, _laịb, _सिरा_, mvai,
   {{0x6d462fdc,0x29022fdd,0xc33200be,0xee3980e8}},	//   _yaka, yaka_, _שול_, іни_,
   {{0x44292fde,0xd6580039,0x5ebf00ab,0xc1740326}},	//   ota_, ליות_, _আলাই, _kiɗe_,
   {{0xe3b888c5,0x2d838110,0x272f817b,0x644d22b2}},	//   flı_, ėje_, tını_, nvai,
   {{0x4429171c,0x29022a75,0x69d62fdf,0x29d781b9}},	//   ita_, waka_, _siye, _għar_,
   {{0x29022fe0,0x44292fe1,0x272f8afe,0x62852fe2}},	//   taka_, hta_, rını_, nzho,
   {{0x4429088b,0x272f8459,0x72078019,0x2cae819d}},	//   kta_, sını_, _ہفتہ_, ịmị_,
   {{0x29022fe3,0x6d462fe4,0xa01b0065,0x3b099232}},	//   raka_, _raka, szön, _дело_,
   {{0x6d462fe5,0x44292fe6,0x6f03afe7,0x6d49811e}},	//   _saka, dta_, nanc, ldea,
   {{0x6d462fe8,0x29022fe9,0x2d922fea,0xa2c9820e}},	//   _paka, paka_, tiye_, हेश्,
   {{0x6d49afeb,0x60db8d48,0x44290b0b,0xed572fec}},	//   ndea, _ngum, fta_, мос_,
   {{0x6d462fed,0x44292fee,0x2d922fef,0x6d49803c}},	// [1d80] _vaka, gta_, riye_, idea,
   {{0x6d462ff0,0x2d922ff1,0x7c298b2b,0x6d498f31}},	//   _waka, siye_, iter, hdea,
   {{0x6d462ff2,0x44292ff3,0x7c29aff4,0x673c1e81}},	//   _taka, ata_, hter, merj,
   {{0x27e0025d,0x3d1805b3,0x44292ff5,0x443f882e}},	//   _kuin_, _फाटे_, bta_, kwu_,
   {{0x44291883,0x27e003d3,0x7d042ff6,0xe3b88182}},	//   cta_, _juin_, mais, ylı_,
   {{0x7d042ff7,0x6d59aff8,0x6f03aff9,0x673c2ffa}},	//   lais, _anwa, ganc, nerj,
   {{0x7c29affb,0x27edaffc,0xa3c38beb,0x656baffd}},	//   eter, _eten_, ्षन_, _bogh,
   {{0x7d042ffe,0x7c29afff,0x257880e7,0x753b804f}},	//   nais, fter, _vélo_, geuz,
   {{0x673c1a67,0x7c29b000,0x656bb001,0x2b47b002}},	//   kerj, gter, _dogh, _banc_,
   {{0x6f0381b1,0x7d041276,0x2d988019,0x2b47b003}},	//   canc, hais, őre_, _canc_,
   {{0x7d043004,0x656b8c64,0x81bd0029,0xa3dea6ee}},	//   kais, _fogh, stēm, _दूर_,
   {{0xaca48135,0x6d60816b,0x661c3005,0x7d043006}},	//   _akụz, ávač, durk, jais,
   {{0x44293007,0xdb088511,0x29002c03,0x27e00229}},	//   xta_, lodí, _deia_, _cuin_,
   {{0xe3b88201,0x27e03008,0x81bd00eb,0x673c3009}},	//   qlı_, _duin_, otēk, gerj,
   {{0xdfd41641,0xd90499f4,0x67d40ca4,0x79a71e25}},	//   торы, _پی_, тору, _орие,
   {{0x7d04300a,0x656bb00b,0x29ee8326,0x62850824}},	//   gais, _xogh, mƙa_, vzho,
   {{0x673c300c,0x4429300d,0x6f03b00e,0x7bd8b00f}},	// [1d90] berj, uta_, yanc, _kivu,
   {{0x661c2d27,0x752d3010,0x31a403bf,0xa3c3b011}},	//   burk, sfaz, mıza_, ्षय_,
   {{0x7c29b012,0x7d043013,0x644d3014,0x27edb015}},	//   zter, bais, svai, _sten_,
   {{0x44293016,0x6f03b017,0xaca30133,0x764502a0}},	//   pta_, wanc, _abụb, _ishy,
   {{0x39493018,0x656b861f,0x06f30a74,0x44293019}},	//   _maas_, _rogh, _अभाव_, qta_,
   {{0xf1ca001c,0x656b80f7,0xa3e400d4,0x705292dc}},	//   _dạy_, _sogh, _पंत_, انوا,
   {{0x81bd0029,0xd90f80d5,0x6d49b01a,0x45d580b3}},	//   rtēj, _نیا_, tdea, нцит,
   {{0x6f03b01b,0x79828063,0x7c299140,0x1c45b01c}},	//   sanc, chow, tter, еним,
   {{0x7c29b01d,0x27ed835f,0xfc48801c,0x3dc68079}},	//   uter, _uten_, _cử_, _dhow_,
   {{0x6d49851e,0x61e90796,0xc48286d2,0x2d8c0866}},	//   sdea, _čelj, ульк, édez_,
   {{0x673c301e,0x7bd8b01f,0x68e48024,0x394910b0}},	//   verj, _divu, žide, _baas_,
   {{0x6d598114,0x92df80ab,0xf99f3020,0x27e009ff}},	//   _unwa, তরে_, gnè_, _puin_,
   {{0x673c3021,0xa3db000f,0x6007035f,0x27e0009f}},	//   terj, _ढंग_, нням_, _quin_,
   {{0xfaa584f6,0x201d82c4,0x29ee8326,0x7bd89a14}},	//   _пало, iuwi_, bƙa_, _givu,
   {{0xf772810f,0x7d043022,0x6f01b023,0xed5a16ba}},	//   נקל_, tais, _melc, пов_,
   {{0x27e0038e,0x61ee86a5,0x673c02d4,0x2d9f80e7}},	//   _tuin_, íble, serj, nnue_,
   {{0x7d043024,0x673c01b9,0xfc488028,0xdee61f3e}},	// [1da0] rais, perj, _xử_, _попи,
   {{0x7d043025,0x60c4005d,0x8fa63026,0xdb1c01a8}},	//   sais, _izim, _سمجه, _bhrá,
   {{0xdb1c003e,0xe9da2a0e,0xc33282f6,0x4efb0039}},	//   _chrá, чке_, רוב_, _מהיו,
   {{0xfbdf00e7,0x4aaf0072,0x307a03de,0xdb0884e8}},	//   _prêt_, _जुळव, ּאַנ, vodí,
   {{0x6f018358,0xb8e88fd5,0x26180035,0x201d82d5}},	//   _belc, _उर_, बंकी_, guwi_,
   {{0x38cb8bca,0x3dc6b027,0xdfcf880b,0x60c400b8}},	//   سانی_, _show_, مين_, _mzim,
   {{0xfc488104,0x03a30b9c,0x53a32597,0x6f01b028}},	//   _sử_, _сиро, _сарб, _delc,
   {{0x7bd8b029,0x60c4302a,0x8c66838b,0x5d54b02b}},	//   _sivu, _ozim, етод, ткит,
   {{0x60c42f0e,0x10a38a2e,0x3949302c,0x81e78264}},	//   _nzim, _битн, _raas_, মীম_,
   {{0x6446008e,0xf8bf0036,0x25a00824,0x53b001a2}},	//   _mski, ngée_, hnil_, जकिश,
   {{0xc3331a0f,0x60c41f62,0x7bd8b02d,0x25a002d4}},	//   אות_, _azim, _vivu, knil_,
   {{0xfc488104,0x4c868098,0x4a9b00be,0x546a8081}},	//   _tử_, _плев, לייג, _наем_,
   {{0xb90905e8,0xdb0883a7,0xc95384de,0x25718061}},	//   _बल_, godã, אמר_, _vált_,
   {{0xa3c38e70,0x60c400eb,0x25a08353,0x3949302e}},	//   ्षण_, _dzim, čilu_, _waas_,
   {{0x3949302f,0x60c40316,0x64463030,0x6a869a1f}},	//   _taas_, _ezim, _aski, _défé,
   {{0xd5b83031,0x25a002d4,0x257c128a,0x3eba0163}},	//   есу_, gnil_, _dílo_, _dypt_,
   {{0x2ef50698,0x68ed017b,0xe802801b,0xafdb1277}},	// [1db0] _изпр, _ifad, रीमा_, rvøs,
   {{0xc5f680ab,0x200b3032,0x8aa7031f,0x889c0039}},	//   _ঘটনা_, msci_, нред, _מבחי,
   {{0x64463033,0xd5df800f,0x321eb034,0xdd9100d7}},	//   _eski, _पूंज, nuty_, _نود_,
   {{0xc17400fc,0x7ec70032,0x1a6801f9,0x27e68299}},	//   _kiɗa_, _eépí, ریقی_, fqon_,
   {{0x2d84b035,0x6f01b036,0x6d5d0b03,0x64460326}},	//   dhme_, _pelc, _insa, _gski,
   {{0x7bdf83d3,0x7c2d020f,0x656f0352,0x39498df1}},	//   _équi, mtar, _hoch, žas_,
   {{0xfbdf0073,0xe7088154,0x6372008b,0x61dc00d4}},	//   _três_, رتون_, _vænt, यदृष,
   {{0x6d4d3037,0x7dd58110,0x6f0184e7,0x49049a37}},	//   ndaa, _išsk, _welc, _موفق,
   {{0x656f3038,0x200b00d2,0x7d02802e,0x6f01accd}},	//   _moch, jsci_, _deos, _telc,
   {{0x656f0083,0x7c2d3039,0x24890042,0x67200035}},	//   _loch, itar, izam_, _बाइक_,
   {{0xfaa59980,0x6a8682be,0x7c2d2b42,0x69c981e9}},	//   тано, _réfé, htar, _khee,
   {{0x656f303a,0x7d02b03b,0x853000fc,0x2d9f8037}},	//   _noch, _geos, kiɗa, qnue_,
   {{0x6d4d0ef2,0x7c2d0168,0x8ccd8035,0x1b0c0264}},	//   ddaa, jtar, देशो, স্টে_,
   {{0x6d4bb03c,0x24891a1d,0x6d5d303d,0x6569b03e}},	//   _haga, dzam_, _ansa, ljeh,
   {{0x6d4bb03f,0x656f3040,0x7c2d3041,0x20193042}},	//   _kaga, _boch, etar, arsi_,
   {{0x656f3043,0x6d4bb044,0xe8029834,0x44393045}},	//   _coch, _jaga, रीडा_, _bps_,
   {{0x60c402a5,0x6d4b8fa9,0x25a03046,0x7c2d3047}},	// [1dc0] _uzim, _maga, rnil_, gtar,
   {{0x6d5d3048,0x61e3930c,0xa3c1823c,0x6f07003b}},	//   _ensa, _kunl, ंति_, cajc,
   {{0x442db049,0xbcfb087a,0x3f98005c,0x6d4d15e8}},	//   hte_, _poét, miru_, bdaa,
   {{0x6d4bb04a,0x3f98010b,0x656f304b,0x6d4d0079}},	//   _naga, liru_, _goch, cdaa,
   {{0x69c982a3,0x7c2d304c,0xa3c1a8b3,0x69db8722}},	//   _dhee, ctar, ंता_, _diue,
   {{0x4420304d,0x442d8ed8,0x7d02b04e,0x6d4b9bdb}},	//   mui_, dte_, _seos, _aaga,
   {{0x4420304f,0x6d4bb050,0x442d929d,0x26dc026f}},	//   lui_, _baga, ete_, _úvod_,
   {{0x75243051,0x7bdc3052,0x6d4bb053,0x657ba575}},	//   ngiz, _hiru, _caga, gkuh,
   {{0x6d4bb054,0x442db055,0x61e900d2,0x44203056}},	//   _daga, gte_, _čeli, nui_,
   {{0x2d8488cf,0x671c81ab,0x61e382bb,0x201902a5}},	//   shme_, _नाटक_, _bunl, vrsi_,
   {{0x44200867,0xdee387b6,0x442db057,0xf3638190}},	//   hui_, _тохи, ate_, ртын,
   {{0x442db058,0x6d4bb059,0x7c2d305a,0xfd5501bc}},	//   bte_, _gaga, ytar, _draị,
   {{0x442d8bf6,0x656f305b,0x4420305c,0x2904804f}},	//   cte_, _roch, jui_, _mema_,
   {{0x6d40b05d,0x6d4bb05e,0x4420305f,0x656f03b3}},	//   lema, _zaga, dui_, _soch,
   {{0x443902ee,0x35e4035f,0xda6f8698,0x6d4b81d3}},	//   _sps_, ицтв, _тя_, _yaga,
   {{0x7c2d3060,0x672d812b,0x6d40938e,0xdd11011c}},	//   ttar, đaji, nema, _düşd,
   {{0x44203061,0x54550b71,0x6d4d3062,0x7bdc3063}},	// [1dd0] gui_, ыват, rdaa, _biru,
   {{0x09cb8eed,0x2d8210f4,0x6d408006,0x656f0352}},	//   िष्य, _elke_, hema, _woch,
   {{0x442db064,0x7bdc3065,0x69c981c5,0x6d40b066}},	//   zte_, _diru, _phee, kema,
   {{0x7c2d08cf,0x6d5d1341,0x6d40b067,0x44203068}},	//   ptar, _unsa, jema, bui_,
   {{0x6d4bb069,0x442db06a,0x7bdc306b,0x69db823e}},	//   _raga, xte_, _firu, _viue,
   {{0x7dd581e2,0x442d826f,0x7bdc306c,0xe8d9019d}},	//   _išsi, vte_, _giru, _nnọ_,
   {{0x6d4bb06d,0x69c9b06e,0xc794803d,0x6abc0114}},	//   _paga, _thee, جشنب, _gyrf,
   {{0xe8d90870,0x26dc007c,0x7bdc306f,0x6f0501d0}},	//   _anọ_, וקומ, _ziru, _lehc,
   {{0x7bca9301,0x442db070,0xf1bf0038,0xc6bf00c8}},	//   _bhfu, ute_, dlá_, _আলোচ,
   {{0x9ee980f7,0x6d4bb071,0x200980eb,0x212900b9}},	//   _أفضل_, _waga, šais_, _acah_,
   {{0x6d4bb072,0x35f59baa,0x65698499,0x6d40b073}},	//   _taga, _спер, pjeh, bema,
   {{0xdb089be6,0x29043074,0x8ed58264,0x06d58264}},	//   rodá, úma_, _স্থগ, _স্থি,
   {{0x394d831d,0xd9100019,0x442d8168,0x7c648019}},	//   _maes_, میں_, qte_, _ناول,
   {{0x749a8f60,0x649a8158,0x3ced8353,0x61e3826b}},	//   _אינפ, _אינה, lcev_, _tunl,
   {{0xe1f18288,0x20003075,0x3f983076,0x98a403bf}},	//   _است_, _wwii_, riru_, ımı_,
   {{0x7d098025,0x44200f52,0x0ce200ab,0x3ced8353}},	//   naes, tui_, বর্ত, ncev_,
   {{0x752404b9,0x3f98012b,0x26180074,0x644488ae}},	// [1de0] rgiz, piru_, बूजी_, _šiiz,
   {{0xdd041010,0x39423077,0x2904b078,0x44203079}},	//   ısın, leks_, _sema_, rui_,
   {{0xeb96893f,0x6d408870,0x4420307a,0x75e78085}},	//   נדער_, yema, sui_, _qızl,
   {{0x673b005c,0x394218c2,0x4420307b,0x6d408f3e}},	//   đuje, neks_, pui_, xema,
   {{0x4420307c,0x6d40ad03,0xe3b10019,0x2904804f}},	//   qui_, vema, صرے_, _vema_,
   {{0x6fb4000f,0xa2e30256,0x7d06307d,0x39420074}},	//   ंकिं, _горд, _heks, heks_,
   {{0x6d40b07e,0x7d06307f,0xfbde0118,0x63768162}},	//   tema, _keks, _iiª_, _mânt,
   {{0x782680f7,0x746a8009,0xf65703c8,0xdd9080f7}},	//   _معطل, еров_, רסקי_, توب_,
   {{0x6d40b080,0x39423081,0xd1b38077,0x644d81a1}},	//   rema, deks_, _اینک, _šair,
   {{0x6d40b082,0x6d8784a1,0x79843083,0xff248065}},	//   sema, _añad, _aliw, _خبری,
   {{0x4ebf00c8,0xa49b0362,0xaace8074,0xfca980d7}},	//   _আল্ল, _aeòl, हेंक, _یاهو_,
   {{0x6fc005ec,0x25bf8162,0xfce6b084,0x394206ae}},	//   böck, clul_, _содо, geks_,
   {{0xa3e40540,0xe81c0006,0xa49b051e,0x8cb00c28}},	//   _पूल_, भंगा_, _ceòl, _अँगो,
   {{0xead48e02,0x63768087,0xf1bf03f2,0x1b1a0264}},	//   _коль, _cânt, slá_, ন্তে_,
   {{0xa3c3815c,0xa3c1b085,0x7d063086,0x5b7b80be}},	//   ्षर_, ंतर_, _beks, _ארגא,
   {{0x9e43016b,0xa49b0a2a,0x7984066f,0x6b9a8580}},	//   žďov, _feòl, _gliw, litg,
   {{0x7d062ca2,0x33f400f7,0xbcfb0511,0x24180fe6}},	// [1df0] _deks, مسلس, _anéc, лоты_,
   {{0x290b3087,0x7d0602d5,0x69df0168,0x395fb088}},	//   laca_, _eeks, _hiqe, _snus_,
   {{0x3ebe9816,0xdb08807b,0x394db089,0xd6db004a}},	//   _nytt_, lldó, _paes_, _яти_,
   {{0x290b308a,0x4dfa0158,0x3547102a,0x3135804a}},	//   naca_, _שפרא, _схов, редр,
   {{0x3ced807a,0xd7058dae,0xada581d6,0x69df03ed}},	//   vcev_, азли, nkúš, _miqe,
   {{0x88c700c8,0x3ebe919b,0x69df308b,0x290b308c}},	//   _এলাক, _bytt_, _liqe, haca_,
   {{0x6d4f308d,0xd5ae0117,0x27780039,0x25bf8087}},	//   _kaca, _رہے_, רגון_, tlul_,
   {{0x290b0503,0x395f9ca7,0x2d890708,0x6d4f308e}},	//   jaca_, _unus_, nhae_, _jaca,
   {{0xb81ca3e6,0xe7e1023c,0x0d828112,0x87278c2a}},	//   _नियम_, _गंगा_, ільн, _معام,
   {{0x6d4f02a3,0x308481a8,0x60c9b08f,0x00000000}},	//   _laca, _الكف, _izem, --,
   {{0x39420006,0x69cd0362,0x49ca1ddf,0xb1130135}},	//   teks_, _bhae, клон_, _tụle,
   {{0x24968077,0x69cd0114,0x672d812b,0x290b3090}},	//   انید_, _chae, đaju, gaca_,
   {{0x7dc58207,0x764e807b,0x6b65a45b,0x7d06007b}},	//   lóso, _ábyr, _вкла, _reks,
   {{0x87b90676,0x39420665,0x64598609,0x248d822c}},	//   густ_, seks_, _irwi, mzem_,
   {{0x290b3091,0x2d960196,0xe81c8105,0x7d063092}},	//   baca_, арас, _निभा_, _peks,
   {{0x6d4f3093,0x290b3094,0x69cd0013,0xdb188176}},	//   _caca, caca_, _ghae, _akvè,
   {{0x7d06021e,0x6d4f01b4,0x81bd01a9,0x3f85b095}},	// [1e00] _veks, _daca, rtēt, _ollu_,
   {{0x7bc18355,0x644b8077,0x6d4f0229,0x42560992}},	//   nllu, _msgi, _eaca, итет,
   {{0x7d060558,0x00e695f7,0x6d4f0014,0x7c3d3096}},	//   _teks, ажен, _faca, _epsr,
   {{0x6d4f3097,0x6e3e00b9,0x31608333,0x323680be}},	//   _gaca, _ippb, ñiz_, יטען_,
   {{0x60c98035,0x6d443098,0x69da8037,0x2f18b099}},	//   _czem, meia, _ètem, голь_,
   {{0x248daec8,0x2d80009a,0x60c9b09a,0x6d4f309b}},	//   dzem_, lkie_, _dzem, _zaca,
   {{0xfaa3108d,0xeb970b87,0x1c188074,0xe8e000ff}},	//   _даро, _тир_, _दिहल_, _muối_,
   {{0x2d80079f,0xe817016f,0x290b0e1b,0xad6680f7}},	//   nkie_, _तिला_, xaca_, شابه,
   {{0x290b003a,0x4432309c,0xb716803d,0x7b66b09d}},	//   vaca_, nty_, _نباش, атне,
   {{0x4432309e,0x61e0908c,0x443d808e,0x68e4309f}},	//   ity_, _himl, _dpw_, _agid,
   {{0x2d80079f,0x0cc3123a,0x3f9cb0a0,0x443230a1}},	//   kkie_, _शर्म, mivu_, hty_,
   {{0x443209a4,0x60c08009,0x3f9cb0a2,0x7bc1b0a3}},	//   kty_, _kymm, livu_, allu,
   {{0x7bce00b9,0x6d4430a4,0xdbdc81d0,0xdb050118}},	//   _ohbu, deia, lšíh, rohú,
   {{0x6d4f30a5,0xe8e00028,0x61e0b0a6,0x7c2430a7}},	//   _saca, _cuối_, _liml, duir,
   {{0x290b0024,0x6d4f30a8,0xada580e1,0x8de823e7}},	//   paca_, _paca, skúš, ифта_,
   {{0x69c88029,0xdb1c01a8,0x261803ca,0x443230a9}},	//   _ūden, _ghrú, _फिरी_, fty_,
   {{0x4424b0aa,0x6562803e,0x7bce0267,0x69c38036}},	// [1e10] num_, _mnoh, _bhbu, înem,
   {{0x799d005d,0x25a9a2fb,0x6d4f30ab,0x8c1b8039}},	//   lisw, čali_, _waca, כומי,
   {{0x60c98117,0x6d4f04f9,0x442484a7,0x27e930ac}},	//   _szem, _taca, hum_, _huan_,
   {{0x4424b0ad,0x2d8030ae,0x799d005d,0x79a4838b}},	//   kum_, ckie_, nisw, орче,
   {{0x765a8063,0x4424b0af,0x27e902f9,0x7bc1b0b0}},	//   _arty, jum_, _juan_, yllu,
   {{0xbb850307,0x4424b0b1,0x2d86b0b2,0x7d0d30b3}},	//   _السي, dum_, _aloe_, laas,
   {{0x6fcd81ac,0x636da5b3,0x27e930b4,0x799d0234}},	//   júce, _gúny, _luan_, kisw,
   {{0x6fcdb0b5,0x7d0d30b6,0x44248125,0x248d8722}},	//   dúce, naas, fum_, tzem_,
   {{0x4424b0b7,0x60c0b0b8,0xe3b99a19,0x60c9b0b9}},	//   gum_, _gymm, лби_, _uzem,
   {{0xd7748013,0x5f748013,0x7d0d2933,0x61e0b0ba}},	//   _والع, _والر, haas, _ziml,
   {{0x7d0d30bb,0xe9da0021,0x248da422,0x26c101c0}},	//   kaas, лко_, szem_, _nyho_,
   {{0x27e91e66,0x186a30bc,0x443230bd,0x7d0d30be}},	//   _buan_, гами_, yty_, jaas,
   {{0x4424b0bf,0x7d0d02a3,0x443230c0,0x55528065}},	//   cum_, daas, xty_, _رپور,
   {{0xa0270125,0x27e930c1,0x291e02d0,0x7529b0c2}},	//   _stöð, _duan_, şta_, lgez,
   {{0xc9f5845b,0x51f59e13,0xfaa2b0c3,0x644981ec}},	//   _استع, _استر, _нашо, lwei,
   {{0x7d0d30c4,0x7529b0c5,0x7c2430c6,0x63bc30c7}},	//   gaas, ngez, tuir, _skrn,
   {{0x1ddf800f,0x69c280c9,0xd4671300,0x644982af}},	// [1e20] _पूछत, vloe, бите_, nwei,
   {{0x443214e3,0x2d801a15,0x212d81f1,0x4f260991}},	//   rty_, skie_, _aceh_, _удоб,
   {{0x4432309c,0x6449b0c8,0x7c2402a5,0x7d0d30c9}},	//   sty_, hwei, suir, baas,
   {{0x4424b0ca,0x7529890d,0x443230cb,0x6f0e0326}},	//   yum_, jgez, pty_, labc,
   {{0x7c2430cc,0xdb01b0cd,0xe80b800f,0x3a258fb0}},	//   quir, noló, _सौदा_, hulp_,
   {{0xe82000a5,0x442030ce,0x64498114,0x799d0234}},	//   _बिना_, mri_, dwei, zisw,
   {{0x528600f7,0xa248019f,0x4424b0cf,0x442030d0}},	//   _الأك, _خیال_, wum_, lri_,
   {{0x442030d1,0x3f9cb0d2,0x75299d20,0xdb018298}},	//   ori_, sivu_, ggez, koló,
   {{0x442030d3,0x644997fb,0x3946b0d4,0x81ae0264}},	//   nri_, gwei, meos_, কতা_,
   {{0x4424b0d5,0xf36697cb,0x442030d6,0xdb018ce0}},	//   rum_, стин, iri_, doló,
   {{0x7d0d02c1,0x442030d7,0xed06803d,0x7dea8035}},	//   yaas, hri_, _هواپ, _męsk,
   {{0x27e930d8,0x7982809a,0x3946a5ca,0x4424808b}},	//   _puan_, nkow, neos_, pum_,
   {{0x27e930d9,0x543387d2,0x39520039,0x8c439cce}},	//   _quan_, _فرور, _days_, _неце,
   {{0x799d1c01,0x7d0d30da,0x3e580242,0x6f0e0326}},	//   sisw, waas, _bčt_, gabc,
   {{0x442030db,0x7d0d30dc,0x63ba9122,0x7a1c0087}},	//   eri_, taas, motn, nătă,
   {{0x27e930dd,0x63ba8353,0xe8d90133,0xdd940084}},	//   _tuan_, lotn, _alụ_, пасы,
   {{0x442030de,0xe8200006,0xdb01b0df,0x539901bb}},	// [1e30] gri_, _बिया_, coló, авая_,
   {{0x7d0d30e0,0xdce982ce,0x3e5806c0,0x5b1530e1}},	//   saas, vječ, _fčt_, імет,
   {{0x26c701ac,0xd1758196,0x39468511,0x27f8807a}},	//   _áno_, жылы, feos_, _črna_,
   {{0x41c91869,0xdce9a4a0,0x59c908fd,0xf1c90ebf}},	//   रतिस, tječ, रतिर, रतिन,
   {{0x1869a457,0xa069828b,0x63bab0e2,0xa3d51354}},	//   рали_, рала_, kotn, _момч,
   {{0xaded9344,0x36198009,0x66fb06bf,0xdce982ce}},	//   _चंदन_, ацию_, ्रिक_, rječ,
   {{0x3cdb8076,0xdce9920e,0x25a930e3,0x752981ed}},	//   खेने_, sječ, onal_, tgez,
   {{0x25a930e4,0x4c85835f,0x6449b0e5,0x3946a706}},	//   nnal_, жлив, twei, ceos_,
   {{0x290fb0e6,0xe10100c8,0x7989826b,0x7529b0e7}},	//   maga_, ্লাহ_, _ilew, rgez,
   {{0x290fb0e8,0x6449b0e9,0x645d2bea,0x395230ea}},	//   laga_, rwei, _mrsi, _says_,
   {{0x395203d3,0x89aa0364,0x6449a7f9,0x60cd30eb}},	//   _pays_, иков_, swei, _azam,
   {{0x290fb0ec,0x442030ed,0xc1740326,0xdb01b0ee}},	//   naga_, yri_, _kiɗi_, toló,
   {{0x77770197,0xcb699073,0xe8e00129,0x25a904e8}},	//   _boxx, _вале_, _ruồi_, dnal_,
   {{0x442030ef,0x60cd0754,0x661a03f2,0x5ed080ab}},	//   vri_, _dzam, átko, _স্টে,
   {{0xb87b25a7,0x645d30f0,0xdb01b0f1,0x290fb0f2}},	//   scíp, _arsi, soló, kaga_,
   {{0x442030f3,0xa3c38a74,0x2d8db0f4,0xa0a6004a}},	//   tri_, ्षक_, nhee_, _майд,
   {{0x442030f5,0x7d0b8065,0x290fb0f6,0x9f840198}},	// [1e40] uri_, _megs, daga_, töä_,
   {{0x442030f7,0x76418022,0x2bcf800c,0xa2d080d4}},	//   rri_, _oply, _सीमा, डेक्,
   {{0x79828063,0x644f30f8,0x442030f9,0x98b90084}},	//   tkow, _esci, sri_, resą_,
   {{0x442030fa,0x5f460416,0xed5a0f2f,0x08c69ccf}},	//   pri_, _انگل, _том_, обен,
   {{0x3946a82b,0x7982b0fb,0x61e430fc,0x798988f9}},	//   reos_, rkow, _miil, _dlew,
   {{0x7989b0fd,0xdfcf8013,0x394682ba,0x7982809a}},	//   _elew, نين_, seos_, skow,
   {{0x63baa67b,0x394685e4,0x290f820c,0xa3d70701}},	//   votn, peos_, baga_, ागर_,
   {{0x61e40a2c,0x6d5630fe,0x25a030ff,0x290fb100}},	//   _niil, ndya, niil_, caga_,
   {{0x98a38a29,0x61ea802e,0x60c40d4c,0x7c3604fe}},	//   _жите, _sufl, _nyim, ntyr,
   {{0x25a91b3b,0x61e40362,0x63a8808e,0xdb17002a}},	//   znal_, _aiil, undn, toxé,
   {{0xa2a001fe,0x63bab101,0x19590a41,0x326680e8}},	//   _गेम्, rotn, баны_, ітов,
   {{0x63bab102,0xdb17002a,0x60c40a03,0x6fc48580}},	//   sotn, roxé, _byim, dòci,
   {{0xb8f3035a,0x63ba807a,0x9f490187,0xdb01823e}},	//   _वर_, potn, _itaú_, rolò,
   {{0x290fb103,0x60cd007a,0xa294902a,0xdb170118}},	//   zaga_, _vzam, _налі, poxé,
   {{0x290fb104,0xdd9b240b,0x6933001b,0xdb23807b}},	//   yaga_, аша_, _přeč, _þrát,
   {{0xf1a40087,0x48151285,0x3f833105,0x1b0400ab}},	//   _орын, _емис, skju_, _লাগে_,
   {{0x6ebb05e8,0x25a90806,0x60cd3106,0xe8e0001c}},	// [1e50] _शुरु, rnal_, _uzam, _buổi_,
   {{0xd25b2a0e,0x645d0042,0x69c0ac62,0xed5985f3}},	//   ице_, _vrsi, _akme, može_,
   {{0xdced0a20,0x290fb107,0xdb07008b,0x25a02960}},	//   ljač, taga_, _skjó, biil_,
   {{0x20090300,0x2b8086c0,0x25a00079,0x604081bc}},	//   _kwai_, _wòch_, ciil_, _ịmag,
   {{0x290fb108,0x644f3109,0x7d0b81b0,0x64468085}},	//   raga_, _usci, _regs, çkil,
   {{0x442927ba,0x290fb10a,0xd34300d5,0x637f83a7}},	//   mua_, saga_, _تفسی, _têni,
   {{0x4429310b,0x64428e67,0xf96bb10c,0x2d8d89ff}},	//   lua_, _apoi, _край_, thee_,
   {{0x752d310d,0xe79580d5,0x3cf7809a,0x764180e1}},	//   ngaz, _کارک, ीरें_, _vply,
   {{0xdced0067,0xd7f89ddf,0x1c428190,0x68e98609}},	//   jjač, _дух_, еным, _iged,
   {{0x61e42933,0x2d8d8079,0xdced0503,0x7d0b96a1}},	//   _siil, shee_, djač, _wegs,
   {{0x442910af,0x4b7c0158,0x7641816b,0x61e4156e}},	//   hua_, יאזו, _uply, _piil,
   {{0x4429310e,0xe8028c1c,0x248001a5,0x644f806a}},	//   kua_, रीका_, yyim_, æcis,
   {{0x4429310f,0x2d9d80b4,0x27e5a817,0xeb8e96c7}},	//   jua_, _imwe_, _kiln_, _зи_,
   {{0x44290ee2,0x7c298216,0x61e40079,0x752d047f}},	//   dua_, muer, _wiil, egaz,
   {{0x96632240,0x7c2981eb,0x63a1b110,0x68e9b111}},	//   нкре, luer, miln, _oged,
   {{0x752d1eb7,0x68e9b112,0xdce404a8,0x4429004f}},	//   ggaz, _nged, njić, fua_,
   {{0x44293113,0x27ed8102,0x7c29b060,0xd467013a}},	// [1e60] gua_, _nuen_, nuer, пите_,
   {{0xe7ef8105,0x63a1b114,0x213f88f9,0x68e9a020}},	//   _चढ़ा_, niln, _abuh_, _aged,
   {{0x7c362280,0x24920063,0x44290087,0x248615d8}},	//   styr, szym_, aua_, šom_,
   {{0xb4ea8076,0x44293115,0x27ed80ab,0x290d802e}},	//   _मले_, bua_, _buen_, _ceea_,
   {{0xa3cb9521,0x7d04245e,0xe8e00028,0x63a1b116}},	//   लता_, mbis, _tuổi_, kiln,
   {{0x26c5800d,0x27ed811e,0xfbc78bbe,0x7c29b117}},	//   _bylo_, _duen_, _ست_, duer,
   {{0x63a1b118,0x68edaeb6,0x6b6305a8,0xa3c18074}},	//   diln, žada, _якра, ूतन_,
   {{0x7c298693,0xb608801b,0x7f8b0085,0x7d043119}},	//   fuer, jišť, _müqa, nbis,
   {{0x7c29ac92,0xdb050511,0x7d04311a,0xbcfb01d6}},	//   guer, cohó, ibis, _poéz,
   {{0x5ede80c8,0x39400057,0xfbbe1664,0x63a1a0d0}},	//   নুষে, _abis_, ्तिम, giln,
   {{0x27ed80ad,0x4429311b,0xa3e401ce,0x61ee04fe}},	//   _zuen_, zua_, _पूछ_, _jubl,
   {{0xed59803e,0x7c2984dc,0x63be027f,0xa3e79344}},	//   tože_, buer, hopn, _मूक_,
   {{0x63a1a842,0x7c2985b4,0xc8640adb,0x53348198}},	//   biln, cuer, нтри, _желт,
   {{0x61ee03d3,0x7c242944,0x4429311c,0x38660bcf}},	//   _oubl, drir, vua_, _šorc_,
   {{0xdced0042,0x7bda807b,0x433b8039,0x777ab11d}},	//   sjač, mmtu, _העוב, _motx,
   {{0x4429311e,0x7c24311f,0x7d04221b,0x55743120}},	//   tua_, frir, gbis, нгст,
   {{0x09c909a3,0x3f8c8459,0x7c243121,0x752d3122}},	// [1e70] रतीय, _oldu_, grir, rgaz,
   {{0x3b540a4c,0x44293123,0x798d0282,0x44248c5e}},	//   нкур, rua_, _hlaw, irm_,
   {{0x44293124,0xb6068024,0x213f80ee,0x7c243125}},	//   sua_, nošć, _pbuh_, arir,
   {{0x15f205b3,0xdd86803f,0x44293126,0x7dc58510}},	//   _आंतर_, _شو_, pua_, pósi,
   {{0x27edb127,0xdb1707f4,0x44290098,0xdb1c3128}},	//   _quen_, loxí, qua_, _chró,
   {{0x798d031d,0x777a809f,0x3f9e80b9,0x3dc90080}},	//   _llaw, _cotx, _cmtu_, llaw_,
   {{0x63a1acc8,0x61ee02a5,0x7c299770,0x798d3129}},	//   viln, _gubl, wuer, _olaw,
   {{0x7c299914,0xb60680ce,0x63a18035,0x3dc91217}},	//   tuer, došć, wiln, nlaw_,
   {{0x63a1b12a,0x320102d5,0x3940002a,0x69c38036}},	//   tiln, lphy_, _rbis_, îneu,
   {{0x798d312b,0x7c29b12c,0x798611ee,0xaca3819d}},	//   _alaw, ruer, wkkw, _nkụk,
   {{0x7c299b6c,0x63a18353,0xb6068da4,0xa91d8bcf}},	//   suer, riln, gošć, _alži,
   {{0x7c298388,0x7e7e816d,0xaca3882e,0x2d9d82a0}},	//   puer, äppe, _akụk, _umwe_,
   {{0x798d312d,0x63a1b12e,0x3dc9033e,0xbcfb00e1}},	//   _dlaw, piln, dlaw_, _inéh,
   {{0x8c4295e0,0x61fb0b67,0x7c24312f,0xa49b0706}},	//   _реше, _čuln, vrir, _leòs,
   {{0xafe30037,0xdb1703a8,0x7d0f0061,0x4ad191be}},	//   торл, goxí, _becs, _हरिव,
   {{0x61ee3130,0x99520110,0x25adb131,0xe817016f}},	//   _rubl, ršų_, nnel_, _तिचा_,
   {{0x7d043132,0xdca322fd,0x63be007a,0x6fcd80e1}},	// [1e80] rbis, вати, topn, júco,
   {{0x25bf82d6,0x7c24011e,0x387f0192,0x7dea8196}},	//   houl_, rrir, äure_, _kęst,
   {{0xa49b0706,0xdb1c0229,0x68ed81d6,0x3dc90428}},	//   _beòs, _bhrò, ľadn, blaw_,
   {{0x7c240081,0x3dc93133,0xdb1c1a26,0x2f0a8035}},	//   prir, claw_, _phró, _mógł_,
   {{0xb8f6901b,0x7bc38b99,0x7bc8807b,0xaca4019d}},	//   _हर_, _oknu, yldu, _maịs,
   {{0xdb1a826f,0x61ee02f1,0x9f458176,0xe29a3134}},	//   poté, _tubl, _jilè_, _даг_,
   {{0x2b580088,0x69c43135,0x61fc0503,0x9f8d008b}},	//   _iarc_, _okie, _utrl, nþá_,
   {{0xa5349612,0xb606811f,0x2d9202f7,0x29c40118}},	//   хнич, vošć, nhye_, iñas_,
   {{0x29069f33,0x20c381e5,0x7e878110,0xdb18b136}},	//   mboa_, _айтм, _įspū, _akvá,
   {{0x798d3137,0x69c42810,0xb606811f,0x2b583138}},	//   _slaw, _akie, tošć, _jarc_,
   {{0xa2c19513,0xd01380c8,0x798d01e9,0x3218826f}},	//   _रुद्, _সময়_, _plaw, éry_,
   {{0xe4a6954f,0xc486b139,0x68e4826c,0xb6068bcf}},	//   _орло, _олек, židu, rošć,
   {{0xa3e7823c,0xc058102a,0xbf0a016f,0x10740c4f}},	//   _मंच_, мір_, वरून_, вляю,
   {{0x0efb313a,0x2b58313b,0x47cc80ab,0x3dc902c4}},	//   ्रेस_, _narc_, াদকী, wlaw_,
   {{0x52bf0beb,0x9f45b13c,0x69c40609,0x3ceb010d}},	//   _्रेस, _dilè_, _fkie, _pgcv_,
   {{0x3dc90122,0x7f5701b4,0x58d5062c,0x637f8901}},	//   ulaw_, _waxq, _пойт, _fêns,
   {{0x7d020333,0x3dc9313d,0xb7d50032,0x9f4586c4}},	// [1e90] ñosa, rlaw_, _aṣen, _filè_,
   {{0x6d978087,0x69dd313e,0xdb018366,0xdb1c0a2a}},	//   nţar, lmse, anlæ, _shrò,
   {{0xb50e86a7,0x7d0f313f,0xe1f00481,0xdb1c01e4}},	//   सराय_, _tecs, لسن_, _phrò,
   {{0x32013140,0x7dc5b141,0x645c80eb,0x68ed80e1}},	//   rphy_, nóst, ārij, ľado,
   {{0x68ed826f,0x2b583142,0x20190198,0x6008902a}},	//   žado, _farc_, nssi_, днім_,
   {{0x657d3143,0x7c2d3144,0xa49b0229,0x443907f1}},	//   _hosh, muar, _feòr, _iqs_,
   {{0x7c2d3145,0xee398cde,0x2bbe090f,0x657d3146}},	//   luar, їни_, ्तरा, _kosh,
   {{0x68ed3147,0x63a5178f,0x657d3148,0x6d87811b}},	//   _ngad, lihn, _josh, _iñak,
   {{0x657d3149,0x3834b14a,0x7c2d314b,0xed598904}},	//   _mosh, _интр, nuar, rdž_,
   {{0x69c4314c,0xa3bf0592,0x61e9b14d,0x63a500dd}},	//   _skie, ँकि_, _hiel, nihn,
   {{0x61e9b14e,0xa2d3016f,0x60c982f7,0x25ad8706}},	//   _kiel, भेच्, _hyem, pnel_,
   {{0x657d314f,0x7c2d3150,0xa3cf81a2,0x60c983f7}},	//   _nosh, kuar, _वीर_, _kyem,
   {{0x61e9b151,0xdb088511,0x656bb152,0xbcfb00f7}},	//   _miel, godó, _ingh, _gnéi,
   {{0x61e98341,0x7c2d3153,0x7c3bb154,0xdb1e0168}},	//   _liel, duar, mtur, ropë,
   {{0x6d59b155,0x657d3156,0x442db157,0x63a514e4}},	//   _kawa, _bosh, lue_, dihn,
   {{0x6d5bb158,0x61e9b159,0x7bc1b15a,0xaca381bc}},	//   ndua, _niel, lolu, _nhịk,
   {{0x2b58315b,0x6d59b083,0x7c2d315c,0x6aa806ce}},	// [1ea0] _parc_, _mawa, guar, कप्र,
   {{0x6d59b15d,0x291fb15e,0xaca3819d,0x2d9202a0}},	//   _lawa, _adua_, _ahịk, shye_,
   {{0x61e9b15f,0x27ffa266,0x3ea63160,0xa9269d79}},	//   _biel, _atun_, _чинг, едел,
   {{0x61e9b161,0x6d59b162,0x657d3163,0xb17b016d}},	//   _ciel, _nawa, _gosh, rmåg,
   {{0xc7c69821,0x4fc6a950,0x61e988dd,0x7d1602a3}},	//   нски, нска, _diel, mays,
   {{0x7d163164,0x656bb165,0xfaa60d0e,0x442db166}},	//   lays, _angh, _заго, due_,
   {{0x6d59b167,0x657d3168,0x1dcb999e,0x61e98039}},	//   _bawa, _yosh, ातंत, _fiel,
   {{0x7d163169,0x6d59b16a,0x61e98609,0xdd9781a0}},	//   nays, _cawa, _giel, ешь_,
   {{0x442daa70,0x7c3b96fb,0x3cdb82f1,0x60c9b16b}},	//   gue_, gtur, खेले_, _gyem,
   {{0x09c90b6f,0xa0a3b16c,0x61e9b16d,0x1e969285}},	//   रत्य, _сауд, _ziel, _прер,
   {{0x200d8352,0x0c73819f,0x7d160b8a,0x7c2d316e}},	//   _zwei_, ندید, kays, zuar,
   {{0x6d59b16f,0xdce606c4,0x67eb0372,0x0efb01a2}},	//   _gawa, _ankč, _ażja, ्र्स_,
   {{0x7c3b9b9f,0x69dd3170,0x7bc1b171,0x7d160079}},	//   ctur, rmse, bolu, days,
   {{0x7bc1802e,0x657d3172,0x6d59b173,0x2019156e}},	//   colu, _sosh, _zawa, rssi_,
   {{0xdb1a87e2,0x6d59b174,0xa2a0016f,0x657d09be}},	//   notí, _yawa, _गेल्, _posh,
   {{0x7d160079,0x7c2201b9,0xdb01b175,0x6285016b}},	//   gays, ġorn, vilé, vyho,
   {{0x63a509da,0x61e9b176,0xb81ca076,0x6d4d3177}},	// [1eb0] tihn, _riel, _निगम_, reaa,
   {{0x7c2d275d,0x61e9b178,0x6e2e3179,0xb17b0366}},	//   ruar, _siel, bubb, småd,
   {{0x61e9b17a,0x7d160079,0x442d8102,0xdb188106}},	//   _piel, bays, zue_, _ikvä,
   {{0x63a5010b,0x1c218665,0x61e98168,0x27ff808e}},	//   sihn, _मिलल_, _qiel, _ptun_,
   {{0x61e9b17b,0x6d59b17c,0x7c2d317d,0x29d900f7}},	//   _viel, _rawa, quar, méad_,
   {{0x61e9b17e,0x6d598886,0xdce9920e,0x442db17f}},	//   _wiel, _sawa, ljeć, vue_,
   {{0x44293180,0x61e9b181,0x6d59b182,0x6d40b183}},	//   lra_, _tiel, _pawa, ffma,
   {{0x7c3b81dc,0x44293184,0x8d658ada,0xf8bf07bc}},	//   ttur, ora_, твие, ngés_,
   {{0x44293185,0xe43280f7,0x7bc1b186,0x6d5bb187}},	//   nra_, لفيد, tolu, rdua,
   {{0x4429186b,0x6d59b188,0x442db189,0x394fb18a}},	//   ira_, _wawa, rue_, legs_,
   {{0x09d60a49,0x6d59b18b,0x7bc1b18c,0x316d8390}},	//   _সংবা, _tawa, rolu, _knez_,
   {{0x4429318d,0x7bc1b18e,0xdb1e02be,0x656bb18f}},	//   kra_, solu, ropé, _ungh,
   {{0x442db190,0x29120179,0x8edf00c8,0x44293191}},	//   que_, _veya_, _ব্লগ, jra_,
   {{0x44293192,0x701380ab,0x7d16057b,0x7c29a280}},	//   dra_, _সমাজ_, ways, mrer,
   {{0x44293193,0x65b301cd,0x6da61577,0x7d020333}},	//   era_, għho, вива, ñoso,
   {{0x7d09aa97,0x893612c8,0x6e2e3194,0x12e880be}},	//   nbes, _شعبا, rubb, _אַפּ,
   {{0x44293195,0xa91d803a,0x7d1602a3,0x28de0540}},	// [1ec0] gra_, _možd, rays, नेशि,
   {{0x6e2e235a,0x7d163196,0x06863197,0x8cd6864a}},	//   pubb, says, _агон, मेटो,
   {{0x44293198,0x7c2982af,0xdce982ce,0x7d09874c}},	//   ara_, hrer, bjeć, kbes,
   {{0x29d900f7,0x7d1601b4,0x637e928a,0x6fcd8174}},	//   céad_, qays, _záně, lúch,
   {{0x7d09b199,0x317f83ec,0x6d46026b,0xe9478061}},	//   dbes, _douz_, _ibka, ئرمی,
   {{0x5ead80c8,0x7c29b19a,0xaca38135,0x7d09a0b5}},	//   য়েছে, drer, _chọk, ebes,
   {{0x6ae000c8,0x7c29b19b,0xf3f400ab,0x7d09b19c}},	//   _প্রো, erer, _ছবির_, fbes,
   {{0x7d09b19d,0x6ce68d13,0x7c2982df,0x6fcd8174}},	//   gbes, кіпе, frer, húch,
   {{0xc0458277,0x7c29b19e,0xdb1c01d0,0x00000000}},	//   _مخلو, grer, _zkrá, --,
   {{0xf4130051,0x2006b19f,0xf3669677,0xa91d9502}},	//   ספת_, mpoi_, ттин, _požg,
   {{0xc3331a0f,0x442931a0,0x79809088,0x7d09b1a1}},	//   בות_, zra_, _komw, bbes,
   {{0x7c29b1a2,0x316d31a3,0x6f188353,0x44290e20}},	//   brer, ñez_, lavc, yra_,
   {{0x75228133,0xb7d50032,0x6d958091,0xe9df002a}},	//   _idoz, _aṣan, _dáad, rmú_,
   {{0x442931a4,0x547b8039,0x9e3531a5,0x6d4631a6}},	//   vra_, _קטגו, легч, _abka,
   {{0xb8ca058c,0x442919e7,0x2bb1816f,0x2bec064a}},	//   _गे_, wra_, ीकरा, _अंजू_,
   {{0xa91d826f,0x7bc7104a,0x7e6531a7,0xdcfb811f}},	//   _kože, _skju, _vrhp, rkuć,
   {{0xdb1c31a8,0x291931a9,0x6f18807d,0xdcfb8289}},	// [1ed0] _skrá, masa_, kavc, skuć,
   {{0xa91d803a,0x4ea72097,0x8f55035f,0xdce9920e}},	//   _može, _арма, _свої, sjeć,
   {{0x442931aa,0x6f188503,0x7522b1ab,0x61ed31ac}},	//   sra_, davc, _odoz, _kial,
   {{0x442931ad,0x291931ae,0x673b012b,0x60cd31af}},	//   pra_, nasa_, đuju, _kyam,
   {{0xa3c2853e,0xa91d8503,0x6d5d0cb5,0x6fcdb1b0}},	//   ंवा_, _nože, _iasa, lúci,
   {{0x291915bd,0x7522b1b1,0x24890282,0x2d82b1b2}},	//   hasa_, _adoz, myam_, öken_,
   {{0x6d5d31b3,0x6da59860,0x291931b4,0xe5a5a2fd}},	//   _kasa, лика, kasa_, лики,
   {{0x61ed31b5,0x7bc50091,0x7c29b1b6,0xe459813a}},	//   _nial, lohu, trer, ежи_,
   {{0x6d5d318b,0x60cd31b7,0x6f1880d2,0xa91d8279}},	//   _masa, _nyam, bavc, _vožd,
   {{0x7c29ac03,0x6d5d31b8,0x2bd90321,0x490b800d}},	//   rrer, _lasa, _बीमा, ारको_,
   {{0x61ed31b9,0x6fcd81ac,0x60cd31ba,0x25a91e1e}},	//   _bial, júci, _ayam, kial_,
   {{0x6d5d31bb,0x291931bc,0xb4db046d,0x60cd1c61}},	//   _nasa, gasa_, _abàm, _byam,
   {{0x61ed26fd,0x4429b1bd,0x9b458591,0x343980be}},	//   _dial, _ía_, _منشو, _נײַע,
   {{0x9474806b,0x656f1140,0x63a88699,0x443fb1be}},	//   _خدما, _anch, cidn, mtu_,
   {{0x6d5d31bf,0xa2ca89a3,0x291911c2,0x61ed31c0}},	//   _basa, _सुप्, basa_, _fial,
   {{0x5bbe0f21,0x61ed31c1,0x69c98069,0xed5715fc}},	//   ्त्व, _gial, _nkee, лос_,
   {{0x443f88a7,0x6d5d059c,0x2bf680be,0x69c631c2}},	// [1ee0] ntu_, _dasa, ָמען_, moke,
   {{0x443fb1c3,0x69c631c4,0xa09b03de,0x69c9b1c5}},	//   itu_, loke, _נייט, _akee,
   {{0x6d5d31c6,0x443fb1c7,0x201f87e2,0x35a61986}},	//   _fasa, htu_, _avui_, _банг,
   {{0x25a930cc,0x6d5d31c8,0x05560d0e,0x644b8366}},	//   cial_, _gasa, _стоя, _opgi,
   {{0xdefa825d,0x443fb1c9,0xa2ca9516,0xbcfb0333}},	//   ный_, jtu_, _सुन्, _enés,
   {{0x6d5d0491,0xdb1c006a,0x69c631ca,0x7c2b1434}},	//   _zasa, _skræ, hoke, ágre,
   {{0x6d5d31cb,0x291931cc,0xb8eb800c,0xbb3b00be}},	//   _yasa, yasa_, _रु_, _רעלי,
   {{0xa91d80ce,0x6d5d02a3,0x69c623be,0x6f18b1cd}},	//   _pože, _xasa, joke, savc,
   {{0x61ed0307,0x20e303dd,0x63a8816d,0x6f18b1ce}},	//   _rial, _गणेश_, tidn, pavc,
   {{0x40938013,0x2d8231cf,0x25a931d0,0x61ed31d1}},	//   _الكر, _loke_, zial_, _sial,
   {{0x61ed0397,0x291931d2,0x60cd0590,0x443fb1d3}},	//   _pial, tasa_, _syam, atu_,
   {{0x6288b1d4,0xa91d807a,0x7bc5004f,0xe80b801b}},	//   rydo, _tože, zohu, सीका_,
   {{0x291931d5,0x629ab1d6,0x61ed31d7,0x44321126}},	//   rasa_, szto, _vial, juy_,
   {{0x6d5d2fd2,0x29192fc9,0x60cd0010,0x6fcd80e1}},	//   _sasa, sasa_, _vyam, túci,
   {{0x6d5d31d8,0xcddb0fbb,0x6d4431d9,0x69c62127}},	//   _pasa, ења_, ffia, boke,
   {{0x55580160,0x6d5d31da,0x2d580987,0x248905b0}},	//   лася_, _qasa, лись_, tyam_,
   {{0x5b1531db,0x6d5d31dc,0x7bc531dd,0x7bdc0083}},	// [1ef0] имат, _vasa, tohu, _bhru,
   {{0x6d5d31de,0x25a931df,0x7bdc0c64,0x248931e0}},	//   _wasa, sial_, _chru, ryam_,
   {{0x6d5d31e1,0x443f811e,0x7ceb8019,0xd2510c3b}},	//   _tasa, ztu_, _körü, تنا_,
   {{0x6d5d0c41,0x3d0e809a,0xbcfb31e2,0xdb018216}},	//   _uasa, सरों_, _enér, vilí,
   {{0x65360158,0xe739a2f6,0x443fb1e3,0xf3ff0187}},	//   _דארף_, вел_, xtu_, _irão_,
   {{0x61f531e4,0x8ae70d13,0xdb01b1e5,0xdb0883a7}},	//   _tuzl, _бібл, tilí, sidê,
   {{0xed59af02,0x69dbb1e6,0x61fc8118,0x01d60264}},	//   вой_, _thue, írll, _সংসদ,
   {{0x443f9184,0x14258284,0x0d85824f,0x7c2d31c1}},	//   ttu_, адим, рлин, orar,
   {{0x443fb1e7,0x998480f7,0x7c2d04be,0x69c631e8}},	//   utu_, _القو, nrar, voke,
   {{0x395fb1e9,0x4a45acd1,0x443fb1ea,0x25a6a20c}},	//   _haus_, анов, rtu_, _emol_,
   {{0xa2cb2e06,0x69c6022e,0x395fb1eb,0x2fc7b1ec}},	//   _तुम्, toke, _kaus_, mong_,
   {{0x9f49007b,0x7c2d31ed,0x39490362,0x2fc7b1ee}},	//   _stað_, krar, _cbas_, long_,
   {{0x69c631ef,0xa2a71055,0x2d82007a,0xeb8eb1f0}},	//   roke, _टेस्, _roke_, _ди_,
   {{0x7d1bb1f1,0x395f81c5,0x2fc784d2,0x442d906f}},	//   laus, _laus_, nong_, mre_,
   {{0x66e61198,0xeab00a49,0xdee60b9c,0x69c60010}},	//   рова, _কর্ম, рови, poke,
   {{0x7ceb8b06,0x2fc7840a,0x7d0d31f2,0x442db1f3}},	//   _görü, hong_, gbas, ore_,
   {{0x2fc7b1f4,0x7c2d0baf,0x6db7012b,0x6d4431f5}},	// [1f00] kong_, grar, pćan, rfia,
   {{0x442db1f6,0x6b83b1f7,0x2fc7b1f8,0xb6a61d8f}},	//   ire_, _jong, jong_, _виол,
   {{0x6f1c2c92,0x6b83b1f9,0x442db1fa,0x2fc782b8}},	//   marc, _mong, hre_, dong_,
   {{0xd94693b4,0x442db1fb,0x7d1b87ac,0x6f1c31fc}},	//   реди, kre_, jaus, larc,
   {{0x61e281b9,0x395f8282,0x7c2d002e,0x442db1fd}},	//   rmol, _daus_, crar, jre_,
   {{0x442d8e1c,0x2fc7b1fe,0x442031ff,0x7996031d}},	//   dre_, gong_, msi_, _llyw,
   {{0xd5ba9506,0x395f8282,0xf8d32769,0x6d4781a1}},	//   кси_, _faus_, _सर्प, đjan,
   {{0x442db200,0x44200190,0x6f1c3201,0x6b839e3f}},	//   fre_, osi_, harc, _aong,
   {{0x57eaa2f6,0x442d888b,0x6b83b202,0x2fc78bf2}},	//   _адам_, gre_, _bong, bong_,
   {{0x44203203,0x46a68098,0xbea68221,0x2fc7b204}},	//   isi_, _казв, _казк, cong_,
   {{0x6b83b205,0x442db206,0x6440b207,0x6f1c3208}},	//   _dong, are_, stmi, darc,
   {{0x442db209,0x4420320a,0x8c46875a,0x7d1b8051}},	//   bre_, ksi_, _веде, caus,
   {{0x6f1c2b02,0xfce68abe,0x4420320b,0x6b83907c}},	//   farc, _тодо, jsi_, _fong,
   {{0x6f1c320c,0x7c2d0012,0x8c1b83c8,0x6b83821e}},	//   garc, vrar, _יודי, _gong,
   {{0x7c22b20d,0x7bc8b20e,0x61418019,0x3160320f}},	//   _hvor, modu, náló, _faiz_,
   {{0x4420022e,0x44f53210,0x39151bdc,0x527b84de}},	//   fsi_, спас, _умир, _ינוא,
   {{0x2fc784d2,0x7d0d3211,0xe4e7035f,0x6b83b212}},	// [1f10] yong_, rbas, рівн, _yong,
   {{0x7c2d3213,0x6f1c3214,0x395fb215,0xd9bf83eb}},	//   rrar, carc, _saus_, एक्ट,
   {{0x395fb216,0x4420127b,0x2bbe0424,0x442d8061}},	//   _paus_, asi_, ्तजा, zre_,
   {{0x442db217,0x2fc7833e,0x44203218,0xdb088722}},	//   yre_, wong_, bsi_, sidè,
   {{0x44203219,0x2fc7843c,0x557600be,0x395f81c0}},	//   csi_, tong_, _הערן_, _vaus_,
   {{0x442db21a,0x645d321b,0x7d02b21c,0x06b280ab}},	//   vre_, _issi, _afos, য়েছি,
   {{0x2fc782e8,0x22950013,0xa6c996fe,0x7c22b21d}},	//   rong_, _الأس, ылка_, _avor,
   {{0x6b83b21e,0x56b80039,0x2fc7b21f,0x6f1c3220}},	//   _song, יפון_, song_, zarc,
   {{0x442da962,0x6b83b221,0x7f8b0201,0x2fc7b222}},	//   ure_, _pong, _hüqu, pong_,
   {{0x442d8625,0x291db223,0x31600ad4,0x7c22a8fc}},	//   rre_, lawa_, _saiz_, _dvor,
   {{0xa2ca816f,0x442d8019,0x6f1c3224,0xb17b0502}},	//   _सुद्, sre_, varc, rmån,
   {{0x442da65d,0x291db225,0x44203226,0xd00a1d32}},	//   pre_, nawa_, ysi_, леме_,
   {{0x6f1c3227,0x8d5a8039,0x44200085,0x31601dd7}},	//   tarc, _תכני, xsi_, _vaiz_,
   {{0x291d9cbc,0x6b838010,0x6b9a8a11,0x7643808e}},	//   hawa_, _uong, chtg, otny,
   {{0x291db228,0x645d20ef,0x7c228253,0x2d96283b}},	//   kawa_, _assi, _zvor, брас,
   {{0x442024fc,0x6da3006d,0x6f1c3229,0x2b4a008e}},	//   tsi_, писа, sarc, _sbbc_,
   {{0x7b068065,0x4420322a,0x291db22b,0x249f82ce}},	// [1f20] _érté, usi_, dawa_, nzum_,
   {{0x44202f37,0xa91db22c,0xa3dd80d4,0x61e60b81}},	//   rsi_, _roža, _थीम_, lmkl,
   {{0x645d322d,0x25adb22e,0xdb070019,0x60dbb22f}},	//   _essi, kiel_, ámár, _azum,
   {{0x291db230,0x38668067,0xa91d90d1,0xf1a5835f}},	//   gawa_, tvor_, _poža, орін,
   {{0x53c787e6,0x44203231,0x25ad81ac,0x6d563232}},	//   रकाश, qsi_, diel_, meya,
   {{0x60db8267,0x38cb803d,0xd8d700be,0x3f858140}},	//   _dzum, دامی_, זונט_, _colu_,
   {{0x25ad82d8,0x291d985b,0x3f8585aa,0x7c22b233}},	//   fiel_, bawa_, _dolu_, _svor,
   {{0x65643234,0x2d803235,0xd94397c8,0xdd978084}},	//   ndih, njie_, _неси, йшы_,
   {{0x91e38758,0x64443236,0x76438057,0x61f89123}},	//   _хоте, ntii, atny, _suvl,
   {{0x5c5b00be,0x69df00f1,0x3f858390,0x2902009a}},	//   נדיק, _shqe, _golu_, ecka_,
   {{0xa91d9234,0x64d506a7,0x25ad9695,0x6d56010c}},	//   _možn, _दर्श, biel_, keya,
   {{0x7c2284e8,0x25adb237,0x64440406,0x7bc8b238}},	//   _tvor, ciel_, ktii, sodu,
   {{0x399b020f,0xa3d805fb,0x3f858059,0x2d8001b0}},	//   _nëse_, ाता_, _yolu_, djie_,
   {{0x0a948d13,0x291db239,0xdbf1001b,0x2ca0026c}},	//   _малю, zawa_, _příl, dzid_,
   {{0x5694323a,0xa14380eb,0x291d801d,0xfdc406a7}},	//   парт, šķir, yawa_, वकूफ,
   {{0x6d56323b,0x644401b4,0x69cd323c,0x6d9c8174}},	//   geya, ftii, _ukae, _déag,
   {{0x5fba941b,0x2129036e,0x4dd401a8,0x765e06c4}},	// [1f30] ेवाल, _idah_, ستفس, _espy,
   {{0xdea404c0,0x291db23d,0x6f1ab23e,0x25adb23f}},	//   _کیفی, wawa_, _netc, ziel_,
   {{0x291db1bb,0x6d563240,0xd6d9003d,0x72b901a8}},	//   tawa_, beya, _خودش_, جهاز_,
   {{0x6ab90beb,0x291d804f,0x8f5500d7,0x64443241}},	//   _आशीर, uawa_, _انگش, btii,
   {{0x291db242,0xf7708416,0x6d9c80f7,0x25adb243}},	//   rawa_, کان_, _méad, viel_,
   {{0x291db244,0x6d4b8359,0x25ad9699,0x8afe8326}},	//   sawa_, _sbga, wiel_, _yaƙe,
   {{0x2902016d,0xfebb815b,0x62341138,0x66e28048}},	//   ycka_, داشت_, _неру, моша,
   {{0x200903ac,0x7dc58019,0x23633245,0x7643b246}},	//   _otai_, lósz, _hajj_, rtny,
   {{0xa2b901b6,0x25adb247,0x60dbb248,0x92e680ab}},	//   ्थव्, riel_, _uzum, যুৎ_,
   {{0x42259895,0x212900dd,0xb17b0f91,0x25adb249}},	//   одов, _adah_, smål, siel_,
   {{0x80d100c8,0x25adb24a,0x09b580be,0x6d56324b}},	//   সেম্, piel_, ַפֿט_, yeya,
   {{0x6d9cb24c,0x64440198,0xbc758a19,0xdb038f35}},	//   _réag, ytii, _وهاب, _imní,
   {{0xe45f025d,0x6d56324d,0x10a30162,0x65642cc7}},	//   _myös_, veya, диян, vdih,
   {{0x69cbb24e,0x212900ee,0x1af38264,0x6d498174}},	//   hoge, _edah_, _আজকে_, lfea,
   {{0x59c9885d,0xba778077,0x2d80079f,0xb8d108af}},	//   िकार, _داشت, tjie_, _टे_,
   {{0x64440364,0x753ba479,0xf50a324f,0x29d901a8}},	//   ttii, nguz, рнал_, néal_,
   {{0x92d600c8,0x6d563250,0xd46718a0,0x3b862482}},	// [1f40] _হলে_, reya, оите_, олаг,
   {{0x32d630bc,0xa91db251,0x64443241,0x213f80dd}},	//   оцес, _božo, rtii, _acuh_,
   {{0xe8fa9777,0x64443252,0x8b0780fc,0x69cb9a16}},	//   але_, stii, _taƙƙ, foge,
   {{0x6f1a82e6,0x69cbb253,0x64443254,0x7d1f011c}},	//   _setc, goge, ptii, caqs,
   {{0xe0568277,0xa91d807a,0x29d901a8,0x386001b9}},	//   تخاب, _tožn, déal_, _jsir_,
   {{0x44320114,0x7c240834,0x7d043255,0x9e06818b}},	//   mry_, msir, lcis, очил,
   {{0xdd9a9617,0x41ca1299,0x69cbb256,0xbf9b0036}},	//   иши_, रवास, boge, mpêt,
   {{0x69cb81ca,0xed59939c,0x7d043257,0x4432309c}},	//   coge, kožu_, ncis, ory_,
   {{0x7c243258,0xdb1e006a,0xc31e80ab,0x6d9c81a8}},	//   nsir, ropæ, _দাবি_, _réad,
   {{0x77928077,0x7c243259,0x44320748,0x926a88d5}},	//   _زیبا, isir, iry_, арма_,
   {{0x9d46817a,0x2009325a,0x4432016b,0xe3b8b25b}},	//   _межд, _stai_, hry_, rnı_,
   {{0x443201b0,0x7c240304,0x963385e9,0xa194102a}},	//   kry_, ksir, _ініц, даюч,
   {{0x92d600c8,0xa2ca800c,0x9f4c801b,0x7c240503}},	//   _হলো_, _सुर्, _lidí_, jsir,
   {{0x442680ce,0x69cb82af,0xc05800e8,0x09b79053}},	//   _ivo_, zoge, цію_, _अद्य,
   {{0x69cb82ec,0x4426b25c,0xddab0087,0x61fc0965}},	//   yoge, _hvo_, атал_, _nurl,
   {{0x2129035a,0x7c24325d,0x4432015c,0x2bbf2836}},	//   _udah_, fsir, fry_, ्वभा,
   {{0xb9c40013,0x6fca8540,0x78a288ae,0x3959325e}},	// [1f50] _تقيي, ाकां, jzov, mess_,
   {{0x09b3853e,0x69cb8365,0x63ba81ec,0x3959325f}},	//   ंच्य, woge, nntn, less_,
   {{0xe7f9016f,0x44323260,0x46d20cfd,0x69cb8a85}},	//   ंदवा_, ary_, _दुपह, toge,
   {{0x44268025,0xe1f80110,0x39593261,0x7d04234a}},	//   _ovo_, ігі_, ness_, ccis,
   {{0x18698258,0xa2cb3262,0xf994025f,0x8caa81a2}},	//   сали_, _तुर्, ורף_, _जेलो,
   {{0x7d1d1831,0x23fa0039,0x69cbb263,0xbdf81190}},	//   _hess, _להשא, soge, _دریا_,
   {{0x61fc1486,0xc7b40039,0xa3d800d4,0xa2ca850a}},	//   _gurl, ובס_, ातर_, _सुल्,
   {{0xc4858785,0x4c8586e6,0xf1c004e8,0x673c0140}},	//   злик, злив, čák_, zgrj,
   {{0x7d1d114e,0xe3b1803f,0x937980f7,0x29d900e7}},	//   _mess, فرد_, مصدر_, réal_,
   {{0xf8ae80d5,0x29dc85a4,0x798980c9,0x7d1d0a85}},	//   _حکم_, nían_, _hoew, _less,
   {{0x4426803a,0x799b9916,0xdb0888f1,0x8a058110}},	//   _evo_, _kluw, cidí, язне,
   {{0x7d1d1927,0x76470366,0xe61080d7,0xc7a901c6}},	//   _ness, dtjy, _ششم_, _גב_,
   {{0xb4fa8039,0x764b8110,0x92b58fd3,0xdb01862c}},	//   _הפני, žnyč, تحکا, tilä,
   {{0xfaa5a2a7,0x44323264,0xed5981c8,0x6dac02d0}},	//   _нало, vry_, lež_, rşam,
   {{0x70b89513,0x7d1d02af,0x29dc85e4,0xa2cb01d0}},	//   _अश्ल, _bess, dían_, _तुल्,
   {{0xf99f3265,0x39593266,0x7c243267,0x7d1d3268}},	//   chè_, cess_, tsir, _cess,
   {{0x7d1d3269,0x3860326a,0x8afe89ab,0x7d04262b}},	// [1f60] _dess, _usir_, _haƙa, rcis,
   {{0x4432326b,0xa01b0009,0x8afe8326,0xe7f9326c}},	//   rry_, pyör, _kaƙa, ंदरा_,
   {{0x4efb0051,0xe7170051,0x7c24326d,0x61e4326e}},	//   _להיו, _מחיר_, ssir, _khil,
   {{0xc693093f,0xd7fa8676,0x7d1d15fe,0xdb08a8e5}},	//   _נאר_, бук_, _gess, vidí,
   {{0x29dc82ba,0x61e40c41,0xed59915c,0x8afe89ab}},	//   bían_, _mhil, dež_, _laƙa,
   {{0xc7a38226,0xa2a7326f,0x29dc85e4,0x8fa3a57e}},	//   ничк, _टेक्, cían_, наче,
   {{0x442687ca,0x6566029b,0x7d1d3270,0xdb1e01ec}},	//   _svo_, _kakh, _yess, ropä,
   {{0x2abb0039,0x2d9fb271,0x4426929b,0x25a0008e}},	//   _המלא, ghue_, _pvo_, nhil_,
   {{0x3a3a04b7,0x212209c4,0xdb08a509,0xf0448fd3}},	//   lupp_, dakh_, sidí, _تعزی,
   {{0xe44f8013,0x6566005d,0x6f1e011f,0x8afe89ab}},	//   اضي_, _lakh, _nepc, _baƙa,
   {{0x395904b7,0x25a00d8b,0x61e40c41,0xfbab8035}},	//   tess_, khil_, _bhil, टोधम,
   {{0x61e43272,0x65663273,0x4426808b,0x867b81c6}},	//   _chil, _nakh, _tvo_, _לרבו,
   {{0x7d1d3274,0xa91da7b1,0x4426b275,0x39593276}},	//   _ress, _božj, _uvo_, ress_,
   {{0x6d9c8013,0x7d1d3277,0x39593278,0x656601b4}},	//   _féac, _sess, sess_, _aakh,
   {{0x7d1d00a9,0x6566005d,0xd3e582e3,0x29dc8511}},	//   _pess, _bakh, _تقوی, vían_,
   {{0x61e43279,0xbcfb03a8,0xdb08823e,0x98b901a9}},	//   _ghil, _gaél, lidà, nesī_,
   {{0x6ecd0f12,0x6c54096f,0x29dc8511,0x69cf016b}},	// [1f70] _दुरु, нкту, tían_, moce,
   {{0x7d1d0123,0x69c08115,0x8afe89ab,0x889c01c6}},	//   _wess, _ajme, _yaƙa, _לבחי,
   {{0x29dc840e,0x7d1d327a,0xecf905e9,0xbb8400f7}},	//   rían_, _tess, _менш_, علمي,
   {{0x6f1e327b,0x25a000f3,0x69cf2c04,0xc2c40174}},	//   _zepc, chil_, noce, ريني,
   {{0xa3ccb27c,0x1b2280ab,0x6d4d008e,0x237800fe}},	//   लवा_, _মানে_, mfaa, _fnrj_,
   {{0x2d8b05f5,0x6566005d,0x6d4d327d,0xceba80fc}},	//   _hoce_, _zakh, lfaa, waƙa_,
   {{0x6566029b,0xb8f49664,0x6b83007b,0x443b327e}},	//   _yakh, _सु_, öngu, luq_,
   {{0x6d4d0763,0x6d9c80e7,0x799b80dd,0x2d8b327f}},	//   nfaa, _réac, _uluw, _joce_,
   {{0xcc8980d7,0x8afe8326,0x3f818338,0xafdb0646}},	//   زنده_, _saƙa, öhus_, rtøj,
   {{0x61e43280,0x2d8b002a,0x69d981ec,0x7d038061}},	//   _shil, _loce_, llwe, _bíró,
   {{0x52db3281,0x61e43282,0x7e7e816d,0xed598259}},	//   _भरोस, _phil, äppt, pež_,
   {{0x6723b283,0x2d8b3284,0x69cf3285,0xdb08841c}},	//   lanj, _noce_, goce, tidã,
   {{0x65663286,0xa3bf2743,0x81c200ab,0x8afe89ab}},	//   _rakh, ुका_, ্গল_, _waƙa,
   {{0x82358bca,0x6723b287,0xe299b288,0x61e40051}},	//   _قربا, nanj, _мал_, _whil,
   {{0x61e43289,0x2d8b012b,0x6d4d328a,0x25a00642}},	//   _thil, _boce_, ffaa, thil_,
   {{0x6723b28b,0x291f822c,0x6569b28c,0x68fbb28d}},	//   hanj, _neua_, ndeh, _ngud,
   {{0x6449b28e,0x6723b28f,0x2d8b3290,0xbfc62349}},	// [1f80] ntei, kanj, _doce_, _обик,
   {{0x61b899e8,0x65663291,0xd9b886ce,0x212d80b9}},	//   ेक्ष, _wakh, ेक्ट, _adeh_,
   {{0x23678353,0x64499bda,0x35a60071,0x65663292}},	//   _manj_, htei, _жанг, _takh,
   {{0xe0dab293,0x2d8b3036,0x3a3a3294,0x6449b295}},	//   ове_, _goce_, rupp_, ktei,
   {{0x26039220,0xdcb90364,0x4fc69597,0xc7c697c8}},	//   _año_, _ещё_, мска, мски,
   {{0x09bb0519,0x31bb223a,0x6d42802e,0x65698fb0}},	//   _उद्य, _उद्ध, _scoa, edeh,
   {{0x9f4c8118,0x6e3c0144,0xc34e80ff,0x45d49860}},	//   _cidá_, nurb, _bổng_, нокс,
   {{0x717683f8,0xc34e801c,0x644980e3,0x68fb85ee}},	//   _تهرا, _cổng_, ftei, _ggud,
   {{0xe043b296,0x29e88085,0x69cf3297,0x3944841c}},	//   _инти, _uşaq_, voce, _icms_,
   {{0x6723803a,0x96968098,0x547b03de,0x75243298}},	//   canj, _ореш, קטיו, haiz,
   {{0x69cf3299,0xa3e606b7,0xd3370039,0xa2948d8e}},	//   toce, _पठन_, וריה_, хані,
   {{0x3872119b,0x7c3bb29a,0x7524026c,0x443b011c}},	//   _bryr_, buur, jaiz, yuq_,
   {{0x14e2a539,0x3f8cabf7,0x2d8b001b,0xdb1c07d3}},	//   _परिण, _kodu_, _roce_, _skrý,
   {{0xeaaf8416,0x61ee01ac,0xac978077,0xd90f015b}},	//   اعی_, _ďale, _تنها_, دیک_,
   {{0x2bbf14d5,0x3f8cb29b,0xdce28754,0x9f458118}},	//   ्वसा, _modu_, _maoč, _pilú_,
   {{0x23678838,0xa2ad800d,0x7bdab29c,0x693601d0}},	//   _zanj_, ुपर्, lltu, _přež,
   {{0x2d8b163e,0xf1bf026f,0x33750a42,0x6723b29d}},	// [1f90] _voce_, mná_, нгар, yanj,
   {{0xdce285f5,0xf1bf027f,0xa3e48054,0x291f8722}},	//   _naoč, lná_, _भीम_, _seua_,
   {{0x6e3c2cb1,0xaad486a7,0xe3c300ab,0x2d8b0037}},	//   curb, _ठुमक, ্গলব, _toce_,
   {{0x59f9893f,0xf1bf2527,0xa91d96f2,0x6723a994}},	//   פּעד, nná_, _koži, wanj,
   {{0x67238025,0x443b0085,0x3f8c816b,0x64499500}},	//   tanj, quq_, _bodu_, xtei,
   {{0xf77180f7,0xa3dd809a,0x66e58071,0x28b201a2}},	//   طات_, _थीं_, нола, ीपति,
   {{0x6723b29e,0x92c280ab,0xe91980e8,0xa91d9249}},	//   ranj, ্ধু_, _нові_, _loži,
   {{0x6449b29f,0xf1bf05b9,0x6d40b2a0,0x212d82f7}},	//   ttei, jná_, ggma, _udeh_,
   {{0x44290788,0xf1bf0775,0x236799b7,0xa91d8450}},	//   nsa_, dná_, _panj_, _noži,
   {{0x442932a1,0x6449b2a2,0x2d8280f2,0x7c3b8079}},	//   isa_, rtei, öker_, ruur,
   {{0xd9460d0e,0xc34e8028,0xfbd20039,0x44291813}},	//   нени, _tổng_, רתי_, hsa_,
   {{0x3f878024,0xaca381bc,0x569486c8,0x644992af}},	//   ljnu_, _ajụk, _шахт, ptei,
   {{0xaacf885d,0x44291554,0xb9081404,0x25bf802e}},	//   _सुरक, jsa_, _भर_, mnul_,
   {{0x660195dd,0xe8df8135,0x7d09b2a3,0x442932a4}},	//   _kulk, _arịa_, lces, dsa_,
   {{0x44292d08,0x66018364,0x7c29b2a5,0xf1bf026f}},	//   esa_, _julk, lser, bná_,
   {{0x660180a4,0xf1bf016b,0xe7e002f1,0x6d9c9e37}},	//   _mulk, cná_, _खीरा_, _léan,
   {{0x7c29b2a6,0x442932a7,0x64a31597,0xdca31b78}},	// [1fa0] nser, gsa_, гата, гати,
   {{0xa3c1800f,0x6721843d,0xf40180c8,0x68e432a8}},	//   ्कि_, _nelj, _এবার_, _izid,
   {{0x442932a9,0x1b1f00ab,0xdb1c0035,0x7d098035}},	//   asa_, _পাশে_, _skró, kces,
   {{0x7d0980d2,0x442932aa,0xf1a99ef7,0x3f8cb2ab}},	//   jces, bsa_, وانه_, _sodu_,
   {{0x1b1f00c8,0x442932ac,0xe814016f,0x6721b114}},	//   _পারে_, csa_, तीचा_, _belj,
   {{0x6d9c80f7,0x7c29b2ad,0x67218353,0x7dde80f1}},	//   _céan, dser, _celj, tëso,
   {{0x6d9c8307,0xa3b501d2,0xa3bf0a61,0x6721b2ae}},	//   _déan, _जगत_, ुकर_, _delj,
   {{0xa2ca8a75,0x7dde80f1,0x7bc3b2af,0x66018084}},	//   _सुग्, rëso, _ajnu, _dulk,
   {{0x6d460358,0x7c29b2b0,0xf1bf0a21,0xb7da8591}},	//   _mcka, gser, vná_, _فورا_,
   {{0xc45380f7,0x6d9c8b6a,0x1fb58195,0x69d60c8b}},	//   اضيع, _géan, _исхр, _akye,
   {{0xf1bf003e,0x7c2985ee,0x7dde8168,0x533700be}},	//   tná_, aser, qëso, ענטן_,
   {{0x442932b1,0x672180d2,0xa91db2b2,0x7d09a3e1}},	//   ysa_, _zelj, _poži, cces,
   {{0x55778158,0xf1bf003e,0xa3d0199e,0x6601b2b3}},	//   _רעדן_, rná_, शवा_, _zulk,
   {{0xe47b812a,0xf1bf026f,0x4429006a,0x5c978a8e}},	//   _מרדכ, sná_, vsa_, _якія_,
   {{0xf1bf026f,0x67e00106,0x68e401f6,0x6be381a8}},	//   pná_, möjl, _ezid, _حكوم,
   {{0x442932b4,0x13d580ab,0xa3e48beb,0xa91d82d4}},	//   tsa_, _হওয়, _भीत_, _toži,
   {{0x24580009,0x41c40c3b,0x442b32b5,0x98b90084}},	// [1fb0] нать_, _حقيق, _qvc_, mesį_,
   {{0x69dd0014,0x23a4016d,0x236a0144,0xf11980c2}},	//   llse, _nöjd_, _cabj_, दर्द_,
   {{0x442932b6,0xa2d40ebf,0x3a3e82f7,0x290b0037}},	//   ssa_, _बुद्, nutp_, occa_,
   {{0x442932b7,0xc984838b,0x5184b2b8,0x7c29b2b9}},	//   psa_, лучи, луча, yser,
   {{0x34940196,0x657d32ba,0x6601b2bb,0x442932bc}},	//   _баяр, _insh, _sulk, qsa_,
   {{0x66019e1f,0x6d5f13de,0x7c29b2bd,0xb17b0338}},	//   _pulk, leqa, vser, llåd,
   {{0x644d32be,0x6721b2bf,0xbbbf1305,0x7c29b2c0}},	//   ltai, _velj, ्वीक, wser,
   {{0x6d5f208e,0x7c29b2c1,0x672732c2,0x644d32c3}},	//   neqa, tser, hajj, otai,
   {{0x6721b2c4,0x644d32c5,0x9f5307e2,0xa3b5064d}},	//   _telj, ntai, _així_, _जगा_,
   {{0x660190c0,0x25bf8359,0x7d0981e8,0x672728d8}},	//   _tulk, snul_, sces, jajj,
   {{0x644d32c6,0x7c29b2c7,0x2d890681,0x34de0ebf}},	//   htai, sser, kjae_, _मर्द,
   {{0xe2968554,0x644d32c8,0x60dbb2c9,0x61fbb2ca}},	//   таю_, ktai, _kyum, _jiul,
   {{0x6d5f0748,0x2ca9076c,0x656d01b4,0x8c45951b}},	//   deqa, jzad_, ddah, _реле,
   {{0x656b8013,0x644d32cb,0x2d8f8a0f,0x69dd0074}},	//   _hagh, dtai, _hoge_, alse,
   {{0x443fb2cc,0x644d0084,0x6d460122,0x9f4581a8}},	//   luu_, etai, _pcka, _chlé_,
   {{0xdde9003d,0x2d8fb2cd,0xfce615a6,0x656d32ce}},	//   فرقه_, _joge_, вобо, gdah,
   {{0x60dbb2cf,0x656bafbb,0x443fb2d0,0xdb1a816a}},	// [1fc0] _nyum, _magh, nuu_, cotó,
   {{0x4e0608cc,0x656bb2d1,0x657d0c2e,0x22ba1ef5}},	//   _изоб, _lagh, _ensh, وداع_,
   {{0x23a400f2,0x644d032f,0x6a860098,0x3ea61630}},	//   _nöje_, atai, ължа, _ринг,
   {{0x443fb2d2,0x61e9b2d3,0x656bb2d4,0xc05a90ac}},	//   kuu_, _chel, _nagh, дік_,
   {{0xd0078698,0x92bd80c8,0xd94395ac,0x61fb8b20}},	//   вече_, _আরো_, речи, _diul,
   {{0xdefa81a0,0x6d4432d5,0x244b806a,0x443f8079}},	//   мый_, lgia, døm_, duu_,
   {{0x764e32d6,0x64598176,0x61fb8162,0xacbb0866}},	//   ntby, _apwi, _fiul, _jeûn,
   {{0x6d4432d7,0x61fbb2d8,0x2d8fb2d9,0x61e9b2da}},	//   ngia, _giul, _coge_, _ghel,
   {{0x80e101fe,0x656bb2db,0x443fb2dc,0x9f4c8198}},	//   _नरें, _dagh, guu_, _pidä_,
   {{0x6d442322,0xb4e28127,0x5fb68074,0xa91d8115}},	//   hgia, _धरी_, _अगिल, _dožu,
   {{0x75228267,0x46d232dd,0x656bb2de,0x19950a4c}},	//   _teoz, _दुलह, _fagh, ганя,
   {{0x2004a479,0x80d100ab,0x61e980f1,0x656b8870}},	//   _kumi_, _সৃষ্, _xhel, _gagh,
   {{0x8c4380e9,0x1d079634,0x656d32df,0xb17b0106}},	//   _вече, _речи_, vdah, vlåd,
   {{0xa2cb016f,0x656bb2e0,0x6440b2e1,0x2004b2e2}},	//   _तुझ्, _zagh, mumi, _mumi_,
   {{0x6440b2e3,0xa3c18128,0x6d9c80f7,0x2004b2e4}},	//   lumi, ्कर_, _léam, _lumi_,
   {{0x6d440698,0xa2b804c5,0x644d0364,0xa3b50740}},	//   ggia, ्पन्, ttai, _जगह_,
   {{0x6d9c94e1,0x6440b2e5,0x656d0359,0x644d051e}},	// [1fd0] _réal, numi, rdah, utai,
   {{0x644d32e6,0x6d5f05e7,0x61fbb2e7,0xbbbf000c}},	//   rtai, seqa, _siul, ्वेक,
   {{0x6440822e,0x61e9b2e8,0x644d32e9,0x60db80ee}},	//   humi, _phel, stai, _syum,
   {{0x656d02ed,0x6440b2ea,0x2004859c,0x99d180ab}},	//   qdah, kumi, _bumi_, িষ্ক,
   {{0x443f82c1,0x64408029,0x7c841baa,0x656bb2eb}},	//   xuu_, jumi, _куре, _ragh,
   {{0x6440b2ec,0xb60583cb,0x7d0d32ed,0x2004b2ee}},	//   dumi, hláš, lcas, _dumi_,
   {{0x656b97ef,0x99678d69,0x61e9b2ef,0x28da10be}},	//   _pagh, _итал, _thel, _युनि,
   {{0x4efc0051,0x443fad48,0x3949022c,0xa91d812b}},	//   ולוג, tuu_, _ncas_, _požu,
   {{0x6440b2f0,0xa3d8016f,0xa3c18aed,0x60db8bdf}},	//   gumi, ातच_, ्कल_, _uyum,
   {{0x443f927b,0x244b8aa2,0xceeb92c8,0x7d0d0362}},	//   ruu_, røm_, _قران_, hcas,
   {{0xe299b2f1,0x3869318b,0x656bb2f2,0x2d8f933b}},	//   хан_, _asar_, _tagh, _toge_,
   {{0x98b20201,0xe5708c2a,0x6440b2f3,0x443fb2f4}},	//   _sayı_, _وطن_, bumi, puu_,
   {{0x7d1bb2f5,0xad9b1d3a,0x6440925c,0x7c2d0338}},	//   mbus, _miúd, cumi, jsar,
   {{0x442db2f6,0x7c2d0bbd,0x6a7781bc,0x39490580}},	//   mse_, dsar, _ụfo, _ecas_,
   {{0x442db2f7,0xed5a1928,0xd5ac8065,0x386902c4}},	//   lse_, нов_, _رہی_, _esar_,
   {{0xceb283c8,0x442db2f8,0x29000118,0x69c38061}},	//   צין_, ose_, _ugia_, énel,
   {{0x442db2f9,0x69db0158,0x707700f7,0x7c3b802a}},	// [1fe0] nse_, _אַזו, _مميز_, nrur,
   {{0x442db2fa,0x6d9c80f7,0x1c1ba8b3,0x442fb2fb}},	//   ise_, _réam, पीएल_, _mvg_,
   {{0x6440b2fc,0x442db2fd,0x77f70039,0x2004b2fe}},	//   zumi, hse_, _תמיד_, _sumi_,
   {{0x442db2ff,0x9f5a06c0,0x7d0d00e5,0xaca384be}},	//   kse_, _sipè_, ccas, _akọk,
   {{0x64e2823c,0x442db300,0x25d70039,0x69c2b301}},	//   _परेश, jse_, _תוכן_, rnoe,
   {{0x38cb91fb,0x442db302,0xb7d280ab,0x6440b303}},	//   رانی_, dse_, াষ্ট, vumi,
   {{0xfaa617f4,0x7bcb087a,0x499482e3,0x316d80b9}},	//   _саво, égue, _پیشر, _faez_,
   {{0x6440b304,0x6d9c80f7,0x62810088,0x7d1bb305}},	//   tumi, _téam, _šlog, gbus,
   {{0x5b26aafb,0xd326976a,0x442db306,0xb99380f7}},	//   льна, льни, gse_, _القب,
   {{0x6440b307,0xf366a3e0,0x3946b308,0xaca401bc}},	//   rumi, утин, lgos_, _nsọt,
   {{0x442db309,0x7c2d0029,0xafdb0aa2,0x7dde8168}},	//   ase_, zsar, ktør, hësi,
   {{0x3946b30a,0xdb01b30b,0x7dde8168,0xaca4046d}},	//   ngos_, filó, kësi, _asọt,
   {{0x7c3b802e,0x7d028135,0xc5f38039,0x442db30c}},	//   crur, _igos, _הדף_, cse_,
   {{0x6ed61d17,0x66051e71,0xb8fd32dd,0xb8dd03b7}},	//   _मुहु, _puhk, _तँ_, _आध_,
   {{0x4422330d,0x7c2d01e0,0x394900b9,0x7dde8168}},	//   _awk_, wsar, _tcas_, tësh,
   {{0x63ba83cb,0x7c2d330e,0x4422036e,0x27ec80ee}},	//   litn, tsar, _bwk_, _lhdn_,
   {{0x386903aa,0x7d0d17d6,0x69c382be,0x26de808e}},	// [1ff0] _usar_, rcas, énem, _lyto_,
   {{0x212b330f,0x3946b310,0x63ba8f20,0x798083ec}},	//   lach_, egos_, nitn, _anmw,
   {{0x7c2d0e20,0x61ed1b4f,0x8afe8300,0x316d8144}},	//   ssar, _khal, _baƙi, _paez_,
   {{0x212b3311,0x7d02b312,0x7c2d26b1,0x442db313}},	//   nach_, _ngos, psar, yse_,
   {{0x39498029,0x1869817c,0xa069b314,0x61ed125b}},	//   ļas_, тали_, тала_, _mhal,
   {{0x212b0083,0x656f3315,0x25a93316,0xe736b317}},	//   hach_, _hach, lhal_, аеш_,
   {{0x656f3318,0x212b1988,0x244f0457,0x7c2284be}},	//   _kach, kach_, lüm_, _awor,
   {{0x442db319,0x629a8d42,0x212b0035,0x2bbf0b84}},	//   tse_, dyto, jach_, ्वका,
   {{0x212b330f,0x291db31a,0x656f331b,0x442d90b6}},	//   dach_, mbwa_, _mach, use_,
   {{0x656f331c,0xe7a983bb,0x7d028870,0x61ed011e}},	//   _lach, _कतिप, _egos, _ahal,
   {{0x61ed331d,0x26e4000d,0x4acf999e,0xf98617c7}},	//   _bhal, _गरेर_, _सुखव, агно,
   {{0x656f331e,0x442db31f,0x212b3320,0x3f812f9f}},	//   _nach, pse_, gach_, _anhu_,
   {{0x7643b321,0x61ed02c1,0x15f484e3,0x25a905a1}},	//   luny, _dhal, _اسلح, dhal_,
   {{0x629ab322,0x656f3323,0xdca28fc8,0x63ba9b40}},	//   byto, _aach, _фаши, citn,
   {{0xb8fd0935,0x645d0110,0x212b3324,0x39468110}},	//   _तु_, _apsi, bach_, ygos_,
   {{0x7dde820f,0x61ed3325,0x3d20009a,0x25a901e4}},	//   tësi, _ghal, बरें_, ghal_,

   {{0x656f3326,0x7643b327,0x8c46143b,0x044600e8}},	// [2000] _dach, huny, резе, резн,
   {{0x7dde820f,0x656f0ad0,0x7643b328,0xd76402e3}},	//   rësi, _each, kuny, _اندی,
   {{0x320787e2,0x656f3329,0x34e28b04,0x764389ca}},	//   _juny_, _fach, _पर्द, juny,
   {{0x656f332a,0x25a91054,0x39468110,0xd2e603a4}},	//   _gach, chal_, ugos_, _करीब_,
   {{0x39469e00,0x7dde80f1,0x8eb3003d,0x2d820326}},	//   rgos_, qësi, _همیش, _inke_,
   {{0x656f0f66,0x81bd0029,0x394685a4,0x6d59b32b}},	//   _zach, lsēt, sgos_, _abwa,
   {{0x76438dc4,0x8afe8326,0x56948705,0x798085ee}},	//   guny, _taƙi, сайт, _tnmw,
   {{0x6d5606c0,0x645d00e5,0x25a0332c,0x63bab32d}},	//   nfya, _ypsi, nkil_, witn,
   {{0x88bd8063,0x2fd8016d,0x7763ac88,0xdb1aa5ce}},	//   _jeśl, korg_, benx, entá,
   {{0x61ed332e,0x29120010,0x386980f1,0x26de801b}},	//   _shal, _afya_, çare_, _tyto_,
   {{0x212b332f,0xc333078d,0x76439481,0x7ac69509}},	//   tach_, חות_, cuny, рспе,
   {{0x7d028025,0x7c22809a,0x29dc8511,0x96958bda}},	//   _ugos, _twor, mías_, _уруш,
   {{0x212b3330,0x29dc8511,0x6728b331,0xa49b0580}},	//   rach_, lías_, _kedj, _agòn,
   {{0x212b3311,0x656f3332,0x2d823333,0x644f809f}},	//   sach_, _sach, _anke_, àcie,
   {{0x61ed1e66,0x6728b334,0x656f0e44,0x29dc8511}},	//   _thal, _medj, _pach, nías_,
   {{0x6728807d,0x61ed004f,0x656f2795,0x8afe8326}},	//   _ledj, _uhal, _qach, _saƙw,
   {{0x2fd83335,0x656f1030,0x25a90965,0x61e28122}},	// [2010] borg_, _vach, rhal_, dlol,
   {{0x656f3336,0x672882fd,0x9f5e820f,0x25a91b66}},	//   _wach, _nedj, _ditë_, shal_,
   {{0x656f3337,0x68e98019,0x200102c4,0x20090326}},	//   _tach, _szed, _iihi_, _huai_,
   {{0x656f1a29,0x76438aef,0x29dc85e4,0x2cad808e}},	//   _uach, vuny, días_, yzed_,
   {{0xa3e680c2,0xa2d88540,0xe7398256,0x68e0831d}},	//   पता_, _नुस्, гел_, _cymd,
   {{0x785a8029,0x7643b338,0x29dc82ba,0x8a170077}},	//   dāvā, tuny, fías_, _نظرا,
   {{0xf7708bbe,0x29dc85a4,0xed598d55,0x7763802a}},	//   بان_, gías_, гой_, renx,
   {{0xa3b305e8,0x764389ca,0x752d3339,0x2fd800f3}},	//   जोर_, runy, naaz, zorg_,
   {{0xbee403bb,0x76438d6d,0x68e08114,0x8afe80fc}},	//   _गर्न_, suny, _gymd, _maƙu,
   {{0x76438886,0xed59812b,0x29dc8020,0x4a4592ea}},	//   puny, diže_, bías_, бнов,
   {{0xe1fa0396,0x29dc85e4,0x6b95333a,0xd5758110}},	//   лго_, cías_, _mozg, _гуль,
   {{0x6d5982a0,0x200900ee,0x6728826c,0x35f5abd9}},	//   _ubwa, _buai_, _zedj, _упер,
   {{0xd24e8416,0x200900ee,0x2fd8008b,0xf1b283de}},	//   ونی_, _cuai_, torg_, לסט_,
   {{0x443fb33b,0x200900b9,0x6d49b33c,0xf4128039}},	//   mru_, _duai_, lgea, _צפו_,
   {{0x78c10086,0x66e6333d,0xdb1ab33e,0x6b83b33f}},	//   _əvvə, сова, zitë, _inng,
   {{0x6d49947d,0x29008110,0x394d81c0,0xdce4012b}},	//   ngea, žiai_, _nces_, ndić,
   {{0x6d49832f,0x69d9809a,0x7984020d,0x20093340}},	// [2020] igea, dowe, _iniw, _guai_,
   {{0x25a03341,0x443fb342,0x68e08106,0x65641f5d}},	//   skil_, iru_, _rymd, seih,
   {{0x29dc84c3,0x443fb343,0x490680f7,0x67288b80}},	//   xías_, hru_, مواق, _redj,
   {{0x5d860013,0x614691b3,0x705309d7,0xd764015b}},	//   _الحل, седа, _بنیا, _انگی,
   {{0x2056b344,0x6b95026c,0xe3b10065,0x67288088}},	//   стер, _fozg, سرے_, _pedj,
   {{0x443fb345,0x29dc91b9,0x23658267,0xfbc78481}},	//   dru_, tías_, jelj_, _رت_,
   {{0x44321486,0x443fb346,0x9f520144,0xe2970088}},	//   lsy_, eru_, _huyó_, _лар_,
   {{0x29dc960a,0x443f8b67,0x98a68012,0x15fa0bb8}},	//   rías_, fru_, _либе, ्दिर_,
   {{0xdb1ab347,0x44323348,0x443fb349,0x29dc8511}},	//   lité, nsy_, gru_, sías_,
   {{0x320a334a,0x6d498706,0x29dc8333,0x7984113b}},	//   _kuby_, agea, pías_, _aniw,
   {{0xa3d90ee6,0xdd8f8162,0x15f811bc,0x200903ac}},	//   ावत_, _еш_, ंगार_, _suai_,
   {{0x443fb34b,0x394d334c,0x7dde8168,0x25a682d5}},	//   bru_, ües_, tësu, _ulol_,
   {{0x443f8012,0x2009334d,0x8afe89ab,0x6ac4066b}},	//   cru_, _quai_, _raƙu, वपुर,
   {{0x7dde80f1,0x442684be,0x443201b0,0x33f68226}},	//   rësu, _iwo_, dsy_, _учес,
   {{0x9f5e80e7,0x3da709a8,0xdced0699,0x69d9804f}},	//   _cité_, браб, rdač, yowe,
   {{0x7bda8bd2,0xd131003d,0x200900ee,0xb88601d0}},	//   lotu, _کمک_, _tuai_, _spíš,
   {{0x6eda8076,0x7dde80f1,0xdcfd026c,0xb60689d1}},	// [2030] _पुसु, qësu, _posđ, lišć,
   {{0x6ac401c4,0x68ed0b67,0x44269437,0xa3b3009a}},	//   वपूर, _izad, _mwo_, जों_,
   {{0x69d9b34e,0x3cde016f,0x7bc8b34f,0xdd950196}},	//   towe, _कुठे_, indu, _даны,
   {{0x19598084,0x4426877f,0xa159b350,0x127b80be}},	//   рады_, _owo_, раду_, טאבע,
   {{0x44268091,0xf09f3351,0x69d9b352,0x7bda9619}},	//   _nwo_, nyà_, rowe, kotu,
   {{0x8cdc800f,0x645c802e,0xbcfb3353,0x01cf00ab}},	//   _पड़ो, ăril, _abég, রতিদ,
   {{0x35f803f8,0x4426b354,0xdb1a80e7,0x7bda8d15}},	//   _خرید_, _awo_, cité, dotu,
   {{0xa2b81d40,0x44268e4d,0xd0d58098,0x394db355}},	//   ्पर्, _bwo_, _добъ, _uces_,
   {{0x6d498068,0x443fb356,0x386d8051,0x442682f7}},	//   rgea, uru_, _user_, _cwo_,
   {{0x443f8aee,0x6d49b357,0x212f8229,0xdb0e008b}},	//   rru_, sgea, lagh_, _embæ,
   {{0x6d5d0a56,0x68ed0201,0x6602b358,0x198a0098}},	//   _obsa, _azad, _fiok, абни_,
   {{0x443fb359,0x66028037,0x23659502,0xbcfb046d}},	//   pru_, _giok, selj_, _gbég,
   {{0xa3d90576,0x4426b35a,0x2365817f,0x629e009a}},	//   ावा_, _gwo_, pelj_, zypo,
   {{0x6d5d335b,0x6d4f0098,0x25bf8087,0x6b8380e8}},	//   _absa, _acca, liul_, _unng,
   {{0x9f52046d,0xa50a335c,0x68ed0c2e,0xd62a108d}},	//   _buyò_, иева_, _ezad, робе_,
   {{0x44321af4,0xdb1a82be,0x25bf802e,0x386000b4}},	//   tsy_, vité, niul_, _tpir_,
   {{0x249f9ca6,0x212f8706,0x290501d0,0x752bb35d}},	// [2040] nyum_, dagh_, ělat_, _megz,
   {{0x4432335e,0x212280bc,0x25bf8162,0x61e60fb6}},	//   rsy_, मर्श_, hiul_, llkl,
   {{0xed5a00a9,0x3dc902d5,0x7a08928a,0x826601a8}},	//   _кон_, bnaw_, _pěti, تهان,
   {{0x00e6a606,0xe9da8604,0xdb1ab35f,0xd3788503}},	//   ожен, шке_, rité, moće_,
   {{0x25bf802e,0x7bda804f,0x7bc8808b,0x25ad9ab3}},	//   diul_, yotu, yndu, dhel_,
   {{0x442682a0,0x2d99b360,0xc7a39a19,0x8fa39ad8}},	//   _rwo_, ösen_, мичк, маче,
   {{0x59ca09c2,0x2454039c,0xf8bf0866,0xd37880fe}},	//   ाचार, läm_, mbée_, noće_,
   {{0x2cbf00fe,0x25adb361,0x2d9202a0,0xdc1e80ab}},	//   _žudi_, ghel_, njye_, _দিবস_,
   {{0xc5f3078d,0x938a9b2f,0x7bdab362,0x2717001b}},	//   ודה_, асна_, totu, nění_,
   {{0xa3e48105,0xa3ea00bc,0x442681ed,0x68ed0035}},	//   _भीख_, मति_, _vwo_, _rzad,
   {{0x7ae3831d,0x86c680f7,0xf1bf01df,0xddc8826c}},	//   _cynt, _بيان, tiá_, _irdž,
   {{0xb606b363,0x44268051,0x25bf802e,0x29008110}},	//   rišć, _two_, ciul_, žiau_,
   {{0x44268578,0x7bdaae5e,0x25d9803d,0xcf00011c}},	//   _uwo_, potu, _اهنگ_, əşən_,
   {{0x4374803d,0x271701d0,0x68ed016b,0xc6a71d7b}},	//   _رهبر, dění_, _vzad, орби,
   {{0x3ea50019,0x7ae38114,0xa3d906ae,0xed59811f}},	//   ált_, _gynt, ावस_, liža_,
   {{0x321e89c4,0xdb1703a8,0x51870b26,0x7647018e}},	//   mpty_, rixí, _фука, rujy,
   {{0x5fbc801b,0x030e8816,0x68ed3364,0x6d9c81a8}},	// [2050] ्चाल, _सलाह_, _uzad, _héas,
   {{0x69dd3365,0x09d38bbc,0xd37101a8,0x7a35819d}},	//   lose, तव्य, عها_, _ẹtit,
   {{0xe8d90870,0xdb01956e,0x211881bc,0xc3240264}},	//   _mbọ_, silö, _ịtụl, _পাখি_,
   {{0xe0d383f8,0x6b988edd,0x249f9c99,0x67ed95a0}},	//   وزش_, _lovg, yyum_, dúja,
   {{0x29090122,0x95160039,0xdb1e0580,0x6d4d14ba}},	//   _mgaa_, _מקרא_, kipè, mgaa,
   {{0x81c30a49,0x2d9900b4,0x6cfa0039,0x1b2280ab}},	//   ্তি_, _hose_, _לפרס, _মাঝে_,
   {{0x2d992637,0x69dd3366,0x25adb367,0x67ed8019}},	//   _kose_, kose, thel_, gúja,
   {{0x6d4d12eb,0xdceb84b7,0xe8d9046d,0x29093368}},	//   ngaa, _jogħ, _abọ_, _ngaa_,
   {{0x65a30006,0x81c300c8,0x25bf802e,0xdceb9693}},	//   _põhj, ্তা_, riul_, _bagā,
   {{0x5ba98319,0x290901bc,0xdceb84b7,0x26d30216}},	//   ском_, _agaa_, _logħ, _oxxo_,
   {{0x69cbb369,0x249fb36a,0x25bf8087,0x95cba857}},	//   onge, syum_, piul_, _куда_,
   {{0x2005822e,0x2ca0336b,0x69dd0168,0x186a2306}},	//   _hili_, yyid_, gose, бами_,
   {{0x69cbb36c,0xda0b8035,0x6d5b8c53,0x6d4d336d}},	//   inge, _सूरत_, mfua, dgaa,
   {{0xd9b8800c,0xa4fa81c6,0xaabd09c1,0x2d99010c}},	//   _अष्ट, _פלסט, ्पाक, _aose_,
   {{0x2d9902a0,0x2005b36e,0x59db86bf,0x76438359}},	//   _bose_, _mili_, यकार, nrny,
   {{0xf992003f,0x2005b36f,0x6d4d3370,0x2d990098}},	//   _سبب_, _lili_, ggaa, _cose_,
   {{0xdb1e020f,0x02c4016f,0x6ac4036d,0x7643808e}},	// [2060] qipë, वप्न, वप्र, hrny,
   {{0x6d4d1cbc,0x6569b371,0x395f89cd,0xa3cb8072}},	//   agaa, heeh, _abus_, रचि_,
   {{0x2d993372,0x479b0158,0x98b0805c,0x179b00be}},	//   _fose_, _הייס, đači_, _הייב,
   {{0x7bc1b373,0x6d9c80f7,0xddc88754,0x80da80ab}},	//   hilu, _léar, _srdž, _বৃষ্,
   {{0xd12f8d4a,0xa3bd835a,0x75243374,0x7bc1b375}},	//   امه_, ीचा_, mbiz, kilu,
   {{0x26118104,0x2005b376,0xdb1e09c4,0x6449809f}},	//   _báo_, _cili_, kipé, duei,
   {{0xa3d91cd4,0x2005b2db,0x26118028,0x44203377}},	//   ावर_, _dili_, _cáo_, lpi_,
   {{0x7bde23be,0xdcebb378,0x66061bcd,0x77ab0085}},	//   lopu, _xogħ, _jikk, _müxa,
   {{0x6449abe1,0x2005b379,0x6d9c81a8,0x4420337a}},	//   guei, _fili_, _béar, npi_,
   {{0x0b8a8364,0x3160008e,0x6d9c81a8,0x6606337b}},	//   ссии_, _abiz_, _céar, _likk,
   {{0xe4d699f4,0x46db0105,0x6d9c81a8,0x644401b4}},	//   _کتاب, _मुंह, _déar, hrii,
   {{0xdb1ab37c,0x7bde0133,0x6d9c8388,0xfbc400ab}},	//   mití, hopu, _véas, ্তিত,
   {{0x644983d3,0x7bc1b37d,0xdb1ab37e,0x7bde0198}},	//   cuei, bilu, lití, kopu,
   {{0x2259809a,0xe8d9019d,0x200581b4,0x6d9c8174}},	//   ńska_, _nnụ_, _xili_, _géar,
   {{0x6d4d26a1,0x6a1380f7,0xe3c400ab,0xdb1e00f7}},	//   tgaa, _كبير, ্তাব, cipé,
   {{0x66060065,0xe8d90870,0x91e40eef,0x1c11864a}},	//   _cikk, _anụ_, _поје, _डूडल_,
   {{0x6606337f,0xa3d90006,0x539921f6,0x442000e4}},	// [2070] _dikk, ावल_, овая_, gpi_,
   {{0x25ef05b3,0x3374002e,0x2a6302f7,0x7bde008e}},	//   _आठवी_, нгур, _ppjb_, gopu,
   {{0x35f5018b,0xdb0181ec,0x44203380,0xa3b30a43}},	//   _опор, chlä, api_, जोग_,
   {{0x69cb8081,0x644410b5,0xdb1e0198,0x7bc1b381}},	//   unge, brii, enpä, zilu,
   {{0x2005822e,0x200d8081,0x3ce681c0,0x7777022b}},	//   _pili_, _quei_, _nyov_, _kaxx,
   {{0x69dab382,0xdb23003d,0x66e5b383,0xdee5951b}},	//   _íten, _سوری, мола, моли,
   {{0x7bc184b7,0xe7308fc5,0x44393384,0x6d5b80b9}},	//   vilu, اصه_, _hvs_, tfua,
   {{0x69c288f1,0x2005b385,0x395f833e,0x6449b386}},	//   cioe, _wili_, _ubus_, tuei,
   {{0x7bc1b1c4,0x387f81b4,0x752f0035,0x290080e1}},	//   tilu, _urur_, _mecz, žiar_,
   {{0x752f009a,0x261180ff,0x799b8bfd,0xad9b0174}},	//   _lecz, _táo_, _houw, _siúl,
   {{0xd94623e0,0x7bc18a6e,0x61460d45,0x44200102}},	//   мени, rilu, мена, zpi_,
   {{0x5ec100ab,0x799bb387,0x7bc1b388,0x44203389}},	//   _শুভে, _jouw, silu, ypi_,
   {{0x6606338a,0x7bc1802e,0x6d9c80f7,0x64499a7d}},	//   _rikk, pilu, _téar, quei,
   {{0x660606be,0x69c28102,0x777700e5,0x799bb38b}},	//   _sikk, zioe, _caxx, _louw,
   {{0x66e3338c,0x6606037b,0x7a08800d,0x1db183eb}},	//   вора, _pikk, _děts, _जतात,
   {{0x69bf89a3,0x3dcd822b,0x644414c7,0xdb1c338d}},	//   लोमी, nnew_, trii, _imré,
   {{0x7bde0b67,0x5f76045b,0xdb1a8524,0xa3d9016f}},	// [2080] topu, _قادر, zití, ावं_,
   {{0x4439338e,0x64441eaf,0x660625d0,0xf77201f9}},	//   _dvs_, rrii, _wikk, _شاخ_,
   {{0x81c300c8,0x6606338f,0x7c360338,0x799b8a0f}},	//   ্তর_, _tikk, ssyr, _bouw,
   {{0x64a60071,0x64443390,0x2904026c,0x6d9c810c}},	//   _жама, prii, žmau_, _néap,
   {{0x69c2811b,0x799b9c11,0x2a6d01a1,0xdb1a82df}},	//   rioe, _douw, _ćebe_, nitã,
   {{0x43753391,0x7a0c0087,0xd378abea,0x7989b392}},	//   _пуст, _aşte, koća_, _enew,
   {{0x7c2b8114,0xa3db06af,0x799b8176,0x6b9c304c}},	//   _awgr, डकर_, _fouw, _iorg,
   {{0x5c749508,0x65a30006,0x6b9c3393,0x61e43394}},	//   елит, _põhi, _horg, _nkil,
   {{0x69c0b395,0x6b9c1388,0xbeeb064a,0x21268d8b}},	//   _imme, _korg, _टर्न_, mboh_,
   {{0x61e40010,0xf3668d9e,0x7d0b8558,0x7ac6818b}},	//   _akil, фтин, _eggs, дсме,
   {{0xa3b60e18,0x3ddf8a0f,0xbcfb01a8,0x6b9c3396}},	//   _जतन_, bouw_, _mbéa, _morg,
   {{0x6b9c0c41,0x9e658065,0x61f610ae,0x237802d6}},	//   _lorg, _سامن, _chyl, _larj_,
   {{0x6b9c01b0,0x0cc900ab,0x6562818e,0x00000000}},	//   _oorg, _শর্ত, _iboh, --,
   {{0xead49ea4,0x6b9c0cde,0x2cb0861c,0x61e43397}},	//   _поль, _norg, ıldı_, _ekil,
   {{0xbd0580e7,0x69c08a6f,0xf8ae004e,0xdd9b1617}},	//   _théâ, _omme, لکی_, оша_,
   {{0xfaa7803d,0xdb1a92d0,0xc5f881a9,0x96f80993}},	//   _تجهی, lità, _spēj_, фест_,
   {{0x3cfc011b,0x6b9c3398,0xdce980d2,0x94ab06b5}},	// [2090] рvv_, _borg, rdeć, цтва_,
   {{0x799b82d6,0x69c0b399,0x44390370,0xdb1ab39a}},	//   _souw, _amme, _vvs_, nità,
   {{0x6562816b,0xafdb004a,0x69cf0037,0xfd100061}},	//   _oboh, nrøm, once, اجہ_,
   {{0x77b000f2,0x442b041c,0x673507d8,0x3495164f}},	//   _växe, _twc_, lazj, _замр,
   {{0x6b9c1c93,0x2d8b02d0,0x7e620b80,0x799b890d}},	//   _forg, _ince_, _ćopi, _vouw,
   {{0x69c0b39b,0xdce407d9,0x644d000e,0x67352358}},	//   _emme, ldiğ, muai, nazj,
   {{0x644d32be,0x4ae401e2,0x4ad903b7,0x16a9af92}},	//   luai, _аўта, _बँटव, явки_,
   {{0x6b9c339c,0xc8c0835a,0x7bc5339d,0xdce40214}},	//   _zorg, _शेवट, lihu, ndiğ,
   {{0x4439b39e,0x644d339f,0x3ddf81ed,0x290d80e5}},	//   és_, nuai, rouw_, _igea_,
   {{0x61e42b0d,0x3dcd89c4,0x69cf24cc,0x7bc533a0}},	//   _skil, snew_, ence, nihu,
   {{0x25a90065,0xfaa58470,0x2d8b1b7d,0x644d01a8}},	//   kkal_, хано, _once_, huai,
   {{0x9f47816b,0x22598035,0x6dc792c8,0x7d0b80c3}},	//   dlné_, ńsko_, _غزال, _uggs,
   {{0x320902d5,0xa5c6807b,0x6abd1107,0x7bc533a1}},	//   _diay_, sjóð, ्पुर, kihu,
   {{0x2d8b33a2,0x644d33a3,0xdb1a8980,0x2d9db3a4}},	//   _ance_, duai, cità, _howe_,
   {{0x645bb3a5,0x24598385,0x2d9da0d2,0x7a0901d0}},	//   ltui, lèm_, _kowe_, _větr,
   {{0x65aa003e,0x657b9849,0x3209001c,0x06072dd0}},	//   _výho, nduh, _giay_, енск_,
   {{0xd46715fd,0x04430e6b,0xb4db026b,0x68e980d7}},	// [20a0] ните_, летн, _adàb, _nyed,
   {{0x69c633a6,0x2d8b03a8,0x213f885c,0x6abd0b04}},	//   like, _ence_, _aduh_, ्पूर,
   {{0x6b9c02af,0xdb1ab3a7,0x814680f7,0x68e9ac9a}},	//   _vorg, nitá, فنان, _ayed,
   {{0x69c633a8,0x2d9d809a,0x68e985ee,0x645b9407}},	//   nike, _nowe_, _byed, ktui,
   {{0x644d0748,0x764e0c8b,0x6b9c33a9,0x201209ab}},	//   cuai, luby, _torg, _juyi_,
   {{0x290d802a,0x69c633aa,0x201209ab,0x6283b3ab}},	//   _egea_, hike, _muyi_, _orno,
   {{0x201fb3ac,0xfa670d8f,0xda0b8327,0x56949383}},	//   _etui_, _парк_, _संगत_, тайт,
   {{0xd5b7abca,0xf3908028,0xc693036b,0x69c0b3ad}},	//   есь_, _cảnh_, ראה_, _umme,
   {{0x6283b3ae,0x7c2433af,0x2d9db3b0,0x61e2a6e8}},	//   _arno, npir, _dowe_, mool,
   {{0x61e2b3b1,0x765c009a,0xafdb03ba,0x39402179}},	//   lool, ktry, trøm, _adis_,
   {{0x6283803b,0x69c633b2,0xf8bf8125,0xdb1ab3b3}},	//   _crno, fike, _þér_, gitá,
   {{0x248000ce,0x765c01a3,0x69c61c88,0x201233b4}},	//   kvim_, dtry, gike, _buyi_,
   {{0x3f9e84b9,0xfbcf82e3,0x644d0ba3,0xdce402d0}},	//   _kotu_, شتی_, xuai, vdiğ,
   {{0x8c1b893f,0x394033b5,0x229480f7,0x7c24007a}},	//   _צווי, _edis_, _للتس, dpir,
   {{0x61e2b3b6,0x69c633b7,0x61eb951e,0xfe700065}},	//   kool, bike, ylgl, یدہ_,
   {{0x644d33b8,0x3f9eb3b9,0xf0a680ff,0xdced01a1}},	//   tuai, _lotu_, _đành_, ndać,
   {{0x3cfc2e2b,0xdce407d9,0x798d33ba,0x32111142}},	// [20b0] लेले_, rdiğ, _inaw, _suzy_,
   {{0x25a933bb,0x657b9408,0x644d032f,0x386933bc}},	//   skal_, zduh, ruai, _ipar_,
   {{0x644d25e0,0x325511d2,0xc3338039,0xdcef0162}},	//   suai, твер, רוע_, _bacă,
   {{0x7aea83ed,0x27e333bd,0x247202d6,0x7bc533be}},	//   _myft, lojn_, _fņm_, sihu,
   {{0x7aea8408,0x777aabfa,0x6579b3bf,0xf3908129}},	//   _lyft, _batx, _rawh, _rảnh_,
   {{0xf7718250,0x69c633c0,0x10a282ee,0xdb1a85be}},	//   شات_, zike, ришн, litæ,
   {{0x69c633c1,0x0675b3c2,0x61e2b3c3,0xd91581e2}},	//   yike, туля, bool, _адбы,
   {{0xd6ce8013,0xfc3f826f,0x61e2b3c4,0x68fb0084}},	//   تقى_, ším_, cool, žudy,
   {{0x69c633c5,0x2a6780ee,0x777ab3c6,0x657bb3c7}},	//   vike, _spnb_, _fatx, rduh,
   {{0x09ca053e,0x645b8b3c,0x798d33c8,0x5ed700ab}},	//   ाच्य, rtui, _anaw, _ধরনে,
   {{0x69c6288e,0x6579b3c9,0x645bb3ca,0x2fc7b3cb}},	//   tike, _tawh, stui, ming_,
   {{0xaca3819d,0x62838267,0xf8bf002a,0x765c33cc}},	//   _amụk, _vrno, rbén_, vtry,
   {{0x7529b3cd,0x98a48084,0x7c24010c,0x69c633ce}},	//   mbez, _temą_, xpir, rike,
   {{0x69c633cf,0x7c3b80dd,0x6449b3d0,0x644680fe}},	//   sike, msur, mrei, škic,
   {{0x66e62344,0x2c1980c8,0xdee6210d,0xd007023a}},	//   това, _দিয়ে_, тови, тере_,
   {{0x2fc7b3d1,0x7d1b8289,0x661c8019,0xceb284de}},	//   hing_, ncus, _érke, ביל_,
   {{0x2fc7860c,0xff26087e,0xe8fa0698,0x973c8a20}},	// [20c0] king_, _импо, _юли_, _hoće,
   {{0x2fc7b3d2,0x6449b3d3,0x7c3bb3d4,0xd00f004e}},	//   jing_, irei, isur, _گلی_,
   {{0x2fc7b3d5,0x24800025,0x6449b3d6,0x61e2b3d7}},	//   ding_, svim_, hrei, tool,
   {{0x6449b3d8,0x3ea7831d,0x442f80b9,0x6cc6053b}},	//   krei, dynt_, _owg_, _айма,
   {{0xb82280c8,0x61e290b5,0x442f8282,0x2056b3d9}},	//   _নিহত_, rool, _nwg_, ттер,
   {{0x6449b3da,0xb17b016d,0x2fc7b3db,0x61e2b3dc}},	//   drei, llåt, ging_, sool,
   {{0x973cb3dd,0x163780f7,0x61e2b3de,0x660bb3df}},	//   _noće, نسية_, pool, _bigk,
   {{0x6449b3e0,0xd01a00c8,0x557481f3,0x442f80b9}},	//   frei, তীয়_, угит, _bwg_,
   {{0x2fc797ef,0x6449a2a5,0xe817000f,0x7aea816d}},	//   bing_, grei, _धंधा_, _syft,
   {{0x442f8358,0x2fc7b3e1,0x69c42e3a,0x6e3e01a1}},	//   _dwg_, cing_, _amie, _ovpb,
   {{0x38691610,0x19590a14,0xf1f60035,0x23a40338}},	//   _spar_, наны_, ीगढ़_, _höjs_,
   {{0x6449b3e2,0xf1a71980,0x973c8267,0x200c804f}},	//   brei, трон, _doće, _hidi_,
   {{0xe1ff05a4,0xc05810ac,0x6e22192c,0xa3e203db}},	//   rmó_, кір_, _čoba, दवा_,
   {{0x9f5307e2,0x2618801c,0x38698168,0x7c22b3e3}},	//   _això_, _kéo_, çari_, _itor,
   {{0xf8bf0003,0x4ea433e4,0xc6a41317,0x200cb3e5}},	//   mbém_, арта, арти, _midi_,
   {{0x7c22b3e6,0x798d33e7,0x200c81d0,0x2fc78e9e}},	//   _ktor, _unaw, _lidi_, zing_,
   {{0x2fc78051,0x6abd01a2,0x69c380e7,0x9f430168}},	// [20d0] ying_, ्प्र, ènem, nojë_,
   {{0x69c4219c,0x68ed02c1,0x8aa7023a,0x02a700e8}},	//   _zmie, _iyad, кред, крем,
   {{0x9f5e8364,0x2fc7b3e8,0x26188866,0x75d50c3b}},	//   _mitä_, ving_, _néo_, _ميدا,
   {{0xc6920159,0x7bc88867,0x7c22b3e9,0xdd9513cd}},	//   _האט_, hidu, _otor, _самы,
   {{0x2fc7b3ea,0x200c9a73,0x7bc8b3eb,0x248681c0}},	//   ting_, _bidi_, kidu, _nrom_,
   {{0x657d33ec,0xfc3f803e,0x261880ff,0x442f822c}},	//   _hash, šík_, _béo_, _rwg_,
   {{0x657d33ed,0x7c22b3ee,0xcf94098a,0x7bc8a060}},	//   _kash, _ator, יטס_, didu,
   {{0x657d020f,0x7c3bb3ef,0x442f822c,0x24869c11}},	//   _jash, tsur, _pwg_, _brom_,
   {{0x2fc7b3f0,0x657d33f1,0x61e9b3f2,0x75299083}},	//   ping_, _mash, _ikel, rbez,
   {{0x6449b3f3,0x657d33f4,0x7c3bb3f5,0x69c433f6}},	//   rrei, _lash, rsur, _smie,
   {{0x7c22811e,0x6449aa1d,0xdb1ab3f7,0x68ed01b4}},	//   _etor, srei, entó, _ayad,
   {{0x2486804c,0x442f81e9,0x64498b2b,0x64468110}},	//   _from_, _twg_, prei, škia,
   {{0x3fc80077,0x7bc8b3f8,0x8c458b5b,0x2d8fad00}},	//   ندسی_, bidu, _селе, _inge_,
   {{0xf53980e1,0x657d01b4,0x7bc38234,0x25adb3f9}},	//   lať_, _aash, _umnu, lkel_,
   {{0x657d33fa,0x44220ac6,0x69c401b9,0x61e9b3fb}},	//   _bash, _stk_, _tmie, _okel,
   {{0x25adb3fc,0x657d33fd,0x69c41988,0xf53980e1}},	//   nkel_, _cash, _umie, nať_,
   {{0x657d33fe,0xb17b0106,0x68ed09ab,0x81cc8264}},	// [20e0] _dash, rlåt, _gyad, রকম_,
   {{0x5503176e,0xb3468073,0x9f5e0009,0x61e9b3ff}},	//   спуб, moçõ, ötä_, _akel,
   {{0x657d3400,0x25adb401,0xbea60912,0x3ea627a9}},	//   _fash, kkel_, _санк, _синг,
   {{0x61fbb402,0x657d3403,0x3ea508aa,0x2247016b}},	//   _chul, _gash, älte_, ánka_,
   {{0xe8948554,0xf539b404,0x44220867,0x261a000f}},	//   раль, dať_, _utk_, _मंडी_,
   {{0xafdb0022,0x2d8fb405,0x61e98135,0x9f430168}},	//   rsøg, _ange_, _ekel, vojë_,
   {{0x200c803a,0x657d3406,0x67388db7,0x61e6026c}},	//   _vidi_, _yash, ravj, kokl,
   {{0x9f5e8364,0x6d563407,0x7bc8809a,0xd49ab408}},	//   _sitä_, ngya, widu, еро_,
   {{0xa84a88ca,0x61e600eb,0x161602f1,0x2d803409}},	//   _سلام_, dokl, _दूसर_, idie_,
   {{0x9f4300f1,0x2912340a,0x99860084,0x2d8fb40b}},	//   rojë_, _agya_, kslų_, _enge_,
   {{0x7bc8b40c,0xdb1a8a48,0x68ed0359,0x9f430168}},	//   ridu, vitä, _syad, sojë_,
   {{0x2eb08bb8,0x2486b40d,0x2d800493,0x25adb40e}},	//   जनीत, _trom_, jdie_, ckel_,
   {{0x657d00a4,0x7bc8b40f,0x21393410,0x73c4a181}},	//   _rash, pidu, rash_, _پيغم,
   {{0x657d00a4,0x2a660035,0x14d781c6,0x29120c2e}},	//   _sash, łoby_, _גודל_, _egya_,
   {{0x657d3411,0x39448144,0xdb1ab412,0x8b6580d7}},	//   _pash, _odms_, ritä, _خانم,
   {{0x6d562acf,0x61e63413,0x657d3414,0xca4781a8}},	//   ggya, cokl, _qash, _إليه_,
   {{0x657d3415,0xdb1ab416,0xf53f3417,0xdce284e8}},	// [20f0] _vash, pitä, _slås_, _oboč,
   {{0x91fd0029,0x61fb822e,0xf53981ac,0x657d3418}},	//   stād, _shul, zať_, _wash,
   {{0x657d2b2a,0x3a7501e5,0x20d40bca,0x92590009}},	//   _tash, рлер, _نتیج, тает_,
   {{0x657d3419,0x6e250362,0x57dd8072,0x3e410048}},	//   _uash, _ithb, यव्ह, mėt_,
   {{0xf539b404,0x752d341a,0xd5b1827d,0xa3d48b99}},	//   vať_, mbaz, _lúc_, सचा_,
   {{0x44290d54,0x2259809a,0x61fb82f7,0x3f69b41b}},	//   mpa_, ński_, _whul, тико_,
   {{0xf53981ac,0x25ad8074,0xfd1180f7,0xf77403de}},	//   tať_, tkel_, يجة_, מקס_,
   {{0x1c4593b4,0x644d0090,0x4429341c,0xada58198}},	//   аним, orai, opa_, раил,
   {{0x4429028a,0x69cbb41d,0x644d061f,0xf53981ac}},	//   npa_, mige, nrai, rať_,
   {{0x69cb84e1,0xf53981ac,0x5ba9968a,0x4429341e}},	//   lige, sať_, тком_, ipa_,
   {{0x644d0a1c,0x27e7b41f,0xd6d18a47,0x25b08061}},	//   hrai, monn_, _بقا_, álló_,
   {{0x2d8f8bc5,0x69cbb420,0x44290133,0x660f3421}},	//   _unge_, nige, kpa_, _nick,
   {{0x6e2500f7,0x80c001d0,0xac278162,0x00000000}},	//   _athb, _लेखे, _сфек, --,
   {{0x644d1dad,0x7c2999ad,0xdcfb9487,0x443fb422}},	//   drai, mper, nduč, msu_,
   {{0xa91d8a56,0xe7370a94,0x09b5816f,0x63a38046}},	//   _každ, рес_, ंसाठ, _ionn,
   {{0x63a3b423,0x644d3424,0xf53f0082,0x248d3425}},	//   _honn, frai, _slår_, _šema_,
   {{0x63a3b426,0x443f8a73,0x2d8004df,0x644d3427}},	// [2100] _konn, nsu_, rdie_, grai,
   {{0x443f9572,0xdcfb8d2f,0xdb0183ba,0x63a3a1d8}},	//   isu_, jduč, rklæ, _jonn,
   {{0x69cbb428,0x673c16c4,0x973c8289,0x3dd7077f}},	//   fige, marj, _noća, úewé_,
   {{0x7c29b429,0x673c2cc7,0x63a381a8,0x88868db6}},	//   kper, larj, _lonn, илеж,
   {{0x6604043d,0x644d0cb5,0x261c002a,0x91fd00eb}},	//   mmik, crai, _hío_, ltāc,
   {{0x673c342a,0x7c29b42b,0x63a3b42c,0x6604342d}},	//   narj, dper, _nonn, lmik,
   {{0x69cbb42e,0x29568098,0x2eb080c2,0xafdb0aa2}},	//   bige, _възр, जनेत, prøv,
   {{0xd378803a,0x443fb42f,0x91e39a19,0x261c06a5}},	//   moći_, fsu_, _досе, _mío_,
   {{0x26168063,0x673c3430,0x63a3b431,0x261c0661}},	//   _पूरी_, karj, _bonn, _lío_,
   {{0x673c3432,0xeb06a10d,0x63a38213,0x798082a0}},	//   jarj, ично, _conn, _hamw,
   {{0x6d460a56,0x7980b433,0x673c3434,0x63a3b435}},	//   _odka, _kamw, darj, _donn,
   {{0x7c26003b,0x44293436,0x63a38b99,0x7982b437}},	//   _otkr, ypa_, _eonn, ndow,
   {{0x660f3438,0x63a3b439,0x84638081,0x98b20176}},	//   _rick, _fonn, _дъще, _feyč_,
   {{0x4426b43a,0x63a3b43b,0x644d03d3,0x6d460079}},	//   _ito_, _gonn, vrai, _adka,
   {{0x7c260612,0xc3fb8039,0x644083ba,0x7a138162}},	//   _atkr, _שלוש, lsmi, _bătu,
   {{0xa91d82a5,0x4426b43c,0x63a3b43d,0x644d343e}},	//   _kaže, _kto_, _zonn, trai,
   {{0x63a382ec,0x61ed17ea,0x69cbb43f,0x644d0fef}},	// [2110] _yonn, _ikal, vige, urai,
   {{0x644d3440,0x44293441,0x4426b442,0x69d880e7}},	//   rrai, rpa_, _mto_, éven,
   {{0x44293443,0x69cbb444,0x79809b19,0x386d8087}},	//   spa_, tige, _bamw, _sper_,
   {{0x4426b445,0x443fb446,0xf5950f99,0x6440b447}},	//   _oto_, ysu_, _الحج, ksmi,
   {{0x4426b448,0x702280c8,0xfd960039,0x61ed004f}},	//   _nto_, _নিউজ_, _הדרך_, _mkal,
   {{0x9f4780f1,0x6440b449,0x628ab44a,0xdb1e02f1}},	//   monë_, dsmi, _orfo, gipä,
   {{0x4426b44b,0x3f811083,0x6442b44c,0x28a7864a}},	//   _ato_, _mahu_, _avoi, _कॅरि,
   {{0x81bd0341,0x63a3b44d,0x7c2983ab,0x973c83b1}},	//   spēj, _sonn, tper, _voća,
   {{0x69c9b44e,0xb4f5313a,0x27e78247,0x63a3b44f}},	//   _imee, _आरोप_, ponn_, _ponn,
   {{0x443fb450,0x7c29b451,0xd7fb8364,0x61ed3452}},	//   rsu_, rper, _руб_, _akal,
   {{0x4426b453,0x443fb454,0x673c3455,0x63a389ff}},	//   _eto_, ssu_, varj, _vonn,
   {{0x261c02ba,0x443fb456,0x63a38c2e,0x3e619de9}},	//   _río_, psu_, _wonn, mót_,
   {{0x673c3457,0x628a8352,0x973c805c,0x3f810458}},	//   tarj, _erfo, _moćn, _bahu_,
   {{0x261c157a,0x63bab458,0x23268dcd,0xab26964f}},	//   _pío_, chtn, _лоши_, _лоша_,
   {{0x660426a6,0xdfcf00f7,0x673c054b,0x65b5816b}},	//   tmik, ريف_, rarj, _záha,
   {{0x973c803b,0x673c3459,0xd01f80ab,0xdb019b48}},	//   _noćn, sarj, নীয়_, rklä,
   {{0x6da3345a,0x6604345b,0x3f810115,0x44268144}},	// [2120] чита, rmik, _fahu_, _xto_,
   {{0xa3ca8aec,0x261c2848,0x69c9b45c,0x2a6e8144}},	//   रोप_, _tío_, _amee, _ypfb_,
   {{0xdb1a84c3,0x9f4c801c,0x8e8600f7,0x798082d6}},	//   titú, _đoàn_, _الجه, _pamw,
   {{0xe93a9ddd,0x8d560d0e,0xe9da8a26,0x6d460366}},	//   اسات_, _уточ, ыке_, _udka,
   {{0xa3e79130,0x7982b45d,0x6000345e,0x515b01c6}},	//   पवा_, rdow, römf, רכנו,
   {{0xc059835f,0xd9a5016f,0xdefa8009,0xbcfb0032}},	//   рії_, _ऑक्ट, лый_, _abéw,
   {{0x44268025,0x2d8200a4,0xa91db45f,0x65b59727}},	//   _sto_, _kake_, _saže, _sáha,
   {{0x6440a09b,0xa91d8110,0x25a03460,0xa3ca81a2}},	//   tsmi, _paže, njil_, रोन_,
   {{0x2d820051,0x77b0016d,0x5bb895a6,0x4426841c}},	//   _make_, _växj, илия_, _qto_,
   {{0xa91d805c,0x61ed0687,0xd37a8ae7,0xf8bf00e7}},	//   _važe, _skal, учи_, ncée_,
   {{0x77ab0085,0x9f8d01d0,0x25a0008e,0xc7b381c6}},	//   _müxt, uží_, kjil_, _צבע_,
   {{0xdb1c0125,0x2d820041,0xdb03b33e,0x64563461}},	//   _umræ, _nake_, _zonë, kuyi,
   {{0x4426b462,0xafdb0aa2,0x673a8009,0x5c068a4c}},	//   _uto_, drør, _ketj, _ляка,
   {{0x7bcf80e7,0x62348e8e,0x2d82026b,0x43948254}},	//   écut, _деку, _aake_, _факс,
   {{0x25a6b463,0x673a81a1,0x61ed3464,0x7bca9b8f}},	//   _kool_, _metj, _tkal, _imfu,
   {{0x673a82ce,0xa2b101bc,0x7bdc022b,0x61ed3465}},	//   _letj, _dọ́l, _ajru, _ukal,
   {{0x3f811a67,0x21f9003e,0x64a40003,0x2d8203c3}},	// [2130] _tahu_, lého_, паѓа, _dake_,
   {{0x261a009a,0x673a8fb0,0x69c98cfa,0x661a8326}},	//   _मूवी_, _netj, _smee, _outk,
   {{0x21f90775,0xdb03809f,0x02d90eca,0x1df90190}},	//   ného_, _conè, جواب_, _вены_,
   {{0xd378803b,0x25a68079,0x9f4c801c,0x64560c6a}},	//   moću_, _nool_, _đoán_, buyi,
   {{0x3dcdb466,0x973ca828,0x673a8aa2,0x21f9016b}},	//   view_, _voćn, _betj, hého_,
   {{0x21f90a56,0x7c2d2a70,0x2d82022e,0xb4b5047d}},	//   kého_, mpar, _zake_, जनी_,
   {{0x2d823467,0x201302a6,0x69cf3468,0x9989009a}},	//   _yake_, _mixi_, kice, _miał_,
   {{0x0c258790,0x69c9b469,0x94258049,0x25a681c6}},	//   омин, _umee, омие, _cool_,
   {{0x6f001931,0x7c2d346a,0x9f47b46b,0x57d58073}},	//   _kábí, npar, yonè_, _доаѓ,
   {{0x4a4599a4,0x3949346c,0x61ebb46d,0xd378842b}},	//   онов, _adas_, logl, koću_,
   {{0x395f88ae,0xe9da2748,0x63a7346e,0x69cf1ed3}},	//   _kcus_, ико_, _mojn, fice,
   {{0x61ebb46f,0x69cf2e4d,0x39490144,0x7a138162}},	//   nogl, gice, _cdas_, _bătr,
   {{0x09a78076,0x7a13802e,0x201301b4,0x64a58152}},	//   _खवैय, _cătr, _bixi_, _фала,
   {{0x2d823470,0x44079ccf,0x63a701c0,0xe7371c8b}},	//   _sake_, _учеб, _nojn, жер_,
   {{0x2d823471,0x442db472,0x7643b473,0x320682c4}},	//   _pake_, lpe_, nsny, ymoy_,
   {{0x28c50df4,0x6d5bb474,0x6000016d,0x6569b475}},	//   _लेकि, ngua, döme, nfeh,
   {{0x6b83b476,0x90c30364,0xfaf80029,0x442d8247}},	// [2140] _kang, _объе, _šī_, npe_,
   {{0x6b83828a,0xdb1c0082,0x442db477,0x7a0c8201}},	//   _jang, _områ, ipe_, _işti,
   {{0x6b83b478,0x6da6069b,0x79840041,0x2d820051}},	//   _mang, _дина, _kaiw, _take_,
   {{0xa96a81a1,0x442db479,0xdb03b47a,0x61ebb47b}},	//   рида_, kpe_, _coné, gogl,
   {{0x63a70042,0x7984020d,0x00da9a10,0xa3ca847d}},	//   _fojn, _maiw, جبات_, रोड_,
   {{0x6b83b47c,0x69cf347d,0x661a8198,0x25a681c7}},	//   _nang, zice, _putk, _sool_,
   {{0xd5ba95fe,0x179b0051,0xdb1a80f1,0x8f9b010f}},	//   иси_, ייסב, shtë, ייסי,
   {{0x6b8381d8,0x21f90ed7,0x7984347e,0x61eb8081}},	//   _aang, vého_, _naiw, cogl,
   {{0x64441e89,0x764380dd,0x442d82d5,0x69cf347f}},	//   nsii, asny, gpe_, vice,
   {{0x6b838886,0x70538077,0x661ab480,0x64443481}},	//   _cang, _آنلا, _tutk, isii,
   {{0x25a6b482,0x7414803d,0x442db483,0x798404b9}},	//   _tool_, _کوتا, ape_, _baiw,
   {{0x21f9003e,0x64441bda,0xd46a9c82,0x6b83b484}},	//   rého_, ksii, _виде_, _eang,
   {{0x6d40b485,0x3866b486,0xdd8f8c2a,0x6b83b487}},	//   mama, ntor_, _جون_, _fang,
   {{0x6d40b488,0x69cf3489,0xa91d8110,0xb4c892e0}},	//   lama, sice, _maža, ोपी_,
   {{0xa91d8390,0x69cf348a,0x2013348b,0xb5a70956}},	//   _laža, pice, _vixi_, орай,
   {{0x6d40b48c,0x6b83b48d,0x9f4780d7,0x63a701c0}},	//   nama, _zang, roné_, _sojn,
   {{0x6b83b48e,0xa91d803a,0xb4b50361,0x63a70069}},	// [2150] _yang, _naža, जने_, _pojn,
   {{0x7c2d348f,0x6d40b490,0x6b83b491,0xc2e900ab}},	//   rpar, hama, _xang, _কৃষি_,
   {{0x6d40b492,0x7a400013,0x250909a7,0x65aa05b9}},	//   kama, _rátá, _گردی_, _výhr,
   {{0xa3ca9a46,0xf67a0158,0x19598e11,0x1a9b80be}},	//   रोत_, _פארמ, сады_, ייבע,
   {{0x6d40b493,0x859a0039,0x61ebb494,0xf1b40039}},	//   dama, _השרו, rogl, וסף_,
   {{0xa91d96b5,0x3e4581a9,0xec3601c6,0xf8bf002a}},	//   _daža, tēt_, _מאשר_, lbés_,
   {{0x44393495,0x31359c79,0x628e025b,0x69cd14c7}},	//   _hws_, _невр, _grbo, _omae,
   {{0x6d40b496,0x753d0063,0x31790063,0x6602b497}},	//   gama, _jesz, jesz_, _chok,
   {{0x6b839a92,0x442db498,0x3866b499,0x6d5bb150}},	//   _pang, upe_, ctor_, rgua,
   {{0x69dd03d3,0x753d100b,0x6d5bb49a,0x75d38087}},	//   éren, _lesz, sgua, văzu,
   {{0x656f1385,0x656982af,0x4439349b,0xddc880eb}},	//   _obch, pfeh, _lws_, žoša,
   {{0x6d408faa,0x442d8dfc,0x6b83b49c,0x7bda8009}},	//   cama, ppe_, _wang, antu,
   {{0x6b83859e,0x4439146a,0x3f85b49d,0x442b349e}},	//   _tang, _nws_, _kalu_, _ntc_,
   {{0x6609b49f,0x61a88670,0x3f8591ee,0x79840300}},	//   lmek, _कक्ष, _jalu_, _waiw,
   {{0x753d0065,0x798434a0,0x443934a1,0xcf9280be}},	//   _besz, _taiw, _aws_, עטל_,
   {{0x3f85848f,0x3179009a,0xf1bf026f,0x741600f7}},	//   _lalu_, cesz_, chá_, كورا,
   {{0x39420006,0x75241e41,0xa5070c5c,0x25bf80ee}},	// [2160] maks_, rciz, зета_, ihul_,
   {{0x6d40b4a2,0x64440079,0xb90334a3,0x442034a4}},	//   zama, rsii, _язык, rqi_,
   {{0x442b34a5,0x753d0019,0xa91d80d2,0xdb1ab4a6}},	//   _etc_, _fesz, _saža, uhté,
   {{0x3866b4a7,0x628e042b,0x25bfaf9f,0x5886a1f6}},	//   ttor_, _vrbo, jhul_, зыка,
   {{0x6d40b4a8,0xd90d826a,0x3f85b4a9,0x442034aa}},	//   vama, لیف_, _balu_, qqi_,
   {{0x6d4bb4ab,0x3866b4ac,0x6602b4ad,0xa91d805c}},	//   _adga, rtor_, _shok, _važa,
   {{0x6d40b066,0x7bce34ae,0x7c2b80eb,0x59dc020e}},	//   tama, _imbu, _atgr, मचार,
   {{0x80cd81ab,0xbcfb34af,0x9adb0039,0x661e026c}},	//   _देवे, _ibér, _החלט, _mupk,
   {{0x6d40b4b0,0xa91d8024,0x661e00d2,0x6d4b01a8}},	//   rama, _kažn, _lupk, ógai,
   {{0x6d40b4b1,0xad9b001c,0x644fb4b2,0x3f859ffe}},	//   sama, _nhún, ácia, _galu_,
   {{0x21fc801b,0x7bce0359,0x21790190,0xdcfd01a9}},	//   ního_, _mmbu, ойны_, _masā,
   {{0xa91d8503,0x25bfb4b3,0x6d40b4b4,0x80ab00ab}},	//   _lažn, chul_, qama, _চেষ্,
   {{0x2ac282be,0x4420802e,0x26099094,0x3a20a329}},	//   _bébé_, _îi_, ागरी_, _čipu_,
   {{0xad9b0104,0xefc815da,0x03a3a49a,0xf09f07f1}},	//   _chún, пуск_, _пичо, rxà_,
   {{0x248200ee,0x394234b5,0xdb07010c,0x21fc928a}},	//   _askm_, baks_, _gojè, jího_,
   {{0x40ee082e,0x22f78039,0x44391670,0x9df90a4c}},	//   ọrọ_, _מזון_, _pws_, інат_,
   {{0x753d0065,0xf8bf0b2c,0xa91d8110,0xbcfb026b}},	// [2170] _vesz, rbés_, _bažn, _abér,
   {{0x6ad080ab,0x442b00ff,0x051d0264,0x44390bfd}},	//   _সুযো, _vtc_, তরের_, _vws_,
   {{0x753d0065,0xa91d81e2,0x22470061,0x69dd29d8}},	//   _tesz, _dažn, énk_, onse,
   {{0x7bce34b6,0x6aaa00f2,0x3f85b4b7,0x69dd34b8}},	//   _embu, äffa, _salu_, nnse,
   {{0xc5fb0670,0x3f858573,0x2d9934b9,0x656d3323}},	//   ्षीय_, _palu_, _inse_, mfah,
   {{0x1408016f,0xab8434ba,0xbcfb00f7,0xdfd181a8}},	//   वगृह_, _пуск, _gcéa, ضيع_,
   {{0x21fc801b,0x6609b4bb,0x63a3007b,0x3f8592a5}},	//   cího_, tmek, önnu, _valu_,
   {{0x2d8934bc,0x75fe8168,0x629a2bea,0x69dd01ed}},	//   ndae_, tëza, _štog, jnse,
   {{0x91fd0029,0x394d80d2,0x6609b4bd,0xfc058652}},	//   rtāl, _ides_, rmek, мпио,
   {{0x63aa8114,0x7655009a,0xe3b181a8,0xdb1ab4be}},	//   _cofn, krzy, ئرة_, ditó,
   {{0x91e634bf,0xf1c4801b,0x3942103d,0x29000019}},	//   доне, लोकन, taks_, _szia_,
   {{0x6d4b813c,0x44b5abfc,0xbcb58ada,0x7f4381b4}},	//   _udga, _обес, _обещ, lanq,
   {{0xe87c0459,0xa91d80d2,0xa3ca83dd,0x21fc81d0}},	//   _düşü, _lažo, रोह_, zího_,
   {{0x2d9934c0,0x39420006,0x3fcc00ab,0x63aa8428}},	//   _anse_, saks_, লক্ষ, _gofn,
   {{0x394d82a5,0xa91d8da8,0xdb03826f,0x248d83cd}},	//   _odes_, _ražn, _koní, lvem_,
   {{0xbcfb00f7,0x394d89c4,0x68f6062c,0x70ef0133}},	//   _scéa, _ndes_, _tyyd, ụrụi,
   {{0xd4670f13,0xa91d8025,0xdcfd0029,0x64468289}},	// [2180] мите_, _pažn, _pasā, škiv,
   {{0x973cb4c1,0x6b8701a1,0x2d9934c2,0x394d8580}},	//   _voćk, _cajg, _ense_, _ades_,
   {{0xa91d803a,0x38cb0077,0xa3af0665,0x213fa14a}},	//   _važn, _هایی_, _ओकर_, _beuh_,
   {{0x2005b4c3,0xbbaa946d,0xe8fab4c4,0x765c00b4}},	//   _ahli_, _चक्क, оле_, mury,
   {{0x39402763,0x7bc1859c,0x6b8734c5,0x394d9670}},	//   _meis_, khlu, _fajg, _ddes_,
   {{0x39401e59,0x6d4434c6,0x394d8009,0xc5f8b4c7}},	//   _leis_, laia, _edes_, ुष्य_,
   {{0xd90d8065,0x5a550098,0x9e06a1ae,0xdb038980}},	//   لیہ_, _пъту, мчил, _boní,
   {{0x77b4809f,0xdb038473,0x6d4433bc,0x973c8bcf}},	//   _màxi, _coní, naia, _moći,
   {{0x628382c4,0xa06ab4bf,0xf1bd8035,0xdb03846d}},	//   _asno, _фаза_, ्फरन, _doní,
   {{0x765c023b,0x0a6a9a02,0x7bc1b4c8,0x6d44011b}},	//   kury, орми_, ghlu, haia,
   {{0x6d440867,0x973c80d2,0x6fb380d7,0x452a8162}},	//   kaia, _noći, _جملا, _джен_,
   {{0x85068872,0x225185b9,0x24800748,0x69c2b4c9}},	//   _قوان, ázka_, kwim_, nhoe,
   {{0x69dd34ca,0x394000f7,0xc8642503,0x6d4434cb}},	//   rnse, _deis_, ктри, daia,
   {{0x7655009a,0x7bc1b4cc,0x6004823e,0xdb1ab4cd}},	//   trzy, chlu, lòmb, ritó,
   {{0xc1ee80d4,0x05b280d4,0x6d4403cd,0x3940212b}},	//   जवाब_, _जवाब, faia, _feis_,
   {{0xa91d8029,0x6d4434ce,0x973c81a1,0x69d60061}},	//   _ražo, gaia, _doći, ézet,
   {{0x656d34cf,0xe9df00e1,0x261683db,0xa4c0099b}},	// [2190] rfah, mnú_, _पूछी_, rüşü_,
   {{0x2d89067f,0x765c00b4,0xe9df00e1,0x09d78072}},	//   sdae_, bury, lnú_, ढच्य,
   {{0x77b0016d,0x33f40106,0x6d4434d0,0x248d81d0}},	//   _växt, växt_, baia, zvem_,
   {{0xd5a68591,0xe9df34d1,0x9f47823e,0x397c03de}},	//   _صف_, nnú_, roní_, ַטונ,
   {{0xe7eb8076,0xe3b88214,0x394d8168,0x660d21d8}},	//   टवला_, kkı_, _vdes_, mmak,
   {{0x660d34d2,0xe9df00f7,0x01c98019,0x65bcb4d3}},	//   lmak, hnú_, _کورٹ_, _réha,
   {{0xfe7189d7,0x7f43818a,0x7bc18282,0xd34600d7}},	//   ادت_, ranq, vhlu, _سینه_,
   {{0x660d34d4,0x2247027f,0x394db4d5,0x91fd00eb}},	//   nmak, ánku_, _udes_, stāj,
   {{0xe9df01ac,0xa924826f,0x6000016d,0x799b8300}},	//   dnú_, _úžas, dömn, _inuw,
   {{0xf77095e4,0x39401313,0xb605816b,0xa3caa0e9}},	//   _نام_, _seis_, dnáš, रोल_,
   {{0xeb920158,0xa3b70665,0xe299b4d6,0xd5bc046d}},	//   אָר_, _जवन_, чан_, _bọ́_,
   {{0x3ce08025,0xdb070125,0x29d200d2,0x1df9064a}},	//   _žive_, _hljó, ršao_, ंतोष_,
   {{0xbcfb1db6,0x777c002a,0x6e2180b9,0x6d4402df}},	//   _scén, terx, _hulb, vaia,
   {{0x6d44010b,0x7529b4d7,0x29d2026c,0xb4cb83b7}},	//   waia, lcez, pšao_, रछी_,
   {{0x670f800c,0xa91d8024,0x6449b4d8,0x394034d9}},	//   ाधिक_, _pažl, lsei, _teis_,
   {{0x660d34da,0x973c80c3,0x6e21a7d1,0x386902a6}},	//   gmak, _voći, _mulb, _fqar_,
   {{0x6449b4db,0x6d4434dc,0x6b5600f7,0x765c34dd}},	// [21a0] nsei, raia, فضائ, sury,
   {{0x7c2b2509,0x6d441c91,0x26cc0548,0x64498a2a}},	//   ígra, saia, údos_, isei,
   {{0xc0a90077,0x6d44208b,0x69c2b4de,0x443db41f}},	//   _فایل_, paia, thoe, _lww_,
   {{0x64a61652,0x5066a17e,0xdca6067c,0xe046867c}},	//   _зама, етка, _зами, енди,
   {{0x69c286a8,0x248000ee,0x2ac60032,0x201a2aa0}},	//   rhoe, qwim_, _bíbé_, _kipi_,
   {{0x61e410d3,0x6449b4df,0xc7a382d3,0x69c29de6}},	//   _ljil, dsei, личк, shoe,
   {{0x539b0051,0x442234e0,0xa3dd02f1,0x644b868f}},	//   _צילו, _huk_, तचर_, _avgi,
   {{0x38cb80d5,0x9f4a03fb,0x75fe80f1,0xa91d807a}},	//   _کافی_, dobí_, rëzo, _lažj,
   {{0x69c0b4e1,0x44220110,0x91fd00eb,0x63ae012b}},	//   _ilme, _juk_, stāk, _kobn,
   {{0xa3ca8d38,0x61e4022e,0x442f89ca,0x7ac6a155}},	//   रों_, _ajil, _dtg_, есме,
   {{0x19590a14,0xe3b883bf,0x2ec69c12,0xe9df00e1}},	//   маны_, rkı_, _ثقاف, tnú_,
   {{0x644982af,0x394695d7,0xcc88801c,0x3ce6822c}},	//   bsei, naos_, _tớ_, _txov_,
   {{0x44220b18,0x61e434e2,0xe9df00e1,0x201a00c3}},	//   _nuk_, _djil, rnú_, _bipi_,
   {{0xc5fb05e8,0x6d4f0683,0x6446807a,0x8c1b81c6}},	//   ्ष्य_, _sdca, škis, _זוגי,
   {{0x69c0b4e3,0x442234e4,0x660d34e5,0xd5bb2318}},	//   _olme, _auk_, tmak, пса_,
   {{0x7c228009,0x61e40168,0x3946b4e6,0x6b8ab4e7}},	//   _kuor, _gjil, jaos_, _hafg,
   {{0x660d34e8,0x442219d5,0x6ad900c2,0x3946b4e9}},	// [21b0] rmak, _cuk_, भप्र, daos_,
   {{0x69c0b4ea,0x442203c3,0x7c228081,0xdb150118}},	//   _alme, _duk_, _muor, _alzá,
   {{0xdb03816b,0xdb188216,0x660d34eb,0x29048c53}},	//   _koná, _olví, pmak, _azma_,
   {{0xa2d5053e,0x3e4c800d,0x28d2908a,0x2486826c}},	//   _येण्, dět_, _देहि, _osom_,
   {{0x7c2293cd,0xf8b334ec,0xdb03802a,0x7f4180f1}},	//   _nuor, ुनिय, _moná, _pelq,
   {{0x2d8b0a49,0x9a8734ed,0x69c08a09,0xa91d8110}},	//   _hace_, _публ, _elme, _kažk,
   {{0x973c817f,0x44220102,0x2d8b34ee,0x60000338}},	//   _noću, _zuk_, _kace_, döml,
   {{0x25a934ef,0x2d8b02a5,0x442f9083,0x6449b4f0}},	//   njal_, _jace_, _ptg_, tsei,
   {{0x7c228098,0x1c428084,0x2d8b04b9,0x6d42802e}},	//   _cuor, аным, _mace_, _deoa,
   {{0x61f634f1,0x6449b4f2,0x8b958878,0x6295026c}},	//   _skyl, rsei, трич, _krzo,
   {{0x13098009,0xa2e581e5,0x320902c4,0x920d0035}},	//   ьной_, тонд, _bhay_, सगंज_,
   {{0x7c228098,0x442fb4f3,0x62950b80,0x201a076d}},	//   _fuor, _ttg_, _mrzo, _sipi_,
   {{0x9f4a026f,0x6446929b,0xef1880eb,0x2d9d8870}},	//   sobí_, škir, _daļu_, _inwe_,
   {{0x4422067f,0x2b4302d4,0x61fd0299,0x00000000}},	//   _ruk_, _nejc_, alsl, --,
   {{0xf74314d6,0x442234f4,0x201a34f5,0x2d8b0041}},	//   ресо, _suk_, _vipi_, _bace_,
   {{0xc692810f,0x2d8b026c,0x63ae34f6,0xdb070216}},	//   סאן_, _cace_, _sobn, _cojí,
   {{0x201a34f7,0x2d8b00a4,0xab661505,0x62950333}},	// [21c0] _tipi_, _dace_, квал, _arzo,
   {{0x291f9fd1,0x44220024,0x2d8b008e,0x35c60035}},	//   _agua_, _vuk_, _eace_, रोज़,
   {{0x68fb9220,0xcf570051,0x0f570158,0x2d8b34f8}},	//   _ayud, _בבית_, _ביים_, _face_,
   {{0xa7fb01df,0x25a907d8,0x2d8b0314,0x2c6b8366}},	//   ruñe, cjal_, _gace_, kød_,
   {{0xf993010f,0x64430a20,0x2d80002e,0x3946b4f9}},	//   ירא_, ćnic, meie_, raos_,
   {{0x60048247,0x6d4283a8,0x2d8b34fa,0x2d80004a}},	//   fòma, _seoa, _zace_, leie_,
   {{0x7c228364,0xfaa334fb,0x2d8b00a4,0xc7b888ae}},	//   _suor, _каро, _yace_, _niđe_,
   {{0xa2c590a1,0x656434fc,0x5e5700be,0x2d8b0118}},	//   ानन्, ngih, דיקע_, _xace_,
   {{0x68fbb15d,0x2904b4fd,0x6d4286ae,0x7dde8ec3}},	//   _gyud, _uzma_, _veoa, nīsi,
   {{0x7c228009,0x212000b9,0x2d9d8870,0x32090df6}},	//   _vuor, _agih_, _enwe_, _shay_,
   {{0x2d8001b0,0xdea3804e,0xd7ef80f7,0xa5b300c2}},	//   keie_, _نیوی, _بكل_, _इकलौ,
   {{0x61e2b4fe,0x7c228009,0xb6d980be,0x24868069}},	//   nnol, _tuor, _אַנט, _tsom_,
   {{0x7c2d8457,0x2d8b34ff,0x3f8cb500,0x61fd29c6}},	//   _çarp, _race_, _kadu_, rlsl,
   {{0xb8cb243f,0x2d8b0041,0x7dde81a9,0x6b8a8366}},	//   _गप_, _sace_, dīsi, _uafg,
   {{0x8c1b810f,0x32090028,0x3f8c8b20,0x2d8b3501}},	//   _קווי, _thay_, _madu_, _pace_,
   {{0x69c60352,0xdb1ab502,0xf1b98668,0x320902d5}},	//   chke, chtá, _kiše_, _uhay_,
   {{0x33750021,0x25a93503,0xa5f82466,0x61e2b504}},	// [21d0] лгар, rjal_, тету_, dnol,
   {{0x1ae700ab,0xe1ff3505,0x248d026c,0x2d8b0041}},	//   _করবে_, lló_, _šems_, _wace_,
   {{0x2d8b04b9,0x798d3506,0x68fb9400,0x2d8db507}},	//   _tace_, _kaaw, _syud, ydee_,
   {{0x61e2b508,0xe1ff0019,0x3f9e8041,0xfb1580be}},	//   gnol, nló_, _antu_, אַנט_,
   {{0x80cd8063,0x040d801c,0x518481e5,0x3f8c8102}},	//   _देखे, _cườn, руха, _badu_,
   {{0xa91d8110,0x69d885db,0xa5bb0825,0x040d80ff}},	//   _maži, éver, _bióg, _dườn,
   {{0xf770a6f1,0xf1b98267,0x442932aa,0x661d3509}},	//   تان_, _aiše_, lqa_, _kisk,
   {{0x661d350a,0x644d350b,0x752d350c,0x3ea98d26}},	//   _jisk, osai, ncaz, ćat_,
   {{0xa3b70076,0x7afc00f1,0xad9b00f7,0x644d350d}},	//   _जवा_, _zyrt, _chúi, nsai,
   {{0x3f8cb50e,0x09dc035a,0x69d9b50f,0x2c6b8edd}},	//   _gadu_, मच्य, liwe, rød_,
   {{0xd9460dd3,0xd57589c7,0x61461597,0xa96a1677}},	//   лени, _буль, лена, нина_,
   {{0x7c958591,0x798d0079,0x644d3510,0xaca38133}},	//   _مشتا, _caaw, ksai, _alụk,
   {{0xeb8eb511,0x753ba742,0x798d3512,0x3f8cb513}},	//   _ли_, mbuz, _daaw, _yadu_,
   {{0x69c600f1,0xe80403b7,0xe1ff0216,0x661d2f52}},	//   shke, _शीशा_, aló_, _aisk,
   {{0x6b8184cc,0xe1ff3514,0x661d3515,0x3ebe007b}},	//   melg, bló_, _bisk, átt_,
   {{0x61e28085,0x8886148d,0x69d9804f,0x3f8c258f}},	//   xnol, _ближ, jiwe, ždu_,
   {{0xb0d2809a,0x645bb516,0x69c43517,0x7c29b518}},	// [21e0] _देंग, nrui, _ilie, nqer,
   {{0xb6a60cec,0x3ea6045e,0xdb0380e7,0x69c43519}},	//   _биол, _биог, _conç, _hlie,
   {{0x661d155f,0x644d10eb,0x50d6803d,0x7c36351a}},	//   _fisk, asai, گزار, spyr,
   {{0x3f8ca1dc,0x91fd0029,0x249f0024,0xa91d8f20}},	//   _sadu_, stāv, _šume_, _zaži,
   {{0x7bc38006,0x644d351b,0x69c401ac,0x6d4601a9}},	//   _olnu, csai, _mlie, _ieka,
   {{0x91fd0029,0x61e2a1a2,0x6d46351c,0x661d016b}},	//   ltāt, snol, _heka, _zisk,
   {{0x6d4634c3,0x26058076,0x69c4351d,0xf1c1026f}},	//   _keka, _हीही_, _olie, ášky_,
   {{0x5454b51e,0x645bb51f,0x2627826c,0x040d801c}},	//   авит, frui, _gđom_, _tườn,
   {{0xa2d9a38c,0x973c8088,0x7bc68612,0x6b81b520}},	//   _फेब्, _anće, ūkum, felg,
   {{0xf1b9803a,0x1ae70a49,0x6d46127a,0xef918077}},	//   _više_, _করতে_, _leka, _ویند,
   {{0x69c43521,0xb3458187,0x798d02d5,0xd3778048}},	//   _blie, _seçã, _paaw, учы_,
   {{0x6d463522,0x645b933a,0x8c46954f,0x0446af4b}},	//   _neka, brui, _беде, _бедн,
   {{0x645bb523,0x201eb524,0xa91d8110,0x107403c7}},	//   crui, _kiti_, _paži, бляю,
   {{0xa3e88b3b,0x69c43525,0x92948ff7,0x69d9b526}},	//   _यदि_, _elie, _вакц, ziwe,
   {{0x6d463527,0x4426822e,0xdd9b3528,0x7bda8364}},	//   _beka, _huo_, нша_, mitu,
   {{0x6d463529,0x44268110,0x7c26352a,0x69c4352b}},	//   _ceka, _kuo_, _bukr, _glie,
   {{0x661d28d1,0x2455003d,0x6298b52c,0x24580009}},	// [21f0] _visk, شناس, _hrvo, лать_,
   {{0x644d352d,0x442901b9,0x661d352e,0xf1bf01d0}},	//   rsai, rqa_, _wisk, lká_,
   {{0x644d352f,0x661d3530,0x6d463531,0x44293532}},	//   ssai, _tisk, _feka, sqa_,
   {{0x19598196,0x7bda8744,0xf1bf3533,0x3ebe0bc5}},	//   тады_, hitu, nká_, øtte_,
   {{0x201e8052,0x44268a8e,0xa0a58adb,0x7bdab534}},	//   _biti_, _nuo_, ралд, kitu,
   {{0x6d463535,0x65b5803e,0x201eb536,0x62988019}},	//   _zeka, _náhr, _citi_, _orvo,
   {{0x74d904c5,0xda05016f,0x8c0a80ab,0x6d46071f}},	//   _नेतृ, रतात_, রদান_, _yeka,
   {{0x4426b537,0xf2d204de,0x201e8084,0x225c01d6}},	//   _buo_, _ועל_, _eiti_, ávke_,
   {{0x62988364,0x44268052,0xe1348012,0x05a68009}},	//   _arvo, _cuo_, _ынты, рвый_,
   {{0xf77388ca,0x69c43538,0x7bdab539,0x6721805c}},	//   _دار_, _slie, gitu, _uglj,
   {{0x69c4353a,0x62988699,0x61e9835f,0x2909019d}},	//   _plie, _crvo, _kjel, _azaa_,
   {{0x629882a5,0x645bb53b,0x6b81b53c,0x2258b53d}},	//   _drvo, prui, selg, árka_,
   {{0x6d460025,0x69c40b3c,0x628aabe1,0x629880f3}},	//   _reka, _vlie, _esfo, _ervo,
   {{0x6d460812,0x7bdab53e,0x91fd00eb,0x7bc8b53f}},	//   _seka, citu, tuāc, chdu,
   {{0x61fbb540,0x69c401b9,0x7c263541,0x2d8fb542}},	//   _okul, _tlie, _sukr, _kage_,
   {{0xf1bf0a56,0x65b581ac,0xceb28039,0x61e9b543}},	//   cká_, _záhr, חיל_, _njel,
   {{0x9f5e8009,0x6fc5816f,0xd7c58072,0xa91d80c3}},	// [2200] _yhtä_, वसां, वसाच, _kažu,
   {{0x2d8fb544,0x61fbb545,0x75fe80f1,0x91fd01a9}},	//   _lage_, _akul, rëzi, grāf,
   {{0x6d460886,0x61e98654,0xbea614bc,0xa9268db4}},	//   _teka, _bjel, _танк, адел,
   {{0x201eb546,0x61e9920e,0x25adb547,0xc05a8d13}},	//   _siti_, _cjel, jjel_, вік_,
   {{0x61e9830b,0x201eb548,0x25a20456,0xd378807d}},	//   _djel, _piti_, _inkl_, liće_,
   {{0x91fd0341,0xd90d80d5,0x7c2480f7,0x44268870}},	//   ntār, ریل_, _éiri, _ruo_,
   {{0x44268698,0x4b7b0bea,0x7bdab549,0x64428063}},	//   _suo_, _שאלו, vitu, _swoi,
   {{0x2d920205,0x61e9945c,0xbcfb00f7,0x4426b54a}},	//   ndye_, _gjel, _scéi, _puo_,
   {{0x2d8fb54b,0x201eb54c,0xbc6780f7,0x7bdaa4cf}},	//   _dage_, _titi_, لمين_, titu,
   {{0x62988b5d,0x90e5803d,0xc5e3354d,0x201e8162}},	//   _prvo, _اسفن, _गद्य_, _uiti_,
   {{0xe7e38076,0xbeaa8077,0xf1b98353,0x2d8f8041}},	//   कचरा_, _جهان_, _hiša_, _fage_,
   {{0x4426b4ba,0x7bdab54e,0x28db946d,0x6da39541}},	//   _tuo_, situ, _मेडि, _миха,
   {{0x6e28827f,0xe3af819f,0xdb0e0214,0x75d381a8}},	//   _hudb, سری_, _albü, _بينا,
   {{0xf1bf003e,0x2d84b54f,0xf1b98390,0x248b008e}},	//   ská_, leme_, _miša_, _rscm_,
   {{0x394b3550,0x69dd0bfe,0x7bd89d61,0xadc38091}},	//   pacs_, éres, _imvu, _atẹl,
   {{0xdcfb83bf,0xf99f1b01,0x2d84b551,0xfa3395a9}},	//   nduğ, rmès_, neme_, _برود,
   {{0x69dd138e,0xf1b985a2,0x6e2889d1,0x600d8020}},	// [2210] mise, _niša_, _ludb, lúme,
   {{0x61fbb552,0x3dc90069,0x60c00bc5,0x69dd138e}},	//   _skul, shaw_, ømme, lise,
   {{0x2003003b,0xe6950013,0x6e950013,0xf1b988ae}},	//   mlji_, _الجد, _الجا, _aiša_,
   {{0x69dd3553,0x6286809a,0xa5bb0333,0xdb0e0216}},	//   nise, łkow, _dióc, _albó,
   {{0x2d8f84b9,0x2d84803e,0x9f51001b,0x260a9993}},	//   _rage_, deme_, hozí_, ातनी_,
   {{0x69dd3554,0x39490c5e,0x7dde80eb,0x490a0fb2}},	//   hise, _leas_, zīst, _सरसो_,
   {{0x2d8fb555,0x320d804c,0x69dd3556,0x7c2d3557}},	//   _page_, _they_, kise, lqar,
   {{0x59f98009,0x61fb805d,0x3940807b,0xc7b8811f}},	//   _себя_, _ukul, ðist_, _viđa_,
   {{0x7bc704c4,0x69dd0006,0x26c181ac,0x63b50bcf}},	//   _klju, dise, šho_, _kozn,
   {{0x6e28835d,0x39490118,0x25bfb4b1,0x3a2002f7}},	//   _fudb, _aeas_, skul_, _siip_,
   {{0x2d8fb558,0x69dd3559,0x7dde8029,0x63b5355a}},	//   _tage_, fise, tīst, _mozn,
   {{0x63b50904,0xd3788253,0x69dd355b,0x2d849e1c}},	//   _lozn, viće_, gise, ceme_,
   {{0x27f8355c,0x39490083,0x7bc7355d,0xec3580be}},	//   torn_, _deas_, _olju, _פאַר_,
   {{0x7c3bb55e,0xd3788289,0x69dd355f,0xdc3680be}},	//   mpur, tiće_, aise, _האסט_,
   {{0xed5a0758,0xada61b10,0x6da61630,0x75fe8168}},	//   лов_, бавл, бива, rëzv,
   {{0x249f01dd,0x6569b560,0xd3788289,0xe3bf03a8}},	//   _šuma_, ngeh, riće_, _buño_,
   {{0x61f9809a,0xdca31ac9,0xd3788904,0x7bc700ce}},	// [2220] dowl, пати, siće_, _blju,
   {{0x7bc1b561,0x65bc82be,0xd3788289,0x7f8600f7}},	//   nklu, _véhi, piće_, _الدن,
   {{0x63b53562,0xdceb80eb,0xdb0e06c4,0xce9581a9}},	//   _dozn, _angļ, _albò, šējā_,
   {{0x629a2a3e,0x27e981a8,0xdb1c0106,0x9f580168}},	//   _átom, éann_, _omrö, korë_,
   {{0x6e288025,0x28d2824c,0xdb0a8118,0x66043563}},	//   _sudb, _देखि, _mofá, mlik,
   {{0x824a2f0a,0x66043564,0xdfd080f7,0x79863312}},	//   _مشرف_, llik, بيت_, hekw,
   {{0x7bde3565,0x69dd29f7,0x8f9b0039,0xddcb826c}},	//   mipu, yise, טיסי, _šiši,
   {{0x7bde0886,0x63b50038,0x66043566,0x69cba7f9}},	//   lipu, _zozn, nlik, chge,
   {{0xe3bf07f4,0xdcfb83bf,0x6604067f,0x69dd3567}},	//   _xuño_, rduğ, ilik, vise,
   {{0x7bde03f8,0x325485c2,0xdee68992,0x7bc1a168}},	//   nipu, овор, _лози, gklu,
   {{0x69dd3568,0x66043569,0xd5af9b4b,0x93fb00be}},	//   tise, klik, _ес_, רליי,
   {{0x645d82ba,0x7bde003d,0xba9b03c8,0x69c2b56a}},	//   ásic, hipu, אסטי, nkoe,
   {{0x7bde356b,0x6604356c,0x39490511,0x600d8020}},	//   kipu, dlik, _veas_, súme,
   {{0x69dd356d,0x7bc182af,0xcc57810f,0x629c356e}},	//   sise, cklu, _פסוק_, _orro,
   {{0x98a51010,0x7bde356f,0x91fd00eb,0x7bdb8039}},	//   ğlı_, dipu, trād, _תקוו,
   {{0x98a50182,0x66043570,0x1ae700ab,0x7d02838a}},	//   şlı_, glik, _করলে_, _kyos,
   {{0x2003005c,0x545500e8,0xe9df01a8,0x93270061}},	// [2230] plji_, юват, miú_, مران,
   {{0x7bde1b6b,0x61ed23ea,0xad9b00f7,0xe9df01a8}},	//   gipu, _hjal, _chúr, liú_,
   {{0x63b5135a,0x387fb571,0xc33381c6,0x7bc702d4}},	//   _vozn, _spur_, פוף_, _vlju,
   {{0xdb038038,0xe9df00f7,0x3949a511,0x6e22b572}},	//   _ponú, niú_, úas_, _niob,
   {{0x628e3573,0x7c2d0609,0x629c3574,0x27e985e4}},	//   _esbo, qqar, _erro, éano_,
   {{0x44393575,0x7bc70042,0x9848a1f6,0xad9b0f35}},	//   _its_, _ulju, сяца_, _thús,
   {{0x798620c4,0x61ed3576,0x6569b577,0x3ffc03de}},	//   yekw, _ojal, tgeh, אפגע,
   {{0x44230586,0xe4598af2,0xf8bf3043,0x7d0282a0}},	//   _hij_, ажи_, ncés_, _byos,
   {{0xdb1a80f7,0xa3b00540,0x6e22b578,0x6569b579}},	//   chtú, टॉक_, _diob, rgeh,
   {{0x7986357a,0xa3d3800f,0x61ed357b,0x4423357c}},	//   wekw, सों_, _ajal, _jij_,
   {{0xf77095e4,0x44230613,0x7986357d,0x656f0098}},	//   _سال_, _mij_, tekw, _occh,
   {{0x7c3bb57e,0x44230069,0x6e22b57f,0x644301dd}},	//   ppur, _lij_, _giob, ćnij,
   {{0x61ed3580,0x79862f0b,0x44393581,0x69c9826c}},	//   _djal, rekw, _nts_, _mlee,
   {{0x4423022c,0xee3a2606,0xd9b697a3,0xaa45a28e}},	//   _nij_, инг_, _अक्ट, _декл,
   {{0x61ed3582,0x69c9b583,0x6d4b8590,0x66043584}},	//   _fjal, _olee, _kega, tlik,
   {{0x61ed3585,0x806611c7,0x2251803e,0xe5a30fe7}},	//   _gjal, _движ, ázku_, миси,
   {{0x44231dbe,0x66043586,0x7bde1d29,0xd3788024}},	// [2240] _bij_, rlik, tipu, lića_,
   {{0x66043587,0x3f879351,0x6d4bb588,0x69c9b589}},	//   slik, jenu_, _lega, _alee,
   {{0x6604358a,0x7bde358b,0x3f87b58c,0x44390722}},	//   plik, ripu, denu_, _ets_,
   {{0x7bde358d,0x64a608d5,0x0906802e,0xf6530039}},	//   sipu, _дама, опен, _קצר_,
   {{0x4423358e,0x6e22816a,0xd378b58f,0x69c2800b}},	//   _fij_, _riob, hića_, rkoe,
   {{0x69c995ba,0xd3788289,0xc05980e8,0xa09b03c8}},	//   _elee, kića_, сії_, יינט,
   {{0x600487e2,0xeb910158,0xd37881dd,0x628e020d}},	//   nòmi, _אָן_, jića_, _usbo,
   {{0x44230613,0xd378803b,0x6d4b90e1,0x5d5480b3}},	//   _zij_, dića_, _cega, чкит,
   {{0x6d4bb590,0x4423022c,0x7c238091,0x6d598365}},	//   _dega, _yij_, _binr, _ddwa,
   {{0x6d59b591,0x3f87825b,0xd378812b,0x61ed070b}},	//   _edwa, cenu_, fića_, _sjal,
   {{0x6d4b9e72,0xc33302f6,0xd3788042,0x69c98009}},	//   _fega, וות_, gića_, _ylee,
   {{0x7c23a32a,0x6e22826c,0x78a201a9,0xfec20264}},	//   _einr, _uiob, _šova, োপাধ,
   {{0xa5078ae7,0xe9df0013,0x6443005c,0xc95384de}},	//   _деца_, riú_, ćnik, ומר_,
   {{0xd7fb138c,0x29050029,0xd378812b,0xe9df00f7}},	//   рум_, āla_, bića_, siú_,
   {{0xcddb19e3,0x442300f3,0x7c2b8398,0xa3ae1199}},	//   ања_, _rij_, _zugr, कान_,
   {{0x442301c5,0x442b0722,0x7bdc2bb7,0x7dce8229}},	//   _sij_, _puc_, _amru, _dùsg,
   {{0x44230282,0x61fd0a96,0x92e700c8,0x7e6701c0}},	// [2250] _pij_, mosl, _পরে_, sujp,
   {{0x44233592,0x69c9b593,0x7a330609,0x9f430216}},	//   _qij_, _slee, _aħta, rojó_,
   {{0x69c9b594,0x4423290e,0x8ae7035f,0x443902f7}},	//   _plee, _vij_, ціал, _wts_,
   {{0x44230613,0x61fd3595,0xbcfb00e1,0x442b00ff}},	//   _wij_, nosl, _dcér, _tuc_,
   {{0x44233596,0x8fa58d13,0x4439008e,0x69c983b2}},	//   _tij_, зале, _uts_, _vlee,
   {{0x6d4b885c,0x2904831d,0x94ba0039,0x9f4780e7}},	//   _sega, _dyma_, _המשת, onné_,
   {{0x3f878289,0x9258038d,0x6d4ba5c8,0xed59b597}},	//   renu_, _март_, _pega, бой_,
   {{0xd378803b,0x656d3598,0xd90e8065,0x21290748}},	//   vića_, ngah, ئیے_, _ngah_,
   {{0x6d4bb599,0x205481a0,0x478b8009,0x3f87929b}},	//   _vega, _октя, _всем_, penu_,
   {{0xd3788067,0x63b881c0,0x6d4bb59a,0xf1b9826c}},	//   tića_, _covn, _wega, _hoš_,
   {{0x88bd80ab,0x7bc500dd,0x9f4e03c1,0x6b950612}},	//   _অধিক, ikhu, áním_, _mazg,
   {{0xf1b9803a,0x22470ed7,0xd3788024,0x20010359}},	//   _još_, ánky_, rića_, _akhi_,
   {{0xa3dc05b3,0x64a599b5,0x394daa3c,0xd378812b}},	//   तोड_, _хала, _mees_, sića_,
   {{0x394db59b,0x443f8812,0x4375893f,0xf1b9805c}},	//   _lees_, mpu_, _זײַן_, _loš_,
   {{0x443fb59c,0x6012007b,0x61fd176d,0xc33283de}},	//   lpu_, væmd, bosl, _אוו_,
   {{0xc8bd89a3,0x25a6040e,0x394d8282,0x69cf026f}},	//   ्नाट, ñol_, _nees_, chce,
   {{0x6b950115,0x2ea883e8,0x443f8176,0xdd8f0b8c}},	// [2260] _bazg, _कप्त, npu_, دوق_,
   {{0xdb0383d3,0x389b010f,0x60001cab,0x3a24b59d}},	//   _anné, _פיינ, röms, _simp_,
   {{0xf1b98353,0xd36f0154,0x394d9af4,0xc7b8811f}},	//   _boš_, اهم_, _bees_, _rođ_,
   {{0x2d89359e,0xa96a8f27,0x69c615c8,0x3f8a359f}},	//   ceae_, сида_, nkke, lebu_,
   {{0x6d441cdc,0x394db5a0,0x68438329,0xbcfb026b}},	//   mbia, _dees_, енча, _adéf,
   {{0x6d440110,0x3f9835a1,0x6e2602d5,0x64560034}},	//   lbia, ndru_, _hikb, msyi,
   {{0x3a248012,0x63b8803e,0x09cc035a,0xd946a09a}},	//   _timp_, _rovn, ासाठ, _неви,
   {{0x394db5a2,0x6fcb01cc,0x3a24816a,0x3f8a35a3}},	//   _gees_, _müca, _uimp_, hebu_,
   {{0x69dd02be,0x645635a4,0x443f82d5,0x48ce0264}},	//   èrem, nsyi, gpu_, রপুর,
   {{0x5a348572,0x6f668073,0x799605ee,0x61e2b5a5}},	//   мнот, _ѕвез, _aayw, liol,
   {{0xa5bb0207,0x7f3b8039,0x799602d5,0x60c29fce}},	//   _biól, _העבו, _bayw, lyom,
   {{0x394d822c,0x61e2b5a6,0x25a68114,0xdceb02d4}},	//   _xees_, niol, _unol_, _žičn,
   {{0x60c2b5a7,0xdca39c79,0x61fd1b50,0x2bd9809a}},	//   nyom, _паци, rosl, योहा,
   {{0xb7bd802e,0x6fbe80d4,0x3f8a35a8,0x61e2b5a9}},	//   _puţi, ्सिं, gebu_, hiol,
   {{0x644086a8,0xbcfb0118,0xddd035aa,0x61e2b5ab}},	//   lpmi, _acép, _šeši, kiol,
   {{0xb8e30a49,0x6d4435ac,0x76550035,0x69c60192}},	//   _এই_, gbia, rszy, ckke,
   {{0x57f5120c,0x394db5ad,0x69df0609,0xb0db8a27}},	// [2270] _опит, _rees_, _imqe, _मेंग,
   {{0xfe6e19f4,0xa3d7000f,0x60cf080a,0x76550035}},	//   دگی_, ़ों_, ınmı, pszy,
   {{0x6d4435ae,0x6602b5af,0x394d9d14,0x6b9502d0}},	//   bbia, _okok, _pees_, _vazg,
   {{0xe8d935b0,0x61e2847f,0x394d8282,0x27e301ed}},	//   _ndị_, giol, _qees_, lijn_,
   {{0x394db5b1,0x315800be,0x60c28019,0xf1b98af8}},	//   _vees_, ליאן_, gyom, _hišk_,
   {{0x394d84df,0x660290ab,0xe8d90870,0xbcfb046d}},	//   _wees_, _akok, _adị_, _adég,
   {{0x6d4f0397,0xdd918117,0x69c60b40,0x629a35b2}},	//   _keca, ہوں_, ykke, _štov,
   {{0xf1948153,0x7c2735b3,0x8459b5b4,0x38608503}},	//   _пись, _hijr, орот_, šira_,
   {{0x8554803d,0x225800cd,0x799600fc,0x6f0901d0}},	//   ریور_, _zvrk_, _rayw, řech,
   {{0x6d4f35b5,0x69cd0d62,0x443fb5b6,0x3e578162}},	//   _leca, _alae, rpu_, păt_,
   {{0x7c2f0c6e,0xa18a2b3f,0xa3ae34ec,0x69cd031d}},	//   _lucr, обна_, कात_, _blae,
   {{0x443f8fc0,0x69cd35b7,0x6d4f35b8,0x88e60ca0}},	//   ppu_, _clae, _neca, джме,
   {{0x661bb5b9,0xc4fb803d,0x69c60198,0x6609b5ba}},	//   mmuk, _اعضا_, rkke, mlek,
   {{0x69cd02c4,0x661b8a41,0x8b0381d0,0x7d061c77}},	//   _elae, lmuk, ářsk, _ryks,
   {{0xf77209d7,0x6d4f3499,0x2bda8077,0x442fb5bb}},	//   _یاد_, _beca, _بانک_, _hug_,
   {{0x4427b5bc,0x6d4f35bd,0x7e61007b,0x6609b5be}},	//   _hin_, _ceca, álpa, nlek,
   {{0x6d442bb8,0xe3ba0cf3,0xfce30195,0x442fb5bf}},	// [2280] rbia, оба_, вото, _jug_,
   {{0x44278b1b,0x8bf100c8,0x64561600,0x7d060110}},	//   _jin_, _জীবন_, rsyi, _vyks,
   {{0x442fb5c0,0x9f5c80f1,0x7c2f0118,0xbcfb26b2}},	//   _lug_, sovë_, _eucr, _adéd,
   {{0x4427b5c1,0x6609869f,0x9f5c83c1,0x661b80b9}},	//   _lin_, jlek, mové_, jmuk,
   {{0x9f5c803e,0xa3bf897d,0x645d816b,0x443d81c0}},	//   lové_, ीसा_, ásil, _ntw_,
   {{0x4427b5c2,0x6609b5c3,0x8fa38878,0xd8d735c4}},	//   _nin_, elek, каче, וונט_,
   {{0xdb03a6d5,0x9f5c827f,0x34b88bb8,0xd6d080f7}},	//   _monó, nové_, ेन्द, طقة_,
   {{0xd5b08307,0x4427b5c5,0x27e301ed,0x661b977c}},	//   افة_, _ain_, zijn_, gmuk,
   {{0x4427b5c6,0x442f8640,0x9f5c826f,0xf41f0338}},	//   _bin_, _cug_, hové_, _isär_,
   {{0x63bc0a3e,0x9f5c83cb,0x39468110,0xa3d8809a}},	//   _jorn, kové_, lbos_, ठों_,
   {{0xbcfb35c7,0x9f5c826f,0x2fd7803d,0x69cd35c8}},	//   _idée, jové_, _تولد_, _plae,
   {{0x4427b5c9,0x9f5c83fb,0x3ce08289,0x8c4687b6}},	//   _ein_, dové_, _živu_, _жеде,
   {{0x6d4f1520,0x29f8b5ca,0x443d808e,0xdb18802a}},	//   _reca, mčad_, _gtw_, _mové,
   {{0x6d4f1a67,0x4427b5cb,0x9f4300f1,0xdb038388}},	//   _seca, _gin_, mijë_, _conó,
   {{0xd5bb35cc,0x7c2f1ebb,0xdb038118,0x9f5c85b9}},	//   оса_, _sucr, _donó, gové_,
   {{0x4427b5cd,0xdb18827f,0xca2980be,0x29f8811f}},	//   _zin_, _nové, _צופֿ, nčad_,
   {{0x63bc35ce,0x4427a778,0x6d4f35cf,0x62978118}},	// [2290] _born, _yin_, _veca, _áxor,
   {{0x2fc70104,0x44278028,0x60c000f2,0x9f5c826f}},	//   _ông_, _xin_, ämme, bové_,
   {{0x3d0583bb,0x386680ee,0x63bc35d0,0xddc38087}},	//   _हुने_, eror_, _dorn, nunţ,
   {{0x6d5d006a,0x6eae001b,0x2909008e,0xf1b980ce}},	//   _udsa, ीहरु, _kyaa_, _kiši_,
   {{0xdd3a0051,0x63bc080e,0x798bb5d1,0x6609941f}},	//   _מערכ, _forn, regw, vlek,
   {{0x2d990079,0xe7398b9b,0xe8d9019d,0xe61180d7}},	//   _hase_, чек_, _ndọ_, گشت_,
   {{0x4427b5d2,0x2d9935d3,0x27e981dd,0x442fb5d4}},	//   _rin_, _kase_, đan_, _sug_,
   {{0x4427b5d5,0xdcf380fe,0xdceb81cd,0xe8d901bc}},	//   _sin_, šače, _jagħ, _adọ_,
   {{0x6609b5d6,0x661b859c,0xdceb81cd,0x9f5c826f}},	//   rlek, rmuk, _magħ, zové_,
   {{0xe3b18307,0x63bc35d7,0x2d9935d8,0xe8bd8540}},	//   ارة_, _xorn, _lase_, ्नीच,
   {{0x29090962,0x4427b5d9,0x2bb1809a,0x6609b5da}},	//   _ayaa_, _vin_, जाबा, plek,
   {{0x442f81e9,0x9f5c826f,0xf99f0247,0x9f4781a8}},	//   _tug_, vové_, blèm_, inní_,
   {{0x4427b5db,0x30750d91,0x2ec81d40,0x1c4485a8}},	//   _tin_, курс, रन्त, _анім,
   {{0x9f5c803e,0x44278f29,0x6aae81a8,0x25bd81b4}},	//   tové_, _uin_, óifí, _howl_,
   {{0xa3ae2a54,0xb9072261,0xf8bd800d,0x39468110}},	//   कास_, _ये_, ्नुप, ybos_,
   {{0x9f5c803e,0x2d9935dc,0x212d90e1,0xdb1c00e7}},	//   rové_, _case_, _ngeh_, _forê,
   {{0xa3c3835a,0x3dd20355,0x9f5c803e,0x7de8801b}},	// [22a0] _एका_, rhyw_, sové_, měst,
   {{0xdcea812b,0x61e635dd,0xfc3f0013,0x395f90f0}},	//   šiće, likl, _dtí_, _adus_,
   {{0xa3dc058c,0x63bc01ec,0x160fa0d5,0x6600a0e2}},	//   तोष_, _vorn, ातार_, yomk,
   {{0x3f9a35de,0x61e60255,0x629a00c3,0xfb1683de}},	//   _hapu_, nikl, _štos, ײַבט_,
   {{0x63bc35df,0xe8948ca0,0x6d5635e0,0xa927835f}},	//   _torn, таль, maya, ніше_,
   {{0x2d990f20,0x2d8035e1,0xdb03823e,0x644435e2}},	//   _zase_, lfie_, _anní, mpii,
   {{0xaade8105,0x3f9a1249,0xdb1c0168,0x61e635e3}},	//   _फेंक, _mapu_, _morë, kikl,
   {{0xceb30051,0x6d5635e4,0x442a0133,0xa3ae11bc}},	//   ריה_, naya, _hib_, काव_,
   {{0x442a35e5,0x61e635e6,0x18678073,0xd1758084}},	//   _kib_, dikl, _пати_, _шыры,
   {{0x6d5635e7,0x3a29059c,0x442a056c,0xb3469243}},	//   haya, _siap_, _jib_, diçõ,
   {{0x6d5602e8,0x78a435e8,0xd257804a,0x2ca002f1}},	//   kaya, _ariv, нця_, hvid_,
   {{0x442a35e9,0x6d5634c3,0x78a435ea,0x3e7a8168}},	//   _lib_, jaya, _briv, mët_,
   {{0x7dca003e,0x6d5635eb,0x3e7a820f,0x1ae700c8}},	//   _výsl, daya, lët_, _করছে_,
   {{0x442a35ec,0xf1b98024,0xb4be864a,0x78a435ed}},	//   _nib_, _viši_, ीनी_, _driv,
   {{0x2d990205,0x3a290057,0x2d802cbd,0x3e7a80f1}},	//   _pase_, _tiap_, ffie_, nët_,
   {{0x6d561efa,0x32538698,0xb3468073,0x78a40370}},	//   gaya, _свър, biçõ, _friv,
   {{0xf3670758,0x442a03ec,0x3e7a80f1,0xdb15026f}},	// [22b0] етен, _bib_, hët_, _vozí,
   {{0x442a35ee,0x3e7a820f,0x667200d7,0x7c2a8372}},	//   _cib_, kët_, دگیر, _jifr,
   {{0x442a02a3,0xdcebaf1e,0x6d5635ef,0x3e7a80f1}},	//   _dib_, _tagħ, baya, jët_,
   {{0x200335f0,0x799d35f1,0x6d5635f2,0x7de7810c}},	//   loji_, ndsw, caya, _mèsè,
   {{0x660d35f3,0x249f03a7,0x799d1989,0x7dda128a}},	//   mlak, _éum_, idsw, růst,
   {{0x660d35f4,0x61e61c37,0xdee584ae,0x442a35f5}},	//   llak, zikl, коли, _gib_,
   {{0xa3ae0d86,0x34c98bb8,0x3e7a8168,0xddd48088}},	//   कार_, िन्द, gët_, _šaši,
   {{0x442a0282,0x4ce280ab,0x660d35f6,0x4c85b5f7}},	//   _zib_, _পড়ু, nlak, влив,
   {{0x61e606be,0x442a022c,0xc8e00540,0x7c2a808b}},	//   vikl, _yib_, _पेंट, _bifr,
   {{0xad9b01fa,0xd7598b76,0x660d005d,0x20030803}},	//   _skúl, _آلات_, hlak, joji_,
   {{0x6d5635f8,0x7c2aabbe,0x27e7807b,0xa96a0e0b}},	//   yaya, _difr, minn_, мина_,
   {{0xe3b18bca,0x660d0024,0x27e7b5f9,0x3f9a355e}},	//   ارک_, jlak, linn_, _sapu_,
   {{0xeb8e9ddf,0x660d35fa,0x1a65819f,0x61e635fb}},	//   _ки_, dlak, ریکی_, rikl,
   {{0x20030db7,0x6d562b36,0xb34683a7,0x777703a8}},	//   goji_, waya, riçõ, _ccxx,
   {{0x6d5635fc,0xb34683a7,0xa3d686af,0x645d0711}},	//   taya, siçõ, _सतत_, _avsi,
   {{0x442a10af,0x660d221b,0x27e78046,0x799bb5fd}},	//   _sib_, glak, hinn_, _nauw,
   {{0xa3ae09a3,0x442a01c5,0x6d5635fe,0x27e7807b}},	// [22c0] काल_, _pib_, raya, kinn_,
   {{0x6d5635ff,0x442a0069,0xa3dc0063,0x80db3600}},	//   saya, _qib_, तों_, _যুক্,
   {{0x6d563601,0x442a0282,0x799bb602,0x81f7004e}},	//   paya, _vib_, _bauw, _سفیر_,
   {{0x442a0e60,0x5e570158,0x6e2b877f,0x6d5601b4}},	//   _wib_, _ביטע_, _nigb, qaya,
   {{0x442a01e9,0xf1b9a35d,0xf772803f,0x6d49b603}},	//   _tib_, _nišu_, لاغ_, dbea,
   {{0x27e7b604,0x3e7a80f1,0x6e2b8091,0xf09303c8}},	//   ginn_, tët_, _aigb, ינד_,
   {{0x61e400ce,0xf1b9826c,0xbcfb3605,0xd6cf80a0}},	//   _omil, _aišu_, _idéa, يقه_,
   {{0x3e7a88cf,0x6b9c3606,0x7c2ab607,0x2bca99e8}},	//   rët_, _harg, _sifr, िस्थ,
   {{0xb4be913d,0xb4cc81fe,0x6b9c3608,0xd3788289}},	//   ीने_, रने_, _karg, lići_,
   {{0x61e43609,0x69c0b60a,0xf1b98699,0x27e781e4}},	//   _amil, _home, _dišu_, cinn_,
   {{0x6d49b60b,0xd6c48bca,0xa3e3923a,0xa3c38006}},	//   bbea, _حمای, _नगर_, _एकर_,
   {{0x6b9c33fe,0xdb1c360c,0x3869b60d,0x6e2b8915}},	//   _larg, _coré, šare_, _gigb,
   {{0xdb151727,0xdb1c12b6,0x2d86810c,0xd3788140}},	//   _mozá, _doré, _iboe_, hići_,
   {{0x61e4360e,0x5ba38698,0xbcfb00f7,0xa3e1824c}},	//   _emil, _връз, _ndéa, नोद_,
   {{0x27ed003b,0xdd9b0791,0x660d360f,0x9e07035f}},	//   đen_, мша_, tlak, вчал,
   {{0xd378805c,0x2ba68beb,0x973c8115,0x59670081}},	//   dići_, _कोता, _inću, _ръка,
   {{0x660d14ff,0xa3ae00d4,0x629a3610,0x24580009}},	// [22d0] rlak, कां_, _štop, кать_,
   {{0x6b9c10dd,0xd3789487,0x39593611,0xfc3f0511}},	//   _carg, fići_, lass_, _cría_,
   {{0x6b9c3612,0x799bb613,0x69c0a170,0x656281d6}},	//   _darg, _pauw, _bome, _odoh,
   {{0x249f00fe,0xf99f06c0,0xf1b989d1,0xa11581a8}},	//   _šumu_, ndè_, _ništ_, هوات,
   {{0x27e7b614,0x69cb83b2,0xfc3f2a8c,0xa0698254}},	//   tinn_, rkge, _fría_, хала_,
   {{0x6b9c3615,0xd37882a5,0x628a806a,0xa3ae3616}},	//   _garg, bići_, _opfo, काः_,
   {{0x27e7b617,0x69c0b618,0x2bb18076,0x7dd586a5}},	//   rinn_, _fome, जासा, _láse,
   {{0x27e7b619,0x2ca6811f,0xf1b98024,0x69c0b61a}},	//   sinn_, _brod_, _pišu_, _gome,
   {{0x6d49b61b,0x9f478168,0x3f910102,0x6b9c02d0}},	//   rbea, ninë_, kezu_, _yarg,
   {{0x69c08a0f,0x6d4981e4,0xf1b980ce,0x249900ee}},	//   _zome, sbea, _višu_, _mssm_,
   {{0x39ea0ae7,0xdb1c0548,0x44211a29,0x42260193}},	//   едно_, _poré, imh_, лдов,
   {{0x9f4e003e,0x186a11d2,0x7dca03f2,0xceb280be}},	//   čník_, нами_, _výsk, _ליב_,
   {{0xc60f86b7,0xa91d8110,0x6fcb01ec,0xd37880d2}},	//   ातीय_, _pažy, _küch, zići_,
   {{0xaae4803d,0x3a2d81ed,0x66e6361c,0x2d9d867f}},	//   اسیو, _liep_, гога, _hawe_,
   {{0x2d9db61d,0xf7430098,0x66040bf0,0xcb5681c6}},	//   _kawe_, сесо, toik, _עסקה_,
   {{0xd3788052,0x2d9fb61e,0xa01b0019,0xed598088}},	//   vići_, ndue_, gtöb, naž_,
   {{0xd4671289,0x5baa03c7,0xb38607b6,0x6b9c361f}},	// [22e0] лите_, нкам_, ллал, _parg,
   {{0x69c0b620,0xd378812b,0x3ce68006,0x5eff00c2}},	//   _some, tići_, _जइसे_, _शुक्_,
   {{0x68fb87f4,0x69c0a39f,0x6b9c3621,0x63bc9252}},	//   _axud, _pome, _varg, örni,
   {{0xc693093f,0x6b9c3622,0x4421061f,0x2d9db623}},	//   _פאר_, _warg, amh_, _nawe_,
   {{0x2d922fca,0x17548c40,0x3a2d837a,0xd7e68d8e}},	//   meye_, авля, _diep_, ліко,
   {{0x6fcb02af,0x78a2816b,0x2d9d8032,0x69c0b624}},	//   _rück, rvov, _aawe_, _wome,
   {{0x6442b625,0x24803626,0xb4cc8a27,0xe8d901bc}},	//   _stoi, ltim_, रन्_, _ibụ_,
   {{0x2d922fca,0x225c026f,0xa3d686b7,0x25a03627}},	//   neye_, ávku_, _सतह_, ndil_,
   {{0x98a39e25,0x24803628,0xf74692b2,0x7c2e18d5}},	//   _лите, ntim_, _безо, _kibr,
   {{0x7c2e3629,0x320698b3,0x248002d5,0xdcef0669}},	//   _jibr, looy_, itim_, šeće,
   {{0x3f910052,0x8646b210,0x2d92362a,0x3f9e80b9}},	//   vezu_, _снеж, keye_, _iatu_,
   {{0x2480362b,0x7c2e3437,0xf6518117,0x2d9db62c}},	//   ktim_, _libr, _گئے_, _gawe_,
   {{0x7c2e0013,0x3f91007d,0x3f9e8a36,0x2480362d}},	//   _oibr, tezu_, _katu_, jtim_,
   {{0x3940026c,0x3f9eb62e,0x7d0686ae,0x3959362f}},	//   _efis_, _jatu_, üksu, sass_,
   {{0x6298803b,0xa3ae0697,0x2d9dafc0,0x39590687}},	//   _usvo, काई_, _yawe_, pass_,
   {{0xf99307bd,0x7c2e00f7,0x3f9e80eb,0xe8d90870}},	//   _طبع_, _aibr, _latu_, _abụ_,
   {{0x442e81cd,0x3b5528df,0x4421008e,0x7c2e0f3e}},	// [22f0] _kif_, икар, tmh_, _bibr,
   {{0x9f47820f,0x3f9eb630,0x7c2e3631,0x3a2d8299}},	//   rinë_, _natu_, _cibr, _siep_,
   {{0x06bf00c8,0x9f4780f1,0xa5bb0825,0x93880084}},	//   _উইকি, sinë_, _biót, ыста_,
   {{0xaca3019d,0x7dd5a6e7,0x9f47b632,0xd37880ce}},	//   _agụb, _másc, pinë_, miću_,
   {{0x3f9e9067,0x6d4d2339,0xd37881dd,0x9f47b543}},	//   _batu_, mbaa, liću_, liné_,
   {{0xdcfd0029,0x7c2e3633,0xf77191cc,0x764500f1}},	//   _lasī, _gibr, زات_, _kthy,
   {{0x45d598a0,0x3f9eaa6b,0xd378812b,0x3a2d8129}},	//   ицит, _datu_, niću_, _tiep_,
   {{0x6d4d02b5,0xb88681d0,0x442eb634,0x4465a341}},	//   nbaa, _sníž, _aif_, авив,
   {{0x851fb635,0x61eb8098,0xed598916,0x3f9eb636}},	//   मेंट_, migl, raž_, _fatu_,
   {{0x2d9dafc0,0x442e80fc,0xa5bb00f7,0x2d923637}},	//   _wawe_, _cif_, _fhóg, zeye_,
   {{0x629e9fc2,0x6d4d05f8,0xd378811f,0x6b600061}},	//   _špor, kbaa, jiću_, lágí,
   {{0xd3788024,0x9f47b638,0x78a9b639,0x61ebb63a}},	//   diću_, diné_, _krev, nigl,
   {{0x9f5c803e,0x20078006,0x6d5b8b99,0x6d4d329a}},	//   lová_, ooni_, maua, dbaa,
   {{0x2007b63b,0xd378812b,0x6d5bb63c,0xbcfb046d}},	//   noni_, fiću_, laua, _adéo,
   {{0xed5a00af,0x9f5c803e,0x2d92362a,0x9f47b63d}},	//   ков_, nová_, teye_, giné_,
   {{0x7bc38125,0x2007a7ce,0x38608289,0x78a9ace1}},	//   _honu, honi_, širi_, _orev,
   {{0x7bc3b63e,0x2007b63f,0x69d60065,0x2d922fca}},	// [2300] _konu, koni_, _ilye, reye_,
   {{0x2007b640,0x69aa05b3,0x9f5c827f,0x2d923641}},	//   joni_, _जोती, ková_, seye_,
   {{0x7f5c0e99,0xeb97228e,0x3f9eb529,0x24803642}},	//   marq, рих_, _ratu_, stim_,
   {{0x3f9e848f,0x22518efc,0xa96a8b26,0x6d5b8590}},	//   _satu_, ázky_, тида_, jaua,
   {{0x78a9b643,0x7c2e3644,0x386080f7,0xad9b026b}},	//   _crev, _tibr, éir_, _akúw,
   {{0x78a9a39f,0x7f5c1883,0x60000198,0x26170036}},	//   _drev, narq, tömy, nçon_,
   {{0x61ebb645,0x442eb646,0xd9109e29,0xd1768198}},	//   bigl, _rif_, _کیش_, _вызы,
   {{0x3f9e80f6,0x69d9b647,0xa3ae0076,0x69c413df}},	//   _watu_, chwe, काक_, _noie,
   {{0x3f9e8d4c,0x030b809a,0x20078dc4,0x2e3c007b}},	//   _tatu_, _सुबह_, boni_, _líf_,
   {{0x9f5c826f,0xa5bb00f7,0x2007b648,0x7dd58187}},	//   bová_, _thóg, coni_, _pásc,
   {{0x1fb584fa,0xbcfb3649,0x7bc3b64a,0x98a20085}},	//   _устр, _adél, _donu, dakı_,
   {{0xd378803b,0x644601dd,0x6d5bb19f,0x973c8b80}},	//   viću_, _otki, caua, _daće,
   {{0xa3e7000f,0x90980656,0x2b06b64b,0x7dd1364c}},	//   _बगल_, авят_, _सुरु_, _såso,
   {{0xd378a828,0x9f4780d7,0x9217141b,0x628e0fb0}},	//   tiću_, tiné_, _धीरज_, _opbo,
   {{0xc6a41980,0x69d62347,0x799f036e,0x6d4d364d}},	//   орти, _flye, _taqw, tbaa,
   {{0xd3788289,0x69c40102,0xcdd804ae,0x9f479ab3}},	//   riću_, _goie, ању_, riné_,
   {{0xdce6084a,0x6d4d0c11,0xf94a0158,0x2007b64e}},	// [2310] _bakı, rbaa, _געפֿ, yoni_,
   {{0x6d4d2023,0xd79500f7,0x69c400f3,0x3ceb016f}},	//   sbaa, _الدخ, _zoie, _घेणे_,
   {{0x644607d9,0x69d98234,0x6d4d0cfa,0xfc3f0511}},	//   _etki, thwe, pbaa, _trío_,
   {{0xf993803d,0x7dd8001b,0x9f5c816b,0x69c4002a}},	//   تبط_, _píse, vová_, _xoie,
   {{0xf99f009f,0x2d8b01c0,0x61ebb64f,0x98a5b650}},	//   llès_, _ibce_, rigl, силе,
   {{0x61ebb651,0x9f5c9c18,0x78a98390,0x6aaa8428}},	//   sigl, tová_, _vrev, _orff,
   {{0x44390bfa,0x2007b652,0x6d5b8b17,0xe61f001c}},	//   _hus_, roni_, taua, _khô_,
   {{0x7bc3b653,0x78a9b654,0x44393655,0x2007b656}},	//   _sonu, _trev, _kus_, soni_,
   {{0x7bc3b657,0x61e9b658,0xdce607d9,0x44393659}},	//   _ponu, _imel, _yakı, _jus_,
   {{0x4439146a,0xa3e18df4,0x7bc3b65a,0x395d9393}},	//   _mus_, नों_, _qonu, laws_,
   {{0x443910af,0x6449b65b,0x4431365c,0x2d8b21d5}},	//   _lus_, spei, _miz_, _obce_,
   {{0x4439023e,0xbcfb0032,0x3cfd81c5,0x6449b65d}},	//   _ous_, _adém, _txwv_, ppei,
   {{0x44390069,0x61e98133,0xc884817b,0x53a5802e}},	//   _nus_, _mmel, cağı_, _галб,
   {{0x7bdab3d6,0x6d598072,0x61fb8289,0x248f80b9}},	//   chtu, _hewa, _ljul, _ipgm_,
   {{0x4439365e,0xdb188117,0x6d59b65f,0x7dd5803e}},	//   _aus_, _tová, _kewa, _zása,
   {{0x25bf9ab3,0x443100eb,0xdce602d0,0x44393660}},	//   njul_, _aiz_, _sakı, _bus_,
   {{0x4431173c,0x6d59b661,0x44393662,0x2b580019}},	// [2320] _biz_, _mewa, _cus_, _perc_,
   {{0x44393663,0x61e9b664,0x6d598890,0xf1a9803d}},	//   _dus_, _amel, _lewa, یانه_,
   {{0x44393665,0x44310073,0x6fd0016d,0x479b03c8}},	//   _eus_, _diz_, _läck, _גייס,
   {{0x26173666,0x200a3667,0x29f88bcf,0xa3a80f12}},	//   nçol_, lobi_, rčao_, _खोर_,
   {{0x1cba030f,0x4fc68c07,0xc7c688cc,0x06e580c8}},	//   _صاحب_, йска, йски, _পুলি,
   {{0x161c023c,0x61e9b668,0x43751bdc,0x29f8826c}},	//   _भीतर_, _emel, _муст, pčao_,
   {{0x44393669,0x6d59b3fc,0xe0df01e8,0x2fc582d4}},	//   _zus_, _bewa, zzò_, _dolg_,
   {{0x443901e9,0x6d5980a4,0x6fd012d2,0x7dd58333}},	//   _yus_, _cewa, _bäck, _pása,
   {{0x6d598812,0x443901e9,0xbcfb026b,0xea010129}},	//   _dewa, _xus_, _adéj, _quậy_,
   {{0x6fd00106,0x9b588073,0x4431366a,0x249d8176}},	//   _däck, шиот_, _xiz_, _dswm_,
   {{0x66098fb0,0x51f900e8,0x200a328b,0x91fd01a9}},	//   boek, иною_, dobi_, krāt,
   {{0x6d59b66b,0x7bda89be,0xf2d300be,0x386081a1}},	//   _gewa, shtu, פער_, širu_,
   {{0x6e3ab66c,0xb4db046d,0xb87b01d6,0x63bca51d}},	//   _hutb, _afàn, dzíc, örns,
   {{0xa3a809a3,0x63ad80fc,0x3fe70264,0x03a38162}},	//   _खोल_, _ɗank, পক্ষ, _ничо,
   {{0x4439366d,0xd35b8bea,0x48e90074,0xe2468250}},	//   _sus_, _גדול, _चेरो_, _اختي,
   {{0x44310182,0x4439366e,0xdb0a823e,0x395d8282}},	//   _siz_, _pus_, _infà, xaws_,
   {{0xf1f800d5,0x71f80829,0x320b009a,0x44390069}},	// [2330] _دعوت_, _دروس_, mocy_, _qus_,
   {{0x66098a0f,0x6fd002af,0x200a010c,0x4439366f}},	//   zoek, _näch, cobi_, _vus_,
   {{0x6fb5003d,0x443101d0,0xe5350150,0x4439003d}},	//   _همکا, _viz_, _мень, _wus_,
   {{0x4439146a,0x7dd10022,0x6fcb0214,0x3f8c985b}},	//   _tus_, _måsk, _vücu, _abdu_,
   {{0x7dca027f,0x44390006,0x6d5f3670,0x9ccb01bb}},	//   _výst, _uus_, maqa, _сына_,
   {{0x644d0d17,0x6d5989ca,0x6fd000f2,0x6e3a8122}},	//   mpai, _sewa, _räck, _butb,
   {{0x2fc58b3c,0x7ac40056,0x6d599295,0x644d3671}},	//   _volg_, _есте, _pewa, lpai,
   {{0xa2d786ab,0x61e9b672,0x1c459017,0x59f98009}},	//   मनस्, _umel, оним, _тебя_,
   {{0x644d3673,0x22478b99,0x6609b674,0x386081a8}},	//   npai, _stnk_, roek, áirt_,
   {{0x7ff78277,0xdb1c12da,0xd2658ada,0x660981b0}},	//   _اسرا, _horá, окой, soek,
   {{0x62853675,0x6d598562,0xdb1c2792,0x78ad3676}},	//   ntho, _tewa, _korá, _arav,
   {{0x6fd0016d,0x7bc73677,0x249d8282,0x62850428}},	//   _täck, _loju, _tswm_, itho,
   {{0x200a046d,0x394d0e15,0x62850362,0xb915826b}},	//   tobi_, ñesa_, htho, _agbẹ_,
   {{0x34b283f8,0x2329b678,0x78ad011a,0xdbf18085}},	//   _آموز, _коли_, _drav, dəçi,
   {{0x200a3679,0x6285367a,0x443fb67b,0x61ef1c33}},	//   robi_, jtho, lqu_, bicl,
   {{0x63a3b67c,0x69dd0352,0x7dd58065,0xdd920b76}},	//   _hann, chse, _máso, بور_,
   {{0x63a3b67d,0x6285031d,0x13ea0048,0x7bc7367e}},	// [2340] _kann, etho, амай_, _boju,
   {{0x63a3b67f,0xad9b3680,0xa3e5103e,0x63bb0326}},	//   _jann, _skút, बोल_, _ɗung,
   {{0x63a3b681,0x3f9804b6,0xe29a2005,0x6d5f3670}},	//   _mann, meru_, рае_, baqa,
   {{0x63a3b682,0x63a50014,0xdb1c15a0,0x29f880c3}},	//   _lann, adhn, _corá, pčam_,
   {{0x92bc0a49,0xaca3819d,0x91a00129,0x7bc70032}},	//   েছে_, _blọk, _chỉ_, _foju,
   {{0x63a3b683,0x6d441f50,0x66163684,0x3f983685}},	//   _nann, lcia, llyk, neru_,
   {{0xdb1c01a8,0x62853686,0xd90d8019,0x9f9d026b}},	//   _forá, ctho, نیہ_, _dìè_,
   {{0x6d442d2a,0x26c08052,0x39428006,0x63a38c11}},	//   ncia, ćio_, _üks_, _aann,
   {{0x63a3b687,0x2249b688,0x6d443689,0x3f98368a}},	//   _bann, _čaka_, icia, keru_,
   {{0x69c28b3c,0x3f9800ce,0x63a39e68,0x7dd112c3}},	//   ljoe, jeru_, _cann, _påsk,
   {{0x61ef368b,0x1fb5b68c,0x69dd0168,0x2905080a}},	//   ticl, _эстр, thse, ğlam_,
   {{0x78ad368d,0x51f80190,0x63a3998d,0x6d44368e}},	//   _prav, жнюю_, _eann, jcia,
   {{0x63a3b68f,0x7dd59c18,0x3f983345,0xa3c3816f}},	//   _fann, _záso, feru_, _एकच_,
   {{0xa3ce81b6,0x3f983690,0x6560b691,0x7ddc80e7}},	//   _रवि_, geru_, lamh, _dése,
   {{0x9f340163,0xbcfb03a7,0x66163692,0x6d5f10ba}},	//   дері, _idéi, flyk, taqa,
   {{0x7dd5803e,0x78ad3693,0x63a390ed,0x24408247}},	//   _násl, _trav, _zann, _kòm_,
   {{0x63a3b694,0xad9b01ac,0x78ad3695,0x3f983696}},	// [2350] _yann, _skús, _urav, beru_,
   {{0x6d5f3697,0x644d0f31,0xdb1c0019,0x57f40198}},	//   saqa, rpai, _sorá, _опыт,
   {{0x644d3698,0xdd910013,0x61ed007a,0x5a35046e}},	//   spai, _كود_, _kmal, чнет,
   {{0x62850347,0x6d440098,0xfe9a00be,0xf1bf3699}},	//   rtho, ccia, _פירמ, zmán_,
   {{0x6d5d00eb,0x61ed0135,0x6285369a,0x660d09c4}},	//   _iesa, _mmal, stho, moak,
   {{0x6d5d369b,0x1da39513,0x940500d7,0x7dd5816b}},	//   _hesa, _खोजत, _روزه, _páso,
   {{0x63a3b69c,0x6d5d369d,0x7c3d3644,0xdb1c0207}},	//   _rann, _kesa, _husr, _torá,
   {{0x63a3b69e,0x3f98369f,0x6d5d2a81,0xbca580f7}},	//   _sann, zeru_, _jesa, كمبي,
   {{0x6d5d36a0,0x63a3b6a1,0xb4d58816,0x6e22b6a2}},	//   _mesa, _pann, सने_, _dhob,
   {{0x7ddc83d3,0x61ed36a3,0x443fb6a4,0x6d5d2890}},	//   _rése, _amal, rqu_, _lesa,
   {{0x63a3b6a5,0x443f82be,0xe8e10028,0x3f9810e8}},	//   _vann, squ_, _đều_, veru_,
   {{0x63a3b6a6,0x6d5d36a7,0xdb1c013c,0x3f9836a8}},	//   _wann, _nesa, _foræ, weru_,
   {{0x7c3d36a9,0x660d0359,0x63a3b6aa,0x6e298aa2}},	//   _nusr, doak, _tann, mmeb,
   {{0xf8a583f8,0x2bbb8307,0x69db9fd6,0x63a390ac}},	//   _یک_, _خاصة_, _llue, _uann,
   {{0x6d5d1a67,0x7c3d02af,0xa3b52342,0xaca40133}},	//   _besa, _ausr, झाई_, _mpụt,
   {{0xf06636ab,0x1c46268a,0x7c3501a9,0x29f88140}},	//   _екип, знам, _aizr, rčak_,
   {{0x6d5d36ac,0xdb1c00f1,0x3f9836ad,0x7c3d008e}},	// [2360] _desa, _korç, peru_, _cusr,
   {{0x6d4436ae,0x69db8364,0xe81b86a7,0x66160a64}},	//   scia, _alue, _पीला_, slyk,
   {{0x69c28901,0x8c1a8039,0xe29723d7,0x160b8beb}},	//   tjoe, צועי, зах_, हकार_,
   {{0x6d5d36af,0xf3f1aae3,0xaca40135,0x236a0122}},	//   _gesa, hị_, _apụt, _wdbj_,
   {{0xf5370051,0x2d82016d,0x6e2982f1,0xb4d586ae}},	//   _מרכז_, _icke_, dmeb, सनो_,
   {{0x56949269,0x6e949c8b,0xbcfb0091,0x2440b6b0}},	//   дакт, дику, _adéw, _ròm_,
   {{0xcf268013,0x6e22b6b1,0x69dba347,0x60168187}},	//   أرشي, _phob, _flue, nâmi,
   {{0xe9a39273,0x21a390ca,0x7c3d0359,0xade380e8}},	//   _пасп, _писм, _yusr, ецьк,
   {{0xdb1c007e,0x28168061,0xdcebb6b2,0x6560b6b3}},	//   _borç, _فورس, _bagı, ramh,
   {{0x46a68554,0x6560b6b4,0x61ed0039,0xa01b0009}},	//   _назв, samh, _smal, ttöm,
   {{0xe9df0013,0x6e2289ef,0x9f5c81d6,0xbeaa80d7}},	//   thú_, _thob, kovú_, _دهان_,
   {{0x39469313,0xdb03803d,0x26170214,0x7d028102}},	//   ncos_, _manè, rçok_, _txos,
   {{0xdb1c2670,0x39468c52,0x7dd801d0,0x9ac481b9}},	//   _forç, icos_, _písn, _suċċ,
   {{0x6d5d355e,0x92578077,0xdc378158,0xa5bb36b5}},	//   _sesa, _کشور_, _זאגט_, _chón,
   {{0x6d5d36b6,0x7c3d003a,0x9f4a0388,0x660d36b7}},	//   _pesa, _susr, cibí_, toak,
   {{0x61ed3496,0x442303ac,0x42fb8039,0xe1ab8beb}},	//   _umal, _shj_, _להוס, _घोंघ,
   {{0x394936b8,0x660d36b9,0x7bcab6ba,0x7bdc05ee}},	// [2370] _ifas_, roak, _kofu, _blru,
   {{0x3f8104cd,0x6e991b2f,0x3946b6bb,0xdd9985b9}},	//   _uchu_, _двор_, ecos_, zeň_,
   {{0xaadc85b3,0x386936bc,0xdb580198,0xdd0c0035}},	//   मनिक, _hvar_, яют_, góło,
   {{0xd13191cc,0x61fd36bd,0x38690687,0x23c8801b}},	//   نما_, nnsl, _kvar_, ाउँद,
   {{0xdd99803e,0x8fa587ff,0x92bd00ab,0x07a5b6ab}},	//   veň_, дале, ইনে_, далн,
   {{0x25a92b24,0xb4d903db,0x7bcab14f,0x443d8bfd}},	//   ldal_, ़नी_, _nofu, _ruw_,
   {{0x24890065,0x9f478216,0x6446808b,0x5692aba7}},	//   ltam_, giná_, íkin, вајт,
   {{0x96270341,0x5334013a,0x25a936be,0x25a68c41}},	//   _uzņē, _чест, ndal_, _caol_,
   {{0x248936bf,0xf1bf1bd9,0x7dd5807b,0xea0000ff}},	//   ntam_, rmál_, _hásk, _ngại_,
   {{0x63a72ce4,0x320f8051,0xdd99826f,0x394936c0}},	//   _jajn, logy_, seň_, _afas_,
   {{0x25a936c1,0xdd99816b,0x3ed58f99,0x395f81ed}},	//   kdal_, peň_, _تقار, _keus_,
   {{0x77638a2b,0x25a68c41,0x67219351,0xaca3026b}},	//   lanx, _gaol_, _izlj, _afọb,
   {{0x7dd5803e,0x395fb6c2,0xb87b0019,0xa5bb001c}},	//   _lásk, _meus_, szín, _phón,
   {{0x63a736c3,0x0c24835f,0x7dd800e1,0x24890019}},	//   _najn, _змін, _píso, dtam_,
   {{0x16a70381,0xe73715fe,0x386906ab,0xe7e58074}},	//   мври_, дер_, _evar_, _कतना_,
   {{0x200eb6c4,0xcb128039,0x601683a7,0x26138187}},	//   zofi_, _שלה_, râmi, mãos_,
   {{0x224d003b,0x39a681e2,0x63a70019,0xdb038077}},	// [2380] _čeka_, _jūsų_, _bajn, _sanè,
   {{0x39a681e2,0x6721b6c5,0xafdb0aa2,0x78a436c6}},	//   _mūsų_, _ozlj, spør, _isiv,
   {{0xe72a198c,0x395f8580,0xea010129,0x7ddc810c}},	//   _фонд_, _beus_, _quầy_, _lésa,
   {{0xfc3f0216,0x395f8362,0xbcfb0580,0xa01b062c}},	//   _fuí_, _ceus_, _adéu, ytök,
   {{0x395fb6c7,0x5fd20063,0x63a7009a,0x18678991}},	//   _deus_, _हवाल, _fajn, дачи_,
   {{0x25a680f7,0x63a736c8,0xb03380e8,0x2cad99dc}},	//   _saol_, _gajn, вніш, dved_,
   {{0xc7b88028,0xdb1c016d,0x69d880f1,0x61fd2496}},	//   _vnđ_, _borå, ëves, ynsl,
   {{0x746a8153,0x443836c9,0x395fb6ca,0x200eb6cb}},	//   оров_, _hir_, _geus_, sofi_,
   {{0x61e2b6cc,0x6f0d8380,0xd49a804a,0x6fd487f1}},	//   mhol, ğaca, іри_, _làci,
   {{0x5f76845b,0x1b2100ab,0x61e28a33,0x7ddc80e7}},	//   _زائر, _বলতে_, lhol, _désa,
   {{0x38690082,0x443836cd,0x33770039,0xc7b384de}},	//   _svar_, _mir_, ועים_, _שבע_,
   {{0xc333078d,0x61e2835f,0x443836ce,0xdd8f80f7}},	//   כות_, nhol, _lir_, _نوم_,
   {{0x7dd104b8,0xdd8f8bca,0x2ca00239,0x443801e4}},	//   _måst, _خون_, jwid_, _oir_,
   {{0x44380609,0x7dd103a6,0x61e2b6cf,0x7522b6d0}},	//   _nir_, _låst, hhol, _izoz,
   {{0x38c5020f,0x61e2805d,0xe61300f7,0x63a736d1}},	//   _bërë_, khol, نشر_, _rajn,
   {{0xe81f058c,0x2d8036d2,0x443836d3,0x24890019}},	//   _मीरा_, ggie_, _air_, ttam_,
   {{0x443836d4,0x61e2813c,0x395f809f,0xb4d9009a}},	// [2390] _bir_, dhol, _reus_, ़ने_,
   {{0x395f907f,0x3f9c8fda,0x7dd5b6d5,0xd838886f}},	//   _seus_, jevu_, _pásk, _nič_,
   {{0x443836d6,0x248936d7,0xe1ff1726,0x395f823e}},	//   _dir_, stam_, onó_, _peus_,
   {{0x7c38b6d8,0x201136d9,0x443836da,0x660296f2}},	//   _livr, lozi_, _eir_, _njok,
   {{0x7b67025d,0x63a7003a,0x386980f7,0x395f8722}},	//   _отве, _tajn, éar_, _veus_,
   {{0x187c0039,0x4438035f,0x7c38826c,0x48e080ab}},	//   קטוב, _gir_, _nivr, বপূর,
   {{0x776384c3,0x395fb6db,0x260b86bf,0xa3a80075}},	//   ranx, _teus_, ावली_, _खोट_,
   {{0x61e2b6dc,0x442c8fb0,0xd5b18872,0xdcef08c5}},	//   chol, emd_, افظ_, _hacı,
   {{0x201120d7,0xd83881a1,0x6012006a,0x316036dd}},	//   kozi_, _fič_, kæmp, _reiz_,
   {{0x7dd58019,0x2cad8039,0x3f9c8699,0x9f9d026b}},	//   _mási, rved_, cevu_, _bìí_,
   {{0x656f2158,0xd24e8416,0x7dd8209c,0xb81b8035}},	//   _odch, ینی_, _sísm, _पीएम_,
   {{0x7dd8026f,0x66028168,0x644f05f3,0x69c6022c}},	//   _písm, _gjok, _otci, ujke,
   {{0x764197ea,0x7dd5816b,0x65640009,0x26170187}},	//   _huly, _nási, vaih, nçou_,
   {{0x201136de,0x661ba818,0x6d49b6df,0x60c4956e}},	//   gozi_, lluk, lcea, äimi,
   {{0x442782af,0x66e61bc1,0xdee60b9c,0x443836e0}},	//   _ihn_, хова, хови, _rir_,
   {{0x7dd59313,0xa3a80fea,0x7641b6e1,0xd24e80f7}},	//   _bási, _खोज_, _muly, _اني_,
   {{0x20110578,0x656436e2,0xfce3023f,0x91fd00eb}},	// [23a0] bozi_, raih, гото, ksāj,
   {{0x9f9d0324,0xfc3f00f7,0x661b829b,0x085704de}},	//   _yìí_, _arís_, hluk, _רבים_,
   {{0x44382674,0x7dd10bfa,0xdb1c01ac,0x442782f7}},	//   _vir_, _påst, _horú, _mhn_,
   {{0x443836e3,0x3f85b6e4,0xceb302f6,0x2a6a8019}},	//   _wir_, _aclu_, _עיר_, ábbi_,
   {{0x443806f6,0x61e2805f,0xdb1886c4,0x3f9cb6e5}},	//   _tir_, rhol, _envè, tevu_,
   {{0x6602b6e6,0x7641b6e7,0x442c06c0,0x998d81d6}},	//   _sjok, _buly, _òd_, _vieš_,
   {{0xfc031f25,0x7dd5826f,0x6996b6e8,0x3f9cb6e9}},	//   _спро, _zási, _прах, revu_,
   {{0x661baf08,0x291e009a,0x3f9c8267,0x69d98252}},	//   gluk, ętaj_, sevu_, ckwe,
   {{0x09e38e02,0xb4da8105,0x7bce36ea,0xdb188187}},	//   _сотн, ठने_, _kobu, _invé,
   {{0x7bce0087,0x8afe89ab,0x236580c3,0x3ea9866f}},	//   _jobu, _leƙe, galj_, łata_,
   {{0x7c3880e7,0x76419fce,0x7bce36eb,0x442c80f3}},	//   _vivr, _guly, _mobu, rmd_,
   {{0x7982b6ec,0x225c003e,0x6136880a,0x7bce0234}},	//   ngow, ávky_, _gülü, _lobu,
   {{0x20110423,0x23658904,0xe3b2803d,0x799d1e26}},	//   tozi_, balj_, _مرغ_, resw,
   {{0xb8c90d38,0x644fa6e1,0x2ca68114,0x799d2e4d}},	//   _गई_, ície, _isod_, sesw,
   {{0x201100b4,0x7a3e8084,0xe28f81a8,0x6e942f7d}},	//   rozi_, _būte, _هذي_, лиру,
   {{0x63aaa8b8,0x201136ed,0x34952f02,0x2365026c}},	//   _hafn, sozi_, кабр, _žlj_,
   {{0x7dd836ee,0x7bce36ef,0xbcfb046d,0x3a29033e}},	// [23b0] _získ, _bobu, _adér, _ihap_,
   {{0x63aa8125,0xdce0b6f0,0x6442b6f1,0x7bce0c4d}},	//   _jafn, jamč, _muoi, _cobu,
   {{0xa0360039,0xbb8401a8,0x29d782d0,0x9f8f02f1}},	//   _שאתה_, المي, _uçak_, _müü_,
   {{0x6562b6f2,0xcb1380be,0x9f58007b,0x7ae582f1}},	//   _neoh, אלע_, lorð_, _ühte,
   {{0xf9940039,0x7641b6f3,0x69d99699,0x661b817f}},	//   טרף_, _suly, rkwe, vluk,
   {{0x69d9b6f4,0x6298837a,0x63aa807b,0x3f83008b}},	//   skwe, _opvo, _nafn, ngju_,
   {{0x23658390,0x628b0493,0x5f05847f,0x9f47862c}},	//   valj_, ăgos, ъзка, vinä_,
   {{0xceb40158,0x7ddc82be,0x7bce36f5,0x9f5c816b}},	//   ריק_, _déso, _zobu, mový_,
   {{0x661b8867,0x2365b55d,0xa5bb0c52,0x9f5c826f}},	//   rluk, talj_, _dióx, lový_,
   {{0x6d4980f7,0x1a65815b,0xe50203eb,0x9aa40019}},	//   scea, نیتی_, लपति_, _جمہو,
   {{0x386db20d,0x9f5c826f,0xb17b0aa2,0x261726e1}},	//   _hver_, nový_, rhån, nços_,
   {{0x999880eb,0x3a2936f6,0x186a0a7c,0x2365817f}},	//   _kurš_, _chap_, мами_, salj_,
   {{0x4427810b,0x9f5c816b,0x2365817f,0x9f9d026b}},	//   _thn_, hový_, palj_, _bìà_,
   {{0xb4bf835a,0x9f5c83fb,0x29f896f2,0xb4cd816f}},	//   ीही_, kový_, nčar_, रही_,
   {{0xfaa5a64e,0x9f5c816b,0x248db6f7,0x91a000ff}},	//   _райо, jový_, ltem_, _thì_,
   {{0x386d8051,0x9f5c826f,0x98be0214,0x63bc36f8}},	//   _over_, dový_, ştı_, _snrn,
   {{0xd4670381,0x248db6f9,0x9f58008b,0xb38622d0}},	// [23c0] ките_, ntem_, borð_, клал,
   {{0x7dd836fa,0xeafa0250,0x248db6fb,0x2d9f8a53}},	//   _mísi, ورات_, item_, heue_,
   {{0x386d8098,0xdb1c077f,0x66e636fc,0xb4cd8074}},	//   _aver_, _yorù, _рона, रहु_,
   {{0x7ddcb6fd,0xdb18803e,0xe9da80e8,0x248db6fe}},	//   _réso, _nový, ьке_, ktem_,
   {{0x80be8540,0xe8949663,0xe0e080ab,0x7bce36ff}},	//   ्हें, уаль, বপ্ন, _tobu,
   {{0xdfcf8624,0x248db700,0x6562a6ac,0x9f5c8a21}},	//   يين_, dtem_, _seoh, bový_,
   {{0x6fdd809f,0x386d8039,0x2480051e,0x973c8b80}},	//   _tècn, _ever_, luim_, _jaći,
   {{0x5f168076,0x752601c0,0x25a0051e,0x442a008e}},	//   _पुण्_, _kzkz, neil_, _hhb_,
   {{0xc5f30051,0x6442838f,0xdb01865d,0x3a2902c4}},	//   ידה_, _quoi, ndlæ, _rhap_,
   {{0x32020038,0x7c3c04b7,0x660db701,0x25a03702}},	//   enky_, _jirr, čaka, heil_,
   {{0xe9f921d2,0x0d8682a9,0x5a351508,0x37ba00ab}},	//   енні_, _ален, лнот, ুসার,
   {{0xcb1304de,0x973c80fe,0x39400db1,0x91a0027d}},	//   ילת_, _naći, _cgis_, _phí_,
   {{0x386d3703,0x6abf016f,0x248d87f1,0x9f5c816b}},	//   éer_, _एप्र, ctem_, zový_,
   {{0x24803704,0x7c3c3705,0xdb1c03ba,0xd7c900d7}},	//   duim_, _nirr, _forø, روزه_,
   {{0x88cb00ab,0xbcfb046d,0x973c8140,0x1af080ab}},	//   _লেখক, _adép, _baći, _ঘুরে_,
   {{0x32538098,0x9f5c826f,0x25a001e4,0x7c3c0362}},	//   _твър, vový_, geil_, _airr,
   {{0x80be8063,0x443cb706,0x7c3c3707,0x38600428}},	// [23d0] ्हों, _kiv_, _birr, _gwir_,
   {{0x9f5c803e,0x7c3c3708,0x6fdd8722,0x442a01a1}},	//   tový_, _cirr, _rèco, _chb_,
   {{0x443cb709,0x20031487,0x7dd5816b,0x248d8019}},	//   _miv_, mnji_, _zásu, ztem_,
   {{0xe7e581fe,0x443ca253,0x261707e0,0x973c81dd}},	//   कसभा_, _liv_, rços_, _gaći,
   {{0x7dd5b70a,0x9f5c826f,0xdfd58d55,0x851e8054}},	//   _mást, sový_, лоды, _परगट_,
   {{0x443cb70b,0x7dd581ca,0x6e3d00fc,0x9f5c84e8}},	//   _niv_, _lást, _hisb, pový_,
   {{0x6e3d370c,0x4e9580f7,0xf1a7828b,0x7645008e}},	//   _kisb, اشتر, _иран, _juhy,
   {{0x7dd5803e,0x248d8065,0x26c9805c,0x069680f7}},	//   _nást, ttem_, ćao_, انية_,
   {{0x6e3d370d,0x31348596,0xb17b00f2,0xa5bb0013}},	//   _misb, _ветр, rhål, _chói,
   {{0x7dd80125,0x200302a5,0x248db70e,0xb17b016d}},	//   _vísi, jnji_, rtem_, shål,
   {{0x7d1d00f2,0x1603015c,0x17f880f7,0xdb03b70f}},	//   _lyss, रचार_, _شركة_, _taní,
   {{0x64b592dc,0x6e3d3710,0x2b4e8326,0x61f982c4}},	//   _محتر, _nisb, _effc_, niwl,
   {{0x6d5b9a67,0x443cb711,0x25a01aab,0x6fd4823e}},	//   mbua, _fiv_, veil_, _tàct,
   {{0x443c813c,0x291e00eb,0x2a6c8101,0x75fe80eb}},	//   _giv_, āta_, bsdb_, vīzi,
   {{0x66e31ad2,0x25a03712,0x6e3d3713,0xdee33714}},	//   бора, teil_, _bisb, бори,
   {{0x64a60972,0x443c82a5,0x7dd58207,0x7c3c1037}},	//   лаба, _ziv_, _gást, _sirr,
   {{0x29050459,0xa3d78768,0x25a03715,0xb4de3716}},	// [23e0] şlar_, _सवा_, reil_, तने_,
   {{0x7dd585b9,0xfc3f00f7,0x25a001e4,0x24803717}},	//   _zást, _tsín_, seil_, ruim_,
   {{0xdb0a8980,0x764509c4,0x7c3c3718,0x1bf683de}},	//   _cafè, _guhy, _virr, נצער_,
   {{0x00e69508,0x7cda01a9,0xaa570290,0x067b03de}},	//   лжен, _pārā, النا_, _אנטל,
   {{0xb4cd8076,0x66043719,0xd9178160,0x7c3c01b9}},	//   रहो_, mnik, льш_, _tirr,
   {{0x6604371a,0x6281b71b,0x63a182a5,0xeeaa8e8e}},	//   lnik, kulo, jeln, етик_,
   {{0x63a1b71c,0x69dd0009,0xdb01816d,0x656615bd}},	//   deln, ykse, ndlä, _kekh,
   {{0x443c90af,0x5c749537,0x6604371d,0x6e3d02a3}},	//   _siv_, алит, nnik, _xisb,
   {{0x69c08511,0x443c81c5,0xa3e8023c,0x600a8ae7}},	//   _inme, _piv_, _बता_, _знам_,
   {{0xda7ab71e,0x644601d3,0x644fa363,0x61e4371f}},	//   ням_, _muki, ícia, _alil,
   {{0xd00f803f,0x66043065,0x443cb720,0x64463721}},	//   _علم_, knik, _viv_, _luki,
   {{0x69dd0364,0x15469445,0xa01b0009,0xe1350198}},	//   ukse, _седм, ytös, инны,
   {{0x20030024,0x443c81c5,0x644604b9,0x5c568139}},	//   tnji_, _tiv_, _nuki, _стеф,
   {{0x6281b722,0x53348adb,0x7d1d3723,0x3cff0110}},	//   bulo, _келт, _ryss, _žuvo_,
   {{0x6281b724,0xd5bb3725,0x64463726,0x9f3500e8}},	//   culo, нса_, _auki, реві,
   {{0x20030052,0x5d551182,0x7d1d1a50,0x660407f6}},	//   snji_, ркат, _pyss, gnik,
   {{0xd37b1860,0x6e3d03ab,0xf99000f7,0x8f55003d}},	// [23f0] ече_, _visb, _ربي_, _پنجش,
   {{0x69c0b727,0x644604b9,0x6d4d3728,0x926b2133}},	//   _anme, _duki, scaa, ерда_,
   {{0x66040db7,0xdb038e93,0x63ae0282,0x973c990f}},	//   bnik, _kaná, _dabn, _kaću,
   {{0xdb0ab729,0x6d42801c,0x5fc32bef,0x629c372a}},	//   _café, _ngoa, शावल, _dpro,
   {{0x79c989a7,0x60168087,0x601f8187,0x644600b4}},	//   _یوسف_, tâmp, lêmi, _guki,
   {{0x629c002a,0x3d18800f,0x69c0b72b,0x244981fa}},	//   _fpro, _पड़े_, _enme, _rúm_,
   {{0x6d5b8201,0x64460267,0xd3440019,0x0f5801c6}},	//   tbua, _zuki, _اہمی, ניהם_,
   {{0x660d8353,0x9f580168,0x78a9822c,0x9f4100e1}},	//   čako, tirë_, _tsev, _dlhé_,
   {{0x63a1b72c,0x6d5bb72d,0xa787815b,0x78a9b72e}},	//   teln, rbua, _مشاو, _usev,
   {{0x6281b72f,0xdb18840e,0x66043730,0x6619861b}},	//   tulo, _enví, znik, _wkwk,
   {{0x4fc4a344,0xdb038c83,0x212900b9,0x3b098ae7}},	//   _уста, _baná, _azah_, тено_,
   {{0x63a1b731,0x66040085,0xd9f780d4,0x601f8187}},	//   seln, xnik, ूचित_, dêmi,
   {{0x7dd8000d,0x63a1b732,0x628182e8,0x3d04009a}},	//   _míst, peln, sulo, _रखें_,
   {{0x66040063,0x64462fc0,0x7dd8026f,0xdb0380f7}},	//   wnik, _ruki, _líst, _eaná,
   {{0x316b0063,0x09e62e7b,0x656600b9,0xdb070144}},	//   bacz_, _войн, _pekh, _bají,
   {{0xe9df01ac,0x260b897d,0x290d8118,0xdb038216}},	//   ckú_, ावटी_, _oxea_, _ganá,

   {{0xab66045d,0xf1bf0c83,0xa01b1e2b,0xddd880d2}},	// [2400] ивал, rmát_, rtör, nuvš,
   {{0x66040668,0x6446042b,0x629c01b9,0x68200019}},	//   snik, _vuki, _ppro, ködi,
   {{0x66043733,0x65660101,0xb1468dc0,0x877b025f}},	//   pnik, _tekh, анел, _באיי,
   {{0x20183734,0x64463735,0xfc48801c,0x2d9606f1}},	//   lori_, _tuki, _lửa_, _трос,
   {{0x4fc691b3,0x629c009a,0x67450177,0x9f513736}},	//   иска, _wpro, _átjá, lizá_,
   {{0xdb07000d,0x20183737,0xfc48801c,0x63bb00fc}},	//   _zají, nori_, _nửa_, _ɗunk,
   {{0x46678fe6,0x7ddc80e7,0xb76580e8,0xa5f888ed}},	//   арым_, _hési, стій, леку_,
   {{0xd5b79fc8,0x20180114,0x9fa3808b,0x7dd58333}},	//   ась_, hori_, síðu_, _básq,
   {{0xad9b007b,0x644000e7,0x22478144,0x5f16b738}},	//   _sjúk, _émis, _aunk_, _पुर्_,
   {{0xfc488028,0x20180ff5,0x6609005c,0x60e8880a}},	//   _cửa_, jori_, čeki, ırmı,
   {{0xb4db0028,0x20183739,0x91fd00eb,0xa6ca80f7}},	//   _ngàn, dori_, ksāt, _جوال_,
   {{0x7dd807d0,0xd49ab73a,0xdb1c0fba,0x05838d9e}},	//   _míss, _арк_, _horó, _душм,
   {{0xfbcf87d2,0x7648b73b,0x245481ad,0x291f81c0}},	//   ستی_, _hudy, _انتس, _xyua_,
   {{0xb7f88aed,0xd7fb0a3d,0x7a2382f1,0xe9df01d6}},	//   ्चिम_, тум_, võtm, skú_,
   {{0xdb038019,0x62351182,0xdb1c349a,0x5f1a0fb2}},	//   _taná, _леку, _moró, _मुद्_,
   {{0x3c2b83ba,0xdb188580,0x5d78062c,0x2367b73c}},	//   røve_, _invà, ийся_, _zenj_,
   {{0x20180503,0x22a80214,0x44210f3e,0x409500f7}},	// [2410] bori_, _aşk_, tlh_, _الخر,
   {{0x7ddc82be,0x3a3f808e,0x2018373d,0xdb0e003d}},	//   _dési, _siup_, cori_, _kabè,
   {{0x24848122,0xa5bb01a8,0x442989ab,0x3a2d8129}},	//   humm_, _bhót, _ɗa_, _phep_,
   {{0x29d78380,0x32191122,0xf54f019d,0xe1f0ab7e}},	//   _açar_, nosy_, _rụwa_, وسن_,
   {{0x7dd812ca,0xdce28088,0xe80e03b7,0x245d026b}},	//   _víst, _beoč, _सदमा_, _dámò_,
   {{0xf77185ff,0x656d373e,0xab8411b3,0x7648809a}},	//   سات_, laah, _муск, _budy,
   {{0x3a3f8359,0x212981ac,0xfc4880ff,0x61fd373f}},	//   _tiup_, ťah_, _rửa_, kisl,
   {{0xfc488028,0x61fd3740,0x798d0069,0x644fb741}},	//   _sửa_, jisl, _ncaw, ício,
   {{0x442e8267,0x628515d0,0x20183742,0x22400074}},	//   _bhf_, luho, yori_, _riik_,
   {{0x53c982de,0x63a502d4,0x656d3743,0x7dd58216}},	//   угом_, nehn, haah, _vásq,
   {{0xa96a013a,0x216a17c8,0xae7880e8,0x656d3744}},	//   лина_, лини_, _всіх_, kaah,
   {{0xdb038073,0x656d0079,0x442e807b,0x6fdd8036}},	//   _lanç, jaah, _ehf_, _sèch,
   {{0xeb9998a0,0x63c281d0,0x799bb745,0x91ba81c6}},	//   _бил_, ávní, _mbuw, אמרי,
   {{0x7ddc82be,0xd91a8039,0xb4e39344,0x7648808e}},	//   _rési, רושל, ननी_, _yudy,
   {{0x799bb746,0x20183747,0x6729000d,0xe2998162}},	//   _obuw, rori_, řejn, _сай_,
   {{0xfbdf001c,0xbb3a80be,0x7ddca848,0xa2c4852a}},	//   _quên_, _געצי, _pési, िमर्,
   {{0xbddb00e7,0xfd6481bc,0x7bd50214,0xdb18b748}},	// [2420] _sièc, _agwụ, _bozu, _invá,
   {{0xbddb03d3,0xdb0391dd,0xdb0e3749,0x9f860cf9}},	//   _pièc, _canç, _habé, _угод,
   {{0xfe721168,0xb87b0065,0xe5a6134e,0x69c41254}},	//   _عدد_, szít, _лини, _knie,
   {{0x69d6374a,0xed360162,0xc8b50065,0x3eb809d1}},	//   _joye, _гэгэ, _الیک, mvrt_,
   {{0x69d602be,0x7bc3838a,0xdb1c374b,0x69c4009a}},	//   _moye, _onnu, _poró, _mnie,
   {{0x6e241a5a,0xa09b010f,0x6285374c,0x2bc9374d}},	//   llib, ריסט, buho, राणा,
   {{0x2291b74e,0x3eb8007a,0x78bb8144,0x7ddc87f1}},	//   ják_, nvrt_, _eruv, _mésv,
   {{0x7bc3b74f,0x5454b750,0x61fd04c3,0xfbc90ebf}},	//   _annu, овит, xisl, राथम,
   {{0x61fd003e,0xdce28267,0xf1c3801b,0x61e28e3a}},	//   visl, _teoč, šší_, mkol,
   {{0xb274b751,0x248001a8,0xf54f01bc,0xd4978a14}},	//   олош, irim_, _hụta_, ёры_,
   {{0x61fd0038,0x24803752,0x441b00be,0x69d63753}},	//   tisl, hrim_, רויס, _boye,
   {{0x14c83754,0x7bc3b755,0x61e2b756,0xd46a80a9}},	//   रमाण, _ennu, nkol, _биде_,
   {{0xdca3b714,0xf54f0135,0xdce60609,0x682d81d6}},	//   _наци, _mụta_, _dekċ, súde,
   {{0xdb018019,0x656d0870,0xd7f810bc,0xb8d11664}},	//   zelé, waah, бус_, _ऐन_,
   {{0x61e2b757,0x7bd5185c,0xdb0a8247,0xf40000ab}},	//   kkol, _rozu, _enfò, ্তার_,
   {{0x6e243758,0xbcfb0019,0x9f47816b,0x78ad3759}},	//   glib, _idéz, diný_, _tsav,
   {{0x63a5375a,0x656d02a3,0x7bd50085,0xdb018019}},	// [2430] tehn, raah, _pozu, velé,
   {{0xe1ff1362,0xa5bb01a8,0x6285375b,0xdb1c2509}},	//   lió_, _chór, tuho, _enrí,
   {{0xa6ab0b76,0xe7c7809a,0xdb018019,0x7bd50267}},	//   _صادق_, लासप, telé, _vozu,
   {{0xe1ff07e2,0x201eb75c,0x78bbb75d,0x61e2a476}},	//   nió_, _akti_, _pruv, gkol,
   {{0x7bd51ccc,0xdb018019,0x3ea1008e,0xb97c03c8}},	//   _tozu, relé, _hpht_, רנדי,
   {{0xf2e7119d,0x66090289,0x7e55988f,0x22918061}},	//   _любо, čeku, отиц, yák_,
   {{0xb7dc00be,0xdb0187bc,0xdddc0b80,0x7ddc810c}},	//   רקוי, pelé, lurš, _lésu,
   {{0x649982a4,0x2291a8e5,0xec79b408,0x91a90129}},	//   атор_, vák_, апи_, _nhà_,
   {{0xe1ff375e,0xb4e3809a,0x61fbb75f,0x13e9b760}},	//   dió_, नने_, _imul, имий_,
   {{0x69c43761,0x69d600e7,0x2291a792,0xdb0e3762}},	//   _snie, _soye, ták_, _sabé,
   {{0xd5ae8077,0xab298470,0xe299911c,0x645bb27d}},	//   رفی_, рона_, шан_, spui,
   {{0x5ed280c8,0xe1ff3763,0xbba60540,0x27fa0101}},	//   _থেকে, gió_, _ऑस्क, _smpn_,
   {{0x69d63764,0x9f45b765,0x776e011c,0x2291a792}},	//   _voye, _allé_, tabx, sák_,
   {{0xa2e58193,0x3eb8025b,0x61e9802a,0x61e2b766}},	//   _молд, tvrt_, _llel, zkol,
   {{0x61fb8c56,0xe1ff00ab,0xdb1c0125,0x7f430e86}},	//   _omul, bió_, _norð, держ,
   {{0xe1ff3767,0x6609b768,0x644b8578,0x69c40905}},	//   ció_, nnek, _kugi, _unie,
   {{0x656bb769,0xb87b0065,0x6e240057,0x644b81a1}},	// [2440] _megh, szír, rlib, _jugi,
   {{0x9f580013,0xdb070065,0x644bb76a,0x61fbb76b}},	//   oirí_, _sajá, _mugi, _amul,
   {{0x44258224,0x9d460256,0x661ba3e4,0xf54f0135}},	//   ill_, _менд, kouk, _pụta_,
   {{0xa9268381,0x661b8198,0x2480376c,0x660981a1}},	//   одел, jouk, prim_, jnek,
   {{0x61e2b76d,0x7642810c,0x9f5c936f,0xdce60af8}},	//   rkol, _rioy, livé_, _kekč,
   {{0x61e98135,0x6609811b,0x2d9d838a,0x6443b76e}},	//   _elel, enek, _abwe_, _nini,
   {{0x644b8110,0x98a38084,0xfe6fa1df,0x656b80e5}},	//   _augi, _ąją_, ندي_, _begh,
   {{0x9343035f,0x644bb76f,0x6443b770,0x4425b771}},	//   _інте, _bugi, _aini, ell_,
   {{0x6443b772,0x656bb773,0xe1ff06a5,0x644bb2a3}},	//   _bini, _degh, vió_, _cugi,
   {{0x7ddc83d3,0x644b811f,0x6443b774,0xa2f480e8}},	//   _résu, _dugi, _cini, зпоч,
   {{0xe1ff05a4,0x661bb775,0xe3b88214,0x3eb88061}},	//   tió_, bouk, llık_, _ért_,
   {{0x201c89cf,0x644bb776,0x644391e6,0x81e30264}},	//   lovi_, _fugi, _eini, ফোন_,
   {{0xe1ff05a4,0xa92b10ac,0xe3b88214,0x64439e68}},	//   rió_, ріне_, nlık_, _fini,
   {{0xbebc8341,0xe1ff07e2,0x6443b777,0x3a203778}},	//   _dzīv, sió_, _gini, _ekip_,
   {{0x3dc68051,0x23c9064a,0x3a26b779,0x356b0abe}},	//   _know_, रासद, klop_, иран_,
   {{0x63a8b77a,0x7a120029,0x644b8358,0x6443b77b}},	//   ledn, tāte, _yugi, _zini,
   {{0x628880ab,0x34940009,0x7dd80661,0x25d78e82}},	// [2450] ludo, матр, _vísp, קומן_,
   {{0xa2be86bf,0x61fbb77c,0x60c00366,0x9f3501b5}},	//   षिप्, _smul, æmme, _непі,
   {{0x201c803a,0x62888301,0x7afc80f7,0x7ddc82df}},	//   dovi_, nudo, úrth, _jéss,
   {{0x7bd8b77d,0xdb188106,0x386900fc,0x6600928a}},	//   _lovu, _invä, _kwar_, jimk,
   {{0x4425b77e,0x998d81ac,0x201c8390,0xf7f4003d}},	//   yll_, _tiež_, fovi_, _رسید,
   {{0x63a8807d,0x201c812b,0xa2a6000f,0x644bb77f}},	//   jedn, govi_, _टैक्, _rugi,
   {{0xfbd20051,0x644bb780,0x661bb781,0x656b80b9}},	//   _אתם_, _sugi, touk, _pegh,
   {{0x2bc91344,0x25a90014,0x63b51286,0x644bb648}},	//   रावा, neal_, _hazn, _pugi,
   {{0x6443b782,0x201c8024,0x24893783,0x321d8035}},	//   _pini, bovi_, nuam_, mowy_,
   {{0x656bb784,0x644381f6,0x25a910eb,0x321d8035}},	//   _wegh, _qini, heal_, lowy_,
   {{0x316db785,0x7bd8b786,0x63b5139c,0x386904b9}},	//   _keez_, _dovu, _mazn, _awar_,
   {{0x63b500d2,0x644bb787,0x3d959445,0x321d8035}},	//   _lazn, _tugi, _хидр, nowy_,
   {{0xdb189918,0x64439e82,0x63a882ee,0x25a93788}},	//   _anvä, _tini, bedn, deal_,
   {{0x386901cd,0x628889a4,0x9f5cb789,0x2a67841c}},	//   _dwar_, budo, tivé_, _twnb_,
   {{0xf1bf0013,0xfaa28698,0x62888c52,0xe7f38006}},	//   mlán_, _защо, cudo, _अतना_,
   {{0x201c8024,0x7bc72323,0x25a9378a,0xceb282f6}},	//   zovi_, _anju, geal_, עין_,
   {{0xdca30993,0x321d809a,0x248903ac,0x64a3017d}},	// [2460] нати, dowy_, guam_, ната,
   {{0xa097010f,0x66008850,0xdb1c0338,0x32021e1e}},	//   _צדיק_, zimk, _morö, liky_,
   {{0x201c8052,0x386902af,0xdce08289,0x3ce60a21}},	//   vovi_, _zwar_, pamć, šov_,
   {{0x3202026f,0x63a8809a,0x8c460198,0xaca40133}},	//   niky_, zedn, _неме, _ahụr,
   {{0xd7c78e1a,0x25d7093f,0xe89497d4,0x63b5378b}},	//   लांच, _זוכן_, фаль, _fazn,
   {{0xdb0e040e,0xdb0a80f2,0x63b521a2,0x7416015b}},	//   _habí, _infö, _gazn, _روزا,
   {{0xcfb600ab,0x3a2681bf,0xfbc90c1c,0x76460c2e}},	//   ঞাপন, plop_, रारम, _kiky,
   {{0xf64f803d,0xdb0380e1,0x7646008e,0xceb301c6}},	//   دئو_, _fanú, _jiky, תיה_,
   {{0x7bd8803b,0x201c803b,0x66008877,0xdb088187}},	//   _povu, povi_, rimk, cedê,
   {{0x6288b78c,0x9f4781e8,0x7ddc8187,0xb05b0106}},	//   tudo, sinò_, _péss, lväg,
   {{0x63a8b78d,0xa75b8039,0x61358019,0x3202016b}},	//   redn, _הדבר, pülé, fiky_,
   {{0xdb0e03bb,0x6288806a,0xddcb026c,0x80b38035}},	//   _nabí, rudo, _žiža, _इनमे,
   {{0x68e2b4c2,0x7bd8b78e,0x2fda0473,0x7a2382f1}},	//   nyod, _tovu, _bopg_, mõtt,
   {{0x3f8eb78f,0xf1bf3790,0xa01b0061,0xd7f80087}},	//   ngfu_, clán_, ltöz, пус_,
   {{0x752f0d38,0xa3b58592,0x25a90c41,0x245280ff}},	//   _szcz, _चोट_, teal_, _hâm_,
   {{0x63b5003b,0xe3b882bb,0x6564177c,0x6a1501b5}},	//   _sazn, ldı_, gbih, _імпу,
   {{0x61ed3791,0xb4e73792,0x67ef813c,0x9f582f10}},	// [2470] _ilal, बने_, _høje, birà_,
   {{0xe3b882bb,0x25a93793,0x67250009,0x68e2b794}},	//   ndı_, seal_, _tyhj, dyod,
   {{0x98b90459,0x63b500d2,0x25a91c1d,0x24890069}},	//   ması_, _vazn, peal_, suam_,
   {{0x7a3f1482,0x9f580207,0x62970102,0x22950687}},	//   _būti, mirá_, rtxo, råk_,
   {{0x656f031d,0x248907b6,0x321db795,0x7a1200eb}},	//   _iech, quam_, rowy_, nāta,
   {{0xb8d585e8,0x656f3796,0x7bc70573,0x98b9080a}},	//   _जन_, _hech, _unju, nası_,
   {{0x656f3797,0xdce600eb,0x9f581e00,0x60c0b798}},	//   _kech, _iekā, nirá_, _ermm,
   {{0x644f0587,0x660d3799,0x20031ec1,0x6447379a}},	//   _kuci, nnak, hiji_, _hiji,
   {{0x98b90182,0x6447379b,0xf1bf0e1b,0xdcfd0457}},	//   kası_, _kiji, tlán_, _kası,
   {{0x656f379c,0x61ed2b3e,0x2003379d,0x6447379e}},	//   _lech, _alal, jiji_, _jiji,
   {{0x3202026f,0x6447071d,0xdb088722,0x26c101c5}},	//   tiky_, _miji, nedè, _nrho_,
   {{0x656f0775,0x471a893f,0x645d01c2,0x69db83d3}},	//   _nech, _וועג, _otsi, _joue,
   {{0x25098288,0x660d00ce,0x645d10af,0x69db9e9e}},	//   _برای_, dnak, _ntsi, _moue,
   {{0xdcfd07d9,0xdb0e0d76,0x69dbacf0,0xdce600eb}},	//   _nası, _sabí, _loue, _nekā,
   {{0x645d0a8e,0x656f379f,0x9f5837a0,0x69c9b7a1}},	//   _atsi, _bech, rirà_, _onee,
   {{0x660d37a2,0x644737a3,0x656f1f1c,0xdb0a81a8}},	//   gnak, _aiji, _cech, _uafá,
   {{0x20030d11,0x644f0698,0x656f37a4,0x644737a5}},	// [2480] biji_, _cuci, _dech, _biji,
   {{0x644f37a6,0x9f459ec4,0x9f5805e4,0x656404e6}},	//   _duci, _allí_, birá_, sbih,
   {{0x6d598c0b,0xe2971a8f,0x656f03aa,0x644737a7}},	//   _ofwa, дах_, _fech, _diji,
   {{0x6d4b8854,0xa96789a0,0x644f047f,0x79a38992}},	//   _ngga, дица_, _fuci, врше,
   {{0x660437a8,0x7a238074,0xd6cf803d,0x644737a9}},	//   miik, võtt, یقه_, _fiji,
   {{0x66040ef6,0x6d4bb7aa,0xb05b016d,0x68e2b7ab}},	//   liik, _agga, sväg, ryod,
   {{0x644f04b9,0x656f37ac,0x2452b7ad,0x7a2382f1}},	//   _zuci, _yech, _sâm_, tõtt,
   {{0x98b90059,0x7bdc0079,0xc8838214,0x1dc58b84}},	//   zası_, _horu, üğü_, वागत,
   {{0x7bdc37ae,0x98b90201,0xe3b8811c,0x9f5802df}},	//   _koru, yası_, tdı_, zirá_,
   {{0x61ed0bda,0x88bd809a,0x6d4bb7af,0xc0a98481}},	//   _slal, _myśl, _egga, _عاقل_,
   {{0x200302a5,0xddcb803a,0xe3b882bb,0xdd8f81a1}},	//   viji_, žišt, rdı_, _иш_,
   {{0x24528104,0x7bdc046d,0x7c669459,0x9f58018a}},	//   _tâm_, _loru, _قاتل, virá_,
   {{0x656f37b0,0x60f801bb,0x64c8000f,0x660d01ac}},	//   _rech, дняя_, रमोश, vnak,
   {{0x9f582706,0x656f37b1,0x67ef8366,0xdce0928a}},	//   tirá_, _sech, _tøje, zamě,
   {{0x656f37b2,0xa3d205fb,0x75ea003e,0x98b9017b}},	//   _pech, वान_, _význ, rası_,
   {{0x200302a5,0x6e20b7b3,0x644737b4,0x9f5837b5}},	//   siji_, nomb, _siji, rirá_,
   {{0x656f37b6,0x660d270b,0x25a20748,0x69db80e7}},	// [2490] _vech, rnak, _dbkl_, _roue,
   {{0x7bdc37b7,0xfe710065,0x656f02af,0x644f0bcf}},	//   _coru, _مگر_, _wech, _vuci,
   {{0x7bdc1249,0x6e20b7b8,0x644737b9,0x69dbb7ba}},	//   _doru, komb, _viji, _poue,
   {{0x7bdc0176,0x3e7a8029,0xdb088019,0xdb0e0187}},	//   _eoru, dīt_, gedé, _sabã,
   {{0xa0699a8f,0x18699980,0x645d37bb,0x6e29b7bc}},	//   чала_, чали_, _utsi, vleb,
   {{0x63b88b40,0x7bdc1035,0xdb070722,0x76b3811c}},	//   _navn, _goru, _majú, _həyə,
   {{0xfc488104,0x26c183bb,0xd6d19e95,0x442137bd}},	//   _gửi_, ího_, اقع_, moh_,
   {{0x6e20a578,0x442102d4,0x22988019,0x7bdc0214}},	//   gomb, loh_, dék_, _zoru,
   {{0x7bdc37be,0x6e29b527,0xdb018a21,0x212900b9}},	//   _yoru, rleb, delá, _nyah_,
   {{0xf6e7b7bf,0xa3d20576,0x35d106a7,0x2bd20072}},	//   _оцен, वाय_, हाड़, साया,
   {{0x63b88025,0x21290057,0xdb15026f,0x6e20a0b0}},	//   _davn, _ayah_, _bazé, bomb,
   {{0x61f98afe,0x7bca8365,0x6d4ba475,0x70cb0a43}},	//   _çalı, _enfu, _ugga, ामूल,
   {{0x44211ad4,0x629a8009,0x1c398a14,0x66040198}},	//   koh_, atto, _езды_, viik,
   {{0xcc76810f,0xf1b981a1,0x212937c0,0xdb0e0338}},	//   _טענה_, _laš_, _dyah_, _inbö,
   {{0x44210057,0x5f1a0105,0x660437c1,0x6da61634}},	//   doh_, _मुख्_, tiik, нива,
   {{0x7bdc0afe,0x25ad85f8,0xc1ba00a0,0x22490122}},	//   _soru, neel_, _رابط_, _giak_,
   {{0x7bdc37c2,0x660430c4,0x1de10074,0x76b38085}},	// [24a0] _poru, riik, _नवरत, _dəyə,
   {{0xa09b0158,0x25ad8fb0,0x7bdc0201,0x660437c3}},	//   _צייט, heel_, _qoru, siik,
   {{0xf1b9803a,0x386d810c,0x2bb78076,0x88bd809a}},	//   _baš_, _awer_, _असना, _wyśl,
   {{0x60c406a4,0xd910804e,0x9f5c8118,0x62530372}},	//   _krim, لیز_, riví_, _għom,
   {{0xf1238b88,0x44210458,0x25ad837a,0x9f458722}},	//   льшо, boh_, deel_, _allà_,
   {{0x3e7a8029,0x442137c4,0x65760df6,0xe7c78327}},	//   tīt_, coh_, layh, लागप,
   {{0x44380352,0x63b88805,0x6e20b7c5,0x629a8706}},	//   _ihr_, _ravn, tomb, xtto,
   {{0x3e7a80eb,0x63b88e66,0x32078061,0x2d9237c6}},	//   rīt_, _savn, ényt_, ngye_,
   {{0x3e7a8029,0x248d855a,0x224911d6,0x2cb2031d}},	//   sīt_, guem_, _riak_, nwyd_,
   {{0x22988065,0xa87b8051,0xa01b089c,0xa5bb0032}},	//   ték_, _מאמר, tröm, _akól,
   {{0x60c437c7,0x056682ff,0x44380706,0xda77b7c8}},	//   _arim, _звен, _mhr_, няя_,
   {{0xddea803d,0x60c437c9,0xf8bf016b,0x20010106}},	//   _عرضه_, _brim, tvé_, _smhi_,
   {{0xebe6b2b8,0xf8bf02be,0x442109c4,0x60c4079a}},	//   _подп, uvé_, yoh_, _crim,
   {{0xf8bf00e7,0xdb188168,0x2cb20114,0x44380133}},	//   rvé_, _javë, dwyd_, _nhr_,
   {{0x443e8352,0x60c437ca,0x6e26008e,0x25a00428}},	//   mmt_, _erim, _bkkb, ffil_,
   {{0x7c3e12ca,0x442ca51d,0x60c404dc,0xbcfb0061}},	//   empr, lld_, _frim, _beép,
   {{0x644ab7cb,0x60c40d1a,0x69cd004f,0xe4531ef5}},	// [24b0] _kifi, _grim, _inae, اضر_,
   {{0x7a3637cc,0x1602016f,0x68470032,0x62888037}},	//   ráte, रोबर_, _dédì, ordo,
   {{0xa5f937cd,0x442c808b,0x443837ce,0x8c1b81c6}},	//   _жену_, ild_, _dhr_, לומי,
   {{0x442137cf,0x443e8192,0x644ab7d0,0x225c1517}},	//   soh_, hmt_, _lifi, ívka_,
   {{0x25ad90f4,0x644a803c,0x442110e1,0xed59812b}},	//   veel_, _oifi, poh_, ndže_,
   {{0x9f4585a4,0x442137d1,0x644ab7d2,0x66028314}},	//   _allá_, qoh_, _nifi, _amok,
   {{0xf1a7a451,0x6e2d1793,0x25adb7d3,0xf1b981f4}},	//   _пран, olab, teel_, _taš_,
   {{0x6e2d37d4,0xa91d808d,0x2bc9001b,0x02a28133}},	//   nlab, _adže, राका, _chọọ,
   {{0x8cc4009a,0x6e2d0051,0x628881ca,0x644a80b4}},	//   रियो, ilab, erdo, _bifi,
   {{0xa5bb0125,0x69cd37d5,0x6e2d005d,0x24890187}},	//   _skól, _anae, hlab, iram_,
   {{0xa3d2035a,0x24893752,0x05e10035,0x60c437d6}},	//   वात_, hram_, _नवंब, _srim,
   {{0xd70d83eb,0x442c81ed,0x24890f7c,0xdd1d8162}},	//   िपीठ_, ald_, kram_, _câţi,
   {{0x248937d7,0x644ab15e,0x248db7d8,0x7c218b99}},	//   jram_, _fifi, quem_, polr,
   {{0x2007b64e,0x65698aa2,0x7a38b7d9,0x644a8314}},	//   nini_, lbeh, míte, _gifi,
   {{0xd62a37da,0xa5961bc1,0x91fd00eb,0x6e2d349a}},	//   дове_, кращ, mpān, flab,
   {{0x200780f6,0x6e2d37db,0xa6e9801c,0x6569b7dc}},	//   hini_, glab, _trươ, nbeh,
   {{0x200780f6,0xb9070a49,0x25a037dd,0xa5071628}},	// [24c0] kini_, _যে_, rfil_, вета_,
   {{0xdca32410,0x2007b7de,0x64a30fbf,0x2bd210be}},	//   рафи, jini_, рафа, साधा,
   {{0xee3a0604,0x44278239,0xd259102a,0xeb9737df}},	//   _оно_, _mkn_, еці_, тих_,
   {{0x248902df,0x6d5b81c0,0x656981ed,0x58868a14}},	//   bram_, jcua, jbeh, выка,
   {{0xa3d21370,0x2007b7e0,0x443ea51d,0xdce4012b}},	//   वाद_, fini_, ymt_, obič,
   {{0x2007b7e1,0x44380352,0x656980e1,0x02a281bc}},	//   gini_, _uhr_, ebeh, _shọọ,
   {{0x60090503,0x644ab7e2,0xa3d58aad,0x63bc29de}},	//   nžma, _rifi, हान_, _iarn,
   {{0x44279600,0x644ab7e3,0x6adb00ab,0x531b01c6}},	//   _akn_, _sifi, _যেকো, _חולצ,
   {{0x61e08068,0x41d6000c,0x442789ca,0x229c026f}},	//   _ioml, धानस, _bkn_, lík_,
   {{0x3866b7e4,0x442c8051,0x2bb7816f,0x63bc37e5}},	//   mpor_, uld_, _असणा, _jarn,
   {{0x63bc37e6,0x443ea09b,0x229c03cb,0x764b8065}},	//   _marn, rmt_, ník_, _figy,
   {{0x2489061c,0x61e080b9,0x8b0781d0,0xad9b0032}},	//   yram_, _joml, _skří, _amún,
   {{0x63bc00b9,0x6ba78106,0x442c80b9,0xcdf781c6}},	//   _oarn, ärgå, pld_, _במאי_,
   {{0xdb03b7e7,0x44278118,0x69cd0114,0x61e0b7e8}},	//   _canó, _gkn_, _wnae, _loml,
   {{0x2bb7835a,0xdceb80eb,0x5c37807c,0xdb019647}},	//   _असता, _iegā, _שטוב_, gelä,
   {{0x24892ec0,0x518715da,0x61e0836a,0x229c016b}},	//   tram_, _рука, _noml, dík_,
   {{0x6e2d37e9,0x2007b7ea,0x63bc37eb,0x7bda822c}},	// [24d0] rlab, yini_, _barn, ojtu,
   {{0x31790117,0x248937ec,0xd378809a,0x6e2d37ed}},	//   lasz_, rram_, nać_, slab,
   {{0xf09f01c1,0x16229c4f,0x6e2437ee,0x78a980e1}},	//   ltà_, मवार_, boib, _spev,
   {{0xd378b7ef,0xf6500117,0xf1bf0032,0xa5f902de}},	//   hać_, _گئی_, ndá_, _чему_,
   {{0xd378809a,0xf09f3340,0x3c398036,0x61e081d0}},	//   kać_, ntà_, lève_, _doml,
   {{0xe73989e0,0xb4df016f,0xf09f3340,0x1e95b7f0}},	//   нел_, तही_, ità_, грир,
   {{0x2007b7f1,0xed599641,0xd3788063,0x9f5105a4}},	//   rini_, ной_, dać_, lizó_,
   {{0x2007b7f2,0x26c5803a,0xe8d9082e,0xe3b88085}},	//   sini_, _vrlo_, _afọ_, dlıq_,
   {{0xdd118182,0x2007b28f,0xdd918065,0x9f5101ca}},	//   _düşm, pini_, لوں_, nizó_,
   {{0x7a3896a5,0x3a292c8d,0x7c25016b,0x2007b7f3}},	//   ríte, _akap_, nohr, qini_,
   {{0x81b68a49,0x420a1056,0x224d81e2,0xf09f0098}},	//   জার_, енно_, _kiek_, età_,
   {{0x3a2900b9,0xdb088333,0x6ec08651,0x75ea01d0}},	//   _ckap_, cedí, विरु, _výzk,
   {{0x22478400,0x4427b7f4,0x229c016b,0x66099c11}},	//   ínky_, _tkn_, zík_, miek,
   {{0x660985d7,0x25bdb7f5,0x224db7f6,0xdb01b7f7}},	//   liek, _hawl_, _liek_, telä,
   {{0x4425b7f8,0x98a50029,0x249fb7f9,0xd757004e}},	//   mol_, ālā_, ltum_, الفت_,
   {{0x66098341,0x229c0125,0xe1f20077,0x25bfb7fa}},	//   niek, vík_, _دست_, ndul_,
   {{0xfbb788af,0x61e0b286,0x63bc1b40,0xd57505a8}},	// [24e0] _असाम, _roml, _parn, русь,
   {{0x44258355,0x229c37fb,0x61e0b7fc,0x69a021ef}},	//   nol_, tík_, _soml, ग्री,
   {{0xdee60187,0x63bc37fd,0x7f9b0039,0x51869860}},	//   _сони, _varn, _אביז, гула,
   {{0x4425b7fe,0xa3d20ebf,0x200a37ff,0xd3788035}},	//   hol_, वाह_, libi_, zać_,
   {{0x4425b800,0x63bc3801,0x7a1c81d0,0x25bf8326}},	//   kol_, _tarn, jčte, ddul_,
   {{0xb4c20aed,0x2ca00e23,0x4425b802,0x3866b803}},	//   ्मी_, mtid_, jol_, rpor_,
   {{0x2ca02e80,0x4425b7fe,0x3866b804,0x09a980c8}},	//   ltid_, dol_, spor_, ওয়া,
   {{0xd3788d38,0x200a03bf,0xb05b016d,0xa3d2056b}},	//   wać_, hibi_, dvän, वाव_,
   {{0x7ddc8117,0x644e3805,0x200a3806,0x4425831d}},	//   _kész, _kibi, kibi_, fol_,
   {{0x3a2680c9,0x4425b807,0x200a04b9,0x644e21c7}},	//   loop_, gol_, jibi_, _jibi,
   {{0x9e669d85,0x53348764,0xa91d8267,0x6609adc5}},	//   _свед, рент, _idža, biek,
   {{0xf09f0698,0xf2d30158,0xe3b88085,0xd378809a}},	//   ttà_, צער_, rlıq_, sać_,
   {{0x4425b808,0x7984031d,0x3dc00114,0x7d7b83de}},	//   bol_, _ddiw, ddiw_, _טראג,
   {{0x4425b809,0xf09f01c1,0x644e380a,0xc3568698}},	//   col_, rtà_, _nibi, _съдъ,
   {{0x3a268cfa,0xa36f80e1,0xd90f003d,0xf09f380b}},	//   koop_, äčši, تیک_, stà_,
   {{0x2bd290be,0x270e8201,0xb4c20361,0x442a0573}},	//   तावा, _mən_, ्मू_, _akb_,
   {{0x9f4100f1,0xa91d8390,0x200a380c,0x1ae200ab}},	// [24f0] _kohë_, _odža, bibi_, _গেলে_,
   {{0x644e380d,0x320b380e,0x6609b80f,0xbcfb0118}},	//   _cibi, licy_, ziek, _aféc,
   {{0x644e3810,0xddd00214,0xe45f0106,0x9e350391}},	//   _dibi, _çeşi, _grön_, _венч,
   {{0x320b0035,0x4425b811,0xac951f96,0x69d80f12}},	//   nicy_, zol_, _камш, यायी,
   {{0x656d1ad4,0x4425b812,0xa3e5950e,0x2ca00428}},	//   mbah, yol_, _नवल_, ctid_,
   {{0xdceb8087,0xba7712c8,0x656d3813,0x9f518085}},	//   _legă, _مارت, lbah, _özü_,
   {{0x224da338,0x6609b814,0xb3d2035a,0xec360039}},	//   _tiek_, tiek, सारख, _כאשר_,
   {{0x656d3815,0xfbb78063,0x249fb816,0x4425b817}},	//   nbah, _असहम, ttum_, wol_,
   {{0x4425b818,0x25bfb819,0xec768a14,0x20ce808b}},	//   tol_, rdul_, апы_, rðið_,
   {{0xa3ab01b6,0x6609b81a,0x249fb81b,0x60c9b81c}},	//   _कॉम_, siek, rtum_, _irem,
   {{0x249fb81d,0xddc701e2,0xc5d5a1d2,0x216a1d34}},	//   stum_, gpjū, _віль, кини_,
   {{0x4425831d,0xb05b00f2,0x249f808b,0xcfaa80ab}},	//   sol_, rvän, ptum_, _গোপন,
   {{0x69d801ab,0x777702f7,0x7a1200eb,0xb05b0106}},	//   याबी, _bexx, nāti, svän,
   {{0x88bd809a,0x248db81e,0x60c9804f,0x4425b81f}},	//   _wyśw, mrem_, _mrem, qol_,
   {{0x7ddc8117,0x645b9220,0xf74602c7,0x200a3820}},	//   _rész, lqui, рево, ribi_,
   {{0xdd921b9a,0x644e3821,0x06af80ab,0x8e55035f}},	//   تور_, _sibi, কিপি, стрі,
   {{0x7a3614b5,0x9f4780f7,0xa3d2064a,0x248d808e}},	// [2500] láto, ghnú_, वाल_, nrem_,
   {{0x907b0158,0x7bc1b822,0x2ca0005f,0x187b00be}},	//   _שטיי, ndlu, rtid_, _שטיב,
   {{0x2ca03823,0xe29a027e,0x7a360c83,0xdb1503a7}},	//   stid_, тае_, náto, _razã,
   {{0x60c98456,0x7ae31af3,0x50669986,0xb05b016d}},	//   _brem, änta, атка, kväl,
   {{0x270e8085,0xe046af75,0x76440041,0xf8b80074}},	//   _sən_, анди, mmiy, ेटिय,
   {{0x76443824,0x24803825,0x7a360c83,0xdb073826}},	//   lmiy, msim_, káto, _cajó,
   {{0x44443827,0x764402a3,0x60c9b828,0x7a3d282c}},	//   mm_, omiy, _erem, léte,
   {{0x60c98ac6,0xe5c68544,0x806680e8,0x61e43829}},	//   _frem, рско, _вваж, _noil,
   {{0x2bd2800d,0x7a388aae,0x6aa9026c,0x4444382a}},	//   ताला, cíta, _ćefi, om_,
   {{0x4444382b,0x69c2838e,0xdb1c06c0,0x628781b9}},	//   nm_, ldoe, _parè, ġjon,
   {{0x44442404,0x78ad003a,0x78a28a9e,0x4b7b00be}},	//   im_, _spav, ltov, כטיג,
   {{0x61e40083,0x261704b7,0xdca68d91,0x248db82c}},	//   _coil, għol_, _вади, brem_,
   {{0x78a284e8,0xfeb804c0,0x69c0b82d,0xb4c206a7}},	//   ntov, یافت_, _mame, ्मो_,
   {{0x4444382e,0xb4c224bd,0xdb18b82f,0x8c43802e}},	//   jm_, ्मै_, _haví, _дече,
   {{0x69c08012,0x61e41a29,0xc9872707,0x0cb6ab51}},	//   _oame, _foil, _купи, _अनुम,
   {{0x44443830,0x81ab8a49,0x5d550381,0xdb0504b8}},	//   em_, _কোন_, скат, nehå,
   {{0xa3d20006,0x78a2b831,0x78ad026c,0xbddb0036}},	// [2510] वां_, jtov, _upav, _bièr,
   {{0x6380001b,0x656d31a6,0x6fb509a7,0x7a388c83}},	//   vání, sbah, _امدا, víta,
   {{0x60c9b4c1,0xdb1501ac,0x645b8661,0x69c09ea2}},	//   _srem, _bazá, zqui, _bame,
   {{0xb5a73832,0x44443833,0xc9878966,0xdb18801b}},	//   _трой, am_, ружи, _naví,
   {{0x69d8016f,0x7c2880f1,0x7a3603b0,0xb05b0106}},	//   याती, kodr, záto, kväm,
   {{0x645d82ba,0xa3d224bd,0xf1bf002a,0xafe28198}},	//   ísim, वाः_, xoán_, зошл,
   {{0x75ea026f,0x657b820d,0x69c0b834,0x7a38b835}},	//   _výzv, tauh, _fame, síta,
   {{0x660d3836,0x248db837,0x69c0b838,0xff1804de}},	//   niak, trem_, _game, יקות_,
   {{0x32f78085,0xf1bf00e1,0x7c28b839,0x60c9a5f4}},	//   məyə_, hlás_, fodr, _urem,
   {{0x61e42174,0x69c0b83a,0x248db83b,0x660d0102}},	//   _soil, _zame, rrem_, hiak,
   {{0x645bb83c,0x61e4383d,0xdb1c366a,0x69c0b83e}},	//   squi, _poil, _paré, _yame,
   {{0x7a36037d,0x245b8073,0xa06a017c,0xb0c30361}},	//   ráto, _têm_, лама_, शिंग,
   {{0x660d383f,0x61e402be,0x6e298118,0xfd568039}},	//   diak, _voil, moeb, _השני_,
   {{0x7afe3840,0x76aa8201,0x7a3d0019,0x7c28b49a}},	//   yzpt, _həya, véte, codr,
   {{0x670d83bb,0x229580f7,0xe45f0106,0x528581a8}},	//   िपटक_, _العس, _dröm_, _البك,
   {{0x78a2803e,0x4444146a,0x6459b841,0x660d3842}},	//   ytov, wm_, _kuwi, giak,
   {{0x228387d9,0x78a2826f,0x7ae30106,0x146291d3}},	// [2520] lık_, xtov, äntn, _kọọp,
   {{0x444410af,0x69c092cf,0x76443843,0x24803844}},	//   um_, _same, smiy, rsim_,
   {{0x62818422,0x7d090503,0xdcef0029,0x24803845}},	//   nslo, _žest, _vecā, ssim_,
   {{0x44443846,0xe8fa8b79,0x69c09abf,0x6579b847}},	//   sm_, лле_, _qame, _newh,
   {{0x69c2800b,0x17549af1,0x6459b848,0xb3b7b849}},	//   rdoe, овля, _nuwi, _असंख,
   {{0x69c080f6,0x78a2b84a,0xab2a1d85,0x62838503}},	//   _wame, rtov, _бога_, _ovno,
   {{0x78a2b84b,0x69c086c7,0x76aa8085,0xdb18b6fa}},	//   stov, _tame, _bəya, _paví,
   {{0x8a06875a,0x78a2b84c,0x22838214,0x6459820d}},	//   _узбе, ptov, dık_, _buwi,
   {{0x628380d2,0xb87b0019,0x7a388061,0x645989c4}},	//   _avno, nyít, líto, _cuwi,
   {{0x660d384d,0x2cbd82d5,0x27e58326,0x6459b84e}},	//   ziak, _dswd_, _goln_, _duwi,
   {{0x02a39fb4,0xdb050106,0x91bc914f,0x6281a26d}},	//   прям, pehå, _ईसाई, gslo,
   {{0x7f3b8158,0x2240384f,0x224680b9,0x200e811c}},	//   _געבו, _chik_, nmok_, lifi_,
   {{0x25b7803d,0x22401ab3,0x9f4101d6,0xe9df0061}},	//   _دهند_, _dhik_, _dlhý_, rjú_,
   {{0x765a9fc5,0x7bcd84b9,0x26cc81a1,0xe8d9082e}},	//   _kuty, _ɗauk, _krdo_, _ndụ_,
   {{0xa3d583a4,0xa3cc2e2b,0x6b7b83c8,0x4b7b810f}},	//   हार_, _शोध_, _גרונ, _גאוו,
   {{0xe8d901bc,0x765a8c2e,0xf1bf0019,0x75f581d0}},	//   _adụ_, _muty, rlás_, _lázn,
   {{0xc4b681fe,0x660d0695,0xae023850,0x045b00d7}},	// [2530] _अनोख, riak, रोइन_, اجرت_,
   {{0x3a2d81b0,0x60cd018e,0x41a5000c,0x660d3851}},	//   _skep_, _iram, ग्रस, siak,
   {{0x1dc43852,0xbddb06c0,0x660d3853,0x31698333}},	//   _लोकत, _chèc, piak, ñazo_,
   {{0x60cd3854,0x3f9e80e7,0xdb0183ba,0x22469fdb}},	//   _kram, _actu_, relø, gmok_,
   {{0x200e84bb,0x26ccb855,0x777a8580,0xf8c903db}},	//   fifi_, _ardo_, _betx, िटिय,
   {{0x26cc8052,0x765ab856,0x6281b857,0x26c7817f}},	//   _brdo_, _buty, yslo, tvno_,
   {{0x6e29b858,0x7bd53859,0xa91d8267,0xe7398009}},	//   toeb, _inzu, _idžm, шек_,
   {{0x7d0907ca,0xdb0a82af,0x25a91823,0x63b7026f}},	//   _þess, _dafü, nfal_, lexn,
   {{0x38690072,0xa3bd116e,0xa3d58ebf,0x79898176}},	//   _ntar_, _आसा_, हाल_, _idew,
   {{0x7bc50077,0x228387d9,0x98178b8c,0x52a98319}},	//   ndhu, tık_, _ابرا, авом_,
   {{0x60cd385a,0xbf1580f7,0xa3ab03dd,0x28c78424}},	//   _aram, _بواب, क्य_, लिवि,
   {{0x6459b85b,0x75f59c18,0x60cd385c,0x7a3601d0}},	//   _tuwi, _zázn, _bram, mátk,
   {{0x7a36026f,0x316d2509,0x89360bbe,0x62819ff5}},	//   látk, ñeza_, تعدا, sslo,
   {{0x6281b85d,0xcb6980e8,0x6283b85e,0x7a1201a9}},	//   pslo, _таке_, _tvno, vātu,
   {{0x26cc1313,0x7bc3802e,0x60cd385f,0x65c60081}},	//   ído_, _ianu, _eram, обва,
   {{0x60cd3860,0x7bd502af,0x660b80b9,0x7989b861}},	//   _fram, _anzu, _jmgk, _ndew,
   {{0xdca31980,0x69d63862,0x7bc3b863,0x64a30d46}},	// [2540] мати, _inye, _kanu, мата,
   {{0x69c40102,0x38a43864,0x7bc53865,0x7989b866}},	//   _haie, mör_, gdhu, _adew,
   {{0x75f5a5ce,0x7bc39e44,0x2bce035a,0x0576080b}},	//   _názo, _manu, _होणा, _واحد,
   {{0xa3d58e88,0x7bc3b867,0x69c4011b,0x69c63868}},	//   हाँ_, _lanu, _jaie, ndke,
   {{0x79898114,0x2db70039,0x7a388019,0x3ebeb869}},	//   _ddew, _ולכן_, síto, _sstt_,
   {{0x7a38b86a,0x629701df,0x7bc3b86b,0xdb1c06a5}},	//   píto, buxo, _nanu, _harí,
   {{0x81e68a49,0x38a429ed,0x69d6386c,0xf1ca000c}},	//   যোগ_, hör_, _onye, ियान,
   {{0x85f70158,0x2bce2539,0x442e88dc,0x69d601bc}},	//   ַציע_, _होता, _skf_, _nnye,
   {{0xdb1c386d,0xa3d5881f,0x6283026f,0x1da6a0f2}},	//   _marí, हां_, ánov, क्षत,
   {{0x7a360013,0xe9ff8028,0x69d60247,0x60c080fc}},	//   láth, _kiến_, _anye, _ismm,
   {{0x6fde01aa,0x69c40c50,0x386910b6,0xada68196}},	//   मानं, _baie, _star_, _мажл,
   {{0x38a4386e,0x61e2b86f,0x60cd3870,0x7a3601a8}},	//   för_, njol, _pram, náth,
   {{0x38a4016d,0xa3ab00d4,0x7a3d00e7,0x10741273}},	//   gör_, क्ड_, géta, мляю,
   {{0x69d6082e,0x7bc3b871,0x9f45826b,0x248681f4}},	//   _enye, _ganu, _bolè_, _ivom_,
   {{0x226380e1,0x98ac00eb,0x61e283ba,0xdb1c046d}},	//   ľské_, ādā_, kjol, _barí,
   {{0x442cb872,0x2d580153,0xc333812a,0xa5bb026b}},	//   lod_, жить_, _קוק_, _akór,
   {{0x80ba8c28,0x2902009a,0xa8028214,0xdb1c05e4}},	// [2550] _शैले, czka_, şıyo, _darí,
   {{0x69a71094,0x442cb873,0xe9ff8028,0x7bc38079}},	//   ट्री, nod_, _biến_, _xanu,
   {{0x20113874,0xdb1c22d8,0x2c608247,0x7bc53875}},	//   mizi_, _farí, _lòd_, rdhu,
   {{0x24868025,0x5bb783dd,0x20112693,0x442cb876}},	//   _ovom_, _अस्व, lizi_, hod_,
   {{0x442cb877,0x7e6202d4,0x3f69996e,0xead0826b}},	//   kod_, _čopi, било_, _jẹbi_,
   {{0x657d1b64,0xcc76012a,0x20113878,0x442c8682}},	//   _hesh, _מעשה_, nizi_, jod_,
   {{0x657d135e,0xfd4c8028,0x533433e4,0x645d0010}},	//   _kesh, _triể, _жерт, _husi,
   {{0x645d273f,0x657d3879,0x7bc39bb7,0xf0768065}},	//   _kusi, _jesh, _sanu, _کیوں_,
   {{0x7bc3b87a,0x64551d1b,0x442c831d,0x657d387b}},	//   _panu, _kizi, fod_, _mesh,
   {{0x7a361313,0x442cb87c,0x7bc38201,0x1c428d15}},	//   máti, god_, _qanu, нным,
   {{0x69c4387d,0x6455387e,0x7bc3b87f,0x645d3880}},	//   _paie, _mizi, _vanu, _lusi,
   {{0x38a43881,0x61e9a32d,0x3d0f8072,0x273481a8}},	//   tör_, _joel, _तेथे_, súnú_,
   {{0x645d01e2,0x442c831d,0x7bc3b882,0xa01b02af}},	//   _nusi, bod_, _tanu, rsön,
   {{0x76499d5a,0x64553883,0x7a3d3884,0x7fd50d8e}},	//   lmey, _nizi, réta, місі,
   {{0x61fbb885,0x657d3886,0x645d1aea,0x29022448}},	//   _olul, _besh, _ausi, szka_,
   {{0xd90d03f8,0x645d3887,0xe8860b5b,0x661ba645}},	//   ایی_, _busi, _егип, nnuk,
   {{0x64553888,0x657d3889,0xdb0a8125,0xdb1c388a}},	// [2560] _bizi, _desh, _hafð, _varí,
   {{0xf7461fab,0x6b81b88b,0x2d800036,0x7a36041c}},	//   _непо, nalg, saie_, dáti,
   {{0x1dbd863a,0x6455388c,0x6285388d,0x7a388019}},	//   ्यात, _dizi, gsho, sítm,
   {{0x6d59882e,0x442cb88e,0xa3cc0105,0x61e9b88f}},	//   _ngwa, zod_, _शोर_, _coel,
   {{0x61e98b3c,0x442c97ea,0xed52003d,0x6b81b890}},	//   _doel, yod_, _سپس_, kalg,
   {{0x62853891,0xe9ff8028,0x2609800f,0x6d59b892}},	//   bsho, _tiến_, ़ोसी_, _agwa,
   {{0x8c430956,0x24868025,0x04430607,0xe2970ba7}},	//   _чере, _svom_, _черн, _нар_,
   {{0xd49a85f1,0xceb30051,0x442c8428,0x645506a0}},	//   бро_, גיה_, wod_, _zizi,
   {{0x38c883f8,0x442cb893,0x7d043894,0x290280f2}},	//   _بازی_, tod_, nzis, _åka_,
   {{0xe7d700ab,0x7e6d8279,0xcfaa803d,0x6e2d0ece}},	//   _হত্য, ćapr, _دارم_, zoab,
   {{0x764280dd,0x644880eb,0x39402168,0x20113895}},	//   _thoy, rmdi, _azis_, vizi_,
   {{0x24868052,0x442cb896,0x7a38816b,0x61e98118}},	//   _tvom_, sod_, dítk, _xoel,
   {{0x657d3897,0x6b81b898,0x50672b3f,0x20113899}},	//   _resh, balg, ятна, tizi_,
   {{0x645d389a,0x1ae200c8,0x657d389b,0xdb0e0020}},	//   _rusi, _গেছে_, _sesh, _jabó,
   {{0x645d29fb,0xa3e02d19,0x657d389c,0xa3c20e88}},	//   _susi, थान_, _pesh, ्यन_,
   {{0x63bab89d,0x6455389e,0x645d389f,0xa4d500e8}},	//   letn, _sizi, _pusi, мобі,
   {{0x629a98ac,0x657d00f1,0x2718809a,0x61e9910f}},	// [2570] luto, _vesh, धपुर_, _roel,
   {{0x62851ded,0x6455029a,0xf045026a,0x78fc0039}},	//   tsho, _qizi, _تعبی, _לפחו,
   {{0x645538a0,0x3f830025,0x629a90dd,0x2bae816f}},	//   _vizi, maju_, nuto, ज्या,
   {{0x2fc58bc5,0x628538a1,0x645d38a2,0x64551e8f}},	//   _salg_, rsho, _tusi, _wizi,
   {{0x48aba4c8,0x645d0364,0x63bab642,0x61e9838e}},	//   стем_, _uusi, ketn, _voel,
   {{0x63bab8a3,0x629ab8a4,0x7a36016b,0x2ca90106}},	//   jetn, kuto, ráti, mtad_,
   {{0x2ca938a5,0x61e9837a,0x6b81b8a6,0x2fc58257}},	//   ltad_, _toel, valg, _valg_,
   {{0x629ab8a7,0x3f831d96,0x61fbb8a8,0x661b985b}},	//   duto, haju_, _ulul, unuk,
   {{0x3f83003b,0x6b81b8a9,0x2ca938aa,0x76498214}},	//   kaju_, talg, ntad_, rmey,
   {{0x3f830025,0x9f638009,0x798d00a4,0x3e7a80eb}},	//   jaju_, ävät_, _adaw, būt_,
   {{0x3f830289,0x7bc70c9e,0x629ab8ab,0x7a3d026f}},	//   daju_, _maju, guto, rétn,
   {{0x7bc7036e,0x2ca938ac,0x7bd8b8ad,0xa91d81a1}},	//   _laju, ktad_, _envu, _adži,
   {{0xa3c88e18,0xb4bc009a,0xa3c21b7e,0x3ce00118}},	//   _लोक_, _आने_, ्यम_, xxiv_,
   {{0x63ba80d2,0xfd108bbe,0xdb0e002a,0x2d9f841c}},	//   cetn, _حجم_, _xabó, lgue_,
   {{0xe9ff8028,0x67ef806a,0xa3d1109b,0x798d0197}},	//   _nhắn_, _højs, वयन_, _fdaw,
   {{0xa3ab0305,0xee3a0d13,0x51560d5f,0x6009026c}},	//   क्स_, іна_, _отпу, džmu,
   {{0x3f830025,0xd0408201,0xbc6a08ca,0x2ca938ae}},	// [2580] baju_, _ermə, زمان_, gtad_,
   {{0x3f830025,0x60c438af,0x7d0438b0,0xdb1c0722}},	//   caju_, _isim, rzis, _parà,
   {{0xdb1c38b1,0x09e699b8,0x7bc72ad8,0xe9ff801c}},	//   _bará, можн, _daju, _chắn_,
   {{0xdb1c2b72,0xaca40135,0xaca38133,0xdb0e2c6c}},	//   _cará, _akụr, _anọk, _sabó,
   {{0x7a38b8b2,0x307a00be,0xdb0e24a3,0x7bc89113}},	//   níti, קאַנ, _pabó, yddu,
   {{0x60c40010,0x7bc738b3,0x386010eb,0x7a3638b4}},	//   _msim, _gaju, _muir_, mátu,
   {{0xa3c880cf,0xdb1c38b5,0x25adb8b6,0x63bab8b7}},	//   _लोग_, _fará, ffel_, vetn,
   {{0xdb1c037d,0x60c438b8,0x3f8300d2,0x25a038b9}},	//   _gará, _osim, zaju_, ngil_,
   {{0x80a68bca,0x7bc72e22,0x60c438ba,0x063703de}},	//   _زمان, _yaju, _nsim, ונקט_,
   {{0xa3d58ee6,0x427487b6,0xdb1c38bb,0xb05b0192}},	//   हाग_, нгос, _zará, hwäc,
   {{0x3f830025,0x59d00074,0x7bc88c72,0x629a82d5}},	//   vaju_, _तोहर, rddu, uuto,
   {{0x629ab8bc,0x3f8310ab,0x51f80a14,0x27ec80e1}},	//   ruto, waju_, днюю_, _hodn_,
   {{0x38601536,0x3f830025,0x6e2290ab,0xd90f04c0}},	//   _cuir_, taju_, _ijob, شید_,
   {{0x629a8637,0x67ef813c,0x2d84b8bd,0x59dd001b}},	//   puto, _højr, lame_, याहर,
   {{0x3f830025,0x60c438be,0x7bc738bf,0xa01b0338}},	//   raju_, _esim, _raju, lsök,
   {{0x3f830052,0x7c3ab8c0,0x4d7b80be,0x2ca938c1}},	//   saju_, lltr, ַרבע, ttad_,
   {{0x6458b8c2,0x3f830052,0xe81fb8c3,0x7bc7031b}},	// [2590] _kivi, paju_, _बदला_, _paju,
   {{0x2ca938c4,0x2c64016d,0x2d84b8c5,0x59dd016f}},	//   rtad_, _död_, hame_, यावर,
   {{0xa3ab053f,0x6fdd835a,0x3a2fb8c6,0x2ca9180a}},	//   क्ष_, पासू, togp_, stad_,
   {{0x6458b8c7,0xdb260077,0x2d848110,0x7bc70010}},	//   _livi, رونی, jame_, _waju,
   {{0x7bc738c8,0x9f5800f7,0x6d5d0420,0x25ad8106}},	//   _taju, mhrá_, _igsa, vfel_,
   {{0x764d1d5a,0x248938c9,0x07a29182,0xbcfb0032}},	//   lmay, msam_, гашн, _agég,
   {{0x25ad8012,0x49bb8077,0x9f458722,0x82a401a1}},	//   tfel_, _وارد_, _allò_, _иште,
   {{0xcf58004c,0xa3ab09a3,0x2d84b8ca,0x764d03bf}},	//   ובות_, क्र_, game_, nmay,
   {{0x2d9f8333,0xed5982ce,0x248938cb,0x25adb8cc}},	//   rgue_, ježe_, nsam_, rfel_,
   {{0x3ec48364,0x69cb8c4d,0x6e229d36,0x5ba980bf}},	//   ästä_, ldge, _ejob, чком_,
   {{0xa91d807a,0x61ed0087,0x3d0f8035,0x764d02d0}},	//   _deže, _boal, _तेरे_, kmay,
   {{0x61ed38cd,0x69cb84eb,0xc7a90bea,0x25e0816f}},	//   _coal, ndge, _לב_, काणी_,
   {{0xe9ff8104,0x7e61837a,0x69c9808e,0x9f45823e}},	//   _nhận_, _hulp, _maee, _molí_,
   {{0x7a38b8ce,0xb8e8001b,0x2c64016d,0x6e3b9a7f}},	//   ríti, _ईन_, _röd_, llub,
   {{0x6e29016b,0x1da686a7,0xb87b01df,0xf6262ba7}},	//   čebn, क्कत, rxía, едво,
   {{0x60c438cf,0x4423008e,0xa2c300bc,0x91fd01a9}},	//   _tsim, _ajj_, रबन्, spār,
   {{0xdd8f0c48,0x798638d0,0x24891849,0x60c42cc3}},	// [25a0] صول_, makw, gsam_, _usim,
   {{0x61ed0613,0x26c5835f,0x2d84b8d1,0x7aea0106}},	//   _zoal, _oslo_, zame_, äfto,
   {{0x6e3bb8d2,0xdb1c0073,0xeac9877f,0x2bf68158}},	//   klub, _març, _jẹ_, עמען_,
   {{0xeac98028,0x798638d3,0x5fde001b,0x4911852a}},	//   _mẹ_, nakw, मावल, _देहो_,
   {{0x2d8491ba,0xdb1a80f1,0x6b850748,0x27fe82f7}},	//   vame_, tetë, bahg, _pltn_,
   {{0xfaa638d4,0xe7e30035,0xdcc88129,0x290688f1}},	//   _паго, खाया_, _rỉ_, rzoa_,
   {{0x75f8026f,0x4df43281,0x2d84b8d5,0x2d82203d}},	//   _nízk, _इकाई_, tame_, _keke_,
   {{0x6458b8d6,0x63be04c4,0x433b0158,0xc1ca0bb8}},	//   _sivi, lepn, _זעלב, ियोग,
   {{0x2d84b8d7,0x61ed38d8,0xdb1c38d9,0x798638da}},	//   rame_, _roal, _barç, dakw,
   {{0xdee68b9c,0xa01b04b8,0x61ed0812,0xdb1ab8db}},	//   _пози, rsök, _soal, leté,
   {{0x645891b9,0x645d8091,0x629e38dc,0x59dd001b}},	//   _vivi, ísir, nupo, यालर,
   {{0x2d820025,0xdb1a8019,0xf54f0a2c,0xaca48133}},	//   _neke_, neté, _bụla_, _abụz,
   {{0xa3c238dd,0x66040ce1,0xed59811f,0x61ed0493}},	//   ्या_, dhik, teže_, _voal,
   {{0x2bd7823c,0x629e279f,0xa91db8de,0xdb1c360c}},	//   _भोपा, kupo, _idžt, _garç,
   {{0x79862f0b,0x764d03bf,0xed599502,0xf647016c}},	//   bakw, tmay, reže_, ехан,
   {{0xbddb02be,0xe9ff801c,0x7bdc01ec,0x7bca925c}},	//   _thèm, _phận_, _anru, _hafu,
   {{0xdbf98063,0x76aa8201,0x764d38df,0x5d550ae7}},	// [25b0] _głów, _dəyi, rmay, ткат,
   {{0xb60381ac,0x7bca87de,0xdd868061,0xb60680ce}},	//   čšin, _jafu, _ھو_, lešć,
   {{0x7bca822e,0x2489153a,0x764d01cc,0xb05b0338}},	//   _mafu, ssam_, pmay, sväs,
   {{0x660438e0,0x38a9b8e1,0xe9ff80ff,0x7bcab8e2}},	//   chik, túr_, _thận_, _lafu,
   {{0x8fa599b8,0x69cb89ff,0x491180c2,0x28f8804a}},	//   вале, rdge, _देशो_, нець_,
   {{0x7bca819e,0xe7398ce6,0x673a8123,0xe8d9027d}},	//   _nafu, мел_, _bytj, _ngọ_,
   {{0x38a981a8,0xd00eab7e,0x798629f7,0x3d150072}},	//   súr_, تلو_, yakw, _नेते_,
   {{0xa91da35d,0x53340615,0xeac9877f,0xed59a1f6}},	//   _vežb, _сест, _rẹ_, мой_,
   {{0xdb1c03bf,0x6e3b8359,0x7bcaa016,0xf1bf00e1}},	//   _parç, rlub, _bafu, deá_,
   {{0x75f5803e,0x798638e3,0x6e3bb8e4,0x7bca87b6}},	//   _názv, wakw, slub, _cafu,
   {{0xf1dd053e,0x91f581ab,0x798638e5,0xfbd20039}},	//   यांन, _आवाज_, takw, בתי_,
   {{0x22490205,0xa5bb007b,0x3f87b8e6,0xe8d9019d}},	//   _chak_, _sjón, lanu_, _egọ_,
   {{0x2d8238e7,0x7986062b,0xd9e380ab,0x63b50654}},	//   _reke_, rakw, _মতাম, _obzn,
   {{0xdb1a8065,0x35a7800f,0x3dcdb8e8,0x2d8238e9}},	//   zeté, _गाड़, ldew_, _seke_,
   {{0x443338ea,0x2d8238eb,0x660438ec,0xb05b0106}},	//   dox_, _peke_, thik, tvär,
   {{0x6b839755,0x25bf82b1,0xf1bf00f7,0xdb0181ec}},	//   _heng, neul_, ceá_, rflä,
   {{0x2cada543,0x443338ed,0x7bca9d1b,0x6b83b8ee}},	// [25c0] nted_, fox_, _yafu, _keng,
   {{0x395f9e59,0x660438ef,0x389b0158,0x0e6600ae}},	//   _agus_, shik, _קיינ, _икон,
   {{0x6b839dae,0x201838f0,0x3f87b8f1,0x395f8359}},	//   _meng, miri_, danu_, _bgus_,
   {{0x629e38f2,0x201838f3,0xb33c84b7,0x63be02f7}},	//   rupo, liri_, ngħa, sepn,
   {{0x629e38f4,0x25bf82b1,0x2cadb358,0xf1aa0c28}},	//   supo, deul_, jted_, _कानन,
   {{0x9346217e,0x3f87b30d,0xe9ff8028,0xf1e40105}},	//   _анге, ganu_, _phản_, गाड़_,
   {{0xcac702de,0x2ca00fb0,0xa2e338f5,0x1ae30436}},	//   _игре_, luid_, _корд, _корм,
   {{0x645c011e,0x201838f6,0x7c3e1ff5,0x25bfb8f7}},	//   _hiri, hiri_, llpr, geul_,
   {{0x201838f8,0x6b83b8f9,0x443838fa,0x69d3826f}},	//   kiri_, _beng, _kkr_, ádež,
   {{0x69a5035a,0x645c38fb,0x201838fc,0x44382daf}},	//   _काही, _jiri, jiri_, _jkr_,
   {{0x6b839dae,0x201820eb,0xcfa99a3c,0x25bf8a2a}},	//   _deng, diri_, _سالم_, beul_,
   {{0xc333073a,0x7a388510,0x645c38fd,0x7bcaa73f}},	//   יות_, pítu, _liri, _wafu,
   {{0x6b83b6bd,0x2cad8051,0x201838fe,0x7bca8b4a}},	//   _feng, cted_, firi_, _tafu,
   {{0x6b83b8ff,0xdb1703a7,0xaca4082e,0x3eba02f7}},	//   _geng, nexã, _chọr, _bppt_,
   {{0x6602a2ba,0xbe881d51,0x6d460102,0x7a3d0036}},	//   _klok, ксте_, _azka, héti,
   {{0x443eb900,0x645c3901,0x3f878024,0xa91db8b7}},	//   llt_, _airi, zanu_, _leža,
   {{0x645c3902,0x20180542,0x73d9221f,0x6b838d4e}},	// [25d0] _biri, biri_, ндар_, _yeng,
   {{0x33740b01,0xaca40133,0x46ac06a7,0x25bf8087}},	//   игур, _ghọr, _चहचह, zeul_,
   {{0x443eb903,0x6602b904,0x3f87b905,0x7d09847f}},	//   ilt_, _olok, vanu_, zzes,
   {{0x443e82af,0x645c3906,0xa2940d8e,0x3f87b907}},	//   hlt_, _eiri, раці, wanu_,
   {{0x69349d85,0x3f878a3b,0xa91db908,0xe1348110}},	//   анцу, tanu_, _beža, анцы,
   {{0x645c3909,0x660292bf,0x13a7015b,0x2fde8118}},	//   _giri, _alok, _جنسی_, _cntg_,
   {{0x6b83b90a,0x7a388065,0x6b888144,0x2be00f97}},	//   _reng, gíts, dadg, नारा,
   {{0x6b83a4ff,0x2018390b,0x656d355e,0x9d458b79}},	//   _seng, ziri_, ncah, лейд,
   {{0x6b83859c,0x629ab90c,0x765d2ac5,0x89378875}},	//   _peng, erto, _misy, _شعرا,
   {{0x6602b029,0x60c9b90d,0x645c02a3,0x2cadb90e}},	//   _elok, _isem, _xiri, rted_,
   {{0x6602b90f,0x2cadb910,0x6b83b911,0x7d09900b}},	//   _flok, sted_, _veng, szes,
   {{0x6b83b912,0x201837a3,0x3f85b913,0x443eb914}},	//   _weng, wiri_, _helu_, alt_,
   {{0x25e0853f,0x20183915,0x657b903b,0x6b888079}},	//   कारी_, tiri_, mbuh, badg,
   {{0x9d1a8158,0x5ebb00c8,0x60c9b916,0x765d178f}},	//   _אונט, _উপজে, _msem, _aisy,
   {{0x20183917,0x657b82a5,0x7bc18e9a,0x3f85b918}},	//   riri_, obuh, melu, _melu_,
   {{0x645c3919,0x2018391a,0x60c9b91b,0xa3cc0beb}},	//   _siri, siri_, _osem, _शोज_,
   {{0x271f890a,0x20182605,0x765d391c,0x248db91d}},	// [25e0] यपुर_, piri_, _disy, nsem_,
   {{0xdb150118,0x20180168,0xdb08b91e,0x6d4603c1}},	//   _nazó, qiri_, yedü, _vzka,
   {{0x645c391f,0x60c9b920,0xa91d99b7,0x200783ed}},	//   _viri, _asem, _reža, dhni_,
   {{0x7a3d10dd,0x645c3921,0x3f8a3922,0x248db923}},	//   téti, _wiri, labu_, ksem_,
   {{0x645c3924,0x7bc1a5e0,0x3f85b925,0x44383926}},	//   _tiri, kelu, _belu_, _tkr_,
   {{0x3f85b927,0x67d4af84,0x7a3d0866,0x645c051e}},	//   _celu_, року, réti, _uiri,
   {{0x60c9b928,0x7bc1b929,0x3f858b89,0x6602b92a}},	//   _esem, delu, _delu_, _plok,
   {{0x4427826c,0x7bce392b,0x3f8a2813,0x629a80e1}},	//   _ajn_, _habu, habu_, vrto,
   {{0xa91d86c2,0x2fde80dd,0xed59812b,0x7a3881ad}},	//   _teža, _tntg_, teža_, síts,
   {{0x7bc1844e,0x20078b04,0x443eb92c,0x7bce392d}},	//   gelu, chni_, ult_, _jabu,
   {{0x7bce31fe,0xd43700be,0xed59826c,0x81ce0264}},	//   _mabu, רטיי_, reža_, রান_,
   {{0x7bce392e,0x5fe2863a,0x6602922e,0xd7e28072}},	//   _labu, पावल, _ulok, पावच,
   {{0x7bc1a13f,0x78a281e8,0x765d00b9,0x69cf0106}},	//   belu, nuov, _risy, rdce,
   {{0x7bce392f,0xdb1ab930,0xb8ed03e8,0xbcfb0118}},	//   _nabu, letí, _रन_, _ofér,
   {{0x3219096a,0xa91db931,0xf3f90087,0x78a29639}},	//   pisy_, _nežn, _îţi_, huov,
   {{0xe66410f8,0x7bce3932,0x2bc706a7,0x78a2b933}},	//   стро, _aabu, रजभा, kuov,
   {{0x3f8a022e,0x2616108a,0x7bce2ae5,0x69c28bc5}},	// [25f0] babu_, _नगरी_, _babu, deoe,
   {{0x59dd016f,0x26e49d89,0xa91d81ac,0x5d541860}},	//   याकर, _कपूर_, _bežn, скут,
   {{0x753d0063,0xdb152d11,0x7afa8f06,0x63a501a8}},	//   _wysz, _razó, nytt, rghn,
   {{0x3f858067,0x6562836a,0x2614016f,0x7bc1b934}},	//   _selu_, _ngoh, नोदी_, zelu,
   {{0x3f8590ab,0xa3d486ab,0x7afa8d1a,0x2259128a}},	//   _pelu_, हया_, hytt, írky_,
   {{0xb8cd923a,0xb4c101fe,0xa3ac01b6,0xa3c21905}},	//   _कम_, ंबी_, _गाय_, ्यः_,
   {{0x7bc1802e,0x2c6980e1,0x69c29c11,0x3f858609}},	//   velu, _súd_, beoe, _velu_,
   {{0x7bce3935,0x2007b936,0x6b870b80,0x7bc1b937}},	//   _zabu, shni_, _hejg, welu,
   {{0x81ce0a49,0xccf20158,0x7bc1b938,0xb882000d}},	//   রাম_, ַכט_, telu, říze,
   {{0x3ea300f1,0x798bb939,0x1da781ab,0x5e8781e2}},	//   kujt_, lagw, _गावत, _будз,
   {{0x200581b9,0x248db666,0xa72000ab,0x7bc18087}},	//   _illi_, ssem_, _ধর্ম_, relu,
   {{0x186a0c8e,0xdb0529ed,0x7bc1abf2,0xc04903c8}},	//   ками_, behö, selu, _חז_,
   {{0x39490063,0x3f8a393a,0x7d0d0bcf,0x2b158074}},	//   _czas_, tabu_, jzas, _फेरु_,
   {{0x2bd505b3,0x661b8110,0x68e204b7,0x8fa600a9}},	//   _डोला, liuk, _ġodd, јаве,
   {{0x7bce393b,0x539a8039,0x3f8a393c,0xe73a0323}},	//   _rabu, _סיקו, rabu_, тев_,
   {{0x7bce393d,0x3f8a004f,0x75f5816b,0xa91d81f4}},	//   _sabu, sabu_, _zázr, _režn,
   {{0xdca60ba8,0xd46718a0,0x7bce1b4d,0xed5a00a9}},	// [2600] рази, иите_, _pabu, тоа_,
   {{0x9f4c25b3,0x7bce393e,0x4f96393f,0x25ab0609}},	//   ódó_, _qabu, _триу, _eccl_,
   {{0xbf9b012a,0x6441b940,0x213f8748,0x661bb941}},	//   _בייש, illi, _ayuh_, kiuk,
   {{0x7bce0533,0x64a63197,0xbcfb0019,0x2005b942}},	//   _wabu, _кама, _igén, _alli_,
   {{0x7fe9019f,0xe7e29a1c,0xb5fb0118,0x5fe2801b}},	//   _شریف_, पालप, _fiáb, पालल,
   {{0xdb17002a,0x7afa8198,0x224d9fa4,0x26da1502}},	//   sexá, yytt, _ehek_, _krpo_,
   {{0x9e06a3e0,0xddc400eb,0x2900a8c4,0x42d505a8}},	//   ичил, rmiņ, šia_, _літу,
   {{0xa01b2522,0x64418009,0xdef78190,0x88818065}},	//   nsör, elli, рыш_, _کیون,
   {{0xafe6b943,0xa06a8198,0x75fc8176,0x07a69fab}},	//   _коал, _раза_, _jézi, _вазн,
   {{0x34b70051,0xe9ff8104,0xf366a550,0x690883bf}},	//   ספים_, _phần_, штин, ırdı,
   {{0xa3ab1391,0x8aa39fb4,0x6609805d,0x03d7007c}},	//   क्ट_, оряд, bhek, בוים_,
   {{0xf2d30158,0x9f5800f7,0x6609804f,0x6441b853}},	//   קער_, bhrú_, chek, alli,
   {{0x1bd48698,0xc31a00c8,0xbcfb3353,0x7afa8009}},	//   _голя, _তুমি_, _agén, sytt,
   {{0xe9ff8028,0x2005007b,0x9f4c816b,0x331780d7}},	//   _thần_, óli_, _lodí_, ازید_,
   {{0x543980be,0x798b8545,0xf8ae053d,0xc66809a5}},	//   _געװא, yagw, وکی_, иште_,
   {{0x442a3944,0x7a2801cc,0xe9df002a,0x443c80c3}},	//   _ajb_, nıtl, flúe_, _hkv_,
   {{0xf36701f3,0x39490289,0x442a3945,0x201cb307}},	// [2610] атен, _uzas_, _bjb_, kivi_,
   {{0x60cd3946,0x442a0b80,0x81ce00ab,0x224d8168}},	//   _isam, _cjb_, রাণ_, _shek_,
   {{0xb5fb0118,0xa91d81a1,0x2c7d0032,0x931901a8}},	//   _viáb, _pežo, _bádò_, دقاء_,
   {{0x38690748,0xa2d7b947,0x644e0f3e,0xdb019277}},	//   _kuar_, यित्, _ehbi, rflø,
   {{0x98c7917e,0xe9df04c3,0x442a1142,0xe9ff801c}},	//   рсел, clúe_, _fjb_, _nhấn_,
   {{0x38693948,0x25a93949,0x60cd004f,0x7e68810c}},	//   _muar_, lgal_, _msam, _budp,
   {{0x386914ff,0x6609b94a,0xa91d817f,0x2294160e}},	//   _luar_, thek, _težo, _миря,
   {{0xc485b6ab,0x25a9394b,0xf1cf8105,0x5bc711bc}},	//   блик, ngal_, _सोचन, _रघुव,
   {{0x201c811f,0x999f826f,0x386900b9,0xe9ff80ff}},	//   bivi_, _chuť_, _nuar_, _chấn_,
   {{0x75f58feb,0xf09f394c,0x6609b94d,0x2005b94e}},	//   _vázq, drà_, shek, _ulli_,
   {{0xd7f88554,0x60cd394f,0x7c2200e7,0xf09f047f}},	//   _тут_, _asam, éori, erà_,
   {{0xa3de035a,0x60cd00b9,0x7bc50168,0x6441b950}},	//   _दोन_, _bsam, hehu, slli,
   {{0x7bc521ad,0xed4e9da9,0xa3e803db,0x7989b951}},	//   kehu, _хо_, _मचल_, _meew,
   {{0x6d4bb952,0x438580f7,0x183580be,0x7989b953}},	//   _izga, _الثق, מאָל_, _leew,
   {{0x60cd3954,0xa3ab0cf0,0xf09f023e,0x249f9a16}},	//   _esam, क्छ_, arà_, lrum_,
   {{0x25a9015b,0x60dbb955,0x38693956,0x4d66044f}},	//   ggal_, _orum, _fuar_, скав,
   {{0x61e428af,0xe3ba0fbe,0x7a3d007b,0x1b1500ab}},	// [2620] _inil, лба_, rétt, _তুলে_,
   {{0x69c63957,0x25a900f7,0xf1bf00f7,0x7bc53958}},	//   leke, agal_, nnán_, gehu,
   {{0xa3b92cdd,0x60dba60d,0x7a280214,0x59dd06ae}},	//   _अउर_, _arum, yıtl, याचर,
   {{0x61f60901,0xdb1a87f0,0x7a3d3959,0x994a81a8}},	//   _joyl, netá, létr, هلال_,
   {{0x201cb95a,0x2d80063c,0x10a3b95b,0x98a392b2}},	//   tivi_, mbie_, зичн, зиче,
   {{0x60dba37a,0x7644395c,0x7a3d2ad5,0x69c613fa}},	//   _drum, lliy, nétr, heke,
   {{0xfaa32cd1,0x69c6395d,0x201c939a,0x443a056a}},	//   _наро, keke, rivi_, mop_,
   {{0x4444395e,0x60dbb95f,0xa3c20076,0x5c74917f}},	//   ll_, _frum, ्यक_, олит,
   {{0x69c60065,0x8cdb01a2,0x60dbb960,0x2a6a00b9}},	//   deke, नियो, _grum, _hubb_,
   {{0x61e43961,0xda7a8d70,0x44443962,0x443a000b}},	//   _anil, лям_, nl_, nop_,
   {{0x44441dad,0x76443963,0x61f63964,0xdb1a8144}},	//   il_, kliy, _boyl, fetá,
   {{0x69c63965,0x64a6add0,0x444413ac,0xf09f1e06}},	//   geke, _гада, hl_, trà_,
   {{0x443a3966,0x41aa101e,0x63bc0824,0x4444083d}},	//   kop_, _कारस, _obrn, kl_,
   {{0x3e6e000d,0x44443967,0xf09f19bf,0x6e3d00b9}},	//   _být_, jl_, rrà_, _sksb,
   {{0xd5bb17d6,0x69c63968,0x76443969,0xa3d5801b}},	//   лса_, beke, fliy, ाएर_,
   {{0x4444396a,0x60cd396b,0x7c3ab732,0x69c6396c}},	//   el_, _tsam, lotr, ceke,
   {{0x320910ba,0x6fa9816f,0x7bc5396d,0x3f8eb0a0}},	// [2630] _ilay_, _घालू, tehu, kafu_,
   {{0xf367396e,0x4444396f,0x7b671287,0x7c28b970}},	//   стан, gl_, стае, nndr,
   {{0x76443971,0x2ca00074,0xb99592c8,0x2367007a}},	//   bliy, arid_, قلاب, žnjo_,
   {{0xddc1802e,0x80cc00ab,0x7a28011c,0xdb088338}},	//   _mulţ, ামর্, yıtm, bedö,
   {{0x4444031d,0xb05b00e1,0x7bc53972,0x3f8e89ab}},	//   bl_, dväz, pehu, fafu_,
   {{0x69c63973,0x7c3a9c67,0x63bc008e,0x249fb974}},	//   zeke, jotr, _gbrn, vrum_,
   {{0x41aa0f12,0x2d8b0679,0x1dda8105,0x3209007e}},	//   _कालस, _kece_, _मोहत, _olay_,
   {{0xa3e70076,0xf1d9000f,0xd346003d,0x64453975}},	//   भाव_, _बोलन, _بیمه_, llhi,
   {{0x7c3ab976,0xdb1e0087,0x60dbb977,0x69c61104}},	//   fotr, cepâ, _urum, veke,
   {{0x32093978,0x69c63979,0x61e4397a,0x249fb97b}},	//   _alay_, weke, _snil, rrum_,
   {{0x69c6397c,0x2fc7b97d,0x5fae816f,0x26c101c0}},	//   teke, meng_, _घातल, _npho_,
   {{0x2d8b02a5,0x2fc7b97e,0x3ea78722,0xf1bb80d4}},	//   _nece_, leng_, munt_, ोजिन,
   {{0x6e3b8024,0x443a10c1,0x29041ef5,0x660d003d}},	//   moub, yop_, áma_, dhak,
   {{0x69c6397f,0x2fc783f8,0x78a60289,0x290c009a}},	//   seke, neng_, rukv, ąda_,
   {{0x4444006a,0xdb1ab980,0x69c63981,0x764407c0}},	//   vl_, petá, peke, tliy,
   {{0x3d150665,0x2fc7b982,0x2d8b3983,0x660d0ec9}},	//   _नइखे_, heng_, _cece_, ghak,
   {{0x2d8b0eef,0x76440201,0x2fc7b984,0x44442ead}},	// [2640] _dece_, rliy, keng_, tl_,
   {{0x44443985,0x2fc78077,0xa91d82d4,0x41aa03eb}},	//   ul_, jeng_, _težj, _काँस,
   {{0x42ca0071,0x443a3986,0x2fc7b987,0x2d8b047f}},	//   рген_, rop_, deng_, _fece_,
   {{0xa3d58063,0xe0da9935,0x660d3988,0xfce616df}},	//   ाएँ_, иве_, chak, _домо,
   {{0x7e628118,0x7c288558,0x9989136f,0x660403e4}},	//   _riop, yndr, _dlaň_, mkik,
   {{0x2bae9305,0x7e62b989,0x2fc7b98a,0xdc3987c0}},	//   ज्ञा, _siop, geng_, kçıl,
   {{0x491a800d,0x23270098,0xe2970d5f,0x6fad000f}},	//   _मेरो_, _дори_, _мар_, _जासू,
   {{0x16378013,0x7ae10065,0xd5b78987,0xb5fb36fa}},	//   يسية_, _álta, ось_, _lián,
   {{0xa3d58063,0x3f8e84cd,0xf6530039,0x7982a4f2}},	//   ाएं_, pafu_, וצה_, mbow,
   {{0x22400019,0x3ea78176,0x224681b9,0x60cd9b26}},	//   _akik_, bunt_, llok_, çame,
   {{0x32092a92,0xdd8f8279,0xe73a804a,0x66042c6b}},	//   _play_, _ош_, _теж_, kkik,
   {{0x7c3ab98b,0x601000f2,0x80ac0816,0x2246808e}},	//   sotr, _jämf, _जमशे, nlok_,
   {{0x7c3ab98c,0xfbcf87d2,0x2d8b398d,0xd2580a8e}},	//   potr, رتی_, _rece_, юць_,
   {{0x6e20b98e,0x39450029,0xd83b22f0,0xb4d690be}},	//   limb, āls_, рэм_, ाटी_,
   {{0x28d1800c,0x2246b98f,0x660d0c14,0x78a2826c}},	//   _दैनि, klok_, thak, hrov,
   {{0x6e208397,0x2246b990,0xdb1c02af,0xa5bb008b}},	//   nimb, jlok_, _darü, _njót,
   {{0x2d8b0052,0x660d3991,0x31690019,0x78a288ae}},	// [2650] _vece_, rhak, _igaz_, jrov,
   {{0x660d0578,0x6e20b992,0xdb1c3993,0x69bc0f8d}},	//   shak, himb, _naró, ष्ठी,
   {{0x3f913994,0x6e209e45,0xa91d8353,0x660d005d}},	//   mazu_, kimb, _težk, phak,
   {{0x3f91005c,0xdce982ee,0x2fc7b995,0x2a649600}},	//   lazu_, zbeđ, weng_, _cimb_,
   {{0x2fc783f8,0x78a2826f,0xdb1c016a,0xdb150187}},	//   teng_, grov, _baró, _razõ,
   {{0xf77185ff,0xdb1c01df,0xa3da9344,0x7bc88369}},	//   رات_, _caró, _ढोल_, jedu,
   {{0x2fc7b996,0x44210824,0x224693eb,0x63b405b9}},	//   reng_, mih_, blok_, žený,
   {{0x3ea7b997,0x2fc7b998,0xc4859e25,0xed599024}},	//   runt_, seng_, плик, leži_,
   {{0x629c84c3,0x2fc78d6d,0x6e299dcb,0x442e81a1}},	//   áron, peng_, rneb, _bjf_,
   {{0xa91db999,0x3ea7b99a,0xdc39880a,0x7bc8b99b}},	//   _neži, punt_, tçıl, gedu,
   {{0x7bd5399c,0xf8a9010f,0x6e20b99d,0x661d307d}},	//   _mazu, _תש_, bimb, _omsk,
   {{0x44211600,0xdeba8039,0xdb1c0035,0x06c380ab}},	//   hih_, _למעל, _zaró, ্মদি,
   {{0x4421399e,0xfce5b99f,0x3e71b9a0,0xa5bb0125}},	//   kih_, _холо, _hát_, _ljós,
   {{0x442102f7,0xed59b5b2,0x913a80be,0x7bc8b9a1}},	//   jih_, ježi_, מערק, cedu,
   {{0x26de01df,0xa3c10ebf,0x8c3d8214,0xdee334bf}},	//   íto_, ्जन_, nuşm, нори,
   {{0x799b8077,0x3e71801c,0x386d81b0,0x8afa81c6}},	//   _nduw, _mát_, _ouer_, _להצי,
   {{0x3e71b9a2,0x660439a3,0x7bd539a4,0x386d8326}},	// [2660] _lát_, rkik, _bazu, _nuer_,
   {{0x660439a5,0x7bd50012,0x6e20b3cd,0x69d601b4}},	//   skik, _cazu, zimb, _haye,
   {{0x3f8c8805,0xe6460a13,0x38b60e34,0x6e20b9a6}},	//   _redu_, _неоп, lær_, yimb,
   {{0x23720029,0x3f8cb9a7,0x69d6010c,0x7bc8811b}},	//   _šajā_, _sedu_, _jaye, zedu,
   {{0x4421048f,0x69d6298f,0x38b600b2,0x6e208234}},	//   bih_, _maye, nær_, vimb,
   {{0x2d9239a8,0x4421135a,0x25adb9a9,0x3e71b9aa}},	//   laye_, cih_, egel_, _bát_,
   {{0xc0598cde,0x7bc8b9ab,0x3e7180ff,0xdb1c0511}},	//   ції_, vedu, _cát_, _varó,
   {{0x3e71826f,0x78a2b9ac,0x25adb9ad,0x69d61f4b}},	//   _dát_, prov, ggel_, _naye,
   {{0x6e20b9ae,0x7bd50309,0xb4d68744,0xb05b0106}},	//   rimb, _yazu, ाटे_, pväx,
   {{0x6e2081d3,0x798d30b2,0x2d9239af,0x6d4600ee}},	//   simb, _seaw, haye_, _myka,
   {{0x69d639b0,0x600b0201,0x60c439b1,0x26de80e5}},	//   _baye, _nüma, _apim, _urto_,
   {{0x69d639b2,0xa3de10f7,0x38b60e51,0xb05b0865}},	//   _caye, _दोस_, fær_, hwät,
   {{0xb5fb2a63,0x7bc8b9b3,0x2d9239b4,0x5c068098}},	//   _diál, pedu, daye_, _няка,
   {{0xdb1a8009,0xba73803d,0x7c3e026c,0x545380e8}},	//   tetä, بایت, jopr, _звіт,
   {{0x645a8125,0x69c081ac,0x98be00eb,0xdd9b0a42}},	//   mmti, _obme, ātā_, йша_,
   {{0x443eb72f,0x442103f8,0x2d9239b5,0x7e6600b9}},	//   lot_, wih_, gaye_, _cikp,
   {{0x42380bea,0xa91d803a,0xed5980fe,0x200c852a}},	// [2670] _מנהל_, _teži, teži_, _oldi_,
   {{0x443eb9b6,0xf0920bea,0x442cb9b7,0x69c08192}},	//   not_, _שני_, nnd_, _abme,
   {{0x2d9239b8,0x442139b9,0x7bd5002e,0x8c4181ec}},	//   baye_, rih_, _vazu, äßig,
   {{0x442114e5,0xa2a483eb,0x200c89e8,0x661d39ba}},	//   sih_, _किन्, _aldi_, _umsk,
   {{0x443eb9bb,0xddc41010,0x386d8073,0x89378013}},	//   kot_, lmiş, _quer_, أعضا,
   {{0xd3668013,0x443e8029,0x442101a5,0x7642930c}},	//   _له_, jot_, qih_, _akoy,
   {{0x443eb9bc,0x6e2d39bd,0x29021d21,0xddc40457}},	//   dot_, onab, zyka_, nmiş,
   {{0x6e2d02ec,0x6448a023,0x442c9527,0xcfcd80ab}},	//   nnab, eldi, end_, লাইন,
   {{0x62988081,0x442c807b,0x443eb9be,0x4c358084}},	//   _avvo, fnd_, fot_, дэнт,
   {{0x443eb9bf,0x69d9a9d8,0x69d639c0,0x69cbb2c7}},	//   got_, ldwe, _saye, lege,
   {{0x61fbb9c1,0x81d700ab,0xdb1c007b,0x69d612b6}},	//   _koul, সান_, _jarð, _paye,
   {{0x69d9b9c2,0xa3c10076,0x29020063,0x61fb8009}},	//   ndwe, ्जड_, tyka_, _joul,
   {{0x200403a7,0x515539c3,0x6e2d0114,0xaca381bc}},	//   êmio_, етру, dnab, _maịk,
   {{0xb8f61008,0x443eb9c4,0x61fba1bf,0x69d6029b}},	//   _सन_, cot_, _loul, _waye,
   {{0x7c3e007d,0xf7430767,0x7f430009,0x2d9239c5}},	//   vopr, веро, верж, taye_,
   {{0x237801dd,0x6e2d39c6,0x69cbb9c7,0x249900b9}},	//   _sfrj_, gnab, jege, _bvsm_,
   {{0x7c3e39c8,0x2d9239c9,0x69cbb9ca,0x60c425f4}},	// [2680] topr, raye_, dege, _upim,
   {{0x2d8f8c39,0x61e9b9cb,0x2d9239cc,0xa91d81a1}},	//   _lege_, _anel, saye_, _ježu,
   {{0x61fbb9cd,0x76499632,0x320d828d,0x628182d6}},	//   _boul, kley, _bley_, nplo,
   {{0x61fb8809,0x69cb8c1b,0x6b8e0102,0x443eb9ce}},	//   _coul, gege, _webg, zot_,
   {{0x443eb9cf,0x442c807b,0x64488bbd,0x61fbb9d0}},	//   yot_, ynd_, yldi, _doul,
   {{0xd12f9a37,0x6e2439d1,0x656b80e5,0x237802df}},	//   جمه_, liib, _aggh, _ufrj_,
   {{0x443e86d4,0xdb1c007b,0x61fbb9d2,0x2d8fb9d3}},	//   vot_, _garð, _foul, _bege_,
   {{0xceb30051,0xd49a813a,0x3ea0801b,0x442cb9d4}},	//   דיה_, оро_, čit_, wnd_,
   {{0x443eb9d5,0x7d040a40,0x64a383a7,0x2d8fb9d6}},	//   tot_, nyis, вања, _dege_,
   {{0x442c8051,0x61fb8bfe,0xed598654,0x9f5a03ed}},	//   und_, _zoul, ježu_, _copë_,
   {{0x443ea638,0xa3c10054,0x442cb9d7,0x271c8264}},	//   rot_, ्जत_, rnd_, _পুরো_,
   {{0x443eb9d8,0x2d8f90ab,0x20ca0540,0x7d040009}},	//   sot_, _gege_, िबंध, kyis,
   {{0xb4bd1880,0x9cb381a8,0xe8e081bc,0x6e2401b4}},	//   _आहे_, _لمنت, daịs_, diib,
   {{0x36d5146c,0xdb1e0187,0xa29483a9,0x2d8fb9d9}},	//   ногр, cepç, _закі, _zege_,
   {{0x80d5800f,0x69cbb9da,0x683f01d0,0xc5fb0073}},	//   _मैने, yege, vádě, оѓа_,
   {{0xc3338039,0xddc40059,0x7640b9db,0x7bd88bdf}},	//   _שוק_, rmiş, nomy, _havu,
   {{0x61fb9dac,0x69cbb9dc,0x7bd8b9dd,0x54550103}},	// [2690] _roul, vege, _kavu, еват,
   {{0x69cbb9de,0x61e9b9df,0x61fbb9e0,0x2a69022c}},	//   wege, _snel, _soul, _hiab_,
   {{0x69cbb9e1,0x61fbb9e2,0x2a690069,0x7640b9e3}},	//   tege, _poul, _kiab_, komy,
   {{0x7bd8b9e4,0xdb1c007b,0x7640809a,0xe4a70087}},	//   _lavu, _varð, jomy, _орго,
   {{0xf1c1052a,0x61fb82be,0x69d9800b,0x7d16009a}},	//   ष्यन, _voul, rdwe, czys,
   {{0x61fbb624,0x2a6901c5,0x78ab8cfa,0x7bd8ace3}},	//   _woul, _liab_, rugv, _navu,
   {{0x61fba7a7,0x7649b9e5,0x69cbaf5f,0x2007b9e6}},	//   _toul, tley, pege, rkni_,
   {{0xb8d580c8,0x61e9b9e7,0x2a69022c,0x6ec206a7}},	//   _জন_, _unel, _niab_, _लहसु,
   {{0x3e7539e8,0xdd918117,0x7bd8b9e9,0x3949022c}},	//   _låt_, نوں_, _bavu, _nyas_,
   {{0x7649b9ea,0x6281b52e,0x3707a240,0xaf078992}},	//   sley, tplo, _очев, _очек,
   {{0x3e75016d,0x76498ce9,0x7bd8b9eb,0xdbcc9434}},	//   _nåt_, pley, _davu, róðu,
   {{0x2a69022c,0x7afc816d,0xaca38135,0x6e240079}},	//   _ciab_, ärta, _abụk, xiib,
   {{0xa3c1053f,0x7bd8822b,0xed59812b,0x2a690176}},	//   ्जा_, _favu, težu_, _diab_,
   {{0x7bd8b9ec,0x66099dcb,0x39490122,0x3d188035}},	//   _gavu, lkek, _dyas_, _बेटे_,
   {{0x7bc3836e,0x6e2402ec,0x2a690037,0x84648081}},	//   _ibnu, tiib, _fiab_, _ръце,
   {{0x7d040364,0x6441b9ed,0xee3a00e8,0x7bd89acc}},	//   tyis, loli, їна_, _zavu,
   {{0x44259a29,0xdca30e6b,0x7bd882a0,0x64a30f04}},	// [26a0] oil_, лати, _yavu, лата,
   {{0x7d160d38,0xa3e7073c,0x4425b9ee,0x68e439ef}},	//   rzys, भाग_, nil_, _irid,
   {{0xa3b7835a,0x387f9e03,0xad9b39f0,0x68e40140}},	//   _छान_, _atur_, _clús, _hrid,
   {{0x44259882,0xa2d51516,0xaca401bc,0x68e439f1}},	//   hil_, णिज्, _ajụr, _krid,
   {{0x6441b7c2,0x394901c0,0x69c439f2,0xc0e38a41}},	//   koli, _xyas_, _mbie, лоцк,
   {{0x4425ac17,0x2ab88065,0xe8d9001c,0x64418805}},	//   jil_, yéb_, _ngờ_, joli,
   {{0x6441b9f3,0x69c439f4,0x0cd0146d,0xa3e70254}},	//   doli, _obie, _हनुम, _ядра_,
   {{0x6ed38086,0x7bd8b9f5,0x68e4026c,0xe7e080d4}},	//   _xəbə, _savu, _orid, _गोरा_,
   {{0x6441b9f6,0xddde00eb,0xf8d49513,0xdb1e2551}},	//   foli, _atpū, _धनिय, sepä,
   {{0x69c439f7,0x6441b9f8,0x2a6910af,0x600b0059}},	//   _abie, goli, _siab_, _cüml,
   {{0x68e439f9,0xa3b6801b,0x2a6901c0,0xdb1c08f1}},	//   _arid, ङ्ग_, _piab_, _obrí,
   {{0xdc12817b,0xc3330039,0x44258c5e,0x7bd8b9fa}},	//   rşıl, טות_, ail_, _wavu,
   {{0x6e22b9fb,0x68e439fc,0x3d189513,0xc05b00e8}},	//   _imob, _crid, _बेचे_, зів_,
   {{0x4425b9fd,0x6441b9fe,0x20d60efd,0x6ed38201}},	//   cil_, coli, džić_, _səbə,
   {{0x9f34021e,0x68e434c2,0x2a690282,0x80c400ab}},	//   гері, _erid, _tiab_, শিষ্,
   {{0x68e439ff,0xe7e786a7,0x45d4004a,0x44d202d6}},	//   _frid, _टोना_, лосс, _bņ_,
   {{0x629aa187,0x629c0201,0x61ed3a00,0x68e40653}},	// [26b0] lsto, _avro, _inal, _grid,
   {{0x69cf0179,0x69c4219c,0x600b03e3,0xdb01ba01}},	//   lece, _zbie, _kümm, rflö,
   {{0xd0110117,0x61ed3a02,0xdb1a806a,0xc1740041}},	//   _ملک_, _knal, getø, _haɗa_,
   {{0x69cf3a03,0x6441ba04,0xdbd708e5,0x629aba05}},	//   nece, zoli, _sääs, isto,
   {{0x629c3a06,0xdbd703ff,0x44259072,0x6441ba07}},	//   _evro, _pääs, yil_, yoli,
   {{0x63552748,0x44258201,0x44251bc0,0x2ca93a08}},	//   _авгу, xil_, _öl_, mrad_,
   {{0x629a803b,0x25bfba09,0x61ed3a0a,0x4425ba0b}},	//   jsto, tful_, _onal, vil_,
   {{0x62850c63,0x4425ba0c,0x78a48024,0x764d3a0d}},	//   mpho, wil_, šiva, nlay,
   {{0x629a81ac,0x6fb2009a,0x442300b9,0xc1740300}},	//   esto, _जालं, _kmj_, _naɗa_,
   {{0x2367003b,0x62853a0e,0x69db811e,0x629aba0f}},	//   žnju_, opho, _haue, fsto,
   {{0x15b981e5,0x764d07d9,0x68e40140,0x629aba10}},	//   _жылы_, klay, _srid, gsto,
   {{0x68e43a11,0x4425ba12,0xa2c40a74,0xf2d200be}},	//   _prid, sil_, _रहस्, בעט_,
   {{0x4425ba13,0x764d3a14,0x66068019,0x22423a15}},	//   pil_, dlay, ökke, rokk_,
   {{0x60c98133,0x68e40b81,0x7fd50558,0x61ed3a16}},	//   _mpem, _vrid, лісі, _enal,
   {{0x69cf0207,0xa0673a17,0x629aba18,0x80b3864a}},	//   bece, тара_, csto, उंडे,
   {{0x6458820f,0x764d3a19,0x940c0201,0xf1bf0333}},	//   _zhvi, glay, ələr_, lián_,
   {{0x2ca91487,0xdd8f0875,0x05661289,0x8e5500e8}},	// [26c0] grad_, زول_, тван, утрі,
   {{0x61ed0ebf,0x7bc1ba1a,0x6d4b851e,0x62868904}},	//   _znal, nflu, _myga, ćkov,
   {{0xe2970bac,0x3f9804b9,0x69db81ec,0x442300c3}},	//   вах_, maru_, _baue, _dmj_,
   {{0x3ced017f,0x69db9e9e,0xaca38091,0x2ca93a1b}},	//   _ševe_, _caue, _apọj, brad_,
   {{0x69db9919,0xa967951b,0xd7fa8162,0x8c3dba1c}},	//   _daue, вица_, дуй_, luşu,
   {{0xbcfb0065,0x442300ee,0x25daa743,0x9f6580e1}},	//   _egés, _gmj_, _खोजी_, _štát_,
   {{0x48ee8063,0x69cf07d9,0x59dd93ba,0x8c3d82d0}},	//   _आपको_, yece, _नोकर, nuşu,
   {{0x44443a1d,0x7bdc3a1e,0xe5c68895,0x3f983a1f}},	//   lo_, _haru, тско, haru_,
   {{0x2603a70d,0x3f9803c3,0x7bdc3a20,0x629aba21}},	//   _años_, karu_, _karu, wsto,
   {{0x44443a22,0x629a8a10,0x7bdc09ab,0x7bde000b}},	//   no_, tsto, _jaru, ndpu,
   {{0x44443a23,0x6e2281e0,0x60148722,0x81dc00ab}},	//   io_, _tmob, _càme, ঠান_,
   {{0x44443a24,0x7bdc3a25,0x3f933a26,0x7e6b8122}},	//   ho_, _laru, _sexu_, _gigp,
   {{0x44443a27,0x3e78ba28,0x69dd3a29,0xf1bf188b}},	//   ko_, _hét_, rdse, bián_,
   {{0x44443a2a,0x3e788065,0x629a84fe,0x69cf3a2b}},	//   jo_, _két_, psto, sece,
   {{0x44443a2c,0x5f943a2d,0x7c28a6ca,0xa3ac064a}},	//   do_, рист, midr, _गाज_,
   {{0x4444229d,0x3ce6805c,0x7bdc0091,0x61ed3a2e}},	//   eo_, _krov_, _aaru, _unal,
   {{0x444405ee,0x68e29487,0x7bdc3a2f,0x764d0059}},	// [26d0] fo_, jvod, _baru, rlay,
   {{0x7bdc10da,0x600b0182,0x69dbba30,0x2ca93a31}},	//   _caru, _mümk, _saue, rrad_,
   {{0x764d3a32,0xf8bf00e7,0x3e78801c,0xba7401a8}},	//   play, lté_, _nét_, لانت,
   {{0xc3338051,0x68e20029,0xb05b0884,0x60100106}},	//   בוע_, _šodi, städ, _jämn,
   {{0x44443a33,0xf8bf3a34,0x7bdc3a35,0x3ce68069}},	//   bo_, nté_, _faru, _nrov_,
   {{0x601004b8,0x7bdc37a5,0xf8bf00e7,0x8c3d82d0}},	//   _lämn, _garu, ité_, nuşt,
   {{0xaa67b1db,0x8cdb0c1c,0xf1bf0118,0x7afc8338}},	//   _атак, निको, vián_, ärtl,
   {{0x53340ab5,0x64451066,0x7bdc136f,0x6010016d}},	//   _тест, lohi, _zaru, _nämn,
   {{0xc104a181,0x29198711,0x7bdc3a36,0x660d3a37}},	//   _پولي, _åsa_, _yaru, ikak,
   {{0x6b950024,0x22490ad4,0x7bdc02a3,0xa2a480d4}},	//   _jezg, _akak_, _xaru, _किश्,
   {{0x3f983a38,0x7bc1ba39,0x660d3a3a,0xdd91803d}},	//   varu_, rflu, kkak, _هوا_,
   {{0x644504b9,0x3f980f3d,0x7999a914,0x9d199290}},	//   hohi, waru_, naww, _поет_,
   {{0x3ce68bbd,0x625880f7,0x64452020,0x7c2884e1}},	//   _grov_, líoc, kohi, bidr,
   {{0x44443a3b,0x3e718038,0x31568158,0x6e29ba3c}},	//   xo_, _ešte_, טירן_, lieb,
   {{0xdb1c0a56,0x6da61980,0x3f983a3d,0x3e78801c}},	//   _obrá, лива, raru_, _xét_,
   {{0x44443a3e,0x7bdc3a3f,0x660d04d2,0x2bc606b7}},	//   wo_, _saru, gkak, र्ना,
   {{0x44440323,0x7d098a5a,0xf8bf02be,0xe45a0abe}},	// [26e0] to_, nyes, cté_, ежа_,
   {{0x78a90904,0x2013008e,0x44441823,0x6e298192}},	//   ševc, _glxi_, uo_, hieb,
   {{0x7bdc08a3,0x91e6aeb2,0x81d700ab,0x2cbf8074}},	//   _varu, ложе, সার_, htud_,
   {{0x44443a40,0x7bdc3a41,0xe947804e,0x2cbf8122}},	//   so_, _waru, گرمی, ktud_,
   {{0x859b0051,0x7bdc3a42,0xa3b3816f,0x69c2ba43}},	//   _אשכו, _taru, टला_, rfoe,
   {{0xd6da860a,0xa2a4816f,0x44443a14,0xa0679ad8}},	//   ети_, _किल्, qo_, гача_,
   {{0x5fb20076,0x62588013,0x7c28ba44,0x645c00e1}},	//   _जाईल, ríob, vidr, _ihri,
   {{0x3ce6888b,0xa5bd8084,0xf8bf04e8,0x7c288799}},	//   _prov_, liųj, yté_, widr,
   {{0x27ef800d,0x7c28ba45,0x20183a46,0x247202d6}},	//   ální_, tidr, khri_, _fņme_,
   {{0xd12f87bd,0x610a80eb,0x660d33bc,0x63ad8041}},	//   _عمل_, _vēlā, zkak, _ɓang,
   {{0xa68697f9,0x2bc623bd,0xfbc60f1b,0x629e3a47}},	//   _след, र्या, र्यम, nspo,
   {{0x54e688ca,0xaca43a48,0xf8bf2538,0x9f5e9b3a}},	//   _مستق, _akọr, tté_, _noté_,
   {{0xf8bf02be,0x02d110a1,0x645c3a49,0xe9df3a4a}},	//   uté_, _सन्न, _ohri, rdú_,
   {{0x2bc6053f,0xddd00503,0xf8bf02be,0xc1740326}},	//   र्मा, _češk, rté_, _faɗo_,
   {{0xf8bf3a4b,0x6b7b812a,0x6e95079e,0xdce083bf}},	//   sté_, _ארונ, рибу, mamı,
   {{0x66028006,0xdce083bf,0x629e3a4c,0xf8bf00e7}},	//   _jook, lamı, dspo, pté_,
   {{0x64450284,0x660d3a4d,0x645c0083,0x8234026a}},	// [26f0] tohi, rkak, _bhri, _دروا,
   {{0x6b9a809f,0x6602ba4e,0x645c3a4f,0xbd6817ae}},	//   natg, _look, _chri, урсе_,
   {{0x64453a50,0x629e3a51,0xdddc011f,0xdb1a8118}},	//   rohi, gspo, sprš, metó,
   {{0xfde912c6,0x660285ee,0x60cd0133,0xb5fb2620}},	//   _ऑफिस_, _nook, _kpam, _ciát,
   {{0x69df00f1,0x26cc82c4,0x645c0635,0x02d1ba52}},	//   _maqe, _apdo_, _fhri, _तन्न,
   {{0x60cd2fc0,0x645c032f,0x60103a53,0x7999ba54}},	//   _mpam, _ghri, _näml, saww,
   {{0x6602ba55,0x629e0088,0xe57180f7,0x6e29ba56}},	//   _book, cspo, يطة_, tieb,
   {{0x82378013,0x62588013,0x7aea013c,0x6602ba57}},	//   _إرسا, ríoc, æfte, _cook,
   {{0xf1bf003e,0x6e29ba58,0x1fa79a19,0xdd99816b}},	//   riál_, rieb, _брег, raň_,
   {{0x60dbba59,0x68e9a9cb,0x2cbf8151,0x6e29ba5a}},	//   _isum, _ired, rtud_, sieb,
   {{0xfbd20039,0xa5bb026b,0x60cd08f9,0x2cbfba5b}},	//   חתי_, _amóm, _apam, stud_,
   {{0x01660656,0xaab682f1,0x998f8084,0xb34587f1}},	//   икно, _अमरक, mogų_, _alçà,
   {{0xe0d70098,0x291da198,0xaca4019d,0x2d8dba5c}},	//   авя_, nzwa_, _kwụt, mbee_,
   {{0xb8ee023c,0x6b9a87f1,0x6e2600b9,0x6602838a}},	//   _रह_, catg, _smkb, _zook,
   {{0x44d68d38,0x69df00f1,0x6602846d,0xd62a07a1}},	//   _zł_, _faqe, _yook, вове_,
   {{0x78a90db7,0x0d860470,0x3ced017f,0xee3723d7}},	//   ševa, рлан, _ševa_, анс_,
   {{0x249fba5d,0x8fa60294,0x629e3a5e,0x645c082a}},	// [2700] nsum_, _капе, wspo, _phri,
   {{0x389b00be,0x2246ba5f,0x69c982ec,0x515b01c6}},	//   _שיינ, wook_, _abee, _בכפו,
   {{0x60dba3be,0xf1eb01ce,0x68e9ba60,0xf77881b9}},	//   _asum, _जोड़_, _ared, _naħa_,
   {{0x68e992f1,0x00e6919d,0xb05b016d,0x249f8359}},	//   _bred, ижен, ptäc, ksum_,
   {{0x68e9b206,0x66029c11,0x2246ba61,0x60100009}},	//   _cred, _rook, rook_, _lämm,
   {{0xb8ce8403,0xa2e60364,0x2cadb6b8,0x6602b0c9}},	//   _कि_, _когд, dred_, _sook,
   {{0xe297333d,0x68e99d6b,0xfaa302cb,0x2bc606bf}},	//   _вас_, _ered, _маро, र्णा,
   {{0x68e98082,0x2d801122,0x28da8006,0x3e7c001b}},	//   _fred, ncie_, _मैथि, _mít_,
   {{0x68e9ba62,0x6b9a809f,0x999901ac,0xfbc624bd}},	//   _gred, tatg, nosť_, र्थम,
   {{0x5fb20076,0xe3b89014,0x60c2ba63,0x66028b99}},	//   _जागल, lnız_, mtom, _wook,
   {{0x2d8021a9,0x6b9a8722,0x33770039,0x61e089c4}},	//   kcie_, ratg, יעים_, _kaml,
   {{0x61e2ba64,0x2bc604c5,0x6ab681ce,0x2cadba65}},	//   ndol, र्ता, _अमीर, bred_,
   {{0x61e08010,0x3e7195db,0x63bc00d2,0x6b9aba66}},	//   _maml, _išta_, _ocrn, patg,
   {{0x61e28364,0x44278b99,0x6b9a8197,0x2d80009a}},	//   hdol, _gmn_, qatg, ecie_,
   {{0x6448ba67,0xf09f3a68,0xd5bb0d5f,0xdb1aba69}},	//   modi, ssà_, кса_, retó,
   {{0x442cba6a,0x248901bf,0xef190035,0xdb1a8118}},	//   lid_, tpam_, ąż_, setó,
   {{0x60cd3a6b,0x442cba6c,0x3f9c9e8f,0x61e28114}},	// [2710] _upam, oid_, kavu_, ddol,
   {{0x4ada8006,0x6448ba6d,0x442cba6e,0x3f9ca6fd}},	//   _बनाव, nodi, nid_, javu_,
   {{0x2bc60778,0xb5fb3a6f,0x25a6ba70,0x61e085e7}},	//   र्धा, _diár, _odol_, _baml,
   {{0x68e9ba71,0xa3e705fc,0x64488f20,0x2d8000e5}},	//   _pred, _मोर_, hodi, ccie_,
   {{0x69bc016f,0x442cba72,0x95080065,0x84670098}},	//   ष्टी, kid_, _پہلے_, _въве,
   {{0x68e9ba73,0x6e2d3a74,0xe7398e97,0x442cb93e}},	//   _vred, liab, лел_, jid_,
   {{0x2486ba75,0x7d0d3969,0x61e0856c,0x2d993a76}},	//   _atom_, lyas, _faml, _kese_,
   {{0x61e08558,0x249f856c,0x68e9904a,0x625880f7}},	//   _gaml, tsum_, _tred, líon,
   {{0xa3ab0d38,0x2d993a77,0x7d0d3a78,0x893993f7}},	//   _गया_, _mese_, nyas, _спас_,
   {{0x6448803a,0x6e2d3630,0x249fba79,0x2d993a7a}},	//   godi, hiab, rsum_, _lese_,
   {{0x9cf98a49,0x249fba7b,0x81da80c8,0x8c1a0039}},	//   েছেন_, ssum_, ়ার_, רותי,
   {{0x2d993a7c,0x442cba7d,0xf53f0106,0x20058428}},	//   _nese_, aid_, _oxå_, _holi_,
   {{0xeb8e80ae,0xddc602a5,0x2005ba7e,0x44278359}},	//   _ни_, _nikš, _koli_, _tmn_,
   {{0x999901ac,0x7d0d3a7f,0x6b98826c,0x4427926a}},	//   vosť_, dyas, _gevg, _umn_,
   {{0x81bf00c8,0x20058668,0x2d993a80,0xddc60110}},	//   ীয়_, _moli_, _bese_, _aikš,
   {{0x3f9c8da8,0x2d990511,0x2ca00074,0xdb170187}},	//   zavu_, _cese_, tsid_, nexõ,
   {{0x2d993a81,0x2aa38201,0x2d803a82,0x61e0a699}},	// [2720] _dese_, lıb_, rcie_, _raml,
   {{0x61e08370,0xe7e782f1,0x25e80816,0x80ad04c5}},	//   _saml, _टोला_, _चोरी_, _जिते,
   {{0xe80d0063,0x2ca002f1,0x2aa38201,0x2a600282}},	//   _सकता_, ssid_, nıb_, _khib_,
   {{0x60c2ba83,0x6e2d3a84,0x753d8035,0x6448b327}},	//   ttom, ciab, ższy, zodi,
   {{0x2005ba85,0x442cba86,0xdb1e0019,0x81da80ab}},	//   _boli_, yid_, lepü, ়াল_,
   {{0x60c29f5d,0x66061e62,0x442cba87,0xa5bb0032}},	//   rtom, _hokk, xid_, _amóh,
   {{0x660618c2,0x442a3a88,0x60c2a79a,0x2005ba89}},	//   _kokk, _imb_, stom, _doli_,
   {{0x6b989010,0x442cba8a,0x3f9a0904,0xd5ba8d91}},	//   _sevg, wid_, _lepu_, уск_,
   {{0x8fa6ba8b,0x38cb815b,0xa3b3816f,0x2005ba8c}},	//   _газе, _مالی_, टलं_, _foli_,
   {{0xb5fb0104,0x442a0267,0xdbf0801b,0x66060a64}},	//   _khác, _jmb_, _tříd, _lokk,
   {{0x442cba8d,0x6448ba8e,0xe9f90160,0x95ca80e8}},	//   rid_, rodi, анні_, _була_,
   {{0x442c8665,0x661b822e,0x66060125,0x2a6001c0}},	//   sid_, chuk, _nokk, _chib_,
   {{0xa3b8023c,0x442a01e0,0x799d3a8f,0x2486ba90}},	//   छला_, _omb_, rasw, _utom_,
   {{0x2d993a91,0x7d0d3a92,0x3f9a3a93,0xa3e706a7}},	//   _sese_, vyas, _cepu_, _मों_,
   {{0x2d993a94,0x877b82f6,0x59c88540,0x66063a95}},	//   _pese_, ראלי, रभार, _bokk,
   {{0x442a138d,0x7d0d3a96,0xb5fb01a8,0xdceb81b9}},	//   _amb_, tyas, _sháb, _qegħ,
   {{0x62871434,0x2d993a97,0x442a3a98,0x26c30353}},	// [2730] _stjo, _vese_, _bmb_, stjo_,
   {{0x224b3a99,0x6e2d056c,0x2d993a9a,0x7d0d3a9b}},	//   lock_, siab, _wese_, ryas,
   {{0x7d0d3a9c,0x68ed03fb,0x625880f7,0x2005ba9d}},	//   syas, _hrad, ríon, _roli_,
   {{0x09ab00c8,0x41558a08,0x66063a9e,0x3abb80be}},	//   গ্রা, овес, _gokk, רמאנ,
   {{0xed468986,0x09e300c8,0x26de9fa4,0x2aa38085}},	//   _آپ_, যাপা, _asto_, zıb_,
   {{0x2aa38201,0xa29506b5,0x68ed0010,0x62588118}},	//   yıb_, _магі, _mrad, líol,
   {{0xb05b0009,0x66063a9f,0x661bbaa0,0x2a668282}},	//   ytän, _yokk, thuk, bmob_,
   {{0xf2d2093f,0x68ed3aa1,0xc48584dd,0x7bd73aa2}},	//   _קען_, _orad, олик, lexu,
   {{0x2bc614a7,0x26de9220,0xe3b19e13,0x2a6001c0}},	//   र्वा, _esto_, ورد_, _rhib_,
   {{0x5ac9baa3,0x661bbaa4,0x2aa38085,0x2a6010ba}},	//   алом_, shuk, tıb_, _shib_,
   {{0x68ed3a1c,0x78a9005c,0xb05b0009,0xd7f8801c}},	//   _arad, ševl, ttän, _khăn_,
   {{0x2a6001c5,0x2aa38085,0xb6868019,0xdd1e928a}},	//   _qhib_, rıb_, _بھول_, _síťo,
   {{0x786004b8,0x6e2b826b,0x7e7a890d,0xb05b1c50}},	//   höve, _imgb, _zutp, rtän,
   {{0xb05b3aa5,0x799b82f7,0x66063aa6,0x68ed3aa7}},	//   stän, _leuw, _sokk, _drad,
   {{0xdee3117e,0x442a3aa8,0x66e33aa9,0x2a600069}},	//   мори, _rmb_, мора, _thib_,
   {{0x68ed3aaa,0x78a414a2,0xe1ff0511,0x39401d67}},	//   _frad, _tviv, lmón_, _txis_,
   {{0xad660077,0x64430353,0x3f9a3aab,0x248d80b9}},	// [2740] زاره, čnin, _tepu_, npem_,
   {{0x6b5622ea,0x66063aac,0x61e62ec5,0xc17400fc}},	//   отех, _wokk, ldkl, _naɗi_,
   {{0x61e402b8,0x59c10107,0x86460f75,0x68ed04e8}},	//   _kail, ष्कर, _множ, _zrad,
   {{0xd7f880ff,0x62588118,0x3f858162,0xdcfd0084}},	//   _chăn_, cíol, _aflu_, _nesė,
   {{0x25a03aad,0xe8949a8f,0x2d9201d3,0x10a3b7df}},	//   mail_, чаль, mbye_, дичн,
   {{0x4aa9853e,0xeeaa8b87,0xacd90158,0x76aa910b}},	//   _किंव, атик_, _פֿרי, атив_,
   {{0xa01b0198,0xc1740300,0x09b20264,0x26de8037}},	//   mpöt, _daɗi_, ট্যা, _qsto_,
   {{0x78ad8025,0x25a03aae,0x61469577,0x6b9c3aaf}},	//   šava, nail_, _деба, _herg,
   {{0x07a69cb2,0x625880f7,0x6b9c0074,0x7aee007a}},	//   _маан, níom, _kerg, _hrbt,
   {{0x25a004bc,0x3eb800f1,0x6b9c3ab0,0x9b6a8323}},	//   hail_, kurt_, _jerg, ишна_,
   {{0x61e4154c,0xa5bb0073,0x25a03ab1,0x68ed3ab2}},	//   _bail, _imóv, kail_, _srad,
   {{0x68ed01e2,0x61e43ab3,0x201a00df,0xba2b00e8}},	//   _prad, _cail, _alpi_, ріод_,
   {{0x25a0125b,0xcd368c2b,0x660f9614,0x61e42612}},	//   dail_, _براب, öcke, _dail,
   {{0xcbd500c8,0x3eb83ab4,0x6b9c3ab5,0x7c2aa32a}},	//   _হচ্ছ, furt_, _nerg, _umfr,
   {{0x09d000c8,0xdd9b0615,0x25a03ab6,0xdb4f80e8}},	//   িয়া, иша_, fail_, _цю_,
   {{0x3ead0775,0x61e43ab7,0x25a00014,0x7bce01b9}},	//   čet_, _gail, gail_, _abbu,
   {{0x6b9c3ab8,0x2fd80338,0x68ed1408,0xc05b035f}},	// [2750] _berg, berg_, _urad, _він_,
   {{0xa2a490f7,0x6b9c3ab9,0x7c3ababa,0x61e40102}},	//   _किञ्, _cerg, nntr, _zail,
   {{0x23c2800f,0x25a00013,0x926ba3d7,0x6b9c3abb}},	//   _शानद, bail_, арда_, _derg,
   {{0x25a0008c,0x7c3ababc,0x6b9c1384,0x69c0babd}},	//   cail_, hntr, _eerg, _ccme,
   {{0x6b9c2ebd,0xc5fa0039,0x6d5d1247,0x00000000}},	//   _ferg, _הפרט, _uzsa, --,
   {{0x3abb03f8,0x6b9c3abe,0xe8d90133,0x66e598d1}},	//   _پاسخ_, _gerg, _nzọ_, зока,
   {{0xa195835f,0x199589a8,0x7e628a15,0x160f08d4}},	//   _навч, _навя, _bhop, _सवार_,
   {{0x7c3ab49a,0x6b9c0102,0xe8d901bc,0xd6ce80f7}},	//   entr, _zerg, _azọ_, اقي_,
   {{0x69d9babf,0x6d4301ec,0xc1740326,0x81198652}},	//   mewe, ßnah, _taɗi_, _ужас_,
   {{0x69d9bac0,0x4b258221,0x3e71826c,0x6b9c0118}},	//   lewe, змов, _tšto_, _xerg,
   {{0x81e500c8,0xef20009a,0xb05b0106,0x91e61617}},	//   নান_, ążki_, rtäl, поне,
   {{0xb05b04b8,0x7a362c62,0x6eca811c,0x61463ac1}},	//   stäl, kšte, _məbl, зема,
   {{0x25a002be,0x61e60123,0x61e43ac2,0x7e698f81}},	//   vail_, rdkl, _vail, mmep,
   {{0x7c94803d,0x601d86c0,0x62890bcf,0xb4d7bac3}},	//   _آشنا, _fème, _čeon, ाबी_,
   {{0x61e43ac4,0x81b380ab,0x4e1f8105,0x25a010b6}},	//   _tail, জ্য_, _बताई_, tail_,
   {{0x2cb201b0,0xbddb313c,0x69d98bfd,0x6e3bbac5}},	//   tryd_, _ajèb, jewe, nnub,
   {{0x25a03ac6,0x69d9bac7,0x2d9d819d,0x3eb83ac8}},	// [2760] rail_, dewe, _mewe_, surt_,
   {{0x2d9d879f,0xdce600eb,0x25a010a2,0x625881a8}},	//   _lewe_, _iekļ, sail_, ríom,
   {{0x6b9c1d6f,0x877b0039,0x51869777,0x9f970039}},	//   _verg, _לאיי, пула, _מדיה_,
   {{0x69d9844e,0x63a1bac9,0xe8faa462,0x320900ff}},	//   gewe, haln, йле_, _xoay_,
   {{0x6b9c0867,0x3dc380c8,0xb5fb001c,0xc5c380ab}},	//   _terg, ্যাল, _khán, ্যাপ,
   {{0x7e629838,0xfaa63aca,0x9326015b,0x660401c8}},	//   _shop, _наго, _فرزن, ljik,
   {{0xeab680ab,0x8c1b0039,0x7c2e12b8,0x69d99ab0}},	//   _জন্ম, _פולי, _imbr, bewe,
   {{0x91e3bacb,0x44f49317,0x2d9d8b99,0x66043acc}},	//   _посе, дпис, _cewe_, njik,
   {{0x2ba683bb,0x63a1811f,0x81e500ab,0x7e7e2853}},	//   jící_, faln, নাম_, _lupp,
   {{0xb05b0364,0x2281808b,0xb5fb00ff,0x2ba681d0}},	//   ttäm, _bók_, _nhán, dící_,
   {{0x81df80c8,0x316034e8,0xe1d9035f,0xeee4803d}},	//   তার_, _aziz_, одні_, _تغذی,
   {{0xddc88267,0x250b804e,0xa194102a,0x752400ee}},	//   _hudž, _گرمی_, наюч, kziz,
   {{0xd6258013,0xb05b3acd,0xf1a40084,0x3f9e80f1}},	//   _تعلي, stäm, эрэн, _ketu_,
   {{0x7a360a21,0x36d51541,0x7afc9614,0x63a1bace}},	//   všte, могр, ärts, caln,
   {{0x3f9ebacf,0x7bdabad0,0xddc88267,0x628aa1ad}},	//   _metu_, metu, _mudž, _utfo,
   {{0x7bdabad1,0x3f9e9a75,0x660400f1,0xe8d901bc}},	//   letu, _letu_, gjik, _afụ_,
   {{0x69d9bad2,0xb05b1c15,0xb5fb0f35,0x65600a2a}},	// [2770] vewe, ntäk, _fhán, _ùmhl,
   {{0x7bdabad3,0x69d983f7,0x705500d7,0xf7788372}},	//   netu, wewe, _زنجا, _daħk_,
   {{0x442e8390,0x34d9800d,0xd7f8801c,0x6b8501ec}},	//   _mmf_, _भन्द, _chăm_, rchg,
   {{0x7a361601,0x7bda9b17,0x63a186e4,0xe8d92ae3}},	//   pšte, hetu, zaln, _efụ_,
   {{0xddc8bad4,0x37e588ed,0x81df80ab,0x7e7e01e8}},	//   _budž, долг, তাল_, _zupp,
   {{0xacfa0039,0x78ad8390,0x69d9bad5,0x2d9d867f}},	//   _והשכ, šavo, sewe, _sewe_,
   {{0x63a18db7,0x7bdabad6,0xb05b0009,0x69d985ee}},	//   valn, detu, ttäj, pewe,
   {{0x601000f2,0x44333ad7,0x26c78796,0x63a18035}},	//   _hämt, lix_, rtno_, waln,
   {{0x26c78353,0x7e6993c2,0x9f5e8216,0x78600338}},	//   stno_, rmep, _votá_, höva,
   {{0x2d9d822e,0x7bdabad8,0x60100106,0x7e6481b9}},	//   _wewe_, getu, _jämt, ċipa,
   {{0x387f838e,0x569484ae,0xfbcf1a46,0x04ef8264}},	//   _huur_, _захт, स्यम, য়নের_,
   {{0x63a1bad9,0x3f9e8010,0xdcf98fd3,0xb5fb128a}},	//   saln, _zetu_, _وفات_, _shán,
   {{0x7e7e0213,0x63a18f28,0x3f9e822e,0x6443003a}},	//   _supp, paln, _yetu_, čnij,
   {{0x2281807b,0x387f837a,0x7e7e3ada,0x2bcf0b84}},	//   _tók_, _muur_, _pupp, स्मा,
   {{0x59c6035a,0x8c428279,0x44333adb,0x41c60035}},	//   _वापर, _шеше, dix_, _वापस,
   {{0x25bfbadc,0x4433023e,0x2b0a801b,0x7524011b}},	//   ngul_, eix_, ाहरु_, tziz,
   {{0xb5fb0104,0xdca32f84,0x64a3176e,0x387fb512}},	// [2780] _thán, кати, ката, _nuur_,
   {{0x661d15f8,0x68e43add,0x442100dd,0x7e7e365d}},	//   _elsk, _isid, ghh_, _tupp,
   {{0x2bcf8f21,0x78a98698,0x78ad8301,0x9f458168}},	//   त्या, _avev, šavl, _dalë_,
   {{0x442134b1,0xd378812b,0x81e50264,0x387f91b8}},	//   ahh_, meće_, নাথ_, _buur_,
   {{0xd37890d3,0x7bda804f,0x9f458168,0x02da890f}},	//   leće_, yetu, _falë_, _बन्न,
   {{0x387fbade,0xd7f8801c,0xd0108c3b,0x2bcfba52}},	//   _duur_, _thăm_, طلب_, त्मा,
   {{0x7bdabadf,0xa3e7150e,0xd3788904,0x6a8307b6}},	//   vetu, _मोट_, neće_, _алса,
   {{0x78a9003b,0x973c803a,0x3f9e822e,0x25bf9295}},	//   ševi, _neće, _wetu_, ggul_,
   {{0x7bdabae0,0xe3ce8028,0x47c684ae,0x60101a50}},	//   tetu, _dựng_, _обав, _jäms,
   {{0x69c43ae1,0xf0638084,0xa3de0054,0x25bf8493}},	//   _acie, _акуп, ढ़ि_, agul_,
   {{0x0bb70051,0xd378a3e3,0x22590198,0x387f890d}},	//   ולים_, jeće_, зины_, _zuur_,
   {{0xd378803a,0x7bdabae2,0x442e9849,0xdd90880b}},	//   deće_, setu, _wmf_, _صوت_,
   {{0x200cbae3,0xb4bd02f1,0xa3de0105,0xf1bf0144}},	//   _kodi_, _इमे_, ढ़ा_, rgá_,
   {{0x200c86c0,0x6562b106,0x44332e12,0xb8f7170c}},	//   _jodi_, _izoh, xix_, _सह_,
   {{0x200cbae4,0x45d50468,0xe6dca342,0x76878214}},	//   _modi_, новс, _मनोज, _kıya,
   {{0x200cbae5,0x59c605e8,0x645a831d,0xf1d0001c}},	//   _lodi_, _वायर, llti, _hạng_,
   {{0x69dd3ae6,0x44333ae7,0x443e81e4,0x2d580b88}},	// [2790] mese, tix_, ont_, дить_,
   {{0x443ea1ec,0x69dd3ae8,0x200c8114,0xc86700f7}},	//   nnt_, lese, _nodi_, _تطبي,
   {{0x443ea0a4,0x44333ae9,0xf1d00028,0x387f8074}},	//   int_, rix_, _mạng_, _suur_,
   {{0x443e82af,0x201e94ed,0x44210b17,0x32193aea}},	//   hnt_, _alti_, shh_, nksy_,
   {{0x629c08d9,0x200cbaeb,0x78bd15a0,0x7a36131b}},	//   _ewro, _bodi_, nusv, nšta,
   {{0xb907901b,0x85740d13,0x649a0051,0x76428136}},	//   _बन_, _шлях, _מישה, _ajoy,
   {{0x63a53aec,0x69dd3aed,0x7ac411d5,0x2aa81539}},	//   mahn, kese, _исте, _отто_,
   {{0x443ebaee,0xceb40f60,0x63a51067,0x261c00f7}},	//   ent_, דיק_, lahn, _líon_,
   {{0x2bcf29b7,0x9f45826f,0x61fb9698,0x2ca90ce9}},	//   स्था, _malé_, _inul, nsad_,
   {{0xd3788024,0x63a53aef,0x69c43af0,0x443ebaf1}},	//   zeće_, nahn, _scie, gnt_,
   {{0xf1d0001c,0x61fbbaf2,0x69dd1267,0x61e9baf3}},	//   _dạng_, _knul, fese, _kael,
   {{0x2bcf0d86,0x443ebaf4,0x69dd3af5,0x200cb3b5}},	//   स्ता, ant_, gese, _zodi_,
   {{0x973c8052,0x61e9822e,0xa1550698,0x63a509ca}},	//   _veće, _mael, върш, kahn,
   {{0xfaa59fa1,0xdb1c0013,0x63a50be6,0x61e9baf6}},	//   _зако, _scrí, jahn, _lael,
   {{0x63a509ca,0x8c1a8039,0x69dd3af7,0xd3789487}},	//   dahn, _מוסי, bese, teće_,
   {{0x69dd3af8,0x20183af9,0x61e9bafa,0x9f45bafb}},	//   cese, skri_, _nael, _valè_,
   {{0x2edc800d,0xd378812b,0x15f28105,0x63a53afc}},	// [27a0] _मन्त, reće_, _अफसर_, fahn,
   {{0x61fbbafd,0x6fd387d9,0x63a53afe,0x7bc1baff}},	//   _anul, nıcı, gahn, nglu,
   {{0x3f983b00,0x23c6024c,0x2bc60744,0xa79b007c}},	//   mbru_, र्गद, र्गा, _משיח,
   {{0x6455106d,0x2bcf824c,0xdb0181ac,0xfbcf8a27}},	//   _ekzi, त्ता, galé, त्तम,
   {{0x443ebb01,0x63a53b02,0x6d5982e9,0x6b8081bc}},	//   ynt_, bahn, _nywa, ịgid,
   {{0x69dd3b03,0xb05b0364,0x9f34b73a,0x7bc180ce}},	//   zese, ttäi, келі, jglu,
   {{0x8c430765,0x69dd2499,0xd6d78150,0x765b86a5}},	//   _сере, yese, еты_, fluy,
   {{0x61e9803c,0x2bc28006,0xa3d2bb04,0x443ebb05}},	//   _gael, _शाहा, ह्न_, wnt_,
   {{0x59a70063,0x69dd3b06,0x290280f1,0x2bc70cf0}},	//   _ख़बर, vese, _çka_, _लामा,
   {{0x320dbb07,0x69dd3b08,0xe8d78039,0x443ebb09}},	//   _zoey_, wese, _אומר_, unt_,
   {{0x69dd3b0a,0xa19501bb,0x600f83ba,0x443eb2c7}},	//   tese, канч, _tømr, rnt_,
   {{0xf2d30158,0x765b85b4,0x3a200028,0x2bc70076}},	//   נער_, cluy, _clip_, _लाभा,
   {{0x63a50d92,0x6e243b0b,0x09e300ab,0x7bde3b0c}},	//   yahn, dhib, যালা, kepu,
   {{0xb05b0009,0x6010016d,0x69dd3b0d,0xb803b716}},	//   htäv, _sämr, sese, लायम_,
   {{0x387a026c,0xc22183a4,0x63a5011a,0x69dd3b0e}},	//   _dipr_, _मतलब_, vahn, pese,
   {{0x6e24222e,0x63a5010b,0x7a360b67,0x09d580ab}},	//   ghib, wahn, pšta, _সোনা,
   {{0xd90495e4,0xa5bb0118,0xb87b01fa,0x7e6d27d1}},	// [27b0] _ای_, _alóc, rvís, rmap,
   {{0x7e6d010c,0x2bd80035,0x2ca9308a,0xf8bf0144}},	//   smap, ड़गा, rsad_, mué_,
   {{0xa8580051,0x63a53b0f,0x2ca93b10,0x61e9bb11}},	//   _איזה_, rahn, ssad_, _pael,
   {{0x6e243b12,0x63a50d92,0x92b401a8,0x798d0197}},	//   chib, sahn, احلا, _jfaw,
   {{0x91bf81bc,0x2604815c,0x60103b13,0x9f5a02d6}},	//   _ahụ_, वानी_, _kämp, _anpè_,
   {{0x7bde0012,0xec350158,0xdb01a82b,0xe05780d5}},	//   cepu, _יאָר_, salé, ریات_,
   {{0xf4c280c8,0x765b9238,0x61fb85ee,0x6d598123}},	//   ্টোব, tluy, _tnul, _sywa,
   {{0xe8d9001c,0x60103b14,0x660f3b15,0x6288002a}},	//   _ngữ_, _lämp, _jock, _édoa,
   {{0x6fd381cc,0xe1ff0035,0x9f5a0176,0x5a4493bf}},	//   tıcı, lmów_, _enpè_, _сэра,
   {{0x2a6902d5,0x660f24c0,0x249680d7,0x6e2402d4}},	//   _ahab_, _lock, کنید_, zhib,
   {{0x23298c24,0xab2990f8,0x7bc1a0f0,0x6fd3899b}},	//   фони_, фона_, rglu, rıcı,
   {{0x65958cec,0x7aea006a,0x8d878081,0x2a690362}},	//   _раду, æfti, _чужд, _chab_,
   {{0xf8bf3b16,0x261c01a8,0x2a6901b4,0xbcfb0061}},	//   gué_, _díol_, _dhab_, _szén,
   {{0x2cbf8079,0x6eca829a,0x00000000,0x00000000}},	//   muud_, _səbi, --, --,
   {{0x07a33b17,0x8fa31597,0x6e243b18,0x317fbb19}},	//   расн, расе, thib, _oguz_,
   {{0x63a3bb1a,0x68e2831d,0x7bd501ec,0x661bbb1b}},	//   _henn, ywod, _abzu, nkuk,
   {{0x6441bb1c,0x6283bb1d,0x7bde3b1e,0x69d63b1f}},	// [27c0] onli, _huno, tepu, _ibye,
   {{0x6283bb20,0xd3788289,0x6441bb21,0xe29a0cf9}},	//   _kuno, leća_, nnli, даж_,
   {{0x81e50a49,0x260480d4,0x63a38e20,0xb05b0364}},	//   নার_, वामी_, _menn, ttäv,
   {{0x63a3bb22,0x62838542,0x7bde0b17,0xaca40133}},	//   _lenn, _muno, sepu, _amụr,
   {{0xe3a7850c,0x0cbc80ab,0x69c2bb23,0x92cd80ab}},	//   _پر_, _অন্ত, rgoe, রিয়_,
   {{0x09d600c8,0x63a3bb24,0x64418a0f,0xb05b0009}},	//   _তোমা, _nenn, jnli, stäv,
   {{0x29008012,0x973c80d2,0x69d63b25,0xc5eb80ab}},	//   ţia_, _beća, _obye, কানা_,
   {{0xd37882fd,0x2bcf815c,0x64419412,0x661b809c}},	//   jeća_, त्सा, enli, gkuk,
   {{0x81e88a49,0xd3788025,0x70dc035a,0x24860307}},	//   বাদ_, deća_, यबोल, íomh_,
   {{0x63a3bb26,0xe7c9809a,0x2bc6001b,0x6283bb27}},	//   _cenn, _रायप, र्चा, _buno,
   {{0x63a381a3,0x62838012,0x6d448038,0x0c7380f7}},	//   _denn, _cuno, _žiad, جديد,
   {{0x68f63b28,0xf8bf00e7,0x62839fc9,0x2a69022c}},	//   _bryd, tué_, _duno, _qhab_,
   {{0xc05b035f,0x63a3bb29,0xac0a8eef,0xe7c986f0}},	//   дів_, _fenn, _онда_, _रामप,
   {{0x63a3bb2a,0x660f3b2b,0xd9180009,0x69d602ec}},	//   _genn, _sock, тью_, _ebye,
   {{0x6e228259,0x63a88f09,0x2a690282,0x62838087}},	//   _klob, madn, _thab_, _guno,
   {{0x78ad8024,0x33778039,0xd5b80c0e,0x62810036}},	//   šavi, _בתוך_, ксу_, _éloi,
   {{0x2bcf835a,0xf8bf3b2c,0xfbcf81d0,0x63a382ec}},	// [27d0] त्वा, qué_, त्वम, _yenn,
   {{0x61ed3b2d,0x6e228722,0xddc43b2e,0x27fe808e}},	//   _haal, _llob, rmiš, _nntn_,
   {{0xe7ec00d4,0x61ed3b2f,0x660f011f,0xe29800e8}},	//   _छोटा_, _kaal, _tock, ває_,
   {{0x61ed0079,0x63a8bb30,0xc3338039,0x645e3b31}},	//   _jaal, hadn, סוף_, alpi,
   {{0x61ed3b32,0x25a93b33,0x394980a9,0x660982fd}},	//   _maal, maal_, ças_, vjek,
   {{0xd378803b,0xa3d2ac2a,0x973c9432,0xab9400e8}},	//   zeća_, _हॉल_, _seća, _вирі,
   {{0x63a38e20,0x973c8699,0xadc40032,0x7a26008b}},	//   _renn, _peća, _ajẹs, _hóte,
   {{0x61ed3b34,0x25a92409,0xdb0380e7,0xa3cf06bf}},	//   _naal, naal_, _fenê, व्र_,
   {{0x69cc826f,0x7e7d3b35,0x661bbb36,0x62838cf4}},	//   ílež, _misp, rkuk, _suno,
   {{0x7bc53aef,0x6283bb37,0x6609bb38,0x25a92808}},	//   nghu, _puno, sjek, haal_,
   {{0x63a3bb39,0xc5d5835f,0x61ed3b3a,0xbcfb0019}},	//   _venn, _біль, _baal, _szél,
   {{0xb5fb0013,0x61ed02a3,0x63a3949d,0x68f6031d}},	//   _fhái, _caal, _wenn, _pryd,
   {{0x61ed3b3b,0x25a93b3c,0x04c881a8,0x7a26016a}},	//   _daal, daal_, _لوني_, _nóte,
   {{0x6283bb3d,0x68f601b0,0xf77884b7,0x013680be}},	//   _tuno, _vryd, _taħt_, אָלט_,
   {{0x18671927,0x61ed3824,0xa3aa000f,0xb05b0004}},	//   уари_, _faal, _गजब_, kräf,
   {{0x2bcf8894,0xc6928158,0x25a902a3,0xfbcfb738}},	//   त्रा, מאל_, gaal_, त्रम,
   {{0x05663b3e,0xfbb783eb,0xdd8f0bbe,0x30be8264}},	// [27e0] уван, _आयाम, سول_, _ইন্স,
   {{0x69c9802e,0x309b0bea,0x389b010f,0x61ed0365}},	//   _acee, _רשימ, _ריינ, _zaal,
   {{0x3ce58063,0x81e880ab,0x61ed1a25,0x25a93b3f}},	//   _जैसे_, বাস_, _yaal, baal_,
   {{0x69c601da,0x61ed02a3,0xb05b02af,0x63a8807a}},	//   ngke, _xaal, stät, zadn,
   {{0x522d00be,0xc05a81e2,0x9f45bb40,0xa3cf064a}},	//   וואַ, нік_, _dalí_, _वॉक_,
   {{0x6e2295d8,0xcaa600f7,0x3a26b437,0xdd3b03de}},	//   _slob, _مصري, shop_, _װעלכ,
   {{0x444439e8,0x63a8a19f,0x68e9a499,0x94230b5b}},	//   mn_, vadn, _esed, _умре,
   {{0x443a3b41,0x44440b2f,0x201c8904,0xa281809a}},	//   lip_, ln_, skvi_, łość_,
   {{0x444406ba,0x61ed0079,0x2ba80651,0x3d0e8074}},	//   on_, _raal, गरपा, िहें_,
   {{0x44443b42,0x443a336a,0x61ed3b43,0x60c2bb44}},	//   nn_, nip_, _saal, muom,
   {{0x44443b45,0x25a902a3,0x26048aed,0x61ed3b46}},	//   in_, yaal_, वादी_, _paal,
   {{0xc333078d,0x6eca8201,0xb5fb0013,0x63a8bb47}},	//   מות_, _qəbu, _thái, sadn,
   {{0x7e7d09ba,0x443a3b48,0xdddb880a,0x61ed3b49}},	//   _risp, kip_, lmuş, _vaal,
   {{0x4394bb4a,0x44443b4b,0x443a06c0,0xf1bf0013}},	//   _такс, jn_, jip_, chán_,
   {{0x25a92808,0x61ed0c1f,0x7c3abb4c,0x5f941510}},	//   taal_, _taal, mitr, сист,
   {{0x5eb980ab,0x92b392c8,0x6eca8085,0x387ebb4d}},	//   _আহমে, _احوا, _həbs, _litr_,
   {{0x61e2bb4e,0x25a90c11,0x7e7d0029,0x7a26008b}},	// [27f0] deol, raal_, _visp, _fótb,
   {{0x7c3aab02,0xddc98214,0x443a02e8,0x25a68114}},	//   nitr, kleş, gip_, _leol_,
   {{0x45d52a71,0xb05b1af3,0x25a91ad7,0x78bc80eb}},	//   _конс, träf, paal_, _ārva,
   {{0x7c3a811a,0x973c9123,0x3e410110,0x09e300ab}},	//   hitr, _pećn, kėti_, যাকা,
   {{0x44443b4f,0x9f4781d0,0x26d10cdb,0xe94580d7}},	//   bn_, rdní_, ltzo_, جرای,
   {{0x660d2d2e,0x3e4101e2,0xb5fb3b50,0x25a9807a}},	//   ljak, dėti_, _cháv, _žal_,
   {{0xdb03bb51,0x7c3abb52,0xdb01bb53,0x26d10cdb}},	//   _genè, ditr, talí, ntzo_,
   {{0xed59b2b8,0x645704c3,0x25a68c5e,0xc3320039}},	//   кой_, loxi, _ceol_, _וול_,
   {{0x0c258ab2,0x387ebb54,0x68e9bb55,0xac858073}},	//   имин, _fitr_, _used, јгол,
   {{0xdb01bb56,0x2cad9c1d,0x22490458,0x660d156e}},	//   salí, rsed_, _ajak_, hjak,
   {{0x7f849301,0x81e88a49,0x2a6d9d14,0x69cc800d}},	//   _المن, বার_, _kheb_, _हामी,
   {{0xd5758e02,0x26c306a5,0xc86904de,0x20010122}},	//   _куль, dujo_, _חן_, _anhi_,
   {{0xeb8ea42e,0x444402c1,0x62873b57,0x443a0214}},	//   _ми_, yn_, _lujo, yip_,
   {{0x7c288014,0x7c3abb58,0x63a7001b,0xa06a01e2}},	//   chdr, citr, _nejn, тага_,
   {{0x44440b40,0x81ab80ab,0x28b20074,0xcc3a80be}},	//   vn_, _খান_, _जिकि, _בעסט,
   {{0x44443b59,0xe8fa0b30,0x644f80e7,0x64453b5a}},	//   wn_, _али_, écif, enhi,

   {{0x628702be,0x443a3b5b,0x7d098118,0xddc98214}},	// [2800] _aujo, tip_, nxes, zleş,
   {{0x44443b5c,0x6457002a,0x26c30e1b,0xdddb8380}},	//   un_, goxi, bujo_, ymuş,
   {{0x44443b5d,0x63a701c0,0x67bb0039,0x395f80e4}},	//   rn_, _dejn, _במיק, _ayus_,
   {{0xb05b034a,0xe7d201ab,0x7d1b8365,0x2efa2c92}},	//   träg, द्रप, kyus, _irpf_,
   {{0x260481c4,0x61e2bb5e,0x44442ebd,0xae0982f1}},	//   वासी_, reol, pn_, वानन_,
   {{0x443a00f1,0x2056bb5f,0x25a680f7,0x64a31986}},	//   qip_, штер, _seol_, _фара,
   {{0x2120935a,0x60c2827e,0x973c812b,0x6e298a10}},	//   ših_, suom, _većo, fheb,
   {{0xdb03aa63,0xfe6f80a0,0xddc98214,0xdddba2f8}},	//   _gené, ودي_, rleş, rmuş,
   {{0x394d0063,0x87da84c0,0x9c469016,0x7c28bb60}},	//   żesz_, _لباس_, ихол, thdr,
   {{0xbcfb0019,0x7ed680e8,0xdb038061,0x6280bb61}},	//   _szék, _відч, _zené, _himo,
   {{0x752d01dc,0x6280bb62,0x233881e2,0x6bd8803d}},	//   zzaz, _kimo, упны_, نوکس_,
   {{0xdb0384c3,0xdd8f8019,0x7c3a8084,0x6cd68019}},	//   _xené, _قوم_, sitr, _نقصا,
   {{0x04948624,0x7c948013,0x62808f20,0x6fcd83eb}},	//   _التح, _التص, _mimo, _सामू,
   {{0x251b8e82,0xd83b0087,0x798403f7,0x04dbb5c4}},	//   _בודא, тэм_, _egiw, _סקול,
   {{0x6f1c031d,0xbe880860,0x63a7007a,0x6602bb63}},	//   gyrc, исте_, _rejn, _knok,
   {{0x4b7b812a,0x30a72386,0x628084a7,0x6d5c8457}},	//   _באוו, _кров, _nimo, ğraf,
   {{0xb05b016d,0x9f45826f,0x786d841c,0x629abb64}},	// [2810] träd, _malá_, lúve, lpto,
   {{0x6e29bb65,0x6280bb66,0x62873b67,0x224680e1}},	//   zheb, _aimo, _pujo, enok_,
   {{0x2d8280e1,0x19b99539,0x2bd89869,0xd8488133}},	//   ľkej_, гуль_, ब्या, kọb_,
   {{0x62870279,0x2a6d8282,0x645c03ec,0x6457002a}},	//   _vujo, _qheb_, _ekri, soxi,
   {{0x6280bb68,0x26dea6e7,0xb5fb01a8,0xe8038072}},	//   _dimo, _apto_, _dhát, लाला_,
   {{0x09e300ab,0x7a263b69,0x6602b6ef,0x1d1601c6}},	//   যাটা, _móta, _anok, _הקשר_,
   {{0xdb0386a5,0x2a7f8748,0xdb018c83,0x316981d6}},	//   _tené, _tiub_, kalá, ťaz_,
   {{0xb8cd80c8,0xf2d204de,0x62809f6d,0x26dea5ca}},	//   _কম_, _מעל_, _gimo, _dpto_,
   {{0x6e298648,0xbc198048,0x7a2601a8,0x2bc284c5}},	//   rheb, гіні_, _nóta, _शाखा,
   {{0x40849cce,0x98148077,0x9b440117,0x68fb811e}},	//   _футб, _وبلا, _انہو, _irud,
   {{0x44213b6a,0xdce78182,0x682b0201,0x68ed3b6b}},	//   ikh_, ımız, _müdd, _asad,
   {{0xdb018019,0x6eca8085,0xf8bf023e,0xa5bb008b}},	//   galá, _təbr, fré_, _blóm,
   {{0x2604bb6c,0x291dbb6d,0xc9560009,0x8505803d}},	//   वारी_, nywa_, стны, _دوشن,
   {{0x765d0e87,0x2cbfb55e,0x3cfe01d0,0xc2c880d7}},	//   _aksy, mrud_, _čtv_, دبیل_,
   {{0xdb0184be,0x66f98107,0xd62a0320,0xf99f01e8}},	//   balá, ्मिक_, гове_, bbè_,
   {{0x645c0bbd,0xf8bf003e,0x0d861bf2,0x442102a3}},	//   _skri, bré_, слан, ekh_,
   {{0x61e63b6e,0xcc888104,0x44383b6f,0x6280bb70}},	// [2820] mekl, _lớn_, _pmr_, _rimo,
   {{0x69db85a4,0x44278890,0x61e63b71,0x4adb8fb8}},	//   _abue, _jln_, lekl, _बहाव,
   {{0x4427bb72,0xfc3f07e2,0x6d4f3b40,0x25ad8bcb}},	//   _mln_, _avís_, _exca, kael_,
   {{0x68fb84fe,0x80cb00c8,0x61e63b73,0xd2598d8e}},	//   _brud, িবর্, nekl, аці_,
   {{0x25a00393,0x6280a6d5,0x25ad8114,0xddcd1bef}},	//   mbil_, _vimo, dael_, llaş,
   {{0x645c3b74,0x25a03b75,0xe447bb76,0x44383b77}},	//   _ukri, lbil_, _رض_, _umr_,
   {{0x62808a5e,0xddcd0059,0x61e60214,0x09b200ab}},	//   _timo, nlaş, kekl, য়্যা,
   {{0x61e6111b,0x7e64020d,0x25a004e1,0xa5bb026b}},	//   jekl, nlip, nbil_, _alój,
   {{0xa9268009,0x4427810b,0x61e63b78,0x998d81a1}},	//   _удал, _bln_, dekl, _umeš_,
   {{0xddcd0214,0xf8bf00e7,0xb34682df,0xe8248061}},	//   klaş, vré_, jeçõ, _بذری,
   {{0xdb01bb79,0x5c5b00be,0x7a263b7a,0x2bf701c6}},	//   talá, רדיק, _sóta, זמין_,
   {{0xad9b0073,0x5d868013,0x2604816f,0x5b7b03c8}},	//   _anún, _الإل, वाळी_, טריא,
   {{0xfdf78039,0x44213b7b,0x661d9c50,0xf8bf3b7c}},	//   _לצאת_, ykh_, öske, uré_,
   {{0xa2c08ec5,0xf8bf3b7d,0xb9218032,0x96eb0b79}},	//   _विप्, rré_, _aisọ_, льба_,
   {{0x443e8e79,0x6fda800f,0x501b8039,0x543b80be}},	//   mit_, प्यू, נולו, _געגא,
   {{0x645abb7e,0xe8d90028,0x7bdc3b7f,0x61e63b80}},	//   loti, _ngủ_, _abru, cekl,
   {{0x68ed0510,0x2bcf89a9,0x973c8b67,0x3a2902c4}},	// [2830] _usad, त्का, _bećk, _ilap_,
   {{0x44273b81,0x645abb82,0x3ce0800f,0x97a70087}},	//   ón_, noti, _कहने_, _урил,
   {{0x6448bb83,0x3a29000b,0xfa8980ff,0x68fb8115}},	//   indi, _klap_, _lẫn_, _srud,
   {{0x443ebb84,0xc1b70c28,0x1df90009,0x7e643b85}},	//   hit_, _अयोग, _темы_, clip,
   {{0x443eb1f4,0x645abb86,0x7a36012b,0x65628db1}},	//   kit_, koti, ušti, _nyoh,
   {{0x62988b5d,0x443ebb87,0x63aa8125,0x645abb88}},	//   _otvo, jit_, _nefn, joti,
   {{0xa3be92ee,0x443ebb89,0x645abb8a,0x6562bb8b}},	//   ेलन_, dit_, doti, _ayoh,
   {{0x7a36003b,0xe619abf3,0x644898f2,0x68fbacdb}},	//   pšti, рди_, endi, _trud,
   {{0x44278894,0x25adbb8c,0x6448bb8d,0x64890b80}},	//   _pln_, rael_, fndi, _džig,
   {{0x443ebb8e,0xfa898104,0xddcd05c5,0x63aa831d}},	//   git_, _dẫn_, ylaş, _cefn,
   {{0xcb69bb8f,0x63aa8355,0x27e7bb90,0xdb1c00f7}},	//   ране_, _defn, menn_, _scrú,
   {{0x69cb8397,0x27e7bb91,0x60c615bd,0x64488010}},	//   ngge, lenn_, tukm, andi,
   {{0xe3ae8c8e,0x645abb92,0x61e63b93,0xa3aa2743}},	//   _об_, boti, rekl, _गजल_,
   {{0x442cbb94,0x61e60e63,0x645abb95,0x27e7bb96}},	//   chd_, sekl, coti, nenn_,
   {{0xa3d28063,0x26c7bb97,0x224d81bf,0x61e63b98}},	//   _हॉट_, nuno_, _ojek_, pekl,
   {{0x22b580eb,0xddcd08c5,0x27e7bb99,0x7649bb9a}},	//   māk_, rlaş, henn_, nney,
   {{0x3ea0805c,0x22b580eb,0x7e6412b0,0x81d300ab}},	// [2840] ćiti_, lāk_, rlip, _হোক_,
   {{0x25a023f8,0x27e78f7c,0xebe30af2,0xddcd099b}},	//   sbil_, jenn_, моуп, plaş,
   {{0x27e786c4,0x6e2d179f,0xd24f004e,0x22b580eb}},	//   denn_, bhab, _سنی_, nāk_,
   {{0x6e2d3b9b,0x443ebb9c,0xe8fa9777,0xddcd002e}},	//   chab, zit_, иле_, rmaţ,
   {{0x3ead003b,0x644892fa,0x645abb9d,0x28f8bb9e}},	//   ćete_, yndi, yoti, сель_,
   {{0x443ebb9f,0x6489017f,0x973c826c,0x224d80dd}},	//   xit_, _džid, _heći, _ejek_,
   {{0x645a8025,0xdcf60059,0x26c7bba0,0xdb03b49a}},	//   voti, mayı, guno_, _bení,
   {{0xdcf60182,0x443ebba1,0xdb0381d0,0x629e0a6f}},	//   layı, wit_, _cení, mppo,
   {{0x443ebba2,0x62988025,0x645abba3,0xdb03801b}},	//   tit_, _stvo, toti, _dení,
   {{0x186a8698,0xfa898028,0xd37882a5,0x47c39194}},	//   _тази_, _vẫn_, leći_, _обув,
   {{0x443e8e79,0x2bcf12e0,0x7e9180eb,0x1bfb00be}},	//   rit_, स्टा, _tāpa, בליב,
   {{0x2d9287d9,0x443ebba4,0xed5a9d34,0xd37882a5}},	//   _üye_, sit_, _кое_, neći_,
   {{0x443eb73b,0xda7b8051,0x9f5ea5b3,0xb4e918b8}},	//   pit_, ינטר, _totó_, _मने_,
   {{0xe8d92ae3,0x76408110,0x22b580eb,0x443e8168}},	//   _ngụ_, limy, bāk_, qit_,
   {{0x261c0307,0x5694044f,0x60c2bba5,0x69cb8bc5}},	//   _níos_, даст, hrom, ygge,
   {{0x2bdd0beb,0x60c2803e,0xd378805c,0x27e782d6}},	//   न्ना, krom, jeći_, zenn_,
   {{0xd378803a,0x98be002e,0x6e2d3ba6,0x60c28bcf}},	// [2850] deći_, ătă_, rhab, jrom,
   {{0x60c2a7d9,0x6e2d2a19,0x26c7bba7,0x1c050105}},	//   drom, shab, yuno_, राइल_,
   {{0x2c000076,0xce5907b6,0x261c01a8,0x764981b4}},	//   राजू_, _ганц_, _cíos_, yney,
   {{0x26c78ca2,0x9f4c8980,0xcb138e82,0xa49b0580}},	//   vuno_, _cadí_, ולע_, _pròd,
   {{0x260809a3,0x8cc20996,0x22b580eb,0x22a78019}},	//   हारी_, _लियो, zāk_, zők_,
   {{0x442a01bc,0xf8078d0e,0xd3e300d5,0x261c03a8}},	//   _glb_, ючен, _تقسی, _fíos_,
   {{0xd00e80f7,0x224d813c,0xdb03801b,0xd378825b}},	//   الى_, _tjek_, _pení, beći_,
   {{0xdb08a54d,0x0609af2f,0x3e61808b,0x44ed3ba8}},	//   gadí, сник_, jótt_, _kž_,
   {{0x27e7bba9,0x7649bbaa,0xe4d680f7,0xdb0386a5}},	//   penn_, rney, كويت_, _vení,
   {{0x1fa78a08,0x22a78019,0x26c78ce9,0x870780f7}},	//   _фраг, tők_, puno_, _وبال,
   {{0xa3dd0023,0xdb039099,0x98b00067,0x2bdd0744}},	//   थ्य_, _tení, đača_, न्या,
   {{0x22b58341,0x2c6d0efc,0x26f98740,0x9f5e81e8}},	//   rāk_, _vždy_, ्मीर_, _totò_,
   {{0x48fe80ba,0x78720366,0x601d82d6,0x22b581a9}},	//   लियो_, hæve, _fèmt, sāk_,
   {{0xd378807d,0x3ce0809a,0x261c00f7,0xfe7981d0}},	//   zeći_, _कहते_, _níor_, lmů_,
   {{0x6441bbab,0x44ed0a56,0x973c8289,0x91cc801b}},	//   mili, _až_, _peći, _हालै,
   {{0x261c3b56,0xe1ff02ba,0xa2c0923a,0xddcd026c}},	//   _ríos_, llón_, _वित्, tmaš,
   {{0x973c803a,0x52db81ab,0x261c0013,0xd37882a5}},	// [2860] _veći, _बहुस, _síos_, veći_,
   {{0x44ed3bac,0x29003bad,0xb4633bae,0x6e243baf}},	//   _dž_, _iria_, екул, skib,
   {{0x61f63bb0,0xd378805c,0x62978333,0xbcfb0061}},	//   _kayl, teći_, _éxod, _szét,
   {{0x7aba8039,0xcc88801c,0x64891f3a,0xfe7981d0}},	//   מצעו, _sớm_, _džib, jmů_,
   {{0x6441bbb1,0x201a1ab9,0xd3788052,0x26d83bb2}},	//   kili, _kopi_, reći_, ltro_,
   {{0xd37882a5,0x4425979d,0x6441804f,0xb05b01ec}},	//   seći_, jkl_, jili, hrän,
   {{0x6441bbb3,0xdb0885dc,0xd378811f,0x442580ee}},	//   dili, tadí, peći_, dkl_,
   {{0x60c2bbb4,0x682b1014,0x26c50024,0x29003bb5}},	//   prom, _müda, šlog_, _oria_,
   {{0x6441bbb6,0xdb0884e8,0x628e3bb7,0xbcfb2190}},	//   fili, radí, _hubo, _nyél,
   {{0x628e3623,0x26ca3bb8,0x3949802a,0x682f8821}},	//   _kubo, kubo_, úase_, _rødg,
   {{0x644f83d3,0x61f63bb9,0x46a3869b,0x28af000f}},	//   écia, _bayl, _захв, जीनि,
   {{0xb05b00f2,0x7ae101ec,0x645e3b30,0x628e199f}},	//   grän, _älte, hopi, _mubo,
   {{0x628e3bba,0x21670554,0x2baf009a,0x29003666}},	//   _lubo, ятог, टरमा, _cria_,
   {{0xb8f53bbb,0x629c3bbc,0x645e0369,0xe1ff0333}},	//   _हम_, _otro, jopi, clón_,
   {{0x629c827f,0xf1c6016f,0x628e1cb1,0xb05b2651}},	//   írod, _वाचन, _nubo, brän,
   {{0x29003bbd,0xade280d4,0x3e4581a9,0xee49827d}},	//   _fria_, _कॉमन_, bētu_, hẽn_,
   {{0x629c0df1,0x320902c1,0xbcfb0065,0x91bc0039}},	// [2870] _atro, _inay_, _azér, _המחי,
   {{0x628e3107,0x44ed3ba8,0x26ca00e4,0x682f8366}},	//   _bubo, _vž_, bubo_, _køde,
   {{0x41d1809a,0x26ca01e8,0x628e0c1d,0x682f854f}},	//   _हादस, cubo_, _cubo, _jøde,
   {{0x628e003a,0x682f813c,0x3a26820d,0x69cf01f6}},	//   _dubo, _møde, gkop_, ngce,
   {{0xa3be8663,0x44ed3bbe,0xbcfb0019,0xd37880d2}},	//   ेला_, _už_, _ezér, meću_,
   {{0x44250355,0x23c303d3,0x9f478efc,0x7a3601ac}},	//   _ôl_, _déjà_, lené_, nštr,
   {{0xe81e9344,0x320902d0,0x6441938e,0x682f805f}},	//   _बकरा_, _onay_, vili, _rødd,
   {{0x64418355,0xc7448013,0xdb03826f,0x764d3bbf}},	//   wili, عضوي, _nená, nnay,
   {{0x3d000e5b,0xdb01b60c,0x280881d0,0xdb07349a}},	//   रिये_, mblé, átní_, _mejí,
   {{0x61f61b37,0x32093bc0,0xe7b582e3,0x09c6016f}},	//   _sayl, _anay_, _آماد, वल्य,
   {{0x61f602bb,0xb05b1bc0,0x1b1f00ab,0x3a2dbbc1}},	//   _payl, trän, _যেতে_, _klep_,
   {{0x6441b05c,0x2900016f,0x25740125,0xd37895db}},	//   sili, _pria_, _júlí_, jeću_,
   {{0x6441bbc2,0x9f478038,0xd37881dd,0x645e0010}},	//   pili, dené_, deću_, yopi,
   {{0x3e458029,0xaac58996,0x26d80098,0x7e69829e}},	//   rētu_, _विपक, ttro_, llep,
   {{0x683000f2,0x2ba381a2,0x26d8002a,0x25b202c4}},	//   _rädd, _ख्या, utro_, tayl_,
   {{0x29000722,0x764d3bc3,0x628e3bc4,0x7bc301fa}},	//   _tria_, gnay, _rubo, ónun,
   {{0x629c0942,0x628e003b,0x224038dc,0x2bd48105}},	// [2880] _stro, _subo, _imik_, _दामा,
   {{0xd7ca003d,0xf1bf0b4c,0x6d4480e1,0x764d01b4}},	//   _بوده_, nkán_, _žiak, anay,
   {{0x645e3bc5,0x9f47803e,0x2bdd001b,0x63bc8ff4}},	//   ropi, bené_, न्धा, órni,
   {{0x7e69985c,0xfaf800eb,0x63ae3bc6,0x63a90390}},	//   jlep, _šīs_, _webn, _đene,
   {{0x5fc985b3,0x2bc703db,0x249d81c0,0x08979a3c}},	//   _राखल, _लाचा, _ntwm_, وضوع_,
   {{0x7e62bbc7,0x628e381c,0x0ee20bb8,0x2bdd275c}},	//   _skop, _tubo, _पहाड, न्दा,
   {{0x44442f3a,0x61ebbbc8,0x629c1277,0x63833bc9}},	//   mi_, begl, _utro, _агра,
   {{0x26c0bbca,0x2487803c,0x64891487,0x7e69bbcb}},	//   čio_, _ainm_, _užic, glep,
   {{0xdb08862f,0x752402ec,0x01d7830f,0x83fc8654}},	//   dadá, nyiz, _توقع_, hođe,
   {{0x44443bcc,0x83fc82fd,0x9f47827f,0xd3788289}},	//   ni_, kođe, zené_, zeću_,
   {{0xcc888142,0x44443bcd,0x764d02a3,0xd6cf806b}},	//   _mới_, ii_, ynay, _نقل_,
   {{0xc7b8803a,0x7e62bbce,0xb5fb0032,0xdb088061}},	//   _dođe_, _ukop, _akán, gadá,
   {{0x9f478a21,0x7e60bbcf,0x69dd007b,0xd8488133}},	//   vené_, momp, rfse, họm_,
   {{0x61eb8063,0x7e608812,0x656f81ec,0x601d89c4}},	//   zegl, lomp, üche, _jèmp,
   {{0x5f9417f4,0x83fc803b,0x290d002e,0x2bf3816f}},	//   тист, gođe, ţea_, _असतं_,
   {{0x44443bd0,0x41e70d13,0x5c990a14,0x32090122}},	//   ei_, _ціка, зкая_, _unay_,
   {{0x44443a20,0x78a2a828,0x5c750009,0xd37882a5}},	// [2890] fi_, jpov, елат, reću_,
   {{0x83fc8052,0x78a2803e,0x9f4c026f,0x6f030118}},	//   bođe, dpov, ždá_, _ánco,
   {{0xf1b9803a,0xb5fd84a8,0x64890110,0x9f479c18}},	//   _loše_, loše, _džia, pené_,
   {{0x44443bd1,0x6830016d,0xdb1c2509,0x7d02bbd2}},	//   ai_, _väde, _acró, _oros,
   {{0x5d852f0a,0xb5fd80ce,0x0ef7809a,0x798d0c53}},	//   _سلسل, noše, ंट्स_, _mgaw,
   {{0x61eb8353,0x160d016f,0x661d0901,0xd848819d}},	//   segl, हावर_, _hosk, bọm_,
   {{0x661d0364,0xa2c08b84,0x64453385,0x7e69bbd3}},	//   _kosk, _विष्, mihi, tlep,
   {{0x7d02bbd4,0x64453bd5,0x798d0c14,0x661d0009}},	//   _bros, lihi, _ngaw, _josk,
   {{0x661d3bd6,0x7e69810b,0xb5fd8279,0xdfdb8098}},	//   _mosk, rlep, joše, _мъж_,
   {{0xa2c090c5,0xa2c4035a,0x7d02bbd7,0x64453bd8}},	//   _विश्, ांच्, _dros, nihi,
   {{0x7d028bf0,0xdb039d1a,0xdb0894a8,0x7e69bbd9}},	//   _eros, _menç, tadá, plep,
   {{0x44443bda,0x83fc8025,0xb87b11b9,0x64453bdb}},	//   zi_, vođe, ntíf, hihi,
   {{0xdb08bbdc,0x660b8288,0xfce5835f,0x64453bdd}},	//   radá, _ingk, _чоло, kihi,
   {{0x26c78098,0x7af50019,0x6e298aa2,0x95cc8085}},	//   orno_, _oszt, lkeb, _çərç,
   {{0x44440743,0xdee30328,0xbcfb0019,0x2edd8ebf}},	//   vi_, лори, _szép, _महोत,
   {{0x444437b4,0x26128bb8,0x83fc805c,0x9f583bde}},	//   wi_, थायी_, rođe, ndré_,
   {{0x61e42562,0x661d1988,0x660b8359,0x7af50019}},	// [28a0] _ibil, _dosk, _mngk, _aszt,
   {{0x44442bb8,0x799b8300,0x76443bdf,0x394d03a8}},	//   ui_, _afuw, siiy, úese_,
   {{0x4fd7093f,0xe7c983db,0x7fd70158,0x660b8e60}},	//   _אויב_, _राजप, _אויס_, _ongk,
   {{0xcc888142,0x3ce08006,0x09c700ab,0x6ad00035}},	//   _với_, _कहले_, ষ্ঠা, _हमीर,
   {{0x44440573,0x47b300c8,0x61e4283a,0x64453be0}},	//   pi_, _জাতী, _mbil, bihi,
   {{0x660b9ad4,0xcc888104,0x25dda23a,0x44443be1}},	//   _angk, _tới_, क्सी_, qi_,
   {{0x61e40025,0x78a2807d,0x7e6080d7,0xdb0a806a}},	//   _obil, spov, tomp, _udfø,
   {{0x78a280c3,0x6fd281fe,0x7d090118,0x5fd28072}},	//   ppov, _सावं, _áesc, _सावल,
   {{0x5454bac1,0x02e0001b,0xfd1285ff,0x69c08609}},	//   квит, _नहुन, اجع_, _idme,
   {{0x660b8455,0xccf30039,0xf1b981a1,0x7d1d8106}},	//   _engk, רכז_, _voše_, ässa,
   {{0x200cbbe2,0x6fd70074,0xdb0e1f90,0xaa59168a}},	//   _indi_, _बाबू, _bebé, дину_,
   {{0x5ab7093f,0x7d02b807,0xfe7282e3,0x200c876d}},	//   עלכע_, _tros, _صدا_, _hndi_,
   {{0x442e8bc5,0x661d3be3,0x644502a3,0x64a38a4c}},	//   _tlf_, _rosk, yihi, _бача,
   {{0x61e40146,0xb5fd8796,0xdb070061,0xdb038106}},	//   _ebil, roše, _lejá, _benä,
   {{0x661d1234,0xadf4823c,0xa3d9b792,0x201e8ff2}},	//   _posk, _आसान_, _डॉट_, _moti_,
   {{0x27fa002a,0xa5bb0032,0x201ebbe4,0x78ad0b5e}},	//   _eapn_, _alór, _loti_, _twav,
   {{0x64453be5,0x8bc71285,0xf1bf0c83,0xb05b0338}},	// [28b0] tihi, есед, nkám_, nräk,
   {{0x201eaad4,0x69c087fc,0x61e4111b,0xb4e107e6}},	//   _noti_, _adme, _zbil, _दही_,
   {{0x64453be6,0xdb039fee,0xb5fd8140,0xdb070061}},	//   rihi, _venç, nošc, _bejá,
   {{0x61fd2d85,0x61ef04cc,0x200c9437,0xaca3019d}},	//   ndsl, necl, _andi_, _amục,
   {{0xd3668077,0x25a904a7,0x7e6d3be7,0xa5bb3be8}},	//   _چه_, mbal_, mlap, _flór,
   {{0xd3668077,0x7e6d3be9,0xdb18802a,0x28980039}},	//   _نه_, llap, _adví, עדון_,
   {{0x6c540470,0xf456007c,0xe4543bea,0x8f9c00be}},	//   _скру, _יישר_, _скры, ליגי,
   {{0x2499a6d5,0x60c481e2,0x200cbbeb,0x59d8864a}},	//   ísmo_, šima, _endi_, _डायर,
   {{0x320d8079,0x9f47bbec,0x9f4a0722,0xdb0a83a8}},	//   _iney_, mení_, rebé_, _defí,
   {{0x9f47800d,0xb5fb3bed,0x6e29806f,0x61e400e5}},	//   lení_, _skál, skeb, _sbil,
   {{0x68300006,0x61fbbbee,0xbf15819f,0x6fdf00d4}},	//   _näda, _kaul, _جواب, _पॉइं,
   {{0x660b94ec,0xa696810f,0x201e80f1,0x61fbbbef}},	//   _ungk, _סכנה_, _zoti_, _jaul,
   {{0x25a93363,0x463a8158,0x29040376,0x91ba81c6}},	//   dbal_, _קענע, íma_, ומרי,
   {{0x61fbbbf0,0x6a7888f1,0x69a23bf1,0x25dd8519}},	//   _laul, mífe, _क्री, क्री_,
   {{0xf1b385fc,0x998f8110,0x61e43bf2,0x6443bbf3}},	//   ुणान, nigų_, _tbil, _imni,
   {{0x61e40503,0x9f4783fb,0xe8d18424,0x7e6d1ac4}},	//   _ubil, jení_, _समूच, glap,
   {{0x9f47803e,0x0d86174a,0x6a7888f1,0x44313bf4}},	// [28c0] dení_, тлан, nífe, _blz_,
   {{0xe0b70f60,0x03a607b6,0x64890084,0x9f5a03ed}},	//   _שליט_, тижо, _džio, _japë_,
   {{0x2bd48076,0x61fbbbf5,0xe9da9cf8,0x321f826b}},	//   _दासा, _baul, дке_, _bouy_,
   {{0x201e8205,0x98a69630,0x6489025b,0x831a80be}},	//   _soti_, виде, _užin, וועז,
   {{0x201ebbf6,0x61fb84b9,0xdb0a81df,0x83fc826c}},	//   _poti_, _daul, _refí, hođa,
   {{0x03a3035f,0xf1bf04e8,0x6b9c02df,0x61fb82f9}},	//   _виро, vkám_, _ufrg, _eaul,
   {{0x8c431fab,0x201eaa4d,0x044322b7,0xddcd0087}},	//   _тере, _voti_, _терн, noaş,
   {{0x9f47800d,0x6443bbf7,0x61fbbbf8,0x35f4a42e}},	//   cení_, _amni, _gaul, упир,
   {{0x29048012,0x61ef0358,0x201e802e,0x9f49816b}},	//   _urma_, vecl, _toti_, čkám_,
   {{0xfa8a0028,0x200cbbf9,0x1e1f03db,0xa84a80b7}},	//   _mẫu_, _undi_, _यक्ष_, _غلام_,
   {{0x83fc812b,0x1db23bfa,0x0bb7025f,0x61fbaaa0}},	//   gođa, जरात, כלים_, _yaul,
   {{0x27e985f5,0xf2d30158,0x61e29529,0x60dd0711}},	//   đane_, סער_, nfol, ttsm,
   {{0x9f45826f,0xcc8880ff,0x6a788118,0x2e37825f}},	//   _malý_, _bớt_, cífe, _בראש_,
   {{0x9f47800d,0x36d50328,0xdb05008b,0x69b480d4}},	//   zení_, логр, rahú, आरडी,
   {{0x25a93bfb,0xf1b9805c,0x442cbbfc,0x69d382f1}},	//   tbal_, _loša_, mkd_, _डाली,
   {{0x2d8f006a,0x61e2bbfd,0x64438035,0xe654004a}},	//   øge_, jfol, _zmni, авсь,
   {{0x25a6040e,0x3ea9803a,0x23b6800f,0x9f47800d}},	// [28d0] ñola_, ćati_, _आजाद, vení_,
   {{0x61fba338,0x7e6d189e,0x25a93bfe,0x57f5164c}},	//   _saul, slap, sbal_, _спот,
   {{0x61fbbbff,0x68e98098,0x61e29106,0x9f4783f2}},	//   _paul, _sped, ffol, tení_,
   {{0x64489e74,0x6e36026f,0x61fb80dd,0xe1ff3c00}},	//   hidi, chyb, _qaul, ndó_,
   {{0xdca680f7,0x6e2d3c01,0xe0df3c02,0x660f0b80}},	//   _دى_, mkab, ntò_, _inck,
   {{0xb5fd80eb,0x628d00fc,0x6e2d3c03,0xf1b98115}},	//   doša, _liao, lkab, _doša_,
   {{0x61fbbc04,0x6448bc05,0x81cb00ab,0x3669960f}},	//   _taul, didi, র্য_, нако_,
   {{0x83fc803a,0xc7b88024,0xc69400be,0x644380b9}},	//   vođa, _vođa_, סאפ_, _smni,
   {{0xf1b98e9f,0x7aea8706,0x7a2601fa,0x4bd981e2}},	//   _goša_, _apft, _mótt, ньня_,
   {{0x6448bc06,0xe5768048,0x62953c07,0x628d0362}},	//   gidi, ызы_, _kuzo, _aiao,
   {{0x2bd49d01,0x6e2d3c08,0xcc888129,0xeab9814c}},	//   _दारा, kkab, _rớt_, эйн_,
   {{0xe9df00f7,0x83fc81dd,0x628d3c09,0x82361190}},	//   siún_, rođa, _ciao, اردا,
   {{0x6448bc0a,0x7d0902a5,0x628d2322,0xfd108154}},	//   bidi, _šesn, _diao, _وجه_,
   {{0xddc4001b,0x9f430009,0xdb03a84c,0x7a263c0b}},	//   dliš, kejä_, _menú, _rótu,
   {{0x75298019,0xae179664,0xd5b786b7,0x3ebe007b}},	//   lyez, थापन_, _इजाज, étt_,
   {{0x661b8867,0x6e2d043b,0x81cb00ab,0x67210589}},	//   njuk, gkab, র্ব_, älja,
   {{0x7529bc0c,0x62950102,0x753bbc0d,0x7a26008b}},	// [28e0] nyez, _auzo, nzuz, _dótt,
   {{0x63b50390,0x661b98c2,0x26d10234,0xbc6a0bbe}},	//   _cezn, hjuk, buzo_, رمان_,
   {{0x6e460878,0x49ca9508,0xd62a3c0e,0x61e2804a}},	//   _бенз, елен_, _зоне_, tfol,
   {{0x6448bc0f,0x78a42d38,0xb05b0106,0x7afcbc10}},	//   zidi, _ktiv, tsäg, ærti,
   {{0x28f88e86,0xad9b01ac,0x6448bc11,0xdb01816b}},	//   тель_, _vnút, yidi, valý,
   {{0x7d043c12,0xdb0387e0,0xb8dc8074,0xb5fd80eb}},	//   mvis, _denú, _आब_, voša,
   {{0x62953c13,0xdb18816b,0xa3d7897d,0xddc401a9}},	//   _guzo, _odvá, िलन_, rniņ,
   {{0xb5fd8029,0xceb30039,0x6448831d,0x69d609c1}},	//   toša, זיה_, widi, _भाषी,
   {{0x2fd68013,0x81cb00c8,0x7d040082,0x3ce03c14}},	//   _متاح, র্ড_, nvis, ntiv_,
   {{0x69c4011e,0xb5fd80eb,0x2a66809c,0x628281b4}},	//   _adie, roša, loob_, lmoo,
   {{0x78a40073,0xd7938013,0x2f56a83b,0xb5fd812b}},	//   _ativ, _المخ, _стас, mošn,
   {{0xa2cc0fea,0xb5fd93cf,0x6448bc15,0x2a66856c}},	//   _हिन्, lošn, sidi, noob_,
   {{0xa2c08744,0x9f47803e,0x6448bc16,0xe1ff3c17}},	//   _विक्, mená_, pidi, rdó_,
   {{0x9f47803e,0x62828282,0x69c43c18,0xb5fd826c}},	//   lená_, hmoo, _edie, nošn,
   {{0xd904850c,0xf8d1bc19,0x6e22bc1a,0xae098023}},	//   _کی_, _सम्प, _koob, वाचन_,
   {{0x63b51cf3,0xadf98bb8,0x69c00333,0xddc40088}},	//   _sezn, ्ययन_, ómet, tliš,
   {{0x6e228952,0xdb0e05e4,0xd3a702df,0xbcfb08f9}},	// [28f0] _moob, _debí, греп, _nyét,
   {{0x68ed3c1b,0xad9b0e67,0x6e2d013c,0x224b3c1c}},	//   _ipad, _saúd, skab, lick_,
   {{0x81cb00ab,0x7d043c1d,0xe29800e8,0x09bc80ab}},	//   র্ণ_, avis, гає_, _ইউজা,
   {{0x98a99487,0x6e22bc1e,0xdb07016d,0xa4d51138}},	//   šač_, _noob, _rejä, _комі,
   {{0x212b3c1f,0x90e48154,0x9f478a21,0x3ce00087}},	//   nych_, مسون, dená_, ctiv_,
   {{0x63ba8a20,0x43943c20,0x2ca9003d,0x41268009}},	//   jatn, _гарс, mpad_, рошо_,
   {{0x6e22bc21,0x59c5016f,0xc7d8007c,0x2ca92a33}},	//   _boob, वणार, אווי_, lpad_,
   {{0x6e22bc22,0x060995e0,0x212b01ac,0x442304e4}},	//   _coob, тник_, kych_, _hoj_,
   {{0x4423146a,0x680b8029,0x63ba9ce5,0xe61694ef}},	//   _koj_, _pēdē, fatn, рды_,
   {{0x4423003a,0x3ce5901b,0x212b3c23,0xa0c480f7}},	//   _joj_, _कहीं_, dych_, _ديكو,
   {{0x44232494,0x68ed3c24,0x6e22bc25,0x9f45bc26}},	//   _moj_, _apad, _foob, _való_,
   {{0x442301e9,0x6e2282a3,0xa2d626ee,0xfe9a8039}},	//   _loj_, _goob, मंत्, _סינמ,
   {{0xd1760791,0x61e98d4c,0x63ba8057,0x6721016d}},	//   рыны, _mbel, batn, äljn,
   {{0x80cd89a3,0x7d0412bb,0x98a0803a,0x442301e9}},	//   _सिने, vvis, šić_, _noj_,
   {{0x61e9bc27,0xc4478117,0x6fd703eb,0xdfcf00f7}},	//   _obel, _لیکن_, _बारू, ظيف_,
   {{0x7c2387a3,0x7d043c28,0x3ce004b7,0x6a761e00}},	//   _honr, tvis, ttiv_, máfo,
   {{0x212b0063,0x1c460110,0xa4463c29,0x656f0114}},	// [2900] cych_, анам, анад, _cych,
   {{0x629e9313,0x61e9bc2a,0x69db85b4,0x442301e9}},	//   _époc, _abel, _acue, _coj_,
   {{0xb87b3c2b,0x68fbbc2c,0x25adbc2d,0x2bdda539}},	//   stíc, _asud, kbel_, _माना,
   {{0x27ed003a,0x09e69cf6,0x2cbf9922,0xcc888028}},	//   đene_, родн, ksud_, _lớp_,
   {{0x63ba810b,0x6282bc2e,0x9f47826f,0x6f088a21}},	//   yatn, rmoo, vená_, _srdc,
   {{0x61e9bc2f,0x6e228952,0x3ec68009,0x44230147}},	//   _ebel, _soob, асиб, _goj_,
   {{0x63ba803b,0x212b009a,0x9f58009f,0xb87b05e4}},	//   vatn, zych_, ndrà_, ntía,
   {{0x27e98025,0x2c0a035a,0x63ba89ca,0x2fc5802a}},	//   đana_, _होतं_, watn, _edlg_,
   {{0x63ba89a4,0x80a6826a,0x15e2816f,0x27e08041}},	//   tatn, _ضمان, क्षर_, ƙin_,
   {{0x7c23bc30,0x61ff3c31,0xaca401bc,0x3cf90816}},	//   _conr, _saql, _amịr, _उनसे_,
   {{0x212b0d38,0x25ad923f,0x64890699,0xdfcf81a8}},	//   wych_, bbel_, _džih, _زين_,
   {{0x2ca93c32,0xfce68171,0xade2b13a,0x212b0dee}},	//   ypad_, _водо, क्शन_, tych_,
   {{0x224b3c33,0x63babc34,0xf99f0722,0x984b0081}},	//   rick_, patn, rcè_, вява_,
   {{0x212b3c23,0x656f000d,0x26c50289,0xf1a70697}},	//   rych_, _rych, šlom_, _क्रन,
   {{0x442301c5,0xf8bf1b20,0xc058035f,0xe29780a9}},	//   _roj_, ssé_, рія_, _кај_,
   {{0x44230282,0x7a360084,0x2ca909ff,0xdda80087}},	//   _soj_, kšty, tpad_, итул_,
   {{0x442301c5,0xdb050013,0xb5fdbc35,0x63b881c0}},	// [2910] _poj_, rbhí, došl, _kevn,
   {{0x656f027f,0x61e989da,0x0ba72e2e,0x44232928}},	//   _vych, _sbel, ршам, _qoj_,
   {{0xd7dc023c,0xed59803a,0x44230640,0x656f009a}},	//   _बातच, maže_, _voj_, _wych,
   {{0xed598503,0x6298bc36,0x63b8801b,0x2ca90106}},	//   laže_, _muvo, _levn, ppad_,
   {{0x44233c37,0x3ce58105,0x20010a63,0xe1ff3c38}},	//   _toj_, _कहें_, _kahi_, llós_,
   {{0x9f5801ca,0x63b880e8,0x81dd00ab,0x20033c39}},	//   ldrá_, _nevn, ড়ি_, ndji_,
   {{0x26c19385,0x6298b340,0x752d1fce,0xad9b0187}},	//   ého_, _nuvo, lyaz, _gaúc,
   {{0x7c23bc3a,0xa2c0825e,0x9f580693,0x26c98067}},	//   _sonr, _विज्, ndrá_, čao_,
   {{0x81dd00c8,0xdd918117,0x68fb8669,0xeb999a19}},	//   ড়া_, _ہوا_, _usud, лип_,
   {{0xc6e78cde,0x200100ad,0x7c3abbb0,0x6a761984}},	//   _відп, _nahi_, ghtr, táfo,
   {{0x26c502a5,0x2a7f8282,0xd6db84ae,0xe365a306}},	//   šloj_, _khub_, _шта_, скни,
   {{0x69d9bc3b,0xf59580f7,0x81cb00ab,0x8d9580f7}},	//   ngwe, _الإج, র্স_, _الإش,
   {{0x20011149,0xbca5803d,0x66ea811c,0xdb15136f}},	//   _bahi_, _امتي, _təkc, _dezé,
   {{0x7c3abc3c,0x22490859,0xf1b981dd,0x8fa30cec}},	//   chtr, _emak_, _leš_, заре,
   {{0xe7371860,0x9e5a3c3d,0xdb1c016b,0x2ca68122}},	//   бер_, граф_, _odrá, _ztod_,
   {{0x2a7f81c0,0xf1b9bc3e,0xb05b189c,0xb87b157a}},	//   _nhub_, _neš_, tsäc, rtía,
   {{0xe57a0dc0,0xb87b0511,0x15b90196,0x629881ec}},	// [2920] уза_, stía, рысы_, _zuvo,
   {{0x8ccf809a,0xd37e8042,0x9f47bc3f,0x09b00264}},	//   _दिनो, šćem_, cenç_, _কাটা,
   {{0xfdf9a3bd,0xdb0a82af,0xb05b3c40,0xadf9800c}},	//   ्यास_, _gefä, rrät, ्यान_,
   {{0xd5b90009,0xb05b016d,0xb7b5819d,0xd186ab3f}},	//   _всё_, srät, _kọw, блей,
   {{0xa3d78744,0x69db00be,0xb05b0106,0x9c82807a}},	//   िला_, אַוו, prät, ščil,
   {{0x64a3215c,0x33d5035f,0x66043c41,0xdfcf8013}},	//   _хара, _міст, ldik, فيه_,
   {{0xb5fd8025,0x2ca68082,0x68e280df,0xe8190778}},	//   pošl, _stod_, stod, दाता_,
   {{0xb8ce8a49,0x66043c42,0x60c40669,0x91e38ae7}},	//   _কি_, ndik, _ovim, _носе,
   {{0x63b88efc,0x6298b5aa,0xe12387b6,0x68300338}},	//   _pevn, _suvo, _емти, _vädj,
   {{0x96ba941e,0x22493c43,0x4438008e,0x60c2bc44}},	//   _буду_, _smak_, _jlr_, msom,
   {{0x6e969ddd,0xe69680f7,0x60c284dc,0x7d0b9384}},	//   _الصا, _الصد, lsom, _ergs,
   {{0xe7178051,0x80dd00c8,0x7c3a80f1,0xc33302f6}},	//   _לחבר_, যবস্, shtr, פור_,
   {{0x63be0877,0x60c2bc45,0x9e6580f7,0xa3ca2c4f}},	//   kapn, nsom, _بالن, ोला_,
   {{0xf1db0101,0x60c29149,0x25de99e8,0xdb1c006a}},	//   _भावन, isom, _गाडी_, _idræ,
   {{0x63be09ca,0x9f47bc46,0x02a281bc,0xddc9826c}},	//   dapn, renç_, _klọọ, lleš,
   {{0x66028074,0x22492bea,0x20012aa0,0xed59b114}},	//   _jaok, _umak_, _wahi_, saže_,
   {{0x5fc88aad,0x2001010a,0x61ed3c47,0x443800b9}},	// [2930] रणाल, _tahi_, _ibal, _blr_,
   {{0x7bdabc48,0x60c28e23,0x44e2807b,0xb6069487}},	//   ngtu, dsom, ið_, lašć,
   {{0x62808267,0xd37b1401,0x319e8133,0x645c0580}},	//   _bhmo, уча_, _ịza_, _djri,
   {{0x62808858,0x2a7f822c,0x6602aa42,0x998dbc49}},	//   _chmo, _qhub_, _naok, _aleš_,
   {{0x61ed273b,0x4ac50076,0x7bc30125,0xf1b984c4}},	//   _mbal, _लटकव, ónus, _veš_,
   {{0xc60100c8,0x9ea992b2,0x16a99485,0xd00981ae}},	//   _একটা_, авка_, авки_, реке_,
   {{0xe7398c6e,0x62358009,0x6e3ba0b3,0x46399156}},	//   рей_, _деву, thub, ичия_,
   {{0x82378f24,0xe7f5809a,0x7bda837a,0x25de816f}},	//   _ارسا, _इसका_, egtu, _गाणी_,
   {{0x6e3b8867,0x7e69838e,0xddc9807a,0x998d9024}},	//   rhub, roep, gleš, _fleš_,
   {{0x61ed3c4a,0x6e3bbc4b,0x7e6982f7,0x72c58087}},	//   _abal, shub, soep, обоз,
   {{0x60c4003a,0xfbd204de,0x61ed0c2e,0x7c2701a1}},	//   _svim, ותי_, _bbal, _mojr,
   {{0x3cfd90af,0xa2cc05fb,0x6e3b805d,0x7c270168}},	//   _tswv_, _हिस्, qhub, _lojr,
   {{0xb87b12cc,0x644f82be,0xe44e8a08,0x9f478009}},	//   rtín, écis, _жж_, senä_,
   {{0x6e3981c0,0xb5fd8450,0x61ed3c4c,0xdfd201a8}},	//   _hlwb, košk, _ebal, بيس_,
   {{0x7d09bc4d,0xb5fd8052,0x81b900ab,0x969510f8}},	//   lves, jošk, _চার_, зруш,
   {{0x4427bc4e,0x27ed003a,0x78a9801b,0x85053c4f}},	//   _hon_, đena_, _otev, रिंट_,
   {{0x66043c50,0x4427bc51,0x63be3c52,0x0c263c53}},	// [2940] rdik, _kon_, tapn, оман,
   {{0x69c982a3,0x44279d6a,0x2aed80a5,0xf20286a7}},	//   _adee, _jon_, _जहाँ_, _रोज़_,
   {{0x442786e3,0x290dbc54,0x6d40ae4d,0xf1b985f3}},	//   _mon_, _area_, zzma, _gošk_,
   {{0x290dbc55,0x4427801c,0xe4da003d,0x60c2bc56}},	//   _brea_, _lon_, _پوست_, tsom,
   {{0xa88a8071,0x290db340,0xdb1abc57,0x208a8558}},	//   айда_, _crea_, raté, айди_,
   {{0x4427bc58,0xb8f28f1b,0x764b831d,0x29000748}},	//   _non_, _वि_, _amgy, _msia_,
   {{0xab2a0021,0x71a68705,0x26d83c59,0xb5fd826c}},	//   _това_, _мавз, nuro_, cošk,
   {{0x44278af9,0x27f830e5,0x25bfbc5a,0x290d8118}},	//   _aon_, hern_, gaul_, _frea_,
   {{0x4427bc5b,0x629c3c5c,0xe4e6835f,0x27f81647}},	//   _bon_, _huro, ційн, kern_,
   {{0x4427bc5d,0x629c3c5e,0x44e28125,0x26d83c5f}},	//   _con_, _kuro, rð_, kuro_,
   {{0x629c00a9,0x2be20b86,0x44278051,0xa3e205e8}},	//   _juro, _पाना, _don_, _धान_,
   {{0x26d83c60,0x629c3c61,0x64893c62,0x63bc02af}},	//   duro_, _muro, _uživ, _lern,
   {{0x4427bc63,0x3204809a,0x27f83c64,0xc21800e8}},	//   _fon_, _mamy_, fern_, ією_,
   {{0x44279a03,0x9f4c027f,0x27f83a53,0xb87b01a8}},	//   _gon_, ždý_, gern_, rtío,
   {{0xd5bb35cc,0x764b831d,0x629c0110,0x26c53c65}},	//   иса_, _ymgy, _nuro, élo_,
   {{0x26cd003a,0x4427bc66,0x61ed3c67,0xc7b880ce}},	//   čeo_, _zon_, _ubal, _dođi_,
   {{0x4427bc68,0x2d8f034a,0x63bc383f,0xdb0385e4}},	// [2950] _yon_, äge_, _bern, _fenó,
   {{0xf1d88023,0xfbab0048,0x645abc69,0x63bc3c6a}},	//   _डाउन, ртай_, nnti, _cern,
   {{0x63bc3c6b,0xb87b0272,0x26d83c6c,0x7d09bc6d}},	//   _dern, ntím, curo_, zves,
   {{0xb5fd8db7,0x290d802e,0xf9c7835f,0x629c3c6e}},	//   rošk, _prea_, іщен, _duro,
   {{0x8d87361c,0x361a04de,0xddc8809a,0xdb188118}},	//   _фунд, _הורד, łośc, _devé,
   {{0x63bc3c6f,0x629c1bea,0x290d802e,0x7bce8207}},	//   _gern, _furo, _vrea_, óbul,
   {{0xf1b9812b,0x629c3c70,0x443ebc71,0x9f4781d6}},	//   _loši_, _guro, dht_, lenú_,
   {{0xf1bf87ca,0x4427bc72,0x682f8bc5,0x443e81ec}},	//   _þá_, _son_, _nødv, eht_,
   {{0x63bc3c73,0x27f8131e,0x7bca802a,0x225fa168}},	//   _yern, yern_, _bdfu, _ijuk_,
   {{0x443e804c,0x2900008e,0x69dd3c74,0x442783e7}},	//   ght_, _rsia_, egse, _qon_,
   {{0x44278943,0xa822803d,0x63a502af,0xdb0e01ec}},	//   _von_, _سکون, ichn, _gebä,
   {{0x2005bc75,0xdb03862f,0x645abc76,0xfc3f178e}},	//   _hali_, _senó, anti, _stíl_,
   {{0x20058859,0x4427bc77,0x27f83c78,0xdb0881a8}},	//   _kali_, _ton_, tern_, fadó,
   {{0x443e8bd5,0x26d83c79,0x9f5a047f,0x27f801ec}},	//   cht_, turo_, _papà_, uern_,
   {{0xe7ed9880,0xe7373c7a,0x7bc18c0f,0x63bc0d11}},	//   च्या_, пер_, malu, _rern,
   {{0x7bc19a67,0x200580d7,0x629a00e7,0x26d800b4}},	//   lalu, _lali_, _étoi, ruro_,
   {{0x63bc0393,0x29000057,0xdb1891b9,0x27f83c7b}},	// [2960] _pern, _usia_, _revé, pern_,
   {{0x7bc1bc7c,0x26d81f78,0x224dbc7d,0x2005bc7e}},	//   nalu, puro_, _amek_, _nali_,
   {{0xeb971bc1,0x179b010f,0x629620b0,0xe7b70039}},	//   чих_, _לייב, _kiyo, _מהיר_,
   {{0x63bc0077,0x629610fe,0xd36f12c5,0xdb1c0168}},	//   _wern, _jiyo, دهم_, _herë,
   {{0xe5720b76,0x63bc3c7f,0x2005bc80,0x645abc81}},	//   _سطح_, _tern, _bali_, ynti,
   {{0x66063c82,0x200582a3,0x7bc1bc83,0x186794f6}},	//   _hakk, _cali_, jalu, пачи_,
   {{0x2005bc84,0x81d400c8,0xed59a944,0x8f9b03c8}},	//   _dali_, স্য_, važa_, זיצי,
   {{0x225a8013,0x442a3c85,0x7e648088,0x62963c86}},	//   _الرد_, _hob_, čipo, _niyo,
   {{0x6d440698,0x442a3c87,0x7bc1bc88,0x682f9dd5}},	//   nzia, _kob_, falu, _rødv,
   {{0x20058a8e,0x645abc89,0x7bde04a7,0x64893c8a}},	//   _gali_, unti, ngpu, _užit,
   {{0x442a08df,0x62963c8b,0xddcd001b,0x62840046}},	//   _mob_, _biyo, hlaš, _bhio,
   {{0x443e88cf,0x1e8691e9,0x442a3c8c,0x62843c8d}},	//   sht_, _элем, _lob_, _chio,
   {{0x62963c8e,0x588713cd,0x7bc1a45e,0x9f5e809f}},	//   _diyo, зыва, balu, _matí_,
   {{0x6d440063,0x27ed003b,0xc9538051,0x442a3c8f}},	//   dzia, đeno_, תמש_, _nob_,
   {{0x6284003c,0x7e6d0955,0x3ce681c0,0x66063c90}},	//   _fhio, toap, _hqov_, _bakk,
   {{0x33778051,0xf4a800c8,0x629606a9,0xa2d30105}},	//   _מתוך_, _ওয়েব, _giyo, _डिब्,
   {{0x81c28a49,0x6a7d040e,0x7e6d002e,0xdb08bc91}},	// [2970] ংলা_, léfo, roap, padó,
   {{0x442a0069,0x6296132e,0x225f8186,0x78ad3c92}},	//   _cob_, _ziyo, _sjuk_, _itav,
   {{0x3cf9101c,0x63a50114,0x6606270c,0x62963c93}},	//   _उनके_, rchn, _fakk, _yiyo,
   {{0x63a502af,0xe9df3c94,0x2005bc95,0x644e02ec}},	//   schn, ngú_, _sali_, _embi,
   {{0x8c3b0352,0x3ce6822c,0x9984801b,0x443c9d14}},	//   _auße, _nqov_, _domů_, _olv_,
   {{0x7d0d3c96,0x6a7612ca,0x66ea8085,0x66063c97}},	//   mvas, ráfi, _təkl, _zakk,
   {{0x7d02933b,0x7bc193bd,0x2005bc98,0x66060c2e}},	//   _asos, valu, _vali_, _yakk,
   {{0x2005a223,0x2d998aa2,0x442a06b9,0x78ad3c99}},	//   _wali_, øse_, _zob_, _otav,
   {{0x7bc1bc9a,0x799b8122,0x442a0282,0xd0d48081}},	//   talu, _iguw, _yob_, _потъ,
   {{0x62963c9b,0x7c2a831d,0x62840c41,0x442a0069}},	//   _siyo, _cofr, _shio, _xob_,
   {{0x37e300c8,0xb05b00f2,0x7bc1bc9c,0x6fd7016f}},	//   য়ার, rsäl, ralu, _बाजू,
   {{0x7bc1bc9d,0xc7b88052,0x1c0a016f,0x5eac00ab}},	//   salu, _dođu_, _होईल_, _ছিলে,
   {{0xed4e8ea2,0x7bc1bc9e,0xdb1c00f1,0xdb1e0511}},	//   _ро_, palu, _perë, rapé,
   {{0xb8f61834,0x40950847,0x66063c9f,0x6609bca0}},	//   _हि_, ерст, _sakk, ldek,
   {{0xdee33ca1,0x628409de,0xe73a0009,0x66e3008f}},	//   кори, _thio, цев_, кора,
   {{0x442a3ca2,0x6d440102,0x644e00dd,0xa3a98a74}},	//   _sob_, tzia, _smbi, गुर_,
   {{0x442a3ca3,0x66063ca4,0x15fd0035,0x6e24008e}},	// [2980] _pob_, _vakk, उज़र_, rjib,
   {{0x6d443ca5,0x66063ca6,0x64418234,0x66098198}},	//   rzia, _wakk, nhli, hdek,
   {{0x7d090ef1,0x66063ca7,0xdb1c3ca8,0xf1b9812b}},	//   _šest, _takk, _keré, _lošu_,
   {{0x7df9800c,0x8c480085,0xa2d5bca9,0xceb304de}},	//   ्योग_, _başç, _भिन्, _שיר_,
   {{0x442a0282,0x81cb00ab,0x66098365,0x201a008e}},	//   _tob_, র্ক_, ddek, _knpi_,
   {{0x76aa9697,0x644e0f38,0x60c9807a,0x9f5806c0}},	//   отив_, _umbi, _dvem, terè_,
   {{0xe80f0023,0xd3721b9a,0x64418782,0xdb1a89b2}},	//   ायता_, _شهر_, dhli, tatí,
   {{0x60c9011f,0x7c2abcaa,0x81d400ab,0x249806ae}},	//   šemi, _sofr, স্ত_, _hirm_,
   {{0x6e2b826b,0x998d826f,0xdb1abcab,0x69c080eb}},	//   _dogb, _pleť_, ratí, _ieme,
   {{0x69c0bcac,0x682f8257,0x29049e1d,0x61e41a54}},	//   _heme, _døds, _isma_, _acil,
   {{0x69c0bcad,0xda1a0540,0x29122168,0xdb1a8511}},	//   _keme, धांत_, _arya_, patí,
   {{0x69c0bcae,0x78a082a0,0x682f8257,0xc7b880d2}},	//   _jeme, _kumv, _føds, _vođu_,
   {{0x69c08393,0x3946bcaf,0xf8ae015b,0x656f81ec}},	//   _meme, nzos_, یکی_, ücht,
   {{0x644182af,0xdb0e0118,0x69c0a385,0x59db0072}},	//   chli, _debú, _leme, _भाकर,
   {{0xfe730c2a,0x76410110,0x7793003d,0x32670081}},	//   ندر_, ūlym, ضیحا, _отив,
   {{0x27e98025,0x69c0bcb0,0xdb15026f,0xe508801c}},	//   đani_, _neme, _nezá, _kỷ_,
   {{0xa2da8b6f,0x3d118076,0x61fd3cb1,0xddc40cd9}},	// [2990] पूर्, तिये_, mesl, bliž,
   {{0x69c088f1,0x32093cb2,0x4ea73cb3,0x660982d0}},	//   _aeme, _haay_, _орма, zdek,
   {{0x60c9803a,0x69c0bcb4,0x2904b996,0x3ce93cb5}},	//   _svem, _beme, _asma_, stav_,
   {{0xfe350158,0x61fd3cb6,0xdb18801b,0xdb050b6a}},	//   _נאָך_, nesl, _neví, nché,
   {{0x69c08b0b,0xadd604de,0x29048122,0x32092676}},	//   _deme, _אורח_, _csma_, _maay_,
   {{0x75160158,0x9f0580f7,0xa3b086ae,0xfd66819d}},	//   _אַלע_, فوتو, टुम_, sspọ,
   {{0x69c0bcb7,0x7bc511df,0x66098fb0,0x20d5807b}},	//   _feme, mahu, tdek, _búið_,
   {{0x69c0915b,0x7bc53cb8,0xb87b3cb9,0x32090122}},	//   _geme, lahu, luíd, _naay_,
   {{0x6441bcba,0xdb18816b,0x2904bcbb,0x27e98300}},	//   thli, _deví, _gsma_, ƙan_,
   {{0x69c0bcbc,0x7bc51341,0xc9849510,0x61e401a8}},	//   _zeme, nahu, _руси, _scil,
   {{0x69c0bcbd,0x6e2bbcbe,0x35b59138,0xdb1c2190}},	//   _yeme, _togb, _збер, _peré,
   {{0xcb120158,0x61fd00c9,0x6a788207,0x6834809f}},	//   אלט_, gesl, tífi, _ràdi,
   {{0x7bc53cbf,0x2d9d882e,0x78a081c0,0x6f053cc0}},	//   kahu, _igwe_, _xumv, _ashc,
   {{0xf8b28039,0xe3d500ab,0x68300106,0x7e7bb65d}},	//   רשם_, স্তব, _räds, llup,
   {{0xdb1c03b0,0x3a3f9d19,0x61fd3cc1,0x7bc53cc2}},	//   _teré, _olup_, besl, dahu,
   {{0xa49b009f,0x61e4017f,0xdb0381ec,0x7e7b8ff9}},	//   _pròp, _ucil, _benö, nlup,
   {{0xc6928f60,0x69c08fc6,0x7afb20a7,0x6bd60061}},	// [29a0] ראן_, _reme, _ćuta, فتار,
   {{0x69c62a84,0x7bc53cc3,0xdb1a8019,0x7e7b8234}},	//   lake, gahu, latá, hlup,
   {{0x69c095bd,0xe1fa8f27,0x645e15b3,0x6735009a}},	//   _peme, зге_, rnpi, cyzj,
   {{0xe64611d2,0x69c63cc4,0x51868e02,0x4ad1016f}},	//   _чемп, nake, нула, _हिरव,
   {{0x76560be8,0xa3cf8778,0x7bc53cc5,0xb87b0ba3}},	//   miyy, षणा_, bahu, buíd,
   {{0x69c63cc6,0x76560086,0x26dcbcc7,0x3946bcc8}},	//   hake, liyy, tuvo_, rzos_,
   {{0x44441e59,0x81cb00c8,0x69c603f8,0x8c1b0158}},	//   mh_, র্ট_, kake, _צולי,
   {{0x76560be8,0x3a3f8668,0x7e7bbcc9,0x69c63cca}},	//   niyy, _glup_, glup, jake,
   {{0xd257810f,0x69c63ccb,0x40a88065,0x7c2e3ccc}},	//   _נשמה_, dake, _آخری_, _kobr,
   {{0x44440142,0xb05b00f2,0x9f47826f,0x224006df}},	//   nh_, rsäk, lený_, _alik_,
   {{0x3fc98077,0x1de10e5b,0x22403ccd,0xb21b00ec}},	//   _آگهی_, _फालत, _blik_, nlæg,
   {{0x61e2b2e3,0xb5fb0065,0x64a6aeab,0xa2d30eed}},	//   ngol, _aján, _зада, _डिस्,
   {{0x76563cce,0x76443ccf,0x44443cd0,0x61fd08f8}},	//   diyy, dhiy, kh_, resl,
   {{0x444428ee,0x2c16809a,0x7c2e3cd1,0x7984009a}},	//   jh_, ताओं_, _nobr, _dziw,
   {{0x4444279d,0xb5fd80d2,0xb87b0e14,0x78ad3cd2}},	//   dh_, pošt, ktív, _živč,
   {{0x44443cd3,0x442e84eb,0xa2d5800d,0xdb1abcd4}},	//   eh_, _hof_, _भित्, catá,
   {{0x7bc53cd5,0x5c753160,0x25a93cd6,0x9f478a21}},	// [29b0] tahu, влат, rcal_, dený_,
   {{0xddeb0077,0x44443cd7,0x25a93cd8,0x61e2a460}},	//   _کرده_, gh_, scal_, egol,
   {{0xa3e20006,0x7bc53cd9,0xb3e215fb,0xb87b26f0}},	//   _धार_, rahu, _पारख, ruíd,
   {{0x7bc50bfb,0x44443cda,0x61e2aa96,0x442ebcdb}},	//   sahu, ah_, ggol, _lof_,
   {{0x44441523,0x661d3cdc,0x26cc8267,0x7bc53cdd}},	//   bh_, _insk, _avdo_, pahu,
   {{0x44443cde,0x81cb00c8,0xb87b3cdf,0x69c63ce0}},	//   ch_, র্চ_, quíd, zake,
   {{0xe8221a3b,0xd9d900c8,0x1c0a005e,0x9f47826f}},	//   माता_, ধ্যম, _होटल_, bený_,
   {{0x660d3ce1,0x7c2e0ed7,0x645704c3,0x60cd3bce}},	//   ndak, _zobr, lixi, _ovam,
   {{0x7e7b810b,0xe1ff0019,0xe81e8105,0x26cc82f7}},	//   rlup, deó_, पाशा_, _evdo_,
   {{0x2240021e,0x76560201,0x442e8428,0x69c63ce2}},	//   _slik_, ziyy, _cof_, wake,
   {{0x2fc7bce3,0xdb1a8065,0x69c63ce4,0xdb0a82af}},	//   mang_, tatá, take, _gefü,
   {{0x2fc7ac11,0x444400f1,0x3eaa803e,0x38a60187}},	//   lang_, zh_, žité_, _pôr_,
   {{0x69c63ce5,0x1d0987eb,0xf1bf0019,0x76560085}},	//   rake, _цели_, pján_, viyy,
   {{0x2fc7ad67,0x76563a20,0x69c63ce6,0x6d458085}},	//   nang_, wiyy, sake, _əhal,
   {{0x64573631,0xe45680be,0x76443ce7,0x660b8122}},	//   dixi, _ביסט_, thiy, _kagk,
   {{0xadf99391,0x2fc7afd2,0xb17b016d,0x49730a2c}},	//   ्यटन_, hang_, mgån, ụtụ_,
   {{0x44443ce8,0xed5720bf,0x7c2e3ce9,0x660b84d2}},	// [29c0] th_, вот_, _pobr, _magk,
   {{0x661d3cea,0x2fc78455,0x7bc3bceb,0xb5fb007b}},	//   _ensk, jang_, _jenu, _hjál,
   {{0x7bc3845c,0x2fc78458,0x3ced8917,0x9f480009}},	//   _menu, dang_, htev_, ähän_,
   {{0x44443cec,0x660b849f,0xb21b0215,0x6289bced}},	//   sh_, _nagk, rlæg, _cheo,
   {{0x61f600f1,0x2fc78456,0x9f4780e1,0x69c43cee}},	//   _mbyl, fang_, rený_, _meie,
   {{0x2fc7bcef,0x69c42aef,0x7bc3a5c6,0xb87b03a7}},	//   gang_, _leie, _nenu, stív,
   {{0x44208104,0x2d808612,0x660bbcf0,0xd8388390}},	//   _đi_, _šie_, _bagk, _niče_,
   {{0x27ed0025,0x6289bcf1,0x69c400eb,0x442eb6b0}},	//   đeni_, _gheo, _neie, _sof_,
   {{0x2fc7977c,0x18a696be,0x7bc3ae68,0xa0a6885f}},	//   bang_, _разм, _benu, _разд,
   {{0x442e82a3,0x2fc7bcf2,0x7bc3bcf3,0xdb1a82d0}},	//   _qof_, cang_, _cenu, natç,
   {{0x201e81cd,0x60cd1a16,0x6aa481a1,0xdb188061}},	//   _inti_, _svam, _čifs, _bevá,
   {{0x200cbcf4,0x7d043cf5,0x05e103eb,0xddcd0035}},	//   _hadi_, kwis, _फाइब, ział,
   {{0xe80f035a,0x6a7d02be,0x7bc38915,0x200cbcf6}},	//   ायला_, néfi, _fenu, _kadi_,
   {{0x200c848f,0x6aa384be,0x645711ee,0x78a401ed}},	//   _jadi_, _funf, xixi, _duiv,
   {{0x45d50391,0x7bc89d9f,0x200c83ec,0x69c43cf7}},	//   ловс, madu, _madi_, _feie,
   {{0x6d0e01fe,0x200cbcf8,0x7bc89f61,0x7bc3bcf9}},	//   सिंग_, _ladi_, ladu, _zenu,
   {{0xd9049fbe,0x2fc7ac11,0x2d580364,0x62898355}},	// [29d0] _بی_, yang_, вить_, _rheo,
   {{0xda2105b3,0x200c990f,0x7642ab02,0x6289bcfa}},	//   यावत_, _nadi_, _lloy, _sheo,
   {{0x64573cfb,0xddcd009a,0x2fc7800b,0x6289851e}},	//   rixi, riał, vang_, _pheo,
   {{0x2fc7ac11,0x22590370,0x661d0858,0x629e80e7}},	//   wang_, nisk_, _unsk, _épou,
   {{0x2fc79ac4,0x4dda0051,0x200c96ea,0x7bc8bcfc}},	//   tang_, _אחרו, _badi_, kadu,
   {{0xd366af7b,0xa2cc3cfd,0x7bc88074,0x764288b1}},	//   _هه_, _हिच्, jadu, _aloy,
   {{0x2fc78455,0x660b9856,0x7bc3bcfe,0x200c83f8}},	//   rang_, _pagk, _renu, _dadi_,
   {{0xc3321a63,0x2fc7bbc2,0x6d49811e,0x201e8081}},	//   _פון_, sang_, tzea, _enti_,
   {{0x7bc394ec,0x2fc79291,0x22592280,0x6e2989ca}},	//   _penu, pang_, disk_, rjeb,
   {{0xb5fb0125,0x7bc8bcff,0x69c41789,0x200cbd00}},	//   _sjál, gadu, _seie, _gadi_,
   {{0x78a403d3,0x7bc3bd01,0x22590370,0xc73580d5}},	//   _suiv, _venu, fisk_, _حفاظ,
   {{0x22590370,0x76429bad,0xb17b0106,0x68fb819d}},	//   gisk_, _gloy, rgån, _kpud,
   {{0x7bc3bd02,0xfe70845b,0x7bc8bd03,0xc9550048}},	//   _tenu, _بدل_, badu, атры,
   {{0xdee61628,0xdb1c040e,0x6cd28c2a,0x66e60d91}},	//   логи, _serí, _اقوا, лога,
   {{0xdb1c26f0,0xe81901ce,0x61e9bd04,0x22592280}},	//   _perí, दाजा_, _ocel, bisk_,
   {{0x28dc1d01,0x3ea58c6e,0x25adbd05,0x6d410201}},	//   _बिपि, _mult_, ncel_, _əlav,
   {{0xdb0a8125,0x3a20336a,0xdb1c3d06,0x4431173c}},	// [29e0] _hefð, _inip_, _verí, _boz_,
   {{0x7d043d07,0x61e9b296,0x6600803e,0x657d00f1}},	//   rwis, _acel, zemk, _dysh,
   {{0x200c8025,0x59b80076,0x7ae1bd08,0xddc98025}},	//   _radi_, _आभार, nult, dlež,
   {{0x66ea8201,0x61e60b20,0x2fc583a8,0x64552733}},	//   _məkt, ngkl, _aelg_, _emzi,
   {{0x7ae1bd09,0x44310ba3,0x9f5801e8,0xc7b881f4}},	//   hult, _foz_, lerà_, _anđa_,
   {{0x648b1d3a,0xdcfd00eb,0x53a3102a,0x3ea5aa65}},	//   güid, _uzsā, _гарб, _bult_,
   {{0xf1ba0028,0xa3e9016f,0xe8d901bc,0x9f5801e8}},	//   _đơn_, _यात_, _izụ_, nerà_,
   {{0xe297bd0a,0x7e640074,0x96349ad2,0xb05b0106}},	//   _бас_, nnip, рниц, lsät,
   {{0x200c8867,0x7bc8bd0b,0x80a018b8,0x3d170d86}},	//   _tadi_, tadu, _गंगे, निये_,
   {{0xcb1f80d4,0xf1b9826c,0x201e809c,0x61e9801b}},	//   यमंड_, _inša_, _unti_, _zcel,
   {{0x22590370,0xa3e5835a,0xb89380f7,0x7e6414cf}},	//   tisk_, _फार_, _اللع, knip,
   {{0x9f58047f,0xd9150048,0xdb050187,0x80c1864a}},	//   derà_, адмы, lchã, रीवे,
   {{0x22590370,0x7bc8ac73,0xf1bf0019,0x3ea580f3}},	//   risk_, padu, lják_, _zult_,
   {{0x22590370,0xb5fb03fb,0xe7e300ab,0xbddb09c4}},	//   sisk_, _ukáz, য়্য, _clèn,
   {{0x645abd0c,0x81dc80c8,0x22590370,0x7ae1879a}},	//   miti, ত্য_, pisk_, cult,
   {{0xe8d90870,0x443ebd0d,0x442c8106,0x29090ec9}},	//   _azụ_, lkt_, ljd_, _tsaa_,
   {{0x54551878,0xe8220076,0xa3e90740,0xdc5504bd}},	// [29f0] ават, माशा_, _याद_, авањ,
   {{0xe7e081fe,0x61e98098,0xb87b05a4,0x645ab282}},	//   _नागप, _scel, dríg, niti,
   {{0x443126d5,0x443ebd0e,0x20033d0f,0xed59890c}},	//   _voz_, ikt_, meji_, raži_,
   {{0x20033d10,0xdb1c0073,0x27ed005c,0x645abd11}},	//   leji_, _serã, đenu_, hiti,
   {{0x25ea146d,0x628d125b,0x91bf819d,0x3ea5bd12}},	//   _छाती_, _mhao, _ajụ_, _sult_,
   {{0x443e8613,0x645abd13,0x20110bb7,0x7c3e048d}},	//   jkt_, jiti, ndzi_, ckpr,
   {{0xfc3f02ba,0x645abd14,0xdb1c03a7,0x2fc5bd15}},	//   _guía_, diti, _verã, _velg_,
   {{0xceb40451,0x6e2d3d16,0x443e97dd,0x81dc80ab}},	//   זיק_, njab, ekt_, ত্ব_,
   {{0x645abd17,0x20033d18,0x7bc7059c,0x1c45960f}},	//   fiti, keji_, _keju, иним,
   {{0x1c1f8cce,0x69cbbd19,0x7bc73d1a,0xdb1c002a}},	//   बाइल_, lage, _jeju, _herá,
   {{0x3f678a95,0xcb69813a,0x38ab83ba,0x7bc70133}},	//   _стаб, тане_, _hør_, _meju,
   {{0x628d1a29,0x69cbbd1b,0x660f0004,0x7bc735cf}},	//   _chao, nage, _nack, _leju,
   {{0x645abd1c,0x628d0ad0,0x9f580e67,0xfe708872}},	//   biti, _dhao, derá_, _عدم_,
   {{0x443ebd1d,0x69cbbd1e,0x7ae1bd1f,0x9f583340}},	//   ckt_, hage, pult, terà_,
   {{0x660f3d20,0x69cbbd21,0x38ab8aa2,0x628d0014}},	//   _back, kage, _lør_, _fhao,
   {{0x628d0083,0x660f0b80,0x7aee826f,0x9f583d22}},	//   _ghao, _cack, žití, gerá_,
   {{0xb05b1a50,0x7afc14e4,0x6486808b,0x69d60420}},	// [2a00] tsät, _sprt, iðin, _idye,
   {{0x7d0b8077,0x628d0326,0x9f583340,0x7bc70144}},	//   _msgs, _zhao, perà_, _ceju,
   {{0xb05b0884,0x9f583d23,0x660f3d24,0xf1da2207}},	//   rsät, berá_, _fack, _भयान,
   {{0x9f5810dd,0x660f02a5,0x38ab8a38,0xed598024}},	//   cerá_, _gack, _bør_, lažu_,
   {{0x03a6143b,0x645a82ec,0x3940bd25,0x443ebd26}},	//   _виго, yiti, áis_, ykt_,
   {{0x660421c0,0x645abd27,0x26dc9c67,0xf1bf0019}},	//   leik, xiti, trvo_, tják_,
   {{0xe7ee023c,0x1c1fa3bd,0x69cbb104,0x12e080ab}},	//   _जाना_, बाईल_, bage, _বন্দ,
   {{0x38ab8a38,0x261983e8,0x69cbbd28,0x7d0b8176}},	//   _før_, _मोदी_, cage, _bsgs,
   {{0x38ab8022,0x61439263,0xed598289,0x645abd29}},	//   _gør_, _дета, kažu_, titi,
   {{0x62829b98,0x628d008c,0x69d62dcb,0x9f5800e1}},	//   lloo, _shao, _adye, zerá_,
   {{0x443ebd2a,0x63a380ee,0x3dc680ee,0x6d4d0365}},	//   rkt_, _dgnn, _teow_, zzaa,
   {{0x443e819b,0x645abd2b,0x6282a695,0x2efe826c}},	//   skt_, siti, nloo, _iptf_,
   {{0x645a8c53,0x9f5803a7,0xc05b00e8,0x68e48046}},	//   piti, verá_, вів_, àidh,
   {{0x02a6aed9,0x69cbbd2c,0xc05b00e8,0x69d600e4}},	//   _крим, zage, тім_, _edye,
   {{0x628d0ad0,0x9f580207,0x69cbbd2d,0x44f0bd2e}},	//   _thao, terá_, yage, là_,
   {{0x7bc70867,0xf8a6897d,0xb05b0198,0xe61f00ff}},	//   _seju, खदाय, tsäs, _khôi_,
   {{0x660f00f2,0xdb050a21,0x7bc70458,0x44f0a2c6}},	// [2a10] _vack, dchá, _peju, nà_,
   {{0xdb1c040e,0x6d4d0a0f,0x69cbbd2f,0x38ab83ba}},	//   _será, rzaa, wage, _rør_,
   {{0x69cbbd30,0xa2f53d31,0x6282a0d1,0x38ab821e}},	//   tage, спеч, floo, _sør_,
   {{0xceb20159,0x80db800f,0xb9100135,0x628289ff}},	//   _מיט_, _निदे, _nanị_, gloo,
   {{0xdb1c0da1,0xe9d88110,0xe7ee0424,0x81d400ab}},	//   _verá, ркі_, _जामा_, স্ক_,
   {{0x6e22bd32,0x44f0bd33,0x7bd53d34,0xdb0501a8}},	//   _anob, dà_, _udzu, achá,
   {{0xdb1c03a2,0x6282930d,0x64470197,0x41e785a8}},	//   _terá, bloo, _ilji, _віза,
   {{0x38ab8aa2,0x683d8722,0x6aa09bec,0x7d0b8122}},	//   _tør_, _mèdi, _gimf, _psgs,
   {{0x64868125,0xf80780e8,0x79808114,0x7649875e}},	//   rðin, _вчен, _gymw, rhey,
   {{0x308580f7,0x7649bd35,0xe0df3d36,0x61ed0c1d}},	//   _الطف, shey, drò_, _acal,
   {{0x78a98264,0xb87b01df,0x9f58009f,0x442300fc}},	//   _huev, tuín, merç_, _mnj_,
   {{0x78a1bd37,0x66ea811c,0x61fb810c,0x6458913b}},	//   _hilv, _təkr, _jbul, _emvi,
   {{0x78a986a5,0x25bf91d6,0x66043d38,0x61fbbd39}},	//   _juev, mbul_, veik, _mbul,
   {{0x78a986a5,0x25bf8122,0x7e7d3d3a,0xf1bf041c}},	//   _muev, lbul_, _aksp, abá_,
   {{0x66043d3b,0xa2d31a3b,0x7d098d33,0xddcb2828}},	//   teik, _डिग्, lwes, _šiša,
   {{0x25bf87d9,0x290d8e1b,0xed598301,0x64470300}},	//   nbul_, _osea_, sažu_, _alji,
   {{0x78a9a70d,0x66043d3c,0xddc98035,0x7c3506c4}},	// [2a20] _nuev, reik, wieś, _bozr,
   {{0x61fbbd3d,0xdd8f0591,0xaca38133,0x628281e0}},	//   _abul, رول_, _adịk, wloo,
   {{0xdb1c3d3e,0x25bf883a,0xb09b0039,0x7d0980ed}},	//   _merç, kbul_, _תייר, hwes,
   {{0xd910819f,0x7d09805d,0xb87b3d3f,0x6b7a80be}},	//   ویز_, kwes, críb, ארענ,
   {{0xc05a8d8e,0x6441bd40,0x78a98333,0x78a192f1}},	//   лік_, kkli, _cuev, _bilv,
   {{0x78a18341,0x6447005c,0x61fbbd41,0xdb1abd42}},	//   _cilv, _glji, _ebul, ratú,
   {{0x6282bd43,0x645e3d44,0x6441816d,0x7ff380f7}},	//   ploo, mipi, dkli, سسوا,
   {{0x44f081dc,0xc8e0800f,0x6f1a807a,0x44b480e8}},	//   tà_, _निपट, _vrtc, обис,
   {{0xa49b0722,0xdb1c0187,0x7afb0da8,0x68e60711}},	//   _pròx, _berç, _ćuti, jukd,
   {{0x44f0bd45,0x61fb80f1,0x645e3d46,0x15ea83eb}},	//   rà_, _zbul, nipi, _टावर_,
   {{0x7f868307,0x6d410201,0x44f0bd33,0x547b0039}},	//   _الان, _əlaq, sà_, רטיו,
   {{0xc3331a0f,0x7a3f020f,0xe61f0028,0xa5bb37b5}},	//   לות_, _këti, _thôi_, _anón,
   {{0x6da38c48,0x645e3d47,0xdb1c0009,0xb87b0118}},	//   _عموم, kipi, _herä, buíl,
   {{0x6441bd48,0xdb1c3d49,0x69c01434,0xe0df01e8}},	//   ckli, _gerç, ðmer, rrò_,
   {{0x623507b6,0x7c351d21,0x466b072a,0xc0580d8e}},	//   _меку, _rozr, грам_, сія_,
   {{0x7bca87ca,0x4caa00ab,0x6447025b,0x68e602c4}},	//   _hefu, _চৌধু, _slji, bukd,
   {{0x69cf0333,0x7c350038,0x7cd9003d,0x7bca80b9}},	// [2a30] mace, _pozr, شواز_, _kefu,
   {{0x69cf0018,0x4d9807ac,0x6aaabd4a,0x645e3d4b}},	//   lace, скую_, _kuff, gipi,
   {{0xe7ee00cf,0xe9f90028,0x78a983a8,0x25a6bd4c}},	//   _जाता_, _giả_, _suev, _ogol_,
   {{0xa49b0176,0xb87b03cd,0x38af0850,0x04060264}},	//   _asòt, bríc, _kür_, রাগী_,
   {{0x61fbbd4d,0x7bd880d2,0x78a18b0c,0x78a9a4a3}},	//   _vbul, _odvu, _pilv, _quev,
   {{0x8aa70785,0x02a70a8e,0xdb1c00f2,0x25b3914f}},	//   _град, _грам, _berä, ीर्ण,
   {{0x81d40a49,0xa6b480ab,0x80dbb13a,0x69cf3d4e}},	//   স্ট_, _টিউট, _निवे, kace,
   {{0xee398abe,0x764d3d4f,0x7d09bd50,0x68e623c1}},	//   рни_, nhay, twes, yukd,
   {{0x82348b76,0x78a18a35,0x7bcabd51,0x893784e3}},	//   _عرفا, _tilv, _befu, _اعزا,
   {{0xf9909381,0x22493d52,0x7d09bd53,0x26199344}},	//   _سبق_, _alak_, rwes, _मोरी_,
   {{0x2007bd54,0x6441bd55,0xdb1c3d56,0x69cf3d57}},	//   meni_, rkli, _gerä, face,
   {{0x2007829b,0x81e200c8,0x64419aed,0x7d09bd58}},	//   leni_, ন্ন_, skli, pwes,
   {{0x7e7b8052,0xdb1c0073,0xe7ee0074,0xa2d58f0f}},	//   moup, _terç, _जादा_, _भिक्,
   {{0x7bca9546,0x2007805d,0x22493d59,0x7e698216}},	//   _gefu, neni_, _elak_, lnep,
   {{0x07a33d5a,0x2bbfb011,0x032580e8,0x8fa3151a}},	//   дарн, _श्या, _єдин, даре,
   {{0x38af0943,0xb87b3d5b,0x2007bd5c,0x7e69bd5d}},	//   _für_, tríc, heni_, nnep,
   {{0x645e3d5e,0x2007bd5f,0x3ea2016d,0xe45a10ee}},	// [2a40] tipi, keni_, _vikt_, ажа_,
   {{0x62863d60,0x2a7f8326,0x81b00326,0xc8e080c2}},	//   llko, _akub_, _daɓe, _निबट,
   {{0xe5a60676,0x6da61354,0x41aa81f3,0x7e7b801b}},	//   _мини, _мина, авен_, koup,
   {{0x764d3d61,0x645e0b51,0x387e82f7,0xb5fb008b}},	//   chay, sipi, _sktr_, _sjáv,
   {{0xa3e9853e,0xe80f016f,0xaca381bc,0x645e3987}},	//   यला_, ायचा_, _adọk, pipi,
   {{0xd6daa885,0x2007bd62,0xdb1c0009,0xdfd080f7}},	//   ати_, geni_, _perä, ريب_,
   {{0x44f40364,0x27e087d9,0x44443d63,0x81e200ab}},	//   lä_, ğin_, mk_, ন্য_,
   {{0x44383d64,0xa534bd65,0x91e60592,0xdb1c02af}},	//   _hor_, знич, _कागज_, _verä,
   {{0x44f40364,0xc6930bea,0x2007bd66,0xd40684fa}},	//   nä_, ואה_, beni_, ояни,
   {{0x44443d67,0x81e200ab,0xb35480e8,0x69cf0f89}},	//   nk_, ন্ম_, зкош, wace,
   {{0x444406a8,0x443801ba,0x6b838355,0x28c68eed}},	//   ik_, _mor_, _cyng, रीरि,
   {{0x81dc8a49,0xb5fb00ab,0x44381bdd,0xb87b05a4}},	//   ত্র_, _imág, _lor_, dría,
   {{0x443804df,0x7e608812,0x44443d68,0x44f40364}},	//   _oor_, mimp, kk_, jä_,
   {{0x44440586,0x6aaabd69,0x44f40009,0x7d02bd6a}},	//   jk_, _tuff, dä_, _ipos,
   {{0x69cf087a,0x764d3d6b,0x6b838114,0xd838bd6c}},	//   pace, thay, _gyng, _moč_,
   {{0x2cb90358,0x7e60b996,0x44443d6d,0x38af1266}},	//   _ptsd_, nimp, ek_, _tür_,
   {{0x44380bfa,0xa3ae86a7,0xd7fb259a,0x5d5501f3}},	// [2a50] _bor_, _कला_, _кун_, чкат,
   {{0x44383d6e,0x64dd835a,0x764d2751,0x68e29ad5}},	//   _cor_, _मिसळ, shay, drod,
   {{0x443822a0,0xf8bf24df,0x6d40bd6f,0x7ae88122}},	//   _dor_, lpé_, hyma, nudt,
   {{0x2007ae95,0x444404e0,0xc3338158,0x7c38bd70}},	//   weni_, ak_, ווע_, _lovr,
   {{0x4438073a,0x2ca30613,0x2007bd71,0x68e2809a}},	//   _for_, _tijd_, teni_, grod,
   {{0x44383d72,0x6d408110,0xd7fb8049,0xf8bf0036}},	//   _gor_, dyma, руд_, ipé_,
   {{0xe739bd73,0x2007812b,0x7d0d3d74,0x44298028}},	//   сей_, reni_, lwas, _đa_,
   {{0xb0dc05b3,0x2007b082,0x28dc0054,0x44383d75}},	//   _बिलग, seni_, _बिलि, _zor_,
   {{0xdb050352,0x81e200c8,0x7d0d3d76,0x83fc876c}},	//   schä, ন্ড_, nwas, ziđe,
   {{0x20079cb5,0xbebc80eb,0x76443d77,0x28e0a207}},	//   qeni_, _brīd, zkiy, _निति,
   {{0x7c388098,0x59cf8aed,0x7d0d3d78,0x7d02bd79}},	//   _dovr, _हजार, hwas, _epos,
   {{0x7d0d3d7a,0x83fc8024,0x60c9a6bd,0x7e608359}},	//   kwas, viđe, _kwem, cimp,
   {{0x6f1e0b80,0x69cd00c3,0xa56780d7,0x271c8129}},	//   _srpc, _deae, _بدان, _ảnh_,
   {{0x6b8388f3,0x44f40009,0x60c9a994,0x6aa411fe}},	//   _tyng, vä_, _mwem, _wiif,
   {{0xcb6694d6,0x4427bd7b,0xaa461c57,0xbebc81a9}},	//   _наше_, _inn_, _некл, _grīd,
   {{0x44f4025d,0x7c2706cb,0x6f1e00ce,0xb87b0333}},	//   tä_, _anjr, _vrpc, rría,
   {{0x76443d7c,0x7d0d1400,0x28e081a2,0x6e39822b}},	// [2a60] rkiy, gwas, _निधि, _mowb,
   {{0x44443d7d,0x764400a4,0x29120590,0x69db8216}},	//   uk_, skiy, _isya_, _adue,
   {{0x44383d7e,0xf62601f3,0x6d40809a,0x7d1b8074}},	//   _vor_, _едно, zyma, hvus,
   {{0x4444006f,0x64a61506,0xdca600ae,0x645c01ed}},	//   sk_, _нама, _нами, _wmri,
   {{0x44383d7f,0x4427bd80,0xf1a9803d,0x291f80f7}},	//   _tor_, _onn_, زانه_, _crua_,
   {{0x645c2c5d,0x68e2a00a,0x69db8118,0x69c286a8}},	//   _umri, rrod, _edue, sboe,
   {{0x7d02bd81,0xa91d826f,0x1c020540,0x7bdc00ee}},	//   _spos, _vyža, _रॉयल_, _idru,
   {{0x4427bd82,0x81e20a49,0x7c38bd83,0x6d408d42}},	//   _ann_, ন্ত_, _sovr, tyma,
   {{0x7c388b48,0x7bce0763,0xe297b73a,0x48e390ca}},	//   _povr, _kebu, _хат_, _потв,
   {{0x7e60bd84,0xb5fd85f5,0x6d409ad5,0x5fd0801b}},	//   simp, više, ryma, _सजिल,
   {{0x29123d85,0x7e6088de,0x60c98a0f,0x6d409ad5}},	//   _asya_, pimp, _zwem, syma,
   {{0x44278357,0x7bce3d86,0x78ad01c0,0x3ce901c0}},	//   _enn_, _lebu, _puav, yuav_,
   {{0xdcf783f8,0x7d028754,0x7c38807a,0x2e3781c6}},	//   _فروش_, _upos, _tovr, _מראש_,
   {{0x7bce3d87,0xb905058c,0xb5fd8916,0xa8a416ba}},	//   _nebu, _पट_, riše, ерск,
   {{0x5433826a,0xabfb81c6,0x81e200ab,0xff041cf8}},	//   _سرور, _ההור, ন্ধ_, нятн,
   {{0x7d0d3d88,0xb5fd811a,0xf8bf00e7,0xa49b026b}},	//   twas, piše, ppé_, _asòp,
   {{0x59c30327,0x7bce3d89,0x3a290359,0xdcef01a9}},	// [2a70] _व्यर, _bebu, _inap_, _izcī,
   {{0xfbab0196,0x81e200c8,0x200a3d8a,0x6609bd8b}},	//   стай_, ন্দ_, cebi_, zeek,
   {{0x7529012b,0x64451cbc,0x3d0e9344,0x3a292862}},	//   _šezd, rkhi, _तैसे_, _knap_,
   {{0xdb15026f,0xfd1f001c,0xdb1ab4be,0xa3dc8ebf}},	//   _sezó, _trì_, lató, तृत_,
   {{0xe1f09e13,0xb5fb0125,0x9f5106a5,0x7e6d3d8c}},	//   اسم_, _fjár, pezó_, mnap,
   {{0x7bce2e68,0xdb1abd8d,0x4174803d,0x6609bd8e}},	//   _gebu, nató, رانس, week,
   {{0x66098c56,0xae1e8128,0x7bc53d8f,0x3a290db1}},	//   teek, _मोहन_, mbhu, _onap_,
   {{0xda1d1d01,0x7bdc1fe7,0x7e6d25d3,0x7bce0caa}},	//   _बोलत_, _zdru, nnap, _zebu,
   {{0x5fbf000d,0xe7ee0665,0x66099306,0xd7bf0d14}},	//   ्राल, _जाला_, reek, ्राच,
   {{0x68e48307,0x6609bd90,0x5ee58035,0xbb4595b5}},	//   áide, seek, _टिप्_, деок,
   {{0x7e6d09ff,0xe29a045e,0x3ea68118,0x212000b9}},	//   knap, жан_, _fiot_, _srih_,
   {{0xd9ff8128,0xb87b01a8,0x3a290229,0x9f580144}},	//   ोजित_, frío, _cnap_, perú_,
   {{0x7e6d3d91,0xdb0a80f2,0xdb038144,0x68eb833e}},	//   dnap, _affä, _igní, nugd,
   {{0xdb1abd92,0xe8008f1b,0xa91d816b,0x67218bcf}},	//   gató, ल्पा_, _lyžo, _krlj,
   {{0x81e58a49,0xa0a33d93,0x7bce3d94,0x224d8327}},	//   ব্য_, тард, _rebu, _olek_,
   {{0x7bce1a67,0x2ca78006,0x7ae500d2,0x6721812b}},	//   _sebu, _hind_, drht, _mrlj,
   {{0x1be18074,0x7bce02f7,0x62843d95,0x2bb203db}},	// [2a80] _खयाल_, _pebu, _ikio, _जलदा,
   {{0x1daa0054,0x225f8642,0x67218140,0xdb1abd96}},	//   _कलकत, _amuk_, _orlj, cató,
   {{0x38b41918,0x28e083eb,0x65c62098,0x2ca7bd97}},	//   _här_, _निहि, _обна, _mind_,
   {{0x7bce3d98,0x1bf00105,0x2ca7bd99,0xdb18816b}},	//   _webu, _चावल_, _lind_, _nevý,
   {{0x7bce3d9a,0x83fc826c,0xb17b03a6,0x644f81a9}},	//   _tebu, hiđa, lgår, īcij,
   {{0x7bdc003a,0x224dbd9b,0x59cc800d,0x46d20105}},	//   _udru, _elek_, ारहर, _तबाह,
   {{0x38b400f2,0x224dbd9c,0xb17b04e1,0x644e3d9d}},	//   _lär_, _flek_, ngår, _ilbi,
   {{0x44208193,0x1514a49a,0x7e64046d,0x442a35ca}},	//   _şi_, едия, niip, _hnb_,
   {{0x38b41918,0x7c3c17ab,0x6d440812,0xd8388289}},	//   _när_, _korr, nyia, _liči_,
   {{0xdb1c0aa2,0x6284004f,0x2ca78087,0x67218503}},	//   _berø, _akio, _cind_, _frlj,
   {{0x9e3c826f,0x672180fe,0x60c28d55,0x9f5e823e}},	//   _buďt, _grlj, lpom, _obté_,
   {{0x38b40884,0x81e200ab,0x2ca780f3,0x60c28035}},	//   _bär_, ন্স_, _eind_, opom,
   {{0x2ca7bd9e,0xa3c0064a,0xdb1abd9f,0x644e047f}},	//   _find_, ीरा_, tató, _olbi,
   {{0x38b41918,0x7c3c3da0,0x62843da1,0x75228db1}},	//   _där_, _norr, _ekio, _iroz,
   {{0xe8009880,0x9f5f07d9,0xb5fd8024,0x7522826f}},	//   ल्या_, _ürün_, liša, _hroz,
   {{0x644e011e,0x443cbda2,0x7e6402c4,0x81b00300}},	//   _albi, _hov_, giip, _taɓa,
   {{0x443cbda3,0xdb1abda4,0x66028077,0x60c2875f}},	// [2a90] _kov_, catò, _mbok, jpom,
   {{0x7c3c3da5,0xe3b88457,0x6f05001c,0x225f806a}},	//   _corr, ncı_, _tphc, _smuk_,
   {{0x443c88df,0x224d90f4,0x7c3c3da6,0x60cd008e}},	//   _mov_, _plek_, _dorr, _hwam,
   {{0x60cd3da7,0x443cbda8,0x644e0808,0x442a3da9}},	//   _kwam, _lov_, _elbi, _enb_,
   {{0x7c3c3b39,0xa8038214,0x6e3d0122,0x67218503}},	//   _forr, _çıkt, _iosb, _srlj,
   {{0x67218052,0x6602afd5,0x7c3c3daa,0x60cd2169}},	//   _prlj, _abok, _gorr, _mwam,
   {{0x3949a338,0xddc40353,0x98bf807e,0x60cd0c6a}},	//   šas_, lniš, ırım_, _lwam,
   {{0x2ca7834a,0x439413cd,0x83fc82a5,0x75228bcf}},	//   _sind_, _расс, viđa, _broz,
   {{0x7522a7f5,0x60cd0133,0x2ca7bdab,0xd7fbbdac}},	//   _croz, _nwam, _pind_, _муж_,
   {{0x660d3dad,0xfc318307,0x443c946a,0x20cd3dae}},	//   heak, احة_, _cov_, dži_,
   {{0x2ca79699,0x443cbc22,0x60cd2142,0xda661612}},	//   _vind_, _dov_, _awam, евни,
   {{0x23bf873c,0x2bbf8744,0xfbbf853f,0xee2e8a8e}},	//   _श्रद, _श्रा, _श्रम, _ён_,
   {{0xed4ebdaf,0x7522bdb0,0x1bf00076,0x6e2b8915}},	//   _со_, _groz, _चालल_, _ingb,
   {{0x6aa996a1,0xddc4135a,0x26de0024,0x653a80be}},	//   _lief, dniš, štom_, _מענד,
   {{0x44f9bdb1,0xdb18802a,0x6619a358,0xe73a1289}},	//   lè_, _devó, _kawk, чев_,
   {{0x661bbdb2,0xb17b0e23,0x62840c53,0x443c8069}},	//   nduk, rgår, _ukio, _zov_,
   {{0xfce32856,0x14262f84,0x60cd03c3,0x660301e5}},	// [2aa0] лото, ндам, _gwam, ыпта,
   {{0x78fb0051,0x443c81e9,0x395704de,0x7e7b0289}},	//   _צפיו, _xov_, _נשים_, čupa,
   {{0x7c3c3db3,0x6d441283,0xb5fd8bcf,0x6aa9bdb4}},	//   _vorr, syia, ziša, _bief,
   {{0xddc40db7,0x7ae30742,0x661babea,0x2bb206b7}},	//   bniš, ánta, jduk, _जलवा,
   {{0xa3e9016f,0x442a3db5,0x44f986c0,0x6aa986a8}},	//   _याच_, _tnb_, jè_, _dief,
   {{0x75249dd7,0x98a38991,0x6e2b826b,0x10a38c9b}},	//   _šizo, гиче, _angb, гичн,
   {{0x91e6964f,0x443c81e9,0x09e6835f,0x7989bdb6}},	//   _пове, _rov_, _повн, _eyew,
   {{0x7522bdb7,0x443cbdb8,0xb87b3db9,0x661b8bb1}},	//   _proz, _sov_, quív, gduk,
   {{0x443c81c5,0x6ecc8105,0xc8ca9ef7,0x09cc8054}},	//   _pov_, _सबकु, _روان_, ारीय,
   {{0xa2b48076,0x60cd2fc0,0x61f61c33,0x201a0019}},	//   _ईंद्, _rwam, _acyl, _napi_,
   {{0x443cbdba,0xddc4007a,0xdee381a1,0xcf1200ab}},	//   _vov_, zniš, _бохи, হমুদ_,
   {{0xb5fdbdbb,0x7649bdbc,0xdc3c8042,0x7522bdbd}},	//   lišn, ckey, _išču, _troz,
   {{0x81a900c8,0x443c9d14,0x261981ce,0x39468019}},	//   খুন_, _tov_, _मोटी_, nyos_,
   {{0x201a3dbe,0xa3490032,0xb87b002a,0xb5fdbdbf}},	//   _capi_, _bọ́t, prím, unšv,
   {{0x45d51630,0x81b000fc,0x660d3dc0,0x141b81c6}},	//   ковс, _gaɓo, teak, _מוגב,
   {{0x6d1c00d4,0xddc40ee1,0x63ae019d,0x60cd1f34}},	//   निंग_, tniš, _agbn, _twam,
   {{0x30a7007f,0xa8a71541,0x31351777,0xb87b008b}},	// [2ab0] _пров, _прок, _репр, nrík,
   {{0xb5fd8052,0xddc4007a,0x7989808e,0x63ba88ae}},	//   jišn, rniš, _ryew, nctn,
   {{0xb5fd803a,0x28b717ba,0xddc4012b,0xf6990dc7}},	//   dišn, _इंडि, sniš, _овој_,
   {{0x44f99c5e,0x290901bc,0xd83889d1,0xb926019d}},	//   yè_, _kpaa_, _miču_, _nkwọ_,
   {{0xca749459,0x201a3dc1,0xdb0187f1,0x00000000}},	//   دالغ, _yapi_, nclò, --,
   {{0x6bd40c2b,0xb92601bc,0x290905ee,0x7e628176}},	//   _متفر, _akwọ_, _mpaa_, _amop,
   {{0x439415fe,0x6aa981ec,0xd838817f,0x79c980f7}},	//   _барс, _tief, _niču_, _يوسف_,
   {{0x44f986c0,0x9f4c8580,0x68fd072c,0x4ada825a}},	//   tè_, _abdó_, ktsd, _भिजव,
   {{0xb5fd8699,0x60db80b8,0x3d170072,0x81b000fc}},	//   bišn, _uvum, निटे_, _saɓo,
   {{0x44f9bdc2,0xd83881a1,0x26de0061,0x7bd71029}},	//   rè_, _biču_, átok_, naxu,
   {{0x201a0458,0x9f0492dc,0x3a3f86c0,0x26c101c0}},	//   _rapi_, _مولو, _koup_, _ntho_,
   {{0x201a08b3,0x44f9bdc3,0xa96a2300,0x216a2d59}},	//   _sapi_, pè_, дима_, дими_,
   {{0x212400f7,0x6486807b,0x9f5801fa,0x44f98037}},	//   ímh_, gðis, rfrí_, qè_,
   {{0x66e600a9,0xed5684ae,0x3a3f92b6,0xb05b148c}},	//   кога, _још_, _loup_, spän,
   {{0xe1ff388a,0xfc3f0ba3,0xb5fb008b,0x17790198}},	//   mión_, _luís_, _smáa, есть_,
   {{0x80d280c8,0xe5f3002e,0x201a0010,0x224b1142}},	//   _সমস্, văţă, _wapi_, ckck_,
   {{0x201a0500,0xb87b04c3,0x28dc0d86,0xbea33dc4}},	// [2ac0] _tapi_, tuít, _बिटि, ратк,
   {{0xe1ff128e,0x3eab0db1,0xf1a701d0,0x224002f9}},	//   nión_, _eict_, _गणतन, _hoik_,
   {{0xb5fd805c,0x3a3f82d6,0x3e7a8ec3,0x00000000}},	//   višn, _boup_, līte_, --,
   {{0x3a3f82be,0x20058bb1,0xb87b3dc5,0xbebc81a9}},	//   _coup_, _abli_, buís, _brīn,
   {{0x6f088118,0x2444007b,0x99dd8176,0xc7b880fe}},	//   _spdc, _sömu_, _alňs, _lađe_,
   {{0x75360713,0xdb1c0065,0xe9f910ab,0x3ea03dc6}},	//   mxyz, _kerü, _diẹ_, lmit_,
   {{0xc7b8805c,0xb5fd8390,0x7c2e3dc7,0xe8e0001c}},	//   _nađe_, rišn, _inbr, _ước_,
   {{0x2005826c,0xeb970956,0x9f580144,0x5eea01d0}},	//   _ebli_, _рис_, leró_, _छिन्_,
   {{0x5ea381a8,0xdb1abdc8,0x5275bd93,0x00000000}},	//   جميل, natö, _суру, --,
   {{0xe1ff3dc9,0xe7ee016f,0x9f580388,0x515b807c}},	//   gión_, _जागा_, neró_, _חכמו,
   {{0xad9b04be,0x3d178035,0x2252067f,0xdc3c80c3}},	//   _abúl, _बैठे_, _blyk_, _ušču,
   {{0x28b70540,0xb87b01ac,0xdb1c3dca,0xacbb0036}},	//   _इंदि, prík, _heró, _brûl,
   {{0xe1ff04c3,0x81cc00ab,0xb87b016a,0x7c2e1c11}},	//   bión_, _লাখ_, nsíg, _onbr,
   {{0xe1ff161b,0xd83882a5,0x545386cf,0x14d78158}},	//   ción_, _tiču_, _квіт, _יודל_,
   {{0x386d02fd,0x44d00063,0x3eab02f7,0x9f5801ca}},	//   đer_, eń_, _pict_, deró_,
   {{0x320f0065,0x02a4027e,0x5bcb1905,0x7c2e3dcb}},	//   _úgy_, _крым, िर्व, _anbr,
   {{0xf1b98042,0x35b415da,0x9a6800f7,0x5c7511b3}},	// [2ad0] _jaše_, рбур, _جميل_, глат,
   {{0x7ae33dcc,0xa5bb3dcd,0x7bc582f1,0x5454102a}},	//   ánto, _anót, _õhut, авут,
   {{0x629f047f,0xe81d80d4,0x6aad004f,0x3ea00039}},	//   _èpos, _योगा_, _kiaf, bmit_,
   {{0x20113dce,0xe45f00f2,0x3ce90353,0x798d31af}},	//   lezi_, _stöd_, prav_, _kyaw,
   {{0x26debdcf,0xc7b80289,0x91058d15,0x6aad2aa0}},	//   _avto_, žđe_, упле, _miaf,
   {{0xe1ff02ba,0x661d04b9,0x24440106,0x764d3dd0}},	//   xión_, _hask, _döms_, lkay,
   {{0x27e9817b,0x9388002e,0x8aa78088,0xead41091}},	//   ğan_, _аста_, _арад, _вось,
   {{0x1dd30076,0x27e982bb,0x765801e2,0x442e81e0}},	//   तरित, şan_, _įvyk, _anf_,
   {{0xe1ff1727,0x798d0397,0x2a648098,0x442ebdd1}},	//   tión_, _nyaw, _търг, _bnf_,
   {{0x661d19e0,0x69d9bdd2,0x3ea000f1,0xec769619}},	//   _lask, lawe, zmit_, лпы_,
   {{0x7bd53dd3,0x6aad3dd4,0x25af80dd,0x9f5801e8}},	//   _mezu, _biaf, _tggl_, herò_,
   {{0xe1ff161b,0xceb2804c,0x69d9822e,0x1cb98013}},	//   sión_, _היא_, nawe, _كاتب_,
   {{0xfce58729,0x798d00b4,0xdb0e0032,0x764d3dd5}},	//   _соло, _cyaw, _egbè, dkay,
   {{0x44fd3dd6,0x7e698110,0x201124e7,0xdb1c002a}},	//   dì_, liep, gezi_, _xeró,
   {{0xcfd880c8,0xb87b0ece,0x2d8f01ec,0x69bc064a}},	//   _সামন, tuír, ügen_, _एलपी,
   {{0x661d3dd7,0x69d9bdd8,0x6e3b8365,0xe3cd00ab}},	//   _cask, jawe, njub, _লাগব,
   {{0x61e43dd9,0x3ea00648,0x62863dda,0x9f580388}},	// [2ae0] _idil, rmit_, moko, teró_,
   {{0x62863ddb,0x09cc90be,0xdb1c0019,0x3ea03ddc}},	//   loko, ार्य, _terü, smit_,
   {{0x272382bb,0x6e3bbb0f,0x661d3ddd,0x91d086a7}},	//   _nın_, kjub, _fask, दरलै,
   {{0x2485bdde,0x661d00a4,0x62860b09,0x69d9bddf}},	//   holm_, _gask, noko, gawe,
   {{0x1ae03792,0x186a9bdc,0x9f581e09,0x91e3bde0}},	//   _पटकथ, нади_, peró_, соче,
   {{0x69d63de1,0x62863de2,0x7bd53de3,0x6d5b8748}},	//   _leye, hoko, _gezu, dzua,
   {{0xeb970bda,0x69d99e54,0xdb1c0333,0x62863de4}},	//   _бир_, bawe, _veró, koko,
   {{0x660402ee,0xf1b9b6f0,0x60c4072f,0x79892358}},	//   nfik, _paše_, _otim, żewi,
   {{0x54548e8e,0x20110c2e,0xb21b03ba,0x60c43de5}},	//   ивит, yezi_, klær, _ntim,
   {{0xf1b99eee,0x4cc380ab,0xdb0e046d,0xe64487c0}},	//   _vaše_, _শিশু, _agbé, ılış,
   {{0x60c43de6,0x798d0859,0x4394bde7,0xaa5919fe}},	//   _atim, _syaw, ранс, вину_,
   {{0x201ea7ba,0x20112994,0xe45287d2,0x62863de8}},	//   _hati_, wezi_, _گفتگ, goko,
   {{0x201e9af2,0x661d3de9,0x20113dea,0x61e40114}},	//   _kati_, _rask, tezi_, _ddil,
   {{0x61e40a0b,0x661d3deb,0x201e8397,0x76428079}},	//   _edil, _sask, _jati_, _hooy,
   {{0x7bdabdec,0x661d3ded,0x201e885c,0x20113dee}},	//   matu, _pask, _mati_, rezi_,
   {{0x201e8324,0x7642ba46,0x69d61210,0xdb188192}},	//   _lati_, _jooy, _geye, _bevö,
   {{0x20113def,0x764d3df0,0xdb0501ec,0xdddb81d0}},	// [2af0] pezi_, rkay, schü, nouš,
   {{0x201ebdf1,0x69c0bdf2,0x44fd3df3,0x661d3df4}},	//   _nati_, _afme, rì_, _wask,
   {{0x7bd50b67,0x69d9a169,0x44fd3d36,0x8af902a4}},	//   _vezu, tawe, sì_, тнес_,
   {{0x7bdabdf5,0x7f3a00be,0x21290168,0x7d160428}},	//   hatu, _סערו, _krah_, bwys,
   {{0x7bdabdf6,0x201ebdf7,0xe0df3df8,0x6728bdf9}},	//   katu, _bati_, nsò_, _ardj,
   {{0xe800a9b7,0xd2d7190c,0xb3468214,0x67288b80}},	//   ल्ला_, _مغرب, _kaçı, _brdj,
   {{0xe73982da,0x201ebdfa,0x7bdabdfb,0x629b801c}},	//   тей_, _dati_, datu, _thuo,
   {{0x8aa48aca,0xddc2809a,0xb87b0317,0xa2678098}},	//   _груд, _iloś, crív, _съгл,
   {{0x7bdabdfc,0xee36827e,0x69d63dfd,0xb5fd8984}},	//   fatu, рны_, _reye, lišk,
   {{0x6e3bbdfe,0x201e80f1,0x62863dff,0x44213b15}},	//   sjub, _gati_, woko, ndh_,
   {{0x4421279d,0x21290397,0x62863e00,0xb5fd8984}},	//   idh_, _arah_, toko, nišk,
   {{0x201e811b,0x3cee8072,0x764281b4,0x2cae8362}},	//   _zati_, _आमचे_, _gooy, _eifd_,
   {{0x62863e01,0x7bda9611,0x44313e02,0x8e8480f7}},	//   roko, batu, _onz_, _النه,
   {{0x7bdabe03,0x9f58007b,0x25bfbe04,0x6c7980be}},	//   catu, ferð_, lcul_, _שאַפ,
   {{0x07a605d3,0x8fa61cd5,0x62863e05,0x45d61354}},	//   равн, раве, poko, ицат,
   {{0x25bf8590,0x13da80ab,0x64553e06,0x6443be07}},	//   ncul_, _দায়, _alzi, _honi,
   {{0x6443be08,0x6604208b,0xb4663e09,0x21292368}},	// [2b00] _koni, rfik, акал, _grah_,
   {{0x75243e0a,0x3eaf8a0f,0xe457113f,0x61fb87db}},	//   rviz, _ligt_, ажу_, _acul,
   {{0x3a200a8e,0x6443a776,0x44310267,0x201ebe0b}},	//   _kaip_, _moni, _dnz_, _rati_,
   {{0x201e803b,0x4421154c,0x6443946f,0xa9268e97}},	//   _sati_, adh_, _loni, идел,
   {{0x201e9f7c,0xd3788025,0x7bda8545,0x67288904}},	//   _pati_, maće_, yatu, _srdj,
   {{0xdb1c0125,0x7ee68790,0x6443be0c,0x6aa2bb99}},	//   _ferð, ацие, _noni, smof,
   {{0x7bdabe0d,0xdb1c0125,0xd6d784d9,0x290d8102}},	//   vatu, _gerð, аты_, _epea_,
   {{0xf53f3e0e,0x7bdaa892,0x7e7601e0,0x96348389}},	//   _igår_, watu, nnyp, сниц,
   {{0x7bdabe0f,0xd90e8bca,0xdd978ca4,0xd49a8256}},	//   tatu, _آیت_, ишь_, кро_,
   {{0x656fb128,0x7642885a,0x320902c4,0x6443a91e}},	//   úcha, _wooy, _sbay_, _coni,
   {{0xc5e880c8,0x0bb70051,0x6f09009a,0xc7b8817f}},	//   ক্ষা_, ילים_, łecz, _gađa_,
   {{0x7bdabe10,0x3ced8082,0xd3789487,0xaa673e11}},	//   satu, brev_, jaće_, рток,
   {{0x7bdabe12,0xdfdb0098,0x6443be13,0xd37880ce}},	//   patu, къв_, _foni, daće_,
   {{0x27ed0352,0x64438988,0x588701e2,0xf1b9be14}},	//   ßen_, _goni, рыма, _maša_,
   {{0x80d881ce,0x09d780ab,0xe0df3a68,0x27ed02d0}},	//   _नौसे, _হাসা, ssò_, ğen_,
   {{0xb5fd8110,0x27ed0214,0xe65400e8,0x443e8106}},	//   višk, şen_, овсь, ljt_,
   {{0xf1b9be15,0x69dd3e16,0xc7b80289,0x656d81ac}},	// [2b10] _naša_, mase, žđa_, _ľahk,
   {{0x69dd3e17,0x57f505f1,0xa802899b,0x2a690282}},	//   lase, _упот, çıla, _hmab_,
   {{0x94a803a7,0xd3788b67,0xbebc81a9,0x442103ed}},	//   ртта_, baće_, _drīk, rdh_,
   {{0xdb1c07ca,0x69dd3e18,0xb5fd8984,0xc7b882a5}},	//   _verð, nase, rišk, _rađa_,
   {{0x634a8201,0xb5fd8110,0x645a8079,0xe4a703a7}},	//   lənd, sišk, khti, _врво,
   {{0x69dd3e19,0x89348065,0xe2d90065,0xb87b157a}},	//   hase, تعما, _مارچ_, crít,
   {{0x81e200c8,0x69dd3e1a,0x6d4d0def,0xb92081bc}},	//   ন্ট_, kase, lyaa, _karị_,
   {{0x6443be1b,0x80b800c8,0x69dd3e1c,0xb920819d}},	//   _soni, _অবস্, jase, _jarị_,
   {{0x6d4d0d7a,0x6443be1d,0xb5fd8e63,0x25bf8087}},	//   nyaa, _poni, niši, rcul_,
   {{0x25bfbe1e,0xd37885a2,0x799b8300,0x628d3e1f}},	//   scul_, zaće_, _izuw, _akao,
   {{0xd7958013,0x3a2003ac,0x6443be20,0x7e6d3e21}},	//   _الاخ, _paip_, _voni, kiap,
   {{0xc0493e22,0x64438613,0x69dd3e23,0x42561878}},	//   _אז_, _woni, gase, стот,
   {{0xd3788024,0xa3d73e24,0x2f01be25,0x2ba7016f}},	//   vaće_, सरा_, lóg_, केता,
   {{0x645abe26,0x2902231b,0x7bd8910f,0x10a6002e}},	//   chti, rtka_, _gevu, сигн,
   {{0x3a200a8e,0xd378876c,0xaa4601e5,0xdddb81b9}},	//   _taip_, taće_, _гейл, kluż,
   {{0x7bc1be27,0x765bbe28,0x69c101d0,0xaac48a19}},	//   lclu, nhuy, ělec, _بتون,
   {{0xe5a324c8,0xd37881dd,0x6da33e29,0x3ae382d0}},	// [2b20] зити, raće_, зита, lıp_,
   {{0xf1b981f4,0xd3788390,0xb87b2216,0xb3d58264}},	//   _raša_, saće_, rsíc, _দাঁড়,
   {{0x3ce01031,0xf1b9979d,0x68e4013c,0x6d4d0d92}},	//   ssiv_, _saša_, _hvid, ayaa,
   {{0xeb9702c7,0xe8040105,0xddcd0087,0xb5fd8115}},	//   щих_, श्रा_, rnaţ, biši,
   {{0xcfcf80c8,0xaca40135,0x7bc194a2,0xdd920c2a}},	//   _রাজন, _anụr, kclu, _روس_,
   {{0xf1b9be2a,0x3ae382d0,0x6e2408bf,0x99dd84e8}},	//   _vaša_, kıp_, ldib, _voňa,
   {{0x76460110,0x7bd8be2b,0x69dd3e2c,0x7bde3e2d}},	//   _koky, _revu, yase, mapu,
   {{0x6e243e2e,0xdb1c016d,0x645d80f1,0xceb30039}},	//   ndib, _berö, ësin, היה_,
   {{0x7d043e2f,0x764601e2,0x69dd03ca,0x7bd881a1}},	//   ntis, _moky, vase, _pevu,
   {{0x7bde103b,0xb4d6000d,0x409680f7,0xe7f28592}},	//   napu, _सबै_, _الطر, _घाटा_,
   {{0x69dd3e30,0x7d043e31,0x68e40e94,0x539880e8}},	//   tase, htis, _avid, рвня_,
   {{0x645a820f,0x7d04120b,0x7ae30511,0xf363876a}},	//   shti, ktis, ánti, ятын,
   {{0x7bde3e32,0xd90f0077,0x6443016d,0x6d4d0079}},	//   kapu, رید_, önik, xyaa,
   {{0x80b800ab,0x634a8085,0x69dd3e33,0x68e901a1}},	//   _অবশ্, tənd, sase, šedo,
   {{0xf773115f,0x6fda0ee6,0x69dd3e34,0x764602c4}},	//   ساس_, _बजरं, pase, _boky,
   {{0xdceb0a21,0x8afc809a,0x7d04075e,0x6e240ec9}},	//   žičk, rzęd, ftis, gdib,
   {{0x76463e35,0x68e40dc1,0x26de14b5,0x68e28824}},	// [2b30] _doky, _gvid, átor_, jsod,
   {{0x7e6d1083,0xb5fd811f,0x7bde3e36,0x6d4d0079}},	//   siap, riši, gapu, ryaa,
   {{0x6d4d07d5,0xb87b002a,0x6e242ad9,0xb5fd8088}},	//   syaa, brír, bdib, mišv,
   {{0x09ad00c8,0x9989003a,0x200cbe37,0xa3c90424}},	//   _ক্যা, _znaš_, _abdi_, ैरह_,
   {{0xab620182,0x645885b4,0x7d043e38,0xe9d88a8e}},	//   _çünk, _olvi, ctis, скі_,
   {{0x3ae38214,0xd5e28032,0x7ff5803d,0x1ec98878}},	//   yıp_, _amò, زستا, алки_,
   {{0x8fa2867c,0xaad786a7,0xb87b0144,0x70b50035}},	//   маше, _भौंक, nríq, ंदुल,
   {{0x245b83d3,0x44233e39,0x6e229493,0x2f01be3a}},	//   _même_, _haj_, _caob, róg_,
   {{0x44233e3b,0x64470025,0x628b9f1e,0x1fa61d40}},	//   _kaj_, _koji, mogo, _खण्ड,
   {{0x628bbe3c,0xdb1c10f6,0x3d098321,0x60c9b593}},	//   logo, _verö, _वहीं_, _item,
   {{0x68e4011f,0xeb99be3d,0x64900364,0x3b099ac9}},	//   _svid, рин_, päiv, шено_,
   {{0x44233e3e,0x64473e3f,0x7bde01df,0xa3b58ebf}},	//   _laj_, _loji, zapu, _झलक_,
   {{0x7bde2d1f,0xe820800d,0x229c816b,0xa3a93738}},	//   yapu, _यसमा_, níka_, खेत_,
   {{0x44233e40,0x9f5800e7,0x6e228b5d,0x660998e8}},	//   _naj_, lgré_, _zaob, lfek,
   {{0xe29a1b93,0x61e99ba5,0xa7aa3e41,0xf1b98353}},	//   _как_, _odel, рква_, _našo_,
   {{0x69db8352,0x7bde04cd,0x61e9803d,0x6e2427f5}},	//   _neue, wapu, _ndel, udib,
   {{0x6447025b,0x7bde2575,0x0eb6000f,0x628bbe42}},	// [2b40] _boji, tapu, _आंकड, dogo,
   {{0x7659831d,0x44233e43,0x61e9be44,0x64473e45}},	//   _llwy, _caj_, _adel, _coji,
   {{0xb7240077,0x7c238722,0x8fa6284f,0xe73a1bdc}},	//   _عکسه, _manr, _фане, _тен_,
   {{0x20180179,0x7afd8063,0x212000dd,0x6b7a80be}},	//   leri_, ństw, _ksih_, ברענ,
   {{0x44233e46,0x64a602cb,0x69c284c3,0x7bde3e47}},	//   _faj_, _мама, rcoe, papu,
   {{0x6e22a8e1,0x20183e48,0x61e9be49,0x2912022e}},	//   _saob, neri_, _edel, _mpya_,
   {{0xf8bf8a0f,0x6609a09b,0x68e2be4a,0x69db81ec}},	//   _één_, ffek, ssod, _feue,
   {{0x442301e9,0x7bdc3e4b,0x20183e4c,0xe3b8817b}},	//   _zaj_, _heru, heri_, rdım_,
   {{0x7bdc07d5,0x7c23be4d,0xd378911b,0x442301c5}},	//   _keru, _banr, daća_, _yaj_,
   {{0x2018003a,0xddc40f20,0x344a9810,0x44230069}},	//   jeri_, jniž, рчин_, _xaj_,
   {{0x7bdc1a67,0x6e228ad0,0x64900009,0x61e9806a}},	//   _meru, _taob, läis, _ydel,
   {{0xbebc8029,0xf1b18105,0xbddb0036,0x7529811a}},	//   _brīv, ुँचन, _poèm, bvez,
   {{0x2906be4e,0x64900198,0xe53486d2,0xddcd01d0}},	//   ntoa_, näis, _хель, chař,
   {{0x20183e4f,0x7bdc3e50,0x7c238114,0xe3af8019}},	//   geri_, _neru, _ganr, عری_,
   {{0x6447349a,0x6abc00dd,0x466b3e51,0xe9f9001c}},	//   _roji, _nurf, арам_, _chả_,
   {{0x44233e52,0x644704b9,0x64900009,0x7bdc3e53}},	//   _saj_, _soji, käis, _aeru,
   {{0x7bdc3e54,0x20183e55,0x44233e56,0x628b8503}},	// [2b50] _beru, beri_, _paj_, vogo,
   {{0xb5fd803a,0x20183e57,0x7bdc3e58,0xf1b9b78b}},	//   lišt, ceri_, _ceru, _pašo_,
   {{0x442301e9,0x628b8503,0x60c987ea,0x7bdc3e59}},	//   _vaj_, togo, _stem, _deru,
   {{0x61fd2280,0xf1b9807a,0xb87b0187,0x78bb87b8}},	//   ngsl, _vašo_, juíz, _puuv,
   {{0x44230025,0x3ea90364,0x7bdc3e5a,0x61fd3e5b}},	//   _taj_, mmat_, _feru, igsl,
   {{0x7bdc044e,0x3ea91f5d,0xb5fd807a,0x44b40098}},	//   _geru, lmat_, hišt, _обяс,
   {{0x7bc51b7c,0xa2ab8697,0x69db81ec,0x6abc0041}},	//   mchu, जगद्, _teue, _gurf,
   {{0xee39867c,0xe9df87ca,0xb5fd90d1,0x61e9be5c}},	//   сни_, _þú_, jišt, _udel,
   {{0x7bdc1d1b,0x1c0b000d,0x1a68803d,0x195881bb}},	//   _yeru, स्थल_, _بینی_, _даты_,
   {{0x200100f6,0x75298065,0x3ea927df,0x7bc53e5d}},	//   _nchi_, rvez, hmat_, nchu,
   {{0xf9890159,0x7c23be5e,0x3ea9059c,0x260c11bc}},	//   _ער_, _vanr, kmat_, ड्डी_,
   {{0xc86904de,0x98a90279,0x6721817f,0x20183e5f}},	//   _גן_, _drač_, _islj, weri_,
   {{0x20183e60,0x3ea90ad4,0xd378812b,0x7c23861c}},	//   teri_, dmat_, raća_, _tanr,
   {{0xb5fd8b67,0x39408198,0x2a7f82d4,0x64902079}},	//   rišu, äisi_, _ljub_, häir,
   {{0x2bd1835a,0x7bdc11ee,0x20183e61,0x43758158}},	//   _द्या, _reru, reri_, _מײַן_,
   {{0x7bdc085c,0x20010133,0x3ea9028c,0x98a008ae}},	//   _seru, _echi_, gmat_, _orić_,
   {{0x7bdc3e62,0x959a3aa3,0x20183e63,0x056636ae}},	// [2b60] _peru, ству_, peri_, чван,
   {{0xf1bf3e64,0x14231b67,0xdb0e04be,0x69c608f9}},	//   ndán_, ндум, _agbá, lcke,
   {{0x7bdc3e65,0x2ba704e5,0xdc9a80be,0x68f981ed}},	//   _veru, केला, ציעל, euwd,
   {{0x64900364,0xb87b01df,0x645e3df9,0xfc3f01df}},	//   täis, xuíz, shpi, _xuíz_,
   {{0x7bdc03ac,0xc5f3012a,0x3a26800b,0xf91880d7}},	//   _teru, _אדר_, rdop_, تراژ_,
   {{0x7bc5279e,0xb5fd8668,0x2a7fb2df,0x6e26020d}},	//   cchu, zišt, _ejub_, _hakb,
   {{0x64a30be4,0x2906be66,0x98a00b80,0x63830251}},	//   _чара, stoa_, _erić_, _згра,
   {{0x44443e67,0xb86680d5,0xa534be68,0x64903e69}},	//   lj_, _کارو, днич, päis,
   {{0x444401e9,0xb5fd9620,0xfc3f157a,0x6e263e6a}},	//   oj_, višt, _ruíz_, _makb,
   {{0x44443e6b,0x3ea93e6c,0xfd0f81a8,0x6aa405ee}},	//   nj_, zmat_, اجي_, _ahif,
   {{0x444401c5,0x443801b0,0xb5fd90d1,0x04fe80ab}},	//   ij_, _mnr_, tišt, ্টের_,
   {{0x6aa43e6d,0x7f3b8039,0x20013e6e,0x61e2be6f}},	//   _chif, _לעבו, _schi_, naol,
   {{0xb5fd803a,0x444400ee,0x3ebe9670,0x81e180ab}},	//   rišt, kj_, _hutt_, _দাম_,
   {{0x8c438652,0xb5fd8115,0x042080ab,0x7b058198}},	//   _пече, sišt, বাহী_, öttö,
   {{0xb5fd801b,0xe9ff801c,0x6e263e70,0x98a68088}},	//   pišt, _loạn_, _bakb, jvoč_,
   {{0x44443e71,0x7afabe72,0x6aa40d8b,0x5f9400e8}},	//   ej_, mutt, _ghif, хист,
   {{0x644abe73,0x7afabe74,0x61ed3240,0x628f01ac}},	// [2b70] _kofi, lutt, _idal, moco,
   {{0x60cd3e75,0x5ba71777,0x7c2894ba,0x628f0c1d}},	//   _itam, през, nddr, loco,
   {{0x7afaaa3d,0x7bc53e76,0x644a8915,0x660281a1}},	//   nutt, rchu, _mofi, _ocok,
   {{0x444410af,0xe1ff3e77,0x7bc51d77,0x27e33e78}},	//   aj_, ngó_, schu, lajn_,
   {{0xa95480e8,0x92b48060,0xb5fb04be,0x7afaaada}},	//   нкці, رحما, _alág, hutt,
   {{0xf77083f8,0x7afabe79,0xe0d08591,0x644abe7a}},	//   گاه_, kutt, ازن_, _nofi,
   {{0x9ea98056,0x69c600f2,0x16a99240,0x628f06cb}},	//   овка_, ycke, овки_, koco,
   {{0x7c273e7b,0x61ed3e7c,0x7afaa1da,0x2a7faf12}},	//   _hajr, _ndal, dutt, _ujub_,
   {{0x644abe7d,0x68e480f7,0x3e6a803d,0x60cd3051}},	//   _bofi, áidt, تجوی_, _ntam,
   {{0x61ed045c,0x644abe7e,0x6aa433fe,0x8b07928a}},	//   _adal, _cofi, _shif, _naří,
   {{0x60cd3e7f,0x1c020b04,0x6721856f,0x28b706af}},	//   _atam, र्टल_, _uslj, _इंजि,
   {{0x628f002a,0x60db8a03,0x2d8e8135,0x68e9be80}},	//   goco, _kwum, ịlị_, _kved,
   {{0x752d02a5,0x660d3e81,0x98a48087,0x61ed3e82}},	//   jvaz, dfak, _urmă_, _ddal,
   {{0x764b8065,0x6e298ca6,0x7afa80df,0x7c273e83}},	//   _hogy, ldeb, butt, _najr,
   {{0x2dcb0a2c,0x28dd8b75,0x628f0359,0x60cd34c2}},	//   _ụlọ_, नीति, boco, _etam,
   {{0x44279e7c,0x444401e9,0x661bbe84,0x96950f27}},	//   _han_, wj_, neuk, еруш,
   {{0x4427be85,0x7c27269d,0x644a8b99,0xfce30009}},	// [2b80] _kan_, _bajr, _yofi, кото,
   {{0x444410af,0x4427be86,0xb5fb3e87,0x660d036e}},	//   uj_, _jan_, _alád, afak,
   {{0x4427be88,0x6e263e89,0x7d09be8a,0xe1ff3d9f}},	//   _man_, _takb, htes, ciós_,
   {{0x4427be8b,0x8b07801b,0x7d09be8c,0xe1ff009a}},	//   _lan_, _zaří, ktes, chód_,
   {{0x09e390f8,0x44278129,0xe3e380ab,0x61e2be8d}},	//   точн, _oan_, _মানব, raol,
   {{0x4427be8e,0x645c048d,0xdfcf80a0,0x68e981a1}},	//   _nan_, _ulri, ليه_, _dved,
   {{0x63bc01a1,0x61e280e5,0xdde181f4,0x60db871f}},	//   _igrn, paol, _šuša, _ewum,
   {{0x4427bade,0x27e328fc,0x661b804f,0x7afa8198}},	//   _aan_, zajn_, geuk, vutt,
   {{0x4427be8f,0x628f1d3a,0xe7cfbbf1,0xc7b8826c}},	//   _ban_, voco, _स्वप, _lađi_,
   {{0x4427804c,0x7afabe90,0x61e0816d,0x3ebe847f}},	//   _can_, tutt, _heml, _tutt_,
   {{0x4427be91,0x764b8019,0x68e98259,0x61e0b204}},	//   _dan_, _fogy, _zved, _keml,
   {{0xc7b8be92,0x60c0be93,0x7afa81dc,0x4427be94}},	//   _nađi_, _kumm, rutt, _ean_,
   {{0x44278cf7,0x27e3012b,0xe8058e5b,0x60c0be95}},	//   _fan_, tajn_, _रामा_, _jumm,
   {{0x4427be96,0x60c0be97,0xa3dfbe98,0x628f3e99}},	//   _gan_, _mumm, तरण_, soco,
   {{0x764b88b3,0x27e304b7,0x2bdd0072,0x7bca82a6}},	//   _yogy, rajn_, यरसा, _iffu,
   {{0x61ed3e9a,0x4427be9b,0x61e0854f,0xfe1480d4}},	//   _udal, _zan_, _neml, _थॉमस_,
   {{0x4427be9c,0x60c0be9d,0x60cd04bf,0x6e940db6}},	// [2b90] _yan_, _numm, _utam, титу,
   {{0x201c803a,0x752d2d08,0x69c980f3,0x4cc800ab}},	//   jevi_, rvaz, _sfee, _লিখু,
   {{0xa3a90d38,0x68e9be9e,0xc7d60051,0xd3711e13}},	//   खें_, _sved, _אותי_, دها_,
   {{0xa4d500e8,0x3a291699,0x7d09971c,0xd3a4066a}},	//   _помі, _jaap_, ytes, труп,
   {{0xb5fb003e,0x7c270197,0xe6ed81ac,0xcce700f7}},	//   _vlád, _tajr, _väčš, _تسجي,
   {{0x07a5838d,0x8fa58847,0xa15801c6,0x78fc01c6}},	//   налн, нале, ובדה_, קלופ,
   {{0x4427be9f,0x3eb90157,0x26c13ea0,0x2eb591d0}},	//   _ran_, _kist_, _juho_, нсис,
   {{0x6d258dcd,0x7bca924b,0x2d990198,0x26c13ea1}},	//   едиз, _affu, _kyse_, _muho_,
   {{0x68e9827f,0x6fca90c5,0x3eb93ea2,0xe5798009}},	//   _uved, _स्कू, _mist_, язи_,
   {{0xf1b9bc6d,0x3eb93ea3,0x201c828e,0x224d83b2}},	//   _naši_, _list_, cevi_, _hoek_,
   {{0x4427bea4,0xe29a0d69,0x09ad00ab,0xdbdc81fa}},	//   _van_, зан_, _ক্লা, ráði,
   {{0x4427bea5,0x7bca8c2e,0x60c0a0ae,0xc332007c}},	//   _wan_, _effu, _yumm, אוט_,
   {{0x3ead8f06,0xdb1c00f2,0xddc98029,0x4427b3ce}},	//   mmet_, _ifrå, cieš, _tan_,
   {{0x3eadbea6,0x4427a12b,0x26c13ea7,0x3eb90362}},	//   lmet_, _uan_, _buho_, _aist_,
   {{0x3eb93ea8,0x4ac6903e,0xa0a3373a,0x66c782d0}},	//   _bist_, _रूपव, уард, _yıka,
   {{0x09da00ab,0xb5fb3ea9,0xe61f00e1,0x3e7a81a9}},	//   _থাকা, _aláb, _skôr_, tīti_,
   {{0x61e63eaa,0x33f6183a,0xdbe2826b,0x3ead8386}},	// [2ba0] makl, ечес, _béèd, imet_,
   {{0x61e63eab,0x60c0beac,0x3eadbead,0xa3df8c28}},	//   lakl, _rumm, hmet_, तरि_,
   {{0x224d8b3c,0x09d780c8,0xaca38135,0x60c0beae}},	//   _boek_, _হাজা, _ahịh, _summ,
   {{0x2cb8034a,0x3ead80f1,0xb34683a7,0x224d8267}},	//   _wird_, jmet_, laçõ, _coek_,
   {{0x645b0065,0x3eadbeaf,0x201cbeb0,0x601382d0}},	//   áció, dmet_, tevi_, kımı,
   {{0xeee70077,0x20c6001c,0xddc98bb6,0xd6da8c24}},	//   _تغیی, _môi_, vieš, пти_,
   {{0x442a0282,0x03a33eb1,0xf093012a,0xda200105}},	//   _iab_, _биро, אנג_, _बसंत_,
   {{0x9634867c,0x442a3eb2,0x60c0beb3,0xddc981a9}},	//   тниц, _hab_, _tumm, tieš,
   {{0x06e085fc,0x644e0063,0x61e61ca6,0x442a3eb4}},	//   _गौरव_, _kobi, dakl, _kab_,
   {{0x224d8613,0x545498a0,0xddc9b7f6,0x2cb8816d}},	//   _zoek_, твот, rieš, örd_,
   {{0x442a2f54,0x3ea68168,0xb346841c,0x7e640234}},	//   _mab_, _thot_, daçõ, khip,
   {{0xf1b981a1,0x2456007b,0x20c600ff,0xa75b825f}},	//   _saši_, _dæmi_, _bôi_, _מדבר,
   {{0x2bd18105,0x51843eb5,0x7e6409c4,0x26c13eb6}},	//   _द्वा, гура, dhip, _suho_,
   {{0x442a0069,0x3eb9035f,0xb346beb7,0x634a8085}},	//   _nab_, _sist_, gaçõ, lənm,
   {{0xf1b9beb8,0x61f40106,0x5f95041c,0x443f0129}},	//   _vaši_, ådlö, тивт, _đu_,
   {{0x78ba9087,0x61e60214,0x3a293bb0,0x439b8039}},	//   _litv, cakl, _uaap_, _מבוג,
   {{0x442a3996,0x3eb93eb9,0x8d770eca,0x442c8114}},	// [2bb0] _bab_, _vist_, رارا, odd_,
   {{0x442a2bf4,0x645abeba,0xb3468073,0xe8058beb}},	//   _cab_, nkti, caçõ, _राधा_,
   {{0x442a01e9,0x442cb3d0,0x443c81a1,0x2d99067f}},	//   _dab_, idd_, _mnv_, _wyse_,
   {{0x7c2a83ec,0xdbe2846d,0x442a1fa4,0x6013a2f8}},	//   _lafr, _dééd, _eab_, zımı,
   {{0x442a3dd7,0x6e3d01ec,0x26debebb,0x99800088}},	//   _fab_, _insb, _awto_, _kaiš_,
   {{0x644e1e4f,0x61e61286,0xa3bc8fcc,0x442a3ebc}},	//   _gobi, zakl, _अलग_, _gab_,
   {{0x7d0d3ebd,0xddcd0087,0x81e70264,0xdb1c08f9}},	//   ltas, ciaţ, _পান_, _ngrè,
   {{0x6e2d3ebe,0xb34680a9,0x442c8355,0x3eb9bebf}},	//   ndab, zaçõ, edd_, öst_,
   {{0x3eadbec0,0x442a3ec1,0x12bd80c8,0x443cba98}},	//   rmet_, _yab_, _আবেদ, _bnv_,
   {{0x09e100ab,0x3eadbec2,0x442a0069,0x61e600b9}},	//   _ভাষা, smet_, _xab_, wakl,
   {{0x6fca800f,0x61e622d1,0x764f3ec3,0x601382bb}},	//   _स्टू, takl, _oocy, rımı,
   {{0x27e7bec4,0x161126ee,0x7d0d3e8c,0x799b808e}},	//   lann_, _डॉलर_, ktas, _kyuw,
   {{0xed4e86f1,0xb3468073,0x61e63ec5,0x6e2d0079}},	//   _то_, taçõ, rakl, ddab,
   {{0x27e78013,0x7d0d013c,0x38a4016d,0xfaf880eb}},	//   nann_, dtas, föra_, brī_,
   {{0x644e21a9,0x442a3ec6,0xb3468073,0x6b66a55e}},	//   _robi, _rab_, raçõ, _végé,
   {{0x442a01e9,0x20c60104,0x644e3ec7,0x27e7ad53}},	//   _sab_, _tôi_, _sobi, hann_,
   {{0xd0408086,0x442a10af,0x6e2b849f,0x644e1188}},	// [2bc0] _etmə, _pab_, _magb, _pobi,
   {{0x442a01e9,0x61e40357,0x644e02f7,0x6e2b84be}},	//   _qab_, _heil, _qobi, _lagb,
   {{0x2c138c28,0x442a3ec8,0xbddb3b51,0x27e7bec9}},	//   त्यं_, _vab_, _poèt, dann_,
   {{0x6aa9beca,0x6e2b849f,0x7afe3ecb,0x60c40010}},	//   _chef, _nagb, rupt, _kuim,
   {{0x442a01e9,0x442ca065,0xe3b88059,0x27e7becc}},	//   _tab_, ydd_, ndır_, fann_,
   {{0xcee919f4,0x27e7becd,0x442a3ece,0x644e005c}},	//   _ترین_, gann_, _uab_, _uobi,
   {{0x8a06867c,0xb8c98fd5,0x7c2abecf,0xa7fc8457}},	//   _изве, _गी_, _rafr, _alıc,
   {{0xfaa6953d,0x66043ed0,0x61e43ed1,0x442c831d}},	//   _рабо, ngik, _neil, wdd_,
   {{0xd3788067,0x27e7bed2,0x47e180ab,0xa3d600a5}},	//   maći_, bann_, _নারী, _सभा_,
   {{0x78ba85f8,0xdb1c00e7,0x27e79a26,0x6b9c3ed3}},	//   _uitv, _agré, cann_, _kyrg,
   {{0x6fd8873c,0x442c8355,0x68ed0b48,0x7d0d3012}},	//   _न्यू, rdd_, _svad, ztas,
   {{0xd3788a20,0x6f798158,0x6282bed4,0x7d0d3ed5}},	//   naći_, _אָנג, nnoo, ytas,
   {{0x61e43ed6,0x60c40ad0,0x94030105,0x6e20bed7}},	//   _deil, _cuim, _लालच_, memb,
   {{0x6e209fce,0x58d42240,0xa2cabed8,0x645d8168}},	//   lemb, рорт, _संप्, ësit,
   {{0x7e62bed9,0x61e43eda,0x260f8701,0x8c1b8039}},	//   _klop, _feil, थ्वी_, _חווי,
   {{0x6e20bedb,0x60c40020,0x7d0d0e20,0x61e43edc}},	//   nemb, _fuim, ttas, _geil,
   {{0xa5070009,0x3944016d,0x7d00bedd,0x16df9513}},	// [2bd0] ъявл, ämst_, nums, _नब्ब,
   {{0x7d0d3ede,0xbbdd0540,0x6e209b8f,0x61e40f67}},	//   rtas, यरेक, hemb, _zeil,
   {{0x27e7bedf,0xddc6009a,0x3946802a,0x7d008088}},	//   vann_, _dokł, exos_, hums,
   {{0x6e20bee0,0x27e7bee1,0x628287b8,0x625396f0}},	//   jemb, wann_, gnoo, _açor,
   {{0x7d00bee2,0x6e208365,0x27e7bee3,0x6f1a8118}},	//   jums, demb, tann_, _aptc,
   {{0x6e2bbee4,0xfa2380ab,0x628281b4,0xaa20050a}},	//   _sagb, ফাইল_, anoo, _बस्छ_,
   {{0x6e2b97ef,0x27e7bee5,0x44211959,0x12bd80ab}},	//   _pagb, rann_, meh_, _আব্দ,
   {{0x44210fc7,0x27e7bee6,0xddcd0029,0x05a70b75}},	//   leh_, sann_, skaņ, _खराब,
   {{0x27e7bb99,0x61e4350d,0xf1b980eb,0x3a3f8122}},	//   pann_, _reil, _pašu_, _inup_,
   {{0x44213ee7,0x60c405f8,0xe9f9001c,0x61e42d01}},	//   neh_, _ruim, _thẻ_, _seil,
   {{0x6e2bbee8,0x91e61d7b,0x60c40cdd,0x21292b36}},	//   _tagb, лоне, _suim, _asah_,
   {{0x44213592,0xcd358416,0x7d00bee9,0x940389ab}},	//   heh_, _مرتب, bums, ƙƙoƙ,
   {{0x61e43eea,0x645d820f,0x4421085c,0x290f839c}},	//   _veil, ësis, keh_, ntga_,
   {{0xe3b882bb,0x4421120e,0x26c5beeb,0x61e43eec}},	//   rdır_, jeh_, _kulo_, _weil,
   {{0x61e43eed,0x91e38074,0x212900b9,0xf1b980c3}},	//   _teil, खराज_, _esah_, _zašt_,
   {{0xa2060fdd,0x26c5beee,0x75243eef,0x7874011c}},	//   _спид, _mulo_, twiz, _müvə,
   {{0x0eb90b71,0x96b909c7,0xe9f9001c,0x22400242}},	// [2be0] туры_, туру_, _nhẹ_, _inik_,
   {{0x6e20bef0,0x29023ef1,0x44213ef2,0x75240db1}},	//   zemb, muka_, geh_, rwiz,
   {{0x7d00b78b,0x6e20b92f,0xd37884a8,0xb17d80e1}},	//   zums, yemb, taći_, _reťa,
   {{0x1efb03c8,0x26d83ef3,0x1c1383eb,0x2c13808e}},	//   _אלטע, mpro_, त्तल_, त्तं_,
   {{0x29023ef4,0x6282ba61,0x44210077,0xb87b041c}},	//   nuka_, rnoo, beh_, rsív,
   {{0x3cf98063,0xb87b00a9,0x3ea03ef5,0x66c787d9}},	//   ोंने_, ssív, llit_, _tıkl,
   {{0x6e208980,0x26c5bef6,0xe8162a2b,0x290200b4}},	//   temb, _culo_, द्या_, huka_,
   {{0x7c2e3ef7,0xe3c1080a,0x26c5820d,0x29023ef8}},	//   _habr, ğış_, _dulo_, kuka_,
   {{0x6e209bcb,0x5986b2f1,0x634a8201,0x7c2e3ef9}},	//   remb, _слаб, məni, _kabr,
   {{0x634a8085,0x7ea58019,0x3e7a80eb,0xd91b807c}},	//   ləni, rópa, tīts_, _אומל,
   {{0x6e209eb3,0x7d00befa,0x7c2e1b42,0x3ea03efb}},	//   pemb, sums, _mabr, klit_,
   {{0x7c2e3efc,0xfce6beb1,0x29023efd,0xa2950221}},	//   _labr, _бодо, fuka_, рамі,
   {{0x6e938624,0xf1b9826c,0x44212eb7,0x667b80be}},	//   _النا, _hašr_, yeh_, _אטאק,
   {{0x2240026c,0xe1ff0333,0x36d50eef,0x6d468198}},	//   _enik_, chón_, иогр, äkau,
   {{0xe7f7946d,0x395f0bb6,0x442e816d,0x2bda801b}},	//   ीलता_, šus_, _iaf_, _म्या,
   {{0x3ea03efe,0x44212709,0x442ebeff,0xf8bf0036}},	//   glit_, weh_, _haf_, uvés_,
   {{0x3cee0063,0x2129078a,0xf8bf02be,0x44213a20}},	// [2bf0] ेंगे_, _usah_, rvés_, teh_,
   {{0x442ebf00,0x225d861b,0xb5fb0511,0x35b43c20}},	//   _jaf_, wkwk_, _glán, сбур,
   {{0x2baa035a,0x9f4780f1,0x44213f01,0x69dd02c4}},	//   _करणा, ranë_, reh_, obse,
   {{0x44213f02,0x60cd9984,0x27e588ae,0x644806c0}},	//   seh_, íamo, _seln_, _òdin,
   {{0x7c2e3f03,0x44213f04,0xd378812b,0xa5bb1e00}},	//   _fabr, peh_, maću_, _caót,
   {{0x46f5a3fc,0x442ebf05,0x3f9e826f,0x26c5bf06}},	//   ачит, _naf_, _bytu_, _pulo_,
   {{0xf771936d,0x36698dc7,0xe7e6016f,0x2902287b}},	//   غات_, како_, करता_, zuka_,
   {{0xee398be2,0x7c2e1620,0xbb840013,0x7c21bf07}},	//   тни_, _zabr, _الفي, welr,
   {{0x81eb00ab,0x656d3f08,0x9f43001b,0x98b9beb1}},	//   মলা_, nzah, dají_, _алат_,
   {{0x9f6b8021,0x26c5bf09,0x5c558425,0xd3788858}},	//   _през_, _tulo_, ртиф, haću_,
   {{0x9f47bf0a,0x290201d3,0x6aad0706,0x68fd000b}},	//   kané_, wuka_, _bhaf, ersd,
   {{0x61eb8c27,0x6f03b3d2,0x6aad3f0b,0x29023f0c}},	//   nagl, munc, _chaf, tuka_,
   {{0x9f47bf0d,0x6f03bf0e,0xb5fb003e,0xaca3819d}},	//   dané_, lunc, _plán, _agụk,
   {{0x29023f0f,0x442ebf10,0x61eb948c,0x2007bf11}},	//   ruka_, _gaf_, hagl, ngni_,
   {{0x6f03a623,0xfaa62103,0x66e6272e,0x29023ebe}},	//   nunc, _како, роба, suka_,
   {{0x22403f12,0xdbdf0125,0x7afc8c58,0x2902004f}},	//   _unik_, _síðu, árte, puka_,

   {{0x6d5b81c5,0x7c2e3f13,0x3ea0007b,0x69c414ed}},	// [2c00] nyua, _pabr, rlit_, _igie,
   {{0xa7fc82bb,0x6f03bf14,0x3ea03f15,0x2baa02f1}},	//   _alın, kunc, slit_, _करदा,
   {{0x6287003e,0x9f47bf16,0xf1a900d7,0x6d5b808e}},	//   čkov, bané_, _لایه_, hyua,
   {{0xeb9715f7,0x2c64016d,0x62863d40,0x6f038bcf}},	//   ших_, _döda_, nnko, dunc,
   {{0x7c2e3f17,0x7bc38081,0xb17d80e1,0x6d5b81c0}},	//   _tabr, _ognu, _deťo, jyua,
   {{0x7d043d95,0xa073835f,0xceb40085,0x2c640106}},	//   muis, огіч, lmə_, _föda_,
   {{0x7d043f18,0x53aa06b7,0xa2ca8935,0x61eb80e5}},	//   luis, _करिश, _संध्, bagl,
   {{0xa2cb09c8,0x62898168,0x2bd21130,0x61ebbf19}},	//   _तंत्, _gjeo, दुरा, cagl,
   {{0x9f43001b,0x7d0405ed,0x6d5b81c0,0xbebc81a9}},	//   vají_, nuis, gyua, _krīz,
   {{0x62863f1a,0x442ead8d,0x9f479c18,0xb806803d}},	//   enko, _qaf_, zané_, _خبره,
   {{0xe9f90028,0x6f03bf1b,0x7d04000b,0x9f478077}},	//   _chế_, cunc, huis, yané_,
   {{0xc3330051,0x7d043f1c,0x7e69bf1d,0x442ebf1e}},	//   קור_, kuis, chep, _waf_,
   {{0x9f478a56,0x442e9acf,0x7d040a6f,0x61f6031d}},	//   vané_, _taf_, juis, _ddyl,
   {{0x786201ac,0x0377804e,0x7d043f1f,0x251b807c}},	//   _dôvo, احیت_, duis, _סווא,
   {{0xe816035a,0x9f47bf20,0xb4c0000d,0xe9f9001c}},	//   द्धा_, tané_, ँदै_, _ghế_,
   {{0x798d10af,0x2c64016d,0xdce60214,0x5f943f21}},	//   _txaw, _röda_, _aykı, цист,
   {{0x7d04087a,0x764d1cbc,0x9f47bf22,0xd90482e3}},	// [2c10] guis, rjay, rané_, _تی_,
   {{0xe8160778,0x9f47bf22,0xea00001c,0x98650065}},	//   द्दा_, sané_, _trải_, _ایسے_,
   {{0x61ebbf23,0x9f47bf0a,0x5b15148d,0x656d0192}},	//   tagl, pané_, смет, szah,
   {{0x09bb00c8,0x7d043f24,0xe8f580f7,0xdddb826c}},	//   _অ্যা, buis, مستخ, knuš,
   {{0xe1f88048,0x3cfe0063,0x200c8a03,0x7e7b80c3}},	//   ргі_, _लिये_, _bcdi_, viup,
   {{0x6f039e53,0xf1bf0061,0x6d5b81c0,0x26d984e8}},	//   tunc, ldás_, vyua, _čsob_,
   {{0xda3597ae,0x61eb809c,0xb5fb0388,0x7e7b80dd}},	//   _левы, pagl, _llám, tiup,
   {{0x44313f25,0x7ea58118,0x6d498102,0x6f03bf26}},	//   _haz_, rópo, txea, runc,
   {{0xee36827e,0x44311c66,0x2aff0054,0x7ea587f0}},	//   сны_, _kaz_, शंकु_, sópo,
   {{0x44310db7,0x3c658364,0xb4658364,0x629982ec}},	//   _jaz_, ског, скол, lowo,
   {{0x64553f27,0x61e98006,0x6d5bbf28,0x20128085}},	//   _mozi, _keel, syua, əyi_,
   {{0x6455003a,0x99808038,0x786201ac,0x60c1bf29}},	//   _lozi, žiť_, _pôvo, _hilm,
   {{0x61e9bf2a,0xf6528039,0x61e4a320,0xd54892c5}},	//   _meel, _מצא_, ðili, _نجوم_,
   {{0xe9f90104,0x1c030665,0x753680be,0x64553f2b}},	//   _thế_, _लागल_, _לאנד_, _nozi,
   {{0x4425b30d,0x6443bf2c,0x6299bf2d,0xceb40085}},	//   mel_, _inni, kowo, tmə_,
   {{0x6609bf2e,0x9f4583fb,0x7d0404fa,0xcf9283de}},	//   ngek, _celé_, tuis, פטן_,
   {{0x6299a4f2,0x44313f2f,0x75298a0f,0x6e241655}},	// [2c20] dowo, _baz_, nwez, reib,
   {{0x64550073,0x44313f30,0x2292016b,0xa3ab8576}},	//   _cozi, _caz_, váky_, _खरा_,
   {{0x61e98c11,0x64553c13,0x291f8009,0xddcb8035}},	//   _beel, _dozi, _apua_, _mogł,
   {{0x4425bf31,0x61e98079,0x201820f0,0x2292016b}},	//   hel_, _ceel, lfri_, táky_,
   {{0x4425bf32,0x60c19010,0x61e98b3c,0x44313f33}},	//   kel_, _bilm, _deel, _faz_,
   {{0xd2598029,0xbb460b88,0xd90d80d5,0x38a9bf34}},	//   _viņa_, _легк, ئیل_, túra_,
   {{0xe80e8e18,0x26c23f35,0x60c1bf36,0xf1bf00e1}},	//   _साठा_, _kiko_, _dilm, ndár_,
   {{0x4425838e,0x61e9aa57,0x6299809a,0x6609836c}},	//   eel_, _geel, cowo, ggek,
   {{0x4425bf37,0x64550db1,0x443103bf,0x89669821}},	//   fel_, _yozi, _yaz_, _укаж,
   {{0xddc28efc,0x61e9bf38,0x26c23f39,0xe8d781c6}},	//   _umož, _zeel, _liko_, _לומר_,
   {{0x61e982a3,0xfd0f80d5,0xb4db0722,0xf743bcb3}},	//   _yeel, وجی_, _gràf, _нефо,
   {{0x32670dea,0x6443bf3a,0x2120008e,0x466980e8}},	//   стов, _enni, _bpih_, _крім_,
   {{0x9f45bf3b,0x4425bf3c,0xb5fb0118,0x201801b9}},	//   _relé_, bel_, _imáx, ffri_,
   {{0x4425bf3d,0x26c20041,0x27ee808b,0x2e3501bc}},	//   cel_, _aiko_, nafn_, _ụf_,
   {{0x443121a9,0x27ff0182,0x26c20870,0xeac9801c}},	//   _raz_, ğun_, _biko_, _hẹn_,
   {{0x64553f3e,0x26c23f3f,0xea00001c,0xf1ba97ba}},	//   _sozi, _ciko_, _trại_, ेशान,
   {{0x5455351e,0x443110dd,0x26c202d5,0xa7fc82d0}},	// [2c30] оват, _paz_, _diko_, _alım,
   {{0x2a690282,0x61e9bf40,0x44310085,0x61ef117d}},	//   _hlab_, _seel, _qaz_, lacl,
   {{0x64551874,0x94a80698,0x50d40065,0x212b031d}},	//   _vozi, стта_, _وزیر, lwch_,
   {{0x4425bf41,0x60c1843d,0x61ef3f42,0xdb0e0091}},	//   zel_, _silm, nacl, _agbó,
   {{0x6299b746,0x60c985a4,0x44313975,0xe3e800c8}},	//   rowo, _quem, _taz_, _পারব,
   {{0x212d8353,0x60c1a795,0x81e180ab,0x6299bf43}},	//   _vseh_, _qilm, _দাও_, sowo,
   {{0x4425bf44,0x2bdf1a87,0x786b07d9,0xb8d0873c}},	//   vel_, _प्या, _güve, _टी_,
   {{0x442585ad,0x0f7c0039,0xd04d00fc,0x826589c4}},	//   wel_, טרול, _kwaɓ, _بهرن,
   {{0x60c1bf45,0x4425bf46,0x61ef0118,0x6609b5da}},	//   _tilm, tel_, dacl, rgek,
   {{0x66099591,0x2a6900e4,0x212b0114,0x752981ed}},	//   sgek, _alab_, dwch_, rwez,
   {{0x2dd5b71e,0x4425bf47,0x2a6900c3,0x7e6d3553}},	//   _джер, rel_, _blab_, khap,
   {{0x4425bf48,0x753d0065,0xd6ab8591,0x9f4783f2}},	//   sel_, _orsz, _صدام_, naní_,
   {{0xa4f7826a,0x26c23f49,0x7e6d1ab3,0x212b0428}},	//   _اکبر_, _riko_, dhap, gwch_,
   {{0x6443807b,0x8c4581a1,0x26c23f4a,0x2a6902f1}},	//   _unni, _феке, _siko_, _elab_,
   {{0x81ea80ab,0x18a301e2,0xa0a33c20,0xe81b8072}},	//   _মাস_, фарм, фард, प्या_,
   {{0x2a6902c4,0x8afc8035,0x00ca1cb2,0xf1bf0118}},	//   _glab_, rzęt, _клик_, meán_,
   {{0x63a3831d,0xf1bf00f7,0xec7a0615,0x9f4783f2}},	// [2c40] _hynn, leán_, апа_, daní_,
   {{0x63a3bf4b,0x67218024,0x0c230198,0x3e6702f1}},	//   _kynn, _oplj, ммун, _võta_,
   {{0x49ca9354,0xeac9801c,0xa5bb026b,0xdb0e0032}},	//   ален_, _mẹo_, _abód, _agbò,
   {{0x7e6d3f4c,0xe81600c2,0x63a3bf4d,0xa3d602f1}},	//   chap, द्रा_, _mynn, _सभक_,
   {{0x2ba6864a,0xb4db0706,0xdfd48a41,0xb5fd81d6}},	//   _ऑर्थ, _cràd, полы, chši,
   {{0x6e360110,0x3a26808e,0x29020df6,0x00000000}},	//   ldyb, seop_, irka_, --,
   {{0xed508019,0xdb0e046d,0x42d60a18,0x03a333d9}},	//   کھا_, _egbò, _фігу, _жиро,
   {{0x6e361503,0x63ae026c,0x6722026c,0xf1bf00f7}},	//   ndyb, _izbn, _ćojl, deán_,
   {{0xceb304de,0xddc2809a,0xd25980eb,0xd00a84ae}},	//   ויה_, _umoż, _ziņo_, _везе_,
   {{0x31e3016f,0x09e30d14,0x0bf38009,0x63a38114}},	//   पर्ध, पर्य, мпью, _bynn,
   {{0x2a690069,0x63a38355,0x61ef3f4e,0x20d0801c}},	//   _plab_, _cynn, tacl, _hài_,
   {{0x61e2bf4f,0xb5fb03c1,0x212b0114,0x63b5816b}},	//   nbol, _vlák, twch_, ýzna,
   {{0xa2ca85b3,0x26ccbf50,0x17e200ab,0x61ef27d3}},	//   _सूर्, _hudo_, _বাড়ি, racl,
   {{0x80dd00c8,0x26cc8168,0x212b0114,0x61ef00e5}},	//   _বিদ্, _kudo_, rwch_, sacl,
   {{0x63a38355,0x61e2bf51,0x8f343c7a,0x29023f52}},	//   _gynn, kbol, мерц, arka_,
   {{0x26cc81b4,0xfb8780d7,0x6458b3d9,0x60dd20e4}},	//   _mudo_, _بدهی, _hovi, ppsm,
   {{0x9f479dc1,0x61e2813c,0x6458bf53,0x7e6d33fe}},	// [2c50] vaní_, dbol, _kovi, rhap,
   {{0x64588390,0x97152ded,0x61ed1357,0x7e6d3f54}},	//   _jovi, _емоц, _heal, shap,
   {{0x6458bf55,0xd4983f56,0x8c2580c8,0x7e6d3f57}},	//   _movi, іру_, বাচন_, phap,
   {{0x20d08142,0x7c288358,0x6458bf58,0x61e28b4e}},	//   _bài_, hedr, _lovi, gbol,
   {{0xdd868307,0x20d08028,0xcfbd00ab,0x9f47826f}},	//   _أو_, _cài_, _অভিন, raní_,
   {{0x20d08028,0x61ed0c9f,0x55ba0039,0x26cca256}},	//   _dài_, _leal, _למרו, _budo_,
   {{0x61e28682,0x26cc8699,0xdb0385b9,0x752d3f59}},	//   bbol, _cudo_, _ozná, lwaz,
   {{0x660d3f5a,0x29023f5b,0x26cc8216,0x69db15c7}},	//   ngak, yrka_, _dudo_, ñuel,
   {{0x7c28bf5c,0xd840026f,0x63a3bf5d,0xb5fb00f7}},	//   fedr, íčky_, _synn, _clái,
   {{0x7c289254,0x26cc88ec,0x60db8d57,0x68e981bc}},	//   gedr, _fudo_, _itum, _iwed,
   {{0x61ed17ca,0x628b8010,0x7c353f5e,0x6458bf5f}},	//   _beal, ongo, _mazr, _dovi,
   {{0x752d3f60,0x213f8988,0xf1bf00f7,0x61ed0ae3}},	//   kwaz, _kruh_, reán_, _ceal,
   {{0x7c28bf61,0xf1bf00f7,0x752d1118,0x20d080ff}},	//   bedr, seán_, jwaz, _xài_,
   {{0x60db822e,0x7d09bf62,0x653a80be,0x7c353f63}},	//   _mtum, mues, _לענד, _nazr,
   {{0x629d2817,0x69c99e3b,0xa7aa1269,0x61ed3f64}},	//   boso, _ogee, сква_, _feal,
   {{0x64470057,0x61ed0083,0x6458817f,0xc6c33832}},	//   _anji, _geal, _zovi, ейск,
   {{0x2bd2a076,0xf1bf00f7,0x60cd00ee,0x7d098168}},	// [2c60] _सलमा, neál_, _guam, nues,
   {{0x7e643f65,0x39403f66,0x69c99a14,0x673e05f3}},	//   skip, _iris_, _agee, _trpj,
   {{0xe8059039,0x6d4b016d,0xf8b30039,0x60dbbf67}},	//   _राजा_, ägar, _רשת_, _atum,
   {{0x39403f68,0x64473f69,0xf53f021e,0x7659809a}},	//   _kris_, _enji, _frå_, _nowy,
   {{0x7c3500b9,0xf53f01a3,0x463b00be,0xb5fb0091}},	//   _fazr, _grå_, _העכע, _aláw,
   {{0xb8f4a3a7,0x26cc85a4,0x61e2ae6c,0x20d0801c}},	//   _सं_, _pudo_, sbol, _vài_,
   {{0x7c28bf6a,0x75229fd4,0xb5fb00f7,0x91e68319}},	//   vedr, _spoz, _slái, _нове,
   {{0x20d08104,0x80dd00c8,0x39400091,0xfaa380e8}},	//   _tài_, _বিস্, _oris_, _засо,
   {{0x6458bf6b,0x2ab20019,0x394001c0,0x68e98114}},	//   _povi, kább_, _nris_, _gwed,
   {{0x26cc80a9,0x7d04244d,0xf044826a,0x6282bf6c}},	//   _tudo_, iris, _تعری, lioo,
   {{0x61ed0665,0x60cd0867,0xe61a8f2f,0x7c288082}},	//   _peal, _suam, _где_, redr,
   {{0x7d043f6d,0xe81f052a,0xaf4980f7,0xcf2580f7}},	//   kris, म्ना_, _بشكل_, _تركي,
   {{0x8c469232,0x7d098693,0xb5fb027f,0xf487881b}},	//   _неде, cues, _kláv, _کانی,
   {{0x629d3f6e,0x7d043f6f,0x61e0007e,0x80e18264}},	//   soso, dris, ımla, _নিম্,
   {{0xda0d823c,0x25afbf70,0x60c502f1,0x628b8428}},	//   _हालत_, _zzgl_, _vihm, yngo,
   {{0x443f07d9,0x752d3f71,0x7d0410b9,0x7c350289}},	//   _şu_, twaz, fris, _sazr,
   {{0xe7cc8076,0x224901ac,0x660d3f72,0xba3b0cd1}},	// [2c70] ाशाप, _inak_, rgak, roïd,
   {{0x628b8114,0x29193f73,0xb4db25dc,0xdfd101a8}},	//   wngo, mtsa_, _aràc, _جيد_,
   {{0xaac70c48,0x7d0412a5,0x290b3f74,0x752d3f75}},	//   ستان, aris, luca_, swaz,
   {{0x7d043f76,0xe3b00013,0x7d180013,0x68e9809c}},	//   bris, ارك_, éasá, _pwed,
   {{0x6e29bf77,0xaca481bc,0x9f47826f,0x29193f78}},	//   veeb, _agọz, daná_, ntsa_,
   {{0x3ea93f79,0xf9940158,0xad9b0032,0x8fa58323}},	//   llat_, ערס_, _adúg, мале,
   {{0xe80e83db,0xb8f48e5b,0x12c780ab,0x7659a9a7}},	//   _सारा_, _सू_, _শব্দ, _powy,
   {{0xd87783f8,0xb4db07e2,0x7d0980f1,0x645cbf7a}},	//   _کارب, _gràc, tues, örin,
   {{0x60db822e,0x63a70168,0x6e2991c9,0x290b3f7b}},	//   _utum, _hyjn, reeb, juca_,
   {{0x22491397,0x7d0980f1,0x2a6dbf7c,0x78700198}},	//   _anak_, rues, _hleb_, _käve,
   {{0x6ee7bf7d,0x2ab20065,0x3ea90587,0x7d0980f1}},	//   _رسال, vább_, klat_, sues,
   {{0x39402280,0x7d099220,0x38a402af,0x7d04007b}},	//   _pris_, pues, hört_, yris,
   {{0x7d0993a0,0x3ea90461,0x66c782d0,0xbbaa0bbc}},	//   ques, dlat_, _fıkr, _कर्क,
   {{0x80dd0a49,0x22493f7e,0x638585c2,0x3e83846d}},	//   _বিশ্, _enak_, _огла, _fètè_,
   {{0x07a30a13,0xb8d50006,0xc79517ae,0xe29f007b}},	//   варн, _छी_, ерты, boð_,
   {{0xe1ff1e1e,0x38a4008b,0xecea246c,0xe05800d7}},	//   lkón_, vöru_, ждал_, _کیست_,
   {{0x32d38028,0x14c80077,0xe80e81ab,0x38a40106}},	// [2c80] _hãy_, سهای_, _साला_, fört_,
   {{0x26cc1313,0x81ea8264,0x9f479ee0,0xa2e6062c}},	//   ídos_, _মাই_, zaná_, дожд,
   {{0x3ea93798,0xb4db009f,0x98a90669,0x3e7a81a9}},	//   blat_, _pràc, _građ_, sūti_,
   {{0x41aa8f80,0xb5fb0a21,0x7d0410b6,0xaca4019d}},	//   овен_, _sláv, pris, _inọr,
   {{0x9f47803e,0x20d40406,0xb5fb3f7f,0x62828074}},	//   vaná_, _jäi_, _cláu, rioo,
   {{0xd6daa64c,0x62828006,0xbddb010c,0xa3c80576}},	//   оти_, sioo, _anèh, _उलट_,
   {{0x44383f80,0xdca31c8b,0x9f47b53d,0x645c3f81}},	//   _iar_, _рари, taná_, _iori,
   {{0x44383f82,0x645c3f83,0xa3c390c5,0x1d3488cc}},	//   _har_, _hori, ्शन_, ения,
   {{0x645c003a,0x4438252d,0x64c895fb,0x9f47bf84}},	//   _kori, _kar_, रदेश, raná_,
   {{0x645c2948,0x628081c0,0x83868071,0x6aa43f85}},	//   _jori, _hmmo, дыме, _akif,
   {{0x645c3f86,0xd37a80e8,0x443810b6,0x9f47bf87}},	//   _mori, ючи_, _mar_, paná_,
   {{0xaacf853f,0x6ab6031d,0x05668012,0x32d38129}},	//   _संरक, _chyf, _овен, _dãy_,
   {{0x3ea93f88,0xa2ca800c,0xaca401bc,0x7c3e8118}},	//   vlat_, _संक्, _anọr, _ópro,
   {{0x645c1c1f,0xb9072cdd,0x44383f89,0xdbf3080a}},	//   _nori, _पऽ_, _nar_, _işçi,
   {{0xc05805e9,0x442ca427,0x25ad1f95,0xd8388503}},	//   фія_, med_, _šel_, _mač_,
   {{0x442cbf8a,0x7c38bf8b,0x3ea93f8c,0x60c8bf8d}},	//   led_, _havr, ulat_, _lidm,
   {{0x67d537cd,0x442c8114,0x443801c6,0x7c3882d0}},	// [2c90] _попу, oed_, _bar_, _kavr,
   {{0x6280bf8e,0xb5fb1931,0x645c3f8f,0x3ea9001b}},	//   _ammo, _alát, _cori, slat_,
   {{0x44383f90,0x645c3f91,0x2a6d81c0,0x7c38bf92}},	//   _dar_, _dori, _pleb_, _mavr,
   {{0x23df08d4,0x442cbf93,0x68ed3f94,0xdd140038}},	//   _प्रद, hed_, _kwad, _súťa,
   {{0x6025a31a,0x645c3f95,0x26de8081,0x6d448110}},	//   едла, _fori, _atto_, _šian,
   {{0x3e71803e,0x442cbf96,0x44383f97,0x7d0d010b}},	//   _máte_, jed_, _gar_, muas,
   {{0x442c804c,0x7d0d3d84,0x8fa2a410,0x6d428cdb}},	//   ded_, luas, лаше, _aroa,
   {{0x4438003a,0xbb480077,0x9f45826f,0x645c0102}},	//   _zar_, _تلفن_, _celá_, _zori,
   {{0x645c026b,0xddc2a7aa,0x44383f98,0x38b60aa2}},	//   _yori, _ploš, _yar_, lære_,
   {{0xe4518013,0x765d3f99,0x6aa40257,0x645c3f9a}},	//   اضة_, _losy, _skif, _xori,
   {{0x7c3883bf,0x68ed38b3,0x6d42bf9b,0x09c80d72}},	//   _davr, _awad, _eroa, रख्य,
   {{0x7d0d0590,0x644ab21a,0xdb1e81d0,0x68ed3f9c}},	//   kuas, _enfi, áván, _bwad,
   {{0x764b8065,0x4423136f,0x6d428087,0x3e6e008b}},	//   _ingy, _obj_, _groa, _nýta_,
   {{0x60c88201,0x2bdf0305,0x442cadc0,0xddc28d2f}},	//   _xidm, _प्ला, ced_, _uloš,
   {{0x7c2380ee,0x7d1bbf9d,0x765d010c,0x68ed3f9e}},	//   _ibnr, ltus, _bosy, _ewad,
   {{0x7c3882a5,0x998d012b,0x7ea58228,0x44383f9f}},	//   _zavr, žeš_, cópt, _sar_,
   {{0x44383fa0,0xeb1f80cf,0x62863fa1,0x645c3fa2}},	// [2ca0] _par_, _बहुत_, miko, _pori,
   {{0x62860ef1,0x69dbbfa3,0x7d1b8009,0x645c01b4}},	//   liko, _afue, itus, _qori,
   {{0x44383fa4,0x020692bc,0xb5fb3fa5,0x645c3fa6}},	//   _var_, езен, _clás, _vori,
   {{0xe29799b8,0xfce604a9,0x62863fa7,0x442cbfa8}},	//   нах_, _помо, niko, zed_,
   {{0x44381100,0xa96796d9,0x216790ca,0x645c15a4}},	//   _tar_, ница_, ници_, _tori,
   {{0x9f4301ac,0x62863fa9,0xdfcf80f7,0x29068102}},	//   vajú_, hiko, ميه_, rroa_,
   {{0x62863faa,0x442c8051,0x6e398420,0x7bce3fab}},	//   kiko, ved_, _bawb, _igbu,
   {{0x7c38803a,0xb65b0158,0x6d42bfac,0x442cbfad}},	//   _savr, ִדיש, _proa, wed_,
   {{0x442c804c,0x62863fae,0xb5fb3faf,0x2dd780f7}},	//   ted_, diko, _klár, ربية_,
   {{0x6aa280c9,0x99808110,0x9f4300e1,0x764bbfb0}},	//   loof, žių_, rajú_, _engy,
   {{0x442cbfb1,0x62863fb2,0x141b00be,0x68ed337a}},	//   red_, fiko, הויב, _swad,
   {{0x442c8434,0x79a70c9d,0x62863fb3,0x2bd28fb2}},	//   sed_, ерге, giko, _सलवा,
   {{0x442c8039,0x3ea6876d,0x7bce2d10,0x7bdc03ed}},	//   ped_, _ikot_, _ogbu, _ofru,
   {{0x765d3a7f,0xd25980eb,0x7413803d,0x6aa29de6}},	//   _sosy, _viņi_, _موها, hoof,
   {{0x02a71afa,0x533495b5,0x62861b19,0xc90d801b}},	//   _прим, _рейт, biko, _सम्म_,
   {{0x68ed3fb4,0xb5fb04be,0x7bce3fb5,0x7d0d12af}},	//   _twad, _alár, _agbu, tuas,
   {{0x6e2d2305,0xe59810ac,0xbbeb01a8,0x9f4a02df}},	// [2cb0] reab, екті_, كرام_, rabá_,
   {{0xb5fb0307,0xb4ab000f,0x7bdabfb6,0x6e2d3fb7}},	//   _clár, खते_, nctu, seab,
   {{0x68fb8024,0x229c816b,0xf99009a7,0x200101b4}},	//   _svud, líky_, _نبی_, _idhi_,
   {{0x7d0d010b,0x7bce0135,0x636b8061,0x212900ff}},	//   puas, _egbu, lönö, _kpah_,
   {{0x229c83c1,0x865a025f,0x7d0d0037,0x81c98264}},	//   níky_, _חדרי, quas, লুন_,
   {{0x62863fb8,0x38b62419,0x1ae68264,0x7afaa7d1}},	//   ziko, pære_, _কিনে_, kstt,
   {{0x201a8722,0x62860cb7,0xd00e81a8,0xdb1506c4}},	//   òpia_, yiko, زلي_, _egzò,
   {{0x62863fb9,0x7c238359,0x7d1ba2c2,0x21290d8b}},	//   xiko, _sbnr, ttus, _opah_,
   {{0xee36827e,0x44ef2358,0x26d30ba3,0x7e69bfba}},	//   тны_, nż_, _luxo_, rkep,
   {{0x44658895,0x2bb80424,0x58d48abe,0x290fbfbb}},	//   твов, _अरमा, _софт, muga_,
   {{0xe29a22a7,0x62863fbc,0x7d1ba47f,0xfbd20051}},	//   дан_, tiko, stus, יתי_,
   {{0x7ea5bfbd,0x225f86c0,0x20013fbe,0xa3b91a3b}},	//   róps, _jouk_, _adhi_, _चरन_,
   {{0x62863fbf,0x3eadbfc0,0xa56480f7,0x290fb044}},	//   riko, mlet_, _مدون, nuga_,
   {{0x3ea0931b,0x26d30118,0x291d804f,0x3ebfbfc1}},	//   čite_, _buxo_, itwa_, lmut_,
   {{0x44ef0063,0x26d301df,0x8fa600b3,0x26cb3fc2}},	//   eż_, _cuxo_, таве, _bico_,
   {{0x7bdc3fc3,0x7aed809a,0x26cb0140,0x291d86c0}},	//   _sfru, _łatw, _cico_, ktwa_,
   {{0xc5f28451,0x7d09bfc4,0x26cb1137,0x3eadbfc5}},	// [2cc0] ידן_, nres, _dico_, ilet_,
   {{0xb4db3fc6,0x3eadbfc7,0x69c2001b,0x224d8b09}},	//   _tràn, hlet_, रेणी, _anek_,
   {{0x3eadbfc8,0x26cb3074,0x7d0981ec,0x78a3ba92}},	//   klet_, _fico_, hres, donv,
   {{0x290f8365,0x6d448110,0x5186a749,0xe8df81bc}},	//   fuga_, _šiam, кула, _erọn_,
   {{0xc05a80e8,0x6aa2bfc9,0x290fbfca,0x78a3bfcb}},	//   дій_, roof, guga_, fonv,
   {{0x7afc24a0,0xa3c392ee,0x7d09bfcc,0x80e180ab}},	//   _tvrt, ्शा_, dres, _নিশ্,
   {{0x7c3c0af9,0x644e3fcd,0xb4c0009a,0x3eadbfce}},	//   _iarr, _inbi, ुदी_, flet_,
   {{0x80e18a49,0x7d09bfcf,0x290f81d3,0x6d460267}},	//   _নির্, fres, buga_, _krka,
   {{0x7c3c3fd0,0x7d099b7d,0x291d8035,0x08c6a2f0}},	//   _karr, gres, ctwa_, _абан,
   {{0x7c3c00ad,0x62843fd1,0x225fbfd2,0x6d4601a1}},	//   _jarr, _amio, _zouk_, _mrka,
   {{0x7c3c33fe,0xd7a99a3b,0xd25102e3,0x3ead8e1c}},	//   _marr, _चुपच, مند_, blet_,
   {{0x7c3c011e,0x7d09a09c,0x6d463fd3,0x9e669d85}},	//   _larr, bres, _orka, _швед,
   {{0x9553803d,0xa2d4064a,0x316d0333,0x518401ae}},	//   _نخوا, _बूस्, áez_, аура,
   {{0x58870048,0x26d301df,0x8cd60105,0x8c0800ab}},	//   тыма, _puxo_, _बढ़ो, র্তন_,
   {{0x54338c2a,0x26cb0207,0x443c8282,0xd25980eb}},	//   _ضرور, _pico_, _iav_, _ziņu_,
   {{0x443ebfd4,0x443cbdd7,0x3cfe000f,0x644e3fd5}},	//   ldt_, _hav_, _लिखे_, _anbi,
   {{0x80dd00c8,0x443c81c5,0x27f8209b,0x2129010b}},	// [2cd0] _বিক্, _kav_, barn_, _upah_,
   {{0x443ebfd6,0x7c3c360a,0x290f8578,0x443cbfd7}},	//   ndt_, _carr, vuga_, _jav_,
   {{0x7c3c3fd8,0x443c822c,0x3e71bfd9,0x225f807a}},	//   _darr, _mav_, _láta_, _pouk_,
   {{0x443cbfda,0x7c3c0ad0,0x6602bfdb,0x99848110}},	//   _lav_, _earr, _ndok, _namų_,
   {{0x7c3c3fdc,0x3eadbfdd,0xe8df80ff,0x443cbfde}},	//   _farr, vlet_, _trọn_, _oav_,
   {{0x443c8341,0x7c3c159d,0x290fbfdf,0x443e80f3}},	//   _nav_, _garr, ruga_, jdt_,
   {{0x28da0996,0x6d4600e1,0x290fbfe0,0x6e3d3fe1}},	//   _यूनि, _zrka, suga_, _kasb,
   {{0x443e80f3,0x3ebf8980,0x7e6d3fe2,0x224d8573}},	//   edt_, umut_, nkap, _unek_,
   {{0x3ebf9e03,0x6e3d3fe3,0x9a848b5b,0x3ead8eb9}},	//   rmut_, _masb, _турл, rlet_,
   {{0x443c8069,0x3eadbfe4,0x3e71bfe5,0x649d809f}},	//   _cav_, slet_, _dáta_, nèix,
   {{0x443c81c5,0x46158fc5,0x7e6d2450,0x27f83f88}},	//   _dav_, _موار, kkap, varn_,
   {{0x7d09bf55,0x3f7a8158,0x6e3d3fe6,0xe0c900be}},	//   pres, _אָדע, _nasb, _זײ_,
   {{0x32368158,0x81ac00ab,0x321e0035,0x443e8118}},	//   נטשן_, কেন_, ęty_, bdt_,
   {{0x40953fe7,0x443c93c2,0x81ea80ab,0xe81f001b}},	//   арст, _gav_, _মাছ_, म्ला_,
   {{0xd62a2481,0xdc9a807c,0x7c3c0041,0x61f9893d}},	//   нове_, _איסל, _rarr, kawl,
   {{0x7e6d26bc,0x7c3c3fe8,0x442780b9,0x6aa98088}},	//   gkap, _sarr, _hbn_, _nkef,
   {{0x26c03fe9,0x0c260dc0,0x443c81c5,0xa5072f4b}},	// [2ce0] rmio_, лман, _yav_, лета_,
   {{0x443c90af,0xf54f81bc,0x7c3c27cc,0x786f83ba}},	//   _xav_, _bụzi_, _qarr, _søvn,
   {{0xa3b903eb,0x7c3c3fea,0x9f4c8388,0x6e3d01a1}},	//   _चरण_, _varr, _pedí_, _fasb,
   {{0x2ca5bfeb,0x6d460904,0x998d809a,0xe3c580ab}},	//   hold_, _trka, _oceń_, _এভাব,
   {{0x7c3c3fec,0x64430073,0x442780cd,0x6abb81b4}},	//   _tarr, ônic, _obn_, _dhuf,
   {{0x61f6395c,0x4427bb15,0x3e7181a8,0x60d602c4}},	//   _leyl, _nbn_, _ráta_, _muym,
   {{0x6d443fed,0x9f580168,0x3ea4bfee,0x4acf8c28}},	//   lvia, darë_, tomt_, _संगव,
   {{0xa3b90076,0x7ae302b7,0x443cbfef,0x9b9300f7}},	//   _चरत_, ínte, _sav_, _الفت,
   {{0x5c74a657,0x443cbff0,0x6d44009f,0x6143bff1}},	//   илит, _pav_, nvia, _лета,
   {{0xd5c085e8,0x290b00d2,0x3ea48aa2,0x443c8282}},	//   शेषज, vrca_, somt_, _qav_,
   {{0x443ebff2,0x5fa40076,0x68e40110,0x7e6d076d}},	//   rdt_, _खुलल, _atid, ykap,
   {{0x201a0197,0x673a911b,0x66028f90,0xd7f88129}},	//   _acpi_, _istj, _udok, _xoăn_,
   {{0x443cbff3,0x6d4401ac,0x2ca5bff4,0x6c548073}},	//   _tav_, jvia, bold_, _вклу,
   {{0x443cbff5,0x6d3b8039,0x9f4780e1,0xb8fd3ff6}},	//   _uav_, _נתונ, vanú_, _तं_,
   {{0xb4c08e00,0xb4c286a7,0x68e406c0,0x99990019}},	//   ंगी_, ्दी_, _etid, reső_,
   {{0x58d50021,0xe80e8996,0x4ea70048,0x228b026b}},	//   _коит, _साझा_, урга, _dòkè_,
   {{0xb4db0722,0xb8049199,0x260a03db,0x6e3d342b}},	// [2cf0] _tràm, रणाम_, िलजी_, _vasb,
   {{0x7870016d,0x7e6d3ff7,0x673a82f1,0x6e3d1412}},	//   _jävl, skap, _ostj, _wasb,
   {{0x6e3d00ee,0xe7eb016f,0x649d809f,0xd4983ff8}},	//   _tasb, _ज्या_, rèix, урт_,
   {{0x39493ff9,0x6e3d008e,0xb4c2bffa,0x61f6011c}},	//   _kras_, _uasb, ्दु_, _xeyl,
   {{0x61f9ba65,0x673a8609,0xc5fa01c6,0xa3ab801b}},	//   rawl, _astj, _בפרט, _कुन_,
   {{0x216684ae,0x1bd40cb1,0x7d0d33a0,0xa3d401cf}},	//   риши_, _горя, mras, _горч,
   {{0x6fcc80d4,0x21de819d,0x2ca593c2,0x9f5803ed}},	//   ाशगं, _ịhe_, vold_, varë_,
   {{0x39492e91,0x0e658c9b,0x7e6285d8,0x2ca5bffb}},	//   _oras_, ркин, _coop, wold_,
   {{0x7ae48025,0xb4c2a701,0x7d0d2993,0x9f5800f1}},	//   _čita, ्दू_, nras, tarë_,
   {{0x3ea080d2,0x4b259957,0xac859bcc,0x4c85a481}},	//   čita_, амов, ргол, рлов,
   {{0x68e40052,0xeb999017,0x39493ffc,0x7d0d3ffd}},	//   _stid, тин_, _aras_, hras,
   {{0x80dd0a49,0xfaa62bd9,0x628b8428,0x39493ffe}},	//   _বিজ্, рамо, nigo, _bras_,
   {{0xe29719dd,0x9f583fff,0x201a03a8,0x61e90118}},	//   рая_, maré_, _pcpi_, ñela,
   {{0x7870016d,0xd4668b30,0x394930b8,0x628bc000}},	//   _gävl, _више_, _dras_, higo,
   {{0xb8fd1551,0xe7e50b9f,0x39492620,0x628b8545}},	//   _तू_, कड़ा_, _eras_, kigo,
   {{0x7e628609,0xddc9179d,0x63ae06e1,0x26cf84b9}},	//   _xoop, _šošt, _rybn, _jigo_,
   {{0x7d0d4001,0x291f81c0,0x39490f7c,0xac860cf9}},	// [2d00] gras, _nqua_, _gras_, агал,
   {{0xd12f00d5,0x26cfc002,0x0eb8016f,0x9f580144}},	//   _کمی_, _ligo_, _आठवड, haré_,
   {{0x2bab8592,0x2abc8e1b,0x7d0d1581,0xdddd0019}},	//   _घुमा, híbe_, aras, _első,
   {{0x9f4c826f,0x628baa96,0x6441808e,0x6da6004a}},	//   _nedá_, gigo, hdli, _вима,
   {{0x44e98510,0x7d0d1a2e,0x22402eac,0x290083a7}},	//   _nº_, cras, _maik_, éia_,
   {{0x20184003,0x26cf82f7,0x37069cf8,0x403495b7}},	//   ngri_, _aigo_, ачив, секс,
   {{0x628bc004,0x26cfc005,0x291f80e5,0x9f580580}},	//   bigo, _bigo_, _equa_, faré_,
   {{0xf2a38e8e,0x22400483,0x644182af,0x26cf882c}},	//   _дисп, _naik_, edli, _cigo_,
   {{0x26cfa6d5,0xd5b78987,0x61ed86a5,0xf8bf0866}},	//   _digo_, ись_, ñale, ltée_,
   {{0xb4c08063,0x8c668012,0xceea80e8,0xb4c28128}},	//   ंगे_, ртид, _адже_, ्दे_,
   {{0x22401a67,0x3e75016d,0x39468110,0x225209ca}},	//   _baik_, _låta_, lvos_, _bnyk_,
   {{0xc5f080c8,0xbd878416,0x394900d7,0x1bf283a4}},	//   _টাকা_, انین_, _pras_, _आजकल_,
   {{0x787000f2,0xcd36826a,0x224000b9,0x3946802a}},	//   _tävl, _خراب, _daik_, nvos_,
   {{0x83f89c79,0x533483c7,0x27fc83ba,0xe9df4006}},	//   _секс_, _гект, navn_, scú_,
   {{0x1cbb8158,0x44333075,0x06fd81d0,0x22404007}},	//   _שמוע, vex_, žívá_, _faik_,
   {{0x3949040e,0x27fc8edd,0xaa2d0198,0x2c190072}},	//   _tras_, havn_, ämää_, _पाहू_,
   {{0xddc40289,0x61ef00b9,0xdb1c0035,0x6d4002d4}},	// [2d10] tkiš, mbcl, _ogró, _šmar,
   {{0xe1ff0035,0xc3cb01a8,0x61fd208e,0xeaca0129}},	//   tków_, نظام_, lasl, _hẹp_,
   {{0x44334008,0x628b8e67,0x389c098a,0x1da72730}},	//   rex_, tigo, _ביזנ, _कुरत,
   {{0x7d0d4009,0xde590221,0xa3e68eed,0x7d028654}},	//   pras, _самі_, युत_, _ovos,
   {{0x394982ba,0x3ce6822c,0x26cf87e4,0x0dcb00a9}},	//   ías_, _ntov_, _rigo_, _јуни_,
   {{0x26cfc00a,0x628bc00b,0xb4c2801b,0xb4c091be}},	//   _sigo_, sigo, ्दो_, ंगो_,
   {{0xb4c283bb,0x61fd011e,0x261b816f,0x9f58400c}},	//   ्दै_, kasl, _यादी_, taré_,
   {{0xee39998c,0x201809d1,0x2f9801c6,0xb4db0706}},	//   уни_, zgri_, יכון_, _arài,
   {{0x26cf87f4,0x656d400d,0x88078c2b,0x6289c00e}},	//   _vigo_, nyah, _نظام, _imeo,
   {{0x7d02811f,0x6aad400f,0x3e7181ac,0x101781f9}},	//   _dvos, _akaf, _táto_, _خبرد,
   {{0x6441c010,0x69cb9c7b,0xa25b0187,0x9f584011}},	//   rdli, _तृती, rmôn, paré_,
   {{0xc869093f,0x2721ad11,0x6f154012,0x625a33e4}},	//   _אן_, món_, duzc, урор_,
   {{0x272188a4,0xa5098b9c,0x2c6980e1,0xeaca0129}},	//   lón_, _села_, _súdu_, _dẹp_,
   {{0x645cc013,0xb4db051e,0x656d0df6,0x37e301a1}},	//   örit, _grài, dyah, зорг,
   {{0x2721862f,0x628981e8,0x224000ee,0xb21b006a}},	//   nón_, _omeo, _taik_, dhæf,
   {{0x442a4014,0x61fd0279,0xaad006b7,0x27218118}},	//   _sbb_, casl, _सूचक, ión_,
   {{0x442a0886,0x61e42c9a,0xed574015,0x2721c016}},	// [2d20] _pbb_, _ifil, бот_, hón_,
   {{0x98a90110,0x6289aef4,0xa3ab8853,0xe09e8135}},	//   _ypač_, _ameo, कअप_, kọọ_,
   {{0x29024017,0x2721c018,0xf8bf0036,0x656d2676}},	//   lska_, jón_, utée_, ayah,
   {{0x27218c58,0x786b0085,0xd9fa03eb,0xf1fa8124}},	//   dón_, _qüvv, ्णित_, اعات_,
   {{0x19588fe6,0x186a8bc7,0xceb40085,0x656d00b4}},	//   ралы_, лади_, mlə_, cyah,
   {{0xfce34019,0x2721bfe5,0x76440085,0x29020079}},	//   _хоро, fón_, ldiy, iska_,
   {{0x6d4bc01a,0x3946c01b,0x272182ba,0x4444401c}},	//   _arga, svos_, gón_, md_,
   {{0x22968013,0x3ea0803b,0x7644401d,0x329681a8}},	//   _الرس, čito_, ndiy, _الرأ,
   {{0x75243724,0x2d80401e,0x444419c2,0x26da401f}},	//   ntiz, nzie_, od_, _lupo_,
   {{0xd6d28872,0xb865af0a,0x290202a5,0x2721c020}},	//   _فقط_, _والو, dska_, bón_,
   {{0x6d4bc021,0x27218d76,0xceb40085,0xae209a3b}},	//   _erga, cón_, klə_, _यापन_,
   {{0x6d4481e2,0x44444022,0x9c8701d0,0x6d898019}},	//   _šiau, hd_, _kočá, امیہ_,
   {{0x0c738077,0x61e4002a,0xd0418085,0x76444023}},	//   زدید, _dfil, _ailə, ddiy,
   {{0x2d800d38,0x69d60117,0xd0418086,0x44440613}},	//   dzie_, _egye, _bilə, jd_,
   {{0x44442065,0x1bfb8051,0x93fb810f,0xaae68bbe}},	//   dd_, _גלוב, _גלוי, _استو,
   {{0x44444024,0x5f94138c,0x656d056a,0xa19514ed}},	//   ed_, чист, tyah, _майч,
   {{0x2721840e,0x9f47826f,0x44440a0f,0x2d58245b}},	// [2d30] zón_, daný_, fd_, бить_,
   {{0x44444025,0x80dc809a,0x656d0079,0xd37b0f13}},	//   gd_, _पढ़े, ryah, лче_,
   {{0x272181df,0x45d51775,0xb5fd807a,0x57fa01c6}},	//   xón_, _монс, ljše, _דלתו,
   {{0x44444026,0x7ae480ce,0x656d16fb,0x61e281f6}},	//   ad_, _čitl, pyah, gcol,
   {{0xae1a0158,0xd5a689a7,0x444402f7,0xb5fd82d4}},	//   _דורכ, _آف_, bd_, njše,
   {{0x2721988b,0xd7fb8037,0x26da004f,0x628f0493}},	//   tón_, ууд_, _yupo_, hico,
   {{0x64554027,0x320901b4,0x628f34d3,0x7e7b8234}},	//   _inzi, _oday_, kico, thup,
   {{0x272188a9,0x29020079,0x644502a3,0x628f0503}},	//   rón_, yska_, ldhi, jico,
   {{0x6499840d,0x2721988b,0xb5fb4028,0xec79964f}},	//   итор_, són_, _bláz, ипи_,
   {{0x64454029,0x27218511,0x61fbc02a,0x61e4063f}},	//   ndhi, pón_, _heul, _sfil,
   {{0xe82009a3,0x628f1313,0x76440201,0x68f60355}},	//   _बाबा_, fico, ydiy, _swyd,
   {{0x2902012b,0xd5759a8f,0x60db9e08,0x628f402b}},	//   tska_, _муль, _kuum, gico,
   {{0x444402a3,0x787004a2,0xddc2c02c,0x26da0216}},	//   yd_, _hävi, _zlož, _supo_,
   {{0x60dbc02d,0x26da04be,0x38b6006a,0x78700198}},	//   _muum, _pupo_, mærk_, _kävi,
   {{0x61e29c33,0xceb40085,0x6d49c02e,0x4444004a}},	//   ycol, tlə_, lvea, vd_,
   {{0x6455402f,0x75244030,0xee3a09a5,0x61fbc031}},	//   _anzi, ttiz, јна_, _neul,
   {{0x6443c032,0x9f478a56,0xa3c383b7,0x76440201}},	// [2d40] _kani, vaný_, ्शक_, rdiy,
   {{0x3e78c033,0x6299867f,0xa3bd8424,0x44443ce8}},	//   _méta_, enwo, _आरा_, ud_,
   {{0x673e030b,0x75244034,0x61fb851e,0x213f8c68}},	//   _uspj, stiz, _beul, _asuh_,
   {{0x44444035,0x75241c8c,0x64554036,0x6443c037}},	//   sd_, ptiz, _enzi, _lani,
   {{0x81ac00c8,0x61e2c038,0x394dc039,0x61ed85a4}},	//   কের_, rcol, _cres_, ñala,
   {{0x644391df,0x61e2c03a,0xb902aa85,0xd90d803d}},	//   _nani, scol, _नं_, ایل_,
   {{0x394d9726,0x25e10076,0xe3a7819f,0xdfcf80f7}},	//   _eres_, _कलमी_, _آر_, نيه_,
   {{0xddc29807,0x628f403b,0x61fbc03c,0x39400f29}},	//   _vlož, xico, _geul, _osis_,
   {{0x7d04403d,0x64438af5,0x261b8054,0xd90d8fd3}},	//   nsis, _bani, _यारी_, _مین_,
   {{0x6443c03e,0x7d04403f,0x2246c040,0xe46a891c}},	//   _cani, isis, ldok_, ршил_,
   {{0xddc287df,0x628f0888,0x39400084,0x9f5c84e8}},	//   _ulož, tico, _asis_, kavé_,
   {{0x7d044041,0xd3778110,0x0dca8e17,0xdb214042}},	//   ksis, ючы_, _кули_, étét,
   {{0x628f4043,0x21268867,0x66008d92,0x394d1e09}},	//   rico, ntoh_, mamk, íes_,
   {{0x628f25a7,0x6443c044,0x66008079,0xfbcf82e3}},	//   sico, _gani, lamk, عتی_,
   {{0x368b2748,0x628f1820,0x81ac00ab,0x44e0c045}},	//   асан_, pico, কেল_, _hò_,
   {{0x44e0c046,0xcb138bea,0x7c2e4047,0x66008010}},	//   _kò_, _חלק_, _abbr, namk,
   {{0xd90489d7,0x7d0402b8,0x95cb0323,0x628d0b80}},	// [2d50] _جی_, gsis, рува_, _imao,
   {{0x44e0c048,0x61fb82be,0x60dba1e8,0x660095e8}},	//   _mò_, _seul, _ruum, hamk,
   {{0x44e0c048,0x68e993e1,0x3e7180f7,0x64454049}},	//   _lò_, _sted, _fáth_, rdhi,
   {{0x9f45803e,0x660089ca,0x7c2e0ab3,0xb4db051e}},	//   _celý_, jamk, _ebbr, _bràt,
   {{0x2a69404a,0x61fba5d2,0x44e083ec,0x6600c04b}},	//   _moab_, _veul, _nò_, damk,
   {{0xbca500f7,0x68e980e1,0x38b6006a,0x3e7c01d0}},	//   _رمزي, _vted, værk_, _víte_,
   {{0xf7718bbe,0x644382a5,0x2cac831d,0x61fbc04c}},	//   عات_, _rani, dodd_, _teul,
   {{0x394da84c,0x44e0c04d,0xe1ff8125,0x2919404e}},	//   _tres_, _bò_, _þó_, kusa_,
   {{0x6443c04f,0x44e0c050,0x7982809a,0x2cac831d}},	//   _pani, _cò_, czow, fodd_,
   {{0x44e090ab,0x629d087a,0x628d0133,0xc48283c7}},	//   _dò_, éron, _amao, ельк,
   {{0xf1a90159,0x3e718324,0x22920110,0xa3ab9513}},	//   _עס_, _láti_, eška_, _कुश_,
   {{0x644395bd,0xe29a108d,0x44e0c051,0x394002f7}},	//   _wani, сам_, _fò_, _psis_,
   {{0x44e09b4c,0x2eaa8117,0x6443c052,0xbbb8000d}},	//   _gò_, _اپنی_, _tani, _अर्क,
   {{0xf09f3c3f,0x26c20168,0xb87b00e1,0x15429092}},	//   dràs_, _shko_, dpís, _чешм,
   {{0x1fb523d7,0x38ca0019,0xeb96911c,0x9f5c936f}},	//   дстр, لاڑی_, _ниш_, tavé_,
   {{0x3940146a,0x29194053,0x3e6e007b,0x7d044054}},	//   _tsis_, busa_, _nýtt_, tsis,
   {{0x29193340,0x9f5c816b,0xed574055,0x44e080e5}},	// [2d60] cusa_, ravé_, пот_, _xò_,
   {{0x7d044056,0x3d13a743,0xf5070e49,0x99dd80e1}},	//   rsis, _दिने_, янул_, _raňa,
   {{0x9f45c057,0x2baf06a7,0xb4db026b,0x7ae48140}},	//   _meló_, _जुदा, _bràs, _čitk,
   {{0x81ac00ab,0xfaa385a8,0xf8bf4058,0x3202016b}},	//   কেঃ_, нахо, ntén_, naky_,
   {{0x2fda00b9,0x6d4f00c3,0x9f58023e,0xb4db01e4}},	//   _kgpg_, _grca, larà_, _dràs,
   {{0x44e08324,0x38b6007b,0x79828035,0x55bb01c6}},	//   _rò_, færi_, rzow, _למכו,
   {{0x44e0c059,0xa3ab80a5,0x9f580722,0x76462f76}},	//   _sò_, _कुल_, narà_, _kaky,
   {{0x44e0c05a,0x443a405b,0x3202016b,0x7e6402f7}},	//   _pò_, lep_, jaky_, njip,
   {{0x2919036a,0xa3c9800c,0x7646405c,0x1dbe0743}},	//   xusa_, लेस_, _maky, ्धित,
   {{0x628d0ad0,0x443a2190,0xa3e6864a,0x2292007a}},	//   _smao, nep_, युं_, vška_,
   {{0x59a51055,0xd25102e3,0x44e0877f,0x200c8114}},	//   _गुजर, نند_, _wò_, _iddi_,
   {{0x44e090ab,0x443a405d,0x9f580722,0x76460c2e}},	//   _tò_, hep_, darà_, _naky,
   {{0x443a37c0,0x442ec05e,0xc05b00e8,0x41c70035}},	//   kep_, _tbf_, бів_, रेंस,
   {{0x2919405f,0x443a02ce,0xdd3b8039,0x764600e4}},	//   rusa_, jep_, _לעדכ, _aaky,
   {{0xb5fd84c4,0x64588ca9,0x3ae18028,0x6d4f00d2}},	//   ljša, _invi, _góp_, _srca,
   {{0xfbb78051,0x81ac00ab,0x29192fdb,0x26de8f8e}},	//   _מפות_, কেই_, pusa_, _muto_,
   {{0x2d580364,0x26dec060,0xb5fd807a,0x76463a20}},	// [2d70] пить_, _luto_, njša, _daky,
   {{0x443a003d,0x6448c061,0x9f580722,0xf09f023e}},	//   gep_, nddi, barà_, rràs_,
   {{0x20034062,0x9f580722,0x64488114,0x61ed8333}},	//   maji_, carà_, iddi, ñalo,
   {{0x2ea8035a,0x6d4f02a5,0x63b5026f,0x7c3ac063}},	//   ककृत, _trca, _vyzn, hetr,
   {{0xa06994bc,0x9f581984,0x7c3a81a3,0x6d4f0162}},	//   жала_, mará_, ketr, _urca,
   {{0x26dec064,0x9f58018a,0x443a4065,0x20034066}},	//   _buto_, lará_, cep_, naji_,
   {{0x60df036e,0x6d42802a,0xa6c98572,0x442300ee}},	//   _luqm, _asoa, олка_, _icj_,
   {{0x9f581f5c,0x6447054e,0x20034067,0x442c81ed}},	//   nará_, _haji, haji_, efd_,
   {{0x64471600,0x6d4d18c7,0x20034068,0x61e9846d}},	//   _kaji, nvaa, kaji_, _ifel,
   {{0x7c3ab66b,0x20034069,0x6447406a,0xd90d8019}},	//   getr, jaji_, _jaji, _میچ_,
   {{0x6447406b,0x29090364,0xe8171c3b,0x68ed406c}},	//   _maji, _avaa_, _ताजा_, _atad,
   {{0x6458c06d,0x6447406e,0xdd8e826a,0x9f58406f}},	//   _envi, _laji, اوی_, jará_,
   {{0xda1f1499,0x76460455,0xe8f70554,0x9f582a63}},	//   _भारत_, _raky, мля_, dará_,
   {{0x64470c9e,0xf8bf02b7,0x9f580722,0x20034070}},	//   _naji, stén_, tarà_, gaji_,
   {{0x4aad8076,0x68ed4071,0xa3c9858c,0x7529b905}},	//   टकाव, _etad, लेश_, ltez,
   {{0x9f580a3e,0x44230176,0x7649c072,0xe8204073}},	//   gará_, _acj_, ndey, _बावा_,
   {{0x443a37c0,0x20034074,0x7529b349,0xdb0e001b}},	// [2d80] tep_, baji_, ntez, _vybí,
   {{0x69dbc075,0x7e7d0362,0xfbd2030f,0x9f58023e}},	//   _ague, _elsp, نتا_, parà_,
   {{0x443a4076,0x76464077,0xaec60ff0,0x9f581984}},	//   rep_, _taky, _обол, bará_,
   {{0x9f580acf,0x443a292a,0xe297a434,0x99dd826f}},	//   cará_, sep_, мах_, _daňo,
   {{0x6448a065,0xd1308416,0x66043842,0x7649c078}},	//   yddi, امت_, maik, ddey,
   {{0x66044079,0x2906862f,0xd6ea8ae7,0x64471cc5}},	//   laik, rsoa_, офил_, _gaji,
   {{0x29068073,0x7bdc407a,0xdfd081a8,0x7c3ac07b}},	//   ssoa_, _igru, ديث_, vetr,
   {{0x2003022e,0x660416d5,0x667b00be,0xc9568364}},	//   zaji_, naik, ַװיג, _отзы,
   {{0x9f5e80f1,0x6447407c,0x6f1c3aaa,0x2d848289}},	//   _ketë_, _yaji, hurc, uzme_,
   {{0x9f5e820f,0x9f58407d,0x3e78800d,0x26de801b}},	//   _jetë_, zará_, _této_, _tuto_,
   {{0xd62a9289,0x66042bc6,0x6448c07e,0xa3c98072}},	//   _може_, kaik, rddi, लेल_,
   {{0x6f1c02af,0x7d1bc07f,0x6282aeee,0x2003004f}},	//   durc, buus, nhoo, waji_,
   {{0x941e023c,0x7c3ac080,0x2003022e,0x9f582a63}},	//   _पांच_, petr, taji_, vará_,
   {{0xddcd10d3,0xc05801b5,0x656f81ec,0x7bdc003d}},	//   jkaš, міс_, äche, _ngru,
   {{0x9f581313,0x64474081,0x26c6c082,0xe8202a85}},	//   tará_, _raji, _khoo_, _बारा_,
   {{0x4ea418a0,0x7bdc2e88,0x64471eb3,0x66044083}},	//   вруа, _agru, _saji, gaik,
   {{0x9f581fd1,0xdd9401bb,0xa5bb0118,0x64470168}},	// [2d90] rará_, ваты, _ecón, _paji,
   {{0x31560051,0xf5488135,0x6d4d3768,0x9f582a63}},	//   _ניתן_, _mụ_, rvaa, sará_,
   {{0x66040867,0x9f5826d5,0xf8bf0073,0xa5bb00f7}},	//   baik, pará_, ntém_, _gcón,
   {{0xb4ca84e5,0xfd5e80ff,0x387e8037,0x6d4d090d}},	//   लगु_, _quyể, _altr_, pvaa,
   {{0x224901d8,0xc6160051,0x50b581bb,0x801807d2}},	//   _maak_, _אחרי_, нску, _عزیز_,
   {{0x26d94084,0x7d1b862c,0x2b430980,0x9f5e826b}},	//   _hiso_, vuus, _tsjc_, _ketè_,
   {{0xfd5e8028,0x7afc0114,0x38b603ba,0x9f5c84e8}},	//   _tuyể, _gwrt, mært_, baví_,
   {{0x26c6c085,0xf548b5b0,0x06098d5f,0x7d1b82ec}},	//   _choo_, _bụ_, чник_, tuus,
   {{0xf5488028,0xdc3a8201,0x2a7f8420,0x0c95add0}},	//   _cụ_, _açıq, _ilub_, ешня,
   {{0x7529c086,0x2a7f81e9,0x6ac800d4,0x291dc087}},	//   rtez, _hlub_, रग्र, muwa_,
   {{0x44211523,0x7d1b9572,0xa3c98740,0xe8d68039}},	//   igh_, suus, लें_, _נוער_,
   {{0xbbdc000f,0x26d90353,0x395201b0,0x25a0811a}},	//   _बल्क, _niso_, _prys_, _žile_,
   {{0xf548aae3,0xaca381bc,0x66040d15,0xb5fd81a1}},	//   _gụ_, _azụk, vaik, ljšo,
   {{0x660401bc,0xd11c1344,0x2a6dc088,0xf1b9816b}},	//   waik, भूषण_, _loeb_, _myš_,
   {{0xc7b2893f,0x6ab630bc,0x7d098bc5,0x2baf00a5}},	//   ָבן_, _псих, lses, _जुला,
   {{0x291da0d4,0x9f5c1c86,0x68339010,0x7bc38024}},	//   kuwa_, _því_, lıdı, _iznu,
   {{0x26d94089,0x6604408a,0xafe60391,0xf8af8beb}},	// [2da0] _diso_, raik, _попл, टवाय,
   {{0x6604408b,0x6457a6d5,0x7d098009,0x224900f3}},	//   saik, _óxid, ises, _zaak_,
   {{0xddcd0067,0x9f5ec08c,0x6604408d,0x3ce506a7}},	//   rkaš, _vetë_, paik, _झूठे_,
   {{0x09e6b38c,0x7d09c08e,0x2366003a,0x442101e4}},	//   ходн, kses, ćoj_, agh_,
   {{0x6282ba61,0x941e0076,0xaca40135,0x9f5c83fb}},	//   rhoo, _पाऊच_, _abụr, raví_,
   {{0x6d46408f,0x3b0a14b7,0x6282c090,0xe3b10117}},	//   _iska, _него_, shoo, ارے_,
   {{0x64a32028,0x645c4091,0x3ea00168,0x26c681c0}},	//   _сара, _inri, onit_, _phoo_,
   {{0x3ea01af3,0x291d84b9,0xfd55019d,0x9405811c}},	//   nnit_, buwa_, _nkaọ, milə_,
   {{0x6280825d,0x2249079f,0x3ea0372f,0xdd90803d}},	//   _ilmo, _raak_, init_, شود_,
   {{0xf5488104,0x224901b0,0xfd550133,0x6386c092}},	//   _vụ_, _saak_, _akaọ, _néné,
   {{0x69c40698,0x7ae92828,0xa5bb0118,0xfd4981bc}},	//   _azie, _četk, _acól, _kalị,
   {{0x6d464093,0x09d480c8,0x7d0982f7,0xf54880ff}},	//   _oska, _হ্যা, bses, _tụ_,
   {{0x22490a0f,0xf8bf027f,0x638682be,0x26d93d36}},	//   _vaak_, stém_, _béné, _riso_,
   {{0x69c44094,0x3ea0825b,0x638689c4,0xf1c70035}},	//   _dzie, čitu_, _céné, रेगन,
   {{0x443e83ed,0x6d464095,0x26d926de,0x60da83e3}},	//   met_, _aska, _piso_, _mitm,
   {{0x644ac096,0x2001010c,0x291d80a4,0x62670b8c}},	//   _hafi, _wehi_, yuwa_, _سابق,
   {{0x644ac097,0x26d90611,0x7c3e01f4,0xdb0e026f}},	// [2db0] _kafi, _viso_, fepr, _rybá,
   {{0x638683d3,0x44210051,0x7d1d8722,0x64848014}},	//   _géné, ugh_, àssi, _dòig,
   {{0x6d4600ad,0x7f4500f1,0xa3c2b852,0x41ee819d}},	//   _eska, _ushq, ्धि_, _ịsị_,
   {{0x443ec098,0xa3cd0b6f,0x644a80a4,0x291dc099}},	//   het_, शेष_, _lafi, tuwa_,
   {{0x443ec09a,0x765d07d5,0xfe79800d,0xd9458abe}},	//   ket_, _insy, vků_, тели,
   {{0x443ec09b,0x22498025,0xa3c28894,0x291dc09c}},	//   jet_, žak_, ्धा_, ruwa_,
   {{0x443e920b,0xb4bd0b9f,0x752d0211,0x291dc087}},	//   det_, आती_, ltaz, suwa_,
   {{0x764d409d,0x81ac00ab,0x644a846d,0x7d098074}},	//   nday, কেট_, _aafi, tses,
   {{0x752d2579,0x443ec09e,0x644ac09f,0x290b009a}},	//   ntaz, fet_, _bafi, jsca_,
   {{0x443e8a33,0x60da8214,0x6ab62a33,0xf9908199}},	//   get_, _gitm, _skyf, _طبق_,
   {{0x2007c0a0,0x5f798077,0x8c3c87d9,0x03a5818b}},	//   mani_, _تماس_, toğr, тино,
   {{0x20079fb6,0x752d0695,0x7c3e009a,0x7d09c0a1}},	//   lani_, ktaz, zepr, pses,
   {{0x443ec0a2,0x764d0ec8,0x644ac0a3,0xb4db026b}},	//   bet_, dday, _fafi, _asàm,
   {{0x2007c0a4,0x764b8065,0x7e6985f3,0x62888110}},	//   nani_, _hagy, ljep, _įdom,
   {{0x764bc0a5,0x66e604ae,0x290b1947,0xe7271290}},	//   _kagy, тоба, asca_, корд_,
   {{0x644ab6ba,0x764d179b,0x7e7b8168,0x7e69beb6}},	//   _zafi, gday, nkup, njep,
   {{0x764b8117,0x2007c0a6,0x7c3e40a7,0x3ea040a8}},	// [2dc0] _magy, kani_, tepr, rnit_,
   {{0x7ae3c0a9,0x644a8079,0x3ea040aa,0x711b00be}},	//   _kunt, _xafi, snit_, _קויפ,
   {{0x290d8012,0x7ae3c0ab,0x7c3e3665,0x68e4038e}},	//   _avea_, _junt, repr, _huid,
   {{0x764b8117,0x7ae3c0ac,0x443ec0ad,0x68e40006}},	//   _nagy, _munt, zet_, _kuid,
   {{0x443ec0ae,0x2007c0af,0x94058085,0x6d463e74}},	//   yet_, fani_, silə_, _uska,
   {{0x443e40b0,0x68e4043d,0xf1a9803d,0x6602c0b1}},	//   _út_, _muid, رانه_, _seok,
   {{0x443e8370,0x644a8c9e,0x7ae3c0b2,0x764bad80}},	//   vet_, _rafi, _nunt, _bagy,
   {{0x6e2440b3,0x443ec0b4,0xf8bf0019,0x7e7babb9}},	//   ngib, wet_, tték_, gkup,
   {{0x7ae9003b,0x443e8e79,0x20079fe5,0x48e6835f}},	//   _četi, tet_, bani_, _розв,
   {{0x7ae3c0b5,0x60da8cfa,0xa3d7047d,0x443ec0b6}},	//   _bunt, _uitm, ाखच_, uet_,
   {{0x443ec0b7,0x8c1b0158,0x7ae39b96,0x8fa38bc7}},	//   ret_, וויי, _cunt, _кафе,
   {{0x443ebe74,0x68e40014,0x92580009,0x644aa647}},	//   set_, _buid, вают_, _wafi,
   {{0x68e410eb,0x443e85a0,0x644a80a4,0x61ed8511}},	//   _cuid, pet_, _tafi, ñali,
   {{0xa8a440b8,0x1c1e0592,0xcb548b76,0x443e820f}},	//   арск, _पागल_, _منتظ, qet_,
   {{0xd6db130f,0x764d40b9,0x290b01a1,0x6b8d8326}},	//   дта_, tday, ssca_, _ƙage,
   {{0x34db035a,0x752d40ba,0x0bb78039,0x6e2423ff}},	//   बद्द, ttaz, _שלהם_, ggib,
   {{0x2007c0bb,0x68e4114e,0x51870d8e,0xb6040249}},	// [2dd0] yani_, _guid, _шука, ряск,
   {{0x752d40bc,0x1acb8eed,0x041480c8,0x63bc40bd}},	//   rtaz, िष्ठ, ত্রী_, _byrn,
   {{0x2007c0be,0x7ae387f4,0x752d40bf,0x68e400f3}},	//   vani_, _xunt, staz, _zuid,
   {{0x2007c0c0,0xf67900be,0x3d13816f,0x657200f1}},	//   wani_, _נאָמ, _दिले_, ëdhë,
   {{0x2007c0c1,0x7640c0c2,0x66ea8035,0x9564047f}},	//   tani_, demy, _ręka, _кърд,
   {{0xfaf30277,0xb4ac801b,0x7d0d40c3,0x66d58084}},	//   _نثر_, कको_, msas, _iški,
   {{0x2007c0c4,0x61e49601,0x3e750687,0x442797e9}},	//   rani_, žila, _fått_, _rcn_,
   {{0x7ae3c0c5,0x3e750448,0xdd918065,0xdb258019}},	//   _runt, _gått_, یوں_, épít,
   {{0x7ae3c0c6,0x764bc0c7,0x7e7b9abf,0x78b50503}},	//   _sunt, _vagy, rkup, kozv,
   {{0x68e421fd,0x3a2900dd,0x1abe020e,0x764b85ee}},	//   _ruid, _acap_, ोष्ठ, _wagy,
   {{0x394940c8,0x68e440c9,0xb0b680be,0xe29a1b23}},	//   _asas_, _suid, _עפעס_, еан_,
   {{0x68e42cc5,0x2005b241,0xad9b04f0,0x7d0d40ca}},	//   _puid, _heli_, _reún, ksas,
   {{0x2005c0cb,0x78b501a1,0x64848362,0xc871826b}},	//   _keli_, fozv, _dòib, _ko̟_,
   {{0x7ae3c0cc,0x3ebf8364,0x2005811f,0x628600f1}},	//   _tunt, llut_, _jeli_, shko,
   {{0x394940cd,0xe29a1927,0xa3c98778,0x2005af8c}},	//   _esas_, _пак_, लेख_, _meli_,
   {{0x6441c0ce,0x224d8b99,0x44e990ab,0x20058234}},	//   leli, _naek_, _kú_, _leli_,
   {{0x44e9c0cf,0xa3e7a701,0x7d0d02b8,0x6284400e}},	// [2de0] _jú_, _भला_, gsas, _ilio,
   {{0x6441c0d0,0x44e9877f,0x629d026f,0x7640809a}},	//   neli, _mú_, érov, zemy,
   {{0x44e99ca9,0x224d90e4,0x25ab40d1,0x6609a43c}},	//   _lú_, _baek_, _excl_, kaek,
   {{0xa3ab9499,0x64418a92,0x200a3368,0x60de008e}},	//   _कुछ_, heli, labi_, _hipm,
   {{0x44e9c0d2,0x2005c0d3,0xd378809a,0x7d0d40d4}},	//   _nú_, _beli_, zyć_, csas,
   {{0x7ae9003b,0x6441c0d5,0x200a2fc2,0xf8b40b9f}},	//   _četv, jeli, nabi_, ंकिय,
   {{0x64418de8,0xd6da86a1,0x2005c0d6,0x09b580ab}},	//   deli, нти_, _deli_, জেলা,
   {{0x44e9c0d7,0x644e05d8,0x26dd8300,0x26c000e5}},	//   _bú_, _habi, _ciwo_, nlio_,
   {{0x66061f58,0x6441c0d8,0xd49ac0d9,0x7640a1ce}},	//   _mekk, feli, ерн_, remy,
   {{0x6441c0da,0x660640db,0x27f7800d,0x62840010}},	//   geli, _lekk, čení_, _alio,
   {{0x644e40dc,0xd7ef80f7,0x44380706,0x2a60008e}},	//   _mabi, _ركن_, _mbr_, _bnib_,
   {{0x644e1fc6,0x20058052,0x6284051e,0x66062ffb}},	//   _labi, _zeli_, _clio, _nekk,
   {{0x44e99e4e,0xa3d606b7,0x443840dd,0x9f5e8216}},	//   _gú_, ाइड_, _obr_, _metí_,
   {{0xac18835f,0x6441a2f8,0x200a0040,0x224d1cf3}},	//   _року_, celi, gabi_, žek_,
   {{0x447b8158,0x660640de,0x1ee7003d,0xe80c897d}},	//   _אנגע, _bekk, اوری_, _सजना_,
   {{0x26c00021,0x44382eaa,0x3a290890,0x62841581}},	//   glio_, _abr_, _ucap_, _glio,
   {{0x644e2f14,0xe21400a0,0x660640df,0x44380366}},	// [2df0] _babi, _طبيع, _dekk, _bbr_,
   {{0x7d0d40e0,0x888300d7,0x229202d4,0x320b066f}},	//   rsas, _ایسن, vški_, lacy_,
   {{0x644e40e1,0xaca48135,0x62840009,0x20059c40}},	//   _dabi, _azịz, _ylio, _reli_,
   {{0x6441c0e2,0x66061c11,0x62359c3a,0x44380428}},	//   zeli, _gekk, реду, _ebr_,
   {{0x9f5e80e1,0x44258114,0x2005c0e3,0x6441c0e4}},	//   _detí_, ygl_, _peli_, yeli,
   {{0x44e990ab,0x8f15808f,0x44250aa2,0x7e6d0074}},	//   _rú_, афич, _øl_, ljap,
   {{0x44e9c0e5,0x200585f3,0xb5fd807a,0x7d029c00}},	//   _sú_, _veli_, ljši, _awos,
   {{0x6441b986,0x7f3c00be,0x20058079,0x225f8503}},	//   weli, געהו, _weli_, _unuk_,
   {{0xc4858251,0x644e1ea2,0x6f04811f,0x26c380eb}},	//   илик, _yabi, ćica, ējo_,
   {{0x99848013,0x7ae700f1,0x3ebf80f2,0x7d1ba03b}},	//   _الكو, _kujt, slut_, rrus,
   {{0xda661264,0x626600af,0x26c00114,0x200a40e6}},	//   авни, авна, ylio_, vabi_,
   {{0x44e9c0e7,0xe29a1052,0xc5d5835f,0x6723b6c8}},	//   _tú_, там_, _кіль, munj,
   {{0x27318104,0x64418436,0x67238359,0x200a3722}},	//   _hơn_, peli, lunj, tabi_,
   {{0xe3b0803d,0x6d59a668,0x660640e8,0x8d748f24}},	//   _کره_, _irwa, _sekk, _داما,
   {{0x67238867,0x200a40e9,0xb4c383dd,0xb4c1b4ec}},	//   nunj, rabi_, ्षी_, ंती_,
   {{0x644e40ea,0x6284022e,0x200a40eb,0x7ebe80f1}},	//   _sabi, _ulio, sabi_, tëpi,
   {{0x644e15d0,0xb2bb0039,0x61e440ec,0xf5e729c9}},	// [2e00] _pabi, _במקר, _igil, рмул_,
   {{0x26c00025,0x644e381f,0x4463035f,0x6723912e}},	//   slio_, _qabi, овув, kunj,
   {{0x26c006a5,0x66060074,0x644e007a,0xf1bf2294}},	//   plio_, _tekk, _vabi, ngán_,
   {{0x53368158,0xb4c181fe,0x67238699,0x6d59a525}},	//   ינען_, ंतु_, dunj, _orwa,
   {{0x644e40ed,0x656f81ec,0xe046824f,0xa06a8eef}},	//   _tabi, ächl, инди, када_,
   {{0xfb26003d,0x442a01e0,0x4438026c,0x764f023b}},	//   _پرسپ, _ucb_, _ubr_, _zacy,
   {{0x6d4bc0ee,0x6d59c0ef,0x3cec0540,0x61e40106}},	//   _asga, _arwa, _अंडे_, _ogil,
   {{0x2baf08fd,0x66c58125,0x61e424ff,0x7d0286c0}},	//   _जुटा, sókn, _ngil, _pwos,
   {{0x320b40f0,0xe7fb0ebf,0x444403e4,0x657b82c4}},	//   vacy_, ्रमा_, oe_, gyuh,
   {{0x37b28264,0x7ae09867,0x22920196,0x00000000}},	//   টেগর, _himt, išku_, --,
   {{0x94738307,0x444440f1,0x6d5982af,0xe82040f2}},	//   تديا, ie_, _erwa, _बाजा_,
   {{0x44441941,0x1eda80f7,0x48fd800d,0x7d028a03}},	//   he_, _شباب_, रीको_, _twos,
   {{0x64a69a80,0xe29801e2,0x673e0580,0x81e88264}},	//   _када, раў_, _appj, _মজা_,
   {{0x653b83c8,0x61e440f3,0x69c09d94,0x27248133}},	//   _סעוד, _egil, _myme, _ịnye_,
   {{0x7e629254,0xa3b7826a,0x9e070f27,0xddc60035}},	//   _knop, _پاور_, ичал, _nakł,
   {{0x444440f4,0x9f5e8081,0x962100d4,0x33db81c6}},	//   ee_, _metà_, यलेट_, _בחוד,
   {{0x629d40f5,0x7524002a,0x44443f47,0x7e6d2079}},	// [2e10] miso, guiz, fe_, rjap,
   {{0xfd4d0104,0x91bc0039,0x629d40f6,0x6abb8aa2}},	//   _khoả, _במחי, liso, _skuf,
   {{0x7ae0808e,0x69c0c0f7,0xf36740f8,0x7e62c0f9}},	//   _bimt, _ayme, штан, _onop,
   {{0x444440fa,0x4b378051,0x6723a813,0x69c0867f}},	//   ae_, שראל_, vunj, _byme,
   {{0x444440fb,0x660d02d8,0x2731801c,0x463a00be}},	//   be_, maak, _sơn_, _גערע,
   {{0x67238590,0x660d40fc,0x6c8500f7,0x6d9e0609}},	//   tunj, laak, _السم, _dħaħ,
   {{0x629d40fd,0xf8bf255e,0x6445004f,0x3f8184e8}},	//   kiso, ltés_, mehi, áhu_,
   {{0x9aa58077,0x7ebe80f1,0x64453d46,0x660d40fe}},	//   _امرو, këpu, lehi, naak,
   {{0xf8bf255e,0x3e788125,0xddc6009a,0x1fd410c8}},	//   ntés_, _rétt_, _zakł, _दण्ड,
   {{0x4c8598a2,0xd8748013,0xb4c38d14,0xcc89803d}},	//   слов, _والب, ्षे_, انده_,
   {{0x3a2d011b,0x5f79987e,0x09e61bc1,0xdb1c00e7}},	//   мep_, _حماس_, йонн, _pyré,
   {{0x44441e98,0x68e1c0ff,0x629d1fca,0x6d59809a}},	//   ze_, _hild, giso, _trwa,
   {{0x44444100,0x6d5980b4,0x68e184d6,0x6e2994f9}},	//   ye_, _urwa, _kild, mgeb,
   {{0x44443a3b,0x037989a7,0x68e18bce,0x6e29a0b5}},	//   xe_, _محبت_, _jild, lgeb,
   {{0x177911d2,0x629d1f34,0x44fb802a,0x03a28037}},	//   асть_, biso, _hª_, _нишо,
   {{0x07a31ae5,0x75244101,0x6e3b0144,0x6e29b2c7}},	//   часн, tuiz, _ñubl, ngeb,
   {{0x6ab98362,0x7ae08084,0x0dca0b69,0x64848229}},	// [2e20] dowf, _rimt, улай_, _mòin,
   {{0x7ae94102,0x44444103,0x7ae0c104,0x44fbad16}},	//   _četr, ue_, _simt, _mª_,
   {{0x18770039,0x48ee11bc,0xe9f90032,0xb5fd807a}},	//   _העיר_, _इंडो_, _ajẹ_, ljšu,
   {{0x366a0fe7,0x69c086a5,0x2c21816f,0x7f3b00be}},	//   _само_, _pyme, _माझं_, _געטו,
   {{0x68e1b2a6,0x7524016a,0x6e299337,0xf8bf4105}},	//   _bild, quiz, dgeb, ctés_,
   {{0xb4c386b7,0x69c08a21,0x44444106,0x629d4107}},	//   ्षो_, _vyme, qe_, ziso,
   {{0x43860013,0x394d84c3,0x68e18965,0xd6d096a5}},	//   _الأق, _eses_, _dild, وقت_,
   {{0xdd080038,0x8cf4c108,0x39401893,0x44f4817c}},	//   _môže, озиц, _opis_, опис,
   {{0x68e9c109,0x39401dd3,0xf65301c6,0xbcfb046d}},	//   _gued, _npis_, לצה_, _eréf,
   {{0x68e1807b,0x6282c10a,0x04669510,0x44fb802a}},	//   _gild, lkoo, стим, _dª_,
   {{0x2d82895e,0x629d410b,0x44fb8118,0x7c288bfd}},	//   ške_, tiso, _eª_, rgdr,
   {{0x6282c10c,0x25a98289,0x6d49c10d,0x7e62c10e}},	//   nkoo, _žale_, bwea, _unop,
   {{0x787d8247,0x68e19238,0xe1ff410f,0x660d0365}},	//   _sèvi, _yild, rbó_, vaak,
   {{0x629d4110,0x200e8239,0x68e18079,0xd9180009}},	//   siso, nafi_, _xild, щью_,
   {{0x6282c111,0x5c3784de,0x443c8dcc,0x64450087}},	//   kkoo, _הטוב_, _ibv_, vehi,
   {{0xf96b0098,0x62828952,0x61e481a1,0xfaa42ba7}},	//   _брой_, jkoo, žilj, _најо,
   {{0xe29f0125,0x62829ead,0x660d4