# Dolphin Emulator Code of Conduct

Like many Open Source projects and the greater FLOSS community, Dolphin is a
collaborative open source community comprised of a diverse group of
contributors and users from around the globe. We find the contributions,
collaborations, and mentorships within our community to be the essential
lifeblood of our project and appreciate the efforts of those who participate to
nurture and grow those, and all other aspects of our community.

However, when a large and sufficiently diverse group of people work together,
there are often cultural, communication, and compatibility issues. In order to
minimize conflict, and provide a framework for resolution, we have a brief code
of conduct that we ask all participants in the Dolphin community adhere to.
These rules should apply to everyone, regardless of their status within the
community, and anyone can serve to remind, or ask the project leads to help
resolve issues.

No list is ever exhaustive, so we encourage members of the Dolphin community to
adhere to the spirit, rather than the letter, of this code, as that is how it
will be enforced. Places where this code may be particularly applicable are
GitHub issues and pull requests, bug tracker comments, IRC, Discord, forums,
Twitter discussions broadly directed at or between members of the community,
and other direct interactions within the community. Any violations, especially
continued or flagrant offenses, may affect an individual’s (or organization’s)
ability to participate within the Dolphin community.

If you feel that someone is in violation of the code of conduct, whether in
letter or in spirit, we request that you email as detailed a description as
possible of the offense and offending party/parties to
[conduct@dolphin-emu.org](mailto:conduct@dolphin-emu.org). If you have
questions, concerns, or any other inquiries please feel free to contact the
project leads.

## Rules

1. **Be friendly and patient.** We were all new or suffered from a lack of
   knowledge at one point in time. Please try to remember what it felt like to
   be on that end, and treat people accordingly.

2. **Be welcoming.** We strive to be a community that welcomes and supports
   people of all backgrounds and identities. This includes, but is not limited
   to members of any race, ethnicity, culture, national origin, colour,
   immigration status, social and economic class, educational level, sex,
   sexual orientation, gender identity and expression, age, size, family
   status, political belief, religion, and mental and physical ability.

3. **Be helpful.** By helping others to learn our entire ecosystem is enriched.
   We encourage members of the Dolphin community to mentor each other and help
   to raise the general level of knowledge in the community whenever possible.

4. **Be considerate.** Your work will be used by other people, and you in turn
   will depend on the work of others. Any decision you take will affect users
   and colleagues, and you should take those consequences into account when
   making decisions. Remember that we’re a world-wide community, so you might
   not be communicating in someone else’s primary language.

5. **Be respectful.** Not all of us will agree all the time, but disagreement
   is no excuse for poor behavior and poor manners. We might all experience
   some frustration now and then, but we cannot allow that frustration to turn
   into a personal attack. It’s important to remember that a community where
   people feel uncomfortable or threatened is not a productive one. Members of
   the Dolphin community should be respectful when dealing with other members
   as well as with people outside the Dolphin community.

6. **Be careful in the words that you choose.** We are a community of
   professionals, and we conduct ourselves professionally. Be kind to others.
   Do not insult or put down other participants. Harassment and other
   exclusionary behavior aren’t acceptable. This includes, but is not limited
   to:

    - Violent threats or language directed against another person.
    - Discriminatory jokes and language.
    - Posting sexually explicit or violent material.
    - Posting (or threatening to post) other people’s personally identifying
      information (“doxing”), regardless of whether it is publicly available.
    - Personal insults, especially those using racist, sexist, or otherwise
      discriminatory terms.
    - Deliberately referring to others by names or pronouns counter to their
      identity.
    - Unwelcome sexual attention.
    - Advocating for, or encouraging, any of the above behavior.
    - Repeated harassment of others. In general, if someone asks you to stop,
      then stop.

7. **When we disagree, try to understand why.** Disagreements, both social and
   technical, happen all the time and Dolphin is no exception. It is important
   that we resolve disagreements and differing views constructively.  Remember
   that we’re different. The strength of Dolphin comes from its varied
   community, people from a wide range of backgrounds. Different people have
   different perspectives on issues. Being unable to understand why someone
   holds a viewpoint doesn’t mean that they’re wrong. Don’t forget that it is
   human to err and blaming each other doesn’t get us anywhere. Instead, focus
   on helping to resolve issues and learning from mistakes.

## Consequences

Except in flagrant or otherwise egregious cases, the first infraction will
result in a verbal warning. Everyone slips up or acts out of frustration at
times, we just ask that you work to not repeat the behavior. Continued
infractions will be dealt with on a case-by-case basis, and could lead to
actions including:

- Temporary suspension from one or all avenues of Dolphin community
  participation. This includes, but is not limited to, IRC, Discord, GitHub,
  Redmine, and the Dolphin Forums.
- Permanent suspension from participating in the Dolphin community.

Moderators should generally assume good intent when evaluating infractions, but
should also keep in mind that good intent does not override the Code of Conduct
rules.

## Acknowledgments

This text is adapted from the [Asahi Linux Code of
Conduct](https://asahilinux.org/code-of-conduct/), itself derived from the
[Ceph Code of Conduct](https://ceph.io/community/code-of-conduct/), and the
[Django Project Code of Conduct](https://www.djangoproject.com/conduct/). Feel
free to reuse under the terms of the [CC-BY-SA 4.0
license](https://creativecommons.org/licenses/by-sa/4.0/).
