/* SPDX-License-Identifier: GPL-2.0 */
/* Copyright (c) 2018, The Linux Foundation. All rights reserved. */

#ifndef _DT_BINDINGS_POWER_QCOM_RPMPD_H
#define _DT_BINDINGS_POWER_QCOM_RPMPD_H

#include <dt-bindings/power/qcom,rpmhpd.h>

/* SM6350 Power Domain Indexes */
#define SM6375_VDDCX		0
#define SM6375_VDDCX_AO	1
#define SM6375_VDDCX_VFL	2
#define SM6375_VDDMX		3
#define SM6375_VDDMX_AO	4
#define SM6375_VDDMX_VFL	5
#define SM6375_VDDGX		6
#define SM6375_VDDGX_AO	7
#define SM6375_VDD_LPI_CX	8
#define SM6375_VDD_LPI_MX	9

/* MDM9607 Power Domains */
#define MDM9607_VDDCX		0
#define MDM9607_VDDCX_AO	1
#define MDM9607_VDDCX_VFL	2
#define MDM9607_VDDMX		3
#define MDM9607_VDDMX_AO	4
#define MDM9607_VDDMX_VFL	5

/* MSM8226 Power Domain Indexes */
#define MSM8226_VDDCX		0
#define MSM8226_VDDCX_AO	1
#define MSM8226_VDDCX_VFC	2

/* MSM8939 Power Domains */
#define MSM8939_VDDMDCX		0
#define MSM8939_VDDMDCX_AO	1
#define MSM8939_VDDMDCX_VFC	2
#define MSM8939_VDDCX		3
#define MSM8939_VDDCX_AO	4
#define MSM8939_VDDCX_VFC	5
#define MSM8939_VDDMX		6
#define MSM8939_VDDMX_AO	7

/* MSM8916 Power Domain Indexes */
#define MSM8916_VDDCX		0
#define MSM8916_VDDCX_AO	1
#define MSM8916_VDDCX_VFC	2
#define MSM8916_VDDMX		3
#define MSM8916_VDDMX_AO	4

/* MSM8909 Power Domain Indexes */
#define MSM8909_VDDCX		MSM8916_VDDCX
#define MSM8909_VDDCX_AO	MSM8916_VDDCX_AO
#define MSM8909_VDDCX_VFC	MSM8916_VDDCX_VFC
#define MSM8909_VDDMX		MSM8916_VDDMX
#define MSM8909_VDDMX_AO	MSM8916_VDDMX_AO

/* MSM8917 Power Domain Indexes */
#define MSM8917_VDDCX		0
#define MSM8917_VDDCX_AO	1
#define MSM8917_VDDCX_VFL	2
#define MSM8917_VDDMX		3
#define MSM8917_VDDMX_AO	4

/* MSM8937 Power Domain Indexes */
#define MSM8937_VDDCX		MSM8917_VDDCX
#define MSM8937_VDDCX_AO	MSM8917_VDDCX_AO
#define MSM8937_VDDCX_VFL	MSM8917_VDDCX_VFL
#define MSM8937_VDDMX		MSM8917_VDDMX
#define MSM8937_VDDMX_AO	MSM8917_VDDMX_AO

/* QM215 Power Domain Indexes */
#define QM215_VDDCX		MSM8917_VDDCX
#define QM215_VDDCX_AO		MSM8917_VDDCX_AO
#define QM215_VDDCX_VFL		MSM8917_VDDCX_VFL
#define QM215_VDDMX		MSM8917_VDDMX
#define QM215_VDDMX_AO		MSM8917_VDDMX_AO

/* MSM8953 Power Domain Indexes */
#define MSM8953_VDDMD		0
#define MSM8953_VDDMD_AO	1
#define MSM8953_VDDCX		2
#define MSM8953_VDDCX_AO	3
#define MSM8953_VDDCX_VFL	4
#define MSM8953_VDDMX		5
#define MSM8953_VDDMX_AO	6

/* MSM8974 Power Domain Indexes */
#define MSM8974_VDDCX		0
#define MSM8974_VDDCX_AO	1
#define MSM8974_VDDCX_VFC	2
#define MSM8974_VDDGFX		3
#define MSM8974_VDDGFX_VFC	4

/* MSM8976 Power Domain Indexes */
#define MSM8976_VDDCX		0
#define MSM8976_VDDCX_AO	1
#define MSM8976_VDDCX_VFL	2
#define MSM8976_VDDMX		3
#define MSM8976_VDDMX_AO	4
#define MSM8976_VDDMX_VFL	5

/* MSM8994 Power Domain Indexes */
#define MSM8994_VDDCX		0
#define MSM8994_VDDCX_AO	1
#define MSM8994_VDDCX_VFC	2
#define MSM8994_VDDMX		3
#define MSM8994_VDDMX_AO	4
#define MSM8994_VDDGFX		5
#define MSM8994_VDDGFX_VFC	6

/* MSM8996 Power Domain Indexes */
#define MSM8996_VDDCX		0
#define MSM8996_VDDCX_AO	1
#define MSM8996_VDDCX_VFC	2
#define MSM8996_VDDMX		3
#define MSM8996_VDDMX_AO	4
#define MSM8996_VDDSSCX		5
#define MSM8996_VDDSSCX_VFC	6

/* MSM8998 Power Domain Indexes */
#define MSM8998_VDDCX		0
#define MSM8998_VDDCX_AO	1
#define MSM8998_VDDCX_VFL	2
#define MSM8998_VDDMX		3
#define MSM8998_VDDMX_AO	4
#define MSM8998_VDDMX_VFL	5
#define MSM8998_SSCCX		6
#define MSM8998_SSCCX_VFL	7
#define MSM8998_SSCMX		8
#define MSM8998_SSCMX_VFL	9

/* QCS404 Power Domains */
#define QCS404_VDDMX		0
#define QCS404_VDDMX_AO		1
#define QCS404_VDDMX_VFL	2
#define QCS404_LPICX		3
#define QCS404_LPICX_VFL	4
#define QCS404_LPIMX		5
#define QCS404_LPIMX_VFL	6

/* SDM660 Power Domains */
#define SDM660_VDDCX		0
#define SDM660_VDDCX_AO		1
#define SDM660_VDDCX_VFL	2
#define SDM660_VDDMX		3
#define SDM660_VDDMX_AO		4
#define SDM660_VDDMX_VFL	5
#define SDM660_SSCCX		6
#define SDM660_SSCCX_VFL	7
#define SDM660_SSCMX		8
#define SDM660_SSCMX_VFL	9

/* SM6115 Power Domains */
#define SM6115_VDDCX		0
#define SM6115_VDDCX_AO		1
#define SM6115_VDDCX_VFL	2
#define SM6115_VDDMX		3
#define SM6115_VDDMX_AO		4
#define SM6115_VDDMX_VFL	5
#define SM6115_VDD_LPI_CX	6
#define SM6115_VDD_LPI_MX	7

/* SM6125 Power Domains */
#define SM6125_VDDCX		0
#define SM6125_VDDCX_AO		1
#define SM6125_VDDCX_VFL	2
#define SM6125_VDDMX		3
#define SM6125_VDDMX_AO		4
#define SM6125_VDDMX_VFL	5

/* QCM2290 Power Domains */
#define QCM2290_VDDCX		0
#define QCM2290_VDDCX_AO	1
#define QCM2290_VDDCX_VFL	2
#define QCM2290_VDDMX		3
#define QCM2290_VDDMX_AO	4
#define QCM2290_VDDMX_VFL	5
#define QCM2290_VDD_LPI_CX	6
#define QCM2290_VDD_LPI_MX	7

/* RPM SMD Power Domain performance levels */
#define RPM_SMD_LEVEL_RETENTION       16
#define RPM_SMD_LEVEL_RETENTION_PLUS  32
#define RPM_SMD_LEVEL_MIN_SVS         48
#define RPM_SMD_LEVEL_LOW_SVS         64
#define RPM_SMD_LEVEL_SVS             128
#define RPM_SMD_LEVEL_SVS_PLUS        192
#define RPM_SMD_LEVEL_NOM             256
#define RPM_SMD_LEVEL_NOM_PLUS        320
#define RPM_SMD_LEVEL_TURBO           384
#define RPM_SMD_LEVEL_TURBO_NO_CPR    416
#define RPM_SMD_LEVEL_TURBO_HIGH      448
#define RPM_SMD_LEVEL_BINNING         512

#endif
