/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.jvm.internal.impl.types.checker.ClassicTypeSystemContext;
import kotlin.reflect.jvm.internal.impl.types.model.ArgumentList;
import kotlin.reflect.jvm.internal.impl.types.model.CapturedTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.DefinitelyNotNullTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.FlexibleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.RigidTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.SimpleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeArgumentListMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeArgumentMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimpleClassicTypeSystemContext
implements ClassicTypeSystemContext {
    @NotNull
    public static final SimpleClassicTypeSystemContext INSTANCE = new SimpleClassicTypeSystemContext();

    private SimpleClassicTypeSystemContext() {
    }

    @NotNull
    public KotlinTypeMarker default$makeNullable(KotlinTypeMarker $this$makeNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$makeNullable, (String)"<this>");
        RigidTypeMarker rigidTypeMarker = this.asRigidType($this$makeNullable);
        return rigidTypeMarker != null && (rigidTypeMarker = this.withNullability(rigidTypeMarker, true)) != null ? (KotlinTypeMarker)rigidTypeMarker : $this$makeNullable;
    }

    @Nullable
    public CapturedTypeMarker default$asCapturedTypeUnwrappingDnn(RigidTypeMarker $this$asCapturedTypeUnwrappingDnn) {
        Intrinsics.checkNotNullParameter((Object)$this$asCapturedTypeUnwrappingDnn, (String)"<this>");
        return this.asCapturedType(this.originalIfDefinitelyNotNullable($this$asCapturedTypeUnwrappingDnn));
    }

    public boolean default$isCapturedType(KotlinTypeMarker $this$isCapturedType) {
        Intrinsics.checkNotNullParameter((Object)$this$isCapturedType, (String)"<this>");
        RigidTypeMarker rigidTypeMarker = this.asRigidType($this$isCapturedType);
        return (rigidTypeMarker != null ? this.asCapturedTypeUnwrappingDnn(rigidTypeMarker) : null) != null;
    }

    @NotNull
    public SimpleTypeMarker default$originalIfDefinitelyNotNullable(RigidTypeMarker $this$originalIfDefinitelyNotNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$originalIfDefinitelyNotNullable, (String)"<this>");
        RigidTypeMarker rigidTypeMarker = this.asDefinitelyNotNullType($this$originalIfDefinitelyNotNullable);
        if (rigidTypeMarker == null || (rigidTypeMarker = this.original((DefinitelyNotNullTypeMarker)rigidTypeMarker)) == null) {
            rigidTypeMarker = (SimpleTypeMarker)$this$originalIfDefinitelyNotNullable;
        }
        return rigidTypeMarker;
    }

    @NotNull
    public KotlinTypeMarker default$makeDefinitelyNotNullOrNotNull(KotlinTypeMarker $this$makeDefinitelyNotNullOrNotNull) {
        Intrinsics.checkNotNullParameter((Object)$this$makeDefinitelyNotNullOrNotNull, (String)"<this>");
        return this.makeDefinitelyNotNullOrNotNull($this$makeDefinitelyNotNullOrNotNull, false);
    }

    @Nullable
    public TypeArgumentMarker default$getArgumentOrNull(RigidTypeMarker $this$getArgumentOrNull, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getArgumentOrNull, (String)"<this>");
        boolean bl = 0 <= index ? index < this.argumentsCount($this$getArgumentOrNull) : false;
        if (bl) {
            return this.getArgument($this$getArgumentOrNull, index);
        }
        return null;
    }

    @NotNull
    public RigidTypeMarker default$lowerBoundIfFlexible(KotlinTypeMarker $this$lowerBoundIfFlexible) {
        Intrinsics.checkNotNullParameter((Object)$this$lowerBoundIfFlexible, (String)"<this>");
        KotlinTypeMarker kotlinTypeMarker = this.asFlexibleType($this$lowerBoundIfFlexible);
        if (kotlinTypeMarker == null || (kotlinTypeMarker = this.lowerBound((FlexibleTypeMarker)kotlinTypeMarker)) == null) {
            RigidTypeMarker rigidTypeMarker = this.asRigidType($this$lowerBoundIfFlexible);
            kotlinTypeMarker = rigidTypeMarker;
            Intrinsics.checkNotNull((Object)rigidTypeMarker);
        }
        return kotlinTypeMarker;
    }

    @NotNull
    public RigidTypeMarker default$upperBoundIfFlexible(KotlinTypeMarker $this$upperBoundIfFlexible) {
        Intrinsics.checkNotNullParameter((Object)$this$upperBoundIfFlexible, (String)"<this>");
        KotlinTypeMarker kotlinTypeMarker = this.asFlexibleType($this$upperBoundIfFlexible);
        if (kotlinTypeMarker == null || (kotlinTypeMarker = this.upperBound((FlexibleTypeMarker)kotlinTypeMarker)) == null) {
            RigidTypeMarker rigidTypeMarker = this.asRigidType($this$upperBoundIfFlexible);
            kotlinTypeMarker = rigidTypeMarker;
            Intrinsics.checkNotNull((Object)rigidTypeMarker);
        }
        return kotlinTypeMarker;
    }

    public boolean default$isFlexibleWithDifferentTypeConstructors(KotlinTypeMarker $this$isFlexibleWithDifferentTypeConstructors) {
        Intrinsics.checkNotNullParameter((Object)$this$isFlexibleWithDifferentTypeConstructors, (String)"<this>");
        return !Intrinsics.areEqual((Object)this.typeConstructor(this.lowerBoundIfFlexible($this$isFlexibleWithDifferentTypeConstructors)), (Object)this.typeConstructor(this.upperBoundIfFlexible($this$isFlexibleWithDifferentTypeConstructors)));
    }

    public boolean default$isFlexible(KotlinTypeMarker $this$isFlexible) {
        Intrinsics.checkNotNullParameter((Object)$this$isFlexible, (String)"<this>");
        return this.asFlexibleType($this$isFlexible) != null;
    }

    public boolean default$isDynamic(KotlinTypeMarker $this$isDynamic) {
        Intrinsics.checkNotNullParameter((Object)$this$isDynamic, (String)"<this>");
        FlexibleTypeMarker flexibleTypeMarker = this.asFlexibleType($this$isDynamic);
        return (flexibleTypeMarker != null ? this.asDynamicType(flexibleTypeMarker) : null) != null;
    }

    public boolean default$isDefinitelyNotNullType(KotlinTypeMarker $this$isDefinitelyNotNullType) {
        Intrinsics.checkNotNullParameter((Object)$this$isDefinitelyNotNullType, (String)"<this>");
        RigidTypeMarker rigidTypeMarker = this.asRigidType($this$isDefinitelyNotNullType);
        return (rigidTypeMarker != null ? this.asDefinitelyNotNullType(rigidTypeMarker) : null) != null;
    }

    public boolean default$isDefinitelyNotNullType(RigidTypeMarker $this$isDefinitelyNotNullType) {
        Intrinsics.checkNotNullParameter((Object)$this$isDefinitelyNotNullType, (String)"<this>");
        return this.asDefinitelyNotNullType($this$isDefinitelyNotNullType) != null;
    }

    public boolean default$hasFlexibleNullability(KotlinTypeMarker $this$hasFlexibleNullability) {
        Intrinsics.checkNotNullParameter((Object)$this$hasFlexibleNullability, (String)"<this>");
        return this.isMarkedNullable(this.lowerBoundIfFlexible($this$hasFlexibleNullability)) != this.isMarkedNullable(this.upperBoundIfFlexible($this$hasFlexibleNullability));
    }

    @NotNull
    public TypeConstructorMarker default$typeConstructor(KotlinTypeMarker $this$typeConstructor) {
        Intrinsics.checkNotNullParameter((Object)$this$typeConstructor, (String)"<this>");
        RigidTypeMarker rigidTypeMarker = this.asRigidType($this$typeConstructor);
        if (rigidTypeMarker == null) {
            rigidTypeMarker = this.lowerBoundIfFlexible($this$typeConstructor);
        }
        return this.typeConstructor(rigidTypeMarker);
    }

    public boolean default$isNothing(KotlinTypeMarker $this$isNothing) {
        Intrinsics.checkNotNullParameter((Object)$this$isNothing, (String)"<this>");
        return this.isNothingConstructor(this.typeConstructor($this$isNothing)) && !this.isNullableType($this$isNothing);
    }

    public boolean default$isClassType(RigidTypeMarker $this$isClassType) {
        Intrinsics.checkNotNullParameter((Object)$this$isClassType, (String)"<this>");
        return this.isClassTypeConstructor(this.typeConstructor($this$isClassType));
    }

    @Nullable
    public List<SimpleTypeMarker> default$fastCorrespondingSupertypes(RigidTypeMarker $this$fastCorrespondingSupertypes, TypeConstructorMarker constructor) {
        Intrinsics.checkNotNullParameter((Object)$this$fastCorrespondingSupertypes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        return null;
    }

    public boolean default$isIntegerLiteralType(RigidTypeMarker $this$isIntegerLiteralType) {
        Intrinsics.checkNotNullParameter((Object)$this$isIntegerLiteralType, (String)"<this>");
        return this.isIntegerLiteralTypeConstructor(this.typeConstructor($this$isIntegerLiteralType));
    }

    @NotNull
    public TypeArgumentMarker default$get(TypeArgumentListMarker $this$get, int index) {
        TypeArgumentMarker typeArgumentMarker;
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        TypeArgumentListMarker typeArgumentListMarker = $this$get;
        if (typeArgumentListMarker instanceof SimpleTypeMarker) {
            typeArgumentMarker = this.getArgument((KotlinTypeMarker)((Object)$this$get), index);
        } else if (typeArgumentListMarker instanceof ArgumentList) {
            Object e = ((ArgumentList)$this$get).get(index);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            typeArgumentMarker = (TypeArgumentMarker)e;
        } else {
            throw new IllegalStateException(("unknown type argument list type: " + $this$get + ", " + Reflection.getOrCreateKotlinClass($this$get.getClass())).toString());
        }
        return typeArgumentMarker;
    }

    public int default$size(TypeArgumentListMarker $this$size) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$size, (String)"<this>");
        TypeArgumentListMarker typeArgumentListMarker = $this$size;
        if (typeArgumentListMarker instanceof RigidTypeMarker) {
            n = this.argumentsCount((KotlinTypeMarker)((Object)$this$size));
        } else if (typeArgumentListMarker instanceof ArgumentList) {
            n = ((ArgumentList)$this$size).size();
        } else {
            throw new IllegalStateException(("unknown type argument list type: " + $this$size + ", " + Reflection.getOrCreateKotlinClass($this$size.getClass())).toString());
        }
        return n;
    }
}

