/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.codehaus.plexus.classworlds;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.org.codehaus.plexus.classworlds.ClassWorldListener;
import org.jetbrains.kotlin.org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.jetbrains.kotlin.org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.jetbrains.kotlin.org.codehaus.plexus.classworlds.realm.NoSuchRealmException;

public class ClassWorld {
    private Map<String, ClassRealm> realms;
    private final List<ClassWorldListener> listeners = new ArrayList<ClassWorldListener>();

    public ClassWorld(String realmId, ClassLoader classLoader) {
        this();
        try {
            this.newRealm(realmId, classLoader);
        }
        catch (DuplicateRealmException duplicateRealmException) {
            // empty catch block
        }
    }

    public ClassWorld() {
        this.realms = new LinkedHashMap<String, ClassRealm>();
    }

    public synchronized ClassRealm newRealm(String id, ClassLoader classLoader) throws DuplicateRealmException {
        if (this.realms.containsKey(id)) {
            throw new DuplicateRealmException(this, id);
        }
        ClassRealm realm = new ClassRealm(this, id, classLoader);
        this.realms.put(id, realm);
        for (ClassWorldListener listener : this.listeners) {
            listener.realmCreated(realm);
        }
        return realm;
    }

    public synchronized ClassRealm getRealm(String id) throws NoSuchRealmException {
        if (this.realms.containsKey(id)) {
            return this.realms.get(id);
        }
        throw new NoSuchRealmException(this, id);
    }

    public synchronized Collection<ClassRealm> getRealms() {
        return Collections.unmodifiableList(new ArrayList<ClassRealm>(this.realms.values()));
    }

    public synchronized void addListener(ClassWorldListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeListener(ClassWorldListener listener) {
        this.listeners.remove(listener);
    }
}

