package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetBaselineConfig invokes the dataworks_public.GetBaselineConfig API synchronously
func (client *Client) GetBaselineConfig(request *GetBaselineConfigRequest) (response *GetBaselineConfigResponse, err error) {
	response = CreateGetBaselineConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetBaselineConfigWithChan invokes the dataworks_public.GetBaselineConfig API asynchronously
func (client *Client) GetBaselineConfigWithChan(request *GetBaselineConfigRequest) (<-chan *GetBaselineConfigResponse, <-chan error) {
	responseChan := make(chan *GetBaselineConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetBaselineConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetBaselineConfigWithCallback invokes the dataworks_public.GetBaselineConfig API asynchronously
func (client *Client) GetBaselineConfigWithCallback(request *GetBaselineConfigRequest, callback func(response *GetBaselineConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetBaselineConfigResponse
		var err error
		defer close(result)
		response, err = client.GetBaselineConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetBaselineConfigRequest is the request struct for api GetBaselineConfig
type GetBaselineConfigRequest struct {
	*requests.RpcRequest
	BaselineId requests.Integer `position:"Body" name:"BaselineId"`
}

// GetBaselineConfigResponse is the response struct for api GetBaselineConfig
type GetBaselineConfigResponse struct {
	*responses.BaseResponse
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetBaselineConfigRequest creates a request to invoke GetBaselineConfig API
func CreateGetBaselineConfigRequest() (request *GetBaselineConfigRequest) {
	request = &GetBaselineConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetBaselineConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateGetBaselineConfigResponse creates a response to parse from GetBaselineConfig response
func CreateGetBaselineConfigResponse() (response *GetBaselineConfigResponse) {
	response = &GetBaselineConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
