package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RelateDbForHBaseHa invokes the hbase.RelateDbForHBaseHa API synchronously
func (client *Client) RelateDbForHBaseHa(request *RelateDbForHBaseHaRequest) (response *RelateDbForHBaseHaResponse, err error) {
	response = CreateRelateDbForHBaseHaResponse()
	err = client.DoAction(request, response)
	return
}

// RelateDbForHBaseHaWithChan invokes the hbase.RelateDbForHBaseHa API asynchronously
func (client *Client) RelateDbForHBaseHaWithChan(request *RelateDbForHBaseHaRequest) (<-chan *RelateDbForHBaseHaResponse, <-chan error) {
	responseChan := make(chan *RelateDbForHBaseHaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RelateDbForHBaseHa(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RelateDbForHBaseHaWithCallback invokes the hbase.RelateDbForHBaseHa API asynchronously
func (client *Client) RelateDbForHBaseHaWithCallback(request *RelateDbForHBaseHaRequest, callback func(response *RelateDbForHBaseHaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RelateDbForHBaseHaResponse
		var err error
		defer close(result)
		response, err = client.RelateDbForHBaseHa(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RelateDbForHBaseHaRequest is the request struct for api RelateDbForHBaseHa
type RelateDbForHBaseHaRequest struct {
	*requests.RpcRequest
	HaMigrateType       string           `position:"Query" name:"HaMigrateType"`
	HaActiveHdfsUri     string           `position:"Query" name:"HaActiveHdfsUri"`
	HaStandbyVersion    string           `position:"Query" name:"HaStandbyVersion"`
	IsStandbyStandard   requests.Boolean `position:"Query" name:"IsStandbyStandard"`
	HaActiveClusterKey  string           `position:"Query" name:"HaActiveClusterKey"`
	HaStandbyPassword   string           `position:"Query" name:"HaStandbyPassword"`
	HaStandbyClusterKey string           `position:"Query" name:"HaStandbyClusterKey"`
	HaStandbyHbaseFsDir string           `position:"Query" name:"HaStandbyHbaseFsDir"`
	HaActiveHbaseFsDir  string           `position:"Query" name:"HaActiveHbaseFsDir"`
	HaActiveDBType      string           `position:"Query" name:"HaActiveDBType"`
	HaActivePassword    string           `position:"Query" name:"HaActivePassword"`
	IsActiveStandard    requests.Boolean `position:"Query" name:"IsActiveStandard"`
	HaStandbyUser       string           `position:"Query" name:"HaStandbyUser"`
	HaActive            string           `position:"Query" name:"HaActive"`
	HaStandby           string           `position:"Query" name:"HaStandby"`
	HaStandbyHdfsUri    string           `position:"Query" name:"HaStandbyHdfsUri"`
	HaActiveVersion     string           `position:"Query" name:"HaActiveVersion"`
	ClusterId           string           `position:"Query" name:"ClusterId"`
	HaStandbyDBType     string           `position:"Query" name:"HaStandbyDBType"`
	HaTables            string           `position:"Query" name:"HaTables"`
	HaActiveUser        string           `position:"Query" name:"HaActiveUser"`
}

// RelateDbForHBaseHaResponse is the response struct for api RelateDbForHBaseHa
type RelateDbForHBaseHaResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRelateDbForHBaseHaRequest creates a request to invoke RelateDbForHBaseHa API
func CreateRelateDbForHBaseHaRequest() (request *RelateDbForHBaseHaRequest) {
	request = &RelateDbForHBaseHaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "RelateDbForHBaseHa", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRelateDbForHBaseHaResponse creates a response to parse from RelateDbForHBaseHa response
func CreateRelateDbForHBaseHaResponse() (response *RelateDbForHBaseHaResponse) {
	response = &RelateDbForHBaseHaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
