/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_zh_Hant_HK extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ka = "格魯吉亞文";
        final String metaValue_kn = "坎納達文";
        final String metaValue_lo = "老撾文";
        final String metaValue_ml = "馬拉雅拉姆文";
        final String metaValue_or = "奧里雅文";
        final String metaValue_ta = "泰米爾文";
        final String metaValue_type_nu_taml = "泰米爾數字";
        final Object[][] data = new Object[][] {
            { "013", "中美洲" },
            { "029", "加勒比" },
            { "053", "澳大拉西亞" },
            { "061", "波利尼西亞" },
            { "AE", "阿拉伯聯合酋長國" },
            { "AG", "安提瓜和巴布達" },
            { "AW", "阿魯巴" },
            { "AZ", "亞塞拜疆" },
            { "BA", "波斯尼亞和黑塞哥維那" },
            { "BB", "巴巴多斯" },
            { "BF", "布基納法索" },
            { "BI", "布隆迪" },
            { "BJ", "貝寧" },
            { "BL", "聖巴泰勒米" },
            { "BV", "鮑威特島" },
            { "BW", "博茨瓦納" },
            { "BZ", "伯利茲" },
            { "CC", "科科斯 (基林) 群島" },
            { "CI", "科特迪瓦" },
            { "CP", "克里珀頓島" },
            { "CR", "哥斯達黎加" },
            { "CV", "佛得角" },
            { "CY", "塞浦路斯" },
            { "DJ", "吉布提" },
            { "DO", "多米尼加共和國" },
            { "EC", "厄瓜多爾" },
            { "ER", "厄立特里亞" },
            { "ET", "埃塞俄比亞" },
            { "GA", "加蓬" },
            { "GD", "格林納達" },
            { "GE", "格魯吉亞" },
            { "GH", "加納" },
            { "GM", "岡比亞" },
            { "GS", "南佐治亞島與南桑威奇群島" },
            { "GT", "危地馬拉" },
            { "GW", "幾內亞比紹" },
            { "GY", "圭亞那" },
            { "HN", "洪都拉斯" },
            { "HR", "克羅地亞" },
            { "IM", "馬恩島" },
            { "IT", "意大利" },
            { "KE", "肯尼亞" },
            { "KM", "科摩羅" },
            { "KN", "聖基茨和尼維斯" },
            { "LA", "老撾" },
            { "LC", "聖盧西亞" },
            { "LI", "列支敦士登" },
            { "LR", "利比里亞" },
            { "LS", "萊索托" },
            { "ME", "黑山" },
            { "ML", "馬里" },
            { "MR", "毛里塔尼亞" },
            { "MS", "蒙特塞拉特" },
            { "MT", "馬耳他" },
            { "MU", "毛里裘斯" },
            { "MV", "馬爾代夫" },
            { "MW", "馬拉維" },
            { "MZ", "莫桑比克" },
            { "NE", "尼日爾" },
            { "NG", "尼日利亞" },
            { "NR", "瑙魯" },
            { "PF", "法屬波利尼西亞" },
            { "PG", "巴布亞新畿內亞" },
            { "PN", "皮特凱恩島" },
            { "PS", "巴勒斯坦領土" },
            { "QA", "卡塔爾" },
            { "RW", "盧旺達" },
            { "SA", "沙地阿拉伯" },
            { "SB", "所羅門群島" },
            { "SC", "塞舌爾" },
            { "SI", "斯洛文尼亞" },
            { "SJ", "斯瓦爾巴特群島及揚馬延島" },
            { "SL", "塞拉利昂" },
            { "SM", "聖馬力諾" },
            { "SO", "索馬里" },
            { "SR", "蘇里南" },
            { "ST", "聖多美和普林西比" },
            { "SZ", "斯威士蘭" },
            { "TC", "特克斯和凱科斯群島" },
            { "TD", "乍得" },
            { "TF", "法屬南部領地" },
            { "TO", "湯加" },
            { "TT", "千里達和多巴哥" },
            { "TV", "圖瓦盧" },
            { "TZ", "坦桑尼亞" },
            { "VC", "聖文森特和格林納丁斯" },
            { "VG", "英屬維爾京群島" },
            { "VI", "美屬維爾京群島" },
            { "VU", "瓦努阿圖" },
            { "YE", "也門" },
            { "YT", "馬約特" },
            { "ZM", "贊比亞" },
            { "ZW", "津巴布韋" },
            { "aa", "阿法爾文" },
            { "am", "岩哈拉語" },
            { "az", "阿塞拜疆文" },
            { "ba", "巴什基爾文" },
            { "br", "布里多尼文" },
            { "bs", "波斯尼亞文" },
            { "ca", "加泰隆尼亞文" },
            { "eo", "世界語" },
            { "gl", "加里西亞文" },
            { "hr", "克羅地亞文" },
            { "ig", "伊博文" },
            { "it", "意大利文" },
            { "ka", metaValue_ka },
            { "kn", metaValue_kn },
            { "ku", "北庫德文" },
            { "lo", metaValue_lo },
            { "mg", "馬拉加斯文" },
            { "ml", metaValue_ml },
            { "mt", "馬耳他文" },
            { "or", metaValue_or },
            { "rw", "盧旺達文" },
            { "sl", "斯洛文尼亞文" },
            { "sn", "修納文" },
            { "so", "索馬里文" },
            { "ta", metaValue_ta },
            { "tn", "突尼西亞文" },
            { "to", "湯加文" },
            { "ur", "烏爾都文" },
            { "crs", "塞舌爾克里奧爾法文" },
            { "den", "斯拉夫文" },
            { "gil", "吉爾伯特文" },
            { "gsw", "瑞士德文" },
            { "jpr", "猶太波斯文" },
            { "kiu", "扎扎其文" },
            { "kri", "克裡奧爾文" },
            { "luo", "盧歐文" },
            { "mfe", "毛里裘斯克里奧爾文" },
            { "nqo", "西非書面語言（N’ko）" },
            { "pcm", "尼日利亞皮欽文" },
            { "rup", "阿羅馬尼亞語" },
            { "syr", "敍利亞文" },
            { "wbp", "瓦爾皮里文" },
            { "yue", "廣東話" },
            { "zgh", "摩洛哥標準塔馬齊格特文" },
            { "Ethi", "埃塞俄比亞文" },
            { "Geor", metaValue_ka },
            { "Guru", "古木基文" },
            { "Hans", "簡體字" },
            { "Hant", "繁體字" },
            { "Knda", metaValue_kn },
            { "Laoo", metaValue_lo },
            { "Mlym", metaValue_ml },
            { "Newa", "尼瓦爾文" },
            { "Orya", metaValue_or },
            { "Sinh", "僧伽羅文" },
            { "Taml", metaValue_ta },
            { "Thaa", "它拿字母" },
            { "de_AT", "奧地利德文" },
            { "de_CH", "瑞士德語" },
            { "en_AU", "澳洲英文" },
            { "en_CA", "加拿大英文" },
            { "en_GB", "英國英文" },
            { "en_US", "美國英文" },
            { "es_ES", "歐洲西班牙文" },
            { "es_MX", "墨西哥西班牙文" },
            { "fa_AF", "達利文" },
            { "fr_CA", "加拿大法文" },
            { "fr_CH", "瑞士法文" },
            { "nl_BE", "比利時荷蘭文" },
            { "pt_BR", "巴西葡萄牙文" },
            { "pt_PT", "歐洲葡萄牙文" },
            { "ro_MD", "摩爾多瓦羅馬尼亞文" },
            { "sw_CD", "剛果史瓦希里文" },
            { "%%1901", "傳統德國拼字法" },
            { "%%1996", "1996 德國拼字法" },
            { "es_419", "拉丁美洲西班牙文" },
            { "key.ms", "度量衡系統" },
            { "az_Arab", "南阿塞拜疆文" },
            { "%%REVISED", "已修訂拼字法" },
            { "%%SCOTLAND", "蘇格蘭標準英語" },
            { "type.nu.deva", "天城體數字" },
            { "type.nu.ethi", "埃塞俄比亞數字" },
            { "type.nu.geor", "格魯吉亞數字" },
            { "type.nu.knda", "卡納達數字" },
            { "type.nu.laoo", "老撾數字" },
            { "type.nu.mlym", "馬拉雅拉姆數字" },
            { "type.nu.orya", "奧里亞數字" },
            { "type.nu.taml", metaValue_type_nu_taml },
            { "type.nu.tamldec", metaValue_type_nu_taml },
            { "type.ca.ethiopic", "埃塞俄比亞曆" },
            { "type.ms.uksystem", "英制" },
            { "type.ms.ussystem", "美制" },
            { "type.co.dictionary", "詞典排序" },
            { "type.ca.ethiopic-amete-alem", "埃塞俄比亞阿美德阿萊姆曆" },
        };
        return data;
    }
}
