//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsxmlparserexternalentityresolvingpolicy?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSXMLParserExternalEntityResolvingPolicy(pub NSUInteger);
impl NSXMLParserExternalEntityResolvingPolicy {
    #[doc(alias = "NSXMLParserResolveExternalEntitiesNever")]
    pub const ResolveExternalEntitiesNever: Self = Self(0);
    #[doc(alias = "NSXMLParserResolveExternalEntitiesNoNetwork")]
    pub const ResolveExternalEntitiesNoNetwork: Self = Self(1);
    #[doc(alias = "NSXMLParserResolveExternalEntitiesSameOriginOnly")]
    pub const ResolveExternalEntitiesSameOriginOnly: Self = Self(2);
    #[doc(alias = "NSXMLParserResolveExternalEntitiesAlways")]
    pub const ResolveExternalEntitiesAlways: Self = Self(3);
}

unsafe impl Encode for NSXMLParserExternalEntityResolvingPolicy {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSXMLParserExternalEntityResolvingPolicy {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsxmlparser?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSXMLParser;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSXMLParser {}
);

impl NSXMLParser {
    extern_methods!(
        #[cfg(feature = "NSURL")]
        #[unsafe(method(initWithContentsOfURL:))]
        #[unsafe(method_family = init)]
        pub fn initWithContentsOfURL(this: Allocated<Self>, url: &NSURL) -> Option<Retained<Self>>;

        #[cfg(feature = "NSData")]
        #[unsafe(method(initWithData:))]
        #[unsafe(method_family = init)]
        pub fn initWithData(this: Allocated<Self>, data: &NSData) -> Retained<Self>;

        #[cfg(feature = "NSStream")]
        #[unsafe(method(initWithStream:))]
        #[unsafe(method_family = init)]
        pub fn initWithStream(this: Allocated<Self>, stream: &NSInputStream) -> Retained<Self>;

        /// # Safety
        ///
        /// This is not retained internally, you must ensure the object is still alive.
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(&self) -> Option<Retained<ProtocolObject<dyn NSXMLParserDelegate>>>;

        /// Setter for [`delegate`][Self::delegate].
        ///
        /// # Safety
        ///
        /// This is unretained, you must ensure the object is kept alive while in use.
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn NSXMLParserDelegate>>,
        );

        #[unsafe(method(shouldProcessNamespaces))]
        #[unsafe(method_family = none)]
        pub fn shouldProcessNamespaces(&self) -> bool;

        /// Setter for [`shouldProcessNamespaces`][Self::shouldProcessNamespaces].
        #[unsafe(method(setShouldProcessNamespaces:))]
        #[unsafe(method_family = none)]
        pub fn setShouldProcessNamespaces(&self, should_process_namespaces: bool);

        #[unsafe(method(shouldReportNamespacePrefixes))]
        #[unsafe(method_family = none)]
        pub fn shouldReportNamespacePrefixes(&self) -> bool;

        /// Setter for [`shouldReportNamespacePrefixes`][Self::shouldReportNamespacePrefixes].
        #[unsafe(method(setShouldReportNamespacePrefixes:))]
        #[unsafe(method_family = none)]
        pub fn setShouldReportNamespacePrefixes(&self, should_report_namespace_prefixes: bool);

        #[unsafe(method(externalEntityResolvingPolicy))]
        #[unsafe(method_family = none)]
        pub fn externalEntityResolvingPolicy(&self) -> NSXMLParserExternalEntityResolvingPolicy;

        /// Setter for [`externalEntityResolvingPolicy`][Self::externalEntityResolvingPolicy].
        #[unsafe(method(setExternalEntityResolvingPolicy:))]
        #[unsafe(method_family = none)]
        pub fn setExternalEntityResolvingPolicy(
            &self,
            external_entity_resolving_policy: NSXMLParserExternalEntityResolvingPolicy,
        );

        #[cfg(all(feature = "NSSet", feature = "NSURL"))]
        #[unsafe(method(allowedExternalEntityURLs))]
        #[unsafe(method_family = none)]
        pub fn allowedExternalEntityURLs(&self) -> Option<Retained<NSSet<NSURL>>>;

        #[cfg(all(feature = "NSSet", feature = "NSURL"))]
        /// Setter for [`allowedExternalEntityURLs`][Self::allowedExternalEntityURLs].
        ///
        /// This is [copied][crate::NSCopying::copy] when set.
        #[unsafe(method(setAllowedExternalEntityURLs:))]
        #[unsafe(method_family = none)]
        pub fn setAllowedExternalEntityURLs(
            &self,
            allowed_external_entity_ur_ls: Option<&NSSet<NSURL>>,
        );

        #[unsafe(method(parse))]
        #[unsafe(method_family = none)]
        pub fn parse(&self) -> bool;

        #[unsafe(method(abortParsing))]
        #[unsafe(method_family = none)]
        pub fn abortParsing(&self);

        #[cfg(feature = "NSError")]
        #[unsafe(method(parserError))]
        #[unsafe(method_family = none)]
        pub fn parserError(&self) -> Option<Retained<NSError>>;

        #[unsafe(method(shouldResolveExternalEntities))]
        #[unsafe(method_family = none)]
        pub fn shouldResolveExternalEntities(&self) -> bool;

        /// Setter for [`shouldResolveExternalEntities`][Self::shouldResolveExternalEntities].
        #[unsafe(method(setShouldResolveExternalEntities:))]
        #[unsafe(method_family = none)]
        pub fn setShouldResolveExternalEntities(&self, should_resolve_external_entities: bool);
    );
}

/// Methods declared on superclass `NSObject`.
impl NSXMLParser {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSXMLParser {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

/// NSXMLParserLocatorAdditions.
impl NSXMLParser {
    extern_methods!(
        #[cfg(feature = "NSString")]
        #[unsafe(method(publicID))]
        #[unsafe(method_family = none)]
        pub fn publicID(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(systemID))]
        #[unsafe(method_family = none)]
        pub fn systemID(&self) -> Option<Retained<NSString>>;

        #[unsafe(method(lineNumber))]
        #[unsafe(method_family = none)]
        pub fn lineNumber(&self) -> NSInteger;

        #[unsafe(method(columnNumber))]
        #[unsafe(method_family = none)]
        pub fn columnNumber(&self) -> NSInteger;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsxmlparserdelegate?language=objc)
    pub unsafe trait NSXMLParserDelegate: NSObjectProtocol {
        #[optional]
        #[unsafe(method(parserDidStartDocument:))]
        #[unsafe(method_family = none)]
        fn parserDidStartDocument(&self, parser: &NSXMLParser);

        #[optional]
        #[unsafe(method(parserDidEndDocument:))]
        #[unsafe(method_family = none)]
        fn parserDidEndDocument(&self, parser: &NSXMLParser);

        #[cfg(feature = "NSString")]
        #[optional]
        #[unsafe(method(parser:foundNotationDeclarationWithName:publicID:systemID:))]
        #[unsafe(method_family = none)]
        fn parser_foundNotationDeclarationWithName_publicID_systemID(
            &self,
            parser: &NSXMLParser,
            name: &NSString,
            public_id: Option<&NSString>,
            system_id: Option<&NSString>,
        );

        #[cfg(feature = "NSString")]
        #[optional]
        #[unsafe(method(parser:foundUnparsedEntityDeclarationWithName:publicID:systemID:notationName:))]
        #[unsafe(method_family = none)]
        fn parser_foundUnparsedEntityDeclarationWithName_publicID_systemID_notationName(
            &self,
            parser: &NSXMLParser,
            name: &NSString,
            public_id: Option<&NSString>,
            system_id: Option<&NSString>,
            notation_name: Option<&NSString>,
        );

        #[cfg(feature = "NSString")]
        #[optional]
        #[unsafe(method(parser:foundAttributeDeclarationWithName:forElement:type:defaultValue:))]
        #[unsafe(method_family = none)]
        fn parser_foundAttributeDeclarationWithName_forElement_type_defaultValue(
            &self,
            parser: &NSXMLParser,
            attribute_name: &NSString,
            element_name: &NSString,
            r#type: Option<&NSString>,
            default_value: Option<&NSString>,
        );

        #[cfg(feature = "NSString")]
        #[optional]
        #[unsafe(method(parser:foundElementDeclarationWithName:model:))]
        #[unsafe(method_family = none)]
        fn parser_foundElementDeclarationWithName_model(
            &self,
            parser: &NSXMLParser,
            element_name: &NSString,
            model: &NSString,
        );

        #[cfg(feature = "NSString")]
        #[optional]
        #[unsafe(method(parser:foundInternalEntityDeclarationWithName:value:))]
        #[unsafe(method_family = none)]
        fn parser_foundInternalEntityDeclarationWithName_value(
            &self,
            parser: &NSXMLParser,
            name: &NSString,
            value: Option<&NSString>,
        );

        #[cfg(feature = "NSString")]
        #[optional]
        #[unsafe(method(parser:foundExternalEntityDeclarationWithName:publicID:systemID:))]
        #[unsafe(method_family = none)]
        fn parser_foundExternalEntityDeclarationWithName_publicID_systemID(
            &self,
            parser: &NSXMLParser,
            name: &NSString,
            public_id: Option<&NSString>,
            system_id: Option<&NSString>,
        );

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        #[optional]
        #[unsafe(method(parser:didStartElement:namespaceURI:qualifiedName:attributes:))]
        #[unsafe(method_family = none)]
        fn parser_didStartElement_namespaceURI_qualifiedName_attributes(
            &self,
            parser: &NSXMLParser,
            element_name: &NSString,
            namespace_uri: Option<&NSString>,
            q_name: Option<&NSString>,
            attribute_dict: &NSDictionary<NSString, NSString>,
        );

        #[cfg(feature = "NSString")]
        #[optional]
        #[unsafe(method(parser:didEndElement:namespaceURI:qualifiedName:))]
        #[unsafe(method_family = none)]
        fn parser_didEndElement_namespaceURI_qualifiedName(
            &self,
            parser: &NSXMLParser,
            element_name: &NSString,
            namespace_uri: Option<&NSString>,
            q_name: Option<&NSString>,
        );

        #[cfg(feature = "NSString")]
        #[optional]
        #[unsafe(method(parser:didStartMappingPrefix:toURI:))]
        #[unsafe(method_family = none)]
        fn parser_didStartMappingPrefix_toURI(
            &self,
            parser: &NSXMLParser,
            prefix: &NSString,
            namespace_uri: &NSString,
        );

        #[cfg(feature = "NSString")]
        #[optional]
        #[unsafe(method(parser:didEndMappingPrefix:))]
        #[unsafe(method_family = none)]
        fn parser_didEndMappingPrefix(&self, parser: &NSXMLParser, prefix: &NSString);

        #[cfg(feature = "NSString")]
        #[optional]
        #[unsafe(method(parser:foundCharacters:))]
        #[unsafe(method_family = none)]
        fn parser_foundCharacters(&self, parser: &NSXMLParser, string: &NSString);

        #[cfg(feature = "NSString")]
        #[optional]
        #[unsafe(method(parser:foundIgnorableWhitespace:))]
        #[unsafe(method_family = none)]
        fn parser_foundIgnorableWhitespace(
            &self,
            parser: &NSXMLParser,
            whitespace_string: &NSString,
        );

        #[cfg(feature = "NSString")]
        #[optional]
        #[unsafe(method(parser:foundProcessingInstructionWithTarget:data:))]
        #[unsafe(method_family = none)]
        fn parser_foundProcessingInstructionWithTarget_data(
            &self,
            parser: &NSXMLParser,
            target: &NSString,
            data: Option<&NSString>,
        );

        #[cfg(feature = "NSString")]
        #[optional]
        #[unsafe(method(parser:foundComment:))]
        #[unsafe(method_family = none)]
        fn parser_foundComment(&self, parser: &NSXMLParser, comment: &NSString);

        #[cfg(feature = "NSData")]
        #[optional]
        #[unsafe(method(parser:foundCDATA:))]
        #[unsafe(method_family = none)]
        fn parser_foundCDATA(&self, parser: &NSXMLParser, cdata_block: &NSData);

        #[cfg(all(feature = "NSData", feature = "NSString"))]
        #[optional]
        #[unsafe(method(parser:resolveExternalEntityName:systemID:))]
        #[unsafe(method_family = none)]
        fn parser_resolveExternalEntityName_systemID(
            &self,
            parser: &NSXMLParser,
            name: &NSString,
            system_id: Option<&NSString>,
        ) -> Option<Retained<NSData>>;

        #[cfg(feature = "NSError")]
        #[optional]
        #[unsafe(method(parser:parseErrorOccurred:))]
        #[unsafe(method_family = none)]
        fn parser_parseErrorOccurred(&self, parser: &NSXMLParser, parse_error: &NSError);

        #[cfg(feature = "NSError")]
        #[optional]
        #[unsafe(method(parser:validationErrorOccurred:))]
        #[unsafe(method_family = none)]
        fn parser_validationErrorOccurred(&self, parser: &NSXMLParser, validation_error: &NSError);
    }
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsxmlparsererrordomain?language=objc)
    #[cfg(all(feature = "NSError", feature = "NSString"))]
    pub static NSXMLParserErrorDomain: &'static NSErrorDomain;
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsxmlparsererror?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSXMLParserError(pub NSInteger);
impl NSXMLParserError {
    #[doc(alias = "NSXMLParserInternalError")]
    pub const InternalError: Self = Self(1);
    #[doc(alias = "NSXMLParserOutOfMemoryError")]
    pub const OutOfMemoryError: Self = Self(2);
    #[doc(alias = "NSXMLParserDocumentStartError")]
    pub const DocumentStartError: Self = Self(3);
    #[doc(alias = "NSXMLParserEmptyDocumentError")]
    pub const EmptyDocumentError: Self = Self(4);
    #[doc(alias = "NSXMLParserPrematureDocumentEndError")]
    pub const PrematureDocumentEndError: Self = Self(5);
    #[doc(alias = "NSXMLParserInvalidHexCharacterRefError")]
    pub const InvalidHexCharacterRefError: Self = Self(6);
    #[doc(alias = "NSXMLParserInvalidDecimalCharacterRefError")]
    pub const InvalidDecimalCharacterRefError: Self = Self(7);
    #[doc(alias = "NSXMLParserInvalidCharacterRefError")]
    pub const InvalidCharacterRefError: Self = Self(8);
    #[doc(alias = "NSXMLParserInvalidCharacterError")]
    pub const InvalidCharacterError: Self = Self(9);
    #[doc(alias = "NSXMLParserCharacterRefAtEOFError")]
    pub const CharacterRefAtEOFError: Self = Self(10);
    #[doc(alias = "NSXMLParserCharacterRefInPrologError")]
    pub const CharacterRefInPrologError: Self = Self(11);
    #[doc(alias = "NSXMLParserCharacterRefInEpilogError")]
    pub const CharacterRefInEpilogError: Self = Self(12);
    #[doc(alias = "NSXMLParserCharacterRefInDTDError")]
    pub const CharacterRefInDTDError: Self = Self(13);
    #[doc(alias = "NSXMLParserEntityRefAtEOFError")]
    pub const EntityRefAtEOFError: Self = Self(14);
    #[doc(alias = "NSXMLParserEntityRefInPrologError")]
    pub const EntityRefInPrologError: Self = Self(15);
    #[doc(alias = "NSXMLParserEntityRefInEpilogError")]
    pub const EntityRefInEpilogError: Self = Self(16);
    #[doc(alias = "NSXMLParserEntityRefInDTDError")]
    pub const EntityRefInDTDError: Self = Self(17);
    #[doc(alias = "NSXMLParserParsedEntityRefAtEOFError")]
    pub const ParsedEntityRefAtEOFError: Self = Self(18);
    #[doc(alias = "NSXMLParserParsedEntityRefInPrologError")]
    pub const ParsedEntityRefInPrologError: Self = Self(19);
    #[doc(alias = "NSXMLParserParsedEntityRefInEpilogError")]
    pub const ParsedEntityRefInEpilogError: Self = Self(20);
    #[doc(alias = "NSXMLParserParsedEntityRefInInternalSubsetError")]
    pub const ParsedEntityRefInInternalSubsetError: Self = Self(21);
    #[doc(alias = "NSXMLParserEntityReferenceWithoutNameError")]
    pub const EntityReferenceWithoutNameError: Self = Self(22);
    #[doc(alias = "NSXMLParserEntityReferenceMissingSemiError")]
    pub const EntityReferenceMissingSemiError: Self = Self(23);
    #[doc(alias = "NSXMLParserParsedEntityRefNoNameError")]
    pub const ParsedEntityRefNoNameError: Self = Self(24);
    #[doc(alias = "NSXMLParserParsedEntityRefMissingSemiError")]
    pub const ParsedEntityRefMissingSemiError: Self = Self(25);
    #[doc(alias = "NSXMLParserUndeclaredEntityError")]
    pub const UndeclaredEntityError: Self = Self(26);
    #[doc(alias = "NSXMLParserUnparsedEntityError")]
    pub const UnparsedEntityError: Self = Self(28);
    #[doc(alias = "NSXMLParserEntityIsExternalError")]
    pub const EntityIsExternalError: Self = Self(29);
    #[doc(alias = "NSXMLParserEntityIsParameterError")]
    pub const EntityIsParameterError: Self = Self(30);
    #[doc(alias = "NSXMLParserUnknownEncodingError")]
    pub const UnknownEncodingError: Self = Self(31);
    #[doc(alias = "NSXMLParserEncodingNotSupportedError")]
    pub const EncodingNotSupportedError: Self = Self(32);
    #[doc(alias = "NSXMLParserStringNotStartedError")]
    pub const StringNotStartedError: Self = Self(33);
    #[doc(alias = "NSXMLParserStringNotClosedError")]
    pub const StringNotClosedError: Self = Self(34);
    #[doc(alias = "NSXMLParserNamespaceDeclarationError")]
    pub const NamespaceDeclarationError: Self = Self(35);
    #[doc(alias = "NSXMLParserEntityNotStartedError")]
    pub const EntityNotStartedError: Self = Self(36);
    #[doc(alias = "NSXMLParserEntityNotFinishedError")]
    pub const EntityNotFinishedError: Self = Self(37);
    #[doc(alias = "NSXMLParserLessThanSymbolInAttributeError")]
    pub const LessThanSymbolInAttributeError: Self = Self(38);
    #[doc(alias = "NSXMLParserAttributeNotStartedError")]
    pub const AttributeNotStartedError: Self = Self(39);
    #[doc(alias = "NSXMLParserAttributeNotFinishedError")]
    pub const AttributeNotFinishedError: Self = Self(40);
    #[doc(alias = "NSXMLParserAttributeHasNoValueError")]
    pub const AttributeHasNoValueError: Self = Self(41);
    #[doc(alias = "NSXMLParserAttributeRedefinedError")]
    pub const AttributeRedefinedError: Self = Self(42);
    #[doc(alias = "NSXMLParserLiteralNotStartedError")]
    pub const LiteralNotStartedError: Self = Self(43);
    #[doc(alias = "NSXMLParserLiteralNotFinishedError")]
    pub const LiteralNotFinishedError: Self = Self(44);
    #[doc(alias = "NSXMLParserCommentNotFinishedError")]
    pub const CommentNotFinishedError: Self = Self(45);
    #[doc(alias = "NSXMLParserProcessingInstructionNotStartedError")]
    pub const ProcessingInstructionNotStartedError: Self = Self(46);
    #[doc(alias = "NSXMLParserProcessingInstructionNotFinishedError")]
    pub const ProcessingInstructionNotFinishedError: Self = Self(47);
    #[doc(alias = "NSXMLParserNotationNotStartedError")]
    pub const NotationNotStartedError: Self = Self(48);
    #[doc(alias = "NSXMLParserNotationNotFinishedError")]
    pub const NotationNotFinishedError: Self = Self(49);
    #[doc(alias = "NSXMLParserAttributeListNotStartedError")]
    pub const AttributeListNotStartedError: Self = Self(50);
    #[doc(alias = "NSXMLParserAttributeListNotFinishedError")]
    pub const AttributeListNotFinishedError: Self = Self(51);
    #[doc(alias = "NSXMLParserMixedContentDeclNotStartedError")]
    pub const MixedContentDeclNotStartedError: Self = Self(52);
    #[doc(alias = "NSXMLParserMixedContentDeclNotFinishedError")]
    pub const MixedContentDeclNotFinishedError: Self = Self(53);
    #[doc(alias = "NSXMLParserElementContentDeclNotStartedError")]
    pub const ElementContentDeclNotStartedError: Self = Self(54);
    #[doc(alias = "NSXMLParserElementContentDeclNotFinishedError")]
    pub const ElementContentDeclNotFinishedError: Self = Self(55);
    #[doc(alias = "NSXMLParserXMLDeclNotStartedError")]
    pub const XMLDeclNotStartedError: Self = Self(56);
    #[doc(alias = "NSXMLParserXMLDeclNotFinishedError")]
    pub const XMLDeclNotFinishedError: Self = Self(57);
    #[doc(alias = "NSXMLParserConditionalSectionNotStartedError")]
    pub const ConditionalSectionNotStartedError: Self = Self(58);
    #[doc(alias = "NSXMLParserConditionalSectionNotFinishedError")]
    pub const ConditionalSectionNotFinishedError: Self = Self(59);
    #[doc(alias = "NSXMLParserExternalSubsetNotFinishedError")]
    pub const ExternalSubsetNotFinishedError: Self = Self(60);
    #[doc(alias = "NSXMLParserDOCTYPEDeclNotFinishedError")]
    pub const DOCTYPEDeclNotFinishedError: Self = Self(61);
    #[doc(alias = "NSXMLParserMisplacedCDATAEndStringError")]
    pub const MisplacedCDATAEndStringError: Self = Self(62);
    #[doc(alias = "NSXMLParserCDATANotFinishedError")]
    pub const CDATANotFinishedError: Self = Self(63);
    #[doc(alias = "NSXMLParserMisplacedXMLDeclarationError")]
    pub const MisplacedXMLDeclarationError: Self = Self(64);
    #[doc(alias = "NSXMLParserSpaceRequiredError")]
    pub const SpaceRequiredError: Self = Self(65);
    #[doc(alias = "NSXMLParserSeparatorRequiredError")]
    pub const SeparatorRequiredError: Self = Self(66);
    #[doc(alias = "NSXMLParserNMTOKENRequiredError")]
    pub const NMTOKENRequiredError: Self = Self(67);
    #[doc(alias = "NSXMLParserNAMERequiredError")]
    pub const NAMERequiredError: Self = Self(68);
    #[doc(alias = "NSXMLParserPCDATARequiredError")]
    pub const PCDATARequiredError: Self = Self(69);
    #[doc(alias = "NSXMLParserURIRequiredError")]
    pub const URIRequiredError: Self = Self(70);
    #[doc(alias = "NSXMLParserPublicIdentifierRequiredError")]
    pub const PublicIdentifierRequiredError: Self = Self(71);
    #[doc(alias = "NSXMLParserLTRequiredError")]
    pub const LTRequiredError: Self = Self(72);
    #[doc(alias = "NSXMLParserGTRequiredError")]
    pub const GTRequiredError: Self = Self(73);
    #[doc(alias = "NSXMLParserLTSlashRequiredError")]
    pub const LTSlashRequiredError: Self = Self(74);
    #[doc(alias = "NSXMLParserEqualExpectedError")]
    pub const EqualExpectedError: Self = Self(75);
    #[doc(alias = "NSXMLParserTagNameMismatchError")]
    pub const TagNameMismatchError: Self = Self(76);
    #[doc(alias = "NSXMLParserUnfinishedTagError")]
    pub const UnfinishedTagError: Self = Self(77);
    #[doc(alias = "NSXMLParserStandaloneValueError")]
    pub const StandaloneValueError: Self = Self(78);
    #[doc(alias = "NSXMLParserInvalidEncodingNameError")]
    pub const InvalidEncodingNameError: Self = Self(79);
    #[doc(alias = "NSXMLParserCommentContainsDoubleHyphenError")]
    pub const CommentContainsDoubleHyphenError: Self = Self(80);
    #[doc(alias = "NSXMLParserInvalidEncodingError")]
    pub const InvalidEncodingError: Self = Self(81);
    #[doc(alias = "NSXMLParserExternalStandaloneEntityError")]
    pub const ExternalStandaloneEntityError: Self = Self(82);
    #[doc(alias = "NSXMLParserInvalidConditionalSectionError")]
    pub const InvalidConditionalSectionError: Self = Self(83);
    #[doc(alias = "NSXMLParserEntityValueRequiredError")]
    pub const EntityValueRequiredError: Self = Self(84);
    #[doc(alias = "NSXMLParserNotWellBalancedError")]
    pub const NotWellBalancedError: Self = Self(85);
    #[doc(alias = "NSXMLParserExtraContentError")]
    pub const ExtraContentError: Self = Self(86);
    #[doc(alias = "NSXMLParserInvalidCharacterInEntityError")]
    pub const InvalidCharacterInEntityError: Self = Self(87);
    #[doc(alias = "NSXMLParserParsedEntityRefInInternalError")]
    pub const ParsedEntityRefInInternalError: Self = Self(88);
    #[doc(alias = "NSXMLParserEntityRefLoopError")]
    pub const EntityRefLoopError: Self = Self(89);
    #[doc(alias = "NSXMLParserEntityBoundaryError")]
    pub const EntityBoundaryError: Self = Self(90);
    #[doc(alias = "NSXMLParserInvalidURIError")]
    pub const InvalidURIError: Self = Self(91);
    #[doc(alias = "NSXMLParserURIFragmentError")]
    pub const URIFragmentError: Self = Self(92);
    #[doc(alias = "NSXMLParserNoDTDError")]
    pub const NoDTDError: Self = Self(94);
    #[doc(alias = "NSXMLParserDelegateAbortedParseError")]
    pub const DelegateAbortedParseError: Self = Self(512);
}

unsafe impl Encode for NSXMLParserError {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSXMLParserError {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}
