/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.netbeans.core.windows.view.dnd.TopComponentDraggable;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public final class MoveWindowAction
extends AbstractAction
implements PropertyChangeListener {
    private final TopComponent tc;

    public MoveWindowAction() {
        this((TopComponent)null);
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
    }

    public MoveWindowAction(TopComponent topComponent) {
        this.putValue("Name", NbBundle.getMessage(ActionUtils.class, (String)"CTL_MoveWindowAction"));
        this.tc = topComponent;
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateEnabled();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MoveWindowAction.this.updateEnabled();
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.updateEnabled();
        if (!this.isEnabled()) {
            return;
        }
        TopComponent topComponent = this.getTCToWorkWith();
        if (null == topComponent) {
            return;
        }
        WindowManagerImpl.getInstance().userStartedKeyboardDragAndDrop(new TopComponentDraggable(topComponent));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("activated".equals(propertyChangeEvent.getPropertyName())) {
            this.updateEnabled();
        }
    }

    private void updateEnabled() {
        TopComponent topComponent = this.getTCToWorkWith();
        if (null == topComponent) {
            this.setEnabled(false);
            return;
        }
        ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
        if (null == modeImpl || WindowManagerImpl.getInstance().getCurrentMaximizedMode() != null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    private TopComponent getTCToWorkWith() {
        if (null != this.tc) {
            return this.tc;
        }
        return TopComponent.getRegistry().getActivated();
    }

    @Override
    public void putValue(String string, Object object) {
        if ("AcceleratorKey".equals(string)) {
            ActionUtils.putSharedAccelerator("MoveWindow", object);
        } else {
            super.putValue(string, object);
        }
    }

    @Override
    public Object getValue(String string) {
        if ("AcceleratorKey".equals(string)) {
            return ActionUtils.getSharedAccelerator("MoveWindow");
        }
        return super.getValue(string);
    }
}

