/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import javax.swing.GrayFilter;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.ErrorManager;

public class ImageWidget
extends Widget {
    private Image image;
    private Image disabledImage;
    private int width;
    private int height;
    private boolean paintAsDisabled;
    private ImageObserver observer = new ImageObserver(){

        @Override
        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            ImageWidget.this.setImageCore(ImageWidget.this.image);
            ImageWidget.this.getScene().validate();
            return (n & 0xC0) == 0;
        }
    };

    public ImageWidget(Scene scene) {
        super(scene);
    }

    public ImageWidget(Scene scene, Image image) {
        super(scene);
        this.setImage(image);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        if (this.image == image) {
            return;
        }
        this.setImageCore(image);
    }

    private void setImageCore(Image image) {
        if (image == this.image) {
            return;
        }
        int n = this.width;
        int n2 = this.height;
        this.image = image;
        this.disabledImage = null;
        this.width = image != null ? image.getWidth(null) : 0;
        int n3 = this.height = image != null ? image.getHeight(null) : 0;
        if (n == this.width && n2 == this.height) {
            this.repaint();
        } else {
            this.revalidate();
        }
    }

    public boolean isPaintAsDisabled() {
        return this.paintAsDisabled;
    }

    public void setPaintAsDisabled(boolean bl) {
        boolean bl2 = this.paintAsDisabled != bl;
        this.paintAsDisabled = bl;
        if (bl2) {
            this.repaint();
        }
    }

    @Override
    protected Rectangle calculateClientArea() {
        if (this.image != null) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        return super.calculateClientArea();
    }

    @Override
    protected void paintWidget() {
        if (this.image == null) {
            return;
        }
        Graphics2D graphics2D = this.getGraphics();
        if (this.image != null) {
            if (this.paintAsDisabled) {
                if (this.disabledImage == null) {
                    this.disabledImage = GrayFilter.createDisabledImage(this.image);
                    MediaTracker mediaTracker = new MediaTracker(this.getScene().getView());
                    mediaTracker.addImage(this.disabledImage, 0);
                    try {
                        mediaTracker.waitForAll();
                    }
                    catch (InterruptedException interruptedException) {
                        ErrorManager.getDefault().notify((Throwable)interruptedException);
                    }
                }
                graphics2D.drawImage(this.disabledImage, 0, 0, this.observer);
            } else {
                graphics2D.drawImage(this.image, 0, 0, this.observer);
            }
        }
    }
}

