/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters.jq;

import java.util.Collections;
import java.util.List;
import org.testng.ISuite;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.jq.BaseMultiSuitePanel;
import org.testng.reporters.jq.Model;

public class GroupPanel
extends BaseMultiSuitePanel {
    public GroupPanel(Model model) {
        super(model);
    }

    @Override
    public String getPrefix() {
        return "group-";
    }

    @Override
    public String getHeader(ISuite iSuite) {
        return "Groups for " + iSuite.getName();
    }

    @Override
    public String getContent(ISuite iSuite, XMLStringBuffer xMLStringBuffer) {
        XMLStringBuffer xMLStringBuffer2 = new XMLStringBuffer(xMLStringBuffer.getCurrentIndent());
        List<String> list = this.getModel().getGroups(iSuite.getName());
        Collections.sort(list);
        for (String string : list) {
            xMLStringBuffer2.push("div", "class", "test-group");
            xMLStringBuffer2.addRequired("span", string, "class", "test-group-name");
            xMLStringBuffer2.addEmptyElement("br");
            List<String> list2 = this.getModel().getMethodsInGroup(string);
            for (String string2 : list2) {
                xMLStringBuffer2.push("div", "class", "method-in-group");
                xMLStringBuffer2.addRequired("span", string2, "class", "method-in-group-name");
                xMLStringBuffer2.addEmptyElement("br");
                xMLStringBuffer2.pop("div");
            }
            xMLStringBuffer2.pop("div");
        }
        return xMLStringBuffer2.toXML();
    }

    @Override
    public String getNavigatorLink(ISuite iSuite) {
        return GroupPanel.pluralize(this.getModel().getGroups(iSuite.getName()).size(), "group");
    }
}

