# 0.0.15

**Version:** 0.0.15
**Published:** 2022-08-20T14:19:32Z

## Release Notes

## Highlights
* `stty` is now partially implemented (https://github.com/uutils/coreutils/pull/3672). We now finally have implementations for all the coreutils!
* `tail` now implements `--follow` and has seen many more improvements thanks to the giant refactor by @jhscheer.
* `wc` and `sum` have gotten performance improvements by @resistor.
* There have been refactors, fixes and performance improvements in many utils.

## GNU test suite compatibility
Many utils have seen minor changes to improve GNU compatibility. This marks the first release where we pass more tests than we fail. See https://github.com/uutils/coreutils-tracking/ for more details

| result | 0.0.14 | 0.0.15 | change |
|--------|-------:|------:|-------:|
| pass   | 242    | 293   |    +51 |
| skip   | 73     | 73    |      0 |
| fail   | 270    | 222   |    -48 |
| error  | 8      | 5     |     -3 |

## Changes
The PR's listed below are a selection of all the contributions in this release.

### `basename`
* Simple format arguments by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3736

### `basenc`
* Fix error code on wrong usage by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3743

### `comm`
* Use `NUL` if delimiter is empty by @cakebaker in https://github.com/uutils/coreutils/pull/3701

### `cp`
* Correctly copy attributes of a dangling symbolic link by @jfinkels in https://github.com/uutils/coreutils/pull/3692
* Implement `--sparse` flag by @pimzero in https://github.com/uutils/coreutils/pull/3766
* Make `--b=simple` protective of source by @philgebhardt in https://github.com/uutils/coreutils/pull/3647
* Truncate destination when `--reflink` is set by @pimzero in https://github.com/uutils/coreutils/pull/3759
* Fix `test_copy_through_dangling_symlink_no_dereference_permissions` by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3789

### `cut`
* Fix argument parsing for the delimiter by @jhscheer in https://github.com/uutils/coreutils/pull/3607

### `dd`
* Error message of invalid args is matched with GNU by @Fuchczyk in https://github.com/uutils/coreutils/pull/3831
* Fix output issues by @patricksjackson in https://github.com/uutils/coreutils/pull/3610
* Only print concise byte counts if count is sufficiently large by @jfinkels in https://github.com/uutils/coreutils/pull/3617
* Reuse buffer for the most common cases by @patricksjackson in https://github.com/uutils/coreutils/pull/3600
* Fix broken pipe in `test_bytes_oseek_bytes_trunc_oflag` by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3797

### `df`
* Better error message when executed in a chroot without `/proc` by @lendandgit in https://github.com/uutils/coreutils/pull/3602
* Fix output if input path is device name by @cakebaker in https://github.com/uutils/coreutils/pull/3682
* Fix rounding behavior in humanreadable mode by @cakebaker in https://github.com/uutils/coreutils/pull/3554
* Read block size from env vars by @cakebaker in https://github.com/uutils/coreutils/pull/3504
* Show "total" label in correct column by @jfinkels in https://github.com/uutils/coreutils/pull/3579
* Trim size header in tests by @cakebaker in https://github.com/uutils/coreutils/pull/3582
* Implement the `--sync` flag for df by @anastygnome in https://github.com/uutils/coreutils/pull/3592

### `dircolors`
* Add support for stdin by @jhscheer in https://github.com/uutils/coreutils/pull/3591
* Escape `'` and `:` by @cakebaker in https://github.com/uutils/coreutils/pull/3639
* Implement `--print-ls-colors` by @cakebaker in https://github.com/uutils/coreutils/pull/3566
* Make `-b` & `-c` args overridable by @cakebaker in https://github.com/uutils/coreutils/pull/3569
* Update error message by @cakebaker in https://github.com/uutils/coreutils/pull/3596

### `dirname`
* Add missing `"\n\"` to usage message by @cakebaker in https://github.com/uutils/coreutils/pull/3570

### `du`
* Remove unnecessary spaces from help by @cakebaker in https://github.com/uutils/coreutils/pull/3622
* Add `parse_glob` module and update `du` to use `parse_glob` by @ackerleytng in https://github.com/uutils/coreutils/pull/3754

### `expand`
* Add support for `--tabs` shortcuts by @cakebaker in https://github.com/uutils/coreutils/pull/3612
* Allow multiple `tabs` args by @cakebaker in https://github.com/uutils/coreutils/pull/3585
* Show error if `--tabs` arg has invalid chars by @cakebaker in https://github.com/uutils/coreutils/pull/3583
* Allow specifier only with last value by @cakebaker in https://github.com/uutils/coreutils/pull/3595
* Handle too large tab size by @cakebaker in https://github.com/uutils/coreutils/pull/3594
* Remove empty line from error message by @cakebaker in https://github.com/uutils/coreutils/pull/3577
* Simplify signature of `expand_shortcuts()` by @cakebaker in https://github.com/uutils/coreutils/pull/3644

### `hashsum`
* Isolate non-"GNU Coreutils" options by @str4d in https://github.com/uutils/coreutils/pull/3593
* Fix the `-c` usage by @sylvestre in https://github.com/uutils/coreutils/pull/3816

### `install`
* Verbose messages shows ginstall as command by @sylvestre in https://github.com/uutils/coreutils/pull/3651
* Fix install `-C` test by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3663
* Make `install -V` show the filename  by @ElijahSink in https://github.com/uutils/coreutils/pull/3657

### `ln`
* Improve error messages compatibility by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3730
* Implement `-L` `-P` to make tests/ln/hard-to-sym.sh work by @sylvestre in https://github.com/uutils/coreutils/pull/3563
* Symlink --force, src and dst are same file by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3724

### `ls`, `dir` & `vdir`
* Add already listed message by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3707
* Fix double quoting when color is enabled by @tertsdiepraam in https://github.com/uutils/coreutils/pull/3590
* Implement `--zero` by @pimzero in https://github.com/uutils/coreutils/pull/3746
* Remove trailing space when using the comma format (`-m`) by @anastygnome in https://github.com/uutils/coreutils/pull/3615
* Silently ignore `-T` option by @Stonks3141 in https://github.com/uutils/coreutils/pull/3718
* Forbid octal numbers for width parameter by @Ganneff in https://github.com/uutils/coreutils/pull/3613

### `mktemp`
* Change directory permission after creation by @353fc443 in https://github.com/uutils/coreutils/pull/3471
* Combine `--tmpdir` and subdirectory info by @jfinkels in https://github.com/uutils/coreutils/pull/3568
* Error on empty `--suffix` in some situations by @jfinkels in https://github.com/uutils/coreutils/pull/3599
* Exit with status `1` on usage errors by @jfinkels in https://github.com/uutils/coreutils/pull/3578
* Include suffix in error message by @jfinkels in https://github.com/uutils/coreutils/pull/3551
* Only replace last contiguous block of Xs by @jfinkels in https://github.com/uutils/coreutils/pull/3586
* Respect `POSIXLY_CORRECT` env var when parsing args by @weijunji in https://github.com/uutils/coreutils/pull/3604
* Simplify file path parameter logic by @jfinkels in https://github.com/uutils/coreutils/pull/3573

### `mv`
* Fix error when moving directory to itself by @Fuchczyk in https://github.com/uutils/coreutils/pull/3809

### `numfmt`
* Implement `--format` by @cakebaker in https://github.com/uutils/coreutils/pull/3751
* Implement `--to-unit` & `--from-unit` by @cakebaker in https://github.com/uutils/coreutils/pull/3705
* Preserve trailing zeros by @cakebaker in https://github.com/uutils/coreutils/pull/3764
* Don't round floats if `--from` is `none` by @cakebaker in https://github.com/uutils/coreutils/pull/3742
* Reject suffix if unit is `none` by @cakebaker in https://github.com/uutils/coreutils/pull/3716
* Remove duplicate default hints from help by @cakebaker in https://github.com/uutils/coreutils/pull/3696
* Show `invalid suffix` error for `i` suffix by @cakebaker in https://github.com/uutils/coreutils/pull/3732
* Show error if `--padding` is zero by @cakebaker in https://github.com/uutils/coreutils/pull/3686
* Show error if `i` suffix is missing by @cakebaker in https://github.com/uutils/coreutils/pull/3713

### `paste`
* Implement `-z` flag by @cakebaker in https://github.com/uutils/coreutils/pull/3659

### `readlink`
* Improve GNU compatibility by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3826
* Symlink loop handling by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3717

### `realpath`
* Relative options by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3710
* Improve symlink handling by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3703
* Add `--no-symlinks` alias by @cakebaker in https://github.com/uutils/coreutils/pull/3681

### `rm`
* Fix help text mistakenly being used as the long option by @tertsdiepraam in https://github.com/uutils/coreutils/pull/3670

### `shuf`
* Add missing spaces to about text by @cakebaker in https://github.com/uutils/coreutils/pull/3677
* Improve performance by @Garfield96 in https://github.com/uutils/coreutils/pull/3642

### `sort`
* Wait when SIGINT was raised for the program to finish properly by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3801

### `sum`
* Speed up sum by using reasonable read buffer sizes. by @resistor in https://github.com/uutils/coreutils/pull/3741

### `split`
* Don't overwrite files by @andrewbaptist in https://github.com/uutils/coreutils/pull/3719
* Set names for arg values by @cakebaker in https://github.com/uutils/coreutils/pull/3541
* Don't skip chucking when the chunk size is a divisor of the buffer size by @resistor in https://github.com/uutils/coreutils/pull/3800

### `stty`
* Initial implementation by @tertsdiepraam in https://github.com/uutils/coreutils/pull/3672

### `tail`
* Implement `--follow` and much more by @jhscheer in https://github.com/uutils/coreutils/pull/2695
* Rework platform module by @anastygnome in https://github.com/uutils/coreutils/pull/3706
* Fix race condition by @jhscheer in https://github.com/uutils/coreutils/pull/3798
* Reduce CPU load for polling by @jhscheer in https://github.com/uutils/coreutils/pull/3618
* Reuse opened file `--follow=descriptor` by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3830

### `tee`
* Implement `-p` by @eds-collabora in https://github.com/uutils/coreutils/pull/3656

### `touch`
* Fix trailing slashes handling by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3788

### `true` & `false`
* Use `clap::ArgAction` for `--help` and `--version` by @jarkonik in https://github.com/uutils/coreutils/pull/3784

### `tty`
* Move from `libc` to `nix` by @tertsdiepraam in https://github.com/uutils/coreutils/pull/3838

### `unexpand`
* Handle too large `tabs` arguments by @cakebaker in https://github.com/uutils/coreutils/pull/3655
* Implement `tabs` shortcuts by @cakebaker in https://github.com/uutils/coreutils/pull/3646
* Set value name of arg by @cakebaker in https://github.com/uutils/coreutils/pull/3605

### `uniq`
* Set default missing value for `group` and `all-repeated` args by @cakebaker in https://github.com/uutils/coreutils/pull/3667

### `wc`
* Specialize scanning loop on settings. by @resistor in https://github.com/uutils/coreutils/pull/3708
* Implement a fast path for character counting in wc. by @resistor in https://github.com/uutils/coreutils/pull/3735
* Implement wc fast paths that skip Unicode decoding. by @resistor in https://github.com/uutils/coreutils/pull/3740
* Fix wc gnu test suite compatibility  by @anastygnome in https://github.com/uutils/coreutils/pull/3688

### `uucore`
* Create `help_section` macro by @tertsdiepraam in https://github.com/uutils/coreutils/pull/3180
* Refactor, document and test `ranges` module by @tertsdiepraam in https://github.com/uutils/coreutils/pull/3844
* Remove `show_error_custom_description` macros `show_usage_error` by @tertsdiepraam in https://github.com/uutils/coreutils/pull/3837
* Add backport for `Path::is_symlink()` by @jfinkels in https://github.com/uutils/coreutils/pull/3697
* Fix invalid enum variant in docstring by @cakebaker in https://github.com/uutils/coreutils/pull/3643
* Simplify invalid encoding handling by @tertsdiepraam in https://github.com/uutils/coreutils/pull/3832
* canonicalize: Loop looking in windows by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3714

### General
* Netbsd / OpenBSD build fix by @devnexen in https://github.com/uutils/coreutils/pull/3807
* Add more consistency in the `--help` output and declarations by @sylvestre in https://github.com/uutils/coreutils/pull/3774
* dependencies: make `winapi` dependency only for Windows by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3846
* tests: fix Freebsd test failures by @jhscheer in https://github.com/uutils/coreutils/pull/3777
* tests: ignore failing tests for FreeBSD by @jhscheer in https://github.com/uutils/coreutils/pull/3806
* Replace lazy_static with once_cell by @Sciencentistguy in https://github.com/uutils/coreutils/pull/3704
* README: add badge for MSRV by @jhscheer in https://github.com/uutils/coreutils/pull/3799
* Remove use of `mem::uninitialized` by @5225225 in https://github.com/uutils/coreutils/pull/3808
* Remove deprecated `clap` functions by @cakebaker in https://github.com/uutils/coreutils/pull/3768, https://github.com/uutils/coreutils/pull/3850, https://github.com/uutils/coreutils/pull/3848, https://github.com/uutils/coreutils/pull/3804 & https://github.com/uutils/coreutils/pull/3771

## New Contributors
@weijunji (https://github.com/uutils/coreutils/pull/3604), @str4d (https://github.com/uutils/coreutils/pull/3593), @patricksjackson (https://github.com/uutils/coreutils/pull/3600), @Ganneff (https://github.com/uutils/coreutils/pull/3613), @Garfield96 (https://github.com/uutils/coreutils/pull/3642), @philgebhardt (https://github.com/uutils/coreutils/pull/3647), @ElijahSink (https://github.com/uutils/coreutils/pull/3657), @niyaznigmatullin (https://github.com/uutils/coreutils/pull/3663), @eds-collabora (https://github.com/uutils/coreutils/pull/3656), @lendandgit (https://github.com/uutils/coreutils/pull/3602), @resistor (https://github.com/uutils/coreutils/pull/3708), @andrewbaptist (https://github.com/uutils/coreutils/pull/3720), @Stonks3141 (https://github.com/uutils/coreutils/pull/3718), @pimzero (https://github.com/uutils/coreutils/pull/3746), @Fuchczyk (https://github.com/uutils/coreutils/pull/3809), @5225225 (https://github.com/uutils/coreutils/pull/3808), @jarkonik (https://github.com/uutils/coreutils/pull/3784)

**Full Changelog**: https://github.com/uutils/coreutils/compare/0.0.14...0.0.15
