# 0.0.23

**Version:** 0.0.23
**Published:** 2023-11-14T12:36:32Z

## Release Notes

📦 **Rust Coreutils 0.0.23 Release:**

We've got +10 more GNU tests passing than in our last release.

24 developers contributed to this release (9 new contributors started with this release).

Visit our website at [https://uutils.github.io](https://uutils.github.io).

If you want to help us, please consider sponsoring on GitHub. This helps us use better tools like GitHub Actions. Sponsor us at [https://github.com/sponsors/uutils](https://github.com/sponsors/uutils).

## GNU test suite compatibility

Here's how version 0.0.23 compares to the previous release - running GNU/Coreutils 9.4:

| result | 0.0.22 | 0.0.23 | Change 0.0.22 to 0.0.23 | % Total 0.0.23 (Change)    |
|--------|-------:|-------:|------------------------:|--------------------------:|
| pass   |    383 |    393 |                     +10 |          65.07% (+1.66%)  |
| skip   |     48 |     49 |                      +1 |           8.11% (+0.17%)  |
| fail   |    171 |    160 |                    -11  |          26.49% (-1.82%)  |
| error  |      2 |      2 |                      0  |           0.33% (0.00%)   |


![GNU testsuite evolution](https://github.com/uutils/coreutils-tracking/blob/main/gnu-results.png?raw=true)

For more details, visit [https://github.com/uutils/coreutils-tracking/](https://github.com/uutils/coreutils-tracking/).

## What's Changed

### global
* Implement SI prefixes R and Q by @zhitkoff in https://github.com/uutils/coreutils/pull/5357
  This applies to the commands: dd, df, du, head, ls, od, shref, split, tail and truncate

### cat
* cat: use error code 62 for ELOOP on FreeBSD by @cakebaker in https://github.com/uutils/coreutils/pull/5477
* cat: return the same error message as GNU with loop symlink by @sylvestre in https://github.com/uutils/coreutils/pull/5466

### cp
* cp: make test_closes_file_descriptors Linux-only by @cakebaker in https://github.com/uutils/coreutils/pull/5508
* cp: fix cp -rT dir dir2 leads to different result than with GNU cp by @tommady in https://github.com/uutils/coreutils/pull/5467
* cp: restrict two test functions to linux/mac/win by @cakebaker in https://github.com/uutils/coreutils/pull/5471
* cp: remove `crash!` call by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5486
* cp --remove-destination: don't fail if destination is symlink to source by @cakebaker in https://github.com/uutils/coreutils/pull/5430
* cp: add test for --attributes-only by @cakebaker in https://github.com/uutils/coreutils/pull/5458
* cp: fix cp -a --no-preserve=mode doesn't keep fully the mode by @tommady in https://github.com/uutils/coreutils/pull/5353
* cp,tail: fix warnings in tests on Android by @cakebaker in https://github.com/uutils/coreutils/pull/5496

### dd
* dd: Do not use the OS provided dd utility on FIFOs by @n1000 in https://github.com/uutils/coreutils/pull/5453

### df
* freebsd: fix the 'df' command by @kostikbel in https://github.com/uutils/coreutils/pull/5462
* df: Replace the error message by the one generated by clap by @sylvestre in https://github.com/uutils/coreutils/pull/5452

### du
* du: make -l/--count-links work by @cakebaker in https://github.com/uutils/coreutils/pull/5493
* du: remove crash! macro by @alexhausen in https://github.com/uutils/coreutils/pull/5501
* du: add --no-dereference by @cakebaker in https://github.com/uutils/coreutils/pull/5491
* du: ignore test under Android & FreeBSD by @cakebaker in https://github.com/uutils/coreutils/pull/5497
* du: use blocks to remove some cfgs by @cakebaker in https://github.com/uutils/coreutils/pull/5504
* du: add -H (alias for --dereference-args) by @cakebaker in https://github.com/uutils/coreutils/pull/5506

### expand
* expand: remove crash! macro by @ceteece in https://github.com/uutils/coreutils/pull/5510

### expr
* expr: return 0 for `"" \| ""` by @Luv-Ray in https://github.com/uutils/coreutils/pull/5416

### join
* join: remove a clippy::cognitive_complexity by moving some content in functions by @sylvestre in https://github.com/uutils/coreutils/pull/5367

### ls
* ls --dired -R: fix the positions  by @sylvestre in https://github.com/uutils/coreutils/pull/5341
* ls --dired: document the whole thing by @sylvestre in https://github.com/uutils/coreutils/pull/5432
* ls: update of the GNU test error output by @sylvestre in https://github.com/uutils/coreutils/pull/5438
* ls: return exit code 2 for invalid time-style by @cakebaker in https://github.com/uutils/coreutils/pull/5447
* ls: use try_get_matches_from instead of get_matches_from by @cakebaker in https://github.com/uutils/coreutils/pull/5446

### mktemp
* mktemp: add func to expose functionality (for use in nushell) by @tskinn in https://github.com/uutils/coreutils/pull/5479

### mv
* mv: make UpdateMode public by @dmatos2012 in https://github.com/uutils/coreutils/pull/5428
* mv: Fix stderr output mv file into dir and dir into file where both are files by @mickvangelderen in https://github.com/uutils/coreutils/pull/5464
* mv: rename canonized_* -> canonicalized_* by @cakebaker in https://github.com/uutils/coreutils/pull/5454
* mv: moving directory itself should fail by @dmatos2012 in https://github.com/uutils/coreutils/pull/5429

### pathchk
* pathchk: check empty path by default by @Luv-Ray in https://github.com/uutils/coreutils/pull/5423

### pr
* pr: skip a test for now for way too long log by @sylvestre in https://github.com/uutils/coreutils/pull/5440

### printf
* printf: support %q by @Luv-Ray in https://github.com/uutils/coreutils/pull/5514

### rm
* rm: In some cases, remove_dir is doing a better job than remove_dir_all by @sylvestre in https://github.com/uutils/coreutils/pull/5403
* rm: refactor `prompt_file`, issue #5345 by @terade in https://github.com/uutils/coreutils/pull/5356
* rm: adjust fail-2eperm.sh - gnu test by @sylvestre in https://github.com/uutils/coreutils/pull/5435

### runcon
* runcon: generate the same error as GNUs by @sylvestre in https://github.com/uutils/coreutils/pull/5439

### split
* split: suffix auto length by @zhitkoff in https://github.com/uutils/coreutils/pull/5433
* split : `--filter` and stdin updates by @zhitkoff in https://github.com/uutils/coreutils/pull/5418
* split: suffix length refactor by @zhitkoff in https://github.com/uutils/coreutils/pull/5449

### test
* test: use mtime for -ot and fix direction of comparison by @n1000 in https://github.com/uutils/coreutils/pull/5441

### Other OS & arch changes
* Add darwin arm64 builds by @dzbarsky in https://github.com/uutils/coreutils/pull/5523
* Add support in uucore for illumos and solaris by @bbarker in https://github.com/uutils/coreutils/pull/5489

### CI

* ci: remove outdated comment by @cakebaker in https://github.com/uutils/coreutils/pull/5525
* deny.toml: remove two entries from skip list by @cakebaker in https://github.com/uutils/coreutils/pull/5478

### Documentation
* doc: add a missing "a" by @cakebaker in https://github.com/uutils/coreutils/pull/5413
* Expand CONTRIBUTING.md (WIP) by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5488
* CONTRIBUTING.md: spell-checker:ignore "rustdoc's" by @cakebaker in https://github.com/uutils/coreutils/pull/5512
* doc: mention "-v/--verbose" as extension of du by @cakebaker in https://github.com/uutils/coreutils/pull/5436
* uucore: remove incorrect comment by @cakebaker in https://github.com/uutils/coreutils/pull/5422
* Remove "last synced with" comments by @cakebaker in https://github.com/uutils/coreutils/pull/5469

## Security
* fuzzing: Refactor the error management by @sylvestre in https://github.com/uutils/coreutils/pull/5517
* fuzz: Move a duplicate function into fuzz_common by @sylvestre in https://github.com/uutils/coreutils/pull/5524
* github action: split the run of the fuzzers by @tommady in https://github.com/uutils/coreutils/pull/5444
* fuzz: use parse_size_u64 by @Luv-Ray in https://github.com/uutils/coreutils/pull/5470
* fuzz: set LC_COLLATE=C for expr by @cakebaker in https://github.com/uutils/coreutils/pull/5419

## Various improvements
* Prepare version 0.0.23 by @sylvestre in https://github.com/uutils/coreutils/pull/5529
* Fix clippy::implicit_clone by @Statheres in https://github.com/uutils/coreutils/pull/5494

## Dependencies
* Bump const-random from 0.1.15 to 0.1.16 by @cakebaker in https://github.com/uutils/coreutils/pull/5445
* fix(deps): update rust crate dns-lookup to 2.0.4 by @renovate in https://github.com/uutils/coreutils/pull/5412
* chore(deps): update rust crate regex to 1.10.2 by @renovate in https://github.com/uutils/coreutils/pull/5415
* Bump rustix crates by @cakebaker in https://github.com/uutils/coreutils/pull/5425
* chore(deps): update rust crate bytecount to 0.6.5 by @renovate in https://github.com/uutils/coreutils/pull/5442
* chore(deps): update rust crate bytecount to 0.6.7 by @renovate in https://github.com/uutils/coreutils/pull/5450
* chore(deps): update rust crate tempfile to 3.8.1 by @renovate in https://github.com/uutils/coreutils/pull/5461
* chore(deps): update actions/github-script action to v7 by @renovate in https://github.com/uutils/coreutils/pull/5528
* chore(deps): update rust crate libc to 0.2.150 by @renovate in https://github.com/uutils/coreutils/pull/5498
* chore(deps): update rust crate procfs to 0.16 by @renovate in https://github.com/uutils/coreutils/pull/5474
* chore(deps): update rust crate bstr to 1.8 by @renovate in https://github.com/uutils/coreutils/pull/5518
* chore(deps): update rust crate self_cell to 1.0.2 by @renovate in https://github.com/uutils/coreutils/pull/5520

## New Contributors
* @terade made their first contribution in https://github.com/uutils/coreutils/pull/5356
* @n1000 made their first contribution in https://github.com/uutils/coreutils/pull/5441
* @mickvangelderen made their first contribution in https://github.com/uutils/coreutils/pull/5464
* @kostikbel made their first contribution in https://github.com/uutils/coreutils/pull/5462
* @bbarker made their first contribution in https://github.com/uutils/coreutils/pull/5489
* @tskinn made their first contribution in https://github.com/uutils/coreutils/pull/5479
* @alexhausen made their first contribution in https://github.com/uutils/coreutils/pull/5501
* @ceteece made their first contribution in https://github.com/uutils/coreutils/pull/5510
* @dzbarsky made their first contribution in https://github.com/uutils/coreutils/pull/5523

**Full Changelog**: https://github.com/uutils/coreutils/compare/0.0.22...0.0.23
