# 0.0.27

**Version:** 0.0.27
**Published:** 2024-06-23T17:12:21Z

## Release Notes

📦 **Rust Coreutils 0.0.27 Release:**

We are excited to announce the release of Rust Coreutils 0.0.27! This version continues to improve the compatibility.

This update adds +8 GNU passing tests compared to version 0.0.26 and therefore reduces the failing tests by -8.

This release saw contributions from 21 developers, including 9 newcomers.

We encourage you to support our project by sponsoring us on GitHub. Your sponsorship helps us maintain and enhance our infrastructure, such as GitHub Actions. Sponsor us at [https://github.com/sponsors/uutils](https://github.com/sponsors/uutils).

For more details and to download the latest release, visit our website at [https://uutils.github.io](https://uutils.github.io).

## What's Changed


## GNU Test Suite Compatibility
Here’s how version 0.0.27 fares in comparison to the previous release:

| Result        | 0.0.26 | 0.0.27 | Change 0.0.26 to 0.0.27 | % Total 0.0.26 | % Total 0.0.27 | % Change 0.0.26 to 0.0.27 |
|---------------|--------|--------|-------------------------|----------------|----------------|--------------------------|
| Pass          | 447    | 455    | +8                      | 73.04%         | 74.35%         | +1.31%                   |
| Skip          | 44     | 44     | 0                       | 7.19%          | 7.19%          | 0.00%                    |
| Fail          | 121    | 113    | -8                      | 19.77%         | 18.46%         | -1.31%                   |
| Error         | 0      | 0      | 0                       | 0.00%          | 0.00%          | 0.00%                    |

![GNU testsuite evolution](https://github.com/uutils/coreutils-tracking/blob/main/gnu-results.png?raw=true)

For more details, visit [https://github.com/uutils/coreutils-tracking/](https://github.com/uutils/coreutils-tracking/).

### cksum
* Improve the GNU compat by @sylvestre in https://github.com/uutils/coreutils/pull/6256

### cksum/hashsum
* refactor the common code. by @sylvestre in https://github.com/uutils/coreutils/pull/6431
* enable `sum` feature for `checksum` feature by @cakebaker in https://github.com/uutils/coreutils/pull/6450
* Implement check (Closes: #5705) by @sylvestre in https://github.com/uutils/coreutils/pull/6390
* Improve the blake2 --tag export by @sylvestre in https://github.com/uutils/coreutils/pull/6412

### cp
* Added overwrite detection for existing symlinks by @AnirbanHalder654322 in https://github.com/uutils/coreutils/pull/6380
* Changed ``/sys/kernel/address_bits`` to ``/sys/kernel/profiling`` in test_cp   by @AnirbanHalder654322 in https://github.com/uutils/coreutils/pull/6294
* use `#[ignore]` to disable tests by @cakebaker in https://github.com/uutils/coreutils/pull/6395
* remove `target_os = "macos-12"` by @cakebaker in https://github.com/uutils/coreutils/pull/6405
* link-deref gnu test fix by @matrixhead in https://github.com/uutils/coreutils/pull/6378
* parent-perm-race gnu fix by @matrixhead in https://github.com/uutils/coreutils/pull/6403
* gnu test case preserve-mode fix by @matrixhead in https://github.com/uutils/coreutils/pull/6432
* `cp-parents` test case by @matrixhead in https://github.com/uutils/coreutils/pull/6446
* remove panics in tests by @cakebaker in https://github.com/uutils/coreutils/pull/6293

### df
* fix size column padding by @Qelxiros in https://github.com/uutils/coreutils/pull/6433
* fix incorrect test & add another test by @cakebaker in https://github.com/uutils/coreutils/pull/6437

### env
* adds --ignore-signal by @Walid-Kh in https://github.com/uutils/coreutils/pull/6377

### fmt
* accept repeated arguments by @BenWiederhake in https://github.com/uutils/coreutils/pull/6355
* value of minlength should not be negative by @ahmadabd in https://github.com/uutils/coreutils/pull/6359
* fix error priority, make goal-errors more helpful by @BenWiederhake in https://github.com/uutils/coreutils/pull/6362
* use `get_matches_from()` instead of `try_get_matches_from()` in tests by @cakebaker in https://github.com/uutils/coreutils/pull/6374

### id
* Handle repeated flags, recognize conflict between pretty-print and passwd file-entry by @BenWiederhake in https://github.com/uutils/coreutils/pull/6288

### kill
* adding support for handling SIGEXIT by @dcarrier in https://github.com/uutils/coreutils/pull/6269

### ls
* fix quoting alignment, add tests for default quoting style in TTY and quoting alignment by @RenjiSann in https://github.com/uutils/coreutils/pull/6402
* Fix ls: panicking on dangling symlink with ``--color=auto -l`` by @AnirbanHalder654322 in https://github.com/uutils/coreutils/pull/6346

### od
* use `u64::MAX` instead of `max_value()` by @cakebaker in https://github.com/uutils/coreutils/pull/6477
* use TestScenario, avoid spamming /tmp on failure by @BenWiederhake in https://github.com/uutils/coreutils/pull/6287

### pinky
* use UTC if offset can't be determined by @cakebaker in https://github.com/uutils/coreutils/pull/6414

### seq
* fix typo in benchmarking documentation file by @TO19 in https://github.com/uutils/coreutils/pull/6454

### shuf
* use usize::MAX instead of std::usize::MAX by @lcheylus in https://github.com/uutils/coreutils/pull/6482

### sort
* disable clippy::suspicious_open_options on OpenBSD by @lcheylus in https://github.com/uutils/coreutils/pull/6292

### tail
* use `#[ignore]` to disable tests by @cakebaker in https://github.com/uutils/coreutils/pull/6388

### tr
* calculate complement set early by @jalil-salame in https://github.com/uutils/coreutils/pull/6340
* Refuse to translate if set2 contains more than one unique characters and set1 contains a character class by @cvonelm in https://github.com/uutils/coreutils/pull/6472
* A [:lower:]/[:upper:] in set2 must be matched in set1 by @cvonelm in https://github.com/uutils/coreutils/pull/6445
* disallow classes besides [:upper:]/[:lower:] in set2 when translating by @cvonelm in https://github.com/uutils/coreutils/pull/6424
* Refuse to translate if set1 is longer than set2 and set2 ends in a character class by @cvonelm in https://github.com/uutils/coreutils/pull/6470

### uptime
* add `-s`/`--since` of `uptime` to extensions by @cakebaker in https://github.com/uutils/coreutils/pull/6391
* Support files in uptime by @AnirbanHalder654322 in https://github.com/uutils/coreutils/pull/6400

### utmpx
* use UTC if offset can't be resolved by @cakebaker in https://github.com/uutils/coreutils/pull/6413

### Misc
* clippy: fix warnings introduced with Rust 1.78 by @cakebaker in https://github.com/uutils/coreutils/pull/6330
* Disable clippy::assigning_clones on OpenBSD by @lcheylus in https://github.com/uutils/coreutils/pull/6356
* clippy: fix warnings introduced by Rust 1.79 by @cakebaker in https://github.com/uutils/coreutils/pull/6468
* tests: fix some clippy warnings by @sylvestre in https://github.com/uutils/coreutils/pull/6430
* Disabling compare_xattrs cp and mv related tests on OpenBSD by @jadijadi in https://github.com/uutils/coreutils/pull/6368
* src/uucore/src/lib/features/fsext.rs: Add magic for bcachefs by @phedders in https://github.com/uutils/coreutils/pull/6438
* tests: remove all `#[cfg(not(target_pointer_width = "128"))]` by @cakebaker in https://github.com/uutils/coreutils/pull/6418
* Cargo.toml: enable uucore's `mode` feature by @cakebaker in https://github.com/uutils/coreutils/pull/6421
* uucore: remove support for Bitrig by @cakebaker in https://github.com/uutils/coreutils/pull/6383
* everywhere: cleanup unused/unnecessary spellcheck-disabling by @BenWiederhake in https://github.com/uutils/coreutils/pull/6295
* multicall: add --list to list all utils by @tertsdiepraam in https://github.com/uutils/coreutils/pull/6251
* config terminal simulation for specific stdios only by @cre4ture in https://github.com/uutils/coreutils/pull/6125
* fix code coverage windows by @piotrkwiecinski in https://github.com/uutils/coreutils/pull/6332
### CI
* macos-latest is now arm64 by @thesayyn in https://github.com/uutils/coreutils/pull/6425
* stdbuf: rename `dragonflybsd` to `dragonfly` by @cakebaker in https://github.com/uutils/coreutils/pull/6384
* deny.toml: remove hashbrown, update comment by @cakebaker in https://github.com/uutils/coreutils/pull/6373
* show-utils.sh: fix jq query to get coreutils deps by @lcheylus in https://github.com/uutils/coreutils/pull/6485
* deny.toml: allow BSL-1.0 as license by @cakebaker in https://github.com/uutils/coreutils/pull/6427


### Documentation
* docs: describe extensions of id by @cakebaker in https://github.com/uutils/coreutils/pull/6289

### Testing
* tests: fix multi-call test precondition by @BenWiederhake in https://github.com/uutils/coreutils/pull/6279
* Disabling xattrs tests on OpenBSD by @jadijadi in https://github.com/uutils/coreutils/pull/6349
* util: added umask manipulation by @matrixhead in https://github.com/uutils/coreutils/pull/6404
* show-utils.sh: fix jq query to get coreutils deps by @lcheylus in https://github.com/uutils/coreutils/pull/6300

### Dependencies
* Bump `itertools` and fix use of deprecated function by @cakebaker in https://github.com/uutils/coreutils/pull/6455
* Bump `fts-sys` and `selinux-sys` by @cakebaker in https://github.com/uutils/coreutils/pull/6339
* Bump bigdecimal from 0.4.0 to 0.4.2 by @cakebaker in https://github.com/uutils/coreutils/pull/6285
* `ls`: upgrade uutils-term-grid to 0.5 by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5485
* Downgrade `libc` to `0.2.153` by @cakebaker in https://github.com/uutils/coreutils/pull/6408
* fix(deps): update rust crate data-encoding to 2.6 by @renovate in https://github.com/uutils/coreutils/pull/6283
* fix(deps): update rust crate data-encoding-macro to 0.1.15 by @renovate in https://github.com/uutils/coreutils/pull/6282
* fix(deps): update rust crate cpp to 0.5.9 by @renovate in https://github.com/uutils/coreutils/pull/6325
* fix(deps): update rust crate libc to 0.2.154 by @renovate in https://github.com/uutils/coreutils/pull/6326
* fix(deps): update rust crate proc-macro2 to v1.0.82 by @renovate in https://github.com/uutils/coreutils/pull/6372
* fix(deps): update rust crate proc-macro2 to v1.0.83 by @renovate in https://github.com/uutils/coreutils/pull/6416
* fix(deps): update rust crate libc to v0.2.155 by @renovate in https://github.com/uutils/coreutils/pull/6411
* fix(deps): update rust crate proc-macro2 to v1.0.84 by @renovate in https://github.com/uutils/coreutils/pull/6434
* fix(deps): update rust crate proc-macro2 to v1.0.85 by @renovate in https://github.com/uutils/coreutils/pull/6443
* fix(deps): update rust crate proc-macro2 to v1.0.86 by @renovate in https://github.com/uutils/coreutils/pull/6486
* chore(deps): update rust crate serde to v1.0.203 by @renovate in https://github.com/uutils/coreutils/pull/6489
* fix(deps): update rust crate libfuzzer-sys to 0.4.7 by @renovate in https://github.com/uutils/coreutils/pull/6327
* fix(deps): update rust crate quote to 1.0.36 by @renovate in https://github.com/uutils/coreutils/pull/6329
* fix(deps): update rust crate rand to 0.8.5 by @renovate in https://github.com/uutils/coreutils/pull/6334
* fix(deps): update rust crate wild to 2.2.1 by @renovate in https://github.com/uutils/coreutils/pull/6335
* fix(deps): update rust crate proc-macro2 to 1.0.81 by @renovate in https://github.com/uutils/coreutils/pull/6328
* fix(deps): update rust crate similar to 2.5.0 by @renovate in https://github.com/uutils/coreutils/pull/6336
* chore(deps): update rust crate unicode-width to 0.1.12 by @renovate in https://github.com/uutils/coreutils/pull/6277
* chore(deps): update rust crate zip to 1.1.2 by @renovate in https://github.com/uutils/coreutils/pull/6286
* chore(deps): update rust crate libc to 0.2.154 by @renovate in https://github.com/uutils/coreutils/pull/6291
* chore(deps): update rust crate zip to 1.1.3 by @renovate in https://github.com/uutils/coreutils/pull/6296
* chore(deps): update rust crate uutils_term_grid to 0.6 by @renovate in https://github.com/uutils/coreutils/pull/5963
* chore(deps): update rust crate cpp_build to 0.5.9 by @renovate in https://github.com/uutils/coreutils/pull/6303
* chore(deps): update rust crate ctrlc to 3.4.4 by @renovate in https://github.com/uutils/coreutils/pull/6304
* chore(deps): update rust crate filetime to 0.2.23 by @renovate in https://github.com/uutils/coreutils/pull/6305
* chore(deps): update rust crate half to 2.4.1 by @renovate in https://github.com/uutils/coreutils/pull/6307
* chore(deps): update rust crate indicatif to 0.17.8 by @renovate in https://github.com/uutils/coreutils/pull/6308
* chore(deps): update rust crate memchr to 2.7.2 by @renovate in https://github.com/uutils/coreutils/pull/6309
* chore(deps): update rust crate memmap2 to 0.9.4 by @renovate in https://github.com/uutils/coreutils/pull/6310
* chore(deps): update rust crate pretty_assertions to 1.4.0 by @renovate in https://github.com/uutils/coreutils/pull/6311
* chore(deps): update rust crate rand_core to 0.6.4 by @renovate in https://github.com/uutils/coreutils/pull/6312
* chore(deps): update rust crate rand_pcg to 0.3.1 by @renovate in https://github.com/uutils/coreutils/pull/6316
* chore(deps): update rust crate redox_syscall to 0.5.1 by @renovate in https://github.com/uutils/coreutils/pull/6317
* chore(deps): update rust crate selinux to 0.4.4 by @renovate in https://github.com/uutils/coreutils/pull/6318
* chore(deps): update rust crate sha1 to 0.10.6 by @renovate in https://github.com/uutils/coreutils/pull/6319
* chore(deps): update rust crate smallvec to 1.13.2 by @renovate in https://github.com/uutils/coreutils/pull/6320
* chore(deps): update rust crate tempfile to 3.10.1 by @renovate in https://github.com/uutils/coreutils/pull/6321
* chore(deps): update rust crate thiserror to 1.0.59 by @renovate in https://github.com/uutils/coreutils/pull/6322
* chore(deps): update rust crate time to 0.3.36 by @renovate in https://github.com/uutils/coreutils/pull/6323
* chore(deps): update rust crate unindent to 0.2.3 by @renovate in https://github.com/uutils/coreutils/pull/6324
* chore(deps): update rust crate self_cell to 1.0.4 by @renovate in https://github.com/uutils/coreutils/pull/6337
* chore(deps): update rust crate num-traits to 0.2.19 by @renovate in https://github.com/uutils/coreutils/pull/6338
* chore(deps): update rust crate zip to 1.1.4 by @renovate in https://github.com/uutils/coreutils/pull/6347
* chore(deps): update rust crate zip to v1.2.0 by @renovate in https://github.com/uutils/coreutils/pull/6366
* chore(deps): update rust crate num-prime to v0.4.4 by @renovate in https://github.com/uutils/coreutils/pull/6367
* chore(deps): update rust crate num-bigint to v0.4.5 by @renovate in https://github.com/uutils/coreutils/pull/6369
* chore(deps): update rust crate thiserror to v1.0.60 by @renovate in https://github.com/uutils/coreutils/pull/6370
* chore(deps): update rust crate zip to v1.2.1 by @renovate in https://github.com/uutils/coreutils/pull/6371
* chore(deps): update rust crate zip to v1.2.2 by @renovate in https://github.com/uutils/coreutils/pull/6389
* chore(deps): update rust crate zip to v1.2.3 by @renovate in https://github.com/uutils/coreutils/pull/6394
* chore(deps): update rust crate thiserror to v1.0.61 by @renovate in https://github.com/uutils/coreutils/pull/6410
* chore(deps): update rust crate zip to v1.3.0 by @renovate in https://github.com/uutils/coreutils/pull/6409
* chore(deps): update rust crate rstest to 0.21.0 by @renovate in https://github.com/uutils/coreutils/pull/6441
* chore(deps): update dawidd6/action-download-artifact action to v4 by @renovate in https://github.com/uutils/coreutils/pull/6447
* chore(deps): update dawidd6/action-download-artifact action to v5 by @renovate in https://github.com/uutils/coreutils/pull/6449
* chore(deps): update rust crate regex to v1.10.5 by @renovate in https://github.com/uutils/coreutils/pull/6458
* chore(deps): update dawidd6/action-download-artifact action to v6 by @renovate in https://github.com/uutils/coreutils/pull/6462
* chore(deps): update rust crate memchr to v2.7.4 by @renovate in https://github.com/uutils/coreutils/pull/6463
* chore(deps): update rust crate redox_syscall to v0.5.2 by @renovate in https://github.com/uutils/coreutils/pull/6469
* chore(deps): update mozilla-actions/sccache-action action to v0.0.5 by @renovate in https://github.com/uutils/coreutils/pull/6476
* chore(deps): update rust crate bigdecimal to v0.4.5 by @renovate in https://github.com/uutils/coreutils/pull/6473

## New Contributors
* @dcarrier made their first contribution in https://github.com/uutils/coreutils/pull/6269
* @jalil-salame made their first contribution in https://github.com/uutils/coreutils/pull/6340
* @ahmadabd made their first contribution in https://github.com/uutils/coreutils/pull/6359
* @Walid-Kh made their first contribution in https://github.com/uutils/coreutils/pull/6377
* @cvonelm made their first contribution in https://github.com/uutils/coreutils/pull/6424
* @thesayyn made their first contribution in https://github.com/uutils/coreutils/pull/6425
* @Qelxiros made their first contribution in https://github.com/uutils/coreutils/pull/6433
* @phedders made their first contribution in https://github.com/uutils/coreutils/pull/6438
* @TO19 made their first contribution in https://github.com/uutils/coreutils/pull/6454

**Full Changelog**: https://github.com/uutils/coreutils/compare/0.0.26...0.0.27
